import{s as pa,n as ra,o as Ma}from"../chunks/scheduler.eb244325.js";import{S as ca,i as ma,e as o,s as n,c as r,q as ya,h as wa,a as i,d as l,b as a,f as j,g as M,j as p,r as da,k as Ps,l as T,m as s,n as c,t as m,o as y,p as w}from"../chunks/index.3fe63ad3.js";import{C as Ta}from"../chunks/CopyLLMTxtMenu.3c6aa112.js";import{C as u}from"../chunks/CodeBlock.85b10842.js";import{H as d,E as ua}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.bf4dbd10.js";function fa(qs){let J,xt,kt,Wt,U,Yt,I,Nt,C,Ds="This tutorial will explain how to integrate your own robot design into the LeRobot ecosystem and have it access all of our tools (data collection, control pipelines, policy training and inference).",Et,g,Ks='To that end, we provide the <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/robots/robot.py" rel="nofollow"><code>Robot</code></a> base class in the LeRobot which specifies a standard interface for physical robot integration. Let’s see how to implement it.',Xt,v,Rt,$,Os='<li>Your own robot which exposes a communication interface (e.g. serial, CAN, TCP)</li> <li>A way to read sensor data and send motor commands programmatically, e.g. manufacturer’s SDK or API, or your own protocol implementation.</li> <li>LeRobot installed in your environment. Follow our <a href="./installation">Installation Guide</a>.</li>',Vt,_,St,B,en="If you’re using Feetech or Dynamixel motors, LeRobot provides built-in bus interfaces:",Ht,A,tn='<li><a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/motors/feetech/feetech.py" rel="nofollow"><code>FeetechMotorsBus</code></a> – for controlling Feetech servos</li> <li><a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/motors/dynamixel/dynamixel.py" rel="nofollow"><code>DynamixelMotorsBus</code></a> – for controlling Dynamixel servos</li>',Qt,Z,ln=`Please refer to the <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/motors/motors_bus.py" rel="nofollow"><code>MotorsBus</code></a> abstract class to learn about its API.
For a good example of how it can be used, you can have a look at our own <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/robots/so101_follower/so101_follower.py" rel="nofollow">SO101 follower implementation</a>`,Lt,k,sn="Use these if compatible. Otherwise, you’ll need to find or write a Python interface (not covered in this tutorial):",Ft,G,nn="<li>Find an existing SDK in Python (or use bindings to C/C++)</li> <li>Or implement a basic communication wrapper (e.g., via pyserial, socket, or CANopen)</li>",zt,x,an="You’re not alone—many community contributions use custom boards or firmware!",Pt,W,on="For Feetech and Dynamixel, we currently support these servos: - Feetech: - STS &amp; SMS series (protocol 0): <code>sts3215</code>, <code>sts3250</code>, <code>sm8512bl</code> - SCS series (protocol 1): <code>scs0009</code> - Dynamixel (protocol 2.0 only): <code>xl330-m077</code>, <code>xl330-m288</code>, <code>xl430-w250</code>, <code>xm430-w350</code>, <code>xm540-w270</code>, <code>xc430-w150</code>",qt,Y,pn='If you are using Feetech or Dynamixel servos that are not in this list, you can add those in the <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/motors/feetech/tables.py" rel="nofollow">Feetech table</a> or <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/motors/dynamixel/tables.py" rel="nofollow">Dynamixel table</a>. Depending on the model, this will require you to add model-specific information. In most cases though, there shouldn’t be a lot of additions to do.',Dt,N,rn="In the next sections, we’ll use a <code>FeetechMotorsBus</code> as the motors interface for the examples. Replace it and adapt to your motors if necessary.",Kt,E,Ot,X,Mn="You’ll first need to specify the config class and a string identifier (<code>name</code>) for your robot. If your robot has special needs that you’d like to be able to change easily, it should go here (e.g. port/address, baudrate).",el,R,cn="Here, we’ll add the port name and one camera by default for our robot:",tl,V,ll,S,mn='<a href="./cameras">Cameras tutorial</a> to understand how to detect and add your camera.',sl,H,yn="Next, we’ll create our actual robot class which inherits from <code>Robot</code>. This abstract class defines a contract you must follow for your robot to be usable with the rest of the LeRobot tools.",nl,Q,wn="Here we’ll create a simple 5-DoF robot with one camera. It could be a simple arm but notice that the <code>Robot</code> abstract class does not assume anything on your robot’s form factor. You can let you imagination run wild when designing new robots!",al,L,ol,F,il,z,dn="These two properties define the <em>interface contract</em> between your robot and tools that consume it (such as data collection or learning pipelines).",pl,b,Tn="<p>Note that these properties must be callable even if the robot is not yet connected, so avoid relying on runtime hardware state to define them.</p>",rl,P,Ml,q,un="This property should return a dictionary describing the structure of sensor outputs from your robot. The keys match what <code>get_observation()</code> returns, and the values describe either the shape (for arrays/images) or the type (for simple values).",cl,D,fn="Example for our 5-DoF arm with one camera:",ml,K,yl,O,Jn="In this case, observations consist of a simple dict storing each motor’s position and a camera image.",wl,ee,dl,te,jn="This property describes the commands your robot expects via <code>send_action()</code>. Again, keys must match the expected input format, and values define the shape/type of each command.",Tl,le,bn="Here, we simply use the same joints proprioceptive features (<code>self._motors_ft</code>) as with <code>observation_features</code>: the action sent will simply the goal position for each motor.",ul,se,fl,ne,Jl,ae,hn="These methods should handle opening and closing communication with your hardware (e.g. serial ports, CAN interfaces, USB devices, cameras).",jl,oe,bl,ie,Un="This property should simply reflect that communication with the robot’s hardware is established. When this property is <code>True</code>, it should be possible to read and write to the hardware using <code>get_observation()</code> and <code>send_action()</code>.",hl,pe,Ul,re,Il,Me,In="This method should establish communication with the hardware. Moreover, if your robot needs calibration and is not calibrated, it should start a calibration procedure by default. If your robot needs some specific configuration, this should also be called here.",Cl,ce,gl,me,vl,ye,Cn="This method should gracefully terminate communication with the hardware: free any related resources (threads or processes), close ports, etc.",$l,we,gn="Here, we already handle this in our <code>MotorsBus</code> and <code>Camera</code> classes so we just need to call their own <code>disconnect()</code> methods:",_l,de,Bl,Te,Al,ue,vn="LeRobot supports saving and loading calibration data automatically. This is useful for joint offsets, zero positions, or sensor alignment.",Zl,fe,$n="<p>Note that depending on your hardware, this may not apply. If that’s the case, you can simply leave these methods as no-ops:</p>",kl,Je,Gl,je,_n=`@property
def is_calibrated(self) -> bool:
return self.bus.is_calibrated`,xl,be,Wl,he,Yl,Ue,Bn="Use this to set up any configuration for your hardware (servos control modes, controller gains, etc.). This should usually be run at connection time and be idempotent.",Nl,Ie,El,Ce,Xl,ge,An="These are the most important runtime functions: the core I/O loop.",Rl,ve,Vl,$e,Zn="Returns a dictionary of sensor values from the robot. These typically include motor states, camera frames, various sensors, etc. In the LeRobot framework, these observations are what will be fed to a policy in order to predict the actions to take. The dictionary keys and structure must match <code>observation_features</code>.",Sl,_e,Hl,Be,Ql,Ae,kn="Takes a dictionary that matches <code>action_features</code>, and sends it to your hardware. You can add safety limits (clipping, smoothing) and return what was actually sent.",Ll,Ze,Gn="For simplicity, we won’t be adding any modification of the actions in our example here.",Fl,ke,zl,Ge,Pl,xe,xn='For implementing teleoperation devices, we also provide a <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/teleoperators/teleoperator.py" rel="nofollow"><code>Teleoperator</code></a> base class. This class is very similar to the <code>Robot</code> base class and also doesn’t assume anything on form factor.',ql,We,Wn="The main differences are in the I/O functions: a teleoperator allows you to produce action via <code>get_action</code> and can receive feedback actions via <code>send_feedback</code>. Feedback could be anything controllable on the teleoperation device that could help the person controlling it understand the consequences of the actions sent. Think motion/force feedback on a leader arm, vibrations on a gamepad controller for example. To implement a teleoperator, you can follow this same tutorial and adapt it for these two methods.",Dl,Ye,Kl,Ne,Yn="You can easily extend <code>lerobot</code> with your own custom hardware—be it a camera, robot, or teleoperation device—by creating a separate, installable Python package. If you follow a few simple conventions, the <code>lerobot</code> command-line tools (like <code>lerobot-teleop</code> and <code>lerobot-record</code>) will <strong>automatically discover and integrate your creations</strong> without requiring any changes to the <code>lerobot</code> source code.",Ol,Ee,Nn="This guide outlines the conventions your plugin must follow.",es,Xe,ts,Re,En="To ensure your custom device is discoverable, you must adhere to the following four rules.",ls,Ve,ss,Se,Xn="Your project must be a standard, installable Python package. Crucially, the name of your package (as defined in <code>pyproject.toml</code> or <code>setup.py</code>) must begin with one of these prefixes:",ns,He,Rn="<li><code>lerobot_robot_</code> for a robot.</li> <li><code>lerobot_camera_</code> for a camera.</li> <li><code>lerobot_teleoperator_</code> for a teleoperation device.</li>",as,Qe,Vn="This prefix system is how <code>lerobot</code> automatically finds your plugin in the Python environment.",os,Le,is,Fe,Sn="Your device’s implementation class must be named after its configuration class, simply by removing the <code>Config</code> suffix.",ps,ze,Hn="<li><strong>Config Class:</strong> <code>MyAwesomeTeleopConfig</code></li> <li><strong>Device Class:</strong> <code>MyAwesomeTeleop</code></li>",rs,Pe,Ms,qe,Qn="The device class (<code>MyAwesomeTeleop</code>) must be located in a predictable module relative to its configuration class (<code>MyAwesomeTeleopConfig</code>). <code>lerobot</code> will automatically search in these locations:",cs,De,Ln="<li>In the <strong>same module</strong> as the config class.</li> <li>In a <strong>submodule named after the device</strong> (e.g., <code>my_awesome_teleop.py</code>).</li>",ms,Ke,Fn="The recommended and simplest structure is to place them in separate, clearly named files within the same directory.",ys,Oe,ws,et,zn="Your package’s <code>__init__.py</code> file should import and expose both the configuration and the device classes, making them easily accessible.",ds,tt,Ts,lt,Pn="Let’s create a new teleoperator called <code>my_awesome_teleop</code>.",us,st,fs,nt,qn="Here is what the project folder should look like. The package name, <code>lerobot_teleoperator_my_awesome_teleop</code>, follows <strong>Convention #1</strong>.",Js,at,js,ot,bs,f,it,vt,Dn="<strong><code>config_my_awesome_teleop.py</code></strong>: Defines the configuration class. Note the <code>Config</code> suffix (<strong>Convention #2</strong>).",Rs,pt,Vs,rt,$t,Kn="<strong><code>my_awesome_teleop.py</code></strong>: Implements the device. The class name <code>MyAwesomeTeleop</code> matches its config class name (<strong>Convention #2</strong>). This file structure adheres to <strong>Convention #3</strong>.",Ss,Mt,Hs,ct,_t,On="<strong><code>__init__.py</code></strong>: Exposes the key classes (<strong>Convention #4</strong>).",Qs,mt,hs,yt,Us,h,wt,Bt,ea="<strong>Install your new plugin in your Python environment.</strong> You can install your local plugin package using <code>pip</code>’s editable mode or from PyPi.",Ls,dt,Fs,Tt,At,ta="<strong>Use it directly from the command line.</strong> Now, you can use your custom device by referencing its type.",zs,ut,Is,ft,la="And that’s it! Your custom device is now fully integrated.",Cs,Jt,gs,jt,sa="Check out these two packages from the community:",vs,bt,na='<li><a href="https://github.com/SpesRobotics/lerobot-robot-xarm" rel="nofollow">https://github.com/SpesRobotics/lerobot-robot-xarm</a></li> <li><a href="https://github.com/SpesRobotics/lerobot-teleoperator-teleop" rel="nofollow">https://github.com/SpesRobotics/lerobot-teleoperator-teleop</a></li>',$s,ht,_s,Ut,aa="Once your robot class is complete, you can leverage the LeRobot ecosystem:",Bs,It,oa="<li>Control your robot with available teleoperators or integrate directly your teleoperating device</li> <li>Record training data and visualize it</li> <li>Integrate it into RL or imitation learning pipelines</li>",As,Ct,ia='Don’t hesitate to reach out to the community for help on our <a href="https://discord.gg/s3KuuzsPFb" rel="nofollow">Discord</a> 🤗',Zs,gt,ks,Gt,Gs;return U=new Ta({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),I=new d({props:{title:"Bring Your Own Hardware",local:"bring-your-own-hardware",headingTag:"h1"}}),v=new d({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),_=new d({props:{title:"Choose your motors",local:"choose-your-motors",headingTag:"h2"}}),E=new d({props:{title:"Step 1: Subclass the Robot Interface",local:"step-1-subclass-the-robot-interface",headingTag:"h2"}}),V=new u({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTJDJTIwZmllbGQlMEElMEFmcm9tJTIwbGVyb2JvdC5jYW1lcmFzJTIwaW1wb3J0JTIwQ2FtZXJhQ29uZmlnJTBBZnJvbSUyMGxlcm9ib3QuY2FtZXJhcy5vcGVuY3YlMjBpbXBvcnQlMjBPcGVuQ1ZDYW1lcmFDb25maWclMEFmcm9tJTIwbGVyb2JvdC5yb2JvdHMlMjBpbXBvcnQlMjBSb2JvdENvbmZpZyUwQSUwQSUwQSU0MFJvYm90Q29uZmlnLnJlZ2lzdGVyX3N1YmNsYXNzKCUyMm15X2Nvb2xfcm9ib3QlMjIpJTBBJTQwZGF0YWNsYXNzJTBBY2xhc3MlMjBNeUNvb2xSb2JvdENvbmZpZyhSb2JvdENvbmZpZyklM0ElMEElMjAlMjAlMjAlMjBwb3J0JTNBJTIwc3RyJTBBJTIwJTIwJTIwJTIwY2FtZXJhcyUzQSUyMGRpY3QlNUJzdHIlMkMlMjBDYW1lcmFDb25maWclNUQlMjAlM0QlMjBmaWVsZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWZhdWx0X2ZhY3RvcnklM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjYW1fMSUyMiUzQSUyME9wZW5DVkNhbWVyYUNvbmZpZyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbmRleF9vcl9wYXRoJTNEMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZwcyUzRDMwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2lkdGglM0Q0ODAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBoZWlnaHQlM0Q2NDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass, field

<span class="hljs-keyword">from</span> lerobot.cameras <span class="hljs-keyword">import</span> CameraConfig
<span class="hljs-keyword">from</span> lerobot.cameras.opencv <span class="hljs-keyword">import</span> OpenCVCameraConfig
<span class="hljs-keyword">from</span> lerobot.robots <span class="hljs-keyword">import</span> RobotConfig


<span class="hljs-meta">@RobotConfig.register_subclass(<span class="hljs-params"><span class="hljs-string">&quot;my_cool_robot&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCoolRobotConfig</span>(<span class="hljs-title class_ inherited__">RobotConfig</span>):
    port: <span class="hljs-built_in">str</span>
    cameras: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, CameraConfig] = field(
        default_factory={
            <span class="hljs-string">&quot;cam_1&quot;</span>: OpenCVCameraConfig(
                index_or_path=<span class="hljs-number">2</span>,
                fps=<span class="hljs-number">30</span>,
                width=<span class="hljs-number">480</span>,
                height=<span class="hljs-number">640</span>,
            ),
        }
    )`,wrap:!1}}),L=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> lerobot.cameras <span class="hljs-keyword">import</span> make_cameras_from_configs
<span class="hljs-keyword">from</span> lerobot.motors <span class="hljs-keyword">import</span> Motor, MotorNormMode
<span class="hljs-keyword">from</span> lerobot.motors.feetech <span class="hljs-keyword">import</span> FeetechMotorsBus
<span class="hljs-keyword">from</span> lerobot.robots <span class="hljs-keyword">import</span> Robot

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCoolRobot</span>(<span class="hljs-title class_ inherited__">Robot</span>):
    config_class = MyCoolRobotConfig
    name = <span class="hljs-string">&quot;my_cool_robot&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: MyCoolRobotConfig</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        self.bus = FeetechMotorsBus(
            port=self.config.port,
            motors={
                <span class="hljs-string">&quot;joint_1&quot;</span>: Motor(<span class="hljs-number">1</span>, <span class="hljs-string">&quot;sts3250&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_2&quot;</span>: Motor(<span class="hljs-number">2</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_3&quot;</span>: Motor(<span class="hljs-number">3</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_4&quot;</span>: Motor(<span class="hljs-number">4</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_5&quot;</span>: Motor(<span class="hljs-number">5</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
            },
            calibration=self.calibration,
        )
        self.cameras = make_cameras_from_configs(config.cameras)`,wrap:!1}}),F=new d({props:{title:"Step 2: Define Observation and Action Features",local:"step-2-define-observation-and-action-features",headingTag:"h2"}}),P=new d({props:{title:"observation_features",local:"observationfeatures",headingTag:"h3"}}),K=new u({props:{code:"JTQwcHJvcGVydHklMEFkZWYlMjBfbW90b3JzX2Z0KHNlbGYpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjB0eXBlJTVEJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyam9pbnRfMS5wb3MlMjIlM0ElMjBmbG9hdCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmpvaW50XzIucG9zJTIyJTNBJTIwZmxvYXQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJqb2ludF8zLnBvcyUyMiUzQSUyMGZsb2F0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyam9pbnRfNC5wb3MlMjIlM0ElMjBmbG9hdCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmpvaW50XzUucG9zJTIyJTNBJTIwZmxvYXQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEElMEElNDBwcm9wZXJ0eSUwQWRlZiUyMF9jYW1lcmFzX2Z0KHNlbGYpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjB0dXBsZSU1RCUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhbSUzQSUyMChzZWxmLmNhbWVyYXMlNUJjYW0lNUQuaGVpZ2h0JTJDJTIwc2VsZi5jYW1lcmFzJTVCY2FtJTVELndpZHRoJTJDJTIwMyklMjBmb3IlMjBjYW0lMjBpbiUyMHNlbGYuY2FtZXJhcyUwQSUyMCUyMCUyMCUyMCU3RCUwQSUwQSU0MHByb3BlcnR5JTBBZGVmJTIwb2JzZXJ2YXRpb25fZmVhdHVyZXMoc2VsZiklMjAtJTNFJTIwZGljdCUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3Qioqc2VsZi5fbW90b3JzX2Z0JTJDJTIwKipzZWxmLl9jYW1lcmFzX2Z0JTdE",highlighted:`<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">_motors_ft</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">type</span>]:
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;joint_1.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_2.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_3.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_4.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_5.pos&quot;</span>: <span class="hljs-built_in">float</span>,
    }

<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">_cameras_ft</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">tuple</span>]:
    <span class="hljs-keyword">return</span> {
        cam: (self.cameras[cam].height, self.cameras[cam].width, <span class="hljs-number">3</span>) <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras
    }

<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">observation_features</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>:
    <span class="hljs-keyword">return</span> {**self._motors_ft, **self._cameras_ft}`,wrap:!1}}),ee=new d({props:{title:"action_features",local:"actionfeatures",headingTag:"h3"}}),se=new u({props:{code:"ZGVmJTIwYWN0aW9uX2ZlYXR1cmVzKHNlbGYpJTIwLSUzRSUyMGRpY3QlM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLl9tb3RvcnNfZnQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">action_features</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>:
    <span class="hljs-keyword">return</span> self._motors_ft`,wrap:!1}}),ne=new d({props:{title:"Step 3: Handle Connection and Disconnection",local:"step-3-handle-connection-and-disconnection",headingTag:"h2"}}),oe=new d({props:{title:"is_connected",local:"isconnected",headingTag:"h3"}}),pe=new u({props:{code:"JTQwcHJvcGVydHklMEFkZWYlMjBpc19jb25uZWN0ZWQoc2VsZiklMjAtJTNFJTIwYm9vbCUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYuYnVzLmlzX2Nvbm5lY3RlZCUyMGFuZCUyMGFsbChjYW0uaXNfY29ubmVjdGVkJTIwZm9yJTIwY2FtJTIwaW4lMjBzZWxmLmNhbWVyYXMudmFsdWVzKCkp",highlighted:`<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_connected</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">bool</span>:
    <span class="hljs-keyword">return</span> self.bus.is_connected <span class="hljs-keyword">and</span> <span class="hljs-built_in">all</span>(cam.is_connected <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras.values())`,wrap:!1}}),re=new d({props:{title:"connect()",local:"connect",headingTag:"h3"}}),ce=new u({props:{code:"ZGVmJTIwY29ubmVjdChzZWxmJTJDJTIwY2FsaWJyYXRlJTNBJTIwYm9vbCUyMCUzRCUyMFRydWUpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjBzZWxmLmJ1cy5jb25uZWN0KCklMEElMjAlMjAlMjAlMjBpZiUyMG5vdCUyMHNlbGYuaXNfY2FsaWJyYXRlZCUyMGFuZCUyMGNhbGlicmF0ZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY2FsaWJyYXRlKCklMEElMEElMjAlMjAlMjAlMjBmb3IlMjBjYW0lMjBpbiUyMHNlbGYuY2FtZXJhcy52YWx1ZXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhbS5jb25uZWN0KCklMEElMEElMjAlMjAlMjAlMjBzZWxmLmNvbmZpZ3VyZSgp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">connect</span>(<span class="hljs-params">self, calibrate: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">True</span></span>) -&gt; <span class="hljs-literal">None</span>:
    self.bus.connect()
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.is_calibrated <span class="hljs-keyword">and</span> calibrate:
        self.calibrate()

    <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras.values():
        cam.connect()

    self.configure()`,wrap:!1}}),me=new d({props:{title:"disconnect()",local:"disconnect",headingTag:"h3"}}),de=new u({props:{code:"ZGVmJTIwZGlzY29ubmVjdChzZWxmKSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwc2VsZi5idXMuZGlzY29ubmVjdCgpJTBBJTIwJTIwJTIwJTIwZm9yJTIwY2FtJTIwaW4lMjBzZWxmLmNhbWVyYXMudmFsdWVzKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYW0uZGlzY29ubmVjdCgp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">disconnect</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
    self.bus.disconnect()
    <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras.values():
        cam.disconnect()`,wrap:!1}}),Te=new d({props:{title:"Step 4: Support Calibration and Configuration",local:"step-4-support-calibration-and-configuration",headingTag:"h2"}}),Je=new u({props:{code:"JTNFJTIwJTQwcHJvcGVydHklMEElM0UlMjBkZWYlMjBpc19jYWxpYnJhdGVkKHNlbGYpJTIwLSUzRSUyMGJvb2wlM0ElMEElM0UlMjAlMjAlMjAlMjByZXR1cm4lMjBUcnVlJTBBJTNFJTBBJTNFJTIwZGVmJTIwY2FsaWJyYXRlKHNlbGYpJTIwLSUzRSUyME5vbmUlM0ElMEElM0UlMjAlMjAlMjAlMjBwYXNzJTBBJTNFJTIwJTYwJTYwJTYwJTBBJTBBJTIzJTIzJTIzJTIwJTYwaXNfY2FsaWJyYXRlZCU2MCUwQSUwQVRoaXMlMjBzaG91bGQlMjByZWZsZWN0JTIwd2hldGhlciUyMHlvdXIlMjByb2JvdCUyMGhhcyUyMHRoZSUyMHJlcXVpcmVkJTIwY2FsaWJyYXRpb24lMjBsb2FkZWQuJTBB",highlighted:`&gt; @<span class="hljs-built_in">property</span>
&gt; <span class="hljs-keyword">def</span> <span class="hljs-title function_">is_calibrated</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">bool</span>:
&gt;    <span class="hljs-keyword">return</span> <span class="hljs-literal">True</span>
&gt;
&gt; <span class="hljs-keyword">def</span> <span class="hljs-title function_">calibrate</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
&gt;    <span class="hljs-keyword">pass</span>
&gt; \`\`\`

<span class="hljs-comment">### \`is_calibrated\`</span>

This should reflect whether your robot has the required calibration loaded.
`,wrap:!1}}),be=new u({props:{code:"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",highlighted:`
<span class="hljs-comment">### \`calibrate()\`</span>

The goal of the calibration <span class="hljs-keyword">is</span> twofold:
    - Know the physical <span class="hljs-built_in">range</span> of motion of each motors <span class="hljs-keyword">in</span> order to only send commands within this <span class="hljs-built_in">range</span>.
    - Normalize raw motors positions to sensible continuous values (e.g. percentages, degrees) instead of arbitrary discrete value dependant on the specific motor used that will <span class="hljs-keyword">not</span> replicate elsewhere.

It should implement the logic <span class="hljs-keyword">for</span> calibration (<span class="hljs-keyword">if</span> relevant) <span class="hljs-keyword">and</span> update the \`self.calibration\` dictionary. If you are using Feetech <span class="hljs-keyword">or</span> Dynamixel motors, our bus interfaces already include methods to <span class="hljs-built_in">help</span> <span class="hljs-keyword">with</span> this.


&lt;!-- prettier-ignore-start --&gt;
\`\`\`python
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calibrate</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
    self.bus.disable_torque()
    <span class="hljs-keyword">for</span> motor <span class="hljs-keyword">in</span> self.bus.motors:
        self.bus.write(<span class="hljs-string">&quot;Operating_Mode&quot;</span>, motor, OperatingMode.POSITION.value)

    <span class="hljs-built_in">input</span>(<span class="hljs-string">f&quot;Move <span class="hljs-subst">{self}</span> to the middle of its range of motion and press ENTER....&quot;</span>)
    homing_offsets = self.bus.set_half_turn_homings()

    <span class="hljs-built_in">print</span>(
        <span class="hljs-string">&quot;Move all joints sequentially through their entire ranges &quot;</span>
        <span class="hljs-string">&quot;of motion.\\nRecording positions. Press ENTER to stop...&quot;</span>
    )
    range_mins, range_maxes = self.bus.record_ranges_of_motion()

    self.calibration = {}
    <span class="hljs-keyword">for</span> motor, m <span class="hljs-keyword">in</span> self.bus.motors.items():
        self.calibration[motor] = MotorCalibration(
            <span class="hljs-built_in">id</span>=m.<span class="hljs-built_in">id</span>,
            drive_mode=<span class="hljs-number">0</span>,
            homing_offset=homing_offsets[motor],
            range_min=range_mins[motor],
            range_max=range_maxes[motor],
        )

    self.bus.write_calibration(self.calibration)
    self._save_calibration()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Calibration saved to&quot;</span>, self.calibration_fpath)`,wrap:!1}}),he=new d({props:{title:"configure()",local:"configure",headingTag:"h3"}}),Ie=new u({props:{code:"ZGVmJTIwY29uZmlndXJlKHNlbGYpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwc2VsZi5idXMudG9ycXVlX2Rpc2FibGVkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmJ1cy5jb25maWd1cmVfbW90b3JzKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBtb3RvciUyMGluJTIwc2VsZi5idXMubW90b3JzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5idXMud3JpdGUoJTIyT3BlcmF0aW5nX01vZGUlMjIlMkMlMjBtb3RvciUyQyUyME9wZXJhdGluZ01vZGUuUE9TSVRJT04udmFsdWUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5idXMud3JpdGUoJTIyUF9Db2VmZmljaWVudCUyMiUyQyUyMG1vdG9yJTJDJTIwMTYpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5idXMud3JpdGUoJTIySV9Db2VmZmljaWVudCUyMiUyQyUyMG1vdG9yJTJDJTIwMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmJ1cy53cml0ZSglMjJEX0NvZWZmaWNpZW50JTIyJTJDJTIwbW90b3IlMkMlMjAzMik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">configure</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">with</span> self.bus.torque_disabled():
        self.bus.configure_motors()
        <span class="hljs-keyword">for</span> motor <span class="hljs-keyword">in</span> self.bus.motors:
            self.bus.write(<span class="hljs-string">&quot;Operating_Mode&quot;</span>, motor, OperatingMode.POSITION.value)
            self.bus.write(<span class="hljs-string">&quot;P_Coefficient&quot;</span>, motor, <span class="hljs-number">16</span>)
            self.bus.write(<span class="hljs-string">&quot;I_Coefficient&quot;</span>, motor, <span class="hljs-number">0</span>)
            self.bus.write(<span class="hljs-string">&quot;D_Coefficient&quot;</span>, motor, <span class="hljs-number">32</span>)`,wrap:!1}}),Ce=new d({props:{title:"Step 5: Implement Sensors Reading and Action Sending",local:"step-5-implement-sensors-reading-and-action-sending",headingTag:"h2"}}),ve=new d({props:{title:"get_observation()",local:"getobservation",headingTag:"h3"}}),_e=new u({props:{code:"ZGVmJTIwZ2V0X29ic2VydmF0aW9uKHNlbGYpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlM0ElMEElMjAlMjAlMjAlMjBpZiUyMG5vdCUyMHNlbGYuaXNfY29ubmVjdGVkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFpc2UlMjBDb25uZWN0aW9uRXJyb3IoZiUyMiU3QnNlbGYlN0QlMjBpcyUyMG5vdCUyMGNvbm5lY3RlZC4lMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwUmVhZCUyMGFybSUyMHBvc2l0aW9uJTBBJTIwJTIwJTIwJTIwb2JzX2RpY3QlMjAlM0QlMjBzZWxmLmJ1cy5zeW5jX3JlYWQoJTIyUHJlc2VudF9Qb3NpdGlvbiUyMiklMEElMjAlMjAlMjAlMjBvYnNfZGljdCUyMCUzRCUyMCU3QmYlMjIlN0Jtb3RvciU3RC5wb3MlMjIlM0ElMjB2YWwlMjBmb3IlMjBtb3RvciUyQyUyMHZhbCUyMGluJTIwb2JzX2RpY3QuaXRlbXMoKSU3RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMENhcHR1cmUlMjBpbWFnZXMlMjBmcm9tJTIwY2FtZXJhcyUwQSUyMCUyMCUyMCUyMGZvciUyMGNhbV9rZXklMkMlMjBjYW0lMjBpbiUyMHNlbGYuY2FtZXJhcy5pdGVtcygpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb2JzX2RpY3QlNUJjYW1fa2V5JTVEJTIwJTNEJTIwY2FtLmFzeW5jX3JlYWQoKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG9ic19kaWN0",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_observation</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.is_connected:
        <span class="hljs-keyword">raise</span> ConnectionError(<span class="hljs-string">f&quot;<span class="hljs-subst">{self}</span> is not connected.&quot;</span>)

    <span class="hljs-comment"># Read arm position</span>
    obs_dict = self.bus.sync_read(<span class="hljs-string">&quot;Present_Position&quot;</span>)
    obs_dict = {<span class="hljs-string">f&quot;<span class="hljs-subst">{motor}</span>.pos&quot;</span>: val <span class="hljs-keyword">for</span> motor, val <span class="hljs-keyword">in</span> obs_dict.items()}

    <span class="hljs-comment"># Capture images from cameras</span>
    <span class="hljs-keyword">for</span> cam_key, cam <span class="hljs-keyword">in</span> self.cameras.items():
        obs_dict[cam_key] = cam.async_read()

    <span class="hljs-keyword">return</span> obs_dict`,wrap:!1}}),Be=new d({props:{title:"send_action()",local:"sendaction",headingTag:"h3"}}),ke=new u({props:{code:"ZGVmJTIwc2VuZF9hY3Rpb24oc2VsZiUyQyUyMGFjdGlvbiUzQSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlM0ElMEElMjAlMjAlMjAlMjBnb2FsX3BvcyUyMCUzRCUyMCU3QmtleS5yZW1vdmVzdWZmaXgoJTIyLnBvcyUyMiklM0ElMjB2YWwlMjBmb3IlMjBrZXklMkMlMjB2YWwlMjBpbiUyMGFjdGlvbi5pdGVtcygpJTdEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwU2VuZCUyMGdvYWwlMjBwb3NpdGlvbiUyMHRvJTIwdGhlJTIwYXJtJTBBJTIwJTIwJTIwJTIwc2VsZi5idXMuc3luY193cml0ZSglMjJHb2FsX1Bvc2l0aW9uJTIyJTJDJTIwZ29hbF9wb3MpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYWN0aW9u",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">send_action</span>(<span class="hljs-params">self, action: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
    goal_pos = {key.removesuffix(<span class="hljs-string">&quot;.pos&quot;</span>): val <span class="hljs-keyword">for</span> key, val <span class="hljs-keyword">in</span> action.items()}

    <span class="hljs-comment"># Send goal position to the arm</span>
    self.bus.sync_write(<span class="hljs-string">&quot;Goal_Position&quot;</span>, goal_pos)

    <span class="hljs-keyword">return</span> action`,wrap:!1}}),Ge=new d({props:{title:"Adding a Teleoperator",local:"adding-a-teleoperator",headingTag:"h2"}}),Ye=new d({props:{title:"Using Your Own LeRobot Devices 🔌",local:"using-your-own-lerobot-devices-",headingTag:"h2"}}),Xe=new d({props:{title:"The 4 Core Conventions",local:"the-4-core-conventions",headingTag:"h3"}}),Ve=new d({props:{title:"1 . Create an Installable Package with a Specific Prefix",local:"1--create-an-installable-package-with-a-specific-prefix",headingTag:"h4"}}),Le=new d({props:{title:"2 . Follow the SomethingConfig / Something Naming Pattern",local:"2--follow-the-somethingconfig--something-naming-pattern",headingTag:"h4"}}),Pe=new d({props:{title:"3 . Place Your Files in a Predictable Structure",local:"3--place-your-files-in-a-predictable-structure",headingTag:"h4"}}),Oe=new d({props:{title:"4 . Expose Classes in __init__.py",local:"4--expose-classes-in-initpy",headingTag:"h4"}}),tt=new d({props:{title:"Putting It All Together: A Complete Example",local:"putting-it-all-together-a-complete-example",headingTag:"h3"}}),st=new d({props:{title:"Directory Structure",local:"directory-structure",headingTag:"h4"}}),at=new u({props:{code:"bGVyb2JvdF90ZWxlb3BlcmF0b3JfbXlfYXdlc29tZV90ZWxlb3AlMkYlMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBweXByb2plY3QudG9tbCUyMCUyMyUyMChvciUyMHNldHVwLnB5KSUyMGxpc3RzJTIwbGVyb2JvdCUyMGFzJTIwYSUyMGRlcGVuZGVuY3klMEElRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBsZXJvYm90X3RlbGVvcGVyYXRvcl9teV9hd2Vzb21lX3RlbGVvcCUyRiUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlnX215X2F3ZXNvbWVfdGVsZW9wLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwbXlfYXdlc29tZV90ZWxlb3AucHk=",highlighted:`lerobot_teleoperator_my_awesome_teleop/
├── pyproject.toml # (<span class="hljs-built_in">or</span> setup.<span class="hljs-keyword">py</span>) lists lerobot <span class="hljs-keyword">as</span> <span class="hljs-keyword">a</span> dependency
└── lerobot_teleoperator_my_awesome_teleop/
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── config_my_awesome_teleop.<span class="hljs-keyword">py</span>
    └── my_awesome_teleop.<span class="hljs-keyword">py</span>`,wrap:!1}}),ot=new d({props:{title:"File Contents",local:"file-contents",headingTag:"h4"}}),pt=new u({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTBBJTBBZnJvbSUyMGxlcm9ib3QudGVsZW9wZXJhdG9ycy5jb25maWclMjBpbXBvcnQlMjBUZWxlb3BlcmF0b3JDb25maWclMEElMEElNDBUZWxlb3BlcmF0b3JDb25maWcucmVnaXN0ZXJfc3ViY2xhc3MoJTIybXlfYXdlc29tZV90ZWxlb3AlMjIpJTBBJTQwZGF0YWNsYXNzJTBBY2xhc3MlMjBNeUF3ZXNvbWVUZWxlb3BDb25maWcoVGVsZW9wZXJhdG9yQ29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFlvdXIlMjBjb25maWd1cmF0aW9uJTIwZmllbGRzJTIwZ28lMjBoZXJlJTBBJTIwJTIwJTIwJTIwcG9ydCUzQSUyMHN0ciUyMCUzRCUyMCUyMjE5Mi4xNjguMS4xJTIy",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass

<span class="hljs-keyword">from</span> lerobot.teleoperators.config <span class="hljs-keyword">import</span> TeleoperatorConfig

<span class="hljs-meta">@TeleoperatorConfig.register_subclass(<span class="hljs-params"><span class="hljs-string">&quot;my_awesome_teleop&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyAwesomeTeleopConfig</span>(<span class="hljs-title class_ inherited__">TeleoperatorConfig</span>):
    <span class="hljs-comment"># Your configuration fields go here</span>
    port: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;192.168.1.1&quot;</span>`,wrap:!1}}),Mt=new u({props:{code:"ZnJvbSUyMGxlcm9ib3QudGVsZW9wZXJhdG9ycy50ZWxlb3BlcmF0b3IlMjBpbXBvcnQlMjBUZWxlb3BlcmF0b3IlMEElMEFmcm9tJTIwLmNvbmZpZ19teV9hd2Vzb21lX3RlbGVvcCUyMGltcG9ydCUyME15QXdlc29tZVRlbGVvcENvbmZpZyUwQSUwQWNsYXNzJTIwTXlBd2Vzb21lVGVsZW9wKFRlbGVvcGVyYXRvciklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBNeUF3ZXNvbWVUZWxlb3BDb25maWclMEElMjAlMjAlMjAlMjBuYW1lJTIwJTNEJTIwJTIybXlfYXdlc29tZV90ZWxlb3AlMjIlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnJTNBJTIwTXlBd2Vzb21lVGVsZW9wQ29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY29uZmlnJTIwJTNEJTIwY29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwWW91ciUyMGRldmljZSUyMGxvZ2ljJTIwKGUuZy4lMkMlMjBjb25uZWN0KSUyMGdvZXMlMjBoZXJl",highlighted:`<span class="hljs-keyword">from</span> lerobot.teleoperators.teleoperator <span class="hljs-keyword">import</span> Teleoperator

<span class="hljs-keyword">from</span> .config_my_awesome_teleop <span class="hljs-keyword">import</span> MyAwesomeTeleopConfig

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyAwesomeTeleop</span>(<span class="hljs-title class_ inherited__">Teleoperator</span>):
    config_class = MyAwesomeTeleopConfig
    name = <span class="hljs-string">&quot;my_awesome_teleop&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: MyAwesomeTeleopConfig</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        self.config = config

    <span class="hljs-comment"># Your device logic (e.g., connect) goes here</span>`,wrap:!1}}),mt=new u({props:{code:"ZnJvbSUyMC5jb25maWdfbXlfYXdlc29tZV90ZWxlb3AlMjBpbXBvcnQlMjBNeUF3ZXNvbWVUZWxlb3BDb25maWclMEFmcm9tJTIwLm15X2F3ZXNvbWVfdGVsZW9wJTIwaW1wb3J0JTIwTXlBd2Vzb21lVGVsZW9w",highlighted:`<span class="hljs-keyword">from</span> .config_my_awesome_teleop <span class="hljs-keyword">import</span> MyAwesomeTeleopConfig
<span class="hljs-keyword">from</span> .my_awesome_teleop <span class="hljs-keyword">import</span> MyAwesomeTeleop`,wrap:!1}}),yt=new d({props:{title:"Installation and Usage",local:"installation-and-usage",headingTag:"h3"}}),dt=new u({props:{code:"JTIzJTIwTG9jYWxseSUwQSUyMyUyME5hdmlnYXRlJTIwdG8lMjB5b3VyJTIwcGx1Z2luJ3MlMjByb290JTIwZGlyZWN0b3J5JTIwYW5kJTIwaW5zdGFsbCUyMGl0JTBBY2QlMjBsZXJvYm90X3RlbGVvcGVyYXRvcl9teV9hd2Vzb21lX3RlbGVvcCUwQXBpcCUyMGluc3RhbGwlMjAtZSUyMC4lMEElMEElMjMlMjBGcm9tJTIwUHlQaSUwQXBpcCUyMGluc3RhbGwlMjBsZXJvYm90X3RlbGVvcGVyYXRvcl9teV9hd2Vzb21lX3RlbGVvcA==",highlighted:`<span class="hljs-comment"># Locally</span>
<span class="hljs-comment"># Navigate to your plugin&#x27;s root directory and install it</span>
<span class="hljs-built_in">cd</span> lerobot_teleoperator_my_awesome_teleop
pip install -e .

<span class="hljs-comment"># From PyPi</span>
pip install lerobot_teleoperator_my_awesome_teleop`,wrap:!1}}),ut=new u({props:{code:"bGVyb2JvdC10ZWxlb3BlcmF0ZSUyMC0tdGVsZW9wLnR5cGUlM0RteV9hd2Vzb21lX3RlbGVvcCUyMCU1QyUwQSUyMyUyMG90aGVyJTIwYXJndW1lbnRz",highlighted:`lerobot-teleoperate --teleop.type=my_awesome_teleop \\
<span class="hljs-comment"># other arguments</span>`,wrap:!1}}),Jt=new d({props:{title:"Looking for an example ?",local:"looking-for-an-example-",headingTag:"h3"}}),ht=new d({props:{title:"Wrapping Up",local:"wrapping-up",headingTag:"h2"}}),gt=new ua({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/integrate_hardware.mdx"}}),{c(){J=o("meta"),xt=n(),kt=o("p"),Wt=n(),r(U.$$.fragment),Yt=n(),r(I.$$.fragment),Nt=n(),C=o("p"),C.textContent=Ds,Et=n(),g=o("p"),g.innerHTML=Ks,Xt=n(),r(v.$$.fragment),Rt=n(),$=o("ul"),$.innerHTML=Os,Vt=n(),r(_.$$.fragment),St=n(),B=o("p"),B.textContent=en,Ht=n(),A=o("ul"),A.innerHTML=tn,Qt=n(),Z=o("p"),Z.innerHTML=ln,Lt=n(),k=o("p"),k.textContent=sn,Ft=n(),G=o("ul"),G.innerHTML=nn,zt=n(),x=o("p"),x.textContent=an,Pt=n(),W=o("p"),W.innerHTML=on,qt=n(),Y=o("p"),Y.innerHTML=pn,Dt=n(),N=o("p"),N.innerHTML=rn,Kt=n(),r(E.$$.fragment),Ot=n(),X=o("p"),X.innerHTML=Mn,el=n(),R=o("p"),R.textContent=cn,tl=n(),r(V.$$.fragment),ll=n(),S=o("p"),S.innerHTML=mn,sl=n(),H=o("p"),H.innerHTML=yn,nl=n(),Q=o("p"),Q.innerHTML=wn,al=n(),r(L.$$.fragment),ol=n(),r(F.$$.fragment),il=n(),z=o("p"),z.innerHTML=dn,pl=n(),b=o("blockquote"),b.innerHTML=Tn,rl=n(),r(P.$$.fragment),Ml=n(),q=o("p"),q.innerHTML=un,cl=n(),D=o("p"),D.textContent=fn,ml=n(),r(K.$$.fragment),yl=n(),O=o("p"),O.textContent=Jn,wl=n(),r(ee.$$.fragment),dl=n(),te=o("p"),te.innerHTML=jn,Tl=n(),le=o("p"),le.innerHTML=bn,ul=n(),r(se.$$.fragment),fl=n(),r(ne.$$.fragment),Jl=n(),ae=o("p"),ae.textContent=hn,jl=n(),r(oe.$$.fragment),bl=n(),ie=o("p"),ie.innerHTML=Un,hl=n(),r(pe.$$.fragment),Ul=n(),r(re.$$.fragment),Il=n(),Me=o("p"),Me.textContent=In,Cl=n(),r(ce.$$.fragment),gl=n(),r(me.$$.fragment),vl=n(),ye=o("p"),ye.textContent=Cn,$l=n(),we=o("p"),we.innerHTML=gn,_l=n(),r(de.$$.fragment),Bl=n(),r(Te.$$.fragment),Al=n(),ue=o("p"),ue.textContent=vn,Zl=n(),fe=o("blockquote"),fe.innerHTML=$n,kl=n(),r(Je.$$.fragment),Gl=ya(`
python
`),je=o("p"),je.textContent=_n,xl=n(),r(be.$$.fragment),Wl=n(),r(he.$$.fragment),Yl=n(),Ue=o("p"),Ue.textContent=Bn,Nl=n(),r(Ie.$$.fragment),El=n(),r(Ce.$$.fragment),Xl=n(),ge=o("p"),ge.textContent=An,Rl=n(),r(ve.$$.fragment),Vl=n(),$e=o("p"),$e.innerHTML=Zn,Sl=n(),r(_e.$$.fragment),Hl=n(),r(Be.$$.fragment),Ql=n(),Ae=o("p"),Ae.innerHTML=kn,Ll=n(),Ze=o("p"),Ze.textContent=Gn,Fl=n(),r(ke.$$.fragment),zl=n(),r(Ge.$$.fragment),Pl=n(),xe=o("p"),xe.innerHTML=xn,ql=n(),We=o("p"),We.innerHTML=Wn,Dl=n(),r(Ye.$$.fragment),Kl=n(),Ne=o("p"),Ne.innerHTML=Yn,Ol=n(),Ee=o("p"),Ee.textContent=Nn,es=n(),r(Xe.$$.fragment),ts=n(),Re=o("p"),Re.textContent=En,ls=n(),r(Ve.$$.fragment),ss=n(),Se=o("p"),Se.innerHTML=Xn,ns=n(),He=o("ul"),He.innerHTML=Rn,as=n(),Qe=o("p"),Qe.innerHTML=Vn,os=n(),r(Le.$$.fragment),is=n(),Fe=o("p"),Fe.innerHTML=Sn,ps=n(),ze=o("ul"),ze.innerHTML=Hn,rs=n(),r(Pe.$$.fragment),Ms=n(),qe=o("p"),qe.innerHTML=Qn,cs=n(),De=o("ul"),De.innerHTML=Ln,ms=n(),Ke=o("p"),Ke.textContent=Fn,ys=n(),r(Oe.$$.fragment),ws=n(),et=o("p"),et.innerHTML=zn,ds=n(),r(tt.$$.fragment),Ts=n(),lt=o("p"),lt.innerHTML=Pn,us=n(),r(st.$$.fragment),fs=n(),nt=o("p"),nt.innerHTML=qn,Js=n(),r(at.$$.fragment),js=n(),r(ot.$$.fragment),bs=n(),f=o("ul"),it=o("li"),vt=o("p"),vt.innerHTML=Dn,Rs=n(),r(pt.$$.fragment),Vs=n(),rt=o("li"),$t=o("p"),$t.innerHTML=Kn,Ss=n(),r(Mt.$$.fragment),Hs=n(),ct=o("li"),_t=o("p"),_t.innerHTML=On,Qs=n(),r(mt.$$.fragment),hs=n(),r(yt.$$.fragment),Us=n(),h=o("ol"),wt=o("li"),Bt=o("p"),Bt.innerHTML=ea,Ls=n(),r(dt.$$.fragment),Fs=n(),Tt=o("li"),At=o("p"),At.innerHTML=ta,zs=n(),r(ut.$$.fragment),Is=n(),ft=o("p"),ft.textContent=la,Cs=n(),r(Jt.$$.fragment),gs=n(),jt=o("p"),jt.textContent=sa,vs=n(),bt=o("ul"),bt.innerHTML=na,$s=n(),r(ht.$$.fragment),_s=n(),Ut=o("p"),Ut.textContent=aa,Bs=n(),It=o("ul"),It.innerHTML=oa,As=n(),Ct=o("p"),Ct.innerHTML=ia,Zs=n(),r(gt.$$.fragment),ks=n(),Gt=o("p"),this.h()},l(e){const t=wa("svelte-u9bgzb",document.head);J=i(t,"META",{name:!0,content:!0}),t.forEach(l),xt=a(e),kt=i(e,"P",{}),j(kt).forEach(l),Wt=a(e),M(U.$$.fragment,e),Yt=a(e),M(I.$$.fragment,e),Nt=a(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-sl443g"&&(C.textContent=Ds),Et=a(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-yp6pog"&&(g.innerHTML=Ks),Xt=a(e),M(v.$$.fragment,e),Rt=a(e),$=i(e,"UL",{"data-svelte-h":!0}),p($)!=="svelte-11itqwk"&&($.innerHTML=Os),Vt=a(e),M(_.$$.fragment,e),St=a(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-9dsyh9"&&(B.textContent=en),Ht=a(e),A=i(e,"UL",{"data-svelte-h":!0}),p(A)!=="svelte-1cfhvoe"&&(A.innerHTML=tn),Qt=a(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-169ujvt"&&(Z.innerHTML=ln),Lt=a(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-12o83v0"&&(k.textContent=sn),Ft=a(e),G=i(e,"UL",{"data-svelte-h":!0}),p(G)!=="svelte-1d5xfjp"&&(G.innerHTML=nn),zt=a(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1e113uy"&&(x.textContent=an),Pt=a(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-145ejj4"&&(W.innerHTML=on),qt=a(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-wbam8h"&&(Y.innerHTML=pn),Dt=a(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-tm2a0s"&&(N.innerHTML=rn),Kt=a(e),M(E.$$.fragment,e),Ot=a(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-rc24jv"&&(X.innerHTML=Mn),el=a(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1p0w0g0"&&(R.textContent=cn),tl=a(e),M(V.$$.fragment,e),ll=a(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1ieof37"&&(S.innerHTML=mn),sl=a(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-dxku0t"&&(H.innerHTML=yn),nl=a(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-nb93rz"&&(Q.innerHTML=wn),al=a(e),M(L.$$.fragment,e),ol=a(e),M(F.$$.fragment,e),il=a(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-l9j1d3"&&(z.innerHTML=dn),pl=a(e),b=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(b)!=="svelte-5ox74y"&&(b.innerHTML=Tn),rl=a(e),M(P.$$.fragment,e),Ml=a(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-u7pcb4"&&(q.innerHTML=un),cl=a(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1t42iyr"&&(D.textContent=fn),ml=a(e),M(K.$$.fragment,e),yl=a(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1rkp57y"&&(O.textContent=Jn),wl=a(e),M(ee.$$.fragment,e),dl=a(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-12yyl6o"&&(te.innerHTML=jn),Tl=a(e),le=i(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1h5avx7"&&(le.innerHTML=bn),ul=a(e),M(se.$$.fragment,e),fl=a(e),M(ne.$$.fragment,e),Jl=a(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-h4v7d7"&&(ae.textContent=hn),jl=a(e),M(oe.$$.fragment,e),bl=a(e),ie=i(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1gpnath"&&(ie.innerHTML=Un),hl=a(e),M(pe.$$.fragment,e),Ul=a(e),M(re.$$.fragment,e),Il=a(e),Me=i(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1iphpc4"&&(Me.textContent=In),Cl=a(e),M(ce.$$.fragment,e),gl=a(e),M(me.$$.fragment,e),vl=a(e),ye=i(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-lfuhuo"&&(ye.textContent=Cn),$l=a(e),we=i(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1seywak"&&(we.innerHTML=gn),_l=a(e),M(de.$$.fragment,e),Bl=a(e),M(Te.$$.fragment,e),Al=a(e),ue=i(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1e7cuec"&&(ue.textContent=vn),Zl=a(e),fe=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(fe)!=="svelte-9w4yye"&&(fe.innerHTML=$n),kl=a(e),M(Je.$$.fragment,e),Gl=da(e,`
python
`),je=i(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1ufctnq"&&(je.textContent=_n),xl=a(e),M(be.$$.fragment,e),Wl=a(e),M(he.$$.fragment,e),Yl=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1gxojkw"&&(Ue.textContent=Bn),Nl=a(e),M(Ie.$$.fragment,e),El=a(e),M(Ce.$$.fragment,e),Xl=a(e),ge=i(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1qfd9tp"&&(ge.textContent=An),Rl=a(e),M(ve.$$.fragment,e),Vl=a(e),$e=i(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-adteeq"&&($e.innerHTML=Zn),Sl=a(e),M(_e.$$.fragment,e),Hl=a(e),M(Be.$$.fragment,e),Ql=a(e),Ae=i(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-1elar01"&&(Ae.innerHTML=kn),Ll=a(e),Ze=i(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-xmm0bj"&&(Ze.textContent=Gn),Fl=a(e),M(ke.$$.fragment,e),zl=a(e),M(Ge.$$.fragment,e),Pl=a(e),xe=i(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1s7uvme"&&(xe.innerHTML=xn),ql=a(e),We=i(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-19bs1hk"&&(We.innerHTML=Wn),Dl=a(e),M(Ye.$$.fragment,e),Kl=a(e),Ne=i(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-b4gh3p"&&(Ne.innerHTML=Yn),Ol=a(e),Ee=i(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-1nx86ge"&&(Ee.textContent=Nn),es=a(e),M(Xe.$$.fragment,e),ts=a(e),Re=i(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-wkwf1l"&&(Re.textContent=En),ls=a(e),M(Ve.$$.fragment,e),ss=a(e),Se=i(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-ngx3o7"&&(Se.innerHTML=Xn),ns=a(e),He=i(e,"UL",{"data-svelte-h":!0}),p(He)!=="svelte-1if2wr2"&&(He.innerHTML=Rn),as=a(e),Qe=i(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-1g5440j"&&(Qe.innerHTML=Vn),os=a(e),M(Le.$$.fragment,e),is=a(e),Fe=i(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-hvi6c3"&&(Fe.innerHTML=Sn),ps=a(e),ze=i(e,"UL",{"data-svelte-h":!0}),p(ze)!=="svelte-one2g8"&&(ze.innerHTML=Hn),rs=a(e),M(Pe.$$.fragment,e),Ms=a(e),qe=i(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-1oiom90"&&(qe.innerHTML=Qn),cs=a(e),De=i(e,"UL",{"data-svelte-h":!0}),p(De)!=="svelte-1631zmm"&&(De.innerHTML=Ln),ms=a(e),Ke=i(e,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-8jrjeo"&&(Ke.textContent=Fn),ys=a(e),M(Oe.$$.fragment,e),ws=a(e),et=i(e,"P",{"data-svelte-h":!0}),p(et)!=="svelte-5us40e"&&(et.innerHTML=zn),ds=a(e),M(tt.$$.fragment,e),Ts=a(e),lt=i(e,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-1vhmw5s"&&(lt.innerHTML=Pn),us=a(e),M(st.$$.fragment,e),fs=a(e),nt=i(e,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-pqm0z"&&(nt.innerHTML=qn),Js=a(e),M(at.$$.fragment,e),js=a(e),M(ot.$$.fragment,e),bs=a(e),f=i(e,"UL",{});var Zt=j(f);it=i(Zt,"LI",{});var xs=j(it);vt=i(xs,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-1bkxmuc"&&(vt.innerHTML=Dn),Rs=a(xs),M(pt.$$.fragment,xs),xs.forEach(l),Vs=a(Zt),rt=i(Zt,"LI",{});var Ws=j(rt);$t=i(Ws,"P",{"data-svelte-h":!0}),p($t)!=="svelte-xwteld"&&($t.innerHTML=Kn),Ss=a(Ws),M(Mt.$$.fragment,Ws),Ws.forEach(l),Hs=a(Zt),ct=i(Zt,"LI",{});var Ys=j(ct);_t=i(Ys,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-iyngrk"&&(_t.innerHTML=On),Qs=a(Ys),M(mt.$$.fragment,Ys),Ys.forEach(l),Zt.forEach(l),hs=a(e),M(yt.$$.fragment,e),Us=a(e),h=i(e,"OL",{});var Ns=j(h);wt=i(Ns,"LI",{});var Es=j(wt);Bt=i(Es,"P",{"data-svelte-h":!0}),p(Bt)!=="svelte-1x64a52"&&(Bt.innerHTML=ea),Ls=a(Es),M(dt.$$.fragment,Es),Es.forEach(l),Fs=a(Ns),Tt=i(Ns,"LI",{});var Xs=j(Tt);At=i(Xs,"P",{"data-svelte-h":!0}),p(At)!=="svelte-rb903a"&&(At.innerHTML=ta),zs=a(Xs),M(ut.$$.fragment,Xs),Xs.forEach(l),Ns.forEach(l),Is=a(e),ft=i(e,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-1u6sxd"&&(ft.textContent=la),Cs=a(e),M(Jt.$$.fragment,e),gs=a(e),jt=i(e,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-4e719u"&&(jt.textContent=sa),vs=a(e),bt=i(e,"UL",{"data-svelte-h":!0}),p(bt)!=="svelte-1rdiovu"&&(bt.innerHTML=na),$s=a(e),M(ht.$$.fragment,e),_s=a(e),Ut=i(e,"P",{"data-svelte-h":!0}),p(Ut)!=="svelte-ta7vyn"&&(Ut.textContent=aa),Bs=a(e),It=i(e,"UL",{"data-svelte-h":!0}),p(It)!=="svelte-16m8r0w"&&(It.innerHTML=oa),As=a(e),Ct=i(e,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-o90m39"&&(Ct.innerHTML=ia),Zs=a(e),M(gt.$$.fragment,e),ks=a(e),Gt=i(e,"P",{}),j(Gt).forEach(l),this.h()},h(){Ps(J,"name","hf:doc:metadata"),Ps(J,"content",Ja),Ps(b,"class","warning")},m(e,t){T(document.head,J),s(e,xt,t),s(e,kt,t),s(e,Wt,t),c(U,e,t),s(e,Yt,t),c(I,e,t),s(e,Nt,t),s(e,C,t),s(e,Et,t),s(e,g,t),s(e,Xt,t),c(v,e,t),s(e,Rt,t),s(e,$,t),s(e,Vt,t),c(_,e,t),s(e,St,t),s(e,B,t),s(e,Ht,t),s(e,A,t),s(e,Qt,t),s(e,Z,t),s(e,Lt,t),s(e,k,t),s(e,Ft,t),s(e,G,t),s(e,zt,t),s(e,x,t),s(e,Pt,t),s(e,W,t),s(e,qt,t),s(e,Y,t),s(e,Dt,t),s(e,N,t),s(e,Kt,t),c(E,e,t),s(e,Ot,t),s(e,X,t),s(e,el,t),s(e,R,t),s(e,tl,t),c(V,e,t),s(e,ll,t),s(e,S,t),s(e,sl,t),s(e,H,t),s(e,nl,t),s(e,Q,t),s(e,al,t),c(L,e,t),s(e,ol,t),c(F,e,t),s(e,il,t),s(e,z,t),s(e,pl,t),s(e,b,t),s(e,rl,t),c(P,e,t),s(e,Ml,t),s(e,q,t),s(e,cl,t),s(e,D,t),s(e,ml,t),c(K,e,t),s(e,yl,t),s(e,O,t),s(e,wl,t),c(ee,e,t),s(e,dl,t),s(e,te,t),s(e,Tl,t),s(e,le,t),s(e,ul,t),c(se,e,t),s(e,fl,t),c(ne,e,t),s(e,Jl,t),s(e,ae,t),s(e,jl,t),c(oe,e,t),s(e,bl,t),s(e,ie,t),s(e,hl,t),c(pe,e,t),s(e,Ul,t),c(re,e,t),s(e,Il,t),s(e,Me,t),s(e,Cl,t),c(ce,e,t),s(e,gl,t),c(me,e,t),s(e,vl,t),s(e,ye,t),s(e,$l,t),s(e,we,t),s(e,_l,t),c(de,e,t),s(e,Bl,t),c(Te,e,t),s(e,Al,t),s(e,ue,t),s(e,Zl,t),s(e,fe,t),s(e,kl,t),c(Je,e,t),s(e,Gl,t),s(e,je,t),s(e,xl,t),c(be,e,t),s(e,Wl,t),c(he,e,t),s(e,Yl,t),s(e,Ue,t),s(e,Nl,t),c(Ie,e,t),s(e,El,t),c(Ce,e,t),s(e,Xl,t),s(e,ge,t),s(e,Rl,t),c(ve,e,t),s(e,Vl,t),s(e,$e,t),s(e,Sl,t),c(_e,e,t),s(e,Hl,t),c(Be,e,t),s(e,Ql,t),s(e,Ae,t),s(e,Ll,t),s(e,Ze,t),s(e,Fl,t),c(ke,e,t),s(e,zl,t),c(Ge,e,t),s(e,Pl,t),s(e,xe,t),s(e,ql,t),s(e,We,t),s(e,Dl,t),c(Ye,e,t),s(e,Kl,t),s(e,Ne,t),s(e,Ol,t),s(e,Ee,t),s(e,es,t),c(Xe,e,t),s(e,ts,t),s(e,Re,t),s(e,ls,t),c(Ve,e,t),s(e,ss,t),s(e,Se,t),s(e,ns,t),s(e,He,t),s(e,as,t),s(e,Qe,t),s(e,os,t),c(Le,e,t),s(e,is,t),s(e,Fe,t),s(e,ps,t),s(e,ze,t),s(e,rs,t),c(Pe,e,t),s(e,Ms,t),s(e,qe,t),s(e,cs,t),s(e,De,t),s(e,ms,t),s(e,Ke,t),s(e,ys,t),c(Oe,e,t),s(e,ws,t),s(e,et,t),s(e,ds,t),c(tt,e,t),s(e,Ts,t),s(e,lt,t),s(e,us,t),c(st,e,t),s(e,fs,t),s(e,nt,t),s(e,Js,t),c(at,e,t),s(e,js,t),c(ot,e,t),s(e,bs,t),s(e,f,t),T(f,it),T(it,vt),T(it,Rs),c(pt,it,null),T(f,Vs),T(f,rt),T(rt,$t),T(rt,Ss),c(Mt,rt,null),T(f,Hs),T(f,ct),T(ct,_t),T(ct,Qs),c(mt,ct,null),s(e,hs,t),c(yt,e,t),s(e,Us,t),s(e,h,t),T(h,wt),T(wt,Bt),T(wt,Ls),c(dt,wt,null),T(h,Fs),T(h,Tt),T(Tt,At),T(Tt,zs),c(ut,Tt,null),s(e,Is,t),s(e,ft,t),s(e,Cs,t),c(Jt,e,t),s(e,gs,t),s(e,jt,t),s(e,vs,t),s(e,bt,t),s(e,$s,t),c(ht,e,t),s(e,_s,t),s(e,Ut,t),s(e,Bs,t),s(e,It,t),s(e,As,t),s(e,Ct,t),s(e,Zs,t),c(gt,e,t),s(e,ks,t),s(e,Gt,t),Gs=!0},p:ra,i(e){Gs||(m(U.$$.fragment,e),m(I.$$.fragment,e),m(v.$$.fragment,e),m(_.$$.fragment,e),m(E.$$.fragment,e),m(V.$$.fragment,e),m(L.$$.fragment,e),m(F.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(oe.$$.fragment,e),m(pe.$$.fragment,e),m(re.$$.fragment,e),m(ce.$$.fragment,e),m(me.$$.fragment,e),m(de.$$.fragment,e),m(Te.$$.fragment,e),m(Je.$$.fragment,e),m(be.$$.fragment,e),m(he.$$.fragment,e),m(Ie.$$.fragment,e),m(Ce.$$.fragment,e),m(ve.$$.fragment,e),m(_e.$$.fragment,e),m(Be.$$.fragment,e),m(ke.$$.fragment,e),m(Ge.$$.fragment,e),m(Ye.$$.fragment,e),m(Xe.$$.fragment,e),m(Ve.$$.fragment,e),m(Le.$$.fragment,e),m(Pe.$$.fragment,e),m(Oe.$$.fragment,e),m(tt.$$.fragment,e),m(st.$$.fragment,e),m(at.$$.fragment,e),m(ot.$$.fragment,e),m(pt.$$.fragment,e),m(Mt.$$.fragment,e),m(mt.$$.fragment,e),m(yt.$$.fragment,e),m(dt.$$.fragment,e),m(ut.$$.fragment,e),m(Jt.$$.fragment,e),m(ht.$$.fragment,e),m(gt.$$.fragment,e),Gs=!0)},o(e){y(U.$$.fragment,e),y(I.$$.fragment,e),y(v.$$.fragment,e),y(_.$$.fragment,e),y(E.$$.fragment,e),y(V.$$.fragment,e),y(L.$$.fragment,e),y(F.$$.fragment,e),y(P.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(se.$$.fragment,e),y(ne.$$.fragment,e),y(oe.$$.fragment,e),y(pe.$$.fragment,e),y(re.$$.fragment,e),y(ce.$$.fragment,e),y(me.$$.fragment,e),y(de.$$.fragment,e),y(Te.$$.fragment,e),y(Je.$$.fragment,e),y(be.$$.fragment,e),y(he.$$.fragment,e),y(Ie.$$.fragment,e),y(Ce.$$.fragment,e),y(ve.$$.fragment,e),y(_e.$$.fragment,e),y(Be.$$.fragment,e),y(ke.$$.fragment,e),y(Ge.$$.fragment,e),y(Ye.$$.fragment,e),y(Xe.$$.fragment,e),y(Ve.$$.fragment,e),y(Le.$$.fragment,e),y(Pe.$$.fragment,e),y(Oe.$$.fragment,e),y(tt.$$.fragment,e),y(st.$$.fragment,e),y(at.$$.fragment,e),y(ot.$$.fragment,e),y(pt.$$.fragment,e),y(Mt.$$.fragment,e),y(mt.$$.fragment,e),y(yt.$$.fragment,e),y(dt.$$.fragment,e),y(ut.$$.fragment,e),y(Jt.$$.fragment,e),y(ht.$$.fragment,e),y(gt.$$.fragment,e),Gs=!1},d(e){e&&(l(xt),l(kt),l(Wt),l(Yt),l(Nt),l(C),l(Et),l(g),l(Xt),l(Rt),l($),l(Vt),l(St),l(B),l(Ht),l(A),l(Qt),l(Z),l(Lt),l(k),l(Ft),l(G),l(zt),l(x),l(Pt),l(W),l(qt),l(Y),l(Dt),l(N),l(Kt),l(Ot),l(X),l(el),l(R),l(tl),l(ll),l(S),l(sl),l(H),l(nl),l(Q),l(al),l(ol),l(il),l(z),l(pl),l(b),l(rl),l(Ml),l(q),l(cl),l(D),l(ml),l(yl),l(O),l(wl),l(dl),l(te),l(Tl),l(le),l(ul),l(fl),l(Jl),l(ae),l(jl),l(bl),l(ie),l(hl),l(Ul),l(Il),l(Me),l(Cl),l(gl),l(vl),l(ye),l($l),l(we),l(_l),l(Bl),l(Al),l(ue),l(Zl),l(fe),l(kl),l(Gl),l(je),l(xl),l(Wl),l(Yl),l(Ue),l(Nl),l(El),l(Xl),l(ge),l(Rl),l(Vl),l($e),l(Sl),l(Hl),l(Ql),l(Ae),l(Ll),l(Ze),l(Fl),l(zl),l(Pl),l(xe),l(ql),l(We),l(Dl),l(Kl),l(Ne),l(Ol),l(Ee),l(es),l(ts),l(Re),l(ls),l(ss),l(Se),l(ns),l(He),l(as),l(Qe),l(os),l(is),l(Fe),l(ps),l(ze),l(rs),l(Ms),l(qe),l(cs),l(De),l(ms),l(Ke),l(ys),l(ws),l(et),l(ds),l(Ts),l(lt),l(us),l(fs),l(nt),l(Js),l(js),l(bs),l(f),l(hs),l(Us),l(h),l(Is),l(ft),l(Cs),l(gs),l(jt),l(vs),l(bt),l($s),l(_s),l(Ut),l(Bs),l(It),l(As),l(Ct),l(Zs),l(ks),l(Gt)),l(J),w(U,e),w(I,e),w(v,e),w(_,e),w(E,e),w(V,e),w(L,e),w(F,e),w(P,e),w(K,e),w(ee,e),w(se,e),w(ne,e),w(oe,e),w(pe,e),w(re,e),w(ce,e),w(me,e),w(de,e),w(Te,e),w(Je,e),w(be,e),w(he,e),w(Ie,e),w(Ce,e),w(ve,e),w(_e,e),w(Be,e),w(ke,e),w(Ge,e),w(Ye,e),w(Xe,e),w(Ve,e),w(Le,e),w(Pe,e),w(Oe,e),w(tt,e),w(st,e),w(at,e),w(ot,e),w(pt),w(Mt),w(mt),w(yt,e),w(dt),w(ut),w(Jt,e),w(ht,e),w(gt,e)}}}const Ja='{"title":"Bring Your Own Hardware","local":"bring-your-own-hardware","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Choose your motors","local":"choose-your-motors","sections":[],"depth":2},{"title":"Step 1: Subclass the Robot Interface","local":"step-1-subclass-the-robot-interface","sections":[],"depth":2},{"title":"Step 2: Define Observation and Action Features","local":"step-2-define-observation-and-action-features","sections":[{"title":"observation_features","local":"observationfeatures","sections":[],"depth":3},{"title":"action_features","local":"actionfeatures","sections":[],"depth":3}],"depth":2},{"title":"Step 3: Handle Connection and Disconnection","local":"step-3-handle-connection-and-disconnection","sections":[{"title":"is_connected","local":"isconnected","sections":[],"depth":3},{"title":"connect()","local":"connect","sections":[],"depth":3},{"title":"disconnect()","local":"disconnect","sections":[],"depth":3}],"depth":2},{"title":"Step 4: Support Calibration and Configuration","local":"step-4-support-calibration-and-configuration","sections":[{"title":"configure()","local":"configure","sections":[],"depth":3}],"depth":2},{"title":"Step 5: Implement Sensors Reading and Action Sending","local":"step-5-implement-sensors-reading-and-action-sending","sections":[{"title":"get_observation()","local":"getobservation","sections":[],"depth":3},{"title":"send_action()","local":"sendaction","sections":[],"depth":3}],"depth":2},{"title":"Adding a Teleoperator","local":"adding-a-teleoperator","sections":[],"depth":2},{"title":"Using Your Own LeRobot Devices 🔌","local":"using-your-own-lerobot-devices-","sections":[{"title":"The 4 Core Conventions","local":"the-4-core-conventions","sections":[{"title":"1 . Create an Installable Package with a Specific Prefix","local":"1--create-an-installable-package-with-a-specific-prefix","sections":[],"depth":4},{"title":"2 . Follow the SomethingConfig / Something Naming Pattern","local":"2--follow-the-somethingconfig--something-naming-pattern","sections":[],"depth":4},{"title":"3 . Place Your Files in a Predictable Structure","local":"3--place-your-files-in-a-predictable-structure","sections":[],"depth":4},{"title":"4 . Expose Classes in __init__.py","local":"4--expose-classes-in-initpy","sections":[],"depth":4}],"depth":3},{"title":"Putting It All Together: A Complete Example","local":"putting-it-all-together-a-complete-example","sections":[{"title":"Directory Structure","local":"directory-structure","sections":[],"depth":4},{"title":"File Contents","local":"file-contents","sections":[],"depth":4}],"depth":3},{"title":"Installation and Usage","local":"installation-and-usage","sections":[],"depth":3},{"title":"Looking for an example ?","local":"looking-for-an-example-","sections":[],"depth":3}],"depth":2},{"title":"Wrapping Up","local":"wrapping-up","sections":[],"depth":2}],"depth":1}';function ja(qs){return Ma(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ga extends ca{constructor(J){super(),ma(this,J,ja,fa,pa,{})}}export{ga as component};
