import{s as dt,n as yt,o as jt}from"../chunks/scheduler.eb244325.js";import{S as bt,i as mt,e as n,s as a,c as r,h as ft,a as i,d as l,b as o,f as wt,g as M,j as p,k as ut,l as ht,m as s,n as c,t as J,o as T,p as w}from"../chunks/index.3fe63ad3.js";import{C as Ut}from"../chunks/CopyLLMTxtMenu.3c6aa112.js";import{C as ze}from"../chunks/CodeBlock.85b10842.js";import{H as d,E as It}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.bf4dbd10.js";function vt(Fe){let u,le,ee,se,y,ae,j,oe,b,ke="This guide shows how to build and modify processing pipelines that connect teleoperators (e.g., phone) to robots and datasets. Pipelines standardize conversions between different action/observation spaces so you can swap teleops and robots without rewriting glue code.",ne,m,Ye="We use the Phone to SO‑100 follower examples for concreteness, but the same patterns apply to other robots.",ie,f,Qe="<strong>What you’ll learn</strong>",pe,h,Se="<li>Absolute vs. relative EE control: What each means, trade‑offs, and how to choose for your task.</li> <li>Three-pipeline pattern: How to map teleop actions → dataset actions → robot commands, and robot observations → dataset observations.</li> <li>Adapters (<code>to_transition</code> / <code>to_output</code>): How these convert raw dicts to <code>EnvTransition</code> and back to reduce boilerplate.</li> <li>Dataset feature contracts: How steps declare features via <code>transform_features(...)</code>, and how to aggregate/merge them for recording.</li> <li>Choosing a representation: When to store joints, absolute EE poses, or relative EE deltas—and how that affects training.</li> <li>Pipeline customization guidance: How to swap robots/URDFs safely and tune bounds, step sizes, and options like IK initialization.</li>",re,U,Me,I,Pe="The examples in this guide use absolute end effector (EE) poses because they are easy to reason about. In practice, relative EE deltas or joint position are often preferred as learning features.",ce,v,Le="With processors, you choose the learning features you want to use for your policy. This could be joints positions/velocities, absolute EE, or relative EE positions. You can also choose to store other features, such as joint torques, motor currents, etc.",Je,A,Te,C,qe=`We often compose three pipelines. Depending on your setup, some can be empty if action and observation spaces already match.
Each of these pipelines handle different conversions between different action and observation spaces. Below is a quick explanation of each pipeline.`,we,_,De="<li>Pipeline 1: Teleop action space → dataset action space (phone pose → EE targets)</li> <li>Pipeline 2: Dataset action space → robot command space (EE targets → joints)</li> <li>Pipeline 3: Robot observation space → dataset observation space (joints → EE pose)</li>",ue,B,Ke="Below is an example of the three pipelines that we use in the phone to SO-100 follower examples:",de,Z,ye,G,je,R,Oe=`To convert from robot/teleoperator to pipeline and back, we use the <code>to_transition</code> and <code>to_output</code> pipeline adapters.
They standardize conversions to reduce boilerplate code, and form the bridge between the robot and teleoperators raw dictionaries and the pipeline’s <code>EnvTransition</code> format.
In the phone to SO-100 follower examples we use the following adapters:`,be,E,et="<li><code>robot_action_to_transition</code>: transforms the teleop action dict to a pipeline transition.</li> <li><code>transition_to_robot_action</code>: transforms the pipeline transition to a robot action dict.</li> <li><code>observation_to_transition</code>: transforms the robot observation dict to a pipeline transition.</li> <li><code>transition_to_observation</code>: transforms the pipeline transition to a observation dict.</li>",me,V,tt='Checkout <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/processor/converters.py" rel="nofollow">src/lerobot/processor/converters.py</a> for more details.',fe,X,he,g,lt="Dataset features are determined by the keys saved in the dataset. Each step can declare what features it modifies in a contract called <code>transform_features(...)</code>. Once you build a processor, the processor can then aggregate all of these features with <code>aggregate_pipeline_dataset_features()</code> and merge multiple feature dicts with <code>combine_feature_dicts(...)</code>.",Ue,$,st="Below is and example of how we declare features with the <code>transform_features</code> method in the phone to SO-100 follower examples:",Ie,W,ve,H,at="Here we declare what PolicyFeatures we modify in this step, so we know what features we can expect when we run the processor. These features can then be aggregated and used to create the dataset features.",Ae,x,ot="Below is an example of how we aggregate and merge features in the phone to SO-100 record example:",Ce,N,_e,z,nt="How it works:",Be,F,it="<li><code>aggregate_pipeline_dataset_features(...)</code>: applies <code>transform_features</code> across the pipeline and filters by patterns (images included when <code>use_videos=True</code>, and state features included when <code>patterns</code> is specified).</li> <li><code>combine_feature_dicts(...)</code>: combine multiple feature dicts.</li> <li>Recording with <code>record_loop(...)</code> uses <code>build_dataset_frame(...)</code> to build frames consistent with <code>dataset.features</code> before we call <code>add_frame(...)</code> to add the frame to the dataset.</li>",Ze,k,Ge,Y,pt="You can store any of the following features as your action/observation space:",Re,Q,rt="<li>Joint positions</li> <li>Absolute EE poses</li> <li>Relative EE deltas</li> <li>Other features: joint velocity, torques, etc.</li>",Ee,S,Mt="Pick what you want to use for your policy action and observation space and configure/modify the pipelines and steps accordingly.",Ve,P,Xe,L,ct="<li>You can easily reuse pipelines, for example to use another robot with phone teleop, modify the examples and swap the robot <code>RobotKinematics</code> (URDF) and <code>motor_names</code> to use your own robot with Phone teleop. Additionally you should ensure <code>target_frame_name</code> points to your gripper/wrist.</li>",ge,q,$e,D,Jt="<li>When changing pipelines, start with tight bounds, implement safety steps when working with real robots.</li> <li>Its advised to start with simulation first and then move to real robots.</li>",We,K,Tt='Thats it! We hope this guide helps you get started with customizing your robot pipelines, If you run into any issues at any point, jump into our <a href="https://discord.com/invite/s3KuuzsPFb" rel="nofollow">Discord community</a> for support.',He,O,xe,te,Ne;return y=new Ut({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new d({props:{title:"Processors for Robots and Teleoperators",local:"processors-for-robots-and-teleoperators",headingTag:"h1"}}),U=new d({props:{title:"Absolute vs relative EE control",local:"absolute-vs-relative-ee-control",headingTag:"h3"}}),A=new d({props:{title:"Three pipelines",local:"three-pipelines",headingTag:"h2"}}),Z=new ze({props:{code:"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",highlighted:`phone_to_robot_ee_pose_processor = RobotProcessorPipeline[RobotAction, RobotAction]( # teleop -&gt; dataset action
    steps=[
        MapPhoneActionToRobotAction(<span class="hljs-attribute">platform</span>=teleop_config.phone_os),
        EEReferenceAndDelta(
            <span class="hljs-attribute">kinematics</span>=kinematics_solver, end_effector_step_sizes={<span class="hljs-string">&quot;x&quot;</span>: 0.5, <span class="hljs-string">&quot;y&quot;</span>: 0.5, <span class="hljs-string">&quot;z&quot;</span>: 0.5}, <span class="hljs-attribute">motor_names</span>=list(robot.bus.motors.keys()),
        ),
        EEBoundsAndSafety(
            end_effector_bounds={<span class="hljs-string">&quot;min&quot;</span>: [-1.0, -1.0, -1.0], <span class="hljs-string">&quot;max&quot;</span>: [1.0, 1.0, 1.0]}, <span class="hljs-attribute">max_ee_step_m</span>=0.20,
        ),
        GripperVelocityToJoint(),
    ],
    <span class="hljs-attribute">to_transition</span>=robot_action_to_transition,
    <span class="hljs-attribute">to_output</span>=transition_to_robot_action,
)

robot_ee_to_joints_processor = RobotProcessorPipeline[RobotAction, RobotAction]( # dataset action -&gt; robot
    steps=[
        InverseKinematicsEEToJoints(
            <span class="hljs-attribute">kinematics</span>=kinematics_solver, <span class="hljs-attribute">motor_names</span>=list(robot.bus.motors.keys()), <span class="hljs-attribute">initial_guess_current_joints</span>=<span class="hljs-literal">True</span>,
        ),
    ],
    <span class="hljs-attribute">to_transition</span>=robot_action_to_transition,
    <span class="hljs-attribute">to_output</span>=transition_to_robot_action,
)

robot_joints_to_ee_pose = RobotProcessorPipeline[RobotObservation, RobotObservation]( # robot obs -&gt; dataset obs
    steps=[
        ForwardKinematicsJointsToEE(<span class="hljs-attribute">kinematics</span>=kinematics_solver, <span class="hljs-attribute">motor_names</span>=list(robot.bus.motors.keys()))
    ],
    <span class="hljs-attribute">to_transition</span>=observation_to_transition,
    <span class="hljs-attribute">to_output</span>=transition_to_observation,
)`,wrap:!1}}),G=new d({props:{title:"Why to_transition / to_output",local:"why-totransition--tooutput",headingTag:"h2"}}),X=new d({props:{title:"Dataset feature contracts",local:"dataset-feature-contracts",headingTag:"h2"}}),W=new ze({props:{code:"JTIwJTIwJTIwJTIwZGVmJTIwdHJhbnNmb3JtX2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYlMkMlMjBmZWF0dXJlcyUzQSUyMGRpY3QlNUJQaXBlbGluZUZlYXR1cmVUeXBlJTJDJTIwZGljdCU1QnN0ciUyQyUyMFBvbGljeUZlYXR1cmUlNUQlNUQlMEElMjAlMjAlMjAlMjApJTIwLSUzRSUyMGRpY3QlNUJQaXBlbGluZUZlYXR1cmVUeXBlJTJDJTIwZGljdCU1QnN0ciUyQyUyMFBvbGljeUZlYXR1cmUlNUQlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBXZSUyMG9ubHklMjB1c2UlMjB0aGUlMjBlZSUyMHBvc2UlMjBpbiUyMHRoZSUyMGRhdGFzZXQlMkMlMjBzbyUyMHdlJTIwZG9uJ3QlMjBuZWVkJTIwdGhlJTIwam9pbnQlMjBwb3NpdGlvbnMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBuJTIwaW4lMjBzZWxmLm1vdG9yX25hbWVzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZmVhdHVyZXMlNUJQaXBlbGluZUZlYXR1cmVUeXBlLkFDVElPTiU1RC5wb3AoZiUyMiU3Qm4lN0QucG9zJTIyJTJDJTIwTm9uZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBXZSUyMHNwZWNpZnklMjB0aGUlMjBkYXRhc2V0JTIwZmVhdHVyZXMlMjBvZiUyMHRoaXMlMjBzdGVwJTIwdGhhdCUyMHdlJTIwd2FudCUyMHRvJTIwYmUlMjBzdG9yZWQlMjBpbiUyMHRoZSUyMGRhdGFzZXQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBrJTIwaW4lMjAlNUIlMjJ4JTIyJTJDJTIwJTIyeSUyMiUyQyUyMCUyMnolMjIlMkMlMjAlMjJ3eCUyMiUyQyUyMCUyMnd5JTIyJTJDJTIwJTIyd3olMjIlMkMlMjAlMjJncmlwcGVyX3BvcyUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTVCUGlwZWxpbmVGZWF0dXJlVHlwZS5BQ1RJT04lNUQlNUJmJTIyZWUuJTdCayU3RCUyMiU1RCUyMCUzRCUyMFBvbGljeUZlYXR1cmUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHlwZSUzREZlYXR1cmVUeXBlLlNUQVRFJTJDJTIwc2hhcGUlM0QoMSUyQyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZmVhdHVyZXM=",highlighted:`    <span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_features</span>(<span class="hljs-params">
        self, features: <span class="hljs-built_in">dict</span>[PipelineFeatureType, <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, PolicyFeature]]
    </span>) -&gt; <span class="hljs-built_in">dict</span>[PipelineFeatureType, <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, PolicyFeature]]:
        <span class="hljs-comment"># We only use the ee pose in the dataset, so we don&#x27;t need the joint positions</span>
        <span class="hljs-keyword">for</span> n <span class="hljs-keyword">in</span> self.motor_names:
            features[PipelineFeatureType.ACTION].pop(<span class="hljs-string">f&quot;<span class="hljs-subst">{n}</span>.pos&quot;</span>, <span class="hljs-literal">None</span>)
        <span class="hljs-comment"># We specify the dataset features of this step that we want to be stored in the dataset</span>
        <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;x&quot;</span>, <span class="hljs-string">&quot;y&quot;</span>, <span class="hljs-string">&quot;z&quot;</span>, <span class="hljs-string">&quot;wx&quot;</span>, <span class="hljs-string">&quot;wy&quot;</span>, <span class="hljs-string">&quot;wz&quot;</span>, <span class="hljs-string">&quot;gripper_pos&quot;</span>]:
            features[PipelineFeatureType.ACTION][<span class="hljs-string">f&quot;ee.<span class="hljs-subst">{k}</span>&quot;</span>] = PolicyFeature(
                <span class="hljs-built_in">type</span>=FeatureType.STATE, shape=(<span class="hljs-number">1</span>,)
            )
        <span class="hljs-keyword">return</span> features`,wrap:!1}}),N=new ze({props:{code:"ZmVhdHVyZXMlM0Rjb21iaW5lX2ZlYXR1cmVfZGljdHMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUnVuJTIwdGhlJTIwZmVhdHVyZSUyMGNvbnRyYWN0JTIwb2YlMjB0aGUlMjBwaXBlbGluZXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBUaGlzJTIwdGVsbHMlMjB5b3UlMjBob3clMjB0aGUlMjBmZWF0dXJlcyUyMHdvdWxkJTIwbG9vayUyMGxpa2UlMjBhZnRlciUyMHRoZSUyMHBpcGVsaW5lJTIwc3RlcHMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhZ2dyZWdhdGVfcGlwZWxpbmVfZGF0YXNldF9mZWF0dXJlcyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwaXBlbGluZSUzRHBob25lX3RvX3JvYm90X2VlX3Bvc2VfcHJvY2Vzc29yJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5pdGlhbF9mZWF0dXJlcyUzRGNyZWF0ZV9pbml0aWFsX2ZlYXR1cmVzKGFjdGlvbiUzRHBob25lLmFjdGlvbl9mZWF0dXJlcyklMkMlMjAlMjMlMjAlM0MtJTIwQWN0aW9uJTIwZmVhdHVyZXMlMjB3ZSUyMGNhbiUyMGV4cGVjdCUyQyUyMHRoZXNlJTIwY29tZSUyMGZyb20lMjBvdXIlMjB0ZWxlb3AlMjBkZXZpY2UlMjAocGhvbmUpJTIwYW5kJTIwYWN0aW9uJTIwcHJvY2Vzc29yJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdXNlX3ZpZGVvcyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWdncmVnYXRlX3BpcGVsaW5lX2RhdGFzZXRfZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwZWxpbmUlM0Ryb2JvdF9qb2ludHNfdG9fZWVfcG9zZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluaXRpYWxfZmVhdHVyZXMlM0RjcmVhdGVfaW5pdGlhbF9mZWF0dXJlcyhvYnNlcnZhdGlvbiUzRHJvYm90Lm9ic2VydmF0aW9uX2ZlYXR1cmVzKSUyQyUyMCUyMyUyMCUzQy0lMjBPYnNlcnZhdGlvbiUyMGZlYXR1cmVzJTIwd2UlMjBjYW4lMjBleHBlY3QlMkMlMjB0aGVzZSUyMGNvbWUlMjBmcm9tJTIwb3VyJTIwcm9ib3QlMjBhbmQlMjBvYnNlcnZhdGlvbiUyMHByb2Nlc3NvciUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHVzZV92aWRlb3MlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGF0dGVybnMlM0QlNUIlMjJvYnNlcnZhdGlvbi5zdGF0ZS5lZSUyMiU1RCUyQyUyMCUyMyUyMCUzQy0lMjBIZXJlJTIweW91JTIwY291bGQlMjBvcHRpb25hbGx5JTIwZmlsdGVyJTIwdGhlJTIwZmVhdHVyZXMlMjB3ZSUyMHdhbnQlMjB0byUyMHN0b3JlJTIwaW4lMjB0aGUlMjBkYXRhc2V0JTJDJTIwd2l0aCUyMGElMjBzcGVjaWZpYyUyMHBhdHRlcm4lMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwKSUyQw==",highlighted:`<span class="hljs-attribute">features</span>=combine_feature_dicts(
        # <span class="hljs-built_in">Run</span> the feature contract of the pipelines
        # This tells you how the features would look like after the pipeline steps
        aggregate_pipeline_dataset_features(
            <span class="hljs-attribute">pipeline</span>=phone_to_robot_ee_pose_processor,
            <span class="hljs-attribute">initial_features</span>=create_initial_features(action=phone.action_features), # &lt;- Action features we can expect, these come <span class="hljs-keyword">from</span> our teleop device (phone) <span class="hljs-keyword">and</span> action processor
            <span class="hljs-attribute">use_videos</span>=<span class="hljs-literal">True</span>,
        ),
        aggregate_pipeline_dataset_features(
            <span class="hljs-attribute">pipeline</span>=robot_joints_to_ee_pose,
            <span class="hljs-attribute">initial_features</span>=create_initial_features(observation=robot.observation_features), # &lt;- Observation features we can expect, these come <span class="hljs-keyword">from</span> our robot <span class="hljs-keyword">and</span> observation processor
            <span class="hljs-attribute">use_videos</span>=<span class="hljs-literal">True</span>,
            patterns=[<span class="hljs-string">&quot;observation.state.ee&quot;</span>], # &lt;- Here you could optionally<span class="hljs-built_in"> filter </span>the features we want <span class="hljs-keyword">to</span> store <span class="hljs-keyword">in</span> the dataset, with a specific pattern

        ),
    ),`,wrap:!1}}),k=new d({props:{title:"Guidance when customizing robot pipelines",local:"guidance-when-customizing-robot-pipelines",headingTag:"h2"}}),P=new d({props:{title:"Different robots",local:"different-robots",headingTag:"h3"}}),q=new d({props:{title:"Safety first",local:"safety-first",headingTag:"h3"}}),O=new It({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/processors_robots_teleop.mdx"}}),{c(){u=n("meta"),le=a(),ee=n("p"),se=a(),r(y.$$.fragment),ae=a(),r(j.$$.fragment),oe=a(),b=n("p"),b.textContent=ke,ne=a(),m=n("p"),m.textContent=Ye,ie=a(),f=n("p"),f.innerHTML=Qe,pe=a(),h=n("ul"),h.innerHTML=Se,re=a(),r(U.$$.fragment),Me=a(),I=n("p"),I.textContent=Pe,ce=a(),v=n("p"),v.textContent=Le,Je=a(),r(A.$$.fragment),Te=a(),C=n("p"),C.textContent=qe,we=a(),_=n("ol"),_.innerHTML=De,ue=a(),B=n("p"),B.textContent=Ke,de=a(),r(Z.$$.fragment),ye=a(),r(G.$$.fragment),je=a(),R=n("p"),R.innerHTML=Oe,be=a(),E=n("ul"),E.innerHTML=et,me=a(),V=n("p"),V.innerHTML=tt,fe=a(),r(X.$$.fragment),he=a(),g=n("p"),g.innerHTML=lt,Ue=a(),$=n("p"),$.innerHTML=st,Ie=a(),r(W.$$.fragment),ve=a(),H=n("p"),H.textContent=at,Ae=a(),x=n("p"),x.textContent=ot,Ce=a(),r(N.$$.fragment),_e=a(),z=n("p"),z.textContent=nt,Be=a(),F=n("ul"),F.innerHTML=it,Ze=a(),r(k.$$.fragment),Ge=a(),Y=n("p"),Y.textContent=pt,Re=a(),Q=n("ul"),Q.innerHTML=rt,Ee=a(),S=n("p"),S.textContent=Mt,Ve=a(),r(P.$$.fragment),Xe=a(),L=n("ul"),L.innerHTML=ct,ge=a(),r(q.$$.fragment),$e=a(),D=n("ul"),D.innerHTML=Jt,We=a(),K=n("p"),K.innerHTML=Tt,He=a(),r(O.$$.fragment),xe=a(),te=n("p"),this.h()},l(e){const t=ft("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(l),le=o(e),ee=i(e,"P",{}),wt(ee).forEach(l),se=o(e),M(y.$$.fragment,e),ae=o(e),M(j.$$.fragment,e),oe=o(e),b=i(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-zkbknq"&&(b.textContent=ke),ne=o(e),m=i(e,"P",{"data-svelte-h":!0}),p(m)!=="svelte-121qa2u"&&(m.textContent=Ye),ie=o(e),f=i(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-rtu37n"&&(f.innerHTML=Qe),pe=o(e),h=i(e,"UL",{"data-svelte-h":!0}),p(h)!=="svelte-1nl3mqe"&&(h.innerHTML=Se),re=o(e),M(U.$$.fragment,e),Me=o(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-i5sp88"&&(I.textContent=Pe),ce=o(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-beme34"&&(v.textContent=Le),Je=o(e),M(A.$$.fragment,e),Te=o(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1uacg6x"&&(C.textContent=qe),we=o(e),_=i(e,"OL",{"data-svelte-h":!0}),p(_)!=="svelte-1q5dwz6"&&(_.innerHTML=De),ue=o(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-zwkq5z"&&(B.textContent=Ke),de=o(e),M(Z.$$.fragment,e),ye=o(e),M(G.$$.fragment,e),je=o(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-113cthv"&&(R.innerHTML=Oe),be=o(e),E=i(e,"UL",{"data-svelte-h":!0}),p(E)!=="svelte-1kdi6lh"&&(E.innerHTML=et),me=o(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1cus9pi"&&(V.innerHTML=tt),fe=o(e),M(X.$$.fragment,e),he=o(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-rtv714"&&(g.innerHTML=lt),Ue=o(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1f03gmf"&&($.innerHTML=st),Ie=o(e),M(W.$$.fragment,e),ve=o(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-v2rcdh"&&(H.textContent=at),Ae=o(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-2wlws6"&&(x.textContent=ot),Ce=o(e),M(N.$$.fragment,e),_e=o(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-14pxkqx"&&(z.textContent=nt),Be=o(e),F=i(e,"UL",{"data-svelte-h":!0}),p(F)!=="svelte-1xxprhi"&&(F.innerHTML=it),Ze=o(e),M(k.$$.fragment,e),Ge=o(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-mdmhp8"&&(Y.textContent=pt),Re=o(e),Q=i(e,"UL",{"data-svelte-h":!0}),p(Q)!=="svelte-1nvqm69"&&(Q.innerHTML=rt),Ee=o(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1t3566s"&&(S.textContent=Mt),Ve=o(e),M(P.$$.fragment,e),Xe=o(e),L=i(e,"UL",{"data-svelte-h":!0}),p(L)!=="svelte-mi45gr"&&(L.innerHTML=ct),ge=o(e),M(q.$$.fragment,e),$e=o(e),D=i(e,"UL",{"data-svelte-h":!0}),p(D)!=="svelte-1yaajmi"&&(D.innerHTML=Jt),We=o(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-18l4o8d"&&(K.innerHTML=Tt),He=o(e),M(O.$$.fragment,e),xe=o(e),te=i(e,"P",{}),wt(te).forEach(l),this.h()},h(){ut(u,"name","hf:doc:metadata"),ut(u,"content",At)},m(e,t){ht(document.head,u),s(e,le,t),s(e,ee,t),s(e,se,t),c(y,e,t),s(e,ae,t),c(j,e,t),s(e,oe,t),s(e,b,t),s(e,ne,t),s(e,m,t),s(e,ie,t),s(e,f,t),s(e,pe,t),s(e,h,t),s(e,re,t),c(U,e,t),s(e,Me,t),s(e,I,t),s(e,ce,t),s(e,v,t),s(e,Je,t),c(A,e,t),s(e,Te,t),s(e,C,t),s(e,we,t),s(e,_,t),s(e,ue,t),s(e,B,t),s(e,de,t),c(Z,e,t),s(e,ye,t),c(G,e,t),s(e,je,t),s(e,R,t),s(e,be,t),s(e,E,t),s(e,me,t),s(e,V,t),s(e,fe,t),c(X,e,t),s(e,he,t),s(e,g,t),s(e,Ue,t),s(e,$,t),s(e,Ie,t),c(W,e,t),s(e,ve,t),s(e,H,t),s(e,Ae,t),s(e,x,t),s(e,Ce,t),c(N,e,t),s(e,_e,t),s(e,z,t),s(e,Be,t),s(e,F,t),s(e,Ze,t),c(k,e,t),s(e,Ge,t),s(e,Y,t),s(e,Re,t),s(e,Q,t),s(e,Ee,t),s(e,S,t),s(e,Ve,t),c(P,e,t),s(e,Xe,t),s(e,L,t),s(e,ge,t),c(q,e,t),s(e,$e,t),s(e,D,t),s(e,We,t),s(e,K,t),s(e,He,t),c(O,e,t),s(e,xe,t),s(e,te,t),Ne=!0},p:yt,i(e){Ne||(J(y.$$.fragment,e),J(j.$$.fragment,e),J(U.$$.fragment,e),J(A.$$.fragment,e),J(Z.$$.fragment,e),J(G.$$.fragment,e),J(X.$$.fragment,e),J(W.$$.fragment,e),J(N.$$.fragment,e),J(k.$$.fragment,e),J(P.$$.fragment,e),J(q.$$.fragment,e),J(O.$$.fragment,e),Ne=!0)},o(e){T(y.$$.fragment,e),T(j.$$.fragment,e),T(U.$$.fragment,e),T(A.$$.fragment,e),T(Z.$$.fragment,e),T(G.$$.fragment,e),T(X.$$.fragment,e),T(W.$$.fragment,e),T(N.$$.fragment,e),T(k.$$.fragment,e),T(P.$$.fragment,e),T(q.$$.fragment,e),T(O.$$.fragment,e),Ne=!1},d(e){e&&(l(le),l(ee),l(se),l(ae),l(oe),l(b),l(ne),l(m),l(ie),l(f),l(pe),l(h),l(re),l(Me),l(I),l(ce),l(v),l(Je),l(Te),l(C),l(we),l(_),l(ue),l(B),l(de),l(ye),l(je),l(R),l(be),l(E),l(me),l(V),l(fe),l(he),l(g),l(Ue),l($),l(Ie),l(ve),l(H),l(Ae),l(x),l(Ce),l(_e),l(z),l(Be),l(F),l(Ze),l(Ge),l(Y),l(Re),l(Q),l(Ee),l(S),l(Ve),l(Xe),l(L),l(ge),l($e),l(D),l(We),l(K),l(He),l(xe),l(te)),l(u),w(y,e),w(j,e),w(U,e),w(A,e),w(Z,e),w(G,e),w(X,e),w(W,e),w(N,e),w(k,e),w(P,e),w(q,e),w(O,e)}}}const At='{"title":"Processors for Robots and Teleoperators","local":"processors-for-robots-and-teleoperators","sections":[{"title":"Absolute vs relative EE control","local":"absolute-vs-relative-ee-control","sections":[],"depth":3},{"title":"Three pipelines","local":"three-pipelines","sections":[],"depth":2},{"title":"Why to_transition / to_output","local":"why-totransition--tooutput","sections":[],"depth":2},{"title":"Dataset feature contracts","local":"dataset-feature-contracts","sections":[],"depth":2},{"title":"Guidance when customizing robot pipelines","local":"guidance-when-customizing-robot-pipelines","sections":[{"title":"Different robots","local":"different-robots","sections":[],"depth":3},{"title":"Safety first","local":"safety-first","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ct(Fe){return jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Et extends bt{constructor(u){super(),mt(this,u,Ct,vt,dt,{})}}export{Et as component};
