# Feetech Motor Firmware Update

This tutorial guides you through updating the firmware of Feetech motors using the official Feetech software.

## Prerequisites

- Windows computer (Feetech software is only available for Windows)
- Feetech motor control board
- USB cable to connect the control board to your computer
- Feetech motors connected to the control board

## Step 1: Download Feetech Software

1. Visit the official Feetech software download page: [https://www.feetechrc.com/software.html](https://www.feetechrc.com/software.html)
2. Download the latest version of the Feetech debugging software (FD)
3. Install the software on your Windows computer

## Step 2: Hardware Setup

1. Connect your Feetech motors to the motor control board
2. Connect the motor control board to your Windows computer via USB cable
3. Ensure power is supplied to the motors

## Step 3: Configure Connection

1. Launch the Feetech debugging software
2. Select the correct COM port from the port dropdown menu
   - If unsure which port to use, check Windows Device Manager under "Ports (COM & LPT)"
3. Set the appropriate baud rate (typically 1000000 for most Feetech motors)
4. Click "Open" to establish communication with the control board

## Step 4: Scan for Motors

1. Once connected, click the "Search" button to detect all connected motors
2. The software will automatically discover and list all motors on the bus
3. Each motor will appear with its ID number

## Step 5: Update Firmware

For each motor you want to update:

1. **Select the motor** from the list by clicking on it
2. **Click on Upgrade tab**:
3. **Click on Online button**:
   - If an potential firmware update is found, it will be displayed in the box
4. **Click on Upgrade button**:
   - The update progress will be displayed

## Step 6: Verify Update

1. After the update completes, the software should automatically refresh the motor information
2. Verify that the firmware version has been updated to the expected version

## Important Notes

⚠️ **Warning**: Do not disconnect power or USB during firmware updates, it will potentially brick the motor.

## Bonus: Motor Debugging on Linux/macOS

For debugging purposes only, you can use the open-source Feetech Debug Tool:

- **Repository**: [FT_SCServo_Debug_Qt](https://github.com/CarolinePascal/FT_SCServo_Debug_Qt/tree/fix/port-search-timer)

### Installation Instructions

Follow the instructions in the repository to install the tool, for Ubuntu you can directly install it, for MacOS you need to build it from source.

**Limitations:**

- This tool is for debugging and parameter adjustment only
- Firmware updates must still be done on Windows with official Feetech software


<EditOnGithub source="https://github.com/huggingface/lerobot/blob/main/docs/source/feetech.mdx" />