import{s as cn,n as un,o as rn}from"../chunks/scheduler.008aaf19.js";import{S as Cn,i as In,e as a,s as n,c as y,h as hn,a as o,d as t,b as M,f as Tn,g as p,j as i,k as u,l as dn,m as e,n as U,t as j,o as J,p as w}from"../chunks/index.7c7f75b2.js";import{C as c}from"../chunks/CodeBlock.027569b9.js";import{H as T,E as mn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.4f0ca956.js";function bn(te){let r,ps,is,Us,B,js,k,ee="The webhook listener is the entry point for our Pull Request Agent. It receives real-time events from the Hugging Face Hub when discussions are created or updated, triggering our MCP-powered tagging workflow. In this section, we’ll implement a webhook handler using FastAPI.",Js,q,ws,v,ne='Following the <a href="https://raw.githubusercontent.com/huggingface/hub-docs/refs/heads/main/docs/hub/webhooks-guide-discussion-bot.md" rel="nofollow">Hugging Face Webhooks Guide</a>, our webhook listener validates incoming requests and processes discussion events in real-time.',Ts,Q,Me='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/001-discussion-bot/webhook-creation.png" alt="Webhook Creation"/>',cs,Z,us,G,ae="Understanding the webhook flow is crucial for building a reliable listener:",rs,E,oe="<li><strong>User Action</strong>: Someone creates a comment in a model repository discussion</li> <li><strong>Hub Event</strong>: Hugging Face generates a webhook event</li> <li><strong>Webhook Delivery</strong>: Hub sends POST request to our endpoint</li> <li><strong>Authentication</strong>: We validate the webhook secret</li> <li><strong>Processing</strong>: Extract tags from the comment content</li> <li><strong>Action</strong>: Use MCP tools to create pull requests for new tags</li>",Cs,C,ie="<p>Webhooks are push notifications - the Hugging Face Hub actively sends events to your application rather than you polling for changes. This enables real-time responses to discussions and comments.</p>",Is,W,hs,N,ye="Let’s build our webhook listener step by step, starting with the foundation and building up to the complete processing logic.",ds,R,ms,S,pe="First, let’s set up the basic FastAPI application with all necessary imports and configuration:",bs,_,As,V,Ue="These imports give us everything we need to build a robust webhook handler. <code>FastAPI</code> provides the web framework, <code>BackgroundTasks</code> enables async processing, and the typing imports help with data validation.",gs,$,je="Now let’s configure our application:",fs,x,Bs,Y,Je="This configuration sets up:",ks,H,we="<li><strong>Webhook secret</strong>: For validating incoming webhooks</li> <li><strong>HF token</strong>: For authenticating with the Hub API</li> <li><strong>Operations store</strong>: In-memory storage for monitoring processed operations</li> <li><strong>CORS middleware</strong>: Allows cross-origin requests for the web interface</li>",qs,I,Te="<p>The <code>tag_operations_store</code> list keeps track of recent webhook processing operations. This is useful for debugging and monitoring, but in production you might want to use a database or limit the size of this list.</p>",vs,X,Qs,z,ce='Based on the <a href="https://raw.githubusercontent.com/huggingface/hub-docs/refs/heads/main/docs/hub/webhooks-guide-discussion-bot.md" rel="nofollow">Hugging Face webhook documentation</a>, we need to understand the webhook data structure:',Zs,F,Gs,L,ue="This Pydantic model helps us understand the webhook structure.",Es,P,re="The key fields we care about are:",Ws,O,Ce="<li><code>event.action</code>: Usually “create” for new comments</li> <li><code>event.scope</code>: Usually “discussion.comment” for comment events</li> <li><code>comment.content</code>: The actual comment text</li> <li><code>repo.name</code>: The repository where the comment was made</li>",Ns,K,Rs,D,Ie="Now for the main webhook handler - this is where the important part happens. Let’s break it down into digestible pieces:",Ss,ll,_s,sl,he="The first step is security validation. We check the <code>X-Webhook-Secret</code> header against our configured secret to ensure the webhook is legitimate.",Vs,h,de="<p>Always validate webhook secrets! Without this check, anyone could send fake webhook requests to your application. The secret acts as a shared password between Hugging Face and your application.</p>",$s,tl,me="Next, let’s parse and validate the webhook data:",xs,el,Ys,nl,be="This parsing step handles potential JSON errors gracefully and validates that we have the expected event structure.",Hs,Ml,Ae="Now for the event filtering logic:",Xs,al,zs,ol,ge="This filtering ensures we only process the events we care about - new discussion comments. We ignore other events like repository creation, model uploads, etc.",Fs,il,fe="We use FastAPI’s <code>background_tasks.add_task()</code> to process the webhook asynchronously. This allows us to return a response quickly (within seconds) while the actual tag processing happens in the background.",Ls,d,Be="<p>Webhook endpoints should respond within 10 seconds, or the sending platform may consider them failed. Using background tasks ensures fast responses while allowing complex processing to happen asynchronously.</p>",Ps,yl,Os,pl,ke="Now let’s implement the core comment processing function that does the actual tag extraction and MCP tool usage:",Ks,Ul,Ds,jl,qe="This initial section extracts all the relevant information from the webhook data. We get both the comment content and discussion title since tags might be mentioned in either place.",lt,Jl,ve="Next, we extract and process the tags:",st,wl,tt,Tl,Qe="We combine tags from both sources and create an operation record for monitoring. This record tracks the progress of each webhook processing operation.",et,m,Ze="<p>Storing operation records is crucial for debugging and monitoring. When something goes wrong, you can look at recent operations to understand what happened and why.</p>",nt,cl,Ge="Now for the MCP agent integration:",Mt,ul,at,rl,Ee="This section handles the core business logic:",ot,Cl,We="<li><strong>Validation</strong>: Ensure we have tags to process and an available agent</li> <li><strong>Processing</strong>: For each tag, create a natural language prompt for the agent</li> <li><strong>Recording</strong>: Store all results for monitoring and debugging</li> <li><strong>Error handling</strong>: Gracefully handle errors for individual tags</li>",it,Il,Ne="The agent prompt is carefully crafted to instruct the AI on exactly what steps to take: check current tags first, then add the new tag if appropriate.",yt,hl,pt,dl,Re="Besides the webhook handler, we need endpoints for monitoring and debugging. Let’s add these essential endpoints:",Ut,ml,jt,bl,Se="The root endpoint provides basic information about your service and its available endpoints.",Jt,Al,wt,gl,_e="The health check endpoint validates that all your components are properly configured. This is essential for production monitoring.",Tt,fl,ct,Bl,Ve="The operations endpoint lets you see recent webhook processing activity, which is invaluable for debugging and monitoring.",ut,b,$e="<p>Health and monitoring endpoints are crucial for production deployments. They help you quickly identify configuration issues and monitor your application’s activity without digging through logs.</p>",rt,kl,Ct,ql,xe="Now that we have our webhook listener ready, let’s configure it on the Hugging Face Hub. This is where we connect our application to real repository events.",It,vl,ht,Ql,Ye='Following the <a href="https://huggingface.co/docs/hub/webhooks-guide-discussion-bot" rel="nofollow">webhook setup guide</a>:',dt,Zl,He='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/001-discussion-bot/webhook-creation.png" alt="Webhook Settings"/>',mt,Gl,Xe='Navigate to your <a href="https://huggingface.co/settings/webhooks" rel="nofollow">Hugging Face Settings</a> and configure:',bt,El,ze="<li><strong>Target Repositories</strong>: Specify which repositories to monitor</li> <li><strong>Webhook URL</strong>: Your deployed application endpoint (e.g., <code>https://your-space.hf.space/webhook</code>)</li> <li><strong>Secret</strong>: Use the same secret from your <code>WEBHOOK_SECRET</code> environment variable</li> <li><strong>Events</strong>: Subscribe to “Community (PR &amp; discussions)” events</li>",At,A,Fe="<p>Start with one or two test repositories before configuring webhooks for many repositories. This lets you validate your application works correctly before scaling up.</p>",gt,Wl,ft,Nl,Le="For Hugging Face Spaces deployment, you’ll need to get your direct URL:",Bt,Rl,Pe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/001-discussion-bot/direct-url.png" alt="Direct URL"/>',kt,Sl,Oe="The process is:",qt,_l,Ke="<li>Click “Embed this Space” in your Space settings</li> <li>Copy the “Direct URL”</li> <li>Append <code>/webhook</code> to create your webhook endpoint</li> <li>Update your webhook configuration with this URL</li>",vt,Vl,De="For example, if your Space URL is <code>https://username-space-name.hf.space</code>, your webhook endpoint would be <code>https://username-space-name.hf.space/webhook</code>.",Qt,$l,ln='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/001-discussion-bot/direct-url.png" alt="Space URL"/>',Zt,xl,Gt,Yl,sn="Testing is crucial before deploying to production. Let’s walk through different testing approaches:",Et,Hl,Wt,Xl,tn="You can test your webhook handler locally using a simple script:",Nt,zl,Rt,Fl,en="This script simulates a real webhook request, allowing you to test your handler without waiting for real events.",St,Ll,_t,Pl,nn="You can also add a simulation endpoint to your FastAPI application for easier testing:",Vt,Ol,$t,Kl,Mn="This endpoint makes it easy to test different scenarios through your application’s interface.",xt,g,an="<p>Simulation endpoints are incredibly useful during development. They let you test different tag combinations and edge cases without creating actual repository discussions.</p>",Yt,Dl,Ht,ls,on="When everything is working correctly, you should see results like the discussion bot example:",Xt,ss,yn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/001-discussion-bot/discussion-result.png" alt="Discussion Result"/>',zt,ts,pn="This screenshot shows a successful webhook processing where the bot creates a pull request in response to a discussion comment.",Ft,es,Lt,ns,Un="With our webhook listener implemented, we now have:",Pt,Ms,jn="<li><strong>Secure webhook validation</strong> following Hugging Face best practices</li> <li><strong>Real-time event processing</strong> with background task handling</li> <li><strong>MCP integration</strong> for intelligent tag management</li> <li><strong>Monitoring and debugging</strong> capabilities</li>",Ot,as,Jn="In the next section, we’ll integrate everything into a complete Pull Request Agent that demonstrates the full workflow from webhook to PR creation.",Kt,f,wn="<p>Always return webhook responses quickly (within 10 seconds) to avoid timeouts. Use background tasks for longer processing operations like MCP tool execution and pull request creation.</p>",Dt,os,le,ys,se;return B=new T({props:{title:"Webhook Listener",local:"webhook-listener",headingTag:"h1"}}),q=new T({props:{title:"Understanding Webhook Integration",local:"understanding-webhook-integration",headingTag:"h2"}}),Z=new T({props:{title:"Webhook Event Flow",local:"webhook-event-flow",headingTag:"h3"}}),W=new T({props:{title:"FastAPI Webhook Application",local:"fastapi-webhook-application",headingTag:"h2"}}),R=new T({props:{title:"1. Application Setup",local:"1-application-setup",headingTag:"h3"}}),_=new c({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBqc29uJTBBZnJvbSUyMGRhdGV0aW1lJTIwaW1wb3J0JTIwZGF0ZXRpbWUlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwTGlzdCUyQyUyMERpY3QlMkMlMjBBbnklMkMlMjBPcHRpb25hbCUwQSUwQWZyb20lMjBmYXN0YXBpJTIwaW1wb3J0JTIwRmFzdEFQSSUyQyUyMFJlcXVlc3QlMkMlMjBCYWNrZ3JvdW5kVGFza3MlMEFmcm9tJTIwZmFzdGFwaS5taWRkbGV3YXJlLmNvcnMlMjBpbXBvcnQlMjBDT1JTTWlkZGxld2FyZSUwQWZyb20lMjBweWRhbnRpYyUyMGltcG9ydCUyMEJhc2VNb2RlbA==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> datetime <span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Any</span>, <span class="hljs-type">Optional</span>

<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> FastAPI, Request, BackgroundTasks
<span class="hljs-keyword">from</span> fastapi.middleware.cors <span class="hljs-keyword">import</span> CORSMiddleware
<span class="hljs-keyword">from</span> pydantic <span class="hljs-keyword">import</span> BaseModel`,wrap:!1}}),x=new c({props:{code:"JTIzJTIwQ29uZmlndXJhdGlvbiUwQVdFQkhPT0tfU0VDUkVUJTIwJTNEJTIwb3MuZ2V0ZW52KCUyMldFQkhPT0tfU0VDUkVUJTIyKSUwQUhGX1RPS0VOJTIwJTNEJTIwb3MuZ2V0ZW52KCUyMkhGX1RPS0VOJTIyKSUwQSUwQSUyMyUyMFNpbXBsZSUyMHN0b3JhZ2UlMjBmb3IlMjBwcm9jZXNzZWQlMjBvcGVyYXRpb25zJTBBdGFnX29wZXJhdGlvbnNfc3RvcmUlM0ElMjBMaXN0JTVCRGljdCU1QnN0ciUyQyUyMEFueSU1RCU1RCUyMCUzRCUyMCU1QiU1RCUwQSUwQWFwcCUyMCUzRCUyMEZhc3RBUEkodGl0bGUlM0QlMjJIRiUyMFRhZ2dpbmclMjBCb3QlMjIpJTBBYXBwLmFkZF9taWRkbGV3YXJlKENPUlNNaWRkbGV3YXJlJTJDJTIwYWxsb3dfb3JpZ2lucyUzRCU1QiUyMiolMjIlNUQp",highlighted:`<span class="hljs-comment"># Configuration</span>
WEBHOOK_SECRET = os.getenv(<span class="hljs-string">&quot;WEBHOOK_SECRET&quot;</span>)
HF_TOKEN = os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)

<span class="hljs-comment"># Simple storage for processed operations</span>
tag_operations_store: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]] = []

app = FastAPI(title=<span class="hljs-string">&quot;HF Tagging Bot&quot;</span>)
app.add_middleware(CORSMiddleware, allow_origins=[<span class="hljs-string">&quot;*&quot;</span>])`,wrap:!1}}),X=new T({props:{title:"2. Webhook Data Models",local:"2-webhook-data-models",headingTag:"h3"}}),F=new c({props:{code:"Y2xhc3MlMjBXZWJob29rRXZlbnQoQmFzZU1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMGV2ZW50JTNBJTIwRGljdCU1QnN0ciUyQyUyMHN0ciU1RCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMENvbnRhaW5zJTIwYWN0aW9uJTIwYW5kJTIwc2NvcGUlMjBpbmZvcm1hdGlvbiUwQSUyMCUyMCUyMCUyMGNvbW1lbnQlM0ElMjBEaWN0JTVCc3RyJTJDJTIwQW55JTVEJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQ29tbWVudCUyMGNvbnRlbnQlMjBhbmQlMjBtZXRhZGF0YSUwQSUyMCUyMCUyMCUyMGRpc2N1c3Npb24lM0ElMjBEaWN0JTVCc3RyJTJDJTIwQW55JTVEJTIwJTIwJTIwJTIwJTIwJTIzJTIwRGlzY3Vzc2lvbiUyMGluZm9ybWF0aW9uJTBBJTIwJTIwJTIwJTIwcmVwbyUzQSUyMERpY3QlNUJzdHIlMkMlMjBzdHIlNUQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBSZXBvc2l0b3J5JTIwZGV0YWlscw==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">WebhookEvent</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
    event: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">str</span>]          <span class="hljs-comment"># Contains action and scope information</span>
    comment: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]        <span class="hljs-comment"># Comment content and metadata</span>
    discussion: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]     <span class="hljs-comment"># Discussion information</span>
    repo: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">str</span>]           <span class="hljs-comment"># Repository details</span>`,wrap:!1}}),K=new T({props:{title:"3. Core Webhook Handler",local:"3-core-webhook-handler",headingTag:"h3"}}),ll=new c({props:{code:"JTQwYXBwLnBvc3QoJTIyJTJGd2ViaG9vayUyMiklMEFhc3luYyUyMGRlZiUyMHdlYmhvb2tfaGFuZGxlcihyZXF1ZXN0JTNBJTIwUmVxdWVzdCUyQyUyMGJhY2tncm91bmRfdGFza3MlM0ElMjBCYWNrZ3JvdW5kVGFza3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwSGFuZGxlJTIwaW5jb21pbmclMjB3ZWJob29rcyUyMGZyb20lMjBIdWdnaW5nJTIwRmFjZSUyMEh1YiUwQSUyMCUyMCUyMCUyMEZvbGxvd2luZyUyMHRoZSUyMHBhdHRlcm4lMjBmcm9tJTNBJTIwaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGaHVnZ2luZ2ZhY2UlMkZodWItZG9jcyUyRnJlZnMlMkZoZWFkcyUyRm1haW4lMkZkb2NzJTJGaHViJTJGd2ViaG9va3MtZ3VpZGUtZGlzY3Vzc2lvbi1ib3QubWQlMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBwcmludCglMjIlRjAlOUYlOTQlOTQlMjBXZWJob29rJTIwcmVjZWl2ZWQhJTIyKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFN0ZXAlMjAxJTNBJTIwVmFsaWRhdGUlMjB3ZWJob29rJTIwc2VjcmV0JTIwKHNlY3VyaXR5KSUwQSUyMCUyMCUyMCUyMHdlYmhvb2tfc2VjcmV0JTIwJTNEJTIwcmVxdWVzdC5oZWFkZXJzLmdldCglMjJYLVdlYmhvb2stU2VjcmV0JTIyKSUwQSUyMCUyMCUyMCUyMGlmJTIwd2ViaG9va19zZWNyZXQlMjAhJTNEJTIwV0VCSE9PS19TRUNSRVQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCglMjIlRTIlOUQlOEMlMjBJbnZhbGlkJTIwd2ViaG9vayUyMHNlY3JldCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJlcnJvciUyMiUzQSUyMCUyMmluY29ycmVjdCUyMHNlY3JldCUyMiU3RCUyQyUyMDQwMA==",highlighted:`<span class="hljs-meta">@app.post(<span class="hljs-params"><span class="hljs-string">&quot;/webhook&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">webhook_handler</span>(<span class="hljs-params">request: Request, background_tasks: BackgroundTasks</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Handle incoming webhooks from Hugging Face Hub
    Following the pattern from: https://raw.githubusercontent.com/huggingface/hub-docs/refs/heads/main/docs/hub/webhooks-guide-discussion-bot.md
    &quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🔔 Webhook received!&quot;</span>)
    
    <span class="hljs-comment"># Step 1: Validate webhook secret (security)</span>
    webhook_secret = request.headers.get(<span class="hljs-string">&quot;X-Webhook-Secret&quot;</span>)
    <span class="hljs-keyword">if</span> webhook_secret != WEBHOOK_SECRET:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;❌ Invalid webhook secret&quot;</span>)
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-string">&quot;incorrect secret&quot;</span>}, <span class="hljs-number">400</span>`,wrap:!1}}),el=new c({props:{code:"JTIwJTIwJTIwJTIwJTIzJTIwU3RlcCUyMDIlM0ElMjBQYXJzZSUyMHdlYmhvb2slMjBkYXRhJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2ViaG9va19kYXRhJTIwJTNEJTIwYXdhaXQlMjByZXF1ZXN0Lmpzb24oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjIlRjAlOUYlOTMlQTUlMjBXZWJob29rJTIwZGF0YSUzQSUyMCU3Qmpzb24uZHVtcHMod2ViaG9va19kYXRhJTJDJTIwaW5kZW50JTNEMiklN0QlMjIpJTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwRXhjZXB0aW9uJTIwYXMlMjBlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVFMiU5RCU4QyUyMEVycm9yJTIwcGFyc2luZyUyMHdlYmhvb2slMjBkYXRhJTNBJTIwJTdCc3RyKGUpJTdEJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmVycm9yJTIyJTNBJTIwJTIyaW52YWxpZCUyMEpTT04lMjIlN0QlMkMlMjA0MDAlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBTdGVwJTIwMyUzQSUyMFZhbGlkYXRlJTIwZXZlbnQlMjBzdHJ1Y3R1cmUlMEElMjAlMjAlMjAlMjBldmVudCUyMCUzRCUyMHdlYmhvb2tfZGF0YS5nZXQoJTIyZXZlbnQlMjIlMkMlMjAlN0IlN0QpJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBldmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCUyMiVFMiU5RCU4QyUyME5vJTIwZXZlbnQlMjBkYXRhJTIwaW4lMjB3ZWJob29rJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmVycm9yJTIyJTNBJTIwJTIybWlzc2luZyUyMGV2ZW50JTIwZGF0YSUyMiU3RCUyQyUyMDQwMA==",highlighted:`    <span class="hljs-comment"># Step 2: Parse webhook data</span>
    <span class="hljs-keyword">try</span>:
        webhook_data = <span class="hljs-keyword">await</span> request.json()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📥 Webhook data: <span class="hljs-subst">{json.dumps(webhook_data, indent=<span class="hljs-number">2</span>)}</span>&quot;</span>)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ Error parsing webhook data: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-string">&quot;invalid JSON&quot;</span>}, <span class="hljs-number">400</span>
    
    <span class="hljs-comment"># Step 3: Validate event structure</span>
    event = webhook_data.get(<span class="hljs-string">&quot;event&quot;</span>, {})
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> event:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;❌ No event data in webhook&quot;</span>)
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-string">&quot;missing event data&quot;</span>}, <span class="hljs-number">400</span>`,wrap:!1}}),al=new c({props:{code:"JTIwJTIwJTIwJTIwJTIzJTIwU3RlcCUyMDQlM0ElMjBDaGVjayUyMGlmJTIwdGhpcyUyMGlzJTIwYSUyMGRpc2N1c3Npb24lMjBjb21tZW50JTIwY3JlYXRpb24lMEElMjAlMjAlMjAlMjAlMjMlMjBGb2xsb3dpbmclMjB0aGUlMjB3ZWJob29rJTIwZ3VpZGUlMjBwYXR0ZXJuJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXZlbnQuZ2V0KCUyMmFjdGlvbiUyMiklMjAlM0QlM0QlMjAlMjJjcmVhdGUlMjIlMjBhbmQlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBldmVudC5nZXQoJTIyc2NvcGUlMjIpJTIwJTNEJTNEJTIwJTIyZGlzY3Vzc2lvbi5jb21tZW50JTIyJTBBJTIwJTIwJTIwJTIwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCUyMiVFMiU5QyU4NSUyMFZhbGlkJTIwZGlzY3Vzc2lvbiUyMGNvbW1lbnQlMjBjcmVhdGlvbiUyMGV2ZW50JTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjBpbiUyMGJhY2tncm91bmQlMjB0byUyMHJldHVybiUyMHF1aWNrbHklMjB0byUyMEh1YiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhY2tncm91bmRfdGFza3MuYWRkX3Rhc2socHJvY2Vzc193ZWJob29rX2NvbW1lbnQlMkMlMjB3ZWJob29rX2RhdGEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhdHVzJTIyJTNBJTIwJTIyYWNjZXB0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtZXNzYWdlJTIyJTNBJTIwJTIyQ29tbWVudCUyMHByb2Nlc3NpbmclMjBzdGFydGVkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGltZXN0YW1wJTIyJTNBJTIwZGF0ZXRpbWUubm93KCkuaXNvZm9ybWF0KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVFMiU4NCVCOSVFRiVCOCU4RiUyMElnbm9yaW5nJTIwZXZlbnQlM0ElMjBhY3Rpb24lM0QlN0JldmVudC5nZXQoJ2FjdGlvbicpJTdEJTJDJTIwc2NvcGUlM0QlN0JldmVudC5nZXQoJ3Njb3BlJyklN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhdHVzJTIyJTNBJTIwJTIyaWdub3JlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlYXNvbiUyMiUzQSUyMCUyMk5vdCUyMGElMjBkaXNjdXNzaW9uJTIwY29tbWVudCUyMGNyZWF0aW9uJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdE",highlighted:`    <span class="hljs-comment"># Step 4: Check if this is a discussion comment creation</span>
    <span class="hljs-comment"># Following the webhook guide pattern:</span>
    <span class="hljs-keyword">if</span> (
        event.get(<span class="hljs-string">&quot;action&quot;</span>) == <span class="hljs-string">&quot;create&quot;</span> <span class="hljs-keyword">and</span> 
        event.get(<span class="hljs-string">&quot;scope&quot;</span>) == <span class="hljs-string">&quot;discussion.comment&quot;</span>
    ):
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Valid discussion comment creation event&quot;</span>)
        
        <span class="hljs-comment"># Process in background to return quickly to Hub</span>
        background_tasks.add_task(process_webhook_comment, webhook_data)
        
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;accepted&quot;</span>,
            <span class="hljs-string">&quot;message&quot;</span>: <span class="hljs-string">&quot;Comment processing started&quot;</span>,
            <span class="hljs-string">&quot;timestamp&quot;</span>: datetime.now().isoformat()
        }
    <span class="hljs-keyword">else</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;ℹ️ Ignoring event: action=<span class="hljs-subst">{event.get(<span class="hljs-string">&#x27;action&#x27;</span>)}</span>, scope=<span class="hljs-subst">{event.get(<span class="hljs-string">&#x27;scope&#x27;</span>)}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;ignored&quot;</span>,
            <span class="hljs-string">&quot;reason&quot;</span>: <span class="hljs-string">&quot;Not a discussion comment creation&quot;</span>
        }`,wrap:!1}}),yl=new T({props:{title:"4. Comment Processing Logic",local:"4-comment-processing-logic",headingTag:"h3"}}),Ul=new c({props:{code:"YXN5bmMlMjBkZWYlMjBwcm9jZXNzX3dlYmhvb2tfY29tbWVudCh3ZWJob29rX2RhdGElM0ElMjBEaWN0JTVCc3RyJTJDJTIwQW55JTVEKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMFByb2Nlc3MlMjB3ZWJob29rJTIwY29tbWVudCUyMHRvJTIwZGV0ZWN0JTIwYW5kJTIwYWRkJTIwdGFncyUwQSUyMCUyMCUyMCUyMEludGVncmF0ZXMlMjB3aXRoJTIwb3VyJTIwTUNQJTIwY2xpZW50JTIwZm9yJTIwSHViJTIwaW50ZXJhY3Rpb25zJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyJUYwJTlGJThGJUI3JUVGJUI4JThGJTIwU3RhcnRpbmclMjBwcm9jZXNzX3dlYmhvb2tfY29tbWVudC4uLiUyMiklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBFeHRyYWN0JTIwY29tbWVudCUyMGFuZCUyMHJlcG9zaXRvcnklMjBpbmZvcm1hdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbW1lbnRfY29udGVudCUyMCUzRCUyMHdlYmhvb2tfZGF0YSU1QiUyMmNvbW1lbnQlMjIlNUQlNUIlMjJjb250ZW50JTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGlzY3Vzc2lvbl90aXRsZSUyMCUzRCUyMHdlYmhvb2tfZGF0YSU1QiUyMmRpc2N1c3Npb24lMjIlNUQlNUIlMjJ0aXRsZSUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9fbmFtZSUyMCUzRCUyMHdlYmhvb2tfZGF0YSU1QiUyMnJlcG8lMjIlNUQlNUIlMjJuYW1lJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGlzY3Vzc2lvbl9udW0lMjAlM0QlMjB3ZWJob29rX2RhdGElNUIlMjJkaXNjdXNzaW9uJTIyJTVEJTVCJTIybnVtJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29tbWVudF9hdXRob3IlMjAlM0QlMjB3ZWJob29rX2RhdGElNUIlMjJjb21tZW50JTIyJTVEJTVCJTIyYXV0aG9yJTIyJTVELmdldCglMjJpZCUyMiUyQyUyMCUyMnVua25vd24lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVGMCU5RiU5MyU5RCUyMENvbW1lbnQlMjBmcm9tJTIwJTdCY29tbWVudF9hdXRob3IlN0QlM0ElMjAlN0Jjb21tZW50X2NvbnRlbnQlN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVGMCU5RiU5MyVCMCUyMERpc2N1c3Npb24lM0ElMjAlN0JkaXNjdXNzaW9uX3RpdGxlJTdEJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjIlRjAlOUYlOTMlQTYlMjBSZXBvc2l0b3J5JTNBJTIwJTdCcmVwb19uYW1lJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">process_webhook_comment</span>(<span class="hljs-params">webhook_data: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Process webhook comment to detect and add tags
    Integrates with our MCP client for Hub interactions
    &quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🏷️ Starting process_webhook_comment...&quot;</span>)
    
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Extract comment and repository information</span>
        comment_content = webhook_data[<span class="hljs-string">&quot;comment&quot;</span>][<span class="hljs-string">&quot;content&quot;</span>]
        discussion_title = webhook_data[<span class="hljs-string">&quot;discussion&quot;</span>][<span class="hljs-string">&quot;title&quot;</span>]
        repo_name = webhook_data[<span class="hljs-string">&quot;repo&quot;</span>][<span class="hljs-string">&quot;name&quot;</span>]
        discussion_num = webhook_data[<span class="hljs-string">&quot;discussion&quot;</span>][<span class="hljs-string">&quot;num&quot;</span>]
        comment_author = webhook_data[<span class="hljs-string">&quot;comment&quot;</span>][<span class="hljs-string">&quot;author&quot;</span>].get(<span class="hljs-string">&quot;id&quot;</span>, <span class="hljs-string">&quot;unknown&quot;</span>)
        
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📝 Comment from <span class="hljs-subst">{comment_author}</span>: <span class="hljs-subst">{comment_content}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📰 Discussion: <span class="hljs-subst">{discussion_title}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📦 Repository: <span class="hljs-subst">{repo_name}</span>&quot;</span>)`,wrap:!1}}),wl=new c({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRXh0cmFjdCUyMHBvdGVudGlhbCUyMHRhZ3MlMjBmcm9tJTIwY29tbWVudCUyMGFuZCUyMHRpdGxlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29tbWVudF90YWdzJTIwJTNEJTIwZXh0cmFjdF90YWdzX2Zyb21fdGV4dChjb21tZW50X2NvbnRlbnQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGVfdGFncyUyMCUzRCUyMGV4dHJhY3RfdGFnc19mcm9tX3RleHQoZGlzY3Vzc2lvbl90aXRsZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhbGxfdGFncyUyMCUzRCUyMGxpc3Qoc2V0KGNvbW1lbnRfdGFncyUyMCUyQiUyMHRpdGxlX3RhZ3MpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjIlRjAlOUYlOTQlOEQlMjBGb3VuZCUyMHRhZ3MlM0ElMjAlN0JhbGxfdGFncyU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTdG9yZSUyMG9wZXJhdGlvbiUyMGZvciUyMG1vbml0b3JpbmclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcGVyYXRpb24lMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjBkYXRldGltZS5ub3coKS5pc29mb3JtYXQoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlcG9fbmFtZSUyMiUzQSUyMHJlcG9fbmFtZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRpc2N1c3Npb25fbnVtJTIyJTNBJTIwZGlzY3Vzc2lvbl9udW0lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb21tZW50X2F1dGhvciUyMiUzQSUyMGNvbW1lbnRfYXV0aG9yJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZXh0cmFjdGVkX3RhZ3MlMjIlM0ElMjBhbGxfdGFncyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbW1lbnRfcHJldmlldyUyMiUzQSUyMGNvbW1lbnRfY29udGVudCU1QiUzQTEwMCU1RCUyMCUyQiUyMCUyMi4uLiUyMiUyMGlmJTIwbGVuKGNvbW1lbnRfY29udGVudCklMjAlM0UlMjAxMDAlMjBlbHNlJTIwY29tbWVudF9jb250ZW50JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhdHVzJTIyJTNBJTIwJTIycHJvY2Vzc2luZyUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhZ19vcGVyYXRpb25zX3N0b3JlLmFwcGVuZChvcGVyYXRpb24p",highlighted:`        <span class="hljs-comment"># Extract potential tags from comment and title</span>
        comment_tags = extract_tags_from_text(comment_content)
        title_tags = extract_tags_from_text(discussion_title)
        all_tags = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(comment_tags + title_tags))
        
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔍 Found tags: <span class="hljs-subst">{all_tags}</span>&quot;</span>)
        
        <span class="hljs-comment"># Store operation for monitoring</span>
        operation = {
            <span class="hljs-string">&quot;timestamp&quot;</span>: datetime.now().isoformat(),
            <span class="hljs-string">&quot;repo_name&quot;</span>: repo_name,
            <span class="hljs-string">&quot;discussion_num&quot;</span>: discussion_num,
            <span class="hljs-string">&quot;comment_author&quot;</span>: comment_author,
            <span class="hljs-string">&quot;extracted_tags&quot;</span>: all_tags,
            <span class="hljs-string">&quot;comment_preview&quot;</span>: comment_content[:<span class="hljs-number">100</span>] + <span class="hljs-string">&quot;...&quot;</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(comment_content) &gt; <span class="hljs-number">100</span> <span class="hljs-keyword">else</span> comment_content,
            <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;processing&quot;</span>
        }
        tag_operations_store.append(operation)`,wrap:!1}}),ul=new c({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBhbGxfdGFncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wZXJhdGlvbiU1QiUyMnN0YXR1cyUyMiU1RCUyMCUzRCUyMCUyMm5vX3RhZ3MlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcGVyYXRpb24lNUIlMjJtZXNzYWdlJTIyJTVEJTIwJTNEJTIwJTIyTm8lMjByZWNvZ25pemFibGUlMjB0YWdzJTIwZm91bmQlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCglMjIlRTIlOUQlOEMlMjBObyUyMHRhZ3MlMjBmb3VuZCUyMHRvJTIwcHJvY2VzcyUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBHZXQlMjBNQ1AlMjBhZ2VudCUyMGZvciUyMHRhZyUyMHByb2Nlc3NpbmclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhZ2VudCUyMCUzRCUyMGF3YWl0JTIwZ2V0X2FnZW50KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMG5vdCUyMGFnZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3BlcmF0aW9uJTVCJTIyc3RhdHVzJTIyJTVEJTIwJTNEJTIwJTIyZXJyb3IlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcGVyYXRpb24lNUIlMjJtZXNzYWdlJTIyJTVEJTIwJTNEJTIwJTIyQWdlbnQlMjBub3QlMjBjb25maWd1cmVkJTIwKG1pc3NpbmclMjBIRl9UT0tFTiklMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCglMjIlRTIlOUQlOEMlMjBObyUyMGFnZW50JTIwYXZhaWxhYmxlJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjBlYWNoJTIwZXh0cmFjdGVkJTIwdGFnJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3BlcmF0aW9uJTVCJTIycmVzdWx0cyUyMiU1RCUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHRhZyUyMGluJTIwYWxsX3RhZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyJUYwJTlGJUE0JTk2JTIwUHJvY2Vzc2luZyUyMHRhZyUyMCclN0J0YWclN0QnJTIwZm9yJTIwcmVwbyUyMCclN0JyZXBvX25hbWUlN0QnJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMENyZWF0ZSUyMHByb21wdCUyMGZvciUyMGFnZW50JTIwdG8lMjBoYW5kbGUlMjB0YWclMjBwcm9jZXNzaW5nJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwZiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEFuYWx5emUlMjB0aGUlMjByZXBvc2l0b3J5JTIwJyU3QnJlcG9fbmFtZSU3RCclMjBhbmQlMjBkZXRlcm1pbmUlMjBpZiUyMHRoZSUyMHRhZyUyMCclN0J0YWclN0QnJTIwc2hvdWxkJTIwYmUlMjBhZGRlZC4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBGaXJzdCUyQyUyMGNoZWNrJTIwdGhlJTIwY3VycmVudCUyMHRhZ3MlMjB1c2luZyUyMGdldF9jdXJyZW50X3RhZ3MuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwSWYlMjAnJTdCdGFnJTdEJyUyMGlzJTIwbm90JTIwYWxyZWFkeSUyMHByZXNlbnQlMjBhbmQlMjBpdCdzJTIwYSUyMHZhbGlkJTIwdGFnJTJDJTIwYWRkJTIwaXQlMjB1c2luZyUyMGFkZF9uZXdfdGFnLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFJlcG9zaXRvcnklM0ElMjAlN0JyZXBvX25hbWUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUYWclMjB0byUyMHByb2Nlc3MlM0ElMjAlN0J0YWclN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBQcm92aWRlJTIwYSUyMGNsZWFyJTIwc3VtbWFyeSUyMG9mJTIwd2hhdCUyMHdhcyUyMGRvbmUuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBhd2FpdCUyMGFnZW50LnJ1bihwcm9tcHQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVGMCU5RiVBNCU5NiUyMEFnZW50JTIwcmVzcG9uc2UlMjBmb3IlMjAnJTdCdGFnJTdEJyUzQSUyMCU3QnJlc3BvbnNlJTdEJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFBhcnNlJTIwcmVzcG9uc2UlMjBhbmQlMjBzdG9yZSUyMHJlc3VsdCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhZ19yZXN1bHQlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YWclMjIlM0ElMjB0YWclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyZXNwb25zZSUyMiUzQSUyMHJlc3BvbnNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGltZXN0YW1wJTIyJTNBJTIwZGF0ZXRpbWUubm93KCkuaXNvZm9ybWF0KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcGVyYXRpb24lNUIlMjJyZXN1bHRzJTIyJTVELmFwcGVuZCh0YWdfcmVzdWx0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4Y2VwdCUyMEV4Y2VwdGlvbiUyMGFzJTIwZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVycm9yX21zZyUyMCUzRCUyMGYlMjIlRTIlOUQlOEMlMjBFcnJvciUyMHByb2Nlc3NpbmclMjB0YWclMjAnJTdCdGFnJTdEJyUzQSUyMCU3QnN0cihlKSU3RCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGVycm9yX21zZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcGVyYXRpb24lNUIlMjJyZXN1bHRzJTIyJTVELmFwcGVuZCglN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YWclMjIlM0ElMjB0YWclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlcnJvciUyMiUzQSUyMHN0cihlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRpbWVzdGFtcCUyMiUzQSUyMGRhdGV0aW1lLm5vdygpLmlzb2Zvcm1hdCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wZXJhdGlvbiU1QiUyMnN0YXR1cyUyMiU1RCUyMCUzRCUyMCUyMmNvbXBsZXRlZCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjIlRTIlOUMlODUlMjBDb21wbGV0ZWQlMjBwcm9jZXNzaW5nJTIwJTdCbGVuKGFsbF90YWdzKSU3RCUyMHRhZ3MlMjIp",highlighted:`        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> all_tags:
            operation[<span class="hljs-string">&quot;status&quot;</span>] = <span class="hljs-string">&quot;no_tags&quot;</span>
            operation[<span class="hljs-string">&quot;message&quot;</span>] = <span class="hljs-string">&quot;No recognizable tags found&quot;</span>
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;❌ No tags found to process&quot;</span>)
            <span class="hljs-keyword">return</span>
        
        <span class="hljs-comment"># Get MCP agent for tag processing</span>
        agent = <span class="hljs-keyword">await</span> get_agent()
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> agent:
            operation[<span class="hljs-string">&quot;status&quot;</span>] = <span class="hljs-string">&quot;error&quot;</span>
            operation[<span class="hljs-string">&quot;message&quot;</span>] = <span class="hljs-string">&quot;Agent not configured (missing HF_TOKEN)&quot;</span>
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;❌ No agent available&quot;</span>)
            <span class="hljs-keyword">return</span>
        
        <span class="hljs-comment"># Process each extracted tag</span>
        operation[<span class="hljs-string">&quot;results&quot;</span>] = []
        <span class="hljs-keyword">for</span> tag <span class="hljs-keyword">in</span> all_tags:
            <span class="hljs-keyword">try</span>:
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🤖 Processing tag &#x27;<span class="hljs-subst">{tag}</span>&#x27; for repo &#x27;<span class="hljs-subst">{repo_name}</span>&#x27;&quot;</span>)
                
                <span class="hljs-comment"># Create prompt for agent to handle tag processing</span>
                prompt = <span class="hljs-string">f&quot;&quot;&quot;
                Analyze the repository &#x27;<span class="hljs-subst">{repo_name}</span>&#x27; and determine if the tag &#x27;<span class="hljs-subst">{tag}</span>&#x27; should be added.
                
                First, check the current tags using get_current_tags.
                If &#x27;<span class="hljs-subst">{tag}</span>&#x27; is not already present and it&#x27;s a valid tag, add it using add_new_tag.
                
                Repository: <span class="hljs-subst">{repo_name}</span>
                Tag to process: <span class="hljs-subst">{tag}</span>
                
                Provide a clear summary of what was done.
                &quot;&quot;&quot;</span>
                
                response = <span class="hljs-keyword">await</span> agent.run(prompt)
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🤖 Agent response for &#x27;<span class="hljs-subst">{tag}</span>&#x27;: <span class="hljs-subst">{response}</span>&quot;</span>)
                
                <span class="hljs-comment"># Parse response and store result</span>
                tag_result = {
                    <span class="hljs-string">&quot;tag&quot;</span>: tag,
                    <span class="hljs-string">&quot;response&quot;</span>: response,
                    <span class="hljs-string">&quot;timestamp&quot;</span>: datetime.now().isoformat()
                }
                operation[<span class="hljs-string">&quot;results&quot;</span>].append(tag_result)
                
            <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
                error_msg = <span class="hljs-string">f&quot;❌ Error processing tag &#x27;<span class="hljs-subst">{tag}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
                <span class="hljs-built_in">print</span>(error_msg)
                operation[<span class="hljs-string">&quot;results&quot;</span>].append({
                    <span class="hljs-string">&quot;tag&quot;</span>: tag,
                    <span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-built_in">str</span>(e),
                    <span class="hljs-string">&quot;timestamp&quot;</span>: datetime.now().isoformat()
                })
        
        operation[<span class="hljs-string">&quot;status&quot;</span>] = <span class="hljs-string">&quot;completed&quot;</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ Completed processing <span class="hljs-subst">{<span class="hljs-built_in">len</span>(all_tags)}</span> tags&quot;</span>)`,wrap:!1}}),hl=new T({props:{title:"5. Health and Monitoring Endpoints",local:"5-health-and-monitoring-endpoints",headingTag:"h3"}}),ml=new c({props:{code:"JTQwYXBwLmdldCglMjIlMkYlMjIpJTBBYXN5bmMlMjBkZWYlMjByb290KCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJSb290JTIwZW5kcG9pbnQlMjB3aXRoJTIwYmFzaWMlMjBpbmZvcm1hdGlvbiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJIRiUyMFRhZ2dpbmclMjBCb3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGF0dXMlMjIlM0ElMjAlMjJydW5uaW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJXZWJob29rJTIwbGlzdGVuZXIlMjBmb3IlMjBhdXRvbWF0aWMlMjBtb2RlbCUyMHRhZ2dpbmclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmRwb2ludHMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3ZWJob29rJTIyJTNBJTIwJTIyJTJGd2ViaG9vayUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlYWx0aCUyMiUzQSUyMCUyMiUyRmhlYWx0aCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm9wZXJhdGlvbnMlMjIlM0ElMjAlMjIlMkZvcGVyYXRpb25zJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdE",highlighted:`<span class="hljs-meta">@app.get(<span class="hljs-params"><span class="hljs-string">&quot;/&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">root</span>():
    <span class="hljs-string">&quot;&quot;&quot;Root endpoint with basic information&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;HF Tagging Bot&quot;</span>,
        <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;running&quot;</span>,
        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Webhook listener for automatic model tagging&quot;</span>,
        <span class="hljs-string">&quot;endpoints&quot;</span>: {
            <span class="hljs-string">&quot;webhook&quot;</span>: <span class="hljs-string">&quot;/webhook&quot;</span>,
            <span class="hljs-string">&quot;health&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
            <span class="hljs-string">&quot;operations&quot;</span>: <span class="hljs-string">&quot;/operations&quot;</span>
        }
    }`,wrap:!1}}),Al=new c({props:{code:"JTQwYXBwLmdldCglMjIlMkZoZWFsdGglMjIpJTBBYXN5bmMlMjBkZWYlMjBoZWFsdGhfY2hlY2soKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkhlYWx0aCUyMGNoZWNrJTIwZW5kcG9pbnQlMjBmb3IlMjBtb25pdG9yaW5nJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBhd2FpdCUyMGdldF9hZ2VudCgpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhdHVzJTIyJTNBJTIwJTIyaGVhbHRoeSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRpbWVzdGFtcCUyMiUzQSUyMGRhdGV0aW1lLm5vdygpLmlzb2Zvcm1hdCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29tcG9uZW50cyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMndlYmhvb2tfc2VjcmV0JTIyJTNBJTIwJTIyY29uZmlndXJlZCUyMiUyMGlmJTIwV0VCSE9PS19TRUNSRVQlMjBlbHNlJTIwJTIybWlzc2luZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhmX3Rva2VuJTIyJTNBJTIwJTIyY29uZmlndXJlZCUyMiUyMGlmJTIwSEZfVE9LRU4lMjBlbHNlJTIwJTIybWlzc2luZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1jcF9hZ2VudCUyMiUzQSUyMCUyMnJlYWR5JTIyJTIwaWYlMjBhZ2VudCUyMGVsc2UlMjAlMjJub3RfcmVhZHklMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0Q=",highlighted:`<span class="hljs-meta">@app.get(<span class="hljs-params"><span class="hljs-string">&quot;/health&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">health_check</span>():
    <span class="hljs-string">&quot;&quot;&quot;Health check endpoint for monitoring&quot;&quot;&quot;</span>
    agent = <span class="hljs-keyword">await</span> get_agent()
    
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;healthy&quot;</span>,
        <span class="hljs-string">&quot;timestamp&quot;</span>: datetime.now().isoformat(),
        <span class="hljs-string">&quot;components&quot;</span>: {
            <span class="hljs-string">&quot;webhook_secret&quot;</span>: <span class="hljs-string">&quot;configured&quot;</span> <span class="hljs-keyword">if</span> WEBHOOK_SECRET <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;missing&quot;</span>,
            <span class="hljs-string">&quot;hf_token&quot;</span>: <span class="hljs-string">&quot;configured&quot;</span> <span class="hljs-keyword">if</span> HF_TOKEN <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;missing&quot;</span>,
            <span class="hljs-string">&quot;mcp_agent&quot;</span>: <span class="hljs-string">&quot;ready&quot;</span> <span class="hljs-keyword">if</span> agent <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;not_ready&quot;</span>
        }
    }`,wrap:!1}}),fl=new c({props:{code:"JTQwYXBwLmdldCglMjIlMkZvcGVyYXRpb25zJTIyKSUwQWFzeW5jJTIwZGVmJTIwZ2V0X29wZXJhdGlvbnMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkdldCUyMHJlY2VudCUyMHRhZyUyMG9wZXJhdGlvbnMlMjBmb3IlMjBtb25pdG9yaW5nJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIzJTIwUmV0dXJuJTIwbGFzdCUyMDUwJTIwb3BlcmF0aW9ucyUwQSUyMCUyMCUyMCUyMHJlY2VudF9vcHMlMjAlM0QlMjB0YWdfb3BlcmF0aW9uc19zdG9yZSU1Qi01MCUzQSU1RCUyMGlmJTIwdGFnX29wZXJhdGlvbnNfc3RvcmUlMjBlbHNlJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydG90YWxfb3BlcmF0aW9ucyUyMiUzQSUyMGxlbih0YWdfb3BlcmF0aW9uc19zdG9yZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyZWNlbnRfb3BlcmF0aW9ucyUyMiUzQSUyMHJlY2VudF9vcHMlMEElMjAlMjAlMjAlMjAlN0Q=",highlighted:`<span class="hljs-meta">@app.get(<span class="hljs-params"><span class="hljs-string">&quot;/operations&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_operations</span>():
    <span class="hljs-string">&quot;&quot;&quot;Get recent tag operations for monitoring&quot;&quot;&quot;</span>
    <span class="hljs-comment"># Return last 50 operations</span>
    recent_ops = tag_operations_store[-<span class="hljs-number">50</span>:] <span class="hljs-keyword">if</span> tag_operations_store <span class="hljs-keyword">else</span> []
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;total_operations&quot;</span>: <span class="hljs-built_in">len</span>(tag_operations_store),
        <span class="hljs-string">&quot;recent_operations&quot;</span>: recent_ops
    }`,wrap:!1}}),kl=new T({props:{title:"Webhook Configuration on Hugging Face Hub",local:"webhook-configuration-on-hugging-face-hub",headingTag:"h2"}}),vl=new T({props:{title:"1. Create Webhook in Settings",local:"1-create-webhook-in-settings",headingTag:"h3"}}),Wl=new T({props:{title:"2. Space URL Configuration",local:"2-space-url-configuration",headingTag:"h3"}}),xl=new T({props:{title:"Testing the Webhook Listener",local:"testing-the-webhook-listener",headingTag:"h2"}}),Hl=new T({props:{title:"1. Local Testing",local:"1-local-testing",headingTag:"h3"}}),zl=new c({props:{code:"JTIzJTIwdGVzdF93ZWJob29rX2xvY2FsLnB5JTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjBqc29uJTBBJTBBJTIzJTIwVGVzdCUyMGRhdGElMjBtYXRjaGluZyUyMHdlYmhvb2slMjBmb3JtYXQlMEF0ZXN0X3dlYmhvb2tfZGF0YSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmV2ZW50JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWN0aW9uJTIyJTNBJTIwJTIyY3JlYXRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2NvcGUlMjIlM0ElMjAlMjJkaXNjdXNzaW9uLmNvbW1lbnQlMjIlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJjb21tZW50JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMlRoaXMlMjBtb2RlbCUyMG5lZWRzJTIwdGFncyUzQSUyMHB5dG9yY2glMkMlMjB0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdXRob3IlMjIlM0ElMjAlN0IlMjJpZCUyMiUzQSUyMCUyMnRlc3QtdXNlciUyMiU3RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmRpc2N1c3Npb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0aXRsZSUyMiUzQSUyMCUyMk1pc3NpbmclMjB0YWdzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybnVtJTIyJTNBJTIwMSUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlcG8lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIydGVzdC11c2VyJTJGdGVzdC1tb2RlbCUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RCUwQSUwQSUyMyUyMFNlbmQlMjB0ZXN0JTIwd2ViaG9vayUwQXJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMucG9zdCglMEElMjAlMjAlMjAlMjAlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBODAwMCUyRndlYmhvb2slMjIlMkMlMEElMjAlMjAlMjAlMjBqc29uJTNEdGVzdF93ZWJob29rX2RhdGElMkMlMEElMjAlMjAlMjAlMjBoZWFkZXJzJTNEJTdCJTIyWC1XZWJob29rLVNlY3JldCUyMiUzQSUyMCUyMnlvdXItdGVzdC1zZWNyZXQlMjIlN0QlMEEpJTBBJTBBcHJpbnQoZiUyMlN0YXR1cyUzQSUyMCU3QnJlc3BvbnNlLnN0YXR1c19jb2RlJTdEJTIyKSUwQXByaW50KGYlMjJSZXNwb25zZSUzQSUyMCU3QnJlc3BvbnNlLmpzb24oKSU3RCUyMik=",highlighted:`<span class="hljs-comment"># test_webhook_local.py</span>
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> json

<span class="hljs-comment"># Test data matching webhook format</span>
test_webhook_data = {
    <span class="hljs-string">&quot;event&quot;</span>: {
        <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;create&quot;</span>,
        <span class="hljs-string">&quot;scope&quot;</span>: <span class="hljs-string">&quot;discussion.comment&quot;</span>
    },
    <span class="hljs-string">&quot;comment&quot;</span>: {
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;This model needs tags: pytorch, transformers&quot;</span>,
        <span class="hljs-string">&quot;author&quot;</span>: {<span class="hljs-string">&quot;id&quot;</span>: <span class="hljs-string">&quot;test-user&quot;</span>}
    },
    <span class="hljs-string">&quot;discussion&quot;</span>: {
        <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Missing tags&quot;</span>,
        <span class="hljs-string">&quot;num&quot;</span>: <span class="hljs-number">1</span>
    },
    <span class="hljs-string">&quot;repo&quot;</span>: {
        <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;test-user/test-model&quot;</span>
    }
}

<span class="hljs-comment"># Send test webhook</span>
response = requests.post(
    <span class="hljs-string">&quot;http://localhost:8000/webhook&quot;</span>,
    json=test_webhook_data,
    headers={<span class="hljs-string">&quot;X-Webhook-Secret&quot;</span>: <span class="hljs-string">&quot;your-test-secret&quot;</span>}
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Status: <span class="hljs-subst">{response.status_code}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Response: <span class="hljs-subst">{response.json()}</span>&quot;</span>)`,wrap:!1}}),Ll=new T({props:{title:"2. Simulation Endpoint for Development",local:"2-simulation-endpoint-for-development",headingTag:"h3"}}),Ol=new c({props:{code:"JTQwYXBwLnBvc3QoJTIyJTJGc2ltdWxhdGVfd2ViaG9vayUyMiklMEFhc3luYyUyMGRlZiUyMHNpbXVsYXRlX3dlYmhvb2soJTBBJTIwJTIwJTIwJTIwcmVwb19uYW1lJTNBJTIwc3RyJTJDJTIwJTBBJTIwJTIwJTIwJTIwZGlzY3Vzc2lvbl90aXRsZSUzQSUyMHN0ciUyQyUyMCUwQSUyMCUyMCUyMCUyMGNvbW1lbnRfY29udGVudCUzQSUyMHN0ciUwQSklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyU2ltdWxhdGUlMjB3ZWJob29rJTIwZm9yJTIwdGVzdGluZyUyMHB1cnBvc2VzJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ3JlYXRlJTIwbW9jayUyMHdlYmhvb2slMjBkYXRhJTBBJTIwJTIwJTIwJTIwbW9ja193ZWJob29rX2RhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJldmVudCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmFjdGlvbiUyMiUzQSUyMCUyMmNyZWF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNjb3BlJTIyJTNBJTIwJTIyZGlzY3Vzc2lvbi5jb21tZW50JTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29tbWVudCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjBjb21tZW50X2NvbnRlbnQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdXRob3IlMjIlM0ElMjAlN0IlMjJpZCUyMiUzQSUyMCUyMnRlc3QtdXNlciUyMiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRpc2N1c3Npb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0aXRsZSUyMiUzQSUyMGRpc2N1c3Npb25fdGl0bGUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJudW0lMjIlM0ElMjA5OTklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyZXBvJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybmFtZSUyMiUzQSUyMHJlcG9fbmFtZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjB0aGUlMjBzaW11bGF0ZWQlMjB3ZWJob29rJTBBJTIwJTIwJTIwJTIwYXdhaXQlMjBwcm9jZXNzX3dlYmhvb2tfY29tbWVudChtb2NrX3dlYmhvb2tfZGF0YSklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBmJTIyU2ltdWxhdGVkJTIwd2ViaG9vayUyMHByb2Nlc3NlZCUyMGZvciUyMCU3QnJlcG9fbmFtZSU3RCUyMg==",highlighted:`<span class="hljs-meta">@app.post(<span class="hljs-params"><span class="hljs-string">&quot;/simulate_webhook&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">simulate_webhook</span>(<span class="hljs-params">
    repo_name: <span class="hljs-built_in">str</span>, 
    discussion_title: <span class="hljs-built_in">str</span>, 
    comment_content: <span class="hljs-built_in">str</span>
</span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Simulate webhook for testing purposes&quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Create mock webhook data</span>
    mock_webhook_data = {
        <span class="hljs-string">&quot;event&quot;</span>: {
            <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;create&quot;</span>,
            <span class="hljs-string">&quot;scope&quot;</span>: <span class="hljs-string">&quot;discussion.comment&quot;</span>
        },
        <span class="hljs-string">&quot;comment&quot;</span>: {
            <span class="hljs-string">&quot;content&quot;</span>: comment_content,
            <span class="hljs-string">&quot;author&quot;</span>: {<span class="hljs-string">&quot;id&quot;</span>: <span class="hljs-string">&quot;test-user&quot;</span>}
        },
        <span class="hljs-string">&quot;discussion&quot;</span>: {
            <span class="hljs-string">&quot;title&quot;</span>: discussion_title,
            <span class="hljs-string">&quot;num&quot;</span>: <span class="hljs-number">999</span>
        },
        <span class="hljs-string">&quot;repo&quot;</span>: {
            <span class="hljs-string">&quot;name&quot;</span>: repo_name
        }
    }
    
    <span class="hljs-comment"># Process the simulated webhook</span>
    <span class="hljs-keyword">await</span> process_webhook_comment(mock_webhook_data)
    
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Simulated webhook processed for <span class="hljs-subst">{repo_name}</span>&quot;</span>`,wrap:!1}}),Dl=new T({props:{title:"Expected Webhook Result",local:"expected-webhook-result",headingTag:"h2"}}),es=new T({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),os=new mn({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit3_1/webhook-listener.mdx"}}),{c(){r=a("meta"),ps=n(),is=a("p"),Us=n(),y(B.$$.fragment),js=n(),k=a("p"),k.textContent=ee,Js=n(),y(q.$$.fragment),ws=n(),v=a("p"),v.innerHTML=ne,Ts=n(),Q=a("p"),Q.innerHTML=Me,cs=n(),y(Z.$$.fragment),us=n(),G=a("p"),G.textContent=ae,rs=n(),E=a("ol"),E.innerHTML=oe,Cs=n(),C=a("blockquote"),C.innerHTML=ie,Is=n(),y(W.$$.fragment),hs=n(),N=a("p"),N.textContent=ye,ds=n(),y(R.$$.fragment),ms=n(),S=a("p"),S.textContent=pe,bs=n(),y(_.$$.fragment),As=n(),V=a("p"),V.innerHTML=Ue,gs=n(),$=a("p"),$.textContent=je,fs=n(),y(x.$$.fragment),Bs=n(),Y=a("p"),Y.textContent=Je,ks=n(),H=a("ul"),H.innerHTML=we,qs=n(),I=a("blockquote"),I.innerHTML=Te,vs=n(),y(X.$$.fragment),Qs=n(),z=a("p"),z.innerHTML=ce,Zs=n(),y(F.$$.fragment),Gs=n(),L=a("p"),L.textContent=ue,Es=n(),P=a("p"),P.textContent=re,Ws=n(),O=a("ul"),O.innerHTML=Ce,Ns=n(),y(K.$$.fragment),Rs=n(),D=a("p"),D.textContent=Ie,Ss=n(),y(ll.$$.fragment),_s=n(),sl=a("p"),sl.innerHTML=he,Vs=n(),h=a("blockquote"),h.innerHTML=de,$s=n(),tl=a("p"),tl.textContent=me,xs=n(),y(el.$$.fragment),Ys=n(),nl=a("p"),nl.textContent=be,Hs=n(),Ml=a("p"),Ml.textContent=Ae,Xs=n(),y(al.$$.fragment),zs=n(),ol=a("p"),ol.textContent=ge,Fs=n(),il=a("p"),il.innerHTML=fe,Ls=n(),d=a("blockquote"),d.innerHTML=Be,Ps=n(),y(yl.$$.fragment),Os=n(),pl=a("p"),pl.textContent=ke,Ks=n(),y(Ul.$$.fragment),Ds=n(),jl=a("p"),jl.textContent=qe,lt=n(),Jl=a("p"),Jl.textContent=ve,st=n(),y(wl.$$.fragment),tt=n(),Tl=a("p"),Tl.textContent=Qe,et=n(),m=a("blockquote"),m.innerHTML=Ze,nt=n(),cl=a("p"),cl.textContent=Ge,Mt=n(),y(ul.$$.fragment),at=n(),rl=a("p"),rl.textContent=Ee,ot=n(),Cl=a("ol"),Cl.innerHTML=We,it=n(),Il=a("p"),Il.textContent=Ne,yt=n(),y(hl.$$.fragment),pt=n(),dl=a("p"),dl.textContent=Re,Ut=n(),y(ml.$$.fragment),jt=n(),bl=a("p"),bl.textContent=Se,Jt=n(),y(Al.$$.fragment),wt=n(),gl=a("p"),gl.textContent=_e,Tt=n(),y(fl.$$.fragment),ct=n(),Bl=a("p"),Bl.textContent=Ve,ut=n(),b=a("blockquote"),b.innerHTML=$e,rt=n(),y(kl.$$.fragment),Ct=n(),ql=a("p"),ql.textContent=xe,It=n(),y(vl.$$.fragment),ht=n(),Ql=a("p"),Ql.innerHTML=Ye,dt=n(),Zl=a("p"),Zl.innerHTML=He,mt=n(),Gl=a("p"),Gl.innerHTML=Xe,bt=n(),El=a("ol"),El.innerHTML=ze,At=n(),A=a("blockquote"),A.innerHTML=Fe,gt=n(),y(Wl.$$.fragment),ft=n(),Nl=a("p"),Nl.textContent=Le,Bt=n(),Rl=a("p"),Rl.innerHTML=Pe,kt=n(),Sl=a("p"),Sl.textContent=Oe,qt=n(),_l=a("ol"),_l.innerHTML=Ke,vt=n(),Vl=a("p"),Vl.innerHTML=De,Qt=n(),$l=a("p"),$l.innerHTML=ln,Zt=n(),y(xl.$$.fragment),Gt=n(),Yl=a("p"),Yl.textContent=sn,Et=n(),y(Hl.$$.fragment),Wt=n(),Xl=a("p"),Xl.textContent=tn,Nt=n(),y(zl.$$.fragment),Rt=n(),Fl=a("p"),Fl.textContent=en,St=n(),y(Ll.$$.fragment),_t=n(),Pl=a("p"),Pl.textContent=nn,Vt=n(),y(Ol.$$.fragment),$t=n(),Kl=a("p"),Kl.textContent=Mn,xt=n(),g=a("blockquote"),g.innerHTML=an,Yt=n(),y(Dl.$$.fragment),Ht=n(),ls=a("p"),ls.textContent=on,Xt=n(),ss=a("p"),ss.innerHTML=yn,zt=n(),ts=a("p"),ts.textContent=pn,Ft=n(),y(es.$$.fragment),Lt=n(),ns=a("p"),ns.textContent=Un,Pt=n(),Ms=a("ol"),Ms.innerHTML=jn,Ot=n(),as=a("p"),as.textContent=Jn,Kt=n(),f=a("blockquote"),f.innerHTML=wn,Dt=n(),y(os.$$.fragment),le=n(),ys=a("p"),this.h()},l(l){const s=hn("svelte-u9bgzb",document.head);r=o(s,"META",{name:!0,content:!0}),s.forEach(t),ps=M(l),is=o(l,"P",{}),Tn(is).forEach(t),Us=M(l),p(B.$$.fragment,l),js=M(l),k=o(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1eub5er"&&(k.textContent=ee),Js=M(l),p(q.$$.fragment,l),ws=M(l),v=o(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-zs6gis"&&(v.innerHTML=ne),Ts=M(l),Q=o(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-2dzniq"&&(Q.innerHTML=Me),cs=M(l),p(Z.$$.fragment,l),us=M(l),G=o(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1uwf7f3"&&(G.textContent=ae),rs=M(l),E=o(l,"OL",{"data-svelte-h":!0}),i(E)!=="svelte-1la2ai8"&&(E.innerHTML=oe),Cs=M(l),C=o(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(C)!=="svelte-25s9sz"&&(C.innerHTML=ie),Is=M(l),p(W.$$.fragment,l),hs=M(l),N=o(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-30xlox"&&(N.textContent=ye),ds=M(l),p(R.$$.fragment,l),ms=M(l),S=o(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1yn5m8w"&&(S.textContent=pe),bs=M(l),p(_.$$.fragment,l),As=M(l),V=o(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-zzzhss"&&(V.innerHTML=Ue),gs=M(l),$=o(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-jud5zz"&&($.textContent=je),fs=M(l),p(x.$$.fragment,l),Bs=M(l),Y=o(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-10dhypi"&&(Y.textContent=Je),ks=M(l),H=o(l,"UL",{"data-svelte-h":!0}),i(H)!=="svelte-1m8npcg"&&(H.innerHTML=we),qs=M(l),I=o(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(I)!=="svelte-nifn3p"&&(I.innerHTML=Te),vs=M(l),p(X.$$.fragment,l),Qs=M(l),z=o(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1gq8l98"&&(z.innerHTML=ce),Zs=M(l),p(F.$$.fragment,l),Gs=M(l),L=o(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-11rd4l8"&&(L.textContent=ue),Es=M(l),P=o(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-7jxndb"&&(P.textContent=re),Ws=M(l),O=o(l,"UL",{"data-svelte-h":!0}),i(O)!=="svelte-yb9adx"&&(O.innerHTML=Ce),Ns=M(l),p(K.$$.fragment,l),Rs=M(l),D=o(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-8wi0lp"&&(D.textContent=Ie),Ss=M(l),p(ll.$$.fragment,l),_s=M(l),sl=o(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-gioszz"&&(sl.innerHTML=he),Vs=M(l),h=o(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(h)!=="svelte-1281x5r"&&(h.innerHTML=de),$s=M(l),tl=o(l,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-1cgryry"&&(tl.textContent=me),xs=M(l),p(el.$$.fragment,l),Ys=M(l),nl=o(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-fw492h"&&(nl.textContent=be),Hs=M(l),Ml=o(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-1886e9a"&&(Ml.textContent=Ae),Xs=M(l),p(al.$$.fragment,l),zs=M(l),ol=o(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-1f6564z"&&(ol.textContent=ge),Fs=M(l),il=o(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-hn7yve"&&(il.innerHTML=fe),Ls=M(l),d=o(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(d)!=="svelte-1jbsjtp"&&(d.innerHTML=Be),Ps=M(l),p(yl.$$.fragment,l),Os=M(l),pl=o(l,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-1noq05c"&&(pl.textContent=ke),Ks=M(l),p(Ul.$$.fragment,l),Ds=M(l),jl=o(l,"P",{"data-svelte-h":!0}),i(jl)!=="svelte-olpz7c"&&(jl.textContent=qe),lt=M(l),Jl=o(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-th5ate"&&(Jl.textContent=ve),st=M(l),p(wl.$$.fragment,l),tt=M(l),Tl=o(l,"P",{"data-svelte-h":!0}),i(Tl)!=="svelte-6ke5ju"&&(Tl.textContent=Qe),et=M(l),m=o(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(m)!=="svelte-cm9hxh"&&(m.innerHTML=Ze),nt=M(l),cl=o(l,"P",{"data-svelte-h":!0}),i(cl)!=="svelte-7cat8p"&&(cl.textContent=Ge),Mt=M(l),p(ul.$$.fragment,l),at=M(l),rl=o(l,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-evqnic"&&(rl.textContent=Ee),ot=M(l),Cl=o(l,"OL",{"data-svelte-h":!0}),i(Cl)!=="svelte-18uz71w"&&(Cl.innerHTML=We),it=M(l),Il=o(l,"P",{"data-svelte-h":!0}),i(Il)!=="svelte-j0txlt"&&(Il.textContent=Ne),yt=M(l),p(hl.$$.fragment,l),pt=M(l),dl=o(l,"P",{"data-svelte-h":!0}),i(dl)!=="svelte-1lqb59s"&&(dl.textContent=Re),Ut=M(l),p(ml.$$.fragment,l),jt=M(l),bl=o(l,"P",{"data-svelte-h":!0}),i(bl)!=="svelte-a05cab"&&(bl.textContent=Se),Jt=M(l),p(Al.$$.fragment,l),wt=M(l),gl=o(l,"P",{"data-svelte-h":!0}),i(gl)!=="svelte-byt3a9"&&(gl.textContent=_e),Tt=M(l),p(fl.$$.fragment,l),ct=M(l),Bl=o(l,"P",{"data-svelte-h":!0}),i(Bl)!=="svelte-naqt2m"&&(Bl.textContent=Ve),ut=M(l),b=o(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(b)!=="svelte-12udw77"&&(b.innerHTML=$e),rt=M(l),p(kl.$$.fragment,l),Ct=M(l),ql=o(l,"P",{"data-svelte-h":!0}),i(ql)!=="svelte-1g1oryt"&&(ql.textContent=xe),It=M(l),p(vl.$$.fragment,l),ht=M(l),Ql=o(l,"P",{"data-svelte-h":!0}),i(Ql)!=="svelte-5kl7kx"&&(Ql.innerHTML=Ye),dt=M(l),Zl=o(l,"P",{"data-svelte-h":!0}),i(Zl)!=="svelte-1d7h7y6"&&(Zl.innerHTML=He),mt=M(l),Gl=o(l,"P",{"data-svelte-h":!0}),i(Gl)!=="svelte-1na9glc"&&(Gl.innerHTML=Xe),bt=M(l),El=o(l,"OL",{"data-svelte-h":!0}),i(El)!=="svelte-bjboxn"&&(El.innerHTML=ze),At=M(l),A=o(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(A)!=="svelte-fs6up2"&&(A.innerHTML=Fe),gt=M(l),p(Wl.$$.fragment,l),ft=M(l),Nl=o(l,"P",{"data-svelte-h":!0}),i(Nl)!=="svelte-1hzpj89"&&(Nl.textContent=Le),Bt=M(l),Rl=o(l,"P",{"data-svelte-h":!0}),i(Rl)!=="svelte-sqnb9c"&&(Rl.innerHTML=Pe),kt=M(l),Sl=o(l,"P",{"data-svelte-h":!0}),i(Sl)!=="svelte-17xbyqk"&&(Sl.textContent=Oe),qt=M(l),_l=o(l,"OL",{"data-svelte-h":!0}),i(_l)!=="svelte-1nylw4h"&&(_l.innerHTML=Ke),vt=M(l),Vl=o(l,"P",{"data-svelte-h":!0}),i(Vl)!=="svelte-2jg831"&&(Vl.innerHTML=De),Qt=M(l),$l=o(l,"P",{"data-svelte-h":!0}),i($l)!=="svelte-1kndn4n"&&($l.innerHTML=ln),Zt=M(l),p(xl.$$.fragment,l),Gt=M(l),Yl=o(l,"P",{"data-svelte-h":!0}),i(Yl)!=="svelte-30xatb"&&(Yl.textContent=sn),Et=M(l),p(Hl.$$.fragment,l),Wt=M(l),Xl=o(l,"P",{"data-svelte-h":!0}),i(Xl)!=="svelte-7r07br"&&(Xl.textContent=tn),Nt=M(l),p(zl.$$.fragment,l),Rt=M(l),Fl=o(l,"P",{"data-svelte-h":!0}),i(Fl)!=="svelte-1f6yjhi"&&(Fl.textContent=en),St=M(l),p(Ll.$$.fragment,l),_t=M(l),Pl=o(l,"P",{"data-svelte-h":!0}),i(Pl)!=="svelte-z9njw6"&&(Pl.textContent=nn),Vt=M(l),p(Ol.$$.fragment,l),$t=M(l),Kl=o(l,"P",{"data-svelte-h":!0}),i(Kl)!=="svelte-1h392h7"&&(Kl.textContent=Mn),xt=M(l),g=o(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(g)!=="svelte-2zrpyr"&&(g.innerHTML=an),Yt=M(l),p(Dl.$$.fragment,l),Ht=M(l),ls=o(l,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-141mla5"&&(ls.textContent=on),Xt=M(l),ss=o(l,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-18qs3uu"&&(ss.innerHTML=yn),zt=M(l),ts=o(l,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-sir06v"&&(ts.textContent=pn),Ft=M(l),p(es.$$.fragment,l),Lt=M(l),ns=o(l,"P",{"data-svelte-h":!0}),i(ns)!=="svelte-jm8el5"&&(ns.textContent=Un),Pt=M(l),Ms=o(l,"OL",{"data-svelte-h":!0}),i(Ms)!=="svelte-oytvxt"&&(Ms.innerHTML=jn),Ot=M(l),as=o(l,"P",{"data-svelte-h":!0}),i(as)!=="svelte-1y29lx8"&&(as.textContent=Jn),Kt=M(l),f=o(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(f)!=="svelte-1pqsgvc"&&(f.innerHTML=wn),Dt=M(l),p(os.$$.fragment,l),le=M(l),ys=o(l,"P",{}),Tn(ys).forEach(t),this.h()},h(){u(r,"name","hf:doc:metadata"),u(r,"content",An),u(C,"class","tip"),u(I,"class","tip"),u(h,"class","tip"),u(d,"class","tip"),u(m,"class","tip"),u(b,"class","tip"),u(A,"class","tip"),u(g,"class","tip"),u(f,"class","tip")},m(l,s){dn(document.head,r),e(l,ps,s),e(l,is,s),e(l,Us,s),U(B,l,s),e(l,js,s),e(l,k,s),e(l,Js,s),U(q,l,s),e(l,ws,s),e(l,v,s),e(l,Ts,s),e(l,Q,s),e(l,cs,s),U(Z,l,s),e(l,us,s),e(l,G,s),e(l,rs,s),e(l,E,s),e(l,Cs,s),e(l,C,s),e(l,Is,s),U(W,l,s),e(l,hs,s),e(l,N,s),e(l,ds,s),U(R,l,s),e(l,ms,s),e(l,S,s),e(l,bs,s),U(_,l,s),e(l,As,s),e(l,V,s),e(l,gs,s),e(l,$,s),e(l,fs,s),U(x,l,s),e(l,Bs,s),e(l,Y,s),e(l,ks,s),e(l,H,s),e(l,qs,s),e(l,I,s),e(l,vs,s),U(X,l,s),e(l,Qs,s),e(l,z,s),e(l,Zs,s),U(F,l,s),e(l,Gs,s),e(l,L,s),e(l,Es,s),e(l,P,s),e(l,Ws,s),e(l,O,s),e(l,Ns,s),U(K,l,s),e(l,Rs,s),e(l,D,s),e(l,Ss,s),U(ll,l,s),e(l,_s,s),e(l,sl,s),e(l,Vs,s),e(l,h,s),e(l,$s,s),e(l,tl,s),e(l,xs,s),U(el,l,s),e(l,Ys,s),e(l,nl,s),e(l,Hs,s),e(l,Ml,s),e(l,Xs,s),U(al,l,s),e(l,zs,s),e(l,ol,s),e(l,Fs,s),e(l,il,s),e(l,Ls,s),e(l,d,s),e(l,Ps,s),U(yl,l,s),e(l,Os,s),e(l,pl,s),e(l,Ks,s),U(Ul,l,s),e(l,Ds,s),e(l,jl,s),e(l,lt,s),e(l,Jl,s),e(l,st,s),U(wl,l,s),e(l,tt,s),e(l,Tl,s),e(l,et,s),e(l,m,s),e(l,nt,s),e(l,cl,s),e(l,Mt,s),U(ul,l,s),e(l,at,s),e(l,rl,s),e(l,ot,s),e(l,Cl,s),e(l,it,s),e(l,Il,s),e(l,yt,s),U(hl,l,s),e(l,pt,s),e(l,dl,s),e(l,Ut,s),U(ml,l,s),e(l,jt,s),e(l,bl,s),e(l,Jt,s),U(Al,l,s),e(l,wt,s),e(l,gl,s),e(l,Tt,s),U(fl,l,s),e(l,ct,s),e(l,Bl,s),e(l,ut,s),e(l,b,s),e(l,rt,s),U(kl,l,s),e(l,Ct,s),e(l,ql,s),e(l,It,s),U(vl,l,s),e(l,ht,s),e(l,Ql,s),e(l,dt,s),e(l,Zl,s),e(l,mt,s),e(l,Gl,s),e(l,bt,s),e(l,El,s),e(l,At,s),e(l,A,s),e(l,gt,s),U(Wl,l,s),e(l,ft,s),e(l,Nl,s),e(l,Bt,s),e(l,Rl,s),e(l,kt,s),e(l,Sl,s),e(l,qt,s),e(l,_l,s),e(l,vt,s),e(l,Vl,s),e(l,Qt,s),e(l,$l,s),e(l,Zt,s),U(xl,l,s),e(l,Gt,s),e(l,Yl,s),e(l,Et,s),U(Hl,l,s),e(l,Wt,s),e(l,Xl,s),e(l,Nt,s),U(zl,l,s),e(l,Rt,s),e(l,Fl,s),e(l,St,s),U(Ll,l,s),e(l,_t,s),e(l,Pl,s),e(l,Vt,s),U(Ol,l,s),e(l,$t,s),e(l,Kl,s),e(l,xt,s),e(l,g,s),e(l,Yt,s),U(Dl,l,s),e(l,Ht,s),e(l,ls,s),e(l,Xt,s),e(l,ss,s),e(l,zt,s),e(l,ts,s),e(l,Ft,s),U(es,l,s),e(l,Lt,s),e(l,ns,s),e(l,Pt,s),e(l,Ms,s),e(l,Ot,s),e(l,as,s),e(l,Kt,s),e(l,f,s),e(l,Dt,s),U(os,l,s),e(l,le,s),e(l,ys,s),se=!0},p:un,i(l){se||(j(B.$$.fragment,l),j(q.$$.fragment,l),j(Z.$$.fragment,l),j(W.$$.fragment,l),j(R.$$.fragment,l),j(_.$$.fragment,l),j(x.$$.fragment,l),j(X.$$.fragment,l),j(F.$$.fragment,l),j(K.$$.fragment,l),j(ll.$$.fragment,l),j(el.$$.fragment,l),j(al.$$.fragment,l),j(yl.$$.fragment,l),j(Ul.$$.fragment,l),j(wl.$$.fragment,l),j(ul.$$.fragment,l),j(hl.$$.fragment,l),j(ml.$$.fragment,l),j(Al.$$.fragment,l),j(fl.$$.fragment,l),j(kl.$$.fragment,l),j(vl.$$.fragment,l),j(Wl.$$.fragment,l),j(xl.$$.fragment,l),j(Hl.$$.fragment,l),j(zl.$$.fragment,l),j(Ll.$$.fragment,l),j(Ol.$$.fragment,l),j(Dl.$$.fragment,l),j(es.$$.fragment,l),j(os.$$.fragment,l),se=!0)},o(l){J(B.$$.fragment,l),J(q.$$.fragment,l),J(Z.$$.fragment,l),J(W.$$.fragment,l),J(R.$$.fragment,l),J(_.$$.fragment,l),J(x.$$.fragment,l),J(X.$$.fragment,l),J(F.$$.fragment,l),J(K.$$.fragment,l),J(ll.$$.fragment,l),J(el.$$.fragment,l),J(al.$$.fragment,l),J(yl.$$.fragment,l),J(Ul.$$.fragment,l),J(wl.$$.fragment,l),J(ul.$$.fragment,l),J(hl.$$.fragment,l),J(ml.$$.fragment,l),J(Al.$$.fragment,l),J(fl.$$.fragment,l),J(kl.$$.fragment,l),J(vl.$$.fragment,l),J(Wl.$$.fragment,l),J(xl.$$.fragment,l),J(Hl.$$.fragment,l),J(zl.$$.fragment,l),J(Ll.$$.fragment,l),J(Ol.$$.fragment,l),J(Dl.$$.fragment,l),J(es.$$.fragment,l),J(os.$$.fragment,l),se=!1},d(l){l&&(t(ps),t(is),t(Us),t(js),t(k),t(Js),t(ws),t(v),t(Ts),t(Q),t(cs),t(us),t(G),t(rs),t(E),t(Cs),t(C),t(Is),t(hs),t(N),t(ds),t(ms),t(S),t(bs),t(As),t(V),t(gs),t($),t(fs),t(Bs),t(Y),t(ks),t(H),t(qs),t(I),t(vs),t(Qs),t(z),t(Zs),t(Gs),t(L),t(Es),t(P),t(Ws),t(O),t(Ns),t(Rs),t(D),t(Ss),t(_s),t(sl),t(Vs),t(h),t($s),t(tl),t(xs),t(Ys),t(nl),t(Hs),t(Ml),t(Xs),t(zs),t(ol),t(Fs),t(il),t(Ls),t(d),t(Ps),t(Os),t(pl),t(Ks),t(Ds),t(jl),t(lt),t(Jl),t(st),t(tt),t(Tl),t(et),t(m),t(nt),t(cl),t(Mt),t(at),t(rl),t(ot),t(Cl),t(it),t(Il),t(yt),t(pt),t(dl),t(Ut),t(jt),t(bl),t(Jt),t(wt),t(gl),t(Tt),t(ct),t(Bl),t(ut),t(b),t(rt),t(Ct),t(ql),t(It),t(ht),t(Ql),t(dt),t(Zl),t(mt),t(Gl),t(bt),t(El),t(At),t(A),t(gt),t(ft),t(Nl),t(Bt),t(Rl),t(kt),t(Sl),t(qt),t(_l),t(vt),t(Vl),t(Qt),t($l),t(Zt),t(Gt),t(Yl),t(Et),t(Wt),t(Xl),t(Nt),t(Rt),t(Fl),t(St),t(_t),t(Pl),t(Vt),t($t),t(Kl),t(xt),t(g),t(Yt),t(Ht),t(ls),t(Xt),t(ss),t(zt),t(ts),t(Ft),t(Lt),t(ns),t(Pt),t(Ms),t(Ot),t(as),t(Kt),t(f),t(Dt),t(le),t(ys)),t(r),w(B,l),w(q,l),w(Z,l),w(W,l),w(R,l),w(_,l),w(x,l),w(X,l),w(F,l),w(K,l),w(ll,l),w(el,l),w(al,l),w(yl,l),w(Ul,l),w(wl,l),w(ul,l),w(hl,l),w(ml,l),w(Al,l),w(fl,l),w(kl,l),w(vl,l),w(Wl,l),w(xl,l),w(Hl,l),w(zl,l),w(Ll,l),w(Ol,l),w(Dl,l),w(es,l),w(os,l)}}}const An='{"title":"Webhook Listener","local":"webhook-listener","sections":[{"title":"Understanding Webhook Integration","local":"understanding-webhook-integration","sections":[{"title":"Webhook Event Flow","local":"webhook-event-flow","sections":[],"depth":3}],"depth":2},{"title":"FastAPI Webhook Application","local":"fastapi-webhook-application","sections":[{"title":"1. Application Setup","local":"1-application-setup","sections":[],"depth":3},{"title":"2. Webhook Data Models","local":"2-webhook-data-models","sections":[],"depth":3},{"title":"3. Core Webhook Handler","local":"3-core-webhook-handler","sections":[],"depth":3},{"title":"4. Comment Processing Logic","local":"4-comment-processing-logic","sections":[],"depth":3},{"title":"5. Health and Monitoring Endpoints","local":"5-health-and-monitoring-endpoints","sections":[],"depth":3}],"depth":2},{"title":"Webhook Configuration on Hugging Face Hub","local":"webhook-configuration-on-hugging-face-hub","sections":[{"title":"1. Create Webhook in Settings","local":"1-create-webhook-in-settings","sections":[],"depth":3},{"title":"2. Space URL Configuration","local":"2-space-url-configuration","sections":[],"depth":3}],"depth":2},{"title":"Testing the Webhook Listener","local":"testing-the-webhook-listener","sections":[{"title":"1. Local Testing","local":"1-local-testing","sections":[],"depth":3},{"title":"2. Simulation Endpoint for Development","local":"2-simulation-endpoint-for-development","sections":[],"depth":3}],"depth":2},{"title":"Expected Webhook Result","local":"expected-webhook-result","sections":[],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function gn(te){return rn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vn extends Cn{constructor(r){super(),In(this,r,gn,bn,cn,{})}}export{vn as component};
