# Welcome to the 🤗 Model Context Protocol (MCP) Course

![MCP Course thumbnail](https://huggingface.co/datasets/mcp-course/images/resolve/main/unit0/1.png)

Welcome to the most exciting topic in AI today: **Model Context Protocol (MCP)**!

This free course, built in partnership with [Anthropic](https://www.anthropic.com), will take you on a journey, **from beginner to informed**, in understanding, using, and building applications with MCP.

This first unit will help you onboard:

* Discover the **course's syllabus**.
* **Get more information about the certification process and the schedule**.
* Get to know the team behind the course.
* Create your **account**.
* **Sign-up to our Discord server**, and meet your classmates and us.

Let's get started!

## What to expect from this course?

In this course, you will:

* 📖 Study Model Context Protocol in **theory, design, and practice.**
* 🧑‍💻 Learn to **use established MCP SDKs and frameworks**.
* 💾 **Share your projects** and explore applications created by the community.
* 🏆 Participate in challenges where you will **evaluate your MCP implementations against other students'.**
* 🎓 **Earn a certificate of completion** by completing assignments.

And more!

At the end of this course, you'll understand **how MCP works and how to build your own AI applications that leverage external data and tools using the latest MCP standards**.

Don't forget to [**sign up to the course!**](https://huggingface.co/mcp-course)

## What does the course look like?

The course is composed of:

* _Foundational Units_: where you learn MCP **concepts in theory**.
* _Hands-on_: where you'll learn **to use established MCP SDKs** to build your applications. These hands-on sections will have pre-configured environments.
* _Use case assignments_: where you'll apply the concepts you've learned to solve a real-world problem that you'll choose.
* _Collaborations_: We're collaborating with Hugging Face's partners to give you the latest MCP implementations and tools.
 
This **course is a living project, evolving with your feedback and contributions!** Feel free to open issues and PRs in GitHub, and engage in discussions in our Discord server.

## What's the syllabus?

Here is the **general syllabus for the course**. A more detailed list of topics will be released with each unit.

| Chapter | Topic                                       | Description                                                                                                            |
| ------- | ------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------- |
| 0       | Onboarding                                  | Set you up with the tools and platforms that you will use.                                                             |
| 1       | MCP Fundamentals, Architecture and Core Concepts | Explain core concepts, architecture, and components of Model Context Protocol. Show a simple use case using MCP.       |
| 2       | End-to-end Use case: MCP in Action              | Build a simple end-to-end MCP application that you can share with the community. |
| 3       | Deployed Use case: MCP in Action               | Build a deployed MCP application using the Hugging Face ecosystem and partners' services.                                        |
| 4       | Bonus Units                                  | Bonus units to help you get more out of the course, working with partners' libraries and services.                                        |

## What are the prerequisites?

To be able to follow this course, you should have:

* Basic understanding of AI and LLM concepts
* Familiarity with software development principles and API concepts
* Experience with at least one programming language (Python or TypeScript examples will be shown)

If you don't have any of these, don't worry! Here are some resources that can help you:

* [LLM Course](https://huggingface.co/learn/llm-course/) will guide you through the basics of using and building with LLMs.
* [Agents Course](https://huggingface.co/learn/agents-course/) will guide you through building AI agents with LLMs.

> [!TIP]
> The above courses are not prerequisites in themselves, so if you understand the concepts of LLMs and agents, you can start the course now!

## What tools do I need?

You only need 2 things:

* _A computer_ with an internet connection.
* An _account_: to access the course resources and create projects. If you don't have an account yet, you can create one [here](https://huggingface.co/join) (it's free).

## The Certification Process

You can choose to follow this course _in audit mode_, or do the activities and _get one of the two certificates we'll issue_. If you audit the course, you can participate in all the challenges and do assignments if you want, and **you don't need to notify us**.

The certification process is **completely free**:

* _To get a certification for fundamentals_: you need to complete Unit 1 of the course. This is intended for students that want to get up to date with the latest trends in MCP, without the need to build a full application.
* _To get a certificate of completion_: you need to complete the use case units (2 and 3). This is intended for students that want to build a full application and share it with the community.

## What is the recommended pace?

Each chapter in this course is designed **to be completed in 1 week, with approximately 3-4 hours of work per week**.

Since there's a deadline, we provide you a recommended pace:

![Recommended Pace](https://huggingface.co/datasets/mcp-course/images/resolve/main/unit0/2.png)

## How to get the most out of the course?

To get the most out of the course, we have some advice:

1. [Join study groups in Discord](https://discord.gg/UrrTSsSyjb): Studying in groups is always easier. To do that, you need to join our discord server and verify your account.
2. **Do the quizzes and assignments**: The best way to learn is through hands-on practice and self-assessment.
3. **Define a schedule to stay in sync**: You can use our recommended pace schedule below or create yours.

![Course advice](https://huggingface.co/datasets/mcp-course/images/resolve/main/unit0/3.png)

## Who are we

About the authors:

### Ben Burtenshaw

Ben is a Machine Learning Engineer at Hugging Face who focuses on building LLM applications, with post training and agentic approaches. [Follow Ben on the Hub](https://huggingface.co/burtenshaw) to see his latest projects.

### Alex Notov

Alex is Technical Partner Enablement Lead at [Anthropic](https://www.anthropic.com) and worked on unit 3 of this course. Alex trains Anthropic's partners on Claude best practices for their use cases. Follow Alex on [LinkedIn](https://linkedin.com/in/zealoushacker) and [GitHub](https://github.com/zealoushacker).

## Acknowledgments

We would like to extend our gratitude to the following individuals and partners for their invaluable contributions and support:

- [Gradio](https://www.gradio.app/)
- [Continue](https://continue.dev)
- [Llama.cpp](https://github.com/ggerganov/llama.cpp)
- [Anthropic](https://www.anthropic.com)

## I found a bug, or I want to improve the course

Contributions are **welcome** 🤗

* If you _found a bug 🐛 in a notebook_, please [open an issue](https://github.com/huggingface/mcp-course/issues/new) and **describe the problem**.
* If you _want to improve the course_, you can [open a Pull Request](https://github.com/huggingface/mcp-course/pulls).
* If you _want to add a full section or a new unit_, the best is to [open an issue](https://github.com/huggingface/mcp-course/issues/new) and **describe what content you want to add before starting to write it so that we can guide you**.

## I still have questions

Please ask your question in our discord server #mcp-course-questions.

Now that you have all the information, let's get on board ⛵ 


<EditOnGithub source="https://github.com/huggingface/mcp-course/blob/main/units/en/unit0/introduction.mdx" />