# Quiz 1: MCP Fundamentals

Test your knowledge of the core concepts of Model Context Protocol.

### Q1: What is the primary purpose of Model Context Protocol (MCP)?

<Question
  choices={[
    {
      text: "To limit the training data of AI models",
      explain: "MCP aims to expand, not limit, the contexts AI models can access."
    },
    {
      text: "To enable AI models to connect with external data sources, tools, and environments",
      explain: "Correct! MCP's main goal is to facilitate interoperability.",
      correct: true
    },
    {
      text: "To replace prompting when using Large Language Models",
      explain: "MCP is a protocol that enhances prompting, not a replacement for it."
    },
    {
      text: "To create a new programming language for AI",
      explain: "MCP is a protocol, not a programming language."
    }
  ]}
/>

### Q2: What problem does MCP primarily aim to solve?

<Question
  choices={[
    {
      text: "The lack of AI models",
      explain: "MCP addresses integration challenges, not the availability of AI models themselves."
    },
    {
      text: "The high cost of training LLMs",
      explain: "While MCP can improve efficiency, its primary focus is not on reducing training costs directly."
    },
    {
      text: "The M×N Integration Problem",
      explain: "Correct! MCP standardizes connections to avoid M×N custom integrations.",
      correct: true
    },
    {
      text: "The difficulty in creating new AI algorithms",
      explain: "MCP facilitates using existing algorithms and tools, not creating new ones from scratch."
    }
  ]}
/>

### Q3: Which of the following is a key benefit of MCP?

<Question
  choices={[
    {
      text: "Reduced AI model accuracy",
      explain: "MCP aims to enhance AI capabilities, which should ideally lead to improved or maintained accuracy, not reduced."
    },
    {
      text: "Increased complexity in AI development",
      explain: "MCP aims to simplify integration, thereby reducing complexity."
    },
    {
      text: "Standardization and interoperability in the AI ecosystem",
      explain: "Correct! This is a primary goal and benefit of MCP.",
      correct: true
    },
    {
      text: "Isolation of AI models from external systems",
      explain: "MCP promotes connection and interaction, not isolation."
    }
  ]}
/>

### Q4: In MCP terminology, what is a "Host"?

<Question
  choices={[
    {
      text: "The external program exposing capabilities",
      explain: "This describes an MCP Server."
    },
    {
      text: "The user-facing AI application",
      explain: "Correct! The Host is the application users interact with.",
      correct: true
    },
    {
      text: "A read-only data source",
      explain: "This describes a type of MCP Capability (Resource)."
    },
    {
      text: "A pre-defined template for interactions",
      explain: "This describes a type of MCP Capability (Prompt)."
    }
  ]}
/>

### Q5: What does "M×N Integration Problem" refer to in the context of AI applications?

<Question
  choices={[
    {
      text: "The difficulty of training M models with N datasets",
      explain: "This relates to model training, not the integration problem MCP addresses."
    },
    {
      text: "The challenge of connecting M AI applications to N external tools without a standard",
      explain: "Correct! MCP provides the standard to solve this M*N complexity.",
      correct: true
    },
    {
      text: "The problem of managing M users across N applications",
      explain: "This is a user management or identity problem, not the focus of MCP."
    },
    {
      text: "The complexity of developing M features for N different user segments",
      explain: "This relates to product development strategy, not system integration in the way MCP defines."
    }
  ]}
/>

Congrats on finishing this Quiz 🥳! If you need to review any elements, take the time to revisit the chapter to reinforce your knowledge. 

<EditOnGithub source="https://github.com/huggingface/mcp-course/blob/main/units/en/unit1/quiz1.mdx" />