import{s as ct,n as dt,o as $t}from"../chunks/scheduler.d9d004e7.js";import{S as gt,i as bt,e as l,s as n,c as p,h as yt,a as m,d as s,b as a,f as ht,g as o,j as c,k as ut,l as Mt,m as i,n as r,t as f,o as h,p as u}from"../chunks/index.4a2b774c.js";import{C as wt,H as d,E as Tt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.2d77c8e6.js";import{C as Y}from"../chunks/CodeBlock.8806415f.js";function xt(Oe){let $,O,D,ee,g,te,b,se,y,et="This article demonstrates how to benchmark and compare the performance of the Habana Processing Unit (HPU)-optimized <code>safe_softmax</code> operation against the native PyTorch implementation. The provided Python script guides you through the process step-by-step, with detailed explanations for each part. Additionally, we will provide some context about <code>safe_softmax</code>, its purpose, and its use cases.",ie,ne,ae,M,le,w,tt="The <code>safe_softmax</code> operation works out-of-the-box in PyTorch. When running your code on Habana hardware, the HPU-optimized implementation is automatically utilized without any additional configuration. This seamless integration allows you to benefit from performance improvements without modifying your existing code.",me,pe,oe,T,re,x,st="The <code>softmax</code> function is a common operation in machine learning, particularly in classification tasks. It converts raw logits into probabilities by applying the exponential function and normalizing the results. However, the standard <code>softmax</code> can encounter numerical instability when dealing with very large or very small values in the input tensor, leading to overflow or underflow issues.",fe,U,it="To address this, <code>safe_softmax</code> is implemented. It stabilizes the computation by subtracting the maximum value in each row (or along the specified dimension) from the logits before applying the exponential function. This ensures that the largest value in the exponent is zero, preventing overflow.",he,_,ue,v,nt="<li><strong>Numerical Stability</strong>: Prevents overflow/underflow issues during computation.</li> <li><strong>Widely Used</strong>: Commonly used in neural networks, especially in the final layer for classification tasks.</li> <li><strong>Efficiency</strong>: Optimized implementations can significantly improve performance on specialized hardware like GPUs or HPUs.</li>",ce,de,$e,j,ge,H,be,J,ye,C,at="<li><strong><code>torch</code></strong>: The core PyTorch library for tensor operations.</li> <li><strong><code>timeit</code></strong>: A Python module for measuring execution time.</li> <li><strong><code>habana_frameworks.torch</code></strong>: Provides support for Habana hardware (HPUs).</li> <li><strong><code>safe_softmax</code></strong>: The native PyTorch implementation of <code>safe_softmax</code> is imported for comparison.</li>",Me,we,Te,k,xe,z,Ue,I,lt="<li>The HPU-optimized version of <code>safe_softmax</code> is accessed via the <code>torch.ops.aten</code> namespace. This implementation is specifically designed to leverage the Habana hardware for faster execution.</li>",_e,ve,je,Z,He,W,Je,G,mt="<li>A 2D tensor is created with some typical values, including <code>-inf</code> to simulate edge cases.</li> <li>The tensor is moved to the HPU device using <code>.to(&quot;hpu&quot;)</code>.</li>",Ce,ke,ze,P,Ie,L,Ze,N,pt="<li>Both the HPU-optimized and native implementations are executed once before benchmarking. This ensures that any initialization overhead is excluded from the timing measurements.</li> <li><code>ht.hpu.synchronize()</code> ensures that all HPU operations are completed before proceeding.</li>",We,Ge,Pe,E,Le,B,Ne,V,ot="<li>The <code>timeit</code> module is used to measure the execution time of each implementation over 10,000 iterations.</li> <li>The <code>globals=globals()</code> argument allows the <code>timeit</code> module to access the defined variables and functions in the script.</li>",Ee,Be,Ve,R,Re,X,Xe,S,rt="<li>The execution times for both implementations are printed, allowing for a direct comparison of their performance.</li>",Se,Qe,qe,Q,Ae,q,ft="After running the script, you might see output similar to the following (lower is better):",Fe,A,Ye,F,De,K,Ke;return g=new wt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),b=new d({props:{title:"Comparing HPU-Optimized safe_softmax with Native PyTorch safe_softmax",local:"comparing-hpu-optimized-safesoftmax-with-native-pytorch-safesoftmax",headingTag:"h1"}}),M=new d({props:{title:"Important Note: No Special Setup Required",local:"important-note-no-special-setup-required",headingTag:"h2"}}),T=new d({props:{title:"What is safe_softmax ?",local:"what-is-safesoftmax-",headingTag:"h2"}}),_=new d({props:{title:"Why is safe_softmax important?",local:"why-is-safesoftmax-important",headingTag:"h3"}}),j=new d({props:{title:"Step-by-Step Explanation of the Code",local:"step-by-step-explanation-of-the-code",headingTag:"h2"}}),H=new d({props:{title:"1. Importing Required Libraries",local:"1-importing-required-libraries",headingTag:"h3"}}),J=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1laXQlMEFpbXBvcnQlMjBoYWJhbmFfZnJhbWV3b3Jrcy50b3JjaCUyMGFzJTIwaHQlMEFmcm9tJTIwdG9yY2guX2RlY29tcC5kZWNvbXBvc2l0aW9ucyUyMGltcG9ydCUyMHNhZmVfc29mdG1heCUyMGFzJTIwbmF0aXZlX3NhZmVfc29mdG1heA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> timeit
<span class="hljs-keyword">import</span> habana_frameworks.torch <span class="hljs-keyword">as</span> ht
<span class="hljs-keyword">from</span> torch._decomp.decompositions <span class="hljs-keyword">import</span> safe_softmax <span class="hljs-keyword">as</span> native_safe_softmax`,wrap:!1}}),k=new d({props:{title:"2. Defining the HPU-Optimized safe_softmax",local:"2-defining-the-hpu-optimized-safesoftmax",headingTag:"h3"}}),z=new Y({props:{code:"aHB1X3NhZmVfc29mdG1heCUyMCUzRCUyMHRvcmNoLm9wcy5hdGVuLl9zYWZlX3NvZnRtYXguZGVmYXVsdA==",highlighted:"hpu_safe_softmax = torch.ops.aten._safe_softmax.default",wrap:!1}}),Z=new d({props:{title:"3. Preparing the Input Tensor",local:"3-preparing-the-input-tensor",headingTag:"h3"}}),W=new Y({props:{code:"aW5wdXRfdGVuc29yJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QiU1QjEuMCUyQyUyMDIuMCUyQyUyMGZsb2F0KCUyMi1pbmYlMjIpJTVEJTJDJTIwJTVCMy4wJTJDJTIwNC4wJTJDJTIwNS4wJTVEJTVEKS50byglMjJocHUlMjIp",highlighted:'input_tensor = torch.tensor([[<span class="hljs-number">1.0</span>, <span class="hljs-number">2.0</span>, <span class="hljs-built_in">float</span>(<span class="hljs-string">&quot;-inf&quot;</span>)], [<span class="hljs-number">3.0</span>, <span class="hljs-number">4.0</span>, <span class="hljs-number">5.0</span>]]).to(<span class="hljs-string">&quot;hpu&quot;</span>)',wrap:!1}}),P=new d({props:{title:"4. Warmup for Fair Benchmarking",local:"4-warmup-for-fair-benchmarking",headingTag:"h3"}}),L=new Y({props:{code:"aHB1X3NhZmVfc29mdG1heChpbnB1dF90ZW5zb3IlMkMlMjBkaW0lM0QxKSUzQiUyMGh0LmhwdS5zeW5jaHJvbml6ZSgpJTBBbmF0aXZlX3NhZmVfc29mdG1heChpbnB1dF90ZW5zb3IlMkMlMjBkaW0lM0QxKSUzQiUyMGh0LmhwdS5zeW5jaHJvbml6ZSgp",highlighted:`hpu_safe_softmax(input_tensor, dim=<span class="hljs-number">1</span>); ht.hpu.synchronize()
native_safe_softmax(input_tensor, dim=<span class="hljs-number">1</span>); ht.hpu.synchronize()`,wrap:!1}}),E=new d({props:{title:"5. Benchmarking the Implementations",local:"5-benchmarking-the-implementations",headingTag:"h3"}}),B=new Y({props:{code:"bnVtX2l0ZXJhdGlvbnMlMjAlM0QlMjAxMDAwMCUwQWhwdV90aW1lJTIwJTNEJTIwdGltZWl0LnRpbWVpdCglMEElMjAlMjAlMjAlMjAlMjJocHVfc2FmZV9zb2Z0bWF4KGlucHV0X3RlbnNvciUyQyUyMGRpbSUzRDEpJTNCJTIwaHQuaHB1LnN5bmNocm9uaXplKCklMjIlMkMlMEElMjAlMjAlMjAlMjBnbG9iYWxzJTNEZ2xvYmFscygpJTJDJTBBJTIwJTIwJTIwJTIwbnVtYmVyJTNEbnVtX2l0ZXJhdGlvbnMlMEEpJTBBbmF0aXZlX3RpbWUlMjAlM0QlMjB0aW1laXQudGltZWl0KCUwQSUyMCUyMCUyMCUyMCUyMm5hdGl2ZV9zYWZlX3NvZnRtYXgoaW5wdXRfdGVuc29yJTJDJTIwZGltJTNEMSklM0IlMjBodC5ocHUuc3luY2hyb25pemUoKSUyMiUyQyUwQSUyMCUyMCUyMCUyMGdsb2JhbHMlM0RnbG9iYWxzKCklMkMlMEElMjAlMjAlMjAlMjBudW1iZXIlM0RudW1faXRlcmF0aW9ucyUwQSk=",highlighted:`num_iterations = <span class="hljs-number">10000</span>
hpu_time = timeit.timeit(
    <span class="hljs-string">&quot;hpu_safe_softmax(input_tensor, dim=1); ht.hpu.synchronize()&quot;</span>,
    <span class="hljs-built_in">globals</span>=<span class="hljs-built_in">globals</span>(),
    number=num_iterations
)
native_time = timeit.timeit(
    <span class="hljs-string">&quot;native_safe_softmax(input_tensor, dim=1); ht.hpu.synchronize()&quot;</span>,
    <span class="hljs-built_in">globals</span>=<span class="hljs-built_in">globals</span>(),
    number=num_iterations
)`,wrap:!1}}),R=new d({props:{title:"6. Printing the Results",local:"6-printing-the-results",headingTag:"h3"}}),X=new Y({props:{code:"cHJpbnQoZiUyMlBlcmZvcm1hbmNlJTIwY29tcGFyaXNvbiUyMG92ZXIlMjAlN0JudW1faXRlcmF0aW9ucyU3RCUyMGl0ZXJhdGlvbnMlM0ElMjIpJTBBcHJpbnQoZiUyMk5hdGl2ZSUyMHNhZmVfc29mdG1heCUzQSUyMCU3Qm5hdGl2ZV90aW1lJTNBLjZmJTdEJTIwc2Vjb25kcyUyMiklMEFwcmludChmJTIySFBVJTIwc2FmZV9zb2Z0bWF4JTNBJTIwJTdCaHB1X3RpbWUlM0EuNmYlN0QlMjBzZWNvbmRzJTIyKQ==",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Performance comparison over <span class="hljs-subst">{num_iterations}</span> iterations:&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Native safe_softmax: <span class="hljs-subst">{native_time:<span class="hljs-number">.6</span>f}</span> seconds&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;HPU safe_softmax: <span class="hljs-subst">{hpu_time:<span class="hljs-number">.6</span>f}</span> seconds&quot;</span>)`,wrap:!1}}),Q=new d({props:{title:"Example Output",local:"example-output",headingTag:"h2"}}),A=new Y({props:{code:"UGVyZm9ybWFuY2UlMjBjb21wYXJpc29uJTIwb3ZlciUyMDEwMDAwJTIwaXRlcmF0aW9ucyUzQSUwQU5hdGl2ZSUyMHNhZmVfc29mdG1heCUzQSUyMDEuMDA0MDU3JTIwc2Vjb25kcyUwQUhQVSUyMHNhZmVfc29mdG1heCUzQSUyMDAuMTA0MDA0JTIwc2Vjb25kcw==",highlighted:`<span class="hljs-attribute">Performance</span> comparison over <span class="hljs-number">10000</span> iterations:
<span class="hljs-attribute">Native</span> safe_softmax: <span class="hljs-number">1</span>.<span class="hljs-number">004057</span> seconds
<span class="hljs-attribute">HPU</span> safe_softmax: <span class="hljs-number">0</span>.<span class="hljs-number">104004</span> seconds`,wrap:!1}}),F=new Tt({props:{source:"https://github.com/huggingface/optimum-habana/blob/main/docs/source/usage_guides/safe_softmax.mdx"}}),{c(){$=l("meta"),O=n(),D=l("p"),ee=n(),p(g.$$.fragment),te=n(),p(b.$$.fragment),se=n(),y=l("p"),y.innerHTML=et,ie=n(),ne=l("hr"),ae=n(),p(M.$$.fragment),le=n(),w=l("p"),w.innerHTML=tt,me=n(),pe=l("hr"),oe=n(),p(T.$$.fragment),re=n(),x=l("p"),x.innerHTML=st,fe=n(),U=l("p"),U.innerHTML=it,he=n(),p(_.$$.fragment),ue=n(),v=l("ul"),v.innerHTML=nt,ce=n(),de=l("hr"),$e=n(),p(j.$$.fragment),ge=n(),p(H.$$.fragment),be=n(),p(J.$$.fragment),ye=n(),C=l("ul"),C.innerHTML=at,Me=n(),we=l("hr"),Te=n(),p(k.$$.fragment),xe=n(),p(z.$$.fragment),Ue=n(),I=l("ul"),I.innerHTML=lt,_e=n(),ve=l("hr"),je=n(),p(Z.$$.fragment),He=n(),p(W.$$.fragment),Je=n(),G=l("ul"),G.innerHTML=mt,Ce=n(),ke=l("hr"),ze=n(),p(P.$$.fragment),Ie=n(),p(L.$$.fragment),Ze=n(),N=l("ul"),N.innerHTML=pt,We=n(),Ge=l("hr"),Pe=n(),p(E.$$.fragment),Le=n(),p(B.$$.fragment),Ne=n(),V=l("ul"),V.innerHTML=ot,Ee=n(),Be=l("hr"),Ve=n(),p(R.$$.fragment),Re=n(),p(X.$$.fragment),Xe=n(),S=l("ul"),S.innerHTML=rt,Se=n(),Qe=l("hr"),qe=n(),p(Q.$$.fragment),Ae=n(),q=l("p"),q.textContent=ft,Fe=n(),p(A.$$.fragment),Ye=n(),p(F.$$.fragment),De=n(),K=l("p"),this.h()},l(e){const t=yt("svelte-u9bgzb",document.head);$=m(t,"META",{name:!0,content:!0}),t.forEach(s),O=a(e),D=m(e,"P",{}),ht(D).forEach(s),ee=a(e),o(g.$$.fragment,e),te=a(e),o(b.$$.fragment,e),se=a(e),y=m(e,"P",{"data-svelte-h":!0}),c(y)!=="svelte-qkhhtt"&&(y.innerHTML=et),ie=a(e),ne=m(e,"HR",{}),ae=a(e),o(M.$$.fragment,e),le=a(e),w=m(e,"P",{"data-svelte-h":!0}),c(w)!=="svelte-1d70kfu"&&(w.innerHTML=tt),me=a(e),pe=m(e,"HR",{}),oe=a(e),o(T.$$.fragment,e),re=a(e),x=m(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-sy3qnf"&&(x.innerHTML=st),fe=a(e),U=m(e,"P",{"data-svelte-h":!0}),c(U)!=="svelte-1ja0ojh"&&(U.innerHTML=it),he=a(e),o(_.$$.fragment,e),ue=a(e),v=m(e,"UL",{"data-svelte-h":!0}),c(v)!=="svelte-1m1cn17"&&(v.innerHTML=nt),ce=a(e),de=m(e,"HR",{}),$e=a(e),o(j.$$.fragment,e),ge=a(e),o(H.$$.fragment,e),be=a(e),o(J.$$.fragment,e),ye=a(e),C=m(e,"UL",{"data-svelte-h":!0}),c(C)!=="svelte-ycc5xw"&&(C.innerHTML=at),Me=a(e),we=m(e,"HR",{}),Te=a(e),o(k.$$.fragment,e),xe=a(e),o(z.$$.fragment,e),Ue=a(e),I=m(e,"UL",{"data-svelte-h":!0}),c(I)!=="svelte-1vmnn5g"&&(I.innerHTML=lt),_e=a(e),ve=m(e,"HR",{}),je=a(e),o(Z.$$.fragment,e),He=a(e),o(W.$$.fragment,e),Je=a(e),G=m(e,"UL",{"data-svelte-h":!0}),c(G)!=="svelte-1dm3d7p"&&(G.innerHTML=mt),Ce=a(e),ke=m(e,"HR",{}),ze=a(e),o(P.$$.fragment,e),Ie=a(e),o(L.$$.fragment,e),Ze=a(e),N=m(e,"UL",{"data-svelte-h":!0}),c(N)!=="svelte-iqiv15"&&(N.innerHTML=pt),We=a(e),Ge=m(e,"HR",{}),Pe=a(e),o(E.$$.fragment,e),Le=a(e),o(B.$$.fragment,e),Ne=a(e),V=m(e,"UL",{"data-svelte-h":!0}),c(V)!=="svelte-fhgher"&&(V.innerHTML=ot),Ee=a(e),Be=m(e,"HR",{}),Ve=a(e),o(R.$$.fragment,e),Re=a(e),o(X.$$.fragment,e),Xe=a(e),S=m(e,"UL",{"data-svelte-h":!0}),c(S)!=="svelte-1ebbosp"&&(S.innerHTML=rt),Se=a(e),Qe=m(e,"HR",{}),qe=a(e),o(Q.$$.fragment,e),Ae=a(e),q=m(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-16gysxd"&&(q.textContent=ft),Fe=a(e),o(A.$$.fragment,e),Ye=a(e),o(F.$$.fragment,e),De=a(e),K=m(e,"P",{}),ht(K).forEach(s),this.h()},h(){ut($,"name","hf:doc:metadata"),ut($,"content",Ut)},m(e,t){Mt(document.head,$),i(e,O,t),i(e,D,t),i(e,ee,t),r(g,e,t),i(e,te,t),r(b,e,t),i(e,se,t),i(e,y,t),i(e,ie,t),i(e,ne,t),i(e,ae,t),r(M,e,t),i(e,le,t),i(e,w,t),i(e,me,t),i(e,pe,t),i(e,oe,t),r(T,e,t),i(e,re,t),i(e,x,t),i(e,fe,t),i(e,U,t),i(e,he,t),r(_,e,t),i(e,ue,t),i(e,v,t),i(e,ce,t),i(e,de,t),i(e,$e,t),r(j,e,t),i(e,ge,t),r(H,e,t),i(e,be,t),r(J,e,t),i(e,ye,t),i(e,C,t),i(e,Me,t),i(e,we,t),i(e,Te,t),r(k,e,t),i(e,xe,t),r(z,e,t),i(e,Ue,t),i(e,I,t),i(e,_e,t),i(e,ve,t),i(e,je,t),r(Z,e,t),i(e,He,t),r(W,e,t),i(e,Je,t),i(e,G,t),i(e,Ce,t),i(e,ke,t),i(e,ze,t),r(P,e,t),i(e,Ie,t),r(L,e,t),i(e,Ze,t),i(e,N,t),i(e,We,t),i(e,Ge,t),i(e,Pe,t),r(E,e,t),i(e,Le,t),r(B,e,t),i(e,Ne,t),i(e,V,t),i(e,Ee,t),i(e,Be,t),i(e,Ve,t),r(R,e,t),i(e,Re,t),r(X,e,t),i(e,Xe,t),i(e,S,t),i(e,Se,t),i(e,Qe,t),i(e,qe,t),r(Q,e,t),i(e,Ae,t),i(e,q,t),i(e,Fe,t),r(A,e,t),i(e,Ye,t),r(F,e,t),i(e,De,t),i(e,K,t),Ke=!0},p:dt,i(e){Ke||(f(g.$$.fragment,e),f(b.$$.fragment,e),f(M.$$.fragment,e),f(T.$$.fragment,e),f(_.$$.fragment,e),f(j.$$.fragment,e),f(H.$$.fragment,e),f(J.$$.fragment,e),f(k.$$.fragment,e),f(z.$$.fragment,e),f(Z.$$.fragment,e),f(W.$$.fragment,e),f(P.$$.fragment,e),f(L.$$.fragment,e),f(E.$$.fragment,e),f(B.$$.fragment,e),f(R.$$.fragment,e),f(X.$$.fragment,e),f(Q.$$.fragment,e),f(A.$$.fragment,e),f(F.$$.fragment,e),Ke=!0)},o(e){h(g.$$.fragment,e),h(b.$$.fragment,e),h(M.$$.fragment,e),h(T.$$.fragment,e),h(_.$$.fragment,e),h(j.$$.fragment,e),h(H.$$.fragment,e),h(J.$$.fragment,e),h(k.$$.fragment,e),h(z.$$.fragment,e),h(Z.$$.fragment,e),h(W.$$.fragment,e),h(P.$$.fragment,e),h(L.$$.fragment,e),h(E.$$.fragment,e),h(B.$$.fragment,e),h(R.$$.fragment,e),h(X.$$.fragment,e),h(Q.$$.fragment,e),h(A.$$.fragment,e),h(F.$$.fragment,e),Ke=!1},d(e){e&&(s(O),s(D),s(ee),s(te),s(se),s(y),s(ie),s(ne),s(ae),s(le),s(w),s(me),s(pe),s(oe),s(re),s(x),s(fe),s(U),s(he),s(ue),s(v),s(ce),s(de),s($e),s(ge),s(be),s(ye),s(C),s(Me),s(we),s(Te),s(xe),s(Ue),s(I),s(_e),s(ve),s(je),s(He),s(Je),s(G),s(Ce),s(ke),s(ze),s(Ie),s(Ze),s(N),s(We),s(Ge),s(Pe),s(Le),s(Ne),s(V),s(Ee),s(Be),s(Ve),s(Re),s(Xe),s(S),s(Se),s(Qe),s(qe),s(Ae),s(q),s(Fe),s(Ye),s(De),s(K)),s($),u(g,e),u(b,e),u(M,e),u(T,e),u(_,e),u(j,e),u(H,e),u(J,e),u(k,e),u(z,e),u(Z,e),u(W,e),u(P,e),u(L,e),u(E,e),u(B,e),u(R,e),u(X,e),u(Q,e),u(A,e),u(F,e)}}}const Ut='{"title":"Comparing HPU-Optimized safe_softmax with Native PyTorch safe_softmax","local":"comparing-hpu-optimized-safesoftmax-with-native-pytorch-safesoftmax","sections":[{"title":"Important Note: No Special Setup Required","local":"important-note-no-special-setup-required","sections":[],"depth":2},{"title":"What is safe_softmax ?","local":"what-is-safesoftmax-","sections":[{"title":"Why is safe_softmax important?","local":"why-is-safesoftmax-important","sections":[],"depth":3}],"depth":2},{"title":"Step-by-Step Explanation of the Code","local":"step-by-step-explanation-of-the-code","sections":[{"title":"1. Importing Required Libraries","local":"1-importing-required-libraries","sections":[],"depth":3},{"title":"2. Defining the HPU-Optimized safe_softmax","local":"2-defining-the-hpu-optimized-safesoftmax","sections":[],"depth":3},{"title":"3. Preparing the Input Tensor","local":"3-preparing-the-input-tensor","sections":[],"depth":3},{"title":"4. Warmup for Fair Benchmarking","local":"4-warmup-for-fair-benchmarking","sections":[],"depth":3},{"title":"5. Benchmarking the Implementations","local":"5-benchmarking-the-implementations","sections":[],"depth":3},{"title":"6. Printing the Results","local":"6-printing-the-results","sections":[],"depth":3}],"depth":2},{"title":"Example Output","local":"example-output","sections":[],"depth":2}],"depth":1}';function _t(Oe){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ct extends gt{constructor($){super(),bt(this,$,_t,xt,ct,{})}}export{Ct as component};
