import{s as te,n as ae,o as le}from"../chunks/scheduler.d9d004e7.js";import{S as ne,i as ie,e as r,s as n,c as j,h as se,a as o,d as a,b as i,f as K,g as U,j as G,k as O,l as re,m as l,n as w,t as W,o as B,p as g}from"../chunks/index.4a2b774c.js";import{C as oe,H as z,E as me}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.2d77c8e6.js";import{C as ee}from"../chunks/CodeBlock.8806415f.js";function pe(F){let s,R,Z,$,m,_,p,E,d,N=`🤗 Optimum for Intel Gaudi features HPU-optimized support for many of the latest 🤗 Transformers and Diffusers models.
To convert a script to use model optimized for a Gaudi device, simple adaptation can be performed.`,X,u,V,f,v="Here is how to do a transformers script adaptation for Intel Gaudi:",S,M,C,c,P=`where <code>gaudi_config_name</code> is the name of a model from the <a href="https://huggingface.co/Habana" rel="nofollow">Hub</a> a path to a local Gaudi configuration file.
Gaudi configurations are stored as JSON files in model repositories but you can write your own.
More information can be found <a href="../package_reference/gaudi_config">here</a>.`,Q,J,Y,y,q=`🤗 Optimum for Intel Gaudi also features HPU-optimized support for the 🤗 Diffusers library.
Thus, you can easily deploy Stable Diffusion on Gaudi for performing text-to-image generation.`,H,b,L="Here is how to use it and the differences with the 🤗 Diffusers library:",A,T,D,h,k,I,x;return m=new oe({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),p=new z({props:{title:"Adapt a Transformers/Diffusers script to Intel Gaudi",local:"adapt-a-transformersdiffusers-script-to-intel-gaudi",headingTag:"h1"}}),u=new z({props:{title:"Transformers",local:"transformers",headingTag:"h2"}}),M=new ee({props:{code:"LSUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUcmFpbmVyJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMEElMkIlMjBmcm9tJTIwb3B0aW11bS5oYWJhbmElMjBpbXBvcnQlMjBHYXVkaVRyYWluZXIlMkMlMjBHYXVkaVRyYWluaW5nQXJndW1lbnRzJTBBJTBBJTIzJTIwRGVmaW5lJTIwdGhlJTIwdHJhaW5pbmclMjBhcmd1bWVudHMlMEEtJTIwdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyQiUyMHRyYWluaW5nX2FyZ3MlMjAlM0QlMjBHYXVkaVRyYWluaW5nQXJndW1lbnRzKCUwQSUyQiUyMCUyMCUyMHVzZV9oYWJhbmElM0RUcnVlJTJDJTBBJTJCJTIwJTIwJTIwdXNlX2xhenlfbW9kZSUzRFRydWUlMkMlMEElMkIlMjAlMjAlMjBnYXVkaV9jb25maWdfbmFtZSUzRGdhdWRpX2NvbmZpZ19uYW1lJTJDJTBBJTIwJTIwLi4uJTBBKSUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjBvdXIlMjBUcmFpbmVyJTBBLSUyMHRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKCUwQSUyQiUyMHRyYWluZXIlMjAlM0QlMjBHYXVkaVRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMEElMjAlMjAlMjAlMjAuLi4lMjAlMjMlMjBvdGhlciUyMGFyZ3VtZW50cyUwQSk=",highlighted:`<span class="hljs-deletion">- from transformers import Trainer, TrainingArguments</span>
<span class="hljs-addition">+ from optimum.habana import GaudiTrainer, GaudiTrainingArguments</span>

# Define the training arguments
<span class="hljs-deletion">- training_args = TrainingArguments(</span>
<span class="hljs-addition">+ training_args = GaudiTrainingArguments(</span>
<span class="hljs-addition">+   use_habana=True,</span>
<span class="hljs-addition">+   use_lazy_mode=True,</span>
<span class="hljs-addition">+   gaudi_config_name=gaudi_config_name,</span>
  ...
)

# Initialize our Trainer
<span class="hljs-deletion">- trainer = Trainer(</span>
<span class="hljs-addition">+ trainer = GaudiTrainer(</span>
    model=model,
    args=training_args,
    train_dataset=train_dataset
    ... # other arguments
)`,wrap:!1}}),J=new z({props:{title:"Diffusers",local:"diffusers",headingTag:"h2"}}),T=new ee({props:{code:"LSUyMGZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBERElNU2NoZWR1bGVyJTJDJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMkIlMjBmcm9tJTIwb3B0aW11bS5oYWJhbmEuZGlmZnVzZXJzJTIwaW1wb3J0JTIwR2F1ZGlERElNU2NoZWR1bGVyJTJDJTIwR2F1ZGlTdGFibGVEaWZmdXNpb25QaXBlbGluZSUwQSUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQSUwQS0lMjBzY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQSUyQiUyMHNjaGVkdWxlciUyMCUzRCUyMEdhdWRpRERJTVNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiklMEElMEEtJTIwcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTJCJTIwcGlwZWxpbmUlMjAlM0QlMjBHYXVkaVN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyJTJDJTBBJTJCJTIwJTIwJTIwdXNlX2hhYmFuYSUzRFRydWUlMkMlMEElMkIlMjAlMjAlMjB1c2VfaHB1X2dyYXBocyUzRFRydWUlMkMlMEElMkIlMjAlMjAlMjBnYXVkaV9jb25maWclM0QlMjJIYWJhbmElMkZzdGFibGUtZGlmZnVzaW9uJTIyJTJDJTBBKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlNUIlMjJBbiUyMGltYWdlJTIwb2YlMjBhJTIwc3F1aXJyZWwlMjBpbiUyMFBpY2Fzc28lMjBzdHlsZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCUzRDE2JTJDJTBBJTJCJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRDQlMkMlMEEp",highlighted:`<span class="hljs-deletion">- from diffusers import DDIMScheduler, StableDiffusionPipeline</span>
<span class="hljs-addition">+ from optimum.habana.diffusers import GaudiDDIMScheduler, GaudiStableDiffusionPipeline</span>


model_name = &quot;runwayml/stable-diffusion-v1-5&quot;

<span class="hljs-deletion">- scheduler = DDIMScheduler.from_pretrained(model_name, subfolder=&quot;scheduler&quot;)</span>
<span class="hljs-addition">+ scheduler = GaudiDDIMScheduler.from_pretrained(model_name, subfolder=&quot;scheduler&quot;)</span>

<span class="hljs-deletion">- pipeline = StableDiffusionPipeline.from_pretrained(</span>
<span class="hljs-addition">+ pipeline = GaudiStableDiffusionPipeline.from_pretrained(</span>
    model_name,
    scheduler=scheduler,
<span class="hljs-addition">+   use_habana=True,</span>
<span class="hljs-addition">+   use_hpu_graphs=True,</span>
<span class="hljs-addition">+   gaudi_config=&quot;Habana/stable-diffusion&quot;,</span>
)

outputs = pipeline(
    [&quot;An image of a squirrel in Picasso style&quot;],
    num_images_per_prompt=16,
<span class="hljs-addition">+   batch_size=4,</span>
)`,wrap:!1}}),h=new me({props:{source:"https://github.com/huggingface/optimum-habana/blob/main/docs/source/usage_guides/script_adaptation.mdx"}}),{c(){s=r("meta"),R=n(),Z=r("p"),$=n(),j(m.$$.fragment),_=n(),j(p.$$.fragment),E=n(),d=r("p"),d.textContent=N,X=n(),j(u.$$.fragment),V=n(),f=r("p"),f.textContent=v,S=n(),j(M.$$.fragment),C=n(),c=r("p"),c.innerHTML=P,Q=n(),j(J.$$.fragment),Y=n(),y=r("p"),y.textContent=q,H=n(),b=r("p"),b.textContent=L,A=n(),j(T.$$.fragment),D=n(),j(h.$$.fragment),k=n(),I=r("p"),this.h()},l(e){const t=se("svelte-u9bgzb",document.head);s=o(t,"META",{name:!0,content:!0}),t.forEach(a),R=i(e),Z=o(e,"P",{}),K(Z).forEach(a),$=i(e),U(m.$$.fragment,e),_=i(e),U(p.$$.fragment,e),E=i(e),d=o(e,"P",{"data-svelte-h":!0}),G(d)!=="svelte-drgjyo"&&(d.textContent=N),X=i(e),U(u.$$.fragment,e),V=i(e),f=o(e,"P",{"data-svelte-h":!0}),G(f)!=="svelte-153qiya"&&(f.textContent=v),S=i(e),U(M.$$.fragment,e),C=i(e),c=o(e,"P",{"data-svelte-h":!0}),G(c)!=="svelte-i5iet4"&&(c.innerHTML=P),Q=i(e),U(J.$$.fragment,e),Y=i(e),y=o(e,"P",{"data-svelte-h":!0}),G(y)!=="svelte-79egnp"&&(y.textContent=q),H=i(e),b=o(e,"P",{"data-svelte-h":!0}),G(b)!=="svelte-2jvm77"&&(b.textContent=L),A=i(e),U(T.$$.fragment,e),D=i(e),U(h.$$.fragment,e),k=i(e),I=o(e,"P",{}),K(I).forEach(a),this.h()},h(){O(s,"name","hf:doc:metadata"),O(s,"content",de)},m(e,t){re(document.head,s),l(e,R,t),l(e,Z,t),l(e,$,t),w(m,e,t),l(e,_,t),w(p,e,t),l(e,E,t),l(e,d,t),l(e,X,t),w(u,e,t),l(e,V,t),l(e,f,t),l(e,S,t),w(M,e,t),l(e,C,t),l(e,c,t),l(e,Q,t),w(J,e,t),l(e,Y,t),l(e,y,t),l(e,H,t),l(e,b,t),l(e,A,t),w(T,e,t),l(e,D,t),w(h,e,t),l(e,k,t),l(e,I,t),x=!0},p:ae,i(e){x||(W(m.$$.fragment,e),W(p.$$.fragment,e),W(u.$$.fragment,e),W(M.$$.fragment,e),W(J.$$.fragment,e),W(T.$$.fragment,e),W(h.$$.fragment,e),x=!0)},o(e){B(m.$$.fragment,e),B(p.$$.fragment,e),B(u.$$.fragment,e),B(M.$$.fragment,e),B(J.$$.fragment,e),B(T.$$.fragment,e),B(h.$$.fragment,e),x=!1},d(e){e&&(a(R),a(Z),a($),a(_),a(E),a(d),a(X),a(V),a(f),a(S),a(C),a(c),a(Q),a(Y),a(y),a(H),a(b),a(A),a(D),a(k),a(I)),a(s),g(m,e),g(p,e),g(u,e),g(M,e),g(J,e),g(T,e),g(h,e)}}}const de='{"title":"Adapt a Transformers/Diffusers script to Intel Gaudi","local":"adapt-a-transformersdiffusers-script-to-intel-gaudi","sections":[{"title":"Transformers","local":"transformers","sections":[],"depth":2},{"title":"Diffusers","local":"diffusers","sections":[],"depth":2}],"depth":1}';function ue(F){return le(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ye extends ne{constructor(s){super(),ie(this,s,ue,pe,te,{})}}export{ye as component};
