import{s as ht,n as wt,o as Zt}from"../chunks/scheduler.c90a44b2.js";import{S as ft,i as jt,e as d,s as n,c as s,h as Wt,a as c,d as e,b as i,f as Tt,g as o,j as u,k as Ut,l as It,m as a,n as p,t as r,o as m,p as M}from"../chunks/index.66c3f415.js";import{C as Xt,H as y}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.654a99cc.js";import{C as J}from"../chunks/CodeBlock.267f447f.js";function Ct(Ol){let b,pl,sl,rl,T,ml,U,Ml,h,lt="Optimum Intel can be used to apply popular compression techniques such as quantization, pruning and knowledge distillation.",dl,w,cl,Z,tt=`Post-training compression techniques such as dynamic and static quantization can be easily applied on your model using our <a href="optimization"><code>INCQuantizer</code></a>.
Note that quantization is currently only supported for CPUs (only CPU backends are available), so we will not be utilizing GPUs / CUDA in the following examples.`,ul,f,yl,j,et="You can easily add dynamic quantization on your model by using the following command line:",Jl,W,bl,I,at="When applying post-training quantization, an accuracy tolerance along with an adapted evaluation function can also be specified in order to find a quantized model meeting the specified constraints. This can be done for both dynamic and static quantization.",Tl,X,Ul,C,hl,G,nt="In the same manner we can apply static quantization, for which we also need to generate the calibration dataset in order to perform the calibration step.",wl,g,Zl,R,fl,B,it='The <a href="https://arxiv.org/abs/2211.10438" rel="nofollow">SmoothQuant</a> methodology is available for post-training quantization. This methodology usually improves the accuracy of the model in comparison to other post-training static quantization methodologies. This is done by migrating the difficulty from activations to weights with a mathematically equivalent transformation.',jl,F,Wl,z,st='Please refer to INC <a href="https://github.com/intel/neural-compressor/blob/master/docs/source/smooth_quant.md" rel="nofollow">documentation</a> and the list of <a href="https://github.com/intel/neural-compressor/blob/master/docs/source/smooth_quant.md#validated-models" rel="nofollow">models</a> quantized with the methodology for more details.',Il,V,Xl,Q,ot="One challenge in model quantization is identifying the optimal configuration that balances accuracy and performance. Distributed tuning speeds up this time-consuming process by parallelizing it across multiple nodes, which accelerates the tuning process in linear scaling.",Cl,Y,pt="To utilize distributed tuning, please set the <code>quant_level</code> to <code>1</code> and run it with <code>mpirun</code>.",Gl,N,gl,k,Rl,v,rt='Please refer to INC <a href="https://github.com/intel/neural-compressor/blob/master/docs/source/tuning_strategies.md#distributed-tuning" rel="nofollow">documentation</a> and <a href="https://github.com/huggingface/optimum-intel/tree/main/examples/neural_compressor/text-classification" rel="nofollow">text-classification</a> example for more details.',Bl,_,Fl,E,mt=`The <a href="https://huggingface.co/docs/optimum/main/intel/reference_inc#optimum.intel.INCTrainer" rel="nofollow"><code>INCTrainer</code></a> class provides an API to train your model while combining different compression techniques such as knowledge distillation, pruning and quantization.
The <code>INCTrainer</code> is very similar to the 🤗 Transformers <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#trainer" rel="nofollow"><code>Trainer</code></a>, which can be replaced with minimal changes in your code.`,zl,$,Vl,q,Mt="To apply quantization during training, you only need to create the appropriate configuration and pass it to the <code>INCTrainer</code>.",Ql,H,Yl,x,Nl,S,dt=`In the same manner, pruning can be applied by specifying the pruning configuration detailing the desired pruning process.
To know more about the different supported methodologies, you can refer to the Neural Compressor <a href="https://github.com/intel/neural-compressor/tree/master/neural_compressor/compression/pruner#pruning-types" rel="nofollow">documentation</a>.
At the moment, pruning is applied on both the linear and the convolutional layers, and not on other layers such as the embeddings. It’s important to mention that the pruning sparsity defined in the configuration will be applied on these layers, and thus will not results in the global model sparsity.`,kl,A,vl,L,_l,D,ct=`Knowledge distillation can also be applied in the same manner.
To know more about the different supported methodologies, you can refer to the Neural Compressor <a href="https://github.com/intel/neural-compressor/blob/master/docs/source/distillation.md" rel="nofollow">documentation</a>`,El,K,$l,P,ql,O,ut='To load a quantized model hosted locally or on the 🤗 hub, you must instantiate you model using our <a href="reference"><code>INCModelForXxx</code></a> classes.',Hl,ll,xl,tl,yt='You can load many more quantized models hosted on the hub under the Intel organization <a href="https://huggingface.co/Intel" rel="nofollow"><code>here</code></a>.',Sl,el,Al,al,Jt='The quantized model can then easily be used to run inference with the Transformers <a href="https://huggingface.co/docs/transformers/main/en/main_classes/pipelines" rel="nofollow">pipelines</a>.',Ll,nl,Dl,il,bt='Check out the <a href="https://github.com/huggingface/optimum-intel/tree/main/examples" rel="nofollow"><code>examples</code></a> directory for more sophisticated usage.',Kl,ol,Pl;return T=new Xt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new y({props:{title:"Optimization",local:"optimization",headingTag:"h1"}}),w=new y({props:{title:"Post-training optimization",local:"post-training-optimization",headingTag:"h2"}}),f=new y({props:{title:"Dynamic quantization",local:"dynamic-quantization",headingTag:"h3"}}),W=new J({props:{code:"b3B0aW11bS1jbGklMjBpbmMlMjBxdWFudGl6ZSUyMC0tbW9kZWwlMjBkaXN0aWxiZXJ0LWJhc2UtY2FzZWQtZGlzdGlsbGVkLXNxdWFkJTIwLS1vdXRwdXQlMjBxdWFudGl6ZWRfZGlzdGlsYmVydA==",highlighted:"optimum-cli inc quantize --model distilbert-base-cased-distilled-squad --output quantized_distilbert",wrap:!1}}),X=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> INCQuantizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForQuestionAnswering, AutoTokenizer, pipeline
<span class="hljs-keyword">from</span> neural_compressor.config <span class="hljs-keyword">import</span> AccuracyCriterion, TuningCriterion, PostTrainingQuantConfig

model_name = <span class="hljs-string">&quot;distilbert-base-cased-distilled-squad&quot;</span>
model = AutoModelForQuestionAnswering.from_pretrained(model_name)
tokenizer = AutoTokenizer.from_pretrained(model_name)
eval_dataset = load_dataset(<span class="hljs-string">&quot;squad&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">64</span>))
task_evaluator = evaluate.evaluator(<span class="hljs-string">&quot;question-answering&quot;</span>)
qa_pipeline = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">eval_fn</span>(<span class="hljs-params">model</span>):
    qa_pipeline.model = model
    metrics = task_evaluator.compute(model_or_pipeline=qa_pipeline, data=eval_dataset, metric=<span class="hljs-string">&quot;squad&quot;</span>)
    <span class="hljs-keyword">return</span> metrics[<span class="hljs-string">&quot;f1&quot;</span>]

<span class="hljs-comment"># Set the accepted accuracy loss to 5%</span>
accuracy_criterion = AccuracyCriterion(tolerable_loss=<span class="hljs-number">0.05</span>)
<span class="hljs-comment"># Set the maximum number of trials to 10</span>
tuning_criterion = TuningCriterion(max_trials=<span class="hljs-number">10</span>)
quantization_config = PostTrainingQuantConfig(
    approach=<span class="hljs-string">&quot;dynamic&quot;</span>, accuracy_criterion=accuracy_criterion, tuning_criterion=tuning_criterion
)
quantizer = INCQuantizer.from_pretrained(model, eval_fn=eval_fn)
quantizer.quantize(quantization_config=quantization_config, save_directory=<span class="hljs-string">&quot;dynamic_quantization&quot;</span>)`,wrap:!1}}),C=new y({props:{title:"Static quantization",local:"static-quantization",headingTag:"h3"}}),g=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, AutoTokenizer
<span class="hljs-keyword">from</span> neural_compressor.config <span class="hljs-keyword">import</span> PostTrainingQuantConfig
<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> INCQuantizer

model_name = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
model = AutoModelForSequenceClassification.from_pretrained(model_name)
tokenizer = AutoTokenizer.from_pretrained(model_name)
<span class="hljs-comment"># The directory where the quantized model will be saved</span>
save_dir = <span class="hljs-string">&quot;static_quantization&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples, tokenizer</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;sentence&quot;</span>], padding=<span class="hljs-string">&quot;max_length&quot;</span>, max_length=<span class="hljs-number">128</span>, truncation=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Load the quantization configuration detailing the quantization we wish to apply</span>
quantization_config = PostTrainingQuantConfig(approach=<span class="hljs-string">&quot;static&quot;</span>)
quantizer = INCQuantizer.from_pretrained(model)
<span class="hljs-comment"># Generate the calibration dataset needed for the calibration step</span>
calibration_dataset = quantizer.get_calibration_dataset(
    <span class="hljs-string">&quot;glue&quot;</span>,
    dataset_config_name=<span class="hljs-string">&quot;sst2&quot;</span>,
    preprocess_function=partial(preprocess_function, tokenizer=tokenizer),
    num_samples=<span class="hljs-number">100</span>,
    dataset_split=<span class="hljs-string">&quot;train&quot;</span>,
)
quantizer = INCQuantizer.from_pretrained(model)
<span class="hljs-comment"># Apply static quantization and save the resulting model</span>
quantizer.quantize(
    quantization_config=quantization_config,
    calibration_dataset=calibration_dataset,
    save_directory=save_dir,
)`,wrap:!1}}),R=new y({props:{title:"Specify Quantization Recipes",local:"specify-quantization-recipes",headingTag:"h3"}}),F=new J({props:{code:"LSUyMHF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBQb3N0VHJhaW5pbmdRdWFudENvbmZpZyhhcHByb2FjaCUzRCUyMnN0YXRpYyUyMiklMEElMkIlMjByZWNpcGVzJTNEJTdCJTIyc21vb3RoX3F1YW50JTIyJTNBJTIwVHJ1ZSUyQyUyMCUyMCUyMnNtb290aF9xdWFudF9hcmdzJTIyJTNBJTIwJTdCJTIyYWxwaGElMjIlM0ElMjAwLjUlMkMlMjAlMjJmb2xkaW5nJTIyJTNBJTIwVHJ1ZSU3RCU3RCUwQSUyQiUyMHF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBQb3N0VHJhaW5pbmdRdWFudENvbmZpZyhhcHByb2FjaCUzRCUyMnN0YXRpYyUyMiUyQyUyMGJhY2tlbmQlM0QlMjJpcGV4JTIyJTJDJTIwcmVjaXBlcyUzRHJlY2lwZXMp",highlighted:`<span class="hljs-deletion">- quantization_config = PostTrainingQuantConfig(approach=&quot;static&quot;)</span>
<span class="hljs-addition">+ recipes={&quot;smooth_quant&quot;: True,  &quot;smooth_quant_args&quot;: {&quot;alpha&quot;: 0.5, &quot;folding&quot;: True}}</span>
<span class="hljs-addition">+ quantization_config = PostTrainingQuantConfig(approach=&quot;static&quot;, backend=&quot;ipex&quot;, recipes=recipes)</span>`,wrap:!1}}),V=new y({props:{title:"Distributed Acuracy-aware Tuning",local:"distributed-acuracy-aware-tuning",headingTag:"h3"}}),N=new J({props:{code:"LSUyMHF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBQb3N0VHJhaW5pbmdRdWFudENvbmZpZyhhcHByb2FjaCUzRCUyMnN0YXRpYyUyMiklMEElMkIlMjBxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwUG9zdFRyYWluaW5nUXVhbnRDb25maWcoYXBwcm9hY2glM0QlMjJzdGF0aWMlMjIlMkMlMjBxdWFudF9sZXZlbCUzRDEp",highlighted:`<span class="hljs-deletion">- quantization_config = PostTrainingQuantConfig(approach=&quot;static&quot;)</span>
<span class="hljs-addition">+ quantization_config = PostTrainingQuantConfig(approach=&quot;static&quot;, quant_level=1)</span>`,wrap:!1}}),k=new J({props:{code:"bXBpcnVuJTIwLW5wJTIwJTNDbnVtYmVyX29mX3Byb2Nlc3NlcyUzRSUyMCUzQ1JVTl9DTUQlM0U=",highlighted:"mpirun -np &lt;number_of_processes&gt; &lt;RUN_CMD&gt;",wrap:!1}}),_=new y({props:{title:"During training optimization",local:"during-training-optimization",headingTag:"h2"}}),$=new y({props:{title:"Quantization",local:"quantization",headingTag:"h3"}}),H=new J({props:{code:"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",highlighted:`  import evaluate
  import numpy as np
  from datasets import load_dataset
  from transformers import AutoModelForSequenceClassification, AutoTokenizer, TrainingArguments, default_data_collator
<span class="hljs-deletion">- from transformers import Trainer</span>
<span class="hljs-addition">+ from optimum.intel import INCModelForSequenceClassification, INCTrainer</span>
<span class="hljs-addition">+ from neural_compressor import QuantizationAwareTrainingConfig</span>

  model_id = &quot;distilbert-base-uncased-finetuned-sst-2-english&quot;
  model = AutoModelForSequenceClassification.from_pretrained(model_id)
  tokenizer = AutoTokenizer.from_pretrained(model_id)
  dataset = load_dataset(&quot;glue&quot;, &quot;sst2&quot;)
  dataset = dataset.map(lambda examples: tokenizer(examples[&quot;sentence&quot;], padding=True, max_length=128), batched=True)
  metric = evaluate.load(&quot;glue&quot;, &quot;sst2&quot;)
  compute_metrics = lambda p: metric.compute(predictions=np.argmax(p.predictions, axis=1), references=p.label_ids)

  # The directory where the quantized model will be saved
  save_dir = &quot;quantized_model&quot;

  # The configuration detailing the quantization process
<span class="hljs-addition">+ quantization_config = QuantizationAwareTrainingConfig()</span>

<span class="hljs-deletion">- trainer = Trainer(</span>
<span class="hljs-addition">+ trainer = INCTrainer(</span>
      model=model,
<span class="hljs-addition">+     quantization_config=quantization_config,</span>
      args=TrainingArguments(save_dir, num_train_epochs=1.0, do_train=True, do_eval=False),
      train_dataset=dataset[&quot;train&quot;].select(range(300)),
      eval_dataset=dataset[&quot;validation&quot;],
      compute_metrics=compute_metrics,
      tokenizer=tokenizer,
      data_collator=default_data_collator,
  )

  train_result = trainer.train()
  metrics = trainer.evaluate()
  trainer.save_model()

<span class="hljs-deletion">- model = AutoModelForSequenceClassification.from_pretrained(save_dir)</span>
<span class="hljs-addition">+ model = INCModelForSequenceClassification.from_pretrained(save_dir)</span>`,wrap:!1}}),x=new y({props:{title:"Pruning",local:"pruning",headingTag:"h3"}}),A=new J({props:{code:"LSUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUcmFpbmVyJTBBJTJCJTIwZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBJTkNUcmFpbmVyJTBBJTJCJTIwZnJvbSUyMG5ldXJhbF9jb21wcmVzc29yJTIwaW1wb3J0JTIwV2VpZ2h0UHJ1bmluZ0NvbmZpZyUwQSUwQSUyMCUyMCUyMyUyMFRoZSUyMGNvbmZpZ3VyYXRpb24lMjBkZXRhaWxpbmclMjB0aGUlMjBwcnVuaW5nJTIwcHJvY2VzcyUwQSUyQiUyMHBydW5pbmdfY29uZmlnJTIwJTNEJTIwV2VpZ2h0UHJ1bmluZ0NvbmZpZyglMEElMkIlMjAlMjAlMjAlMjAlMjBwcnVuaW5nX3R5cGUlM0QlMjJtYWduaXR1ZGUlMjIlMkMlMEElMkIlMjAlMjAlMjAlMjAlMjBzdGFydF9zdGVwJTNEMCUyQyUwQSUyQiUyMCUyMCUyMCUyMCUyMGVuZF9zdGVwJTNEMTUlMkMlMEElMkIlMjAlMjAlMjAlMjAlMjB0YXJnZXRfc3BhcnNpdHklM0QwLjIlMkMlMEElMkIlMjAlMjAlMjAlMjAlMjBwcnVuaW5nX3Njb3BlJTNEJTIybG9jYWwlMjIlMkMlMEElMkIlMjApJTBBJTBBLSUyMHRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKCUwQSUyQiUyMHRyYWluZXIlMjAlM0QlMjBJTkNUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMkIlMjAlMjAlMjAlMjAlMjBwcnVuaW5nX2NvbmZpZyUzRHBydW5pbmdfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJncyUzRFRyYWluaW5nQXJndW1lbnRzKHNhdmVfZGlyJTJDJTIwbnVtX3RyYWluX2Vwb2NocyUzRDEuMCUyQyUyMGRvX3RyYWluJTNEVHJ1ZSUyQyUyMGRvX2V2YWwlM0RGYWxzZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCU1QiUyMnRyYWluJTIyJTVELnNlbGVjdChyYW5nZSgzMDApKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGRhdGFzZXQlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwY29tcHV0ZV9tZXRyaWNzJTNEY29tcHV0ZV9tZXRyaWNzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRlZmF1bHRfZGF0YV9jb2xsYXRvciUyQyUwQSUyMCUyMCklMEElMEElMjAlMjB0cmFpbl9yZXN1bHQlMjAlM0QlMjB0cmFpbmVyLnRyYWluKCklMEElMjAlMjBtZXRyaWNzJTIwJTNEJTIwdHJhaW5lci5ldmFsdWF0ZSgpJTBBJTIwJTIwdHJhaW5lci5zYXZlX21vZGVsKCklMEElMEElMjAlMjBtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKHNhdmVfZGlyKQ==",highlighted:`<span class="hljs-deletion">- from transformers import Trainer</span>
<span class="hljs-addition">+ from optimum.intel import INCTrainer</span>
<span class="hljs-addition">+ from neural_compressor import WeightPruningConfig</span>

  # The configuration detailing the pruning process
<span class="hljs-addition">+ pruning_config = WeightPruningConfig(</span>
<span class="hljs-addition">+     pruning_type=&quot;magnitude&quot;,</span>
<span class="hljs-addition">+     start_step=0,</span>
<span class="hljs-addition">+     end_step=15,</span>
<span class="hljs-addition">+     target_sparsity=0.2,</span>
<span class="hljs-addition">+     pruning_scope=&quot;local&quot;,</span>
<span class="hljs-addition">+ )</span>

<span class="hljs-deletion">- trainer = Trainer(</span>
<span class="hljs-addition">+ trainer = INCTrainer(</span>
      model=model,
<span class="hljs-addition">+     pruning_config=pruning_config,</span>
      args=TrainingArguments(save_dir, num_train_epochs=1.0, do_train=True, do_eval=False),
      train_dataset=dataset[&quot;train&quot;].select(range(300)),
      eval_dataset=dataset[&quot;validation&quot;],
      compute_metrics=compute_metrics,
      tokenizer=tokenizer,
      data_collator=default_data_collator,
  )

  train_result = trainer.train()
  metrics = trainer.evaluate()
  trainer.save_model()

  model = AutoModelForSequenceClassification.from_pretrained(save_dir)`,wrap:!1}}),L=new y({props:{title:"Knowledge distillation",local:"knowledge-distillation",headingTag:"h3"}}),K=new J({props:{code:"LSUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUcmFpbmVyJTBBJTJCJTIwZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBJTkNUcmFpbmVyJTBBJTJCJTIwZnJvbSUyMG5ldXJhbF9jb21wcmVzc29yJTIwaW1wb3J0JTIwRGlzdGlsbGF0aW9uQ29uZmlnJTBBJTBBJTJCJTIwdGVhY2hlcl9tb2RlbF9pZCUyMCUzRCUyMCUyMnRleHRhdHRhY2slMkZiZXJ0LWJhc2UtdW5jYXNlZC1TU1QtMiUyMiUwQSUyQiUyMHRlYWNoZXJfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCh0ZWFjaGVyX21vZGVsX2lkKSUwQSUyQiUyMGRpc3RpbGxhdGlvbl9jb25maWclMjAlM0QlMjBEaXN0aWxsYXRpb25Db25maWcodGVhY2hlcl9tb2RlbCUzRHRlYWNoZXJfbW9kZWwpJTBBJTBBLSUyMHRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKCUwQSUyQiUyMHRyYWluZXIlMjAlM0QlMjBJTkNUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMkIlMjAlMjAlMjAlMjAlMjBkaXN0aWxsYXRpb25fY29uZmlnJTNEZGlzdGlsbGF0aW9uX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyZ3MlM0RUcmFpbmluZ0FyZ3VtZW50cyhzYXZlX2RpciUyQyUyMG51bV90cmFpbl9lcG9jaHMlM0QxLjAlMkMlMjBkb190cmFpbiUzRFRydWUlMkMlMjBkb19ldmFsJTNERmFsc2UpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RC5zZWxlY3QocmFuZ2UoMzAwKSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydmFsaWRhdGlvbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkZWZhdWx0X2RhdGFfY29sbGF0b3IlMkMlMEElMjAlMjApJTBBJTBBJTIwJTIwdHJhaW5fcmVzdWx0JTIwJTNEJTIwdHJhaW5lci50cmFpbigpJTBBJTIwJTIwbWV0cmljcyUyMCUzRCUyMHRyYWluZXIuZXZhbHVhdGUoKSUwQSUyMCUyMHRyYWluZXIuc2F2ZV9tb2RlbCgpJTBBJTBBJTIwJTIwbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChzYXZlX2Rpcik=",highlighted:`<span class="hljs-deletion">- from transformers import Trainer</span>
<span class="hljs-addition">+ from optimum.intel import INCTrainer</span>
<span class="hljs-addition">+ from neural_compressor import DistillationConfig</span>

<span class="hljs-addition">+ teacher_model_id = &quot;textattack/bert-base-uncased-SST-2&quot;</span>
<span class="hljs-addition">+ teacher_model = AutoModelForSequenceClassification.from_pretrained(teacher_model_id)</span>
<span class="hljs-addition">+ distillation_config = DistillationConfig(teacher_model=teacher_model)</span>

<span class="hljs-deletion">- trainer = Trainer(</span>
<span class="hljs-addition">+ trainer = INCTrainer(</span>
      model=model,
<span class="hljs-addition">+     distillation_config=distillation_config,</span>
      args=TrainingArguments(save_dir, num_train_epochs=1.0, do_train=True, do_eval=False),
      train_dataset=dataset[&quot;train&quot;].select(range(300)),
      eval_dataset=dataset[&quot;validation&quot;],
      compute_metrics=compute_metrics,
      tokenizer=tokenizer,
      data_collator=default_data_collator,
  )

  train_result = trainer.train()
  metrics = trainer.evaluate()
  trainer.save_model()

  model = AutoModelForSequenceClassification.from_pretrained(save_dir)`,wrap:!1}}),P=new y({props:{title:"Loading a quantized model",local:"loading-a-quantized-model",headingTag:"h2"}}),ll=new J({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBJTkNNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbF9uYW1lJTIwJTNEJTIwJTIySW50ZWwlMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaC1pbnQ4LWR5bmFtaWMlMjIlMEFtb2RlbCUyMCUzRCUyMElOQ01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSk=",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> INCModelForSequenceClassification

model_name = <span class="hljs-string">&quot;Intel/distilbert-base-uncased-finetuned-sst-2-english-int8-dynamic&quot;</span>
model = INCModelForSequenceClassification.from_pretrained(model_name)`,wrap:!1}}),el=new y({props:{title:"Inference with Transformers pipeline",local:"inference-with-transformers-pipeline",headingTag:"h2"}}),nl=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXBpcGVfY2xzJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBdGV4dCUyMCUzRCUyMCUyMkhlJ3MlMjBhJTIwZHJlYWRmdWwlMjBtYWdpY2lhbi4lMjIlMEFvdXRwdXRzJTIwJTNEJTIwcGlwZV9jbHModGV4dCklMEElMEElNUIlN0InbGFiZWwnJTNBJTIwJ05FR0FUSVZFJyUyQyUyMCdzY29yZSclM0ElMjAwLjk4ODAyMTYxMjE2NzM1ODQlN0QlNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline

tokenizer = AutoTokenizer.from_pretrained(model_id)
pipe_cls = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model, tokenizer=tokenizer)
text = <span class="hljs-string">&quot;He&#x27;s a dreadful magician.&quot;</span>
outputs = pipe_cls(text)

[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9880216121673584</span>}]`,wrap:!1}}),{c(){b=d("meta"),pl=n(),sl=d("p"),rl=n(),s(T.$$.fragment),ml=n(),s(U.$$.fragment),Ml=n(),h=d("p"),h.textContent=lt,dl=n(),s(w.$$.fragment),cl=n(),Z=d("p"),Z.innerHTML=tt,ul=n(),s(f.$$.fragment),yl=n(),j=d("p"),j.textContent=et,Jl=n(),s(W.$$.fragment),bl=n(),I=d("p"),I.textContent=at,Tl=n(),s(X.$$.fragment),Ul=n(),s(C.$$.fragment),hl=n(),G=d("p"),G.textContent=nt,wl=n(),s(g.$$.fragment),Zl=n(),s(R.$$.fragment),fl=n(),B=d("p"),B.innerHTML=it,jl=n(),s(F.$$.fragment),Wl=n(),z=d("p"),z.innerHTML=st,Il=n(),s(V.$$.fragment),Xl=n(),Q=d("p"),Q.textContent=ot,Cl=n(),Y=d("p"),Y.innerHTML=pt,Gl=n(),s(N.$$.fragment),gl=n(),s(k.$$.fragment),Rl=n(),v=d("p"),v.innerHTML=rt,Bl=n(),s(_.$$.fragment),Fl=n(),E=d("p"),E.innerHTML=mt,zl=n(),s($.$$.fragment),Vl=n(),q=d("p"),q.innerHTML=Mt,Ql=n(),s(H.$$.fragment),Yl=n(),s(x.$$.fragment),Nl=n(),S=d("p"),S.innerHTML=dt,kl=n(),s(A.$$.fragment),vl=n(),s(L.$$.fragment),_l=n(),D=d("p"),D.innerHTML=ct,El=n(),s(K.$$.fragment),$l=n(),s(P.$$.fragment),ql=n(),O=d("p"),O.innerHTML=ut,Hl=n(),s(ll.$$.fragment),xl=n(),tl=d("p"),tl.innerHTML=yt,Sl=n(),s(el.$$.fragment),Al=n(),al=d("p"),al.innerHTML=Jt,Ll=n(),s(nl.$$.fragment),Dl=n(),il=d("p"),il.innerHTML=bt,Kl=n(),ol=d("p"),this.h()},l(l){const t=Wt("svelte-u9bgzb",document.head);b=c(t,"META",{name:!0,content:!0}),t.forEach(e),pl=i(l),sl=c(l,"P",{}),Tt(sl).forEach(e),rl=i(l),o(T.$$.fragment,l),ml=i(l),o(U.$$.fragment,l),Ml=i(l),h=c(l,"P",{"data-svelte-h":!0}),u(h)!=="svelte-1vfv9wu"&&(h.textContent=lt),dl=i(l),o(w.$$.fragment,l),cl=i(l),Z=c(l,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-1ghyp3d"&&(Z.innerHTML=tt),ul=i(l),o(f.$$.fragment,l),yl=i(l),j=c(l,"P",{"data-svelte-h":!0}),u(j)!=="svelte-1e02uxc"&&(j.textContent=et),Jl=i(l),o(W.$$.fragment,l),bl=i(l),I=c(l,"P",{"data-svelte-h":!0}),u(I)!=="svelte-k7p5hw"&&(I.textContent=at),Tl=i(l),o(X.$$.fragment,l),Ul=i(l),o(C.$$.fragment,l),hl=i(l),G=c(l,"P",{"data-svelte-h":!0}),u(G)!=="svelte-19clhwu"&&(G.textContent=nt),wl=i(l),o(g.$$.fragment,l),Zl=i(l),o(R.$$.fragment,l),fl=i(l),B=c(l,"P",{"data-svelte-h":!0}),u(B)!=="svelte-dc2np2"&&(B.innerHTML=it),jl=i(l),o(F.$$.fragment,l),Wl=i(l),z=c(l,"P",{"data-svelte-h":!0}),u(z)!=="svelte-1yhwu97"&&(z.innerHTML=st),Il=i(l),o(V.$$.fragment,l),Xl=i(l),Q=c(l,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-1p1kfk1"&&(Q.textContent=ot),Cl=i(l),Y=c(l,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-135ooff"&&(Y.innerHTML=pt),Gl=i(l),o(N.$$.fragment,l),gl=i(l),o(k.$$.fragment,l),Rl=i(l),v=c(l,"P",{"data-svelte-h":!0}),u(v)!=="svelte-1brppl7"&&(v.innerHTML=rt),Bl=i(l),o(_.$$.fragment,l),Fl=i(l),E=c(l,"P",{"data-svelte-h":!0}),u(E)!=="svelte-1k8j2c5"&&(E.innerHTML=mt),zl=i(l),o($.$$.fragment,l),Vl=i(l),q=c(l,"P",{"data-svelte-h":!0}),u(q)!=="svelte-v9ldfc"&&(q.innerHTML=Mt),Ql=i(l),o(H.$$.fragment,l),Yl=i(l),o(x.$$.fragment,l),Nl=i(l),S=c(l,"P",{"data-svelte-h":!0}),u(S)!=="svelte-mg11pz"&&(S.innerHTML=dt),kl=i(l),o(A.$$.fragment,l),vl=i(l),o(L.$$.fragment,l),_l=i(l),D=c(l,"P",{"data-svelte-h":!0}),u(D)!=="svelte-7qf0t8"&&(D.innerHTML=ct),El=i(l),o(K.$$.fragment,l),$l=i(l),o(P.$$.fragment,l),ql=i(l),O=c(l,"P",{"data-svelte-h":!0}),u(O)!=="svelte-1pzgkud"&&(O.innerHTML=ut),Hl=i(l),o(ll.$$.fragment,l),xl=i(l),tl=c(l,"P",{"data-svelte-h":!0}),u(tl)!=="svelte-rs75ni"&&(tl.innerHTML=yt),Sl=i(l),o(el.$$.fragment,l),Al=i(l),al=c(l,"P",{"data-svelte-h":!0}),u(al)!=="svelte-sktavk"&&(al.innerHTML=Jt),Ll=i(l),o(nl.$$.fragment,l),Dl=i(l),il=c(l,"P",{"data-svelte-h":!0}),u(il)!=="svelte-1jp7e0u"&&(il.innerHTML=bt),Kl=i(l),ol=c(l,"P",{}),Tt(ol).forEach(e),this.h()},h(){Ut(b,"name","hf:doc:metadata"),Ut(b,"content",Gt)},m(l,t){It(document.head,b),a(l,pl,t),a(l,sl,t),a(l,rl,t),p(T,l,t),a(l,ml,t),p(U,l,t),a(l,Ml,t),a(l,h,t),a(l,dl,t),p(w,l,t),a(l,cl,t),a(l,Z,t),a(l,ul,t),p(f,l,t),a(l,yl,t),a(l,j,t),a(l,Jl,t),p(W,l,t),a(l,bl,t),a(l,I,t),a(l,Tl,t),p(X,l,t),a(l,Ul,t),p(C,l,t),a(l,hl,t),a(l,G,t),a(l,wl,t),p(g,l,t),a(l,Zl,t),p(R,l,t),a(l,fl,t),a(l,B,t),a(l,jl,t),p(F,l,t),a(l,Wl,t),a(l,z,t),a(l,Il,t),p(V,l,t),a(l,Xl,t),a(l,Q,t),a(l,Cl,t),a(l,Y,t),a(l,Gl,t),p(N,l,t),a(l,gl,t),p(k,l,t),a(l,Rl,t),a(l,v,t),a(l,Bl,t),p(_,l,t),a(l,Fl,t),a(l,E,t),a(l,zl,t),p($,l,t),a(l,Vl,t),a(l,q,t),a(l,Ql,t),p(H,l,t),a(l,Yl,t),p(x,l,t),a(l,Nl,t),a(l,S,t),a(l,kl,t),p(A,l,t),a(l,vl,t),p(L,l,t),a(l,_l,t),a(l,D,t),a(l,El,t),p(K,l,t),a(l,$l,t),p(P,l,t),a(l,ql,t),a(l,O,t),a(l,Hl,t),p(ll,l,t),a(l,xl,t),a(l,tl,t),a(l,Sl,t),p(el,l,t),a(l,Al,t),a(l,al,t),a(l,Ll,t),p(nl,l,t),a(l,Dl,t),a(l,il,t),a(l,Kl,t),a(l,ol,t),Pl=!0},p:wt,i(l){Pl||(r(T.$$.fragment,l),r(U.$$.fragment,l),r(w.$$.fragment,l),r(f.$$.fragment,l),r(W.$$.fragment,l),r(X.$$.fragment,l),r(C.$$.fragment,l),r(g.$$.fragment,l),r(R.$$.fragment,l),r(F.$$.fragment,l),r(V.$$.fragment,l),r(N.$$.fragment,l),r(k.$$.fragment,l),r(_.$$.fragment,l),r($.$$.fragment,l),r(H.$$.fragment,l),r(x.$$.fragment,l),r(A.$$.fragment,l),r(L.$$.fragment,l),r(K.$$.fragment,l),r(P.$$.fragment,l),r(ll.$$.fragment,l),r(el.$$.fragment,l),r(nl.$$.fragment,l),Pl=!0)},o(l){m(T.$$.fragment,l),m(U.$$.fragment,l),m(w.$$.fragment,l),m(f.$$.fragment,l),m(W.$$.fragment,l),m(X.$$.fragment,l),m(C.$$.fragment,l),m(g.$$.fragment,l),m(R.$$.fragment,l),m(F.$$.fragment,l),m(V.$$.fragment,l),m(N.$$.fragment,l),m(k.$$.fragment,l),m(_.$$.fragment,l),m($.$$.fragment,l),m(H.$$.fragment,l),m(x.$$.fragment,l),m(A.$$.fragment,l),m(L.$$.fragment,l),m(K.$$.fragment,l),m(P.$$.fragment,l),m(ll.$$.fragment,l),m(el.$$.fragment,l),m(nl.$$.fragment,l),Pl=!1},d(l){l&&(e(pl),e(sl),e(rl),e(ml),e(Ml),e(h),e(dl),e(cl),e(Z),e(ul),e(yl),e(j),e(Jl),e(bl),e(I),e(Tl),e(Ul),e(hl),e(G),e(wl),e(Zl),e(fl),e(B),e(jl),e(Wl),e(z),e(Il),e(Xl),e(Q),e(Cl),e(Y),e(Gl),e(gl),e(Rl),e(v),e(Bl),e(Fl),e(E),e(zl),e(Vl),e(q),e(Ql),e(Yl),e(Nl),e(S),e(kl),e(vl),e(_l),e(D),e(El),e($l),e(ql),e(O),e(Hl),e(xl),e(tl),e(Sl),e(Al),e(al),e(Ll),e(Dl),e(il),e(Kl),e(ol)),e(b),M(T,l),M(U,l),M(w,l),M(f,l),M(W,l),M(X,l),M(C,l),M(g,l),M(R,l),M(F,l),M(V,l),M(N,l),M(k,l),M(_,l),M($,l),M(H,l),M(x,l),M(A,l),M(L,l),M(K,l),M(P,l),M(ll,l),M(el,l),M(nl,l)}}}const Gt='{"title":"Optimization","local":"optimization","sections":[{"title":"Post-training optimization","local":"post-training-optimization","sections":[{"title":"Dynamic quantization","local":"dynamic-quantization","sections":[],"depth":3},{"title":"Static quantization","local":"static-quantization","sections":[],"depth":3},{"title":"Specify Quantization Recipes","local":"specify-quantization-recipes","sections":[],"depth":3},{"title":"Distributed Acuracy-aware Tuning","local":"distributed-acuracy-aware-tuning","sections":[],"depth":3}],"depth":2},{"title":"During training optimization","local":"during-training-optimization","sections":[{"title":"Quantization","local":"quantization","sections":[],"depth":3},{"title":"Pruning","local":"pruning","sections":[],"depth":3},{"title":"Knowledge distillation","local":"knowledge-distillation","sections":[],"depth":3}],"depth":2},{"title":"Loading a quantized model","local":"loading-a-quantized-model","sections":[],"depth":2},{"title":"Inference with Transformers pipeline","local":"inference-with-transformers-pipeline","sections":[],"depth":2}],"depth":1}';function gt(Ol){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vt extends ft{constructor(b){super(),jt(this,b,gt,Ct,ht,{})}}export{Vt as component};
