import{s as Mn,n as cn,o as on}from"../chunks/scheduler.00bde567.js";import{S as Jn,i as un,g as p,s as e,r as c,m as jn,A as wn,h as M,f as t,c as n,j as Al,u as o,x as i,n as Tn,k as Tl,y as T,a,v as J,d as u,t as j,w}from"../chunks/index.752e2ff6.js";import{C as y}from"../chunks/CodeBlock.e62cd1dc.js";import{H as m}from"../chunks/Heading.476d3364.js";function yn(Ea){let I,Sl,Wl,Nl,A,Gl,W,Qa='<a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> implements everything described in the <a href="https://arxiv.org/abs/1910.02054" rel="nofollow">ZeRO paper</a>. Currently, it provides full support for:',vl,X,Fa="<li>Optimizer state partitioning (ZeRO stage 1)</li> <li>Gradient partitioning (ZeRO stage 2)</li> <li>Parameter partitioning (ZeRO stage 3)</li> <li>Custom mixed precision training handling</li> <li>A range of fast CUDA-extension-based optimizers</li> <li>ZeRO-Offload to CPU and Disk/NVMe</li>",Vl,S,ka=`ZeRO-Offload has its own dedicated paper: <a href="https://arxiv.org/abs/2101.06840" rel="nofollow">ZeRO-Offload: Democratizing Billion-Scale Model Training</a>. And NVMe-support is described in the paper <a href="https://arxiv.org/abs/2104.07857" rel="nofollow">ZeRO-Infinity: Breaking the GPU
Memory Wall for Extreme Scale Deep Learning</a>.`,zl,N,qa="DeepSpeed ZeRO-2 is primarily used only for training, as its features are of no use to inference.",Yl,G,Ha=`DeepSpeed ZeRO-3 can be used for inference as well since it allows huge models to be loaded on multiple GPUs, which
won’t be possible on a single GPU.`,Rl,v,$a='🤗 Accelerate integrates <a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> via 2 options:',xl,V,La=`<li>Integration of the DeepSpeed features via <code>deepspeed config file</code> specification in <code>accelerate config</code> . You just supply your custom config file or use our template. Most of
this document is focused on this feature. This supports all the core features of DeepSpeed and gives user a lot of flexibility.
User may have to change a few lines of code depending on the config.</li> <li>Integration via <code>deepspeed_plugin</code>.This supports subset of the DeepSpeed features and uses default options for the rest of the configurations.
User need not change any code and is good for those who are fine with most of the default settings of DeepSpeed.</li>`,El,z,Ql,Y,Da="Training:",Fl,R,Pa=`<li>DeepSpeed ZeRO training supports the full ZeRO stages 1, 2 and 3 as well as CPU/Disk offload of optimizer states, gradients and parameters.
Below is a short description of Data Parallelism using ZeRO - Zero Redundancy Optimizer along with diagram from this <a href="https://www.microsoft.com/en-us/research/blog/zero-deepspeed-new-system-optimizations-enable-training-models-with-over-100-billion-parameters/" rel="nofollow">blog post</a> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero.png" alt="ZeRO Data Parallelism"/></li>`,kl,x,Oa='(Source: <a href="https://www.microsoft.com/en-us/research/blog/zero-deepspeed-new-system-optimizations-enable-training-models-with-over-100-billion-parameters/" rel="nofollow">link</a>)',ql,E,Ka="a. <strong>Stage 1</strong> : Shards optimizer states across data parallel workers/GPUs",Hl,Q,se="b. <strong>Stage 2</strong> : Shards optimizer states + gradients across data parallel workers/GPUs",$l,F,le="c. <strong>Stage 3</strong>: Shards optimizer states + gradients + model parameters across data parallel workers/GPUs",Ll,k,te="d. <strong>Optimizer Offload</strong>: Offloads the gradients + optimizer states to CPU/Disk building on top of ZERO Stage 2",Dl,q,ae="e. <strong>Param Offload</strong>: Offloads the model parameters to CPU/Disk building on top of ZERO Stage 3",Pl,H,ee="Note",Ol,$,ne="Inference:",Kl,L,pe=`<li>DeepSpeed ZeRO Inference supports ZeRO stage 3 with ZeRO-Infinity. It uses the same ZeRO protocol as training, but
it doesn’t use an optimizer and a lr scheduler and only stage 3 is relevant. For more details see:
<a href="#deepspeed-zero-inference">deepspeed-zero-inference</a>.</li>`,st,D,lt,P,Me=`<strong>Pre-Requisites</strong>: Install DeepSpeed version &gt;=0.6.5. Please refer to the <a href="https://github.com/microsoft/DeepSpeed#installation" rel="nofollow">DeepSpeed Installation details</a>
for more information.`,tt,O,ie=`We will first look at easy to use integration via <code>accelerate config</code>.
Followed by more flexible and feature rich <code>deepspeed config file</code> integration.`,at,K,et,ss,ce="On your machine(s) just run:",nt,ls,pt,ts,oe=`and answer the questions asked. It will ask whether you want to use a config file for DeepSpeed to which you should answer no. Then answer the following questions to generate a basic DeepSpeed config.
This will generate a config file that will be used automatically to properly set the
default options when doing`,Mt,as,it,es,Je="For instance, here is how you would run the NLP example <code>examples/nlp_example.py</code> (from the root of the repo) with DeepSpeed Plugin:",ct,ns,ue="<strong>ZeRO Stage-2 DeepSpeed Plugin Example</strong>",ot,ps,Jt,Ms,ut,is,je="<strong>ZeRO Stage-3 with CPU Offload DeepSpeed Plugin Example</strong>",jt,cs,wt,os,Tt,Js,we="Currently, <code>Accelerate</code> supports following config through the CLI:",yt,us,rt,js,Te="To be able to tweak more options, you will need to use a DeepSpeed config file.",Ut,ws,ht,Ts,ye="On your machine(s) just run:",dt,ys,It,rs,re=`and answer the questions asked. It will ask whether you want to use a config file for deepspeed to which you answer yes
and provide the path to the deepspeed config file.
This will generate a config file that will be used automatically to properly set the
default options when doing`,mt,Us,ft,hs,Ue="For instance, here is how you would run the NLP example <code>examples/by_feature/deepspeed_with_config_support.py</code> (from the root of the repo) with DeepSpeed Config File:",bt,ds,he="<strong>ZeRO Stage-2 DeepSpeed Config File Example</strong>",Ct,Is,Zt,ms,de="with the contents of <code>zero_stage2_config.json</code> being:",_t,fs,Bt,bs,gt,Cs,Ie="<strong>ZeRO Stage-3 with CPU offload DeepSpeed Config File Example</strong>",At,Zs,Wt,_s,me="with the contents of <code>zero_stage3_offload_config.json</code> being:",Xt,Bs,St,gs,Nt,As,fe="<strong>Important code changes when using DeepSpeed Config File</strong>",Gt,f,h,yl,be=`DeepSpeed Optimizers and Schedulers. For more information on these,
see the <a href="https://deepspeed.readthedocs.io/en/latest/optimizers.html" rel="nofollow">DeepSpeed Optimizers</a> and <a href="https://deepspeed.readthedocs.io/en/latest/schedulers.html" rel="nofollow">DeepSpeed Schedulers</a> documentation.
We will look at the changes needed in the code when using these.`,ba,rl,Ce=`a. DS Optim + DS Scheduler: The case when both <code>optimizer</code> and <code>scheduler</code> keys are present in the DeepSpeed config file.
In this situation, those will be used and the user has to use <code>accelerate.utils.DummyOptim</code> and <code>accelerate.utils.DummyScheduler</code> to replace the PyTorch/Custom optimizers and schedulers in their code.
Below is the snippet from <code>examples/by_feature/deepspeed_with_config_support.py</code> showing this:`,Ca,Ws,Za,Ul,Ze=`b. Custom Optim + Custom Scheduler: The case when both <code>optimizer</code> and <code>scheduler</code> keys are absent in the DeepSpeed config file.
In this situation, no code changes are needed from the user and this is the case when using integration via DeepSpeed Plugin.
In the above example we can see that the code remains unchanged if the <code>optimizer</code> and <code>scheduler</code> keys are absent in the DeepSpeed config file.`,_a,hl,_e=`c. Custom Optim + DS Scheduler: The case when only <code>scheduler</code> key is present in the DeepSpeed config file.
In this situation, the user has to use <code>accelerate.utils.DummyScheduler</code> to replace the PyTorch/Custom scheduler in their code.`,Ba,dl,Be=`d. DS Optim + Custom Scheduler: The case when only <code>optimizer</code> key is present in the DeepSpeed config file.
This will result in an error because you can only use DS Scheduler when using DS Optim.`,ga,Il,ge=`<p>Notice the <code>auto</code> values in the above example DeepSpeed config files. These are automatically handled by <code>prepare</code> method
based on model, dataloaders, dummy optimizer and dummy schedulers provided to <code>prepare</code> method.
Only the <code>auto</code> fields specified in above examples are handled by <code>prepare</code> method and the rest have to be explicitly specified by the user.</p>`,vt,Xs,Ae="<strong>Things to note when using DeepSpeed Config File</strong>",Vt,Ss,We="Below is a sample script using <code>deepspeed_config_file</code> in different scenarios.",zt,Ns,Xe="Code <code>test.py</code>:",Yt,Gs,Rt,vs,Se="<strong>Scenario 1</strong>: Manually tampered accelerate config file having <code>deepspeed_config_file</code> along with other entries.",xt,Vs,Ne="<li>Content of the <code>accelerate</code> config:</li>",Et,zs,Qt,b,Ge="<li><code>ds_config.json</code>:</li>",Ft,Ys,kt,C,ve="<li>Output of <code>accelerate launch test.py</code>:</li>",qt,Rs,Ht,xs,Ve="<strong>Scenario 2</strong>: Use the solution of the error to create new accelerate config and check that no ambiguity error is now thrown.",$t,Es,ze="<li>Run <code>accelerate config</code>:</li>",Lt,Qs,Dt,Z,Ye="<li>Content of the <code>accelerate</code> config:</li>",Pt,Fs,Ot,_,Re="<li>Output of <code>accelerate launch test.py</code>:</li>",Kt,ks,sa,qs,xe="<strong>Scenario 3</strong>: Setting the <code>accelerate launch</code> command arguments related to DeepSpeed as <code>&quot;auto&quot;</code> in the DeepSpeed` configuration file and check that things work as expected.",la,Hs,Ee="<li>New <code>ds_config.json</code> with <code>&quot;auto&quot;</code> for the <code>accelerate launch</code> DeepSpeed command arguments:</li>",ta,$s,aa,B,Qe="<li>Output of <code>accelerate launch --mixed_precision=&quot;fp16&quot; --zero_stage=3 --gradient_accumulation_steps=5 --gradient_clipping=1.0 --offload_param_device=&quot;cpu&quot; --offload_optimizer_device=&quot;nvme&quot; --zero3_save_16bit_model=&quot;true&quot; test.py</code>:</li>",ea,Ls,na,Ds,Fe="<strong>Note</strong>:",pa,Ps,ke=`<li>Remaining <code>&quot;auto&quot;</code> values are handled in <code>accelerator.prepare()</code> call as explained in point 2 of
<code>Important code changes when using DeepSpeed Config File</code>.</li> <li>Only when <code>gradient_accumulation_steps</code> is <code>auto</code>, the value passed while creating <code>Accelerator</code> object via <code>Accelerator(gradient_accumulation_steps=k)</code> will be used. When using DeepSpeed Plugin, the value from it will be used and it will overwrite the value passed while creating Accelerator object.</li>`,Ma,Os,ia,g,ml,qe="<p>Saving and loading of models is unchanged for ZeRO Stage-1 and Stage-2.</p>",Aa,r,fl,He=`under ZeRO Stage-3, <code>state_dict</code> contains just the placeholders since the model weights are partitioned across multiple GPUs.
ZeRO Stage-3 has 2 options:`,Wa,bl,$e=`a. Saving the entire 16bit model weights to directly load later on using <code>model.load_state_dict(torch.load(pytorch_model.bin))</code>.
For this, either set <code>zero_optimization.stage3_gather_16bit_weights_on_model_save</code> to True in DeepSpeed Config file or set
<code>zero3_save_16bit_model</code> to True in DeepSpeed Plugin.
<strong>Note that this option requires consolidation of the weights on one GPU it can be slow and memory demanding, so only use this feature when needed.</strong>
Below is the snippet from <code>examples/by_feature/deepspeed_with_config_support.py</code> showing this:`,Xa,Ks,Sa,Cl,Le=`b. To get 32bit weights, first save the model using <code>model.save_checkpoint()</code>.
Below is the snippet from <code>examples/by_feature/deepspeed_with_config_support.py</code> showing this:`,Na,sl,Ga,Zl,De=`This will create ZeRO model and optimizer partitions along with <code>zero_to_fp32.py</code> script in checkpoint directory.
You can use this script to do offline consolidation.<br/>
It requires no configuration files or GPUs. Here is an example of its usage:`,va,ll,Va,_l,Pe="To get 32bit model for saving/inference, you can perform:",za,tl,Ya,Bl,Oe="If you are only interested in the <code>state_dict</code>, you can do the following:",Ra,al,xa,gl,Ke="Note that all these functions require ~2x memory (general RAM) of the size of the final checkpoint.",ca,el,oa,nl,sn=`DeepSpeed ZeRO Inference supports ZeRO stage 3 with ZeRO-Infinity.
It uses the same ZeRO protocol as training, but it doesn’t use an optimizer and a lr scheduler and only stage 3 is relevant.
With accelerate integration, you just need to prepare the model and dataloader as shown below:`,Ja,pl,ua,Ml,ja,il,ln="<li>Current integration doesn’t support Pipeline Parallelism of DeepSpeed.</li> <li>Current integration doesn’t support <code>mpu</code>, limiting the tensor parallelism which is supported in Megatron-LM.</li> <li>Current integration doesn’t support multiple models.</li>",wa,cl,Ta,ol,tn='The documentation for the internals related to deepspeed can be found <a href="../package_reference/deepspeed">here</a>.',ya,Jl,an='<li><a href="https://github.com/microsoft/deepspeed" rel="nofollow">Project’s github</a></li> <li><a href="https://www.deepspeed.ai/getting-started/" rel="nofollow">Usage docs</a></li> <li><a href="https://deepspeed.readthedocs.io/en/latest/index.html" rel="nofollow">API docs</a></li> <li><a href="https://www.microsoft.com/en-us/research/search/?q=deepspeed" rel="nofollow">Blog posts</a></li>',ra,ul,en="Papers:",Ua,jl,nn='<li><a href="https://arxiv.org/abs/1910.02054" rel="nofollow">ZeRO: Memory Optimizations Toward Training Trillion Parameter Models</a></li> <li><a href="https://arxiv.org/abs/2101.06840" rel="nofollow">ZeRO-Offload: Democratizing Billion-Scale Model Training</a></li> <li><a href="https://arxiv.org/abs/2104.07857" rel="nofollow">ZeRO-Infinity: Breaking the GPU Memory Wall for Extreme Scale Deep Learning</a></li>',ha,wl,pn=`Finally, please, remember that 🤗 <code>Accelerate</code> only integrates DeepSpeed, therefore if you
have any problems or questions with regards to DeepSpeed usage, please, file an issue with <a href="https://github.com/microsoft/DeepSpeed/issues" rel="nofollow">DeepSpeed GitHub</a>.`,da,Xl,Ia;return A=new m({props:{title:"DeepSpeed",local:"deepspeed",headingTag:"h1"}}),z=new m({props:{title:"What is integrated?",local:"what-is-integrated",headingTag:"h2"}}),D=new m({props:{title:"How it works?",local:"how-it-works",headingTag:"h2"}}),K=new m({props:{title:"Accelerate DeepSpeed Plugin",local:"accelerate-deepspeed-plugin",headingTag:"h3"}}),ls=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),as=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMG15X3NjcmlwdC5weSUyMC0tYXJnc190b19teV9zY3JpcHQ=",highlighted:"accelerate launch my_script.py --args_to_my_script",wrap:!1}}),ps=new y({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWVwc3BlZWRfY29uZmlnJTNBJTBBJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNBJTIwMSUwQSUyMGdyYWRpZW50X2NsaXBwaW5nJTNBJTIwMS4wJTBBJTIwb2ZmbG9hZF9vcHRpbWl6ZXJfZGV2aWNlJTNBJTIwbm9uZSUwQSUyMG9mZmxvYWRfcGFyYW1fZGV2aWNlJTNBJTIwbm9uZSUwQSUyMHplcm8zX2luaXRfZmxhZyUzQSUyMHRydWUlMEElMjB6ZXJvX3N0YWdlJTNBJTIwMiUwQWRpc3RyaWJ1dGVkX3R5cGUlM0ElMjBERUVQU1BFRUQlMEFmc2RwX2NvbmZpZyUzQSUyMCU3QiU3RCUwQW1hY2hpbmVfcmFuayUzQSUyMDAlMEFtYWluX3Byb2Nlc3NfaXAlM0ElMjBudWxsJTBBbWFpbl9wcm9jZXNzX3BvcnQlM0ElMjBudWxsJTBBbWFpbl90cmFpbmluZ19mdW5jdGlvbiUzQSUyMG1haW4lMEFtaXhlZF9wcmVjaXNpb24lM0ElMjBmcDE2JTBBbnVtX21hY2hpbmVzJTNBJTIwMSUwQW51bV9wcm9jZXNzZXMlM0ElMjAyJTBBdXNlX2NwdSUzQSUyMGZhbHNl",highlighted:`compute_environment: LOCAL_MACHINE
deepspeed_config:
 gradient_accumulation_steps: 1
 gradient_clipping: 1.0
 offload_optimizer_device: none
 offload_param_device: none
 zero3_init_flag: <span class="hljs-literal">true</span>
 zero_stage: 2
distributed_type: DEEPSPEED
fsdp_config: {}
machine_rank: 0
main_process_ip: null
main_process_port: null
main_training_function: main
mixed_precision: fp16
num_machines: 1
num_processes: 2
use_cpu: <span class="hljs-literal">false</span>`,wrap:!1}}),Ms=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMGV4YW1wbGVzJTJGbmxwX2V4YW1wbGUucHklMjAtLW1peGVkX3ByZWNpc2lvbiUyMGZwMTY=",highlighted:"accelerate launch examples/nlp_example.py --mixed_precision fp16",wrap:!1}}),cs=new y({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWVwc3BlZWRfY29uZmlnJTNBJTBBJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNBJTIwMSUwQSUyMCUyMGdyYWRpZW50X2NsaXBwaW5nJTNBJTIwMS4wJTBBJTIwJTIwb2ZmbG9hZF9vcHRpbWl6ZXJfZGV2aWNlJTNBJTIwY3B1JTBBJTIwJTIwb2ZmbG9hZF9wYXJhbV9kZXZpY2UlM0ElMjBjcHUlMEElMjAlMjB6ZXJvM19pbml0X2ZsYWclM0ElMjB0cnVlJTBBJTIwJTIwemVybzNfc2F2ZV8xNmJpdF9tb2RlbCUzQSUyMHRydWUlMEElMjAlMjB6ZXJvX3N0YWdlJTNBJTIwMyUwQWRpc3RyaWJ1dGVkX3R5cGUlM0ElMjBERUVQU1BFRUQlMEFmc2RwX2NvbmZpZyUzQSUyMCU3QiU3RCUwQW1hY2hpbmVfcmFuayUzQSUyMDAlMEFtYWluX3Byb2Nlc3NfaXAlM0ElMjBudWxsJTBBbWFpbl9wcm9jZXNzX3BvcnQlM0ElMjBudWxsJTBBbWFpbl90cmFpbmluZ19mdW5jdGlvbiUzQSUyMG1haW4lMEFtaXhlZF9wcmVjaXNpb24lM0ElMjBmcDE2JTBBbnVtX21hY2hpbmVzJTNBJTIwMSUwQW51bV9wcm9jZXNzZXMlM0ElMjAyJTBBdXNlX2NwdSUzQSUyMGZhbHNl",highlighted:`compute_environment: LOCAL_MACHINE
deepspeed_config:
  gradient_accumulation_steps: 1
  gradient_clipping: 1.0
  offload_optimizer_device: cpu
  offload_param_device: cpu
  zero3_init_flag: <span class="hljs-literal">true</span>
  zero3_save_16bit_model: <span class="hljs-literal">true</span>
  zero_stage: 3
distributed_type: DEEPSPEED
fsdp_config: {}
machine_rank: 0
main_process_ip: null
main_process_port: null
main_training_function: main
mixed_precision: fp16
num_machines: 1
num_processes: 2
use_cpu: <span class="hljs-literal">false</span>`,wrap:!1}}),os=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMGV4YW1wbGVzJTJGbmxwX2V4YW1wbGUucHklMjAtLW1peGVkX3ByZWNpc2lvbiUyMGZwMTY=",highlighted:"accelerate launch examples/nlp_example.py --mixed_precision fp16",wrap:!1}}),us=new y({props:{code:"JTYwemVyb19zdGFnZSU2MCUzQSUyMCU1QjAlNUQlMjBEaXNhYmxlZCUyQyUyMCU1QjElNUQlMjBvcHRpbWl6ZXIlMjBzdGF0ZSUyMHBhcnRpdGlvbmluZyUyQyUyMCU1QjIlNUQlMjBvcHRpbWl6ZXIlMkJncmFkaWVudCUyMHN0YXRlJTIwcGFydGl0aW9uaW5nJTIwYW5kJTIwJTVCMyU1RCUyMG9wdGltaXplciUyQmdyYWRpZW50JTJCcGFyYW1ldGVyJTIwcGFydGl0aW9uaW5nJTBBJTYwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTYwJTNBJTIwTnVtYmVyJTIwb2YlMjB0cmFpbmluZyUyMHN0ZXBzJTIwdG8lMjBhY2N1bXVsYXRlJTIwZ3JhZGllbnRzJTIwYmVmb3JlJTIwYXZlcmFnaW5nJTIwYW5kJTIwYXBwbHlpbmclMjB0aGVtLiUwQSU2MGdyYWRpZW50X2NsaXBwaW5nJTYwJTNBJTIwRW5hYmxlJTIwZ3JhZGllbnQlMjBjbGlwcGluZyUyMHdpdGglMjB2YWx1ZS4lMEElNjBvZmZsb2FkX29wdGltaXplcl9kZXZpY2UlNjAlM0ElMjAlNUJub25lJTVEJTIwRGlzYWJsZSUyMG9wdGltaXplciUyMG9mZmxvYWRpbmclMkMlMjAlNUJjcHUlNUQlMjBvZmZsb2FkJTIwb3B0aW1pemVyJTIwdG8lMjBDUFUlMkMlMjAlNUJudm1lJTVEJTIwb2ZmbG9hZCUyMG9wdGltaXplciUyMHRvJTIwTlZNZSUyMFNTRC4lMjBPbmx5JTIwYXBwbGljYWJsZSUyMHdpdGglMjBaZVJPJTIwJTNFJTNEJTIwU3RhZ2UtMi4lMEElNjBvZmZsb2FkX3BhcmFtX2RldmljZSU2MCUzQSUyMCU1Qm5vbmUlNUQlMjBEaXNhYmxlJTIwcGFyYW1ldGVyJTIwb2ZmbG9hZGluZyUyQyUyMCU1QmNwdSU1RCUyMG9mZmxvYWQlMjBwYXJhbWV0ZXJzJTIwdG8lMjBDUFUlMkMlMjAlNUJudm1lJTVEJTIwb2ZmbG9hZCUyMHBhcmFtZXRlcnMlMjB0byUyME5WTWUlMjBTU0QuJTIwT25seSUyMGFwcGxpY2FibGUlMjB3aXRoJTIwWmVSTyUyMFN0YWdlLTMuJTBBJTYwemVybzNfaW5pdF9mbGFnJTYwJTNBJTIwRGVjaWRlcyUyMHdoZXRoZXIlMjB0byUyMGVuYWJsZSUyMCU2MGRlZXBzcGVlZC56ZXJvLkluaXQlNjAlMjBmb3IlMjBjb25zdHJ1Y3RpbmclMjBtYXNzaXZlJTIwbW9kZWxzLiUyME9ubHklMjBhcHBsaWNhYmxlJTIwd2l0aCUyMFplUk8lMjBTdGFnZS0zLiUwQSU2MHplcm8zX3NhdmVfMTZiaXRfbW9kZWwlNjAlM0ElMjBEZWNpZGVzJTIwd2hldGhlciUyMHRvJTIwc2F2ZSUyMDE2LWJpdCUyMG1vZGVsJTIwd2VpZ2h0cyUyMHdoZW4lMjB1c2luZyUyMFplUk8lMjBTdGFnZS0zLiUwQSU2MG1peGVkX3ByZWNpc2lvbiU2MCUzQSUyMCU2MG5vJTYwJTIwZm9yJTIwRlAzMiUyMHRyYWluaW5nJTJDJTIwJTYwZnAxNiU2MCUyMGZvciUyMEZQMTYlMjBtaXhlZC1wcmVjaXNpb24lMjB0cmFpbmluZyUyMGFuZCUyMCU2MGJmMTYlNjAlMjBmb3IlMjBCRjE2JTIwbWl4ZWQtcHJlY2lzaW9uJTIwdHJhaW5pbmcuJTIw",highlighted:'`zero_stage`: [0] Disabled, [1] optimizer state partitioning, [2] optimizer+gradient state partitioning and [3] optimizer+gradient+parameter partitioning\n`gradient_accumulation_steps`: Number of training steps to accumulate gradients before averaging and applying them.\n`gradient_clipping`: Enable gradient clipping with value.\n`offload_optimizer_device`: [none] Disable optimizer offloading, [cpu] offload optimizer to CPU, [nvme] offload optimizer to NVMe SSD. Only applicable with ZeRO &gt;= Stage-2.\n`offload_param_device`: [none] Disable parameter offloading, [cpu] offload parameters to CPU, [nvme] offload parameters to NVMe SSD. Only applicable with ZeRO Stage-3.\n`zero3_init_flag`: Decides whether to <span class="hljs-built_in">enable</span> `deepspeed.zero.Init` <span class="hljs-keyword">for</span> constructing massive models. Only applicable with ZeRO Stage-3.\n`zero3_save_16bit_model`: Decides whether to save 16-bit model weights when using ZeRO Stage-3.\n`mixed_precision`: `no` <span class="hljs-keyword">for</span> FP32 training, `fp16` <span class="hljs-keyword">for</span> FP16 mixed-precision training and `bf16` <span class="hljs-keyword">for</span> BF16 mixed-precision training. ',wrap:!1}}),ws=new m({props:{title:"DeepSpeed Config File",local:"deepspeed-config-file",headingTag:"h3"}}),ys=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),Us=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMG15X3NjcmlwdC5weSUyMC0tYXJnc190b19teV9zY3JpcHQ=",highlighted:"accelerate launch my_script.py --args_to_my_script",wrap:!1}}),Is=new y({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWVwc3BlZWRfY29uZmlnJTNBJTBBJTIwZGVlcHNwZWVkX2NvbmZpZ19maWxlJTNBJTIwJTJGaG9tZSUyRnVidW50dSUyRmFjY2VsZXJhdGUlMkZleGFtcGxlcyUyRmNvbmZpZ3MlMkZkZWVwc3BlZWRfY29uZmlnX3RlbXBsYXRlcyUyRnplcm9fc3RhZ2UyX2NvbmZpZy5qc29uJTBBJTIwemVybzNfaW5pdF9mbGFnJTNBJTIwdHJ1ZSUwQWRpc3RyaWJ1dGVkX3R5cGUlM0ElMjBERUVQU1BFRUQlMEFmc2RwX2NvbmZpZyUzQSUyMCU3QiU3RCUwQW1hY2hpbmVfcmFuayUzQSUyMDAlMEFtYWluX3Byb2Nlc3NfaXAlM0ElMjBudWxsJTBBbWFpbl9wcm9jZXNzX3BvcnQlM0ElMjBudWxsJTBBbWFpbl90cmFpbmluZ19mdW5jdGlvbiUzQSUyMG1haW4lMEFtaXhlZF9wcmVjaXNpb24lM0ElMjBmcDE2JTBBbnVtX21hY2hpbmVzJTNBJTIwMSUwQW51bV9wcm9jZXNzZXMlM0ElMjAyJTBBdXNlX2NwdSUzQSUyMGZhbHNl",highlighted:`compute_environment: LOCAL_MACHINE
deepspeed_config:
 deepspeed_config_file: /home/ubuntu/accelerate/examples/configs/deepspeed_config_templates/zero_stage2_config.json
 zero3_init_flag: <span class="hljs-literal">true</span>
distributed_type: DEEPSPEED
fsdp_config: {}
machine_rank: 0
main_process_ip: null
main_process_port: null
main_training_function: main
mixed_precision: fp16
num_machines: 1
num_processes: 2
use_cpu: <span class="hljs-literal">false</span>`,wrap:!1}}),fs=new y({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;torch_adam&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;adam_w_mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupDecayLR&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;total_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_partitions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_scatter&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;wall_clock_breakdown&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),bs=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMGV4YW1wbGVzJTJGYnlfZmVhdHVyZSUyRmRlZXBzcGVlZF93aXRoX2NvbmZpZ19zdXBwb3J0LnB5JTIwJTVDJTBBLS1jb25maWdfbmFtZSUyMCUyMmdwdDItbGFyZ2UlMjIlMjAlNUMlMEEtLXRva2VuaXplcl9uYW1lJTIwJTIyZ3B0Mi1sYXJnZSUyMiUyMCU1QyUwQS0tZGF0YXNldF9uYW1lJTIwJTIyd2lraXRleHQlMjIlMjAlNUMlMEEtLWRhdGFzZXRfY29uZmlnX25hbWUlMjAlMjJ3aWtpdGV4dC0yLXJhdy12MSUyMiUyMCU1QyUwQS0tYmxvY2tfc2l6ZSUyMDEyOCUyMCU1QyUwQS0tb3V0cHV0X2RpciUyMCUyMi4lMkZjbG0lMkZjbG1fZGVlcHNwZWVkX3N0YWdlMl9hY2NlbGVyYXRlJTIyJTIwJTVDJTBBLS1sZWFybmluZ19yYXRlJTIwNWUtNCUyMCU1QyUwQS0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwMjQlMjAlNUMlMEEtLXBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTIwMjQlMjAlNUMlMEEtLW51bV90cmFpbl9lcG9jaHMlMjAzJTIwJTVDJTBBLS13aXRoX3RyYWNraW5nJTIwJTVDJTBBLS1yZXBvcnRfdG8lMjAlMjJ3YW5kYiUyMiU1Qw==",highlighted:`accelerate launch examples/by_feature/deepspeed_with_config_support.py \\
--config_name <span class="hljs-string">&quot;gpt2-large&quot;</span> \\
--tokenizer_name <span class="hljs-string">&quot;gpt2-large&quot;</span> \\
--dataset_name <span class="hljs-string">&quot;wikitext&quot;</span> \\
--dataset_config_name <span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span> \\
--block_size 128 \\
--output_dir <span class="hljs-string">&quot;./clm/clm_deepspeed_stage2_accelerate&quot;</span> \\
--learning_rate 5e-4 \\
--per_device_train_batch_size 24 \\
--per_device_eval_batch_size 24 \\
--num_train_epochs 3 \\
--with_tracking \\
--report_to <span class="hljs-string">&quot;wandb&quot;</span>\\`,wrap:!1}}),Zs=new y({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWVwc3BlZWRfY29uZmlnJTNBJTBBJTIwZGVlcHNwZWVkX2NvbmZpZ19maWxlJTNBJTIwJTJGaG9tZSUyRnVidW50dSUyRmFjY2VsZXJhdGUlMkZleGFtcGxlcyUyRmNvbmZpZ3MlMkZkZWVwc3BlZWRfY29uZmlnX3RlbXBsYXRlcyUyRnplcm9fc3RhZ2UzX29mZmxvYWRfY29uZmlnLmpzb24lMEElMjB6ZXJvM19pbml0X2ZsYWclM0ElMjB0cnVlJTBBZGlzdHJpYnV0ZWRfdHlwZSUzQSUyMERFRVBTUEVFRCUwQWZzZHBfY29uZmlnJTNBJTIwJTdCJTdEJTBBbWFjaGluZV9yYW5rJTNBJTIwMCUwQW1haW5fcHJvY2Vzc19pcCUzQSUyMG51bGwlMEFtYWluX3Byb2Nlc3NfcG9ydCUzQSUyMG51bGwlMEFtYWluX3RyYWluaW5nX2Z1bmN0aW9uJTNBJTIwbWFpbiUwQW1peGVkX3ByZWNpc2lvbiUzQSUyMGZwMTYlMEFudW1fbWFjaGluZXMlM0ElMjAxJTBBbnVtX3Byb2Nlc3NlcyUzQSUyMDIlMEF1c2VfY3B1JTNBJTIwZmFsc2U=",highlighted:`compute_environment: LOCAL_MACHINE
deepspeed_config:
 deepspeed_config_file: /home/ubuntu/accelerate/examples/configs/deepspeed_config_templates/zero_stage3_offload_config.json
 zero3_init_flag: <span class="hljs-literal">true</span>
distributed_type: DEEPSPEED
fsdp_config: {}
machine_rank: 0
main_process_ip: null
main_process_port: null
main_training_function: main
mixed_precision: fp16
num_machines: 1
num_processes: 2
use_cpu: <span class="hljs-literal">false</span>`,wrap:!1}}),Bs=new y({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupDecayLR&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;total_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_param&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_prefetch_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_param_persistence_threshold&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;sub_group_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_live_parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_reuse_distance&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;wall_clock_breakdown&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),gs=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMGV4YW1wbGVzJTJGYnlfZmVhdHVyZSUyRmRlZXBzcGVlZF93aXRoX2NvbmZpZ19zdXBwb3J0LnB5JTIwJTVDJTBBLS1jb25maWdfbmFtZSUyMCUyMmdwdDItbGFyZ2UlMjIlMjAlNUMlMEEtLXRva2VuaXplcl9uYW1lJTIwJTIyZ3B0Mi1sYXJnZSUyMiUyMCU1QyUwQS0tZGF0YXNldF9uYW1lJTIwJTIyd2lraXRleHQlMjIlMjAlNUMlMEEtLWRhdGFzZXRfY29uZmlnX25hbWUlMjAlMjJ3aWtpdGV4dC0yLXJhdy12MSUyMiUyMCU1QyUwQS0tYmxvY2tfc2l6ZSUyMDEyOCUyMCU1QyUwQS0tb3V0cHV0X2RpciUyMCUyMi4lMkZjbG0lMkZjbG1fZGVlcHNwZWVkX3N0YWdlM19vZmZsb2FkX2FjY2VsZXJhdGUlMjIlMjAlNUMlMEEtLWxlYXJuaW5nX3JhdGUlMjA1ZS00JTIwJTVDJTBBLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAzMiUyMCU1QyUwQS0tcGVyX2RldmljZV9ldmFsX2JhdGNoX3NpemUlMjAzMiUyMCU1QyUwQS0tbnVtX3RyYWluX2Vwb2NocyUyMDMlMjAlNUMlMEEtLXdpdGhfdHJhY2tpbmclMjAlNUMlMEEtLXJlcG9ydF90byUyMCUyMndhbmRiJTIyJTVD",highlighted:`accelerate launch examples/by_feature/deepspeed_with_config_support.py \\
--config_name <span class="hljs-string">&quot;gpt2-large&quot;</span> \\
--tokenizer_name <span class="hljs-string">&quot;gpt2-large&quot;</span> \\
--dataset_name <span class="hljs-string">&quot;wikitext&quot;</span> \\
--dataset_config_name <span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span> \\
--block_size 128 \\
--output_dir <span class="hljs-string">&quot;./clm/clm_deepspeed_stage3_offload_accelerate&quot;</span> \\
--learning_rate 5e-4 \\
--per_device_train_batch_size 32 \\
--per_device_eval_batch_size 32 \\
--num_train_epochs 3 \\
--with_tracking \\
--report_to <span class="hljs-string">&quot;wandb&quot;</span>\\`,wrap:!1}}),Ws=new y({props:{code:"JTIwJTIzJTIwQ3JlYXRlcyUyMER1bW15JTIwT3B0aW1pemVyJTIwaWYlMjAlNjBvcHRpbWl6ZXIlNjAlMjB3YXMlMjBzcGNpZmllZCUyMGluJTIwdGhlJTIwY29uZmlnJTIwZmlsZSUyMGVsc2UlMjBjcmVhdGVzJTIwQWRhbSUyME9wdGltaXplciUwQSUyMG9wdGltaXplcl9jbHMlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIwdG9yY2gub3B0aW0uQWRhbVclMEElMjAlMjAlMjAlMjAlMjBpZiUyMGFjY2VsZXJhdG9yLnN0YXRlLmRlZXBzcGVlZF9wbHVnaW4lMjBpcyUyME5vbmUlMEElMjAlMjAlMjAlMjAlMjBvciUyMCUyMm9wdGltaXplciUyMiUyMG5vdCUyMGluJTIwYWNjZWxlcmF0b3Iuc3RhdGUuZGVlcHNwZWVkX3BsdWdpbi5kZWVwc3BlZWRfY29uZmlnJTBBJTIwJTIwJTIwJTIwJTIwZWxzZSUyMER1bW15T3B0aW0lMEElMjApJTBBJTIwb3B0aW1pemVyJTIwJTNEJTIwb3B0aW1pemVyX2NscyhvcHRpbWl6ZXJfZ3JvdXBlZF9wYXJhbWV0ZXJzJTJDJTIwbHIlM0RhcmdzLmxlYXJuaW5nX3JhdGUpJTBBJTBBJTIwJTIzJTIwQ3JlYXRlcyUyMER1bW15JTIwU2NoZWR1bGVyJTIwaWYlMjAlNjBzY2hlZHVsZXIlNjAlMjB3YXMlMjBzcGNpZmllZCUyMGluJTIwdGhlJTIwY29uZmlnJTIwZmlsZSUyMGVsc2UlMjBjcmVhdGVzJTIwJTYwYXJncy5scl9zY2hlZHVsZXJfdHlwZSU2MCUyMFNjaGVkdWxlciUwQSUyMGlmJTIwKCUwQSUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLnN0YXRlLmRlZXBzcGVlZF9wbHVnaW4lMjBpcyUyME5vbmUlMEElMjAlMjAlMjAlMjAlMjBvciUyMCUyMnNjaGVkdWxlciUyMiUyMG5vdCUyMGluJTIwYWNjZWxlcmF0b3Iuc3RhdGUuZGVlcHNwZWVkX3BsdWdpbi5kZWVwc3BlZWRfY29uZmlnJTBBJTIwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlciUyMCUzRCUyMGdldF9zY2hlZHVsZXIoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmFtZSUzRGFyZ3MubHJfc2NoZWR1bGVyX3R5cGUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fd2FybXVwX3N0ZXBzJTNEYXJncy5udW1fd2FybXVwX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEYXJncy5tYXhfdHJhaW5fc3RlcHMlMkMlMEElMjAlMjAlMjAlMjAlMjApJTBBJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlciUyMCUzRCUyMER1bW15U2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplciUyQyUyMHRvdGFsX251bV9zdGVwcyUzRGFyZ3MubWF4X3RyYWluX3N0ZXBzJTJDJTIwd2FybXVwX251bV9zdGVwcyUzRGFyZ3MubnVtX3dhcm11cF9zdGVwcyUwQSUyMCUyMCUyMCUyMCUyMCk=",highlighted:` <span class="hljs-comment"># Creates Dummy Optimizer if \`optimizer\` was spcified in the config file else creates Adam Optimizer</span>
 optimizer_cls = (
     torch.optim.AdamW
     <span class="hljs-keyword">if</span> accelerator.state.deepspeed_plugin <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>
     <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;optimizer&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> accelerator.state.deepspeed_plugin.deepspeed_config
     <span class="hljs-keyword">else</span> DummyOptim
 )
 optimizer = optimizer_cls(optimizer_grouped_parameters, lr=args.learning_rate)

 <span class="hljs-comment"># Creates Dummy Scheduler if \`scheduler\` was spcified in the config file else creates \`args.lr_scheduler_type\` Scheduler</span>
 <span class="hljs-keyword">if</span> (
     accelerator.state.deepspeed_plugin <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>
     <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;scheduler&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> accelerator.state.deepspeed_plugin.deepspeed_config
 ):
     lr_scheduler = get_scheduler(
         name=args.lr_scheduler_type,
         optimizer=optimizer,
         num_warmup_steps=args.num_warmup_steps,
         num_training_steps=args.max_train_steps,
     )
 <span class="hljs-keyword">else</span>:
     lr_scheduler = DummyScheduler(
         optimizer, total_num_steps=args.max_train_steps, warmup_num_steps=args.num_warmup_steps
     )`,wrap:!1}}),Gs=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnN0YXRlJTIwaW1wb3J0JTIwQWNjZWxlcmF0b3JTdGF0ZSUwQSUwQSUwQWRlZiUyMG1haW4oKSUzQSUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLnByaW50KGYlMjIlN0JBY2NlbGVyYXRvclN0YXRlKCklN0QlMjIpJTBBJTBBJTBBaWYlMjBfX25hbWVfXyUyMCUzRCUzRCUyMCUyMl9fbWFpbl9fJTIyJTNBJTBBJTIwJTIwJTIwJTIwbWFpbigp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> AcceleratorState


<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    accelerator = Accelerator()
    accelerator.<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{AcceleratorState()}</span>&quot;</span>)


<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    main()`,wrap:!1}}),zs=new y({props:{code:"Y29tbWFuZF9maWxlJTNBJTIwbnVsbCUwQWNvbW1hbmRzJTNBJTIwbnVsbCUwQWNvbXB1dGVfZW52aXJvbm1lbnQlM0ElMjBMT0NBTF9NQUNISU5FJTBBZGVlcHNwZWVkX2NvbmZpZyUzQSUwQSUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzQSUyMDElMEElMjAlMjBncmFkaWVudF9jbGlwcGluZyUzQSUyMDEuMCUwQSUyMCUyMG9mZmxvYWRfb3B0aW1pemVyX2RldmljZSUzQSUyMCdjcHUnJTBBJTIwJTIwb2ZmbG9hZF9wYXJhbV9kZXZpY2UlM0ElMjAnY3B1JyUwQSUyMCUyMHplcm8zX2luaXRfZmxhZyUzQSUyMHRydWUlMEElMjAlMjB6ZXJvM19zYXZlXzE2Yml0X21vZGVsJTNBJTIwdHJ1ZSUwQSUyMCUyMHplcm9fc3RhZ2UlM0ElMjAzJTBBJTIwJTIwZGVlcHNwZWVkX2NvbmZpZ19maWxlJTNBJTIwJ2RzX2NvbmZpZy5qc29uJyUwQWRpc3RyaWJ1dGVkX3R5cGUlM0ElMjBERUVQU1BFRUQlMEFkb3duY2FzdF9iZjE2JTNBJTIwJ25vJyUwQWR5bmFtb19iYWNrZW5kJTNBJTIwJ05PJyUwQWZzZHBfY29uZmlnJTNBJTIwJTdCJTdEJTBBZ3B1X2lkcyUzQSUyMG51bGwlMEFtYWNoaW5lX3JhbmslM0ElMjAwJTBBbWFpbl9wcm9jZXNzX2lwJTNBJTIwbnVsbCUwQW1haW5fcHJvY2Vzc19wb3J0JTNBJTIwbnVsbCUwQW1haW5fdHJhaW5pbmdfZnVuY3Rpb24lM0ElMjBtYWluJTBBbWVnYXRyb25fbG1fY29uZmlnJTNBJTIwJTdCJTdEJTBBbnVtX21hY2hpbmVzJTNBJTIwMSUwQW51bV9wcm9jZXNzZXMlM0ElMjAyJTBBcmR6dl9iYWNrZW5kJTNBJTIwc3RhdGljJTBBc2FtZV9uZXR3b3JrJTNBJTIwdHJ1ZSUwQXRwdV9uYW1lJTNBJTIwbnVsbCUwQXRwdV96b25lJTNBJTIwbnVsbCUwQXVzZV9jcHUlM0ElMjBmYWxzZQ==",highlighted:`<span class="hljs-attr">command_file:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">commands:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>
<span class="hljs-attr">deepspeed_config:</span>
  <span class="hljs-attr">gradient_accumulation_steps:</span> <span class="hljs-number">1</span>
  <span class="hljs-attr">gradient_clipping:</span> <span class="hljs-number">1.0</span>
  <span class="hljs-attr">offload_optimizer_device:</span> <span class="hljs-string">&#x27;cpu&#x27;</span>
  <span class="hljs-attr">offload_param_device:</span> <span class="hljs-string">&#x27;cpu&#x27;</span>
  <span class="hljs-attr">zero3_init_flag:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">zero3_save_16bit_model:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">zero_stage:</span> <span class="hljs-number">3</span>
  <span class="hljs-attr">deepspeed_config_file:</span> <span class="hljs-string">&#x27;ds_config.json&#x27;</span>
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">DEEPSPEED</span>
<span class="hljs-attr">downcast_bf16:</span> <span class="hljs-string">&#x27;no&#x27;</span>
<span class="hljs-attr">dynamo_backend:</span> <span class="hljs-string">&#x27;NO&#x27;</span>
<span class="hljs-attr">fsdp_config:</span> {}
<span class="hljs-attr">gpu_ids:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">main_process_ip:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">main_process_port:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">megatron_lm_config:</span> {}
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">2</span>
<span class="hljs-attr">rdzv_backend:</span> <span class="hljs-string">static</span>
<span class="hljs-attr">same_network:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">tpu_name:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">tpu_zone:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),Ys=new y({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyYmYxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMDMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZTNfZ2F0aGVyXzE2Yml0X3dlaWdodHNfb25fbW9kZWxfc2F2ZSUyMiUzQSUyMGZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb2ZmbG9hZF9vcHRpbWl6ZXIlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkZXZpY2UlMjIlM0ElMjAlMjJub25lJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb2ZmbG9hZF9wYXJhbSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRldmljZSUyMiUzQSUyMCUyMm5vbmUlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJncmFkaWVudF9jbGlwcGluZyUyMiUzQSUyMDEuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRyYWluX2JhdGNoX3NpemUlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhaW5fbWljcm9fYmF0Y2hfc2l6ZV9wZXJfZ3B1JTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMiUzQSUyMDEwJTJDJTBBJTIwJTIwJTIwJTIwJTIyc3RlcHNfcGVyX3ByaW50JTIyJTNBJTIwMjAwMDAwMCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;bf16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;none&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_param&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;none&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1.0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">10</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000000</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Rs=new y({props:{code:"VmFsdWVFcnJvciUzQSUyMFdoZW4lMjB1c2luZyUyMCU2MGRlZXBzcGVlZF9jb25maWdfZmlsZSU2MCUyQyUyMHRoZSUyMGZvbGxvd2luZyUyMGFjY2VsZXJhdGUlMjBjb25maWclMjB2YXJpYWJsZXMlMjB3aWxsJTIwYmUlMjBpZ25vcmVkJTNBJTIwJTBBJTVCJ2dyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyclMkMlMjAnZ3JhZGllbnRfY2xpcHBpbmcnJTJDJTIwJ3plcm9fc3RhZ2UnJTJDJTIwJ29mZmxvYWRfb3B0aW1pemVyX2RldmljZSclMkMlMjAnb2ZmbG9hZF9wYXJhbV9kZXZpY2UnJTJDJTIwJTBBJ3plcm8zX3NhdmVfMTZiaXRfbW9kZWwnJTJDJTIwJ21peGVkX3ByZWNpc2lvbiclNUQuJTBBUGxlYXNlJTIwc3BlY2lmeSUyMHRoZW0lMjBhcHByb3ByaWF0ZWx5JTIwaW4lMjB0aGUlMjBEZWVwU3BlZWQlMjBjb25maWclMjBmaWxlLiUwQUlmJTIweW91JTIwYXJlJTIwdXNpbmclMjBhbiUyMGFjY2VsZXJhdGUlMjBjb25maWclMjBmaWxlJTJDJTIwcmVtb3ZlJTIwb3RoZXJzJTIwY29uZmlnJTIwdmFyaWFibGVzJTIwbWVudGlvbmVkJTIwaW4lMjB0aGUlMjBhYm92ZSUyMHNwZWNpZmllZCUyMGxpc3QuJTBBVGhlJTIwZWFzaWVzdCUyMG1ldGhvZCUyMGlzJTIwdG8lMjBjcmVhdGUlMjBhJTIwbmV3JTIwY29uZmlnJTIwZm9sbG93aW5nJTIwdGhlJTIwcXVlc3Rpb25uYWlyZSUyMHZpYSUyMCU2MGFjY2VsZXJhdGUlMjBjb25maWclNjAuJTBBSXQlMjB3aWxsJTIwb25seSUyMGFzayUyMGZvciUyMHRoZSUyMG5lY2Vzc2FyeSUyMGNvbmZpZyUyMHZhcmlhYmxlcyUyMHdoZW4lMjB1c2luZyUyMCU2MGRlZXBzcGVlZF9jb25maWdfZmlsZSU2MC4=",highlighted:'ValueError: When using `deepspeed_config_file`, the following accelerate config variables will be ignored: \n[<span class="hljs-string">&#x27;gradient_accumulation_steps&#x27;</span>, <span class="hljs-string">&#x27;gradient_clipping&#x27;</span>, <span class="hljs-string">&#x27;zero_stage&#x27;</span>, <span class="hljs-string">&#x27;offload_optimizer_device&#x27;</span>, <span class="hljs-string">&#x27;offload_param_device&#x27;</span>, \n<span class="hljs-string">&#x27;zero3_save_16bit_model&#x27;</span>, <span class="hljs-string">&#x27;mixed_precision&#x27;</span>].\nPlease specify them appropriately <span class="hljs-keyword">in</span> the DeepSpeed config file.\nIf you are using an accelerate config file, remove others config variables mentioned <span class="hljs-keyword">in</span> the above specified list.\nThe easiest method is to create a new config following the questionnaire via `accelerate config`.\nIt will only ask <span class="hljs-keyword">for</span> the necessary config variables when using `deepspeed_config_file`.',wrap:!1}}),Qs=new y({props:{code:"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",highlighted:`$ accelerate config
-------------------------------------------------------------------------------------------------------------------------------
In <span class="hljs-built_in">which</span> compute environment are you running?
This machine                                                                                                                   
-------------------------------------------------------------------------------------------------------------------------------
Which <span class="hljs-built_in">type</span> of machine are you using?                                                                                           
multi-GPU                                                                                                                      
How many different machines will you use (use more than 1 <span class="hljs-keyword">for</span> multi-node training)? [1]:                                       
Do you wish to optimize your script with torch dynamo?[<span class="hljs-built_in">yes</span>/NO]:                                                                
Do you want to use DeepSpeed? [<span class="hljs-built_in">yes</span>/NO]: <span class="hljs-built_in">yes</span>                                                                                    
Do you want to specify a json file to a DeepSpeed config? [<span class="hljs-built_in">yes</span>/NO]: <span class="hljs-built_in">yes</span>                                                        
Please enter the path to the json DeepSpeed config file: ds_config.json                                                        
Do you want to <span class="hljs-built_in">enable</span> \`deepspeed.zero.Init\` when using ZeRO Stage-3 <span class="hljs-keyword">for</span> constructing massive models? [<span class="hljs-built_in">yes</span>/NO]: <span class="hljs-built_in">yes</span>
How many GPU(s) should be used <span class="hljs-keyword">for</span> distributed training? [1]:4
accelerate configuration saved at ds_config_sample.yaml`,wrap:!1}}),Fs=new y({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWVwc3BlZWRfY29uZmlnJTNBJTBBJTIwJTIwZGVlcHNwZWVkX2NvbmZpZ19maWxlJTNBJTIwZHNfY29uZmlnLmpzb24lMEElMjAlMjB6ZXJvM19pbml0X2ZsYWclM0ElMjB0cnVlJTBBZGlzdHJpYnV0ZWRfdHlwZSUzQSUyMERFRVBTUEVFRCUwQWRvd25jYXN0X2JmMTYlM0ElMjAnbm8nJTBBZHluYW1vX2JhY2tlbmQlM0ElMjAnTk8nJTBBZnNkcF9jb25maWclM0ElMjAlN0IlN0QlMEFtYWNoaW5lX3JhbmslM0ElMjAwJTBBbWFpbl90cmFpbmluZ19mdW5jdGlvbiUzQSUyMG1haW4lMEFtZWdhdHJvbl9sbV9jb25maWclM0ElMjAlN0IlN0QlMEFudW1fbWFjaGluZXMlM0ElMjAxJTBBbnVtX3Byb2Nlc3NlcyUzQSUyMDQlMEFyZHp2X2JhY2tlbmQlM0ElMjBzdGF0aWMlMEFzYW1lX25ldHdvcmslM0ElMjB0cnVlJTBBdXNlX2NwdSUzQSUyMGZhbHNl",highlighted:`<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>
<span class="hljs-attr">deepspeed_config:</span>
  <span class="hljs-attr">deepspeed_config_file:</span> <span class="hljs-string">ds_config.json</span>
  <span class="hljs-attr">zero3_init_flag:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">DEEPSPEED</span>
<span class="hljs-attr">downcast_bf16:</span> <span class="hljs-string">&#x27;no&#x27;</span>
<span class="hljs-attr">dynamo_backend:</span> <span class="hljs-string">&#x27;NO&#x27;</span>
<span class="hljs-attr">fsdp_config:</span> {}
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">megatron_lm_config:</span> {}
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">4</span>
<span class="hljs-attr">rdzv_backend:</span> <span class="hljs-string">static</span>
<span class="hljs-attr">same_network:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),ks=new y({props:{code:"RGlzdHJpYnV0ZWQlMjBlbnZpcm9ubWVudCUzQSUyMERFRVBTUEVFRCUyMCUyMEJhY2tlbmQlM0ElMjBuY2NsJTBBTnVtJTIwcHJvY2Vzc2VzJTNBJTIwNCUwQVByb2Nlc3MlMjBpbmRleCUzQSUyMDAlMEFMb2NhbCUyMHByb2Nlc3MlMjBpbmRleCUzQSUyMDAlMEFEZXZpY2UlM0ElMjBjdWRhJTNBMCUwQU1peGVkJTIwcHJlY2lzaW9uJTIwdHlwZSUzQSUyMGJmMTYlMEFkc19jb25maWclM0ElMjAlN0InYmYxNiclM0ElMjAlN0InZW5hYmxlZCclM0ElMjBUcnVlJTdEJTJDJTIwJ3plcm9fb3B0aW1pemF0aW9uJyUzQSUyMCU3QidzdGFnZSclM0ElMjAzJTJDJTIwJ3N0YWdlM19nYXRoZXJfMTZiaXRfd2VpZ2h0c19vbl9tb2RlbF9zYXZlJyUzQSUyMEZhbHNlJTJDJTIwJ29mZmxvYWRfb3B0aW1pemVyJyUzQSUyMCU3QidkZXZpY2UnJTNBJTIwJ25vbmUnJTdEJTJDJTIwJ29mZmxvYWRfcGFyYW0nJTNBJTIwJTdCJ2RldmljZSclM0ElMjAnbm9uZSclN0QlN0QlMkMlMjAnZ3JhZGllbnRfY2xpcHBpbmcnJTNBJTIwMS4wJTJDJTIwJ3RyYWluX2JhdGNoX3NpemUnJTNBJTIwJ2F1dG8nJTJDJTIwJ3RyYWluX21pY3JvX2JhdGNoX3NpemVfcGVyX2dwdSclM0ElMjAnYXV0byclMkMlMjAnZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJyUzQSUyMDEwJTJDJTIwJ3N0ZXBzX3Blcl9wcmludCclM0ElMjBpbmYlMkMlMjAnZnAxNiclM0ElMjAlN0InZW5hYmxlZCclM0ElMjBGYWxzZSU3RCU3RA==",highlighted:`Distributed environment: DEEPSPEED  Backend: nccl
Num processes: 4
Process index: 0
Local process index: 0
Device: cuda:0
Mixed precision <span class="hljs-built_in">type</span>: bf16
ds_config: {<span class="hljs-string">&#x27;bf16&#x27;</span>: {<span class="hljs-string">&#x27;enabled&#x27;</span>: True}, <span class="hljs-string">&#x27;zero_optimization&#x27;</span>: {<span class="hljs-string">&#x27;stage&#x27;</span>: 3, <span class="hljs-string">&#x27;stage3_gather_16bit_weights_on_model_save&#x27;</span>: False, <span class="hljs-string">&#x27;offload_optimizer&#x27;</span>: {<span class="hljs-string">&#x27;device&#x27;</span>: <span class="hljs-string">&#x27;none&#x27;</span>}, <span class="hljs-string">&#x27;offload_param&#x27;</span>: {<span class="hljs-string">&#x27;device&#x27;</span>: <span class="hljs-string">&#x27;none&#x27;</span>}}, <span class="hljs-string">&#x27;gradient_clipping&#x27;</span>: 1.0, <span class="hljs-string">&#x27;train_batch_size&#x27;</span>: <span class="hljs-string">&#x27;auto&#x27;</span>, <span class="hljs-string">&#x27;train_micro_batch_size_per_gpu&#x27;</span>: <span class="hljs-string">&#x27;auto&#x27;</span>, <span class="hljs-string">&#x27;gradient_accumulation_steps&#x27;</span>: 10, <span class="hljs-string">&#x27;steps_per_print&#x27;</span>: inf, <span class="hljs-string">&#x27;fp16&#x27;</span>: {<span class="hljs-string">&#x27;enabled&#x27;</span>: False}}`,wrap:!1}}),$s=new y({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyYmYxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjAlMjJhdXRvJTIyJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZTNfZ2F0aGVyXzE2Yml0X3dlaWdodHNfb25fbW9kZWxfc2F2ZSUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvZmZsb2FkX29wdGltaXplciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRldmljZSUyMiUzQSUyMCUyMmF1dG8lMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvZmZsb2FkX3BhcmFtJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGV2aWNlJTIyJTNBJTIwJTIyYXV0byUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmdyYWRpZW50X2NsaXBwaW5nJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnRyYWluX2JhdGNoX3NpemUlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhaW5fbWljcm9fYmF0Y2hfc2l6ZV9wZXJfZ3B1JTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJzdGVwc19wZXJfcHJpbnQlMjIlM0ElMjAyMDAwMDAwJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;bf16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_param&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000000</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ls=new y({props:{code:"RGlzdHJpYnV0ZWQlMjBlbnZpcm9ubWVudCUzQSUyMERFRVBTUEVFRCUyMCUyMEJhY2tlbmQlM0ElMjBuY2NsJTBBTnVtJTIwcHJvY2Vzc2VzJTNBJTIwNCUwQVByb2Nlc3MlMjBpbmRleCUzQSUyMDAlMEFMb2NhbCUyMHByb2Nlc3MlMjBpbmRleCUzQSUyMDAlMEFEZXZpY2UlM0ElMjBjdWRhJTNBMCUwQU1peGVkJTIwcHJlY2lzaW9uJTIwdHlwZSUzQSUyMGZwMTYlMEFkc19jb25maWclM0ElMjAlN0InYmYxNiclM0ElMjAlN0InZW5hYmxlZCclM0ElMjBGYWxzZSU3RCUyQyUyMCd6ZXJvX29wdGltaXphdGlvbiclM0ElMjAlN0Inc3RhZ2UnJTNBJTIwMyUyQyUyMCdzdGFnZTNfZ2F0aGVyXzE2Yml0X3dlaWdodHNfb25fbW9kZWxfc2F2ZSclM0ElMjBUcnVlJTJDJTIwJ29mZmxvYWRfb3B0aW1pemVyJyUzQSUyMCU3QidkZXZpY2UnJTNBJTIwJ252bWUnJTdEJTJDJTIwJ29mZmxvYWRfcGFyYW0nJTNBJTIwJTdCJ2RldmljZSclM0ElMjAnY3B1JyU3RCU3RCUyQyUyMCdncmFkaWVudF9jbGlwcGluZyclM0ElMjAxLjAlMkMlMjAndHJhaW5fYmF0Y2hfc2l6ZSclM0ElMjAnYXV0byclMkMlMjAndHJhaW5fbWljcm9fYmF0Y2hfc2l6ZV9wZXJfZ3B1JyUzQSUyMCdhdXRvJyUyQyUyMCdncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMnJTNBJTIwNSUyQyUyMCdzdGVwc19wZXJfcHJpbnQnJTNBJTIwaW5mJTJDJTIwJ2ZwMTYnJTNBJTIwJTdCJ2VuYWJsZWQnJTNBJTIwVHJ1ZSUyQyUyMCdhdXRvX2Nhc3QnJTNBJTIwVHJ1ZSU3RCU3RA==",highlighted:`Distributed environment: DEEPSPEED  Backend: nccl
Num processes: 4
Process index: 0
Local process index: 0
Device: cuda:0
Mixed precision <span class="hljs-built_in">type</span>: fp16
ds_config: {<span class="hljs-string">&#x27;bf16&#x27;</span>: {<span class="hljs-string">&#x27;enabled&#x27;</span>: False}, <span class="hljs-string">&#x27;zero_optimization&#x27;</span>: {<span class="hljs-string">&#x27;stage&#x27;</span>: 3, <span class="hljs-string">&#x27;stage3_gather_16bit_weights_on_model_save&#x27;</span>: True, <span class="hljs-string">&#x27;offload_optimizer&#x27;</span>: {<span class="hljs-string">&#x27;device&#x27;</span>: <span class="hljs-string">&#x27;nvme&#x27;</span>}, <span class="hljs-string">&#x27;offload_param&#x27;</span>: {<span class="hljs-string">&#x27;device&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>}}, <span class="hljs-string">&#x27;gradient_clipping&#x27;</span>: 1.0, <span class="hljs-string">&#x27;train_batch_size&#x27;</span>: <span class="hljs-string">&#x27;auto&#x27;</span>, <span class="hljs-string">&#x27;train_micro_batch_size_per_gpu&#x27;</span>: <span class="hljs-string">&#x27;auto&#x27;</span>, <span class="hljs-string">&#x27;gradient_accumulation_steps&#x27;</span>: 5, <span class="hljs-string">&#x27;steps_per_print&#x27;</span>: inf, <span class="hljs-string">&#x27;fp16&#x27;</span>: {<span class="hljs-string">&#x27;enabled&#x27;</span>: True, <span class="hljs-string">&#x27;auto_cast&#x27;</span>: True}}`,wrap:!1}}),Os=new m({props:{title:"Saving and loading",local:"saving-and-loading",headingTag:"h2"}}),Ks=new y({props:{code:"dW53cmFwcGVkX21vZGVsJTIwJTNEJTIwYWNjZWxlcmF0b3IudW53cmFwX21vZGVsKG1vZGVsKSUwQSUwQSUyMyUyME5ldyUyMENvZGUlMjAlMjMlMEElMjMlMjBTYXZlcyUyMHRoZSUyMHdob2xlJTJGdW5wYXJ0aXRpb25lZCUyMGZwMTYlMjBtb2RlbCUyMHdoZW4lMjBpbiUyMFplUk8lMjBTdGFnZS0zJTIwdG8lMjB0aGUlMjBvdXRwdXQlMjBkaXJlY3RvcnklMjBpZiUwQSUyMyUyMCU2MHN0YWdlM19nYXRoZXJfMTZiaXRfd2VpZ2h0c19vbl9tb2RlbF9zYXZlJTYwJTIwaXMlMjBUcnVlJTIwaW4lMjBEZWVwU3BlZWQlMjBDb25maWclMjBmaWxlJTIwb3IlMEElMjMlMjAlNjB6ZXJvM19zYXZlXzE2Yml0X21vZGVsJTYwJTIwaXMlMjBUcnVlJTIwaW4lMjBEZWVwU3BlZWQlMjBQbHVnaW4uJTBBJTIzJTIwRm9yJTIwWmVybyUyMFN0YWdlcyUyMDElMjBhbmQlMjAyJTJDJTIwbW9kZWxzJTIwYXJlJTIwc2F2ZWQlMjBhcyUyMHVzdWFsJTIwaW4lMjB0aGUlMjBvdXRwdXQlMjBkaXJlY3RvcnkuJTBBJTIzJTIwVGhlJTIwbW9kZWwlMjBuYW1lJTIwc2F2ZWQlMjBpcyUyMCU2MHB5dG9yY2hfbW9kZWwuYmluJTYwJTBBdW53cmFwcGVkX21vZGVsLnNhdmVfcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBhcmdzLm91dHB1dF9kaXIlMkMlMEElMjAlMjAlMjAlMjBpc19tYWluX3Byb2Nlc3MlM0RhY2NlbGVyYXRvci5pc19tYWluX3Byb2Nlc3MlMkMlMEElMjAlMjAlMjAlMjBzYXZlX2Z1bmN0aW9uJTNEYWNjZWxlcmF0b3Iuc2F2ZSUyQyUwQSUyMCUyMCUyMCUyMHN0YXRlX2RpY3QlM0RhY2NlbGVyYXRvci5nZXRfc3RhdGVfZGljdChtb2RlbCklMkMlMEEp",highlighted:`unwrapped_model = accelerator.unwrap_model(model)

<span class="hljs-comment"># New Code #</span>
<span class="hljs-comment"># Saves the whole/unpartitioned fp16 model when in ZeRO Stage-3 to the output directory if</span>
<span class="hljs-comment"># \`stage3_gather_16bit_weights_on_model_save\` is True in DeepSpeed Config file or</span>
<span class="hljs-comment"># \`zero3_save_16bit_model\` is True in DeepSpeed Plugin.</span>
<span class="hljs-comment"># For Zero Stages 1 and 2, models are saved as usual in the output directory.</span>
<span class="hljs-comment"># The model name saved is \`pytorch_model.bin\`</span>
unwrapped_model.save_pretrained(
    args.output_dir,
    is_main_process=accelerator.is_main_process,
    save_function=accelerator.save,
    state_dict=accelerator.get_state_dict(model),
)`,wrap:!1}}),sl=new y({props:{code:"c3VjY2VzcyUyMCUzRCUyMG1vZGVsLnNhdmVfY2hlY2twb2ludChQQVRIJTJDJTIwY2twdF9pZCUyQyUyMGNoZWNrcG9pbnRfc3RhdGVfZGljdCklMEFzdGF0dXNfbXNnJTIwJTNEJTIwJTIyY2hlY2twb2ludGluZyUzQSUyMFBBVEglM0QlN0IlN0QlMkMlMjBja3B0X2lkJTNEJTdCJTdEJTIyLmZvcm1hdChQQVRIJTJDJTIwY2twdF9pZCklMEFpZiUyMHN1Y2Nlc3MlM0ElMEElMjAlMjAlMjAlMjBsb2dnaW5nLmluZm8oZiUyMlN1Y2Nlc3MlMjAlN0JzdGF0dXNfbXNnJTdEJTIyKSUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjBsb2dnaW5nLndhcm5pbmcoZiUyMkZhaWx1cmUlMjAlN0JzdGF0dXNfbXNnJTdEJTIyKQ==",highlighted:`success = model.save_checkpoint(PATH, ckpt_id, checkpoint_state_dict)
status_msg = <span class="hljs-string">&quot;checkpointing: PATH={}, ckpt_id={}&quot;</span>.<span class="hljs-built_in">format</span>(PATH, ckpt_id)
<span class="hljs-keyword">if</span> success:
    logging.info(<span class="hljs-string">f&quot;Success <span class="hljs-subst">{status_msg}</span>&quot;</span>)
<span class="hljs-keyword">else</span>:
    logging.warning(<span class="hljs-string">f&quot;Failure <span class="hljs-subst">{status_msg}</span>&quot;</span>)`,wrap:!1}}),ll=new y({props:{code:"JTI0JTIwY2QlMjAlMkZwYXRoJTJGdG8lMkZjaGVja3BvaW50X2RpciUwQSUyNCUyMC4lMkZ6ZXJvX3RvX2ZwMzIucHklMjAuJTIwcHl0b3JjaF9tb2RlbC5iaW4lMEFQcm9jZXNzaW5nJTIwemVybyUyMGNoZWNrcG9pbnQlMjBhdCUyMGdsb2JhbF9zdGVwMSUwQURldGVjdGVkJTIwY2hlY2twb2ludCUyMG9mJTIwdHlwZSUyMHplcm8lMjBzdGFnZSUyMDMlMkMlMjB3b3JsZF9zaXplJTNBJTIwMiUwQVNhdmluZyUyMGZwMzIlMjBzdGF0ZSUyMGRpY3QlMjB0byUyMHB5dG9yY2hfbW9kZWwuYmluJTIwKHRvdGFsX251bWVsJTNENjA1MDY2MjQp",highlighted:`$ <span class="hljs-built_in">cd</span> /path/to/checkpoint_dir
$ ./zero_to_fp32.py . pytorch_model.bin
Processing zero checkpoint at global_step1
Detected checkpoint of <span class="hljs-built_in">type</span> zero stage 3, world_size: 2
Saving fp32 state dict to pytorch_model.bin (total_numel=60506624)`,wrap:!1}}),tl=new y({props:{code:"ZnJvbSUyMGRlZXBzcGVlZC51dGlscy56ZXJvX3RvX2ZwMzIlMjBpbXBvcnQlMjBsb2FkX3N0YXRlX2RpY3RfZnJvbV96ZXJvX2NoZWNrcG9pbnQlMEElMEF1bndyYXBwZWRfbW9kZWwlMjAlM0QlMjBhY2NlbGVyYXRvci51bndyYXBfbW9kZWwobW9kZWwpJTBBZnAzMl9tb2RlbCUyMCUzRCUyMGxvYWRfc3RhdGVfZGljdF9mcm9tX3plcm9fY2hlY2twb2ludCh1bndyYXBwZWRfbW9kZWwlMkMlMjBjaGVja3BvaW50X2Rpcik=",highlighted:`<span class="hljs-keyword">from</span> deepspeed.utils.zero_to_fp32 <span class="hljs-keyword">import</span> load_state_dict_from_zero_checkpoint

unwrapped_model = accelerator.unwrap_model(model)
fp32_model = load_state_dict_from_zero_checkpoint(unwrapped_model, checkpoint_dir)`,wrap:!1}}),al=new y({props:{code:"ZnJvbSUyMGRlZXBzcGVlZC51dGlscy56ZXJvX3RvX2ZwMzIlMjBpbXBvcnQlMjBnZXRfZnAzMl9zdGF0ZV9kaWN0X2Zyb21femVyb19jaGVja3BvaW50JTBBJTBBc3RhdGVfZGljdCUyMCUzRCUyMGdldF9mcDMyX3N0YXRlX2RpY3RfZnJvbV96ZXJvX2NoZWNrcG9pbnQoY2hlY2twb2ludF9kaXIp",highlighted:`<span class="hljs-keyword">from</span> deepspeed.utils.zero_to_fp32 <span class="hljs-keyword">import</span> get_fp32_state_dict_from_zero_checkpoint

state_dict = get_fp32_state_dict_from_zero_checkpoint(checkpoint_dir)`,wrap:!1}}),el=new m({props:{title:"ZeRO Inference",local:"zero-inference",headingTag:"h2"}}),pl=new y({props:{code:"bW9kZWwlMkMlMjBldmFsX2RhdGFsb2FkZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKG1vZGVsJTJDJTIwZXZhbF9kYXRhbG9hZGVyKQ==",highlighted:"model, eval_dataloader = accelerator.prepare(model, eval_dataloader)",wrap:!1}}),Ml=new m({props:{title:"Few caveats to be aware of",local:"few-caveats-to-be-aware-of",headingTag:"h2"}}),cl=new m({props:{title:"DeepSpeed Resources",local:"deepspeed-resources",headingTag:"h2"}}),{c(){I=p("meta"),Sl=e(),Wl=p("p"),Nl=e(),c(A.$$.fragment),Gl=e(),W=p("p"),W.innerHTML=Qa,vl=e(),X=p("ol"),X.innerHTML=Fa,Vl=e(),S=p("p"),S.innerHTML=ka,zl=e(),N=p("p"),N.textContent=qa,Yl=e(),G=p("p"),G.textContent=Ha,Rl=e(),v=p("p"),v.innerHTML=$a,xl=e(),V=p("ol"),V.innerHTML=La,El=e(),c(z.$$.fragment),Ql=e(),Y=p("p"),Y.textContent=Da,Fl=e(),R=p("ol"),R.innerHTML=Pa,kl=e(),x=p("p"),x.innerHTML=Oa,ql=e(),E=p("p"),E.innerHTML=Ka,Hl=e(),Q=p("p"),Q.innerHTML=se,$l=e(),F=p("p"),F.innerHTML=le,Ll=e(),k=p("p"),k.innerHTML=te,Dl=e(),q=p("p"),q.innerHTML=ae,Pl=e(),H=p("u"),H.textContent=ee,Ol=jn(`: With respect to Disk Offload, the disk should be an NVME for decent speed but it technically works on any Disk
`),$=p("p"),$.textContent=ne,Kl=e(),L=p("ol"),L.innerHTML=pe,st=e(),c(D.$$.fragment),lt=e(),P=p("p"),P.innerHTML=Me,tt=e(),O=p("p"),O.innerHTML=ie,at=e(),c(K.$$.fragment),et=e(),ss=p("p"),ss.textContent=ce,nt=e(),c(ls.$$.fragment),pt=e(),ts=p("p"),ts.textContent=oe,Mt=e(),c(as.$$.fragment),it=e(),es=p("p"),es.innerHTML=Je,ct=e(),ns=p("p"),ns.innerHTML=ue,ot=e(),c(ps.$$.fragment),Jt=e(),c(Ms.$$.fragment),ut=e(),is=p("p"),is.innerHTML=je,jt=e(),c(cs.$$.fragment),wt=e(),c(os.$$.fragment),Tt=e(),Js=p("p"),Js.innerHTML=we,yt=e(),c(us.$$.fragment),rt=e(),js=p("p"),js.textContent=Te,Ut=e(),c(ws.$$.fragment),ht=e(),Ts=p("p"),Ts.textContent=ye,dt=e(),c(ys.$$.fragment),It=e(),rs=p("p"),rs.textContent=re,mt=e(),c(Us.$$.fragment),ft=e(),hs=p("p"),hs.innerHTML=Ue,bt=e(),ds=p("p"),ds.innerHTML=he,Ct=e(),c(Is.$$.fragment),Zt=e(),ms=p("p"),ms.innerHTML=de,_t=e(),c(fs.$$.fragment),Bt=e(),c(bs.$$.fragment),gt=e(),Cs=p("p"),Cs.innerHTML=Ie,At=e(),c(Zs.$$.fragment),Wt=e(),_s=p("p"),_s.innerHTML=me,Xt=e(),c(Bs.$$.fragment),St=e(),c(gs.$$.fragment),Nt=e(),As=p("p"),As.innerHTML=fe,Gt=e(),f=p("ol"),h=p("li"),yl=p("p"),yl.innerHTML=be,ba=e(),rl=p("p"),rl.innerHTML=Ce,Ca=e(),c(Ws.$$.fragment),Za=e(),Ul=p("p"),Ul.innerHTML=Ze,_a=e(),hl=p("p"),hl.innerHTML=_e,Ba=e(),dl=p("p"),dl.innerHTML=Be,ga=e(),Il=p("li"),Il.innerHTML=ge,vt=e(),Xs=p("p"),Xs.innerHTML=Ae,Vt=e(),Ss=p("p"),Ss.innerHTML=We,zt=e(),Ns=p("p"),Ns.innerHTML=Xe,Yt=e(),c(Gs.$$.fragment),Rt=e(),vs=p("p"),vs.innerHTML=Se,xt=e(),Vs=p("ol"),Vs.innerHTML=Ne,Et=e(),c(zs.$$.fragment),Qt=e(),b=p("ol"),b.innerHTML=Ge,Ft=e(),c(Ys.$$.fragment),kt=e(),C=p("ol"),C.innerHTML=ve,qt=e(),c(Rs.$$.fragment),Ht=e(),xs=p("p"),xs.innerHTML=Ve,$t=e(),Es=p("ol"),Es.innerHTML=ze,Lt=e(),c(Qs.$$.fragment),Dt=e(),Z=p("ol"),Z.innerHTML=Ye,Pt=e(),c(Fs.$$.fragment),Ot=e(),_=p("ol"),_.innerHTML=Re,Kt=e(),c(ks.$$.fragment),sa=e(),qs=p("p"),qs.innerHTML=xe,la=e(),Hs=p("ol"),Hs.innerHTML=Ee,ta=e(),c($s.$$.fragment),aa=e(),B=p("ol"),B.innerHTML=Qe,ea=e(),c(Ls.$$.fragment),na=e(),Ds=p("p"),Ds.innerHTML=Fe,pa=e(),Ps=p("ol"),Ps.innerHTML=ke,Ma=e(),c(Os.$$.fragment),ia=e(),g=p("ol"),ml=p("li"),ml.innerHTML=qe,Aa=e(),r=p("li"),fl=p("p"),fl.innerHTML=He,Wa=e(),bl=p("p"),bl.innerHTML=$e,Xa=e(),c(Ks.$$.fragment),Sa=e(),Cl=p("p"),Cl.innerHTML=Le,Na=e(),c(sl.$$.fragment),Ga=e(),Zl=p("p"),Zl.innerHTML=De,va=e(),c(ll.$$.fragment),Va=e(),_l=p("p"),_l.textContent=Pe,za=e(),c(tl.$$.fragment),Ya=e(),Bl=p("p"),Bl.innerHTML=Oe,Ra=e(),c(al.$$.fragment),xa=e(),gl=p("p"),gl.textContent=Ke,ca=e(),c(el.$$.fragment),oa=e(),nl=p("p"),nl.textContent=sn,Ja=e(),c(pl.$$.fragment),ua=e(),c(Ml.$$.fragment),ja=e(),il=p("ol"),il.innerHTML=ln,wa=e(),c(cl.$$.fragment),Ta=e(),ol=p("p"),ol.innerHTML=tn,ya=e(),Jl=p("ul"),Jl.innerHTML=an,ra=e(),ul=p("p"),ul.textContent=en,Ua=e(),jl=p("ul"),jl.innerHTML=nn,ha=e(),wl=p("p"),wl.innerHTML=pn,da=e(),Xl=p("p"),this.h()},l(s){const l=wn("svelte-u9bgzb",document.head);I=M(l,"META",{name:!0,content:!0}),l.forEach(t),Sl=n(s),Wl=M(s,"P",{}),Al(Wl).forEach(t),Nl=n(s),o(A.$$.fragment,s),Gl=n(s),W=M(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-bl016q"&&(W.innerHTML=Qa),vl=n(s),X=M(s,"OL",{"data-svelte-h":!0}),i(X)!=="svelte-1au2wd9"&&(X.innerHTML=Fa),Vl=n(s),S=M(s,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1ipy5tt"&&(S.innerHTML=ka),zl=n(s),N=M(s,"P",{"data-svelte-h":!0}),i(N)!=="svelte-iaccrf"&&(N.textContent=qa),Yl=n(s),G=M(s,"P",{"data-svelte-h":!0}),i(G)!=="svelte-l1xxpu"&&(G.textContent=Ha),Rl=n(s),v=M(s,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1j8gyyc"&&(v.innerHTML=$a),xl=n(s),V=M(s,"OL",{"data-svelte-h":!0}),i(V)!=="svelte-15nzigp"&&(V.innerHTML=La),El=n(s),o(z.$$.fragment,s),Ql=n(s),Y=M(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1igpel8"&&(Y.textContent=Da),Fl=n(s),R=M(s,"OL",{"data-svelte-h":!0}),i(R)!=="svelte-fwbkl6"&&(R.innerHTML=Pa),kl=n(s),x=M(s,"P",{"data-svelte-h":!0}),i(x)!=="svelte-134sd43"&&(x.innerHTML=Oa),ql=n(s),E=M(s,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1d4qqra"&&(E.innerHTML=Ka),Hl=n(s),Q=M(s,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-n0e1lo"&&(Q.innerHTML=se),$l=n(s),F=M(s,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1ob4qwq"&&(F.innerHTML=le),Ll=n(s),k=M(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-f1y4d9"&&(k.innerHTML=te),Dl=n(s),q=M(s,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1sgbcs5"&&(q.innerHTML=ae),Pl=n(s),H=M(s,"U",{"data-svelte-h":!0}),i(H)!=="svelte-248d1k"&&(H.textContent=ee),Ol=Tn(s,`: With respect to Disk Offload, the disk should be an NVME for decent speed but it technically works on any Disk
`),$=M(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-1i9b1jx"&&($.textContent=ne),Kl=n(s),L=M(s,"OL",{"data-svelte-h":!0}),i(L)!=="svelte-yjfbl7"&&(L.innerHTML=pe),st=n(s),o(D.$$.fragment,s),lt=n(s),P=M(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1wpffgu"&&(P.innerHTML=Me),tt=n(s),O=M(s,"P",{"data-svelte-h":!0}),i(O)!=="svelte-fbsjt0"&&(O.innerHTML=ie),at=n(s),o(K.$$.fragment,s),et=n(s),ss=M(s,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-3pof6s"&&(ss.textContent=ce),nt=n(s),o(ls.$$.fragment,s),pt=n(s),ts=M(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-1ik26hy"&&(ts.textContent=oe),Mt=n(s),o(as.$$.fragment,s),it=n(s),es=M(s,"P",{"data-svelte-h":!0}),i(es)!=="svelte-10u1bf7"&&(es.innerHTML=Je),ct=n(s),ns=M(s,"P",{"data-svelte-h":!0}),i(ns)!=="svelte-vp1nym"&&(ns.innerHTML=ue),ot=n(s),o(ps.$$.fragment,s),Jt=n(s),o(Ms.$$.fragment,s),ut=n(s),is=M(s,"P",{"data-svelte-h":!0}),i(is)!=="svelte-12x21g8"&&(is.innerHTML=je),jt=n(s),o(cs.$$.fragment,s),wt=n(s),o(os.$$.fragment,s),Tt=n(s),Js=M(s,"P",{"data-svelte-h":!0}),i(Js)!=="svelte-lh95an"&&(Js.innerHTML=we),yt=n(s),o(us.$$.fragment,s),rt=n(s),js=M(s,"P",{"data-svelte-h":!0}),i(js)!=="svelte-1spmm13"&&(js.textContent=Te),Ut=n(s),o(ws.$$.fragment,s),ht=n(s),Ts=M(s,"P",{"data-svelte-h":!0}),i(Ts)!=="svelte-3pof6s"&&(Ts.textContent=ye),dt=n(s),o(ys.$$.fragment,s),It=n(s),rs=M(s,"P",{"data-svelte-h":!0}),i(rs)!=="svelte-1vp75xs"&&(rs.textContent=re),mt=n(s),o(Us.$$.fragment,s),ft=n(s),hs=M(s,"P",{"data-svelte-h":!0}),i(hs)!=="svelte-17th5u9"&&(hs.innerHTML=Ue),bt=n(s),ds=M(s,"P",{"data-svelte-h":!0}),i(ds)!=="svelte-1l59g75"&&(ds.innerHTML=he),Ct=n(s),o(Is.$$.fragment,s),Zt=n(s),ms=M(s,"P",{"data-svelte-h":!0}),i(ms)!=="svelte-1iv8u1c"&&(ms.innerHTML=de),_t=n(s),o(fs.$$.fragment,s),Bt=n(s),o(bs.$$.fragment,s),gt=n(s),Cs=M(s,"P",{"data-svelte-h":!0}),i(Cs)!=="svelte-3yuze5"&&(Cs.innerHTML=Ie),At=n(s),o(Zs.$$.fragment,s),Wt=n(s),_s=M(s,"P",{"data-svelte-h":!0}),i(_s)!=="svelte-15nfwtv"&&(_s.innerHTML=me),Xt=n(s),o(Bs.$$.fragment,s),St=n(s),o(gs.$$.fragment,s),Nt=n(s),As=M(s,"P",{"data-svelte-h":!0}),i(As)!=="svelte-1y80l2"&&(As.innerHTML=fe),Gt=n(s),f=M(s,"OL",{});var ma=Al(f);h=M(ma,"LI",{});var d=Al(h);yl=M(d,"P",{"data-svelte-h":!0}),i(yl)!=="svelte-19wri7m"&&(yl.innerHTML=be),ba=n(d),rl=M(d,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-1w1lp0n"&&(rl.innerHTML=Ce),Ca=n(d),o(Ws.$$.fragment,d),Za=n(d),Ul=M(d,"P",{"data-svelte-h":!0}),i(Ul)!=="svelte-ce0g29"&&(Ul.innerHTML=Ze),_a=n(d),hl=M(d,"P",{"data-svelte-h":!0}),i(hl)!=="svelte-11vazlp"&&(hl.innerHTML=_e),Ba=n(d),dl=M(d,"P",{"data-svelte-h":!0}),i(dl)!=="svelte-jof0o2"&&(dl.innerHTML=Be),d.forEach(t),ga=n(ma),Il=M(ma,"LI",{"data-svelte-h":!0}),i(Il)!=="svelte-1k2nlfe"&&(Il.innerHTML=ge),ma.forEach(t),vt=n(s),Xs=M(s,"P",{"data-svelte-h":!0}),i(Xs)!=="svelte-nnfxti"&&(Xs.innerHTML=Ae),Vt=n(s),Ss=M(s,"P",{"data-svelte-h":!0}),i(Ss)!=="svelte-2eh81g"&&(Ss.innerHTML=We),zt=n(s),Ns=M(s,"P",{"data-svelte-h":!0}),i(Ns)!=="svelte-1r2ikm1"&&(Ns.innerHTML=Xe),Yt=n(s),o(Gs.$$.fragment,s),Rt=n(s),vs=M(s,"P",{"data-svelte-h":!0}),i(vs)!=="svelte-23a28o"&&(vs.innerHTML=Se),xt=n(s),Vs=M(s,"OL",{"data-svelte-h":!0}),i(Vs)!=="svelte-835v9i"&&(Vs.innerHTML=Ne),Et=n(s),o(zs.$$.fragment,s),Qt=n(s),b=M(s,"OL",{start:!0,"data-svelte-h":!0}),i(b)!=="svelte-1f7op2x"&&(b.innerHTML=Ge),Ft=n(s),o(Ys.$$.fragment,s),kt=n(s),C=M(s,"OL",{start:!0,"data-svelte-h":!0}),i(C)!=="svelte-czp5cr"&&(C.innerHTML=ve),qt=n(s),o(Rs.$$.fragment,s),Ht=n(s),xs=M(s,"P",{"data-svelte-h":!0}),i(xs)!=="svelte-57upna"&&(xs.innerHTML=Ve),$t=n(s),Es=M(s,"OL",{"data-svelte-h":!0}),i(Es)!=="svelte-jop1mq"&&(Es.innerHTML=ze),Lt=n(s),o(Qs.$$.fragment,s),Dt=n(s),Z=M(s,"OL",{start:!0,"data-svelte-h":!0}),i(Z)!=="svelte-w41hdb"&&(Z.innerHTML=Ye),Pt=n(s),o(Fs.$$.fragment,s),Ot=n(s),_=M(s,"OL",{start:!0,"data-svelte-h":!0}),i(_)!=="svelte-czp5cr"&&(_.innerHTML=Re),Kt=n(s),o(ks.$$.fragment,s),sa=n(s),qs=M(s,"P",{"data-svelte-h":!0}),i(qs)!=="svelte-s6le15"&&(qs.innerHTML=xe),la=n(s),Hs=M(s,"OL",{"data-svelte-h":!0}),i(Hs)!=="svelte-q77lu7"&&(Hs.innerHTML=Ee),ta=n(s),o($s.$$.fragment,s),aa=n(s),B=M(s,"OL",{start:!0,"data-svelte-h":!0}),i(B)!=="svelte-18b0p9"&&(B.innerHTML=Qe),ea=n(s),o(Ls.$$.fragment,s),na=n(s),Ds=M(s,"P",{"data-svelte-h":!0}),i(Ds)!=="svelte-e17mg7"&&(Ds.innerHTML=Fe),pa=n(s),Ps=M(s,"OL",{"data-svelte-h":!0}),i(Ps)!=="svelte-xt73to"&&(Ps.innerHTML=ke),Ma=n(s),o(Os.$$.fragment,s),ia=n(s),g=M(s,"OL",{});var fa=Al(g);ml=M(fa,"LI",{"data-svelte-h":!0}),i(ml)!=="svelte-1ix3dy3"&&(ml.innerHTML=qe),Aa=n(fa),r=M(fa,"LI",{});var U=Al(r);fl=M(U,"P",{"data-svelte-h":!0}),i(fl)!=="svelte-1vo2i9p"&&(fl.innerHTML=He),Wa=n(U),bl=M(U,"P",{"data-svelte-h":!0}),i(bl)!=="svelte-hk8fhr"&&(bl.innerHTML=$e),Xa=n(U),o(Ks.$$.fragment,U),Sa=n(U),Cl=M(U,"P",{"data-svelte-h":!0}),i(Cl)!=="svelte-1ddq7v6"&&(Cl.innerHTML=Le),Na=n(U),o(sl.$$.fragment,U),Ga=n(U),Zl=M(U,"P",{"data-svelte-h":!0}),i(Zl)!=="svelte-1rlt8wa"&&(Zl.innerHTML=De),va=n(U),o(ll.$$.fragment,U),Va=n(U),_l=M(U,"P",{"data-svelte-h":!0}),i(_l)!=="svelte-1hbu42f"&&(_l.textContent=Pe),za=n(U),o(tl.$$.fragment,U),Ya=n(U),Bl=M(U,"P",{"data-svelte-h":!0}),i(Bl)!=="svelte-h6u0m6"&&(Bl.innerHTML=Oe),Ra=n(U),o(al.$$.fragment,U),xa=n(U),gl=M(U,"P",{"data-svelte-h":!0}),i(gl)!=="svelte-13dj8kw"&&(gl.textContent=Ke),U.forEach(t),fa.forEach(t),ca=n(s),o(el.$$.fragment,s),oa=n(s),nl=M(s,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-5ua48b"&&(nl.textContent=sn),Ja=n(s),o(pl.$$.fragment,s),ua=n(s),o(Ml.$$.fragment,s),ja=n(s),il=M(s,"OL",{"data-svelte-h":!0}),i(il)!=="svelte-1y4pgy"&&(il.innerHTML=ln),wa=n(s),o(cl.$$.fragment,s),Ta=n(s),ol=M(s,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-1aiu2sl"&&(ol.innerHTML=tn),ya=n(s),Jl=M(s,"UL",{"data-svelte-h":!0}),i(Jl)!=="svelte-qibs9v"&&(Jl.innerHTML=an),ra=n(s),ul=M(s,"P",{"data-svelte-h":!0}),i(ul)!=="svelte-1pnpyer"&&(ul.textContent=en),Ua=n(s),jl=M(s,"UL",{"data-svelte-h":!0}),i(jl)!=="svelte-teaul9"&&(jl.innerHTML=nn),ha=n(s),wl=M(s,"P",{"data-svelte-h":!0}),i(wl)!=="svelte-kyi5s0"&&(wl.innerHTML=pn),da=n(s),Xl=M(s,"P",{}),Al(Xl).forEach(t),this.h()},h(){Tl(I,"name","hf:doc:metadata"),Tl(I,"content",rn),Tl(b,"start","2"),Tl(C,"start","3"),Tl(Z,"start","2"),Tl(_,"start","3"),Tl(B,"start","2")},m(s,l){T(document.head,I),a(s,Sl,l),a(s,Wl,l),a(s,Nl,l),J(A,s,l),a(s,Gl,l),a(s,W,l),a(s,vl,l),a(s,X,l),a(s,Vl,l),a(s,S,l),a(s,zl,l),a(s,N,l),a(s,Yl,l),a(s,G,l),a(s,Rl,l),a(s,v,l),a(s,xl,l),a(s,V,l),a(s,El,l),J(z,s,l),a(s,Ql,l),a(s,Y,l),a(s,Fl,l),a(s,R,l),a(s,kl,l),a(s,x,l),a(s,ql,l),a(s,E,l),a(s,Hl,l),a(s,Q,l),a(s,$l,l),a(s,F,l),a(s,Ll,l),a(s,k,l),a(s,Dl,l),a(s,q,l),a(s,Pl,l),a(s,H,l),a(s,Ol,l),a(s,$,l),a(s,Kl,l),a(s,L,l),a(s,st,l),J(D,s,l),a(s,lt,l),a(s,P,l),a(s,tt,l),a(s,O,l),a(s,at,l),J(K,s,l),a(s,et,l),a(s,ss,l),a(s,nt,l),J(ls,s,l),a(s,pt,l),a(s,ts,l),a(s,Mt,l),J(as,s,l),a(s,it,l),a(s,es,l),a(s,ct,l),a(s,ns,l),a(s,ot,l),J(ps,s,l),a(s,Jt,l),J(Ms,s,l),a(s,ut,l),a(s,is,l),a(s,jt,l),J(cs,s,l),a(s,wt,l),J(os,s,l),a(s,Tt,l),a(s,Js,l),a(s,yt,l),J(us,s,l),a(s,rt,l),a(s,js,l),a(s,Ut,l),J(ws,s,l),a(s,ht,l),a(s,Ts,l),a(s,dt,l),J(ys,s,l),a(s,It,l),a(s,rs,l),a(s,mt,l),J(Us,s,l),a(s,ft,l),a(s,hs,l),a(s,bt,l),a(s,ds,l),a(s,Ct,l),J(Is,s,l),a(s,Zt,l),a(s,ms,l),a(s,_t,l),J(fs,s,l),a(s,Bt,l),J(bs,s,l),a(s,gt,l),a(s,Cs,l),a(s,At,l),J(Zs,s,l),a(s,Wt,l),a(s,_s,l),a(s,Xt,l),J(Bs,s,l),a(s,St,l),J(gs,s,l),a(s,Nt,l),a(s,As,l),a(s,Gt,l),a(s,f,l),T(f,h),T(h,yl),T(h,ba),T(h,rl),T(h,Ca),J(Ws,h,null),T(h,Za),T(h,Ul),T(h,_a),T(h,hl),T(h,Ba),T(h,dl),T(f,ga),T(f,Il),a(s,vt,l),a(s,Xs,l),a(s,Vt,l),a(s,Ss,l),a(s,zt,l),a(s,Ns,l),a(s,Yt,l),J(Gs,s,l),a(s,Rt,l),a(s,vs,l),a(s,xt,l),a(s,Vs,l),a(s,Et,l),J(zs,s,l),a(s,Qt,l),a(s,b,l),a(s,Ft,l),J(Ys,s,l),a(s,kt,l),a(s,C,l),a(s,qt,l),J(Rs,s,l),a(s,Ht,l),a(s,xs,l),a(s,$t,l),a(s,Es,l),a(s,Lt,l),J(Qs,s,l),a(s,Dt,l),a(s,Z,l),a(s,Pt,l),J(Fs,s,l),a(s,Ot,l),a(s,_,l),a(s,Kt,l),J(ks,s,l),a(s,sa,l),a(s,qs,l),a(s,la,l),a(s,Hs,l),a(s,ta,l),J($s,s,l),a(s,aa,l),a(s,B,l),a(s,ea,l),J(Ls,s,l),a(s,na,l),a(s,Ds,l),a(s,pa,l),a(s,Ps,l),a(s,Ma,l),J(Os,s,l),a(s,ia,l),a(s,g,l),T(g,ml),T(g,Aa),T(g,r),T(r,fl),T(r,Wa),T(r,bl),T(r,Xa),J(Ks,r,null),T(r,Sa),T(r,Cl),T(r,Na),J(sl,r,null),T(r,Ga),T(r,Zl),T(r,va),J(ll,r,null),T(r,Va),T(r,_l),T(r,za),J(tl,r,null),T(r,Ya),T(r,Bl),T(r,Ra),J(al,r,null),T(r,xa),T(r,gl),a(s,ca,l),J(el,s,l),a(s,oa,l),a(s,nl,l),a(s,Ja,l),J(pl,s,l),a(s,ua,l),J(Ml,s,l),a(s,ja,l),a(s,il,l),a(s,wa,l),J(cl,s,l),a(s,Ta,l),a(s,ol,l),a(s,ya,l),a(s,Jl,l),a(s,ra,l),a(s,ul,l),a(s,Ua,l),a(s,jl,l),a(s,ha,l),a(s,wl,l),a(s,da,l),a(s,Xl,l),Ia=!0},p:cn,i(s){Ia||(u(A.$$.fragment,s),u(z.$$.fragment,s),u(D.$$.fragment,s),u(K.$$.fragment,s),u(ls.$$.fragment,s),u(as.$$.fragment,s),u(ps.$$.fragment,s),u(Ms.$$.fragment,s),u(cs.$$.fragment,s),u(os.$$.fragment,s),u(us.$$.fragment,s),u(ws.$$.fragment,s),u(ys.$$.fragment,s),u(Us.$$.fragment,s),u(Is.$$.fragment,s),u(fs.$$.fragment,s),u(bs.$$.fragment,s),u(Zs.$$.fragment,s),u(Bs.$$.fragment,s),u(gs.$$.fragment,s),u(Ws.$$.fragment,s),u(Gs.$$.fragment,s),u(zs.$$.fragment,s),u(Ys.$$.fragment,s),u(Rs.$$.fragment,s),u(Qs.$$.fragment,s),u(Fs.$$.fragment,s),u(ks.$$.fragment,s),u($s.$$.fragment,s),u(Ls.$$.fragment,s),u(Os.$$.fragment,s),u(Ks.$$.fragment,s),u(sl.$$.fragment,s),u(ll.$$.fragment,s),u(tl.$$.fragment,s),u(al.$$.fragment,s),u(el.$$.fragment,s),u(pl.$$.fragment,s),u(Ml.$$.fragment,s),u(cl.$$.fragment,s),Ia=!0)},o(s){j(A.$$.fragment,s),j(z.$$.fragment,s),j(D.$$.fragment,s),j(K.$$.fragment,s),j(ls.$$.fragment,s),j(as.$$.fragment,s),j(ps.$$.fragment,s),j(Ms.$$.fragment,s),j(cs.$$.fragment,s),j(os.$$.fragment,s),j(us.$$.fragment,s),j(ws.$$.fragment,s),j(ys.$$.fragment,s),j(Us.$$.fragment,s),j(Is.$$.fragment,s),j(fs.$$.fragment,s),j(bs.$$.fragment,s),j(Zs.$$.fragment,s),j(Bs.$$.fragment,s),j(gs.$$.fragment,s),j(Ws.$$.fragment,s),j(Gs.$$.fragment,s),j(zs.$$.fragment,s),j(Ys.$$.fragment,s),j(Rs.$$.fragment,s),j(Qs.$$.fragment,s),j(Fs.$$.fragment,s),j(ks.$$.fragment,s),j($s.$$.fragment,s),j(Ls.$$.fragment,s),j(Os.$$.fragment,s),j(Ks.$$.fragment,s),j(sl.$$.fragment,s),j(ll.$$.fragment,s),j(tl.$$.fragment,s),j(al.$$.fragment,s),j(el.$$.fragment,s),j(pl.$$.fragment,s),j(Ml.$$.fragment,s),j(cl.$$.fragment,s),Ia=!1},d(s){s&&(t(Sl),t(Wl),t(Nl),t(Gl),t(W),t(vl),t(X),t(Vl),t(S),t(zl),t(N),t(Yl),t(G),t(Rl),t(v),t(xl),t(V),t(El),t(Ql),t(Y),t(Fl),t(R),t(kl),t(x),t(ql),t(E),t(Hl),t(Q),t($l),t(F),t(Ll),t(k),t(Dl),t(q),t(Pl),t(H),t(Ol),t($),t(Kl),t(L),t(st),t(lt),t(P),t(tt),t(O),t(at),t(et),t(ss),t(nt),t(pt),t(ts),t(Mt),t(it),t(es),t(ct),t(ns),t(ot),t(Jt),t(ut),t(is),t(jt),t(wt),t(Tt),t(Js),t(yt),t(rt),t(js),t(Ut),t(ht),t(Ts),t(dt),t(It),t(rs),t(mt),t(ft),t(hs),t(bt),t(ds),t(Ct),t(Zt),t(ms),t(_t),t(Bt),t(gt),t(Cs),t(At),t(Wt),t(_s),t(Xt),t(St),t(Nt),t(As),t(Gt),t(f),t(vt),t(Xs),t(Vt),t(Ss),t(zt),t(Ns),t(Yt),t(Rt),t(vs),t(xt),t(Vs),t(Et),t(Qt),t(b),t(Ft),t(kt),t(C),t(qt),t(Ht),t(xs),t($t),t(Es),t(Lt),t(Dt),t(Z),t(Pt),t(Ot),t(_),t(Kt),t(sa),t(qs),t(la),t(Hs),t(ta),t(aa),t(B),t(ea),t(na),t(Ds),t(pa),t(Ps),t(Ma),t(ia),t(g),t(ca),t(oa),t(nl),t(Ja),t(ua),t(ja),t(il),t(wa),t(Ta),t(ol),t(ya),t(Jl),t(ra),t(ul),t(Ua),t(jl),t(ha),t(wl),t(da),t(Xl)),t(I),w(A,s),w(z,s),w(D,s),w(K,s),w(ls,s),w(as,s),w(ps,s),w(Ms,s),w(cs,s),w(os,s),w(us,s),w(ws,s),w(ys,s),w(Us,s),w(Is,s),w(fs,s),w(bs,s),w(Zs,s),w(Bs,s),w(gs,s),w(Ws),w(Gs,s),w(zs,s),w(Ys,s),w(Rs,s),w(Qs,s),w(Fs,s),w(ks,s),w($s,s),w(Ls,s),w(Os,s),w(Ks),w(sl),w(ll),w(tl),w(al),w(el,s),w(pl,s),w(Ml,s),w(cl,s)}}}const rn='{"title":"DeepSpeed","local":"deepspeed","sections":[{"title":"What is integrated?","local":"what-is-integrated","sections":[],"depth":2},{"title":"How it works?","local":"how-it-works","sections":[{"title":"Accelerate DeepSpeed Plugin","local":"accelerate-deepspeed-plugin","sections":[],"depth":3},{"title":"DeepSpeed Config File","local":"deepspeed-config-file","sections":[],"depth":3}],"depth":2},{"title":"Saving and loading","local":"saving-and-loading","sections":[],"depth":2},{"title":"ZeRO Inference","local":"zero-inference","sections":[],"depth":2},{"title":"Few caveats to be aware of","local":"few-caveats-to-be-aware-of","sections":[],"depth":2},{"title":"DeepSpeed Resources","local":"deepspeed-resources","sections":[],"depth":2}],"depth":1}';function Un(Ea){return on(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fn extends Jn{constructor(I){super(),un(this,I,Un,yn,Mn,{})}}export{fn as component};
