import{s as P,n as q,o as K}from"../chunks/scheduler.00bde567.js";import{S as D,i as O,g as M,s as i,r as W,A as ee,h as r,f as l,c as n,j as Q,u as V,x as J,k as S,y as te,a,v as k,d as g,t as x,w as R}from"../chunks/index.752e2ff6.js";import{C as le}from"../chunks/CodeBlock.e62cd1dc.js";import{H as L}from"../chunks/Heading.476d3364.js";function ae(E){let s,f,w,T,o,C,c,z=`One of the most frustrating errors when it comes to running training scripts is hitting “CUDA Out-of-Memory”,
as the entire script needs to be restarted, progress is lost, and typically a developer would want to simply
start their script and let it run.`,b,d,B='<code>Accelerate</code> provides a utility heavily based on <a href="https://github.com/BlackHC/toma" rel="nofollow">toma</a> to give this capability.',A,y,_,m,F=`This algorithm operates with exponential decay, decreasing the batch size in half after each failed run on some
training script. To use it, restructure your training function to include an inner function that includes this wrapper,
and build your dataloaders inside it. At a minimum, this could look like 4 new lines of code.`,I,p,$="<p>Note: The inner function <em>must</em> take in the batch size as the first parameter, but we do not pass one to it when called. The wrapper handles this for us</p>",G,h,H=`It should also be noted that anything which will consume CUDA memory and passed to the <code>accelerator</code> <strong>must</strong> be declared inside the inner function,
such as models and optimizers.`,X,u,v,U,N='To find out more, check the documentation <a href="../package_reference/utilities#accelerate.find_executable_batch_size">here</a>.',Y,j,Z;return o=new L({props:{title:"Memory Utilities",local:"memory-utilities",headingTag:"h1"}}),y=new L({props:{title:"find_executable_batch_size",local:"findexecutablebatchsize",headingTag:"h2"}}),u=new le({props:{code:"ZGVmJTIwdHJhaW5pbmdfZnVuY3Rpb24oYXJncyklM0ElMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKCklMEElMEElMkIlMjAlMjAlMjAlNDBmaW5kX2V4ZWN1dGFibGVfYmF0Y2hfc2l6ZShzdGFydGluZ19iYXRjaF9zaXplJTNEYXJncy5iYXRjaF9zaXplKSUwQSUyQiUyMCUyMCUyMGRlZiUyMGlubmVyX3RyYWluaW5nX2xvb3AoYmF0Y2hfc2l6ZSklM0ElMEElMkIlMjAlMjAlMjAlMjAlMjAlMjAlMjBub25sb2NhbCUyMGFjY2VsZXJhdG9yJTIwJTIzJTIwRW5zdXJlJTIwdGhleSUyMGNhbiUyMGJlJTIwdXNlZCUyMGluJTIwb3VyJTIwY29udGV4dCUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmZyZWVfbWVtb3J5KCklMjAlMjMlMjBGcmVlJTIwYWxsJTIwbGluZ2VyaW5nJTIwcmVmZXJlbmNlcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwZ2V0X21vZGVsKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbC50byhhY2NlbGVyYXRvci5kZXZpY2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyJTIwJTNEJTIwZ2V0X29wdGltaXplcigpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyMCUzRCUyMGdldF9kYXRhbG9hZGVycyhhY2NlbGVyYXRvciUyQyUyMGJhdGNoX3NpemUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fdHJhaW5pbmdfc3RlcHMlM0RsZW4odHJhaW5fZGF0YWxvYWRlcikqbnVtX2Vwb2NocyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBldmFsX2RhdGFsb2FkZXIlMkMlMjBscl9zY2hlZHVsZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyQyUyMGxyX3NjaGVkdWxlciUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFpbihtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBscl9zY2hlZHVsZXIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmFsaWRhdGUobW9kZWwlMkMlMjBldmFsX2RhdGFsb2FkZXIpJTBBJTJCJTIwJTIwJTIwaW5uZXJfdHJhaW5pbmdfbG9vcCgp",highlighted:`def training_function(args):
    accelerator = Accelerator()

<span class="hljs-addition">+   @find_executable_batch_size(starting_batch_size=args.batch_size)</span>
<span class="hljs-addition">+   def inner_training_loop(batch_size):</span>
<span class="hljs-addition">+       nonlocal accelerator # Ensure they can be used in our context</span>
<span class="hljs-addition">+       accelerator.free_memory() # Free all lingering references</span>
        model = get_model()
        model.to(accelerator.device)
        optimizer = get_optimizer()
        train_dataloader, eval_dataloader = get_dataloaders(accelerator, batch_size)
        lr_scheduler = get_scheduler(
            optimizer, 
            num_training_steps=len(train_dataloader)*num_epochs
        )
        model, optimizer, train_dataloader, eval_dataloader, lr_scheduler = accelerator.prepare(
            model, optimizer, train_dataloader, eval_dataloader, lr_scheduler
        )
        train(model, optimizer, train_dataloader, lr_scheduler)
        validate(model, eval_dataloader)
<span class="hljs-addition">+   inner_training_loop()</span>`,wrap:!1}}),{c(){s=M("meta"),f=i(),w=M("p"),T=i(),W(o.$$.fragment),C=i(),c=M("p"),c.textContent=z,b=i(),d=M("p"),d.innerHTML=B,A=i(),W(y.$$.fragment),_=i(),m=M("p"),m.textContent=F,I=i(),p=M("blockquote"),p.innerHTML=$,G=i(),h=M("p"),h.innerHTML=H,X=i(),W(u.$$.fragment),v=i(),U=M("p"),U.innerHTML=N,Y=i(),j=M("p"),this.h()},l(e){const t=ee("svelte-u9bgzb",document.head);s=r(t,"META",{name:!0,content:!0}),t.forEach(l),f=n(e),w=r(e,"P",{}),Q(w).forEach(l),T=n(e),V(o.$$.fragment,e),C=n(e),c=r(e,"P",{"data-svelte-h":!0}),J(c)!=="svelte-1a38a5f"&&(c.textContent=z),b=n(e),d=r(e,"P",{"data-svelte-h":!0}),J(d)!=="svelte-1lre1t5"&&(d.innerHTML=B),A=n(e),V(y.$$.fragment,e),_=n(e),m=r(e,"P",{"data-svelte-h":!0}),J(m)!=="svelte-h7jpn3"&&(m.textContent=F),I=n(e),p=r(e,"BLOCKQUOTE",{"data-svelte-h":!0}),J(p)!=="svelte-ek1s5f"&&(p.innerHTML=$),G=n(e),h=r(e,"P",{"data-svelte-h":!0}),J(h)!=="svelte-12qvnq9"&&(h.innerHTML=H),X=n(e),V(u.$$.fragment,e),v=n(e),U=r(e,"P",{"data-svelte-h":!0}),J(U)!=="svelte-8y5n2"&&(U.innerHTML=N),Y=n(e),j=r(e,"P",{}),Q(j).forEach(l),this.h()},h(){S(s,"name","hf:doc:metadata"),S(s,"content",ie)},m(e,t){te(document.head,s),a(e,f,t),a(e,w,t),a(e,T,t),k(o,e,t),a(e,C,t),a(e,c,t),a(e,b,t),a(e,d,t),a(e,A,t),k(y,e,t),a(e,_,t),a(e,m,t),a(e,I,t),a(e,p,t),a(e,G,t),a(e,h,t),a(e,X,t),k(u,e,t),a(e,v,t),a(e,U,t),a(e,Y,t),a(e,j,t),Z=!0},p:q,i(e){Z||(g(o.$$.fragment,e),g(y.$$.fragment,e),g(u.$$.fragment,e),Z=!0)},o(e){x(o.$$.fragment,e),x(y.$$.fragment,e),x(u.$$.fragment,e),Z=!1},d(e){e&&(l(f),l(w),l(T),l(C),l(c),l(b),l(d),l(A),l(_),l(m),l(I),l(p),l(G),l(h),l(X),l(v),l(U),l(Y),l(j)),l(s),R(o,e),R(y,e),R(u,e)}}}const ie='{"title":"Memory Utilities","local":"memory-utilities","sections":[{"title":"find_executable_batch_size","local":"findexecutablebatchsize","sections":[],"depth":2}],"depth":1}';function ne(E){return K(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ce extends D{constructor(s){super(),O(this,s,ne,ae,P,{})}}export{ce as component};
