import{s as yn,o as un,n as wt}from"../chunks/scheduler.37c15a92.js";import{S as wn,i as jn,g as p,s as n,r as m,m as ot,H as ma,A as Un,h as o,f as e,c as l,j as Mt,u as c,x as i,n as it,E as ca,k as mn,y as T,a,v as h,d as M,t as y,w as u}from"../chunks/index.2bf4358c.js";import{T as yt}from"../chunks/Tip.363c041f.js";import{Y as dn}from"../chunks/Youtube.1e50a667.js";import{C as j}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Jn}from"../chunks/CourseFloatingBanner.5dff5e20.js";import{H as ut}from"../chunks/Heading.8ada512a.js";function bn(J){let r,U="💡 This section covers Unigram in depth, going as far as showing a full implementation. You can skip to the end if you just want a general overview of the tokenization algorithm.";return{c(){r=p("p"),r.textContent=U},l(w){r=o(w,"P",{"data-svelte-h":!0}),i(r)!=="svelte-11nzsd1"&&(r.textContent=U)},m(w,d){a(w,r,d)},p:wt,d(w){w&&e(r)}}}function Tn(J){let r,U="✏️ <strong>Now your turn!</strong> Write the code to compute the frequencies above and double-check that the results shown are correct, as well as the total sum.";return{c(){r=p("p"),r.innerHTML=U},l(w){r=o(w,"P",{"data-svelte-h":!0}),i(r)!=="svelte-kyc6dp"&&(r.innerHTML=U)},m(w,d){a(w,r,d)},p:wt,d(w){w&&e(r)}}}function gn(J){let r,U="✏️ <strong>Now your turn!</strong> Determine the tokenization of the word <code>&quot;huggun&quot;</code>, and its score.";return{c(){r=p("p"),r.innerHTML=U},l(w){r=o(w,"P",{"data-svelte-h":!0}),i(r)!=="svelte-zwh8th"&&(r.innerHTML=U)},m(w,d){a(w,r,d)},p:wt,d(w){w&&e(r)}}}function fn(J){let r,U="💡 SentencePiece uses a more efficient algorithm called Enhanced Suffix Array (ESA) to create the initial vocabulary.";return{c(){r=p("p"),r.textContent=U},l(w){r=o(w,"P",{"data-svelte-h":!0}),i(r)!=="svelte-1s00c64"&&(r.textContent=U)},m(w,d){a(w,r,d)},p:wt,d(w){w&&e(r)}}}function Cn(J){let r,U="💡 This approach is very inefficient, so SentencePiece uses an approximation of the loss of the model without token X: instead of starting from scratch, it just replaces token X by its segmentation in the vocabulary that is left. This way, all the scores can be computed at once at the same time as the model loss.";return{c(){r=p("p"),r.textContent=U},l(w){r=o(w,"P",{"data-svelte-h":!0}),i(r)!=="svelte-p8xm7n"&&(r.textContent=U)},m(w,d){a(w,r,d)},p:wt,d(w){w&&e(r)}}}function In(J){let r,U,w,d,A,jt,Z,Ut,_,ha="The Unigram algorithm is often used in SentencePiece, which is the tokenization algorithm used by models like AlBERT, T5, mBART, Big Bird, and XLNet.",dt,N,Jt,C,bt,z,Tt,V,Ma="Compared to BPE and WordPiece, Unigram works in the other direction: it starts from a big vocabulary and removes tokens from it until it reaches the desired vocabulary size. There are several options to use to build that base vocabulary: we can take the most common substrings in pre-tokenized words, for instance, or apply BPE on the initial corpus with a large vocabulary size.",gt,Q,ya="At each step of the training, the Unigram algorithm computes a loss over the corpus given the current vocabulary. Then, for each symbol in the vocabulary, the algorithm computes how much the overall loss would increase if the symbol was removed, and looks for the symbols that would increase it the least. Those symbols have a lower effect on the overall loss over the corpus, so in a sense they are “less needed” and are the best candidates for removal.",ft,I,na,Ct,cn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>p</mi></mrow><annotation encoding="application/x-tex">p</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.625em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">p</span></span></span></span>',It,kt,B,ua="Note that we never remove the base characters, to make sure any word can be tokenized.",vt,G,wa="Now, this is still a bit vague: the main part of the algorithm is to compute a loss over the corpus and see how it changes when we remove some tokens from the vocabulary, but we haven’t explained how to do this yet. This step relies on the tokenization algorithm of a Unigram model, so we’ll dive into this next.",$t,S,ja="We’ll reuse the corpus from the previous examples:",qt,R,xt,E,Ua="and for this example, we will take all strict substrings for the initial vocabulary :",At,H,Zt,X,_t,W,da="A Unigram model is a type of language model that considers each token to be independent of the tokens before it. It’s the simplest language model, in the sense that the probability of token X given the previous context is just the probability of token X. So, if we used a Unigram language model to generate text, we would always predict the most common token.",Nt,K,Ja="The probability of a given token is its frequency (the number of times we find it) in the original corpus, divided by the sum of all frequencies of all tokens in the vocabulary (to make sure the probabilities sum up to 1). For instance, <code>&quot;ug&quot;</code> is present in <code>&quot;hug&quot;</code>, <code>&quot;pug&quot;</code>, and <code>&quot;hugs&quot;</code>, so it has a frequency of 20 in our corpus.",zt,Y,ba="Here are the frequencies of all the possible subwords in the vocabulary:",Vt,D,Qt,F,Ta="So, the sum of all frequencies is 210, and the probability of the subword <code>&quot;ug&quot;</code> is thus 20/210.",Bt,k,Gt,b,la,rt,ga='["p", "u", "g"]',pa,mt,fa='"pug"',oa,St,hn='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>P</mi><mo stretchy="false">(</mo><mo stretchy="false">[</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>p</mi><mi mathvariant="normal">&quot;</mi><mo separator="true">,</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>u</mi><mi mathvariant="normal">&quot;</mi><mo separator="true">,</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>g</mi><mi mathvariant="normal">&quot;</mi><mo stretchy="false">]</mo><mo stretchy="false">)</mo><mo>=</mo><mi>P</mi><mo stretchy="false">(</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>p</mi><mi mathvariant="normal">&quot;</mi><mo stretchy="false">)</mo><mo>×</mo><mi>P</mi><mo stretchy="false">(</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>u</mi><mi mathvariant="normal">&quot;</mi><mo stretchy="false">)</mo><mo>×</mo><mi>P</mi><mo stretchy="false">(</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>g</mi><mi mathvariant="normal">&quot;</mi><mo stretchy="false">)</mo><mo>=</mo><mfrac><mn>5</mn><mn>210</mn></mfrac><mo>×</mo><mfrac><mn>36</mn><mn>210</mn></mfrac><mo>×</mo><mfrac><mn>20</mn><mn>210</mn></mfrac><mo>=</mo><mn>0.000389</mn></mrow><annotation encoding="application/x-tex">P([``p&quot;, ``u&quot;, ``g&quot;]) = P(``p&quot;) \\times P(``u&quot;) \\times P(``g&quot;) = \\frac{5}{210} \\times \\frac{36}{210} \\times \\frac{20}{210} = 0.000389</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">([</span><span class="mord">‘‘</span><span class="mord mathnormal">p</span><span class="mord">&quot;</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">‘‘</span><span class="mord mathnormal">u</span><span class="mord">&quot;</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">‘‘</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord">&quot;</span><span class="mclose">])</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">(</span><span class="mord">‘‘</span><span class="mord mathnormal">p</span><span class="mord">&quot;</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">(</span><span class="mord">‘‘</span><span class="mord mathnormal">u</span><span class="mord">&quot;</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">(</span><span class="mord">‘‘</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord">&quot;</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:2.0074em;vertical-align:-0.686em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.3214em;"><span style="top:-2.314em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">210</span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">5</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.686em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:2.0074em;vertical-align:-0.686em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.3214em;"><span style="top:-2.314em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">210</span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">36</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.686em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:2.0074em;vertical-align:-0.686em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.3214em;"><span style="top:-2.314em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">210</span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">20</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.686em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">0.000389</span></span></span></span></span>',Rt,f,ia,ct,Ca='["pu", "g"]',ra,Et,Mn='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>P</mi><mo stretchy="false">(</mo><mo stretchy="false">[</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>p</mi><mi>u</mi><mi mathvariant="normal">&quot;</mi><mo separator="true">,</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>g</mi><mi mathvariant="normal">&quot;</mi><mo stretchy="false">]</mo><mo stretchy="false">)</mo><mo>=</mo><mi>P</mi><mo stretchy="false">(</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>p</mi><mi>u</mi><mi mathvariant="normal">&quot;</mi><mo stretchy="false">)</mo><mo>×</mo><mi>P</mi><mo stretchy="false">(</mo><mi mathvariant="normal">‘</mi><mi mathvariant="normal">‘</mi><mi>g</mi><mi mathvariant="normal">&quot;</mi><mo stretchy="false">)</mo><mo>=</mo><mfrac><mn>5</mn><mn>210</mn></mfrac><mo>×</mo><mfrac><mn>20</mn><mn>210</mn></mfrac><mo>=</mo><mn>0.0022676</mn></mrow><annotation encoding="application/x-tex">P([``pu&quot;, ``g&quot;]) = P(``pu&quot;) \\times P(``g&quot;) = \\frac{5}{210} \\times \\frac{20}{210} = 0.0022676</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">([</span><span class="mord">‘‘</span><span class="mord mathnormal">p</span><span class="mord mathnormal">u</span><span class="mord">&quot;</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">‘‘</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord">&quot;</span><span class="mclose">])</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">(</span><span class="mord">‘‘</span><span class="mord mathnormal">p</span><span class="mord mathnormal">u</span><span class="mord">&quot;</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">P</span><span class="mopen">(</span><span class="mord">‘‘</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord">&quot;</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:2.0074em;vertical-align:-0.686em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.3214em;"><span style="top:-2.314em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">210</span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">5</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.686em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:2.0074em;vertical-align:-0.686em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.3214em;"><span style="top:-2.314em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">210</span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">20</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.686em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">0.0022676</span></span></span></span></span>',Ht,P,Ia="so that one is way more likely. In general, tokenizations with the least tokens possible will have the highest probability (because of that division by 210 repeated for each token), which corresponds to what we want intuitively: to split a word into the least number of tokens possible.",Xt,L,ka="The tokenization of a word with the Unigram model is then the tokenization with the highest probability. In the example of <code>&quot;pug&quot;</code>, here are the probabilities we would get for each possible segmentation:",Wt,O,Kt,ss,va="So, <code>&quot;pug&quot;</code> would be tokenized as <code>[&quot;p&quot;, &quot;ug&quot;]</code> or <code>[&quot;pu&quot;, &quot;g&quot;]</code>, depending on which of those segmentations is encountered first (note that in a larger corpus, equality cases like this will be rare).",Yt,ts,$a="In this case, it was easy to find all the possible segmentations and compute their probabilities, but in general it’s going to be a bit harder. There is a classic algorithm used for this, called the <em>Viterbi algorithm</em>. Essentially, we can build a graph to detect the possible segmentations of a given word by saying there is a branch from character <em>a</em> to character <em>b</em> if the subword from <em>a</em> to <em>b</em> is in the vocabulary, and attribute to that branch the probability of the subword.",Dt,es,qa="To find the path in that graph that is going to have the best score the Viterbi algorithm determines, for each position in the word, the segmentation with the best score that ends at that position. Since we go from the beginning to the end, that best score can be found by looping through all subwords ending at the current position and then using the best tokenization score from the position this subword begins at. Then, we just have to unroll the path taken to arrive at the end.",Ft,as,xa="Let’s take a look at an example using our vocabulary and the word <code>&quot;unhug&quot;</code>. For each position, the subwords with the best scores ending there are the following:",Pt,ns,Lt,ls,Aa="Thus <code>&quot;unhug&quot;</code> would be tokenized as <code>[&quot;un&quot;, &quot;hug&quot;]</code>.",Ot,v,se,ps,te,os,Za="Now that we have seen how the tokenization works, we can dive a little more deeply into the loss used during training. At any given stage, this loss is computed by tokenizing every word in the corpus, using the current vocabulary and the Unigram model determined by the frequencies of each token in the corpus (as seen before).",ee,is,_a="Each word in the corpus has a score, and the loss is the negative log likelihood of those scores — that is, the sum for all the words in the corpus of all the <code>-log(P(word))</code>.",ae,rs,Na="Let’s go back to our example with the following corpus:",ne,ms,le,cs,za="The tokenization of each word with their respective scores is:",pe,hs,oe,Ms,Va="So the loss is:",ie,ys,re,us,Qa="Now we need to compute how removing each token affects the loss. This is rather tedious, so we’ll just do it for two tokens here and save the whole process for when we have code to help us. In this (very) particular case, we had two equivalent tokenizations of all the words: as we saw earlier, for example, <code>&quot;pug&quot;</code> could be tokenized <code>[&quot;p&quot;, &quot;ug&quot;]</code> with the same score. Thus, removing the <code>&quot;pu&quot;</code> token from the vocabulary will give the exact same loss.",me,ws,Ba="On the other hand, removing <code>&quot;hug&quot;</code> will make the loss worse, because the tokenization of <code>&quot;hug&quot;</code> and <code>&quot;hugs&quot;</code> will become:",ce,js,he,Us,Ga="These changes will cause the loss to rise by:",Me,ds,ye,Js,Sa="Therefore, the token <code>&quot;pu&quot;</code> will probably be removed from the vocabulary, but not <code>&quot;hug&quot;</code>.",ue,bs,we,Ts,Ra="Now let’s implement everything we’ve seen so far in code. Like with BPE and WordPiece, this is not an efficient implementation of the Unigram algorithm (quite the opposite), but it should help you understand it a bit better.",je,gs,Ea="We will use the same corpus as before as an example:",Ue,fs,de,Cs,Ha="This time, we will use <code>xlnet-base-cased</code> as our model:",Je,Is,be,ks,Xa="Like for BPE and WordPiece, we begin by counting the number of occurrences of each word in the corpus:",Te,vs,ge,$s,Wa="Then, we need to initialize our vocabulary to something larger than the vocab size we will want at the end. We have to include all the basic characters (otherwise we won’t be able to tokenize every word), but for the bigger substrings we’ll only keep the most common ones, so we sort them by frequency:",fe,qs,Ce,xs,Ie,As,Ka="We group the characters with the best subwords to arrive at an initial vocabulary of size 300:",ke,Zs,ve,$,$e,_s,Ya="Next, we compute the sum of all frequencies, to convert the frequencies into probabilities. For our model we will store the logarithms of the probabilities, because it’s more numerically stable to add logarithms than to multiply small numbers, and this will simplify the computation of the loss of the model:",qe,Ns,xe,zs,Da="Now the main function is the one that tokenizes words using the Viterbi algorithm. As we saw before, that algorithm computes the best segmentation of each substring of the word, which we will store in a variable named <code>best_segmentations</code>. We will store one dictionary per position in the word (from 0 to its total length), with two keys: the index of the start of the last token in the best segmentation, and the score of the best segmentation. With the index of the start of the last token, we will be able to retrieve the full segmentation once the list is completely populated.",Ae,Vs,Fa="Populating the list is done with just two loops: the main loop goes over each start position, and the second loop tries all substrings beginning at that start position. If the substring is in the vocabulary, we have a new segmentation of the word up until that end position, which we compare to what is in <code>best_segmentations</code>.",Ze,Qs,Pa="Once the main loop is finished, we just start from the end and hop from one start position to the next, recording the tokens as we go, until we reach the start of the word:",_e,Bs,Ne,Gs,La="We can already try our initial model on some words:",ze,Ss,Ve,Rs,Qe,Es,Oa="Now it’s easy to compute the loss of the model on the corpus!",Be,Hs,Ge,Xs,sn="We can check it works on the model we have:",Se,Ws,Re,Ks,Ee,Ys,tn="Computing the scores for each token is not very hard either; we just have to compute the loss for the models obtained by deleting each token:",He,Ds,Xe,Fs,en="We can try it on a given token:",We,Ps,Ke,Ls,an="Since <code>&quot;ll&quot;</code> is used in the tokenization of <code>&quot;Hopefully&quot;</code>, and removing it will probably make us use the token <code>&quot;l&quot;</code> twice instead, we expect it will have a positive loss. <code>&quot;his&quot;</code> is only used inside the word <code>&quot;This&quot;</code>, which is tokenized as itself, so we expect it to have a zero loss. Here are the results:",Ye,Os,De,q,Fe,st,nn="With all of this in place, the last thing we need to do is add the special tokens used by the model to the vocabulary, then loop until we have pruned enough tokens from the vocabulary to reach our desired size:",Pe,tt,Le,et,ln="Then, to tokenize some text, we just need to apply the pre-tokenization and then use our <code>encode_word()</code> function:",Oe,at,sa,nt,ta,lt,pn="That’s it for Unigram! Hopefully by now you’re feeling like an expert in all things tokenizer. In the next section, we will delve into the building blocks of the 🤗 Tokenizers library, and show you how you can use them to build your own tokenizer.",ea,ht,aa;return A=new ut({props:{title:"Unigram tokenization",local:"unigram-tokenization",headingTag:"h1"}}),Z=new Jn({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section7.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section7.ipynb"}]}}),N=new dn({props:{id:"TGZfZVuF9Yc"}}),C=new yt({props:{$$slots:{default:[bn]},$$scope:{ctx:J}}}),z=new ut({props:{title:"Training algorithm",local:"training-algorithm",headingTag:"h2"}}),R=new j({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),H=new j({props:{code:"JTVCJTIyaCUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaHUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnAlMjIlMkMlMjAlMjJwdSUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJ1biUyMiUyQyUyMCUyMmIlMjIlMkMlMjAlMjJidSUyMiUyQyUyMCUyMnMlMjIlMkMlMjAlMjJodWclMjIlMkMlMjAlMjJncyUyMiUyQyUyMCUyMnVncyUyMiU1RA==",highlighted:'<span class="hljs-selector-attr">[<span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;hu&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;pu&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;bu&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-string">&quot;gs&quot;</span>, <span class="hljs-string">&quot;ugs&quot;</span>]</span>',wrap:!1}}),X=new ut({props:{title:"Tokenization algorithm",local:"tokenization-algorithm",headingTag:"h2"}}),D=new j({props:{code:"KCUyMmglMjIlMkMlMjAxNSklMjAoJTIydSUyMiUyQyUyMDM2KSUyMCglMjJnJTIyJTJDJTIwMjApJTIwKCUyMmh1JTIyJTJDJTIwMTUpJTIwKCUyMnVnJTIyJTJDJTIwMjApJTIwKCUyMnAlMjIlMkMlMjAxNyklMjAoJTIycHUlMjIlMkMlMjAxNyklMjAoJTIybiUyMiUyQyUyMDE2KSUwQSglMjJ1biUyMiUyQyUyMDE2KSUyMCglMjJiJTIyJTJDJTIwNCklMjAoJTIyYnUlMjIlMkMlMjA0KSUyMCglMjJzJTIyJTJDJTIwNSklMjAoJTIyaHVnJTIyJTJDJTIwMTUpJTIwKCUyMmdzJTIyJTJDJTIwNSklMjAoJTIydWdzJTIyJTJDJTIwNSk=",highlighted:`(<span class="hljs-string">&quot;h&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">15</span>) (<span class="hljs-string">&quot;u&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">36</span>) (<span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">20</span>) (<span class="hljs-string">&quot;hu&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">15</span>) (<span class="hljs-string">&quot;ug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">20</span>) (<span class="hljs-string">&quot;p&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">17</span>) (<span class="hljs-string">&quot;pu&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">17</span>) (<span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">16</span>)
(<span class="hljs-string">&quot;un&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">16</span>) (<span class="hljs-string">&quot;b&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>) (<span class="hljs-string">&quot;bu&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>) (<span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>) (<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">15</span>) (<span class="hljs-string">&quot;gs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>) (<span class="hljs-string">&quot;ugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)`,wrap:!1}}),k=new yt({props:{$$slots:{default:[Tn]},$$scope:{ctx:J}}}),O=new j({props:{code:"JTVCJTIycCUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJnJTIyJTVEJTIwJTNBJTIwMC4wMDAzODklMEElNUIlMjJwJTIyJTJDJTIwJTIydWclMjIlNUQlMjAlM0ElMjAwLjAwMjI2NzYlMEElNUIlMjJwdSUyMiUyQyUyMCUyMmclMjIlNUQlMjAlM0ElMjAwLjAwMjI2NzY=",highlighted:`[<span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>] : 0.000389
[<span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>] : 0.0022676
[<span class="hljs-string">&quot;pu&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>] : 0.0022676`,wrap:!1}}),ns=new j({props:{code:"Q2hhcmFjdGVyJTIwMCUyMCh1KSUzQSUyMCUyMnUlMjIlMjAoc2NvcmUlMjAwLjE3MTQyOSklMEFDaGFyYWN0ZXIlMjAxJTIwKG4pJTNBJTIwJTIydW4lMjIlMjAoc2NvcmUlMjAwLjA3NjE5MSklMEFDaGFyYWN0ZXIlMjAyJTIwKGgpJTNBJTIwJTIydW4lMjIlMjAlMjJoJTIyJTIwKHNjb3JlJTIwMC4wMDU0NDIpJTBBQ2hhcmFjdGVyJTIwMyUyMCh1KSUzQSUyMCUyMnVuJTIyJTIwJTIyaHUlMjIlMjAoc2NvcmUlMjAwLjAwNTQ0MiklMEFDaGFyYWN0ZXIlMjA0JTIwKGcpJTNBJTIwJTIydW4lMjIlMjAlMjJodWclMjIlMjAoc2NvcmUlMjAwLjAwNTQ0Mik=",highlighted:`<span class="hljs-attribute">Character</span> <span class="hljs-number">0</span> (u): <span class="hljs-string">&quot;u&quot;</span> (score <span class="hljs-number">0</span>.<span class="hljs-number">171429</span>)
<span class="hljs-attribute">Character</span> <span class="hljs-number">1</span> (n): <span class="hljs-string">&quot;un&quot;</span> (score <span class="hljs-number">0</span>.<span class="hljs-number">076191</span>)
<span class="hljs-attribute">Character</span> <span class="hljs-number">2</span> (h): <span class="hljs-string">&quot;un&quot;</span> <span class="hljs-string">&quot;h&quot;</span> (score <span class="hljs-number">0</span>.<span class="hljs-number">005442</span>)
<span class="hljs-attribute">Character</span> <span class="hljs-number">3</span> (u): <span class="hljs-string">&quot;un&quot;</span> <span class="hljs-string">&quot;hu&quot;</span> (score <span class="hljs-number">0</span>.<span class="hljs-number">005442</span>)
<span class="hljs-attribute">Character</span> <span class="hljs-number">4</span> (g): <span class="hljs-string">&quot;un&quot;</span> <span class="hljs-string">&quot;hug&quot;</span> (score <span class="hljs-number">0</span>.<span class="hljs-number">005442</span>)`,wrap:!1}}),v=new yt({props:{$$slots:{default:[gn]},$$scope:{ctx:J}}}),ps=new ut({props:{title:"Back to training",local:"back-to-training",headingTag:"h2"}}),ms=new j({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),hs=new j({props:{code:"JTIyaHVnJTIyJTNBJTIwJTVCJTIyaHVnJTIyJTVEJTIwKHNjb3JlJTIwMC4wNzE0MjgpJTBBJTIycHVnJTIyJTNBJTIwJTVCJTIycHUlMjIlMkMlMjAlMjJnJTIyJTVEJTIwKHNjb3JlJTIwMC4wMDc3MTApJTBBJTIycHVuJTIyJTNBJTIwJTVCJTIycHUlMjIlMkMlMjAlMjJuJTIyJTVEJTIwKHNjb3JlJTIwMC4wMDYxNjgpJTBBJTIyYnVuJTIyJTNBJTIwJTVCJTIyYnUlMjIlMkMlMjAlMjJuJTIyJTVEJTIwKHNjb3JlJTIwMC4wMDE0NTEpJTBBJTIyaHVncyUyMiUzQSUyMCU1QiUyMmh1ZyUyMiUyQyUyMCUyMnMlMjIlNUQlMjAoc2NvcmUlMjAwLjAwMTcwMSk=",highlighted:`<span class="hljs-string">&quot;hug&quot;</span>: [<span class="hljs-string">&quot;hug&quot;</span>] <span class="hljs-comment">(score 0.071428)</span>
<span class="hljs-string">&quot;pug&quot;</span>: [<span class="hljs-string">&quot;pu&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>] <span class="hljs-comment">(score 0.007710)</span>
<span class="hljs-string">&quot;pun&quot;</span>: [<span class="hljs-string">&quot;pu&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>] <span class="hljs-comment">(score 0.006168)</span>
<span class="hljs-string">&quot;bun&quot;</span>: [<span class="hljs-string">&quot;bu&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>] <span class="hljs-comment">(score 0.001451)</span>
<span class="hljs-string">&quot;hugs&quot;</span>: [<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>] <span class="hljs-comment">(score 0.001701)</span>`,wrap:!1}}),ys=new j({props:{code:"MTAlMjAqJTIwKC1sb2coMC4wNzE0MjgpKSUyMCUyQiUyMDUlMjAqJTIwKC1sb2coMC4wMDc3MTApKSUyMCUyQiUyMDEyJTIwKiUyMCgtbG9nKDAuMDA2MTY4KSklMjAlMkIlMjA0JTIwKiUyMCgtbG9nKDAuMDAxNDUxKSklMjAlMkIlMjA1JTIwKiUyMCgtbG9nKDAuMDAxNzAxKSklMjAlM0QlMjAxNjkuOA==",highlighted:'<span class="hljs-attribute">10</span> * (-log(<span class="hljs-number">0</span>.<span class="hljs-number">071428</span>)) + <span class="hljs-number">5</span> * (-log(<span class="hljs-number">0</span>.<span class="hljs-number">007710</span>)) + <span class="hljs-number">12</span> * (-log(<span class="hljs-number">0</span>.<span class="hljs-number">006168</span>)) + <span class="hljs-number">4</span> * (-log(<span class="hljs-number">0</span>.<span class="hljs-number">001451</span>)) + <span class="hljs-number">5</span> * (-log(<span class="hljs-number">0</span>.<span class="hljs-number">001701</span>)) = <span class="hljs-number">169</span>.<span class="hljs-number">8</span>',wrap:!1}}),js=new j({props:{code:"JTIyaHVnJTIyJTNBJTIwJTVCJTIyaHUlMjIlMkMlMjAlMjJnJTIyJTVEJTIwKHNjb3JlJTIwMC4wMDY4MDIpJTBBJTIyaHVncyUyMiUzQSUyMCU1QiUyMmh1JTIyJTJDJTIwJTIyZ3MlMjIlNUQlMjAoc2NvcmUlMjAwLjAwMTcwMSk=",highlighted:`<span class="hljs-string">&quot;hug&quot;</span>: [<span class="hljs-string">&quot;hu&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>] <span class="hljs-comment">(score 0.006802)</span>
<span class="hljs-string">&quot;hugs&quot;</span>: [<span class="hljs-string">&quot;hu&quot;</span>, <span class="hljs-string">&quot;gs&quot;</span>] <span class="hljs-comment">(score 0.001701)</span>`,wrap:!1}}),ds=new j({props:{code:"LSUyMDEwJTIwKiUyMCgtbG9nKDAuMDcxNDI4KSklMjAlMkIlMjAxMCUyMColMjAoLWxvZygwLjAwNjgwMikpJTIwJTNEJTIwMjMuNQ==",highlighted:'- <span class="hljs-number">10</span> * (<span class="hljs-name">-log</span>(<span class="hljs-number">0.071428</span>)) + <span class="hljs-number">10</span> * (<span class="hljs-name">-log</span>(<span class="hljs-number">0.006802</span>)) = <span class="hljs-number">23.5</span>',wrap:!1}}),bs=new ut({props:{title:"Implementing Unigram",local:"implementing-unigram",headingTag:"h2"}}),fs=new j({props:{code:"Y29ycHVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBDb3Vyc2UuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGNoYXB0ZXIlMjBpcyUyMGFib3V0JTIwdG9rZW5pemF0aW9uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoaXMlMjBzZWN0aW9uJTIwc2hvd3MlMjBzZXZlcmFsJTIwdG9rZW5pemVyJTIwYWxnb3JpdGhtcy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJIb3BlZnVsbHklMkMlMjB5b3UlMjB3aWxsJTIwYmUlMjBhYmxlJTIwdG8lMjB1bmRlcnN0YW5kJTIwaG93JTIwdGhleSUyMGFyZSUyMHRyYWluZWQlMjBhbmQlMjBnZW5lcmF0ZSUyMHRva2Vucy4lMjIlMkMlMEElNUQ=",highlighted:`corpus = [
    <span class="hljs-string">&quot;This is the Hugging Face Course.&quot;</span>,
    <span class="hljs-string">&quot;This chapter is about tokenization.&quot;</span>,
    <span class="hljs-string">&quot;This section shows several tokenizer algorithms.&quot;</span>,
    <span class="hljs-string">&quot;Hopefully, you will be able to understand how they are trained and generate tokens.&quot;</span>,
]`,wrap:!1}}),Is=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ4bG5ldC1iYXNlLWNhc2VkJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;xlnet-base-cased&quot;</span>)`,wrap:!1}}),vs=new j({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEF3b3JkX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQWZvciUyMHRleHQlMjBpbiUyMGNvcnB1cyUzQSUwQSUyMCUyMCUyMCUyMHdvcmRzX3dpdGhfb2Zmc2V0cyUyMCUzRCUyMHRva2VuaXplci5iYWNrZW5kX3Rva2VuaXplci5wcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIodGV4dCklMEElMjAlMjAlMjAlMjBuZXdfd29yZHMlMjAlM0QlMjAlNUJ3b3JkJTIwZm9yJTIwd29yZCUyQyUyMG9mZnNldCUyMGluJTIwd29yZHNfd2l0aF9vZmZzZXRzJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwbmV3X3dvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZF9mcmVxcyU1QndvcmQlNUQlMjAlMkIlM0QlMjAxJTBBJTBBd29yZF9mcmVxcw==",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

word_freqs = defaultdict(<span class="hljs-built_in">int</span>)
<span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> corpus:
    words_with_offsets = tokenizer.backend_tokenizer.pre_tokenizer.pre_tokenize_str(text)
    new_words = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> words_with_offsets]
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> new_words:
        word_freqs[word] += <span class="hljs-number">1</span>

word_freqs`,wrap:!1}}),qs=new j({props:{code:"Y2hhcl9mcmVxcyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEFzdWJ3b3Jkc19mcmVxcyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEFmb3IlMjB3b3JkJTJDJTIwZnJlcSUyMGluJTIwd29yZF9mcmVxcy5pdGVtcygpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UobGVuKHdvcmQpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNoYXJfZnJlcXMlNUJ3b3JkJTVCaSU1RCU1RCUyMCUyQiUzRCUyMGZyZXElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBMb29wJTIwdGhyb3VnaCUyMHRoZSUyMHN1YndvcmRzJTIwb2YlMjBsZW5ndGglMjBhdCUyMGxlYXN0JTIwMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGolMjBpbiUyMHJhbmdlKGklMjAlMkIlMjAyJTJDJTIwbGVuKHdvcmQpJTIwJTJCJTIwMSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdWJ3b3Jkc19mcmVxcyU1QndvcmQlNUJpJTNBaiU1RCU1RCUyMCUyQiUzRCUyMGZyZXElMEElMEElMjMlMjBTb3J0JTIwc3Vid29yZHMlMjBieSUyMGZyZXF1ZW5jeSUwQXNvcnRlZF9zdWJ3b3JkcyUyMCUzRCUyMHNvcnRlZChzdWJ3b3Jkc19mcmVxcy5pdGVtcygpJTJDJTIwa2V5JTNEbGFtYmRhJTIweCUzQSUyMHglNUIxJTVEJTJDJTIwcmV2ZXJzZSUzRFRydWUpJTBBc29ydGVkX3N1YndvcmRzJTVCJTNBMTAlNUQ=",highlighted:`char_freqs = defaultdict(<span class="hljs-built_in">int</span>)
subwords_freqs = defaultdict(<span class="hljs-built_in">int</span>)
<span class="hljs-keyword">for</span> word, freq <span class="hljs-keyword">in</span> word_freqs.items():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(word)):
        char_freqs[word[i]] += freq
        <span class="hljs-comment"># Loop through the subwords of length at least 2</span>
        <span class="hljs-keyword">for</span> j <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(i + <span class="hljs-number">2</span>, <span class="hljs-built_in">len</span>(word) + <span class="hljs-number">1</span>):
            subwords_freqs[word[i:j]] += freq

<span class="hljs-comment"># Sort subwords by frequency</span>
sorted_subwords = <span class="hljs-built_in">sorted</span>(subwords_freqs.items(), key=<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-number">1</span>], reverse=<span class="hljs-literal">True</span>)
sorted_subwords[:<span class="hljs-number">10</span>]`,wrap:!1}}),xs=new j({props:{code:"JTVCKCclRTIlOTYlODF0JyUyQyUyMDcpJTJDJTIwKCdpcyclMkMlMjA1KSUyQyUyMCgnZXInJTJDJTIwNSklMkMlMjAoJyVFMiU5NiU4MWEnJTJDJTIwNSklMkMlMjAoJyVFMiU5NiU4MXRvJyUyQyUyMDQpJTJDJTIwKCd0byclMkMlMjA0KSUyQyUyMCgnZW4nJTJDJTIwNCklMkMlMjAoJyVFMiU5NiU4MVQnJTJDJTIwMyklMkMlMjAoJyVFMiU5NiU4MVRoJyUyQyUyMDMpJTJDJTIwKCclRTIlOTYlODFUaGknJTJDJTIwMyklNUQ=",highlighted:'[(<span class="hljs-string">&#x27;▁t&#x27;</span>, <span class="hljs-number">7</span>), (<span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&#x27;er&#x27;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&#x27;▁a&#x27;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&#x27;to&#x27;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&#x27;▁T&#x27;</span>, <span class="hljs-number">3</span>), (<span class="hljs-string">&#x27;▁Th&#x27;</span>, <span class="hljs-number">3</span>), (<span class="hljs-string">&#x27;▁Thi&#x27;</span>, <span class="hljs-number">3</span>)]',wrap:!1}}),Zs=new j({props:{code:"dG9rZW5fZnJlcXMlMjAlM0QlMjBsaXN0KGNoYXJfZnJlcXMuaXRlbXMoKSklMjAlMkIlMjBzb3J0ZWRfc3Vid29yZHMlNUIlM0ElMjAzMDAlMjAtJTIwbGVuKGNoYXJfZnJlcXMpJTVEJTBBdG9rZW5fZnJlcXMlMjAlM0QlMjAlN0J0b2tlbiUzQSUyMGZyZXElMjBmb3IlMjB0b2tlbiUyQyUyMGZyZXElMjBpbiUyMHRva2VuX2ZyZXFzJTdE",highlighted:`token_freqs = <span class="hljs-built_in">list</span>(char_freqs.items()) + sorted_subwords[: <span class="hljs-number">300</span> - <span class="hljs-built_in">len</span>(char_freqs)]
token_freqs = {token: freq <span class="hljs-keyword">for</span> token, freq <span class="hljs-keyword">in</span> token_freqs}`,wrap:!1}}),$=new yt({props:{$$slots:{default:[fn]},$$scope:{ctx:J}}}),Ns=new j({props:{code:"ZnJvbSUyMG1hdGglMjBpbXBvcnQlMjBsb2clMEElMEF0b3RhbF9zdW0lMjAlM0QlMjBzdW0oJTVCZnJlcSUyMGZvciUyMHRva2VuJTJDJTIwZnJlcSUyMGluJTIwdG9rZW5fZnJlcXMuaXRlbXMoKSU1RCklMEFtb2RlbCUyMCUzRCUyMCU3QnRva2VuJTNBJTIwLWxvZyhmcmVxJTIwJTJGJTIwdG90YWxfc3VtKSUyMGZvciUyMHRva2VuJTJDJTIwZnJlcSUyMGluJTIwdG9rZW5fZnJlcXMuaXRlbXMoKSU3RA==",highlighted:`<span class="hljs-keyword">from</span> math <span class="hljs-keyword">import</span> log

total_sum = <span class="hljs-built_in">sum</span>([freq <span class="hljs-keyword">for</span> token, freq <span class="hljs-keyword">in</span> token_freqs.items()])
model = {token: -log(freq / total_sum) <span class="hljs-keyword">for</span> token, freq <span class="hljs-keyword">in</span> token_freqs.items()}`,wrap:!1}}),Bs=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">encode_word</span>(<span class="hljs-params">word, model</span>):
    best_segmentations = [{<span class="hljs-string">&quot;start&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">1</span>}] + [
        {<span class="hljs-string">&quot;start&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-literal">None</span>} <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(word))
    ]
    <span class="hljs-keyword">for</span> start_idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(word)):
        <span class="hljs-comment"># This should be properly filled by the previous steps of the loop</span>
        best_score_at_start = best_segmentations[start_idx][<span class="hljs-string">&quot;score&quot;</span>]
        <span class="hljs-keyword">for</span> end_idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(start_idx + <span class="hljs-number">1</span>, <span class="hljs-built_in">len</span>(word) + <span class="hljs-number">1</span>):
            token = word[start_idx:end_idx]
            <span class="hljs-keyword">if</span> token <span class="hljs-keyword">in</span> model <span class="hljs-keyword">and</span> best_score_at_start <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
                score = model[token] + best_score_at_start
                <span class="hljs-comment"># If we have found a better segmentation ending at end_idx, we update</span>
                <span class="hljs-keyword">if</span> (
                    best_segmentations[end_idx][<span class="hljs-string">&quot;score&quot;</span>] <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>
                    <span class="hljs-keyword">or</span> best_segmentations[end_idx][<span class="hljs-string">&quot;score&quot;</span>] &gt; score
                ):
                    best_segmentations[end_idx] = {<span class="hljs-string">&quot;start&quot;</span>: start_idx, <span class="hljs-string">&quot;score&quot;</span>: score}

    segmentation = best_segmentations[-<span class="hljs-number">1</span>]
    <span class="hljs-keyword">if</span> segmentation[<span class="hljs-string">&quot;score&quot;</span>] <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-comment"># We did not find a tokenization of the word -&gt; unknown</span>
        <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>], <span class="hljs-literal">None</span>

    score = segmentation[<span class="hljs-string">&quot;score&quot;</span>]
    start = segmentation[<span class="hljs-string">&quot;start&quot;</span>]
    end = <span class="hljs-built_in">len</span>(word)
    tokens = []
    <span class="hljs-keyword">while</span> start != <span class="hljs-number">0</span>:
        tokens.insert(<span class="hljs-number">0</span>, word[start:end])
        next_start = best_segmentations[start][<span class="hljs-string">&quot;start&quot;</span>]
        end = start
        start = next_start
    tokens.insert(<span class="hljs-number">0</span>, word[start:end])
    <span class="hljs-keyword">return</span> tokens, score`,wrap:!1}}),Ss=new j({props:{code:"cHJpbnQoZW5jb2RlX3dvcmQoJTIySG9wZWZ1bGx5JTIyJTJDJTIwbW9kZWwpKSUwQXByaW50KGVuY29kZV93b3JkKCUyMlRoaXMlMjIlMkMlMjBtb2RlbCkp",highlighted:`<span class="hljs-built_in">print</span>(encode_word(<span class="hljs-string">&quot;Hopefully&quot;</span>, model))
<span class="hljs-built_in">print</span>(encode_word(<span class="hljs-string">&quot;This&quot;</span>, model))`,wrap:!1}}),Rs=new j({props:{code:"KCU1QidIJyUyQyUyMCdvJyUyQyUyMCdwJyUyQyUyMCdlJyUyQyUyMCdmJyUyQyUyMCd1JyUyQyUyMCdsbCclMkMlMjAneSclNUQlMkMlMjA0MS41MTU3NDk0NjAxNDAyKSUwQSglNUInVGhpcyclNUQlMkMlMjA2LjI4ODI2NzAzMDY5NDUzNSk=",highlighted:`([<span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;ll&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>], <span class="hljs-number">41.5157494601402</span>)
([<span class="hljs-string">&#x27;This&#x27;</span>], <span class="hljs-number">6.288267030694535</span>)`,wrap:!1}}),Hs=new j({props:{code:"ZGVmJTIwY29tcHV0ZV9sb3NzKG1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjAwJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyQyUyMGZyZXElMjBpbiUyMHdvcmRfZnJlcXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lMkMlMjB3b3JkX2xvc3MlMjAlM0QlMjBlbmNvZGVfd29yZCh3b3JkJTJDJTIwbW9kZWwpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUyQiUzRCUyMGZyZXElMjAqJTIwd29yZF9sb3NzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbG9zcw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_loss</span>(<span class="hljs-params">model</span>):
    loss = <span class="hljs-number">0</span>
    <span class="hljs-keyword">for</span> word, freq <span class="hljs-keyword">in</span> word_freqs.items():
        _, word_loss = encode_word(word, model)
        loss += freq * word_loss
    <span class="hljs-keyword">return</span> loss`,wrap:!1}}),Ws=new j({props:{code:"Y29tcHV0ZV9sb3NzKG1vZGVsKQ==",highlighted:"compute_loss(model)",wrap:!1}}),Ks=new j({props:{code:"NDEzLjEwMzc3NjQyOTQwODc1",highlighted:'<span class="hljs-number">413.10377642940875</span>',wrap:!1}}),Ds=new j({props:{code:"aW1wb3J0JTIwY29weSUwQSUwQSUwQWRlZiUyMGNvbXB1dGVfc2NvcmVzKG1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMHNjb3JlcyUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMG1vZGVsX2xvc3MlMjAlM0QlMjBjb21wdXRlX2xvc3MobW9kZWwpJTBBJTIwJTIwJTIwJTIwZm9yJTIwdG9rZW4lMkMlMjBzY29yZSUyMGluJTIwbW9kZWwuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFdlJTIwYWx3YXlzJTIwa2VlcCUyMHRva2VucyUyMG9mJTIwbGVuZ3RoJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGVuKHRva2VuKSUyMCUzRCUzRCUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb250aW51ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX3dpdGhvdXRfdG9rZW4lMjAlM0QlMjBjb3B5LmRlZXBjb3B5KG1vZGVsKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lMjAlM0QlMjBtb2RlbF93aXRob3V0X3Rva2VuLnBvcCh0b2tlbiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzY29yZXMlNUJ0b2tlbiU1RCUyMCUzRCUyMGNvbXB1dGVfbG9zcyhtb2RlbF93aXRob3V0X3Rva2VuKSUyMC0lMjBtb2RlbF9sb3NzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2NvcmVz",highlighted:`<span class="hljs-keyword">import</span> copy


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_scores</span>(<span class="hljs-params">model</span>):
    scores = {}
    model_loss = compute_loss(model)
    <span class="hljs-keyword">for</span> token, score <span class="hljs-keyword">in</span> model.items():
        <span class="hljs-comment"># We always keep tokens of length 1</span>
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(token) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>
        model_without_token = copy.deepcopy(model)
        _ = model_without_token.pop(token)
        scores[token] = compute_loss(model_without_token) - model_loss
    <span class="hljs-keyword">return</span> scores`,wrap:!1}}),Ps=new j({props:{code:"c2NvcmVzJTIwJTNEJTIwY29tcHV0ZV9zY29yZXMobW9kZWwpJTBBcHJpbnQoc2NvcmVzJTVCJTIybGwlMjIlNUQpJTBBcHJpbnQoc2NvcmVzJTVCJTIyaGlzJTIyJTVEKQ==",highlighted:`scores = compute_scores(model)
<span class="hljs-built_in">print</span>(scores[<span class="hljs-string">&quot;ll&quot;</span>])
<span class="hljs-built_in">print</span>(scores[<span class="hljs-string">&quot;his&quot;</span>])`,wrap:!1}}),Os=new j({props:{code:"Ni4zNzY0MTI0MDM2MjM4NzQlMEEwLjA=",highlighted:`<span class="hljs-number">6.376412403623874</span>
<span class="hljs-number">0.0</span>`,wrap:!1}}),q=new yt({props:{$$slots:{default:[Cn]},$$scope:{ctx:J}}}),tt=new j({props:{code:"cGVyY2VudF90b19yZW1vdmUlMjAlM0QlMjAwLjElMEF3aGlsZSUyMGxlbihtb2RlbCklMjAlM0UlMjAxMDAlM0ElMEElMjAlMjAlMjAlMjBzY29yZXMlMjAlM0QlMjBjb21wdXRlX3Njb3Jlcyhtb2RlbCklMEElMjAlMjAlMjAlMjBzb3J0ZWRfc2NvcmVzJTIwJTNEJTIwc29ydGVkKHNjb3Jlcy5pdGVtcygpJTJDJTIwa2V5JTNEbGFtYmRhJTIweCUzQSUyMHglNUIxJTVEKSUwQSUyMCUyMCUyMCUyMCUyMyUyMFJlbW92ZSUyMHBlcmNlbnRfdG9fcmVtb3ZlJTIwdG9rZW5zJTIwd2l0aCUyMHRoZSUyMGxvd2VzdCUyMHNjb3Jlcy4lMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShpbnQobGVuKG1vZGVsKSUyMColMjBwZXJjZW50X3RvX3JlbW92ZSkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwXyUyMCUzRCUyMHRva2VuX2ZyZXFzLnBvcChzb3J0ZWRfc2NvcmVzJTVCaSU1RCU1QjAlNUQpJTBBJTBBJTIwJTIwJTIwJTIwdG90YWxfc3VtJTIwJTNEJTIwc3VtKCU1QmZyZXElMjBmb3IlMjB0b2tlbiUyQyUyMGZyZXElMjBpbiUyMHRva2VuX2ZyZXFzLml0ZW1zKCklNUQpJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjAlN0J0b2tlbiUzQSUyMC1sb2coZnJlcSUyMCUyRiUyMHRvdGFsX3N1bSklMjBmb3IlMjB0b2tlbiUyQyUyMGZyZXElMjBpbiUyMHRva2VuX2ZyZXFzLml0ZW1zKCklN0Q=",highlighted:`percent_to_remove = <span class="hljs-number">0.1</span>
<span class="hljs-keyword">while</span> <span class="hljs-built_in">len</span>(model) &gt; <span class="hljs-number">100</span>:
    scores = compute_scores(model)
    sorted_scores = <span class="hljs-built_in">sorted</span>(scores.items(), key=<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-number">1</span>])
    <span class="hljs-comment"># Remove percent_to_remove tokens with the lowest scores.</span>
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">int</span>(<span class="hljs-built_in">len</span>(model) * percent_to_remove)):
        _ = token_freqs.pop(sorted_scores[i][<span class="hljs-number">0</span>])

    total_sum = <span class="hljs-built_in">sum</span>([freq <span class="hljs-keyword">for</span> token, freq <span class="hljs-keyword">in</span> token_freqs.items()])
    model = {token: -log(freq / total_sum) <span class="hljs-keyword">for</span> token, freq <span class="hljs-keyword">in</span> token_freqs.items()}`,wrap:!1}}),at=new j({props:{code:"ZGVmJTIwdG9rZW5pemUodGV4dCUyQyUyMG1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMHdvcmRzX3dpdGhfb2Zmc2V0cyUyMCUzRCUyMHRva2VuaXplci5iYWNrZW5kX3Rva2VuaXplci5wcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIodGV4dCklMEElMjAlMjAlMjAlMjBwcmVfdG9rZW5pemVkX3RleHQlMjAlM0QlMjAlNUJ3b3JkJTIwZm9yJTIwd29yZCUyQyUyMG9mZnNldCUyMGluJTIwd29yZHNfd2l0aF9vZmZzZXRzJTVEJTBBJTIwJTIwJTIwJTIwZW5jb2RlZF93b3JkcyUyMCUzRCUyMCU1QmVuY29kZV93b3JkKHdvcmQlMkMlMjBtb2RlbCklNUIwJTVEJTIwZm9yJTIwd29yZCUyMGluJTIwcHJlX3Rva2VuaXplZF90ZXh0JTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3VtKGVuY29kZWRfd29yZHMlMkMlMjAlNUIlNUQpJTBBJTBBJTBBdG9rZW5pemUoJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBjb3Vyc2UuJTIyJTJDJTIwbW9kZWwp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">text, model</span>):
    words_with_offsets = tokenizer.backend_tokenizer.pre_tokenizer.pre_tokenize_str(text)
    pre_tokenized_text = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> words_with_offsets]
    encoded_words = [encode_word(word, model)[<span class="hljs-number">0</span>] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> pre_tokenized_text]
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">sum</span>(encoded_words, [])


tokenize(<span class="hljs-string">&quot;This is the Hugging Face course.&quot;</span>, model)`,wrap:!1}}),nt=new j({props:{code:"JTVCJyVFMiU5NiU4MVRoaXMnJTJDJTIwJyVFMiU5NiU4MWlzJyUyQyUyMCclRTIlOTYlODF0aGUnJTJDJTIwJyVFMiU5NiU4MUh1Z2dpbmcnJTJDJTIwJyVFMiU5NiU4MUZhY2UnJTJDJTIwJyVFMiU5NiU4MSclMkMlMjAnYyclMkMlMjAnb3UnJTJDJTIwJ3InJTJDJTIwJ3MnJTJDJTIwJ2UnJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;▁This&#x27;</span>, <span class="hljs-string">&#x27;▁is&#x27;</span>, <span class="hljs-string">&#x27;▁the&#x27;</span>, <span class="hljs-string">&#x27;▁Hugging&#x27;</span>, <span class="hljs-string">&#x27;▁Face&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;ou&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),{c(){r=p("meta"),U=n(),w=p("p"),d=n(),m(A.$$.fragment),jt=n(),m(Z.$$.fragment),Ut=n(),_=p("p"),_.textContent=ha,dt=n(),m(N.$$.fragment),Jt=n(),m(C.$$.fragment),bt=n(),m(z.$$.fragment),Tt=n(),V=p("p"),V.textContent=Ma,gt=n(),Q=p("p"),Q.textContent=ya,ft=n(),I=p("p"),na=ot("This is all a very costly operation, so we don’t just remove the single symbol associated with the lowest loss increase, but the"),Ct=new ma(!1),It=ot(" (\\(p\\) being a hyperparameter you can control, usually 10 or 20) percent of the symbols associated with the lowest loss increase. This process is then repeated until the vocabulary has reached the desired size."),kt=n(),B=p("p"),B.textContent=ua,vt=n(),G=p("p"),G.textContent=wa,$t=n(),S=p("p"),S.textContent=ja,qt=n(),m(R.$$.fragment),xt=n(),E=p("p"),E.textContent=Ua,At=n(),m(H.$$.fragment),Zt=n(),m(X.$$.fragment),_t=n(),W=p("p"),W.textContent=da,Nt=n(),K=p("p"),K.innerHTML=Ja,zt=n(),Y=p("p"),Y.textContent=ba,Vt=n(),m(D.$$.fragment),Qt=n(),F=p("p"),F.innerHTML=Ta,Bt=n(),m(k.$$.fragment),Gt=n(),b=p("p"),la=ot("Now, to tokenize a given word, we look at all the possible segmentations into tokens and compute the probability of each according to the Unigram model. Since all tokens are considered independent, this probability is just the product of the probability of each token. For instance, the tokenization "),rt=p("code"),rt.textContent=ga,pa=ot(" of "),mt=p("code"),mt.textContent=fa,oa=ot(` has the probability:
`),St=new ma(!1),Rt=n(),f=p("p"),ia=ot("Comparatively, the tokenization "),ct=p("code"),ct.textContent=Ca,ra=ot(` has the probability:
`),Et=new ma(!1),Ht=n(),P=p("p"),P.textContent=Ia,Xt=n(),L=p("p"),L.innerHTML=ka,Wt=n(),m(O.$$.fragment),Kt=n(),ss=p("p"),ss.innerHTML=va,Yt=n(),ts=p("p"),ts.innerHTML=$a,Dt=n(),es=p("p"),es.textContent=qa,Ft=n(),as=p("p"),as.innerHTML=xa,Pt=n(),m(ns.$$.fragment),Lt=n(),ls=p("p"),ls.innerHTML=Aa,Ot=n(),m(v.$$.fragment),se=n(),m(ps.$$.fragment),te=n(),os=p("p"),os.textContent=Za,ee=n(),is=p("p"),is.innerHTML=_a,ae=n(),rs=p("p"),rs.textContent=Na,ne=n(),m(ms.$$.fragment),le=n(),cs=p("p"),cs.textContent=za,pe=n(),m(hs.$$.fragment),oe=n(),Ms=p("p"),Ms.textContent=Va,ie=n(),m(ys.$$.fragment),re=n(),us=p("p"),us.innerHTML=Qa,me=n(),ws=p("p"),ws.innerHTML=Ba,ce=n(),m(js.$$.fragment),he=n(),Us=p("p"),Us.textContent=Ga,Me=n(),m(ds.$$.fragment),ye=n(),Js=p("p"),Js.innerHTML=Sa,ue=n(),m(bs.$$.fragment),we=n(),Ts=p("p"),Ts.textContent=Ra,je=n(),gs=p("p"),gs.textContent=Ea,Ue=n(),m(fs.$$.fragment),de=n(),Cs=p("p"),Cs.innerHTML=Ha,Je=n(),m(Is.$$.fragment),be=n(),ks=p("p"),ks.textContent=Xa,Te=n(),m(vs.$$.fragment),ge=n(),$s=p("p"),$s.textContent=Wa,fe=n(),m(qs.$$.fragment),Ce=n(),m(xs.$$.fragment),Ie=n(),As=p("p"),As.textContent=Ka,ke=n(),m(Zs.$$.fragment),ve=n(),m($.$$.fragment),$e=n(),_s=p("p"),_s.textContent=Ya,qe=n(),m(Ns.$$.fragment),xe=n(),zs=p("p"),zs.innerHTML=Da,Ae=n(),Vs=p("p"),Vs.innerHTML=Fa,Ze=n(),Qs=p("p"),Qs.textContent=Pa,_e=n(),m(Bs.$$.fragment),Ne=n(),Gs=p("p"),Gs.textContent=La,ze=n(),m(Ss.$$.fragment),Ve=n(),m(Rs.$$.fragment),Qe=n(),Es=p("p"),Es.textContent=Oa,Be=n(),m(Hs.$$.fragment),Ge=n(),Xs=p("p"),Xs.textContent=sn,Se=n(),m(Ws.$$.fragment),Re=n(),m(Ks.$$.fragment),Ee=n(),Ys=p("p"),Ys.textContent=tn,He=n(),m(Ds.$$.fragment),Xe=n(),Fs=p("p"),Fs.textContent=en,We=n(),m(Ps.$$.fragment),Ke=n(),Ls=p("p"),Ls.innerHTML=an,Ye=n(),m(Os.$$.fragment),De=n(),m(q.$$.fragment),Fe=n(),st=p("p"),st.textContent=nn,Pe=n(),m(tt.$$.fragment),Le=n(),et=p("p"),et.innerHTML=ln,Oe=n(),m(at.$$.fragment),sa=n(),m(nt.$$.fragment),ta=n(),lt=p("p"),lt.textContent=pn,ea=n(),ht=p("p"),this.h()},l(s){const t=Un("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(e),U=l(s),w=o(s,"P",{}),Mt(w).forEach(e),d=l(s),c(A.$$.fragment,s),jt=l(s),c(Z.$$.fragment,s),Ut=l(s),_=o(s,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1ogtfl7"&&(_.textContent=ha),dt=l(s),c(N.$$.fragment,s),Jt=l(s),c(C.$$.fragment,s),bt=l(s),c(z.$$.fragment,s),Tt=l(s),V=o(s,"P",{"data-svelte-h":!0}),i(V)!=="svelte-16vv0fb"&&(V.textContent=Ma),gt=l(s),Q=o(s,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1yvt99t"&&(Q.textContent=ya),ft=l(s),I=o(s,"P",{});var pt=Mt(I);na=it(pt,"This is all a very costly operation, so we don’t just remove the single symbol associated with the lowest loss increase, but the"),Ct=ca(pt,!1),It=it(pt," (\\(p\\) being a hyperparameter you can control, usually 10 or 20) percent of the symbols associated with the lowest loss increase. This process is then repeated until the vocabulary has reached the desired size."),pt.forEach(e),kt=l(s),B=o(s,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1bd68el"&&(B.textContent=ua),vt=l(s),G=o(s,"P",{"data-svelte-h":!0}),i(G)!=="svelte-18sgwt4"&&(G.textContent=wa),$t=l(s),S=o(s,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1rnxwlp"&&(S.textContent=ja),qt=l(s),c(R.$$.fragment,s),xt=l(s),E=o(s,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1sp8vuv"&&(E.textContent=Ua),At=l(s),c(H.$$.fragment,s),Zt=l(s),c(X.$$.fragment,s),_t=l(s),W=o(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-17i13c1"&&(W.textContent=da),Nt=l(s),K=o(s,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1ywxof8"&&(K.innerHTML=Ja),zt=l(s),Y=o(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1im6u9i"&&(Y.textContent=ba),Vt=l(s),c(D.$$.fragment,s),Qt=l(s),F=o(s,"P",{"data-svelte-h":!0}),i(F)!=="svelte-16cln8v"&&(F.innerHTML=Ta),Bt=l(s),c(k.$$.fragment,s),Gt=l(s),b=o(s,"P",{});var g=Mt(b);la=it(g,"Now, to tokenize a given word, we look at all the possible segmentations into tokens and compute the probability of each according to the Unigram model. Since all tokens are considered independent, this probability is just the product of the probability of each token. For instance, the tokenization "),rt=o(g,"CODE",{"data-svelte-h":!0}),i(rt)!=="svelte-1n2m4po"&&(rt.textContent=ga),pa=it(g," of "),mt=o(g,"CODE",{"data-svelte-h":!0}),i(mt)!=="svelte-1gjdq76"&&(mt.textContent=fa),oa=it(g,` has the probability:
`),St=ca(g,!1),g.forEach(e),Rt=l(s),f=o(s,"P",{});var x=Mt(f);ia=it(x,"Comparatively, the tokenization "),ct=o(x,"CODE",{"data-svelte-h":!0}),i(ct)!=="svelte-42m5r0"&&(ct.textContent=Ca),ra=it(x,` has the probability:
`),Et=ca(x,!1),x.forEach(e),Ht=l(s),P=o(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-g2doa3"&&(P.textContent=Ia),Xt=l(s),L=o(s,"P",{"data-svelte-h":!0}),i(L)!=="svelte-9ovu4k"&&(L.innerHTML=ka),Wt=l(s),c(O.$$.fragment,s),Kt=l(s),ss=o(s,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-by7atq"&&(ss.innerHTML=va),Yt=l(s),ts=o(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-1re84pi"&&(ts.innerHTML=$a),Dt=l(s),es=o(s,"P",{"data-svelte-h":!0}),i(es)!=="svelte-4w9cp8"&&(es.textContent=qa),Ft=l(s),as=o(s,"P",{"data-svelte-h":!0}),i(as)!=="svelte-1v3e60i"&&(as.innerHTML=xa),Pt=l(s),c(ns.$$.fragment,s),Lt=l(s),ls=o(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-17ww2xx"&&(ls.innerHTML=Aa),Ot=l(s),c(v.$$.fragment,s),se=l(s),c(ps.$$.fragment,s),te=l(s),os=o(s,"P",{"data-svelte-h":!0}),i(os)!=="svelte-1mxwvxi"&&(os.textContent=Za),ee=l(s),is=o(s,"P",{"data-svelte-h":!0}),i(is)!=="svelte-r1ko6w"&&(is.innerHTML=_a),ae=l(s),rs=o(s,"P",{"data-svelte-h":!0}),i(rs)!=="svelte-1y2guu9"&&(rs.textContent=Na),ne=l(s),c(ms.$$.fragment,s),le=l(s),cs=o(s,"P",{"data-svelte-h":!0}),i(cs)!=="svelte-smnwx3"&&(cs.textContent=za),pe=l(s),c(hs.$$.fragment,s),oe=l(s),Ms=o(s,"P",{"data-svelte-h":!0}),i(Ms)!=="svelte-14jcfwu"&&(Ms.textContent=Va),ie=l(s),c(ys.$$.fragment,s),re=l(s),us=o(s,"P",{"data-svelte-h":!0}),i(us)!=="svelte-1rsqmv"&&(us.innerHTML=Qa),me=l(s),ws=o(s,"P",{"data-svelte-h":!0}),i(ws)!=="svelte-1e3tr4j"&&(ws.innerHTML=Ba),ce=l(s),c(js.$$.fragment,s),he=l(s),Us=o(s,"P",{"data-svelte-h":!0}),i(Us)!=="svelte-15gzb9u"&&(Us.textContent=Ga),Me=l(s),c(ds.$$.fragment,s),ye=l(s),Js=o(s,"P",{"data-svelte-h":!0}),i(Js)!=="svelte-1gwabz2"&&(Js.innerHTML=Sa),ue=l(s),c(bs.$$.fragment,s),we=l(s),Ts=o(s,"P",{"data-svelte-h":!0}),i(Ts)!=="svelte-1p0q4mo"&&(Ts.textContent=Ra),je=l(s),gs=o(s,"P",{"data-svelte-h":!0}),i(gs)!=="svelte-160kau6"&&(gs.textContent=Ea),Ue=l(s),c(fs.$$.fragment,s),de=l(s),Cs=o(s,"P",{"data-svelte-h":!0}),i(Cs)!=="svelte-5hfan0"&&(Cs.innerHTML=Ha),Je=l(s),c(Is.$$.fragment,s),be=l(s),ks=o(s,"P",{"data-svelte-h":!0}),i(ks)!=="svelte-1p0ikvu"&&(ks.textContent=Xa),Te=l(s),c(vs.$$.fragment,s),ge=l(s),$s=o(s,"P",{"data-svelte-h":!0}),i($s)!=="svelte-1njxouy"&&($s.textContent=Wa),fe=l(s),c(qs.$$.fragment,s),Ce=l(s),c(xs.$$.fragment,s),Ie=l(s),As=o(s,"P",{"data-svelte-h":!0}),i(As)!=="svelte-1rbeurr"&&(As.textContent=Ka),ke=l(s),c(Zs.$$.fragment,s),ve=l(s),c($.$$.fragment,s),$e=l(s),_s=o(s,"P",{"data-svelte-h":!0}),i(_s)!=="svelte-kpz2jw"&&(_s.textContent=Ya),qe=l(s),c(Ns.$$.fragment,s),xe=l(s),zs=o(s,"P",{"data-svelte-h":!0}),i(zs)!=="svelte-1vp6twv"&&(zs.innerHTML=Da),Ae=l(s),Vs=o(s,"P",{"data-svelte-h":!0}),i(Vs)!=="svelte-8o0mkc"&&(Vs.innerHTML=Fa),Ze=l(s),Qs=o(s,"P",{"data-svelte-h":!0}),i(Qs)!=="svelte-76z975"&&(Qs.textContent=Pa),_e=l(s),c(Bs.$$.fragment,s),Ne=l(s),Gs=o(s,"P",{"data-svelte-h":!0}),i(Gs)!=="svelte-1riuhoo"&&(Gs.textContent=La),ze=l(s),c(Ss.$$.fragment,s),Ve=l(s),c(Rs.$$.fragment,s),Qe=l(s),Es=o(s,"P",{"data-svelte-h":!0}),i(Es)!=="svelte-ncpc2j"&&(Es.textContent=Oa),Be=l(s),c(Hs.$$.fragment,s),Ge=l(s),Xs=o(s,"P",{"data-svelte-h":!0}),i(Xs)!=="svelte-p7t1po"&&(Xs.textContent=sn),Se=l(s),c(Ws.$$.fragment,s),Re=l(s),c(Ks.$$.fragment,s),Ee=l(s),Ys=o(s,"P",{"data-svelte-h":!0}),i(Ys)!=="svelte-emtee"&&(Ys.textContent=tn),He=l(s),c(Ds.$$.fragment,s),Xe=l(s),Fs=o(s,"P",{"data-svelte-h":!0}),i(Fs)!=="svelte-qxfbyo"&&(Fs.textContent=en),We=l(s),c(Ps.$$.fragment,s),Ke=l(s),Ls=o(s,"P",{"data-svelte-h":!0}),i(Ls)!=="svelte-zu2ggv"&&(Ls.innerHTML=an),Ye=l(s),c(Os.$$.fragment,s),De=l(s),c(q.$$.fragment,s),Fe=l(s),st=o(s,"P",{"data-svelte-h":!0}),i(st)!=="svelte-1vz3e3j"&&(st.textContent=nn),Pe=l(s),c(tt.$$.fragment,s),Le=l(s),et=o(s,"P",{"data-svelte-h":!0}),i(et)!=="svelte-m3sdwl"&&(et.innerHTML=ln),Oe=l(s),c(at.$$.fragment,s),sa=l(s),c(nt.$$.fragment,s),ta=l(s),lt=o(s,"P",{"data-svelte-h":!0}),i(lt)!=="svelte-1hk3m3g"&&(lt.textContent=pn),ea=l(s),ht=o(s,"P",{}),Mt(ht).forEach(e),this.h()},h(){mn(r,"name","hf:doc:metadata"),mn(r,"content",kn),Ct.a=It,St.a=null,Et.a=null},m(s,t){T(document.head,r),a(s,U,t),a(s,w,t),a(s,d,t),h(A,s,t),a(s,jt,t),h(Z,s,t),a(s,Ut,t),a(s,_,t),a(s,dt,t),h(N,s,t),a(s,Jt,t),h(C,s,t),a(s,bt,t),h(z,s,t),a(s,Tt,t),a(s,V,t),a(s,gt,t),a(s,Q,t),a(s,ft,t),a(s,I,t),T(I,na),Ct.m(cn,I),T(I,It),a(s,kt,t),a(s,B,t),a(s,vt,t),a(s,G,t),a(s,$t,t),a(s,S,t),a(s,qt,t),h(R,s,t),a(s,xt,t),a(s,E,t),a(s,At,t),h(H,s,t),a(s,Zt,t),h(X,s,t),a(s,_t,t),a(s,W,t),a(s,Nt,t),a(s,K,t),a(s,zt,t),a(s,Y,t),a(s,Vt,t),h(D,s,t),a(s,Qt,t),a(s,F,t),a(s,Bt,t),h(k,s,t),a(s,Gt,t),a(s,b,t),T(b,la),T(b,rt),T(b,pa),T(b,mt),T(b,oa),St.m(hn,b),a(s,Rt,t),a(s,f,t),T(f,ia),T(f,ct),T(f,ra),Et.m(Mn,f),a(s,Ht,t),a(s,P,t),a(s,Xt,t),a(s,L,t),a(s,Wt,t),h(O,s,t),a(s,Kt,t),a(s,ss,t),a(s,Yt,t),a(s,ts,t),a(s,Dt,t),a(s,es,t),a(s,Ft,t),a(s,as,t),a(s,Pt,t),h(ns,s,t),a(s,Lt,t),a(s,ls,t),a(s,Ot,t),h(v,s,t),a(s,se,t),h(ps,s,t),a(s,te,t),a(s,os,t),a(s,ee,t),a(s,is,t),a(s,ae,t),a(s,rs,t),a(s,ne,t),h(ms,s,t),a(s,le,t),a(s,cs,t),a(s,pe,t),h(hs,s,t),a(s,oe,t),a(s,Ms,t),a(s,ie,t),h(ys,s,t),a(s,re,t),a(s,us,t),a(s,me,t),a(s,ws,t),a(s,ce,t),h(js,s,t),a(s,he,t),a(s,Us,t),a(s,Me,t),h(ds,s,t),a(s,ye,t),a(s,Js,t),a(s,ue,t),h(bs,s,t),a(s,we,t),a(s,Ts,t),a(s,je,t),a(s,gs,t),a(s,Ue,t),h(fs,s,t),a(s,de,t),a(s,Cs,t),a(s,Je,t),h(Is,s,t),a(s,be,t),a(s,ks,t),a(s,Te,t),h(vs,s,t),a(s,ge,t),a(s,$s,t),a(s,fe,t),h(qs,s,t),a(s,Ce,t),h(xs,s,t),a(s,Ie,t),a(s,As,t),a(s,ke,t),h(Zs,s,t),a(s,ve,t),h($,s,t),a(s,$e,t),a(s,_s,t),a(s,qe,t),h(Ns,s,t),a(s,xe,t),a(s,zs,t),a(s,Ae,t),a(s,Vs,t),a(s,Ze,t),a(s,Qs,t),a(s,_e,t),h(Bs,s,t),a(s,Ne,t),a(s,Gs,t),a(s,ze,t),h(Ss,s,t),a(s,Ve,t),h(Rs,s,t),a(s,Qe,t),a(s,Es,t),a(s,Be,t),h(Hs,s,t),a(s,Ge,t),a(s,Xs,t),a(s,Se,t),h(Ws,s,t),a(s,Re,t),h(Ks,s,t),a(s,Ee,t),a(s,Ys,t),a(s,He,t),h(Ds,s,t),a(s,Xe,t),a(s,Fs,t),a(s,We,t),h(Ps,s,t),a(s,Ke,t),a(s,Ls,t),a(s,Ye,t),h(Os,s,t),a(s,De,t),h(q,s,t),a(s,Fe,t),a(s,st,t),a(s,Pe,t),h(tt,s,t),a(s,Le,t),a(s,et,t),a(s,Oe,t),h(at,s,t),a(s,sa,t),h(nt,s,t),a(s,ta,t),a(s,lt,t),a(s,ea,t),a(s,ht,t),aa=!0},p(s,[t]){const pt={};t&2&&(pt.$$scope={dirty:t,ctx:s}),C.$set(pt);const g={};t&2&&(g.$$scope={dirty:t,ctx:s}),k.$set(g);const x={};t&2&&(x.$$scope={dirty:t,ctx:s}),v.$set(x);const on={};t&2&&(on.$$scope={dirty:t,ctx:s}),$.$set(on);const rn={};t&2&&(rn.$$scope={dirty:t,ctx:s}),q.$set(rn)},i(s){aa||(M(A.$$.fragment,s),M(Z.$$.fragment,s),M(N.$$.fragment,s),M(C.$$.fragment,s),M(z.$$.fragment,s),M(R.$$.fragment,s),M(H.$$.fragment,s),M(X.$$.fragment,s),M(D.$$.fragment,s),M(k.$$.fragment,s),M(O.$$.fragment,s),M(ns.$$.fragment,s),M(v.$$.fragment,s),M(ps.$$.fragment,s),M(ms.$$.fragment,s),M(hs.$$.fragment,s),M(ys.$$.fragment,s),M(js.$$.fragment,s),M(ds.$$.fragment,s),M(bs.$$.fragment,s),M(fs.$$.fragment,s),M(Is.$$.fragment,s),M(vs.$$.fragment,s),M(qs.$$.fragment,s),M(xs.$$.fragment,s),M(Zs.$$.fragment,s),M($.$$.fragment,s),M(Ns.$$.fragment,s),M(Bs.$$.fragment,s),M(Ss.$$.fragment,s),M(Rs.$$.fragment,s),M(Hs.$$.fragment,s),M(Ws.$$.fragment,s),M(Ks.$$.fragment,s),M(Ds.$$.fragment,s),M(Ps.$$.fragment,s),M(Os.$$.fragment,s),M(q.$$.fragment,s),M(tt.$$.fragment,s),M(at.$$.fragment,s),M(nt.$$.fragment,s),aa=!0)},o(s){y(A.$$.fragment,s),y(Z.$$.fragment,s),y(N.$$.fragment,s),y(C.$$.fragment,s),y(z.$$.fragment,s),y(R.$$.fragment,s),y(H.$$.fragment,s),y(X.$$.fragment,s),y(D.$$.fragment,s),y(k.$$.fragment,s),y(O.$$.fragment,s),y(ns.$$.fragment,s),y(v.$$.fragment,s),y(ps.$$.fragment,s),y(ms.$$.fragment,s),y(hs.$$.fragment,s),y(ys.$$.fragment,s),y(js.$$.fragment,s),y(ds.$$.fragment,s),y(bs.$$.fragment,s),y(fs.$$.fragment,s),y(Is.$$.fragment,s),y(vs.$$.fragment,s),y(qs.$$.fragment,s),y(xs.$$.fragment,s),y(Zs.$$.fragment,s),y($.$$.fragment,s),y(Ns.$$.fragment,s),y(Bs.$$.fragment,s),y(Ss.$$.fragment,s),y(Rs.$$.fragment,s),y(Hs.$$.fragment,s),y(Ws.$$.fragment,s),y(Ks.$$.fragment,s),y(Ds.$$.fragment,s),y(Ps.$$.fragment,s),y(Os.$$.fragment,s),y(q.$$.fragment,s),y(tt.$$.fragment,s),y(at.$$.fragment,s),y(nt.$$.fragment,s),aa=!1},d(s){s&&(e(U),e(w),e(d),e(jt),e(Ut),e(_),e(dt),e(Jt),e(bt),e(Tt),e(V),e(gt),e(Q),e(ft),e(I),e(kt),e(B),e(vt),e(G),e($t),e(S),e(qt),e(xt),e(E),e(At),e(Zt),e(_t),e(W),e(Nt),e(K),e(zt),e(Y),e(Vt),e(Qt),e(F),e(Bt),e(Gt),e(b),e(Rt),e(f),e(Ht),e(P),e(Xt),e(L),e(Wt),e(Kt),e(ss),e(Yt),e(ts),e(Dt),e(es),e(Ft),e(as),e(Pt),e(Lt),e(ls),e(Ot),e(se),e(te),e(os),e(ee),e(is),e(ae),e(rs),e(ne),e(le),e(cs),e(pe),e(oe),e(Ms),e(ie),e(re),e(us),e(me),e(ws),e(ce),e(he),e(Us),e(Me),e(ye),e(Js),e(ue),e(we),e(Ts),e(je),e(gs),e(Ue),e(de),e(Cs),e(Je),e(be),e(ks),e(Te),e(ge),e($s),e(fe),e(Ce),e(Ie),e(As),e(ke),e(ve),e($e),e(_s),e(qe),e(xe),e(zs),e(Ae),e(Vs),e(Ze),e(Qs),e(_e),e(Ne),e(Gs),e(ze),e(Ve),e(Qe),e(Es),e(Be),e(Ge),e(Xs),e(Se),e(Re),e(Ee),e(Ys),e(He),e(Xe),e(Fs),e(We),e(Ke),e(Ls),e(Ye),e(De),e(Fe),e(st),e(Pe),e(Le),e(et),e(Oe),e(sa),e(ta),e(lt),e(ea),e(ht)),e(r),u(A,s),u(Z,s),u(N,s),u(C,s),u(z,s),u(R,s),u(H,s),u(X,s),u(D,s),u(k,s),u(O,s),u(ns,s),u(v,s),u(ps,s),u(ms,s),u(hs,s),u(ys,s),u(js,s),u(ds,s),u(bs,s),u(fs,s),u(Is,s),u(vs,s),u(qs,s),u(xs,s),u(Zs,s),u($,s),u(Ns,s),u(Bs,s),u(Ss,s),u(Rs,s),u(Hs,s),u(Ws,s),u(Ks,s),u(Ds,s),u(Ps,s),u(Os,s),u(q,s),u(tt,s),u(at,s),u(nt,s)}}}const kn='{"title":"Unigram tokenization","local":"unigram-tokenization","sections":[{"title":"Training algorithm","local":"training-algorithm","sections":[],"depth":2},{"title":"Tokenization algorithm","local":"tokenization-algorithm","sections":[],"depth":2},{"title":"Back to training","local":"back-to-training","sections":[],"depth":2},{"title":"Implementing Unigram","local":"implementing-unigram","sections":[],"depth":2}],"depth":1}';function vn(J){return un(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zn extends wn{constructor(r){super(),jn(this,r,vn,In,yn,{})}}export{zn as component};
