import{s as Ts,n as ms,o as ws}from"../chunks/scheduler.9680c161.js";import{S as js,i as hs,g as M,s as a,r as y,A as Is,h as o,f as t,c as n,j as rs,u as i,x as c,k as cs,y as ds,a as e,v as p,d as U,t as J,w as u}from"../chunks/index.38d74ee1.js";import{C as as}from"../chunks/CodeBlock.1371964c.js";import{H as E}from"../chunks/Heading.74c51a96.js";function gs(ns){let r,V,W,x,T,Y,m,Ms="Text Generation Inference (TGI) now supports the Messages API, which is fully compatible with the OpenAI Chat Completion API. This feature is available starting from version 1.4.0. You can use OpenAI’s client libraries or third-party libraries expecting OpenAI schema to interact with TGI’s Messages API. Below are some examples of how to utilize this compatibility.",$,w,os="<p><strong>Note:</strong> The Messages API is supported from TGI version 1.4.0 and above. Ensure you are using a compatible version to access this feature.</p>",k,j,v,h,ys="You can make a request to TGI’s Messages API using <code>curl</code>. Here’s an example:",R,I,_,d,z,g,is="You can also use OpenAI’s Python client library to make a streaming request. Here’s how:",X,C,F,b,H,G,ps="If you prefer to make a synchronous request, you can do so like this:",P,B,L,f,D,Q,Us="TGI can be deployed on various cloud providers for scalable and robust text generation. One such provider is Amazon SageMaker, which has recently added support for TGI. Here’s how you can deploy TGI on Amazon SageMaker:",O,Z,K,S,Js="To enable the Messages API in Amazon SageMaker you need to set the environment variable <code>MESSAGES_API_ENABLED=true</code>.",ss,q,us="This will modify the <code>/invocations</code> route to accept Messages dictonaries consisting out of role and content. See the example below on how to deploy Llama with the new Messages API.",ls,A,ts,N,es;return T=new E({props:{title:"Messages API",local:"messages-api",headingTag:"h1"}}),j=new E({props:{title:"Making a Request",local:"making-a-request",headingTag:"h2"}}),I=new as({props:{code:"Y3VybCUyMGxvY2FsaG9zdCUzQTMwMDAlMkZ2MSUyRmNoYXQlMkZjb21wbGV0aW9ucyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1YJTIwUE9TVCUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUwQSUyMCUyMCUyMm1vZGVsJTIyJTNBJTIwJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnN0cmVhbSUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjJtYXhfdG9rZW5zJTIyJTNBJTIwMjAlMEElN0QnJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAnQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJw==",highlighted:`curl localhost:3000/v1/chat/completions \\
    -X POST \\
    -d <span class="hljs-string">&#x27;{
  &quot;model&quot;: &quot;tgi&quot;,
  &quot;messages&quot;: [
    {
      &quot;role&quot;: &quot;system&quot;,
      &quot;content&quot;: &quot;You are a helpful assistant.&quot;
    },
    {
      &quot;role&quot;: &quot;user&quot;,
      &quot;content&quot;: &quot;What is deep learning?&quot;
    }
  ],
  &quot;stream&quot;: true,
  &quot;max_tokens&quot;: 20
}&#x27;</span> \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span>`,wrap:!1}}),d=new E({props:{title:"Streaming",local:"streaming",headingTag:"h2"}}),C=new as({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQSUyMyUyMGluaXQlMjB0aGUlMjBjbGllbnQlMjBidXQlMjBwb2ludCUyMGl0JTIwdG8lMjBUR0klMEFjbGllbnQlMjAlM0QlMjBPcGVuQUkoJTBBJTIwJTIwJTIwJTIwYmFzZV91cmwlM0QlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBMzAwMCUyRnYxJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMi0lMjIlMEEpJTBBJTBBY2hhdF9jb21wbGV0aW9uJTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiU3RCUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMHN0cmVhbSUzRFRydWUlMEEpJTBBJTBBJTIzJTIwaXRlcmF0ZSUyMGFuZCUyMHByaW50JTIwc3RyZWFtJTBBZm9yJTIwbWVzc2FnZSUyMGluJTIwY2hhdF9jb21wbGV0aW9uJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQobWVzc2FnZSk=",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># init the client but point it to TGI</span>
client = OpenAI(
    base_url=<span class="hljs-string">&quot;http://localhost:3000/v1&quot;</span>,
    api_key=<span class="hljs-string">&quot;-&quot;</span>
)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>}
    ],
    stream=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># iterate and print stream</span>
<span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> chat_completion:
    <span class="hljs-built_in">print</span>(message)`,wrap:!1}}),b=new E({props:{title:"Synchronous",local:"synchronous",headingTag:"h2"}}),B=new as({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQSUyMyUyMGluaXQlMjB0aGUlMjBjbGllbnQlMjBidXQlMjBwb2ludCUyMGl0JTIwdG8lMjBUR0klMEFjbGllbnQlMjAlM0QlMjBPcGVuQUkoJTBBJTIwJTIwJTIwJTIwYmFzZV91cmwlM0QlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBMzAwMCUyRnYxJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMi0lMjIlMEEpJTBBJTBBY2hhdF9jb21wbGV0aW9uJTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiU3RCUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMHN0cmVhbSUzREZhbHNlJTBBKSUwQSUwQXByaW50KGNoYXRfY29tcGxldGlvbik=",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># init the client but point it to TGI</span>
client = OpenAI(
    base_url=<span class="hljs-string">&quot;http://localhost:3000/v1&quot;</span>,
    api_key=<span class="hljs-string">&quot;-&quot;</span>
)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>}
    ],
    stream=<span class="hljs-literal">False</span>
)

<span class="hljs-built_in">print</span>(chat_completion)`,wrap:!1}}),f=new E({props:{title:"Cloud Providers",local:"cloud-providers",headingTag:"h2"}}),Z=new E({props:{title:"Amazon SageMaker",local:"amazon-sagemaker",headingTag:"h2"}}),A=new as({props:{code:"aW1wb3J0JTIwanNvbiUwQWltcG9ydCUyMHNhZ2VtYWtlciUwQWltcG9ydCUyMGJvdG8zJTBBZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlTW9kZWwlMkMlMjBnZXRfaHVnZ2luZ2ZhY2VfbGxtX2ltYWdlX3VyaSUwQSUwQXRyeSUzQSUwQSUyMHJvbGUlMjAlM0QlMjBzYWdlbWFrZXIuZ2V0X2V4ZWN1dGlvbl9yb2xlKCklMEFleGNlcHQlMjBWYWx1ZUVycm9yJTNBJTBBJTIwaWFtJTIwJTNEJTIwYm90bzMuY2xpZW50KCdpYW0nKSUwQSUyMHJvbGUlMjAlM0QlMjBpYW0uZ2V0X3JvbGUoUm9sZU5hbWUlM0Qnc2FnZW1ha2VyX2V4ZWN1dGlvbl9yb2xlJyklNUInUm9sZSclNUQlNUInQXJuJyU1RCUwQSUwQSUyMyUyMEh1YiUyME1vZGVsJTIwY29uZmlndXJhdGlvbi4lMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTBBaHViJTIwJTNEJTIwJTdCJTBBJTIwJ0hGX01PREVMX0lEJyUzQSdIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGEnJTJDJTBBJTIwJ1NNX05VTV9HUFVTJyUzQSUyMGpzb24uZHVtcHMoMSklMkMlMEElMjAnTUVTU0FHRVNfQVBJX0VOQUJMRUQnJTNBJTIwVHJ1ZSUwQSU3RCUwQSUwQSUyMyUyMGNyZWF0ZSUyMEh1Z2dpbmclMjBGYWNlJTIwTW9kZWwlMjBDbGFzcyUwQWh1Z2dpbmdmYWNlX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VNb2RlbCglMEElMjBpbWFnZV91cmklM0RnZXRfaHVnZ2luZ2ZhY2VfbGxtX2ltYWdlX3VyaSglMjJodWdnaW5nZmFjZSUyMiUyQ3ZlcnNpb24lM0QlMjIxLjQuMCUyMiklMkMlMEElMjBlbnYlM0RodWIlMkMlMEElMjByb2xlJTNEcm9sZSUyQyUyMCUwQSklMEElMEElMjMlMjBkZXBsb3klMjBtb2RlbCUyMHRvJTIwU2FnZU1ha2VyJTIwSW5mZXJlbmNlJTBBcHJlZGljdG9yJTIwJTNEJTIwaHVnZ2luZ2ZhY2VfbW9kZWwuZGVwbG95KCUwQSUyMGluaXRpYWxfaW5zdGFuY2VfY291bnQlM0QxJTJDJTBBJTIwaW5zdGFuY2VfdHlwZSUzRCUyMm1sLmc1LjJ4bGFyZ2UlMjIlMkMlMEElMjBjb250YWluZXJfc3RhcnR1cF9oZWFsdGhfY2hlY2tfdGltZW91dCUzRDMwMCUyQyUwQSUyMCUyMCklMEElMjAlMjAlMEElMjMlMjBzZW5kJTIwcmVxdWVzdCUwQXByZWRpY3Rvci5wcmVkaWN0KCU3QiUwQSUyMm1lc3NhZ2VzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjBkZWVwJTIwbGVhcm5pbmclM0YlMjIlN0QlMEElMjAlMjAlMjAlMjAlNUQlMEElN0Qp",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3
<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel, get_huggingface_llm_image_uri

<span class="hljs-keyword">try</span>:
 role = sagemaker.get_execution_role()
<span class="hljs-keyword">except</span> ValueError:
 iam = boto3.client(<span class="hljs-string">&#x27;iam&#x27;</span>)
 role = iam.get_role(RoleName=<span class="hljs-string">&#x27;sagemaker_execution_role&#x27;</span>)[<span class="hljs-string">&#x27;Role&#x27;</span>][<span class="hljs-string">&#x27;Arn&#x27;</span>]

<span class="hljs-comment"># Hub Model configuration. https://huggingface.co/models</span>
hub = {
 <span class="hljs-string">&#x27;HF_MODEL_ID&#x27;</span>:<span class="hljs-string">&#x27;HuggingFaceH4/zephyr-7b-beta&#x27;</span>,
 <span class="hljs-string">&#x27;SM_NUM_GPUS&#x27;</span>: json.dumps(<span class="hljs-number">1</span>),
 <span class="hljs-string">&#x27;MESSAGES_API_ENABLED&#x27;</span>: <span class="hljs-literal">True</span>
}

<span class="hljs-comment"># create Hugging Face Model Class</span>
huggingface_model = HuggingFaceModel(
 image_uri=get_huggingface_llm_image_uri(<span class="hljs-string">&quot;huggingface&quot;</span>,version=<span class="hljs-string">&quot;1.4.0&quot;</span>),
 env=hub,
 role=role, 
)

<span class="hljs-comment"># deploy model to SageMaker Inference</span>
predictor = huggingface_model.deploy(
 initial_instance_count=<span class="hljs-number">1</span>,
 instance_type=<span class="hljs-string">&quot;ml.g5.2xlarge&quot;</span>,
 container_startup_health_check_timeout=<span class="hljs-number">300</span>,
  )
  
<span class="hljs-comment"># send request</span>
predictor.predict({
<span class="hljs-string">&quot;messages&quot;</span>: [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>}
    ]
})`,wrap:!1}}),{c(){r=M("meta"),V=a(),W=M("p"),x=a(),y(T.$$.fragment),Y=a(),m=M("p"),m.textContent=Ms,$=a(),w=M("blockquote"),w.innerHTML=os,k=a(),y(j.$$.fragment),v=a(),h=M("p"),h.innerHTML=ys,R=a(),y(I.$$.fragment),_=a(),y(d.$$.fragment),z=a(),g=M("p"),g.textContent=is,X=a(),y(C.$$.fragment),F=a(),y(b.$$.fragment),H=a(),G=M("p"),G.textContent=ps,P=a(),y(B.$$.fragment),L=a(),y(f.$$.fragment),D=a(),Q=M("p"),Q.textContent=Us,O=a(),y(Z.$$.fragment),K=a(),S=M("p"),S.innerHTML=Js,ss=a(),q=M("p"),q.innerHTML=us,ls=a(),y(A.$$.fragment),ts=a(),N=M("p"),this.h()},l(s){const l=Is("svelte-u9bgzb",document.head);r=o(l,"META",{name:!0,content:!0}),l.forEach(t),V=n(s),W=o(s,"P",{}),rs(W).forEach(t),x=n(s),i(T.$$.fragment,s),Y=n(s),m=o(s,"P",{"data-svelte-h":!0}),c(m)!=="svelte-1npf6uj"&&(m.textContent=Ms),$=n(s),w=o(s,"BLOCKQUOTE",{"data-svelte-h":!0}),c(w)!=="svelte-d3rfkz"&&(w.innerHTML=os),k=n(s),i(j.$$.fragment,s),v=n(s),h=o(s,"P",{"data-svelte-h":!0}),c(h)!=="svelte-1w70cim"&&(h.innerHTML=ys),R=n(s),i(I.$$.fragment,s),_=n(s),i(d.$$.fragment,s),z=n(s),g=o(s,"P",{"data-svelte-h":!0}),c(g)!=="svelte-1g3ypvi"&&(g.textContent=is),X=n(s),i(C.$$.fragment,s),F=n(s),i(b.$$.fragment,s),H=n(s),G=o(s,"P",{"data-svelte-h":!0}),c(G)!=="svelte-1xyk36t"&&(G.textContent=ps),P=n(s),i(B.$$.fragment,s),L=n(s),i(f.$$.fragment,s),D=n(s),Q=o(s,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-10f0asl"&&(Q.textContent=Us),O=n(s),i(Z.$$.fragment,s),K=n(s),S=o(s,"P",{"data-svelte-h":!0}),c(S)!=="svelte-zm7msf"&&(S.innerHTML=Js),ss=n(s),q=o(s,"P",{"data-svelte-h":!0}),c(q)!=="svelte-7x0wid"&&(q.innerHTML=us),ls=n(s),i(A.$$.fragment,s),ts=n(s),N=o(s,"P",{}),rs(N).forEach(t),this.h()},h(){cs(r,"name","hf:doc:metadata"),cs(r,"content",Cs)},m(s,l){ds(document.head,r),e(s,V,l),e(s,W,l),e(s,x,l),p(T,s,l),e(s,Y,l),e(s,m,l),e(s,$,l),e(s,w,l),e(s,k,l),p(j,s,l),e(s,v,l),e(s,h,l),e(s,R,l),p(I,s,l),e(s,_,l),p(d,s,l),e(s,z,l),e(s,g,l),e(s,X,l),p(C,s,l),e(s,F,l),p(b,s,l),e(s,H,l),e(s,G,l),e(s,P,l),p(B,s,l),e(s,L,l),p(f,s,l),e(s,D,l),e(s,Q,l),e(s,O,l),p(Z,s,l),e(s,K,l),e(s,S,l),e(s,ss,l),e(s,q,l),e(s,ls,l),p(A,s,l),e(s,ts,l),e(s,N,l),es=!0},p:ms,i(s){es||(U(T.$$.fragment,s),U(j.$$.fragment,s),U(I.$$.fragment,s),U(d.$$.fragment,s),U(C.$$.fragment,s),U(b.$$.fragment,s),U(B.$$.fragment,s),U(f.$$.fragment,s),U(Z.$$.fragment,s),U(A.$$.fragment,s),es=!0)},o(s){J(T.$$.fragment,s),J(j.$$.fragment,s),J(I.$$.fragment,s),J(d.$$.fragment,s),J(C.$$.fragment,s),J(b.$$.fragment,s),J(B.$$.fragment,s),J(f.$$.fragment,s),J(Z.$$.fragment,s),J(A.$$.fragment,s),es=!1},d(s){s&&(t(V),t(W),t(x),t(Y),t(m),t($),t(w),t(k),t(v),t(h),t(R),t(_),t(z),t(g),t(X),t(F),t(H),t(G),t(P),t(L),t(D),t(Q),t(O),t(K),t(S),t(ss),t(q),t(ls),t(ts),t(N)),t(r),u(T,s),u(j,s),u(I,s),u(d,s),u(C,s),u(b,s),u(B,s),u(f,s),u(Z,s),u(A,s)}}}const Cs='{"title":"Messages API","local":"messages-api","sections":[{"title":"Making a Request","local":"making-a-request","sections":[],"depth":2},{"title":"Streaming","local":"streaming","sections":[],"depth":2},{"title":"Synchronous","local":"synchronous","sections":[],"depth":2},{"title":"Cloud Providers","local":"cloud-providers","sections":[],"depth":2},{"title":"Amazon SageMaker","local":"amazon-sagemaker","sections":[],"depth":2}],"depth":1}';function bs(ns){return ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zs extends js{constructor(r){super(),hs(this,r,bs,gs,Ts,{})}}export{Zs as component};
