import{s as Ee,o as ze,n as He}from"../chunks/scheduler.924d507e.js";import{S as Ye,i as qe,g as h,s,r as i,A as Ae,h as u,f as a,c as n,j as Ce,u as r,x as c,k as Fe,y as Ne,a as l,v as p,d as m,t as d,w as f}from"../chunks/index.0ece89e8.js";import{T as xe}from"../chunks/Tip.a5ce8f1d.js";import{C as M}from"../chunks/CodeBlock.d01ac312.js";import{H as x}from"../chunks/Heading.c9bff43c.js";function Se(P){let o,T='Learn more about how PEFT works with quantization in the <a href="quantization">Quantization</a> guide.';return{c(){o=h("p"),o.innerHTML=T},l(w){o=u(w,"P",{"data-svelte-h":!0}),c(o)!=="svelte-1nbpolx"&&(o.innerHTML=T)},m(w,N){l(w,o,N)},p:He,d(w){w&&a(o)}}}function Pe(P){let o,T,w,N,y,K,b,ke='LoRA is low-rank decomposition method to reduce the number of trainable parameters which speeds up finetuning large models and uses less memory. In PEFT, using LoRA is as easy as setting up a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and wrapping it with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> to create a trainable <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',D,J,je="This guide explores in more detail other options and features for using LoRA.",O,Z,ee,_,ve='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> in <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. By default, PEFT initializes LoRA weights with Kaiming-uniform for weight A and zeros for weight B resulting in an identity transform (same as the reference <a href="https://github.com/microsoft/LoRA" rel="nofollow">implementation</a>).',te,$,Le='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this initializes weight A with a Gaussian distribution and zeros for weight B (this is how <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">Diffusers</a> initializes LoRA weights).',ae,k,le,j,We="There is also an option to set <code>init_lora_weights=False</code> which is useful for debugging and testing. This should be the only time you use this option. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform.",se,v,ne,L,oe,W,Be='When quantizing the base model for QLoRA training, consider using the <a href="https://arxiv.org/abs/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve performance when training quantized models. The idea is that the LoRA weights are initialized such that the quantization error is minimized. If you’re using LoftQ, <em>do not</em> quantize the base model. You should set up a <code>LoftQConfig</code> instead:',ie,B,re,g,pe,I,me,R,Ie='Another way to initialize <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is with the <a href="https://huggingface.co/papers/2312.03732" rel="nofollow">rank-stabilized LoRA (rsLoRA)</a> method. The LoRA architecture scales each adapter during every forward pass by a fixed scalar which is set at initialization and depends on the rank <code>r</code>. The scalar is given by <code>lora_alpha/r</code> in the original implementation, but rsLoRA uses <code>lora_alpha/math.sqrt(r)</code> which stabilizes the adapters and increases the performance potential from using a higher <code>r</code>.',de,U,fe,V,he,G,Re='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA adapter. To eliminate latency, use the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model. This allows you to use the newly merged model as a standalone model. The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function doesn’t keep the adapter weights in memory.',ue,X,ce,Q,Ue='If you need to keep a copy of the weights so you can unmerge the adapter later or delete and load different ones, you should use the <code>~tuners.tuner_utils.BaseTuner.merge_adapter</code> function instead. Now you have the option to use <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to return the base model.',we,C,Me,F,Ve='The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> function is useful for merging multiple LoRAs into a new adapter based on a user provided weighting scheme in the <code>weights</code> parameter.',ge,E,Te,z,ye,H,Ge='Adapters can be loaded onto a pretrained model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>, which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.set_adapter">set_adapter()</a> function.',be,Y,Je,q,Xe='To return the base model, you could use <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.unload">unload()</a> to unload all of the LoRA modules or <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete the adapter entirely.',Ze,A,_e,S,$e;return y=new x({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),Z=new x({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),k=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmdhdXNzaWFuJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>, ...)`,wrap:!1}}),v=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzREZhbHNlJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-literal">False</span>, ...)`,wrap:!1}}),L=new x({props:{title:"LoftQ",local:"loftq",headingTag:"h3"}}),B=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb2Z0UUNvbmZpZyUyQyUyMExvcmFDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoLi4uKSUyMCUyMCUyMyUyMGRvbid0JTIwcXVhbnRpemUlMjBoZXJlJTBBbG9mdHFfY29uZmlnJTIwJTNEJTIwTG9mdFFDb25maWcobG9mdHFfYml0cyUzRDQlMkMlMjAuLi4pJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwc2V0JTIwNGJpdCUyMHF1YW50aXphdGlvbiUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4lMkMlMjBpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmxvZnRxJTIyJTJDJTIwbG9mdHFfY29uZmlnJTNEbG9mdHFfY29uZmlnKSUwQXBlZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChiYXNlX21vZGVsJTJDJTIwbG9yYV9jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoftQConfig, LoraConfig, get_peft_model

base_model = AutoModelForCausalLM.from_pretrained(...)  <span class="hljs-comment"># don&#x27;t quantize here</span>
loftq_config = LoftQConfig(loftq_bits=<span class="hljs-number">4</span>, ...)           <span class="hljs-comment"># set 4bit quantization</span>
lora_config = LoraConfig(..., init_lora_weights=<span class="hljs-string">&quot;loftq&quot;</span>, loftq_config=loftq_config)
peft_model = get_peft_model(base_model, lora_config)`,wrap:!1}}),g=new xe({props:{$$slots:{default:[Se]},$$scope:{ctx:P}}}),I=new x({props:{title:"Rank-stabilized LoRA",local:"rank-stabilized-lora",headingTag:"h3"}}),U=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfcnNsb3JhJTNEVHJ1ZSUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_rslora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),V=new x({props:{title:"Merge adapters",local:"merge-adapters",headingTag:"h2"}}),X=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FuZF91bmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),C=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FkYXB0ZXIoKSUwQSUwQSUyMyUyMHVubWVyZ2UlMjB0aGUlMjBMb1JBJTIwbGF5ZXJzJTIwZnJvbSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsLnVubWVyZ2VfYWRhcHRlcigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_adapter()

<span class="hljs-comment"># unmerge the LoRA layers from the base model</span>
model.unmerge_adapter()`,wrap:!1}}),E=new M({props:{code:"bW9kZWwuYWRkX3dlaWdodGVkX2FkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwYWRhcHRlcnMlM0QlNUIlMjJhZGFwdGVyXzElMjIlMkMlMjAlMjJhZGFwdGVyXzIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTNEJTVCMC43JTJDJTIwMC4zJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEJTIybmV3LXdlaWdodGVkLWFkYXB0ZXIlMjIlMEEp",highlighted:`model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;adapter_1&quot;</span>, <span class="hljs-string">&quot;adapter_2&quot;</span>],
    weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>],
    adapter_name=<span class="hljs-string">&quot;new-weighted-adapter&quot;</span>
)`,wrap:!1}}),z=new x({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),Y=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQSUwQSUyMyUyMGxvYWQlMjBkaWZmZXJlbnQlMjBhZGFwdGVyJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEElMEElMjMlMjBzZXQlMjBhZGFwdGVyJTIwYXMlMjBhY3RpdmUlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJkcG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)

<span class="hljs-comment"># load different adapter</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)

<span class="hljs-comment"># set adapter as active</span>
model.set_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),A=new M({props:{code:"JTIzJTIwdW5sb2FkJTIwYWRhcHRlciUwQW1vZGVsLnVubG9hZCgpJTBBJTBBJTIzJTIwZGVsZXRlJTIwYWRhcHRlciUwQW1vZGVsLmRlbGV0ZV9hZGFwdGVyKCUyMmRwbyUyMik=",highlighted:`<span class="hljs-comment"># unload adapter</span>
model.unload()

<span class="hljs-comment"># delete adapter</span>
model.delete_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),{c(){o=h("meta"),T=s(),w=h("p"),N=s(),i(y.$$.fragment),K=s(),b=h("p"),b.innerHTML=ke,D=s(),J=h("p"),J.textContent=je,O=s(),i(Z.$$.fragment),ee=s(),_=h("p"),_.innerHTML=ve,te=s(),$=h("p"),$.innerHTML=Le,ae=s(),i(k.$$.fragment),le=s(),j=h("p"),j.innerHTML=We,se=s(),i(v.$$.fragment),ne=s(),i(L.$$.fragment),oe=s(),W=h("p"),W.innerHTML=Be,ie=s(),i(B.$$.fragment),re=s(),i(g.$$.fragment),pe=s(),i(I.$$.fragment),me=s(),R=h("p"),R.innerHTML=Ie,de=s(),i(U.$$.fragment),fe=s(),i(V.$$.fragment),he=s(),G=h("p"),G.innerHTML=Re,ue=s(),i(X.$$.fragment),ce=s(),Q=h("p"),Q.innerHTML=Ue,we=s(),i(C.$$.fragment),Me=s(),F=h("p"),F.innerHTML=Ve,ge=s(),i(E.$$.fragment),Te=s(),i(z.$$.fragment),ye=s(),H=h("p"),H.innerHTML=Ge,be=s(),i(Y.$$.fragment),Je=s(),q=h("p"),q.innerHTML=Xe,Ze=s(),i(A.$$.fragment),_e=s(),S=h("p"),this.h()},l(e){const t=Ae("svelte-u9bgzb",document.head);o=u(t,"META",{name:!0,content:!0}),t.forEach(a),T=n(e),w=u(e,"P",{}),Ce(w).forEach(a),N=n(e),r(y.$$.fragment,e),K=n(e),b=u(e,"P",{"data-svelte-h":!0}),c(b)!=="svelte-38uxl6"&&(b.innerHTML=ke),D=n(e),J=u(e,"P",{"data-svelte-h":!0}),c(J)!=="svelte-ovsn32"&&(J.textContent=je),O=n(e),r(Z.$$.fragment,e),ee=n(e),_=u(e,"P",{"data-svelte-h":!0}),c(_)!=="svelte-j883mf"&&(_.innerHTML=ve),te=n(e),$=u(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-1fujb7a"&&($.innerHTML=Le),ae=n(e),r(k.$$.fragment,e),le=n(e),j=u(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-mwvui1"&&(j.innerHTML=We),se=n(e),r(v.$$.fragment,e),ne=n(e),r(L.$$.fragment,e),oe=n(e),W=u(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-1khsfzg"&&(W.innerHTML=Be),ie=n(e),r(B.$$.fragment,e),re=n(e),r(g.$$.fragment,e),pe=n(e),r(I.$$.fragment,e),me=n(e),R=u(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-omuw13"&&(R.innerHTML=Ie),de=n(e),r(U.$$.fragment,e),fe=n(e),r(V.$$.fragment,e),he=n(e),G=u(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-1c3h9aa"&&(G.innerHTML=Re),ue=n(e),r(X.$$.fragment,e),ce=n(e),Q=u(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-1rv3dam"&&(Q.innerHTML=Ue),we=n(e),r(C.$$.fragment,e),Me=n(e),F=u(e,"P",{"data-svelte-h":!0}),c(F)!=="svelte-so149c"&&(F.innerHTML=Ve),ge=n(e),r(E.$$.fragment,e),Te=n(e),r(z.$$.fragment,e),ye=n(e),H=u(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-ke62q2"&&(H.innerHTML=Ge),be=n(e),r(Y.$$.fragment,e),Je=n(e),q=u(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-cvmoj6"&&(q.innerHTML=Xe),Ze=n(e),r(A.$$.fragment,e),_e=n(e),S=u(e,"P",{}),Ce(S).forEach(a),this.h()},h(){Fe(o,"name","hf:doc:metadata"),Fe(o,"content",Ke)},m(e,t){Ne(document.head,o),l(e,T,t),l(e,w,t),l(e,N,t),p(y,e,t),l(e,K,t),l(e,b,t),l(e,D,t),l(e,J,t),l(e,O,t),p(Z,e,t),l(e,ee,t),l(e,_,t),l(e,te,t),l(e,$,t),l(e,ae,t),p(k,e,t),l(e,le,t),l(e,j,t),l(e,se,t),p(v,e,t),l(e,ne,t),p(L,e,t),l(e,oe,t),l(e,W,t),l(e,ie,t),p(B,e,t),l(e,re,t),p(g,e,t),l(e,pe,t),p(I,e,t),l(e,me,t),l(e,R,t),l(e,de,t),p(U,e,t),l(e,fe,t),p(V,e,t),l(e,he,t),l(e,G,t),l(e,ue,t),p(X,e,t),l(e,ce,t),l(e,Q,t),l(e,we,t),p(C,e,t),l(e,Me,t),l(e,F,t),l(e,ge,t),p(E,e,t),l(e,Te,t),p(z,e,t),l(e,ye,t),l(e,H,t),l(e,be,t),p(Y,e,t),l(e,Je,t),l(e,q,t),l(e,Ze,t),p(A,e,t),l(e,_e,t),l(e,S,t),$e=!0},p(e,[t]){const Qe={};t&2&&(Qe.$$scope={dirty:t,ctx:e}),g.$set(Qe)},i(e){$e||(m(y.$$.fragment,e),m(Z.$$.fragment,e),m(k.$$.fragment,e),m(v.$$.fragment,e),m(L.$$.fragment,e),m(B.$$.fragment,e),m(g.$$.fragment,e),m(I.$$.fragment,e),m(U.$$.fragment,e),m(V.$$.fragment,e),m(X.$$.fragment,e),m(C.$$.fragment,e),m(E.$$.fragment,e),m(z.$$.fragment,e),m(Y.$$.fragment,e),m(A.$$.fragment,e),$e=!0)},o(e){d(y.$$.fragment,e),d(Z.$$.fragment,e),d(k.$$.fragment,e),d(v.$$.fragment,e),d(L.$$.fragment,e),d(B.$$.fragment,e),d(g.$$.fragment,e),d(I.$$.fragment,e),d(U.$$.fragment,e),d(V.$$.fragment,e),d(X.$$.fragment,e),d(C.$$.fragment,e),d(E.$$.fragment,e),d(z.$$.fragment,e),d(Y.$$.fragment,e),d(A.$$.fragment,e),$e=!1},d(e){e&&(a(T),a(w),a(N),a(K),a(b),a(D),a(J),a(O),a(ee),a(_),a(te),a($),a(ae),a(le),a(j),a(se),a(ne),a(oe),a(W),a(ie),a(re),a(pe),a(me),a(R),a(de),a(fe),a(he),a(G),a(ue),a(ce),a(Q),a(we),a(Me),a(F),a(ge),a(Te),a(ye),a(H),a(be),a(Je),a(q),a(Ze),a(_e),a(S)),a(o),f(y,e),f(Z,e),f(k,e),f(v,e),f(L,e),f(B,e),f(g,e),f(I,e),f(U,e),f(V,e),f(X,e),f(C,e),f(E,e),f(z,e),f(Y,e),f(A,e)}}}const Ke='{"title":"LoRA","local":"lora","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"LoftQ","local":"loftq","sections":[],"depth":3},{"title":"Rank-stabilized LoRA","local":"rank-stabilized-lora","sections":[],"depth":3}],"depth":2},{"title":"Merge adapters","local":"merge-adapters","sections":[],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[],"depth":2}],"depth":1}';function De(P){return ze(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class st extends Ye{constructor(o){super(),qe(this,o,De,Pe,Ee,{})}}export{st as component};
