import{s as Ae,o as Le,n as Ee}from"../chunks/scheduler.9bc65507.js";import{S as Pe,i as Qe,g as r,s as o,r as f,A as Ye,h as i,f as l,c as a,j as Ne,u as c,x as p,k as Fe,y as qe,a as n,v as d,d as u,t as h,w as b}from"../chunks/index.707bf1b6.js";import{T as ze}from"../chunks/Tip.c2ecdbf4.js";import{C as q}from"../chunks/CodeBlock.54a9f38d.js";import{H as Q}from"../chunks/Heading.342b1fa6.js";function Se(P){let s,y='Note: A multi GPU setup can use the majority of the strategies described in the <a href="./perf_infer_gpu_one">single GPU section</a>. You must be aware of simple techniques, though, that can be used for a better usage.';return{c(){s=r("p"),s.innerHTML=y},l(m){s=i(m,"P",{"data-svelte-h":!0}),p(s)!=="svelte-1ub93af"&&(s.innerHTML=y)},m(m,M){n(m,s,M)},p:Ee,d(m){m&&l(s)}}}function De(P){let s,y="Flash Attention can only be used for models using fp16 or bf16 dtype. Make sure to cast your model to the appropriate dtype before using BetterTransformer.";return{c(){s=r("p"),s.textContent=y},l(m){s=i(m,"P",{"data-svelte-h":!0}),p(s)!=="svelte-1291w1c"&&(s.textContent=y)},m(m,M){n(m,s,M)},p:Ee,d(m){m&&l(s)}}}function Ke(P){let s,y,m,M,w,S,$,ge="This document contains information on how to efficiently infer on a multiple GPUs.",D,T,K,v,O,g,Ze='Flash Attention 2 integration also works in a multi-GPU setup, check out the appropriate section in the <a href="./perf_infer_gpu_one#Flash-Attention-2">single GPU section</a>',ee,Z,te,B,Be='<a href="https://huggingface.co/docs/optimum/bettertransformer/overview" rel="nofollow">BetterTransformer</a> converts 🤗 Transformers models to use the PyTorch-native fastpath execution, which calls optimized kernels like Flash Attention under the hood.',le,U,Ue="BetterTransformer is also supported for faster inference on single and multi-GPU for text, image, and audio models.",ne,J,oe,_,ae,k,_e='For text models, especially decoder-based models (GPT, T5, Llama, etc.), the BetterTransformer API converts all attention operations to use the <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention" rel="nofollow"><code>torch.nn.functional.scaled_dot_product_attention</code> operator</a> (SDPA) that is only available in PyTorch 2.0 and onwards.',se,C,ke="To convert a model to BetterTransformer:",re,j,ie,G,Ce='SDPA can also call <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">Flash Attention</a> kernels under the hood. To enable Flash Attention or to check that it is available in a given setting (hardware, problem size), use <a href="https://pytorch.org/docs/master/backends.html#torch.backends.cuda.sdp_kernel" rel="nofollow"><code>torch.backends.cuda.sdp_kernel</code></a> as a context manager:',me,W,pe,x,je="If you see a bug with a traceback saying",fe,R,ce,V,Ge="try using the PyTorch nightly version, which may have a broader coverage for Flash Attention:",de,H,ue,I,We='Have a look at this <a href="https://pytorch.org/blog/out-of-the-box-acceleration/" rel="nofollow">blog post</a> to learn more about what is possible with the BetterTransformer + SDPA API.',he,X,be,N,xe='For encoder models during inference, BetterTransformer dispatches the forward call of encoder layers to an equivalent of <a href="https://pytorch.org/docs/stable/generated/torch.nn.TransformerEncoderLayer.html" rel="nofollow"><code>torch.nn.TransformerEncoderLayer</code></a> that will execute the fastpath implementation of the encoder layers.',ye,F,Re="Because <code>torch.nn.TransformerEncoderLayer</code> fastpath does not support training, it is dispatched to <code>torch.nn.functional.scaled_dot_product_attention</code> instead, which does not leverage nested tensors but can use Flash Attention or Memory-Efficient Attention fused kernels.",Me,z,Ve='More details about BetterTransformer performance can be found in this <a href="https://medium.com/pytorch/bettertransformer-out-of-the-box-performance-for-huggingface-transformers-3fbe27d50ab2" rel="nofollow">blog post</a>, and you can learn more about BetterTransformer for encoder models in this <a href="https://pytorch.org/blog/a-better-transformer-for-fast-transformer-encoder-inference/" rel="nofollow">blog</a>.',Te,E,Je,A,He="You can combine the different methods described above to get the best performance for your model. For example, you can use BetterTransformer with FP4 mixed-precision inference + flash attention:",we,L,$e,Y,ve;return w=new Q({props:{title:"Efficient Inference on a Multiple GPUs",local:"efficient-inference-on-a-multiple-gpus",headingTag:"h1"}}),T=new ze({props:{$$slots:{default:[Se]},$$scope:{ctx:P}}}),v=new Q({props:{title:"Flash Attention 2",local:"flash-attention-2",headingTag:"h2"}}),Z=new Q({props:{title:"BetterTransformer",local:"bettertransformer",headingTag:"h2"}}),J=new ze({props:{$$slots:{default:[De]},$$scope:{ctx:P}}}),_=new Q({props:{title:"Decoder models",local:"decoder-models",headingTag:"h3"}}),j=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMjMlMjBjb252ZXJ0JTIwdGhlJTIwbW9kZWwlMjB0byUyMEJldHRlclRyYW5zZm9ybWVyJTBBbW9kZWwudG9fYmV0dGVydHJhbnNmb3JtZXIoKSUwQSUwQSUyMyUyMFVzZSUyMGl0JTIwZm9yJTIwdHJhaW5pbmclMjBvciUyMGluZmVyZW5jZQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
<span class="hljs-comment"># convert the model to BetterTransformer</span>
model.to_bettertransformer()

<span class="hljs-comment"># Use it for training or inference</span>`,wrap:!1}}),W=new q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyKS50byglMjJjdWRhJTIyKSUwQSUyMyUyMGNvbnZlcnQlMjB0aGUlMjBtb2RlbCUyMHRvJTIwQmV0dGVyVHJhbnNmb3JtZXIlMEFtb2RlbC50b19iZXR0ZXJ0cmFuc2Zvcm1lcigpJTBBJTBBaW5wdXRfdGV4dCUyMCUzRCUyMCUyMkhlbGxvJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjBhbmQlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTJCJTIwd2l0aCUyMHRvcmNoLmJhY2tlbmRzLmN1ZGEuc2RwX2tlcm5lbChlbmFibGVfZmxhc2glM0RUcnVlJTJDJTIwZW5hYmxlX21hdGglM0RGYWxzZSUyQyUyMGVuYWJsZV9tZW1fZWZmaWNpZW50JTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0cyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`import torch
from transformers import AutoModelForCausalLM, AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(&quot;facebook/opt-350m&quot;)
model = AutoModelForCausalLM.from_pretrained(&quot;facebook/opt-350m&quot;).to(&quot;cuda&quot;)
# convert the model to BetterTransformer
model.to_bettertransformer()

input_text = &quot;Hello my dog is cute and&quot;
inputs = tokenizer(input_text, return_tensors=&quot;pt&quot;).to(&quot;cuda&quot;)

<span class="hljs-addition">+ with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</span>
    outputs = model.generate(**inputs)

print(tokenizer.decode(outputs[0], skip_special_tokens=True))`,wrap:!1}}),R=new q({props:{code:"UnVudGltZUVycm9yJTNBJTIwTm8lMjBhdmFpbGFibGUlMjBrZXJuZWwuJTIwJTIwQWJvcnRpbmclMjBleGVjdXRpb24u",highlighted:"RuntimeError: No available kernel.  Aborting execution.",wrap:!1}}),H=new q({props:{code:"cGlwMyUyMGluc3RhbGwlMjAtVSUyMC0tcHJlJTIwdG9yY2glMjB0b3JjaHZpc2lvbiUyMHRvcmNoYXVkaW8lMjAtLWluZGV4LXVybCUyMGh0dHBzJTNBJTJGJTJGZG93bmxvYWQucHl0b3JjaC5vcmclMkZ3aGwlMkZuaWdodGx5JTJGY3UxMTg=",highlighted:"pip3 install -U --pre torch torchvision torchaudio --index-url https://download.pytorch.org/whl/nightly/cu118",wrap:!1}}),X=new Q({props:{title:"Encoder models",local:"encoder-models",headingTag:"h3"}}),E=new Q({props:{title:"Advanced usage: mixing FP4 (or Int8) and BetterTransformer",local:"advanced-usage-mixing-fp4-or-int8-and-bettertransformer",headingTag:"h2"}}),L=new q({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWcpJTBBJTBBaW5wdXRfdGV4dCUyMCUzRCUyMCUyMkhlbGxvJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjBhbmQlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBd2l0aCUyMHRvcmNoLmJhY2tlbmRzLmN1ZGEuc2RwX2tlcm5lbChlbmFibGVfZmxhc2glM0RUcnVlJTJDJTIwZW5hYmxlX21hdGglM0RGYWxzZSUyQyUyMGVuYWJsZV9tZW1fZWZmaWNpZW50JTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0cyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_compute_dtype=torch.float16
)

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, quantization_config=quantization_config)

input_text = <span class="hljs-string">&quot;Hello my dog is cute and&quot;</span>
inputs = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">with</span> torch.backends.cuda.sdp_kernel(enable_flash=<span class="hljs-literal">True</span>, enable_math=<span class="hljs-literal">False</span>, enable_mem_efficient=<span class="hljs-literal">False</span>):
    outputs = model.generate(**inputs)

<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),{c(){s=r("meta"),y=o(),m=r("p"),M=o(),f(w.$$.fragment),S=o(),$=r("p"),$.textContent=ge,D=o(),f(T.$$.fragment),K=o(),f(v.$$.fragment),O=o(),g=r("p"),g.innerHTML=Ze,ee=o(),f(Z.$$.fragment),te=o(),B=r("p"),B.innerHTML=Be,le=o(),U=r("p"),U.textContent=Ue,ne=o(),f(J.$$.fragment),oe=o(),f(_.$$.fragment),ae=o(),k=r("p"),k.innerHTML=_e,se=o(),C=r("p"),C.textContent=ke,re=o(),f(j.$$.fragment),ie=o(),G=r("p"),G.innerHTML=Ce,me=o(),f(W.$$.fragment),pe=o(),x=r("p"),x.textContent=je,fe=o(),f(R.$$.fragment),ce=o(),V=r("p"),V.textContent=Ge,de=o(),f(H.$$.fragment),ue=o(),I=r("p"),I.innerHTML=We,he=o(),f(X.$$.fragment),be=o(),N=r("p"),N.innerHTML=xe,ye=o(),F=r("p"),F.innerHTML=Re,Me=o(),z=r("p"),z.innerHTML=Ve,Te=o(),f(E.$$.fragment),Je=o(),A=r("p"),A.textContent=He,we=o(),f(L.$$.fragment),$e=o(),Y=r("p"),this.h()},l(e){const t=Ye("svelte-u9bgzb",document.head);s=i(t,"META",{name:!0,content:!0}),t.forEach(l),y=a(e),m=i(e,"P",{}),Ne(m).forEach(l),M=a(e),c(w.$$.fragment,e),S=a(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1fpif6b"&&($.textContent=ge),D=a(e),c(T.$$.fragment,e),K=a(e),c(v.$$.fragment,e),O=a(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-r2jcxr"&&(g.innerHTML=Ze),ee=a(e),c(Z.$$.fragment,e),te=a(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1ytgap0"&&(B.innerHTML=Be),le=a(e),U=i(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-6mes7v"&&(U.textContent=Ue),ne=a(e),c(J.$$.fragment,e),oe=a(e),c(_.$$.fragment,e),ae=a(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1jgnsw9"&&(k.innerHTML=_e),se=a(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1fsfh6a"&&(C.textContent=ke),re=a(e),c(j.$$.fragment,e),ie=a(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-2zsmk5"&&(G.innerHTML=Ce),me=a(e),c(W.$$.fragment,e),pe=a(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-143u65w"&&(x.textContent=je),fe=a(e),c(R.$$.fragment,e),ce=a(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-10v9ayf"&&(V.textContent=Ge),de=a(e),c(H.$$.fragment,e),ue=a(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-133a6cx"&&(I.innerHTML=We),he=a(e),c(X.$$.fragment,e),be=a(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1sf3bai"&&(N.innerHTML=xe),ye=a(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1pqj2y1"&&(F.innerHTML=Re),Me=a(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-a1ky9q"&&(z.innerHTML=Ve),Te=a(e),c(E.$$.fragment,e),Je=a(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1mbq6eb"&&(A.textContent=He),we=a(e),c(L.$$.fragment,e),$e=a(e),Y=i(e,"P",{}),Ne(Y).forEach(l),this.h()},h(){Fe(s,"name","hf:doc:metadata"),Fe(s,"content",Oe)},m(e,t){qe(document.head,s),n(e,y,t),n(e,m,t),n(e,M,t),d(w,e,t),n(e,S,t),n(e,$,t),n(e,D,t),d(T,e,t),n(e,K,t),d(v,e,t),n(e,O,t),n(e,g,t),n(e,ee,t),d(Z,e,t),n(e,te,t),n(e,B,t),n(e,le,t),n(e,U,t),n(e,ne,t),d(J,e,t),n(e,oe,t),d(_,e,t),n(e,ae,t),n(e,k,t),n(e,se,t),n(e,C,t),n(e,re,t),d(j,e,t),n(e,ie,t),n(e,G,t),n(e,me,t),d(W,e,t),n(e,pe,t),n(e,x,t),n(e,fe,t),d(R,e,t),n(e,ce,t),n(e,V,t),n(e,de,t),d(H,e,t),n(e,ue,t),n(e,I,t),n(e,he,t),d(X,e,t),n(e,be,t),n(e,N,t),n(e,ye,t),n(e,F,t),n(e,Me,t),n(e,z,t),n(e,Te,t),d(E,e,t),n(e,Je,t),n(e,A,t),n(e,we,t),d(L,e,t),n(e,$e,t),n(e,Y,t),ve=!0},p(e,[t]){const Ie={};t&2&&(Ie.$$scope={dirty:t,ctx:e}),T.$set(Ie);const Xe={};t&2&&(Xe.$$scope={dirty:t,ctx:e}),J.$set(Xe)},i(e){ve||(u(w.$$.fragment,e),u(T.$$.fragment,e),u(v.$$.fragment,e),u(Z.$$.fragment,e),u(J.$$.fragment,e),u(_.$$.fragment,e),u(j.$$.fragment,e),u(W.$$.fragment,e),u(R.$$.fragment,e),u(H.$$.fragment,e),u(X.$$.fragment,e),u(E.$$.fragment,e),u(L.$$.fragment,e),ve=!0)},o(e){h(w.$$.fragment,e),h(T.$$.fragment,e),h(v.$$.fragment,e),h(Z.$$.fragment,e),h(J.$$.fragment,e),h(_.$$.fragment,e),h(j.$$.fragment,e),h(W.$$.fragment,e),h(R.$$.fragment,e),h(H.$$.fragment,e),h(X.$$.fragment,e),h(E.$$.fragment,e),h(L.$$.fragment,e),ve=!1},d(e){e&&(l(y),l(m),l(M),l(S),l($),l(D),l(K),l(O),l(g),l(ee),l(te),l(B),l(le),l(U),l(ne),l(oe),l(ae),l(k),l(se),l(C),l(re),l(ie),l(G),l(me),l(pe),l(x),l(fe),l(ce),l(V),l(de),l(ue),l(I),l(he),l(be),l(N),l(ye),l(F),l(Me),l(z),l(Te),l(Je),l(A),l(we),l($e),l(Y)),l(s),b(w,e),b(T,e),b(v,e),b(Z,e),b(J,e),b(_,e),b(j,e),b(W,e),b(R,e),b(H,e),b(X,e),b(E,e),b(L,e)}}}const Oe='{"title":"Efficient Inference on a Multiple GPUs","local":"efficient-inference-on-a-multiple-gpus","sections":[{"title":"Flash Attention 2","local":"flash-attention-2","sections":[],"depth":2},{"title":"BetterTransformer","local":"bettertransformer","sections":[{"title":"Decoder models","local":"decoder-models","sections":[],"depth":3},{"title":"Encoder models","local":"encoder-models","sections":[],"depth":3}],"depth":2},{"title":"Advanced usage: mixing FP4 (or Int8) and BetterTransformer","local":"advanced-usage-mixing-fp4-or-int8-and-bettertransformer","sections":[],"depth":2}],"depth":1}';function et(P){return Le(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class st extends Pe{constructor(s){super(),Qe(this,s,et,Ke,Ae,{})}}export{st as component};
