import{s as Ie,n as Be,o as Ce}from"../chunks/scheduler.9bc65507.js";import{S as _e,i as ke,g as p,s as a,r,A as Ze,h as i,f as l,c as n,j as Ue,u as c,x as o,k as be,y as ge,a as t,v as M,d,t as y,w as m}from"../chunks/index.707bf1b6.js";import{C as u}from"../chunks/CodeBlock.54a9f38d.js";import{H as Ss}from"../chunks/Heading.342b1fa6.js";function Ge(Ls){let w,ns,ts,ps,h,is,T,Ps=`In this guide, we will see how to create a custom pipeline and share it on the <a href="hf.co/models">Hub</a> or add it to the
🤗 Transformers library.`,os,J,Ks=`First and foremost, you need to decide the raw entries the pipeline will be able to take. It can be strings, raw bytes,
dictionaries or whatever seems to be the most likely desired input. Try to keep these inputs as pure Python as possible
as it makes compatibility easier (even through other languages via JSON). Those will be the <code>inputs</code> of the
pipeline (<code>preprocess</code>).`,rs,j,Ds=`Then define the <code>outputs</code>. Same policy as the <code>inputs</code>. The simpler, the better. Those will be the outputs of
<code>postprocess</code> method.`,cs,f,Os=`Start by inheriting the base class <code>Pipeline</code> with the 4 methods needed to implement <code>preprocess</code>,
<code>_forward</code>, <code>postprocess</code>, and <code>_sanitize_parameters</code>.`,Ms,U,ds,b,se=`The structure of this breakdown is to support relatively seamless support for CPU/GPU, while supporting doing
pre/postprocessing on the CPU on different threads`,ys,I,ee=`<code>preprocess</code> will take the originally defined inputs, and turn them into something feedable to the model. It might
contain more information and is usually a <code>Dict</code>.`,ms,B,le=`<code>_forward</code> is the implementation detail and is not meant to be called directly. <code>forward</code> is the preferred
called method as it contains safeguards to make sure everything is working on the expected device. If anything is
linked to a real model it belongs in the <code>_forward</code> method, anything else is in the preprocess/postprocess.`,us,C,te=`<code>postprocess</code> methods will take the output of <code>_forward</code> and turn it into the final output that was decided
earlier.`,ws,_,ae=`<code>_sanitize_parameters</code> exists to allow users to pass any parameters whenever they wish, be it at initialization
time <code>pipeline(...., maybe_arg=4)</code> or at call time <code>pipe = pipeline(...); output = pipe(...., maybe_arg=4)</code>.`,hs,k,ne=`The returns of <code>_sanitize_parameters</code> are the 3 dicts of kwargs that will be passed directly to <code>preprocess</code>,
<code>_forward</code>, and <code>postprocess</code>. Don’t fill anything if the caller didn’t call with any extra parameter. That
allows to keep the default arguments in the function definition which is always more “natural”.`,Ts,Z,pe="A classic example would be a <code>top_k</code> argument in the post processing in classification tasks.",Js,g,js,G,ie=`In order to achieve that, we’ll update our <code>postprocess</code> method with a default parameter to <code>5</code>. and edit
<code>_sanitize_parameters</code> to allow this new parameter.`,fs,H,Us,A,oe=`Try to keep the inputs/outputs very simple and ideally JSON-serializable as it makes the pipeline usage very easy
without requiring users to understand new kinds of objects. It’s also relatively common to support many different types
of arguments for ease of use (audio files, which can be filenames, URLs or pure bytes)`,bs,V,Is,X,re="To register your <code>new-task</code> to the list of supported tasks, you have to add it to the <code>PIPELINE_REGISTRY</code>:",Bs,W,Cs,R,ce="You can specify a default model if you want, in which case it should come with a specific revision (which can be the name of a branch or a commit hash, here we took <code>&quot;abcdef&quot;</code>) as well as the type:",_s,N,ks,q,Zs,v,Me=`To share your custom pipeline on the Hub, you just have to save the custom code of your <code>Pipeline</code> subclass in a
python file. For instance, let’s say we want to use a custom pipeline for sentence pair classification like this:`,gs,E,Gs,z,de=`The implementation is framework agnostic, and will work for PyTorch and TensorFlow models. If we have saved this in
a file named <code>pair_classification.py</code>, we can then import it and register it like this:`,Hs,$,As,x,ye=`Once this is done, we can use it with a pretrained model. For instance <code>sgugger/finetuned-bert-mrpc</code> has been
fine-tuned on the MRPC dataset, which classifies pairs of sentences as paraphrases or not.`,Vs,Y,Xs,F,me="Then we can share it on the Hub by using the <code>save_pretrained</code> method in a <code>Repository</code>:",Ws,Q,Rs,S,ue=`This will copy the file where you defined <code>PairClassificationPipeline</code> inside the folder <code>&quot;test-dynamic-pipeline&quot;</code>,
along with saving the model and tokenizer of the pipeline, before pushing everything into the repository
<code>{your_username}/test-dynamic-pipeline</code>. After that, anyone can use it as long as they provide the option
<code>trust_remote_code=True</code>:`,Ns,L,qs,P,vs,K,we=`If you want to contribute your pipeline to 🤗 Transformers, you will need to add a new module in the <code>pipelines</code> submodule
with the code of your pipeline, then add it to the list of tasks defined in <code>pipelines/__init__.py</code>.`,Es,D,he="Then you will need to add tests. Create a new file <code>tests/test_pipelines_MY_PIPELINE.py</code> with examples of the other tests.",zs,O,Te=`The <code>run_pipeline_test</code> function will be very generic and run on small random models on every possible
architecture as defined by <code>model_mapping</code> and <code>tf_model_mapping</code>.`,$s,ss,Je=`This is very important to test future compatibility, meaning if someone adds a new model for
<code>XXXForQuestionAnswering</code> then the pipeline test will attempt to run on it. Because the models are random it’s
impossible to check for actual values, that’s why there is a helper <code>ANY</code> that will simply attempt to match the
output of the pipeline TYPE.`,xs,es,je="You also <em>need</em> to implement 2 (ideally 4) tests.",Ys,ls,fe=`<li><code>test_small_model_pt</code> : Define 1 small model for this pipeline (doesn’t matter if the results don’t make sense)
and test the pipeline outputs. The results should be the same as <code>test_small_model_tf</code>.</li> <li><code>test_small_model_tf</code> : Define 1 small model for this pipeline (doesn’t matter if the results don’t make sense)
and test the pipeline outputs. The results should be the same as <code>test_small_model_pt</code>.</li> <li><code>test_large_model_pt</code> (<code>optional</code>): Tests the pipeline on a real pipeline where the results are supposed to
make sense. These tests are slow and should be marked as such. Here the goal is to showcase the pipeline and to make
sure there is no drift in future releases.</li> <li><code>test_large_model_tf</code> (<code>optional</code>): Tests the pipeline on a real pipeline where the results are supposed to
make sense. These tests are slow and should be marked as such. Here the goal is to showcase the pipeline and to make
sure there is no drift in future releases.</li>`,Fs,as,Qs;return h=new Ss({props:{title:"How to create a custom pipeline?",local:"how-to-create-a-custom-pipeline",headingTag:"h1"}}),U=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBpcGVsaW5lJTBBJTBBJTBBY2xhc3MlMjBNeVBpcGVsaW5lKFBpcGVsaW5lKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9zYW5pdGl6ZV9wYXJhbWV0ZXJzKHNlbGYlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwJTIybWF5YmVfYXJnJTIyJTIwaW4lMjBrd2FyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUyMCUzRCUyMGt3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwJTdCJTdEJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcHJlcHJvY2VzcyhzZWxmJTJDJTIwaW5wdXRzJTJDJTIwbWF5YmVfYXJnJTNEMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pbnB1dCUyMCUzRCUyMFRlbnNvcihpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9mb3J3YXJkKHNlbGYlMkMlMjBtb2RlbF9pbnB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbW9kZWxfaW5wdXRzJTIwJTNEJTNEJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBzZWxmLm1vZGVsKCoqbW9kZWxfaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME1heWJlJTIwJTdCJTIybG9naXRzJTIyJTNBJTIwVGVuc29yKC4uLiklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRzJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, inputs, maybe_arg=<span class="hljs-number">2</span></span>):
        model_input = Tensor(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;model_input&quot;</span>: model_input}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-comment"># model_inputs == {&quot;model_input&quot;: model_input}</span>
        outputs = self.model(**model_inputs)
        <span class="hljs-comment"># Maybe {&quot;logits&quot;: Tensor(...)}</span>
        <span class="hljs-keyword">return</span> outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
        <span class="hljs-keyword">return</span> best_class`,wrap:!1}}),g=new u({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMm15LW5ldy10YXNrJTIyKSUwQXBpcGUoJTIyVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIpJTBBJTBBcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwdGVzdCUyMiUyQyUyMHRvcF9rJTNEMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;my-new-task&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;3-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.05</span>}
{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;4-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;5-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>, top_k=<span class="hljs-number">2</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}]`,wrap:!1}}),H=new u({props:{code:"ZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMlMkMlMjB0b3BfayUzRDUpJTNBJTBBJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjMlMjBBZGQlMjBsb2dpYyUyMHRvJTIwaGFuZGxlJTIwdG9wX2slMEElMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNzJTBBJTBBJTBBZGVmJTIwX3Nhbml0aXplX3BhcmFtZXRlcnMoc2VsZiUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJtYXliZV9hcmclMjIlMjBpbiUyMGt3YXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTIwJTNEJTIwa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJ0b3BfayUyMiUyMGluJTIwa3dhcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTVCJTIydG9wX2slMjIlNUQlMjAlM0QlMjBrd2FyZ3MlNUIlMjJ0b3BfayUyMiU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwcG9zdHByb2Nlc3Nfa3dhcmdz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs, top_k=<span class="hljs-number">5</span></span>):
    best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
    <span class="hljs-comment"># Add logic to handle top_k</span>
    <span class="hljs-keyword">return</span> best_class


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
    preprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]

    postprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;top_k&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        postprocess_kwargs[<span class="hljs-string">&quot;top_k&quot;</span>] = kwargs[<span class="hljs-string">&quot;top_k&quot;</span>]
    <span class="hljs-keyword">return</span> preprocess_kwargs, {}, postprocess_kwargs`,wrap:!1}}),V=new Ss({props:{title:"Adding it to the list of supported tasks",local:"adding-it-to-the-list-of-supported-tasks",headingTag:"h2"}}),W=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMlMjBpbXBvcnQlMjBQSVBFTElORV9SRUdJU1RSWSUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMm5ldy10YXNrJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfY2xhc3MlM0RNeVBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
)`,wrap:!1}}),N=new u({props:{code:"UElQRUxJTkVfUkVHSVNUUlkucmVnaXN0ZXJfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIybmV3LXRhc2slMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRE15UGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBwdF9tb2RlbCUzREF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEElMjAlMjAlMjAlMjBkZWZhdWx0JTNEJTdCJTIycHQlMjIlM0ElMjAoJTIydXNlciUyRmF3ZXNvbWVfbW9kZWwlMjIlMkMlMjAlMjJhYmNkZWYlMjIpJTdEJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnRleHQlMjIlMkMlMjAlMjAlMjMlMjBjdXJyZW50JTIwc3VwcG9ydCUyMHR5cGUlM0ElMjB0ZXh0JTJDJTIwYXVkaW8lMkMlMjBpbWFnZSUyQyUyMG11bHRpbW9kYWwlMEEp",highlighted:`PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
    default={<span class="hljs-string">&quot;pt&quot;</span>: (<span class="hljs-string">&quot;user/awesome_model&quot;</span>, <span class="hljs-string">&quot;abcdef&quot;</span>)},
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;text&quot;</span>,  <span class="hljs-comment"># current support type: text, audio, image, multimodal</span>
)`,wrap:!1}}),q=new Ss({props:{title:"Share your pipeline on the Hub",local:"share-your-pipeline-on-the-hub",headingTag:"h2"}}),E=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">def</span> <span class="hljs-title function_">softmax</span>(<span class="hljs-params">outputs</span>):
    maxes = np.<span class="hljs-built_in">max</span>(outputs, axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)
    shifted_exp = np.exp(outputs - maxes)
    <span class="hljs-keyword">return</span> shifted_exp / shifted_exp.<span class="hljs-built_in">sum</span>(axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">class</span> <span class="hljs-title class_">PairClassificationPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;second_text&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;second_text&quot;</span>] = kwargs[<span class="hljs-string">&quot;second_text&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, text, second_text=<span class="hljs-literal">None</span></span>):
        <span class="hljs-keyword">return</span> self.tokenizer(text, text_pair=second_text, return_tensors=self.framework)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-keyword">return</span> self.model(**model_inputs)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        logits = model_outputs.logits[<span class="hljs-number">0</span>].numpy()
        probabilities = softmax(logits)

        best_class = np.argmax(probabilities)
        label = self.model.config.id2label[best_class]
        score = probabilities[best_class].item()
        logits = logits.tolist()
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;label&quot;</span>: label, <span class="hljs-string">&quot;score&quot;</span>: score, <span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),$=new u({props:{code:"ZnJvbSUyMHBhaXJfY2xhc3NpZmljYXRpb24lMjBpbXBvcnQlMjBQYWlyQ2xhc3NpZmljYXRpb25QaXBlbGluZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMucGlwZWxpbmVzJTIwaW1wb3J0JTIwUElQRUxJTkVfUkVHSVNUUlklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRFBhaXJDbGFzc2lmaWNhdGlvblBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdGZfbW9kZWwlM0RURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> pair_classification <span class="hljs-keyword">import</span> PairClassificationPipeline
<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, TFAutoModelForSequenceClassification

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;pair-classification&quot;</span>,
    pipeline_class=PairClassificationPipeline,
    pt_model=AutoModelForSequenceClassification,
    tf_model=TFAutoModelForSequenceClassification,
)`,wrap:!1}}),Y=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMnNndWdnZXIlMkZmaW5ldHVuZWQtYmVydC1tcnBjJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(<span class="hljs-string">&quot;pair-classification&quot;</span>, model=<span class="hljs-string">&quot;sgugger/finetuned-bert-mrpc&quot;</span>)`,wrap:!1}}),Q=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEElMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeSglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIlMkMlMjBjbG9uZV9mcm9tJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiklMEFjbGFzc2lmaWVyLnNhdmVfcHJldHJhaW5lZCglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIpJTBBcmVwby5wdXNoX3RvX2h1Yigp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository

repo = Repository(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>, clone_from=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>)
classifier.save_pretrained(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>)
repo.push_to_hub()`,wrap:!1}}),L=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(model=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),P=new Ss({props:{title:"Add the pipeline to 🤗 Transformers",local:"add-the-pipeline-to--transformers",headingTag:"h2"}}),{c(){w=p("meta"),ns=a(),ts=p("p"),ps=a(),r(h.$$.fragment),is=a(),T=p("p"),T.innerHTML=Ps,os=a(),J=p("p"),J.innerHTML=Ks,rs=a(),j=p("p"),j.innerHTML=Ds,cs=a(),f=p("p"),f.innerHTML=Os,Ms=a(),r(U.$$.fragment),ds=a(),b=p("p"),b.textContent=se,ys=a(),I=p("p"),I.innerHTML=ee,ms=a(),B=p("p"),B.innerHTML=le,us=a(),C=p("p"),C.innerHTML=te,ws=a(),_=p("p"),_.innerHTML=ae,hs=a(),k=p("p"),k.innerHTML=ne,Ts=a(),Z=p("p"),Z.innerHTML=pe,Js=a(),r(g.$$.fragment),js=a(),G=p("p"),G.innerHTML=ie,fs=a(),r(H.$$.fragment),Us=a(),A=p("p"),A.textContent=oe,bs=a(),r(V.$$.fragment),Is=a(),X=p("p"),X.innerHTML=re,Bs=a(),r(W.$$.fragment),Cs=a(),R=p("p"),R.innerHTML=ce,_s=a(),r(N.$$.fragment),ks=a(),r(q.$$.fragment),Zs=a(),v=p("p"),v.innerHTML=Me,gs=a(),r(E.$$.fragment),Gs=a(),z=p("p"),z.innerHTML=de,Hs=a(),r($.$$.fragment),As=a(),x=p("p"),x.innerHTML=ye,Vs=a(),r(Y.$$.fragment),Xs=a(),F=p("p"),F.innerHTML=me,Ws=a(),r(Q.$$.fragment),Rs=a(),S=p("p"),S.innerHTML=ue,Ns=a(),r(L.$$.fragment),qs=a(),r(P.$$.fragment),vs=a(),K=p("p"),K.innerHTML=we,Es=a(),D=p("p"),D.innerHTML=he,zs=a(),O=p("p"),O.innerHTML=Te,$s=a(),ss=p("p"),ss.innerHTML=Je,xs=a(),es=p("p"),es.innerHTML=je,Ys=a(),ls=p("ul"),ls.innerHTML=fe,Fs=a(),as=p("p"),this.h()},l(s){const e=Ze("svelte-u9bgzb",document.head);w=i(e,"META",{name:!0,content:!0}),e.forEach(l),ns=n(s),ts=i(s,"P",{}),Ue(ts).forEach(l),ps=n(s),c(h.$$.fragment,s),is=n(s),T=i(s,"P",{"data-svelte-h":!0}),o(T)!=="svelte-b9qm9y"&&(T.innerHTML=Ps),os=n(s),J=i(s,"P",{"data-svelte-h":!0}),o(J)!=="svelte-oxa02l"&&(J.innerHTML=Ks),rs=n(s),j=i(s,"P",{"data-svelte-h":!0}),o(j)!=="svelte-6dmyza"&&(j.innerHTML=Ds),cs=n(s),f=i(s,"P",{"data-svelte-h":!0}),o(f)!=="svelte-yoim0k"&&(f.innerHTML=Os),Ms=n(s),c(U.$$.fragment,s),ds=n(s),b=i(s,"P",{"data-svelte-h":!0}),o(b)!=="svelte-byrozk"&&(b.textContent=se),ys=n(s),I=i(s,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1f1lssz"&&(I.innerHTML=ee),ms=n(s),B=i(s,"P",{"data-svelte-h":!0}),o(B)!=="svelte-12jiwrp"&&(B.innerHTML=le),us=n(s),C=i(s,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1ev1pra"&&(C.innerHTML=te),ws=n(s),_=i(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-wbhsl3"&&(_.innerHTML=ae),hs=n(s),k=i(s,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1rxvpik"&&(k.innerHTML=ne),Ts=n(s),Z=i(s,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1jbvi33"&&(Z.innerHTML=pe),Js=n(s),c(g.$$.fragment,s),js=n(s),G=i(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-nsc0of"&&(G.innerHTML=ie),fs=n(s),c(H.$$.fragment,s),Us=n(s),A=i(s,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1r0sy2p"&&(A.textContent=oe),bs=n(s),c(V.$$.fragment,s),Is=n(s),X=i(s,"P",{"data-svelte-h":!0}),o(X)!=="svelte-3jotdg"&&(X.innerHTML=re),Bs=n(s),c(W.$$.fragment,s),Cs=n(s),R=i(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-491gz1"&&(R.innerHTML=ce),_s=n(s),c(N.$$.fragment,s),ks=n(s),c(q.$$.fragment,s),Zs=n(s),v=i(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-12i9yqr"&&(v.innerHTML=Me),gs=n(s),c(E.$$.fragment,s),Gs=n(s),z=i(s,"P",{"data-svelte-h":!0}),o(z)!=="svelte-fgifeg"&&(z.innerHTML=de),Hs=n(s),c($.$$.fragment,s),As=n(s),x=i(s,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1o1fy6m"&&(x.innerHTML=ye),Vs=n(s),c(Y.$$.fragment,s),Xs=n(s),F=i(s,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1769ktt"&&(F.innerHTML=me),Ws=n(s),c(Q.$$.fragment,s),Rs=n(s),S=i(s,"P",{"data-svelte-h":!0}),o(S)!=="svelte-m8nvb"&&(S.innerHTML=ue),Ns=n(s),c(L.$$.fragment,s),qs=n(s),c(P.$$.fragment,s),vs=n(s),K=i(s,"P",{"data-svelte-h":!0}),o(K)!=="svelte-wriqax"&&(K.innerHTML=we),Es=n(s),D=i(s,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1wx7ut0"&&(D.innerHTML=he),zs=n(s),O=i(s,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1by38ya"&&(O.innerHTML=Te),$s=n(s),ss=i(s,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-1cftve5"&&(ss.innerHTML=Je),xs=n(s),es=i(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-17fu767"&&(es.innerHTML=je),Ys=n(s),ls=i(s,"UL",{"data-svelte-h":!0}),o(ls)!=="svelte-9p61si"&&(ls.innerHTML=fe),Fs=n(s),as=i(s,"P",{}),Ue(as).forEach(l),this.h()},h(){be(w,"name","hf:doc:metadata"),be(w,"content",He)},m(s,e){ge(document.head,w),t(s,ns,e),t(s,ts,e),t(s,ps,e),M(h,s,e),t(s,is,e),t(s,T,e),t(s,os,e),t(s,J,e),t(s,rs,e),t(s,j,e),t(s,cs,e),t(s,f,e),t(s,Ms,e),M(U,s,e),t(s,ds,e),t(s,b,e),t(s,ys,e),t(s,I,e),t(s,ms,e),t(s,B,e),t(s,us,e),t(s,C,e),t(s,ws,e),t(s,_,e),t(s,hs,e),t(s,k,e),t(s,Ts,e),t(s,Z,e),t(s,Js,e),M(g,s,e),t(s,js,e),t(s,G,e),t(s,fs,e),M(H,s,e),t(s,Us,e),t(s,A,e),t(s,bs,e),M(V,s,e),t(s,Is,e),t(s,X,e),t(s,Bs,e),M(W,s,e),t(s,Cs,e),t(s,R,e),t(s,_s,e),M(N,s,e),t(s,ks,e),M(q,s,e),t(s,Zs,e),t(s,v,e),t(s,gs,e),M(E,s,e),t(s,Gs,e),t(s,z,e),t(s,Hs,e),M($,s,e),t(s,As,e),t(s,x,e),t(s,Vs,e),M(Y,s,e),t(s,Xs,e),t(s,F,e),t(s,Ws,e),M(Q,s,e),t(s,Rs,e),t(s,S,e),t(s,Ns,e),M(L,s,e),t(s,qs,e),M(P,s,e),t(s,vs,e),t(s,K,e),t(s,Es,e),t(s,D,e),t(s,zs,e),t(s,O,e),t(s,$s,e),t(s,ss,e),t(s,xs,e),t(s,es,e),t(s,Ys,e),t(s,ls,e),t(s,Fs,e),t(s,as,e),Qs=!0},p:Be,i(s){Qs||(d(h.$$.fragment,s),d(U.$$.fragment,s),d(g.$$.fragment,s),d(H.$$.fragment,s),d(V.$$.fragment,s),d(W.$$.fragment,s),d(N.$$.fragment,s),d(q.$$.fragment,s),d(E.$$.fragment,s),d($.$$.fragment,s),d(Y.$$.fragment,s),d(Q.$$.fragment,s),d(L.$$.fragment,s),d(P.$$.fragment,s),Qs=!0)},o(s){y(h.$$.fragment,s),y(U.$$.fragment,s),y(g.$$.fragment,s),y(H.$$.fragment,s),y(V.$$.fragment,s),y(W.$$.fragment,s),y(N.$$.fragment,s),y(q.$$.fragment,s),y(E.$$.fragment,s),y($.$$.fragment,s),y(Y.$$.fragment,s),y(Q.$$.fragment,s),y(L.$$.fragment,s),y(P.$$.fragment,s),Qs=!1},d(s){s&&(l(ns),l(ts),l(ps),l(is),l(T),l(os),l(J),l(rs),l(j),l(cs),l(f),l(Ms),l(ds),l(b),l(ys),l(I),l(ms),l(B),l(us),l(C),l(ws),l(_),l(hs),l(k),l(Ts),l(Z),l(Js),l(js),l(G),l(fs),l(Us),l(A),l(bs),l(Is),l(X),l(Bs),l(Cs),l(R),l(_s),l(ks),l(Zs),l(v),l(gs),l(Gs),l(z),l(Hs),l(As),l(x),l(Vs),l(Xs),l(F),l(Ws),l(Rs),l(S),l(Ns),l(qs),l(vs),l(K),l(Es),l(D),l(zs),l(O),l($s),l(ss),l(xs),l(es),l(Ys),l(ls),l(Fs),l(as)),l(w),m(h,s),m(U,s),m(g,s),m(H,s),m(V,s),m(W,s),m(N,s),m(q,s),m(E,s),m($,s),m(Y,s),m(Q,s),m(L,s),m(P,s)}}}const He='{"title":"How to create a custom pipeline?","local":"how-to-create-a-custom-pipeline","sections":[{"title":"Adding it to the list of supported tasks","local":"adding-it-to-the-list-of-supported-tasks","sections":[],"depth":2},{"title":"Share your pipeline on the Hub","local":"share-your-pipeline-on-the-hub","sections":[],"depth":2},{"title":"Add the pipeline to 🤗 Transformers","local":"add-the-pipeline-to--transformers","sections":[],"depth":2}],"depth":1}';function Ae(Ls){return Ce(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ne extends _e{constructor(w){super(),ke(this,w,Ae,Ge,Ie,{})}}export{Ne as component};
