import{s as Ae,n as Ke,o as Oe}from"../chunks/scheduler.3e4cb221.js";import{S as tl,i as el,g as i,s as n,r as o,A as ll,h as m,f as l,c as a,j as Se,u as r,x as p,k as De,y as sl,a as s,v as J,d as c,t as M,w as u}from"../chunks/index.bc693fcb.js";import{H as T,g as nl}from"../chunks/Heading.64df45ec.js";import{C as d}from"../chunks/CodeBlock.4b1f9331.js";import{D as al}from"../chunks/DocNotebookDropdown.6f3fc135.js";function il(Te){let g,Tt,dt,ft,f,Ut,U,bt,b,fe='🤗 Transformers 中有多种多语言模型，它们的推理用法与单语言模型不同。但是，并非<em>所有</em>的多语言模型用法都不同。一些模型，例如 <a href="https://huggingface.co/bert-base-multilingual-uncased" rel="nofollow">bert-base-multilingual-uncased</a> 就可以像单语言模型一样使用。本指南将向您展示如何使用不同用途的多语言模型进行推理。',yt,y,ht,h,Ue="XLM 有十个不同的检查点，其中只有一个是单语言的。剩下的九个检查点可以归为两类：使用语言嵌入的检查点和不使用语言嵌入的检查点。",$t,$,wt,w,be="以下 XLM 模型使用语言嵌入来指定推理中使用的语言：",xt,x,ye="<li><code>xlm-mlm-ende-1024</code> （掩码语言建模，英语-德语）</li> <li><code>xlm-mlm-enfr-1024</code> （掩码语言建模，英语-法语）</li> <li><code>xlm-mlm-enro-1024</code> （掩码语言建模，英语-罗马尼亚语）</li> <li><code>xlm-mlm-xnli15-1024</code> （掩码语言建模，XNLI 数据集语言）</li> <li><code>xlm-mlm-tlm-xnli15-1024</code> （掩码语言建模+翻译，XNLI 数据集语言）</li> <li><code>xlm-clm-enfr-1024</code> （因果语言建模，英语-法语）</li> <li><code>xlm-clm-ende-1024</code> （因果语言建模，英语-德语）</li>",jt,j,he="语言嵌入被表示一个张量，其形状与传递给模型的 <code>input_ids</code> 相同。这些张量中的值取决于所使用的语言，并由分词器的 <code>lang2id</code> 和 <code>id2lang</code>  属性识别。",Ct,C,$e="在此示例中，加载 <code>xlm-clm-enfr-1024</code> 检查点（因果语言建模，英语-法语）：",kt,k,vt,v,we="分词器的 <code>lang2id</code> 属性显示了该模型的语言及其对应的id：",_t,_,Zt,Z,xe="接下来，创建一个示例输入：",It,I,Xt,X,je="将语言 id 设置为 <code>&quot;en&quot;</code> 并用其定义语言嵌入。语言嵌入是一个用 <code>0</code> 填充的张量，这个张量应该与 <code>input_ids</code> 大小相同。",Rt,R,Vt,V,Ce="现在，你可以将 <code>input_ids</code> 和语言嵌入传递给模型：",Gt,G,Wt,W,ke='<a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-generation/run_generation.py" rel="nofollow">run_generation.py</a> 脚本可以使用 <code>xlm-clm</code> 检查点生成带有语言嵌入的文本。',Lt,L,zt,z,ve="以下 XLM 模型在推理时不需要语言嵌入：",Bt,B,_e="<li><code>xlm-mlm-17-1280</code> （掩码语言建模，支持 17 种语言）</li> <li><code>xlm-mlm-100-1280</code> （掩码语言建模，支持 100 种语言）</li>",Et,E,Ze="与之前的 XLM 检查点不同，这些模型用于通用句子表示。",Ft,F,Qt,Q,Ie="以下 BERT 模型可用于多语言任务：",Ht,H,Xe="<li><code>bert-base-multilingual-uncased</code> （掩码语言建模 + 下一句预测，支持 102 种语言）</li> <li><code>bert-base-multilingual-cased</code> （掩码语言建模 + 下一句预测，支持 104 种语言）</li>",qt,q,Re="这些模型在推理时不需要语言嵌入。它们应该能够从上下文中识别语言并进行相应的推理。",Nt,N,Yt,Y,Ve="以下 XLM-RoBERTa 模型可用于多语言任务：",Pt,P,Ge="<li><code>xlm-roberta-base</code> （掩码语言建模，支持 100 种语言）</li> <li><code>xlm-roberta-large</code> （掩码语言建模，支持 100 种语言）</li>",St,S,We="XLM-RoBERTa 使用 100 种语言的 2.5TB 新创建和清理的 CommonCrawl 数据进行了训练。与之前发布的 mBERT 或 XLM 等多语言模型相比，它在分类、序列标记和问答等下游任务上提供了更强大的优势。",Dt,D,At,A,Le="以下 M2M100 模型可用于多语言翻译：",Kt,K,ze="<li><code>facebook/m2m100_418M</code> （翻译）</li> <li><code>facebook/m2m100_1.2B</code> （翻译）</li>",Ot,O,Be="在此示例中，加载 <code>facebook/m2m100_418M</code> 检查点以将中文翻译为英文。你可以在分词器中设置源语言：",te,tt,ee,et,Ee="对文本进行分词：",le,lt,se,st,Fe="M2M100 强制将目标语言 id 作为第一个生成的标记，以进行到目标语言的翻译。在 <code>generate</code> 方法中将 <code>forced_bos_token_id</code> 设置为 <code>en</code> 以翻译成英语：",ne,nt,ae,at,ie,it,Qe="以下 MBart 模型可用于多语言翻译：",me,mt,He="<li><code>facebook/mbart-large-50-one-to-many-mmt</code> （一对多多语言机器翻译，支持 50 种语言）</li> <li><code>facebook/mbart-large-50-many-to-many-mmt</code> （多对多多语言机器翻译，支持 50 种语言）</li> <li><code>facebook/mbart-large-50-many-to-one-mmt</code> （多对一多语言机器翻译，支持 50 种语言）</li> <li><code>facebook/mbart-large-50</code> （多语言翻译，支持 50 种语言）</li> <li><code>facebook/mbart-large-cc25</code></li>",pe,pt,qe="在此示例中，加载  <code>facebook/mbart-large-50-many-to-many-mmt</code> 检查点以将芬兰语翻译为英语。 你可以在分词器中设置源语言：",oe,ot,re,rt,Ne="对文本进行分词：",Je,Jt,ce,ct,Ye="MBart 强制将目标语言 id 作为第一个生成的标记，以进行到目标语言的翻译。在 <code>generate</code> 方法中将 <code>forced_bos_token_id</code> 设置为 <code>en</code> 以翻译成英语：",Me,Mt,ue,ut,Pe="如果你使用的是 <code>facebook/mbart-large-50-many-to-one-mmt</code> 检查点，则无需强制目标语言 id 作为第一个生成的令牌，否则用法是相同的。",de,gt,ge;return f=new T({props:{title:"用于推理的多语言模型",local:"用于推理的多语言模型",headingTag:"h1"}}),U=new al({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/multilingual.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/tensorflow/multilingual.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/multilingual.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/tensorflow/multilingual.ipynb"}]}}),y=new T({props:{title:"XLM",local:"xlm",headingTag:"h2"}}),$=new T({props:{title:"带有语言嵌入的 XLM",local:"带有语言嵌入的-xlm",headingTag:"h3"}}),k=new d({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwWExNVG9rZW5pemVyJTJDJTIwWExNV2l0aExNSGVhZE1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwWExNVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ4bG0tY2xtLWVuZnItMTAyNCUyMiklMEFtb2RlbCUyMCUzRCUyMFhMTVdpdGhMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyeGxtLWNsbS1lbmZyLTEwMjQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLMTokenizer, XLMWithLMHeadModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = XLMTokenizer.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = XLMWithLMHeadModel.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)`,wrap:!1}}),_=new d({props:{code:"cHJpbnQodG9rZW5pemVyLmxhbmcyaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.lang2id)
{<span class="hljs-string">&#x27;en&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;fr&#x27;</span>: <span class="hljs-number">1</span>}`,wrap:!1}}),I=new d({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QnRva2VuaXplci5lbmNvZGUoJTIyV2lraXBlZGlhJTIwd2FzJTIwdXNlZCUyMHRvJTIyKSU1RCklMjAlMjAlMjMlMjBiYXRjaCUyMHNpemUlMjAlRTQlQjglQkElMjAx",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([tokenizer.encode(<span class="hljs-string">&quot;Wikipedia was used to&quot;</span>)])  <span class="hljs-comment"># batch size 为 1</span>',wrap:!1}}),R=new d({props:{code:"bGFuZ3VhZ2VfaWQlMjAlM0QlMjB0b2tlbml6ZXIubGFuZzJpZCU1QiUyMmVuJTIyJTVEJTIwJTIwJTIzJTIwMCUwQWxhbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1Qmxhbmd1YWdlX2lkJTVEJTIwKiUyMGlucHV0X2lkcy5zaGFwZSU1QjElNUQpJTIwJTIwJTIzJTIwdG9yY2gudGVuc29yKCU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMC4uLiUyQyUyMDAlNUQpJTBBJTBBJTIzJTIwJUU2JTg4JTkxJUU0JUJCJUFDJUU1JUIwJTg2JUU1JTg1JUI2JTIwcmVzaGFwZSUyMCVFNCVCOCVCQSUyMChiYXRjaF9zaXplJTJDJTIwc2VxdWVuY2VfbGVuZ3RoKSUyMCVFNSVBNCVBNyVFNSVCMCU4RiUwQWxhbmdzJTIwJTNEJTIwbGFuZ3MudmlldygxJTJDJTIwLTEpJTIwJTIwJTIzJTIwJUU3JThFJUIwJUU1JTlDJUE4JUU3JTlBJTg0JUU1JUJEJUEyJUU3JThBJUI2JUU2JTk4JUFGJTIwJTVCMSUyQyUyMHNlcXVlbmNlX2xlbmd0aCU1RCUyMCglRTYlODglOTElRTQlQkIlQUMlRTclOUElODQlMjBiYXRjaCUyMHNpemUlMjAlRTQlQjglQkElMjAxKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>language_id = tokenizer.lang2id[<span class="hljs-string">&quot;en&quot;</span>]  <span class="hljs-comment"># 0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = torch.tensor([language_id] * input_ids.shape[<span class="hljs-number">1</span>])  <span class="hljs-comment"># torch.tensor([0, 0, 0, ..., 0])</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 我们将其 reshape 为 (batch_size, sequence_length) 大小</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = langs.view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>)  <span class="hljs-comment"># 现在的形状是 [1, sequence_length] (我们的 batch size 为 1)</span>`,wrap:!1}}),G=new d({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUyQyUyMGxhbmdzJTNEbGFuZ3Mp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids, langs=langs)',wrap:!1}}),L=new T({props:{title:"不带语言嵌入的 XLM",local:"不带语言嵌入的-xlm",headingTag:"h3"}}),F=new T({props:{title:"BERT",local:"bert",headingTag:"h2"}}),N=new T({props:{title:"XLM-RoBERTa",local:"xlm-roberta",headingTag:"h2"}}),D=new T({props:{title:"M2M100",local:"m2m100",headingTag:"h2"}}),tt=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME0yTTEwMEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyME0yTTEwMFRva2VuaXplciUwQSUwQWVuX3RleHQlMjAlM0QlMjAlMjJEbyUyMG5vdCUyMG1lZGRsZSUyMGluJTIwdGhlJTIwYWZmYWlycyUyMG9mJTIwd2l6YXJkcyUyQyUyMGZvciUyMHRoZXklMjBhcmUlMjBzdWJ0bGUlMjBhbmQlMjBxdWljayUyMHRvJTIwYW5nZXIuJTIyJTBBY2hpbmVzZV90ZXh0JTIwJTNEJTIwJTIyJUU0JUI4JThEJUU4JUE2JTgxJUU2JThGJTkyJUU2JTg5JThCJUU1JUI3JUFCJUU1JUI4JUFCJUU3JTlBJTg0JUU0JUJBJThCJUU1JThCJTk5JTJDJTIwJUU1JTlCJUEwJUU3JTgyJUJBJUU0JUJCJTk2JUU1JTgwJTkxJUU2JTk4JUFGJUU1JUJFJUFFJUU1JUE2JTk5JUU3JTlBJTg0JTJDJTIwJUU1JUJFJTg4JUU1JUJGJUFCJUU1JUIwJUIxJUU2JTlDJTgzJUU3JTk5JUJDJUU2JTgwJTkyLiUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyME0yTTEwMFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtMm0xMDBfNDE4TSUyMiUyQyUyMHNyY19sYW5nJTNEJTIyemglMjIpJTBBbW9kZWwlMjAlM0QlMjBNMk0xMDBGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbTJtMTAwXzQxOE0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> M2M100ForConditionalGeneration, M2M100Tokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chinese_text = <span class="hljs-string">&quot;不要插手巫師的事務, 因為他們是微妙的, 很快就會發怒.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = M2M100Tokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>, src_lang=<span class="hljs-string">&quot;zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = M2M100ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>)`,wrap:!1}}),lt=new d({props:{code:"ZW5jb2RlZF96aCUyMCUzRCUyMHRva2VuaXplcihjaGluZXNlX3RleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_zh = tokenizer(chinese_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),nt=new d({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF96aCUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZ2V0X2xhbmdfaWQoJTIyZW4lMjIpKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_zh, forced_bos_token_id=tokenizer.get_lang_id(<span class="hljs-string">&quot;en&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Do not interfere with the matters of the witches, because they are delicate and will soon be angry.&#x27;</span>`,wrap:!1}}),at=new T({props:{title:"MBart",local:"mbart",headingTag:"h2"}}),ot=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFlbl90ZXh0JTIwJTNEJTIwJTIyRG8lMjBub3QlMjBtZWRkbGUlMjBpbiUyMHRoZSUyMGFmZmFpcnMlMjBvZiUyMHdpemFyZHMlMkMlMjBmb3IlMjB0aGV5JTIwYXJlJTIwc3VidGxlJTIwYW5kJTIwcXVpY2slMjB0byUyMGFuZ2VyLiUyMiUwQWZpX3RleHQlMjAlM0QlMjAlMjIlQzMlODRsJUMzJUE0JTIwc2VrYWFubnUlMjB2ZWxob2plbiUyMGFzaW9paGluJTJDJTIwc2lsbCVDMyVBNCUyMG5lJTIwb3ZhdCUyMGhpZW5vdmFyYWlzaWElMjBqYSUyMG5vcGVhc3RpJTIwdmloYWlzaWEuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJmaV9GSSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fi_text = <span class="hljs-string">&quot;Älä sekaannu velhojen asioihin, sillä ne ovat hienovaraisia ja nopeasti vihaisia.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;fi_FI&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>)`,wrap:!1}}),Jt=new d({props:{code:"ZW5jb2RlZF9lbiUyMCUzRCUyMHRva2VuaXplcihlbl90ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_en = tokenizer(en_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),Mt=new d({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF9lbiUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIubGFuZ19jb2RlX3RvX2lkJTVCJTIyZW5fWFglMjIlNUQpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_en, forced_bos_token_id=tokenizer.lang_code_to_id[<span class="hljs-string">&quot;en_XX&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;Don&#x27;t interfere with the wizard&#x27;s affairs, because they are subtle, will soon get angry.&quot;</span>`,wrap:!1}}),{c(){g=i("meta"),Tt=n(),dt=i("p"),ft=n(),o(f.$$.fragment),Ut=n(),o(U.$$.fragment),bt=n(),b=i("p"),b.innerHTML=fe,yt=n(),o(y.$$.fragment),ht=n(),h=i("p"),h.textContent=Ue,$t=n(),o($.$$.fragment),wt=n(),w=i("p"),w.textContent=be,xt=n(),x=i("ul"),x.innerHTML=ye,jt=n(),j=i("p"),j.innerHTML=he,Ct=n(),C=i("p"),C.innerHTML=$e,kt=n(),o(k.$$.fragment),vt=n(),v=i("p"),v.innerHTML=we,_t=n(),o(_.$$.fragment),Zt=n(),Z=i("p"),Z.textContent=xe,It=n(),o(I.$$.fragment),Xt=n(),X=i("p"),X.innerHTML=je,Rt=n(),o(R.$$.fragment),Vt=n(),V=i("p"),V.innerHTML=Ce,Gt=n(),o(G.$$.fragment),Wt=n(),W=i("p"),W.innerHTML=ke,Lt=n(),o(L.$$.fragment),zt=n(),z=i("p"),z.textContent=ve,Bt=n(),B=i("ul"),B.innerHTML=_e,Et=n(),E=i("p"),E.textContent=Ze,Ft=n(),o(F.$$.fragment),Qt=n(),Q=i("p"),Q.textContent=Ie,Ht=n(),H=i("ul"),H.innerHTML=Xe,qt=n(),q=i("p"),q.textContent=Re,Nt=n(),o(N.$$.fragment),Yt=n(),Y=i("p"),Y.textContent=Ve,Pt=n(),P=i("ul"),P.innerHTML=Ge,St=n(),S=i("p"),S.textContent=We,Dt=n(),o(D.$$.fragment),At=n(),A=i("p"),A.textContent=Le,Kt=n(),K=i("ul"),K.innerHTML=ze,Ot=n(),O=i("p"),O.innerHTML=Be,te=n(),o(tt.$$.fragment),ee=n(),et=i("p"),et.textContent=Ee,le=n(),o(lt.$$.fragment),se=n(),st=i("p"),st.innerHTML=Fe,ne=n(),o(nt.$$.fragment),ae=n(),o(at.$$.fragment),ie=n(),it=i("p"),it.textContent=Qe,me=n(),mt=i("ul"),mt.innerHTML=He,pe=n(),pt=i("p"),pt.innerHTML=qe,oe=n(),o(ot.$$.fragment),re=n(),rt=i("p"),rt.textContent=Ne,Je=n(),o(Jt.$$.fragment),ce=n(),ct=i("p"),ct.innerHTML=Ye,Me=n(),o(Mt.$$.fragment),ue=n(),ut=i("p"),ut.innerHTML=Pe,de=n(),gt=i("p"),this.h()},l(t){const e=ll("svelte-u9bgzb",document.head);g=m(e,"META",{name:!0,content:!0}),e.forEach(l),Tt=a(t),dt=m(t,"P",{}),Se(dt).forEach(l),ft=a(t),r(f.$$.fragment,t),Ut=a(t),r(U.$$.fragment,t),bt=a(t),b=m(t,"P",{"data-svelte-h":!0}),p(b)!=="svelte-tk208n"&&(b.innerHTML=fe),yt=a(t),r(y.$$.fragment,t),ht=a(t),h=m(t,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1do04ou"&&(h.textContent=Ue),$t=a(t),r($.$$.fragment,t),wt=a(t),w=m(t,"P",{"data-svelte-h":!0}),p(w)!=="svelte-ae6845"&&(w.textContent=be),xt=a(t),x=m(t,"UL",{"data-svelte-h":!0}),p(x)!=="svelte-o2sepu"&&(x.innerHTML=ye),jt=a(t),j=m(t,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1xxan1y"&&(j.innerHTML=he),Ct=a(t),C=m(t,"P",{"data-svelte-h":!0}),p(C)!=="svelte-y2cvsq"&&(C.innerHTML=$e),kt=a(t),r(k.$$.fragment,t),vt=a(t),v=m(t,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1bg3kzi"&&(v.innerHTML=we),_t=a(t),r(_.$$.fragment,t),Zt=a(t),Z=m(t,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-mgsk1x"&&(Z.textContent=xe),It=a(t),r(I.$$.fragment,t),Xt=a(t),X=m(t,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1wd8oyh"&&(X.innerHTML=je),Rt=a(t),r(R.$$.fragment,t),Vt=a(t),V=m(t,"P",{"data-svelte-h":!0}),p(V)!=="svelte-wr7smr"&&(V.innerHTML=Ce),Gt=a(t),r(G.$$.fragment,t),Wt=a(t),W=m(t,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1y11as"&&(W.innerHTML=ke),Lt=a(t),r(L.$$.fragment,t),zt=a(t),z=m(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-ug2kdl"&&(z.textContent=ve),Bt=a(t),B=m(t,"UL",{"data-svelte-h":!0}),p(B)!=="svelte-f6s7ji"&&(B.innerHTML=_e),Et=a(t),E=m(t,"P",{"data-svelte-h":!0}),p(E)!=="svelte-s35cwf"&&(E.textContent=Ze),Ft=a(t),r(F.$$.fragment,t),Qt=a(t),Q=m(t,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-10z54vn"&&(Q.textContent=Ie),Ht=a(t),H=m(t,"UL",{"data-svelte-h":!0}),p(H)!=="svelte-uos87p"&&(H.innerHTML=Xe),qt=a(t),q=m(t,"P",{"data-svelte-h":!0}),p(q)!=="svelte-mlr4c8"&&(q.textContent=Re),Nt=a(t),r(N.$$.fragment,t),Yt=a(t),Y=m(t,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1e23zdv"&&(Y.textContent=Ve),Pt=a(t),P=m(t,"UL",{"data-svelte-h":!0}),p(P)!=="svelte-qd9drw"&&(P.innerHTML=Ge),St=a(t),S=m(t,"P",{"data-svelte-h":!0}),p(S)!=="svelte-gdaw37"&&(S.textContent=We),Dt=a(t),r(D.$$.fragment,t),At=a(t),A=m(t,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1eurwqt"&&(A.textContent=Le),Kt=a(t),K=m(t,"UL",{"data-svelte-h":!0}),p(K)!=="svelte-11pgdv5"&&(K.innerHTML=ze),Ot=a(t),O=m(t,"P",{"data-svelte-h":!0}),p(O)!=="svelte-7kr2c3"&&(O.innerHTML=Be),te=a(t),r(tt.$$.fragment,t),ee=a(t),et=m(t,"P",{"data-svelte-h":!0}),p(et)!=="svelte-1azdq78"&&(et.textContent=Ee),le=a(t),r(lt.$$.fragment,t),se=a(t),st=m(t,"P",{"data-svelte-h":!0}),p(st)!=="svelte-7k4v2z"&&(st.innerHTML=Fe),ne=a(t),r(nt.$$.fragment,t),ae=a(t),r(at.$$.fragment,t),ie=a(t),it=m(t,"P",{"data-svelte-h":!0}),p(it)!=="svelte-1n3gxv8"&&(it.textContent=Qe),me=a(t),mt=m(t,"UL",{"data-svelte-h":!0}),p(mt)!=="svelte-xrptst"&&(mt.innerHTML=He),pe=a(t),pt=m(t,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-df2xsd"&&(pt.innerHTML=qe),oe=a(t),r(ot.$$.fragment,t),re=a(t),rt=m(t,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-1azdq78"&&(rt.textContent=Ne),Je=a(t),r(Jt.$$.fragment,t),ce=a(t),ct=m(t,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-z2e3e4"&&(ct.innerHTML=Ye),Me=a(t),r(Mt.$$.fragment,t),ue=a(t),ut=m(t,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-573keg"&&(ut.innerHTML=Pe),de=a(t),gt=m(t,"P",{}),Se(gt).forEach(l),this.h()},h(){De(g,"name","hf:doc:metadata"),De(g,"content",ml)},m(t,e){sl(document.head,g),s(t,Tt,e),s(t,dt,e),s(t,ft,e),J(f,t,e),s(t,Ut,e),J(U,t,e),s(t,bt,e),s(t,b,e),s(t,yt,e),J(y,t,e),s(t,ht,e),s(t,h,e),s(t,$t,e),J($,t,e),s(t,wt,e),s(t,w,e),s(t,xt,e),s(t,x,e),s(t,jt,e),s(t,j,e),s(t,Ct,e),s(t,C,e),s(t,kt,e),J(k,t,e),s(t,vt,e),s(t,v,e),s(t,_t,e),J(_,t,e),s(t,Zt,e),s(t,Z,e),s(t,It,e),J(I,t,e),s(t,Xt,e),s(t,X,e),s(t,Rt,e),J(R,t,e),s(t,Vt,e),s(t,V,e),s(t,Gt,e),J(G,t,e),s(t,Wt,e),s(t,W,e),s(t,Lt,e),J(L,t,e),s(t,zt,e),s(t,z,e),s(t,Bt,e),s(t,B,e),s(t,Et,e),s(t,E,e),s(t,Ft,e),J(F,t,e),s(t,Qt,e),s(t,Q,e),s(t,Ht,e),s(t,H,e),s(t,qt,e),s(t,q,e),s(t,Nt,e),J(N,t,e),s(t,Yt,e),s(t,Y,e),s(t,Pt,e),s(t,P,e),s(t,St,e),s(t,S,e),s(t,Dt,e),J(D,t,e),s(t,At,e),s(t,A,e),s(t,Kt,e),s(t,K,e),s(t,Ot,e),s(t,O,e),s(t,te,e),J(tt,t,e),s(t,ee,e),s(t,et,e),s(t,le,e),J(lt,t,e),s(t,se,e),s(t,st,e),s(t,ne,e),J(nt,t,e),s(t,ae,e),J(at,t,e),s(t,ie,e),s(t,it,e),s(t,me,e),s(t,mt,e),s(t,pe,e),s(t,pt,e),s(t,oe,e),J(ot,t,e),s(t,re,e),s(t,rt,e),s(t,Je,e),J(Jt,t,e),s(t,ce,e),s(t,ct,e),s(t,Me,e),J(Mt,t,e),s(t,ue,e),s(t,ut,e),s(t,de,e),s(t,gt,e),ge=!0},p:Ke,i(t){ge||(c(f.$$.fragment,t),c(U.$$.fragment,t),c(y.$$.fragment,t),c($.$$.fragment,t),c(k.$$.fragment,t),c(_.$$.fragment,t),c(I.$$.fragment,t),c(R.$$.fragment,t),c(G.$$.fragment,t),c(L.$$.fragment,t),c(F.$$.fragment,t),c(N.$$.fragment,t),c(D.$$.fragment,t),c(tt.$$.fragment,t),c(lt.$$.fragment,t),c(nt.$$.fragment,t),c(at.$$.fragment,t),c(ot.$$.fragment,t),c(Jt.$$.fragment,t),c(Mt.$$.fragment,t),ge=!0)},o(t){M(f.$$.fragment,t),M(U.$$.fragment,t),M(y.$$.fragment,t),M($.$$.fragment,t),M(k.$$.fragment,t),M(_.$$.fragment,t),M(I.$$.fragment,t),M(R.$$.fragment,t),M(G.$$.fragment,t),M(L.$$.fragment,t),M(F.$$.fragment,t),M(N.$$.fragment,t),M(D.$$.fragment,t),M(tt.$$.fragment,t),M(lt.$$.fragment,t),M(nt.$$.fragment,t),M(at.$$.fragment,t),M(ot.$$.fragment,t),M(Jt.$$.fragment,t),M(Mt.$$.fragment,t),ge=!1},d(t){t&&(l(Tt),l(dt),l(ft),l(Ut),l(bt),l(b),l(yt),l(ht),l(h),l($t),l(wt),l(w),l(xt),l(x),l(jt),l(j),l(Ct),l(C),l(kt),l(vt),l(v),l(_t),l(Zt),l(Z),l(It),l(Xt),l(X),l(Rt),l(Vt),l(V),l(Gt),l(Wt),l(W),l(Lt),l(zt),l(z),l(Bt),l(B),l(Et),l(E),l(Ft),l(Qt),l(Q),l(Ht),l(H),l(qt),l(q),l(Nt),l(Yt),l(Y),l(Pt),l(P),l(St),l(S),l(Dt),l(At),l(A),l(Kt),l(K),l(Ot),l(O),l(te),l(ee),l(et),l(le),l(se),l(st),l(ne),l(ae),l(ie),l(it),l(me),l(mt),l(pe),l(pt),l(oe),l(re),l(rt),l(Je),l(ce),l(ct),l(Me),l(ue),l(ut),l(de),l(gt)),l(g),u(f,t),u(U,t),u(y,t),u($,t),u(k,t),u(_,t),u(I,t),u(R,t),u(G,t),u(L,t),u(F,t),u(N,t),u(D,t),u(tt,t),u(lt,t),u(nt,t),u(at,t),u(ot,t),u(Jt,t),u(Mt,t)}}}const ml='{"title":"用于推理的多语言模型","local":"用于推理的多语言模型","sections":[{"title":"XLM","local":"xlm","sections":[{"title":"带有语言嵌入的 XLM","local":"带有语言嵌入的-xlm","sections":[],"depth":3},{"title":"不带语言嵌入的 XLM","local":"不带语言嵌入的-xlm","sections":[],"depth":3}],"depth":2},{"title":"BERT","local":"bert","sections":[],"depth":2},{"title":"XLM-RoBERTa","local":"xlm-roberta","sections":[],"depth":2},{"title":"M2M100","local":"m2m100","sections":[],"depth":2},{"title":"MBart","local":"mbart","sections":[],"depth":2}],"depth":1}';function pl(Te){return Oe(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=nl}),[]}class ul extends tl{constructor(g){super(),el(this,g,pl,il,Ae,{})}}export{ul as component};
