import{s as ln,f as Pl,o as sn,n as Ol}from"../chunks/scheduler.9039eef2.js";import{S as nn,i as an,g as i,s as n,r as o,A as pn,h as p,f as l,c as a,j as tn,u,x as m,k as w,y as mn,a as s,v as r,d as c,t as M,w as d}from"../chunks/index.cdcc3d35.js";import{T as Kl}from"../chunks/Tip.6f74db41.js";import{C as b}from"../chunks/CodeBlock.e3ac94d9.js";import{H as h}from"../chunks/Heading.96ce3702.js";function on(G){let y,T="To apply optimized compute of Unet’s attention score, please configure your environment variable with <code>export NEURON_FUSE_SOFTMAX=1</code>.",f,g,j='Besides, don’t hesitate to tweak the compilation configuration to find the best tradeoff between performance v.s accuracy in your use case. By default, we suggest casting FP32 matrix multiplication operations to BF16 which offers good performance with moderate sacrifice of the accuracy. Check out the guide from <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/general/appnotes/neuronx-cc/neuronx-cc-training-mixed-precision.html#neuronx-cc-training-mixed-precision" rel="nofollow">AWS Neuron documentation</a> to better understand the options for your compilation.';return{c(){y=i("p"),y.innerHTML=T,f=n(),g=i("p"),g.innerHTML=j},l(J){y=p(J,"P",{"data-svelte-h":!0}),m(y)!=="svelte-6bhicj"&&(y.innerHTML=T),f=a(J),g=p(J,"P",{"data-svelte-h":!0}),m(g)!=="svelte-1dh7n4s"&&(g.innerHTML=j)},m(J,U){s(J,y,U),s(J,f,U),s(J,g,U)},p:Ol,d(J){J&&(l(y),l(f),l(g))}}}function un(G){let y,T="To avoid Neuron device out of memory, it’s suggested to finish all base inference and release the device memory before running the refiner.";return{c(){y=i("p"),y.textContent=T},l(f){y=p(f,"P",{"data-svelte-h":!0}),m(y)!=="svelte-1323ut2"&&(y.textContent=T)},m(f,g){s(f,y,g)},p:Ol,d(f){f&&l(y)}}}function rn(G){let y,T="Inf2 instances contain one or more Neuron devices, and each Neuron device includes 2 NeuronCore-v2. By default, we load the whole pipeline of LCM to both Neuron cores. It means that when the batch size is divisible by 2, you can fully leverage the compute power of both cores.";return{c(){y=i("p"),y.textContent=T},l(f){y=p(f,"P",{"data-svelte-h":!0}),m(y)!=="svelte-3zwean"&&(y.textContent=T)},m(f,g){s(f,y,g)},p:Ol,d(f){f&&l(y)}}}function cn(G){let y,T,f,g,j,J,U,rt,_,es='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/stable-diffusion/stable-diffusion-txt2img.ipynb" rel="nofollow">here</a></em>.',ct,V,ts="🤗 <code>Optimum</code> extends <code>Diffusers</code> to support inference on the second generation of Neuron devices(powering Trainium and Inferentia 2). It aims at inheriting the ease of Diffusers on Neuron.",Mt,$,ls='To get started, make sure you have <a href="../installation">configured your inf2 / trn1 instance</a>, and installed optimum:',dt,v,yt,N,ft,x,ss="To deploy models, you will need to compile them to TorchScript optimized for AWS Neuron. In the case of Stable Diffusion, there are four components which need to be exported to the <code>.neuron</code> format to boost the performance:",ht,R,ns="<li>Text encoder</li> <li>U-Net</li> <li>VAE encoder</li> <li>VAE decoder</li>",bt,k,as="You can either compile and export a Stable Diffusion Checkpoint via CLI or <code>NeuronStableDiffusionPipeline</code> class.",gt,S,is="<strong><em>Export via CLI</em></strong>",Jt,Y,ps="Here is an example of exporting stable diffusion components with <code>Optimum</code> CLI:",wt,L,Tt,H,ms="We recommend using a <code>inf2.8xlarge</code> or a larger instance for the model compilation. You will also be able to compile the model with the Optimum CLI on a CPU-only instance (needs ~35 GB memory), and then run the pre-compiled model on <code>inf2.xlarge</code> to reduce the expenses. In this case, don’t forget to disable validation of inference by adding the <code>--disable-validation</code> argument.",Ut,F,os="<strong><em>Export via Python API</em></strong>",jt,Q,us="Here is an example of exporting stable diffusion components with <code>NeuronStableDiffusionPipeline</code>:",Zt,X,Wt,z,It,E,Gt,q,rs="<code>NeuronStableDiffusionPipeline</code> class allows you to generate images from a text prompt on neuron devices similar to the experience with <code>Diffusers</code>.",Xt,A,cs="With pre-compiled Stable Diffusion models, now generate an image with a prompt on Neuron:",Ct,D,Bt,Z,Ms,_t,P,Vt,K,ds="With the <code>NeuronStableDiffusionImg2ImgPipeline</code> class, you can generate a new image conditioned on a text prompt and an initial image.",$t,O,vt,ee,ys='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="center">output</th> <th align="right"></th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/03-sd-img2img-init.png" alt="landscape photo" width="256" height="256"/></td> <td align="center"><strong><em>ghibli style, a fantasy landscape with snowcapped mountains, trees, lake with detailed reflection. warm colors, 8K</em></strong></td> <td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/04-sd-img2img.png" alt="drawing" width="250"/></td> <td align="right"></td></tr></tbody>',Nt,te,xt,le,fs="With the <code>NeuronStableDiffusionInpaintPipeline</code> class, you can edit specific parts of an image by providing a mask and a text prompt.",Rt,se,kt,ne,hs='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>mask_image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png" alt="drawing" width="250"/></td> <td align="center"><img src="https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>Face of a yellow cat, high resolution, sitting on a park bench</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/05-sd-inpaint.png" alt="drawing" width="250"/></td></tr></tbody>',St,ae,Yt,ie,bs='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/stable-diffusion/stable-diffusion-xl-txt2img.ipynb" rel="nofollow">here</a></em>.',Lt,pe,gs="Stable Diffusion XL (SDXL) is a latent diffusion model for text-to-image. Compared to the previous versions of Stable Diffusion models, it improves the quality of generated images with a times larger UNet.",Ht,me,Ft,oe,Js="To deploy SDXL models, we will also start by compiling the models. We support the export of following components in the pipeline to boost the speed:",Qt,ue,ws="<li>Text encoder</li> <li>Second text encoder</li> <li>U-Net (a three times larger UNet than the one in Stable Diffusion pipeline)</li> <li>VAE encoder</li> <li>VAE decoder</li>",zt,re,Ts="<strong><em>Export via CLI</em></strong>",Et,ce,Us="Here is an example of exporting SDXL components with <code>Optimum</code> CLI:",qt,Me,At,de,js="We recommend using a <code>inf2.8xlarge</code> or a larger instance for the model compilation. You will also be able to compile the model with Optimum CLI on a CPU-only instance (needs ~92 GB memory), and then run the pre-compiled models on <code>inf2.xlarge</code> to reduce the expenses. In this case, don’t forget to disable validation of inference by adding the <code>--disable-validation</code> argument.",Dt,ye,Zs="<strong><em>Export via Python API</em></strong>",Pt,fe,Ws="Here is an example of exporting stable diffusion components with <code>NeuronStableDiffusionXLPipeline</code>:",Kt,he,Ot,be,el,ge,Is="With pre-compiled SDXL models, now generate an image with a text prompt on Neuron:",tl,Je,ll,W,Gs,sl,we,nl,Te,Xs="With <code>NeuronStableDiffusionXLImg2ImgPipeline</code>, you can pass an initial image, and a text prompt to condition generated images:",al,Ue,il,je,Cs='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="center">output</th> <th align="right"></th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png" alt="castle photo" width="256" height="256"/></td> <td align="center"><strong><em>a dog running, lake, moat</em></strong></td> <td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/06-sdxl-img2img.png" alt="castle with dog" width="250"/></td> <td align="right"></td></tr></tbody>',pl,Ze,ml,We,Bs="With <code>NeuronStableDiffusionXLInpaintPipeline</code>, pass the original image and a mask of what you want to replace in the original image. Then replace the masked area with content described in a prompt.",ol,Ie,ul,Ge,_s='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>mask_image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png" alt="drawing" width="250"/></td> <td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>A deep sea diver floating</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/07-sdxl-inpaint.png" alt="drawing" width="250"/></td></tr></tbody>',rl,Xe,cl,Ce,Vs='SDXL includes a <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-refiner-1.0" rel="nofollow">refiner model</a> to denoise low-noise stage images generated from the base model. There are two ways to use the refiner:',Ml,Be,$s="<li>use the base and refiner model together to produce a refined image.</li> <li>use the base model to produce an image, and subsequently use the refiner model to add more details to the image.</li>",dl,_e,yl,Ve,fl,I,vs,hl,$e,bl,ve,gl,Ne,Ns='<thead><tr><th align="center"><code>Base Image</code></th> <th align="right">Refined Image</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/09-sdxl-base-full.png" alt="drawing" width="250"/></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/010-sdxl-refiner-detailed.png" alt="drawing" width="250"/></td></tr></tbody>',Jl,C,wl,xe,Tl,Re,xs='Latent Consistency Models (LCMs) were proposed in <a href="https://huggingface.co/papers/2310.04378" rel="nofollow">Latent Consistency Models: Synthesizing High-Resolution Images with Few-Step Inference by Simian Luo, Yiqin Tan, Longbo Huang, Jian Li, and Hang Zhao</a>. LCMs enable inference with fewer steps on any pre-trained LDMs, including Stable Diffusion and SDXL.',Ul,ke,Rs="In <code>optimum-neuron</code>, you can:",jl,Se,ks="<li>Use the class <code>NeuronLatentConsistencyModelPipeline</code> to compile and run inference of LCMs distilled from Stable Diffusion (SD) models.</li> <li>And continue to use the class <code>NeuronStableDiffusionXLPipeline</code> for LCMs distilled from SDXL models.</li>",Zl,Ye,Ss='Here are examples to compile the LCMs of Stable Diffusion ( <a href="https://huggingface.co/SimianLuo/LCM_Dreamshaper_v7" rel="nofollow">SimianLuo/LCM_Dreamshaper_v7</a> ) and Stable Diffusion XL( <a href="https://huggingface.co/latent-consistency/lcm-sdxl" rel="nofollow">latent-consistency/lcm-sdxl</a> ), and then run inference on AWS Inferentia 2 :',Wl,Le,Il,He,Ys="<strong><em>LCM of Stable Diffusion</em></strong>",Gl,Fe,Xl,Qe,Ls="<strong><em>LCM of Stable Diffusion XL</em></strong>",Cl,ze,Bl,Ee,_l,qe,Hs="Now we can generate images from text prompts on Inf2 using the pre-compiled model:",Vl,Ae,Fs="<strong><em>LCM of Stable Diffusion</em></strong>",$l,De,vl,Pe,Qs="<strong><em>LCM of Stable Diffusion XL</em></strong>",Nl,Ke,xl,Oe,Rl,et,zs='SDXL Turbo is an adversarial time-distilled Stable Diffusion XL (SDXL) model capable of running inference in as little as 1 step (<a href="https://huggingface.co/docs/diffusers/using-diffusers/sdxl_turbo" rel="nofollow">check <code>🤗diffusers</code> for more details</a>).',kl,tt,Es="In <code>optimum-neuron</code>, you can:",Sl,lt,qs="<li>Use the class <code>NeuronStableDiffusionXLPipeline</code> to compile and run inference.</li>",Yl,st,As='Here we will compile the <a href="https://huggingface.co/stabilityai/sdxl-turbo" rel="nofollow"><code>stabilityai/sdxl-turbo</code></a> model with Optimum CLI.',Ll,nt,Hl,at,Fl,it,Ql,pt,Ds="Now we can generate images from text prompts on Inf2 using the pre-compiled model:",zl,mt,El,B,ql,ot,Ps='Are there any other stable diffusion features that you want us to support in 🤗<code>Optimum-neuron</code>? Please file an issue to <a href="https://github.com/huggingface/optimum-neuron" rel="nofollow"><code>Optimum-neuron</code> Github repo</a> or discuss with us on <a href="https://discuss.huggingface.co/c/optimum/" rel="nofollow">HuggingFace’s community forum</a>, cheers 🤗 !',Al,ut,Dl;return j=new h({props:{title:"Generate images with Stable Diffusion models on AWS Inferentia",local:"generate-images-with-stable-diffusion-models-on-aws-inferentia",headingTag:"h1"}}),U=new h({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),v=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMm9wdGltdW0lNUJuZXVyb254JTJDJTIwZGlmZnVzZXJzJTVEJTIy",highlighted:'pip install <span class="hljs-string">&quot;optimum[neuronx, diffusers]&quot;</span>',wrap:!1}}),N=new h({props:{title:"Compile Stable Diffusion",local:"compile-stable-diffusion",headingTag:"h3"}}),L=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMS1iYXNlJTIwJTVDJTBBJTIwJTIwLS10YXNrJTIwc3RhYmxlLWRpZmZ1c2lvbiUyMCU1QyUwQSUyMCUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEElMjAlMjAtLWhlaWdodCUyMDUxMiUyMCU2MCUyMyUyMGhlaWdodCUyMGluJTIwcGl4ZWxzJTIwb2YlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyQyUyMGVnLiUyMDUxMiUyQyUyMDc2OCU2MCUyMCU1QyUwQSUyMCUyMC0td2lkdGglMjA1MTIlMjAlNjAlMjMlMjB3aWR0aCUyMGluJTIwcGl4ZWxzJTIwb2YlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyQyUyMGVnLiUyMDUxMiUyQyUyMDc2OCU2MCUyMCU1QyUwQSUyMCUyMC0tbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwNCUyMCU2MCUyMyUyMG51bWJlciUyMG9mJTIwaW1hZ2VzJTIwdG8lMjBnZW5lcmF0ZSUyMHBlciUyMHByb21wdCUyQyUyMGRlZmF1bHRzJTIwdG8lMjAxJTYwJTIwJTVDJTBBJTIwJTIwLS1hdXRvX2Nhc3QlMjBtYXRtdWwlMjAlNjAlMjMlMjBjYXN0JTIwb25seSUyMG1hdHJpeCUyMG11bHRpcGxpY2F0aW9uJTIwb3BlcmF0aW9ucyU2MCUyMCU1QyUwQSUyMCUyMC0tYXV0b19jYXN0X3R5cGUlMjBiZjE2JTIwJTYwJTIzJTIwY2FzdCUyMG9wZXJhdGlvbnMlMjBmcm9tJTIwRlAzMiUyMHRvJTIwQkYxNiU2MCUyMCU1QyUwQSUyMCUyMHNkX25ldXJvbiUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/stable-diffusion-2-1-base \\\n  --task stable-diffusion \\\n  --batch_size 1 \\\n  --height 512 `<span class="hljs-comment"># height in pixels of generated image, eg. 512, 768` \\</span>\n  --width 512 `<span class="hljs-comment"># width in pixels of generated image, eg. 512, 768` \\</span>\n  --num_images_per_prompt 4 `<span class="hljs-comment"># number of images to generate per prompt, defaults to 1` \\</span>\n  --auto_cast matmul `<span class="hljs-comment"># cast only matrix multiplication operations` \\</span>\n  --auto_cast_type bf16 `<span class="hljs-comment"># cast operations from FP32 to BF16` \\</span>\n  sd_neuron/',wrap:!1}}),X=new Kl({props:{$$slots:{default:[on]},$$scope:{ctx:G}}}),z=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMmF1dG9fY2FzdCUyMiUzQSUyMCUyMm1hdG11bCUyMiUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJTIyYmYxNiUyMiU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMCoqY29tcGlsZXJfYXJncyUyQyUyMCoqaW5wdXRfc2hhcGVzKSUwQSUwQXNhdmVfZGlyZWN0b3J5JTIwJTNEJTIwJTIyc2RfbmV1cm9uJTJGJTIyJTBBc3RhYmxlX2RpZmZ1c2lvbi5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBc3RhYmxlX2RpZmZ1c2lvbi5wdXNoX3RvX2h1YiglMEElMjAlMjAlMjAlMjBzYXZlX2RpcmVjdG9yeSUyQyUyMHJlcG9zaXRvcnlfaWQlM0QlMjJteS1uZXVyb24tcmVwbyUyMiUyQyUyMHVzZV9hdXRoX3Rva2VuJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion = NeuronStableDiffusionPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;sd_neuron/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion.push_to_hub(
<span class="hljs-meta">... </span>    save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),E=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),D=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbiUyRiUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBaW1hZ2UlMjAlM0QlMjBzdGFibGVfZGlmZnVzaW9uKHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion = NeuronStableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = stable_diffusion(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),P=new h({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),O=new b({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBJTIzJTIwY29tcGlsZSUyMCUyNiUyMHNhdmUlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMm5pdHJvc29ja2UlMkZHaGlibGktRGlmZnVzaW9uJTIyJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA1MTIlMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiU3RCUwQXBpcGVsaW5lJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmlucHV0X3NoYXBlcyklMEFwaXBlbGluZS5zYXZlX3ByZXRyYWluZWQoJTIyc2RfaW1nMmltZyUyRiUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEFpbml0X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbml0X2ltYWdlJTIwJTNEJTIwaW5pdF9pbWFnZS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyZ2hpYmxpJTIwc3R5bGUlMkMlMjBhJTIwZmFudGFzeSUyMGxhbmRzY2FwZSUyMHdpdGglMjBzbm93Y2FwcGVkJTIwbW91bnRhaW5zJTJDJTIwdHJlZXMlMkMlMjBsYWtlJTIwd2l0aCUyMGRldGFpbGVkJTIwcmVmbGVjdGlvbi4lMjBzdW5saWdodCUyMGFuZCUyMGNsb3VkJTIwaW4lMjB0aGUlMjBza3klMkMlMjB3YXJtJTIwY29sb3JzJTJDJTIwOEslMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC43NSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENy41KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJmYW50YXN5X2xhbmRzY2FwZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionImg2ImgPipeline

<span class="hljs-comment"># compile &amp; save</span>
model_id = <span class="hljs-string">&quot;nitrosocke/Ghibli-Diffusion&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}
pipeline = NeuronStableDiffusionImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes)
pipeline.save_pretrained(<span class="hljs-string">&quot;sd_img2img/&quot;</span>)

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;ghibli style, a fantasy landscape with snowcapped mountains, trees, lake with detailed reflection. sunlight and cloud in the sky, warm colors, 8K&quot;</span>

image = pipeline(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),te=new h({props:{title:"Inpaint",local:"inpaint",headingTag:"h3"}}),se=new b({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEFwaXBlbGluZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlJTJDJTIwKippbnB1dF9zaGFwZXMpJTBBcGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMnNkX2lucGFpbnQlMkYlMjIpJTBBJTBBZGVmJTIwZG93bmxvYWRfaW1hZ2UodXJsKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1by5wbmclMjIlMEFtYXNrX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvX21hc2sucG5nJTIyJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGRvd25sb2FkX2ltYWdlKGltZ191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEFtYXNrX2ltYWdlJTIwJTNEJTIwZG93bmxvYWRfaW1hZ2UobWFza191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJGYWNlJTIwb2YlMjBhJTIweWVsbG93JTIwY2F0JTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBzaXR0aW5nJTIwb24lMjBhJTIwcGFyayUyMGJlbmNoJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyY2F0X29uX2JlbmNoLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionInpaintPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}
pipeline = NeuronStableDiffusionInpaintPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes)
pipeline.save_pretrained(<span class="hljs-string">&quot;sd_inpaint/&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat_on_bench.png&quot;</span>)`,wrap:!1}}),ae=new h({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),me=new h({props:{title:"Compile Stable Diffusion XL",local:"compile-stable-diffusion-xl",headingTag:"h3"}}),Me=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIwJTVDJTBBJTIwJTIwLS10YXNrJTIwc3RhYmxlLWRpZmZ1c2lvbi14bCUyMCU1QyUwQSUyMCUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEElMjAlMjAtLWhlaWdodCUyMDEwMjQlMjAlNjAlMjMlMjBoZWlnaHQlMjBpbiUyMHBpeGVscyUyMG9mJTIwZ2VuZXJhdGVkJTIwaW1hZ2UlMkMlMjBlZy4lMjA3NjglMkMlMjAxMDI0JTYwJTIwJTVDJTBBJTIwJTIwLS13aWR0aCUyMDEwMjQlMjAlNjAlMjMlMjB3aWR0aCUyMGluJTIwcGl4ZWxzJTIwb2YlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyQyUyMGVnLiUyMDc2OCUyQyUyMDEwMjQlNjAlMjAlNUMlMEElMjAlMjAtLW51bV9pbWFnZXNfcGVyX3Byb21wdCUyMDQlMjAlNjAlMjMlMjBudW1iZXIlMjBvZiUyMGltYWdlcyUyMHRvJTIwZ2VuZXJhdGUlMjBwZXIlMjBwcm9tcHQlMkMlMjBkZWZhdWx0cyUyMHRvJTIwMSU2MCUyMCU1QyUwQSUyMCUyMC0tYXV0b19jYXN0JTIwbWF0bXVsJTIwJTYwJTIzJTIwY2FzdCUyMG9ubHklMjBtYXRyaXglMjBtdWx0aXBsaWNhdGlvbiUyMG9wZXJhdGlvbnMlNjAlMjAlNUMlMEElMjAlMjAtLWF1dG9fY2FzdF90eXBlJTIwYmYxNiUyMCU2MCUyMyUyMGNhc3QlMjBvcGVyYXRpb25zJTIwZnJvbSUyMEZQMzIlMjB0byUyMEJGMTYlNjAlMjAlNUMlMEElMjAlMjBzZF9uZXVyb25feGwlMkY=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/stable-diffusion-xl-base-1.0 \\\n  --task stable-diffusion-xl \\\n  --batch_size 1 \\\n  --height 1024 `<span class="hljs-comment"># height in pixels of generated image, eg. 768, 1024` \\</span>\n  --width 1024 `<span class="hljs-comment"># width in pixels of generated image, eg. 768, 1024` \\</span>\n  --num_images_per_prompt 4 `<span class="hljs-comment"># number of images to generate per prompt, defaults to 1` \\</span>\n  --auto_cast matmul `<span class="hljs-comment"># cast only matrix multiplication operations` \\</span>\n  --auto_cast_type bf16 `<span class="hljs-comment"># cast operations from FP32 to BF16` \\</span>\n  sd_neuron_xl/',wrap:!1}}),he=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMmF1dG9fY2FzdCUyMiUzQSUyMCUyMm1hdG11bCUyMiUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJTIyYmYxNiUyMiU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCU3RCUwQSUwQXN0YWJsZV9kaWZmdXNpb25feGwlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyklMEElMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMnNkX25ldXJvbl94bCUyRiUyMiUwQXN0YWJsZV9kaWZmdXNpb25feGwuc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5KSUwQXN0YWJsZV9kaWZmdXNpb25feGwucHVzaF90b19odWIoJTBBJTIwJTIwJTIwJTIwc2F2ZV9kaXJlY3RvcnklMkMlMjByZXBvc2l0b3J5X2lkJTNEJTIybXktbmV1cm9uLXJlcG8lMjIlMkMlMjB1c2VfYXV0aF90b2tlbiUzRFRydWUlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl = NeuronStableDiffusionXLPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl.push_to_hub(
<span class="hljs-meta">... </span>    save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),be=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),Je=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXN0YWJsZV9kaWZmdXNpb25feGwlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwc3RhYmxlX2RpZmZ1c2lvbl94bChwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = stable_diffusion_xl(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),we=new h({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),Ue=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBkb2clMjBydW5uaW5nJTJDJTIwbGFrZSUyQyUyMG1vYXQlMjIlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZvcHRpbXVtJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmludGVsJTJGb3BlbnZpbm8lMkZzZF94bCUyRmNhc3RsZV9mcmllZHJpY2gucG5nJTIyJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbl94bCUyRiUyMiklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

prompt = <span class="hljs-string">&quot;a dog running, lake, moat&quot;</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png&quot;</span>
init_image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

pipe = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ze=new h({props:{title:"Inpaint",local:"inpaint",headingTag:"h3"}}),Ie=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbnBhaW50UGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzZHhsLXRleHQyaW1nLnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnNkeGwtaW5wYWludC1tYXNrLnBuZyUyMiUwQSklMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWdfdXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGRlZXAlMjBzZWElMjBkaXZlciUyMGZsb2F0aW5nJTIyJTBBJTBBcGlwZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW5wYWludFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjg1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxMi41KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png&quot;</span>
mask_url = (
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png&quot;</span>
)

init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
prompt = <span class="hljs-string">&quot;A deep sea diver floating&quot;</span>

pipe = NeuronStableDiffusionXLInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = pipe(prompt=prompt, image=init_image, mask_image=mask_image, strength=<span class="hljs-number">0.85</span>, guidance_scale=<span class="hljs-number">12.5</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Xe=new h({props:{title:"Refine Image Quality",local:"refine-image-quality",headingTag:"h3"}}),_e=new h({props:{title:"Base + refiner model",local:"base--refiner-model",headingTag:"h4"}}),Ve=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQWJhc2UlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCUzRG51bV9pbWFnZXNfcGVyX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0MCUyQyUwQSUyMCUyMCUyMCUyMGRlbm9pc2luZ19lbmQlM0QwLjglMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMiUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWRlbCUyMGJhc2UlMjAlMjAlMjMlMjBUbyUyMGF2b2lkJTIwbmV1cm9uJTIwZGV2aWNlJTIwT09NJTBBJTBBcmVmaW5lciUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGxfcmVmaW5lciUyRiUyMiklMEFpbWFnZSUyMCUzRCUyMHJlZmluZXIoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQwJTJDJTBBJTIwJTIwJTIwJTIwZGVub2lzaW5nX3N0YXJ0JTNEMC44JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline, NeuronStableDiffusionXLImg2ImgPipeline

prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>
base = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = base(
    prompt=prompt,
    num_images_per_prompt=num_images_per_prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_end=<span class="hljs-number">0.8</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images[<span class="hljs-number">0</span>]
<span class="hljs-keyword">del</span> base  <span class="hljs-comment"># To avoid neuron device OOM</span>

refiner = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl_refiner/&quot;</span>)
image = refiner(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_start=<span class="hljs-number">0.8</span>,
    image=image,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),$e=new h({props:{title:"Base to refiner model",local:"base-to-refiner-model",headingTag:"h4"}}),ve=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQWJhc2UlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKHByb21wdCUzRHByb21wdCUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVEJTBBZGVsJTIwYmFzZSUyMCUyMCUyMyUyMFRvJTIwYXZvaWQlMjBuZXVyb24lMjBkZXZpY2UlMjBPT00lMEElMEFyZWZpbmVyJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbl94bF9yZWZpbmVyJTJGJTIyKSUwQWltYWdlJTIwJTNEJTIwcmVmaW5lcihwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlJTVCTm9uZSUyQyUyMCUzQSU1RCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline, NeuronStableDiffusionXLImg2ImgPipeline

prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>
base = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = base(prompt=prompt, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-keyword">del</span> base  <span class="hljs-comment"># To avoid neuron device OOM</span>

refiner = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl_refiner/&quot;</span>)
image = refiner(prompt=prompt, image=image[<span class="hljs-literal">None</span>, :]).images[<span class="hljs-number">0</span>]`,wrap:!1}}),C=new Kl({props:{$$slots:{default:[un]},$$scope:{ctx:G}}}),xe=new h({props:{title:"Latent Consistency Models",local:"latent-consistency-models",headingTag:"h2"}}),Le=new h({props:{title:"Compile LCM",local:"compile-lcm",headingTag:"h3"}}),Fe=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJTaW1pYW5MdW8lMkZMQ01fRHJlYW1zaGFwZXJfdjclMjIlMEFudW1faW1hZ2VzX3Blcl9wcm9tcHQlMjAlM0QlMjAxJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA3NjglMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDc2OCUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCU3RCUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJhdXRvX2Nhc3QlMjIlM0ElMjAlMjJtYXRtdWwlMjIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCUyMmJmMTYlMjIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyUwQSklMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMmxjbV9zZF9uZXVyb24lMkYlMjIlMEFzdGFibGVfZGlmZnVzaW9uLnNhdmVfcHJldHJhaW5lZChzYXZlX2RpcmVjdG9yeSklMEElMEElMjMlMjBQdXNoJTIwdG8lMjBodWIlMEFzdGFibGVfZGlmZnVzaW9uLnB1c2hfdG9faHViKHNhdmVfZGlyZWN0b3J5JTJDJTIwcmVwb3NpdG9yeV9pZCUzRCUyMm15LW5ldXJvbi1yZXBvJTIyJTJDJTIwdXNlX2F1dGhfdG9rZW4lM0RUcnVlKSUyMCUyMCUyMyUyMFJlcGxhY2UlMjB3aXRoJTIweW91ciUyMHJlcG8lMjBpZCUyQyUyMGVnLiUyMCUyMkppbmd5YSUyRkxDTV9EcmVhbXNoYXBlcl92N19uZXVyb254JTIy",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronLatentConsistencyModelPipeline

model_id = <span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>
num_images_per_prompt = <span class="hljs-number">1</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">768</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">768</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: num_images_per_prompt}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

stable_diffusion = NeuronLatentConsistencyModelPipeline.from_pretrained(
    model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes
)
save_directory = <span class="hljs-string">&quot;lcm_sd_neuron/&quot;</span>
stable_diffusion.save_pretrained(save_directory)

<span class="hljs-comment"># Push to hub</span>
stable_diffusion.push_to_hub(save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)  <span class="hljs-comment"># Replace with your repo id, eg. &quot;Jingya/LCM_Dreamshaper_v7_neuronx&quot;</span>`,wrap:!1}}),ze=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBdW5ldF9pZCUyMCUzRCUyMCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1zZHhsJTIyJTBBbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwJTNEJTIwMSUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCU3RCUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJhdXRvX2Nhc3QlMjIlM0ElMjAlMjJtYXRtdWwlMjIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCUyMmJmMTYlMjIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjB1bmV0X2lkJTNEdW5ldF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyUwQSklMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMmxjbV9zZHhsX25ldXJvbiUyRiUyMiUwQXN0YWJsZV9kaWZmdXNpb24uc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5KSUwQSUwQSUyMyUyMFB1c2glMjB0byUyMGh1YiUwQXN0YWJsZV9kaWZmdXNpb24ucHVzaF90b19odWIoc2F2ZV9kaXJlY3RvcnklMkMlMjByZXBvc2l0b3J5X2lkJTNEJTIybXktbmV1cm9uLXJlcG8lMjIlMkMlMjB1c2VfYXV0aF90b2tlbiUzRFRydWUpJTIwJTIwJTIwJTIzJTIwUmVwbGFjZSUyMHdpdGglMjB5b3VyJTIwcmVwbyUyMGlkJTJDJTIwZWcuJTIwJTIySmluZ3lhJTJGbGNtLXNkeGwtbmV1cm9ueCUyMg==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
unet_id = <span class="hljs-string">&quot;latent-consistency/lcm-sdxl&quot;</span>
num_images_per_prompt = <span class="hljs-number">1</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: num_images_per_prompt}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

stable_diffusion = NeuronStableDiffusionXLPipeline.from_pretrained(
    model_id, unet_id=unet_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes
)
save_directory = <span class="hljs-string">&quot;lcm_sdxl_neuron/&quot;</span>
stable_diffusion.save_pretrained(save_directory)

<span class="hljs-comment"># Push to hub</span>
stable_diffusion.push_to_hub(save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)   <span class="hljs-comment"># Replace with your repo id, eg. &quot;Jingya/lcm-sdxl-neuronx&quot;</span>`,wrap:!1}}),Ee=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),De=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyME5ldXJvbkxhdGVudENvbnNpc3RlbmN5TW9kZWxQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIySmluZ3lhJTJGTENNX0RyZWFtc2hhcGVyX3Y3X25ldXJvbnglMjIpJTBBcHJvbXB0cyUyMCUzRCUyMCU1QiUyMlNlbGYtcG9ydHJhaXQlMjBvaWwlMjBwYWludGluZyUyQyUyMGElMjBiZWF1dGlmdWwlMjBjeWJvcmclMjB3aXRoJTIwZ29sZGVuJTIwaGFpciUyQyUyMDhrJTIyJTVEJTIwKiUyMDIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdHMlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronLatentConsistencyModelPipeline

pipe = NeuronLatentConsistencyModelPipeline.from_pretrained(<span class="hljs-string">&quot;Jingya/LCM_Dreamshaper_v7_neuronx&quot;</span>)
prompts = [<span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompts, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),Ke=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJKaW5neWElMkZsY20tc2R4bC1uZXVyb254JTIyKSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMjJhJTIwY2xvc2UtdXAlMjBwaWN0dXJlJTIwb2YlMjBhbiUyMG9sZCUyMG1hbiUyMHN0YW5kaW5nJTIwaW4lMjB0aGUlMjByYWluJTIyJTVEJTIwKiUyMDIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdHMlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

pipe = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;Jingya/lcm-sdxl-neuronx&quot;</span>)
prompts = [<span class="hljs-string">&quot;a close-up picture of an old man standing in the rain&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompts, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),Oe=new h({props:{title:"Stable Diffusion XL Turbo",local:"stable-diffusion-xl-turbo",headingTag:"h2"}}),nt=new h({props:{title:"Compile SDXL Turbo",local:"compile-sdxl-turbo",headingTag:"h3"}}),at=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzZHhsLXR1cmJvJTIwLS10YXNrJTIwc3RhYmxlLWRpZmZ1c2lvbi14bCUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAtLWhlaWdodCUyMDUxMiUyMC0td2lkdGglMjA1MTIlMjAtLWF1dG9fY2FzdCUyMG1hdG11bCUyMC0tYXV0b19jYXN0X3R5cGUlMjBiZjE2JTIwc2R4bF90dXJib19uZXVyb24lMkY=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/sdxl-turbo --task stable-diffusion-xl --batch_size 1 --height 512 --width 512 --auto_cast matmul --auto_cast_type bf16 sdxl_turbo_neuron/',wrap:!1}}),it=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),mt=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZHhsX3R1cmJvX25ldXJvbiUyRiUyMiUyQyUyMGRhdGFfcGFyYWxsZWxfbW9kZSUzRCUyMmFsbCUyMiklMEFwcm9tcHQlMjAlM0QlMjAlNUIlMjJTZWxmLXBvcnRyYWl0JTIwb2lsJTIwcGFpbnRpbmclMkMlMjBhJTIwYmVhdXRpZnVsJTIwY3lib3JnJTIwd2l0aCUyMGdvbGRlbiUyMGhhaXIlMkMlMjA4ayUyMiU1RCUyMColMjAyJTBBJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAuMCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

pipe = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sdxl_turbo_neuron/&quot;</span>, data_parallel_mode=<span class="hljs-string">&quot;all&quot;</span>)
prompt = [<span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">0.0</span>, num_inference_steps=<span class="hljs-number">1</span>).images`,wrap:!1}}),B=new Kl({props:{$$slots:{default:[rn]},$$scope:{ctx:G}}}),{c(){y=i("meta"),T=n(),f=i("p"),g=n(),o(j.$$.fragment),J=n(),o(U.$$.fragment),rt=n(),_=i("p"),_.innerHTML=es,ct=n(),V=i("p"),V.innerHTML=ts,Mt=n(),$=i("p"),$.innerHTML=ls,dt=n(),o(v.$$.fragment),yt=n(),o(N.$$.fragment),ft=n(),x=i("p"),x.innerHTML=ss,ht=n(),R=i("ul"),R.innerHTML=ns,bt=n(),k=i("p"),k.innerHTML=as,gt=n(),S=i("p"),S.innerHTML=is,Jt=n(),Y=i("p"),Y.innerHTML=ps,wt=n(),o(L.$$.fragment),Tt=n(),H=i("p"),H.innerHTML=ms,Ut=n(),F=i("p"),F.innerHTML=os,jt=n(),Q=i("p"),Q.innerHTML=us,Zt=n(),o(X.$$.fragment),Wt=n(),o(z.$$.fragment),It=n(),o(E.$$.fragment),Gt=n(),q=i("p"),q.innerHTML=rs,Xt=n(),A=i("p"),A.textContent=cs,Ct=n(),o(D.$$.fragment),Bt=n(),Z=i("img"),_t=n(),o(P.$$.fragment),Vt=n(),K=i("p"),K.innerHTML=ds,$t=n(),o(O.$$.fragment),vt=n(),ee=i("table"),ee.innerHTML=ys,Nt=n(),o(te.$$.fragment),xt=n(),le=i("p"),le.innerHTML=fs,Rt=n(),o(se.$$.fragment),kt=n(),ne=i("table"),ne.innerHTML=hs,St=n(),o(ae.$$.fragment),Yt=n(),ie=i("p"),ie.innerHTML=bs,Lt=n(),pe=i("p"),pe.textContent=gs,Ht=n(),o(me.$$.fragment),Ft=n(),oe=i("p"),oe.textContent=Js,Qt=n(),ue=i("ul"),ue.innerHTML=ws,zt=n(),re=i("p"),re.innerHTML=Ts,Et=n(),ce=i("p"),ce.innerHTML=Us,qt=n(),o(Me.$$.fragment),At=n(),de=i("p"),de.innerHTML=js,Dt=n(),ye=i("p"),ye.innerHTML=Zs,Pt=n(),fe=i("p"),fe.innerHTML=Ws,Kt=n(),o(he.$$.fragment),Ot=n(),o(be.$$.fragment),el=n(),ge=i("p"),ge.textContent=Is,tl=n(),o(Je.$$.fragment),ll=n(),W=i("img"),sl=n(),o(we.$$.fragment),nl=n(),Te=i("p"),Te.innerHTML=Xs,al=n(),o(Ue.$$.fragment),il=n(),je=i("table"),je.innerHTML=Cs,pl=n(),o(Ze.$$.fragment),ml=n(),We=i("p"),We.innerHTML=Bs,ol=n(),o(Ie.$$.fragment),ul=n(),Ge=i("table"),Ge.innerHTML=_s,rl=n(),o(Xe.$$.fragment),cl=n(),Ce=i("p"),Ce.innerHTML=Vs,Ml=n(),Be=i("ol"),Be.innerHTML=$s,dl=n(),o(_e.$$.fragment),yl=n(),o(Ve.$$.fragment),fl=n(),I=i("img"),hl=n(),o($e.$$.fragment),bl=n(),o(ve.$$.fragment),gl=n(),Ne=i("table"),Ne.innerHTML=Ns,Jl=n(),o(C.$$.fragment),wl=n(),o(xe.$$.fragment),Tl=n(),Re=i("p"),Re.innerHTML=xs,Ul=n(),ke=i("p"),ke.innerHTML=Rs,jl=n(),Se=i("ul"),Se.innerHTML=ks,Zl=n(),Ye=i("p"),Ye.innerHTML=Ss,Wl=n(),o(Le.$$.fragment),Il=n(),He=i("p"),He.innerHTML=Ys,Gl=n(),o(Fe.$$.fragment),Xl=n(),Qe=i("p"),Qe.innerHTML=Ls,Cl=n(),o(ze.$$.fragment),Bl=n(),o(Ee.$$.fragment),_l=n(),qe=i("p"),qe.textContent=Hs,Vl=n(),Ae=i("p"),Ae.innerHTML=Fs,$l=n(),o(De.$$.fragment),vl=n(),Pe=i("p"),Pe.innerHTML=Qs,Nl=n(),o(Ke.$$.fragment),xl=n(),o(Oe.$$.fragment),Rl=n(),et=i("p"),et.innerHTML=zs,kl=n(),tt=i("p"),tt.innerHTML=Es,Sl=n(),lt=i("ul"),lt.innerHTML=qs,Yl=n(),st=i("p"),st.innerHTML=As,Ll=n(),o(nt.$$.fragment),Hl=n(),o(at.$$.fragment),Fl=n(),o(it.$$.fragment),Ql=n(),pt=i("p"),pt.textContent=Ds,zl=n(),o(mt.$$.fragment),El=n(),o(B.$$.fragment),ql=n(),ot=i("p"),ot.innerHTML=Ps,Al=n(),ut=i("p"),this.h()},l(e){const t=pn("svelte-u9bgzb",document.head);y=p(t,"META",{name:!0,content:!0}),t.forEach(l),T=a(e),f=p(e,"P",{}),tn(f).forEach(l),g=a(e),u(j.$$.fragment,e),J=a(e),u(U.$$.fragment,e),rt=a(e),_=p(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-140c11v"&&(_.innerHTML=es),ct=a(e),V=p(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1g87d8z"&&(V.innerHTML=ts),Mt=a(e),$=p(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-1u4t7n7"&&($.innerHTML=ls),dt=a(e),u(v.$$.fragment,e),yt=a(e),u(N.$$.fragment,e),ft=a(e),x=p(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-3qllio"&&(x.innerHTML=ss),ht=a(e),R=p(e,"UL",{"data-svelte-h":!0}),m(R)!=="svelte-1c1t3y0"&&(R.innerHTML=ns),bt=a(e),k=p(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-15y00oa"&&(k.innerHTML=as),gt=a(e),S=p(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1a2m8iq"&&(S.innerHTML=is),Jt=a(e),Y=p(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-ktaj8q"&&(Y.innerHTML=ps),wt=a(e),u(L.$$.fragment,e),Tt=a(e),H=p(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-jz092x"&&(H.innerHTML=ms),Ut=a(e),F=p(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-kxhd34"&&(F.innerHTML=os),jt=a(e),Q=p(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1bahy14"&&(Q.innerHTML=us),Zt=a(e),u(X.$$.fragment,e),Wt=a(e),u(z.$$.fragment,e),It=a(e),u(E.$$.fragment,e),Gt=a(e),q=p(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1r61oa5"&&(q.innerHTML=rs),Xt=a(e),A=p(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1q8fgqb"&&(A.textContent=cs),Ct=a(e),u(D.$$.fragment,e),Bt=a(e),Z=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),_t=a(e),u(P.$$.fragment,e),Vt=a(e),K=p(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-kqnotf"&&(K.innerHTML=ds),$t=a(e),u(O.$$.fragment,e),vt=a(e),ee=p(e,"TABLE",{"data-svelte-h":!0}),m(ee)!=="svelte-i6e2ex"&&(ee.innerHTML=ys),Nt=a(e),u(te.$$.fragment,e),xt=a(e),le=p(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-vhijyl"&&(le.innerHTML=fs),Rt=a(e),u(se.$$.fragment,e),kt=a(e),ne=p(e,"TABLE",{"data-svelte-h":!0}),m(ne)!=="svelte-v8z5s8"&&(ne.innerHTML=hs),St=a(e),u(ae.$$.fragment,e),Yt=a(e),ie=p(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-1q6nuso"&&(ie.innerHTML=bs),Lt=a(e),pe=p(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-7xctqf"&&(pe.textContent=gs),Ht=a(e),u(me.$$.fragment,e),Ft=a(e),oe=p(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-u4wwem"&&(oe.textContent=Js),Qt=a(e),ue=p(e,"UL",{"data-svelte-h":!0}),m(ue)!=="svelte-17e9k9s"&&(ue.innerHTML=ws),zt=a(e),re=p(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-1a2m8iq"&&(re.innerHTML=Ts),Et=a(e),ce=p(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-9niqj3"&&(ce.innerHTML=Us),qt=a(e),u(Me.$$.fragment,e),At=a(e),de=p(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-eias7g"&&(de.innerHTML=js),Dt=a(e),ye=p(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-kxhd34"&&(ye.innerHTML=Zs),Pt=a(e),fe=p(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-17tzr0c"&&(fe.innerHTML=Ws),Kt=a(e),u(he.$$.fragment,e),Ot=a(e),u(be.$$.fragment,e),el=a(e),ge=p(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-8q3qyn"&&(ge.textContent=Is),tl=a(e),u(Je.$$.fragment,e),ll=a(e),W=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),sl=a(e),u(we.$$.fragment,e),nl=a(e),Te=p(e,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-luub4o"&&(Te.innerHTML=Xs),al=a(e),u(Ue.$$.fragment,e),il=a(e),je=p(e,"TABLE",{"data-svelte-h":!0}),m(je)!=="svelte-1s0d0pv"&&(je.innerHTML=Cs),pl=a(e),u(Ze.$$.fragment,e),ml=a(e),We=p(e,"P",{"data-svelte-h":!0}),m(We)!=="svelte-11fbw00"&&(We.innerHTML=Bs),ol=a(e),u(Ie.$$.fragment,e),ul=a(e),Ge=p(e,"TABLE",{"data-svelte-h":!0}),m(Ge)!=="svelte-18741xe"&&(Ge.innerHTML=_s),rl=a(e),u(Xe.$$.fragment,e),cl=a(e),Ce=p(e,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-1usq821"&&(Ce.innerHTML=Vs),Ml=a(e),Be=p(e,"OL",{"data-svelte-h":!0}),m(Be)!=="svelte-6p4eqi"&&(Be.innerHTML=$s),dl=a(e),u(_e.$$.fragment,e),yl=a(e),u(Ve.$$.fragment,e),fl=a(e),I=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),hl=a(e),u($e.$$.fragment,e),bl=a(e),u(ve.$$.fragment,e),gl=a(e),Ne=p(e,"TABLE",{"data-svelte-h":!0}),m(Ne)!=="svelte-1s7g03c"&&(Ne.innerHTML=Ns),Jl=a(e),u(C.$$.fragment,e),wl=a(e),u(xe.$$.fragment,e),Tl=a(e),Re=p(e,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-1ud6a8q"&&(Re.innerHTML=xs),Ul=a(e),ke=p(e,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-1ayizu6"&&(ke.innerHTML=Rs),jl=a(e),Se=p(e,"UL",{"data-svelte-h":!0}),m(Se)!=="svelte-r4tdj0"&&(Se.innerHTML=ks),Zl=a(e),Ye=p(e,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-c4lhmw"&&(Ye.innerHTML=Ss),Wl=a(e),u(Le.$$.fragment,e),Il=a(e),He=p(e,"P",{"data-svelte-h":!0}),m(He)!=="svelte-1s0vvjb"&&(He.innerHTML=Ys),Gl=a(e),u(Fe.$$.fragment,e),Xl=a(e),Qe=p(e,"P",{"data-svelte-h":!0}),m(Qe)!=="svelte-51zp7x"&&(Qe.innerHTML=Ls),Cl=a(e),u(ze.$$.fragment,e),Bl=a(e),u(Ee.$$.fragment,e),_l=a(e),qe=p(e,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-1ebkvay"&&(qe.textContent=Hs),Vl=a(e),Ae=p(e,"P",{"data-svelte-h":!0}),m(Ae)!=="svelte-1s0vvjb"&&(Ae.innerHTML=Fs),$l=a(e),u(De.$$.fragment,e),vl=a(e),Pe=p(e,"P",{"data-svelte-h":!0}),m(Pe)!=="svelte-51zp7x"&&(Pe.innerHTML=Qs),Nl=a(e),u(Ke.$$.fragment,e),xl=a(e),u(Oe.$$.fragment,e),Rl=a(e),et=p(e,"P",{"data-svelte-h":!0}),m(et)!=="svelte-10h80ju"&&(et.innerHTML=zs),kl=a(e),tt=p(e,"P",{"data-svelte-h":!0}),m(tt)!=="svelte-1ayizu6"&&(tt.innerHTML=Es),Sl=a(e),lt=p(e,"UL",{"data-svelte-h":!0}),m(lt)!=="svelte-t7g18i"&&(lt.innerHTML=qs),Yl=a(e),st=p(e,"P",{"data-svelte-h":!0}),m(st)!=="svelte-ohwj0a"&&(st.innerHTML=As),Ll=a(e),u(nt.$$.fragment,e),Hl=a(e),u(at.$$.fragment,e),Fl=a(e),u(it.$$.fragment,e),Ql=a(e),pt=p(e,"P",{"data-svelte-h":!0}),m(pt)!=="svelte-1ebkvay"&&(pt.textContent=Ds),zl=a(e),u(mt.$$.fragment,e),El=a(e),u(B.$$.fragment,e),ql=a(e),ot=p(e,"P",{"data-svelte-h":!0}),m(ot)!=="svelte-xbi604"&&(ot.innerHTML=Ps),Al=a(e),ut=p(e,"P",{}),tn(ut).forEach(l),this.h()},h(){w(y,"name","hf:doc:metadata"),w(y,"content",Mn),Pl(Z.src,Ms="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/01-sd-image.png")||w(Z,"src",Ms),w(Z,"width","256"),w(Z,"height","256"),w(Z,"alt","stable diffusion generated image"),Pl(W.src,Gs="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/02-sdxl-image.jpeg")||w(W,"src",Gs),w(W,"width","256"),w(W,"height","256"),w(W,"alt","sdxl generated image"),Pl(I.src,vs="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/08-sdxl-base-refine.png")||w(I,"src",vs),w(I,"width","256"),w(I,"height","256"),w(I,"alt","sdxl base + refiner")},m(e,t){mn(document.head,y),s(e,T,t),s(e,f,t),s(e,g,t),r(j,e,t),s(e,J,t),r(U,e,t),s(e,rt,t),s(e,_,t),s(e,ct,t),s(e,V,t),s(e,Mt,t),s(e,$,t),s(e,dt,t),r(v,e,t),s(e,yt,t),r(N,e,t),s(e,ft,t),s(e,x,t),s(e,ht,t),s(e,R,t),s(e,bt,t),s(e,k,t),s(e,gt,t),s(e,S,t),s(e,Jt,t),s(e,Y,t),s(e,wt,t),r(L,e,t),s(e,Tt,t),s(e,H,t),s(e,Ut,t),s(e,F,t),s(e,jt,t),s(e,Q,t),s(e,Zt,t),r(X,e,t),s(e,Wt,t),r(z,e,t),s(e,It,t),r(E,e,t),s(e,Gt,t),s(e,q,t),s(e,Xt,t),s(e,A,t),s(e,Ct,t),r(D,e,t),s(e,Bt,t),s(e,Z,t),s(e,_t,t),r(P,e,t),s(e,Vt,t),s(e,K,t),s(e,$t,t),r(O,e,t),s(e,vt,t),s(e,ee,t),s(e,Nt,t),r(te,e,t),s(e,xt,t),s(e,le,t),s(e,Rt,t),r(se,e,t),s(e,kt,t),s(e,ne,t),s(e,St,t),r(ae,e,t),s(e,Yt,t),s(e,ie,t),s(e,Lt,t),s(e,pe,t),s(e,Ht,t),r(me,e,t),s(e,Ft,t),s(e,oe,t),s(e,Qt,t),s(e,ue,t),s(e,zt,t),s(e,re,t),s(e,Et,t),s(e,ce,t),s(e,qt,t),r(Me,e,t),s(e,At,t),s(e,de,t),s(e,Dt,t),s(e,ye,t),s(e,Pt,t),s(e,fe,t),s(e,Kt,t),r(he,e,t),s(e,Ot,t),r(be,e,t),s(e,el,t),s(e,ge,t),s(e,tl,t),r(Je,e,t),s(e,ll,t),s(e,W,t),s(e,sl,t),r(we,e,t),s(e,nl,t),s(e,Te,t),s(e,al,t),r(Ue,e,t),s(e,il,t),s(e,je,t),s(e,pl,t),r(Ze,e,t),s(e,ml,t),s(e,We,t),s(e,ol,t),r(Ie,e,t),s(e,ul,t),s(e,Ge,t),s(e,rl,t),r(Xe,e,t),s(e,cl,t),s(e,Ce,t),s(e,Ml,t),s(e,Be,t),s(e,dl,t),r(_e,e,t),s(e,yl,t),r(Ve,e,t),s(e,fl,t),s(e,I,t),s(e,hl,t),r($e,e,t),s(e,bl,t),r(ve,e,t),s(e,gl,t),s(e,Ne,t),s(e,Jl,t),r(C,e,t),s(e,wl,t),r(xe,e,t),s(e,Tl,t),s(e,Re,t),s(e,Ul,t),s(e,ke,t),s(e,jl,t),s(e,Se,t),s(e,Zl,t),s(e,Ye,t),s(e,Wl,t),r(Le,e,t),s(e,Il,t),s(e,He,t),s(e,Gl,t),r(Fe,e,t),s(e,Xl,t),s(e,Qe,t),s(e,Cl,t),r(ze,e,t),s(e,Bl,t),r(Ee,e,t),s(e,_l,t),s(e,qe,t),s(e,Vl,t),s(e,Ae,t),s(e,$l,t),r(De,e,t),s(e,vl,t),s(e,Pe,t),s(e,Nl,t),r(Ke,e,t),s(e,xl,t),r(Oe,e,t),s(e,Rl,t),s(e,et,t),s(e,kl,t),s(e,tt,t),s(e,Sl,t),s(e,lt,t),s(e,Yl,t),s(e,st,t),s(e,Ll,t),r(nt,e,t),s(e,Hl,t),r(at,e,t),s(e,Fl,t),r(it,e,t),s(e,Ql,t),s(e,pt,t),s(e,zl,t),r(mt,e,t),s(e,El,t),r(B,e,t),s(e,ql,t),s(e,ot,t),s(e,Al,t),s(e,ut,t),Dl=!0},p(e,[t]){const Ks={};t&2&&(Ks.$$scope={dirty:t,ctx:e}),X.$set(Ks);const Os={};t&2&&(Os.$$scope={dirty:t,ctx:e}),C.$set(Os);const en={};t&2&&(en.$$scope={dirty:t,ctx:e}),B.$set(en)},i(e){Dl||(c(j.$$.fragment,e),c(U.$$.fragment,e),c(v.$$.fragment,e),c(N.$$.fragment,e),c(L.$$.fragment,e),c(X.$$.fragment,e),c(z.$$.fragment,e),c(E.$$.fragment,e),c(D.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),c(me.$$.fragment,e),c(Me.$$.fragment,e),c(he.$$.fragment,e),c(be.$$.fragment,e),c(Je.$$.fragment,e),c(we.$$.fragment,e),c(Ue.$$.fragment,e),c(Ze.$$.fragment,e),c(Ie.$$.fragment,e),c(Xe.$$.fragment,e),c(_e.$$.fragment,e),c(Ve.$$.fragment,e),c($e.$$.fragment,e),c(ve.$$.fragment,e),c(C.$$.fragment,e),c(xe.$$.fragment,e),c(Le.$$.fragment,e),c(Fe.$$.fragment,e),c(ze.$$.fragment,e),c(Ee.$$.fragment,e),c(De.$$.fragment,e),c(Ke.$$.fragment,e),c(Oe.$$.fragment,e),c(nt.$$.fragment,e),c(at.$$.fragment,e),c(it.$$.fragment,e),c(mt.$$.fragment,e),c(B.$$.fragment,e),Dl=!0)},o(e){M(j.$$.fragment,e),M(U.$$.fragment,e),M(v.$$.fragment,e),M(N.$$.fragment,e),M(L.$$.fragment,e),M(X.$$.fragment,e),M(z.$$.fragment,e),M(E.$$.fragment,e),M(D.$$.fragment,e),M(P.$$.fragment,e),M(O.$$.fragment,e),M(te.$$.fragment,e),M(se.$$.fragment,e),M(ae.$$.fragment,e),M(me.$$.fragment,e),M(Me.$$.fragment,e),M(he.$$.fragment,e),M(be.$$.fragment,e),M(Je.$$.fragment,e),M(we.$$.fragment,e),M(Ue.$$.fragment,e),M(Ze.$$.fragment,e),M(Ie.$$.fragment,e),M(Xe.$$.fragment,e),M(_e.$$.fragment,e),M(Ve.$$.fragment,e),M($e.$$.fragment,e),M(ve.$$.fragment,e),M(C.$$.fragment,e),M(xe.$$.fragment,e),M(Le.$$.fragment,e),M(Fe.$$.fragment,e),M(ze.$$.fragment,e),M(Ee.$$.fragment,e),M(De.$$.fragment,e),M(Ke.$$.fragment,e),M(Oe.$$.fragment,e),M(nt.$$.fragment,e),M(at.$$.fragment,e),M(it.$$.fragment,e),M(mt.$$.fragment,e),M(B.$$.fragment,e),Dl=!1},d(e){e&&(l(T),l(f),l(g),l(J),l(rt),l(_),l(ct),l(V),l(Mt),l($),l(dt),l(yt),l(ft),l(x),l(ht),l(R),l(bt),l(k),l(gt),l(S),l(Jt),l(Y),l(wt),l(Tt),l(H),l(Ut),l(F),l(jt),l(Q),l(Zt),l(Wt),l(It),l(Gt),l(q),l(Xt),l(A),l(Ct),l(Bt),l(Z),l(_t),l(Vt),l(K),l($t),l(vt),l(ee),l(Nt),l(xt),l(le),l(Rt),l(kt),l(ne),l(St),l(Yt),l(ie),l(Lt),l(pe),l(Ht),l(Ft),l(oe),l(Qt),l(ue),l(zt),l(re),l(Et),l(ce),l(qt),l(At),l(de),l(Dt),l(ye),l(Pt),l(fe),l(Kt),l(Ot),l(el),l(ge),l(tl),l(ll),l(W),l(sl),l(nl),l(Te),l(al),l(il),l(je),l(pl),l(ml),l(We),l(ol),l(ul),l(Ge),l(rl),l(cl),l(Ce),l(Ml),l(Be),l(dl),l(yl),l(fl),l(I),l(hl),l(bl),l(gl),l(Ne),l(Jl),l(wl),l(Tl),l(Re),l(Ul),l(ke),l(jl),l(Se),l(Zl),l(Ye),l(Wl),l(Il),l(He),l(Gl),l(Xl),l(Qe),l(Cl),l(Bl),l(_l),l(qe),l(Vl),l(Ae),l($l),l(vl),l(Pe),l(Nl),l(xl),l(Rl),l(et),l(kl),l(tt),l(Sl),l(lt),l(Yl),l(st),l(Ll),l(Hl),l(Fl),l(Ql),l(pt),l(zl),l(El),l(ql),l(ot),l(Al),l(ut)),l(y),d(j,e),d(U,e),d(v,e),d(N,e),d(L,e),d(X,e),d(z,e),d(E,e),d(D,e),d(P,e),d(O,e),d(te,e),d(se,e),d(ae,e),d(me,e),d(Me,e),d(he,e),d(be,e),d(Je,e),d(we,e),d(Ue,e),d(Ze,e),d(Ie,e),d(Xe,e),d(_e,e),d(Ve,e),d($e,e),d(ve,e),d(C,e),d(xe,e),d(Le,e),d(Fe,e),d(ze,e),d(Ee,e),d(De,e),d(Ke,e),d(Oe,e),d(nt,e),d(at,e),d(it,e),d(mt,e),d(B,e)}}}const Mn='{"title":"Generate images with Stable Diffusion models on AWS Inferentia","local":"generate-images-with-stable-diffusion-models-on-aws-inferentia","sections":[{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"Compile Stable Diffusion","local":"compile-stable-diffusion","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Inpaint","local":"inpaint","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[{"title":"Compile Stable Diffusion XL","local":"compile-stable-diffusion-xl","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Inpaint","local":"inpaint","sections":[],"depth":3},{"title":"Refine Image Quality","local":"refine-image-quality","sections":[{"title":"Base + refiner model","local":"base--refiner-model","sections":[],"depth":4},{"title":"Base to refiner model","local":"base-to-refiner-model","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Latent Consistency Models","local":"latent-consistency-models","sections":[{"title":"Compile LCM","local":"compile-lcm","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL Turbo","local":"stable-diffusion-xl-turbo","sections":[{"title":"Compile SDXL Turbo","local":"compile-sdxl-turbo","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2}],"depth":1}';function dn(G){return sn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jn extends nn{constructor(y){super(),an(this,y,dn,cn,ln,{})}}export{Jn as component};
