# Pipeline parallelism

Accelerate supports pipeline parallelism for large-scale training with the PyTorch [torch.distributed.pipelining](https://pytorch.org/docs/stable/distributed.pipelining.html) API.

## prepare_pippy[[accelerate.prepare_pippy]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>accelerate.prepare_pippy</name><anchor>accelerate.prepare_pippy</anchor><source>https://github.com/huggingface/accelerate/blob/main/src/accelerate/inference.py#L126</source><parameters>[{"name": "model", "val": ""}, {"name": "split_points", "val": ": typing.Union[str, list[str], NoneType] = 'auto'"}, {"name": "no_split_module_classes", "val": ": typing.Optional[list[str]] = None"}, {"name": "example_args", "val": ": typing.Optional[tuple[typing.Any]] = ()"}, {"name": "example_kwargs", "val": ": typing.Optional[dict[str, typing.Any]] = None"}, {"name": "num_chunks", "val": ": typing.Optional[int] = None"}, {"name": "gather_output", "val": ": typing.Optional[bool] = False"}]</parameters><paramsdesc>- **model** (`torch.nn.Module`) --
  A model we want to split for pipeline-parallel inference
- **split_points** (`str` or `List[str]`, defaults to 'auto') --
  How to generate the split points and chunk the model across each GPU. 'auto' will find the best balanced
  split given any model. Should be a list of layer names in the model to split by otherwise.
- **no_split_module_classes** (`List[str]`) --
  A list of class names for layers we don't want to be split.
- **example_args** (tuple of model inputs) --
  The expected inputs for the model that uses order-based inputs for a *single process*. Recommended to use
  this method if possible.
- **example_kwargs** (dict of model inputs) --
  The expected inputs for the model that uses dictionary-based inputs for a *single process*. This is a
  *highly* limiting structure that requires the same keys be present at *all* inference calls. Not
  recommended unless the prior condition is true for all cases.
- **num_chunks** (`int`, defaults to the number of available GPUs) --
  The number of different stages the Pipeline will have. By default it will assign one chunk per GPU, but
  this can be tuned and played with. In general one should have num_chunks >= num_gpus.
- **gather_output** (`bool`, defaults to `False`) --
  If `True`, the output from the last GPU (which holds the true outputs) is sent across to all GPUs.</paramsdesc><paramgroups>0</paramgroups></docstring>

Wraps `model` for pipeline parallel inference.




</div>

<EditOnGithub source="https://github.com/huggingface/accelerate/blob/main/docs/source/package_reference/inference.md" />