# Launchers

Functions for launching training on distributed processes.

## notebook_launcher[[accelerate.notebook_launcher]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>accelerate.notebook_launcher</name><anchor>accelerate.notebook_launcher</anchor><source>https://github.com/huggingface/accelerate/blob/main/src/accelerate/launchers.py#L40</source><parameters>[{"name": "function", "val": ""}, {"name": "args", "val": " = ()"}, {"name": "num_processes", "val": " = None"}, {"name": "mixed_precision", "val": " = 'no'"}, {"name": "use_port", "val": " = '29500'"}, {"name": "master_addr", "val": " = '127.0.0.1'"}, {"name": "node_rank", "val": " = 0"}, {"name": "num_nodes", "val": " = 1"}, {"name": "rdzv_backend", "val": " = 'static'"}, {"name": "rdzv_endpoint", "val": " = ''"}, {"name": "rdzv_conf", "val": " = None"}, {"name": "rdzv_id", "val": " = 'none'"}, {"name": "max_restarts", "val": " = 0"}, {"name": "monitor_interval", "val": " = 0.1"}, {"name": "log_line_prefix_template", "val": " = None"}]</parameters><paramsdesc>- **function** (`Callable`) --
  The training function to execute. If it accepts arguments, the first argument should be the index of the
  process run.
- **args** (`Tuple`) --
  Tuple of arguments to pass to the function (it will receive `*args`).
- **num_processes** (`int`, *optional*) --
  The number of processes to use for training. Will default to 8 in Colab/Kaggle if a TPU is available, to
  the number of devices available otherwise.
- **mixed_precision** (`str`, *optional*, defaults to `"no"`) --
  If `fp16` or `bf16`, will use mixed precision training on multi-device.
- **use_port** (`str`, *optional*, defaults to `"29500"`) --
  The port to use to communicate between processes when launching a multi-device training.
- **master_addr** (`str`, *optional*, defaults to `"127.0.0.1"`) --
  The address to use for communication between processes.
- **node_rank** (`int`, *optional*, defaults to 0) --
  The rank of the current node.
- **num_nodes** (`int`, *optional*, defaults to 1) --
  The number of nodes to use for training.
- **rdzv_backend** (`str`, *optional*, defaults to `"static"`) --
  The rendezvous method to use, such as 'static' (the default) or 'c10d'
- **rdzv_endpoint** (`str`, *optional*, defaults to `""`) --
  The endpoint of the rdzv sync. storage.
- **rdzv_conf** (`Dict`, *optional*, defaults to `None`) --
  Additional rendezvous configuration.
- **rdzv_id** (`str`, *optional*, defaults to `"none"`) --
  The unique run id of the job.
- **max_restarts** (`int`, *optional*, defaults to 0) --
  The maximum amount of restarts that elastic agent will conduct on workers before failure.
- **monitor_interval** (`float`, *optional*, defaults to 0.1) --
  The interval in seconds that is used by the elastic_agent as a period of monitoring workers.
- **log_line_prefix_template** (`str`, *optional*, defaults to `None`) --
  The prefix template for elastic launch logging. Available from PyTorch 2.2.0.</paramsdesc><paramgroups>0</paramgroups></docstring>

Launches a training function, using several processes or multiple nodes if it's possible in the current environment
(TPU with multiple cores for instance).

<Tip warning={true}>

To use this function absolutely zero calls to a device must be made in the notebook session before calling. If any
have been made, you will need to restart the notebook and make sure no cells use any device capability.

Setting `ACCELERATE_DEBUG_MODE="1"` in your environment will run a test before truly launching to ensure that none
of those calls have been made.

</Tip>



<ExampleCodeBlock anchor="accelerate.notebook_launcher.example">

Example:

```python
# Assume this is defined in a Jupyter Notebook on an instance with two devices
from accelerate import notebook_launcher


def train(*args):
    # Your training function here
    ...


notebook_launcher(train, args=(arg1, arg2), num_processes=2, mixed_precision="fp16")
```

</ExampleCodeBlock>


</div>

## debug_launcher[[accelerate.debug_launcher]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>accelerate.debug_launcher</name><anchor>accelerate.debug_launcher</anchor><source>https://github.com/huggingface/accelerate/blob/main/src/accelerate/launchers.py#L273</source><parameters>[{"name": "function", "val": ""}, {"name": "args", "val": " = ()"}, {"name": "num_processes", "val": " = 2"}]</parameters><paramsdesc>- **function** (`Callable`) --
  The training function to execute.
- **args** (`Tuple`) --
  Tuple of arguments to pass to the function (it will receive `*args`).
- **num_processes** (`int`, *optional*, defaults to 2) --
  The number of processes to use for training.</paramsdesc><paramgroups>0</paramgroups></docstring>

Launches a training function using several processes on CPU for debugging purposes.

<Tip warning={true}>

This function is provided for internal testing and debugging, but it's not intended for real trainings. It will
only use the CPU.

</Tip>




</div>

<EditOnGithub source="https://github.com/huggingface/accelerate/blob/main/docs/source/package_reference/launchers.md" />