import{s as _e,f as Ie,n as $e,o as Le}from"../chunks/scheduler.37c15a92.js";import{S as Ee,i as He,g as i,s as l,r as z,A as Be,h as o,f as n,c as a,j as ke,u as Y,x as r,k as O,y as Ze,a as s,v as D,d as K,t as tt,w as et}from"../chunks/index.2bf4358c.js";import{C as Ae}from"../chunks/CodeBlock.4e987730.js";import{H as Qt}from"../chunks/Heading.8ada512a.js";import{E as Pe}from"../chunks/getInferenceSnippets.0aa3753f.js";function Se(zt){let p,lt,nt,at,d,it,u,Yt="<p>In this section, we explore the concrete steps an AI agent takes to interact with its environment.</p> <p>We’ll cover how actions are represented (using JSON or code), the importance of the stop and parse approach, and introduce different types of agents.</p>",ot,m,Ot="Actions are the concrete steps an <strong>AI agent takes to interact with its environment</strong>.",rt,f,Dt="Whether it’s browsing the web for information or controlling a physical device, each action is a deliberate operation executed by the agent.",pt,g,Kt="For example, an agent assisting with customer service might retrieve customer data, offer support articles, or transfer issues to a human representative.",ut,M,ct,y,te="There are multiple types of Agents that take actions differently:",ht,w,ee="<thead><tr><th>Type of Agent</th> <th>Description</th></tr></thead> <tbody><tr><td>JSON Agent</td> <td>The Action to take is specified in JSON format.</td></tr> <tr><td>Code Agent</td> <td>The Agent writes a code block that is interpreted externally.</td></tr> <tr><td>Function-calling Agent</td> <td>It is a subcategory of the JSON Agent which has been fine-tuned to generate a new message for each action.</td></tr></tbody>",dt,C,ne="Actions themselves can serve many purposes:",mt,v,se="<thead><tr><th>Type of Action</th> <th>Description</th></tr></thead> <tbody><tr><td>Information Gathering</td> <td>Performing web searches, querying databases, or retrieving documents.</td></tr> <tr><td>Tool Usage</td> <td>Making API calls, running calculations, and executing code.</td></tr> <tr><td>Environment Interaction</td> <td>Manipulating digital interfaces or controlling physical devices.</td></tr> <tr><td>Communication</td> <td>Engaging with users via chat or collaborating with other agents.</td></tr></tbody>",ft,T,le="The LLM only handles text and uses it to describe the action it wants to take and the parameters to supply to the tool. For an agent to work properly, the LLM must STOP generating new tokens after emitting all the tokens to define a complete Action. This passes control from the LLM back to the agent and ensures the result is parseable - whether the intended format is JSON, code, or function-calling.",gt,x,Mt,b,ae="One key method for implementing actions is the <strong>stop and parse approach</strong>. This method ensures that the agent’s output is structured and predictable:",yt,j,ie="<li><strong>Generation in a Structured Format</strong>:</li>",wt,U,oe="The agent outputs its intended action in a clear, predetermined format (JSON or code).",Ct,c,re="<li><strong>Halting Further Generation</strong>:</li>",vt,J,pe="Once the text defining the action has been emitted, <strong>the LLM stops generating additional tokens</strong>. This prevents extra or erroneous output.",Tt,h,ue="<li><strong>Parsing the Output</strong>:</li>",xt,k,ce="An external parser reads the formatted action, determines which Tool to call, and extracts the required parameters.",bt,A,he="For example, an agent needing to check the weather might output:",jt,_,Ut,I,de="The framework can then easily parse the name of the function to call and the arguments to apply.",Jt,$,me="This clear, machine-readable format minimizes errors and enables external tools to accurately process the agent’s command.",kt,L,fe=`Note: Function-calling agents operate similarly by structuring each action so that a designated function is invoked with the correct arguments.
We’ll dive deeper into those types of Agents in a future Unit.`,At,E,_t,H,ge=`An alternative approach is using <em>Code Agents</em>.
The idea is: <strong>instead of outputting a simple JSON object</strong>, a Code Agent generates an <strong>executable code block—typically in a high-level language like Python</strong>.`,It,B,Me,$t,Z,ye="This approach offers several advantages:",Lt,P,we="<li><strong>Expressiveness:</strong> Code can naturally represent complex logic, including loops, conditionals, and nested functions, providing greater flexibility than JSON.</li> <li><strong>Modularity and Reusability:</strong> Generated code can include functions and modules that are reusable across different actions or tasks.</li> <li><strong>Enhanced Debuggability:</strong> With a well-defined programming syntax, code errors are often easier to detect and correct.</li> <li><strong>Direct Integration:</strong> Code Agents can integrate directly with external libraries and APIs, enabling more complex operations such as data processing or real-time decision making.</li>",Et,S,Ce=`You must keep in mind that executing LLM-generated code may pose security risks, from prompt injection to the execution of harmful code.
That’s why it’s recommended to use AI agent frameworks like <code>smolagents</code> that integrate default safeguards.
If you want to know more about the risks and how to mitigate them, <a href="https://huggingface.co/docs/smolagents/tutorials/secure_code_execution" rel="nofollow">please have a look at this dedicated section</a>.`,Ht,G,ve="For example, a Code Agent tasked with fetching the weather might generate the following Python snippet:",Bt,q,Zt,F,Te="In this example, the Code Agent:",Pt,W,xe="<li>Retrieves weather data <strong>via an API call</strong>,</li> <li>Processes the response,</li> <li>And uses the print() function to output a final answer.</li>",St,N,be="This method <strong>also follows the stop and parse approach</strong> by clearly delimiting the code block and signaling when execution is complete (here, by printing the final_answer).",Gt,qt,Ft,R,je="We learned that Actions bridge an agent’s internal reasoning and its real-world interactions by executing clear, structured tasks—whether through JSON, code, or function calls.",Wt,V,Ue="This deliberate execution ensures that each action is precise and ready for external processing via the stop and parse approach. In the next section, we will explore Observations to see how agents capture and integrate feedback from their environment.",Nt,X,Je="After this, we will <strong>finally be ready to build our first Agent!</strong>",Rt,Q,Vt,st,Xt;return d=new Qt({props:{title:"Actions:  Enabling the Agent to Engage with Its Environment",local:"actions-enabling-the-agent-to-engage-with-its-environment",headingTag:"h1"}}),M=new Qt({props:{title:"Types of Agent Actions",local:"types-of-agent-actions",headingTag:"h2"}}),x=new Qt({props:{title:"The Stop and Parse Approach",local:"the-stop-and-parse-approach",headingTag:"h2"}}),_=new Ae({props:{code:"VGhvdWdodCUzQSUyMEklMjBuZWVkJTIwdG8lMjBjaGVjayUyMHRoZSUyMGN1cnJlbnQlMjB3ZWF0aGVyJTIwZm9yJTIwTmV3JTIwWW9yay4lMEFBY3Rpb24lMjAlM0ElMEElN0IlMEElMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjAlMjJnZXRfd2VhdGhlciUyMiUyQyUwQSUyMCUyMCUyMmFjdGlvbl9pbnB1dCUyMiUzQSUyMCU3QiUyMmxvY2F0aW9uJTIyJTNBJTIwJTIyTmV3JTIwWW9yayUyMiU3RCUwQSU3RA==",highlighted:`Thought<span class="hljs-punctuation">:</span> I need to check the current weather for New York.
Action <span class="hljs-punctuation">:</span>
<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_weather&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;action_input&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;New York&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),E=new Qt({props:{title:"Code Agents",local:"code-agents",headingTag:"h2"}}),q=new Ae({props:{code:"JTIzJTIwQ29kZSUyMEFnZW50JTIwRXhhbXBsZSUzQSUyMFJldHJpZXZlJTIwV2VhdGhlciUyMEluZm9ybWF0aW9uJTBBZGVmJTIwZ2V0X3dlYXRoZXIoY2l0eSklM0ElMEElMjAlMjAlMjAlMjBpbXBvcnQlMjByZXF1ZXN0cyUwQSUyMCUyMCUyMCUyMGFwaV91cmwlMjAlM0QlMjBmJTIyaHR0cHMlM0ElMkYlMkZhcGkud2VhdGhlci5jb20lMkZ2MSUyRmxvY2F0aW9uJTJGJTdCY2l0eSU3RCUzRmFwaUtleSUzRFlPVVJfQVBJX0tFWSUyMiUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KGFwaV91cmwpJTBBJTIwJTIwJTIwJTIwaWYlMjByZXNwb25zZS5zdGF0dXNfY29kZSUyMCUzRCUzRCUyMDIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGElMjAlM0QlMjByZXNwb25zZS5qc29uKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBkYXRhLmdldCglMjJ3ZWF0aGVyJTIyJTJDJTIwJTIyTm8lMjB3ZWF0aGVyJTIwaW5mb3JtYXRpb24lMjBhdmFpbGFibGUlMjIpJTBBJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMkVycm9yJTNBJTIwVW5hYmxlJTIwdG8lMjBmZXRjaCUyMHdlYXRoZXIlMjBkYXRhLiUyMiUwQSUwQSUyMyUyMEV4ZWN1dGUlMjB0aGUlMjBmdW5jdGlvbiUyMGFuZCUyMHByZXBhcmUlMjB0aGUlMjBmaW5hbCUyMGFuc3dlciUwQXJlc3VsdCUyMCUzRCUyMGdldF93ZWF0aGVyKCUyMk5ldyUyMFlvcmslMjIpJTBBZmluYWxfYW5zd2VyJTIwJTNEJTIwZiUyMlRoZSUyMGN1cnJlbnQlMjB3ZWF0aGVyJTIwaW4lMjBOZXclMjBZb3JrJTIwaXMlM0ElMjAlN0JyZXN1bHQlN0QlMjIlMEFwcmludChmaW5hbF9hbnN3ZXIp",highlighted:`<span class="hljs-comment"># Code Agent Example: Retrieve Weather Information</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather</span>(<span class="hljs-params">city</span>):
    <span class="hljs-keyword">import</span> requests
    api_url = <span class="hljs-string">f&quot;https://api.weather.com/v1/location/<span class="hljs-subst">{city}</span>?apiKey=YOUR_API_KEY&quot;</span>
    response = requests.get(api_url)
    <span class="hljs-keyword">if</span> response.status_code == <span class="hljs-number">200</span>:
        data = response.json()
        <span class="hljs-keyword">return</span> data.get(<span class="hljs-string">&quot;weather&quot;</span>, <span class="hljs-string">&quot;No weather information available&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Error: Unable to fetch weather data.&quot;</span>

<span class="hljs-comment"># Execute the function and prepare the final answer</span>
result = get_weather(<span class="hljs-string">&quot;New York&quot;</span>)
final_answer = <span class="hljs-string">f&quot;The current weather in New York is: <span class="hljs-subst">{result}</span>&quot;</span>
<span class="hljs-built_in">print</span>(final_answer)`,wrap:!1}}),Q=new Pe({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/actions.mdx"}}),{c(){p=i("meta"),lt=l(),nt=i("p"),at=l(),z(d.$$.fragment),it=l(),u=i("blockquote"),u.innerHTML=Yt,ot=l(),m=i("p"),m.innerHTML=Ot,rt=l(),f=i("p"),f.textContent=Dt,pt=l(),g=i("p"),g.textContent=Kt,ut=l(),z(M.$$.fragment),ct=l(),y=i("p"),y.textContent=te,ht=l(),w=i("table"),w.innerHTML=ee,dt=l(),C=i("p"),C.textContent=ne,mt=l(),v=i("table"),v.innerHTML=se,ft=l(),T=i("p"),T.textContent=le,gt=l(),z(x.$$.fragment),Mt=l(),b=i("p"),b.innerHTML=ae,yt=l(),j=i("ol"),j.innerHTML=ie,wt=l(),U=i("p"),U.textContent=oe,Ct=l(),c=i("ol"),c.innerHTML=re,vt=l(),J=i("p"),J.innerHTML=pe,Tt=l(),h=i("ol"),h.innerHTML=ue,xt=l(),k=i("p"),k.textContent=ce,bt=l(),A=i("p"),A.textContent=he,jt=l(),z(_.$$.fragment),Ut=l(),I=i("p"),I.textContent=de,Jt=l(),$=i("p"),$.textContent=me,kt=l(),L=i("p"),L.textContent=fe,At=l(),z(E.$$.fragment),_t=l(),H=i("p"),H.innerHTML=ge,It=l(),B=i("img"),$t=l(),Z=i("p"),Z.textContent=ye,Lt=l(),P=i("ul"),P.innerHTML=we,Et=l(),S=i("p"),S.innerHTML=Ce,Ht=l(),G=i("p"),G.textContent=ve,Bt=l(),z(q.$$.fragment),Zt=l(),F=i("p"),F.textContent=Te,Pt=l(),W=i("ul"),W.innerHTML=xe,St=l(),N=i("p"),N.innerHTML=be,Gt=l(),qt=i("hr"),Ft=l(),R=i("p"),R.textContent=je,Wt=l(),V=i("p"),V.textContent=Ue,Nt=l(),X=i("p"),X.innerHTML=Je,Rt=l(),z(Q.$$.fragment),Vt=l(),st=i("p"),this.h()},l(t){const e=Be("svelte-u9bgzb",document.head);p=o(e,"META",{name:!0,content:!0}),e.forEach(n),lt=a(t),nt=o(t,"P",{}),ke(nt).forEach(n),at=a(t),Y(d.$$.fragment,t),it=a(t),u=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(u)!=="svelte-z9840f"&&(u.innerHTML=Yt),ot=a(t),m=o(t,"P",{"data-svelte-h":!0}),r(m)!=="svelte-1d9hktj"&&(m.innerHTML=Ot),rt=a(t),f=o(t,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1tl5mip"&&(f.textContent=Dt),pt=a(t),g=o(t,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1ubetp8"&&(g.textContent=Kt),ut=a(t),Y(M.$$.fragment,t),ct=a(t),y=o(t,"P",{"data-svelte-h":!0}),r(y)!=="svelte-1wlcwgd"&&(y.textContent=te),ht=a(t),w=o(t,"TABLE",{"data-svelte-h":!0}),r(w)!=="svelte-3ls1cj"&&(w.innerHTML=ee),dt=a(t),C=o(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1xp7kgk"&&(C.textContent=ne),mt=a(t),v=o(t,"TABLE",{"data-svelte-h":!0}),r(v)!=="svelte-4604oy"&&(v.innerHTML=se),ft=a(t),T=o(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-172oujm"&&(T.textContent=le),gt=a(t),Y(x.$$.fragment,t),Mt=a(t),b=o(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-a9as0m"&&(b.innerHTML=ae),yt=a(t),j=o(t,"OL",{"data-svelte-h":!0}),r(j)!=="svelte-1nmidra"&&(j.innerHTML=ie),wt=a(t),U=o(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-l3tk2o"&&(U.textContent=oe),Ct=a(t),c=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(c)!=="svelte-j1mwkc"&&(c.innerHTML=re),vt=a(t),J=o(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1hxxesc"&&(J.innerHTML=pe),Tt=a(t),h=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(h)!=="svelte-w7r926"&&(h.innerHTML=ue),xt=a(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-191aaii"&&(k.textContent=ce),bt=a(t),A=o(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1exbnez"&&(A.textContent=he),jt=a(t),Y(_.$$.fragment,t),Ut=a(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1j4o5aq"&&(I.textContent=de),Jt=a(t),$=o(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1so9m39"&&($.textContent=me),kt=a(t),L=o(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1k8g2zy"&&(L.textContent=fe),At=a(t),Y(E.$$.fragment,t),_t=a(t),H=o(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-19f0lzf"&&(H.innerHTML=ge),It=a(t),B=o(t,"IMG",{src:!0,alt:!0}),$t=a(t),Z=o(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-rsd8hl"&&(Z.textContent=ye),Lt=a(t),P=o(t,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-1t80mrq"&&(P.innerHTML=we),Et=a(t),S=o(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-6v19zm"&&(S.innerHTML=Ce),Ht=a(t),G=o(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-qjq0mw"&&(G.textContent=ve),Bt=a(t),Y(q.$$.fragment,t),Zt=a(t),F=o(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-pfpi4"&&(F.textContent=Te),Pt=a(t),W=o(t,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-b7upo8"&&(W.innerHTML=xe),St=a(t),N=o(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1v0y8k3"&&(N.innerHTML=be),Gt=a(t),qt=o(t,"HR",{}),Ft=a(t),R=o(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-b7m3f6"&&(R.textContent=je),Wt=a(t),V=o(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-h8bvqv"&&(V.textContent=Ue),Nt=a(t),X=o(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-14ocnmz"&&(X.innerHTML=Je),Rt=a(t),Y(Q.$$.fragment,t),Vt=a(t),st=o(t,"P",{}),ke(st).forEach(n),this.h()},h(){O(p,"name","hf:doc:metadata"),O(p,"content",Ge),O(u,"class","tip"),O(c,"start","2"),O(h,"start","3"),Ie(B.src,Me="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/code-vs-json-actions.png")||O(B,"src",Me),O(B,"alt","Code Agents")},m(t,e){Ze(document.head,p),s(t,lt,e),s(t,nt,e),s(t,at,e),D(d,t,e),s(t,it,e),s(t,u,e),s(t,ot,e),s(t,m,e),s(t,rt,e),s(t,f,e),s(t,pt,e),s(t,g,e),s(t,ut,e),D(M,t,e),s(t,ct,e),s(t,y,e),s(t,ht,e),s(t,w,e),s(t,dt,e),s(t,C,e),s(t,mt,e),s(t,v,e),s(t,ft,e),s(t,T,e),s(t,gt,e),D(x,t,e),s(t,Mt,e),s(t,b,e),s(t,yt,e),s(t,j,e),s(t,wt,e),s(t,U,e),s(t,Ct,e),s(t,c,e),s(t,vt,e),s(t,J,e),s(t,Tt,e),s(t,h,e),s(t,xt,e),s(t,k,e),s(t,bt,e),s(t,A,e),s(t,jt,e),D(_,t,e),s(t,Ut,e),s(t,I,e),s(t,Jt,e),s(t,$,e),s(t,kt,e),s(t,L,e),s(t,At,e),D(E,t,e),s(t,_t,e),s(t,H,e),s(t,It,e),s(t,B,e),s(t,$t,e),s(t,Z,e),s(t,Lt,e),s(t,P,e),s(t,Et,e),s(t,S,e),s(t,Ht,e),s(t,G,e),s(t,Bt,e),D(q,t,e),s(t,Zt,e),s(t,F,e),s(t,Pt,e),s(t,W,e),s(t,St,e),s(t,N,e),s(t,Gt,e),s(t,qt,e),s(t,Ft,e),s(t,R,e),s(t,Wt,e),s(t,V,e),s(t,Nt,e),s(t,X,e),s(t,Rt,e),D(Q,t,e),s(t,Vt,e),s(t,st,e),Xt=!0},p:$e,i(t){Xt||(K(d.$$.fragment,t),K(M.$$.fragment,t),K(x.$$.fragment,t),K(_.$$.fragment,t),K(E.$$.fragment,t),K(q.$$.fragment,t),K(Q.$$.fragment,t),Xt=!0)},o(t){tt(d.$$.fragment,t),tt(M.$$.fragment,t),tt(x.$$.fragment,t),tt(_.$$.fragment,t),tt(E.$$.fragment,t),tt(q.$$.fragment,t),tt(Q.$$.fragment,t),Xt=!1},d(t){t&&(n(lt),n(nt),n(at),n(it),n(u),n(ot),n(m),n(rt),n(f),n(pt),n(g),n(ut),n(ct),n(y),n(ht),n(w),n(dt),n(C),n(mt),n(v),n(ft),n(T),n(gt),n(Mt),n(b),n(yt),n(j),n(wt),n(U),n(Ct),n(c),n(vt),n(J),n(Tt),n(h),n(xt),n(k),n(bt),n(A),n(jt),n(Ut),n(I),n(Jt),n($),n(kt),n(L),n(At),n(_t),n(H),n(It),n(B),n($t),n(Z),n(Lt),n(P),n(Et),n(S),n(Ht),n(G),n(Bt),n(Zt),n(F),n(Pt),n(W),n(St),n(N),n(Gt),n(qt),n(Ft),n(R),n(Wt),n(V),n(Nt),n(X),n(Rt),n(Vt),n(st)),n(p),et(d,t),et(M,t),et(x,t),et(_,t),et(E,t),et(q,t),et(Q,t)}}}const Ge='{"title":"Actions:  Enabling the Agent to Engage with Its Environment","local":"actions-enabling-the-agent-to-engage-with-its-environment","sections":[{"title":"Types of Agent Actions","local":"types-of-agent-actions","sections":[],"depth":2},{"title":"The Stop and Parse Approach","local":"the-stop-and-parse-approach","sections":[],"depth":2},{"title":"Code Agents","local":"code-agents","sections":[],"depth":2}],"depth":1}';function qe(zt){return Le(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xe extends Ee{constructor(p){super(),He(this,p,qe,Se,_e,{})}}export{Xe as component};
