import{s as ye,f as qt,n as ue,o as he}from"../chunks/scheduler.37c15a92.js";import{S as de,i as Me,g as p,s as n,r,A as me,h as i,f as s,c as a,j as re,u as y,x as o,k as T,y as Te,a as l,v as u,d as h,t as d,w as M}from"../chunks/index.2bf4358c.js";import{C as D}from"../chunks/CodeBlock.4e987730.js";import{H as O}from"../chunks/Heading.8ada512a.js";import{E as ce}from"../chunks/getInferenceSnippets.0aa3753f.js";function Je(Et){let m,st,tt,lt,J,nt,U,Nt="To build applications with LangGraph, you need to understand its core components. Let’s explore the fundamental building blocks that make up a LangGraph application.",at,c,Vt,pt,w,Qt="An application in LangGraph starts from an <strong>entrypoint</strong>, and depending on the execution, the flow may go to one function or another until it reaches the END.",it,g,Wt,ot,f,rt,I,Yt="<strong>State</strong> is the central concept in LangGraph. It represents all the information that flows through your application.",yt,j,ut,$,zt="The state is <strong>User defined</strong>, hence the fields should carefully be crafted to contain all data needed for decision-making process!",ht,b,At="<p>💡 <strong>Tip:</strong> Think carefully about what information your application needs to track between steps.</p>",dt,C,Mt,k,Kt="<strong>Nodes</strong> are python functions. Each node:",mt,B,Ft="<li>Takes the state as input</li> <li>Performs some operation</li> <li>Returns updates to the state</li>",Tt,_,ct,G,Pt="For example, Nodes can contain:",Jt,Z,Dt="<li><strong>LLM calls</strong>: Generate text or make decisions</li> <li><strong>Tool calls</strong>: Interact with external systems</li> <li><strong>Conditional logic</strong>: Determine next steps</li> <li><strong>Human intervention</strong>: Get input from users</li>",Ut,S,Ot="<p>💡 <strong>Info:</strong> Some nodes necessary for the whole workflow like START and END exist from langGraph directly.</p>",wt,x,gt,v,te="<strong>Edges</strong> connect nodes and define the possible paths through your graph:",ft,R,It,H,ee="Edges can be:",jt,L,se="<li><strong>Direct</strong>: Always go from node A to node B</li> <li><strong>Conditional</strong>: Choose the next node based on the current state</li>",$t,X,bt,q,le="The <strong>StateGraph</strong> is the container that holds your entire agent workflow:",Ct,E,kt,N,ne="Which can then be visualized!",Bt,V,_t,Q,ae,Gt,W,pe="But most importantly, invoked:",Zt,Y,St,z,ie="output :",xt,A,vt,K,Rt,F,oe="In the next section, we’ll put these concepts into practice by building our first graph. This graph lets Alfred take in your e-mails, classify them, and craft a preliminary answer if they are genuine.",Ht,P,Lt,et,Xt;return J=new O({props:{title:"Building Blocks of LangGraph",local:"building-blocks-of-langgraph",headingTag:"h1"}}),f=new O({props:{title:"1. State",local:"1-state",headingTag:"h2"}}),j=new D({props:{code:"ZnJvbSUyMHR5cGluZ19leHRlbnNpb25zJTIwaW1wb3J0JTIwVHlwZWREaWN0JTBBJTBBY2xhc3MlMjBTdGF0ZShUeXBlZERpY3QpJTNBJTBBJTIwJTIwJTIwJTIwZ3JhcGhfc3RhdGUlM0ElMjBzdHI=",highlighted:`<span class="hljs-keyword">from</span> typing_extensions <span class="hljs-keyword">import</span> TypedDict

<span class="hljs-keyword">class</span> <span class="hljs-title class_">State</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    graph_state: <span class="hljs-built_in">str</span>`,wrap:!1}}),C=new O({props:{title:"2. Nodes",local:"2-nodes",headingTag:"h2"}}),_=new D({props:{code:"ZGVmJTIwbm9kZV8xKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAxLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwSSUyMGFtJTIyJTdEJTBBJTBBZGVmJTIwbm9kZV8yKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAyLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwaGFwcHkhJTIyJTdEJTBBJTBBZGVmJTIwbm9kZV8zKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAzLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwc2FkISUyMiU3RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_1</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 1---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; I am&quot;</span>}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_2</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 2---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; happy!&quot;</span>}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_3</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 3---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; sad!&quot;</span>}`,wrap:!1}}),x=new O({props:{title:"3. Edges",local:"3-edges",headingTag:"h2"}}),R=new D({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpdGVyYWwlMEElMEFkZWYlMjBkZWNpZGVfbW9vZChzdGF0ZSklMjAtJTNFJTIwTGl0ZXJhbCU1QiUyMm5vZGVfMiUyMiUyQyUyMCUyMm5vZGVfMyUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyME9mdGVuJTJDJTIwd2UlMjB3aWxsJTIwdXNlJTIwc3RhdGUlMjB0byUyMGRlY2lkZSUyMG9uJTIwdGhlJTIwbmV4dCUyMG5vZGUlMjB0byUyMHZpc2l0JTBBJTIwJTIwJTIwJTIwdXNlcl9pbnB1dCUyMCUzRCUyMHN0YXRlJTVCJ2dyYXBoX3N0YXRlJyU1RCUyMCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMEhlcmUlMkMlMjBsZXQncyUyMGp1c3QlMjBkbyUyMGElMjA1MCUyMCUyRiUyMDUwJTIwc3BsaXQlMjBiZXR3ZWVuJTIwbm9kZXMlMjAyJTJDJTIwMyUwQSUyMCUyMCUyMCUyMGlmJTIwcmFuZG9tLnJhbmRvbSgpJTIwJTNDJTIwMC41JTNBJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwNTAlMjUlMjBvZiUyMHRoZSUyMHRpbWUlMkMlMjB3ZSUyMHJldHVybiUyME5vZGUlMjAyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIybm9kZV8yJTIyJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwNTAlMjUlMjBvZiUyMHRoZSUyMHRpbWUlMkMlMjB3ZSUyMHJldHVybiUyME5vZGUlMjAzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIybm9kZV8zJTIy",highlighted:`<span class="hljs-keyword">import</span> random
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Literal</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">decide_mood</span>(<span class="hljs-params">state</span>) -&gt; <span class="hljs-type">Literal</span>[<span class="hljs-string">&quot;node_2&quot;</span>, <span class="hljs-string">&quot;node_3&quot;</span>]:
    
    <span class="hljs-comment"># Often, we will use state to decide on the next node to visit</span>
    user_input = state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] 
    
    <span class="hljs-comment"># Here, let&#x27;s just do a 50 / 50 split between nodes 2, 3</span>
    <span class="hljs-keyword">if</span> random.random() &lt; <span class="hljs-number">0.5</span>:

        <span class="hljs-comment"># 50% of the time, we return Node 2</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;node_2&quot;</span>
    
    <span class="hljs-comment"># 50% of the time, we return Node 3</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;node_3&quot;</span>`,wrap:!1}}),X=new O({props:{title:"4. StateGraph",local:"4-stategraph",headingTag:"h2"}}),E=new D({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEltYWdlJTJDJTIwZGlzcGxheSUwQWZyb20lMjBsYW5nZ3JhcGguZ3JhcGglMjBpbXBvcnQlMjBTdGF0ZUdyYXBoJTJDJTIwU1RBUlQlMkMlMjBFTkQlMEElMEElMjMlMjBCdWlsZCUyMGdyYXBoJTBBYnVpbGRlciUyMCUzRCUyMFN0YXRlR3JhcGgoU3RhdGUpJTBBYnVpbGRlci5hZGRfbm9kZSglMjJub2RlXzElMjIlMkMlMjBub2RlXzEpJTBBYnVpbGRlci5hZGRfbm9kZSglMjJub2RlXzIlMjIlMkMlMjBub2RlXzIpJTBBYnVpbGRlci5hZGRfbm9kZSglMjJub2RlXzMlMjIlMkMlMjBub2RlXzMpJTBBJTBBJTIzJTIwTG9naWMlMEFidWlsZGVyLmFkZF9lZGdlKFNUQVJUJTJDJTIwJTIybm9kZV8xJTIyKSUwQWJ1aWxkZXIuYWRkX2NvbmRpdGlvbmFsX2VkZ2VzKCUyMm5vZGVfMSUyMiUyQyUyMGRlY2lkZV9tb29kKSUwQWJ1aWxkZXIuYWRkX2VkZ2UoJTIybm9kZV8yJTIyJTJDJTIwRU5EKSUwQWJ1aWxkZXIuYWRkX2VkZ2UoJTIybm9kZV8zJTIyJTJDJTIwRU5EKSUwQSUwQSUyMyUyMEFkZCUwQWdyYXBoJTIwJTNEJTIwYnVpbGRlci5jb21waWxlKCk=",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image, display
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> StateGraph, START, END

<span class="hljs-comment"># Build graph</span>
builder = StateGraph(State)
builder.add_node(<span class="hljs-string">&quot;node_1&quot;</span>, node_1)
builder.add_node(<span class="hljs-string">&quot;node_2&quot;</span>, node_2)
builder.add_node(<span class="hljs-string">&quot;node_3&quot;</span>, node_3)

<span class="hljs-comment"># Logic</span>
builder.add_edge(START, <span class="hljs-string">&quot;node_1&quot;</span>)
builder.add_conditional_edges(<span class="hljs-string">&quot;node_1&quot;</span>, decide_mood)
builder.add_edge(<span class="hljs-string">&quot;node_2&quot;</span>, END)
builder.add_edge(<span class="hljs-string">&quot;node_3&quot;</span>, END)

<span class="hljs-comment"># Add</span>
graph = builder.<span class="hljs-built_in">compile</span>()`,wrap:!1}}),V=new D({props:{code:"JTIzJTIwVmlldyUwQWRpc3BsYXkoSW1hZ2UoZ3JhcGguZ2V0X2dyYXBoKCkuZHJhd19tZXJtYWlkX3BuZygpKSk=",highlighted:`<span class="hljs-comment"># View</span>
display(Image(graph.get_graph().draw_mermaid_png()))`,wrap:!1}}),Y=new D({props:{code:"Z3JhcGguaW52b2tlKCU3QiUyMmdyYXBoX3N0YXRlJTIyJTIwJTNBJTIwJTIySGklMkMlMjB0aGlzJTIwaXMlMjBMYW5jZS4lMjIlN0Qp",highlighted:'graph.invoke({<span class="hljs-string">&quot;graph_state&quot;</span> : <span class="hljs-string">&quot;Hi, this is Lance.&quot;</span>})',wrap:!1}}),A=new D({props:{code:"LS0tTm9kZSUyMDEtLS0lMEEtLS1Ob2RlJTIwMy0tLSUwQSU3QidncmFwaF9zdGF0ZSclM0ElMjAnSGklMkMlMjB0aGlzJTIwaXMlMjBMYW5jZS4lMjBJJTIwYW0lMjBzYWQhJyU3RA==",highlighted:`---<span class="hljs-keyword">Node</span> <span class="hljs-title">1---</span>
---<span class="hljs-keyword">Node</span> <span class="hljs-title">3---</span>
{&#x27;graph_state&#x27;: &#x27;Hi, this is Lance. I am sad!&#x27;}`,wrap:!1}}),K=new O({props:{title:"What’s Next?",local:"whats-next",headingTag:"h2"}}),P=new ce({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/langgraph/building_blocks.mdx"}}),{c(){m=p("meta"),st=n(),tt=p("p"),lt=n(),r(J.$$.fragment),nt=n(),U=p("p"),U.textContent=Nt,at=n(),c=p("img"),pt=n(),w=p("p"),w.innerHTML=Qt,it=n(),g=p("img"),ot=n(),r(f.$$.fragment),rt=n(),I=p("p"),I.innerHTML=Yt,yt=n(),r(j.$$.fragment),ut=n(),$=p("p"),$.innerHTML=zt,ht=n(),b=p("blockquote"),b.innerHTML=At,dt=n(),r(C.$$.fragment),Mt=n(),k=p("p"),k.innerHTML=Kt,mt=n(),B=p("ul"),B.innerHTML=Ft,Tt=n(),r(_.$$.fragment),ct=n(),G=p("p"),G.textContent=Pt,Jt=n(),Z=p("ul"),Z.innerHTML=Dt,Ut=n(),S=p("blockquote"),S.innerHTML=Ot,wt=n(),r(x.$$.fragment),gt=n(),v=p("p"),v.innerHTML=te,ft=n(),r(R.$$.fragment),It=n(),H=p("p"),H.textContent=ee,jt=n(),L=p("ul"),L.innerHTML=se,$t=n(),r(X.$$.fragment),bt=n(),q=p("p"),q.innerHTML=le,Ct=n(),r(E.$$.fragment),kt=n(),N=p("p"),N.textContent=ne,Bt=n(),r(V.$$.fragment),_t=n(),Q=p("img"),Gt=n(),W=p("p"),W.textContent=pe,Zt=n(),r(Y.$$.fragment),St=n(),z=p("p"),z.textContent=ie,xt=n(),r(A.$$.fragment),vt=n(),r(K.$$.fragment),Rt=n(),F=p("p"),F.textContent=oe,Ht=n(),r(P.$$.fragment),Lt=n(),et=p("p"),this.h()},l(t){const e=me("svelte-u9bgzb",document.head);m=i(e,"META",{name:!0,content:!0}),e.forEach(s),st=a(t),tt=i(t,"P",{}),re(tt).forEach(s),lt=a(t),y(J.$$.fragment,t),nt=a(t),U=i(t,"P",{"data-svelte-h":!0}),o(U)!=="svelte-s50h74"&&(U.textContent=Nt),at=a(t),c=i(t,"IMG",{src:!0,alt:!0,width:!0}),pt=a(t),w=i(t,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1n29p4d"&&(w.innerHTML=Qt),it=a(t),g=i(t,"IMG",{src:!0,alt:!0}),ot=a(t),y(f.$$.fragment,t),rt=a(t),I=i(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-13mfgi9"&&(I.innerHTML=Yt),yt=a(t),y(j.$$.fragment,t),ut=a(t),$=i(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-1nv9oba"&&($.innerHTML=zt),ht=a(t),b=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),o(b)!=="svelte-7zvkss"&&(b.innerHTML=At),dt=a(t),y(C.$$.fragment,t),Mt=a(t),k=i(t,"P",{"data-svelte-h":!0}),o(k)!=="svelte-bl6xu8"&&(k.innerHTML=Kt),mt=a(t),B=i(t,"UL",{"data-svelte-h":!0}),o(B)!=="svelte-1ojc0n6"&&(B.innerHTML=Ft),Tt=a(t),y(_.$$.fragment,t),ct=a(t),G=i(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-16qrzia"&&(G.textContent=Pt),Jt=a(t),Z=i(t,"UL",{"data-svelte-h":!0}),o(Z)!=="svelte-opt97h"&&(Z.innerHTML=Dt),Ut=a(t),S=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),o(S)!=="svelte-15fspvc"&&(S.innerHTML=Ot),wt=a(t),y(x.$$.fragment,t),gt=a(t),v=i(t,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1da8kr2"&&(v.innerHTML=te),ft=a(t),y(R.$$.fragment,t),It=a(t),H=i(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-edfl2t"&&(H.textContent=ee),jt=a(t),L=i(t,"UL",{"data-svelte-h":!0}),o(L)!=="svelte-1q9eq0"&&(L.innerHTML=se),$t=a(t),y(X.$$.fragment,t),bt=a(t),q=i(t,"P",{"data-svelte-h":!0}),o(q)!=="svelte-g73ioo"&&(q.innerHTML=le),Ct=a(t),y(E.$$.fragment,t),kt=a(t),N=i(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-147pt7a"&&(N.textContent=ne),Bt=a(t),y(V.$$.fragment,t),_t=a(t),Q=i(t,"IMG",{src:!0,alt:!0}),Gt=a(t),W=i(t,"P",{"data-svelte-h":!0}),o(W)!=="svelte-12bcwpz"&&(W.textContent=pe),Zt=a(t),y(Y.$$.fragment,t),St=a(t),z=i(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1wdnc59"&&(z.textContent=ie),xt=a(t),y(A.$$.fragment,t),vt=a(t),y(K.$$.fragment,t),Rt=a(t),F=i(t,"P",{"data-svelte-h":!0}),o(F)!=="svelte-p74a0p"&&(F.textContent=oe),Ht=a(t),y(P.$$.fragment,t),Lt=a(t),et=i(t,"P",{}),re(et).forEach(s),this.h()},h(){T(m,"name","hf:doc:metadata"),T(m,"content",Ue),qt(c.src,Vt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/Building_blocks.png")||T(c,"src",Vt),T(c,"alt","Building Blocks"),T(c,"width","70%"),qt(g.src,Wt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/application.png")||T(g,"src",Wt),T(g,"alt","Application"),qt(Q.src,ae="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/basic_graph.jpeg")||T(Q,"src",ae),T(Q,"alt","Graph Visualization")},m(t,e){Te(document.head,m),l(t,st,e),l(t,tt,e),l(t,lt,e),u(J,t,e),l(t,nt,e),l(t,U,e),l(t,at,e),l(t,c,e),l(t,pt,e),l(t,w,e),l(t,it,e),l(t,g,e),l(t,ot,e),u(f,t,e),l(t,rt,e),l(t,I,e),l(t,yt,e),u(j,t,e),l(t,ut,e),l(t,$,e),l(t,ht,e),l(t,b,e),l(t,dt,e),u(C,t,e),l(t,Mt,e),l(t,k,e),l(t,mt,e),l(t,B,e),l(t,Tt,e),u(_,t,e),l(t,ct,e),l(t,G,e),l(t,Jt,e),l(t,Z,e),l(t,Ut,e),l(t,S,e),l(t,wt,e),u(x,t,e),l(t,gt,e),l(t,v,e),l(t,ft,e),u(R,t,e),l(t,It,e),l(t,H,e),l(t,jt,e),l(t,L,e),l(t,$t,e),u(X,t,e),l(t,bt,e),l(t,q,e),l(t,Ct,e),u(E,t,e),l(t,kt,e),l(t,N,e),l(t,Bt,e),u(V,t,e),l(t,_t,e),l(t,Q,e),l(t,Gt,e),l(t,W,e),l(t,Zt,e),u(Y,t,e),l(t,St,e),l(t,z,e),l(t,xt,e),u(A,t,e),l(t,vt,e),u(K,t,e),l(t,Rt,e),l(t,F,e),l(t,Ht,e),u(P,t,e),l(t,Lt,e),l(t,et,e),Xt=!0},p:ue,i(t){Xt||(h(J.$$.fragment,t),h(f.$$.fragment,t),h(j.$$.fragment,t),h(C.$$.fragment,t),h(_.$$.fragment,t),h(x.$$.fragment,t),h(R.$$.fragment,t),h(X.$$.fragment,t),h(E.$$.fragment,t),h(V.$$.fragment,t),h(Y.$$.fragment,t),h(A.$$.fragment,t),h(K.$$.fragment,t),h(P.$$.fragment,t),Xt=!0)},o(t){d(J.$$.fragment,t),d(f.$$.fragment,t),d(j.$$.fragment,t),d(C.$$.fragment,t),d(_.$$.fragment,t),d(x.$$.fragment,t),d(R.$$.fragment,t),d(X.$$.fragment,t),d(E.$$.fragment,t),d(V.$$.fragment,t),d(Y.$$.fragment,t),d(A.$$.fragment,t),d(K.$$.fragment,t),d(P.$$.fragment,t),Xt=!1},d(t){t&&(s(st),s(tt),s(lt),s(nt),s(U),s(at),s(c),s(pt),s(w),s(it),s(g),s(ot),s(rt),s(I),s(yt),s(ut),s($),s(ht),s(b),s(dt),s(Mt),s(k),s(mt),s(B),s(Tt),s(ct),s(G),s(Jt),s(Z),s(Ut),s(S),s(wt),s(gt),s(v),s(ft),s(It),s(H),s(jt),s(L),s($t),s(bt),s(q),s(Ct),s(kt),s(N),s(Bt),s(_t),s(Q),s(Gt),s(W),s(Zt),s(St),s(z),s(xt),s(vt),s(Rt),s(F),s(Ht),s(Lt),s(et)),s(m),M(J,t),M(f,t),M(j,t),M(C,t),M(_,t),M(x,t),M(R,t),M(X,t),M(E,t),M(V,t),M(Y,t),M(A,t),M(K,t),M(P,t)}}}const Ue='{"title":"Building Blocks of LangGraph","local":"building-blocks-of-langgraph","sections":[{"title":"1. State","local":"1-state","sections":[],"depth":2},{"title":"2. Nodes","local":"2-nodes","sections":[],"depth":2},{"title":"3. Edges","local":"3-edges","sections":[],"depth":2},{"title":"4. StateGraph","local":"4-stategraph","sections":[],"depth":2},{"title":"What’s Next?","local":"whats-next","sections":[],"depth":2}],"depth":1}';function we(Et){return he(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class be extends de{constructor(m){super(),Me(this,m,we,Je,ye,{})}}export{be as component};
