import{s as ne,n as le,o as se}from"../chunks/scheduler.37c15a92.js";import{S as ae,i as oe,g as o,s,r as c,A as ie,h as i,f as n,c as a,j as ee,u as y,x as r,k as z,y as re,a as l,v as u,d as m,t as M,w}from"../chunks/index.2bf4358c.js";import{C as vt}from"../chunks/CodeBlock.4e987730.js";import{H as Zt}from"../chunks/Heading.8ada512a.js";import{E as pe}from"../chunks/getInferenceSnippets.0aa3753f.js";function ce(Wt){let p,P,$,D,h,K,b,Qt=`Remember Alfred, our helpful butler agent from earlier? Well, he’s about to get an upgrade!
Now that we understand the tools available in LlamaIndex, we can give Alfred new capabilities to serve us better.`,O,g,kt=`But before we continue, let’s remind ourselves what makes an agent like Alfred tick.
Back in Unit 1, we learned that:`,tt,U,Vt="<p>An Agent is a system that leverages an AI model to interact with its environment to achieve a user-defined objective. It combines reasoning, planning, and action execution (often via external tools) to fulfil tasks.</p>",et,f,_t="LlamaIndex supports <strong>three main types of reasoning agents:</strong>",nt,j,Rt='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/agents.png" alt="Agents"/>',lt,I,At="<li><code>Function Calling Agents</code> - These work with AI models that can call specific functions.</li> <li><code>ReAct Agents</code> - These can work with any AI that does chat or text endpoint and deal with complex reasoning tasks.</li> <li><code>Advanced Custom Agents</code> - These use more complex methods to deal with more complex tasks and workflows.</li>",st,d,St='<p>Find more information on advanced agents on <a href="https://github.com/run-llama/llama_index/blob/main/llama-index-core/llama_index/core/agent/workflow/base_agent.py">BaseWorkflowAgent</a></p>',at,B,ot,J,Yt='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/llama-index/agents.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',it,C,Ht=`To create an agent, we start by providing it with a <strong>set of functions/tools that define its capabilities</strong>.
Let’s look at how to create an agent with some basic tools. As of this writing, the agent will automatically use the function calling API (if available), or a standard ReAct agent loop.`,rt,x,Et="LLMs that support a tools/functions API are relatively new, but they provide a powerful way to call tools by avoiding specific prompting and allowing the LLM to create tool calls based on provided schemas.",pt,G,Xt="ReAct agents are also good at complex reasoning tasks and can work with any LLM that has chat or text completion capabilities. They are more verbose, and show the reasoning behind certain actions that they take.",ct,v,yt,Z,Ft=`<strong>Agents are stateless by default</strong>, however, they can remember past interactions using a <code>Context</code> object.
This might be useful if you want to use an agent that needs to remember previous interactions, like a chatbot that maintains context across multiple messages or a task manager that needs to track progress over time.`,ut,W,mt,Q,qt='You’ll notice that agents in <code>LlamaIndex</code> are async because they use Python’s <code>await</code> operator. If you are new to async code in Python, or need a refresher, they have an <a href="https://docs.llamaindex.ai/en/stable/getting_started/async_python/" rel="nofollow">excellent async guide</a>.',Mt,k,Lt="Now we’ve gotten the basics, let’s take a look at how we can use more complex tools in our agents.",wt,V,dt,_,$t=`<strong>Agentic RAG is a powerful way to use agents to answer questions about your data.</strong> We can pass various tools to Alfred to help him answer questions.
However, instead of answering the question on top of documents automatically, Alfred can decide to use any other tool or flow to answer the question.`,Jt,R,Nt='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/agentic-rag.png" alt="Agentic RAG"/>',Tt,A,zt=`It is easy to <strong>wrap <code>QueryEngine</code> as a tool</strong> for an agent.
When doing so, we need to <strong>define a name and description</strong>. The LLM will use this information to correctly use the tool.
Let’s see how to load in a <code>QueryEngineTool</code> using the <code>QueryEngine</code> we created in the <a href="components">component section</a>.`,ht,S,bt,Y,gt,H,Pt="The <code>AgentWorkflow</code> class also directly supports multi-agent systems. By giving each agent a name and description, the system maintains a single active speaker, with each agent having the ability to hand off to another agent.",Ut,E,Dt="By narrowing the scope of each agent, we can help increase their general accuracy when responding to user messages.",ft,X,Kt="<strong>Agents in LlamaIndex can also directly be used as tools</strong> for other agents, for more complex and custom scenarios.",jt,F,It,T,Ot='<p>Haven’t learned enough yet? There is a lot more to discover about agents and tools in LlamaIndex within the <a href="https://docs.llamaindex.ai/en/stable/examples/agent/agent_workflow_basic/">AgentWorkflow Basic Introduction</a> or the <a href="https://docs.llamaindex.ai/en/stable/understanding/agent/">Agent Learning Guide</a>, where you can read more about streaming, context serialization, and human-in-the-loop!</p>',Bt,q,te="Now that we understand the basics of agents and tools in LlamaIndex, let’s see how we can use LlamaIndex to <strong>create configurable and manageable workflows!</strong>",Ct,L,xt,N,Gt;return h=new Zt({props:{title:"Using Agents in LlamaIndex",local:"using-agents-in-llamaindex",headingTag:"h1"}}),B=new Zt({props:{title:"Initialising Agents",local:"initialising-agents",headingTag:"h2"}}),v=new vt({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMuaHVnZ2luZ2ZhY2VfYXBpJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUEklMEFmcm9tJTIwbGxhbWFfaW5kZXguY29yZS5hZ2VudC53b3JrZmxvdyUyMGltcG9ydCUyMEFnZW50V29ya2Zsb3clMEFmcm9tJTIwbGxhbWFfaW5kZXguY29yZS50b29scyUyMGltcG9ydCUyMEZ1bmN0aW9uVG9vbCUwQSUwQSUyMyUyMGRlZmluZSUyMHNhbXBsZSUyMFRvb2wlMjAtLSUyMHR5cGUlMjBhbm5vdGF0aW9ucyUyQyUyMGZ1bmN0aW9uJTIwbmFtZXMlMkMlMjBhbmQlMjBkb2NzdHJpbmdzJTJDJTIwYXJlJTIwYWxsJTIwaW5jbHVkZWQlMjBpbiUyMHBhcnNlZCUyMHNjaGVtYXMhJTBBZGVmJTIwbXVsdGlwbHkoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGxpZXMlMjB0d28lMjBpbnRlZ2VycyUyMGFuZCUyMHJldHVybnMlMjB0aGUlMjByZXN1bHRpbmclMjBpbnRlZ2VyJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBJTIzJTIwaW5pdGlhbGl6ZSUyMGxsbSUwQWxsbSUyMCUzRCUyMEh1Z2dpbmdGYWNlSW5mZXJlbmNlQVBJKG1vZGVsX25hbWUlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBJTBBJTIzJTIwaW5pdGlhbGl6ZSUyMGFnZW50JTBBYWdlbnQlMjAlM0QlMjBBZ2VudFdvcmtmbG93LmZyb21fdG9vbHNfb3JfZnVuY3Rpb25zKCUwQSUyMCUyMCUyMCUyMCU1QkZ1bmN0aW9uVG9vbC5mcm9tX2RlZmF1bHRzKG11bHRpcGx5KSU1RCUyQyUwQSUyMCUyMCUyMCUyMGxsbSUzRGxsbSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI
<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> AgentWorkflow
<span class="hljs-keyword">from</span> llama_index.core.tools <span class="hljs-keyword">import</span> FunctionTool

<span class="hljs-comment"># define sample Tool -- type annotations, function names, and docstrings, are all included in parsed schemas!</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplies two integers and returns the resulting integer&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-comment"># initialize llm</span>
llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

<span class="hljs-comment"># initialize agent</span>
agent = AgentWorkflow.from_tools_or_functions(
    [FunctionTool.from_defaults(multiply)],
    llm=llm
)`,wrap:!1}}),W=new vt({props:{code:"JTIzJTIwc3RhdGVsZXNzJTBBcmVzcG9uc2UlMjAlM0QlMjBhd2FpdCUyMGFnZW50LnJ1biglMjJXaGF0JTIwaXMlMjAyJTIwdGltZXMlMjAyJTNGJTIyKSUwQSUwQSUyMyUyMHJlbWVtYmVyaW5nJTIwc3RhdGUlMEFmcm9tJTIwbGxhbWFfaW5kZXguY29yZS53b3JrZmxvdyUyMGltcG9ydCUyMENvbnRleHQlMEElMEFjdHglMjAlM0QlMjBDb250ZXh0KGFnZW50KSUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwYXdhaXQlMjBhZ2VudC5ydW4oJTIyTXklMjBuYW1lJTIwaXMlMjBCb2IuJTIyJTJDJTIwY3R4JTNEY3R4KSUwQXJlc3BvbnNlJTIwJTNEJTIwYXdhaXQlMjBhZ2VudC5ydW4oJTIyV2hhdCUyMHdhcyUyMG15JTIwbmFtZSUyMGFnYWluJTNGJTIyJTJDJTIwY3R4JTNEY3R4KQ==",highlighted:`<span class="hljs-comment"># stateless</span>
response = <span class="hljs-keyword">await</span> agent.run(<span class="hljs-string">&quot;What is 2 times 2?&quot;</span>)

<span class="hljs-comment"># remembering state</span>
<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context

ctx = Context(agent)

response = <span class="hljs-keyword">await</span> agent.run(<span class="hljs-string">&quot;My name is Bob.&quot;</span>, ctx=ctx)
response = <span class="hljs-keyword">await</span> agent.run(<span class="hljs-string">&quot;What was my name again?&quot;</span>, ctx=ctx)`,wrap:!1}}),V=new Zt({props:{title:"Creating RAG Agents with QueryEngineTools",local:"creating-rag-agents-with-queryenginetools",headingTag:"h2"}}),S=new vt({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUudG9vbHMlMjBpbXBvcnQlMjBRdWVyeUVuZ2luZVRvb2wlMEElMEFxdWVyeV9lbmdpbmUlMjAlM0QlMjBpbmRleC5hc19xdWVyeV9lbmdpbmUobGxtJTNEbGxtJTJDJTIwc2ltaWxhcml0eV90b3BfayUzRDMpJTIwJTIzJTIwYXMlMjBzaG93biUyMGluJTIwdGhlJTIwQ29tcG9uZW50cyUyMGluJTIwTGxhbWFJbmRleCUyMHNlY3Rpb24lMEElMEFxdWVyeV9lbmdpbmVfdG9vbCUyMCUzRCUyMFF1ZXJ5RW5naW5lVG9vbC5mcm9tX2RlZmF1bHRzKCUwQSUyMCUyMCUyMCUyMHF1ZXJ5X2VuZ2luZSUzRHF1ZXJ5X2VuZ2luZSUyQyUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJuYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJhJTIwc3BlY2lmaWMlMjBkZXNjcmlwdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl9kaXJlY3QlM0RGYWxzZSUyQyUwQSklMEFxdWVyeV9lbmdpbmVfYWdlbnQlMjAlM0QlMjBBZ2VudFdvcmtmbG93LmZyb21fdG9vbHNfb3JfZnVuY3Rpb25zKCUwQSUyMCUyMCUyMCUyMCU1QnF1ZXJ5X2VuZ2luZV90b29sJTVEJTJDJTBBJTIwJTIwJTIwJTIwbGxtJTNEbGxtJTJDJTBBJTIwJTIwJTIwJTIwc3lzdGVtX3Byb21wdCUzRCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50JTIwdGhhdCUyMGhhcyUyMGFjY2VzcyUyMHRvJTIwYSUyMGRhdGFiYXNlJTIwY29udGFpbmluZyUyMHBlcnNvbmElMjBkZXNjcmlwdGlvbnMuJTIwJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.tools <span class="hljs-keyword">import</span> QueryEngineTool

query_engine = index.as_query_engine(llm=llm, similarity_top_k=<span class="hljs-number">3</span>) <span class="hljs-comment"># as shown in the Components in LlamaIndex section</span>

query_engine_tool = QueryEngineTool.from_defaults(
    query_engine=query_engine,
    name=<span class="hljs-string">&quot;name&quot;</span>,
    description=<span class="hljs-string">&quot;a specific description&quot;</span>,
    return_direct=<span class="hljs-literal">False</span>,
)
query_engine_agent = AgentWorkflow.from_tools_or_functions(
    [query_engine_tool],
    llm=llm,
    system_prompt=<span class="hljs-string">&quot;You are a helpful assistant that has access to a database containing persona descriptions. &quot;</span>
)`,wrap:!1}}),Y=new Zt({props:{title:"Creating Multi-agent systems",local:"creating-multi-agent-systems",headingTag:"h2"}}),F=new vt({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> (
    AgentWorkflow,
    FunctionAgent,
    ReActAgent,
)

<span class="hljs-comment"># Define some tools</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Add two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a + b


<span class="hljs-keyword">def</span> <span class="hljs-title function_">subtract</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Subtract two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a - b


<span class="hljs-comment"># Create agent configs</span>
<span class="hljs-comment"># <span class="hljs-doctag">NOTE:</span> we can use FunctionAgent or ReActAgent here.</span>
<span class="hljs-comment"># FunctionAgent works for LLMs with a function calling API.</span>
<span class="hljs-comment"># ReActAgent works for any LLM.</span>
calculator_agent = ReActAgent(
    name=<span class="hljs-string">&quot;calculator&quot;</span>,
    description=<span class="hljs-string">&quot;Performs basic arithmetic operations&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;You are a calculator assistant. Use your tools for any math operation.&quot;</span>,
    tools=[add, subtract],
    llm=llm,
)

query_agent = ReActAgent(
    name=<span class="hljs-string">&quot;info_lookup&quot;</span>,
    description=<span class="hljs-string">&quot;Looks up information about XYZ&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;Use your tool to query a RAG system to answer information about XYZ&quot;</span>,
    tools=[query_engine_tool],
    llm=llm
)

<span class="hljs-comment"># Create and run the workflow</span>
agent = AgentWorkflow(
    agents=[calculator_agent, query_agent], root_agent=<span class="hljs-string">&quot;calculator&quot;</span>
)

<span class="hljs-comment"># Run the system</span>
response = <span class="hljs-keyword">await</span> agent.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>)`,wrap:!1}}),L=new pe({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/llama-index/agents.mdx"}}),{c(){p=o("meta"),P=s(),$=o("p"),D=s(),c(h.$$.fragment),K=s(),b=o("p"),b.textContent=Qt,O=s(),g=o("p"),g.textContent=kt,tt=s(),U=o("blockquote"),U.innerHTML=Vt,et=s(),f=o("p"),f.innerHTML=_t,nt=s(),j=o("p"),j.innerHTML=Rt,lt=s(),I=o("ol"),I.innerHTML=At,st=s(),d=o("blockquote"),d.innerHTML=St,at=s(),c(B.$$.fragment),ot=s(),J=o("blockquote"),J.innerHTML=Yt,it=s(),C=o("p"),C.innerHTML=Ht,rt=s(),x=o("p"),x.textContent=Et,pt=s(),G=o("p"),G.textContent=Xt,ct=s(),c(v.$$.fragment),yt=s(),Z=o("p"),Z.innerHTML=Ft,ut=s(),c(W.$$.fragment),mt=s(),Q=o("p"),Q.innerHTML=qt,Mt=s(),k=o("p"),k.textContent=Lt,wt=s(),c(V.$$.fragment),dt=s(),_=o("p"),_.innerHTML=$t,Jt=s(),R=o("p"),R.innerHTML=Nt,Tt=s(),A=o("p"),A.innerHTML=zt,ht=s(),c(S.$$.fragment),bt=s(),c(Y.$$.fragment),gt=s(),H=o("p"),H.innerHTML=Pt,Ut=s(),E=o("p"),E.textContent=Dt,ft=s(),X=o("p"),X.innerHTML=Kt,jt=s(),c(F.$$.fragment),It=s(),T=o("blockquote"),T.innerHTML=Ot,Bt=s(),q=o("p"),q.innerHTML=te,Ct=s(),c(L.$$.fragment),xt=s(),N=o("p"),this.h()},l(t){const e=ie("svelte-u9bgzb",document.head);p=i(e,"META",{name:!0,content:!0}),e.forEach(n),P=a(t),$=i(t,"P",{}),ee($).forEach(n),D=a(t),y(h.$$.fragment,t),K=a(t),b=i(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-k20nvn"&&(b.textContent=Qt),O=a(t),g=i(t,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1hjwxub"&&(g.textContent=kt),tt=a(t),U=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(U)!=="svelte-15o6tbi"&&(U.innerHTML=Vt),et=a(t),f=i(t,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1i02awx"&&(f.innerHTML=_t),nt=a(t),j=i(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-14dee9q"&&(j.innerHTML=Rt),lt=a(t),I=i(t,"OL",{"data-svelte-h":!0}),r(I)!=="svelte-1bz4j87"&&(I.innerHTML=At),st=a(t),d=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(d)!=="svelte-1n8lcg8"&&(d.innerHTML=St),at=a(t),y(B.$$.fragment,t),ot=a(t),J=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-iskmgm"&&(J.innerHTML=Yt),it=a(t),C=i(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1k9r5ws"&&(C.innerHTML=Ht),rt=a(t),x=i(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-gafhou"&&(x.textContent=Et),pt=a(t),G=i(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-dm7947"&&(G.textContent=Xt),ct=a(t),y(v.$$.fragment,t),yt=a(t),Z=i(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1hbrpvb"&&(Z.innerHTML=Ft),ut=a(t),y(W.$$.fragment,t),mt=a(t),Q=i(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-18kp6fu"&&(Q.innerHTML=qt),Mt=a(t),k=i(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-epz1ho"&&(k.textContent=Lt),wt=a(t),y(V.$$.fragment,t),dt=a(t),_=i(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-cdj536"&&(_.innerHTML=$t),Jt=a(t),R=i(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1srircl"&&(R.innerHTML=Nt),Tt=a(t),A=i(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-sogywd"&&(A.innerHTML=zt),ht=a(t),y(S.$$.fragment,t),bt=a(t),y(Y.$$.fragment,t),gt=a(t),H=i(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-pnrrlw"&&(H.innerHTML=Pt),Ut=a(t),E=i(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1lnlpu9"&&(E.textContent=Dt),ft=a(t),X=i(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-19na4nh"&&(X.innerHTML=Kt),jt=a(t),y(F.$$.fragment,t),It=a(t),T=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-5bjjvw"&&(T.innerHTML=Ot),Bt=a(t),q=i(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1synfbm"&&(q.innerHTML=te),Ct=a(t),y(L.$$.fragment,t),xt=a(t),N=i(t,"P",{}),ee(N).forEach(n),this.h()},h(){z(p,"name","hf:doc:metadata"),z(p,"content",ye),z(d,"class","tip"),z(J,"class","tip"),z(T,"class","tip")},m(t,e){re(document.head,p),l(t,P,e),l(t,$,e),l(t,D,e),u(h,t,e),l(t,K,e),l(t,b,e),l(t,O,e),l(t,g,e),l(t,tt,e),l(t,U,e),l(t,et,e),l(t,f,e),l(t,nt,e),l(t,j,e),l(t,lt,e),l(t,I,e),l(t,st,e),l(t,d,e),l(t,at,e),u(B,t,e),l(t,ot,e),l(t,J,e),l(t,it,e),l(t,C,e),l(t,rt,e),l(t,x,e),l(t,pt,e),l(t,G,e),l(t,ct,e),u(v,t,e),l(t,yt,e),l(t,Z,e),l(t,ut,e),u(W,t,e),l(t,mt,e),l(t,Q,e),l(t,Mt,e),l(t,k,e),l(t,wt,e),u(V,t,e),l(t,dt,e),l(t,_,e),l(t,Jt,e),l(t,R,e),l(t,Tt,e),l(t,A,e),l(t,ht,e),u(S,t,e),l(t,bt,e),u(Y,t,e),l(t,gt,e),l(t,H,e),l(t,Ut,e),l(t,E,e),l(t,ft,e),l(t,X,e),l(t,jt,e),u(F,t,e),l(t,It,e),l(t,T,e),l(t,Bt,e),l(t,q,e),l(t,Ct,e),u(L,t,e),l(t,xt,e),l(t,N,e),Gt=!0},p:le,i(t){Gt||(m(h.$$.fragment,t),m(B.$$.fragment,t),m(v.$$.fragment,t),m(W.$$.fragment,t),m(V.$$.fragment,t),m(S.$$.fragment,t),m(Y.$$.fragment,t),m(F.$$.fragment,t),m(L.$$.fragment,t),Gt=!0)},o(t){M(h.$$.fragment,t),M(B.$$.fragment,t),M(v.$$.fragment,t),M(W.$$.fragment,t),M(V.$$.fragment,t),M(S.$$.fragment,t),M(Y.$$.fragment,t),M(F.$$.fragment,t),M(L.$$.fragment,t),Gt=!1},d(t){t&&(n(P),n($),n(D),n(K),n(b),n(O),n(g),n(tt),n(U),n(et),n(f),n(nt),n(j),n(lt),n(I),n(st),n(d),n(at),n(ot),n(J),n(it),n(C),n(rt),n(x),n(pt),n(G),n(ct),n(yt),n(Z),n(ut),n(mt),n(Q),n(Mt),n(k),n(wt),n(dt),n(_),n(Jt),n(R),n(Tt),n(A),n(ht),n(bt),n(gt),n(H),n(Ut),n(E),n(ft),n(X),n(jt),n(It),n(T),n(Bt),n(q),n(Ct),n(xt),n(N)),n(p),w(h,t),w(B,t),w(v,t),w(W,t),w(V,t),w(S,t),w(Y,t),w(F,t),w(L,t)}}}const ye='{"title":"Using Agents in LlamaIndex","local":"using-agents-in-llamaindex","sections":[{"title":"Initialising Agents","local":"initialising-agents","sections":[],"depth":2},{"title":"Creating RAG Agents with QueryEngineTools","local":"creating-rag-agents-with-queryenginetools","sections":[],"depth":2},{"title":"Creating Multi-agent systems","local":"creating-multi-agent-systems","sections":[],"depth":2}],"depth":1}';function ue(Wt){return se(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Te extends ae{constructor(p){super(),oe(this,p,ue,ce,ne,{})}}export{Te as component};
