import{s as wt,n as gt,o as Tt}from"../chunks/scheduler.37c15a92.js";import{S as jt,i as vt,g as s,s as o,r as c,m as Xe,A as xt,h as i,f as l,c as a,j as Qe,u as m,x as r,n as Se,k as O,y as b,a as n,v as p,d,t as u,w as h}from"../chunks/index.2bf4358c.js";import{C as ee}from"../chunks/CodeBlock.4e987730.js";import{H as ae}from"../chunks/Heading.8ada512a.js";import{E as Jt}from"../chunks/getInferenceSnippets.0aa3753f.js";function Zt(ze){let y,re,se,ce,j,me,v,Ke=`<strong>Defining a clear set of Tools is crucial to performance.</strong> As we discussed in <a href="../../unit1/tools">unit 1</a>, clear tool interfaces are easier for LLMs to use.
Much like a software API interface for human engineers, they can get more out of the tool if it’s easy to understand how it works.`,pe,x,De="There are <strong>four main types of tools in LlamaIndex</strong>:",de,J,Oe='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/tools.png" alt="Tools"/>',ue,Z,et="<li><code>FunctionTool</code>: Convert any Python function into a tool that an agent can use. It automatically figures out how the function works.</li> <li><code>QueryEngineTool</code>: A tool that lets agents use query engines. Since agents are built on query engines, they can also use other agents as tools.</li> <li><code>Toolspecs</code>: Sets of tools created by the community, which often include tools for specific services like Gmail.</li> <li><code>Utility Tools</code>: Special tools that help handle large amounts of data from other tools.</li>",he,C,tt="We will go over each of them in more detail below.",fe,U,Me,w,lt='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/llama-index/tools.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',ye,$,nt=`A FunctionTool provides a simple way to wrap any Python function and make it available to an agent.
You can pass either a synchronous or asynchronous function to the tool, along with optional <code>name</code> and <code>description</code> parameters.
The name and description are particularly important as they help the agent understand when and how to use the tool effectively.
Let’s look at how to create a FunctionTool below and then call it.`,be,G,we,g,ot='<p>When using an agent or LLM with function calling, the tool selected (and the arguments written for that tool) rely strongly on the tool name and description of the purpose and arguments of the tool. Learn more about function calling in the <a href="https://docs.llamaindex.ai/en/stable/examples/workflow/function_calling_agent/">Function Calling Guide</a>.</p>',ge,W,Te,I,at=`The <code>QueryEngine</code> we defined in the previous unit can be easily transformed into a tool using the <code>QueryEngineTool</code> class.
Let’s see how to create a <code>QueryEngineTool</code> from a <code>QueryEngine</code> in the example below.`,je,B,ve,_,xe,k,st=`Think of <code>ToolSpecs</code> as collections of tools that work together harmoniously - like a well-organized professional toolkit.
Just as a mechanic’s toolkit contains complementary tools that work together for vehicle repairs, a <code>ToolSpec</code> combines related tools for specific purposes.
For example, an accounting agent’s <code>ToolSpec</code> might elegantly integrate spreadsheet capabilities, email functionality, and calculation tools to handle financial tasks with precision and efficiency.`,Je,f,te,it="Install the Google Toolspec",Fe,L,rt="section on the LlamaHub",qe,V,Ze,E,ct="And now we can load the toolspec and convert it to a list of tools.",Ce,N,Ue,R,mt="To get a more detailed view of the tools, we can take a look at the <code>metadata</code> of each tool.",$e,H,Ge,Y,We,X,pt=`LlamaIndex also allows using MCP tools through a <a href="https://llamahub.ai/l/tools/llama-index-tools-mcp?from=" rel="nofollow">ToolSpec on the LlamaHub</a>.
You can simply run an MCP server and start using it through the following implementation.`,Ie,Q,dt='If you want to dive deeper about MCP, you can check our <a href="https://huggingface.co/learn/mcp-course/" rel="nofollow">free MCP Course</a>.',Be,M,le,ut="Install the MCP Toolspec",Ae,S,ht="section on the LlamaHub",Pe,F,_e,q,ke,A,Le,P,ft=`Oftentimes, directly querying an API <strong>can return an excessive amount of data</strong>, some of which may be irrelevant, overflow the context window of the LLM, or unnecessarily increase the number of tokens that you are using.
Let’s walk through our two main utility tools below.`,Ve,z,Mt="<li><code>OnDemandToolLoader</code>: This tool turns any existing LlamaIndex data loader (BaseReader class) into a tool that an agent can use. The tool can be called with all the parameters needed to trigger <code>load_data</code> from the data loader, along with a natural language query string. During execution, we first load data from the data loader, index it (for instance with a vector store), and then query it ‘on-demand’. All three of these steps happen in a single tool call.</li> <li><code>LoadAndSearchToolSpec</code>: The LoadAndSearchToolSpec takes in any existing Tool as input. As a tool spec, it implements <code>to_tool_list</code>, and when that function is called, two tools are returned: a loading tool and then a search tool. The load Tool execution would call the underlying Tool, and then index the output (by default with a vector index). The search Tool execution would take in a query string as input and call the underlying index.</li>",Ee,T,yt='<p>You can find toolspecs and utility tools on the <a href="https://llamahub.ai/">LlamaHub</a></p>',Ne,K,bt="Now that we understand the basics of agents and tools in LlamaIndex, let’s see how we can <strong>use LlamaIndex to create configurable and manageable workflows!</strong>",Re,D,He,ie,Ye;return j=new ae({props:{title:"Using Tools in LlamaIndex",local:"using-tools-in-llamaindex",headingTag:"h1"}}),U=new ae({props:{title:"Creating a FunctionTool",local:"creating-a-functiontool",headingTag:"h2"}}),G=new ee({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUudG9vbHMlMjBpbXBvcnQlMjBGdW5jdGlvblRvb2wlMEElMEFkZWYlMjBnZXRfd2VhdGhlcihsb2NhdGlvbiUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyVXNlZnVsJTIwZm9yJTIwZ2V0dGluZyUyMHRoZSUyMHdlYXRoZXIlMjBmb3IlMjBhJTIwZ2l2ZW4lMjBsb2NhdGlvbi4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBwcmludChmJTIyR2V0dGluZyUyMHdlYXRoZXIlMjBmb3IlMjAlN0Jsb2NhdGlvbiU3RCUyMiklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBmJTIyVGhlJTIwd2VhdGhlciUyMGluJTIwJTdCbG9jYXRpb24lN0QlMjBpcyUyMHN1bm55JTIyJTBBJTBBdG9vbCUyMCUzRCUyMEZ1bmN0aW9uVG9vbC5mcm9tX2RlZmF1bHRzKCUwQSUyMCUyMCUyMCUyMGdldF93ZWF0aGVyJTJDJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMm15X3dlYXRoZXJfdG9vbCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyVXNlZnVsJTIwZm9yJTIwZ2V0dGluZyUyMHRoZSUyMHdlYXRoZXIlMjBmb3IlMjBhJTIwZ2l2ZW4lMjBsb2NhdGlvbi4lMjIlMkMlMEEpJTBBdG9vbC5jYWxsKCUyMk5ldyUyMFlvcmslMjIp",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.tools <span class="hljs-keyword">import</span> FunctionTool

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Useful for getting the weather for a given location.&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Getting weather for <span class="hljs-subst">{location}</span>&quot;</span>)
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The weather in <span class="hljs-subst">{location}</span> is sunny&quot;</span>

tool = FunctionTool.from_defaults(
    get_weather,
    name=<span class="hljs-string">&quot;my_weather_tool&quot;</span>,
    description=<span class="hljs-string">&quot;Useful for getting the weather for a given location.&quot;</span>,
)
tool.call(<span class="hljs-string">&quot;New York&quot;</span>)`,wrap:!1}}),W=new ae({props:{title:"Creating a QueryEngineTool",local:"creating-a-queryenginetool",headingTag:"h2"}}),B=new ee({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBWZWN0b3JTdG9yZUluZGV4JTBBZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUudG9vbHMlMjBpbXBvcnQlMjBRdWVyeUVuZ2luZVRvb2wlMEFmcm9tJTIwbGxhbWFfaW5kZXgubGxtcy5odWdnaW5nZmFjZV9hcGklMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUluZmVyZW5jZUFQSSUwQWZyb20lMjBsbGFtYV9pbmRleC5lbWJlZGRpbmdzLmh1Z2dpbmdmYWNlJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmclMEFmcm9tJTIwbGxhbWFfaW5kZXgudmVjdG9yX3N0b3Jlcy5jaHJvbWElMjBpbXBvcnQlMjBDaHJvbWFWZWN0b3JTdG9yZSUwQSUwQWVtYmVkX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmcoJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyKSUwQSUwQWRiJTIwJTNEJTIwY2hyb21hZGIuUGVyc2lzdGVudENsaWVudChwYXRoJTNEJTIyLiUyRmFsZnJlZF9jaHJvbWFfZGIlMjIpJTBBY2hyb21hX2NvbGxlY3Rpb24lMjAlM0QlMjBkYi5nZXRfb3JfY3JlYXRlX2NvbGxlY3Rpb24oJTIyYWxmcmVkJTIyKSUwQXZlY3Rvcl9zdG9yZSUyMCUzRCUyMENocm9tYVZlY3RvclN0b3JlKGNocm9tYV9jb2xsZWN0aW9uJTNEY2hyb21hX2NvbGxlY3Rpb24pJTBBJTBBaW5kZXglMjAlM0QlMjBWZWN0b3JTdG9yZUluZGV4LmZyb21fdmVjdG9yX3N0b3JlKHZlY3Rvcl9zdG9yZSUyQyUyMGVtYmVkX21vZGVsJTNEZW1iZWRfbW9kZWwpJTBBJTBBbGxtJTIwJTNEJTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUEkobW9kZWxfbmFtZSUzRCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEFxdWVyeV9lbmdpbmUlMjAlM0QlMjBpbmRleC5hc19xdWVyeV9lbmdpbmUobGxtJTNEbGxtKSUwQXRvb2wlMjAlM0QlMjBRdWVyeUVuZ2luZVRvb2wuZnJvbV9kZWZhdWx0cyhxdWVyeV9lbmdpbmUlMkMlMjBuYW1lJTNEJTIyc29tZSUyMHVzZWZ1bCUyMG5hbWUlMjIlMkMlMjBkZXNjcmlwdGlvbiUzRCUyMnNvbWUlMjB1c2VmdWwlMjBkZXNjcmlwdGlvbiUyMik=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> VectorStoreIndex
<span class="hljs-keyword">from</span> llama_index.core.tools <span class="hljs-keyword">import</span> QueryEngineTool
<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI
<span class="hljs-keyword">from</span> llama_index.embeddings.huggingface <span class="hljs-keyword">import</span> HuggingFaceEmbedding
<span class="hljs-keyword">from</span> llama_index.vector_stores.chroma <span class="hljs-keyword">import</span> ChromaVectorStore

embed_model = HuggingFaceEmbedding(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)

db = chromadb.PersistentClient(path=<span class="hljs-string">&quot;./alfred_chroma_db&quot;</span>)
chroma_collection = db.get_or_create_collection(<span class="hljs-string">&quot;alfred&quot;</span>)
vector_store = ChromaVectorStore(chroma_collection=chroma_collection)

index = VectorStoreIndex.from_vector_store(vector_store, embed_model=embed_model)

llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
query_engine = index.as_query_engine(llm=llm)
tool = QueryEngineTool.from_defaults(query_engine, name=<span class="hljs-string">&quot;some useful name&quot;</span>, description=<span class="hljs-string">&quot;some useful description&quot;</span>)`,wrap:!1}}),_=new ae({props:{title:"Creating Toolspecs",local:"creating-toolspecs",headingTag:"h2"}}),V=new ee({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXRvb2xzLWdvb2dsZQ==",highlighted:"pip install llama-index-tools-google",wrap:!1}}),N=new ee({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LnRvb2xzLmdvb2dsZSUyMGltcG9ydCUyMEdtYWlsVG9vbFNwZWMlMEElMEF0b29sX3NwZWMlMjAlM0QlMjBHbWFpbFRvb2xTcGVjKCklMEF0b29sX3NwZWNfbGlzdCUyMCUzRCUyMHRvb2xfc3BlYy50b190b29sX2xpc3QoKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.tools.google <span class="hljs-keyword">import</span> GmailToolSpec

tool_spec = GmailToolSpec()
tool_spec_list = tool_spec.to_tool_list()`,wrap:!1}}),H=new ee({props:{code:"JTVCKHRvb2wubWV0YWRhdGEubmFtZSUyQyUyMHRvb2wubWV0YWRhdGEuZGVzY3JpcHRpb24pJTIwZm9yJTIwdG9vbCUyMGluJTIwdG9vbF9zcGVjX2xpc3QlNUQ=",highlighted:'[(tool.metadata.name, tool.metadata.description) <span class="hljs-keyword">for</span> tool <span class="hljs-keyword">in</span> tool_spec_list]',wrap:!1}}),Y=new ae({props:{title:"Model Context Protocol (MCP) in LlamaIndex",local:"model-context-protocol-mcp-in-llamaindex",headingTag:"h3"}}),F=new ee({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXRvb2xzLW1jcA==",highlighted:"pip install llama-index-tools-mcp",wrap:!1}}),q=new ee({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LnRvb2xzLm1jcCUyMGltcG9ydCUyMEJhc2ljTUNQQ2xpZW50JTJDJTIwTWNwVG9vbFNwZWMlMEElMEElMjMlMjBXZSUyMGNvbnNpZGVyJTIwdGhlcmUlMjBpcyUyMGElMjBtY3AlMjBzZXJ2ZXIlMjBydW5uaW5nJTIwb24lMjAxMjcuMC4wLjElM0E4MDAwJTJDJTIwb3IlMjB5b3UlMjBjYW4lMjB1c2UlMjB0aGUlMjBtY3AlMjBjbGllbnQlMjB0byUyMGNvbm5lY3QlMjB0byUyMHlvdXIlMjBvd24lMjBtY3AlMjBzZXJ2ZXIuJTBBbWNwX2NsaWVudCUyMCUzRCUyMEJhc2ljTUNQQ2xpZW50KCUyMmh0dHAlM0ElMkYlMkYxMjcuMC4wLjElM0E4MDAwJTJGc3NlJTIyKSUwQW1jcF90b29sJTIwJTNEJTIwTWNwVG9vbFNwZWMoY2xpZW50JTNEbWNwX2NsaWVudCklMEElMEElMjMlMjBnZXQlMjB0aGUlMjBhZ2VudCUwQWFnZW50JTIwJTNEJTIwYXdhaXQlMjBnZXRfYWdlbnQobWNwX3Rvb2wpJTBBJTBBJTIzJTIwY3JlYXRlJTIwdGhlJTIwYWdlbnQlMjBjb250ZXh0JTBBYWdlbnRfY29udGV4dCUyMCUzRCUyMENvbnRleHQoYWdlbnQp",highlighted:`<span class="hljs-keyword">from</span> llama_index.tools.mcp <span class="hljs-keyword">import</span> BasicMCPClient, McpToolSpec

<span class="hljs-comment"># We consider there is a mcp server running on 127.0.0.1:8000, or you can use the mcp client to connect to your own mcp server.</span>
mcp_client = BasicMCPClient(<span class="hljs-string">&quot;http://127.0.0.1:8000/sse&quot;</span>)
mcp_tool = McpToolSpec(client=mcp_client)

<span class="hljs-comment"># get the agent</span>
agent = <span class="hljs-keyword">await</span> get_agent(mcp_tool)

<span class="hljs-comment"># create the agent context</span>
agent_context = Context(agent)`,wrap:!1}}),A=new ae({props:{title:"Utility Tools",local:"utility-tools",headingTag:"h2"}}),D=new Jt({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/llama-index/tools.mdx"}}),{c(){y=s("meta"),re=o(),se=s("p"),ce=o(),c(j.$$.fragment),me=o(),v=s("p"),v.innerHTML=Ke,pe=o(),x=s("p"),x.innerHTML=De,de=o(),J=s("p"),J.innerHTML=Oe,ue=o(),Z=s("ol"),Z.innerHTML=et,he=o(),C=s("p"),C.textContent=tt,fe=o(),c(U.$$.fragment),Me=o(),w=s("blockquote"),w.innerHTML=lt,ye=o(),$=s("p"),$.innerHTML=nt,be=o(),c(G.$$.fragment),we=o(),g=s("blockquote"),g.innerHTML=ot,ge=o(),c(W.$$.fragment),Te=o(),I=s("p"),I.innerHTML=at,je=o(),c(B.$$.fragment),ve=o(),c(_.$$.fragment),xe=o(),k=s("p"),k.innerHTML=st,Je=o(),f=s("details"),te=s("summary"),te.textContent=it,Fe=Xe(`
As introduced in the `),L=s("a"),L.textContent=rt,qe=Xe(`, we can install the Google toolspec with the following command:

	`),c(V.$$.fragment),Ze=o(),E=s("p"),E.textContent=ct,Ce=o(),c(N.$$.fragment),Ue=o(),R=s("p"),R.innerHTML=mt,$e=o(),c(H.$$.fragment),Ge=o(),c(Y.$$.fragment),We=o(),X=s("p"),X.innerHTML=pt,Ie=o(),Q=s("p"),Q.innerHTML=dt,Be=o(),M=s("details"),le=s("summary"),le.textContent=ut,Ae=Xe(`
As introduced in the `),S=s("a"),S.textContent=ht,Pe=Xe(`, we can install the MCP toolspec with the following command:

	`),c(F.$$.fragment),_e=o(),c(q.$$.fragment),ke=o(),c(A.$$.fragment),Le=o(),P=s("p"),P.innerHTML=ft,Ve=o(),z=s("ol"),z.innerHTML=Mt,Ee=o(),T=s("blockquote"),T.innerHTML=yt,Ne=o(),K=s("p"),K.innerHTML=bt,Re=o(),c(D.$$.fragment),He=o(),ie=s("p"),this.h()},l(e){const t=xt("svelte-u9bgzb",document.head);y=i(t,"META",{name:!0,content:!0}),t.forEach(l),re=a(e),se=i(e,"P",{}),Qe(se).forEach(l),ce=a(e),m(j.$$.fragment,e),me=a(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1y4sc3l"&&(v.innerHTML=Ke),pe=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-jgrrn"&&(x.innerHTML=De),de=a(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-ir2ii4"&&(J.innerHTML=Oe),ue=a(e),Z=i(e,"OL",{"data-svelte-h":!0}),r(Z)!=="svelte-7bbi5a"&&(Z.innerHTML=et),he=a(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1hynje"&&(C.textContent=tt),fe=a(e),m(U.$$.fragment,e),Me=a(e),w=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-1x3fhkd"&&(w.innerHTML=lt),ye=a(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1ij77fk"&&($.innerHTML=nt),be=a(e),m(G.$$.fragment,e),we=a(e),g=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-1ifg6bn"&&(g.innerHTML=ot),ge=a(e),m(W.$$.fragment,e),Te=a(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-wh1h60"&&(I.innerHTML=at),je=a(e),m(B.$$.fragment,e),ve=a(e),m(_.$$.fragment,e),xe=a(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1196szp"&&(k.innerHTML=st),Je=a(e),f=i(e,"DETAILS",{});var ne=Qe(f);te=i(ne,"SUMMARY",{"data-svelte-h":!0}),r(te)!=="svelte-8tnjrg"&&(te.textContent=it),Fe=Se(ne,`
As introduced in the `),L=i(ne,"A",{href:!0,"data-svelte-h":!0}),r(L)!=="svelte-16phayx"&&(L.textContent=rt),qe=Se(ne,`, we can install the Google toolspec with the following command:

	`),m(V.$$.fragment,ne),ne.forEach(l),Ze=a(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-a37nc2"&&(E.textContent=ct),Ce=a(e),m(N.$$.fragment,e),Ue=a(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-piorhw"&&(R.innerHTML=mt),$e=a(e),m(H.$$.fragment,e),Ge=a(e),m(Y.$$.fragment,e),We=a(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-k8w2vg"&&(X.innerHTML=pt),Ie=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-ki6njs"&&(Q.innerHTML=dt),Be=a(e),M=i(e,"DETAILS",{});var oe=Qe(M);le=i(oe,"SUMMARY",{"data-svelte-h":!0}),r(le)!=="svelte-vevufv"&&(le.textContent=ut),Ae=Se(oe,`
As introduced in the `),S=i(oe,"A",{href:!0,"data-svelte-h":!0}),r(S)!=="svelte-16phayx"&&(S.textContent=ht),Pe=Se(oe,`, we can install the MCP toolspec with the following command:

	`),m(F.$$.fragment,oe),oe.forEach(l),_e=a(e),m(q.$$.fragment,e),ke=a(e),m(A.$$.fragment,e),Le=a(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1s3291r"&&(P.innerHTML=ft),Ve=a(e),z=i(e,"OL",{"data-svelte-h":!0}),r(z)!=="svelte-1vnf2o5"&&(z.innerHTML=Mt),Ee=a(e),T=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-luijem"&&(T.innerHTML=yt),Ne=a(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-a13dju"&&(K.innerHTML=bt),Re=a(e),m(D.$$.fragment,e),He=a(e),ie=i(e,"P",{}),Qe(ie).forEach(l),this.h()},h(){O(y,"name","hf:doc:metadata"),O(y,"content",Ct),O(w,"class","tip"),O(g,"class","tip"),O(L,"href","./llama-hub"),O(S,"href","./llama-hub"),O(T,"class","tip")},m(e,t){b(document.head,y),n(e,re,t),n(e,se,t),n(e,ce,t),p(j,e,t),n(e,me,t),n(e,v,t),n(e,pe,t),n(e,x,t),n(e,de,t),n(e,J,t),n(e,ue,t),n(e,Z,t),n(e,he,t),n(e,C,t),n(e,fe,t),p(U,e,t),n(e,Me,t),n(e,w,t),n(e,ye,t),n(e,$,t),n(e,be,t),p(G,e,t),n(e,we,t),n(e,g,t),n(e,ge,t),p(W,e,t),n(e,Te,t),n(e,I,t),n(e,je,t),p(B,e,t),n(e,ve,t),p(_,e,t),n(e,xe,t),n(e,k,t),n(e,Je,t),n(e,f,t),b(f,te),b(f,Fe),b(f,L),b(f,qe),p(V,f,null),n(e,Ze,t),n(e,E,t),n(e,Ce,t),p(N,e,t),n(e,Ue,t),n(e,R,t),n(e,$e,t),p(H,e,t),n(e,Ge,t),p(Y,e,t),n(e,We,t),n(e,X,t),n(e,Ie,t),n(e,Q,t),n(e,Be,t),n(e,M,t),b(M,le),b(M,Ae),b(M,S),b(M,Pe),p(F,M,null),n(e,_e,t),p(q,e,t),n(e,ke,t),p(A,e,t),n(e,Le,t),n(e,P,t),n(e,Ve,t),n(e,z,t),n(e,Ee,t),n(e,T,t),n(e,Ne,t),n(e,K,t),n(e,Re,t),p(D,e,t),n(e,He,t),n(e,ie,t),Ye=!0},p:gt,i(e){Ye||(d(j.$$.fragment,e),d(U.$$.fragment,e),d(G.$$.fragment,e),d(W.$$.fragment,e),d(B.$$.fragment,e),d(_.$$.fragment,e),d(V.$$.fragment,e),d(N.$$.fragment,e),d(H.$$.fragment,e),d(Y.$$.fragment,e),d(F.$$.fragment,e),d(q.$$.fragment,e),d(A.$$.fragment,e),d(D.$$.fragment,e),Ye=!0)},o(e){u(j.$$.fragment,e),u(U.$$.fragment,e),u(G.$$.fragment,e),u(W.$$.fragment,e),u(B.$$.fragment,e),u(_.$$.fragment,e),u(V.$$.fragment,e),u(N.$$.fragment,e),u(H.$$.fragment,e),u(Y.$$.fragment,e),u(F.$$.fragment,e),u(q.$$.fragment,e),u(A.$$.fragment,e),u(D.$$.fragment,e),Ye=!1},d(e){e&&(l(re),l(se),l(ce),l(me),l(v),l(pe),l(x),l(de),l(J),l(ue),l(Z),l(he),l(C),l(fe),l(Me),l(w),l(ye),l($),l(be),l(we),l(g),l(ge),l(Te),l(I),l(je),l(ve),l(xe),l(k),l(Je),l(f),l(Ze),l(E),l(Ce),l(Ue),l(R),l($e),l(Ge),l(We),l(X),l(Ie),l(Q),l(Be),l(M),l(_e),l(ke),l(Le),l(P),l(Ve),l(z),l(Ee),l(T),l(Ne),l(K),l(Re),l(He),l(ie)),l(y),h(j,e),h(U,e),h(G,e),h(W,e),h(B,e),h(_,e),h(V),h(N,e),h(H,e),h(Y,e),h(F),h(q,e),h(A,e),h(D,e)}}}const Ct='{"title":"Using Tools in LlamaIndex","local":"using-tools-in-llamaindex","sections":[{"title":"Creating a FunctionTool","local":"creating-a-functiontool","sections":[],"depth":2},{"title":"Creating a QueryEngineTool","local":"creating-a-queryenginetool","sections":[],"depth":2},{"title":"Creating Toolspecs","local":"creating-toolspecs","sections":[{"title":"Model Context Protocol (MCP) in LlamaIndex","local":"model-context-protocol-mcp-in-llamaindex","sections":[],"depth":3}],"depth":2},{"title":"Utility Tools","local":"utility-tools","sections":[],"depth":2}],"depth":1}';function Ut(ze){return Tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _t extends jt{constructor(y){super(),vt(this,y,Ut,Zt,wt,{})}}export{_t as component};
