import{s as Oe,n as et,o as tt}from"../chunks/scheduler.37c15a92.js";import{S as lt,i as st,g as i,s as n,r as M,A as nt,h as o,f as l,c as a,j as Pe,u as p,x as r,k as ve,y as at,a as s,v as y,d as u,t as J,w as T}from"../chunks/index.2bf4358c.js";import{C as Ke}from"../chunks/CodeBlock.4e987730.js";import{C as it}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as F}from"../chunks/Heading.8ada512a.js";import{E as ot}from"../chunks/getInferenceSnippets.0aa3753f.js";function rt(Ze){let c,L,H,D,m,P,d,K,w,Ge='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/retrieval_agents.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',O,h,ke="Retrieval Augmented Generation (RAG) systems combine the capabilities of data retrieval and generation models to provide context-aware responses. For example, a user’s query is passed to a search engine, and the retrieved results are given to the model along with the query. The model then generates a response based on the query and retrieved information.",ee,I,Re="Agentic RAG (Retrieval-Augmented Generation) extends traditional RAG systems by <strong>combining autonomous agents with dynamic knowledge retrieval</strong>.",te,j,Ve="While traditional RAG systems use an LLM to answer queries based on retrieved data, agentic RAG <strong>enables intelligent control of both retrieval and generation processes</strong>, improving efficiency and accuracy.",le,U,We="Traditional RAG systems face key limitations, such as <strong>relying on a single retrieval step</strong> and focusing on direct semantic similarity with the user’s query, which may overlook relevant information.",se,g,Ae="Agentic RAG addresses these issues by allowing the agent to autonomously formulate search queries, critique retrieved results, and conduct multiple retrieval steps for a more tailored and comprehensive output.",ne,b,ae,f,qe="Let’s build a simple agent that can search the web using DuckDuckGo. This agent will retrieve information and synthesize responses to answer queries. With Agentic RAG, Alfred’s agent can:",ie,C,Ee="<li>Search for latest superhero party trends</li> <li>Refine results to include luxury elements</li> <li>Synthesize information into a complete plan</li>",oe,B,Xe="Here’s how Alfred’s agent can achieve this:",re,v,ce,Z,xe="The agent follows this process:",Me,G,Ne="<li><strong>Analyzes the Request:</strong> Alfred’s agent identifies the key elements of the query—luxury superhero-themed party planning, with focus on decor, entertainment, and catering.</li> <li><strong>Performs Retrieval:</strong>  The agent leverages DuckDuckGo to search for the most relevant and up-to-date information, ensuring it aligns with Alfred’s refined preferences for a luxurious event.</li> <li><strong>Synthesizes Information:</strong> After gathering the results, the agent processes them into a cohesive, actionable plan for Alfred, covering all aspects of the party.</li> <li><strong>Stores for Future Reference:</strong> The agent stores the retrieved information for easy access when planning future events, optimizing efficiency in subsequent tasks.</li>",pe,k,ye,R,Se="For specialized tasks, a custom knowledge base can be invaluable. Let’s create a tool that queries a vector database of technical documentation or specialized knowledge. Using semantic search, the agent can find the most relevant information for Alfred’s needs.",ue,V,_e="A vector database stores numerical representations (embeddings) of text or other data, created by machine learning models. It enables semantic search by identifying similar meanings in high-dimensional space.",Je,W,Ye="This approach combines predefined knowledge with semantic search to provide context-aware solutions for event planning. With specialized knowledge access, Alfred can perfect every detail of the party.",Te,A,Qe="In this example, we’ll create a tool that retrieves party planning ideas from a custom knowledge base. We’ll use a BM25 retriever to search the knowledge base and return the top results, and <code>RecursiveCharacterTextSplitter</code> to split the documents into smaller chunks for more efficient search.",we,q,me,E,ze="This enhanced agent can:",de,X,He="<li>First check the documentation for relevant information</li> <li>Combine insights from the knowledge base</li> <li>Maintain conversation context in memory</li>",he,x,Ie,N,$e="When building agentic RAG systems, the agent can employ sophisticated strategies like:",je,S,Fe="<li><strong>Query Reformulation:</strong> Instead of using the raw user query, the agent can craft optimized search terms that better match the target documents</li> <li><strong>Query Decomposition:</strong> Instead of using the user query directly, if it contains multiple pieces of information to query, it can be decomposed to multiple queries</li> <li><strong>Query Expansion:</strong> Somehow similar to Query Reformulation but done multiple times to put the query in multiple wordings to query them all</li> <li><strong>Reranking:</strong> Using Cross-Encoders to assign more comprehensive and semantic relevance scores between retrieved documents and search query</li> <li><strong>Multi-Step Retrieval:</strong> The agent can perform multiple searches, using initial results to inform subsequent queries</li> <li><strong>Source Integration:</strong> Information can be combined from multiple sources like web search and local documentation</li> <li><strong>Result Validation:</strong> Retrieved content can be analyzed for relevance and accuracy before being included in responses</li>",Ue,_,Le="Effective agentic RAG systems require careful consideration of several key aspects. The agent <strong>should select between available tools based on the query type and context</strong>. Memory systems help maintain conversation history and avoid repetitive retrievals. Having fallback strategies ensures the system can still provide value even when primary retrieval methods fail. Additionally, implementing validation steps helps ensure the accuracy and relevance of retrieved information.",ge,Y,be,Q,De='<li><a href="https://huggingface.co/learn/cookbook/agent_rag" rel="nofollow">Agentic RAG: turbocharge your RAG with query reformulation and self-query! 🚀</a> - Recipe for developing an Agentic RAG system using smolagents.</li>',fe,z,Ce,$,Be;return m=new it({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/retrieval_agents.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),d=new F({props:{title:"Building Agentic RAG Systems",local:"building-agentic-rag-systems",headingTag:"h1"}}),b=new F({props:{title:"Basic Retrieval with DuckDuckGo",local:"basic-retrieval-with-duckduckgo",headingTag:"h2"}}),v=new Ke({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMHNlYXJjaCUyMHRvb2wlMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEElMEElMjMlMjBJbml0aWFsaXplJTIwdGhlJTIwbW9kZWwlMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJzZWFyY2hfdG9vbCU1RCUyQyUwQSklMEElMEElMjMlMjBFeGFtcGxlJTIwdXNhZ2UlMEFyZXNwb25zZSUyMCUzRCUyMGFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJTZWFyY2glMjBmb3IlMjBsdXh1cnklMjBzdXBlcmhlcm8tdGhlbWVkJTIwcGFydHklMjBpZGVhcyUyQyUyMGluY2x1ZGluZyUyMGRlY29yYXRpb25zJTJDJTIwZW50ZXJ0YWlubWVudCUyQyUyMGFuZCUyMGNhdGVyaW5nLiUyMiUwQSklMEFwcmludChyZXNwb25zZSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, InferenceClientModel

<span class="hljs-comment"># Initialize the search tool</span>
search_tool = DuckDuckGoSearchTool()

<span class="hljs-comment"># Initialize the model</span>
model = InferenceClientModel()

agent = CodeAgent(
    model=model,
    tools=[search_tool],
)

<span class="hljs-comment"># Example usage</span>
response = agent.run(
    <span class="hljs-string">&quot;Search for luxury superhero-themed party ideas, including decorations, entertainment, and catering.&quot;</span>
)
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),k=new F({props:{title:"Custom Knowledge Base Tool",local:"custom-knowledge-base-tool",headingTag:"h2"}}),q=new Ke({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PartyPlanningRetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;party_planning_retriever&quot;</span>
    description = <span class="hljs-string">&quot;Uses semantic search to retrieve relevant party planning ideas for Alfred’s superhero-themed party at Wayne Manor.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be a query related to party planning or superhero themes.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, docs, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.retriever = BM25Retriever.from_documents(
            docs, k=<span class="hljs-number">5</span>  <span class="hljs-comment"># Retrieve the top 5 documents</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>

        docs = self.retriever.invoke(
            query,
        )
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nRetrieved ideas:\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [
                <span class="hljs-string">f&quot;\\n\\n===== Idea <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content
                <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)
            ]
        )

<span class="hljs-comment"># Simulate a knowledge base about party planning</span>
party_ideas = [
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;A superhero-themed masquerade ball with luxury decor, including gold accents and velvet curtains.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Party Ideas 1&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Hire a professional DJ who can play themed music for superheroes like Batman and Wonder Woman.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Entertainment Ideas&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;For catering, serve dishes named after superheroes, like &#x27;The Hulk&#x27;s Green Smoothie&#x27; and &#x27;Iron Man&#x27;s Power Steak.&#x27;&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Catering Ideas&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Decorate with iconic superhero logos and projections of Gotham and other superhero cities around the venue.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Decoration Ideas&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Interactive experiences with VR where guests can engage in superhero simulations or compete in themed games.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Entertainment Ideas&quot;</span>}
]

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>]})
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> party_ideas
]

<span class="hljs-comment"># Split the documents into smaller chunks for more efficient search</span>
text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">500</span>,
    chunk_overlap=<span class="hljs-number">50</span>,
    add_start_index=<span class="hljs-literal">True</span>,
    strip_whitespace=<span class="hljs-literal">True</span>,
    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
)
docs_processed = text_splitter.split_documents(source_docs)

<span class="hljs-comment"># Create the retriever tool</span>
party_planning_retriever = PartyPlanningRetrieverTool(docs_processed)

<span class="hljs-comment"># Initialize the agent</span>
agent = CodeAgent(tools=[party_planning_retriever], model=InferenceClientModel())

<span class="hljs-comment"># Example usage</span>
response = agent.run(
    <span class="hljs-string">&quot;Find ideas for a luxury superhero-themed party, including entertainment, catering, and decoration options.&quot;</span>
)

<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),x=new F({props:{title:"Enhanced Retrieval Capabilities",local:"enhanced-retrieval-capabilities",headingTag:"h2"}}),Y=new F({props:{title:"Resources",local:"resources",headingTag:"h2"}}),z=new ot({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/smolagents/retrieval_agents.mdx"}}),{c(){c=i("meta"),L=n(),H=i("p"),D=n(),M(m.$$.fragment),P=n(),M(d.$$.fragment),K=n(),w=i("blockquote"),w.innerHTML=Ge,O=n(),h=i("p"),h.textContent=ke,ee=n(),I=i("p"),I.innerHTML=Re,te=n(),j=i("p"),j.innerHTML=Ve,le=n(),U=i("p"),U.innerHTML=We,se=n(),g=i("p"),g.textContent=Ae,ne=n(),M(b.$$.fragment),ae=n(),f=i("p"),f.textContent=qe,ie=n(),C=i("ul"),C.innerHTML=Ee,oe=n(),B=i("p"),B.textContent=Xe,re=n(),M(v.$$.fragment),ce=n(),Z=i("p"),Z.textContent=xe,Me=n(),G=i("ol"),G.innerHTML=Ne,pe=n(),M(k.$$.fragment),ye=n(),R=i("p"),R.textContent=Se,ue=n(),V=i("p"),V.textContent=_e,Je=n(),W=i("p"),W.textContent=Ye,Te=n(),A=i("p"),A.innerHTML=Qe,we=n(),M(q.$$.fragment),me=n(),E=i("p"),E.textContent=ze,de=n(),X=i("ol"),X.innerHTML=He,he=n(),M(x.$$.fragment),Ie=n(),N=i("p"),N.textContent=$e,je=n(),S=i("ol"),S.innerHTML=Fe,Ue=n(),_=i("p"),_.innerHTML=Le,ge=n(),M(Y.$$.fragment),be=n(),Q=i("ul"),Q.innerHTML=De,fe=n(),M(z.$$.fragment),Ce=n(),$=i("p"),this.h()},l(e){const t=nt("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(l),L=a(e),H=o(e,"P",{}),Pe(H).forEach(l),D=a(e),p(m.$$.fragment,e),P=a(e),p(d.$$.fragment,e),K=a(e),w=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-s5lv3w"&&(w.innerHTML=Ge),O=a(e),h=o(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-33rmtz"&&(h.textContent=ke),ee=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-113063o"&&(I.innerHTML=Re),te=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1xlo8ey"&&(j.innerHTML=Ve),le=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-124380o"&&(U.innerHTML=We),se=a(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1lb37r2"&&(g.textContent=Ae),ne=a(e),p(b.$$.fragment,e),ae=a(e),f=o(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1uinlt6"&&(f.textContent=qe),ie=a(e),C=o(e,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-4vqfph"&&(C.innerHTML=Ee),oe=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-jm6fh2"&&(B.textContent=Xe),re=a(e),p(v.$$.fragment,e),ce=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-21wqo5"&&(Z.textContent=xe),Me=a(e),G=o(e,"OL",{"data-svelte-h":!0}),r(G)!=="svelte-sf2q8s"&&(G.innerHTML=Ne),pe=a(e),p(k.$$.fragment,e),ye=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1jei959"&&(R.textContent=Se),ue=a(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-9ytw8z"&&(V.textContent=_e),Je=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-10x3i2g"&&(W.textContent=Ye),Te=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-drawum"&&(A.innerHTML=Qe),we=a(e),p(q.$$.fragment,e),me=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-17lgk8z"&&(E.textContent=ze),de=a(e),X=o(e,"OL",{"data-svelte-h":!0}),r(X)!=="svelte-12vtib7"&&(X.innerHTML=He),he=a(e),p(x.$$.fragment,e),Ie=a(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-gryz7r"&&(N.textContent=$e),je=a(e),S=o(e,"OL",{"data-svelte-h":!0}),r(S)!=="svelte-1h39gqd"&&(S.innerHTML=Fe),Ue=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-qnv9nq"&&(_.innerHTML=Le),ge=a(e),p(Y.$$.fragment,e),be=a(e),Q=o(e,"UL",{"data-svelte-h":!0}),r(Q)!=="svelte-1myvltt"&&(Q.innerHTML=De),fe=a(e),p(z.$$.fragment,e),Ce=a(e),$=o(e,"P",{}),Pe($).forEach(l),this.h()},h(){ve(c,"name","hf:doc:metadata"),ve(c,"content",ct),ve(w,"class","tip")},m(e,t){at(document.head,c),s(e,L,t),s(e,H,t),s(e,D,t),y(m,e,t),s(e,P,t),y(d,e,t),s(e,K,t),s(e,w,t),s(e,O,t),s(e,h,t),s(e,ee,t),s(e,I,t),s(e,te,t),s(e,j,t),s(e,le,t),s(e,U,t),s(e,se,t),s(e,g,t),s(e,ne,t),y(b,e,t),s(e,ae,t),s(e,f,t),s(e,ie,t),s(e,C,t),s(e,oe,t),s(e,B,t),s(e,re,t),y(v,e,t),s(e,ce,t),s(e,Z,t),s(e,Me,t),s(e,G,t),s(e,pe,t),y(k,e,t),s(e,ye,t),s(e,R,t),s(e,ue,t),s(e,V,t),s(e,Je,t),s(e,W,t),s(e,Te,t),s(e,A,t),s(e,we,t),y(q,e,t),s(e,me,t),s(e,E,t),s(e,de,t),s(e,X,t),s(e,he,t),y(x,e,t),s(e,Ie,t),s(e,N,t),s(e,je,t),s(e,S,t),s(e,Ue,t),s(e,_,t),s(e,ge,t),y(Y,e,t),s(e,be,t),s(e,Q,t),s(e,fe,t),y(z,e,t),s(e,Ce,t),s(e,$,t),Be=!0},p:et,i(e){Be||(u(m.$$.fragment,e),u(d.$$.fragment,e),u(b.$$.fragment,e),u(v.$$.fragment,e),u(k.$$.fragment,e),u(q.$$.fragment,e),u(x.$$.fragment,e),u(Y.$$.fragment,e),u(z.$$.fragment,e),Be=!0)},o(e){J(m.$$.fragment,e),J(d.$$.fragment,e),J(b.$$.fragment,e),J(v.$$.fragment,e),J(k.$$.fragment,e),J(q.$$.fragment,e),J(x.$$.fragment,e),J(Y.$$.fragment,e),J(z.$$.fragment,e),Be=!1},d(e){e&&(l(L),l(H),l(D),l(P),l(K),l(w),l(O),l(h),l(ee),l(I),l(te),l(j),l(le),l(U),l(se),l(g),l(ne),l(ae),l(f),l(ie),l(C),l(oe),l(B),l(re),l(ce),l(Z),l(Me),l(G),l(pe),l(ye),l(R),l(ue),l(V),l(Je),l(W),l(Te),l(A),l(we),l(me),l(E),l(de),l(X),l(he),l(Ie),l(N),l(je),l(S),l(Ue),l(_),l(ge),l(be),l(Q),l(fe),l(Ce),l($)),l(c),T(m,e),T(d,e),T(b,e),T(v,e),T(k,e),T(q,e),T(x,e),T(Y,e),T(z,e)}}}const ct='{"title":"Building Agentic RAG Systems","local":"building-agentic-rag-systems","sections":[{"title":"Basic Retrieval with DuckDuckGo","local":"basic-retrieval-with-duckduckgo","sections":[],"depth":2},{"title":"Custom Knowledge Base Tool","local":"custom-knowledge-base-tool","sections":[],"depth":2},{"title":"Enhanced Retrieval Capabilities","local":"enhanced-retrieval-capabilities","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Mt(Ze){return tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class mt extends lt{constructor(c){super(),st(this,c,Mt,rt,Oe,{})}}export{mt as component};
