import{s as ls,f as ss,n as ns,o as os}from"../chunks/scheduler.37c15a92.js";import{S as as,i as is,g as a,s as n,r as M,A as rs,h as i,f as l,c as o,j as il,u as p,x as r,k as Ee,y as Xe,a as s,v as c,d as h,t as u,w as m}from"../chunks/index.2bf4358c.js";import{C as f}from"../chunks/CodeBlock.4e987730.js";import{C as Ms}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as d}from"../chunks/Heading.8ada512a.js";import{E as ps}from"../chunks/getInferenceSnippets.0aa3753f.js";function cs(rl){let g,_e,Re,Qe,J,Fe,w,Ye,j,Ml='As we explored in <a href="https://huggingface.co/learn/agents-course/unit1/tools" rel="nofollow">unit 1</a>, agents use tools to perform various actions. In <code>smolagents</code>, tools are treated as <strong>functions that an LLM can call within an agent system</strong>.',Ne,b,pl="To interact with a tool, the LLM needs an <strong>interface description</strong> with these key components:",Se,U,cl="<li><strong>Name</strong>: What the tool is called</li> <li><strong>Tool description</strong>: What the tool does</li> <li><strong>Input types and descriptions</strong>: What arguments the tool accepts</li> <li><strong>Output type</strong>: What the tool returns</li>",Le,C,hl="For instance, while preparing for a party at Wayne Manor, Alfred needs various tools to gather information - from searching for catering services to finding party theme ideas. Here’s how a simple search tool interface might look:",qe,I,ul="<li><strong>Name:</strong> <code>web_search</code></li> <li><strong>Tool description:</strong> Searches the web for specific queries</li> <li><strong>Input:</strong> <code>query</code> (string) - The search term to look up</li> <li><strong>Output:</strong> String containing the search results</li>",ze,v,ml="By using these tools, Alfred can make informed decisions and gather all the information needed for planning the perfect party.",Pe,B,dl="Below, you can see an animation illustrating how a tool call is managed:",De,Z,yl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Agent_ManimCE.gif" alt="Agentic pipeline from https://huggingface.co/docs/smolagents/conceptual_guides/react"/>',Ke,W,Oe,G,gl="In <code>smolagents</code>, tools can be defined in two ways:",et,x,Tl="<li><strong>Using the <code>@tool</code> decorator</strong> for simple function-based tools</li> <li><strong>Creating a subclass of <code>Tool</code></strong> for more complex functionality</li>",tt,$,lt,A,fl="The <code>@tool</code> decorator is the <strong>recommended way to define simple tools</strong>. Under the hood, smolagents will parse basic information about the function from Python. So if you name your function clearly and write a good docstring, it will be easier for the LLM to use.",st,V,Jl="Using this approach, we define a function with:",nt,H,wl="<li><strong>A clear and descriptive function name</strong> that helps the LLM understand its purpose.</li> <li><strong>Type hints for both inputs and outputs</strong> to ensure proper usage.</li> <li><strong>A detailed description</strong>, including an <code>Args:</code> section where each argument is explicitly described. These descriptions provide valuable context for the LLM, so it’s important to write them carefully.</li>",ot,R,at,k,jl,it,T,bl='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/tools.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',rt,E,Ul="Let’s imagine that Alfred has already decided on the menu for the party, but now he needs help preparing food for such a large number of guests. To do so, he would like to hire a catering service and needs to identify the highest-rated options available. Alfred can leverage a tool to search for the best catering services in his area.",Mt,X,Cl="Below is an example of how Alfred can use the <code>@tool</code> decorator to make this happen:",pt,_,ct,Q,ht,F,Il='This approach involves creating a subclass of <a href="https://huggingface.co/docs/smolagents/v1.8.1/en/reference/tools#smolagents.Tool" rel="nofollow"><code>Tool</code></a>.  For complex tools, we can implement a class instead of a Python function. The class wraps the function with metadata that helps the LLM understand how to use it effectively. In this class, we define:',ut,Y,vl="<li><code>name</code>: The tool’s name.</li> <li><code>description</code>: A description used to populate the agent’s system prompt.</li> <li><code>inputs</code>: A dictionary with keys <code>type</code> and <code>description</code>, providing information to help the Python interpreter process inputs.</li> <li><code>output_type</code>: Specifies the expected output type.</li> <li><code>forward</code>: The method containing the inference logic to execute.</li>",mt,N,Bl="Below, we can see an example of a tool built using <code>Tool</code> and how to integrate it within a <code>CodeAgent</code>.",dt,S,yt,L,Zl="Alfred’s party at the mansion is a <strong>superhero-themed event</strong>, but he needs some creative ideas to make it truly special. As a fantastic host, he wants to surprise the guests with a unique theme.",gt,q,Wl="To do this, he can use an agent that generates superhero-themed party ideas based on a given category. This way, Alfred can find the perfect party theme to wow his guests.",Tt,z,ft,P,Gl="With this tool, Alfred will be the ultimate super host, impressing his guests with a superhero-themed party they won’t forget! 🦸‍♂️🦸‍♀️",Jt,D,wt,K,xl='<code>smolagents</code> comes with a set of pre-built tools that can be directly injected into your agent. The <a href="https://huggingface.co/docs/smolagents/guided_tour?build-a-tool=Decorate+a+function+with+%40tool#default-toolbox" rel="nofollow">default toolbox</a> includes:',jt,O,$l="<li><strong>PythonInterpreterTool</strong></li> <li><strong>FinalAnswerTool</strong></li> <li><strong>UserInputTool</strong></li> <li><strong>DuckDuckGoSearchTool</strong></li> <li><strong>GoogleSearchTool</strong></li> <li><strong>VisitWebpageTool</strong></li>",bt,ee,Al="Alfred could use various tools to ensure a flawless party at Wayne Manor:",Ut,te,Vl="<li><p>First, he could use the <code>DuckDuckGoSearchTool</code> to find creative superhero-themed party ideas.</p></li> <li><p>For catering, he’d rely on the <code>GoogleSearchTool</code> to find the highest-rated services in Gotham.</p></li> <li><p>To manage seating arrangements, Alfred could run calculations with the <code>PythonInterpreterTool</code>.</p></li> <li><p>Once everything is gathered, he’d compile the plan using the <code>FinalAnswerTool</code>.</p></li>",Ct,le,Hl="With these tools, Alfred guarantees the party is both exceptional and seamless. 🦇💡",It,se,vt,ne,Rl="One of the most powerful features of <strong>smolagents</strong> is its ability to share custom tools on the Hub and seamlessly integrate tools created by the community. This includes connecting with <strong>HF Spaces</strong> and <strong>LangChain tools</strong>, significantly enhancing Alfred’s ability to orchestrate an unforgettable party at Wayne Manor. 🎭",Bt,oe,kl="With these integrations, Alfred can tap into advanced event-planning tools—whether it’s adjusting the lighting for the perfect ambiance, curating the ideal playlist for the party, or coordinating with Gotham’s finest caterers.",Zt,ae,El="Here are examples showcasing how these functionalities can elevate the party experience:",Wt,ie,Gt,re,Xl="Sharing your custom tool with the community is easy! Simply upload it to your Hugging Face account using the <code>push_to_hub()</code> method.",xt,Me,_l="For instance, Alfred can share his <code>party_theme_tool</code> to help others find the best catering services in Gotham. Here’s how to do it:",$t,pe,At,ce,Vt,he,Ql="You can easily import tools created by other users using the <code>load_tool()</code> function. For example, Alfred might want to generate a promotional image for the party using AI. Instead of building a tool from scratch, he can leverage a predefined one from the community:",Ht,ue,Rt,me,kt,de,Fl="You can also import a HF Space as a tool using <code>Tool.from_space()</code>. This opens up possibilities for integrating with thousands of spaces from the community for tasks from image generation to data analysis.",Et,ye,Yl="The tool will connect with the spaces Gradio backend using the <code>gradio_client</code>, so make sure to install it via <code>pip</code> if you don’t have it already.",Xt,ge,Nl="For the party, Alfred can use an existing HF Space for the generation of the AI-generated image to be used in the announcement (instead of the pre-built tool we mentioned before). Let’s build it!",_t,Te,Qt,fe,Ft,Je,Sl="We’ll discuss the <code>LangChain</code> framework in upcoming sections. For now, we just note that we can reuse LangChain tools in your smolagents workflow!",Yt,we,Ll="You can easily load LangChain tools using the <code>Tool.from_langchain()</code> method. Alfred, ever the perfectionist, is preparing for a spectacular superhero night at Wayne Manor while the Waynes are away. To make sure every detail exceeds expectations, he taps into LangChain tools to find top-tier entertainment ideas.",Nt,je,ql="By using <code>Tool.from_langchain()</code>, Alfred effortlessly adds advanced search functionalities to his smolagent, enabling him to discover exclusive party ideas and services with just a few commands.",St,be,zl="Here’s how he does it:",Lt,Ue,qt,Ce,zt,Ie,Pl='<code>smolagents</code> also allows importing tools from the hundreds of MCP servers available on <a href="https://glama.ai/mcp/servers" rel="nofollow">glama.ai</a> or <a href="https://smithery.ai" rel="nofollow">smithery.ai</a>. If you want to dive deeper about MCP, you can check our <a href="https://huggingface.co/learn/mcp-course/" rel="nofollow">free MCP Course</a>.',Pt,y,Ae,Dl="Install mcp client",ol,Ve,Kl="We first need to install the <code>mcp</code> integration for <code>smolagents</code>.",al,ve,Dt,Be,Ol="The MCP servers tools can be loaded in a ToolCollection object as follow:",Kt,Ze,Ot,We,es="With this setup, Alfred can quickly discover luxurious entertainment options, ensuring Gotham’s elite guests have an unforgettable experience. This tool helps him curate the perfect superhero-themed event for Wayne Manor! 🎉",el,Ge,tl,xe,ts='<li><a href="https://huggingface.co/docs/smolagents/tutorials/tools" rel="nofollow">Tools Tutorial</a> - Explore this tutorial to learn how to work with tools effectively.</li> <li><a href="https://huggingface.co/docs/smolagents/v1.8.1/en/reference/tools" rel="nofollow">Tools Documentation</a> - Comprehensive reference documentation on tools.</li> <li><a href="https://huggingface.co/docs/smolagents/v1.8.1/en/guided_tour#tools" rel="nofollow">Tools Guided Tour</a> - A step-by-step guided tour to help you build and utilize tools efficiently.</li> <li><a href="https://huggingface.co/docs/smolagents/tutorials/building_good_agents" rel="nofollow">Building Effective Agents</a> - A detailed guide on best practices for developing reliable and high-performance custom function agents.</li>',ll,$e,sl,ke,nl;return J=new Ms({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/tools.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),w=new d({props:{title:"Tools",local:"tools",headingTag:"h1"}}),W=new d({props:{title:"Tool Creation Methods",local:"tool-creation-methods",headingTag:"h2"}}),$=new d({props:{title:"The @tool Decorator",local:"the-tool-decorator",headingTag:"h3"}}),R=new d({props:{title:"Generating a tool that retrieves the highest-rated catering",local:"generating-a-tool-that-retrieves-the-highest-rated-catering",headingTag:"h4"}}),_=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel, tool

<span class="hljs-comment"># Let&#x27;s pretend we have a function that fetches the highest-rated catering services.</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">catering_service_tool</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    This tool returns the highest-rated catering service in Gotham City.

    Args:
        query: A search term for finding catering services.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Example list of catering services and their ratings</span>
    services = {
        <span class="hljs-string">&quot;Gotham Catering Co.&quot;</span>: <span class="hljs-number">4.9</span>,
        <span class="hljs-string">&quot;Wayne Manor Catering&quot;</span>: <span class="hljs-number">4.8</span>,
        <span class="hljs-string">&quot;Gotham City Events&quot;</span>: <span class="hljs-number">4.7</span>,
    }

    <span class="hljs-comment"># Find the highest rated catering service (simulating search query filtering)</span>
    best_service = <span class="hljs-built_in">max</span>(services, key=services.get)

    <span class="hljs-keyword">return</span> best_service


agent = CodeAgent(tools=[catering_service_tool], model=InferenceClientModel())

<span class="hljs-comment"># Run the agent to find the best catering service</span>
result = agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the highest-rated catering service in Gotham City?&quot;</span>
)

<span class="hljs-built_in">print</span>(result)   <span class="hljs-comment"># Output: Gotham Catering Co.</span>`,wrap:!1}}),Q=new d({props:{title:"Defining a Tool as a Python Class",local:"defining-a-tool-as-a-python-class",headingTag:"h3"}}),S=new d({props:{title:"Generating a tool to generate ideas about the superhero-themed party",local:"generating-a-tool-to-generate-ideas-about-the-superhero-themed-party",headingTag:"h4"}}),z=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool, CodeAgent, InferenceClientModel

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SuperheroPartyThemeTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;superhero_party_theme_generator&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This tool suggests creative superhero-themed party ideas based on a category.
    It returns a unique party theme idea.&quot;&quot;&quot;</span>

    inputs = {
        <span class="hljs-string">&quot;category&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The type of superhero party (e.g., &#x27;classic heroes&#x27;, &#x27;villain masquerade&#x27;, &#x27;futuristic Gotham&#x27;).&quot;</span>,
        }
    }

    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, category: <span class="hljs-built_in">str</span></span>):
        themes = {
            <span class="hljs-string">&quot;classic heroes&quot;</span>: <span class="hljs-string">&quot;Justice League Gala: Guests come dressed as their favorite DC heroes with themed cocktails like &#x27;The Kryptonite Punch&#x27;.&quot;</span>,
            <span class="hljs-string">&quot;villain masquerade&quot;</span>: <span class="hljs-string">&quot;Gotham Rogues&#x27; Ball: A mysterious masquerade where guests dress as classic Batman villains.&quot;</span>,
            <span class="hljs-string">&quot;futuristic Gotham&quot;</span>: <span class="hljs-string">&quot;Neo-Gotham Night: A cyberpunk-style party inspired by Batman Beyond, with neon decorations and futuristic gadgets.&quot;</span>
        }

        <span class="hljs-keyword">return</span> themes.get(category.lower(), <span class="hljs-string">&quot;Themed party idea not found. Try &#x27;classic heroes&#x27;, &#x27;villain masquerade&#x27;, or &#x27;futuristic Gotham&#x27;.&quot;</span>)

<span class="hljs-comment"># Instantiate the tool</span>
party_theme_tool = SuperheroPartyThemeTool()
agent = CodeAgent(tools=[party_theme_tool], model=InferenceClientModel())

<span class="hljs-comment"># Run the agent to generate a party theme idea</span>
result = agent.run(
    <span class="hljs-string">&quot;What would be a good superhero party idea for a &#x27;villain masquerade&#x27; theme?&quot;</span>
)

<span class="hljs-built_in">print</span>(result)  <span class="hljs-comment"># Output: &quot;Gotham Rogues&#x27; Ball: A mysterious masquerade where guests dress as classic Batman villains.&quot;</span>`,wrap:!1}}),D=new d({props:{title:"Default Toolbox",local:"default-toolbox",headingTag:"h2"}}),se=new d({props:{title:"Sharing and Importing Tools",local:"sharing-and-importing-tools",headingTag:"h2"}}),ie=new d({props:{title:"Sharing a Tool to the Hub",local:"sharing-a-tool-to-the-hub",headingTag:"h3"}}),pe=new f({props:{code:"cGFydHlfdGhlbWVfdG9vbC5wdXNoX3RvX2h1YiglMjIlN0J5b3VyX3VzZXJuYW1lJTdEJTJGcGFydHlfdGhlbWVfdG9vbCUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'party_theme_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/party_theme_tool&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),ce=new d({props:{title:"Importing a Tool from the Hub",local:"importing-a-tool-from-the-hub",headingTag:"h3"}}),ue=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQWltYWdlX2dlbmVyYXRpb25fdG9vbCUyMCUzRCUyMGxvYWRfdG9vbCglMEElMjAlMjAlMjAlMjAlMjJtLXJpYyUyRnRleHQtdG8taW1hZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKCklMEEpJTBBJTBBYWdlbnQucnVuKCUyMkdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMG9mJTIwYSUyMGx1eHVyaW91cyUyMHN1cGVyaGVyby10aGVtZWQlMjBwYXJ0eSUyMGF0JTIwV2F5bmUlMjBNYW5vciUyMHdpdGglMjBtYWRlLXVwJTIwc3VwZXJoZXJvcy4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent, InferenceClientModel

image_generation_tool = load_tool(
    <span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)

agent = CodeAgent(
    tools=[image_generation_tool],
    model=InferenceClientModel()
)

agent.run(<span class="hljs-string">&quot;Generate an image of a luxurious superhero-themed party at Wayne Manor with made-up superheros.&quot;</span>)`,wrap:!1}}),me=new d({props:{title:"Importing a Hugging Face Space as a Tool",local:"importing-a-hugging-face-space-as-a-tool",headingTag:"h3"}}),Te=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFRvb2wlMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fc3BhY2UoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJpbWFnZV9nZW5lcmF0b3IlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMkdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMGZyb20lMjBhJTIwcHJvbXB0JTIyJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwoJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCaW1hZ2VfZ2VuZXJhdGlvbl90b29sJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCklMEElMEFhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySW1wcm92ZSUyMHRoaXMlMjBwcm9tcHQlMkMlMjB0aGVuJTIwZ2VuZXJhdGUlMjBhbiUyMGltYWdlJTIwb2YlMjBpdC4lMjIlMkMlMEElMjAlMjAlMjAlMjBhZGRpdGlvbmFsX2FyZ3MlM0QlN0IndXNlcl9wcm9tcHQnJTNBJTIwJ0ElMjBncmFuZCUyMHN1cGVyaGVyby10aGVtZWQlMjBwYXJ0eSUyMGF0JTIwV2F5bmUlMjBNYW5vciUyQyUyMHdpdGglMjBBbGZyZWQlMjBvdmVyc2VlaW5nJTIwYSUyMGx1eHVyaW91cyUyMGdhbGEnJTdEJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel, Tool

image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

model = InferenceClientModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>,
    additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A grand superhero-themed party at Wayne Manor, with Alfred overseeing a luxurious gala&#x27;</span>}
)`,wrap:!1}}),fe=new d({props:{title:"Importing a LangChain Tool",local:"importing-a-langchain-tool",headingTag:"h3"}}),Ue=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFRvb2wlMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMFRvb2wuZnJvbV9sYW5nY2hhaW4obG9hZF90b29scyglNUIlMjJzZXJwYXBpJTIyJTVEKSU1QjAlNUQpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJzZWFyY2hfdG9vbCU1RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBJTBBYWdlbnQucnVuKCUyMlNlYXJjaCUyMGZvciUyMGx1eHVyeSUyMGVudGVydGFpbm1lbnQlMjBpZGVhcyUyMGZvciUyMGElMjBzdXBlcmhlcm8tdGhlbWVkJTIwZXZlbnQlMkMlMjBzdWNoJTIwYXMlMjBsaXZlJTIwcGVyZm9ybWFuY2VzJTIwYW5kJTIwaW50ZXJhY3RpdmUlMjBleHBlcmllbmNlcy4lMjIp",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel, Tool

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;Search for luxury entertainment ideas for a superhero-themed event, such as live performances and interactive experiences.&quot;</span>)`,wrap:!1}}),Ce=new d({props:{title:"Importing a tool collection from any MCP server",local:"importing-a-tool-collection-from-any-mcp-server",headingTag:"h3"}}),ve=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMnNtb2xhZ2VudHMlNUJtY3AlNUQlMjI=",highlighted:'pip install <span class="hljs-string">&quot;smolagents[mcp]&quot;</span>',wrap:!1}}),Ze=new f({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMFRvb2xDb2xsZWN0aW9uJTJDJTIwQ29kZUFnZW50JTBBZnJvbSUyMG1jcCUyMGltcG9ydCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyUwQWZyb20lMjBzbW9sYWdlbnRzJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwlMEElMEElMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEElMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyMFRvb2xDb2xsZWN0aW9uLmZyb21fbWNwKHNlcnZlcl9wYXJhbWV0ZXJzJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUyMGFzJTIwdG9vbF9jb2xsZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel


model = InferenceClientModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)


server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),Ge=new d({props:{title:"Resources",local:"resources",headingTag:"h2"}}),$e=new ps({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/smolagents/tools.mdx"}}),{c(){g=a("meta"),_e=n(),Re=a("p"),Qe=n(),M(J.$$.fragment),Fe=n(),M(w.$$.fragment),Ye=n(),j=a("p"),j.innerHTML=Ml,Ne=n(),b=a("p"),b.innerHTML=pl,Se=n(),U=a("ul"),U.innerHTML=cl,Le=n(),C=a("p"),C.textContent=hl,qe=n(),I=a("ul"),I.innerHTML=ul,ze=n(),v=a("p"),v.textContent=ml,Pe=n(),B=a("p"),B.textContent=dl,De=n(),Z=a("p"),Z.innerHTML=yl,Ke=n(),M(W.$$.fragment),Oe=n(),G=a("p"),G.innerHTML=gl,et=n(),x=a("ol"),x.innerHTML=Tl,tt=n(),M($.$$.fragment),lt=n(),A=a("p"),A.innerHTML=fl,st=n(),V=a("p"),V.textContent=Jl,nt=n(),H=a("ul"),H.innerHTML=wl,ot=n(),M(R.$$.fragment),at=n(),k=a("img"),it=n(),T=a("blockquote"),T.innerHTML=bl,rt=n(),E=a("p"),E.textContent=Ul,Mt=n(),X=a("p"),X.innerHTML=Cl,pt=n(),M(_.$$.fragment),ct=n(),M(Q.$$.fragment),ht=n(),F=a("p"),F.innerHTML=Il,ut=n(),Y=a("ul"),Y.innerHTML=vl,mt=n(),N=a("p"),N.innerHTML=Bl,dt=n(),M(S.$$.fragment),yt=n(),L=a("p"),L.innerHTML=Zl,gt=n(),q=a("p"),q.textContent=Wl,Tt=n(),M(z.$$.fragment),ft=n(),P=a("p"),P.textContent=Gl,Jt=n(),M(D.$$.fragment),wt=n(),K=a("p"),K.innerHTML=xl,jt=n(),O=a("ul"),O.innerHTML=$l,bt=n(),ee=a("p"),ee.textContent=Al,Ut=n(),te=a("ul"),te.innerHTML=Vl,Ct=n(),le=a("p"),le.textContent=Hl,It=n(),M(se.$$.fragment),vt=n(),ne=a("p"),ne.innerHTML=Rl,Bt=n(),oe=a("p"),oe.textContent=kl,Zt=n(),ae=a("p"),ae.textContent=El,Wt=n(),M(ie.$$.fragment),Gt=n(),re=a("p"),re.innerHTML=Xl,xt=n(),Me=a("p"),Me.innerHTML=_l,$t=n(),M(pe.$$.fragment),At=n(),M(ce.$$.fragment),Vt=n(),he=a("p"),he.innerHTML=Ql,Ht=n(),M(ue.$$.fragment),Rt=n(),M(me.$$.fragment),kt=n(),de=a("p"),de.innerHTML=Fl,Et=n(),ye=a("p"),ye.innerHTML=Yl,Xt=n(),ge=a("p"),ge.textContent=Nl,_t=n(),M(Te.$$.fragment),Qt=n(),M(fe.$$.fragment),Ft=n(),Je=a("p"),Je.innerHTML=Sl,Yt=n(),we=a("p"),we.innerHTML=Ll,Nt=n(),je=a("p"),je.innerHTML=ql,St=n(),be=a("p"),be.textContent=zl,Lt=n(),M(Ue.$$.fragment),qt=n(),M(Ce.$$.fragment),zt=n(),Ie=a("p"),Ie.innerHTML=Pl,Pt=n(),y=a("details"),Ae=a("summary"),Ae.textContent=Dl,ol=n(),Ve=a("p"),Ve.innerHTML=Kl,al=n(),M(ve.$$.fragment),Dt=n(),Be=a("p"),Be.textContent=Ol,Kt=n(),M(Ze.$$.fragment),Ot=n(),We=a("p"),We.textContent=es,el=n(),M(Ge.$$.fragment),tl=n(),xe=a("ul"),xe.innerHTML=ts,ll=n(),M($e.$$.fragment),sl=n(),ke=a("p"),this.h()},l(e){const t=rs("svelte-u9bgzb",document.head);g=i(t,"META",{name:!0,content:!0}),t.forEach(l),_e=o(e),Re=i(e,"P",{}),il(Re).forEach(l),Qe=o(e),p(J.$$.fragment,e),Fe=o(e),p(w.$$.fragment,e),Ye=o(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-11yvg4r"&&(j.innerHTML=Ml),Ne=o(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1w4pglg"&&(b.innerHTML=pl),Se=o(e),U=i(e,"UL",{"data-svelte-h":!0}),r(U)!=="svelte-6t5tqb"&&(U.innerHTML=cl),Le=o(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-xxdm5o"&&(C.textContent=hl),qe=o(e),I=i(e,"UL",{"data-svelte-h":!0}),r(I)!=="svelte-1y8sxu4"&&(I.innerHTML=ul),ze=o(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1s1gqsf"&&(v.textContent=ml),Pe=o(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-gwhed0"&&(B.textContent=dl),De=o(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1j9zfgm"&&(Z.innerHTML=yl),Ke=o(e),p(W.$$.fragment,e),Oe=o(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-16o4n5p"&&(G.innerHTML=gl),et=o(e),x=i(e,"OL",{"data-svelte-h":!0}),r(x)!=="svelte-12j65du"&&(x.innerHTML=Tl),tt=o(e),p($.$$.fragment,e),lt=o(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1dh93c8"&&(A.innerHTML=fl),st=o(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1hsdx6m"&&(V.textContent=Jl),nt=o(e),H=i(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-1eycwmn"&&(H.innerHTML=wl),ot=o(e),p(R.$$.fragment,e),at=o(e),k=i(e,"IMG",{src:!0,alt:!0}),it=o(e),T=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-1bxj2l0"&&(T.innerHTML=bl),rt=o(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-5qyq1f"&&(E.textContent=Ul),Mt=o(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1f9djim"&&(X.innerHTML=Cl),pt=o(e),p(_.$$.fragment,e),ct=o(e),p(Q.$$.fragment,e),ht=o(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-o654lj"&&(F.innerHTML=Il),ut=o(e),Y=i(e,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-9qay4f"&&(Y.innerHTML=vl),mt=o(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1pi6ccj"&&(N.innerHTML=Bl),dt=o(e),p(S.$$.fragment,e),yt=o(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1ugsnpu"&&(L.innerHTML=Zl),gt=o(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1t4n8j6"&&(q.textContent=Wl),Tt=o(e),p(z.$$.fragment,e),ft=o(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-148a819"&&(P.textContent=Gl),Jt=o(e),p(D.$$.fragment,e),wt=o(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1se8fk8"&&(K.innerHTML=xl),jt=o(e),O=i(e,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-1n5ilxc"&&(O.innerHTML=$l),bt=o(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-13b0t4l"&&(ee.textContent=Al),Ut=o(e),te=i(e,"UL",{"data-svelte-h":!0}),r(te)!=="svelte-3o3ymr"&&(te.innerHTML=Vl),Ct=o(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-13o2uyy"&&(le.textContent=Hl),It=o(e),p(se.$$.fragment,e),vt=o(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-bfnw4l"&&(ne.innerHTML=Rl),Bt=o(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-p4tufw"&&(oe.textContent=kl),Zt=o(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-fsw72s"&&(ae.textContent=El),Wt=o(e),p(ie.$$.fragment,e),Gt=o(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1cmmx6"&&(re.innerHTML=Xl),xt=o(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-2q1hux"&&(Me.innerHTML=_l),$t=o(e),p(pe.$$.fragment,e),At=o(e),p(ce.$$.fragment,e),Vt=o(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1xtes2g"&&(he.innerHTML=Ql),Ht=o(e),p(ue.$$.fragment,e),Rt=o(e),p(me.$$.fragment,e),kt=o(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1mpb2vu"&&(de.innerHTML=Fl),Et=o(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-lat3p2"&&(ye.innerHTML=Yl),Xt=o(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1694k70"&&(ge.textContent=Nl),_t=o(e),p(Te.$$.fragment,e),Qt=o(e),p(fe.$$.fragment,e),Ft=o(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1osr2dc"&&(Je.innerHTML=Sl),Yt=o(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-n7r7ow"&&(we.innerHTML=Ll),Nt=o(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-sjrzcz"&&(je.innerHTML=ql),St=o(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-154co1f"&&(be.textContent=zl),Lt=o(e),p(Ue.$$.fragment,e),qt=o(e),p(Ce.$$.fragment,e),zt=o(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-eejp75"&&(Ie.innerHTML=Pl),Pt=o(e),y=i(e,"DETAILS",{});var He=il(y);Ae=i(He,"SUMMARY",{"data-svelte-h":!0}),r(Ae)!=="svelte-17v5fx6"&&(Ae.textContent=Dl),ol=o(He),Ve=i(He,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1yjphc7"&&(Ve.innerHTML=Kl),al=o(He),p(ve.$$.fragment,He),He.forEach(l),Dt=o(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1ki4qbm"&&(Be.textContent=Ol),Kt=o(e),p(Ze.$$.fragment,e),Ot=o(e),We=i(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1yv1f1"&&(We.textContent=es),el=o(e),p(Ge.$$.fragment,e),tl=o(e),xe=i(e,"UL",{"data-svelte-h":!0}),r(xe)!=="svelte-1gwl39i"&&(xe.innerHTML=ts),ll=o(e),p($e.$$.fragment,e),sl=o(e),ke=i(e,"P",{}),il(ke).forEach(l),this.h()},h(){Ee(g,"name","hf:doc:metadata"),Ee(g,"content",hs),ss(k.src,jl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-catering.jpg")||Ee(k,"src",jl),Ee(k,"alt","Alfred Catering"),Ee(T,"class","tip")},m(e,t){Xe(document.head,g),s(e,_e,t),s(e,Re,t),s(e,Qe,t),c(J,e,t),s(e,Fe,t),c(w,e,t),s(e,Ye,t),s(e,j,t),s(e,Ne,t),s(e,b,t),s(e,Se,t),s(e,U,t),s(e,Le,t),s(e,C,t),s(e,qe,t),s(e,I,t),s(e,ze,t),s(e,v,t),s(e,Pe,t),s(e,B,t),s(e,De,t),s(e,Z,t),s(e,Ke,t),c(W,e,t),s(e,Oe,t),s(e,G,t),s(e,et,t),s(e,x,t),s(e,tt,t),c($,e,t),s(e,lt,t),s(e,A,t),s(e,st,t),s(e,V,t),s(e,nt,t),s(e,H,t),s(e,ot,t),c(R,e,t),s(e,at,t),s(e,k,t),s(e,it,t),s(e,T,t),s(e,rt,t),s(e,E,t),s(e,Mt,t),s(e,X,t),s(e,pt,t),c(_,e,t),s(e,ct,t),c(Q,e,t),s(e,ht,t),s(e,F,t),s(e,ut,t),s(e,Y,t),s(e,mt,t),s(e,N,t),s(e,dt,t),c(S,e,t),s(e,yt,t),s(e,L,t),s(e,gt,t),s(e,q,t),s(e,Tt,t),c(z,e,t),s(e,ft,t),s(e,P,t),s(e,Jt,t),c(D,e,t),s(e,wt,t),s(e,K,t),s(e,jt,t),s(e,O,t),s(e,bt,t),s(e,ee,t),s(e,Ut,t),s(e,te,t),s(e,Ct,t),s(e,le,t),s(e,It,t),c(se,e,t),s(e,vt,t),s(e,ne,t),s(e,Bt,t),s(e,oe,t),s(e,Zt,t),s(e,ae,t),s(e,Wt,t),c(ie,e,t),s(e,Gt,t),s(e,re,t),s(e,xt,t),s(e,Me,t),s(e,$t,t),c(pe,e,t),s(e,At,t),c(ce,e,t),s(e,Vt,t),s(e,he,t),s(e,Ht,t),c(ue,e,t),s(e,Rt,t),c(me,e,t),s(e,kt,t),s(e,de,t),s(e,Et,t),s(e,ye,t),s(e,Xt,t),s(e,ge,t),s(e,_t,t),c(Te,e,t),s(e,Qt,t),c(fe,e,t),s(e,Ft,t),s(e,Je,t),s(e,Yt,t),s(e,we,t),s(e,Nt,t),s(e,je,t),s(e,St,t),s(e,be,t),s(e,Lt,t),c(Ue,e,t),s(e,qt,t),c(Ce,e,t),s(e,zt,t),s(e,Ie,t),s(e,Pt,t),s(e,y,t),Xe(y,Ae),Xe(y,ol),Xe(y,Ve),Xe(y,al),c(ve,y,null),s(e,Dt,t),s(e,Be,t),s(e,Kt,t),c(Ze,e,t),s(e,Ot,t),s(e,We,t),s(e,el,t),c(Ge,e,t),s(e,tl,t),s(e,xe,t),s(e,ll,t),c($e,e,t),s(e,sl,t),s(e,ke,t),nl=!0},p:ns,i(e){nl||(h(J.$$.fragment,e),h(w.$$.fragment,e),h(W.$$.fragment,e),h($.$$.fragment,e),h(R.$$.fragment,e),h(_.$$.fragment,e),h(Q.$$.fragment,e),h(S.$$.fragment,e),h(z.$$.fragment,e),h(D.$$.fragment,e),h(se.$$.fragment,e),h(ie.$$.fragment,e),h(pe.$$.fragment,e),h(ce.$$.fragment,e),h(ue.$$.fragment,e),h(me.$$.fragment,e),h(Te.$$.fragment,e),h(fe.$$.fragment,e),h(Ue.$$.fragment,e),h(Ce.$$.fragment,e),h(ve.$$.fragment,e),h(Ze.$$.fragment,e),h(Ge.$$.fragment,e),h($e.$$.fragment,e),nl=!0)},o(e){u(J.$$.fragment,e),u(w.$$.fragment,e),u(W.$$.fragment,e),u($.$$.fragment,e),u(R.$$.fragment,e),u(_.$$.fragment,e),u(Q.$$.fragment,e),u(S.$$.fragment,e),u(z.$$.fragment,e),u(D.$$.fragment,e),u(se.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(me.$$.fragment,e),u(Te.$$.fragment,e),u(fe.$$.fragment,e),u(Ue.$$.fragment,e),u(Ce.$$.fragment,e),u(ve.$$.fragment,e),u(Ze.$$.fragment,e),u(Ge.$$.fragment,e),u($e.$$.fragment,e),nl=!1},d(e){e&&(l(_e),l(Re),l(Qe),l(Fe),l(Ye),l(j),l(Ne),l(b),l(Se),l(U),l(Le),l(C),l(qe),l(I),l(ze),l(v),l(Pe),l(B),l(De),l(Z),l(Ke),l(Oe),l(G),l(et),l(x),l(tt),l(lt),l(A),l(st),l(V),l(nt),l(H),l(ot),l(at),l(k),l(it),l(T),l(rt),l(E),l(Mt),l(X),l(pt),l(ct),l(ht),l(F),l(ut),l(Y),l(mt),l(N),l(dt),l(yt),l(L),l(gt),l(q),l(Tt),l(ft),l(P),l(Jt),l(wt),l(K),l(jt),l(O),l(bt),l(ee),l(Ut),l(te),l(Ct),l(le),l(It),l(vt),l(ne),l(Bt),l(oe),l(Zt),l(ae),l(Wt),l(Gt),l(re),l(xt),l(Me),l($t),l(At),l(Vt),l(he),l(Ht),l(Rt),l(kt),l(de),l(Et),l(ye),l(Xt),l(ge),l(_t),l(Qt),l(Ft),l(Je),l(Yt),l(we),l(Nt),l(je),l(St),l(be),l(Lt),l(qt),l(zt),l(Ie),l(Pt),l(y),l(Dt),l(Be),l(Kt),l(Ot),l(We),l(el),l(tl),l(xe),l(ll),l(sl),l(ke)),l(g),m(J,e),m(w,e),m(W,e),m($,e),m(R,e),m(_,e),m(Q,e),m(S,e),m(z,e),m(D,e),m(se,e),m(ie,e),m(pe,e),m(ce,e),m(ue,e),m(me,e),m(Te,e),m(fe,e),m(Ue,e),m(Ce,e),m(ve),m(Ze,e),m(Ge,e),m($e,e)}}}const hs='{"title":"Tools","local":"tools","sections":[{"title":"Tool Creation Methods","local":"tool-creation-methods","sections":[{"title":"The @tool Decorator","local":"the-tool-decorator","sections":[{"title":"Generating a tool that retrieves the highest-rated catering","local":"generating-a-tool-that-retrieves-the-highest-rated-catering","sections":[],"depth":4}],"depth":3},{"title":"Defining a Tool as a Python Class","local":"defining-a-tool-as-a-python-class","sections":[{"title":"Generating a tool to generate ideas about the superhero-themed party","local":"generating-a-tool-to-generate-ideas-about-the-superhero-themed-party","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Default Toolbox","local":"default-toolbox","sections":[],"depth":2},{"title":"Sharing and Importing Tools","local":"sharing-and-importing-tools","sections":[{"title":"Sharing a Tool to the Hub","local":"sharing-a-tool-to-the-hub","sections":[],"depth":3},{"title":"Importing a Tool from the Hub","local":"importing-a-tool-from-the-hub","sections":[],"depth":3},{"title":"Importing a Hugging Face Space as a Tool","local":"importing-a-hugging-face-space-as-a-tool","sections":[],"depth":3},{"title":"Importing a LangChain Tool","local":"importing-a-langchain-tool","sections":[],"depth":3},{"title":"Importing a tool collection from any MCP server","local":"importing-a-tool-collection-from-any-mcp-server","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function us(rl){return os(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Js extends as{constructor(g){super(),is(this,g,us,cs,ls,{})}}export{Js as component};
