import{s as xt,f as Xt,n as Qt,o as _t}from"../chunks/scheduler.37c15a92.js";import{S as Nt,i as St,g as i,s as a,r,A as Rt,h as o,f as l,c as n,j as at,u as y,x as M,k as m,y as Yt,a as s,v as p,d as c,t as w,w as h}from"../chunks/index.2bf4358c.js";import{C as d}from"../chunks/CodeBlock.4e987730.js";import{C as Ht}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as st}from"../chunks/Heading.8ada512a.js";import{E as Et}from"../chunks/getInferenceSnippets.0aa3753f.js";function zt(nt){let u,ye,Me,pe,b,ce,I,we,U,it=`<p>The examples in this section require access to a powerful VLM model. We tested them using the GPT-4o API.<br/>
However, <a href="./why_use_smolagents">Why use smolagents</a> discusses alternative solutions supported by smolagents and Hugging Face. If you’d like to explore other options, be sure to check that section.</p>`,he,g,ot="Empowering agents with visual capabilities is crucial for solving tasks that go beyond text processing. Many real-world challenges, such as web browsing or document understanding, require analyzing rich visual content. Fortunately, <code>smolagents</code> provides built-in support for vision-language models (VLMs), enabling agents to process and interpret images effectively.",Je,f,Mt="In this example, imagine Alfred, the butler at Wayne Manor, is tasked with verifying the identities of the guests attending the party. As you can imagine, Alfred may not be familiar with everyone arriving. To help him, we can use an agent that verifies their identity by searching for visual information about their appearance using a VLM. This will allow Alfred to make informed decisions about who can enter. Let’s build this example!",me,C,ue,T,rt='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/vision_agents.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',de,B,yt="In this approach, images are passed to the agent at the start and stored as <code>task_images</code> alongside the task prompt. The agent then processes these images throughout its execution.",Ue,v,pt="Consider the case where Alfred wants to verify the identities of the superheroes attending the party. He already has a dataset of images from previous parties with the names of the guests. Given a new visitor’s image, the agent can compare it with the existing dataset and make a decision about letting them in.",Te,G,ct="In this case, a guest is trying to enter, and Alfred suspects that this visitor might be The Joker impersonating Wonder Woman. Alfred needs to verify their identity to prevent anyone unwanted from entering.",je,Z,wt="Let’s build the example. First, the images are loaded. In this case, we use images from Wikipedia to keep the example minimal, but imagine the possible use-case!",be,W,Ie,k,ht="Now that we have the images, the agent will tell us whether one guest is actually a superhero (Wonder Woman) or a villain (The Joker).",ge,V,fe,A,Jt="In the case of my run, the output is the following, although it could vary in your case, as we’ve already discussed:",Ce,x,Be,X,mt="In this case, the output reveals that the person is impersonating someone else, so we can prevent The Joker from entering the party!",ve,Q,Ge,j,ut='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/vision_web_browser.py" target="_blank">this Python file</a></p>',Ze,_,dt="The previous approach is valuable and has many potential use cases. However, in situations where the guest is not in the database, we need to explore other ways of identifying them. One possible solution is to dynamically retrieve images and information from external sources, such as browsing the web for details.",We,N,Ut="In this approach, images are dynamically added to the agent’s memory during execution. As we know, agents in <code>smolagents</code> are based on the <code>MultiStepAgent</code> class, which is an abstraction of the ReAct framework. This class operates in a structured cycle where various variables and knowledge are logged at different stages:",ke,S,Tt="<li><strong>SystemPromptStep:</strong> Stores the system prompt.</li> <li><strong>TaskStep:</strong> Logs the user query and any provided input.</li> <li><strong>ActionStep:</strong> Captures logs from the agent’s actions and results.</li>",Ve,R,jt="This structured approach allows agents to incorporate visual information dynamically and respond adaptively to evolving tasks. Below is the diagram we’ve already seen, illustrating the dynamic workflow process and how different steps integrate within the agent lifecycle. When browsing, the agent can take screenshots and save them as <code>observation_images</code> in the <code>ActionStep</code>.",Ae,Y,bt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/smolagents-can-see/diagram_adding_vlms_smolagents.png" alt="Dynamic image retrieval"/>',xe,H,It="Now that we understand the need, let’s build our complete example. In this case, Alfred wants full control over the guest verification process, so browsing for details becomes a viable solution. To complete this example, we need a new set of tools for the agent. Additionally, we’ll use Selenium and Helium, which are browser automation tools. This will allow us to build an agent that explores the web, searching for details about a potential guest and retrieving verification information. Let’s install the tools needed:",Xe,E,Qe,z,gt="We’ll need a set of agent tools specifically designed for browsing, such as <code>search_item_ctrl_f</code>, <code>go_back</code>, and <code>close_popups</code>. These tools allow the agent to act like a person navigating the web.",_e,$,Ne,F,ft="We also need functionality for saving screenshots, as this will be an essential part of what our VLM agent uses to complete the task. This functionality captures the screenshot and saves it in <code>step_log.observations_images = [image.copy()]</code>, allowing the agent to store and process the images dynamically as it navigates.",Se,q,Re,L,Ct="This function is passed to the agent as <code>step_callback</code>, as it’s triggered at the end of each step during the agent’s execution. This allows the agent to dynamically capture and store screenshots throughout its process.",Ye,P,Bt="Now, we can generate our vision agent for browsing the web, providing it with the tools we created, along with the <code>DuckDuckGoSearchTool</code> to explore the web. This tool will help the agent retrieve necessary information for verifying guests’ identities based on visual cues.",He,D,Ee,K,vt="With that, Alfred is ready to check the guests’ identities and make informed decisions about whether to let them into the party:",ze,O,$e,ee,Gt="You can see that we include <code>helium_instructions</code> as part of the task. This special prompt is aimed to control the navigation of the agent, ensuring that it follows the correct steps while browsing the web.",Fe,te,Zt="Let’s see how this works in the video below:",qe,J,Wt,Le,le,kt="This is the final output:",Pe,se,De,ae,Vt="With all of that, we’ve successfully created our identity verifier for the party! Alfred now has the necessary tools to ensure only the right guests make it through the door. Everything is set to have a good time at Wayne Manor!",Ke,ne,Oe,ie,At='<li><a href="https://huggingface.co/blog/smolagents-can-see" rel="nofollow">We just gave sight to smolagents</a> - Blog describing the vision agent functionality.</li> <li><a href="https://huggingface.co/docs/smolagents/examples/web_browser" rel="nofollow">Web Browser Automation with Agents 🤖🌐</a> - Example for Web browsing using a vision agent.</li> <li><a href="https://github.com/huggingface/smolagents/blob/main/src/smolagents/vision_web_browser.py" rel="nofollow">Web Browser Vision Agent Example</a> - Example for Web browsing using a vision agent.</li>',et,oe,tt,re,lt;return b=new Ht({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/vision_agents.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),I=new st({props:{title:"Vision Agents with smolagents",local:"vision-agents-with-smolagents",headingTag:"h1"}}),C=new st({props:{title:"Providing Images at the Start of the Agent’s Execution",local:"providing-images-at-the-start-of-the-agents-execution",headingTag:"h2"}}),W=new d({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBJTBBaW1hZ2VfdXJscyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGZSUyRmU4JTJGVGhlX0pva2VyX2F0X1dheF9NdXNldW1fUGx1cy5qcGclMjIlMkMlMjAlMjMlMjBKb2tlciUyMGltYWdlJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cGxvYWQud2lraW1lZGlhLm9yZyUyRndpa2lwZWRpYSUyRmVuJTJGOSUyRjk4JTJGSm9rZXJfJTI1MjhEQ19Db21pY3NfY2hhcmFjdGVyJTI1MjkuanBnJTIyJTIwJTIzJTIwSm9rZXIlMjBpbWFnZSUwQSU1RCUwQSUwQWltYWdlcyUyMCUzRCUyMCU1QiU1RCUwQWZvciUyMHVybCUyMGluJTIwaW1hZ2VfdXJscyUzQSUwQSUyMCUyMCUyMCUyMGhlYWRlcnMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJVc2VyLUFnZW50JTIyJTNBJTIwJTIyTW96aWxsYSUyRjUuMCUyMChXaW5kb3dzJTIwTlQlMjAxMC4wJTNCJTIwV2luNjQlM0IlMjB4NjQpJTIwQXBwbGVXZWJLaXQlMkY1MzcuMzYlMjAoS0hUTUwlMkMlMjBsaWtlJTIwR2Vja28pJTIwQ2hyb21lJTJGMTE0LjAuMC4wJTIwU2FmYXJpJTJGNTM3LjM2JTIyJTIwJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsJTJDaGVhZGVycyUzRGhlYWRlcnMpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUyMCUyMCUyMCUyMGltYWdlcy5hcHBlbmQoaW1hZ2Up",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

image_urls = [
    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/e/e8/The_Joker_at_Wax_Museum_Plus.jpg&quot;</span>, <span class="hljs-comment"># Joker image</span>
    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/en/9/98/Joker_%28DC_Comics_character%29.jpg&quot;</span> <span class="hljs-comment"># Joker image</span>
]

images = []
<span class="hljs-keyword">for</span> url <span class="hljs-keyword">in</span> image_urls:
    headers = {
        <span class="hljs-string">&quot;User-Agent&quot;</span>: <span class="hljs-string">&quot;Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36&quot;</span> 
    }
    response = requests.get(url,headers=headers)
    image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
    images.append(image)`,wrap:!1}}),V=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBPcGVuQUlTZXJ2ZXJNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwT3BlbkFJU2VydmVyTW9kZWwobW9kZWxfaWQlM0QlMjJncHQtNG8lMjIpJTBBJTBBJTIzJTIwSW5zdGFudGlhdGUlMjB0aGUlMjBhZ2VudCUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDIwJTJDJTBBJTIwJTIwJTIwJTIwdmVyYm9zaXR5X2xldmVsJTNEMiUwQSklMEElMEFyZXNwb25zZSUyMCUzRCUyMGFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBEZXNjcmliZSUyMHRoZSUyMGNvc3R1bWUlMjBhbmQlMjBtYWtldXAlMjB0aGF0JTIwdGhlJTIwY29taWMlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZXNlJTIwcGhvdG9zJTIwaXMlMjB3ZWFyaW5nJTIwYW5kJTIwcmV0dXJuJTIwdGhlJTIwZGVzY3JpcHRpb24uJTBBJTIwJTIwJTIwJTIwVGVsbCUyMG1lJTIwaWYlMjB0aGUlMjBndWVzdCUyMGlzJTIwVGhlJTIwSm9rZXIlMjBvciUyMFdvbmRlciUyMFdvbWFuLiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlcyUzRGltYWdlcyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, OpenAIServerModel

model = OpenAIServerModel(model_id=<span class="hljs-string">&quot;gpt-4o&quot;</span>)

<span class="hljs-comment"># Instantiate the agent</span>
agent = CodeAgent(
    tools=[],
    model=model,
    max_steps=<span class="hljs-number">20</span>,
    verbosity_level=<span class="hljs-number">2</span>
)

response = agent.run(
    <span class="hljs-string">&quot;&quot;&quot;
    Describe the costume and makeup that the comic character in these photos is wearing and return the description.
    Tell me if the guest is The Joker or Wonder Woman.
    &quot;&quot;&quot;</span>,
    images=images
)`,wrap:!1}}),x=new d({props:{code:"JTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ0Nvc3R1bWUlMjBhbmQlMjBNYWtldXAlMjAtJTIwRmlyc3QlMjBJbWFnZSclM0ElMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ1B1cnBsZSUyMGNvYXQlMjBhbmQlMjBhJTIwcHVycGxlJTIwc2lsay1saWtlJTIwY3JhdmF0JTIwb3IlMjB0aWUlMjBvdmVyJTIwYSUyMG11c3RhcmQteWVsbG93JTIwc2hpcnQuJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdXaGl0ZSUyMGZhY2UlMjBwYWludCUyMHdpdGglMjBleGFnZ2VyYXRlZCUyMGZlYXR1cmVzJTJDJTIwZGFyayUyMGV5ZWJyb3dzJTJDJTIwYmx1ZSUyMGV5ZSUyMG1ha2V1cCUyQyUyMHJlZCUyMGxpcHMlMjBmb3JtaW5nJTIwYSUyMHdpZGUlMjBzbWlsZS4nJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdDb3N0dW1lJTIwYW5kJTIwTWFrZXVwJTIwLSUyMFNlY29uZCUyMEltYWdlJyUzQSUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnRGFyayUyMHN1aXQlMjB3aXRoJTIwYSUyMGZsb3dlciUyMG9uJTIwdGhlJTIwbGFwZWwlMkMlMjBob2xkaW5nJTIwYSUyMHBsYXlpbmclMjBjYXJkLiclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnUGFsZSUyMHNraW4lMkMlMjBncmVlbiUyMGhhaXIlMkMlMjB2ZXJ5JTIwcmVkJTIwbGlwcyUyMHdpdGglMjBhbiUyMGV4YWdnZXJhdGVkJTIwZ3Jpbi4nJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdDaGFyYWN0ZXIlMjBJZGVudGl0eSclM0ElMjAnVGhpcyUyMGNoYXJhY3RlciUyMHJlc2VtYmxlcyUyMGtub3duJTIwZGVwaWN0aW9ucyUyMG9mJTIwVGhlJTIwSm9rZXIlMjBmcm9tJTIwY29taWMlMjBib29rJTIwbWVkaWEuJyUwQSUyMCUyMCUyMCUyMCU3RA==",highlighted:`    {
        <span class="hljs-string">&#x27;Costume and Makeup - First Image&#x27;</span>: (
            <span class="hljs-string">&#x27;Purple coat and a purple silk-like cravat or tie over a mustard-yellow shirt.&#x27;</span>,
            <span class="hljs-string">&#x27;White face paint with exaggerated features, dark eyebrows, blue eye makeup, red lips forming a wide smile.&#x27;</span>
        ),
        <span class="hljs-string">&#x27;Costume and Makeup - Second Image&#x27;</span>: (
            <span class="hljs-string">&#x27;Dark suit with a flower on the lapel, holding a playing card.&#x27;</span>,
            <span class="hljs-string">&#x27;Pale skin, green hair, very red lips with an exaggerated grin.&#x27;</span>
        ),
        <span class="hljs-string">&#x27;Character Identity&#x27;</span>: <span class="hljs-string">&#x27;This character resembles known depictions of The Joker from comic book media.&#x27;</span>
    }`,wrap:!1}}),Q=new st({props:{title:"Providing Images with Dynamic Retrieval",local:"providing-images-with-dynamic-retrieval",headingTag:"h2"}}),E=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMnNtb2xhZ2VudHMlNUJhbGwlNUQlMjIlMjBoZWxpdW0lMjBzZWxlbml1bSUyMHB5dGhvbi1kb3RlbnY=",highlighted:'pip install <span class="hljs-string">&quot;smolagents[all]&quot;</span> helium selenium python-dotenv',wrap:!1}}),$=new d({props:{code:"JTQwdG9vbCUwQWRlZiUyMHNlYXJjaF9pdGVtX2N0cmxfZih0ZXh0JTNBJTIwc3RyJTJDJTIwbnRoX3Jlc3VsdCUzQSUyMGludCUyMCUzRCUyMDEpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMFNlYXJjaGVzJTIwZm9yJTIwdGV4dCUyMG9uJTIwdGhlJTIwY3VycmVudCUyMHBhZ2UlMjB2aWElMjBDdHJsJTIwJTJCJTIwRiUyMGFuZCUyMGp1bXBzJTIwdG8lMjB0aGUlMjBudGglMjBvY2N1cnJlbmNlLiUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZXh0JTNBJTIwVGhlJTIwdGV4dCUyMHRvJTIwc2VhcmNoJTIwZm9yJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnRoX3Jlc3VsdCUzQSUyMFdoaWNoJTIwb2NjdXJyZW5jZSUyMHRvJTIwanVtcCUyMHRvJTIwKGRlZmF1bHQlM0ElMjAxKSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGVsZW1lbnRzJTIwJTNEJTIwZHJpdmVyLmZpbmRfZWxlbWVudHMoQnkuWFBBVEglMkMlMjBmJTIyJTJGJTJGKiU1QmNvbnRhaW5zKHRleHQoKSUyQyUyMCclN0J0ZXh0JTdEJyklNUQlMjIpJTBBJTIwJTIwJTIwJTIwaWYlMjBudGhfcmVzdWx0JTIwJTNFJTIwbGVuKGVsZW1lbnRzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwRXhjZXB0aW9uKGYlMjJNYXRjaCUyMG4lQzIlQjAlN0JudGhfcmVzdWx0JTdEJTIwbm90JTIwZm91bmQlMjAob25seSUyMCU3QmxlbihlbGVtZW50cyklN0QlMjBtYXRjaGVzJTIwZm91bmQpJTIyKSUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMGYlMjJGb3VuZCUyMCU3QmxlbihlbGVtZW50cyklN0QlMjBtYXRjaGVzJTIwZm9yJTIwJyU3QnRleHQlN0QnLiUyMiUwQSUyMCUyMCUyMCUyMGVsZW0lMjAlM0QlMjBlbGVtZW50cyU1Qm50aF9yZXN1bHQlMjAtJTIwMSU1RCUwQSUyMCUyMCUyMCUyMGRyaXZlci5leGVjdXRlX3NjcmlwdCglMjJhcmd1bWVudHMlNUIwJTVELnNjcm9sbEludG9WaWV3KHRydWUpJTNCJTIyJTJDJTIwZWxlbSklMEElMjAlMjAlMjAlMjByZXN1bHQlMjAlMkIlM0QlMjBmJTIyRm9jdXNlZCUyMG9uJTIwZWxlbWVudCUyMCU3Qm50aF9yZXN1bHQlN0QlMjBvZiUyMCU3QmxlbihlbGVtZW50cyklN0QlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXN1bHQlMEElMEElMEElNDB0b29sJTBBZGVmJTIwZ29fYmFjaygpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJHb2VzJTIwYmFjayUyMHRvJTIwcHJldmlvdXMlMjBwYWdlLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGRyaXZlci5iYWNrKCklMEElMEElMEElNDB0b29sJTBBZGVmJTIwY2xvc2VfcG9wdXBzKCklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwQ2xvc2VzJTIwYW55JTIwdmlzaWJsZSUyMG1vZGFsJTIwb3IlMjBwb3AtdXAlMjBvbiUyMHRoZSUyMHBhZ2UuJTIwVXNlJTIwdGhpcyUyMHRvJTIwZGlzbWlzcyUyMHBvcC11cCUyMHdpbmRvd3MhJTIwVGhpcyUyMGRvZXMlMjBub3QlMjB3b3JrJTIwb24lMjBjb29raWUlMjBjb25zZW50JTIwYmFubmVycy4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjB3ZWJkcml2ZXIuQWN0aW9uQ2hhaW5zKGRyaXZlcikuc2VuZF9rZXlzKEtleXMuRVNDQVBFKS5wZXJmb3JtKCk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">search_item_ctrl_f</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span>, nth_result: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Searches for text on the current page via Ctrl + F and jumps to the nth occurrence.
    Args:
        text: The text to search for
        nth_result: Which occurrence to jump to (default: 1)
    &quot;&quot;&quot;</span>
    elements = driver.find_elements(By.XPATH, <span class="hljs-string">f&quot;//*[contains(text(), &#x27;<span class="hljs-subst">{text}</span>&#x27;)]&quot;</span>)
    <span class="hljs-keyword">if</span> nth_result &gt; <span class="hljs-built_in">len</span>(elements):
        <span class="hljs-keyword">raise</span> Exception(<span class="hljs-string">f&quot;Match n°<span class="hljs-subst">{nth_result}</span> not found (only <span class="hljs-subst">{<span class="hljs-built_in">len</span>(elements)}</span> matches found)&quot;</span>)
    result = <span class="hljs-string">f&quot;Found <span class="hljs-subst">{<span class="hljs-built_in">len</span>(elements)}</span> matches for &#x27;<span class="hljs-subst">{text}</span>&#x27;.&quot;</span>
    elem = elements[nth_result - <span class="hljs-number">1</span>]
    driver.execute_script(<span class="hljs-string">&quot;arguments[0].scrollIntoView(true);&quot;</span>, elem)
    result += <span class="hljs-string">f&quot;Focused on element <span class="hljs-subst">{nth_result}</span> of <span class="hljs-subst">{<span class="hljs-built_in">len</span>(elements)}</span>&quot;</span>
    <span class="hljs-keyword">return</span> result


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">go_back</span>() -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-string">&quot;&quot;&quot;Goes back to previous page.&quot;&quot;&quot;</span>
    driver.back()


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">close_popups</span>() -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Closes any visible modal or pop-up on the page. Use this to dismiss pop-up windows! This does not work on cookie consent banners.
    &quot;&quot;&quot;</span>
    webdriver.ActionChains(driver).send_keys(Keys.ESCAPE).perform()`,wrap:!1}}),q=new d({props:{code:"ZGVmJTIwc2F2ZV9zY3JlZW5zaG90KHN0ZXBfbG9nJTNBJTIwQWN0aW9uU3RlcCUyQyUyMGFnZW50JTNBJTIwQ29kZUFnZW50KSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwc2xlZXAoMS4wKSUyMCUyMCUyMyUyMExldCUyMEphdmFTY3JpcHQlMjBhbmltYXRpb25zJTIwaGFwcGVuJTIwYmVmb3JlJTIwdGFraW5nJTIwdGhlJTIwc2NyZWVuc2hvdCUwQSUyMCUyMCUyMCUyMGRyaXZlciUyMCUzRCUyMGhlbGl1bS5nZXRfZHJpdmVyKCklMEElMjAlMjAlMjAlMjBjdXJyZW50X3N0ZXAlMjAlM0QlMjBzdGVwX2xvZy5zdGVwX251bWJlciUwQSUyMCUyMCUyMCUyMGlmJTIwZHJpdmVyJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwc3RlcF9sb2dzJTIwaW4lMjBhZ2VudC5sb2dzJTNBJTIwJTIwJTIzJTIwUmVtb3ZlJTIwcHJldmlvdXMlMjBzY3JlZW5zaG90cyUyMGZyb20lMjBsb2dzJTIwZm9yJTIwbGVhbiUyMHByb2Nlc3NpbmclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGlzaW5zdGFuY2Uoc3RlcF9sb2clMkMlMjBBY3Rpb25TdGVwKSUyMGFuZCUyMHN0ZXBfbG9nLnN0ZXBfbnVtYmVyJTIwJTNDJTNEJTIwY3VycmVudF9zdGVwJTIwLSUyMDIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVwX2xvZ3Mub2JzZXJ2YXRpb25zX2ltYWdlcyUyMCUzRCUyME5vbmUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwbmdfYnl0ZXMlMjAlM0QlMjBkcml2ZXIuZ2V0X3NjcmVlbnNob3RfYXNfcG5nKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4oQnl0ZXNJTyhwbmdfYnl0ZXMpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjJDYXB0dXJlZCUyMGElMjBicm93c2VyJTIwc2NyZWVuc2hvdCUzQSUyMCU3QmltYWdlLnNpemUlN0QlMjBwaXhlbHMlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlcF9sb2cub2JzZXJ2YXRpb25zX2ltYWdlcyUyMCUzRCUyMCU1QmltYWdlLmNvcHkoKSU1RCUyMCUyMCUyMyUyMENyZWF0ZSUyMGElMjBjb3B5JTIwdG8lMjBlbnN1cmUlMjBpdCUyMHBlcnNpc3RzJTJDJTIwaW1wb3J0YW50ISUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFVwZGF0ZSUyMG9ic2VydmF0aW9ucyUyMHdpdGglMjBjdXJyZW50JTIwVVJMJTBBJTIwJTIwJTIwJTIwdXJsX2luZm8lMjAlM0QlMjBmJTIyQ3VycmVudCUyMHVybCUzQSUyMCU3QmRyaXZlci5jdXJyZW50X3VybCU3RCUyMiUwQSUyMCUyMCUyMCUyMHN0ZXBfbG9nLm9ic2VydmF0aW9ucyUyMCUzRCUyMHVybF9pbmZvJTIwaWYlMjBzdGVwX2xvZ3Mub2JzZXJ2YXRpb25zJTIwaXMlMjBOb25lJTIwZWxzZSUyMHN0ZXBfbG9nLm9ic2VydmF0aW9ucyUyMCUyQiUyMCUyMiU1Q24lMjIlMjAlMkIlMjB1cmxfaW5mbyUwQSUyMCUyMCUyMCUyMHJldHVybg==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">save_screenshot</span>(<span class="hljs-params">step_log: ActionStep, agent: CodeAgent</span>) -&gt; <span class="hljs-literal">None</span>:
    sleep(<span class="hljs-number">1.0</span>)  <span class="hljs-comment"># Let JavaScript animations happen before taking the screenshot</span>
    driver = helium.get_driver()
    current_step = step_log.step_number
    <span class="hljs-keyword">if</span> driver <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">for</span> step_logs <span class="hljs-keyword">in</span> agent.logs:  <span class="hljs-comment"># Remove previous screenshots from logs for lean processing</span>
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(step_log, ActionStep) <span class="hljs-keyword">and</span> step_log.step_number &lt;= current_step - <span class="hljs-number">2</span>:
                step_logs.observations_images = <span class="hljs-literal">None</span>
        png_bytes = driver.get_screenshot_as_png()
        image = Image.<span class="hljs-built_in">open</span>(BytesIO(png_bytes))
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Captured a browser screenshot: <span class="hljs-subst">{image.size}</span> pixels&quot;</span>)
        step_log.observations_images = [image.copy()]  <span class="hljs-comment"># Create a copy to ensure it persists, important!</span>

    <span class="hljs-comment"># Update observations with current URL</span>
    url_info = <span class="hljs-string">f&quot;Current url: <span class="hljs-subst">{driver.current_url}</span>&quot;</span>
    step_log.observations = url_info <span class="hljs-keyword">if</span> step_logs.observations <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> step_log.observations + <span class="hljs-string">&quot;\\n&quot;</span> + url_info
    <span class="hljs-keyword">return</span>`,wrap:!1}}),D=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBPcGVuQUlTZXJ2ZXJNb2RlbCUyQyUyMER1Y2tEdWNrR29TZWFyY2hUb29sJTBBbW9kZWwlMjAlM0QlMjBPcGVuQUlTZXJ2ZXJNb2RlbChtb2RlbF9pZCUzRCUyMmdwdC00byUyMiklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QkR1Y2tEdWNrR29TZWFyY2hUb29sKCklMkMlMjBnb19iYWNrJTJDJTIwY2xvc2VfcG9wdXBzJTJDJTIwc2VhcmNoX2l0ZW1fY3RybF9mJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFkZGl0aW9uYWxfYXV0aG9yaXplZF9pbXBvcnRzJTNEJTVCJTIyaGVsaXVtJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RlcF9jYWxsYmFja3MlM0QlNUJzYXZlX3NjcmVlbnNob3QlNUQlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMHZlcmJvc2l0eV9sZXZlbCUzRDIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, OpenAIServerModel, DuckDuckGoSearchTool
model = OpenAIServerModel(model_id=<span class="hljs-string">&quot;gpt-4o&quot;</span>)

agent = CodeAgent(
    tools=[DuckDuckGoSearchTool(), go_back, close_popups, search_item_ctrl_f],
    model=model,
    additional_authorized_imports=[<span class="hljs-string">&quot;helium&quot;</span>],
    step_callbacks=[save_screenshot],
    max_steps=<span class="hljs-number">20</span>,
    verbosity_level=<span class="hljs-number">2</span>,
)`,wrap:!1}}),O=new d({props:{code:"YWdlbnQucnVuKCUyMiUyMiUyMiUwQUklMjBhbSUyMEFsZnJlZCUyQyUyMHRoZSUyMGJ1dGxlciUyMG9mJTIwV2F5bmUlMjBNYW5vciUyQyUyMHJlc3BvbnNpYmxlJTIwZm9yJTIwdmVyaWZ5aW5nJTIwdGhlJTIwaWRlbnRpdHklMjBvZiUyMGd1ZXN0cyUyMGF0JTIwcGFydHkuJTIwQSUyMHN1cGVyaGVybyUyMGhhcyUyMGFycml2ZWQlMjBhdCUyMHRoZSUyMGVudHJhbmNlJTIwY2xhaW1pbmclMjB0byUyMGJlJTIwV29uZGVyJTIwV29tYW4lMkMlMjBidXQlMjBJJTIwbmVlZCUyMHRvJTIwY29uZmlybSUyMGlmJTIwc2hlJTIwaXMlMjB3aG8lMjBzaGUlMjBzYXlzJTIwc2hlJTIwaXMuJTBBJTBBUGxlYXNlJTIwc2VhcmNoJTIwZm9yJTIwaW1hZ2VzJTIwb2YlMjBXb25kZXIlMjBXb21hbiUyMGFuZCUyMGdlbmVyYXRlJTIwYSUyMGRldGFpbGVkJTIwdmlzdWFsJTIwZGVzY3JpcHRpb24lMjBiYXNlZCUyMG9uJTIwdGhvc2UlMjBpbWFnZXMuJTIwQWRkaXRpb25hbGx5JTJDJTIwbmF2aWdhdGUlMjB0byUyMFdpa2lwZWRpYSUyMHRvJTIwZ2F0aGVyJTIwa2V5JTIwZGV0YWlscyUyMGFib3V0JTIwaGVyJTIwYXBwZWFyYW5jZS4lMjBXaXRoJTIwdGhpcyUyMGluZm9ybWF0aW9uJTJDJTIwSSUyMGNhbiUyMGRldGVybWluZSUyMHdoZXRoZXIlMjB0byUyMGdyYW50JTIwaGVyJTIwYWNjZXNzJTIwdG8lMjB0aGUlMjBldmVudC4lMEElMjIlMjIlMjIlMjAlMkIlMjBoZWxpdW1faW5zdHJ1Y3Rpb25zKQ==",highlighted:`agent.run(<span class="hljs-string">&quot;&quot;&quot;
I am Alfred, the butler of Wayne Manor, responsible for verifying the identity of guests at party. A superhero has arrived at the entrance claiming to be Wonder Woman, but I need to confirm if she is who she says she is.

Please search for images of Wonder Woman and generate a detailed visual description based on those images. Additionally, navigate to Wikipedia to gather key details about her appearance. With this information, I can determine whether to grant her access to the event.
&quot;&quot;&quot;</span> + helium_instructions)`,wrap:!1}}),se=new d({props:{code:"RmluYWwlMjBhbnN3ZXIlM0ElMjBXb25kZXIlMjBXb21hbiUyMGlzJTIwdHlwaWNhbGx5JTIwZGVwaWN0ZWQlMjB3ZWFyaW5nJTIwYSUyMHJlZCUyMGFuZCUyMGdvbGQlMjBidXN0aWVyJTJDJTIwYmx1ZSUyMHNob3J0cyUyMG9yJTIwc2tpcnQlMjB3aXRoJTIwd2hpdGUlMjBzdGFycyUyQyUyMGElMjBnb2xkZW4lMjB0aWFyYSUyQyUyMHNpbHZlciUyMGJyYWNlbGV0cyUyQyUyMGFuZCUyMGElMjBnb2xkZW4lMjBMYXNzbyUyMG9mJTIwVHJ1dGguJTIwU2hlJTIwaXMlMjBQcmluY2VzcyUyMERpYW5hJTIwb2YlMjBUaGVteXNjaXJhJTJDJTIwa25vd24lMjBhcyUyMERpYW5hJTIwUHJpbmNlJTIwaW4lMjB0aGUlMjB3b3JsZCUyMG9mJTIwbWVuLg==",highlighted:'Final answer: Wonder Woman <span class="hljs-keyword">is</span> typically depicted wearing a red <span class="hljs-keyword">and</span> gold bustier, blue shorts <span class="hljs-keyword">or</span> skirt <span class="hljs-keyword">with</span> white stars, a golden tiara, silver bracelets, <span class="hljs-keyword">and</span> a golden Lasso of Truth. She <span class="hljs-keyword">is</span> Princess Diana of Themyscira, known <span class="hljs-keyword">as</span> Diana Prince <span class="hljs-keyword">in</span> the world of men.',wrap:!1}}),ne=new st({props:{title:"Further Reading",local:"further-reading",headingTag:"h2"}}),oe=new Et({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/smolagents/vision_agents.mdx"}}),{c(){u=i("meta"),ye=a(),Me=i("p"),pe=a(),r(b.$$.fragment),ce=a(),r(I.$$.fragment),we=a(),U=i("blockquote"),U.innerHTML=it,he=a(),g=i("p"),g.innerHTML=ot,Je=a(),f=i("p"),f.textContent=Mt,me=a(),r(C.$$.fragment),ue=a(),T=i("blockquote"),T.innerHTML=rt,de=a(),B=i("p"),B.innerHTML=yt,Ue=a(),v=i("p"),v.textContent=pt,Te=a(),G=i("p"),G.textContent=ct,je=a(),Z=i("p"),Z.textContent=wt,be=a(),r(W.$$.fragment),Ie=a(),k=i("p"),k.textContent=ht,ge=a(),r(V.$$.fragment),fe=a(),A=i("p"),A.textContent=Jt,Ce=a(),r(x.$$.fragment),Be=a(),X=i("p"),X.textContent=mt,ve=a(),r(Q.$$.fragment),Ge=a(),j=i("blockquote"),j.innerHTML=ut,Ze=a(),_=i("p"),_.textContent=dt,We=a(),N=i("p"),N.innerHTML=Ut,ke=a(),S=i("ol"),S.innerHTML=Tt,Ve=a(),R=i("p"),R.innerHTML=jt,Ae=a(),Y=i("p"),Y.innerHTML=bt,xe=a(),H=i("p"),H.textContent=It,Xe=a(),r(E.$$.fragment),Qe=a(),z=i("p"),z.innerHTML=gt,_e=a(),r($.$$.fragment),Ne=a(),F=i("p"),F.innerHTML=ft,Se=a(),r(q.$$.fragment),Re=a(),L=i("p"),L.innerHTML=Ct,Ye=a(),P=i("p"),P.innerHTML=Bt,He=a(),r(D.$$.fragment),Ee=a(),K=i("p"),K.textContent=vt,ze=a(),r(O.$$.fragment),$e=a(),ee=i("p"),ee.innerHTML=Gt,Fe=a(),te=i("p"),te.textContent=Zt,qe=a(),J=i("iframe"),Le=a(),le=i("p"),le.textContent=kt,Pe=a(),r(se.$$.fragment),De=a(),ae=i("p"),ae.textContent=Vt,Ke=a(),r(ne.$$.fragment),Oe=a(),ie=i("ul"),ie.innerHTML=At,et=a(),r(oe.$$.fragment),tt=a(),re=i("p"),this.h()},l(e){const t=Rt("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(l),ye=n(e),Me=o(e,"P",{}),at(Me).forEach(l),pe=n(e),y(b.$$.fragment,e),ce=n(e),y(I.$$.fragment,e),we=n(e),U=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(U)!=="svelte-1yatm6d"&&(U.innerHTML=it),he=n(e),g=o(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1g52ok1"&&(g.innerHTML=ot),Je=n(e),f=o(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-myhrzo"&&(f.textContent=Mt),me=n(e),y(C.$$.fragment,e),ue=n(e),T=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(T)!=="svelte-zoou4c"&&(T.innerHTML=rt),de=n(e),B=o(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-cav1cd"&&(B.innerHTML=yt),Ue=n(e),v=o(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-dz13nx"&&(v.textContent=pt),Te=n(e),G=o(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1gdr077"&&(G.textContent=ct),je=n(e),Z=o(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1b86gbf"&&(Z.textContent=wt),be=n(e),y(W.$$.fragment,e),Ie=n(e),k=o(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1biumjp"&&(k.textContent=ht),ge=n(e),y(V.$$.fragment,e),fe=n(e),A=o(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-8ztzdn"&&(A.textContent=Jt),Ce=n(e),y(x.$$.fragment,e),Be=n(e),X=o(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1btcjd5"&&(X.textContent=mt),ve=n(e),y(Q.$$.fragment,e),Ge=n(e),j=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(j)!=="svelte-fblc4c"&&(j.innerHTML=ut),Ze=n(e),_=o(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-snegxf"&&(_.textContent=dt),We=n(e),N=o(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-cbqleh"&&(N.innerHTML=Ut),ke=n(e),S=o(e,"OL",{"data-svelte-h":!0}),M(S)!=="svelte-sp2fa7"&&(S.innerHTML=Tt),Ve=n(e),R=o(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1xu745q"&&(R.innerHTML=jt),Ae=n(e),Y=o(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-1ds9sjb"&&(Y.innerHTML=bt),xe=n(e),H=o(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-k9it6v"&&(H.textContent=It),Xe=n(e),y(E.$$.fragment,e),Qe=n(e),z=o(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-18m9rfq"&&(z.innerHTML=gt),_e=n(e),y($.$$.fragment,e),Ne=n(e),F=o(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-gyap3u"&&(F.innerHTML=ft),Se=n(e),y(q.$$.fragment,e),Re=n(e),L=o(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-13yatx1"&&(L.innerHTML=Ct),Ye=n(e),P=o(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-1im8u68"&&(P.innerHTML=Bt),He=n(e),y(D.$$.fragment,e),Ee=n(e),K=o(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-1w3h7ql"&&(K.textContent=vt),ze=n(e),y(O.$$.fragment,e),$e=n(e),ee=o(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-17wb0kz"&&(ee.innerHTML=Gt),Fe=n(e),te=o(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-cyg54y"&&(te.textContent=Zt),qe=n(e),J=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0,referrerpolicy:!0}),at(J).forEach(l),Le=n(e),le=o(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-1487vwm"&&(le.textContent=kt),Pe=n(e),y(se.$$.fragment,e),De=n(e),ae=o(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-1chr9du"&&(ae.textContent=Vt),Ke=n(e),y(ne.$$.fragment,e),Oe=n(e),ie=o(e,"UL",{"data-svelte-h":!0}),M(ie)!=="svelte-17l37zv"&&(ie.innerHTML=At),et=n(e),y(oe.$$.fragment,e),tt=n(e),re=o(e,"P",{}),at(re).forEach(l),this.h()},h(){m(u,"name","hf:doc:metadata"),m(u,"content",$t),m(U,"class","warning"),m(T,"class","tip"),m(j,"class","tip"),m(J,"width","560"),m(J,"height","315"),Xt(J.src,Wt="https://www.youtube.com/embed/rObJel7-OLc?si=TnNwQ8rqXqun_pqE")||m(J,"src",Wt),m(J,"title","YouTube video player"),m(J,"frameborder","0"),m(J,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"),m(J,"referrerpolicy","strict-origin-when-cross-origin"),J.allowFullscreen=""},m(e,t){Yt(document.head,u),s(e,ye,t),s(e,Me,t),s(e,pe,t),p(b,e,t),s(e,ce,t),p(I,e,t),s(e,we,t),s(e,U,t),s(e,he,t),s(e,g,t),s(e,Je,t),s(e,f,t),s(e,me,t),p(C,e,t),s(e,ue,t),s(e,T,t),s(e,de,t),s(e,B,t),s(e,Ue,t),s(e,v,t),s(e,Te,t),s(e,G,t),s(e,je,t),s(e,Z,t),s(e,be,t),p(W,e,t),s(e,Ie,t),s(e,k,t),s(e,ge,t),p(V,e,t),s(e,fe,t),s(e,A,t),s(e,Ce,t),p(x,e,t),s(e,Be,t),s(e,X,t),s(e,ve,t),p(Q,e,t),s(e,Ge,t),s(e,j,t),s(e,Ze,t),s(e,_,t),s(e,We,t),s(e,N,t),s(e,ke,t),s(e,S,t),s(e,Ve,t),s(e,R,t),s(e,Ae,t),s(e,Y,t),s(e,xe,t),s(e,H,t),s(e,Xe,t),p(E,e,t),s(e,Qe,t),s(e,z,t),s(e,_e,t),p($,e,t),s(e,Ne,t),s(e,F,t),s(e,Se,t),p(q,e,t),s(e,Re,t),s(e,L,t),s(e,Ye,t),s(e,P,t),s(e,He,t),p(D,e,t),s(e,Ee,t),s(e,K,t),s(e,ze,t),p(O,e,t),s(e,$e,t),s(e,ee,t),s(e,Fe,t),s(e,te,t),s(e,qe,t),s(e,J,t),s(e,Le,t),s(e,le,t),s(e,Pe,t),p(se,e,t),s(e,De,t),s(e,ae,t),s(e,Ke,t),p(ne,e,t),s(e,Oe,t),s(e,ie,t),s(e,et,t),p(oe,e,t),s(e,tt,t),s(e,re,t),lt=!0},p:Qt,i(e){lt||(c(b.$$.fragment,e),c(I.$$.fragment,e),c(C.$$.fragment,e),c(W.$$.fragment,e),c(V.$$.fragment,e),c(x.$$.fragment,e),c(Q.$$.fragment,e),c(E.$$.fragment,e),c($.$$.fragment,e),c(q.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(se.$$.fragment,e),c(ne.$$.fragment,e),c(oe.$$.fragment,e),lt=!0)},o(e){w(b.$$.fragment,e),w(I.$$.fragment,e),w(C.$$.fragment,e),w(W.$$.fragment,e),w(V.$$.fragment,e),w(x.$$.fragment,e),w(Q.$$.fragment,e),w(E.$$.fragment,e),w($.$$.fragment,e),w(q.$$.fragment,e),w(D.$$.fragment,e),w(O.$$.fragment,e),w(se.$$.fragment,e),w(ne.$$.fragment,e),w(oe.$$.fragment,e),lt=!1},d(e){e&&(l(ye),l(Me),l(pe),l(ce),l(we),l(U),l(he),l(g),l(Je),l(f),l(me),l(ue),l(T),l(de),l(B),l(Ue),l(v),l(Te),l(G),l(je),l(Z),l(be),l(Ie),l(k),l(ge),l(fe),l(A),l(Ce),l(Be),l(X),l(ve),l(Ge),l(j),l(Ze),l(_),l(We),l(N),l(ke),l(S),l(Ve),l(R),l(Ae),l(Y),l(xe),l(H),l(Xe),l(Qe),l(z),l(_e),l(Ne),l(F),l(Se),l(Re),l(L),l(Ye),l(P),l(He),l(Ee),l(K),l(ze),l($e),l(ee),l(Fe),l(te),l(qe),l(J),l(Le),l(le),l(Pe),l(De),l(ae),l(Ke),l(Oe),l(ie),l(et),l(tt),l(re)),l(u),h(b,e),h(I,e),h(C,e),h(W,e),h(V,e),h(x,e),h(Q,e),h(E,e),h($,e),h(q,e),h(D,e),h(O,e),h(se,e),h(ne,e),h(oe,e)}}}const $t='{"title":"Vision Agents with smolagents","local":"vision-agents-with-smolagents","sections":[{"title":"Providing Images at the Start of the Agent’s Execution","local":"providing-images-at-the-start-of-the-agents-execution","sections":[],"depth":2},{"title":"Providing Images with Dynamic Retrieval","local":"providing-images-with-dynamic-retrieval","sections":[],"depth":2},{"title":"Further Reading","local":"further-reading","sections":[],"depth":2}],"depth":1}';function Ft(nt){return _t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class el extends Nt{constructor(u){super(),St(this,u,Ft,zt,xt,{})}}export{el as component};
