import{s as bn,n as gn,o as fn}from"../chunks/scheduler.37c15a92.js";import{S as Cn,i as In,g as i,s as n,r as p,A as vn,h as o,f as l,c as a,j as Un,u as r,x as M,k as os,y as Zn,a as s,v as u,d as c,t as m,w as y}from"../chunks/index.2bf4358c.js";import{C as T}from"../chunks/CodeBlock.4e987730.js";import{C as Bn}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as w}from"../chunks/Heading.8ada512a.js";import{E as kn}from"../chunks/getInferenceSnippets.0aa3753f.js";function Gn(Ms){let j,ct,rt,mt,J,yt,h,wt,d,ps='<p>You can follow the code in <a href="https://colab.research.google.com/#fileId=https%3A//huggingface.co/agents-course/notebooks/blob/main/bonus-unit2/monitoring-and-evaluating-agents.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',Tt,U,rs="In this notebook, we will learn how to <strong>monitor the internal steps (traces) of our AI agent</strong> and <strong>evaluate its performance</strong> using open-source observability tools.",jt,b,us="The ability to observe and evaluate an agent’s behavior is essential for:",dt,g,cs="<li>Debugging issues when tasks fail or produce suboptimal results</li> <li>Monitoring costs and performance in real-time</li> <li>Improving reliability and safety through continuous feedback</li>",Jt,f,ht,C,ms="Before running this notebook, please be sure you have:",Ut,I,ys='🔲 📚  <strong>Studied</strong> <a href="https://huggingface.co/learn/agents-course/unit1/introduction" rel="nofollow">Introduction to Agents</a>',bt,v,ws='🔲 📚  <strong>Studied</strong> <a href="https://huggingface.co/learn/agents-course/unit2/smolagents/introduction" rel="nofollow">The smolagents framework</a>',gt,Z,ft,B,Ts="We will need a few libraries that allow us to run, monitor, and evaluate our agents:",Ct,k,It,G,vt,W,js='In this notebook, we will use <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> as our observability tool, but you can use <strong>any other OpenTelemetry-compatible service</strong>. The code below shows how to set environment variables for Langfuse (or any OTel endpoint) and how to instrument your smolagent.',Zt,A,ds='<strong>Note:</strong> If you are using LlamaIndex or LangGraph, you can find documentation on instrumenting them <a href="https://langfuse.com/docs/integrations/llama-index/workflows" rel="nofollow">here</a> and <a href="https://langfuse.com/docs/integrations/langchain/example-python-langgraph" rel="nofollow">here</a>.',Bt,$,Js='First, let’s set up the Langfuse credentials as environment variables. Get your Langfuse API keys by signing up for <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse Cloud</a> or <a href="https://langfuse.com/self-hosting" rel="nofollow">self-hosting Langfuse</a>.',kt,x,Gt,R,hs="We also need to configure our Hugging Face token for inference calls.",Wt,E,At,V,Us="With the environment variables set, we can now initialize the Langfuse client. <code>get_client()</code> initializes the Langfuse client using the credentials provided in the environment variables.",$t,H,xt,Y,bs="Next, we can set up the <code>SmolagentsInstrumentor()</code> to instrument our smolagent and send traces to Langfuse.",Rt,L,Et,Q,Vt,N,gs="Here is a simple CodeAgent from smolagents that calculates <code>1+1</code>. We run it to confirm that the instrumentation is working correctly. If everything is set up correctly, you will see logs/spans in your observability dashboard.",Ht,S,Yt,_,fs='Check your <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse Traces Dashboard</a> (or your chosen observability tool) to confirm that the spans and logs have been recorded.',Lt,X,Cs="Example screenshot from Langfuse:",Qt,z,Is='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/first-example-trace.png" alt="Example trace in Langfuse"/>',Nt,F,vs='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1b94d6888258e0998329cdb72a371155?timestamp=2025-03-10T11%3A59%3A41.743Z" rel="nofollow">Link to the trace</a></em>',St,q,_t,D,Zs="Now that you have confirmed your instrumentation works, let’s try a more complex query so we can see how advanced metrics (token usage, latency, costs, etc.) are tracked.",Xt,P,zt,K,Ft,O,Bs="Most observability tools record a <strong>trace</strong> that contains <strong>spans</strong>, which represent each step of your agent’s logic. Here, the trace contains the overall agent run and sub-spans for:",qt,ee,ks="<li>The tool calls (DuckDuckGoSearchTool)</li> <li>The LLM calls (InferenceClientModel)</li>",Dt,te,Gs="You can inspect these to see precisely where time is spent, how many tokens are used, and so on:",Pt,le,Ws='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/trace-tree.png" alt="Trace tree in Langfuse"/>',Kt,se,As='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Link to the trace</a></em>',Ot,ne,el,ae,$s="In the previous section, we learned about the difference between online and offline evaluation. Now, we will see how to monitor your agent in production and evaluate it live.",tl,ie,ll,oe,xs="<li><strong>Costs</strong> — The smolagents instrumentation captures token usage, which you can transform into approximate costs by assigning a price per token.</li> <li><strong>Latency</strong> — Observe the time it takes to complete each step, or the entire run.</li> <li><strong>User Feedback</strong> — Users can provide direct feedback (thumbs up/down) to help refine or correct the agent.</li> <li><strong>LLM-as-a-Judge</strong> — Use a separate LLM to evaluate your agent’s output in near real-time (e.g., checking for toxicity or correctness).</li>",sl,Me,Rs="Below, we show examples of these metrics.",nl,pe,al,re,Es="Below is a screenshot showing usage for <code>Qwen2.5-Coder-32B-Instruct</code> calls. This is useful to see costly steps and optimize your agent.",il,ue,Vs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-costs.png" alt="Costs"/>',ol,ce,Hs='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Link to the trace</a></em>',Ml,me,pl,ye,Ys="We can also see how long it took to complete each step. In the example below, the entire conversation took 32 seconds, which you can break down by step. This helps you identify bottlenecks and optimize your agent.",rl,we,Ls='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-latency.png" alt="Latency"/>',ul,Te,Qs='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Link to the trace</a></em>',cl,je,ml,de,Ns="You may also pass additional attributes to your spans. These can include <code>user_id</code>, <code>tags</code>, <code>session_id</code>, and custom metadata. Enriching traces with these details is important for analysis, debugging, and monitoring of your application’s behavior across different users or sessions.",yl,Je,wl,he,Ss='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-attributes.png" alt="Enhancing agent runs with additional metrics"/>',Tl,Ue,jl,be,_s='If your agent is embedded into a user interface, you can record direct user feedback (like a thumbs-up/down in a chat UI). Below is an example using <a href="https://gradio.app/" rel="nofollow">Gradio</a> to embed a chat with a simple feedback mechanism.',dl,ge,Xs="In the code snippet below, when a user sends a chat message, we capture the trace in Langfuse. If the user likes/dislikes the last answer, we attach a score to the trace.",Jl,fe,hl,Ce,zs="User feedback is then captured in your observability tool:",Ul,Ie,Fs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/user-feedback-gradio.png" alt="User feedback is being captured in Langfuse"/>',bl,ve,gl,Ze,qs="LLM-as-a-Judge is another way to automatically evaluate your agent’s output. You can set up a separate LLM call to gauge the output’s correctness, toxicity, style, or any other criteria you care about.",fl,Be,Ds="<strong>Workflow</strong>:",Cl,ke,Ps="<li>You define an <strong>Evaluation Template</strong>, e.g., “Check if the text is toxic.”</li> <li>Each time your agent generates output, you pass that output to your “judge” LLM with the template.</li> <li>The judge LLM responds with a rating or label that you log to your observability tool.</li>",Il,Ge,Ks="Example from Langfuse:",vl,We,Os='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator-template.png" alt="LLM-as-a-Judge Evaluation Template"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator.png" alt="LLM-as-a-Judge Evaluator"/>',Zl,Ae,Bl,$e,en="You can see that the answer of this example is judged as “not toxic”.",kl,xe,tn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/llm-as-a-judge-score.png" alt="LLM-as-a-Judge Evaluation Score"/>',Gl,Re,Wl,Ee,ln="All of these metrics can be visualized together in dashboards. This enables you to quickly see how your agent performs across many sessions and helps you to track quality metrics over time.",Al,Ve,sn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/langfuse-dashboard.png" alt="Observability metrics overview"/>',$l,He,xl,Ye,nn="Online evaluation is essential for live feedback, but you also need <strong>offline evaluation</strong>—systematic checks before or during development. This helps maintain quality and reliability before rolling changes into production.",Rl,Le,El,Qe,an="In offline evaluation, you typically:",Vl,Ne,on="<li>Have a benchmark dataset (with prompt and expected output pairs)</li> <li>Run your agent on that dataset</li> <li>Compare outputs to the expected results or use an additional scoring mechanism</li>",Hl,Se,Mn='Below, we demonstrate this approach with the <a href="https://huggingface.co/datasets/openai/gsm8k" rel="nofollow">GSM8K dataset</a>, which contains math questions and solutions.',Yl,_e,Ll,Xe,pn="Next, we create a dataset entity in Langfuse to track the runs. Then, we add each item from the dataset to the system. (If you’re not using Langfuse, you might simply store these in your own database or local file for analysis.)",Ql,ze,Nl,Fe,Sl,qe,rn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/example-dataset.png" alt="Dataset items in Langfuse"/>',_l,De,Xl,Pe,un="We define a helper function <code>run_smolagent()</code> that:",zl,Ke,cn="<li>Starts a Langfuse span</li> <li>Runs our agent on the prompt</li> <li>Records the trace ID in Langfuse</li>",Fl,Oe,mn="Then, we loop over each dataset item, run the agent, and link the trace to the dataset item. We can also attach a quick evaluation score if desired.",ql,et,Dl,tt,yn="You can repeat this process with different:",Pl,lt,wn="<li>Models (OpenAI GPT, local LLM, etc.)</li> <li>Tools (search vs. no search)</li> <li>Prompts (different system messages)</li>",Kl,st,Tn="Then compare them side-by-side in your observability tool:",Ol,nt,jn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset_runs.png" alt="Dataset run overview"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset-run-comparison.png" alt="Dataset run comparison"/>',es,at,ts,it,dn="In this notebook, we covered how to:",ls,ot,Jn="<li><strong>Set up Observability</strong> using smolagents + OpenTelemetry exporters</li> <li><strong>Check Instrumentation</strong> by running a simple agent</li> <li><strong>Capture Detailed Metrics</strong> (cost, latency, etc.) through an observability tools</li> <li><strong>Collect User Feedback</strong> via a Gradio interface</li> <li><strong>Use LLM-as-a-Judge</strong> to automatically evaluate outputs</li> <li><strong>Perform Offline Evaluation</strong> with a benchmark dataset</li>",ss,Mt,hn="🤗 Happy coding!",ns,pt,as,ut,is;return J=new Bn({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https%3A//huggingface.co/agents-course/notebooks/blob/main/bonus-unit2/monitoring-and-evaluating-agents.ipynb"}]}}),h=new w({props:{title:"Bonus Unit 2: Observability and Evaluation of Agents",local:"bonus-unit-2-observability-and-evaluation-of-agents",headingTag:"h1"}}),f=new w({props:{title:"Exercise Prerequisites 🏗️",local:"exercise-prerequisites-",headingTag:"h2"}}),Z=new w({props:{title:"Step 0: Install the Required Libraries",local:"step-0-install-the-required-libraries",headingTag:"h2"}}),k=new T({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdmdXNlJTIwJ3Ntb2xhZ2VudHMlNUJ0ZWxlbWV0cnklNUQnJTIwb3BlbmluZmVyZW5jZS1pbnN0cnVtZW50YXRpb24tc21vbGFnZW50cyUyMGRhdGFzZXRzJTIwJ3Ntb2xhZ2VudHMlNUJncmFkaW8lNUQnJTIwZ3JhZGlvJTIwLS11cGdyYWRl",highlighted:'%pip install langfuse <span class="hljs-string">&#x27;smolagents[telemetry]&#x27;</span> openinference-instrumentation-smolagents datasets <span class="hljs-string">&#x27;smolagents[gradio]&#x27;</span> gradio --upgrade',wrap:!1}}),G=new w({props:{title:"Step 1: Instrument Your Agent",local:"step-1-instrument-your-agent",headingTag:"h2"}}),x=new T({props:{code:"aW1wb3J0JTIwb3MlMEElMjMlMjBHZXQlMjBrZXlzJTIwZm9yJTIweW91ciUyMHByb2plY3QlMjBmcm9tJTIwdGhlJTIwcHJvamVjdCUyMHNldHRpbmdzJTIwcGFnZSUzQSUyMGh0dHBzJTNBJTJGJTJGY2xvdWQubGFuZ2Z1c2UuY29tJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1BVQkxJQ19LRVklMjIlNUQlMjAlM0QlMjAlMjJway1sZi0uLi4lMjIlMjAlMEFvcy5lbnZpcm9uJTVCJTIyTEFOR0ZVU0VfU0VDUkVUX0tFWSUyMiU1RCUyMCUzRCUyMCUyMnNrLWxmLS4uLiUyMiUyMCUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZjbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQUElRjAlOUYlODclQkElMjBFVSUyMHJlZ2lvbiUwQSUyMyUyMG9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cy5jbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQkElRjAlOUYlODclQjglMjBVUyUyMHJlZ2lvbg==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-comment"># Get keys for your project from the project settings page: https://cloud.langfuse.com</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = <span class="hljs-string">&quot;sk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span> <span class="hljs-comment"># 🇪🇺 EU region</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot; # 🇺🇸 US region</span>`,wrap:!1}}),E=new T({props:{code:"JTIzJTIwU2V0JTIweW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwYW5kJTIwb3RoZXIlMjB0b2tlbnMlMkZzZWNyZXRzJTIwYXMlMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlJTBBb3MuZW52aXJvbiU1QiUyMkhGX1RPS0VOJTIyJTVEJTIwJTNEJTIwJTIyaGZfLi4uJTIyJTIw",highlighted:`<span class="hljs-comment"># Set your Hugging Face and other tokens/secrets as environment variable</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] = <span class="hljs-string">&quot;hf_...&quot;</span> `,wrap:!1}}),H=new T({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwZ2V0X2NsaWVudCUwQSUyMCUwQWxhbmdmdXNlJTIwJTNEJTIwZ2V0X2NsaWVudCgpJTBBJTIwJTBBJTIzJTIwVmVyaWZ5JTIwY29ubmVjdGlvbiUwQWlmJTIwbGFuZ2Z1c2UuYXV0aF9jaGVjaygpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyTGFuZ2Z1c2UlMjBjbGllbnQlMjBpcyUyMGF1dGhlbnRpY2F0ZWQlMjBhbmQlMjByZWFkeSElMjIpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkF1dGhlbnRpY2F0aW9uJTIwZmFpbGVkLiUyMFBsZWFzZSUyMGNoZWNrJTIweW91ciUyMGNyZWRlbnRpYWxzJTIwYW5kJTIwaG9zdC4lMjIp",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client
 
langfuse = get_client()
 
<span class="hljs-comment"># Verify connection</span>
<span class="hljs-keyword">if</span> langfuse.auth_check():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Langfuse client is authenticated and ready!&quot;</span>)
<span class="hljs-keyword">else</span>:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Authentication failed. Please check your credentials and host.&quot;</span>)`,wrap:!1}}),L=new T({props:{code:"ZnJvbSUyMG9wZW5pbmZlcmVuY2UuaW5zdHJ1bWVudGF0aW9uLnNtb2xhZ2VudHMlMjBpbXBvcnQlMjBTbW9sYWdlbnRzSW5zdHJ1bWVudG9yJTBBJTIwJTBBU21vbGFnZW50c0luc3RydW1lbnRvcigpLmluc3RydW1lbnQoKQ==",highlighted:`<span class="hljs-keyword">from</span> openinference.instrumentation.smolagents <span class="hljs-keyword">import</span> SmolagentsInstrumentor
 
SmolagentsInstrumentor().instrument()`,wrap:!1}}),Q=new w({props:{title:"Step 2: Test Your Instrumentation",local:"step-2-test-your-instrumentation",headingTag:"h2"}}),S=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQSUyMyUyMENyZWF0ZSUyMGElMjBzaW1wbGUlMjBhZ2VudCUyMHRvJTIwdGVzdCUyMGluc3RydW1lbnRhdGlvbiUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBKSUwQSUwQWFnZW50LnJ1biglMjIxJTJCMSUzRCUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-comment"># Create a simple agent to test instrumentation</span>
agent = CodeAgent(
    tools=[],
    model=InferenceClientModel()
)

agent.run(<span class="hljs-string">&quot;1+1=&quot;</span>)`,wrap:!1}}),q=new w({props:{title:"Step 3: Observe and Evaluate a More Complex Agent",local:"step-3-observe-and-evaluate-a-more-complex-agent",headingTag:"h2"}}),P=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwUnViaWsncyUyMEN1YmVzJTIwY291bGQlMjB5b3UlMjBmaXQlMjBpbnNpZGUlMjB0aGUlMjBOb3RyZSUyMERhbWUlMjBDYXRoZWRyYWwlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;How many Rubik&#x27;s Cubes could you fit inside the Notre Dame Cathedral?&quot;</span>)`,wrap:!1}}),K=new w({props:{title:"Trace Structure",local:"trace-structure",headingTag:"h3"}}),ne=new w({props:{title:"Online Evaluation",local:"online-evaluation",headingTag:"h2"}}),ie=new w({props:{title:"Common Metrics to Track in Production",local:"common-metrics-to-track-in-production",headingTag:"h3"}}),pe=new w({props:{title:"1. Costs",local:"1-costs",headingTag:"h4"}}),me=new w({props:{title:"2. Latency",local:"2-latency",headingTag:"h4"}}),je=new w({props:{title:"3. Additional Attributes",local:"3-additional-attributes",headingTag:"h4"}}),Je=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBKSUwQSUwQXdpdGglMjBsYW5nZnVzZS5zdGFydF9hc19jdXJyZW50X3NwYW4oJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMlNtb2xhZ2VudC1UcmFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCklMjBhcyUyMHNwYW4lM0ElMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBSdW4lMjB5b3VyJTIwYXBwbGljYXRpb24lMjBoZXJlJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBhZ2VudC5ydW4oJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwR2VybWFueSUzRiUyMiklMEElMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBQYXNzJTIwYWRkaXRpb25hbCUyMGF0dHJpYnV0ZXMlMjB0byUyMHRoZSUyMHNwYW4lMEElMjAlMjAlMjAlMjBzcGFuLnVwZGF0ZV90cmFjZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dCUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGNhcGl0YWwlMjBvZiUyMEdlcm1hbnklM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXQlM0RyZXNwb25zZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHVzZXJfaWQlM0QlMjJzbW9sYWdlbnQtdXNlci0xMjMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZXNzaW9uX2lkJTNEJTIyc21vbGFnZW50LXNlc3Npb24tMTIzNDU2Nzg5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFncyUzRCU1QiUyMmNpdHktcXVlc3Rpb24lMjIlMkMlMjAlMjJ0ZXN0aW5nLWFnZW50cyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldGFkYXRhJTNEJTdCJTIyZW1haWwlMjIlM0ElMjAlMjJ1c2VyJTQwbGFuZ2Z1c2UuY29tJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUwQSUyMyUyMEZsdXNoJTIwZXZlbnRzJTIwaW4lMjBzaG9ydC1saXZlZCUyMGFwcGxpY2F0aW9ucyUwQWxhbmdmdXNlLmZsdXNoKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(
    tools=[search_tool],
    model=InferenceClientModel()
)

<span class="hljs-keyword">with</span> langfuse.start_as_current_span(
    name=<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>,
    ) <span class="hljs-keyword">as</span> span:
    
    <span class="hljs-comment"># Run your application here</span>
    response = agent.run(<span class="hljs-string">&quot;What is the capital of Germany?&quot;</span>)
 
    <span class="hljs-comment"># Pass additional attributes to the span</span>
    span.update_trace(
        <span class="hljs-built_in">input</span>=<span class="hljs-string">&quot;What is the capital of Germany?&quot;</span>,
        output=response,
        user_id=<span class="hljs-string">&quot;smolagent-user-123&quot;</span>,
        session_id=<span class="hljs-string">&quot;smolagent-session-123456789&quot;</span>,
        tags=[<span class="hljs-string">&quot;city-question&quot;</span>, <span class="hljs-string">&quot;testing-agents&quot;</span>],
        metadata={<span class="hljs-string">&quot;email&quot;</span>: <span class="hljs-string">&quot;user@langfuse.com&quot;</span>},
        )
 
<span class="hljs-comment"># Flush events in short-lived applications</span>
langfuse.flush()`,wrap:!1}}),Ue=new w({props:{title:"4. User Feedback",local:"4-user-feedback",headingTag:"h4"}}),fe=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, InferenceClientModel)
<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client

langfuse = get_client()

model = InferenceClientModel()
agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)

trace_id = <span class="hljs-literal">None</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">respond</span>(<span class="hljs-params">prompt, history</span>):
    <span class="hljs-keyword">with</span> langfuse.start_as_current_span(
        name=<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>):
        
        <span class="hljs-comment"># Run your application here</span>
        output = agent.run(prompt)

        <span class="hljs-keyword">global</span> trace_id
        trace_id = langfuse.get_current_trace_id()

    history.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-built_in">str</span>(output)})
    <span class="hljs-keyword">return</span> history

<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_like</span>(<span class="hljs-params">data: gr.LikeData</span>):
    <span class="hljs-comment"># For demonstration, we map user feedback to a 1 (like) or 0 (dislike)</span>
    <span class="hljs-keyword">if</span> data.liked:
        langfuse.create_score(
            value=<span class="hljs-number">1</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=trace_id
        )
    <span class="hljs-keyword">else</span>:
        langfuse.create_score(
            value=<span class="hljs-number">0</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=trace_id
        )

<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    chatbot = gr.Chatbot(label=<span class="hljs-string">&quot;Chat&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>)
    prompt_box = gr.Textbox(placeholder=<span class="hljs-string">&quot;Type your message...&quot;</span>, label=<span class="hljs-string">&quot;Your message&quot;</span>)

    <span class="hljs-comment"># When the user presses &#x27;Enter&#x27; on the prompt, we run &#x27;respond&#x27;</span>
    prompt_box.submit(
        fn=respond,
        inputs=[prompt_box, chatbot],
        outputs=chatbot
    )

    <span class="hljs-comment"># When the user clicks a &#x27;like&#x27; button on a message, we run &#x27;handle_like&#x27;</span>
    chatbot.like(handle_like, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>)

demo.launch()`,wrap:!1}}),ve=new w({props:{title:"5. LLM-as-a-Judge",local:"5-llm-as-a-judge",headingTag:"h4"}}),Ae=new T({props:{code:"JTIzJTIwRXhhbXBsZSUzQSUyMENoZWNraW5nJTIwaWYlMjB0aGUlMjBhZ2VudCVFMiU4MCU5OXMlMjBvdXRwdXQlMjBpcyUyMHRveGljJTIwb3IlMjBub3QuJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjJDYW4lMjBlYXRpbmclMjBjYXJyb3RzJTIwaW1wcm92ZSUyMHlvdXIlMjB2aXNpb24lM0YlMjIp",highlighted:`<span class="hljs-comment"># Example: Checking if the agent’s output is toxic or not.</span>
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;Can eating carrots improve your vision?&quot;</span>)`,wrap:!1}}),Re=new w({props:{title:"6. Observability Metrics Overview",local:"6-observability-metrics-overview",headingTag:"h4"}}),He=new w({props:{title:"Offline Evaluation",local:"offline-evaluation",headingTag:"h2"}}),Le=new w({props:{title:"Dataset Evaluation",local:"dataset-evaluation",headingTag:"h3"}}),_e=new T({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUyMyUyMEZldGNoJTIwR1NNOEslMjBmcm9tJTIwSHVnZ2luZyUyMEZhY2UlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMm9wZW5haSUyRmdzbThrJTIyJTJDJTIwJ21haW4nJTJDJTIwc3BsaXQlM0QndHJhaW4nKSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lKGRhdGFzZXQpJTBBcHJpbnQoJTIyRmlyc3QlMjBmZXclMjByb3dzJTIwb2YlMjBHU004SyUyMGRhdGFzZXQlM0ElMjIpJTBBcHJpbnQoZGYuaGVhZCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Fetch GSM8K from Hugging Face</span>
dataset = load_dataset(<span class="hljs-string">&quot;openai/gsm8k&quot;</span>, <span class="hljs-string">&#x27;main&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>)
df = pd.DataFrame(dataset)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;First few rows of GSM8K dataset:&quot;</span>)
<span class="hljs-built_in">print</span>(df.head())`,wrap:!1}}),ze=new T({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwZ2V0X2NsaWVudCUwQWxhbmdmdXNlJTIwJTNEJTIwZ2V0X2NsaWVudCgpJTBBJTBBbGFuZ2Z1c2VfZGF0YXNldF9uYW1lJTIwJTNEJTIwJTIyZ3NtOGtfZGF0YXNldF9odWdnaW5nZmFjZSUyMiUwQSUwQSUyMyUyMENyZWF0ZSUyMGElMjBkYXRhc2V0JTIwaW4lMjBMYW5nZnVzZSUwQWxhbmdmdXNlLmNyZWF0ZV9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMG5hbWUlM0RsYW5nZnVzZV9kYXRhc2V0X25hbWUlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMkdTTThLJTIwYmVuY2htYXJrJTIwZGF0YXNldCUyMHVwbG9hZGVkJTIwZnJvbSUyMEh1Z2dpbmdmYWNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWV0YWRhdGElM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkYXRlJTIyJTNBJTIwJTIyMjAyNS0wMy0xMCUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJiZW5jaG1hcmslMjIlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client
langfuse = get_client()

langfuse_dataset_name = <span class="hljs-string">&quot;gsm8k_dataset_huggingface&quot;</span>

<span class="hljs-comment"># Create a dataset in Langfuse</span>
langfuse.create_dataset(
    name=langfuse_dataset_name,
    description=<span class="hljs-string">&quot;GSM8K benchmark dataset uploaded from Huggingface&quot;</span>,
    metadata={
        <span class="hljs-string">&quot;date&quot;</span>: <span class="hljs-string">&quot;2025-03-10&quot;</span>, 
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;benchmark&quot;</span>
    }
)`,wrap:!1}}),Fe=new T({props:{code:"Zm9yJTIwaWR4JTJDJTIwcm93JTIwaW4lMjBkZi5pdGVycm93cygpJTNBJTBBJTIwJTIwJTIwJTIwbGFuZ2Z1c2UuY3JlYXRlX2RhdGFzZXRfaXRlbSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhc2V0X25hbWUlM0RsYW5nZnVzZV9kYXRhc2V0X25hbWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJxdWVzdGlvbiUyMiU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4cGVjdGVkX291dHB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJhbnN3ZXIlMjIlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZV9pbmRleCUyMiUzQSUyMGlkeCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBpZiUyMGlkeCUyMCUzRSUzRCUyMDklM0ElMjAlMjMlMjBVcGxvYWQlMjBvbmx5JTIwdGhlJTIwZmlyc3QlMjAxMCUyMGl0ZW1zJTIwZm9yJTIwZGVtb25zdHJhdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> idx, row <span class="hljs-keyword">in</span> df.iterrows():
    langfuse.create_dataset_item(
        dataset_name=langfuse_dataset_name,
        <span class="hljs-built_in">input</span>={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;question&quot;</span>]},
        expected_output={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;answer&quot;</span>]},
        metadata={<span class="hljs-string">&quot;source_index&quot;</span>: idx}
    )
    <span class="hljs-keyword">if</span> idx &gt;= <span class="hljs-number">9</span>: <span class="hljs-comment"># Upload only the first 10 items for demonstration</span>
        <span class="hljs-keyword">break</span>`,wrap:!1}}),De=new w({props:{title:"Running the Agent on the Dataset",local:"running-the-agent-on-the-dataset",headingTag:"h4"}}),et=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> opentelemetry.trace <span class="hljs-keyword">import</span> format_trace_id
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, InferenceClientModel, LiteLLMModel)
<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client
 
langfuse = get_client()


<span class="hljs-comment"># Example: using InferenceClientModel or LiteLLMModel to access openai, anthropic, gemini, etc. models:</span>
model = InferenceClientModel()

agent = CodeAgent(
    tools=[],
    model=model,
    add_base_tools=<span class="hljs-literal">True</span>
)

dataset_name = <span class="hljs-string">&quot;gsm8k_dataset_huggingface&quot;</span>
current_run_name = <span class="hljs-string">&quot;smolagent-notebook-run-01&quot;</span> <span class="hljs-comment"># Identifies this specific evaluation run</span>
 
<span class="hljs-comment"># Assume &#x27;run_smolagent&#x27; is your instrumented application function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_smolagent</span>(<span class="hljs-params">question</span>):
    <span class="hljs-keyword">with</span> langfuse.start_as_current_generation(name=<span class="hljs-string">&quot;qna-llm-call&quot;</span>) <span class="hljs-keyword">as</span> generation:
        <span class="hljs-comment"># Simulate LLM call</span>
        result = agent.run(question)
 
        <span class="hljs-comment"># Update the trace with the input and output</span>
        generation.update_trace(
            <span class="hljs-built_in">input</span>= question,
            output=result,
        )
 
        <span class="hljs-keyword">return</span> result
 
dataset = langfuse.get_dataset(name=dataset_name) <span class="hljs-comment"># Fetch your pre-populated dataset</span>
 
<span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> dataset.items:
 
    <span class="hljs-comment"># Use the item.run() context manager</span>
    <span class="hljs-keyword">with</span> item.run(
        run_name=current_run_name,
        run_metadata={<span class="hljs-string">&quot;model_provider&quot;</span>: <span class="hljs-string">&quot;Hugging Face&quot;</span>, <span class="hljs-string">&quot;temperature_setting&quot;</span>: <span class="hljs-number">0.7</span>},
        run_description=<span class="hljs-string">&quot;Evaluation run for GSM8K dataset&quot;</span>
    ) <span class="hljs-keyword">as</span> root_span: <span class="hljs-comment"># root_span is the root span of the new trace for this item and run.</span>
        <span class="hljs-comment"># All subsequent langfuse operations within this block are part of this trace.</span>
 
        <span class="hljs-comment"># Call your application logic</span>
        generated_answer = run_smolagent(question=item.<span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;text&quot;</span>])
 
        <span class="hljs-built_in">print</span>(item.<span class="hljs-built_in">input</span>)`,wrap:!1}}),at=new w({props:{title:"Final Thoughts",local:"final-thoughts",headingTag:"h2"}}),pt=new kn({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/bonus-unit2/monitoring-and-evaluating-agents-notebook.mdx"}}),{c(){j=i("meta"),ct=n(),rt=i("p"),mt=n(),p(J.$$.fragment),yt=n(),p(h.$$.fragment),wt=n(),d=i("blockquote"),d.innerHTML=ps,Tt=n(),U=i("p"),U.innerHTML=rs,jt=n(),b=i("p"),b.textContent=us,dt=n(),g=i("ul"),g.innerHTML=cs,Jt=n(),p(f.$$.fragment),ht=n(),C=i("p"),C.textContent=ms,Ut=n(),I=i("p"),I.innerHTML=ys,bt=n(),v=i("p"),v.innerHTML=ws,gt=n(),p(Z.$$.fragment),ft=n(),B=i("p"),B.textContent=Ts,Ct=n(),p(k.$$.fragment),It=n(),p(G.$$.fragment),vt=n(),W=i("p"),W.innerHTML=js,Zt=n(),A=i("p"),A.innerHTML=ds,Bt=n(),$=i("p"),$.innerHTML=Js,kt=n(),p(x.$$.fragment),Gt=n(),R=i("p"),R.textContent=hs,Wt=n(),p(E.$$.fragment),At=n(),V=i("p"),V.innerHTML=Us,$t=n(),p(H.$$.fragment),xt=n(),Y=i("p"),Y.innerHTML=bs,Rt=n(),p(L.$$.fragment),Et=n(),p(Q.$$.fragment),Vt=n(),N=i("p"),N.innerHTML=gs,Ht=n(),p(S.$$.fragment),Yt=n(),_=i("p"),_.innerHTML=fs,Lt=n(),X=i("p"),X.textContent=Cs,Qt=n(),z=i("p"),z.innerHTML=Is,Nt=n(),F=i("p"),F.innerHTML=vs,St=n(),p(q.$$.fragment),_t=n(),D=i("p"),D.textContent=Zs,Xt=n(),p(P.$$.fragment),zt=n(),p(K.$$.fragment),Ft=n(),O=i("p"),O.innerHTML=Bs,qt=n(),ee=i("ul"),ee.innerHTML=ks,Dt=n(),te=i("p"),te.textContent=Gs,Pt=n(),le=i("p"),le.innerHTML=Ws,Kt=n(),se=i("p"),se.innerHTML=As,Ot=n(),p(ne.$$.fragment),el=n(),ae=i("p"),ae.textContent=$s,tl=n(),p(ie.$$.fragment),ll=n(),oe=i("ol"),oe.innerHTML=xs,sl=n(),Me=i("p"),Me.textContent=Rs,nl=n(),p(pe.$$.fragment),al=n(),re=i("p"),re.innerHTML=Es,il=n(),ue=i("p"),ue.innerHTML=Vs,ol=n(),ce=i("p"),ce.innerHTML=Hs,Ml=n(),p(me.$$.fragment),pl=n(),ye=i("p"),ye.textContent=Ys,rl=n(),we=i("p"),we.innerHTML=Ls,ul=n(),Te=i("p"),Te.innerHTML=Qs,cl=n(),p(je.$$.fragment),ml=n(),de=i("p"),de.innerHTML=Ns,yl=n(),p(Je.$$.fragment),wl=n(),he=i("p"),he.innerHTML=Ss,Tl=n(),p(Ue.$$.fragment),jl=n(),be=i("p"),be.innerHTML=_s,dl=n(),ge=i("p"),ge.textContent=Xs,Jl=n(),p(fe.$$.fragment),hl=n(),Ce=i("p"),Ce.textContent=zs,Ul=n(),Ie=i("p"),Ie.innerHTML=Fs,bl=n(),p(ve.$$.fragment),gl=n(),Ze=i("p"),Ze.textContent=qs,fl=n(),Be=i("p"),Be.innerHTML=Ds,Cl=n(),ke=i("ol"),ke.innerHTML=Ps,Il=n(),Ge=i("p"),Ge.textContent=Ks,vl=n(),We=i("p"),We.innerHTML=Os,Zl=n(),p(Ae.$$.fragment),Bl=n(),$e=i("p"),$e.textContent=en,kl=n(),xe=i("p"),xe.innerHTML=tn,Gl=n(),p(Re.$$.fragment),Wl=n(),Ee=i("p"),Ee.textContent=ln,Al=n(),Ve=i("p"),Ve.innerHTML=sn,$l=n(),p(He.$$.fragment),xl=n(),Ye=i("p"),Ye.innerHTML=nn,Rl=n(),p(Le.$$.fragment),El=n(),Qe=i("p"),Qe.textContent=an,Vl=n(),Ne=i("ol"),Ne.innerHTML=on,Hl=n(),Se=i("p"),Se.innerHTML=Mn,Yl=n(),p(_e.$$.fragment),Ll=n(),Xe=i("p"),Xe.textContent=pn,Ql=n(),p(ze.$$.fragment),Nl=n(),p(Fe.$$.fragment),Sl=n(),qe=i("p"),qe.innerHTML=rn,_l=n(),p(De.$$.fragment),Xl=n(),Pe=i("p"),Pe.innerHTML=un,zl=n(),Ke=i("ol"),Ke.innerHTML=cn,Fl=n(),Oe=i("p"),Oe.textContent=mn,ql=n(),p(et.$$.fragment),Dl=n(),tt=i("p"),tt.textContent=yn,Pl=n(),lt=i("ul"),lt.innerHTML=wn,Kl=n(),st=i("p"),st.textContent=Tn,Ol=n(),nt=i("p"),nt.innerHTML=jn,es=n(),p(at.$$.fragment),ts=n(),it=i("p"),it.textContent=dn,ls=n(),ot=i("ol"),ot.innerHTML=Jn,ss=n(),Mt=i("p"),Mt.textContent=hn,ns=n(),p(pt.$$.fragment),as=n(),ut=i("p"),this.h()},l(e){const t=vn("svelte-u9bgzb",document.head);j=o(t,"META",{name:!0,content:!0}),t.forEach(l),ct=a(e),rt=o(e,"P",{}),Un(rt).forEach(l),mt=a(e),r(J.$$.fragment,e),yt=a(e),r(h.$$.fragment,e),wt=a(e),d=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(d)!=="svelte-1ill3vv"&&(d.innerHTML=ps),Tt=a(e),U=o(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1hjcrzt"&&(U.innerHTML=rs),jt=a(e),b=o(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-foopw1"&&(b.textContent=us),dt=a(e),g=o(e,"UL",{"data-svelte-h":!0}),M(g)!=="svelte-owrpod"&&(g.innerHTML=cs),Jt=a(e),r(f.$$.fragment,e),ht=a(e),C=o(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-5cu48y"&&(C.textContent=ms),Ut=a(e),I=o(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-tid2rn"&&(I.innerHTML=ys),bt=a(e),v=o(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-11ima5v"&&(v.innerHTML=ws),gt=a(e),r(Z.$$.fragment,e),ft=a(e),B=o(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-13k1zsa"&&(B.textContent=Ts),Ct=a(e),r(k.$$.fragment,e),It=a(e),r(G.$$.fragment,e),vt=a(e),W=o(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1om0xhg"&&(W.innerHTML=js),Zt=a(e),A=o(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-10zlua1"&&(A.innerHTML=ds),Bt=a(e),$=o(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-1kbyizu"&&($.innerHTML=Js),kt=a(e),r(x.$$.fragment,e),Gt=a(e),R=o(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-188d5j6"&&(R.textContent=hs),Wt=a(e),r(E.$$.fragment,e),At=a(e),V=o(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-wfv4z0"&&(V.innerHTML=Us),$t=a(e),r(H.$$.fragment,e),xt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-1uenr7t"&&(Y.innerHTML=bs),Rt=a(e),r(L.$$.fragment,e),Et=a(e),r(Q.$$.fragment,e),Vt=a(e),N=o(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-18gebex"&&(N.innerHTML=gs),Ht=a(e),r(S.$$.fragment,e),Yt=a(e),_=o(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-vzfgml"&&(_.innerHTML=fs),Lt=a(e),X=o(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-17kovw7"&&(X.textContent=Cs),Qt=a(e),z=o(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-1cb993n"&&(z.innerHTML=Is),Nt=a(e),F=o(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-3d3s8c"&&(F.innerHTML=vs),St=a(e),r(q.$$.fragment,e),_t=a(e),D=o(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-vj8duz"&&(D.textContent=Zs),Xt=a(e),r(P.$$.fragment,e),zt=a(e),r(K.$$.fragment,e),Ft=a(e),O=o(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-11qm5kf"&&(O.innerHTML=Bs),qt=a(e),ee=o(e,"UL",{"data-svelte-h":!0}),M(ee)!=="svelte-1pzu7di"&&(ee.innerHTML=ks),Dt=a(e),te=o(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-5g8r1i"&&(te.textContent=Gs),Pt=a(e),le=o(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-yhkq5w"&&(le.innerHTML=Ws),Kt=a(e),se=o(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-19v4344"&&(se.innerHTML=As),Ot=a(e),r(ne.$$.fragment,e),el=a(e),ae=o(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-1m3q9s4"&&(ae.textContent=$s),tl=a(e),r(ie.$$.fragment,e),ll=a(e),oe=o(e,"OL",{"data-svelte-h":!0}),M(oe)!=="svelte-it9cbz"&&(oe.innerHTML=xs),sl=a(e),Me=o(e,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-1gkbldi"&&(Me.textContent=Rs),nl=a(e),r(pe.$$.fragment,e),al=a(e),re=o(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-zy3zhh"&&(re.innerHTML=Es),il=a(e),ue=o(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-dard47"&&(ue.innerHTML=Vs),ol=a(e),ce=o(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-19v4344"&&(ce.innerHTML=Hs),Ml=a(e),r(me.$$.fragment,e),pl=a(e),ye=o(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-v1au4h"&&(ye.textContent=Ys),rl=a(e),we=o(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-1org4pj"&&(we.innerHTML=Ls),ul=a(e),Te=o(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-19v4344"&&(Te.innerHTML=Qs),cl=a(e),r(je.$$.fragment,e),ml=a(e),de=o(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-ut7yv4"&&(de.innerHTML=Ns),yl=a(e),r(Je.$$.fragment,e),wl=a(e),he=o(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-1gx91hu"&&(he.innerHTML=Ss),Tl=a(e),r(Ue.$$.fragment,e),jl=a(e),be=o(e,"P",{"data-svelte-h":!0}),M(be)!=="svelte-1t6vqwk"&&(be.innerHTML=_s),dl=a(e),ge=o(e,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-1rxqxjo"&&(ge.textContent=Xs),Jl=a(e),r(fe.$$.fragment,e),hl=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),M(Ce)!=="svelte-qczj9m"&&(Ce.textContent=zs),Ul=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),M(Ie)!=="svelte-e6ive4"&&(Ie.innerHTML=Fs),bl=a(e),r(ve.$$.fragment,e),gl=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),M(Ze)!=="svelte-1guzmu1"&&(Ze.textContent=qs),fl=a(e),Be=o(e,"P",{"data-svelte-h":!0}),M(Be)!=="svelte-13jor3c"&&(Be.innerHTML=Ds),Cl=a(e),ke=o(e,"OL",{"data-svelte-h":!0}),M(ke)!=="svelte-8y9f4i"&&(ke.innerHTML=Ps),Il=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),M(Ge)!=="svelte-6rieqh"&&(Ge.textContent=Ks),vl=a(e),We=o(e,"P",{"data-svelte-h":!0}),M(We)!=="svelte-1uar592"&&(We.innerHTML=Os),Zl=a(e),r(Ae.$$.fragment,e),Bl=a(e),$e=o(e,"P",{"data-svelte-h":!0}),M($e)!=="svelte-3xsjjj"&&($e.textContent=en),kl=a(e),xe=o(e,"P",{"data-svelte-h":!0}),M(xe)!=="svelte-zj9pt2"&&(xe.innerHTML=tn),Gl=a(e),r(Re.$$.fragment,e),Wl=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),M(Ee)!=="svelte-1053it2"&&(Ee.textContent=ln),Al=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),M(Ve)!=="svelte-1jemoxg"&&(Ve.innerHTML=sn),$l=a(e),r(He.$$.fragment,e),xl=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),M(Ye)!=="svelte-12emzh2"&&(Ye.innerHTML=nn),Rl=a(e),r(Le.$$.fragment,e),El=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),M(Qe)!=="svelte-nxef74"&&(Qe.textContent=an),Vl=a(e),Ne=o(e,"OL",{"data-svelte-h":!0}),M(Ne)!=="svelte-1ys56q5"&&(Ne.innerHTML=on),Hl=a(e),Se=o(e,"P",{"data-svelte-h":!0}),M(Se)!=="svelte-ijt5m6"&&(Se.innerHTML=Mn),Yl=a(e),r(_e.$$.fragment,e),Ll=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),M(Xe)!=="svelte-14neeab"&&(Xe.textContent=pn),Ql=a(e),r(ze.$$.fragment,e),Nl=a(e),r(Fe.$$.fragment,e),Sl=a(e),qe=o(e,"P",{"data-svelte-h":!0}),M(qe)!=="svelte-giwu4e"&&(qe.innerHTML=rn),_l=a(e),r(De.$$.fragment,e),Xl=a(e),Pe=o(e,"P",{"data-svelte-h":!0}),M(Pe)!=="svelte-y12uij"&&(Pe.innerHTML=un),zl=a(e),Ke=o(e,"OL",{"data-svelte-h":!0}),M(Ke)!=="svelte-1lfvsus"&&(Ke.innerHTML=cn),Fl=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),M(Oe)!=="svelte-1ew78oh"&&(Oe.textContent=mn),ql=a(e),r(et.$$.fragment,e),Dl=a(e),tt=o(e,"P",{"data-svelte-h":!0}),M(tt)!=="svelte-1ebq4ig"&&(tt.textContent=yn),Pl=a(e),lt=o(e,"UL",{"data-svelte-h":!0}),M(lt)!=="svelte-1lunl6l"&&(lt.innerHTML=wn),Kl=a(e),st=o(e,"P",{"data-svelte-h":!0}),M(st)!=="svelte-gt2dc"&&(st.textContent=Tn),Ol=a(e),nt=o(e,"P",{"data-svelte-h":!0}),M(nt)!=="svelte-ukc2vx"&&(nt.innerHTML=jn),es=a(e),r(at.$$.fragment,e),ts=a(e),it=o(e,"P",{"data-svelte-h":!0}),M(it)!=="svelte-1xbvrw5"&&(it.textContent=dn),ls=a(e),ot=o(e,"OL",{"data-svelte-h":!0}),M(ot)!=="svelte-1u9pd9c"&&(ot.innerHTML=Jn),ss=a(e),Mt=o(e,"P",{"data-svelte-h":!0}),M(Mt)!=="svelte-3bxv5s"&&(Mt.textContent=hn),ns=a(e),r(pt.$$.fragment,e),as=a(e),ut=o(e,"P",{}),Un(ut).forEach(l),this.h()},h(){os(j,"name","hf:doc:metadata"),os(j,"content",Wn),os(d,"class","tip")},m(e,t){Zn(document.head,j),s(e,ct,t),s(e,rt,t),s(e,mt,t),u(J,e,t),s(e,yt,t),u(h,e,t),s(e,wt,t),s(e,d,t),s(e,Tt,t),s(e,U,t),s(e,jt,t),s(e,b,t),s(e,dt,t),s(e,g,t),s(e,Jt,t),u(f,e,t),s(e,ht,t),s(e,C,t),s(e,Ut,t),s(e,I,t),s(e,bt,t),s(e,v,t),s(e,gt,t),u(Z,e,t),s(e,ft,t),s(e,B,t),s(e,Ct,t),u(k,e,t),s(e,It,t),u(G,e,t),s(e,vt,t),s(e,W,t),s(e,Zt,t),s(e,A,t),s(e,Bt,t),s(e,$,t),s(e,kt,t),u(x,e,t),s(e,Gt,t),s(e,R,t),s(e,Wt,t),u(E,e,t),s(e,At,t),s(e,V,t),s(e,$t,t),u(H,e,t),s(e,xt,t),s(e,Y,t),s(e,Rt,t),u(L,e,t),s(e,Et,t),u(Q,e,t),s(e,Vt,t),s(e,N,t),s(e,Ht,t),u(S,e,t),s(e,Yt,t),s(e,_,t),s(e,Lt,t),s(e,X,t),s(e,Qt,t),s(e,z,t),s(e,Nt,t),s(e,F,t),s(e,St,t),u(q,e,t),s(e,_t,t),s(e,D,t),s(e,Xt,t),u(P,e,t),s(e,zt,t),u(K,e,t),s(e,Ft,t),s(e,O,t),s(e,qt,t),s(e,ee,t),s(e,Dt,t),s(e,te,t),s(e,Pt,t),s(e,le,t),s(e,Kt,t),s(e,se,t),s(e,Ot,t),u(ne,e,t),s(e,el,t),s(e,ae,t),s(e,tl,t),u(ie,e,t),s(e,ll,t),s(e,oe,t),s(e,sl,t),s(e,Me,t),s(e,nl,t),u(pe,e,t),s(e,al,t),s(e,re,t),s(e,il,t),s(e,ue,t),s(e,ol,t),s(e,ce,t),s(e,Ml,t),u(me,e,t),s(e,pl,t),s(e,ye,t),s(e,rl,t),s(e,we,t),s(e,ul,t),s(e,Te,t),s(e,cl,t),u(je,e,t),s(e,ml,t),s(e,de,t),s(e,yl,t),u(Je,e,t),s(e,wl,t),s(e,he,t),s(e,Tl,t),u(Ue,e,t),s(e,jl,t),s(e,be,t),s(e,dl,t),s(e,ge,t),s(e,Jl,t),u(fe,e,t),s(e,hl,t),s(e,Ce,t),s(e,Ul,t),s(e,Ie,t),s(e,bl,t),u(ve,e,t),s(e,gl,t),s(e,Ze,t),s(e,fl,t),s(e,Be,t),s(e,Cl,t),s(e,ke,t),s(e,Il,t),s(e,Ge,t),s(e,vl,t),s(e,We,t),s(e,Zl,t),u(Ae,e,t),s(e,Bl,t),s(e,$e,t),s(e,kl,t),s(e,xe,t),s(e,Gl,t),u(Re,e,t),s(e,Wl,t),s(e,Ee,t),s(e,Al,t),s(e,Ve,t),s(e,$l,t),u(He,e,t),s(e,xl,t),s(e,Ye,t),s(e,Rl,t),u(Le,e,t),s(e,El,t),s(e,Qe,t),s(e,Vl,t),s(e,Ne,t),s(e,Hl,t),s(e,Se,t),s(e,Yl,t),u(_e,e,t),s(e,Ll,t),s(e,Xe,t),s(e,Ql,t),u(ze,e,t),s(e,Nl,t),u(Fe,e,t),s(e,Sl,t),s(e,qe,t),s(e,_l,t),u(De,e,t),s(e,Xl,t),s(e,Pe,t),s(e,zl,t),s(e,Ke,t),s(e,Fl,t),s(e,Oe,t),s(e,ql,t),u(et,e,t),s(e,Dl,t),s(e,tt,t),s(e,Pl,t),s(e,lt,t),s(e,Kl,t),s(e,st,t),s(e,Ol,t),s(e,nt,t),s(e,es,t),u(at,e,t),s(e,ts,t),s(e,it,t),s(e,ls,t),s(e,ot,t),s(e,ss,t),s(e,Mt,t),s(e,ns,t),u(pt,e,t),s(e,as,t),s(e,ut,t),is=!0},p:gn,i(e){is||(c(J.$$.fragment,e),c(h.$$.fragment,e),c(f.$$.fragment,e),c(Z.$$.fragment,e),c(k.$$.fragment,e),c(G.$$.fragment,e),c(x.$$.fragment,e),c(E.$$.fragment,e),c(H.$$.fragment,e),c(L.$$.fragment,e),c(Q.$$.fragment,e),c(S.$$.fragment,e),c(q.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(je.$$.fragment,e),c(Je.$$.fragment,e),c(Ue.$$.fragment,e),c(fe.$$.fragment,e),c(ve.$$.fragment,e),c(Ae.$$.fragment,e),c(Re.$$.fragment,e),c(He.$$.fragment,e),c(Le.$$.fragment,e),c(_e.$$.fragment,e),c(ze.$$.fragment,e),c(Fe.$$.fragment,e),c(De.$$.fragment,e),c(et.$$.fragment,e),c(at.$$.fragment,e),c(pt.$$.fragment,e),is=!0)},o(e){m(J.$$.fragment,e),m(h.$$.fragment,e),m(f.$$.fragment,e),m(Z.$$.fragment,e),m(k.$$.fragment,e),m(G.$$.fragment,e),m(x.$$.fragment,e),m(E.$$.fragment,e),m(H.$$.fragment,e),m(L.$$.fragment,e),m(Q.$$.fragment,e),m(S.$$.fragment,e),m(q.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(pe.$$.fragment,e),m(me.$$.fragment,e),m(je.$$.fragment,e),m(Je.$$.fragment,e),m(Ue.$$.fragment,e),m(fe.$$.fragment,e),m(ve.$$.fragment,e),m(Ae.$$.fragment,e),m(Re.$$.fragment,e),m(He.$$.fragment,e),m(Le.$$.fragment,e),m(_e.$$.fragment,e),m(ze.$$.fragment,e),m(Fe.$$.fragment,e),m(De.$$.fragment,e),m(et.$$.fragment,e),m(at.$$.fragment,e),m(pt.$$.fragment,e),is=!1},d(e){e&&(l(ct),l(rt),l(mt),l(yt),l(wt),l(d),l(Tt),l(U),l(jt),l(b),l(dt),l(g),l(Jt),l(ht),l(C),l(Ut),l(I),l(bt),l(v),l(gt),l(ft),l(B),l(Ct),l(It),l(vt),l(W),l(Zt),l(A),l(Bt),l($),l(kt),l(Gt),l(R),l(Wt),l(At),l(V),l($t),l(xt),l(Y),l(Rt),l(Et),l(Vt),l(N),l(Ht),l(Yt),l(_),l(Lt),l(X),l(Qt),l(z),l(Nt),l(F),l(St),l(_t),l(D),l(Xt),l(zt),l(Ft),l(O),l(qt),l(ee),l(Dt),l(te),l(Pt),l(le),l(Kt),l(se),l(Ot),l(el),l(ae),l(tl),l(ll),l(oe),l(sl),l(Me),l(nl),l(al),l(re),l(il),l(ue),l(ol),l(ce),l(Ml),l(pl),l(ye),l(rl),l(we),l(ul),l(Te),l(cl),l(ml),l(de),l(yl),l(wl),l(he),l(Tl),l(jl),l(be),l(dl),l(ge),l(Jl),l(hl),l(Ce),l(Ul),l(Ie),l(bl),l(gl),l(Ze),l(fl),l(Be),l(Cl),l(ke),l(Il),l(Ge),l(vl),l(We),l(Zl),l(Bl),l($e),l(kl),l(xe),l(Gl),l(Wl),l(Ee),l(Al),l(Ve),l($l),l(xl),l(Ye),l(Rl),l(El),l(Qe),l(Vl),l(Ne),l(Hl),l(Se),l(Yl),l(Ll),l(Xe),l(Ql),l(Nl),l(Sl),l(qe),l(_l),l(Xl),l(Pe),l(zl),l(Ke),l(Fl),l(Oe),l(ql),l(Dl),l(tt),l(Pl),l(lt),l(Kl),l(st),l(Ol),l(nt),l(es),l(ts),l(it),l(ls),l(ot),l(ss),l(Mt),l(ns),l(as),l(ut)),l(j),y(J,e),y(h,e),y(f,e),y(Z,e),y(k,e),y(G,e),y(x,e),y(E,e),y(H,e),y(L,e),y(Q,e),y(S,e),y(q,e),y(P,e),y(K,e),y(ne,e),y(ie,e),y(pe,e),y(me,e),y(je,e),y(Je,e),y(Ue,e),y(fe,e),y(ve,e),y(Ae,e),y(Re,e),y(He,e),y(Le,e),y(_e,e),y(ze,e),y(Fe,e),y(De,e),y(et,e),y(at,e),y(pt,e)}}}const Wn='{"title":"Bonus Unit 2: Observability and Evaluation of Agents","local":"bonus-unit-2-observability-and-evaluation-of-agents","sections":[{"title":"Exercise Prerequisites 🏗️","local":"exercise-prerequisites-","sections":[],"depth":2},{"title":"Step 0: Install the Required Libraries","local":"step-0-install-the-required-libraries","sections":[],"depth":2},{"title":"Step 1: Instrument Your Agent","local":"step-1-instrument-your-agent","sections":[],"depth":2},{"title":"Step 2: Test Your Instrumentation","local":"step-2-test-your-instrumentation","sections":[],"depth":2},{"title":"Step 3: Observe and Evaluate a More Complex Agent","local":"step-3-observe-and-evaluate-a-more-complex-agent","sections":[{"title":"Trace Structure","local":"trace-structure","sections":[],"depth":3}],"depth":2},{"title":"Online Evaluation","local":"online-evaluation","sections":[{"title":"Common Metrics to Track in Production","local":"common-metrics-to-track-in-production","sections":[{"title":"1. Costs","local":"1-costs","sections":[],"depth":4},{"title":"2. Latency","local":"2-latency","sections":[],"depth":4},{"title":"3. Additional Attributes","local":"3-additional-attributes","sections":[],"depth":4},{"title":"4. User Feedback","local":"4-user-feedback","sections":[],"depth":4},{"title":"5. LLM-as-a-Judge","local":"5-llm-as-a-judge","sections":[],"depth":4},{"title":"6. Observability Metrics Overview","local":"6-observability-metrics-overview","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Offline Evaluation","local":"offline-evaluation","sections":[{"title":"Dataset Evaluation","local":"dataset-evaluation","sections":[{"title":"Running the Agent on the Dataset","local":"running-the-agent-on-the-dataset","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Final Thoughts","local":"final-thoughts","sections":[],"depth":2}],"depth":1}';function An(Ms){return fn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yn extends Cn{constructor(j){super(),In(this,j,An,Gn,bn,{})}}export{Yn as component};
