import{s as Ms,f as We,n as ds,o as ms}from"../chunks/scheduler.37c15a92.js";import{S as ys,i as cs,g as i,s as a,r,A as us,h as p,f as t,c as n,j as rs,u as M,x as o,k as U,y as Us,a as l,v as d,d as m,t as y,w as c}from"../chunks/index.2bf4358c.js";import{C as K}from"../chunks/CodeBlock.4e987730.js";import{H as O}from"../chunks/Heading.8ada512a.js";import{E as gs}from"../chunks/getInferenceSnippets.0aa3753f.js";function js(Qe){let u,te,ee,le,j,ae,h,Ve="Para crear aplicaciones con LangGraph necesitas conocer sus elementos principales. Exploremos los componentes fundamentales que conforman una aplicacion con LangGraph.",ne,g,Ae,ie,f,He="Una aplicación en LangGraph empieza con una  <strong>entrada</strong>, y dependiendo de la ejecución, el flujo puede ir a una función o a otra hasta que llega al FINAL.",pe,w,Ne,oe,T,re,J,Fe="<strong>Estado(State)</strong> es un concepto central en LangGraphh. Representa toda la información que fluye a traves de la aplicación.",Me,C,de,$,Xe="El estado es <strong>definido por el usuario</strong>, es por eso que los campos deben contruirse cuidadosamente para contener toda la información necesaria para el proceso de toma de decisiones!",me,b,ze="<p>💡 <strong>Tip:</strong> Piensa cuidadosamente que información necesita tu aplicación para rastrear entre pasos.</p>",ye,G,ce,Z,Ye="<strong>Nodos(Nodes)</strong> son funciones de python. Cada nodo:",ue,_,Pe="<li>Toma el estado como entrada</li> <li>Realiza alguna operación</li> <li>Regresa actualizaciones al estado</li>",Ue,I,ge,v,De="Por ejemplo, los nodos pueden contener:",je,k,Ke="<li><strong>llamadas a LLM</strong>: Generar texto o tomar decisiones</li> <li><strong>llamadas a Tool</strong>: Interactuar con sistemas externos</li> <li><strong>Lógica Condicional</strong>: Determinar los siguientes pasos</li> <li><strong>Intervención Humana</strong>: Obtener datos del usuario</li>",he,S,Oe="<p>💡 <strong>Info:</strong> Algunos nodos necesarios para el flujo completo como START y END existen directamente desde langGraph.</p>",fe,x,we,B,es="<strong>Aristas (Edges)</strong> conectan nodos y definen los posibles caminos a través de tu grafo:",Te,E,Je,R,ss="Las aristas(edges) pueden ser:",Ce,q,ts="<li><strong>Directas (Direct)</strong>: Siempre van del nodo A al nodo B</li> <li><strong>Condicionales (Conditional)</strong>: Eligen el próximo nodo basándose en el estado actual</li>",$e,L,be,W,ls="El <strong>StateGraph</strong> es el contenedor que alberga todo el flujo de trabajo de tu agente:",Ge,Q,Ze,V,as="¡Que luego puede ser visualizado!",_e,A,Ie,H,ns,ve,N,is="Pero lo más importante, invocado::",ke,F,Se,X,ps="output :",xe,z,Be,Y,Ee,P,os="En la siguiente sección, pondremos estos conceptos en práctica construyendo nuestro primer grafo. Este grafo permite a Alfred recibir tus correos electrónicos, clasificarlos y elaborar una respuesta preliminar si son genuinos.",Re,D,qe,se,Le;return j=new O({props:{title:"Componentes de LangGraph",local:"componentes-de-langgraph",headingTag:"h1"}}),T=new O({props:{title:"1. Estado(State)",local:"1-estadostate",headingTag:"h2"}}),C=new K({props:{code:"ZnJvbSUyMHR5cGluZ19leHRlbnNpb25zJTIwaW1wb3J0JTIwVHlwZWREaWN0JTBBJTBBY2xhc3MlMjBTdGF0ZShUeXBlZERpY3QpJTNBJTBBJTIwJTIwJTIwJTIwZ3JhcGhfc3RhdGUlM0ElMjBzdHI=",highlighted:`<span class="hljs-keyword">from</span> typing_extensions <span class="hljs-keyword">import</span> TypedDict

<span class="hljs-keyword">class</span> <span class="hljs-title class_">State</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    graph_state: <span class="hljs-built_in">str</span>`,wrap:!1}}),G=new O({props:{title:"2. Nodos(Nodes)",local:"2-nodosnodes",headingTag:"h2"}}),I=new K({props:{code:"ZGVmJTIwbm9kZV8xKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAxLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwWW8lMjBlc3RveSUyMiU3RCUwQSUwQWRlZiUyMG5vZGVfMihzdGF0ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjItLS1Ob2RlJTIwMi0tLSUyMiklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJncmFwaF9zdGF0ZSUyMiUzQSUyMHN0YXRlJTVCJ2dyYXBoX3N0YXRlJyU1RCUyMCUyQiUyMiUyMGZlbGl6ISUyMiU3RCUwQSUwQWRlZiUyMG5vZGVfMyhzdGF0ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjItLS1Ob2RlJTIwMy0tLSUyMiklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJncmFwaF9zdGF0ZSUyMiUzQSUyMHN0YXRlJTVCJ2dyYXBoX3N0YXRlJyU1RCUyMCUyQiUyMiUyMHRyaXN0ZSElMjIlN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_1</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 1---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; Yo estoy&quot;</span>}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_2</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 2---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; feliz!&quot;</span>}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_3</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 3---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; triste!&quot;</span>}`,wrap:!1}}),x=new O({props:{title:"3. Aristas (Edges)",local:"3-aristas-edges",headingTag:"h2"}}),E=new K({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpdGVyYWwlMEElMEFkZWYlMjBkZWNpZGVfbW9vZChzdGF0ZSklMjAtJTNFJTIwTGl0ZXJhbCU1QiUyMm5vZGVfMiUyMiUyQyUyMCUyMm5vZGVfMyUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMEElMjBtZW51ZG8lMkMlMjB1c2FyZW1vcyUyMGVsJTIwZXN0YWRvJTIwcGFyYSUyMGRlY2lkaXIlMjBlbCUyMHByJUMzJUIzeGltbyUyMG5vZG8lMjBhJTIwdmlzaXRhciUwQSUyMCUyMCUyMCUyMHVzdWFyaW9fZW50cmFkYSUyMCUzRCUyMHN0YXRlJTVCJ2dyYXBoX3N0YXRlJyU1RCUyMCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEFxdSVDMyVBRCUyQyUyMGhhZ2Ftb3MlMjBzaW1wbGVtZW50ZSUyMHVuYSUyMGRpdmlzaSVDMyVCM24lMjA1MCUyMCUyRiUyMDUwJTIwZW50cmUlMjBsb3MlMjBub2RvcyUyMDIlMkMlMjAzJTBBJTIwJTIwJTIwJTIwaWYlMjByYW5kb20ucmFuZG9tKCklMjAlM0MlMjAwLjUlM0ElMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjA1MCUyNSUyMGRlbCUyMHRpZW1wbyUyQyUyMGRldm9sdmVtb3MlMjBlbCUyME5vZG8lMjAyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIybm9kZV8yJTIyJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwNTAlMjUlMjBkZWwlMjB0aWVtcG8lMkMlMjBkZXZvbHZlbW9zJTIwZWwlMjBOb2RvJTIwMyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCUyMm5vZGVfMyUyMlJldHJ5Q2xhdWRlJTIwY2FuJTIwbWFrZSUyMG1pc3Rha2VzLiUyMFBsZWFzZSUyMGRvdWJsZS1jaGVjayUyMHJlc3BvbnNlcy4=",highlighted:`<span class="hljs-keyword">import</span> random
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Literal</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">decide_mood</span>(<span class="hljs-params">state</span>) -&gt; <span class="hljs-type">Literal</span>[<span class="hljs-string">&quot;node_2&quot;</span>, <span class="hljs-string">&quot;node_3&quot;</span>]:
    
    <span class="hljs-comment"># A menudo, usaremos el estado para decidir el próximo nodo a visitar</span>
    usuario_entrada = state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] 

    <span class="hljs-comment"># Aquí, hagamos simplemente una división 50 / 50 entre los nodos 2, 3</span>
    <span class="hljs-keyword">if</span> random.random() &lt; <span class="hljs-number">0.5</span>:
    
        <span class="hljs-comment"># 50% del tiempo, devolvemos el Nodo 2</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;node_2&quot;</span>

    <span class="hljs-comment"># 50% del tiempo, devolvemos el Nodo 3</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;node_3&quot;</span>RetryClaude can make mistakes. Please double-check responses.`,wrap:!1}}),L=new O({props:{title:"4. StateGraph",local:"4-stategraph",headingTag:"h2"}}),Q=new K({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEltYWdlJTJDJTIwZGlzcGxheSUwQWZyb20lMjBsYW5nZ3JhcGguZ3JhcGglMjBpbXBvcnQlMjBTdGF0ZUdyYXBoJTJDJTIwU1RBUlQlMkMlMjBFTkQlMEElMEElMjMlMjBDb25zdHJ1aXIlMjBncmFmbyUwQWJ1aWxkZXIlMjAlM0QlMjBTdGF0ZUdyYXBoKFN0YXRlKSUwQWJ1aWxkZXIuYWRkX25vZGUoJTIybm9kZV8xJTIyJTJDJTIwbm9kZV8xKSUwQWJ1aWxkZXIuYWRkX25vZGUoJTIybm9kZV8yJTIyJTJDJTIwbm9kZV8yKSUwQWJ1aWxkZXIuYWRkX25vZGUoJTIybm9kZV8zJTIyJTJDJTIwbm9kZV8zKSUwQSUwQSUyMyUyMEwlQzMlQjNnaWNhJTBBYnVpbGRlci5hZGRfZWRnZShTVEFSVCUyQyUyMCUyMm5vZGVfMSUyMiklMEFidWlsZGVyLmFkZF9jb25kaXRpb25hbF9lZGdlcyglMjJub2RlXzElMjIlMkMlMjBkZWNpZGVfbW9vZCklMEFidWlsZGVyLmFkZF9lZGdlKCUyMm5vZGVfMiUyMiUyQyUyMEVORCklMEFidWlsZGVyLmFkZF9lZGdlKCUyMm5vZGVfMyUyMiUyQyUyMEVORCklMEElMEElMjMlMjBBJUMzJUIxYWRpciUwQWdyYXBoJTIwJTNEJTIwYnVpbGRlci5jb21waWxlKCk=",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image, display
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> StateGraph, START, END

<span class="hljs-comment"># Construir grafo</span>
builder = StateGraph(State)
builder.add_node(<span class="hljs-string">&quot;node_1&quot;</span>, node_1)
builder.add_node(<span class="hljs-string">&quot;node_2&quot;</span>, node_2)
builder.add_node(<span class="hljs-string">&quot;node_3&quot;</span>, node_3)

<span class="hljs-comment"># Lógica</span>
builder.add_edge(START, <span class="hljs-string">&quot;node_1&quot;</span>)
builder.add_conditional_edges(<span class="hljs-string">&quot;node_1&quot;</span>, decide_mood)
builder.add_edge(<span class="hljs-string">&quot;node_2&quot;</span>, END)
builder.add_edge(<span class="hljs-string">&quot;node_3&quot;</span>, END)

<span class="hljs-comment"># Añadir</span>
graph = builder.<span class="hljs-built_in">compile</span>()`,wrap:!1}}),A=new K({props:{code:"JTIzJTIwVmVyJTBBZGlzcGxheShJbWFnZShncmFwaC5nZXRfZ3JhcGgoKS5kcmF3X21lcm1haWRfcG5nKCkpKQ==",highlighted:`<span class="hljs-comment"># Ver</span>
display(Image(graph.get_graph().draw_mermaid_png()))`,wrap:!1}}),F=new K({props:{code:"Z3JhcGguaW52b2tlKCU3QiUyMmdyYXBoX3N0YXRlJTIyJTIwJTNBJTIwJTIySG9sYSUyQyUyMHNveSUyMExhbmNlLiUyMiU3RCk=",highlighted:'graph.invoke({<span class="hljs-string">&quot;graph_state&quot;</span> : <span class="hljs-string">&quot;Hola, soy Lance.&quot;</span>})',wrap:!1}}),z=new K({props:{code:"LS0tTm9kZSUyMDEtLS0lMEEtLS1Ob2RlJTIwMy0tLSUwQSU3QidncmFwaF9zdGF0ZSclM0ElMjAnSG9sYSUyQyUyMHNveSUyMExhbmNlLiUyMCVDMiVBMUVzdG95JTIwdHJpc3RlISclN0Q=",highlighted:`---<span class="hljs-keyword">Node</span> <span class="hljs-title">1---</span>
---<span class="hljs-keyword">Node</span> <span class="hljs-title">3---</span>
{&#x27;graph_state&#x27;: &#x27;Hola, soy Lance. ¡Estoy triste!&#x27;}`,wrap:!1}}),Y=new O({props:{title:"¿Qué sigue?",local:"qué-sigue",headingTag:"h2"}}),D=new gs({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit2/langgraph/building_blocks.mdx"}}),{c(){u=i("meta"),te=a(),ee=i("p"),le=a(),r(j.$$.fragment),ae=a(),h=i("p"),h.textContent=Ve,ne=a(),g=i("img"),ie=a(),f=i("p"),f.innerHTML=He,pe=a(),w=i("img"),oe=a(),r(T.$$.fragment),re=a(),J=i("p"),J.innerHTML=Fe,Me=a(),r(C.$$.fragment),de=a(),$=i("p"),$.innerHTML=Xe,me=a(),b=i("blockquote"),b.innerHTML=ze,ye=a(),r(G.$$.fragment),ce=a(),Z=i("p"),Z.innerHTML=Ye,ue=a(),_=i("ul"),_.innerHTML=Pe,Ue=a(),r(I.$$.fragment),ge=a(),v=i("p"),v.textContent=De,je=a(),k=i("ul"),k.innerHTML=Ke,he=a(),S=i("blockquote"),S.innerHTML=Oe,fe=a(),r(x.$$.fragment),we=a(),B=i("p"),B.innerHTML=es,Te=a(),r(E.$$.fragment),Je=a(),R=i("p"),R.textContent=ss,Ce=a(),q=i("ul"),q.innerHTML=ts,$e=a(),r(L.$$.fragment),be=a(),W=i("p"),W.innerHTML=ls,Ge=a(),r(Q.$$.fragment),Ze=a(),V=i("p"),V.textContent=as,_e=a(),r(A.$$.fragment),Ie=a(),H=i("img"),ve=a(),N=i("p"),N.textContent=is,ke=a(),r(F.$$.fragment),Se=a(),X=i("p"),X.textContent=ps,xe=a(),r(z.$$.fragment),Be=a(),r(Y.$$.fragment),Ee=a(),P=i("p"),P.textContent=os,Re=a(),r(D.$$.fragment),qe=a(),se=i("p"),this.h()},l(e){const s=us("svelte-u9bgzb",document.head);u=p(s,"META",{name:!0,content:!0}),s.forEach(t),te=n(e),ee=p(e,"P",{}),rs(ee).forEach(t),le=n(e),M(j.$$.fragment,e),ae=n(e),h=p(e,"P",{"data-svelte-h":!0}),o(h)!=="svelte-xuxj0i"&&(h.textContent=Ve),ne=n(e),g=p(e,"IMG",{src:!0,alt:!0,width:!0}),ie=n(e),f=p(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1afjpci"&&(f.innerHTML=He),pe=n(e),w=p(e,"IMG",{src:!0,alt:!0}),oe=n(e),M(T.$$.fragment,e),re=n(e),J=p(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-q3lndj"&&(J.innerHTML=Fe),Me=n(e),M(C.$$.fragment,e),de=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1g66syz"&&($.innerHTML=Xe),me=n(e),b=p(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(b)!=="svelte-oxxog5"&&(b.innerHTML=ze),ye=n(e),M(G.$$.fragment,e),ce=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1qjv490"&&(Z.innerHTML=Ye),ue=n(e),_=p(e,"UL",{"data-svelte-h":!0}),o(_)!=="svelte-16ifbd5"&&(_.innerHTML=Pe),Ue=n(e),M(I.$$.fragment,e),ge=n(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-11by32f"&&(v.textContent=De),je=n(e),k=p(e,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-6vioqc"&&(k.innerHTML=Ke),he=n(e),S=p(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(S)!=="svelte-ekx9b8"&&(S.innerHTML=Oe),fe=n(e),M(x.$$.fragment,e),we=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1gzev1z"&&(B.innerHTML=es),Te=n(e),M(E.$$.fragment,e),Je=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-8q4fu3"&&(R.textContent=ss),Ce=n(e),q=p(e,"UL",{"data-svelte-h":!0}),o(q)!=="svelte-17pi5sb"&&(q.innerHTML=ts),$e=n(e),M(L.$$.fragment,e),be=n(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-qp6fob"&&(W.innerHTML=ls),Ge=n(e),M(Q.$$.fragment,e),Ze=n(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-178ib0j"&&(V.textContent=as),_e=n(e),M(A.$$.fragment,e),Ie=n(e),H=p(e,"IMG",{src:!0,alt:!0}),ve=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-c2jdle"&&(N.textContent=is),ke=n(e),M(F.$$.fragment,e),Se=n(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1wdnc59"&&(X.textContent=ps),xe=n(e),M(z.$$.fragment,e),Be=n(e),M(Y.$$.fragment,e),Ee=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1tpo6os"&&(P.textContent=os),Re=n(e),M(D.$$.fragment,e),qe=n(e),se=p(e,"P",{}),rs(se).forEach(t),this.h()},h(){U(u,"name","hf:doc:metadata"),U(u,"content",hs),We(g.src,Ae="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/Building_blocks.png")||U(g,"src",Ae),U(g,"alt","Building Blocks"),U(g,"width","70%"),We(w.src,Ne="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/application.png")||U(w,"src",Ne),U(w,"alt","Application"),We(H.src,ns="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/basic_graph.jpeg")||U(H,"src",ns),U(H,"alt","Graph Visualization")},m(e,s){Us(document.head,u),l(e,te,s),l(e,ee,s),l(e,le,s),d(j,e,s),l(e,ae,s),l(e,h,s),l(e,ne,s),l(e,g,s),l(e,ie,s),l(e,f,s),l(e,pe,s),l(e,w,s),l(e,oe,s),d(T,e,s),l(e,re,s),l(e,J,s),l(e,Me,s),d(C,e,s),l(e,de,s),l(e,$,s),l(e,me,s),l(e,b,s),l(e,ye,s),d(G,e,s),l(e,ce,s),l(e,Z,s),l(e,ue,s),l(e,_,s),l(e,Ue,s),d(I,e,s),l(e,ge,s),l(e,v,s),l(e,je,s),l(e,k,s),l(e,he,s),l(e,S,s),l(e,fe,s),d(x,e,s),l(e,we,s),l(e,B,s),l(e,Te,s),d(E,e,s),l(e,Je,s),l(e,R,s),l(e,Ce,s),l(e,q,s),l(e,$e,s),d(L,e,s),l(e,be,s),l(e,W,s),l(e,Ge,s),d(Q,e,s),l(e,Ze,s),l(e,V,s),l(e,_e,s),d(A,e,s),l(e,Ie,s),l(e,H,s),l(e,ve,s),l(e,N,s),l(e,ke,s),d(F,e,s),l(e,Se,s),l(e,X,s),l(e,xe,s),d(z,e,s),l(e,Be,s),d(Y,e,s),l(e,Ee,s),l(e,P,s),l(e,Re,s),d(D,e,s),l(e,qe,s),l(e,se,s),Le=!0},p:ds,i(e){Le||(m(j.$$.fragment,e),m(T.$$.fragment,e),m(C.$$.fragment,e),m(G.$$.fragment,e),m(I.$$.fragment,e),m(x.$$.fragment,e),m(E.$$.fragment,e),m(L.$$.fragment,e),m(Q.$$.fragment,e),m(A.$$.fragment,e),m(F.$$.fragment,e),m(z.$$.fragment,e),m(Y.$$.fragment,e),m(D.$$.fragment,e),Le=!0)},o(e){y(j.$$.fragment,e),y(T.$$.fragment,e),y(C.$$.fragment,e),y(G.$$.fragment,e),y(I.$$.fragment,e),y(x.$$.fragment,e),y(E.$$.fragment,e),y(L.$$.fragment,e),y(Q.$$.fragment,e),y(A.$$.fragment,e),y(F.$$.fragment,e),y(z.$$.fragment,e),y(Y.$$.fragment,e),y(D.$$.fragment,e),Le=!1},d(e){e&&(t(te),t(ee),t(le),t(ae),t(h),t(ne),t(g),t(ie),t(f),t(pe),t(w),t(oe),t(re),t(J),t(Me),t(de),t($),t(me),t(b),t(ye),t(ce),t(Z),t(ue),t(_),t(Ue),t(ge),t(v),t(je),t(k),t(he),t(S),t(fe),t(we),t(B),t(Te),t(Je),t(R),t(Ce),t(q),t($e),t(be),t(W),t(Ge),t(Ze),t(V),t(_e),t(Ie),t(H),t(ve),t(N),t(ke),t(Se),t(X),t(xe),t(Be),t(Ee),t(P),t(Re),t(qe),t(se)),t(u),c(j,e),c(T,e),c(C,e),c(G,e),c(I,e),c(x,e),c(E,e),c(L,e),c(Q,e),c(A,e),c(F,e),c(z,e),c(Y,e),c(D,e)}}}const hs='{"title":"Componentes de LangGraph","local":"componentes-de-langgraph","sections":[{"title":"1. Estado(State)","local":"1-estadostate","sections":[],"depth":2},{"title":"2. Nodos(Nodes)","local":"2-nodosnodes","sections":[],"depth":2},{"title":"3. Aristas (Edges)","local":"3-aristas-edges","sections":[],"depth":2},{"title":"4. StateGraph","local":"4-stategraph","sections":[],"depth":2},{"title":"¿Qué sigue?","local":"qué-sigue","sections":[],"depth":2}],"depth":1}';function fs(Qe){return ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends ys{constructor(u){super(),cs(this,u,fs,js,Ms,{})}}export{bs as component};
