import{s as Ua,f as Ja,n as ma,o as ua}from"../chunks/scheduler.37c15a92.js";import{S as Ta,i as wa,g as M,s as t,r as i,A as da,h as o,f as a,c as n,j as Gs,u as c,x as p,k as Il,y as Ns,a as e,v as r,d as j,t as y,w as J}from"../chunks/index.2bf4358c.js";import{C as m}from"../chunks/CodeBlock.4e987730.js";import{H as U}from"../chunks/Heading.8ada512a.js";import{E as Ia}from"../chunks/getInferenceSnippets.0aa3753f.js";function ha(qs){let u,gl,bl,Bl,w,fl,d,Vs="Ahora que entendemos los componentes básicos, vamos a ponerlos en práctica construyendo nuestro primer grafo funcional. Implementaremos el sistema de procesamiento de correos electrónicos de Alfred, donde necesita:",Wl,I,Qs="<li>Leer correos electrónicos entrantes</li> <li>Clasificarlos como spam o legítimos</li> <li>Redactar una respuesta preliminar para correos legítimos</li> <li>Enviar información al Sr. Wayne cuando son legítimos (solo impresión)</li>",Al,h,Ys="Este ejemplo demuestra cómo estructurar un flujo de trabajo con LangGraph que involucra toma de decisiones basada en LLM. Aunque esto no puede considerarse un Agente ya que no se involucra ninguna herramienta, esta sección se enfoca más en aprender el marco de trabajo de LangGraph que en Agentes.",Zl,T,hl,Ss='Puedes seguir el código en <a href="https://huggingface.co/agents-course/notebooks/resolve/main/unit2/langgraph/mail_sorting.ipynb" target="_blank">este notebook</a> que puedes ejecutar usando Google Colab.',Es,b,El,C,zs="Aquí está el flujo de trabajo que construiremos:",Gl,g,vs,Nl,B,ql,f,Rs="Primero, instalemos los paquetes necesarios:",Vl,W,Ql,A,ks="A continuación, importemos los módulos necesarios:",Yl,Z,Sl,E,zl,G,Fs="Definamos qué información necesita rastrear Alfred durante el flujo de trabajo de procesamiento de correos electrónicos:",vl,N,Rl,q,Xs="<p>💡 <strong>Tip:</strong> Haz que tu estado sea lo suficientemente completo para rastrear toda la información importante, pero evita sobrecargarlo con detalles innecesarios.</p>",kl,V,Fl,Q,_s="Ahora, creemos las funciones de procesamiento que formarán nuestros nodos:",Xl,Y,_l,S,$l,z,$s="Necesitamos una función para determinar qué camino tomar después de la clasificación:",xl,v,Hl,R,xs="<p>💡 <strong>Nota:</strong> Esta función de enrutamiento es llamada por LangGraph para determinar qué arista(edge) seguir después del nodo de clasificación. El valor de retorno debe coincidir con una de las claves en nuestro mapeo de aristas(edges) condicionales.</p>",Ll,k,Dl,F,Hs="Ahora conectamos todo:",Pl,X,Kl,_,Ls="Observa cómo usamos el nodo especial  <code>END</code> proporcionado por LangGraph. Esto indica estados terminales donde el flujo de trabajo se completa.",Ol,$,ls,x,Ds="Probemos nuestro grafo con un correo legítimo y un correo spam:",ss,H,as,L,es,D,Ps="Mientras Alfred perfecciona el Agente de Clasificación de Correo, se está cansando de depurar sus ejecuciones. Los agentes, por naturaleza, son impredecibles y difíciles de inspeccionar. Pero como su objetivo es construir el mejor Agente de Detección de Spam y desplegarlo en producción, necesita una trazabilidad robusta para el monitoreo y análisis futuros.",ts,P,Ks='Para hacer esto, Alfred puede usar una herramienta de observabilidad como <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> para rastrear y monitorear el agente.',ns,K,Os="Primero, instalamos Langfuse con pip:",Ms,O,os,ll,la='Luego, agregamos las claves API de Langfuse y la dirección del host como variables de entorno. Puedes obtener tus credenciales de Langfuse registrándote en <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse Cloud</a> o <a href="https://langfuse.com/self-hosting" rel="nofollow">self-host Langfuse</a>.',ps,sl,is,al,sa='Luego, configuramos el <a href="https://langfuse.com/docs/integrations/langchain/tracing#add-langfuse-to-your-langchain-application" rel="nofollow">Langfuse <code>callback_handler</code></a> instrumentamos el agente añadiendo el <code>langfuse_callback</code> a la invocación del grafo: <code>config={&quot;callbacks&quot;: [langfuse_handler]}</code>.',cs,el,rs,tl,aa="¡Alfred está ahora conectado 🔌! Las ejecuciones de LangGraph se están registrando en Langfuse, dándole visibilidad completa del comportamiento del agente. Con esta configuración, está listo para revisar ejecuciones anteriores y refinar aún más su Agente de Clasificación de Correo.",js,nl,ea='<img src="https://langfuse.com/images/cookbook/huggingface-agent-course/langgraph-trace-legit.png" alt="Example trace in Langfuse"/>',ys,Ml,ta='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/f5d6d72e-20af-4357-b232-af44c3728a7b?timestamp=2025-03-17T10%3A13%3A28.413Z&amp;observation=6997ba69-043f-4f77-9445-700a033afba1" rel="nofollow">Public link to the trace with the legit email</a></em>',Js,ol,na="Visualizando Nuestro Grafo",Us,pl,Ma="LangGraph nos permite visualizar nuestro flujo de trabajo para entender y depurar mejor su estructura:",ms,il,us,cl,oa,Ts,rl,pa="Esto produce una representación visual que muestra cómo están conectados nuestros nodos y los caminos condicionales que se pueden tomar.",ws,jl,ds,yl,ia="Hemos creado un flujo de trabajo completo de procesamiento de correos electrónicos que:",Is,Jl,ca="<li>Toma un correo electrónico entrante</li> <li>Usa un LLM para clasificarlo como spam o legítimo</li> <li>Maneja el spam descartándolo</li> <li>Para correos legítimos, redacta una respuesta y notifica al Sr. Hugg</li>",hs,Ul,ra="Esto demuestra el poder de LangGraph para orquestar flujos de trabajo complejos con LLMs mientras mantiene un flujo claro y estructurado.",bs,ml,Cs,ul,ja="<li><strong>Gestión de Estado</strong>: Definimos un estado completo para rastrear todos los aspectos del procesamiento de correos electrónicos</li> <li><strong>Implementación de Nodos:</strong>: Creamos nodos funcionales que interactúan con un LLM</li> <li><strong>Enrutamiento Condicional</strong>: Implementamos lógica de ramificación basada en la clasificación de correos</li> <li><strong>Estados Terminales:</strong>: Usamos el nodo END para marcar puntos de finalización en nuestro flujo de trabajo</li>",gs,Tl,Bs,wl,ya="En la siguiente sección, exploraremos características más avanzadas de LangGraph, incluyendo el manejo de interacción humana en el flujo de trabajo y la implementación de lógica de ramificación más compleja basada en múltiples condiciones.",fs,dl,Ws,Cl,As;return w=new U({props:{title:"Construyendo Tu Primer LangGraph",local:"construyendo-tu-primer-langgraph",headingTag:"h1"}}),b=new U({props:{title:"Nuestro Flujo de Trabajo",local:"nuestro-flujo-de-trabajo",headingTag:"h2"}}),B=new U({props:{title:"Configurando Nuestro Entorno",local:"configurando-nuestro-entorno",headingTag:"h2"}}),W=new m({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdncmFwaCUyMGxhbmdjaGFpbl9vcGVuYWk=",highlighted:"%pip install langgraph langchain_openai",wrap:!1}}),Z=new m({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwVHlwZWREaWN0JTJDJTIwTGlzdCUyQyUyMERpY3QlMkMlMjBBbnklMkMlMjBPcHRpb25hbCUwQWZyb20lMjBsYW5nZ3JhcGguZ3JhcGglMjBpbXBvcnQlMjBTdGF0ZUdyYXBoJTJDJTIwRU5EJTBBZnJvbSUyMGxhbmdjaGFpbl9vcGVuYWklMjBpbXBvcnQlMjBDaGF0T3BlbkFJJTBBZnJvbSUyMGxhbmdjaGFpbl9jb3JlLm1lc3NhZ2VzJTIwaW1wb3J0JTIwSHVtYW5NZXNzYWdlJTJDJTIwQUlNZXNzYWdl",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> TypedDict, <span class="hljs-type">List</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Any</span>, <span class="hljs-type">Optional</span>
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> StateGraph, END
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> HumanMessage, AIMessage`,wrap:!1}}),E=new U({props:{title:"Paso 1: Definir Nuestro Estado",local:"paso-1-definir-nuestro-estado",headingTag:"h2"}}),N=new m({props:{code:"Y2xhc3MlMjBFbWFpbFN0YXRlKFR5cGVkRGljdCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBFbCUyMGNvcnJlbyUyMGVsZWN0ciVDMyVCM25pY28lMjBxdWUlMjBzZSUyMGVzdCVDMyVBMSUyMHByb2Nlc2FuZG8lMEElMjAlMjAlMjAlMjBlbWFpbCUzQSUyMERpY3QlNUJzdHIlMkMlMjBBbnklNUQlMjAlMjAlMjMlMjBDb250aWVuZSUyMGFzdW50byUyQyUyMHJlbWl0ZW50ZSUyQyUyMGN1ZXJwbyUyQyUyMGV0Yy4lMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBBbiVDMyVBMWxpc2lzJTIweSUyMGRlY2lzaW9uZXMlMEElMjAlMjAlMjAlMjBpc19zcGFtJTNBJTIwT3B0aW9uYWwlNUJib29sJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwR2VuZXJhY2klQzMlQjNuJTIwZGUlMjByZXNwdWVzdGElMEElMjAlMjAlMjAlMjBkcmFmdF9yZXNwb25zZSUzQSUyME9wdGlvbmFsJTVCc3RyJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwTWV0YWRhdG9zJTIwZGUlMjBwcm9jZXNhbWllbnRvJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0ElMjBMaXN0JTVCRGljdCU1QnN0ciUyQyUyMEFueSU1RCU1RCUyMCUyMCUyMyUyMFJhc3RyZWElMjBsYSUyMGNvbnZlcnNhY2klQzMlQjNuJTIwY29uJTIwTExNJTIwcGFyYSUyMGFuJUMzJUExbGlzaXM=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">EmailState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    <span class="hljs-comment"># El correo electrónico que se está procesando</span>
    email: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]  <span class="hljs-comment"># Contiene asunto, remitente, cuerpo, etc.</span>
    
    <span class="hljs-comment"># Análisis y decisiones</span>
    is_spam: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>]
    
    <span class="hljs-comment"># Generación de respuesta</span>
    draft_response: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]
    
    <span class="hljs-comment"># Metadatos de procesamiento</span>
    messages: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]]  <span class="hljs-comment"># Rastrea la conversación con LLM para análisis</span>`,wrap:!1}}),V=new U({props:{title:"Paso 2: Definir Nuestros Nodos",local:"paso-2-definir-nuestros-nodos",headingTag:"h2"}}),Y=new m({props:{code:"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",highlighted:`<span class="hljs-comment"># Inicializar nuestro LLM</span>
model = ChatOpenAI(temperature=<span class="hljs-number">0</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">read_email</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred lee y registra el correo electrónico entrante&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-comment"># Aquí podríamos hacer algún preprocesamiento inicial</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Alfred está procesando un correo electrónico de <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span> con asunto: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>&quot;</span>)
    
    <span class="hljs-comment"># No se necesitan cambios de estado aquí</span>
    <span class="hljs-keyword">return</span> {}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">classify_email</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred usa un LLM para determinar si el correo es spam o legítimo&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
     <span class="hljs-comment"># Preparar nuestro prompt para el LLM</span>
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    Como Alfred el mayordomo, analiza este correo electrónico y determina si es spam o legítimo.
    
    Email:
    De:  <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>
    Asunto: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>
    Body: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;body&#x27;</span>]}</span>
    
    Primero, determina si este correo es spam. Si es spam, explica por qué.
    Si es legítimo, categorízalo (consulta, queja, agradecimiento, etc.).
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Llamar al LLM</span>
    messages = [HumanMessage(content=prompt)]
    response = model.invoke(messages)
    
    <span class="hljs-comment"># Lógica simple para analizar la respuesta (en una aplicación real, querrías un análisis más robusto)</span>
    response_text = response.content.lower()
    is_spam = <span class="hljs-string">&quot;spam&quot;</span> <span class="hljs-keyword">in</span> response_text <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;not spam&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> response_text
    
    <span class="hljs-comment"># Extraer una razón si es spam</span>
    spam_reason = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">if</span> is_spam <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;reason:&quot;</span> <span class="hljs-keyword">in</span> response_text:
        spam_reason = response_text.split(<span class="hljs-string">&quot;reason:&quot;</span>)[<span class="hljs-number">1</span>].strip()
    
    <span class="hljs-comment"># Determinar categoría si es legítimo</span>
    email_category = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> is_spam:
        categories = [<span class="hljs-string">&quot;consulta&quot;</span>, <span class="hljs-string">&quot;queja&quot;</span>, <span class="hljs-string">&quot;agradecimiento&quot;</span>, <span class="hljs-string">&quot;solicitud&quot;</span>, <span class="hljs-string">&quot;información&quot;</span>]
        <span class="hljs-keyword">for</span> category <span class="hljs-keyword">in</span> categories:
            <span class="hljs-keyword">if</span> category <span class="hljs-keyword">in</span> response_text:
                email_category = category
                <span class="hljs-keyword">break</span>
    
    <span class="hljs-comment"># Actualizar mensajes para seguimiento</span>
    new_messages = state.get(<span class="hljs-string">&quot;messages&quot;</span>, []) + [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: response.content}
    ]
    
     <span class="hljs-comment"># Regresar actualizaciones de estado</span>
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;is_spam&quot;</span>: is_spam,
        <span class="hljs-string">&quot;spam_reason&quot;</span>: spam_reason,
        <span class="hljs-string">&quot;email_category&quot;</span>: email_category,
        <span class="hljs-string">&quot;messages&quot;</span>: new_messages
    }

<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_spam</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred descarta el correo spam con una nota&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Alfred ha marcado el correo como spam. Razón: <span class="hljs-subst">{state[<span class="hljs-string">&#x27;spam_reason&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;El correo ha sido movido a la carpeta de spam.&quot;</span>)
    
    <span class="hljs-comment"># Hemos terminado de procesar este correo</span>
    <span class="hljs-keyword">return</span> {}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">draft_response</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred redacta una respuesta preliminar para correos legítimos&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    category = state[<span class="hljs-string">&quot;email_category&quot;</span>] <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;general&quot;</span>
    
   <span class="hljs-comment"># Preparar nuestro prompt para el LLM</span>
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    Como Alfred el mayordomo, redacta una respuesta preliminar cortés a este correo.
    
    Email:
    From: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>
    Subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>
    Body: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;body&#x27;</span>]}</span>
    
     ste correo ha sido categorizado como: <span class="hljs-subst">{category}</span>
    
    Redacta una respuesta breve y profesional que el Sr. Hugg pueda revisar y personalizar antes de enviar.
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Llamar al LLM</span>
    messages = [HumanMessage(content=prompt)]
    response = model.invoke(messages)
    
    <span class="hljs-comment"># Actualizar mensajes para seguimiento</span>
    new_messages = state.get(<span class="hljs-string">&quot;messages&quot;</span>, []) + [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: response.content}
    ]
    
     <span class="hljs-comment"># Regresar actualizaciones de estado</span>
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;draft_response&quot;</span>: response.content,
        <span class="hljs-string">&quot;messages&quot;</span>: new_messages
    }

<span class="hljs-keyword">def</span> <span class="hljs-title function_">notify_mr_hugg</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred notifica al Sr. Hugg sobre el correo y presenta el borrador de respuesta&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Señor, ha recibido un correo electrónico de <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>.&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Categoría: <span class="hljs-subst">{state[<span class="hljs-string">&#x27;email_category&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nHe preparado un borrador de respuesta para su revisión:&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;-&quot;</span>*<span class="hljs-number">50</span>)
    <span class="hljs-built_in">print</span>(state[<span class="hljs-string">&quot;draft_response&quot;</span>])
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span> + <span class="hljs-string">&quot;\\n&quot;</span>)
    
    <span class="hljs-comment"># Hemos terminado de procesar este correo</span>
    <span class="hljs-keyword">return</span> {}`,wrap:!1}}),S=new U({props:{title:"Paso 3: Definir Nuestra Lógica de Enrutamiento",local:"paso-3-definir-nuestra-lógica-de-enrutamiento",headingTag:"h2"}}),v=new m({props:{code:"ZGVmJTIwcm91dGVfZW1haWwoc3RhdGUlM0ElMjBFbWFpbFN0YXRlKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJEZXRlcm1pbmFyJTIwZWwlMjBzaWd1aWVudGUlMjBwYXNvJTIwYmFzYWRvJTIwZW4lMjBsYSUyMGNsYXNpZmljYWNpJUMzJUIzbiUyMGRlJTIwc3BhbSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGlmJTIwc3RhdGUlNUIlMjJpc19zcGFtJTIyJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyc3BhbSUyMiUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlMjJsZWdpdGltYXRlJTIy",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">route_email</span>(<span class="hljs-params">state: EmailState</span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Determinar el siguiente paso basado en la clasificación de spam&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> state[<span class="hljs-string">&quot;is_spam&quot;</span>]:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;spam&quot;</span>
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;legitimate&quot;</span>`,wrap:!1}}),k=new U({props:{title:"Paso 4: Crear el StateGraph y Definir Aristas(Edges)",local:"paso-4-crear-el-stategraph-y-definir-aristasedges",headingTag:"h2"}}),X=new m({props:{code:"JTIzJTIwQ3JlYXIlMjBlbCUyMGdyYWZvJTBBZW1haWxfZ3JhcGglMjAlM0QlMjBTdGF0ZUdyYXBoKEVtYWlsU3RhdGUpJTBBJTBBJTIzJTIwQSVDMyVCMWFkaXIlMjBub2RvcyUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMnJlYWRfZW1haWwlMjIlMkMlMjByZWFkX2VtYWlsKSUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMmNsYXNzaWZ5X2VtYWlsJTIyJTJDJTIwY2xhc3NpZnlfZW1haWwpJTBBZW1haWxfZ3JhcGguYWRkX25vZGUoJTIyaGFuZGxlX3NwYW0lMjIlMkMlMjBoYW5kbGVfc3BhbSklMEFlbWFpbF9ncmFwaC5hZGRfbm9kZSglMjJkcmFmdF9yZXNwb25zZSUyMiUyQyUyMGRyYWZ0X3Jlc3BvbnNlKSUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMm5vdGlmeV9tcl9odWdnJTIyJTJDJTIwbm90aWZ5X21yX2h1Z2cpJTBBJTBBJTIzJTIwQSVDMyVCMWFkaXIlMjBhcmlzdGFzKGVkZ2VzKSUyMC0lMjBkZWZpbmllbmRvJTIwZWwlMjBmbHVqbyUwQWVtYWlsX2dyYXBoLmFkZF9lZGdlKCUyMnJlYWRfZW1haWwlMjIlMkMlMjAlMjJjbGFzc2lmeV9lbWFpbCUyMiklMEElMEElMjMlMjBBJUMzJUIxYWRpciUyMHJhbWlmaWNhY2klQzMlQjNuJTIwY29uZGljaW9uYWwlMjBkZXNkZSUyMGNsYXNzaWZ5X2VtYWlsJTBBZW1haWxfZ3JhcGguYWRkX2NvbmRpdGlvbmFsX2VkZ2VzKCUwQSUyMCUyMCUyMCUyMCUyMmNsYXNzaWZ5X2VtYWlsJTIyJTJDJTBBJTIwJTIwJTIwJTIwcm91dGVfZW1haWwlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzcGFtJTIyJTNBJTIwJTIyaGFuZGxlX3NwYW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWdpdGltYXRlJTIyJTNBJTIwJTIyZHJhZnRfcmVzcG9uc2UlMjIlMEElMjAlMjAlMjAlMjAlN0QlMEEpJTBBJTBBJTIzJTIwQSVDMyVCMWFkaXIlMjBsYXMlMjBhcmlzdGFzKGVkZ2VzKSUyMGZpbmFsZXMlMEFlbWFpbF9ncmFwaC5hZGRfZWRnZSglMjJoYW5kbGVfc3BhbSUyMiUyQyUyMEVORCklMEFlbWFpbF9ncmFwaC5hZGRfZWRnZSglMjJkcmFmdF9yZXNwb25zZSUyMiUyQyUyMCUyMm5vdGlmeV9tcl9odWdnJTIyKSUwQWVtYWlsX2dyYXBoLmFkZF9lZGdlKCUyMm5vdGlmeV9tcl9odWdnJTIyJTJDJTIwRU5EKSUwQSUwQSUyMyUyMENvbXBpbGFyJTIwZWwlMjBncmFmbyUwQWNvbXBpbGVkX2dyYXBoJTIwJTNEJTIwZW1haWxfZ3JhcGguY29tcGlsZSgp",highlighted:`<span class="hljs-comment"># Crear el grafo</span>
email_graph = StateGraph(EmailState)

<span class="hljs-comment"># Añadir nodos</span>
email_graph.add_node(<span class="hljs-string">&quot;read_email&quot;</span>, read_email)
email_graph.add_node(<span class="hljs-string">&quot;classify_email&quot;</span>, classify_email)
email_graph.add_node(<span class="hljs-string">&quot;handle_spam&quot;</span>, handle_spam)
email_graph.add_node(<span class="hljs-string">&quot;draft_response&quot;</span>, draft_response)
email_graph.add_node(<span class="hljs-string">&quot;notify_mr_hugg&quot;</span>, notify_mr_hugg)

<span class="hljs-comment"># Añadir aristas(edges) - definiendo el flujo</span>
email_graph.add_edge(<span class="hljs-string">&quot;read_email&quot;</span>, <span class="hljs-string">&quot;classify_email&quot;</span>)

<span class="hljs-comment"># Añadir ramificación condicional desde classify_email</span>
email_graph.add_conditional_edges(
    <span class="hljs-string">&quot;classify_email&quot;</span>,
    route_email,
    {
        <span class="hljs-string">&quot;spam&quot;</span>: <span class="hljs-string">&quot;handle_spam&quot;</span>,
        <span class="hljs-string">&quot;legitimate&quot;</span>: <span class="hljs-string">&quot;draft_response&quot;</span>
    }
)

<span class="hljs-comment"># Añadir las aristas(edges) finales</span>
email_graph.add_edge(<span class="hljs-string">&quot;handle_spam&quot;</span>, END)
email_graph.add_edge(<span class="hljs-string">&quot;draft_response&quot;</span>, <span class="hljs-string">&quot;notify_mr_hugg&quot;</span>)
email_graph.add_edge(<span class="hljs-string">&quot;notify_mr_hugg&quot;</span>, END)

<span class="hljs-comment"># Compilar el grafo</span>
compiled_graph = email_graph.<span class="hljs-built_in">compile</span>()`,wrap:!1}}),$=new U({props:{title:"Paso 5: Ejecutar la Aplicación",local:"paso-5-ejecutar-la-aplicación",headingTag:"h2"}}),H=new m({props:{code:"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",highlighted:`<span class="hljs-comment"># Ejemplo de correo legítimo</span>
legitimate_email = {
    <span class="hljs-string">&quot;sender&quot;</span>: <span class="hljs-string">&quot;john.smith@example.com&quot;</span>,
    <span class="hljs-string">&quot;subject&quot;</span>: <span class="hljs-string">&quot;Pregunta sobre sus servicios&quot;</span>,
    <span class="hljs-string">&quot;body&quot;</span>: <span class="hljs-string">&quot;Estimado Sr. Hugg, un colega me recomendó contactarle y estoy interesado en conocer más sobre sus servicios de consultoría. ¿Podríamos programar una llamada la próxima semana? Saludos cordiales, John Smith&quot;</span>
}

<span class="hljs-comment"># Ejemplo de correo spam</span>
spam_email = {
    <span class="hljs-string">&quot;sender&quot;</span>: <span class="hljs-string">&quot;winner@lottery-intl.com&quot;</span>,
    <span class="hljs-string">&quot;subject&quot;</span>: ¡¡¡HAS GANADO $<span class="hljs-number">5</span>,<span class="hljs-number">000</span>,<span class="hljs-number">000</span>!!!<span class="hljs-string">&quot;,
    &quot;</span>body<span class="hljs-string">&quot;: &quot;</span>¡FELICIDADES! ¡Has sido seleccionado como el ganador de nuestra lotería internacional! Para reclamar tu premio de $<span class="hljs-number">5</span>,<span class="hljs-number">000</span>,<span class="hljs-number">000</span>, por favor envíanos tus datos bancarios y una tarifa de procesamiento de $<span class="hljs-number">100.</span><span class="hljs-string">&quot;
}

# Procesar el correo legítimo
print(&quot;</span>\\nProcesando correo legítimo...<span class="hljs-string">&quot;)
legitimate_result = compiled_graph.invoke({
    &quot;</span>email<span class="hljs-string">&quot;: legitimate_email,
    &quot;</span>is_spam<span class="hljs-string">&quot;: None,
    &quot;</span>spam_reason<span class="hljs-string">&quot;: None,
    &quot;</span>email_category<span class="hljs-string">&quot;: None,
    &quot;</span>draft_response<span class="hljs-string">&quot;: None,
    &quot;</span>messages<span class="hljs-string">&quot;: []
})

# Procesar el correo spam
print(&quot;</span>\\nProcesando correo spam...<span class="hljs-string">&quot;)
spam_result = compiled_graph.invoke({
    &quot;</span>email<span class="hljs-string">&quot;: spam_email,
    &quot;</span>is_spam<span class="hljs-string">&quot;: None,
    &quot;</span>spam_reason<span class="hljs-string">&quot;: None,
    &quot;</span>email_category<span class="hljs-string">&quot;: None,
    &quot;</span>draft_response<span class="hljs-string">&quot;: None,
    &quot;</span>messages<span class="hljs-string">&quot;: []
})</span>`,wrap:!1}}),L=new U({props:{title:"Paso 6: Inspeccionando Nuestro Agente de Clasificación de Correo con Langfuse 📡",local:"paso-6-inspeccionando-nuestro-agente-de-clasificación-de-correo-con-langfuse-",headingTag:"h2"}}),O=new m({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMC1xJTIwbGFuZ2Z1c2U=",highlighted:"%pip install -q langfuse",wrap:!1}}),sl=new m({props:{code:"aW1wb3J0JTIwb3MlMEElMjAlMEElMjMlMjBPYnQlQzMlQTluJTIwbGFzJTIwY2xhdmVzJTIwcGFyYSUyMHR1JTIwcHJveWVjdG8lMjBkZXNkZSUyMGxhJTIwcCVDMyVBMWdpbmElMjBkZSUyMGNvbmZpZ3VyYWNpJUMzJUIzbiUyMGRlbCUyMHByb3llY3RvJTNBJTIwaHR0cHMlM0ElMkYlMkZjbG91ZC5sYW5nZnVzZS5jb20lMEFvcy5lbnZpcm9uJTVCJTIyTEFOR0ZVU0VfUFVCTElDX0tFWSUyMiU1RCUyMCUzRCUyMCUyMnBrLWxmLS4uLiUyMiUyMCUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9TRUNSRVRfS0VZJTIyJTVEJTIwJTNEJTIwJTIyc2stbGYtLi4uJTIyJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX0hPU1QlMjIlNUQlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmNsb3VkLmxhbmdmdXNlLmNvbSUyMiUyMCUyMyUyMCVGMCU5RiU4NyVBQSVGMCU5RiU4NyVCQSUyMHJlZ2klQzMlQjNuJTIwZGUlMjBsYSUyMFVFJTBBJTIzJTIwb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX0hPU1QlMjIlNUQlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVzLmNsb3VkLmxhbmdmdXNlLmNvbSUyMiUyMCUyMyUyMCVGMCU5RiU4NyVCQSVGMCU5RiU4NyVCOCUyMHJlZ2klQzMlQjNuJTIwZGUlMjBFRS5V",highlighted:`<span class="hljs-keyword">import</span> os
 
<span class="hljs-comment"># Obtén las claves para tu proyecto desde la página de configuración del proyecto: https://cloud.langfuse.com</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = <span class="hljs-string">&quot;sk-lf-...&quot;</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span> <span class="hljs-comment"># 🇪🇺 región de la UE</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot; # 🇺🇸 región de EE.U</span>`,wrap:!1}}),el=new m({props:{code:"ZnJvbSUyMGxhbmdmdXNlLmNhbGxiYWNrJTIwaW1wb3J0JTIwQ2FsbGJhY2tIYW5kbGVyJTBBJTBBJTIzJTIwSW5pY2lhbGl6YXIlMjBDYWxsYmFja0hhbmRsZXIlMjBkZSUyMExhbmdmdXNlJTIwcGFyYSUyMExhbmdHcmFwaCUyRkxhbmdjaGFpbiUyMCh0cmF6YWRvKSUwQWxhbmdmdXNlX2hhbmRsZXIlMjAlM0QlMjBDYWxsYmFja0hhbmRsZXIoKSUwQSUwQSUyMyUyMFByb2Nlc2FyJTIwY29ycmVvJTIwbGVnJUMzJUFEdGltbyUwQWxlZ2l0aW1hdGVfcmVzdWx0JTIwJTNEJTIwY29tcGlsZWRfZ3JhcGguaW52b2tlKCUwQSUyMCUyMCUyMCUyMGlucHV0JTNEJTdCJTIyZW1haWwlMjIlM0ElMjBsZWdpdGltYXRlX2VtYWlsJTJDJTIwJTIyaXNfc3BhbSUyMiUzQSUyME5vbmUlMkMlMjAlMjJzcGFtX3JlYXNvbiUyMiUzQSUyME5vbmUlMkMlMjAlMjJlbWFpbF9jYXRlZ29yeSUyMiUzQSUyME5vbmUlMkMlMjAlMjJkcmFmdF9yZXNwb25zZSUyMiUzQSUyME5vbmUlMkMlMjAlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMGNvbmZpZyUzRCU3QiUyMmNhbGxiYWNrcyUyMiUzQSUyMCU1QmxhbmdmdXNlX2hhbmRsZXIlNUQlN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> langfuse.callback <span class="hljs-keyword">import</span> CallbackHandler

<span class="hljs-comment"># Inicializar CallbackHandler de Langfuse para LangGraph/Langchain (trazado)</span>
langfuse_handler = CallbackHandler()

<span class="hljs-comment"># Procesar correo legítimo</span>
legitimate_result = compiled_graph.invoke(
    <span class="hljs-built_in">input</span>={<span class="hljs-string">&quot;email&quot;</span>: legitimate_email, <span class="hljs-string">&quot;is_spam&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;spam_reason&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;email_category&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;draft_response&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;messages&quot;</span>: []},
    config={<span class="hljs-string">&quot;callbacks&quot;</span>: [langfuse_handler]}
)`,wrap:!1}}),il=new m({props:{code:"Y29tcGlsZWRfZ3JhcGguZ2V0X2dyYXBoKCkuZHJhd19tZXJtYWlkX3BuZygp",highlighted:"compiled_graph.get_graph().draw_mermaid_png()",wrap:!1}}),jl=new U({props:{title:"Lo Que Hemos Construido",local:"lo-que-hemos-construido",headingTag:"h2"}}),ml=new U({props:{title:"Puntos Clave",local:"puntos-clave",headingTag:"h2"}}),Tl=new U({props:{title:"¿Qué Sigue?",local:"qué-sigue",headingTag:"h2"}}),dl=new Ia({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit2/langgraph/first_graph.mdx"}}),{c(){u=M("meta"),gl=t(),bl=M("p"),Bl=t(),i(w.$$.fragment),fl=t(),d=M("p"),d.textContent=Vs,Wl=t(),I=M("ol"),I.innerHTML=Qs,Al=t(),h=M("p"),h.textContent=Ys,Zl=t(),T=M("blockquote"),hl=M("p"),hl.innerHTML=Ss,Es=t(),i(b.$$.fragment),El=t(),C=M("p"),C.textContent=zs,Gl=t(),g=M("img"),Nl=t(),i(B.$$.fragment),ql=t(),f=M("p"),f.textContent=Rs,Vl=t(),i(W.$$.fragment),Ql=t(),A=M("p"),A.textContent=ks,Yl=t(),i(Z.$$.fragment),Sl=t(),i(E.$$.fragment),zl=t(),G=M("p"),G.textContent=Fs,vl=t(),i(N.$$.fragment),Rl=t(),q=M("blockquote"),q.innerHTML=Xs,kl=t(),i(V.$$.fragment),Fl=t(),Q=M("p"),Q.textContent=_s,Xl=t(),i(Y.$$.fragment),_l=t(),i(S.$$.fragment),$l=t(),z=M("p"),z.textContent=$s,xl=t(),i(v.$$.fragment),Hl=t(),R=M("blockquote"),R.innerHTML=xs,Ll=t(),i(k.$$.fragment),Dl=t(),F=M("p"),F.textContent=Hs,Pl=t(),i(X.$$.fragment),Kl=t(),_=M("p"),_.innerHTML=Ls,Ol=t(),i($.$$.fragment),ls=t(),x=M("p"),x.textContent=Ds,ss=t(),i(H.$$.fragment),as=t(),i(L.$$.fragment),es=t(),D=M("p"),D.textContent=Ps,ts=t(),P=M("p"),P.innerHTML=Ks,ns=t(),K=M("p"),K.textContent=Os,Ms=t(),i(O.$$.fragment),os=t(),ll=M("p"),ll.innerHTML=la,ps=t(),i(sl.$$.fragment),is=t(),al=M("p"),al.innerHTML=sa,cs=t(),i(el.$$.fragment),rs=t(),tl=M("p"),tl.textContent=aa,js=t(),nl=M("p"),nl.innerHTML=ea,ys=t(),Ml=M("p"),Ml.innerHTML=ta,Js=t(),ol=M("p"),ol.textContent=na,Us=t(),pl=M("p"),pl.textContent=Ma,ms=t(),i(il.$$.fragment),us=t(),cl=M("img"),Ts=t(),rl=M("p"),rl.textContent=pa,ws=t(),i(jl.$$.fragment),ds=t(),yl=M("p"),yl.textContent=ia,Is=t(),Jl=M("ol"),Jl.innerHTML=ca,hs=t(),Ul=M("p"),Ul.textContent=ra,bs=t(),i(ml.$$.fragment),Cs=t(),ul=M("ul"),ul.innerHTML=ja,gs=t(),i(Tl.$$.fragment),Bs=t(),wl=M("p"),wl.textContent=ya,fs=t(),i(dl.$$.fragment),Ws=t(),Cl=M("p"),this.h()},l(l){const s=da("svelte-u9bgzb",document.head);u=o(s,"META",{name:!0,content:!0}),s.forEach(a),gl=n(l),bl=o(l,"P",{}),Gs(bl).forEach(a),Bl=n(l),c(w.$$.fragment,l),fl=n(l),d=o(l,"P",{"data-svelte-h":!0}),p(d)!=="svelte-doeu2a"&&(d.textContent=Vs),Wl=n(l),I=o(l,"OL",{"data-svelte-h":!0}),p(I)!=="svelte-18e50hn"&&(I.innerHTML=Qs),Al=n(l),h=o(l,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1rwed3n"&&(h.textContent=Ys),Zl=n(l),T=o(l,"BLOCKQUOTE",{class:!0});var Zs=Gs(T);hl=o(Zs,"P",{"data-svelte-h":!0}),p(hl)!=="svelte-1e6stzx"&&(hl.innerHTML=Ss),Es=n(Zs),c(b.$$.fragment,Zs),Zs.forEach(a),El=n(l),C=o(l,"P",{"data-svelte-h":!0}),p(C)!=="svelte-8xoej8"&&(C.textContent=zs),Gl=n(l),g=o(l,"IMG",{src:!0,alt:!0}),Nl=n(l),c(B.$$.fragment,l),ql=n(l),f=o(l,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1tpjtub"&&(f.textContent=Rs),Vl=n(l),c(W.$$.fragment,l),Ql=n(l),A=o(l,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1khiaor"&&(A.textContent=ks),Yl=n(l),c(Z.$$.fragment,l),Sl=n(l),c(E.$$.fragment,l),zl=n(l),G=o(l,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1tph6bi"&&(G.textContent=Fs),vl=n(l),c(N.$$.fragment,l),Rl=n(l),q=o(l,"BLOCKQUOTE",{"data-svelte-h":!0}),p(q)!=="svelte-19va48"&&(q.innerHTML=Xs),kl=n(l),c(V.$$.fragment,l),Fl=n(l),Q=o(l,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-wfblmo"&&(Q.textContent=_s),Xl=n(l),c(Y.$$.fragment,l),_l=n(l),c(S.$$.fragment,l),$l=n(l),z=o(l,"P",{"data-svelte-h":!0}),p(z)!=="svelte-jowye"&&(z.textContent=$s),xl=n(l),c(v.$$.fragment,l),Hl=n(l),R=o(l,"BLOCKQUOTE",{"data-svelte-h":!0}),p(R)!=="svelte-1jznpp5"&&(R.innerHTML=xs),Ll=n(l),c(k.$$.fragment,l),Dl=n(l),F=o(l,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1u3rwx9"&&(F.textContent=Hs),Pl=n(l),c(X.$$.fragment,l),Kl=n(l),_=o(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1panad1"&&(_.innerHTML=Ls),Ol=n(l),c($.$$.fragment,l),ls=n(l),x=o(l,"P",{"data-svelte-h":!0}),p(x)!=="svelte-19tq2o0"&&(x.textContent=Ds),ss=n(l),c(H.$$.fragment,l),as=n(l),c(L.$$.fragment,l),es=n(l),D=o(l,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1qbfxk3"&&(D.textContent=Ps),ts=n(l),P=o(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-pa0rsu"&&(P.innerHTML=Ks),ns=n(l),K=o(l,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1mkf60j"&&(K.textContent=Os),Ms=n(l),c(O.$$.fragment,l),os=n(l),ll=o(l,"P",{"data-svelte-h":!0}),p(ll)!=="svelte-1tnragj"&&(ll.innerHTML=la),ps=n(l),c(sl.$$.fragment,l),is=n(l),al=o(l,"P",{"data-svelte-h":!0}),p(al)!=="svelte-jls7vc"&&(al.innerHTML=sa),cs=n(l),c(el.$$.fragment,l),rs=n(l),tl=o(l,"P",{"data-svelte-h":!0}),p(tl)!=="svelte-nazjpc"&&(tl.textContent=aa),js=n(l),nl=o(l,"P",{"data-svelte-h":!0}),p(nl)!=="svelte-3rgcl6"&&(nl.innerHTML=ea),ys=n(l),Ml=o(l,"P",{"data-svelte-h":!0}),p(Ml)!=="svelte-1kmw2a1"&&(Ml.innerHTML=ta),Js=n(l),ol=o(l,"P",{"data-svelte-h":!0}),p(ol)!=="svelte-12rx4fm"&&(ol.textContent=na),Us=n(l),pl=o(l,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-fg4lxm"&&(pl.textContent=Ma),ms=n(l),c(il.$$.fragment,l),us=n(l),cl=o(l,"IMG",{src:!0,alt:!0}),Ts=n(l),rl=o(l,"P",{"data-svelte-h":!0}),p(rl)!=="svelte-pjb0mq"&&(rl.textContent=pa),ws=n(l),c(jl.$$.fragment,l),ds=n(l),yl=o(l,"P",{"data-svelte-h":!0}),p(yl)!=="svelte-bkdtjn"&&(yl.textContent=ia),Is=n(l),Jl=o(l,"OL",{"data-svelte-h":!0}),p(Jl)!=="svelte-17og569"&&(Jl.innerHTML=ca),hs=n(l),Ul=o(l,"P",{"data-svelte-h":!0}),p(Ul)!=="svelte-ntcgtk"&&(Ul.textContent=ra),bs=n(l),c(ml.$$.fragment,l),Cs=n(l),ul=o(l,"UL",{"data-svelte-h":!0}),p(ul)!=="svelte-1wjpek5"&&(ul.innerHTML=ja),gs=n(l),c(Tl.$$.fragment,l),Bs=n(l),wl=o(l,"P",{"data-svelte-h":!0}),p(wl)!=="svelte-1fk3r9z"&&(wl.textContent=ya),fs=n(l),c(dl.$$.fragment,l),Ws=n(l),Cl=o(l,"P",{}),Gs(Cl).forEach(a),this.h()},h(){Il(u,"name","hf:doc:metadata"),Il(u,"content",ba),Il(T,"class","tip"),Ja(g.src,vs="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/first_graph.png")||Il(g,"src",vs),Il(g,"alt","First LangGraph"),Ja(cl.src,oa="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/mail_flow.png")||Il(cl,"src",oa),Il(cl,"alt","Mail LangGraph")},m(l,s){Ns(document.head,u),e(l,gl,s),e(l,bl,s),e(l,Bl,s),r(w,l,s),e(l,fl,s),e(l,d,s),e(l,Wl,s),e(l,I,s),e(l,Al,s),e(l,h,s),e(l,Zl,s),e(l,T,s),Ns(T,hl),Ns(T,Es),r(b,T,null),e(l,El,s),e(l,C,s),e(l,Gl,s),e(l,g,s),e(l,Nl,s),r(B,l,s),e(l,ql,s),e(l,f,s),e(l,Vl,s),r(W,l,s),e(l,Ql,s),e(l,A,s),e(l,Yl,s),r(Z,l,s),e(l,Sl,s),r(E,l,s),e(l,zl,s),e(l,G,s),e(l,vl,s),r(N,l,s),e(l,Rl,s),e(l,q,s),e(l,kl,s),r(V,l,s),e(l,Fl,s),e(l,Q,s),e(l,Xl,s),r(Y,l,s),e(l,_l,s),r(S,l,s),e(l,$l,s),e(l,z,s),e(l,xl,s),r(v,l,s),e(l,Hl,s),e(l,R,s),e(l,Ll,s),r(k,l,s),e(l,Dl,s),e(l,F,s),e(l,Pl,s),r(X,l,s),e(l,Kl,s),e(l,_,s),e(l,Ol,s),r($,l,s),e(l,ls,s),e(l,x,s),e(l,ss,s),r(H,l,s),e(l,as,s),r(L,l,s),e(l,es,s),e(l,D,s),e(l,ts,s),e(l,P,s),e(l,ns,s),e(l,K,s),e(l,Ms,s),r(O,l,s),e(l,os,s),e(l,ll,s),e(l,ps,s),r(sl,l,s),e(l,is,s),e(l,al,s),e(l,cs,s),r(el,l,s),e(l,rs,s),e(l,tl,s),e(l,js,s),e(l,nl,s),e(l,ys,s),e(l,Ml,s),e(l,Js,s),e(l,ol,s),e(l,Us,s),e(l,pl,s),e(l,ms,s),r(il,l,s),e(l,us,s),e(l,cl,s),e(l,Ts,s),e(l,rl,s),e(l,ws,s),r(jl,l,s),e(l,ds,s),e(l,yl,s),e(l,Is,s),e(l,Jl,s),e(l,hs,s),e(l,Ul,s),e(l,bs,s),r(ml,l,s),e(l,Cs,s),e(l,ul,s),e(l,gs,s),r(Tl,l,s),e(l,Bs,s),e(l,wl,s),e(l,fs,s),r(dl,l,s),e(l,Ws,s),e(l,Cl,s),As=!0},p:ma,i(l){As||(j(w.$$.fragment,l),j(b.$$.fragment,l),j(B.$$.fragment,l),j(W.$$.fragment,l),j(Z.$$.fragment,l),j(E.$$.fragment,l),j(N.$$.fragment,l),j(V.$$.fragment,l),j(Y.$$.fragment,l),j(S.$$.fragment,l),j(v.$$.fragment,l),j(k.$$.fragment,l),j(X.$$.fragment,l),j($.$$.fragment,l),j(H.$$.fragment,l),j(L.$$.fragment,l),j(O.$$.fragment,l),j(sl.$$.fragment,l),j(el.$$.fragment,l),j(il.$$.fragment,l),j(jl.$$.fragment,l),j(ml.$$.fragment,l),j(Tl.$$.fragment,l),j(dl.$$.fragment,l),As=!0)},o(l){y(w.$$.fragment,l),y(b.$$.fragment,l),y(B.$$.fragment,l),y(W.$$.fragment,l),y(Z.$$.fragment,l),y(E.$$.fragment,l),y(N.$$.fragment,l),y(V.$$.fragment,l),y(Y.$$.fragment,l),y(S.$$.fragment,l),y(v.$$.fragment,l),y(k.$$.fragment,l),y(X.$$.fragment,l),y($.$$.fragment,l),y(H.$$.fragment,l),y(L.$$.fragment,l),y(O.$$.fragment,l),y(sl.$$.fragment,l),y(el.$$.fragment,l),y(il.$$.fragment,l),y(jl.$$.fragment,l),y(ml.$$.fragment,l),y(Tl.$$.fragment,l),y(dl.$$.fragment,l),As=!1},d(l){l&&(a(gl),a(bl),a(Bl),a(fl),a(d),a(Wl),a(I),a(Al),a(h),a(Zl),a(T),a(El),a(C),a(Gl),a(g),a(Nl),a(ql),a(f),a(Vl),a(Ql),a(A),a(Yl),a(Sl),a(zl),a(G),a(vl),a(Rl),a(q),a(kl),a(Fl),a(Q),a(Xl),a(_l),a($l),a(z),a(xl),a(Hl),a(R),a(Ll),a(Dl),a(F),a(Pl),a(Kl),a(_),a(Ol),a(ls),a(x),a(ss),a(as),a(es),a(D),a(ts),a(P),a(ns),a(K),a(Ms),a(os),a(ll),a(ps),a(is),a(al),a(cs),a(rs),a(tl),a(js),a(nl),a(ys),a(Ml),a(Js),a(ol),a(Us),a(pl),a(ms),a(us),a(cl),a(Ts),a(rl),a(ws),a(ds),a(yl),a(Is),a(Jl),a(hs),a(Ul),a(bs),a(Cs),a(ul),a(gs),a(Bs),a(wl),a(fs),a(Ws),a(Cl)),a(u),J(w,l),J(b),J(B,l),J(W,l),J(Z,l),J(E,l),J(N,l),J(V,l),J(Y,l),J(S,l),J(v,l),J(k,l),J(X,l),J($,l),J(H,l),J(L,l),J(O,l),J(sl,l),J(el,l),J(il,l),J(jl,l),J(ml,l),J(Tl,l),J(dl,l)}}}const ba='{"title":"Construyendo Tu Primer LangGraph","local":"construyendo-tu-primer-langgraph","sections":[{"title":"Nuestro Flujo de Trabajo","local":"nuestro-flujo-de-trabajo","sections":[],"depth":2},{"title":"Configurando Nuestro Entorno","local":"configurando-nuestro-entorno","sections":[],"depth":2},{"title":"Paso 1: Definir Nuestro Estado","local":"paso-1-definir-nuestro-estado","sections":[],"depth":2},{"title":"Paso 2: Definir Nuestros Nodos","local":"paso-2-definir-nuestros-nodos","sections":[],"depth":2},{"title":"Paso 3: Definir Nuestra Lógica de Enrutamiento","local":"paso-3-definir-nuestra-lógica-de-enrutamiento","sections":[],"depth":2},{"title":"Paso 4: Crear el StateGraph y Definir Aristas(Edges)","local":"paso-4-crear-el-stategraph-y-definir-aristasedges","sections":[],"depth":2},{"title":"Paso 5: Ejecutar la Aplicación","local":"paso-5-ejecutar-la-aplicación","sections":[],"depth":2},{"title":"Paso 6: Inspeccionando Nuestro Agente de Clasificación de Correo con Langfuse 📡","local":"paso-6-inspeccionando-nuestro-agente-de-clasificación-de-correo-con-langfuse-","sections":[],"depth":2},{"title":"Lo Que Hemos Construido","local":"lo-que-hemos-construido","sections":[],"depth":2},{"title":"Puntos Clave","local":"puntos-clave","sections":[],"depth":2},{"title":"¿Qué Sigue?","local":"qué-sigue","sections":[],"depth":2}],"depth":1}';function Ca(qs){return ua(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Za extends Ta{constructor(u){super(),wa(this,u,Ca,ha,Ua,{})}}export{Za as component};
