import{s as Dl,f as Ll,o as Pl,n as N}from"../chunks/scheduler.37c15a92.js";import{S as Kl,i as Ol,g as J,s as c,r as f,A as es,h as y,f as s,c as d,j as yl,u as I,x as T,k as W,y as ls,a,v as g,d as Z,t as C,w as v}from"../chunks/index.2bf4358c.js";import{C as E}from"../chunks/CodeBlock.4e987730.js";import{H as V}from"../chunks/Heading.8ada512a.js";import{H as Tl,a as Y}from"../chunks/HfOption.02c8e375.js";import{E as ss}from"../chunks/getInferenceSnippets.0aa3753f.js";function as(B){let o,U="Usaremos la librería <code>datasets</code> de Hugging Face para cargar el conjunto de datos y convertirlo en una lista de objetos <code>Document</code> del módulo <code>langchain.docstore.document</code>.",p,u,m;return u=new E({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFmcm9tJTIwbGFuZ2NoYWluX2NvcmUuZG9jdW1lbnRzJTIwaW1wb3J0JTIwRG9jdW1lbnQlMEElMEElMjMlMjBDYXJnYXIlMjBlbCUyMGNvbmp1bnRvJTIwZGUlMjBkYXRvcyUwQWd1ZXN0X2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0cy5sb2FkX2RhdGFzZXQoJTIyYWdlbnRzLWNvdXJzZSUyRnVuaXQzLWludml0ZWVzJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEElMEElMjMlMjBDb252ZXJ0aXIlMjBlbnRyYWRhcyUyMGRlbCUyMGNvbmp1bnRvJTIwZGUlMjBkYXRvcyUyMGVuJTIwb2JqZXRvcyUyMERvY3VtZW50JTBBZG9jcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMERvY3VtZW50KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhZ2VfY29udGVudCUzRCUyMiU1Q24lMjIuam9pbiglNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyTmFtZSUzQSUyMCU3Qmd1ZXN0JTVCJ25hbWUnJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMlJlbGF0aW9uJTNBJTIwJTdCZ3Vlc3QlNUIncmVsYXRpb24nJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkRlc2NyaXB0aW9uJTNBJTIwJTdCZ3Vlc3QlNUInZGVzY3JpcHRpb24nJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkVtYWlsJTNBJTIwJTdCZ3Vlc3QlNUInZW1haWwnJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldGFkYXRhJTNEJTdCJTIybmFtZSUyMiUzQSUyMGd1ZXN0JTVCJTIybmFtZSUyMiU1RCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBmb3IlMjBndWVzdCUyMGluJTIwZ3Vlc3RfZGF0YXNldCUwQSU1RCUwQQ==",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> langchain_core.documents <span class="hljs-keyword">import</span> Document

<span class="hljs-comment"># Cargar el conjunto de datos</span>
guest_dataset = datasets.load_dataset(<span class="hljs-string">&quot;agents-course/unit3-invitees&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-comment"># Convertir entradas del conjunto de datos en objetos Document</span>
docs = [
    Document(
        page_content=<span class="hljs-string">&quot;\\n&quot;</span>.join([
            <span class="hljs-string">f&quot;Name: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;name&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Relation: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;relation&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Description: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;description&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Email: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;email&#x27;</span>]}</span>&quot;</span>
        ]),
        metadata={<span class="hljs-string">&quot;name&quot;</span>: guest[<span class="hljs-string">&quot;name&quot;</span>]}
    )
    <span class="hljs-keyword">for</span> guest <span class="hljs-keyword">in</span> guest_dataset
]
`,wrap:!1}}),{c(){o=J("p"),o.innerHTML=U,p=c(),f(u.$$.fragment)},l(i){o=y(i,"P",{"data-svelte-h":!0}),T(o)!=="svelte-wywv5g"&&(o.innerHTML=U),p=d(i),I(u.$$.fragment,i)},m(i,l){a(i,o,l),a(i,p,l),g(u,i,l),m=!0},p:N,i(i){m||(Z(u.$$.fragment,i),m=!0)},o(i){C(u.$$.fragment,i),m=!1},d(i){i&&(s(o),s(p)),v(u,i)}}}function ts(B){let o,U="Usaremos la librería <code>datasets</code> de Hugging Face para cargar el conjunto de datos y convertirlo en una lista de objetos <code>Document</code> del módulo <code>llama_index.core.schema</code>.",p,u,m;return u=new E({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFmcm9tJTIwbGxhbWFfaW5kZXguY29yZS5zY2hlbWElMjBpbXBvcnQlMjBEb2N1bWVudCUwQSUwQSUyMyUyMENhcmdhciUyMGVsJTIwY29uanVudG8lMjBkZSUyMGRhdG9zJTBBZ3Vlc3RfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJhZ2VudHMtY291cnNlJTJGdW5pdDMtaW52aXRlZXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQSUyMyUyMENvbnZlcnRpciUyMGVudHJhZGFzJTIwZGVsJTIwY29uanVudG8lMjBkZSUyMGRhdG9zJTIwZW4lMjBvYmpldG9zJTIwRG9jdW1lbnQlMEFkb2NzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwRG9jdW1lbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dCUzRCUyMiU1Q24lMjIuam9pbiglNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyTmFtZSUzQSUyMCU3Qmd1ZXN0X2RhdGFzZXQlNUInbmFtZSclNUQlNUJpJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMlJlbGF0aW9uJTNBJTIwJTdCZ3Vlc3RfZGF0YXNldCU1QidyZWxhdGlvbiclNUQlNUJpJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkRlc2NyaXB0aW9uJTNBJTIwJTdCZ3Vlc3RfZGF0YXNldCU1QidkZXNjcmlwdGlvbiclNUQlNUJpJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkVtYWlsJTNBJTIwJTdCZ3Vlc3RfZGF0YXNldCU1QidlbWFpbCclNUQlNUJpJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldGFkYXRhJTNEJTdCJTIybmFtZSUyMiUzQSUyMGd1ZXN0X2RhdGFzZXQlNUInbmFtZSclNUQlNUJpJTVEJTdEJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihndWVzdF9kYXRhc2V0KSklMEElNUQ=",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> llama_index.core.schema <span class="hljs-keyword">import</span> Document

<span class="hljs-comment"># Cargar el conjunto de datos</span>
guest_dataset = datasets.load_dataset(<span class="hljs-string">&quot;agents-course/unit3-invitees&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-comment"># Convertir entradas del conjunto de datos en objetos Document</span>
docs = [
    Document(
        text=<span class="hljs-string">&quot;\\n&quot;</span>.join([
            <span class="hljs-string">f&quot;Name: <span class="hljs-subst">{guest_dataset[<span class="hljs-string">&#x27;name&#x27;</span>][i]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Relation: <span class="hljs-subst">{guest_dataset[<span class="hljs-string">&#x27;relation&#x27;</span>][i]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Description: <span class="hljs-subst">{guest_dataset[<span class="hljs-string">&#x27;description&#x27;</span>][i]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Email: <span class="hljs-subst">{guest_dataset[<span class="hljs-string">&#x27;email&#x27;</span>][i]}</span>&quot;</span>
        ]),
        metadata={<span class="hljs-string">&quot;name&quot;</span>: guest_dataset[<span class="hljs-string">&#x27;name&#x27;</span>][i]}
    )
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(guest_dataset))
]`,wrap:!1}}),{c(){o=J("p"),o.innerHTML=U,p=c(),f(u.$$.fragment)},l(i){o=y(i,"P",{"data-svelte-h":!0}),T(o)!=="svelte-eraujj"&&(o.innerHTML=U),p=d(i),I(u.$$.fragment,i)},m(i,l){a(i,o,l),a(i,p,l),g(u,i,l),m=!0},p:N,i(i){m||(Z(u.$$.fragment,i),m=!0)},o(i){C(u.$$.fragment,i),m=!1},d(i){i&&(s(o),s(p)),v(u,i)}}}function ns(B){let o,U="Usaremos la librería <code>datasets</code> de Hugging Face para cargar el conjunto de datos y convertirlo en una lista de objetos <code>Document</code> del módulo <code>langchain.docstore.document</code>.",p,u,m;return u=new E({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFmcm9tJTIwbGFuZ2NoYWluX2NvcmUuZG9jdW1lbnRzJTIwaW1wb3J0JTIwRG9jdW1lbnQlMEElMEElMjMlMjBDYXJnYXIlMjBlbCUyMGNvbmp1bnRvJTIwZGUlMjBkYXRvcyUwQWd1ZXN0X2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0cy5sb2FkX2RhdGFzZXQoJTIyYWdlbnRzLWNvdXJzZSUyRnVuaXQzLWludml0ZWVzJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEElMEElMjMlMjBDb252ZXJ0aXIlMjBlbnRyYWRhcyUyMGRlbCUyMGNvbmp1bnRvJTIwZGUlMjBkYXRvcyUyMGVuJTIwb2JqZXRvcyUyMERvY3VtZW50JTBBZG9jcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMERvY3VtZW50KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhZ2VfY29udGVudCUzRCUyMiU1Q24lMjIuam9pbiglNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyTmFtZSUzQSUyMCU3Qmd1ZXN0JTVCJ25hbWUnJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMlJlbGF0aW9uJTNBJTIwJTdCZ3Vlc3QlNUIncmVsYXRpb24nJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkRlc2NyaXB0aW9uJTNBJTIwJTdCZ3Vlc3QlNUInZGVzY3JpcHRpb24nJTVEJTdEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkVtYWlsJTNBJTIwJTdCZ3Vlc3QlNUInZW1haWwnJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldGFkYXRhJTNEJTdCJTIybmFtZSUyMiUzQSUyMGd1ZXN0JTVCJTIybmFtZSUyMiU1RCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBmb3IlMjBndWVzdCUyMGluJTIwZ3Vlc3RfZGF0YXNldCUwQSU1RA==",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> langchain_core.documents <span class="hljs-keyword">import</span> Document

<span class="hljs-comment"># Cargar el conjunto de datos</span>
guest_dataset = datasets.load_dataset(<span class="hljs-string">&quot;agents-course/unit3-invitees&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-comment"># Convertir entradas del conjunto de datos en objetos Document</span>
docs = [
    Document(
        page_content=<span class="hljs-string">&quot;\\n&quot;</span>.join([
            <span class="hljs-string">f&quot;Name: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;name&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Relation: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;relation&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Description: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;description&#x27;</span>]}</span>&quot;</span>,
            <span class="hljs-string">f&quot;Email: <span class="hljs-subst">{guest[<span class="hljs-string">&#x27;email&#x27;</span>]}</span>&quot;</span>
        ]),
        metadata={<span class="hljs-string">&quot;name&quot;</span>: guest[<span class="hljs-string">&quot;name&quot;</span>]}
    )
    <span class="hljs-keyword">for</span> guest <span class="hljs-keyword">in</span> guest_dataset
]`,wrap:!1}}),{c(){o=J("p"),o.innerHTML=U,p=c(),f(u.$$.fragment)},l(i){o=y(i,"P",{"data-svelte-h":!0}),T(o)!=="svelte-wywv5g"&&(o.innerHTML=U),p=d(i),I(u.$$.fragment,i)},m(i,l){a(i,o,l),a(i,p,l),g(u,i,l),m=!0},p:N,i(i){m||(Z(u.$$.fragment,i),m=!0)},o(i){C(u.$$.fragment,i),m=!1},d(i){i&&(s(o),s(p)),v(u,i)}}}function os(B){let o,U,p,u,m,i;return o=new Y({props:{id:"agents-frameworks",option:"smolagents",$$slots:{default:[as]},$$scope:{ctx:B}}}),p=new Y({props:{id:"agents-frameworks",option:"llama-index",$$slots:{default:[ts]},$$scope:{ctx:B}}}),m=new Y({props:{id:"agents-frameworks",option:"langgraph",$$slots:{default:[ns]},$$scope:{ctx:B}}}),{c(){f(o.$$.fragment),U=c(),f(p.$$.fragment),u=c(),f(m.$$.fragment)},l(l){I(o.$$.fragment,l),U=d(l),I(p.$$.fragment,l),u=d(l),I(m.$$.fragment,l)},m(l,M){g(o,l,M),a(l,U,M),g(p,l,M),a(l,u,M),g(m,l,M),i=!0},p(l,M){const w={};M&2&&(w.$$scope={dirty:M,ctx:l}),o.$set(w);const b={};M&2&&(b.$$scope={dirty:M,ctx:l}),p.$set(b);const j={};M&2&&(j.$$scope={dirty:M,ctx:l}),m.$set(j)},i(l){i||(Z(o.$$.fragment,l),Z(p.$$.fragment,l),Z(m.$$.fragment,l),i=!0)},o(l){C(o.$$.fragment,l),C(p.$$.fragment,l),C(m.$$.fragment,l),i=!1},d(l){l&&(s(U),s(u)),v(o,l),v(p,l),v(m,l)}}}function rs(B){let o,U="Usaremos el <code>BM25Retriever</code> del módulo <code>langchain_community.retrievers</code> para crear una herramienta de recuperación.",p,u,m='<p>El <code>BM25Retriever</code> es un gran punto de partida para la recuperación, pero para búsquedas semánticas más avanzadas, podrías considerar usar recuperadores basados en embeddings como los de <a href="https://www.sbert.net/">sentence-transformers</a>.</p>',i,l,M,w,b="Entendamos esta herramienta paso a paso:",j,h,$="<li>El <code>name</code> y la <code>description</code> ayudan al agente a entender cuándo y cómo usar esta herramienta</li> <li>Los <code>inputs</code> definen qué parámetros espera la herramienta (en este caso, una consulta de búsqueda)</li> <li>Estamos usando un <code>BM25Retriever</code>, que es un algoritmo poderoso de recuperación de texto que no requiere embeddings</li> <li>El método <code>forward</code> procesa la consulta y devuelve la información más relevante del invitado</li>",n;return l=new E({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever

<span class="hljs-keyword">class</span> <span class="hljs-title class_">GuestInfoRetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;guest_info_retriever&quot;</span>
    description = <span class="hljs-string">&quot;Recupera información detallada sobre los invitados de la gala basada en su nombre o relación.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;El nombre o relación del invitado sobre el que deseas información.&quot;</span>
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, docs</span>):
        self.is_initialized = <span class="hljs-literal">False</span>
        self.retriever = BM25Retriever.from_documents(docs)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>):
        results = self.retriever.get_relevant_documents(query)
        <span class="hljs-keyword">if</span> results:
            <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> results[:<span class="hljs-number">3</span>]])
        <span class="hljs-keyword">else</span>:
            <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;No se encontró información que coincida con la búsqueda.&quot;</span>

<span class="hljs-comment"># Inicializar la herramienta</span>
guest_info_tool = GuestInfoRetrieverTool(docs)`,wrap:!1}}),{c(){o=J("p"),o.innerHTML=U,p=c(),u=J("blockquote"),u.innerHTML=m,i=c(),f(l.$$.fragment),M=c(),w=J("p"),w.textContent=b,j=c(),h=J("ul"),h.innerHTML=$,this.h()},l(t){o=y(t,"P",{"data-svelte-h":!0}),T(o)!=="svelte-hx2hs9"&&(o.innerHTML=U),p=d(t),u=y(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(u)!=="svelte-kq5ex6"&&(u.innerHTML=m),i=d(t),I(l.$$.fragment,t),M=d(t),w=y(t,"P",{"data-svelte-h":!0}),T(w)!=="svelte-37tmzc"&&(w.textContent=b),j=d(t),h=y(t,"UL",{"data-svelte-h":!0}),T(h)!=="svelte-16u92h7"&&(h.innerHTML=$),this.h()},h(){W(u,"class","tip")},m(t,G){a(t,o,G),a(t,p,G),a(t,u,G),a(t,i,G),g(l,t,G),a(t,M,G),a(t,w,G),a(t,j,G),a(t,h,G),n=!0},p:N,i(t){n||(Z(l.$$.fragment,t),n=!0)},o(t){C(l.$$.fragment,t),n=!1},d(t){t&&(s(o),s(p),s(u),s(i),s(M),s(w),s(j),s(h)),v(l,t)}}}function is(B){let o,U="Usaremos el <code>BM25Retriever</code> del módulo <code>llama_index.retrievers.bm25</code> para crear una herramienta de recuperación.",p,u,m='<p>El <code>BM25Retriever</code> es un gran punto de partida para la recuperación, pero para búsquedas semánticas más avanzadas, podrías considerar usar recuperadores basados en embeddings como los de <a href="https://www.sbert.net/">sentence-transformers</a>.</p>',i,l,M,w,b="Entendamos esta herramienta paso a paso:",j,h,$="<li>El docstring ayuda al agente a entender cuándo y cómo usar esta herramienta</li> <li>Los decoradores de tipo definen qué parámetros espera la herramienta (en este caso, una consulta de búsqueda)</li> <li>Estamos usando un <code>BM25Retriever</code>, que es un algoritmo poderoso de recuperación de texto que no requiere embeddings</li> <li>El método procesa la consulta y devuelve la información más relevante del invitado</li>",n;return l=new E({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUudG9vbHMlMjBpbXBvcnQlMjBGdW5jdGlvblRvb2wlMEFmcm9tJTIwbGxhbWFfaW5kZXgucmV0cmlldmVycy5ibTI1JTIwaW1wb3J0JTIwQk0yNVJldHJpZXZlciUwQSUwQWJtMjVfcmV0cmlldmVyJTIwJTNEJTIwQk0yNVJldHJpZXZlci5mcm9tX2RlZmF1bHRzKG5vZGVzJTNEZG9jcyklMEElMEFkZWYlMjBnZXRfZ3Vlc3RfaW5mb19yZXRyaWV2ZXIocXVlcnklM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMlJlY3VwZXJhJTIwaW5mb3JtYWNpJUMzJUIzbiUyMGRldGFsbGFkYSUyMHNvYnJlJTIwbG9zJTIwaW52aXRhZG9zJTIwZGUlMjBsYSUyMGdhbGElMjBiYXNhZGElMjBlbiUyMHN1JTIwbm9tYnJlJTIwbyUyMHJlbGFjaSVDMyVCM24uJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmVzdWx0cyUyMCUzRCUyMGJtMjVfcmV0cmlldmVyLnJldHJpZXZlKHF1ZXJ5KSUwQSUyMCUyMCUyMCUyMGlmJTIwcmVzdWx0cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMiU1Q24lNUNuJTIyLmpvaW4oJTVCZG9jLnRleHQlMjBmb3IlMjBkb2MlMjBpbiUyMHJlc3VsdHMlNUIlM0EzJTVEJTVEKSUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlMjJObyUyMHNlJTIwZW5jb250ciVDMyVCMyUyMGluZm9ybWFjaSVDMyVCM24lMjBxdWUlMjBjb2luY2lkYSUyMGNvbiUyMGxhJTIwYiVDMyVCQXNxdWVkYS4lMjIlMEElMEElMjMlMjBJbmljaWFsaXphciUyMGxhJTIwaGVycmFtaWVudGElMEFndWVzdF9pbmZvX3Rvb2wlMjAlM0QlMjBGdW5jdGlvblRvb2wuZnJvbV9kZWZhdWx0cyhnZXRfZ3Vlc3RfaW5mb19yZXRyaWV2ZXIp",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.tools <span class="hljs-keyword">import</span> FunctionTool
<span class="hljs-keyword">from</span> llama_index.retrievers.bm25 <span class="hljs-keyword">import</span> BM25Retriever

bm25_retriever = BM25Retriever.from_defaults(nodes=docs)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_guest_info_retriever</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Recupera información detallada sobre los invitados de la gala basada en su nombre o relación.&quot;&quot;&quot;</span>
    results = bm25_retriever.retrieve(query)
    <span class="hljs-keyword">if</span> results:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([doc.text <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> results[:<span class="hljs-number">3</span>]])
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;No se encontró información que coincida con la búsqueda.&quot;</span>

<span class="hljs-comment"># Inicializar la herramienta</span>
guest_info_tool = FunctionTool.from_defaults(get_guest_info_retriever)`,wrap:!1}}),{c(){o=J("p"),o.innerHTML=U,p=c(),u=J("blockquote"),u.innerHTML=m,i=c(),f(l.$$.fragment),M=c(),w=J("p"),w.textContent=b,j=c(),h=J("ul"),h.innerHTML=$,this.h()},l(t){o=y(t,"P",{"data-svelte-h":!0}),T(o)!=="svelte-tu9tca"&&(o.innerHTML=U),p=d(t),u=y(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(u)!=="svelte-kq5ex6"&&(u.innerHTML=m),i=d(t),I(l.$$.fragment,t),M=d(t),w=y(t,"P",{"data-svelte-h":!0}),T(w)!=="svelte-37tmzc"&&(w.textContent=b),j=d(t),h=y(t,"UL",{"data-svelte-h":!0}),T(h)!=="svelte-16og6op"&&(h.innerHTML=$),this.h()},h(){W(u,"class","tip")},m(t,G){a(t,o,G),a(t,p,G),a(t,u,G),a(t,i,G),g(l,t,G),a(t,M,G),a(t,w,G),a(t,j,G),a(t,h,G),n=!0},p:N,i(t){n||(Z(l.$$.fragment,t),n=!0)},o(t){C(l.$$.fragment,t),n=!1},d(t){t&&(s(o),s(p),s(u),s(i),s(M),s(w),s(j),s(h)),v(l,t)}}}function ps(B){let o,U="Usaremos el <code>BM25Retriever</code> del módulo <code>langchain_community.retrievers</code> para crear una herramienta de recuperación.",p,u,m='<p>El <code>BM25Retriever</code> es un gran punto de partida para la recuperación, pero para búsquedas semánticas más avanzadas, podrías considerar usar recuperadores basados en embeddings como los de <a href="https://www.sbert.net/">sentence-transformers</a>.</p>',i,l,M,w,b="Entendamos esta herramienta paso a paso:",j,h,$="<li>El <code>name</code> y la <code>description</code> ayudan al agente a entender cuándo y cómo usar esta herramienta</li> <li>Los decoradores de tipo definen qué parámetros espera la herramienta (en este caso, una consulta de búsqueda)</li> <li>Estamos usando un <code>BM25Retriever</code>, que es un potente algoritmo de recuperación de texto que no requiere embeddings</li> <li>El método procesa la consulta y devuelve la información más relevante del invitado</li>",n;return l=new E({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkucmV0cmlldmVycyUyMGltcG9ydCUyMEJNMjVSZXRyaWV2ZXIlMEFmcm9tJTIwbGFuZ2NoYWluLnRvb2xzJTIwaW1wb3J0JTIwVG9vbCUwQSUwQWJtMjVfcmV0cmlldmVyJTIwJTNEJTIwQk0yNVJldHJpZXZlci5mcm9tX2RvY3VtZW50cyhkb2NzKSUwQSUwQWRlZiUyMGV4dHJhY3RfdGV4dChxdWVyeSUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyUmVjdXBlcmElMjBpbmZvcm1hY2klQzMlQjNuJTIwZGV0YWxsYWRhJTIwc29icmUlMjBsb3MlMjBpbnZpdGFkb3MlMjBkZSUyMGxhJTIwZ2FsYSUyMGJhc2FkYSUyMGVuJTIwc3UlMjBub21icmUlMjBvJTIwcmVsYWNpJUMzJUIzbi4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXN1bHRzJTIwJTNEJTIwYm0yNV9yZXRyaWV2ZXIuaW52b2tlKHF1ZXJ5KSUwQSUyMCUyMCUyMCUyMGlmJTIwcmVzdWx0cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMiU1Q24lNUNuJTIyLmpvaW4oJTVCZG9jLnRleHQlMjBmb3IlMjBkb2MlMjBpbiUyMHJlc3VsdHMlNUIlM0EzJTVEJTVEKSUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlMjJObyUyMHNlJTIwZW5jb250ciVDMyVCMyUyMGluZm9ybWFjaSVDMyVCM24lMjBxdWUlMjBjb2luY2lkYSUyMGNvbiUyMGxhJTIwYiVDMyVCQXNxdWVkYS4lMjIlMEElMEFndWVzdF9pbmZvX3Rvb2wlMjAlM0QlMjBUb29sKCUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJndWVzdF9pbmZvX3JldHJpZXZlciUyMiUyQyUwQSUyMCUyMCUyMCUyMGZ1bmMlM0RleHRyYWN0X3RleHQlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlJlY3VwZXJhJTIwaW5mb3JtYWNpJUMzJUIzbiUyMGRldGFsbGFkYSUyMHNvYnJlJTIwbG9zJTIwaW52aXRhZG9zJTIwZGUlMjBsYSUyMGdhbGElMjBiYXNhZGElMjBlbiUyMHN1JTIwbm9tYnJlJTIwbyUyMHJlbGFjaSVDMyVCM24uJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever
<span class="hljs-keyword">from</span> langchain.tools <span class="hljs-keyword">import</span> Tool

bm25_retriever = BM25Retriever.from_documents(docs)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_text</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Recupera información detallada sobre los invitados de la gala basada en su nombre o relación.&quot;&quot;&quot;</span>
    results = bm25_retriever.invoke(query)
    <span class="hljs-keyword">if</span> results:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([doc.text <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> results[:<span class="hljs-number">3</span>]])
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;No se encontró información que coincida con la búsqueda.&quot;</span>

guest_info_tool = Tool(
    name=<span class="hljs-string">&quot;guest_info_retriever&quot;</span>,
    func=extract_text,
    description=<span class="hljs-string">&quot;Recupera información detallada sobre los invitados de la gala basada en su nombre o relación.&quot;</span>
)`,wrap:!1}}),{c(){o=J("p"),o.innerHTML=U,p=c(),u=J("blockquote"),u.innerHTML=m,i=c(),f(l.$$.fragment),M=c(),w=J("p"),w.textContent=b,j=c(),h=J("ul"),h.innerHTML=$,this.h()},l(t){o=y(t,"P",{"data-svelte-h":!0}),T(o)!=="svelte-hx2hs9"&&(o.innerHTML=U),p=d(t),u=y(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(u)!=="svelte-kq5ex6"&&(u.innerHTML=m),i=d(t),I(l.$$.fragment,t),M=d(t),w=y(t,"P",{"data-svelte-h":!0}),T(w)!=="svelte-37tmzc"&&(w.textContent=b),j=d(t),h=y(t,"UL",{"data-svelte-h":!0}),T(h)!=="svelte-1jczerd"&&(h.innerHTML=$),this.h()},h(){W(u,"class","tip")},m(t,G){a(t,o,G),a(t,p,G),a(t,u,G),a(t,i,G),g(l,t,G),a(t,M,G),a(t,w,G),a(t,j,G),a(t,h,G),n=!0},p:N,i(t){n||(Z(l.$$.fragment,t),n=!0)},o(t){C(l.$$.fragment,t),n=!1},d(t){t&&(s(o),s(p),s(u),s(i),s(M),s(w),s(j),s(h)),v(l,t)}}}function cs(B){let o,U,p,u,m,i;return o=new Y({props:{id:"agents-frameworks",option:"smolagents",$$slots:{default:[rs]},$$scope:{ctx:B}}}),p=new Y({props:{id:"agents-frameworks",option:"llama-index",$$slots:{default:[is]},$$scope:{ctx:B}}}),m=new Y({props:{id:"agents-frameworks",option:"langgraph",$$slots:{default:[ps]},$$scope:{ctx:B}}}),{c(){f(o.$$.fragment),U=c(),f(p.$$.fragment),u=c(),f(m.$$.fragment)},l(l){I(o.$$.fragment,l),U=d(l),I(p.$$.fragment,l),u=d(l),I(m.$$.fragment,l)},m(l,M){g(o,l,M),a(l,U,M),g(p,l,M),a(l,u,M),g(m,l,M),i=!0},p(l,M){const w={};M&2&&(w.$$scope={dirty:M,ctx:l}),o.$set(w);const b={};M&2&&(b.$$scope={dirty:M,ctx:l}),p.$set(b);const j={};M&2&&(j.$$scope={dirty:M,ctx:l}),m.$set(j)},i(l){i||(Z(o.$$.fragment,l),Z(p.$$.fragment,l),Z(m.$$.fragment,l),i=!0)},o(l){C(o.$$.fragment,l),C(p.$$.fragment,l),C(m.$$.fragment,l),i=!1},d(l){l&&(s(U),s(u)),v(o,l),v(p,l),v(m,l)}}}function ds(B){let o,U,p,u="Salida esperada:",m,i,l,M,w="Lo que está sucediendo en este paso final:",b,j,h="<li>Inicializamos un modelo de Hugging Face usando la clase <code>InferenceClientModel</code></li> <li>Creamos nuestro agente (Alfred) como un <code>CodeAgent</code>, que puede ejecutar código Python para resolver problemas</li> <li>Le pedimos a Alfred que recupere información sobre una invitada llamada “Lady Ada Lovelace”</li>",$;return o=new E({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQSUyMyUyMEluaWNpYWxpemFyJTIwZWwlMjBtb2RlbG8lMjBkZSUyMEh1Z2dpbmclMjBGYWNlJTBBbW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBJTBBJTIzJTIwQ3JlYXIlMjBBbGZyZWQlMkMlMjBudWVzdHJvJTIwYWdlbnRlJTIwZGUlMjBnYWxhJTJDJTIwY29uJTIwbGElMjBoZXJyYW1pZW50YSUyMGRlJTIwaW5mb3JtYWNpJUMzJUIzbiUyMGRlJTIwaW52aXRhZG9zJTBBYWxmcmVkJTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCZ3Vlc3RfaW5mb190b29sJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCklMEElMEElMjMlMjBFamVtcGxvJTIwZGUlMjBjb25zdWx0YSUyMHF1ZSUyMEFsZnJlZCUyMHBvZHIlQzMlQURhJTIwcmVjaWJpciUyMGR1cmFudGUlMjBsYSUyMGdhbGElMEFyZXNwb25zZSUyMCUzRCUyMGFsZnJlZC5ydW4oJTIyQ3UlQzMlQTludGFtZSUyMHNvYnJlJTIwbnVlc3RyYSUyMGludml0YWRhJTIwbGxhbWFkYSUyMCdMYWR5JTIwQWRhJTIwTG92ZWxhY2UnLiUyMiklMEElMEFwcmludCglMjIlRjAlOUYlOEUlQTklMjBSZXNwdWVzdGElMjBkZSUyMEFsZnJlZCUzQSUyMiklMEFwcmludChyZXNwb25zZSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

<span class="hljs-comment"># Inicializar el modelo de Hugging Face</span>
model = InferenceClientModel()

<span class="hljs-comment"># Crear Alfred, nuestro agente de gala, con la herramienta de información de invitados</span>
alfred = CodeAgent(tools=[guest_info_tool], model=model)

<span class="hljs-comment"># Ejemplo de consulta que Alfred podría recibir durante la gala</span>
response = alfred.run(<span class="hljs-string">&quot;Cuéntame sobre nuestra invitada llamada &#x27;Lady Ada Lovelace&#x27;.&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🎩 Respuesta de Alfred:&quot;</span>)
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),i=new E({props:{code:"JUYwJTlGJThFJUE5JTIwUmVzcHVlc3RhJTIwZGUlMjBBbGZyZWQlM0ElMEFCYXNhZG8lMjBlbiUyMGxhJTIwaW5mb3JtYWNpJUMzJUIzbiUyMHF1ZSUyMHJlY3VwZXIlQzMlQTklMkMlMjBMYWR5JTIwQWRhJTIwTG92ZWxhY2UlMjBlcyUyMHVuYSUyMGVzdGltYWRhJTIwbWF0ZW0lQzMlQTF0aWNhJTIweSUyMGFtaWdhLiUyMEVzJTIwcmVjb25vY2lkYSUyMHBvciUyMHN1JTIwdHJhYmFqbyUyMHBpb25lcm8lMjBlbiUyMG1hdGVtJUMzJUExdGljYXMlMjBlJTIwaW5mb3JtJUMzJUExdGljYSUyQyUyMGElMjBtZW51ZG8lMjBjZWxlYnJhZGElMjBjb21vJTIwbGElMjBwcmltZXJhJTIwcHJvZ3JhbWFkb3JhJTIwZGUlMjBjb21wdXRhZG9yYXMlMjBkZWJpZG8lMjBhJTIwc3UlMjB0cmFiYWpvJTIwZW4lMjBsYSUyME0lQzMlQTFxdWluYSUyMEFuYWwlQzMlQUR0aWNhJTIwZGUlMjBDaGFybGVzJTIwQmFiYmFnZS4lMjBTdSUyMGRpcmVjY2klQzMlQjNuJTIwZGUlMjBjb3JyZW8lMjBlbGVjdHIlQzMlQjNuaWNvJTIwZXMlMjBhZGEubG92ZWxhY2UlNDBleGFtcGxlLmNvbS4=",highlighted:`🎩 Respuesta <span class="hljs-keyword">de</span> Alfred:
Basado <span class="hljs-keyword">en</span> <span class="hljs-keyword">la</span> informació<span class="hljs-keyword">n</span> <span class="hljs-keyword">que</span> recuperé, Lady Ada Lovelace es una estimada matemática y amiga. Es reconocida por <span class="hljs-keyword">su</span> trabajo pionero <span class="hljs-keyword">en</span> matemáticas <span class="hljs-keyword">e</span> informática, a menudo celebrada como <span class="hljs-keyword">la</span> primera programadora <span class="hljs-keyword">de</span> computadoras debido a <span class="hljs-keyword">su</span> trabajo <span class="hljs-keyword">en</span> <span class="hljs-keyword">la</span> <span class="hljs-keyword">M</span>áquina Analítica <span class="hljs-keyword">de</span> Charles Babbage. <span class="hljs-keyword">Su</span> direcció<span class="hljs-keyword">n</span> <span class="hljs-keyword">de</span> correo electrónico es ada.lovelace@example.com.`,wrap:!1}}),{c(){f(o.$$.fragment),U=c(),p=J("p"),p.textContent=u,m=c(),f(i.$$.fragment),l=c(),M=J("p"),M.textContent=w,b=c(),j=J("ul"),j.innerHTML=h},l(n){I(o.$$.fragment,n),U=d(n),p=y(n,"P",{"data-svelte-h":!0}),T(p)!=="svelte-wjimjn"&&(p.textContent=u),m=d(n),I(i.$$.fragment,n),l=d(n),M=y(n,"P",{"data-svelte-h":!0}),T(M)!=="svelte-143o5dl"&&(M.textContent=w),b=d(n),j=y(n,"UL",{"data-svelte-h":!0}),T(j)!=="svelte-ks8pur"&&(j.innerHTML=h)},m(n,t){g(o,n,t),a(n,U,t),a(n,p,t),a(n,m,t),g(i,n,t),a(n,l,t),a(n,M,t),a(n,b,t),a(n,j,t),$=!0},p:N,i(n){$||(Z(o.$$.fragment,n),Z(i.$$.fragment,n),$=!0)},o(n){C(o.$$.fragment,n),C(i.$$.fragment,n),$=!1},d(n){n&&(s(U),s(p),s(m),s(l),s(M),s(b),s(j)),v(o,n),v(i,n)}}}function Ms(B){let o,U,p,u="Salida esperada:",m,i,l,M,w="Lo que está sucediendo en este paso final:",b,j,h="<li>Inicializamos un modelo de Hugging Face usando la clase <code>HuggingFaceInferenceAPI</code></li> <li>Creamos nuestro agente (Alfred) como un <code>AgentWorkflow</code>, incluyendo la herramienta que acabamos de crear</li> <li>Le pedimos a Alfred que recupere información sobre una invitada llamada “Lady Ada Lovelace”</li>",$;return o=new E({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUuYWdlbnQud29ya2Zsb3clMjBpbXBvcnQlMjBBZ2VudFdvcmtmbG93JTBBZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMuaHVnZ2luZ2ZhY2VfYXBpJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUEklMEElMEElMjMlMjBJbmljaWFsaXphciUyMGVsJTIwbW9kZWxvJTIwZGUlMjBIdWdnaW5nJTIwRmFjZSUwQWxsbSUyMCUzRCUyMEh1Z2dpbmdGYWNlSW5mZXJlbmNlQVBJKG1vZGVsX25hbWUlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBJTBBJTIzJTIwQ3JlYXIlMjBhJTIwQWxmcmVkJTJDJTIwbnVlc3RybyUyMGFnZW50ZSUyMGRlJTIwZ2FsYSUyQyUyMGNvbiUyMGxhJTIwaGVycmFtaWVudGElMjBkZSUyMGluZm9ybWFjaSVDMyVCM24lMjBkZSUyMGludml0YWRvcyUwQWFsZnJlZCUyMCUzRCUyMEFnZW50V29ya2Zsb3cuZnJvbV90b29sc19vcl9mdW5jdGlvbnMoJTBBJTIwJTIwJTIwJTIwJTVCZ3Vlc3RfaW5mb190b29sJTVEJTJDJTBBJTIwJTIwJTIwJTIwbGxtJTNEbGxtJTJDJTBBKSUwQSUwQSUyMyUyMEVqZW1wbG8lMjBkZSUyMGNvbnN1bHRhJTIwcXVlJTIwQWxmcmVkJTIwcG9kciVDMyVBRGElMjByZWNpYmlyJTIwZHVyYW50ZSUyMGxhJTIwZ2FsYSUwQXJlc3BvbnNlJTIwJTNEJTIwYXdhaXQlMjBhbGZyZWQucnVuKCUyMkN1JUMzJUE5bnRhbWUlMjBzb2JyZSUyMG51ZXN0cmElMjBpbnZpdGFkYSUyMGxsYW1hZGElMjAnTGFkeSUyMEFkYSUyMExvdmVsYWNlJy4lMjIpJTBBJTBBcHJpbnQoJTIyJUYwJTlGJThFJUE5JTIwUmVzcHVlc3RhJTIwZGUlMjBBbGZyZWQlM0ElMjIpJTBBcHJpbnQocmVzcG9uc2Up",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> AgentWorkflow
<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

<span class="hljs-comment"># Inicializar el modelo de Hugging Face</span>
llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

<span class="hljs-comment"># Crear a Alfred, nuestro agente de gala, con la herramienta de información de invitados</span>
alfred = AgentWorkflow.from_tools_or_functions(
    [guest_info_tool],
    llm=llm,
)

<span class="hljs-comment"># Ejemplo de consulta que Alfred podría recibir durante la gala</span>
response = <span class="hljs-keyword">await</span> alfred.run(<span class="hljs-string">&quot;Cuéntame sobre nuestra invitada llamada &#x27;Lady Ada Lovelace&#x27;.&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🎩 Respuesta de Alfred:&quot;</span>)
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),i=new E({props:{code:"JUYwJTlGJThFJUE5JTIwUmVzcHVlc3RhJTIwZGUlMjBBbGZyZWQlM0ElMEFMYWR5JTIwQWRhJTIwTG92ZWxhY2UlMjBlcyUyMHVuYSUyMGVzdGltYWRhJTIwbWF0ZW0lQzMlQTF0aWNhJTIweSUyMGFtaWdhJTJDJTIwcmVjb25vY2lkYSUyMHBvciUyMHN1JTIwdHJhYmFqbyUyMHBpb25lcm8lMjBlbiUyMG1hdGVtJUMzJUExdGljYXMlMjBlJTIwaW5mb3JtJUMzJUExdGljYS4lMjBFcyUyMGNlbGVicmFkYSUyMGNvbW8lMjBsYSUyMHByaW1lcmElMjBwcm9ncmFtYWRvcmElMjBkZSUyMGNvbXB1dGFkb3JhcyUyMGRlYmlkbyUyMGElMjBzdSUyMHRyYWJham8lMjBlbiUyMGxhJTIwTSVDMyVBMXF1aW5hJTIwQW5hbCVDMyVBRHRpY2ElMjBkZSUyMENoYXJsZXMlMjBCYWJiYWdlLiUyMFN1JTIwY29ycmVvJTIwZWxlY3RyJUMzJUIzbmljbyUyMGVzJTIwYWRhLmxvdmVsYWNlJTQwZXhhbXBsZS5jb20u",highlighted:`🎩 Respuesta <span class="hljs-keyword">de</span> Alfred:
Lady Ada Lovelace es una estimada matemática y amiga, reconocida por <span class="hljs-keyword">su</span> trabajo pionero <span class="hljs-keyword">en</span> matemáticas <span class="hljs-keyword">e</span> informática. Es celebrada como <span class="hljs-keyword">la</span> primera programadora <span class="hljs-keyword">de</span> computadoras debido a <span class="hljs-keyword">su</span> trabajo <span class="hljs-keyword">en</span> <span class="hljs-keyword">la</span> <span class="hljs-keyword">M</span>áquina Analítica <span class="hljs-keyword">de</span> Charles Babbage. <span class="hljs-keyword">Su</span> correo electrónico es ada.lovelace@example.com.`,wrap:!1}}),{c(){f(o.$$.fragment),U=c(),p=J("p"),p.textContent=u,m=c(),f(i.$$.fragment),l=c(),M=J("p"),M.textContent=w,b=c(),j=J("ul"),j.innerHTML=h},l(n){I(o.$$.fragment,n),U=d(n),p=y(n,"P",{"data-svelte-h":!0}),T(p)!=="svelte-wjimjn"&&(p.textContent=u),m=d(n),I(i.$$.fragment,n),l=d(n),M=y(n,"P",{"data-svelte-h":!0}),T(M)!=="svelte-143o5dl"&&(M.textContent=w),b=d(n),j=y(n,"UL",{"data-svelte-h":!0}),T(j)!=="svelte-qe8ipf"&&(j.innerHTML=h)},m(n,t){g(o,n,t),a(n,U,t),a(n,p,t),a(n,m,t),g(i,n,t),a(n,l,t),a(n,M,t),a(n,b,t),a(n,j,t),$=!0},p:N,i(n){$||(Z(o.$$.fragment,n),Z(i.$$.fragment,n),$=!0)},o(n){C(o.$$.fragment,n),C(i.$$.fragment,n),$=!1},d(n){n&&(s(U),s(p),s(m),s(l),s(M),s(b),s(j)),v(o,n),v(i,n)}}}function us(B){let o,U,p,u="Salida esperada:",m,i,l,M,w="Lo que está sucediendo en este paso final:",b,j,h="<li>Inicializamos un modelo de Hugging Face usando la clase <code>HuggingFaceEndpoint</code>. También generamos una interfaz de chat y añadimos las herramientas.</li> <li>Creamos nuestro agente (Alfred) como un <code>StateGraph</code>, que combina 2 nodos (<code>assistant</code>, <code>tools</code>) usando un borde</li> <li>Le pedimos a Alfred que recupere información sobre una invitada llamada “Lady Ada Lovelace”</li>",$;return o=new E({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> TypedDict, Annotated
<span class="hljs-keyword">from</span> langgraph.graph.message <span class="hljs-keyword">import</span> add_messages
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> AnyMessage, HumanMessage, AIMessage
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> ToolNode
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> START, StateGraph
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> tools_condition
<span class="hljs-keyword">from</span> langchain_huggingface <span class="hljs-keyword">import</span> HuggingFaceEndpoint, ChatHuggingFace

<span class="hljs-comment"># Generar la interfaz de chat, incluyendo las herramientas</span>
llm = HuggingFaceEndpoint(
    repo_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>,
    huggingfacehub_api_token=HUGGINGFACEHUB_API_TOKEN,
)

chat = ChatHuggingFace(llm=llm, verbose=<span class="hljs-literal">True</span>)
tools = [guest_info_tool]
chat_with_tools = chat.bind_tools(tools)

<span class="hljs-comment"># Generar el AgentState y el grafo del Agente</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">AgentState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    messages: Annotated[<span class="hljs-built_in">list</span>[AnyMessage], add_messages]

<span class="hljs-keyword">def</span> <span class="hljs-title function_">assistant</span>(<span class="hljs-params">state: AgentState</span>):
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;messages&quot;</span>: [chat_with_tools.invoke(state[<span class="hljs-string">&quot;messages&quot;</span>])],
    }

<span class="hljs-comment">## El grafo</span>
builder = StateGraph(AgentState)

<span class="hljs-comment"># Definir nodos: estos hacen el trabajo</span>
builder.add_node(<span class="hljs-string">&quot;assistant&quot;</span>, assistant)
builder.add_node(<span class="hljs-string">&quot;tools&quot;</span>, ToolNode(tools))

<span class="hljs-comment"># Definir bordes: estos determinan cómo se mueve el flujo de control</span>
builder.add_edge(START, <span class="hljs-string">&quot;assistant&quot;</span>)
builder.add_conditional_edges(
    <span class="hljs-string">&quot;assistant&quot;</span>,
    <span class="hljs-comment"># Si el último mensaje requiere una herramienta, enrutar a herramientas</span>
    <span class="hljs-comment"># De lo contrario, proporcionar una respuesta directa</span>
    tools_condition,
)
builder.add_edge(<span class="hljs-string">&quot;tools&quot;</span>, <span class="hljs-string">&quot;assistant&quot;</span>)
alfred = builder.<span class="hljs-built_in">compile</span>()

messages = [HumanMessage(content=<span class="hljs-string">&quot;Cuéntame sobre nuestra invitada llamada &#x27;Lady Ada Lovelace&#x27;.&quot;</span>)]
response = alfred.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages})

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🎩 Respuesta de Alfred:&quot;</span>)
<span class="hljs-built_in">print</span>(messages[<span class="hljs-string">&#x27;messages&#x27;</span>][-<span class="hljs-number">1</span>].content)`,wrap:!1}}),i=new E({props:{code:"JUYwJTlGJThFJUE5JTIwUmVzcHVlc3RhJTIwZGUlMjBBbGZyZWQlM0ElMEFMYWR5JTIwQWRhJTIwTG92ZWxhY2UlMjBlcyUyMHVuYSUyMGVzdGltYWRhJTIwbWF0ZW0lQzMlQTF0aWNhJTIweSUyMHBpb25lcmElMjBlbiUyMGluZm9ybSVDMyVBMXRpY2ElMkMlMjBhJTIwbWVudWRvJTIwY2VsZWJyYWRhJTIwY29tbyUyMGxhJTIwcHJpbWVyYSUyMHByb2dyYW1hZG9yYSUyMGRlJTIwY29tcHV0YWRvcmFzJTIwZGViaWRvJTIwYSUyMHN1JTIwdHJhYmFqbyUyMGVuJTIwbGElMjBNJUMzJUExcXVpbmElMjBBbmFsJUMzJUFEdGljYSUyMGRlJTIwQ2hhcmxlcyUyMEJhYmJhZ2Uu",highlighted:`🎩 Respuesta <span class="hljs-keyword">de</span> Alfred:
Lady Ada Lovelace es una estimada matemática y pionera <span class="hljs-keyword">en</span> informática, a menudo celebrada como <span class="hljs-keyword">la</span> primera programadora <span class="hljs-keyword">de</span> computadoras debido a <span class="hljs-keyword">su</span> trabajo <span class="hljs-keyword">en</span> <span class="hljs-keyword">la</span> <span class="hljs-keyword">M</span>áquina Analítica <span class="hljs-keyword">de</span> Charles Babbage.`,wrap:!1}}),{c(){f(o.$$.fragment),U=c(),p=J("p"),p.textContent=u,m=c(),f(i.$$.fragment),l=c(),M=J("p"),M.textContent=w,b=c(),j=J("ul"),j.innerHTML=h},l(n){I(o.$$.fragment,n),U=d(n),p=y(n,"P",{"data-svelte-h":!0}),T(p)!=="svelte-wjimjn"&&(p.textContent=u),m=d(n),I(i.$$.fragment,n),l=d(n),M=y(n,"P",{"data-svelte-h":!0}),T(M)!=="svelte-143o5dl"&&(M.textContent=w),b=d(n),j=y(n,"UL",{"data-svelte-h":!0}),T(j)!=="svelte-opm47d"&&(j.innerHTML=h)},m(n,t){g(o,n,t),a(n,U,t),a(n,p,t),a(n,m,t),g(i,n,t),a(n,l,t),a(n,M,t),a(n,b,t),a(n,j,t),$=!0},p:N,i(n){$||(Z(o.$$.fragment,n),Z(i.$$.fragment,n),$=!0)},o(n){C(o.$$.fragment,n),C(i.$$.fragment,n),$=!1},d(n){n&&(s(U),s(p),s(m),s(l),s(M),s(b),s(j)),v(o,n),v(i,n)}}}function ms(B){let o,U,p,u,m,i;return o=new Y({props:{id:"agents-frameworks",option:"smolagents",$$slots:{default:[ds]},$$scope:{ctx:B}}}),p=new Y({props:{id:"agents-frameworks",option:"llama-index",$$slots:{default:[Ms]},$$scope:{ctx:B}}}),m=new Y({props:{id:"agents-frameworks",option:"langgraph",$$slots:{default:[us]},$$scope:{ctx:B}}}),{c(){f(o.$$.fragment),U=c(),f(p.$$.fragment),u=c(),f(m.$$.fragment)},l(l){I(o.$$.fragment,l),U=d(l),I(p.$$.fragment,l),u=d(l),I(m.$$.fragment,l)},m(l,M){g(o,l,M),a(l,U,M),g(p,l,M),a(l,u,M),g(m,l,M),i=!0},p(l,M){const w={};M&2&&(w.$$scope={dirty:M,ctx:l}),o.$set(w);const b={};M&2&&(b.$$scope={dirty:M,ctx:l}),p.$set(b);const j={};M&2&&(j.$$scope={dirty:M,ctx:l}),m.$set(j)},i(l){i||(Z(o.$$.fragment,l),Z(p.$$.fragment,l),Z(m.$$.fragment,l),i=!0)},o(l){C(o.$$.fragment,l),C(p.$$.fragment,l),C(m.$$.fragment,l),i=!1},d(l){l&&(s(U),s(u)),v(o,l),v(p,l),v(m,l)}}}function Js(B){let o,U,p,u,m,i,l,M="Alfred, tu agente de confianza, está preparando la gala más extravagante del siglo. Para asegurar que el evento transcurra sin problemas, Alfred necesita acceso rápido a información actualizada sobre cada invitado. Ayudemos a Alfred creando una herramienta personalizada de Generación Aumentada por Recuperación (RAG), impulsada por nuestro conjunto de datos personalizado.",w,b,j,h,$="Imagina a Alfred mezclándose entre los invitados, necesitando recordar detalles específicos sobre cada persona en un instante. Un LLM tradicional podría tener dificultades con esta tarea porque:",n,t,G="<li>La lista de invitados es específica para tu evento y no está en los datos de entrenamiento del modelo</li> <li>La información de los invitados puede cambiar o actualizarse frecuentemente</li> <li>Alfred necesita recuperar detalles precisos como direcciones de correo electrónico</li>",Ze,F,Ul="Aquí es donde brilla la Generación Aumentada por Recuperación (RAG)! Al combinar un sistema de recuperación con un LLM, Alfred puede acceder a información precisa y actualizada sobre tus invitados bajo demanda.",Ce,Q,jl="<p>Puedes elegir cualquiera de los frameworks cubiertos en el curso para este caso de uso. Selecciona tu opción preferida de las pestañas de código.</p>",ve,_,Ge,A,wl="En esta unidad, desarrollaremos nuestro agente dentro de un Espacio de HF(HF Space), como un proyecto Python estructurado. Este enfoque nos ayuda a mantener un código limpio y modular, organizando diferentes funcionalidades en archivos separados. Además, esto crea un caso de uso más realista donde desplegarías la aplicación para uso público.",Be,H,$e,L,bl="<li><strong><code>tools.py</code></strong> – Proporciona herramientas auxiliares para el agente.</li> <li><strong><code>retriever.py</code></strong> – Implementa funciones de recuperación para apoyar el acceso al conocimiento.</li> <li><strong><code>app.py</code></strong> – Integra todos los componentes en un agente completamente funcional, que finalizaremos en la última parte de esta unidad.</li>",We,D,hl='Para una referencia práctica, consulta <a href="https://huggingface.co/spaces/agents-course/Unit_3_Agentic_RAG" rel="nofollow">este Espacio de HF</a>, donde el RAG Agéntico desarrollado en esta unidad está en vivo. ¡Siéntete libre de clonarlo y experimentar!',Ee,P,fl="Puedes probar directamente el agente a continuación:",Ve,R,Il,Re,K,ke,O,gl='Nuestro conjunto de datos <a href="https://huggingface.co/datasets/agents-course/unit3-invitees/" rel="nofollow"><code>agents-course/unit3-invitees</code></a> contiene los siguientes campos para cada invitado:',Ye,ee,Zl="<li><strong>Nombre</strong>: Nombre completo del invitado</li> <li><strong>Relación</strong>: Cómo se relaciona el invitado con el anfitrión</li> <li><strong>Descripción</strong>: Una breve biografía o hechos interesantes sobre el invitado</li> <li><strong>Dirección de Correo Electrónico</strong>: Información de contacto para enviar invitaciones o seguimientos</li>",Ne,le,Cl="A continuación se muestra una vista previa del conjunto de datos:",Qe,k,vl,xe,x,Gl="<p>En un escenario del mundo real, este conjunto de datos podría ampliarse para incluir preferencias dietéticas, intereses de regalos, temas de conversación a evitar y otros detalles útiles para un anfitrión.</p>",Se,se,ze,ae,Bl="Crearemos una herramienta personalizada que Alfred pueda usar para recuperar rápidamente información de los invitados durante la gala. Dividamos esto en tres pasos manejables:",Xe,te,$l="<li>Cargar y preparar el conjunto de datos</li> <li>Crear la Herramienta de Recuperación</li> <li>Integrar la Herramienta con Alfred</li>",qe,ne,Wl="¡Comencemos con la carga y preparación del conjunto de datos!",Fe,oe,_e,re,El="Primero, necesitamos transformar nuestros datos brutos de invitados en un formato optimizado para la recuperación.",Ae,S,He,ie,Vl="En el código anterior:",Le,pe,Rl="<li>Cargamos el conjunto de datos</li> <li>Convertimos cada entrada de invitado en un objeto <code>Document</code> con contenido formateado</li> <li>Almacenamos los objetos <code>Document</code> en una lista</li>",De,ce,kl="Esto significa que tenemos todos nuestros datos disponibles de manera ordenada para poder comenzar a configurar nuestra recuperación.",Pe,de,Ke,Me,Yl="Ahora, creemos una herramienta personalizada que Alfred pueda usar para buscar en nuestra información de invitados.",Oe,z,el,ue,ll,me,Nl="Finalmente, juntemos todo creando nuestro agente y equipándolo con nuestra herramienta personalizada:",sl,X,al,Je,tl,ye,Ql="Durante la gala, una conversación podría fluir así:",nl,Te,xl="<strong>Tú:</strong> “Alfred, ¿quién es ese caballero hablando con el embajador?”",ol,Ue,Sl="<strong>Alfred:</strong> <em>rápidamente busca en la base de datos de invitados</em> “Ese es el Dr. Nikola Tesla, señor. Es un viejo amigo de sus días universitarios. Recientemente ha patentado un nuevo sistema de transmisión de energía inalámbrica y estaría encantado de discutirlo con usted. Solo recuerde que es apasionado por las palomas, así que eso podría ser un buen tema de conversación.”",rl,je,il,we,pl,be,zl="Ahora que Alfred puede recuperar información de invitados, considera cómo podrías mejorar este sistema:",cl,he,Xl='<li><strong>Mejorar el recuperador</strong> para usar un algoritmo más sofisticado como <a href="https://www.sbert.net/" rel="nofollow">sentence-transformers</a></li> <li><strong>Implementar una memoria de conversación</strong> para que Alfred recuerde interacciones previas</li> <li><strong>Combinar con búsqueda web</strong> para obtener la información más reciente sobre invitados desconocidos</li> <li><strong>Integrar múltiples índices</strong> para obtener información más completa de fuentes verificadas</li>',dl,fe,ql="¡Ahora Alfred está completamente equipado para manejar consultas de invitados sin esfuerzo, asegurando que tu gala sea recordada como el evento más sofisticado y encantador del siglo!",Ml,q,Fl="<p>Intenta extender la herramienta de recuperación para que también devuelva iniciadores de conversación basados en los intereses o antecedentes de cada invitado. ¿Cómo modificarías la herramienta para lograr esto?</p> <p>Cuando hayas terminado, implementa tu herramienta de recuperación de invitados en el archivo <code>retriever.py</code>.</p>",ul,Ie,ml,ge,Jl;return m=new V({props:{title:"Creando una Herramienta RAG para Historias de Invitados",local:"creando-una-herramienta-rag-para-historias-de-invitados",headingTag:"h1"}}),b=new V({props:{title:"¿Por qué RAG para una Gala?",local:"por-qué-rag-para-una-gala",headingTag:"h2"}}),_=new V({props:{title:"Configurando nuestra aplicación",local:"configurando-nuestra-aplicación",headingTag:"h2"}}),H=new V({props:{title:"Estructura del Proyecto",local:"estructura-del-proyecto",headingTag:"h3"}}),K=new V({props:{title:"Descripción General del Conjunto de Datos",local:"descripción-general-del-conjunto-de-datos",headingTag:"h2"}}),se=new V({props:{title:"Construyendo la Herramienta de Lista de Invitados",local:"construyendo-la-herramienta-de-lista-de-invitados",headingTag:"h2"}}),oe=new V({props:{title:"Paso 1: Cargar y Preparar el Conjunto de Datos",local:"paso-1-cargar-y-preparar-el-conjunto-de-datos",headingTag:"h3"}}),S=new Tl({props:{id:"agents-frameworks",options:["smolagents","llama-index","langgraph"],$$slots:{default:[os]},$$scope:{ctx:B}}}),de=new V({props:{title:"Paso 2: Crear la Herramienta de Recuperación",local:"paso-2-crear-la-herramienta-de-recuperación",headingTag:"h3"}}),z=new Tl({props:{id:"agents-frameworks",options:["smolagents","llama-index","langgraph"],$$slots:{default:[cs]},$$scope:{ctx:B}}}),ue=new V({props:{title:"Paso 3: Integrar la Herramienta con Alfred",local:"paso-3-integrar-la-herramienta-con-alfred",headingTag:"h3"}}),X=new Tl({props:{id:"agents-frameworks",options:["smolagents","llama-index","langgraph"],$$slots:{default:[ms]},$$scope:{ctx:B}}}),Je=new V({props:{title:"Ejemplo de Interacción",local:"ejemplo-de-interacción",headingTag:"h2"}}),je=new E({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIybmFtZSUyMiUzQSUyMCUyMkRyLiUyME5pa29sYSUyMFRlc2xhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVsYXRpb24lMjIlM0ElMjAlMjJ2aWVqbyUyMGFtaWdvJTIwZGUlMjBkJUMzJUFEYXMlMjB1bml2ZXJzaXRhcmlvcyUyMiUyQyUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIyRWwlMjBEci4lMjBOaWtvbGElMjBUZXNsYSUyMGVzJTIwdW4lMjB2aWVqbyUyMGFtaWdvJTIwZGUlMjBzdXMlMjBkJUMzJUFEYXMlMjB1bml2ZXJzaXRhcmlvcy4lMjBSZWNpZW50ZW1lbnRlJTIwaGElMjBwYXRlbnRhZG8lMjB1biUyMG51ZXZvJTIwc2lzdGVtYSUyMGRlJTIwdHJhbnNtaXNpJUMzJUIzbiUyMGRlJTIwZW5lcmclQzMlQURhJTIwaW5hbCVDMyVBMW1icmljYSUyMHklMjBlc3RhciVDMyVBRGElMjBlbmNhbnRhZG8lMjBkZSUyMGRpc2N1dGlybG8lMjBjb24lMjB1c3RlZC4lMjBTb2xvJTIwcmVjdWVyZGUlMjBxdWUlMjBlcyUyMGFwYXNpb25hZG8lMjBwb3IlMjBsYXMlMjBwYWxvbWFzJTJDJTIwYXMlQzMlQUQlMjBxdWUlMjBlc28lMjBwb2RyJUMzJUFEYSUyMHNlciUyMHVuJTIwYnVlbiUyMHRlbWElMjBkZSUyMGNvbnZlcnNhY2klQzMlQjNuLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVtYWlsJTIyJTNBJTIwJTIybmlrb2xhLnRlc2xhJTQwZ21haWwuY29tJTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Dr. Nikola Tesla&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;relation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;viejo amigo de días universitarios&quot;</span><span class="hljs-punctuation">,</span>  
    <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;El Dr. Nikola Tesla es un viejo amigo de sus días universitarios. Recientemente ha patentado un nuevo sistema de transmisión de energía inalámbrica y estaría encantado de discutirlo con usted. Solo recuerde que es apasionado por las palomas, así que eso podría ser un buen tema de conversación.&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;email&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;nikola.tesla@gmail.com&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),we=new V({props:{title:"Llevándolo Más Allá",local:"llevándolo-más-allá",headingTag:"h2"}}),Ie=new ss({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit3/agentic-rag/invitees.mdx"}}),{c(){o=J("meta"),U=c(),p=J("p"),u=c(),f(m.$$.fragment),i=c(),l=J("p"),l.textContent=M,w=c(),f(b.$$.fragment),j=c(),h=J("p"),h.textContent=$,n=c(),t=J("ol"),t.innerHTML=G,Ze=c(),F=J("p"),F.textContent=Ul,Ce=c(),Q=J("blockquote"),Q.innerHTML=jl,ve=c(),f(_.$$.fragment),Ge=c(),A=J("p"),A.textContent=wl,Be=c(),f(H.$$.fragment),$e=c(),L=J("ul"),L.innerHTML=bl,We=c(),D=J("p"),D.innerHTML=hl,Ee=c(),P=J("p"),P.textContent=fl,Ve=c(),R=J("iframe"),Re=c(),f(K.$$.fragment),ke=c(),O=J("p"),O.innerHTML=gl,Ye=c(),ee=J("ul"),ee.innerHTML=Zl,Ne=c(),le=J("p"),le.textContent=Cl,Qe=c(),k=J("iframe"),xe=c(),x=J("blockquote"),x.innerHTML=Gl,Se=c(),f(se.$$.fragment),ze=c(),ae=J("p"),ae.textContent=Bl,Xe=c(),te=J("ol"),te.innerHTML=$l,qe=c(),ne=J("p"),ne.textContent=Wl,Fe=c(),f(oe.$$.fragment),_e=c(),re=J("p"),re.textContent=El,Ae=c(),f(S.$$.fragment),He=c(),ie=J("p"),ie.textContent=Vl,Le=c(),pe=J("ul"),pe.innerHTML=Rl,De=c(),ce=J("p"),ce.textContent=kl,Pe=c(),f(de.$$.fragment),Ke=c(),Me=J("p"),Me.textContent=Yl,Oe=c(),f(z.$$.fragment),el=c(),f(ue.$$.fragment),ll=c(),me=J("p"),me.textContent=Nl,sl=c(),f(X.$$.fragment),al=c(),f(Je.$$.fragment),tl=c(),ye=J("p"),ye.textContent=Ql,nl=c(),Te=J("p"),Te.innerHTML=xl,ol=c(),Ue=J("p"),Ue.innerHTML=Sl,rl=c(),f(je.$$.fragment),il=c(),f(we.$$.fragment),pl=c(),be=J("p"),be.textContent=zl,cl=c(),he=J("ol"),he.innerHTML=Xl,dl=c(),fe=J("p"),fe.textContent=ql,Ml=c(),q=J("blockquote"),q.innerHTML=Fl,ul=c(),f(Ie.$$.fragment),ml=c(),ge=J("p"),this.h()},l(e){const r=es("svelte-u9bgzb",document.head);o=y(r,"META",{name:!0,content:!0}),r.forEach(s),U=d(e),p=y(e,"P",{}),yl(p).forEach(s),u=d(e),I(m.$$.fragment,e),i=d(e),l=y(e,"P",{"data-svelte-h":!0}),T(l)!=="svelte-kr2sua"&&(l.textContent=M),w=d(e),I(b.$$.fragment,e),j=d(e),h=y(e,"P",{"data-svelte-h":!0}),T(h)!=="svelte-81plxj"&&(h.textContent=$),n=d(e),t=y(e,"OL",{"data-svelte-h":!0}),T(t)!=="svelte-hyh64d"&&(t.innerHTML=G),Ze=d(e),F=y(e,"P",{"data-svelte-h":!0}),T(F)!=="svelte-1pskziw"&&(F.textContent=Ul),Ce=d(e),Q=y(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(Q)!=="svelte-19xv22"&&(Q.innerHTML=jl),ve=d(e),I(_.$$.fragment,e),Ge=d(e),A=y(e,"P",{"data-svelte-h":!0}),T(A)!=="svelte-rjjrlh"&&(A.textContent=wl),Be=d(e),I(H.$$.fragment,e),$e=d(e),L=y(e,"UL",{"data-svelte-h":!0}),T(L)!=="svelte-ug6v2"&&(L.innerHTML=bl),We=d(e),D=y(e,"P",{"data-svelte-h":!0}),T(D)!=="svelte-1q2hi5g"&&(D.innerHTML=hl),Ee=d(e),P=y(e,"P",{"data-svelte-h":!0}),T(P)!=="svelte-1h3egp1"&&(P.textContent=fl),Ve=d(e),R=y(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),yl(R).forEach(s),Re=d(e),I(K.$$.fragment,e),ke=d(e),O=y(e,"P",{"data-svelte-h":!0}),T(O)!=="svelte-15e4w12"&&(O.innerHTML=gl),Ye=d(e),ee=y(e,"UL",{"data-svelte-h":!0}),T(ee)!=="svelte-1t9z4qv"&&(ee.innerHTML=Zl),Ne=d(e),le=y(e,"P",{"data-svelte-h":!0}),T(le)!=="svelte-1ek1znz"&&(le.textContent=Cl),Qe=d(e),k=y(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),yl(k).forEach(s),xe=d(e),x=y(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(x)!=="svelte-1v1bm7l"&&(x.innerHTML=Gl),Se=d(e),I(se.$$.fragment,e),ze=d(e),ae=y(e,"P",{"data-svelte-h":!0}),T(ae)!=="svelte-3mdv5y"&&(ae.textContent=Bl),Xe=d(e),te=y(e,"OL",{"data-svelte-h":!0}),T(te)!=="svelte-qz8oe8"&&(te.innerHTML=$l),qe=d(e),ne=y(e,"P",{"data-svelte-h":!0}),T(ne)!=="svelte-133e1ug"&&(ne.textContent=Wl),Fe=d(e),I(oe.$$.fragment,e),_e=d(e),re=y(e,"P",{"data-svelte-h":!0}),T(re)!=="svelte-xpu2ei"&&(re.textContent=El),Ae=d(e),I(S.$$.fragment,e),He=d(e),ie=y(e,"P",{"data-svelte-h":!0}),T(ie)!=="svelte-1mfw0sf"&&(ie.textContent=Vl),Le=d(e),pe=y(e,"UL",{"data-svelte-h":!0}),T(pe)!=="svelte-dn9sg6"&&(pe.innerHTML=Rl),De=d(e),ce=y(e,"P",{"data-svelte-h":!0}),T(ce)!=="svelte-8prxa4"&&(ce.textContent=kl),Pe=d(e),I(de.$$.fragment,e),Ke=d(e),Me=y(e,"P",{"data-svelte-h":!0}),T(Me)!=="svelte-11t7nlr"&&(Me.textContent=Yl),Oe=d(e),I(z.$$.fragment,e),el=d(e),I(ue.$$.fragment,e),ll=d(e),me=y(e,"P",{"data-svelte-h":!0}),T(me)!=="svelte-1nrd3vd"&&(me.textContent=Nl),sl=d(e),I(X.$$.fragment,e),al=d(e),I(Je.$$.fragment,e),tl=d(e),ye=y(e,"P",{"data-svelte-h":!0}),T(ye)!=="svelte-x35jih"&&(ye.textContent=Ql),nl=d(e),Te=y(e,"P",{"data-svelte-h":!0}),T(Te)!=="svelte-yk3ykx"&&(Te.innerHTML=xl),ol=d(e),Ue=y(e,"P",{"data-svelte-h":!0}),T(Ue)!=="svelte-twxbr6"&&(Ue.innerHTML=Sl),rl=d(e),I(je.$$.fragment,e),il=d(e),I(we.$$.fragment,e),pl=d(e),be=y(e,"P",{"data-svelte-h":!0}),T(be)!=="svelte-ofzv4y"&&(be.textContent=zl),cl=d(e),he=y(e,"OL",{"data-svelte-h":!0}),T(he)!=="svelte-1ply8go"&&(he.innerHTML=Xl),dl=d(e),fe=y(e,"P",{"data-svelte-h":!0}),T(fe)!=="svelte-10gbwj9"&&(fe.textContent=ql),Ml=d(e),q=y(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(q)!=="svelte-1ef0drj"&&(q.innerHTML=Fl),ul=d(e),I(Ie.$$.fragment,e),ml=d(e),ge=y(e,"P",{}),yl(ge).forEach(s),this.h()},h(){W(o,"name","hf:doc:metadata"),W(o,"content",ys),W(Q,"class","tip"),Ll(R.src,Il="https://agents-course-unit-3-agentic-rag.hf.space")||W(R,"src",Il),W(R,"frameborder","0"),W(R,"width","850"),W(R,"height","450"),Ll(k.src,vl="https://huggingface.co/datasets/agents-course/unit3-invitees/embed/viewer/default/train")||W(k,"src",vl),W(k,"frameborder","0"),W(k,"width","100%"),W(k,"height","560px"),W(x,"class","tip"),W(q,"class","tip")},m(e,r){ls(document.head,o),a(e,U,r),a(e,p,r),a(e,u,r),g(m,e,r),a(e,i,r),a(e,l,r),a(e,w,r),g(b,e,r),a(e,j,r),a(e,h,r),a(e,n,r),a(e,t,r),a(e,Ze,r),a(e,F,r),a(e,Ce,r),a(e,Q,r),a(e,ve,r),g(_,e,r),a(e,Ge,r),a(e,A,r),a(e,Be,r),g(H,e,r),a(e,$e,r),a(e,L,r),a(e,We,r),a(e,D,r),a(e,Ee,r),a(e,P,r),a(e,Ve,r),a(e,R,r),a(e,Re,r),g(K,e,r),a(e,ke,r),a(e,O,r),a(e,Ye,r),a(e,ee,r),a(e,Ne,r),a(e,le,r),a(e,Qe,r),a(e,k,r),a(e,xe,r),a(e,x,r),a(e,Se,r),g(se,e,r),a(e,ze,r),a(e,ae,r),a(e,Xe,r),a(e,te,r),a(e,qe,r),a(e,ne,r),a(e,Fe,r),g(oe,e,r),a(e,_e,r),a(e,re,r),a(e,Ae,r),g(S,e,r),a(e,He,r),a(e,ie,r),a(e,Le,r),a(e,pe,r),a(e,De,r),a(e,ce,r),a(e,Pe,r),g(de,e,r),a(e,Ke,r),a(e,Me,r),a(e,Oe,r),g(z,e,r),a(e,el,r),g(ue,e,r),a(e,ll,r),a(e,me,r),a(e,sl,r),g(X,e,r),a(e,al,r),g(Je,e,r),a(e,tl,r),a(e,ye,r),a(e,nl,r),a(e,Te,r),a(e,ol,r),a(e,Ue,r),a(e,rl,r),g(je,e,r),a(e,il,r),g(we,e,r),a(e,pl,r),a(e,be,r),a(e,cl,r),a(e,he,r),a(e,dl,r),a(e,fe,r),a(e,Ml,r),a(e,q,r),a(e,ul,r),g(Ie,e,r),a(e,ml,r),a(e,ge,r),Jl=!0},p(e,[r]){const _l={};r&2&&(_l.$$scope={dirty:r,ctx:e}),S.$set(_l);const Al={};r&2&&(Al.$$scope={dirty:r,ctx:e}),z.$set(Al);const Hl={};r&2&&(Hl.$$scope={dirty:r,ctx:e}),X.$set(Hl)},i(e){Jl||(Z(m.$$.fragment,e),Z(b.$$.fragment,e),Z(_.$$.fragment,e),Z(H.$$.fragment,e),Z(K.$$.fragment,e),Z(se.$$.fragment,e),Z(oe.$$.fragment,e),Z(S.$$.fragment,e),Z(de.$$.fragment,e),Z(z.$$.fragment,e),Z(ue.$$.fragment,e),Z(X.$$.fragment,e),Z(Je.$$.fragment,e),Z(je.$$.fragment,e),Z(we.$$.fragment,e),Z(Ie.$$.fragment,e),Jl=!0)},o(e){C(m.$$.fragment,e),C(b.$$.fragment,e),C(_.$$.fragment,e),C(H.$$.fragment,e),C(K.$$.fragment,e),C(se.$$.fragment,e),C(oe.$$.fragment,e),C(S.$$.fragment,e),C(de.$$.fragment,e),C(z.$$.fragment,e),C(ue.$$.fragment,e),C(X.$$.fragment,e),C(Je.$$.fragment,e),C(je.$$.fragment,e),C(we.$$.fragment,e),C(Ie.$$.fragment,e),Jl=!1},d(e){e&&(s(U),s(p),s(u),s(i),s(l),s(w),s(j),s(h),s(n),s(t),s(Ze),s(F),s(Ce),s(Q),s(ve),s(Ge),s(A),s(Be),s($e),s(L),s(We),s(D),s(Ee),s(P),s(Ve),s(R),s(Re),s(ke),s(O),s(Ye),s(ee),s(Ne),s(le),s(Qe),s(k),s(xe),s(x),s(Se),s(ze),s(ae),s(Xe),s(te),s(qe),s(ne),s(Fe),s(_e),s(re),s(Ae),s(He),s(ie),s(Le),s(pe),s(De),s(ce),s(Pe),s(Ke),s(Me),s(Oe),s(el),s(ll),s(me),s(sl),s(al),s(tl),s(ye),s(nl),s(Te),s(ol),s(Ue),s(rl),s(il),s(pl),s(be),s(cl),s(he),s(dl),s(fe),s(Ml),s(q),s(ul),s(ml),s(ge)),s(o),v(m,e),v(b,e),v(_,e),v(H,e),v(K,e),v(se,e),v(oe,e),v(S,e),v(de,e),v(z,e),v(ue,e),v(X,e),v(Je,e),v(je,e),v(we,e),v(Ie,e)}}}const ys='{"title":"Creando una Herramienta RAG para Historias de Invitados","local":"creando-una-herramienta-rag-para-historias-de-invitados","sections":[{"title":"¿Por qué RAG para una Gala?","local":"por-qué-rag-para-una-gala","sections":[],"depth":2},{"title":"Configurando nuestra aplicación","local":"configurando-nuestra-aplicación","sections":[{"title":"Estructura del Proyecto","local":"estructura-del-proyecto","sections":[],"depth":3}],"depth":2},{"title":"Descripción General del Conjunto de Datos","local":"descripción-general-del-conjunto-de-datos","sections":[],"depth":2},{"title":"Construyendo la Herramienta de Lista de Invitados","local":"construyendo-la-herramienta-de-lista-de-invitados","sections":[{"title":"Paso 1: Cargar y Preparar el Conjunto de Datos","local":"paso-1-cargar-y-preparar-el-conjunto-de-datos","sections":[],"depth":3},{"title":"Paso 2: Crear la Herramienta de Recuperación","local":"paso-2-crear-la-herramienta-de-recuperación","sections":[],"depth":3},{"title":"Paso 3: Integrar la Herramienta con Alfred","local":"paso-3-integrar-la-herramienta-con-alfred","sections":[],"depth":3}],"depth":2},{"title":"Ejemplo de Interacción","local":"ejemplo-de-interacción","sections":[],"depth":2},{"title":"Llevándolo Más Allá","local":"llevándolo-más-allá","sections":[],"depth":2}],"depth":1}';function Ts(B){return Pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Is extends Kl{constructor(o){super(),Ol(this,o,Ts,Js,Dl,{})}}export{Is as component};
