import{s as Ne,n as Re,o as Fe}from"../chunks/scheduler.37c15a92.js";import{S as _e,i as qe,g as M,s as n,r as y,A as He,h as i,f as s,c as a,j as Se,u as o,x as p,k as Ue,y as Le,a as t,v as J,d as r,t as U,w as u}from"../chunks/index.2bf4358c.js";import{C as T}from"../chunks/CodeBlock.4e987730.js";import{H as j}from"../chunks/Heading.8ada512a.js";import{E as De}from"../chunks/getInferenceSnippets.0aa3753f.js";function Pe(ue){let w,jl,Ul,Tl,c,wl,m,je="Alfred à votre service. En tant que majordome de confiance de M. Wayne, j’ai pris la liberté de documenter comment j’aide M. Wayne avec ses divers besoins documentaires. Pendant qu’il s’occupe de ses… activités nocturnes, je m’assure que tous ses papiers, programmes d’entraînement et plans nutritionnels sont correctement analysés et organisés.",dl,I,Te="Avant de partir, il a laissé une note avec son programme d’entraînement de la semaine. J’ai alors pris la responsabilité de proposer un <strong>menu</strong> pour les repas de demain.",cl,C,we="Pour de futurs événements similaires, créons un système d’analyse de documents utilisant LangGraph pour servir les besoins de M. Wayne. Ce système peut :",ml,b,de="<li>Traiter des documents sous forme d’image</li> <li>Extraire du texte en utilisant des modèles de vision (<em>Vision Language Model</em>)</li> <li>Effectuer des calculs quand nécessaire (pour démontrer l’utilisation d’outils normaux)</li> <li>Analyser le contenu et fournir des résumés concis</li> <li>Exécuter des instructions spécifiques liées aux documents</li>",Il,h,Cl,B,ce="Le <em>workflow</em> que nous allons construire suit ce schéma structuré :",bl,g,me='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/alfred_flow.png" alt="Butler&#39;s Document Analysis Workflow"/>',hl,d,Ie='<p>Vous pouvez suivre le code dans <a href="https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/langgraph/agent.ipynb" target="_blank">ce <i>notebook</i></a> que vous pouvez exécuter avec Google Colab.</p>',Bl,Z,gl,A,Zl,G,Ce="et les imports :",Al,f,Gl,W,fl,V,be=`Cet état est un peu plus complexe que les précédents que nous avons vus.
<code>AnyMessage</code> est une classe de LangChain qui définit les messages, et <code>add_messages</code> est un opérateur qui ajoute le dernier message plutôt que de l’écraser avec le dernier état.`,Wl,x,he="C’est un nouveau concept dans LangGraph, où vous pouvez ajouter des opérateurs dans votre état pour définir la façon dont ils doivent interagir ensemble.",Vl,v,xl,X,vl,k,Xl,z,kl,E,zl,$,El,Y,Be="Permettez-moi d’expliquer l’approche dans cet agent. L’agent suit ce qu’on appelle le modèle <em>ReAct</em> (<em>Reason-Act-Observe</em>)",$l,Q,ge="<li><strong>Réfléchir</strong> sur ses documents et demandes</li> <li><strong>Agir</strong> en utilisant les outils appropriés</li> <li><strong>Observer</strong> les résultats</li> <li><strong>Répéter</strong> si nécessaire jusqu’à ce que j’aie pleinement répondu à ses besoins</li>",Yl,S,Ze="C’est une implémentation simple d’un agent utilisant LangGraph.",Ql,N,Sl,R,Ae=`Nous définissons un nœud <code>tools</code> avec notre liste d’outils. Le nœud <code>assistant</code> est juste notre modèle avec les outils liés.
Nous créons un graphe avec les nœuds <code>assistant</code> et <code>tools</code>.`,Nl,F,Ge="Nous ajoutons une arête <code>tools_condition</code>, qui route vers <code>End</code> ou vers <code>tools</code> selon que l’<code>assistant</code> appelle un outil.",Rl,_,fe="Maintenant, nous ajoutons une nouvelle étape :",Fl,q,We="Nous connectons le nœud <code>tools</code> de retour à l’<code>assistant</code>, formant une boucle.",_l,H,Ve="<li>Après l’exécution du nœud <code>assistant</code>, <code>tools_condition</code> vérifie si la sortie du modèle est un appel d’outil.</li> <li>Si c’est un appel d’outil, le flux est dirigé vers le nœud <code>tools</code>.</li> <li>Le nœud <code>tools</code> se reconnecte à <code>assistant</code>.</li> <li>Cette boucle continue tant que le modèle décide d’appeler des outils.</li> <li>Si la réponse du modèle n’est pas un appel d’outil, le flux est dirigé vers <em>END</em>, terminant le processus.</li>",ql,L,xe='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/Agent.png" alt="ReAct Pattern"/>',Hl,D,Ll,P,Dl,K,ve="Voici un exemple pour montrer un cas d’usage simple d’un agent utilisant un outil dans LangGraph.",Pl,O,Kl,ll,Xe="La conversation se déroulerait :",Ol,el,le,sl,ee,tl,ke="Quand Maître Wayne laisse ses notes d’entraînement et de repas :",se,nl,te,al,ze="L’interaction se déroulerait :",ne,Ml,ae,il,Me,pl,Ee="Si vous souhaitez créer votre propre majordome d’analyse de documents, voici les considérations clés :",ie,yl,$e="<li><strong>Définir des outils clairs</strong> pour des tâches spécifiques liées aux documents</li> <li><strong>Créer un suivi d’état robuste</strong> pour maintenir le contexte entre les appels d’outils</li> <li><strong>Considérer la gestion d’erreurs</strong> pour les échecs d’outils</li> <li><strong>Maintenir la conscience contextuelle</strong> des interactions précédentes (assurée par l’opérateur <code>add_messages</code>)</li>",pe,ol,Ye="Avec ces principes, vous pouvez vous aussi fournir un service d’analyse de documents exemplaire digne du manoir Wayne.",ye,Jl,Qe="<em>J’espère que cette explication a été satisfaisante. Maintenant, si vous voulez bien m’excuser, la cape de Maître Wayne nécessite un repassage avant les activités de ce soir.</em>",oe,rl,Je,ul,re;return c=new j({props:{title:"Graphe d’analyse de documents",local:"graphe-danalyse-de-documents",headingTag:"h1"}}),h=new j({props:{title:"Le workflow du majordome",local:"le-workflow-du-majordome",headingTag:"h2"}}),Z=new j({props:{title:"Configuration de l’environnement",local:"configuration-de-lenvironnement",headingTag:"h2"}}),A=new T({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdncmFwaCUyMGxhbmdjaGFpbl9vcGVuYWklMjBsYW5nY2hhaW5fY29yZQ==",highlighted:"%pip install langgraph langchain_openai langchain_core",wrap:!1}}),f=new T({props:{code:"aW1wb3J0JTIwYmFzZTY0JTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpc3QlMkMlMjBUeXBlZERpY3QlMkMlMjBBbm5vdGF0ZWQlMkMlMjBPcHRpb25hbCUwQWZyb20lMjBsYW5nY2hhaW5fb3BlbmFpJTIwaW1wb3J0JTIwQ2hhdE9wZW5BSSUwQWZyb20lMjBsYW5nY2hhaW5fY29yZS5tZXNzYWdlcyUyMGltcG9ydCUyMEFueU1lc3NhZ2UlMkMlMjBTeXN0ZW1NZXNzYWdlJTJDJTIwSHVtYW5NZXNzYWdlJTBBZnJvbSUyMGxhbmdncmFwaC5ncmFwaC5tZXNzYWdlJTIwaW1wb3J0JTIwYWRkX21lc3NhZ2VzJTBBZnJvbSUyMGxhbmdncmFwaC5ncmFwaCUyMGltcG9ydCUyMFNUQVJUJTJDJTIwU3RhdGVHcmFwaCUwQWZyb20lMjBsYW5nZ3JhcGgucHJlYnVpbHQlMjBpbXBvcnQlMjBUb29sTm9kZSUyQyUyMHRvb2xzX2NvbmRpdGlvbiUwQWZyb20lMjBJUHl0aG9uLmRpc3BsYXklMjBpbXBvcnQlMjBJbWFnZSUyQyUyMGRpc3BsYXk=",highlighted:`<span class="hljs-keyword">import</span> base64
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, TypedDict, Annotated, <span class="hljs-type">Optional</span>
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> AnyMessage, SystemMessage, HumanMessage
<span class="hljs-keyword">from</span> langgraph.graph.message <span class="hljs-keyword">import</span> add_messages
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> START, StateGraph
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> ToolNode, tools_condition
<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image, display`,wrap:!1}}),W=new j({props:{title:"Définir l’état de l’agent",local:"définir-létat-de-lagent",headingTag:"h2"}}),v=new T({props:{code:"Y2xhc3MlMjBBZ2VudFN0YXRlKFR5cGVkRGljdCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBMZSUyMGRvY3VtZW50JTIwZm91cm5pJTBBJTIwJTIwJTIwJTIwaW5wdXRfZmlsZSUzQSUyME9wdGlvbmFsJTVCc3RyJTVEJTIwJTIwJTIzJTIwQ29udGllbnQlMjBsZSUyMGNoZW1pbiUyMGR1JTIwZmljaGllciUyMChQREYlMkZQTkcpJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0ElMjBBbm5vdGF0ZWQlNUJsaXN0JTVCQW55TWVzc2FnZSU1RCUyQyUyMGFkZF9tZXNzYWdlcyU1RA==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">AgentState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    <span class="hljs-comment"># Le document fourni</span>
    input_file: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]  <span class="hljs-comment"># Contient le chemin du fichier (PDF/PNG)</span>
    messages: Annotated[<span class="hljs-built_in">list</span>[AnyMessage], add_messages]`,wrap:!1}}),X=new j({props:{title:"Préparer les outils",local:"préparer-les-outils",headingTag:"h2"}}),k=new T({props:{code:"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",highlighted:`vision_llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_text</span>(<span class="hljs-params">img_path: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Extraire le texte d&#x27;un fichier image en utilisant un modèle multimodal.
    
    Maître Wayne laisse souvent des notes avec son régime d&#x27;entraînement ou ses plans de repas.
    Cela me permet d&#x27;analyser correctement le contenu.
    &quot;&quot;&quot;</span>
    all_text = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Lire l&#x27;image et encoder en base64</span>
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(img_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> image_file:
            image_bytes = image_file.read()

        image_base64 = base64.b64encode(image_bytes).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)

        <span class="hljs-comment"># Préparer le prompt incluant les données d&#x27;image base64</span>
        message = [
            HumanMessage(
                content=[
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                        <span class="hljs-string">&quot;text&quot;</span>: (
                            <span class="hljs-string">&quot;Extrayez tout le texte de cette image. &quot;</span>
                            <span class="hljs-string">&quot;Retournez seulement le texte extrait, sans explications.&quot;</span>
                        ),
                    },
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                        <span class="hljs-string">&quot;image_url&quot;</span>: {
                            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">f&quot;data:image/png;base64,<span class="hljs-subst">{image_base64}</span>&quot;</span>
                        },
                    },
                ]
            )
        ]

        <span class="hljs-comment"># Appeler le VLM</span>
        response = vision_llm.invoke(message)

        <span class="hljs-comment"># Ajouter le texte extrait</span>
        all_text += response.content + <span class="hljs-string">&quot;\\n\\n&quot;</span>

        <span class="hljs-keyword">return</span> all_text.strip()
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-comment"># Un majordome doit gérer les erreurs avec élégance</span>
        error_msg = <span class="hljs-string">f&quot;Erreur lors de l&#x27;extraction du texte : <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
        <span class="hljs-built_in">print</span>(error_msg)
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">divide</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;Diviser a et b - pour les calculs occasionnels de Maître Wayne.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a / b

<span class="hljs-comment"># Équiper le majordome avec des outils</span>
tools = [
    divide,
    extract_text
]

llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)
llm_with_tools = llm.bind_tools(tools, parallel_tool_calls=<span class="hljs-literal">False</span>)`,wrap:!1}}),z=new j({props:{title:"Les nœuds",local:"les-nœuds",headingTag:"h2"}}),E=new T({props:{code:"ZGVmJTIwYXNzaXN0YW50KHN0YXRlJTNBJTIwQWdlbnRTdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBNZXNzYWdlJTIwc3lzdCVDMyVBOG1lJTBBJTIwJTIwJTIwJTIwdGV4dHVhbF9kZXNjcmlwdGlvbl9vZl90b29sJTNEJTIyJTIyJTIyJTBBZXh0cmFjdF90ZXh0KGltZ19wYXRoJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjBFeHRyYWlyZSUyMGxlJTIwdGV4dGUlMjBkJ3VuJTIwZmljaGllciUyMGltYWdlJTIwZW4lMjB1dGlsaXNhbnQlMjB1biUyMG1vZCVDMyVBOGxlJTIwbXVsdGltb2RhbC4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1nX3BhdGglM0ElMjBVbiUyMGNoZW1pbiUyMGRlJTIwZmljaGllciUyMGltYWdlJTIwbG9jYWwlMjAoY2hhJUMzJUFFbmVzKS4lMEElMEElMjAlMjAlMjAlMjBSZXR1cm5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVW5lJTIwY2hhJUMzJUFFbmUlMjB1bmlxdWUlMjBjb250ZW5hbnQlMjBsZSUyMHRleHRlJTIwY29uY2F0JUMzJUE5biVDMyVBOSUyMGV4dHJhaXQlMjBkZSUyMGNoYXF1ZSUyMGltYWdlLiUwQWRpdmlkZShhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwZmxvYXQlM0ElMEElMjAlMjAlMjAlMjBEaXZpc2VyJTIwYSUyMGV0JTIwYiUwQSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGltYWdlJTNEc3RhdGUlNUIlMjJpbnB1dF9maWxlJTIyJTVEJTBBJTIwJTIwJTIwJTIwc3lzX21zZyUyMCUzRCUyMFN5c3RlbU1lc3NhZ2UoY29udGVudCUzRGYlMjJWb3VzJTIwJUMzJUFBdGVzJTIwdW4lMjBtYWpvcmRvbWUlMjBzZXJ2aWFibGUlMjBub21tJUMzJUE5JTIwQWxmcmVkJTIwcXVpJTIwc2VydCUyME0uJTIwV2F5bmUlMjBldCUyMEJhdG1hbi4lMjBWb3VzJTIwcG91dmV6JTIwYW5hbHlzZXIlMjBkZXMlMjBkb2N1bWVudHMlMjBldCUyMGVmZmVjdHVlciUyMGRlcyUyMGNhbGN1bHMlMjBhdmVjJTIwbGVzJTIwb3V0aWxzJTIwZm91cm5pcyUyMCUzQSU1Q24lN0J0ZXh0dWFsX2Rlc2NyaXB0aW9uX29mX3Rvb2wlN0QlMjAlNUNuJTIwVm91cyUyMGF2ZXolMjBhY2MlQzMlQThzJTIwJUMzJUEwJTIwcXVlbHF1ZXMlMjBpbWFnZXMlMjBvcHRpb25uZWxsZXMuJTIwQWN0dWVsbGVtZW50JTIwbCdpbWFnZSUyMGNoYXJnJUMzJUE5ZSUyMGVzdCUyMCUzQSUyMCU3QmltYWdlJTdEJTIyKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1lc3NhZ2VzJTIyJTNBJTIwJTVCbGxtX3dpdGhfdG9vbHMuaW52b2tlKCU1QnN5c19tc2clNUQlMjAlMkIlMjBzdGF0ZSU1QiUyMm1lc3NhZ2VzJTIyJTVEKSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmlucHV0X2ZpbGUlMjIlM0ElMjBzdGF0ZSU1QiUyMmlucHV0X2ZpbGUlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">assistant</span>(<span class="hljs-params">state: AgentState</span>):
    <span class="hljs-comment"># Message système</span>
    textual_description_of_tool=<span class="hljs-string">&quot;&quot;&quot;
extract_text(img_path: str) -&gt; str:
    Extraire le texte d&#x27;un fichier image en utilisant un modèle multimodal.

    Args:
        img_path: Un chemin de fichier image local (chaînes).

    Returns:
        Une chaîne unique contenant le texte concaténé extrait de chaque image.
divide(a: int, b: int) -&gt; float:
    Diviser a et b
&quot;&quot;&quot;</span>
    image=state[<span class="hljs-string">&quot;input_file&quot;</span>]
    sys_msg = SystemMessage(content=<span class="hljs-string">f&quot;Vous êtes un majordome serviable nommé Alfred qui sert M. Wayne et Batman. Vous pouvez analyser des documents et effectuer des calculs avec les outils fournis :\\n<span class="hljs-subst">{textual_description_of_tool}</span> \\n Vous avez accès à quelques images optionnelles. Actuellement l&#x27;image chargée est : <span class="hljs-subst">{image}</span>&quot;</span>)

    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;messages&quot;</span>: [llm_with_tools.invoke([sys_msg] + state[<span class="hljs-string">&quot;messages&quot;</span>])],
        <span class="hljs-string">&quot;input_file&quot;</span>: state[<span class="hljs-string">&quot;input_file&quot;</span>]
    }`,wrap:!1}}),$=new j({props:{title:"Le modèle ReAct : Comment j’aide M. Wayne",local:"le-modèle-react--comment-jaide-m-wayne",headingTag:"h2"}}),N=new T({props:{code:"JTIzJTIwTGUlMjBncmFwaGUlMEFidWlsZGVyJTIwJTNEJTIwU3RhdGVHcmFwaChBZ2VudFN0YXRlKSUwQSUwQSUyMyUyMEQlQzMlQTlmaW5pciUyMGxlcyUyMG4lQzUlOTN1ZHMlMjAlM0ElMjBjZXV4LWNpJTIwZm9udCUyMGxlJTIwdHJhdmFpbCUwQWJ1aWxkZXIuYWRkX25vZGUoJTIyYXNzaXN0YW50JTIyJTJDJTIwYXNzaXN0YW50KSUwQWJ1aWxkZXIuYWRkX25vZGUoJTIydG9vbHMlMjIlMkMlMjBUb29sTm9kZSh0b29scykpJTBBJTBBJTIzJTIwRCVDMyVBOWZpbmlyJTIwbGVzJTIwYXIlQzMlQUF0ZXMlMjAlM0ElMjBjZWxsZXMtY2klMjBkJUMzJUE5dGVybWluZW50JTIwY29tbWVudCUyMGxlJTIwZmx1eCUyMGRlJTIwY29udHIlQzMlQjRsZSUyMHNlJTIwZCVDMyVBOXBsYWNlJTBBYnVpbGRlci5hZGRfZWRnZShTVEFSVCUyQyUyMCUyMmFzc2lzdGFudCUyMiklMEFidWlsZGVyLmFkZF9jb25kaXRpb25hbF9lZGdlcyglMEElMjAlMjAlMjAlMjAlMjJhc3Npc3RhbnQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjMlMjBTaSUyMGxlJTIwZGVybmllciUyMG1lc3NhZ2UlMjBuJUMzJUE5Y2Vzc2l0ZSUyMHVuJTIwb3V0aWwlMkMlMjByb3V0ZXIlMjB2ZXJzJTIwbGVzJTIwb3V0aWxzJTBBJTIwJTIwJTIwJTIwJTIzJTIwU2lub24lMkMlMjBmb3VybmlyJTIwdW5lJTIwciVDMyVBOXBvbnNlJTIwZGlyZWN0ZSUwQSUyMCUyMCUyMCUyMHRvb2xzX2NvbmRpdGlvbiUyQyUwQSklMEFidWlsZGVyLmFkZF9lZGdlKCUyMnRvb2xzJTIyJTJDJTIwJTIyYXNzaXN0YW50JTIyKSUwQXJlYWN0X2dyYXBoJTIwJTNEJTIwYnVpbGRlci5jb21waWxlKCklMEElMEElMjMlMjBNb250cmVyJTIwbGUlMjBwcm9jZXNzdXMlMjBkZSUyMHIlQzMlQTlmbGV4aW9uJTIwZHUlMjBtYWpvcmRvbWUlMEFkaXNwbGF5KEltYWdlKHJlYWN0X2dyYXBoLmdldF9ncmFwaCh4cmF5JTNEVHJ1ZSkuZHJhd19tZXJtYWlkX3BuZygpKSk=",highlighted:`<span class="hljs-comment"># Le graphe</span>
builder = StateGraph(AgentState)

<span class="hljs-comment"># Définir les nœuds : ceux-ci font le travail</span>
builder.add_node(<span class="hljs-string">&quot;assistant&quot;</span>, assistant)
builder.add_node(<span class="hljs-string">&quot;tools&quot;</span>, ToolNode(tools))

<span class="hljs-comment"># Définir les arêtes : celles-ci déterminent comment le flux de contrôle se déplace</span>
builder.add_edge(START, <span class="hljs-string">&quot;assistant&quot;</span>)
builder.add_conditional_edges(
    <span class="hljs-string">&quot;assistant&quot;</span>,
    <span class="hljs-comment"># Si le dernier message nécessite un outil, router vers les outils</span>
    <span class="hljs-comment"># Sinon, fournir une réponse directe</span>
    tools_condition,
)
builder.add_edge(<span class="hljs-string">&quot;tools&quot;</span>, <span class="hljs-string">&quot;assistant&quot;</span>)
react_graph = builder.<span class="hljs-built_in">compile</span>()

<span class="hljs-comment"># Montrer le processus de réflexion du majordome</span>
display(Image(react_graph.get_graph(xray=<span class="hljs-literal">True</span>).draw_mermaid_png()))`,wrap:!1}}),D=new j({props:{title:"Le majordome en action",local:"le-majordome-en-action",headingTag:"h2"}}),P=new j({props:{title:"Exemple 1 : Calculs simples",local:"exemple-1--calculs-simples",headingTag:"h3"}}),O=new T({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMkRpdmlzZXolMjA2NzkwJTIwcGFyJTIwNSUyMiklNUQlMEFtZXNzYWdlcyUyMCUzRCUyMHJlYWN0X2dyYXBoLmludm9rZSglN0IlMjJtZXNzYWdlcyUyMiUzQSUyMG1lc3NhZ2VzJTJDJTIwJTIyaW5wdXRfZmlsZSUyMiUzQSUyME5vbmUlN0QpJTBBJTBBJTIzJTIwTW9udHJlciUyMGxlcyUyMG1lc3NhZ2VzJTBBZm9yJTIwbSUyMGluJTIwbWVzc2FnZXMlNUInbWVzc2FnZXMnJTVEJTNBJTBBJTIwJTIwJTIwJTIwbS5wcmV0dHlfcHJpbnQoKQ==",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;Divisez 6790 par 5&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-literal">None</span>})

<span class="hljs-comment"># Montrer les messages</span>
<span class="hljs-keyword">for</span> m <span class="hljs-keyword">in</span> messages[<span class="hljs-string">&#x27;messages&#x27;</span>]:
    m.pretty_print()`,wrap:!1}}),el=new T({props:{code:"SHVtYWluJTIwJTNBJTIwRGl2aXNleiUyMDY3OTAlMjBwYXIlMjA1JTBBJTBBQXBwZWwlMjBkJ3VuJTIwb3V0aWwlMjAlM0ElMjBkaXZpZGUoYSUzRDY3OTAlMkMlMjBiJTNENSklMEElMEFSJUMzJUE5cG9uc2UlMjBkZSUyMGwnb3V0aWwlMjAlM0ElMjAxMzU4LjAlMEElMEFBbGZyZWQlMjAlM0ElMjBMZSUyMHIlQzMlQTlzdWx0YXQlMjBkZSUyMGxhJTIwZGl2aXNpb24lMjBkZSUyMDY3OTAlMjBwYXIlMjA1JTIwZXN0JTIwMTM1OC4wLg==",highlighted:`<span class="hljs-attribute">Humain</span> : Divisez <span class="hljs-number">6790</span> par <span class="hljs-number">5</span>

<span class="hljs-attribute">Appel</span> d&#x27;un outil : divide(a=<span class="hljs-number">6790</span>, b=<span class="hljs-number">5</span>)

<span class="hljs-attribute">R</span>éponse de l&#x27;outil : <span class="hljs-number">1358</span>.<span class="hljs-number">0</span>

<span class="hljs-attribute">Alfred</span> : Le résultat de la division de <span class="hljs-number">6790</span> par <span class="hljs-number">5</span> est <span class="hljs-number">1358</span>.<span class="hljs-number">0</span>.`,wrap:!1}}),sl=new j({props:{title:"Exemple 2 : Analyser les documents d’entraînement de Maître Wayne",local:"exemple-2--analyser-les-documents-dentraînement-de-maître-wayne",headingTag:"h3"}}),nl=new T({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMlNlbG9uJTIwbGElMjBub3RlJTIwZm91cm5pZSUyMHBhciUyME0uJTIwV2F5bmUlMjBkYW5zJTIwbGVzJTIwaW1hZ2VzJTIwZm91cm5pZXMuJTIwUXVlbGxlJTIwZXN0JTIwbGElMjBsaXN0ZSUyMGRlcyUyMGFydGljbGVzJTIwcXVlJTIwamUlMjBkb2lzJTIwYWNoZXRlciUyMHBvdXIlMjBsZSUyMG1lbnUlMjBkdSUyMGQlQzMlQUVuZXIlMjAlM0YlMjIpJTVEJTBBbWVzc2FnZXMlMjAlM0QlMjByZWFjdF9ncmFwaC5pbnZva2UoJTdCJTIybWVzc2FnZXMlMjIlM0ElMjBtZXNzYWdlcyUyQyUyMCUyMmlucHV0X2ZpbGUlMjIlM0ElMjAlMjJCYXRtYW5fdHJhaW5pbmdfYW5kX21lYWxzLnBuZyUyMiU3RCk=",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;Selon la note fournie par M. Wayne dans les images fournies. Quelle est la liste des articles que je dois acheter pour le menu du dîner ?&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-string">&quot;Batman_training_and_meals.png&quot;</span>})`,wrap:!1}}),Ml=new T({props:{code:"SHVtYWluJTIwJTNBJTIwU2Vsb24lMjBsYSUyMG5vdGUlMjBmb3VybmllJTIwcGFyJTIwTS4lMjBXYXluZSUyMGRhbnMlMjBsZXMlMjBpbWFnZXMlMjBmb3Vybmllcy4lMjBRdWVsbGUlMjBlc3QlMjBsYSUyMGxpc3RlJTIwZGVzJTIwYXJ0aWNsZXMlMjBxdWUlMjBqZSUyMGRvaXMlMjBhY2hldGVyJTIwcG91ciUyMGxlJTIwbWVudSUyMGR1JTIwZCVDMyVBRW5lciUyMCUzRiUwQSUwQUFwcGVsJTIwZCd1biUyMG91dGlsJTIwJTNBJTIwZXh0cmFjdF90ZXh0KGltZ19wYXRoJTNEJTIyQmF0bWFuX3RyYWluaW5nX2FuZF9tZWFscy5wbmclMjIpJTBBJTBBUiVDMyVBOXBvbnNlJTIwZGUlMjBsJ291dGlsJTIwJTNBJTIwJTVCVGV4dGUlMjBleHRyYWl0JTIwYXZlYyUyMGxlJTIwcHJvZ3JhbW1lJTIwZCdlbnRyYSVDMyVBRW5lbWVudCUyMGV0JTIwbGVzJTIwZCVDMyVBOXRhaWxzJTIwZHUlMjBtZW51JTVEJTBBJTBBQWxmcmVkJTIwJTNBJTIwUG91ciUyMGxlJTIwbWVudSUyMGR1JTIwZCVDMyVBRW5lciUyQyUyMHZvdXMlMjBkZXZyaWV6JTIwYWNoZXRlciUyMGxlcyUyMGFydGljbGVzJTIwc3VpdmFudHMlMjAlM0ElMEElMEExLiUyMFN0ZWFrJTIwZGUlMjBzdXJsb25nZSUyMGxvY2FsJTIwbm91cnJpJTIwJUMzJUEwJTIwbCdoZXJiZSUwQTIuJTIwJUMzJTg5cGluYXJkcyUyMGJpb2xvZ2lxdWVzJTBBMy4lMjBQb2l2cm9ucyUyMCpwaXF1aWxsbyolMEE0LiUyMFBvbW1lcyUyMGRlJTIwdGVycmUlMjAocG91ciUyMHBvbW1lcyUyMGRlJTIwdGVycmUlMjBhdXglMjBoZXJiZXMlMjBkb3IlQzMlQTllcyUyMGF1JTIwZm91ciklMEE1LiUyMEh1aWxlJTIwZGUlMjBwb2lzc29uJTIwKDIlMjBncmFtbWVzKSUwQSUwQUFzc3VyZXotdm91cyUyMHF1ZSUyMGxlJTIwc3RlYWslMjBzb2l0JTIwbm91cnJpJTIwJUMzJUEwJTIwbCdoZXJiZSUyMGV0JTIwcXVlJTIwbGVzJTIwJUMzJUE5cGluYXJkcyUyMGV0JTIwcG9pdnJvbnMlMjBzb2llbnQlMjBiaW9sb2dpcXVlcyUyMHBvdXIlMjB1biUyMHJlcGFzJTIwZGUlMjBsYSUyMG1laWxsZXVyZSUyMHF1YWxpdCVDMyVBOS4=",highlighted:`Humain : Selon <span class="hljs-keyword">la</span> <span class="hljs-keyword">note</span> fournie par <span class="hljs-keyword">M</span>. Wayne dans les images fournies. Quelle <span class="hljs-keyword">est</span> <span class="hljs-keyword">la</span> liste <span class="hljs-keyword">des</span> articles <span class="hljs-keyword">que</span> je dois acheter pour le menu du <span class="hljs-keyword">d</span>îner ?

Appel <span class="hljs-keyword">d</span>&#x27;un outil : extract_text(img_path=<span class="hljs-string">&quot;Batman_training_and_meals.png&quot;</span>)

Réponse <span class="hljs-keyword">de</span> <span class="hljs-keyword">l</span>&#x27;outil : [Texte extrait avec le programme <span class="hljs-keyword">d</span>&#x27;entraînement et les <span class="hljs-keyword">d</span>étails du menu]

Alfred : Pour le menu du <span class="hljs-keyword">d</span>îner, vous devriez acheter les articles suivants :

1. Steak <span class="hljs-keyword">de</span> surlonge <span class="hljs-keyword">local</span> nourri à <span class="hljs-keyword">l</span>&#x27;herbe
2. Épinards biologiques
3. Poivrons *piquillo*
4. Pommes <span class="hljs-keyword">de</span> terre (pour pommes <span class="hljs-keyword">de</span> terre aux herbes dorées au four)
5. Huile <span class="hljs-keyword">de</span> <span class="hljs-keyword">poisson</span> (2 grammes)

Assurez-vous <span class="hljs-keyword">que</span> le steak soit nourri à <span class="hljs-keyword">l</span>&#x27;herbe et <span class="hljs-keyword">que</span> les épinards et poivrons soient biologiques pour un repas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> meilleure qualité.`,wrap:!1}}),il=new j({props:{title:"Points clés à retenir",local:"points-clés-à-retenir",headingTag:"h2"}}),rl=new De({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/langgraph/document_analysis_agent.mdx"}}),{c(){w=M("meta"),jl=n(),Ul=M("p"),Tl=n(),y(c.$$.fragment),wl=n(),m=M("p"),m.textContent=je,dl=n(),I=M("p"),I.innerHTML=Te,cl=n(),C=M("p"),C.textContent=we,ml=n(),b=M("ol"),b.innerHTML=de,Il=n(),y(h.$$.fragment),Cl=n(),B=M("p"),B.innerHTML=ce,bl=n(),g=M("p"),g.innerHTML=me,hl=n(),d=M("blockquote"),d.innerHTML=Ie,Bl=n(),y(Z.$$.fragment),gl=n(),y(A.$$.fragment),Zl=n(),G=M("p"),G.textContent=Ce,Al=n(),y(f.$$.fragment),Gl=n(),y(W.$$.fragment),fl=n(),V=M("p"),V.innerHTML=be,Wl=n(),x=M("p"),x.textContent=he,Vl=n(),y(v.$$.fragment),xl=n(),y(X.$$.fragment),vl=n(),y(k.$$.fragment),Xl=n(),y(z.$$.fragment),kl=n(),y(E.$$.fragment),zl=n(),y($.$$.fragment),El=n(),Y=M("p"),Y.innerHTML=Be,$l=n(),Q=M("ol"),Q.innerHTML=ge,Yl=n(),S=M("p"),S.textContent=Ze,Ql=n(),y(N.$$.fragment),Sl=n(),R=M("p"),R.innerHTML=Ae,Nl=n(),F=M("p"),F.innerHTML=Ge,Rl=n(),_=M("p"),_.textContent=fe,Fl=n(),q=M("p"),q.innerHTML=We,_l=n(),H=M("ul"),H.innerHTML=Ve,ql=n(),L=M("p"),L.innerHTML=xe,Hl=n(),y(D.$$.fragment),Ll=n(),y(P.$$.fragment),Dl=n(),K=M("p"),K.textContent=ve,Pl=n(),y(O.$$.fragment),Kl=n(),ll=M("p"),ll.textContent=Xe,Ol=n(),y(el.$$.fragment),le=n(),y(sl.$$.fragment),ee=n(),tl=M("p"),tl.textContent=ke,se=n(),y(nl.$$.fragment),te=n(),al=M("p"),al.textContent=ze,ne=n(),y(Ml.$$.fragment),ae=n(),y(il.$$.fragment),Me=n(),pl=M("p"),pl.textContent=Ee,ie=n(),yl=M("ol"),yl.innerHTML=$e,pe=n(),ol=M("p"),ol.textContent=Ye,ye=n(),Jl=M("p"),Jl.innerHTML=Qe,oe=n(),y(rl.$$.fragment),Je=n(),ul=M("p"),this.h()},l(l){const e=He("svelte-u9bgzb",document.head);w=i(e,"META",{name:!0,content:!0}),e.forEach(s),jl=a(l),Ul=i(l,"P",{}),Se(Ul).forEach(s),Tl=a(l),o(c.$$.fragment,l),wl=a(l),m=i(l,"P",{"data-svelte-h":!0}),p(m)!=="svelte-gt557y"&&(m.textContent=je),dl=a(l),I=i(l,"P",{"data-svelte-h":!0}),p(I)!=="svelte-4j0gl0"&&(I.innerHTML=Te),cl=a(l),C=i(l,"P",{"data-svelte-h":!0}),p(C)!=="svelte-10fnikl"&&(C.textContent=we),ml=a(l),b=i(l,"OL",{"data-svelte-h":!0}),p(b)!=="svelte-1hsq04l"&&(b.innerHTML=de),Il=a(l),o(h.$$.fragment,l),Cl=a(l),B=i(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-3lt4u7"&&(B.innerHTML=ce),bl=a(l),g=i(l,"P",{"data-svelte-h":!0}),p(g)!=="svelte-g7cpwr"&&(g.innerHTML=me),hl=a(l),d=i(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(d)!=="svelte-1gbygqo"&&(d.innerHTML=Ie),Bl=a(l),o(Z.$$.fragment,l),gl=a(l),o(A.$$.fragment,l),Zl=a(l),G=i(l,"P",{"data-svelte-h":!0}),p(G)!=="svelte-x7jdgr"&&(G.textContent=Ce),Al=a(l),o(f.$$.fragment,l),Gl=a(l),o(W.$$.fragment,l),fl=a(l),V=i(l,"P",{"data-svelte-h":!0}),p(V)!=="svelte-19o7soi"&&(V.innerHTML=be),Wl=a(l),x=i(l,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1eaw1cp"&&(x.textContent=he),Vl=a(l),o(v.$$.fragment,l),xl=a(l),o(X.$$.fragment,l),vl=a(l),o(k.$$.fragment,l),Xl=a(l),o(z.$$.fragment,l),kl=a(l),o(E.$$.fragment,l),zl=a(l),o($.$$.fragment,l),El=a(l),Y=i(l,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-jejazg"&&(Y.innerHTML=Be),$l=a(l),Q=i(l,"OL",{"data-svelte-h":!0}),p(Q)!=="svelte-svdcrr"&&(Q.innerHTML=ge),Yl=a(l),S=i(l,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1h6mv9k"&&(S.textContent=Ze),Ql=a(l),o(N.$$.fragment,l),Sl=a(l),R=i(l,"P",{"data-svelte-h":!0}),p(R)!=="svelte-kp6yb5"&&(R.innerHTML=Ae),Nl=a(l),F=i(l,"P",{"data-svelte-h":!0}),p(F)!=="svelte-g1y7jt"&&(F.innerHTML=Ge),Rl=a(l),_=i(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-llapac"&&(_.textContent=fe),Fl=a(l),q=i(l,"P",{"data-svelte-h":!0}),p(q)!=="svelte-rl19lj"&&(q.innerHTML=We),_l=a(l),H=i(l,"UL",{"data-svelte-h":!0}),p(H)!=="svelte-ronwmj"&&(H.innerHTML=Ve),ql=a(l),L=i(l,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1nhlurw"&&(L.innerHTML=xe),Hl=a(l),o(D.$$.fragment,l),Ll=a(l),o(P.$$.fragment,l),Dl=a(l),K=i(l,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1521eea"&&(K.textContent=ve),Pl=a(l),o(O.$$.fragment,l),Kl=a(l),ll=i(l,"P",{"data-svelte-h":!0}),p(ll)!=="svelte-528ko8"&&(ll.textContent=Xe),Ol=a(l),o(el.$$.fragment,l),le=a(l),o(sl.$$.fragment,l),ee=a(l),tl=i(l,"P",{"data-svelte-h":!0}),p(tl)!=="svelte-1xfwie6"&&(tl.textContent=ke),se=a(l),o(nl.$$.fragment,l),te=a(l),al=i(l,"P",{"data-svelte-h":!0}),p(al)!=="svelte-1wf0zlb"&&(al.textContent=ze),ne=a(l),o(Ml.$$.fragment,l),ae=a(l),o(il.$$.fragment,l),Me=a(l),pl=i(l,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-1fpv4nj"&&(pl.textContent=Ee),ie=a(l),yl=i(l,"OL",{"data-svelte-h":!0}),p(yl)!=="svelte-frrqyp"&&(yl.innerHTML=$e),pe=a(l),ol=i(l,"P",{"data-svelte-h":!0}),p(ol)!=="svelte-1gn4t6x"&&(ol.textContent=Ye),ye=a(l),Jl=i(l,"P",{"data-svelte-h":!0}),p(Jl)!=="svelte-1fvnwmy"&&(Jl.innerHTML=Qe),oe=a(l),o(rl.$$.fragment,l),Je=a(l),ul=i(l,"P",{}),Se(ul).forEach(s),this.h()},h(){Ue(w,"name","hf:doc:metadata"),Ue(w,"content",Ke),Ue(d,"class","tip")},m(l,e){Le(document.head,w),t(l,jl,e),t(l,Ul,e),t(l,Tl,e),J(c,l,e),t(l,wl,e),t(l,m,e),t(l,dl,e),t(l,I,e),t(l,cl,e),t(l,C,e),t(l,ml,e),t(l,b,e),t(l,Il,e),J(h,l,e),t(l,Cl,e),t(l,B,e),t(l,bl,e),t(l,g,e),t(l,hl,e),t(l,d,e),t(l,Bl,e),J(Z,l,e),t(l,gl,e),J(A,l,e),t(l,Zl,e),t(l,G,e),t(l,Al,e),J(f,l,e),t(l,Gl,e),J(W,l,e),t(l,fl,e),t(l,V,e),t(l,Wl,e),t(l,x,e),t(l,Vl,e),J(v,l,e),t(l,xl,e),J(X,l,e),t(l,vl,e),J(k,l,e),t(l,Xl,e),J(z,l,e),t(l,kl,e),J(E,l,e),t(l,zl,e),J($,l,e),t(l,El,e),t(l,Y,e),t(l,$l,e),t(l,Q,e),t(l,Yl,e),t(l,S,e),t(l,Ql,e),J(N,l,e),t(l,Sl,e),t(l,R,e),t(l,Nl,e),t(l,F,e),t(l,Rl,e),t(l,_,e),t(l,Fl,e),t(l,q,e),t(l,_l,e),t(l,H,e),t(l,ql,e),t(l,L,e),t(l,Hl,e),J(D,l,e),t(l,Ll,e),J(P,l,e),t(l,Dl,e),t(l,K,e),t(l,Pl,e),J(O,l,e),t(l,Kl,e),t(l,ll,e),t(l,Ol,e),J(el,l,e),t(l,le,e),J(sl,l,e),t(l,ee,e),t(l,tl,e),t(l,se,e),J(nl,l,e),t(l,te,e),t(l,al,e),t(l,ne,e),J(Ml,l,e),t(l,ae,e),J(il,l,e),t(l,Me,e),t(l,pl,e),t(l,ie,e),t(l,yl,e),t(l,pe,e),t(l,ol,e),t(l,ye,e),t(l,Jl,e),t(l,oe,e),J(rl,l,e),t(l,Je,e),t(l,ul,e),re=!0},p:Re,i(l){re||(r(c.$$.fragment,l),r(h.$$.fragment,l),r(Z.$$.fragment,l),r(A.$$.fragment,l),r(f.$$.fragment,l),r(W.$$.fragment,l),r(v.$$.fragment,l),r(X.$$.fragment,l),r(k.$$.fragment,l),r(z.$$.fragment,l),r(E.$$.fragment,l),r($.$$.fragment,l),r(N.$$.fragment,l),r(D.$$.fragment,l),r(P.$$.fragment,l),r(O.$$.fragment,l),r(el.$$.fragment,l),r(sl.$$.fragment,l),r(nl.$$.fragment,l),r(Ml.$$.fragment,l),r(il.$$.fragment,l),r(rl.$$.fragment,l),re=!0)},o(l){U(c.$$.fragment,l),U(h.$$.fragment,l),U(Z.$$.fragment,l),U(A.$$.fragment,l),U(f.$$.fragment,l),U(W.$$.fragment,l),U(v.$$.fragment,l),U(X.$$.fragment,l),U(k.$$.fragment,l),U(z.$$.fragment,l),U(E.$$.fragment,l),U($.$$.fragment,l),U(N.$$.fragment,l),U(D.$$.fragment,l),U(P.$$.fragment,l),U(O.$$.fragment,l),U(el.$$.fragment,l),U(sl.$$.fragment,l),U(nl.$$.fragment,l),U(Ml.$$.fragment,l),U(il.$$.fragment,l),U(rl.$$.fragment,l),re=!1},d(l){l&&(s(jl),s(Ul),s(Tl),s(wl),s(m),s(dl),s(I),s(cl),s(C),s(ml),s(b),s(Il),s(Cl),s(B),s(bl),s(g),s(hl),s(d),s(Bl),s(gl),s(Zl),s(G),s(Al),s(Gl),s(fl),s(V),s(Wl),s(x),s(Vl),s(xl),s(vl),s(Xl),s(kl),s(zl),s(El),s(Y),s($l),s(Q),s(Yl),s(S),s(Ql),s(Sl),s(R),s(Nl),s(F),s(Rl),s(_),s(Fl),s(q),s(_l),s(H),s(ql),s(L),s(Hl),s(Ll),s(Dl),s(K),s(Pl),s(Kl),s(ll),s(Ol),s(le),s(ee),s(tl),s(se),s(te),s(al),s(ne),s(ae),s(Me),s(pl),s(ie),s(yl),s(pe),s(ol),s(ye),s(Jl),s(oe),s(Je),s(ul)),s(w),u(c,l),u(h,l),u(Z,l),u(A,l),u(f,l),u(W,l),u(v,l),u(X,l),u(k,l),u(z,l),u(E,l),u($,l),u(N,l),u(D,l),u(P,l),u(O,l),u(el,l),u(sl,l),u(nl,l),u(Ml,l),u(il,l),u(rl,l)}}}const Ke='{"title":"Graphe d’analyse de documents","local":"graphe-danalyse-de-documents","sections":[{"title":"Le workflow du majordome","local":"le-workflow-du-majordome","sections":[],"depth":2},{"title":"Configuration de l’environnement","local":"configuration-de-lenvironnement","sections":[],"depth":2},{"title":"Définir l’état de l’agent","local":"définir-létat-de-lagent","sections":[],"depth":2},{"title":"Préparer les outils","local":"préparer-les-outils","sections":[],"depth":2},{"title":"Les nœuds","local":"les-nœuds","sections":[],"depth":2},{"title":"Le modèle ReAct : Comment j’aide M. Wayne","local":"le-modèle-react--comment-jaide-m-wayne","sections":[],"depth":2},{"title":"Le majordome en action","local":"le-majordome-en-action","sections":[{"title":"Exemple 1 : Calculs simples","local":"exemple-1--calculs-simples","sections":[],"depth":3},{"title":"Exemple 2 : Analyser les documents d’entraînement de Maître Wayne","local":"exemple-2--analyser-les-documents-dentraînement-de-maître-wayne","sections":[],"depth":3}],"depth":2},{"title":"Points clés à retenir","local":"points-clés-à-retenir","sections":[],"depth":2}],"depth":1}';function Oe(ue){return Fe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class as extends _e{constructor(w){super(),qe(this,w,Oe,Pe,Ne,{})}}export{as as component};
