import{s as Ut,n as Jt,o as Zt}from"../chunks/scheduler.37c15a92.js";import{S as Gt,i as $t,g as i,s,r,m as ae,A as Ct,h as a,f as l,c as o,j as Fe,u as c,x as u,n as ue,k as te,y as b,a as n,v as p,d as m,t as d,w as M}from"../chunks/index.2bf4358c.js";import{C as le}from"../chunks/CodeBlock.4e987730.js";import{H as re}from"../chunks/Heading.8ada512a.js";import{E as Wt}from"../chunks/getInferenceSnippets.0aa3753f.js";function _t(et){let T,me,ce,de,j,Me,U,tt=`<strong>Définir un ensemble clair d’outils est crucial pour la performance.</strong> Comme nous l’avons discuté dans l’<a href="../../unit1/tools">Unité 1</a>, des interfaces claires sont plus faciles à utiliser pour les LLM.
Tout comme une interface API logicielle pour les ingénieurs humains, ils peuvent tirer profit de l’outil s’il est facile de comprendre comment il fonctionne.`,be,J,lt="Il y a <strong>quatre types principaux d’outils dans LlamaIndex</strong> :",fe,Z,nt='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/tools.png" alt="Tools"/>',ye,G,st="<li><code>FunctionTool</code> : Convertit n’importe quelle fonction Python en un outil qu’un agent peut utiliser. Il comprend automatiquement comment la fonction fonctionne.</li> <li><code>QueryEngineTool</code> : Un outil qui permet aux agents d’utiliser des <em>query engines</em>. Puisque les agents sont construits sur des <em>query engines</em>, ils peuvent également utiliser d’autres agents comme outil.</li> <li><code>Toolspecs</code> : Ensembles d’outils créés par la communauté, en incluant souvent pour des services spécifiques comme Gmail.</li> <li><code>Utility Tools</code> : Outils spéciaux qui aident à gérer de grandes quantités de données d’autres outils.</li>",Te,$,ot="Nous passerons en revue chacun d’eux plus en détail ci-dessous.",ve,C,he,v,it='<p>Vous pouvez suivre le code dans <a href="https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/llama-index/tools.ipynb" target="_blank">ce <i>notebook</i></a> que vous pouvez exécuter avec Google Colab.</p>',ge,W,at=`<em>FunctionTool</em> fournit un moyen simple d’envelopper n’importe quelle fonction Python et de la rendre disponible à un agent.
Vous pouvez passer soit une fonction synchrone soit asynchrone à l’outil, avec des paramètres optionnels <code>name</code> et <code>description</code>.
Le nom et la description sont particulièrement importants car ils aident l’agent à comprendre quand et comment utiliser l’outil efficacement.
Regardons comment créer un <em>FunctionTool</em> ci-dessous puis l’appeler.`,we,_,xe,h,ut='<p>Lors de l’utilisation d’un agent ou d’un LLM avec l’appel de fonctions, l’outil sélectionné (et les arguments écrits pour celui-ci) dépendent fortement de son nom, t de la description du but et des arguments. Apprenez-en plus sur l’appel de fonctions dans le <a href="https://docs.llamaindex.ai/en/stable/examples/workflow/function_calling_agent/">Guide sur l’appel de fonctions</a>.</p>',je,I,Ue,L,rt=`Le <code>QueryEngine</code> que nous avons défini dans l’unité précédente peut être facilement transformé en un outil en utilisant la classe <code>QueryEngineTool</code>.
Voyons comment créer un <code>QueryEngineTool</code> à partir d’un <code>QueryEngine</code> dans l’exemple ci-dessous.`,Je,V,Ze,B,Ge,H,ct=`Pensez au <code>ToolSpecs</code> comme des collections d’outils qui fonctionnent ensemble harmonieusement à l’instar d’une boîte à outils professionnelle bien organisée.
Tout comme la boîte à outils d’un mécanicien contient des outils complémentaires qui fonctionnent ensemble pour les réparations de véhicules, un <code>ToolSpec</code> combine des outils apparentés pour des objectifs spécifiques.
Par exemple, le <code>ToolSpec</code> d’un agent comptable pourrait intégrer élégamment des capacités de tableur, des fonctionnalités email et des outils de calcul pour gérer les tâches financières avec précision et efficacité.`,$e,f,ne,pt="Installer le <i>Toolspec</i> Google",ze,k,mt="section sur le <i>LlamaHub</i>",Pe,se,dt="toolspec",Ae,E,Ce,q,Mt="Et maintenant nous pouvons charger le <em>toolspec</em> et le convertir en une liste d’outils.",We,Q,_e,S,bt="Pour obtenir une vue plus détaillée des outils, nous pouvons examiner les <code>metadata</code> de chacun d’eux.",Ie,R,Le,N,Ve,Y,ft=`LlamaIndex permet également d’utiliser les outils <em>MCP</em> grâce à un <a href="https://llamahub.ai/l/tools/llama-index-tools-mcp?from=" rel="nofollow"><em>ToolSpec</em> sur le LlamaHub</a>.
Vous pouvez simplement lancer un serveur MCP et commencer à l’utiliser grâce à l’implémentation suivante.`,Be,X,yt='Si vous voulez approfondir MCP, vous pouvez consulter notre <a href="https://huggingface.co/learn/mcp-course/" rel="nofollow">cours gratuit</a>.',He,y,oe,Tt="Installer le <i>Toolspec</i> MCP",Ke,F,vt="section sur le LlamaHub",De,ie,ht="toolspec",Oe,z,ke,P,Ee,A,qe,K,gt=`Souvent, interroger directement une API <strong>peut retourner une quantité excessive de données</strong>, dont certaines peuvent être non pertinentes, déborder la fenêtre de contexte du LLM, ou augmenter inutilement le nombre de <em>tokens</em> que vous utilisez.
Passons en revue nos deux <em>utility tools</em> principaux ci-dessous.`,Qe,D,wt="<li><code>OnDemandToolLoader</code> : Cet outil transforme n’importe quel chargeur de données LlamaIndex existant (classe <em>BaseReader</em>) en un outil qu’un agent peut utiliser. Il peut être appelé avec tous les paramètres nécessaires pour déclencher <code>load_data</code> du chargeur de données, ainsi qu’une chaîne de requête en langage naturel. Pendant l’exécution, nous chargeons d’abord les données du chargeur de données, les indexons (par exemple avec un <em>vector store</em>), puis les interrogeons à la demande. Ces trois étapes se produisent dans un seul appel de l’outil.</li> <li><code>LoadAndSearchToolSpec</code> : Le <em>LoadAndSearchToolSpec</em> prend n’importe quel outil existant en entrée. En tant que <em>tool spec</em>, il implémente <code>to_tool_list</code>, et quand cette fonction est appelée, deux outils sont retournés : un outil de chargement puis un outil de recherche. L’exécution du premier appellerait l’outil sous-jacent, puis indexerait la sortie (par défaut avec un <em>vector index</em>). L’exécution du second prendrait une chaîne de requête en entrée et appellerait l’index sous-jacent.</li>",Se,g,xt='<p>Vous pouvez trouver des <i>toolspecs</i> et des <i>utility tools</i> sur le <a href="https://llamahub.ai/">LlamaHub</a>.</p>',Re,O,jt="Maintenant que nous comprenons les bases des agents et des outils dans LlamaIndex, voyons comment nous pouvons <strong>utiliser LlamaIndex pour créer des <em>workflows</em> configurables et gérables !</strong>",Ne,ee,Ye,pe,Xe;return j=new re({props:{title:"Utiliser les outils dans LlamaIndex",local:"utiliser-les-outils-dans-llamaindex",headingTag:"h1"}}),C=new re({props:{title:"Créer un FunctionTool",local:"créer-un-functiontool",headingTag:"h2"}}),_=new le({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUudG9vbHMlMjBpbXBvcnQlMjBGdW5jdGlvblRvb2wlMEElMEFkZWYlMjBnZXRfd2VhdGhlcihsb2NhdGlvbiUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyVXRpbGUlMjBwb3VyJTIwb2J0ZW5pciUyMGxlJTIwdGVtcHMlMjBxdSdpbCUyMGZhaXQlMjAlQzMlQTAlMjB1biUyMGVuZHJvaXQlMjBkb25uJUMzJUE5LiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJHZXR0aW5nJTIwd2VhdGhlciUyMGZvciUyMCU3QmxvY2F0aW9uJTdEJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGYlMjJUaGUlMjB3ZWF0aGVyJTIwaW4lMjAlN0Jsb2NhdGlvbiU3RCUyMGlzJTIwc3VubnklMjIlMEElMEF0b29sJTIwJTNEJTIwRnVuY3Rpb25Ub29sLmZyb21fZGVmYXVsdHMoJTBBJTIwJTIwJTIwJTIwZ2V0X3dlYXRoZXIlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIybXlfd2VhdGhlcl90b29sJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJVc2VmdWwlMjBmb3IlMjBnZXR0aW5nJTIwdGhlJTIwd2VhdGhlciUyMGZvciUyMGElMjBnaXZlbiUyMGxvY2F0aW9uLiUyMiUyQyUwQSklMEF0b29sLmNhbGwoJTIyTmV3JTIwWW9yayUyMik=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.tools <span class="hljs-keyword">import</span> FunctionTool

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Utile pour obtenir le temps qu&#x27;il fait à un endroit donné.&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Getting weather for <span class="hljs-subst">{location}</span>&quot;</span>)
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The weather in <span class="hljs-subst">{location}</span> is sunny&quot;</span>

tool = FunctionTool.from_defaults(
    get_weather,
    name=<span class="hljs-string">&quot;my_weather_tool&quot;</span>,
    description=<span class="hljs-string">&quot;Useful for getting the weather for a given location.&quot;</span>,
)
tool.call(<span class="hljs-string">&quot;New York&quot;</span>)`,wrap:!1}}),I=new re({props:{title:"Créer un QueryEngineTool",local:"créer-un-queryenginetool",headingTag:"h2"}}),V=new le({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBWZWN0b3JTdG9yZUluZGV4JTBBZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUudG9vbHMlMjBpbXBvcnQlMjBRdWVyeUVuZ2luZVRvb2wlMEFmcm9tJTIwbGxhbWFfaW5kZXgubGxtcy5odWdnaW5nZmFjZV9hcGklMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUluZmVyZW5jZUFQSSUwQWZyb20lMjBsbGFtYV9pbmRleC5lbWJlZGRpbmdzLmh1Z2dpbmdmYWNlJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmclMEFmcm9tJTIwbGxhbWFfaW5kZXgudmVjdG9yX3N0b3Jlcy5jaHJvbWElMjBpbXBvcnQlMjBDaHJvbWFWZWN0b3JTdG9yZSUwQSUwQWVtYmVkX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmcoJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyKSUwQSUwQWRiJTIwJTNEJTIwY2hyb21hZGIuUGVyc2lzdGVudENsaWVudChwYXRoJTNEJTIyLiUyRmFsZnJlZF9jaHJvbWFfZGIlMjIpJTBBY2hyb21hX2NvbGxlY3Rpb24lMjAlM0QlMjBkYi5nZXRfb3JfY3JlYXRlX2NvbGxlY3Rpb24oJTIyYWxmcmVkJTIyKSUwQXZlY3Rvcl9zdG9yZSUyMCUzRCUyMENocm9tYVZlY3RvclN0b3JlKGNocm9tYV9jb2xsZWN0aW9uJTNEY2hyb21hX2NvbGxlY3Rpb24pJTBBJTBBaW5kZXglMjAlM0QlMjBWZWN0b3JTdG9yZUluZGV4LmZyb21fdmVjdG9yX3N0b3JlKHZlY3Rvcl9zdG9yZSUyQyUyMGVtYmVkX21vZGVsJTNEZW1iZWRfbW9kZWwpJTBBJTBBbGxtJTIwJTNEJTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUEkobW9kZWxfbmFtZSUzRCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEFxdWVyeV9lbmdpbmUlMjAlM0QlMjBpbmRleC5hc19xdWVyeV9lbmdpbmUobGxtJTNEbGxtKSUwQXRvb2wlMjAlM0QlMjBRdWVyeUVuZ2luZVRvb2wuZnJvbV9kZWZhdWx0cyhxdWVyeV9lbmdpbmUlMkMlMjBuYW1lJTNEJTIyc29tZSUyMHVzZWZ1bCUyMG5hbWUlMjIlMkMlMjBkZXNjcmlwdGlvbiUzRCUyMnNvbWUlMjB1c2VmdWwlMjBkZXNjcmlwdGlvbiUyMik=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> VectorStoreIndex
<span class="hljs-keyword">from</span> llama_index.core.tools <span class="hljs-keyword">import</span> QueryEngineTool
<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI
<span class="hljs-keyword">from</span> llama_index.embeddings.huggingface <span class="hljs-keyword">import</span> HuggingFaceEmbedding
<span class="hljs-keyword">from</span> llama_index.vector_stores.chroma <span class="hljs-keyword">import</span> ChromaVectorStore

embed_model = HuggingFaceEmbedding(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)

db = chromadb.PersistentClient(path=<span class="hljs-string">&quot;./alfred_chroma_db&quot;</span>)
chroma_collection = db.get_or_create_collection(<span class="hljs-string">&quot;alfred&quot;</span>)
vector_store = ChromaVectorStore(chroma_collection=chroma_collection)

index = VectorStoreIndex.from_vector_store(vector_store, embed_model=embed_model)

llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
query_engine = index.as_query_engine(llm=llm)
tool = QueryEngineTool.from_defaults(query_engine, name=<span class="hljs-string">&quot;some useful name&quot;</span>, description=<span class="hljs-string">&quot;some useful description&quot;</span>)`,wrap:!1}}),B=new re({props:{title:"Créer un Toolspecs",local:"créer-un-toolspecs",headingTag:"h2"}}),E=new le({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXRvb2xzLWdvb2dsZQ==",highlighted:"pip install llama-index-tools-google",wrap:!1}}),Q=new le({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LnRvb2xzLmdvb2dsZSUyMGltcG9ydCUyMEdtYWlsVG9vbFNwZWMlMEElMEF0b29sX3NwZWMlMjAlM0QlMjBHbWFpbFRvb2xTcGVjKCklMEF0b29sX3NwZWNfbGlzdCUyMCUzRCUyMHRvb2xfc3BlYy50b190b29sX2xpc3QoKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.tools.google <span class="hljs-keyword">import</span> GmailToolSpec

tool_spec = GmailToolSpec()
tool_spec_list = tool_spec.to_tool_list()`,wrap:!1}}),R=new le({props:{code:"JTVCKHRvb2wubWV0YWRhdGEubmFtZSUyQyUyMHRvb2wubWV0YWRhdGEuZGVzY3JpcHRpb24pJTIwZm9yJTIwdG9vbCUyMGluJTIwdG9vbF9zcGVjX2xpc3QlNUQ=",highlighted:'[(tool.metadata.name, tool.metadata.description) <span class="hljs-keyword">for</span> tool <span class="hljs-keyword">in</span> tool_spec_list]',wrap:!1}}),N=new re({props:{title:"Model Context Protocol (MCP) dans LlamaIndex",local:"model-context-protocol-mcp-dans-llamaindex",headingTag:"h3"}}),z=new le({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXRvb2xzLW1jcA==",highlighted:"pip install llama-index-tools-mcp",wrap:!1}}),P=new le({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LnRvb2xzLm1jcCUyMGltcG9ydCUyMEJhc2ljTUNQQ2xpZW50JTJDJTIwTWNwVG9vbFNwZWMlMEElMEElMjMlMjBOb3VzJTIwY29uc2lkJUMzJUE5cm9ucyUyMHF1J3VuJTIwc2VydmV1ciUyMG1jcCUyMHRvdXJuZSUyMHN1ciUyMDEyNy4wLjAuMSUzQTgwMDAlMkMlMjBvdSUyMHZvdXMlMjBwb3V2ZXolMjB1dGlsaXNlciUyMGxlJTIwY2xpZW50JTIwbWNwJTIwcG91ciUyMHZvdXMlMjBjb25uZWN0ZXIlMjAlQzMlQTAlMjB2b3RyZSUyMHByb3ByZSUyMHNlcnZldXIlMEFtY3BfY2xpZW50JTIwJTNEJTIwQmFzaWNNQ1BDbGllbnQoJTIyaHR0cCUzQSUyRiUyRjEyNy4wLjAuMSUzQTgwMDAlMkZzc2UlMjIpJTBBbWNwX3Rvb2wlMjAlM0QlMjBNY3BUb29sU3BlYyhjbGllbnQlM0RtY3BfY2xpZW50KSUwQSUwQSUyMyUyMG9idGVuaXIlMjBsJ2FnZW50JTBBYWdlbnQlMjAlM0QlMjBhd2FpdCUyMGdldF9hZ2VudChtY3BfdG9vbCklMEElMEElMjMlMjBjciVDMyVBOWVyJTIwbGUlMjBjb250ZXh0ZSUyMGRlJTIwbCdhZ2VudCUwQWFnZW50X2NvbnRleHQlMjAlM0QlMjBDb250ZXh0KGFnZW50KQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.tools.mcp <span class="hljs-keyword">import</span> BasicMCPClient, McpToolSpec

<span class="hljs-comment"># Nous considérons qu&#x27;un serveur mcp tourne sur 127.0.0.1:8000, ou vous pouvez utiliser le client mcp pour vous connecter à votre propre serveur</span>
mcp_client = BasicMCPClient(<span class="hljs-string">&quot;http://127.0.0.1:8000/sse&quot;</span>)
mcp_tool = McpToolSpec(client=mcp_client)

<span class="hljs-comment"># obtenir l&#x27;agent</span>
agent = <span class="hljs-keyword">await</span> get_agent(mcp_tool)

<span class="hljs-comment"># créer le contexte de l&#x27;agent</span>
agent_context = Context(agent)`,wrap:!1}}),A=new re({props:{title:"Utility Tools",local:"utility-tools",headingTag:"h2"}}),ee=new Wt({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/llama-index/tools.mdx"}}),{c(){T=i("meta"),me=s(),ce=i("p"),de=s(),r(j.$$.fragment),Me=s(),U=i("p"),U.innerHTML=tt,be=s(),J=i("p"),J.innerHTML=lt,fe=s(),Z=i("p"),Z.innerHTML=nt,ye=s(),G=i("ol"),G.innerHTML=st,Te=s(),$=i("p"),$.textContent=ot,ve=s(),r(C.$$.fragment),he=s(),v=i("blockquote"),v.innerHTML=it,ge=s(),W=i("p"),W.innerHTML=at,we=s(),r(_.$$.fragment),xe=s(),h=i("blockquote"),h.innerHTML=ut,je=s(),r(I.$$.fragment),Ue=s(),L=i("p"),L.innerHTML=rt,Je=s(),r(V.$$.fragment),Ze=s(),r(B.$$.fragment),Ge=s(),H=i("p"),H.innerHTML=ct,$e=s(),f=i("details"),ne=i("summary"),ne.innerHTML=pt,ze=ae(`
Comme introduit dans la `),k=i("a"),k.innerHTML=mt,Pe=ae(", nous pouvons installer le "),se=i("i"),se.textContent=dt,Ae=ae(` Google avec la commande suivante :

	`),r(E.$$.fragment),Ce=s(),q=i("p"),q.innerHTML=Mt,We=s(),r(Q.$$.fragment),_e=s(),S=i("p"),S.innerHTML=bt,Ie=s(),r(R.$$.fragment),Le=s(),r(N.$$.fragment),Ve=s(),Y=i("p"),Y.innerHTML=ft,Be=s(),X=i("p"),X.innerHTML=yt,He=s(),y=i("details"),oe=i("summary"),oe.innerHTML=Tt,Ke=ae(`
Comme introduit dans la `),F=i("a"),F.textContent=vt,De=ae(", nous pouvons installer le "),ie=i("i"),ie.textContent=ht,Oe=ae(` MCP avec la commande suivante :

	`),r(z.$$.fragment),ke=s(),r(P.$$.fragment),Ee=s(),r(A.$$.fragment),qe=s(),K=i("p"),K.innerHTML=gt,Qe=s(),D=i("ol"),D.innerHTML=wt,Se=s(),g=i("blockquote"),g.innerHTML=xt,Re=s(),O=i("p"),O.innerHTML=jt,Ne=s(),r(ee.$$.fragment),Ye=s(),pe=i("p"),this.h()},l(e){const t=Ct("svelte-u9bgzb",document.head);T=a(t,"META",{name:!0,content:!0}),t.forEach(l),me=o(e),ce=a(e,"P",{}),Fe(ce).forEach(l),de=o(e),c(j.$$.fragment,e),Me=o(e),U=a(e,"P",{"data-svelte-h":!0}),u(U)!=="svelte-15xnf4h"&&(U.innerHTML=tt),be=o(e),J=a(e,"P",{"data-svelte-h":!0}),u(J)!=="svelte-1wwim52"&&(J.innerHTML=lt),fe=o(e),Z=a(e,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-ir2ii4"&&(Z.innerHTML=nt),ye=o(e),G=a(e,"OL",{"data-svelte-h":!0}),u(G)!=="svelte-rue757"&&(G.innerHTML=st),Te=o(e),$=a(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-se2hf"&&($.textContent=ot),ve=o(e),c(C.$$.fragment,e),he=o(e),v=a(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(v)!=="svelte-1ebr7g6"&&(v.innerHTML=it),ge=o(e),W=a(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-cm71ui"&&(W.innerHTML=at),we=o(e),c(_.$$.fragment,e),xe=o(e),h=a(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(h)!=="svelte-1mmp11s"&&(h.innerHTML=ut),je=o(e),c(I.$$.fragment,e),Ue=o(e),L=a(e,"P",{"data-svelte-h":!0}),u(L)!=="svelte-4ddxlo"&&(L.innerHTML=rt),Je=o(e),c(V.$$.fragment,e),Ze=o(e),c(B.$$.fragment,e),Ge=o(e),H=a(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-17051kk"&&(H.innerHTML=ct),$e=o(e),f=a(e,"DETAILS",{});var w=Fe(f);ne=a(w,"SUMMARY",{"data-svelte-h":!0}),u(ne)!=="svelte-17se9ce"&&(ne.innerHTML=pt),ze=ue(w,`
Comme introduit dans la `),k=a(w,"A",{href:!0,"data-svelte-h":!0}),u(k)!=="svelte-12hnzv1"&&(k.innerHTML=mt),Pe=ue(w,", nous pouvons installer le "),se=a(w,"I",{"data-svelte-h":!0}),u(se)!=="svelte-x626tz"&&(se.textContent=dt),Ae=ue(w,` Google avec la commande suivante :

	`),c(E.$$.fragment,w),w.forEach(l),Ce=o(e),q=a(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-hwh0jr"&&(q.innerHTML=Mt),We=o(e),c(Q.$$.fragment,e),_e=o(e),S=a(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-w2dupu"&&(S.innerHTML=bt),Ie=o(e),c(R.$$.fragment,e),Le=o(e),c(N.$$.fragment,e),Ve=o(e),Y=a(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-143kyx2"&&(Y.innerHTML=ft),Be=o(e),X=a(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-1yipqfs"&&(X.innerHTML=yt),He=o(e),y=a(e,"DETAILS",{});var x=Fe(y);oe=a(x,"SUMMARY",{"data-svelte-h":!0}),u(oe)!=="svelte-wxegrp"&&(oe.innerHTML=Tt),Ke=ue(x,`
Comme introduit dans la `),F=a(x,"A",{href:!0,"data-svelte-h":!0}),u(F)!=="svelte-1pl43ly"&&(F.textContent=vt),De=ue(x,", nous pouvons installer le "),ie=a(x,"I",{"data-svelte-h":!0}),u(ie)!=="svelte-x626tz"&&(ie.textContent=ht),Oe=ue(x,` MCP avec la commande suivante :

	`),c(z.$$.fragment,x),x.forEach(l),ke=o(e),c(P.$$.fragment,e),Ee=o(e),c(A.$$.fragment,e),qe=o(e),K=a(e,"P",{"data-svelte-h":!0}),u(K)!=="svelte-ionwur"&&(K.innerHTML=gt),Qe=o(e),D=a(e,"OL",{"data-svelte-h":!0}),u(D)!=="svelte-l1aj58"&&(D.innerHTML=wt),Se=o(e),g=a(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(g)!=="svelte-hr06my"&&(g.innerHTML=xt),Re=o(e),O=a(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-pi31wf"&&(O.innerHTML=jt),Ne=o(e),c(ee.$$.fragment,e),Ye=o(e),pe=a(e,"P",{}),Fe(pe).forEach(l),this.h()},h(){te(T,"name","hf:doc:metadata"),te(T,"content",It),te(v,"class","tip"),te(h,"class","tip"),te(k,"href","./llama-hub"),te(F,"href","./llama-hub"),te(g,"class","tip")},m(e,t){b(document.head,T),n(e,me,t),n(e,ce,t),n(e,de,t),p(j,e,t),n(e,Me,t),n(e,U,t),n(e,be,t),n(e,J,t),n(e,fe,t),n(e,Z,t),n(e,ye,t),n(e,G,t),n(e,Te,t),n(e,$,t),n(e,ve,t),p(C,e,t),n(e,he,t),n(e,v,t),n(e,ge,t),n(e,W,t),n(e,we,t),p(_,e,t),n(e,xe,t),n(e,h,t),n(e,je,t),p(I,e,t),n(e,Ue,t),n(e,L,t),n(e,Je,t),p(V,e,t),n(e,Ze,t),p(B,e,t),n(e,Ge,t),n(e,H,t),n(e,$e,t),n(e,f,t),b(f,ne),b(f,ze),b(f,k),b(f,Pe),b(f,se),b(f,Ae),p(E,f,null),n(e,Ce,t),n(e,q,t),n(e,We,t),p(Q,e,t),n(e,_e,t),n(e,S,t),n(e,Ie,t),p(R,e,t),n(e,Le,t),p(N,e,t),n(e,Ve,t),n(e,Y,t),n(e,Be,t),n(e,X,t),n(e,He,t),n(e,y,t),b(y,oe),b(y,Ke),b(y,F),b(y,De),b(y,ie),b(y,Oe),p(z,y,null),n(e,ke,t),p(P,e,t),n(e,Ee,t),p(A,e,t),n(e,qe,t),n(e,K,t),n(e,Qe,t),n(e,D,t),n(e,Se,t),n(e,g,t),n(e,Re,t),n(e,O,t),n(e,Ne,t),p(ee,e,t),n(e,Ye,t),n(e,pe,t),Xe=!0},p:Jt,i(e){Xe||(m(j.$$.fragment,e),m(C.$$.fragment,e),m(_.$$.fragment,e),m(I.$$.fragment,e),m(V.$$.fragment,e),m(B.$$.fragment,e),m(E.$$.fragment,e),m(Q.$$.fragment,e),m(R.$$.fragment,e),m(N.$$.fragment,e),m(z.$$.fragment,e),m(P.$$.fragment,e),m(A.$$.fragment,e),m(ee.$$.fragment,e),Xe=!0)},o(e){d(j.$$.fragment,e),d(C.$$.fragment,e),d(_.$$.fragment,e),d(I.$$.fragment,e),d(V.$$.fragment,e),d(B.$$.fragment,e),d(E.$$.fragment,e),d(Q.$$.fragment,e),d(R.$$.fragment,e),d(N.$$.fragment,e),d(z.$$.fragment,e),d(P.$$.fragment,e),d(A.$$.fragment,e),d(ee.$$.fragment,e),Xe=!1},d(e){e&&(l(me),l(ce),l(de),l(Me),l(U),l(be),l(J),l(fe),l(Z),l(ye),l(G),l(Te),l($),l(ve),l(he),l(v),l(ge),l(W),l(we),l(xe),l(h),l(je),l(Ue),l(L),l(Je),l(Ze),l(Ge),l(H),l($e),l(f),l(Ce),l(q),l(We),l(_e),l(S),l(Ie),l(Le),l(Ve),l(Y),l(Be),l(X),l(He),l(y),l(ke),l(Ee),l(qe),l(K),l(Qe),l(D),l(Se),l(g),l(Re),l(O),l(Ne),l(Ye),l(pe)),l(T),M(j,e),M(C,e),M(_,e),M(I,e),M(V,e),M(B,e),M(E),M(Q,e),M(R,e),M(N,e),M(z),M(P,e),M(A,e),M(ee,e)}}}const It='{"title":"Utiliser les outils dans LlamaIndex","local":"utiliser-les-outils-dans-llamaindex","sections":[{"title":"Créer un FunctionTool","local":"créer-un-functiontool","sections":[],"depth":2},{"title":"Créer un QueryEngineTool","local":"créer-un-queryenginetool","sections":[],"depth":2},{"title":"Créer un Toolspecs","local":"créer-un-toolspecs","sections":[{"title":"Model Context Protocol (MCP) dans LlamaIndex","local":"model-context-protocol-mcp-dans-llamaindex","sections":[],"depth":3}],"depth":2},{"title":"Utility Tools","local":"utility-tools","sections":[],"depth":2}],"depth":1}';function Lt(et){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qt extends Gt{constructor(T){super(),$t(this,T,Lt,_t,Ut,{})}}export{qt as component};
