import{s as ge,f as He,n as Ae,o as Be}from"../chunks/scheduler.37c15a92.js";import{S as Le,i as Ze,g as i,s,r as Y,A as Se,h as p,f as l,c as a,j as $e,u as z,x as u,k as O,y as Pe,a as n,v as K,d as D,t as tt,w as et}from"../chunks/index.2bf4358c.js";import{C as Ie}from"../chunks/CodeBlock.4e987730.js";import{H as Qt}from"../chunks/Heading.8ada512a.js";import{E as Ee}from"../chunks/getInferenceSnippets.0aa3753f.js";function Ge(Yt){let M,st,lt,at,y,it,r,zt="<p>在本节中，我们将探讨 AI 智能体 (AI agent) 与其环境交互的具体步骤。</p> <p>我们将介绍动作 (actions) 如何被表示（使用 JSON 或代码），停止和解析方法 (stop and parse approach) 的重要性，以及不同类型的智能体。</p>",pt,C,Ot="动作是<strong>AI 智能体 (AI agent) 与其环境交互的具体步骤</strong>。",ut,f,Kt="无论是浏览网络获取信息还是控制物理设备，每个动作都是智能体执行的一个特定操作。",Mt,h,Dt="例如，一个协助客户服务的智能体可能会检索客户数据、提供支持文章或将问题转交给人工代表。",rt,U,ot,j,te="有多种类型的智能体采用不同的方式执行动作：",mt,T,ee="<thead><tr><th>智能体类型</th> <th>描述</th></tr></thead> <tbody><tr><td>JSON 智能体 (JSON Agent)</td> <td>要执行的动作以 JSON 格式指定。</td></tr> <tr><td>代码智能体 (Code Agent)</td> <td>智能体编写代码块，由外部解释执行。</td></tr> <tr><td>函数调用智能体 (Function-calling Agent)</td> <td>这是 JSON 智能体的一个子类别，经过微调以为每个动作生成新消息。</td></tr></tbody>",yt,d,le="动作本身可以服务于多种目的：",Ct,v,ne="<thead><tr><th>动作类型</th> <th>描述</th></tr></thead> <tbody><tr><td>信息收集 (Information Gathering)</td> <td>执行网络搜索、查询数据库或检索文档。</td></tr> <tr><td>工具使用 (Tool Usage)</td> <td>进行 API 调用、运行计算和执行代码。</td></tr> <tr><td>环境交互 (Environment Interaction)</td> <td>操作数字界面或控制物理设备。</td></tr> <tr><td>通信 (Communication)</td> <td>通过聊天与用户互动或与其他智能体协作。</td></tr></tbody>",ft,c,se="智能体的一个关键部分是<strong>在动作完成时能够停止生成新的标记 (tokens)</strong>，这对所有格式的智能体都适用：JSON、代码或函数调用。这可以防止意外输出并确保智能体的响应清晰准确。",ht,w,ae="大语言模型 (LLM) 只处理文本，并使用它来描述它想要采取的动作以及要提供给工具的参数。",Ut,x,jt,J,ie="实现动作的一个关键方法是<strong>停止和解析方法</strong>。这种方法确保智能体的输出具有结构性和可预测性：",Tt,_,pe="<li><strong>以结构化格式生成 (Generation in a Structured Format)</strong>：</li>",dt,b,ue="智能体以清晰、预定义的格式（JSON或代码）输出其预期动作。",vt,o,Me="<li><strong>停止进一步生成 (Halting Further Generation)</strong>：</li>",ct,$,re="一旦动作完成，<strong>智能体停止生成额外的标记</strong>。这可以防止额外或错误的输出。",wt,m,oe="<li><strong>解析输出 (Parsing the Output)</strong>：</li>",xt,I,me="外部解析器读取格式化的动作，确定要调用哪个工具，并提取所需的参数。",Jt,g,ye="例如，需要检查天气的智能体可能输出：",_t,H,bt,A,Ce="然后框架可以轻松解析要调用的函数名称和要应用的参数。",$t,B,fe="这种清晰的、机器可读的格式最大限度地减少了错误，并使外部工具能够准确处理智能体的命令。",It,L,he=`注意：函数调用智能体的操作方式类似，通过构造每个动作，使指定的函数能够使用正确的参数被调用。
我们将在未来的单元中深入探讨这些类型的智能体。`,gt,Z,Ht,S,Ue=`另一种方法是使用<em>代码智能体</em>。
这个想法是：<strong>代码智能体不是输出简单的 JSON 对象</strong>，而是生成一个<strong>可执行的代码块——通常使用 Python 等高级语言</strong>。`,At,P,je,Bt,E,Te="这种方法提供了几个优势：",Lt,G,de="<li><strong>表达能力 (Expressiveness)：</strong> 代码可以自然地表示复杂的逻辑，包括循环、条件和嵌套函数，提供比 JSON 更大的灵活性。</li> <li><strong>模块化和可重用性 (Modularity and Reusability)：</strong> 生成的代码可以包含在不同动作或任务中可重用的函数和模块。</li> <li><strong>增强的可调试性 (Enhanced Debuggability)：</strong> 使用明确定义的编程语法，代码错误通常更容易检测和纠正。</li> <li><strong>直接集成 (Direct Integration)：</strong> 代码智能体可以直接与外部库和 API 集成，实现更复杂的操作，如数据处理或实时决策。</li>",Zt,k,ve="例如，一个负责获取天气的代码智能体可能生成以下 Python 代码片段：",St,q,Pt,N,ce="在这个例子中，代码智能体：",Et,F,we="<li><strong>通过API调用</strong>获取天气数据，</li> <li>处理响应，</li> <li>并使用print()函数输出最终答案。</li>",Gt,V,xe="这种方法<strong>也遵循停止和解析方法</strong>，通过明确划定代码块并表明执行完成的时间（在这里，通过打印 final_answer）。",kt,qt,Nt,W,Je="我们了解到动作通过执行清晰、结构化的任务（无论是通过 JSON、代码还是函数调用）来连接智能体的内部推理和其现实世界的交互。",Ft,R,_e="这种深思熟虑的执行确保每个动作都是精确的，并通过停止和解析方法准备好进行外部处理。在下一节中，我们将探索观察 (Observations)，看看智能体如何捕获和整合来自其环境的反馈。",Vt,X,be="在此之后，我们将<strong>最终准备好构建我们的第一个智能体！</strong>",Wt,Q,Rt,nt,Xt;return y=new Qt({props:{title:"动作：使智能体能够与环境交互",local:"动作使智能体能够与环境交互",headingTag:"h1"}}),U=new Qt({props:{title:"智能体动作的类型 (Types of Agent Actions)",local:"智能体动作的类型-types-of-agent-actions",headingTag:"h2"}}),x=new Qt({props:{title:"停止和解析方法 (The Stop and Parse Approach)",local:"停止和解析方法-the-stop-and-parse-approach",headingTag:"h2"}}),H=new Ie({props:{code:"VGhvdWdodCUzQSUyMEklMjBuZWVkJTIwdG8lMjBjaGVjayUyMHRoZSUyMGN1cnJlbnQlMjB3ZWF0aGVyJTIwZm9yJTIwTmV3JTIwWW9yay4lMEFBY3Rpb24lMjAlM0ElMEElN0IlMEElMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjAlMjJnZXRfd2VhdGhlciUyMiUyQyUwQSUyMCUyMCUyMmFjdGlvbl9pbnB1dCUyMiUzQSUyMCU3QiUyMmxvY2F0aW9uJTIyJTNBJTIwJTIyTmV3JTIwWW9yayUyMiU3RCUwQSU3RA==",highlighted:`Thought<span class="hljs-punctuation">:</span> I need to check the current weather for New York.
Action <span class="hljs-punctuation">:</span>
<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_weather&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;action_input&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;New York&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Z=new Qt({props:{title:"代码智能体 (Code Agents)",local:"代码智能体-code-agents",headingTag:"h2"}}),q=new Ie({props:{code:"JTIzJTIwQ29kZSUyMEFnZW50JTIwRXhhbXBsZSUzQSUyMFJldHJpZXZlJTIwV2VhdGhlciUyMEluZm9ybWF0aW9uJTBBZGVmJTIwZ2V0X3dlYXRoZXIoY2l0eSklM0ElMEElMjAlMjAlMjAlMjBpbXBvcnQlMjByZXF1ZXN0cyUwQSUyMCUyMCUyMCUyMGFwaV91cmwlMjAlM0QlMjBmJTIyaHR0cHMlM0ElMkYlMkZhcGkud2VhdGhlci5jb20lMkZ2MSUyRmxvY2F0aW9uJTJGJTdCY2l0eSU3RCUzRmFwaUtleSUzRFlPVVJfQVBJX0tFWSUyMiUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KGFwaV91cmwpJTBBJTIwJTIwJTIwJTIwaWYlMjByZXNwb25zZS5zdGF0dXNfY29kZSUyMCUzRCUzRCUyMDIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGElMjAlM0QlMjByZXNwb25zZS5qc29uKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBkYXRhLmdldCglMjJ3ZWF0aGVyJTIyJTJDJTIwJTIyTm8lMjB3ZWF0aGVyJTIwaW5mb3JtYXRpb24lMjBhdmFpbGFibGUlMjIpJTBBJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMkVycm9yJTNBJTIwVW5hYmxlJTIwdG8lMjBmZXRjaCUyMHdlYXRoZXIlMjBkYXRhLiUyMiUwQSUwQSUyMyUyMEV4ZWN1dGUlMjB0aGUlMjBmdW5jdGlvbiUyMGFuZCUyMHByZXBhcmUlMjB0aGUlMjBmaW5hbCUyMGFuc3dlciUwQXJlc3VsdCUyMCUzRCUyMGdldF93ZWF0aGVyKCUyMk5ldyUyMFlvcmslMjIpJTBBZmluYWxfYW5zd2VyJTIwJTNEJTIwZiUyMlRoZSUyMGN1cnJlbnQlMjB3ZWF0aGVyJTIwaW4lMjBOZXclMjBZb3JrJTIwaXMlM0ElMjAlN0JyZXN1bHQlN0QlMjIlMEFwcmludChmaW5hbF9hbnN3ZXIp",highlighted:`<span class="hljs-comment"># Code Agent Example: Retrieve Weather Information</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather</span>(<span class="hljs-params">city</span>):
    <span class="hljs-keyword">import</span> requests
    api_url = <span class="hljs-string">f&quot;https://api.weather.com/v1/location/<span class="hljs-subst">{city}</span>?apiKey=YOUR_API_KEY&quot;</span>
    response = requests.get(api_url)
    <span class="hljs-keyword">if</span> response.status_code == <span class="hljs-number">200</span>:
        data = response.json()
        <span class="hljs-keyword">return</span> data.get(<span class="hljs-string">&quot;weather&quot;</span>, <span class="hljs-string">&quot;No weather information available&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Error: Unable to fetch weather data.&quot;</span>

<span class="hljs-comment"># Execute the function and prepare the final answer</span>
result = get_weather(<span class="hljs-string">&quot;New York&quot;</span>)
final_answer = <span class="hljs-string">f&quot;The current weather in New York is: <span class="hljs-subst">{result}</span>&quot;</span>
<span class="hljs-built_in">print</span>(final_answer)`,wrap:!1}}),Q=new Ee({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/zh-CN/unit1/actions.mdx"}}),{c(){M=i("meta"),st=s(),lt=i("p"),at=s(),Y(y.$$.fragment),it=s(),r=i("blockquote"),r.innerHTML=zt,pt=s(),C=i("p"),C.innerHTML=Ot,ut=s(),f=i("p"),f.textContent=Kt,Mt=s(),h=i("p"),h.textContent=Dt,rt=s(),Y(U.$$.fragment),ot=s(),j=i("p"),j.textContent=te,mt=s(),T=i("table"),T.innerHTML=ee,yt=s(),d=i("p"),d.textContent=le,Ct=s(),v=i("table"),v.innerHTML=ne,ft=s(),c=i("p"),c.innerHTML=se,ht=s(),w=i("p"),w.textContent=ae,Ut=s(),Y(x.$$.fragment),jt=s(),J=i("p"),J.innerHTML=ie,Tt=s(),_=i("ol"),_.innerHTML=pe,dt=s(),b=i("p"),b.textContent=ue,vt=s(),o=i("ol"),o.innerHTML=Me,ct=s(),$=i("p"),$.innerHTML=re,wt=s(),m=i("ol"),m.innerHTML=oe,xt=s(),I=i("p"),I.textContent=me,Jt=s(),g=i("p"),g.textContent=ye,_t=s(),Y(H.$$.fragment),bt=s(),A=i("p"),A.textContent=Ce,$t=s(),B=i("p"),B.textContent=fe,It=s(),L=i("p"),L.textContent=he,gt=s(),Y(Z.$$.fragment),Ht=s(),S=i("p"),S.innerHTML=Ue,At=s(),P=i("img"),Bt=s(),E=i("p"),E.textContent=Te,Lt=s(),G=i("ul"),G.innerHTML=de,Zt=s(),k=i("p"),k.textContent=ve,St=s(),Y(q.$$.fragment),Pt=s(),N=i("p"),N.textContent=ce,Et=s(),F=i("ul"),F.innerHTML=we,Gt=s(),V=i("p"),V.innerHTML=xe,kt=s(),qt=i("hr"),Nt=s(),W=i("p"),W.textContent=Je,Ft=s(),R=i("p"),R.textContent=_e,Vt=s(),X=i("p"),X.innerHTML=be,Wt=s(),Y(Q.$$.fragment),Rt=s(),nt=i("p"),this.h()},l(t){const e=Se("svelte-u9bgzb",document.head);M=p(e,"META",{name:!0,content:!0}),e.forEach(l),st=a(t),lt=p(t,"P",{}),$e(lt).forEach(l),at=a(t),z(y.$$.fragment,t),it=a(t),r=p(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(r)!=="svelte-1lczjqr"&&(r.innerHTML=zt),pt=a(t),C=p(t,"P",{"data-svelte-h":!0}),u(C)!=="svelte-1oehl0b"&&(C.innerHTML=Ot),ut=a(t),f=p(t,"P",{"data-svelte-h":!0}),u(f)!=="svelte-rr84pc"&&(f.textContent=Kt),Mt=a(t),h=p(t,"P",{"data-svelte-h":!0}),u(h)!=="svelte-11t7hmz"&&(h.textContent=Dt),rt=a(t),z(U.$$.fragment,t),ot=a(t),j=p(t,"P",{"data-svelte-h":!0}),u(j)!=="svelte-ds768v"&&(j.textContent=te),mt=a(t),T=p(t,"TABLE",{"data-svelte-h":!0}),u(T)!=="svelte-1mmjhb8"&&(T.innerHTML=ee),yt=a(t),d=p(t,"P",{"data-svelte-h":!0}),u(d)!=="svelte-1apkq8u"&&(d.textContent=le),Ct=a(t),v=p(t,"TABLE",{"data-svelte-h":!0}),u(v)!=="svelte-5xk6bp"&&(v.innerHTML=ne),ft=a(t),c=p(t,"P",{"data-svelte-h":!0}),u(c)!=="svelte-nvl6b4"&&(c.innerHTML=se),ht=a(t),w=p(t,"P",{"data-svelte-h":!0}),u(w)!=="svelte-1r3a9ht"&&(w.textContent=ae),Ut=a(t),z(x.$$.fragment,t),jt=a(t),J=p(t,"P",{"data-svelte-h":!0}),u(J)!=="svelte-1czk6yh"&&(J.innerHTML=ie),Tt=a(t),_=p(t,"OL",{"data-svelte-h":!0}),u(_)!=="svelte-1swx0r1"&&(_.innerHTML=pe),dt=a(t),b=p(t,"P",{"data-svelte-h":!0}),u(b)!=="svelte-5yuo8q"&&(b.textContent=ue),vt=a(t),o=p(t,"OL",{start:!0,"data-svelte-h":!0}),u(o)!=="svelte-7hhw08"&&(o.innerHTML=Me),ct=a(t),$=p(t,"P",{"data-svelte-h":!0}),u($)!=="svelte-s8iucv"&&($.innerHTML=re),wt=a(t),m=p(t,"OL",{start:!0,"data-svelte-h":!0}),u(m)!=="svelte-4g9ysl"&&(m.innerHTML=oe),xt=a(t),I=p(t,"P",{"data-svelte-h":!0}),u(I)!=="svelte-1hnrlul"&&(I.textContent=me),Jt=a(t),g=p(t,"P",{"data-svelte-h":!0}),u(g)!=="svelte-f9j747"&&(g.textContent=ye),_t=a(t),z(H.$$.fragment,t),bt=a(t),A=p(t,"P",{"data-svelte-h":!0}),u(A)!=="svelte-lwcx4v"&&(A.textContent=Ce),$t=a(t),B=p(t,"P",{"data-svelte-h":!0}),u(B)!=="svelte-1a21p42"&&(B.textContent=fe),It=a(t),L=p(t,"P",{"data-svelte-h":!0}),u(L)!=="svelte-1ad2rct"&&(L.textContent=he),gt=a(t),z(Z.$$.fragment,t),Ht=a(t),S=p(t,"P",{"data-svelte-h":!0}),u(S)!=="svelte-emap4f"&&(S.innerHTML=Ue),At=a(t),P=p(t,"IMG",{src:!0,alt:!0}),Bt=a(t),E=p(t,"P",{"data-svelte-h":!0}),u(E)!=="svelte-1h49gxo"&&(E.textContent=Te),Lt=a(t),G=p(t,"UL",{"data-svelte-h":!0}),u(G)!=="svelte-rukxw8"&&(G.innerHTML=de),Zt=a(t),k=p(t,"P",{"data-svelte-h":!0}),u(k)!=="svelte-p3vm8q"&&(k.textContent=ve),St=a(t),z(q.$$.fragment,t),Pt=a(t),N=p(t,"P",{"data-svelte-h":!0}),u(N)!=="svelte-1v7t0xt"&&(N.textContent=ce),Et=a(t),F=p(t,"UL",{"data-svelte-h":!0}),u(F)!=="svelte-1frjtfm"&&(F.innerHTML=we),Gt=a(t),V=p(t,"P",{"data-svelte-h":!0}),u(V)!=="svelte-7mgs6s"&&(V.innerHTML=xe),kt=a(t),qt=p(t,"HR",{}),Nt=a(t),W=p(t,"P",{"data-svelte-h":!0}),u(W)!=="svelte-dqdw0b"&&(W.textContent=Je),Ft=a(t),R=p(t,"P",{"data-svelte-h":!0}),u(R)!=="svelte-1p9xxsx"&&(R.textContent=_e),Vt=a(t),X=p(t,"P",{"data-svelte-h":!0}),u(X)!=="svelte-4qv3mb"&&(X.innerHTML=be),Wt=a(t),z(Q.$$.fragment,t),Rt=a(t),nt=p(t,"P",{}),$e(nt).forEach(l),this.h()},h(){O(M,"name","hf:doc:metadata"),O(M,"content",ke),O(r,"class","tip"),O(o,"start","2"),O(m,"start","3"),He(P.src,je="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/code-vs-json-actions.png")||O(P,"src",je),O(P,"alt","Code Agents")},m(t,e){Pe(document.head,M),n(t,st,e),n(t,lt,e),n(t,at,e),K(y,t,e),n(t,it,e),n(t,r,e),n(t,pt,e),n(t,C,e),n(t,ut,e),n(t,f,e),n(t,Mt,e),n(t,h,e),n(t,rt,e),K(U,t,e),n(t,ot,e),n(t,j,e),n(t,mt,e),n(t,T,e),n(t,yt,e),n(t,d,e),n(t,Ct,e),n(t,v,e),n(t,ft,e),n(t,c,e),n(t,ht,e),n(t,w,e),n(t,Ut,e),K(x,t,e),n(t,jt,e),n(t,J,e),n(t,Tt,e),n(t,_,e),n(t,dt,e),n(t,b,e),n(t,vt,e),n(t,o,e),n(t,ct,e),n(t,$,e),n(t,wt,e),n(t,m,e),n(t,xt,e),n(t,I,e),n(t,Jt,e),n(t,g,e),n(t,_t,e),K(H,t,e),n(t,bt,e),n(t,A,e),n(t,$t,e),n(t,B,e),n(t,It,e),n(t,L,e),n(t,gt,e),K(Z,t,e),n(t,Ht,e),n(t,S,e),n(t,At,e),n(t,P,e),n(t,Bt,e),n(t,E,e),n(t,Lt,e),n(t,G,e),n(t,Zt,e),n(t,k,e),n(t,St,e),K(q,t,e),n(t,Pt,e),n(t,N,e),n(t,Et,e),n(t,F,e),n(t,Gt,e),n(t,V,e),n(t,kt,e),n(t,qt,e),n(t,Nt,e),n(t,W,e),n(t,Ft,e),n(t,R,e),n(t,Vt,e),n(t,X,e),n(t,Wt,e),K(Q,t,e),n(t,Rt,e),n(t,nt,e),Xt=!0},p:Ae,i(t){Xt||(D(y.$$.fragment,t),D(U.$$.fragment,t),D(x.$$.fragment,t),D(H.$$.fragment,t),D(Z.$$.fragment,t),D(q.$$.fragment,t),D(Q.$$.fragment,t),Xt=!0)},o(t){tt(y.$$.fragment,t),tt(U.$$.fragment,t),tt(x.$$.fragment,t),tt(H.$$.fragment,t),tt(Z.$$.fragment,t),tt(q.$$.fragment,t),tt(Q.$$.fragment,t),Xt=!1},d(t){t&&(l(st),l(lt),l(at),l(it),l(r),l(pt),l(C),l(ut),l(f),l(Mt),l(h),l(rt),l(ot),l(j),l(mt),l(T),l(yt),l(d),l(Ct),l(v),l(ft),l(c),l(ht),l(w),l(Ut),l(jt),l(J),l(Tt),l(_),l(dt),l(b),l(vt),l(o),l(ct),l($),l(wt),l(m),l(xt),l(I),l(Jt),l(g),l(_t),l(bt),l(A),l($t),l(B),l(It),l(L),l(gt),l(Ht),l(S),l(At),l(P),l(Bt),l(E),l(Lt),l(G),l(Zt),l(k),l(St),l(Pt),l(N),l(Et),l(F),l(Gt),l(V),l(kt),l(qt),l(Nt),l(W),l(Ft),l(R),l(Vt),l(X),l(Wt),l(Rt),l(nt)),l(M),et(y,t),et(U,t),et(x,t),et(H,t),et(Z,t),et(q,t),et(Q,t)}}}const ke='{"title":"动作：使智能体能够与环境交互","local":"动作使智能体能够与环境交互","sections":[{"title":"智能体动作的类型 (Types of Agent Actions)","local":"智能体动作的类型-types-of-agent-actions","sections":[],"depth":2},{"title":"停止和解析方法 (The Stop and Parse Approach)","local":"停止和解析方法-the-stop-and-parse-approach","sections":[],"depth":2},{"title":"代码智能体 (Code Agents)","local":"代码智能体-code-agents","sections":[],"depth":2}],"depth":1}';function qe(Yt){return Be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xe extends Le{constructor(M){super(),Ze(this,M,qe,Ge,ge,{})}}export{Xe as component};
