import{s as yt,f as pt,n as it,o as jt}from"../chunks/scheduler.37c15a92.js";import{S as ct,i as wt,g as e,s as n,r as p,A as mt,h as U,f as t,c as M,j as Tt,u as T,x as J,k as hl,y as ot,a,v as y,d as i,t as j,w as c}from"../chunks/index.2bf4358c.js";import{C as m}from"../chunks/CodeBlock.4e987730.js";import{H as w}from"../chunks/Heading.8ada512a.js";import{E as It}from"../chunks/getInferenceSnippets.0aa3753f.js";function Ct(fs){let o,bl,rl,Bl,C,Vl,u,Ss="现在我们已经理解了基本构建模块，让我们通过构建第一个功能图来实践。我们将实现 Alfred 的邮件处理系统，他需要：",dl,h,As="<li>阅读 incoming emails</li> <li>将其分类为 spam 或 legitimate</li> <li>为 legitimate 邮件起草初步响应</li> <li>当邮件合法时向 Mr. Wayne 发送信息（仅打印）</li>",Ql,r,Fs="这个示例演示了如何使用 LangGraph 构建涉及基于 LLM 决策的工作流程结构。虽然这不能算是真正的 Agent（因为没有涉及工具），但本节更侧重于学习 LangGraph 框架而非 Agents。",Nl,I,Zs='<p>你可以在 <a href="https://huggingface.co/agents-course/notebooks/resolve/main/unit2/langgraph/mail_sorting.ipynb" target="_blank">这个 notebook</a> 中查看完整代码，并通过 Google Colab 运行。</p>',fl,g,Sl,b,Es="这是我们将要构建的工作流程：",Al,B,Gs,Fl,V,Zl,d,Rs="首先安装必要的包：",El,Q,Gl,N,Ws="接下来，让我们导入必要的模块：",Rl,f,Wl,S,ql,A,qs="让我们定义 Alfred 在电子邮件处理工作流程中需要跟踪哪些信息：",kl,F,Yl,Z,ks="<p>💡 <strong>提示：</strong>让您的状态足够全面，以跟踪所有重要信息，但避免用不必要的细节使其变得臃肿。</p>",_l,E,$l,G,Ys="现在，让我们创建将形成我们节点的处理函数：",zl,R,Xl,W,xl,q,_s="我们需要一个函数来确定分类后要采取哪条路径：",vl,k,Ol,Y,$s="<p>💡 <strong>注意：</strong> LangGraph 调用此路由函数来确定在分类节点之后要跟随哪条边。返回值必须与我们的条件边映射中的一个键匹配。</p>",Hl,_,Ll,$,zs="现在我们将所有内容连接在一起：",Dl,z,Kl,X,Xs="注意我们如何使用 LangGraph 提供的特殊“END”节点。这表示工作流完成的终端状态。",Pl,x,ls,v,xs="让我们用一封合法的电子邮件和一封垃圾邮件来测试我们的图表：",ss,O,ts,H,as,L,vs="随着 Alfred 对主分类智能体进行微调，他越来越厌倦调试其运行。智能体本质上是不可预测的，难以检查。但由于他的目标是构建终极垃圾邮件检测智能体并将其部署到生产中，因此他需要强大的可追溯性以供将来监控和分析。",ns,D,Os='为此，Alfred 可以使用可观察性工具（例如 <a href="https://langfuse.com/" rel="nofollow">Langfuse</a>）来跟踪和监控智能体。',Ms,K,Hs="首先，我们 pip install Langfuse：",es,P,Us,ll,Ls='接下来，我们将 Langfuse API 密钥和主机地址添加为环境变量。您可以通过注册 <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse Cloud</a> 或 <a href="https://langfuse.com/self-hosting" rel="nofollow">self-host Langfuse</a> 获取 Langfuse 凭据。',Js,sl,ps,tl,Ds='然后，我们配置 <a href="https://langfuse.com/docs/integrations/langchain/tracing#add-langfuse-to-your-langchain-application" rel="nofollow">Langfuse <code>callback_handler</code></a>，并通过将 <code>langfuse_callback</code> 添加到图的调用来检测智能体：<code>config={&quot;callbacks&quot;: [langfuse_handler]}</code>。',Ts,al,ys,nl,Ks="Alfred 现已连接 🔌！LangGraph 的运行记录在 Langfuse 中，使他能够全面了解智能体的行为。通过此设置，他可以重新查看之前的运行并进一步完善他的邮件分类智能体。",is,Ml,Ps='<img src="https://langfuse.com/images/cookbook/huggingface-agent-course/langgraph-trace-legit.png" alt="Langfuse 中的示例跟踪"/>',js,el,lt='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/f5d6d72e-20af-4357-b232-af44c3728a7b?timestamp=2025-03-17T10%3A13%3A28.413Z&amp;observation=6997ba69-043f-4f77-9445-700a033afba1" rel="nofollow">带有合法电子邮件的跟踪的公共链接</a></em>',cs,Ul,ws,Jl,st="LangGraph 允许我们可视化我们的工作流程，以便更好地理解和调试其结构：",ms,pl,os,Tl,tt,Is,yl,at="这会产生一个可视化表示，显示我们的节点如何连接以及可以采取的条件路径。",Cs,il,us,jl,nt="我们创建了一个完整的电子邮件处理工作流程：",hs,cl,Mt="<li>接收传入的电子邮件</li> <li>使用 LLM 将其分类为垃圾邮件或合法邮件</li> <li>通过丢弃垃圾邮件来处理垃圾邮件</li> <li>对于合法电子邮件，起草回复并通知 Mr. Hugg</li>",rs,wl,et="这展示了 LangGraph 使用 LLM 编排复杂工作流程同时保持清晰、结构化流程的强大功能。",gs,ml,bs,ol,Ut="<li><strong>状态管理</strong>：我们定义了全面的状态来跟踪电子邮件处理的所有方面</li> <li><strong>节点实现</strong>：我们创建了与 LLM 交互的功能节点</li> <li><strong>条件路由</strong>：我们根据电子邮件分类实现了分支逻辑</li> <li><strong>终端状态</strong>：我们使用 END 节点标记工作流程中的完成点</li>",Bs,Il,Vs,Cl,Jt="在下一部分中，我们将探索 LangGraph 的更多高级功能，包括处理工作流中的人机交互以及根据多种条件实现更复杂的分支逻辑。",ds,ul,Qs,gl,Ns;return C=new w({props:{title:"构建你的第一个 LangGraph",local:"构建你的第一个-langgraph",headingTag:"h1"}}),g=new w({props:{title:"工作流程",local:"工作流程",headingTag:"h2"}}),V=new w({props:{title:"环境设置",local:"环境设置",headingTag:"h2"}}),Q=new m({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdncmFwaCUyMGxhbmdjaGFpbl9vcGVuYWk=",highlighted:"%pip install langgraph langchain_openai",wrap:!1}}),f=new m({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwVHlwZWREaWN0JTJDJTIwTGlzdCUyQyUyMERpY3QlMkMlMjBBbnklMkMlMjBPcHRpb25hbCUwQWZyb20lMjBsYW5nZ3JhcGguZ3JhcGglMjBpbXBvcnQlMjBTdGF0ZUdyYXBoJTJDJTIwRU5EJTBBZnJvbSUyMGxhbmdjaGFpbl9vcGVuYWklMjBpbXBvcnQlMjBDaGF0T3BlbkFJJTBBZnJvbSUyMGxhbmdjaGFpbl9jb3JlLm1lc3NhZ2VzJTIwaW1wb3J0JTIwSHVtYW5NZXNzYWdlJTJDJTIwQUlNZXNzYWdl",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> TypedDict, <span class="hljs-type">List</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Any</span>, <span class="hljs-type">Optional</span>
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> StateGraph, END
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> HumanMessage, AIMessage`,wrap:!1}}),S=new w({props:{title:"步骤 1：定义我们的状态",local:"步骤-1定义我们的状态",headingTag:"h2"}}),F=new m({props:{code:"Y2xhc3MlMjBFbWFpbFN0YXRlKFR5cGVkRGljdCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjAlRTYlQUQlQTMlRTUlOUMlQTglRTUlQTQlODQlRTclOTAlODYlRTclOUElODQlRTclOTQlQjUlRTUlQUQlOTAlRTklODIlQUUlRTQlQkIlQjYlMEElMjAlMjAlMjAlMjBlbWFpbCUzQSUyMERpY3QlNUJzdHIlMkMlMjBBbnklNUQlMjAlMjAlMjMlMjAlRTUlOEMlODUlRTUlOTAlQUIlRTQlQjglQkIlRTklQTIlOTglRTMlODAlODElRTUlOEYlOTElRTQlQkIlQjYlRTQlQkElQkElRTMlODAlODElRTYlQUQlQTMlRTYlOTYlODclRTclQUQlODklRTMlODAlODIlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjAlRTUlODglODYlRTYlOUUlOTAlRTQlQjglOEUlRTUlODYlQjMlRTclQUQlOTYlMEElMjAlMjAlMjAlMjBpc19zcGFtJTNBJTIwT3B0aW9uYWwlNUJib29sJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwJUU1JTkzJThEJUU1JUJBJTk0JUU3JTk0JTlGJUU2JTg4JTkwJTBBJTIwJTIwJTIwJTIwZHJhZnRfcmVzcG9uc2UlM0ElMjBPcHRpb25hbCU1QnN0ciU1RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMCVFNSVBNCU4NCVFNyU5MCU4NiVFNSU4NSU4MyVFNiU5NSVCMCVFNiU4RCVBRSUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNBJTIwTGlzdCU1QkRpY3QlNUJzdHIlMkMlMjBBbnklNUQlNUQlMjAlMjAlMjMlMjAlRTglQjclOUYlRTglQjglQUElRTQlQjglOEUlMjBMTE0lMjAlRTclOUElODQlRTUlQUYlQjklRTglQUYlOUQlRTQlQkIlQTUlRTglQkYlOUIlRTglQTElOEMlRTUlODglODYlRTYlOUUlOTA=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">EmailState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    <span class="hljs-comment"># 正在处理的电子邮件</span>
    email: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]  <span class="hljs-comment"># 包含主题、发件人、正文等。</span>
    
    <span class="hljs-comment"># 分析与决策</span>
    is_spam: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>]
    
    <span class="hljs-comment"># 响应生成</span>
    draft_response: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]
    
    <span class="hljs-comment"># 处理元数据</span>
    messages: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]]  <span class="hljs-comment"># 跟踪与 LLM 的对话以进行分析</span>`,wrap:!1}}),E=new w({props:{title:"第 2 步：定义我们的节点",local:"第-2-步定义我们的节点",headingTag:"h2"}}),R=new m({props:{code:"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",highlighted:`<span class="hljs-comment"># Initialize our LLM</span>
model = ChatOpenAI(temperature=<span class="hljs-number">0</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">read_email</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred reads and logs the incoming email&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-comment"># 在这里我们可能会做一些初步的预处理</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Alfred is processing an email from <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span> with subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>&quot;</span>)
    
    <span class="hljs-comment"># 这里不需要更改状态</span>
    <span class="hljs-keyword">return</span> {}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">classify_email</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred uses an LLM to determine if the email is spam or legitimate&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-comment"># 为 LLM 准备提示</span>
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    As Alfred the butler, analyze this email and determine if it is spam or legitimate.
    
    Email:
    From: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>
    Subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>
    Body: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;body&#x27;</span>]}</span>
    
    First, determine if this email is spam. If it is spam, explain why.
    If it is legitimate, categorize it (inquiry, complaint, thank you, etc.).
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Call the LLM</span>
    messages = [HumanMessage(content=prompt)]
    response = model.invoke(messages)
    
    <span class="hljs-comment"># 解析响应的简单逻辑（在实际应用中，您需要更强大的解析）</span>
    response_text = response.content.lower()
    is_spam = <span class="hljs-string">&quot;spam&quot;</span> <span class="hljs-keyword">in</span> response_text <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;not spam&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> response_text
    
    <span class="hljs-comment"># 如果是垃圾邮件，请提取原因</span>
    spam_reason = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">if</span> is_spam <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;reason:&quot;</span> <span class="hljs-keyword">in</span> response_text:
        spam_reason = response_text.split(<span class="hljs-string">&quot;reason:&quot;</span>)[<span class="hljs-number">1</span>].strip()
    
    <span class="hljs-comment"># 确定类别是否合法</span>
    email_category = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> is_spam:
        categories = [<span class="hljs-string">&quot;inquiry&quot;</span>, <span class="hljs-string">&quot;complaint&quot;</span>, <span class="hljs-string">&quot;thank you&quot;</span>, <span class="hljs-string">&quot;request&quot;</span>, <span class="hljs-string">&quot;information&quot;</span>]
        <span class="hljs-keyword">for</span> category <span class="hljs-keyword">in</span> categories:
            <span class="hljs-keyword">if</span> category <span class="hljs-keyword">in</span> response_text:
                email_category = category
                <span class="hljs-keyword">break</span>
    
    <span class="hljs-comment"># 更新消息以进行追踪</span>
    new_messages = state.get(<span class="hljs-string">&quot;messages&quot;</span>, []) + [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: response.content}
    ]
    
    <span class="hljs-comment"># 返回状态更新</span>
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;is_spam&quot;</span>: is_spam,
        <span class="hljs-string">&quot;spam_reason&quot;</span>: spam_reason,
        <span class="hljs-string">&quot;email_category&quot;</span>: email_category,
        <span class="hljs-string">&quot;messages&quot;</span>: new_messages
    }

<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_spam</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred discards spam email with a note&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Alfred has marked the email as spam. Reason: <span class="hljs-subst">{state[<span class="hljs-string">&#x27;spam_reason&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The email has been moved to the spam folder.&quot;</span>)
    
    <span class="hljs-comment"># 我们已处理完这封电子邮件</span>
    <span class="hljs-keyword">return</span> {}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">draft_response</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred drafts a preliminary response for legitimate emails&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    category = state[<span class="hljs-string">&quot;email_category&quot;</span>] <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;general&quot;</span>
    
    <span class="hljs-comment"># 为 LLM 准备提示词</span>
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    As Alfred the butler, draft a polite preliminary response to this email.
    
    Email:
    From: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>
    Subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>
    Body: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;body&#x27;</span>]}</span>
    
    This email has been categorized as: <span class="hljs-subst">{category}</span>
    
    Draft a brief, professional response that Mr. Hugg can review and personalize before sending.
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Call the LLM</span>
    messages = [HumanMessage(content=prompt)]
    response = model.invoke(messages)
    
    <span class="hljs-comment"># 更新消息以进行追踪</span>
    new_messages = state.get(<span class="hljs-string">&quot;messages&quot;</span>, []) + [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: response.content}
    ]
    
    <span class="hljs-comment"># 返回状态更新</span>
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;draft_response&quot;</span>: response.content,
        <span class="hljs-string">&quot;messages&quot;</span>: new_messages
    }

<span class="hljs-keyword">def</span> <span class="hljs-title function_">notify_mr_hugg</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred notifies Mr. Hugg about the email and presents the draft response&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Sir, you&#x27;ve received an email from <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>.&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Category: <span class="hljs-subst">{state[<span class="hljs-string">&#x27;email_category&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nI&#x27;ve prepared a draft response for your review:&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;-&quot;</span>*<span class="hljs-number">50</span>)
    <span class="hljs-built_in">print</span>(state[<span class="hljs-string">&quot;draft_response&quot;</span>])
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span> + <span class="hljs-string">&quot;\\n&quot;</span>)
    
    <span class="hljs-comment"># 我们已处理完这封电子邮件</span>
    <span class="hljs-keyword">return</span> {}`,wrap:!1}}),W=new w({props:{title:"步骤 3：定义我们的路由逻辑",local:"步骤-3定义我们的路由逻辑",headingTag:"h2"}}),k=new m({props:{code:"ZGVmJTIwcm91dGVfZW1haWwoc3RhdGUlM0ElMjBFbWFpbFN0YXRlKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJEZXRlcm1pbmUlMjB0aGUlMjBuZXh0JTIwc3RlcCUyMGJhc2VkJTIwb24lMjBzcGFtJTIwY2xhc3NpZmljYXRpb24lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpZiUyMHN0YXRlJTVCJTIyaXNfc3BhbSUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMnNwYW0lMjIlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIybGVnaXRpbWF0ZSUyMg==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">route_email</span>(<span class="hljs-params">state: EmailState</span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Determine the next step based on spam classification&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> state[<span class="hljs-string">&quot;is_spam&quot;</span>]:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;spam&quot;</span>
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;legitimate&quot;</span>`,wrap:!1}}),_=new w({props:{title:"步骤 4：创建 StateGraph 并定义边",local:"步骤-4创建-stategraph-并定义边",headingTag:"h2"}}),z=new m({props:{code:"JTIzJTIwJUU1JTg4JTlCJUU1JUJCJUJBJTIwZ3JhcGglMEFlbWFpbF9ncmFwaCUyMCUzRCUyMFN0YXRlR3JhcGgoRW1haWxTdGF0ZSklMEElMEElMjMlMjAlRTYlQjclQkIlRTUlOEElQTAlMjBub2RlcyUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMnJlYWRfZW1haWwlMjIlMkMlMjByZWFkX2VtYWlsKSUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMmNsYXNzaWZ5X2VtYWlsJTIyJTJDJTIwY2xhc3NpZnlfZW1haWwpJTBBZW1haWxfZ3JhcGguYWRkX25vZGUoJTIyaGFuZGxlX3NwYW0lMjIlMkMlMjBoYW5kbGVfc3BhbSklMEFlbWFpbF9ncmFwaC5hZGRfbm9kZSglMjJkcmFmdF9yZXNwb25zZSUyMiUyQyUyMGRyYWZ0X3Jlc3BvbnNlKSUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMm5vdGlmeV9tcl9odWdnJTIyJTJDJTIwbm90aWZ5X21yX2h1Z2cpJTBBJTBBJTIzJTIwJUU2JUI3JUJCJUU1JThBJUEwJTIwZWRnZXMlMjAtJTIwJUU1JUFFJTlBJUU0JUI5JTg5JUU2JUI1JTgxJUU3JUE4JThCJTBBZW1haWxfZ3JhcGguYWRkX2VkZ2UoJTIycmVhZF9lbWFpbCUyMiUyQyUyMCUyMmNsYXNzaWZ5X2VtYWlsJTIyKSUwQSUwQSUyMyUyMCVFNCVCQiU4RSUyMGNsYXNzaWZ5X2VtYWlsJTIwJUU2JUI3JUJCJUU1JThBJUEwJUU2JTlEJUExJUU0JUJCJUI2JUU1JTg4JTg2JUU2JTk0JUFGJTBBZW1haWxfZ3JhcGguYWRkX2NvbmRpdGlvbmFsX2VkZ2VzKCUwQSUyMCUyMCUyMCUyMCUyMmNsYXNzaWZ5X2VtYWlsJTIyJTJDJTBBJTIwJTIwJTIwJTIwcm91dGVfZW1haWwlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzcGFtJTIyJTNBJTIwJTIyaGFuZGxlX3NwYW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWdpdGltYXRlJTIyJTNBJTIwJTIyZHJhZnRfcmVzcG9uc2UlMjIlMEElMjAlMjAlMjAlMjAlN0QlMEEpJTBBJTBBJTIzJTIwJUU2JUI3JUJCJUU1JThBJUEwJUU2JTlDJTgwJUU1JTkwJThFJUU3JTlBJTg0JTIwZWRnZXMlMEFlbWFpbF9ncmFwaC5hZGRfZWRnZSglMjJoYW5kbGVfc3BhbSUyMiUyQyUyMEVORCklMEFlbWFpbF9ncmFwaC5hZGRfZWRnZSglMjJkcmFmdF9yZXNwb25zZSUyMiUyQyUyMCUyMm5vdGlmeV9tcl9odWdnJTIyKSUwQWVtYWlsX2dyYXBoLmFkZF9lZGdlKCUyMm5vdGlmeV9tcl9odWdnJTIyJTJDJTIwRU5EKSUwQSUwQSUyMyUyMCVFNyVCQyU5NiVFOCVBRiU5MSUyMGdyYXBoJTBBY29tcGlsZWRfZ3JhcGglMjAlM0QlMjBlbWFpbF9ncmFwaC5jb21waWxlKCk=",highlighted:`<span class="hljs-comment"># 创建 graph</span>
email_graph = StateGraph(EmailState)

<span class="hljs-comment"># 添加 nodes</span>
email_graph.add_node(<span class="hljs-string">&quot;read_email&quot;</span>, read_email)
email_graph.add_node(<span class="hljs-string">&quot;classify_email&quot;</span>, classify_email)
email_graph.add_node(<span class="hljs-string">&quot;handle_spam&quot;</span>, handle_spam)
email_graph.add_node(<span class="hljs-string">&quot;draft_response&quot;</span>, draft_response)
email_graph.add_node(<span class="hljs-string">&quot;notify_mr_hugg&quot;</span>, notify_mr_hugg)

<span class="hljs-comment"># 添加 edges - 定义流程</span>
email_graph.add_edge(<span class="hljs-string">&quot;read_email&quot;</span>, <span class="hljs-string">&quot;classify_email&quot;</span>)

<span class="hljs-comment"># 从 classify_email 添加条件分支</span>
email_graph.add_conditional_edges(
    <span class="hljs-string">&quot;classify_email&quot;</span>,
    route_email,
    {
        <span class="hljs-string">&quot;spam&quot;</span>: <span class="hljs-string">&quot;handle_spam&quot;</span>,
        <span class="hljs-string">&quot;legitimate&quot;</span>: <span class="hljs-string">&quot;draft_response&quot;</span>
    }
)

<span class="hljs-comment"># 添加最后的 edges</span>
email_graph.add_edge(<span class="hljs-string">&quot;handle_spam&quot;</span>, END)
email_graph.add_edge(<span class="hljs-string">&quot;draft_response&quot;</span>, <span class="hljs-string">&quot;notify_mr_hugg&quot;</span>)
email_graph.add_edge(<span class="hljs-string">&quot;notify_mr_hugg&quot;</span>, END)

<span class="hljs-comment"># 编译 graph</span>
compiled_graph = email_graph.<span class="hljs-built_in">compile</span>()`,wrap:!1}}),x=new w({props:{title:"步骤 5：运行应用程序",local:"步骤-5运行应用程序",headingTag:"h2"}}),O=new m({props:{code:"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",highlighted:`<span class="hljs-comment"># 合法电子邮件示例</span>
legitimate_email = {
    <span class="hljs-string">&quot;sender&quot;</span>: <span class="hljs-string">&quot;john.smith@example.com&quot;</span>,
    <span class="hljs-string">&quot;subject&quot;</span>: <span class="hljs-string">&quot;Question about your services&quot;</span>,
    <span class="hljs-string">&quot;body&quot;</span>: <span class="hljs-string">&quot;Dear Mr. Hugg, I was referred to you by a colleague and I&#x27;m interested in learning more about your consulting services. Could we schedule a call next week? Best regards, John Smith&quot;</span>
}

<span class="hljs-comment"># 垃圾邮件示例</span>
spam_email = {
    <span class="hljs-string">&quot;sender&quot;</span>: <span class="hljs-string">&quot;winner@lottery-intl.com&quot;</span>,
    <span class="hljs-string">&quot;subject&quot;</span>: <span class="hljs-string">&quot;YOU HAVE WON $5,000,000!!!&quot;</span>,
    <span class="hljs-string">&quot;body&quot;</span>: <span class="hljs-string">&quot;CONGRATULATIONS! You have been selected as the winner of our international lottery! To claim your $5,000,000 prize, please send us your bank details and a processing fee of $100.&quot;</span>
}

<span class="hljs-comment"># 处理合法电子邮件</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nProcessing legitimate email...&quot;</span>)
legitimate_result = compiled_graph.invoke({
    <span class="hljs-string">&quot;email&quot;</span>: legitimate_email,
    <span class="hljs-string">&quot;is_spam&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;spam_reason&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;email_category&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;draft_response&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;messages&quot;</span>: []
})

<span class="hljs-comment"># 处理垃圾邮件</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nProcessing spam email...&quot;</span>)
spam_result = compiled_graph.invoke({
    <span class="hljs-string">&quot;email&quot;</span>: spam_email,
    <span class="hljs-string">&quot;is_spam&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;spam_reason&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;email_category&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;draft_response&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;messages&quot;</span>: []
})`,wrap:!1}}),H=new w({props:{title:"第 6 步：使用 Langfuse 检查我们的邮件分类智能体 📡",local:"第-6-步使用-langfuse-检查我们的邮件分类智能体-",headingTag:"h2"}}),P=new m({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMC1xJTIwbGFuZ2Z1c2U=",highlighted:"%pip install -q langfuse",wrap:!1}}),sl=new m({props:{code:"aW1wb3J0JTIwb3MlMEElMjAlMEElMjMlMjBHZXQlMjBrZXlzJTIwZm9yJTIweW91ciUyMHByb2plY3QlMjBmcm9tJTIwdGhlJTIwcHJvamVjdCUyMHNldHRpbmdzJTIwcGFnZSUzQSUyMGh0dHBzJTNBJTJGJTJGY2xvdWQubGFuZ2Z1c2UuY29tJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1BVQkxJQ19LRVklMjIlNUQlMjAlM0QlMjAlMjJway1sZi0uLi4lMjIlMjAlMEFvcy5lbnZpcm9uJTVCJTIyTEFOR0ZVU0VfU0VDUkVUX0tFWSUyMiU1RCUyMCUzRCUyMCUyMnNrLWxmLS4uLiUyMiUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZjbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQUElRjAlOUYlODclQkElMjBFVSUyMHJlZ2lvbiUwQSUyMyUyMG9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cy5jbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQkElRjAlOUYlODclQjglMjBVUyUyMHJlZ2lvbg==",highlighted:`<span class="hljs-keyword">import</span> os
 
<span class="hljs-comment"># Get keys for your project from the project settings page: https://cloud.langfuse.com</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = <span class="hljs-string">&quot;sk-lf-...&quot;</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span> <span class="hljs-comment"># 🇪🇺 EU region</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot; # 🇺🇸 US region</span>`,wrap:!1}}),al=new m({props:{code:"ZnJvbSUyMGxhbmdmdXNlLmxhbmdjaGFpbiUyMGltcG9ydCUyMENhbGxiYWNrSGFuZGxlciUwQSUwQSUyMyUyMCVFNCVCOCVCQSUyMExhbmdHcmFwaCUyRkxhbmdjaGFpbiUyMCVFNSU4OCU5RCVFNSVBNyU4QiVFNSU4QyU5NiUyMExhbmdmdXNlJTIwQ2FsbGJhY2tIYW5kbGVyJUVGJUJDJTg4JUU4JUI3JTlGJUU4JUI4JUFBJUVGJUJDJTg5JTBBbGFuZ2Z1c2VfaGFuZGxlciUyMCUzRCUyMENhbGxiYWNrSGFuZGxlcigpJTBBJTBBJTIzJTIwJUU1JUE0JTg0JUU3JTkwJTg2JUU1JTkwJTg4JUU2JUIzJTk1JUU3JTk0JUI1JUU1JUFEJTkwJUU5JTgyJUFFJUU0JUJCJUI2JTBBbGVnaXRpbWF0ZV9yZXN1bHQlMjAlM0QlMjBjb21waWxlZF9ncmFwaC5pbnZva2UoJTBBJTIwJTIwJTIwJTIwaW5wdXQlM0QlN0IlMjJlbWFpbCUyMiUzQSUyMGxlZ2l0aW1hdGVfZW1haWwlMkMlMjAlMjJpc19zcGFtJTIyJTNBJTIwTm9uZSUyQyUyMCUyMnNwYW1fcmVhc29uJTIyJTNBJTIwTm9uZSUyQyUyMCUyMmVtYWlsX2NhdGVnb3J5JTIyJTNBJTIwTm9uZSUyQyUyMCUyMmRyYWZ0X3Jlc3BvbnNlJTIyJTNBJTIwTm9uZSUyQyUyMCUyMm1lc3NhZ2VzJTIyJTNBJTIwJTVCJTVEJTdEJTJDJTBBJTIwJTIwJTIwJTIwY29uZmlnJTNEJTdCJTIyY2FsbGJhY2tzJTIyJTNBJTIwJTVCbGFuZ2Z1c2VfaGFuZGxlciU1RCU3RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> langfuse.langchain <span class="hljs-keyword">import</span> CallbackHandler

<span class="hljs-comment"># 为 LangGraph/Langchain 初始化 Langfuse CallbackHandler（跟踪）</span>
langfuse_handler = CallbackHandler()

<span class="hljs-comment"># 处理合法电子邮件</span>
legitimate_result = compiled_graph.invoke(
    <span class="hljs-built_in">input</span>={<span class="hljs-string">&quot;email&quot;</span>: legitimate_email, <span class="hljs-string">&quot;is_spam&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;spam_reason&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;email_category&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;draft_response&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;messages&quot;</span>: []},
    config={<span class="hljs-string">&quot;callbacks&quot;</span>: [langfuse_handler]}
)`,wrap:!1}}),Ul=new w({props:{title:"可视化我们的图表",local:"可视化我们的图表",headingTag:"h2"}}),pl=new m({props:{code:"Y29tcGlsZWRfZ3JhcGguZ2V0X2dyYXBoKCkuZHJhd19tZXJtYWlkX3BuZygp",highlighted:"compiled_graph.get_graph().draw_mermaid_png()",wrap:!1}}),il=new w({props:{title:"我们构建了什么",local:"我们构建了什么",headingTag:"h2"}}),ml=new w({props:{title:"关键要点",local:"关键要点",headingTag:"h2"}}),Il=new w({props:{title:"下一步是什么？",local:"下一步是什么",headingTag:"h2"}}),ul=new It({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/zh-CN/unit2/langgraph/first_graph.mdx"}}),{c(){o=e("meta"),bl=n(),rl=e("p"),Bl=n(),p(C.$$.fragment),Vl=n(),u=e("p"),u.textContent=Ss,dl=n(),h=e("ol"),h.innerHTML=As,Ql=n(),r=e("p"),r.textContent=Fs,Nl=n(),I=e("blockquote"),I.innerHTML=Zs,fl=n(),p(g.$$.fragment),Sl=n(),b=e("p"),b.textContent=Es,Al=n(),B=e("img"),Fl=n(),p(V.$$.fragment),Zl=n(),d=e("p"),d.textContent=Rs,El=n(),p(Q.$$.fragment),Gl=n(),N=e("p"),N.textContent=Ws,Rl=n(),p(f.$$.fragment),Wl=n(),p(S.$$.fragment),ql=n(),A=e("p"),A.textContent=qs,kl=n(),p(F.$$.fragment),Yl=n(),Z=e("blockquote"),Z.innerHTML=ks,_l=n(),p(E.$$.fragment),$l=n(),G=e("p"),G.textContent=Ys,zl=n(),p(R.$$.fragment),Xl=n(),p(W.$$.fragment),xl=n(),q=e("p"),q.textContent=_s,vl=n(),p(k.$$.fragment),Ol=n(),Y=e("blockquote"),Y.innerHTML=$s,Hl=n(),p(_.$$.fragment),Ll=n(),$=e("p"),$.textContent=zs,Dl=n(),p(z.$$.fragment),Kl=n(),X=e("p"),X.textContent=Xs,Pl=n(),p(x.$$.fragment),ls=n(),v=e("p"),v.textContent=xs,ss=n(),p(O.$$.fragment),ts=n(),p(H.$$.fragment),as=n(),L=e("p"),L.textContent=vs,ns=n(),D=e("p"),D.innerHTML=Os,Ms=n(),K=e("p"),K.textContent=Hs,es=n(),p(P.$$.fragment),Us=n(),ll=e("p"),ll.innerHTML=Ls,Js=n(),p(sl.$$.fragment),ps=n(),tl=e("p"),tl.innerHTML=Ds,Ts=n(),p(al.$$.fragment),ys=n(),nl=e("p"),nl.textContent=Ks,is=n(),Ml=e("p"),Ml.innerHTML=Ps,js=n(),el=e("p"),el.innerHTML=lt,cs=n(),p(Ul.$$.fragment),ws=n(),Jl=e("p"),Jl.textContent=st,ms=n(),p(pl.$$.fragment),os=n(),Tl=e("img"),Is=n(),yl=e("p"),yl.textContent=at,Cs=n(),p(il.$$.fragment),us=n(),jl=e("p"),jl.textContent=nt,hs=n(),cl=e("ol"),cl.innerHTML=Mt,rs=n(),wl=e("p"),wl.textContent=et,gs=n(),p(ml.$$.fragment),bs=n(),ol=e("ul"),ol.innerHTML=Ut,Bs=n(),p(Il.$$.fragment),Vs=n(),Cl=e("p"),Cl.textContent=Jt,ds=n(),p(ul.$$.fragment),Qs=n(),gl=e("p"),this.h()},l(l){const s=mt("svelte-u9bgzb",document.head);o=U(s,"META",{name:!0,content:!0}),s.forEach(t),bl=M(l),rl=U(l,"P",{}),Tt(rl).forEach(t),Bl=M(l),T(C.$$.fragment,l),Vl=M(l),u=U(l,"P",{"data-svelte-h":!0}),J(u)!=="svelte-wtpds"&&(u.textContent=Ss),dl=M(l),h=U(l,"OL",{"data-svelte-h":!0}),J(h)!=="svelte-1w47pet"&&(h.innerHTML=As),Ql=M(l),r=U(l,"P",{"data-svelte-h":!0}),J(r)!=="svelte-kmq3p0"&&(r.textContent=Fs),Nl=M(l),I=U(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),J(I)!=="svelte-gropo0"&&(I.innerHTML=Zs),fl=M(l),T(g.$$.fragment,l),Sl=M(l),b=U(l,"P",{"data-svelte-h":!0}),J(b)!=="svelte-kmmosp"&&(b.textContent=Es),Al=M(l),B=U(l,"IMG",{src:!0,alt:!0}),Fl=M(l),T(V.$$.fragment,l),Zl=M(l),d=U(l,"P",{"data-svelte-h":!0}),J(d)!=="svelte-i8w9z9"&&(d.textContent=Rs),El=M(l),T(Q.$$.fragment,l),Gl=M(l),N=U(l,"P",{"data-svelte-h":!0}),J(N)!=="svelte-u3fqu"&&(N.textContent=Ws),Rl=M(l),T(f.$$.fragment,l),Wl=M(l),T(S.$$.fragment,l),ql=M(l),A=U(l,"P",{"data-svelte-h":!0}),J(A)!=="svelte-1oeecsl"&&(A.textContent=qs),kl=M(l),T(F.$$.fragment,l),Yl=M(l),Z=U(l,"BLOCKQUOTE",{"data-svelte-h":!0}),J(Z)!=="svelte-1gaur76"&&(Z.innerHTML=ks),_l=M(l),T(E.$$.fragment,l),$l=M(l),G=U(l,"P",{"data-svelte-h":!0}),J(G)!=="svelte-r4wysq"&&(G.textContent=Ys),zl=M(l),T(R.$$.fragment,l),Xl=M(l),T(W.$$.fragment,l),xl=M(l),q=U(l,"P",{"data-svelte-h":!0}),J(q)!=="svelte-se56vn"&&(q.textContent=_s),vl=M(l),T(k.$$.fragment,l),Ol=M(l),Y=U(l,"BLOCKQUOTE",{"data-svelte-h":!0}),J(Y)!=="svelte-1hjck2a"&&(Y.innerHTML=$s),Hl=M(l),T(_.$$.fragment,l),Ll=M(l),$=U(l,"P",{"data-svelte-h":!0}),J($)!=="svelte-1b8z0o4"&&($.textContent=zs),Dl=M(l),T(z.$$.fragment,l),Kl=M(l),X=U(l,"P",{"data-svelte-h":!0}),J(X)!=="svelte-cxg8gi"&&(X.textContent=Xs),Pl=M(l),T(x.$$.fragment,l),ls=M(l),v=U(l,"P",{"data-svelte-h":!0}),J(v)!=="svelte-9y4o4n"&&(v.textContent=xs),ss=M(l),T(O.$$.fragment,l),ts=M(l),T(H.$$.fragment,l),as=M(l),L=U(l,"P",{"data-svelte-h":!0}),J(L)!=="svelte-1gah1tl"&&(L.textContent=vs),ns=M(l),D=U(l,"P",{"data-svelte-h":!0}),J(D)!=="svelte-p2eoxe"&&(D.innerHTML=Os),Ms=M(l),K=U(l,"P",{"data-svelte-h":!0}),J(K)!=="svelte-e1sodk"&&(K.textContent=Hs),es=M(l),T(P.$$.fragment,l),Us=M(l),ll=U(l,"P",{"data-svelte-h":!0}),J(ll)!=="svelte-1fd3ji6"&&(ll.innerHTML=Ls),Js=M(l),T(sl.$$.fragment,l),ps=M(l),tl=U(l,"P",{"data-svelte-h":!0}),J(tl)!=="svelte-12a4tv9"&&(tl.innerHTML=Ds),Ts=M(l),T(al.$$.fragment,l),ys=M(l),nl=U(l,"P",{"data-svelte-h":!0}),J(nl)!=="svelte-1vyc13"&&(nl.textContent=Ks),is=M(l),Ml=U(l,"P",{"data-svelte-h":!0}),J(Ml)!=="svelte-ugmrhh"&&(Ml.innerHTML=Ps),js=M(l),el=U(l,"P",{"data-svelte-h":!0}),J(el)!=="svelte-16dcubd"&&(el.innerHTML=lt),cs=M(l),T(Ul.$$.fragment,l),ws=M(l),Jl=U(l,"P",{"data-svelte-h":!0}),J(Jl)!=="svelte-1ntiz7g"&&(Jl.textContent=st),ms=M(l),T(pl.$$.fragment,l),os=M(l),Tl=U(l,"IMG",{src:!0,alt:!0}),Is=M(l),yl=U(l,"P",{"data-svelte-h":!0}),J(yl)!=="svelte-10q7f2o"&&(yl.textContent=at),Cs=M(l),T(il.$$.fragment,l),us=M(l),jl=U(l,"P",{"data-svelte-h":!0}),J(jl)!=="svelte-cz9mlc"&&(jl.textContent=nt),hs=M(l),cl=U(l,"OL",{"data-svelte-h":!0}),J(cl)!=="svelte-1raplg6"&&(cl.innerHTML=Mt),rs=M(l),wl=U(l,"P",{"data-svelte-h":!0}),J(wl)!=="svelte-aijfvw"&&(wl.textContent=et),gs=M(l),T(ml.$$.fragment,l),bs=M(l),ol=U(l,"UL",{"data-svelte-h":!0}),J(ol)!=="svelte-1i0l2cv"&&(ol.innerHTML=Ut),Bs=M(l),T(Il.$$.fragment,l),Vs=M(l),Cl=U(l,"P",{"data-svelte-h":!0}),J(Cl)!=="svelte-1rewr8w"&&(Cl.textContent=Jt),ds=M(l),T(ul.$$.fragment,l),Qs=M(l),gl=U(l,"P",{}),Tt(gl).forEach(t),this.h()},h(){hl(o,"name","hf:doc:metadata"),hl(o,"content",ut),hl(I,"class","tip"),pt(B.src,Gs="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/first_graph.png")||hl(B,"src",Gs),hl(B,"alt","First LangGraph"),pt(Tl.src,tt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/mail_flow.png")||hl(Tl,"src",tt),hl(Tl,"alt","Mail LangGraph")},m(l,s){ot(document.head,o),a(l,bl,s),a(l,rl,s),a(l,Bl,s),y(C,l,s),a(l,Vl,s),a(l,u,s),a(l,dl,s),a(l,h,s),a(l,Ql,s),a(l,r,s),a(l,Nl,s),a(l,I,s),a(l,fl,s),y(g,l,s),a(l,Sl,s),a(l,b,s),a(l,Al,s),a(l,B,s),a(l,Fl,s),y(V,l,s),a(l,Zl,s),a(l,d,s),a(l,El,s),y(Q,l,s),a(l,Gl,s),a(l,N,s),a(l,Rl,s),y(f,l,s),a(l,Wl,s),y(S,l,s),a(l,ql,s),a(l,A,s),a(l,kl,s),y(F,l,s),a(l,Yl,s),a(l,Z,s),a(l,_l,s),y(E,l,s),a(l,$l,s),a(l,G,s),a(l,zl,s),y(R,l,s),a(l,Xl,s),y(W,l,s),a(l,xl,s),a(l,q,s),a(l,vl,s),y(k,l,s),a(l,Ol,s),a(l,Y,s),a(l,Hl,s),y(_,l,s),a(l,Ll,s),a(l,$,s),a(l,Dl,s),y(z,l,s),a(l,Kl,s),a(l,X,s),a(l,Pl,s),y(x,l,s),a(l,ls,s),a(l,v,s),a(l,ss,s),y(O,l,s),a(l,ts,s),y(H,l,s),a(l,as,s),a(l,L,s),a(l,ns,s),a(l,D,s),a(l,Ms,s),a(l,K,s),a(l,es,s),y(P,l,s),a(l,Us,s),a(l,ll,s),a(l,Js,s),y(sl,l,s),a(l,ps,s),a(l,tl,s),a(l,Ts,s),y(al,l,s),a(l,ys,s),a(l,nl,s),a(l,is,s),a(l,Ml,s),a(l,js,s),a(l,el,s),a(l,cs,s),y(Ul,l,s),a(l,ws,s),a(l,Jl,s),a(l,ms,s),y(pl,l,s),a(l,os,s),a(l,Tl,s),a(l,Is,s),a(l,yl,s),a(l,Cs,s),y(il,l,s),a(l,us,s),a(l,jl,s),a(l,hs,s),a(l,cl,s),a(l,rs,s),a(l,wl,s),a(l,gs,s),y(ml,l,s),a(l,bs,s),a(l,ol,s),a(l,Bs,s),y(Il,l,s),a(l,Vs,s),a(l,Cl,s),a(l,ds,s),y(ul,l,s),a(l,Qs,s),a(l,gl,s),Ns=!0},p:it,i(l){Ns||(i(C.$$.fragment,l),i(g.$$.fragment,l),i(V.$$.fragment,l),i(Q.$$.fragment,l),i(f.$$.fragment,l),i(S.$$.fragment,l),i(F.$$.fragment,l),i(E.$$.fragment,l),i(R.$$.fragment,l),i(W.$$.fragment,l),i(k.$$.fragment,l),i(_.$$.fragment,l),i(z.$$.fragment,l),i(x.$$.fragment,l),i(O.$$.fragment,l),i(H.$$.fragment,l),i(P.$$.fragment,l),i(sl.$$.fragment,l),i(al.$$.fragment,l),i(Ul.$$.fragment,l),i(pl.$$.fragment,l),i(il.$$.fragment,l),i(ml.$$.fragment,l),i(Il.$$.fragment,l),i(ul.$$.fragment,l),Ns=!0)},o(l){j(C.$$.fragment,l),j(g.$$.fragment,l),j(V.$$.fragment,l),j(Q.$$.fragment,l),j(f.$$.fragment,l),j(S.$$.fragment,l),j(F.$$.fragment,l),j(E.$$.fragment,l),j(R.$$.fragment,l),j(W.$$.fragment,l),j(k.$$.fragment,l),j(_.$$.fragment,l),j(z.$$.fragment,l),j(x.$$.fragment,l),j(O.$$.fragment,l),j(H.$$.fragment,l),j(P.$$.fragment,l),j(sl.$$.fragment,l),j(al.$$.fragment,l),j(Ul.$$.fragment,l),j(pl.$$.fragment,l),j(il.$$.fragment,l),j(ml.$$.fragment,l),j(Il.$$.fragment,l),j(ul.$$.fragment,l),Ns=!1},d(l){l&&(t(bl),t(rl),t(Bl),t(Vl),t(u),t(dl),t(h),t(Ql),t(r),t(Nl),t(I),t(fl),t(Sl),t(b),t(Al),t(B),t(Fl),t(Zl),t(d),t(El),t(Gl),t(N),t(Rl),t(Wl),t(ql),t(A),t(kl),t(Yl),t(Z),t(_l),t($l),t(G),t(zl),t(Xl),t(xl),t(q),t(vl),t(Ol),t(Y),t(Hl),t(Ll),t($),t(Dl),t(Kl),t(X),t(Pl),t(ls),t(v),t(ss),t(ts),t(as),t(L),t(ns),t(D),t(Ms),t(K),t(es),t(Us),t(ll),t(Js),t(ps),t(tl),t(Ts),t(ys),t(nl),t(is),t(Ml),t(js),t(el),t(cs),t(ws),t(Jl),t(ms),t(os),t(Tl),t(Is),t(yl),t(Cs),t(us),t(jl),t(hs),t(cl),t(rs),t(wl),t(gs),t(bs),t(ol),t(Bs),t(Vs),t(Cl),t(ds),t(Qs),t(gl)),t(o),c(C,l),c(g,l),c(V,l),c(Q,l),c(f,l),c(S,l),c(F,l),c(E,l),c(R,l),c(W,l),c(k,l),c(_,l),c(z,l),c(x,l),c(O,l),c(H,l),c(P,l),c(sl,l),c(al,l),c(Ul,l),c(pl,l),c(il,l),c(ml,l),c(Il,l),c(ul,l)}}}const ut='{"title":"构建你的第一个 LangGraph","local":"构建你的第一个-langgraph","sections":[{"title":"工作流程","local":"工作流程","sections":[],"depth":2},{"title":"环境设置","local":"环境设置","sections":[],"depth":2},{"title":"步骤 1：定义我们的状态","local":"步骤-1定义我们的状态","sections":[],"depth":2},{"title":"第 2 步：定义我们的节点","local":"第-2-步定义我们的节点","sections":[],"depth":2},{"title":"步骤 3：定义我们的路由逻辑","local":"步骤-3定义我们的路由逻辑","sections":[],"depth":2},{"title":"步骤 4：创建 StateGraph 并定义边","local":"步骤-4创建-stategraph-并定义边","sections":[],"depth":2},{"title":"步骤 5：运行应用程序","local":"步骤-5运行应用程序","sections":[],"depth":2},{"title":"第 6 步：使用 Langfuse 检查我们的邮件分类智能体 📡","local":"第-6-步使用-langfuse-检查我们的邮件分类智能体-","sections":[],"depth":2},{"title":"可视化我们的图表","local":"可视化我们的图表","sections":[],"depth":2},{"title":"我们构建了什么","local":"我们构建了什么","sections":[],"depth":2},{"title":"关键要点","local":"关键要点","sections":[],"depth":2},{"title":"下一步是什么？","local":"下一步是什么","sections":[],"depth":2}],"depth":1}';function ht(fs){return jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dt extends ct{constructor(o){super(),wt(this,o,ht,Ct,yt,{})}}export{dt as component};
