import{s as ve,f as Se,n as Ae,o as Re}from"../chunks/scheduler.37c15a92.js";import{S as Ee,i as Xe,g as n,s as M,r as J,A as _e,h as y,f as s,c as a,j as Me,u as i,x as U,k as r,y as xe,a as t,v as p,d as o,t as T,w}from"../chunks/index.2bf4358c.js";import{C as m}from"../chunks/CodeBlock.4e987730.js";import{C as Fe}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as te}from"../chunks/Heading.8ada512a.js";import{E as Ye}from"../chunks/getInferenceSnippets.0aa3753f.js";function He(ae){let j,il,Ul,pl,b,ol,h,Tl,u,ne=`<p>本节示例需要接入强大的视觉语言模型（VLM）。我们使用 GPT-4o API 进行了测试。<br/>
若需了解 smolagents 和 Hugging Face 支持的其他替代方案，请参考<a href="./why_use_smolagents">为什么选择smolagents</a>章节。</p>`,wl,d,ye="赋予智能体视觉能力对于超越文本处理的任务至关重要。网页浏览、文档理解等现实场景都需要解析丰富的视觉内容。smolagents 内置支持视觉语言模型（VLMs），使智能体能够有效处理图像信息。",cl,B,Ue="假设韦恩庄园的管家 Alfred 需要核验派对嘉宾身份。考虑到他可能无法识别所有来宾，我们可以构建基于 VLM 的智能体，通过视觉信息检索来辅助身份验证决策。以下是具体实现：",rl,Z,jl,C,Je='<p>配套代码可在<a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/vision_agents.ipynb" target="_blank">Google Colab 笔记本</a>中查看。</p>',ml,G,ie="该方法在智能体启动时通过 task_images 参数传入图像，智能体在执行过程中持续处理这些图像。",ul,g,pe="假设 Alfred 需要核验超级英雄身份，他已有历史派对嘉宾图像数据库。",Cl,f,oe="当新访客到来时，智能体可通过图像比对进行准入决策。",Il,V,Te="当前场景中，Alfred 怀疑访客可能是小丑假扮的神奇女侠。我们需要构建身份验证系统：",bl,W,hl,N,we="完成图像加载后，智能体将判断访客身份：究竟是超级英雄（Wonder Woman）还是反派角色（The Joker）。",dl,k,Bl,Q,ce="以下是我的运行结果（实际输出可能因环境差异有所不同，正如前文所述）：",Zl,v,Gl,S,re="在这种情况下，输出结果揭示了这个人正在冒充他人，因此我们可以阻止 The Joker 进入派对！",gl,A,fl,I,je='<p>您可以在 <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/vision_web_browser.py" target="_blank">这个 Python 文件</a> 中查看代码。</p>',Vl,R,me="前面的方法具有很高的价值，并且有许多潜在的应用场景。然而，在客人不在数据库中的情况下，我们需要探索其他识别方式。一种可能的解决方案是从外部来源动态检索图像和信息，例如通过浏览网页获取详细信息。",Wl,E,ue="在此方法中，图像是在执行过程中动态添加到智能体的记忆中的。我们知道，<code>smolagents</code> 中的智能体基于 <code>MultiStepAgent</code> 类，该类是 ReAct 框架的抽象。此类以结构化的周期运行，在不同阶段记录各种变量和知识：",Nl,X,Ce="<li><strong>SystemPromptStep:</strong> 存储系统提示。</li> <li><strong>TaskStep:</strong> 记录用户查询和提供的任何输入。</li> <li><strong>ActionStep:</strong> 捕获智能体操作和结果的日志。</li>",kl,_,Ie="这种结构化的方法使智能体能够动态地结合视觉信息，并对不断变化的任务做出适应性响应。以下是已经见过的图表，展示了动态工作流程过程以及不同步骤如何在智能体生命周期内集成。在浏览时，智能体可以截取屏幕截图并将其保存为 <code>ActionStep</code> 中的 <code>observation_images</code>。",Ql,x,be='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/smolagents-can-see/diagram_adding_vlms_smolagents.png" alt="Dynamic image retrieval"/>',vl,F,he="现在我们理解了需求，让我们构建完整的示例。在这种情况下，Alfred 希望完全控制访客验证过程，因此浏览详情成为可行的解决方案。为了完成这个示例，我们需要为智能体提供一组新的工具。此外，我们将使用 Selenium 和 Helium，这些是浏览器自动化工具。这将使我们能够构建一个探索网络、搜索潜在访客详情并检索验证信息的智能体。让我们安装所需的工具：",Sl,Y,Al,H,de="我们需要一组专为浏览设计的智能体工具，例如“search_item_ctrl_f”、“go_back”和“close_popups”。这些工具允许智能体像浏览网页的人一样行事。",Rl,$,El,z,Be="我们还需要保存屏幕截图的功能，因为这是我们的 VLM 智能体完成任务时必不可少的一部分。此功能会捕获屏幕截图并将其保存在 <code>step_log.observations_images = [image.copy()]</code> 中，从而允许智能体在导航时动态存储和处理图像。",Xl,q,_l,O,Ze="此函数作为 <code>step_callback</code> 传递给智能体，因为它在智能体执行的每一步结束时被触发。这使得智能体能够在整个过程中动态捕获和存储屏幕截图。",xl,L,Ge="现在，我们可以生成用于浏览网页的视觉智能体，为其提供我们创建的工具，以及 <code>DuckDuckGoSearchTool</code> 以探索网页。此工具将帮助智能体根据视觉线索检索验证访客身份所需的信息。",Fl,D,Yl,P,ge="有了这些，Alfred 准备检查访客的身份，并根据这些信息做出是否允许他们进入派对的明智决定：",Hl,K,$l,ll,fe="您可以看到，我们将 <code>helium_instructions</code> 作为任务的一部分包含在内。这个特殊的提示旨在控制智能体的导航，确保它在浏览网页时遵循正确的步骤。",zl,el,Ve="让我们看看这在下面的视频中是如何工作的：",ql,c,We,Ol,sl,Ne="这是最终输出：",Ll,tl,Dl,Ml,ke="通过这些步骤，我们成功地为派对创建了一个身份验证系统！ Alfred 现在拥有必要的工具，可以确保只有正确的宾客能够进入庄园。一切准备就绪，可以享受在韦恩庄园的美好时光！",Pl,al,Kl,nl,Qe='<li><a href="https://huggingface.co/blog/smolagents-can-see" rel="nofollow">我们让 smolagents 有了视觉能力</a> -  博客文章描述了视觉智能体的功能。</li> <li><a href="https://huggingface.co/docs/smolagents/examples/web_browser" rel="nofollow">使用智能体进行网页浏览 🤖🌐</a> - 使用视觉智能体进行网页浏览的示例。</li> <li><a href="https://github.com/huggingface/smolagents/blob/main/src/smolagents/vision_web_browser.py" rel="nofollow">网页浏览视觉智能体示例</a> - 使用视觉智能体进行网页浏览的示例。</li>',le,yl,ee,Jl,se;return b=new Fe({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/vision_agents.ipynb"}]}}),h=new te({props:{title:"使用 smolagents 构建视觉智能体",local:"使用-smolagents-构建视觉智能体",headingTag:"h1"}}),Z=new te({props:{title:"初始执行阶段提供图像",local:"初始执行阶段提供图像",headingTag:"h2"}}),W=new m({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBJTBBaW1hZ2VfdXJscyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGZSUyRmU4JTJGVGhlX0pva2VyX2F0X1dheF9NdXNldW1fUGx1cy5qcGclMjIlMkMlMjAlMjMlMjAlRTUlQjAlOEYlRTQlQjglOTElRTUlOUIlQkUlRTUlODMlOEYlMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGZW4lMkY5JTJGOTglMkZKb2tlcl8lMjUyOERDX0NvbWljc19jaGFyYWN0ZXIlMjUyOS5qcGclMjIlMjAlMjMlMjAlRTUlQjAlOEYlRTQlQjglOTElRTUlOUIlQkUlRTUlODMlOEYlMEElNUQlMEElMEFpbWFnZXMlMjAlM0QlMjAlNUIlNUQlMEFmb3IlMjB1cmwlMjBpbiUyMGltYWdlX3VybHMlM0ElMEElMjAlMjAlMjAlMjBoZWFkZXJzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyVXNlci1BZ2VudCUyMiUzQSUyMCUyMk1vemlsbGElMkY1LjAlMjAoV2luZG93cyUyME5UJTIwMTAuMCUzQiUyMFdpbjY0JTNCJTIweDY0KSUyMEFwcGxlV2ViS2l0JTJGNTM3LjM2JTIwKEtIVE1MJTJDJTIwbGlrZSUyMEdlY2tvKSUyMENocm9tZSUyRjExNC4wLjAuMCUyMFNhZmFyaSUyRjUzNy4zNiUyMiUyMCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCUyQ2hlYWRlcnMlM0RoZWFkZXJzKSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMjAlMjAlMjAlMjBpbWFnZXMuYXBwZW5kKGltYWdlKQ==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

image_urls = [
    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/e/e8/The_Joker_at_Wax_Museum_Plus.jpg&quot;</span>, <span class="hljs-comment"># 小丑图像</span>
    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/en/9/98/Joker_%28DC_Comics_character%29.jpg&quot;</span> <span class="hljs-comment"># 小丑图像</span>
]

images = []
<span class="hljs-keyword">for</span> url <span class="hljs-keyword">in</span> image_urls:
    headers = {
        <span class="hljs-string">&quot;User-Agent&quot;</span>: <span class="hljs-string">&quot;Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36&quot;</span> 
    }
    response = requests.get(url,headers=headers)
    image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
    images.append(image)`,wrap:!1}}),k=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBPcGVuQUlTZXJ2ZXJNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwT3BlbkFJU2VydmVyTW9kZWwobW9kZWxfaWQlM0QlMjJncHQtNG8lMjIpJTBBJTBBJTIzJTIwJUU1JUFFJTlFJUU0JUJFJThCJUU1JThDJTk2JUU2JTk5JUJBJUU4JTgzJUJEJUU0JUJEJTkzJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjB2ZXJib3NpdHlfbGV2ZWwlM0QyJTBBKSUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMERlc2NyaWJlJTIwdGhlJTIwY29zdHVtZSUyMGFuZCUyMG1ha2V1cCUyMHRoYXQlMjB0aGUlMjBjb21pYyUyMGNoYXJhY3RlciUyMGluJTIwdGhlc2UlMjBwaG90b3MlMjBpcyUyMHdlYXJpbmclMjBhbmQlMjByZXR1cm4lMjB0aGUlMjBkZXNjcmlwdGlvbi4lMEElMjAlMjAlMjAlMjBUZWxsJTIwbWUlMjBpZiUyMHRoZSUyMGd1ZXN0JTIwaXMlMjBUaGUlMjBKb2tlciUyMG9yJTIwV29uZGVyJTIwV29tYW4uJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTNEaW1hZ2VzJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, OpenAIServerModel

model = OpenAIServerModel(model_id=<span class="hljs-string">&quot;gpt-4o&quot;</span>)

<span class="hljs-comment"># 实例化智能体</span>
agent = CodeAgent(
    tools=[],
    model=model,
    max_steps=<span class="hljs-number">20</span>,
    verbosity_level=<span class="hljs-number">2</span>
)

response = agent.run(
    <span class="hljs-string">&quot;&quot;&quot;
    Describe the costume and makeup that the comic character in these photos is wearing and return the description.
    Tell me if the guest is The Joker or Wonder Woman.
    &quot;&quot;&quot;</span>,
    images=images
)`,wrap:!1}}),v=new m({props:{code:"JTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ0Nvc3R1bWUlMjBhbmQlMjBNYWtldXAlMjAtJTIwRmlyc3QlMjBJbWFnZSclM0ElMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ1B1cnBsZSUyMGNvYXQlMjBhbmQlMjBhJTIwcHVycGxlJTIwc2lsay1saWtlJTIwY3JhdmF0JTIwb3IlMjB0aWUlMjBvdmVyJTIwYSUyMG11c3RhcmQteWVsbG93JTIwc2hpcnQuJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdXaGl0ZSUyMGZhY2UlMjBwYWludCUyMHdpdGglMjBleGFnZ2VyYXRlZCUyMGZlYXR1cmVzJTJDJTIwZGFyayUyMGV5ZWJyb3dzJTJDJTIwYmx1ZSUyMGV5ZSUyMG1ha2V1cCUyQyUyMHJlZCUyMGxpcHMlMjBmb3JtaW5nJTIwYSUyMHdpZGUlMjBzbWlsZS4nJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdDb3N0dW1lJTIwYW5kJTIwTWFrZXVwJTIwLSUyMFNlY29uZCUyMEltYWdlJyUzQSUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnRGFyayUyMHN1aXQlMjB3aXRoJTIwYSUyMGZsb3dlciUyMG9uJTIwdGhlJTIwbGFwZWwlMkMlMjBob2xkaW5nJTIwYSUyMHBsYXlpbmclMjBjYXJkLiclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnUGFsZSUyMHNraW4lMkMlMjBncmVlbiUyMGhhaXIlMkMlMjB2ZXJ5JTIwcmVkJTIwbGlwcyUyMHdpdGglMjBhbiUyMGV4YWdnZXJhdGVkJTIwZ3Jpbi4nJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdDaGFyYWN0ZXIlMjBJZGVudGl0eSclM0ElMjAnVGhpcyUyMGNoYXJhY3RlciUyMHJlc2VtYmxlcyUyMGtub3duJTIwZGVwaWN0aW9ucyUyMG9mJTIwVGhlJTIwSm9rZXIlMjBmcm9tJTIwY29taWMlMjBib29rJTIwbWVkaWEuJyUwQSUyMCUyMCUyMCUyMCU3RA==",highlighted:`    {
        <span class="hljs-string">&#x27;Costume and Makeup - First Image&#x27;</span>: (
            <span class="hljs-string">&#x27;Purple coat and a purple silk-like cravat or tie over a mustard-yellow shirt.&#x27;</span>,
            <span class="hljs-string">&#x27;White face paint with exaggerated features, dark eyebrows, blue eye makeup, red lips forming a wide smile.&#x27;</span>
        ),
        <span class="hljs-string">&#x27;Costume and Makeup - Second Image&#x27;</span>: (
            <span class="hljs-string">&#x27;Dark suit with a flower on the lapel, holding a playing card.&#x27;</span>,
            <span class="hljs-string">&#x27;Pale skin, green hair, very red lips with an exaggerated grin.&#x27;</span>
        ),
        <span class="hljs-string">&#x27;Character Identity&#x27;</span>: <span class="hljs-string">&#x27;This character resembles known depictions of The Joker from comic book media.&#x27;</span>
    }`,wrap:!1}}),A=new te({props:{title:"提供动态检索图像",local:"提供动态检索图像",headingTag:"h2"}}),Y=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMnNtb2xhZ2VudHMlNUJhbGwlNUQlMjIlMjBoZWxpdW0lMjBzZWxlbml1bSUyMHB5dGhvbi1kb3RlbnY=",highlighted:'pip install <span class="hljs-string">&quot;smolagents[all]&quot;</span> helium selenium python-dotenv',wrap:!1}}),$=new m({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">search_item_ctrl_f</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span>, nth_result: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Searches for text on the current page via Ctrl + F and jumps to the nth occurrence.
    Args:
        text: The text to search for
        nth_result: Which occurrence to jump to (default: 1)
    &quot;&quot;&quot;</span>
    elements = driver.find_elements(By.XPATH, <span class="hljs-string">f&quot;//*[contains(text(), &#x27;<span class="hljs-subst">{text}</span>&#x27;)]&quot;</span>)
    <span class="hljs-keyword">if</span> nth_result &gt; <span class="hljs-built_in">len</span>(elements):
        <span class="hljs-keyword">raise</span> Exception(<span class="hljs-string">f&quot;Match n°<span class="hljs-subst">{nth_result}</span> not found (only <span class="hljs-subst">{<span class="hljs-built_in">len</span>(elements)}</span> matches found)&quot;</span>)
    result = <span class="hljs-string">f&quot;Found <span class="hljs-subst">{<span class="hljs-built_in">len</span>(elements)}</span> matches for &#x27;<span class="hljs-subst">{text}</span>&#x27;.&quot;</span>
    elem = elements[nth_result - <span class="hljs-number">1</span>]
    driver.execute_script(<span class="hljs-string">&quot;arguments[0].scrollIntoView(true);&quot;</span>, elem)
    result += <span class="hljs-string">f&quot;Focused on element <span class="hljs-subst">{nth_result}</span> of <span class="hljs-subst">{<span class="hljs-built_in">len</span>(elements)}</span>&quot;</span>
    <span class="hljs-keyword">return</span> result


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">go_back</span>() -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-string">&quot;&quot;&quot;Goes back to previous page.&quot;&quot;&quot;</span>
    driver.back()


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">close_popups</span>() -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Closes any visible modal or pop-up on the page. Use this to dismiss pop-up windows! This does not work on cookie consent banners.
    &quot;&quot;&quot;</span>
    webdriver.ActionChains(driver).send_keys(Keys.ESCAPE).perform()`,wrap:!1}}),q=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">save_screenshot</span>(<span class="hljs-params">step_log: ActionStep, agent: CodeAgent</span>) -&gt; <span class="hljs-literal">None</span>:
    sleep(<span class="hljs-number">1.0</span>)  <span class="hljs-comment"># 让 JavaScript 动画在截图之前完成</span>
    driver = helium.get_driver()
    current_step = step_log.step_number
    <span class="hljs-keyword">if</span> driver <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">for</span> step_logs <span class="hljs-keyword">in</span> agent.logs:  <span class="hljs-comment"># 从日志中删除先前的截图以进行精简处理</span>
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(step_log, ActionStep) <span class="hljs-keyword">and</span> step_log.step_number &lt;= current_step - <span class="hljs-number">2</span>:
                step_logs.observations_images = <span class="hljs-literal">None</span>
        png_bytes = driver.get_screenshot_as_png()
        image = Image.<span class="hljs-built_in">open</span>(BytesIO(png_bytes))
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Captured a browser screenshot: <span class="hljs-subst">{image.size}</span> pixels&quot;</span>)
        step_log.observations_images = [image.copy()]  <span class="hljs-comment"># 创建副本以确保其持久保存，重要！!</span>

    <span class="hljs-comment"># 使用当前 URL 更新观察结果 </span>
    url_info = <span class="hljs-string">f&quot;Current url: <span class="hljs-subst">{driver.current_url}</span>&quot;</span>
    step_log.observations = url_info <span class="hljs-keyword">if</span> step_logs.observations <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> step_log.observations + <span class="hljs-string">&quot;\\n&quot;</span> + url_info
    <span class="hljs-keyword">return</span>`,wrap:!1}}),D=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBPcGVuQUlTZXJ2ZXJNb2RlbCUyQyUyMER1Y2tEdWNrR29TZWFyY2hUb29sJTBBbW9kZWwlMjAlM0QlMjBPcGVuQUlTZXJ2ZXJNb2RlbChtb2RlbF9pZCUzRCUyMmdwdC00byUyMiklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QkR1Y2tEdWNrR29TZWFyY2hUb29sKCklMkMlMjBnb19iYWNrJTJDJTIwY2xvc2VfcG9wdXBzJTJDJTIwc2VhcmNoX2l0ZW1fY3RybF9mJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFkZGl0aW9uYWxfYXV0aG9yaXplZF9pbXBvcnRzJTNEJTVCJTIyaGVsaXVtJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RlcF9jYWxsYmFja3MlM0QlNUJzYXZlX3NjcmVlbnNob3QlNUQlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMHZlcmJvc2l0eV9sZXZlbCUzRDIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, OpenAIServerModel, DuckDuckGoSearchTool
model = OpenAIServerModel(model_id=<span class="hljs-string">&quot;gpt-4o&quot;</span>)

agent = CodeAgent(
    tools=[DuckDuckGoSearchTool(), go_back, close_popups, search_item_ctrl_f],
    model=model,
    additional_authorized_imports=[<span class="hljs-string">&quot;helium&quot;</span>],
    step_callbacks=[save_screenshot],
    max_steps=<span class="hljs-number">20</span>,
    verbosity_level=<span class="hljs-number">2</span>,
)`,wrap:!1}}),K=new m({props:{code:"YWdlbnQucnVuKCUyMiUyMiUyMiUwQUklMjBhbSUyMEFsZnJlZCUyQyUyMHRoZSUyMGJ1dGxlciUyMG9mJTIwV2F5bmUlMjBNYW5vciUyQyUyMHJlc3BvbnNpYmxlJTIwZm9yJTIwdmVyaWZ5aW5nJTIwdGhlJTIwaWRlbnRpdHklMjBvZiUyMGd1ZXN0cyUyMGF0JTIwcGFydHkuJTIwQSUyMHN1cGVyaGVybyUyMGhhcyUyMGFycml2ZWQlMjBhdCUyMHRoZSUyMGVudHJhbmNlJTIwY2xhaW1pbmclMjB0byUyMGJlJTIwV29uZGVyJTIwV29tYW4lMkMlMjBidXQlMjBJJTIwbmVlZCUyMHRvJTIwY29uZmlybSUyMGlmJTIwc2hlJTIwaXMlMjB3aG8lMjBzaGUlMjBzYXlzJTIwc2hlJTIwaXMuJTBBJTBBUGxlYXNlJTIwc2VhcmNoJTIwZm9yJTIwaW1hZ2VzJTIwb2YlMjBXb25kZXIlMjBXb21hbiUyMGFuZCUyMGdlbmVyYXRlJTIwYSUyMGRldGFpbGVkJTIwdmlzdWFsJTIwZGVzY3JpcHRpb24lMjBiYXNlZCUyMG9uJTIwdGhvc2UlMjBpbWFnZXMuJTIwQWRkaXRpb25hbGx5JTJDJTIwbmF2aWdhdGUlMjB0byUyMFdpa2lwZWRpYSUyMHRvJTIwZ2F0aGVyJTIwa2V5JTIwZGV0YWlscyUyMGFib3V0JTIwaGVyJTIwYXBwZWFyYW5jZS4lMjBXaXRoJTIwdGhpcyUyMGluZm9ybWF0aW9uJTJDJTIwSSUyMGNhbiUyMGRldGVybWluZSUyMHdoZXRoZXIlMjB0byUyMGdyYW50JTIwaGVyJTIwYWNjZXNzJTIwdG8lMjB0aGUlMjBldmVudC4lMEElMjIlMjIlMjIlMjAlMkIlMjBoZWxpdW1faW5zdHJ1Y3Rpb25zKQ==",highlighted:`agent.run(<span class="hljs-string">&quot;&quot;&quot;
I am Alfred, the butler of Wayne Manor, responsible for verifying the identity of guests at party. A superhero has arrived at the entrance claiming to be Wonder Woman, but I need to confirm if she is who she says she is.

Please search for images of Wonder Woman and generate a detailed visual description based on those images. Additionally, navigate to Wikipedia to gather key details about her appearance. With this information, I can determine whether to grant her access to the event.
&quot;&quot;&quot;</span> + helium_instructions)`,wrap:!1}}),tl=new m({props:{code:"RmluYWwlMjBhbnN3ZXIlM0ElMjBXb25kZXIlMjBXb21hbiUyMGlzJTIwdHlwaWNhbGx5JTIwZGVwaWN0ZWQlMjB3ZWFyaW5nJTIwYSUyMHJlZCUyMGFuZCUyMGdvbGQlMjBidXN0aWVyJTJDJTIwYmx1ZSUyMHNob3J0cyUyMG9yJTIwc2tpcnQlMjB3aXRoJTIwd2hpdGUlMjBzdGFycyUyQyUyMGElMjBnb2xkZW4lMjB0aWFyYSUyQyUyMHNpbHZlciUyMGJyYWNlbGV0cyUyQyUyMGFuZCUyMGElMjBnb2xkZW4lMjBMYXNzbyUyMG9mJTIwVHJ1dGguJTIwU2hlJTIwaXMlMjBQcmluY2VzcyUyMERpYW5hJTIwb2YlMjBUaGVteXNjaXJhJTJDJTIwa25vd24lMjBhcyUyMERpYW5hJTIwUHJpbmNlJTIwaW4lMjB0aGUlMjB3b3JsZCUyMG9mJTIwbWVuLg==",highlighted:'Final answer: Wonder Woman <span class="hljs-keyword">is</span> typically depicted wearing a red <span class="hljs-keyword">and</span> gold bustier, blue shorts <span class="hljs-keyword">or</span> skirt <span class="hljs-keyword">with</span> white stars, a golden tiara, silver bracelets, <span class="hljs-keyword">and</span> a golden Lasso of Truth. She <span class="hljs-keyword">is</span> Princess Diana of Themyscira, known <span class="hljs-keyword">as</span> Diana Prince <span class="hljs-keyword">in</span> the world of men.',wrap:!1}}),al=new te({props:{title:"进一步阅读",local:"进一步阅读",headingTag:"h2"}}),yl=new Ye({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/zh-CN/unit2/smolagents/vision_agents.mdx"}}),{c(){j=n("meta"),il=M(),Ul=n("p"),pl=M(),J(b.$$.fragment),ol=M(),J(h.$$.fragment),Tl=M(),u=n("blockquote"),u.innerHTML=ne,wl=M(),d=n("p"),d.textContent=ye,cl=M(),B=n("p"),B.textContent=Ue,rl=M(),J(Z.$$.fragment),jl=M(),C=n("blockquote"),C.innerHTML=Je,ml=M(),G=n("p"),G.textContent=ie,ul=M(),g=n("p"),g.textContent=pe,Cl=M(),f=n("p"),f.textContent=oe,Il=M(),V=n("p"),V.textContent=Te,bl=M(),J(W.$$.fragment),hl=M(),N=n("p"),N.textContent=we,dl=M(),J(k.$$.fragment),Bl=M(),Q=n("p"),Q.textContent=ce,Zl=M(),J(v.$$.fragment),Gl=M(),S=n("p"),S.textContent=re,gl=M(),J(A.$$.fragment),fl=M(),I=n("blockquote"),I.innerHTML=je,Vl=M(),R=n("p"),R.textContent=me,Wl=M(),E=n("p"),E.innerHTML=ue,Nl=M(),X=n("ol"),X.innerHTML=Ce,kl=M(),_=n("p"),_.innerHTML=Ie,Ql=M(),x=n("p"),x.innerHTML=be,vl=M(),F=n("p"),F.textContent=he,Sl=M(),J(Y.$$.fragment),Al=M(),H=n("p"),H.textContent=de,Rl=M(),J($.$$.fragment),El=M(),z=n("p"),z.innerHTML=Be,Xl=M(),J(q.$$.fragment),_l=M(),O=n("p"),O.innerHTML=Ze,xl=M(),L=n("p"),L.innerHTML=Ge,Fl=M(),J(D.$$.fragment),Yl=M(),P=n("p"),P.textContent=ge,Hl=M(),J(K.$$.fragment),$l=M(),ll=n("p"),ll.innerHTML=fe,zl=M(),el=n("p"),el.textContent=Ve,ql=M(),c=n("iframe"),Ol=M(),sl=n("p"),sl.textContent=Ne,Ll=M(),J(tl.$$.fragment),Dl=M(),Ml=n("p"),Ml.textContent=ke,Pl=M(),J(al.$$.fragment),Kl=M(),nl=n("ul"),nl.innerHTML=Qe,le=M(),J(yl.$$.fragment),ee=M(),Jl=n("p"),this.h()},l(l){const e=_e("svelte-u9bgzb",document.head);j=y(e,"META",{name:!0,content:!0}),e.forEach(s),il=a(l),Ul=y(l,"P",{}),Me(Ul).forEach(s),pl=a(l),i(b.$$.fragment,l),ol=a(l),i(h.$$.fragment,l),Tl=a(l),u=y(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),U(u)!=="svelte-1vuezum"&&(u.innerHTML=ne),wl=a(l),d=y(l,"P",{"data-svelte-h":!0}),U(d)!=="svelte-ksl1xk"&&(d.textContent=ye),cl=a(l),B=y(l,"P",{"data-svelte-h":!0}),U(B)!=="svelte-1um3ob9"&&(B.textContent=Ue),rl=a(l),i(Z.$$.fragment,l),jl=a(l),C=y(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),U(C)!=="svelte-dxofwd"&&(C.innerHTML=Je),ml=a(l),G=y(l,"P",{"data-svelte-h":!0}),U(G)!=="svelte-1qd13gq"&&(G.textContent=ie),ul=a(l),g=y(l,"P",{"data-svelte-h":!0}),U(g)!=="svelte-1q6qut6"&&(g.textContent=pe),Cl=a(l),f=y(l,"P",{"data-svelte-h":!0}),U(f)!=="svelte-1itui8i"&&(f.textContent=oe),Il=a(l),V=y(l,"P",{"data-svelte-h":!0}),U(V)!=="svelte-81kpp3"&&(V.textContent=Te),bl=a(l),i(W.$$.fragment,l),hl=a(l),N=y(l,"P",{"data-svelte-h":!0}),U(N)!=="svelte-kb0qgm"&&(N.textContent=we),dl=a(l),i(k.$$.fragment,l),Bl=a(l),Q=y(l,"P",{"data-svelte-h":!0}),U(Q)!=="svelte-1f8j327"&&(Q.textContent=ce),Zl=a(l),i(v.$$.fragment,l),Gl=a(l),S=y(l,"P",{"data-svelte-h":!0}),U(S)!=="svelte-163343l"&&(S.textContent=re),gl=a(l),i(A.$$.fragment,l),fl=a(l),I=y(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),U(I)!=="svelte-13egpd2"&&(I.innerHTML=je),Vl=a(l),R=y(l,"P",{"data-svelte-h":!0}),U(R)!=="svelte-1wbwqpp"&&(R.textContent=me),Wl=a(l),E=y(l,"P",{"data-svelte-h":!0}),U(E)!=="svelte-pugmlu"&&(E.innerHTML=ue),Nl=a(l),X=y(l,"OL",{"data-svelte-h":!0}),U(X)!=="svelte-18ara7e"&&(X.innerHTML=Ce),kl=a(l),_=y(l,"P",{"data-svelte-h":!0}),U(_)!=="svelte-14lsdgn"&&(_.innerHTML=Ie),Ql=a(l),x=y(l,"P",{"data-svelte-h":!0}),U(x)!=="svelte-1ds9sjb"&&(x.innerHTML=be),vl=a(l),F=y(l,"P",{"data-svelte-h":!0}),U(F)!=="svelte-18ge3jp"&&(F.textContent=he),Sl=a(l),i(Y.$$.fragment,l),Al=a(l),H=y(l,"P",{"data-svelte-h":!0}),U(H)!=="svelte-1r8l33u"&&(H.textContent=de),Rl=a(l),i($.$$.fragment,l),El=a(l),z=y(l,"P",{"data-svelte-h":!0}),U(z)!=="svelte-1fran84"&&(z.innerHTML=Be),Xl=a(l),i(q.$$.fragment,l),_l=a(l),O=y(l,"P",{"data-svelte-h":!0}),U(O)!=="svelte-1nv8ok"&&(O.innerHTML=Ze),xl=a(l),L=y(l,"P",{"data-svelte-h":!0}),U(L)!=="svelte-1wegvma"&&(L.innerHTML=Ge),Fl=a(l),i(D.$$.fragment,l),Yl=a(l),P=y(l,"P",{"data-svelte-h":!0}),U(P)!=="svelte-it8f81"&&(P.textContent=ge),Hl=a(l),i(K.$$.fragment,l),$l=a(l),ll=y(l,"P",{"data-svelte-h":!0}),U(ll)!=="svelte-1by02ir"&&(ll.innerHTML=fe),zl=a(l),el=y(l,"P",{"data-svelte-h":!0}),U(el)!=="svelte-16qdyih"&&(el.textContent=Ve),ql=a(l),c=y(l,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0,referrerpolicy:!0}),Me(c).forEach(s),Ol=a(l),sl=y(l,"P",{"data-svelte-h":!0}),U(sl)!=="svelte-68gsct"&&(sl.textContent=Ne),Ll=a(l),i(tl.$$.fragment,l),Dl=a(l),Ml=y(l,"P",{"data-svelte-h":!0}),U(Ml)!=="svelte-lzfhqo"&&(Ml.textContent=ke),Pl=a(l),i(al.$$.fragment,l),Kl=a(l),nl=y(l,"UL",{"data-svelte-h":!0}),U(nl)!=="svelte-86y154"&&(nl.innerHTML=Qe),le=a(l),i(yl.$$.fragment,l),ee=a(l),Jl=y(l,"P",{}),Me(Jl).forEach(s),this.h()},h(){r(j,"name","hf:doc:metadata"),r(j,"content",$e),r(u,"class","warning"),r(C,"class","tip"),r(I,"class","tip"),r(c,"width","560"),r(c,"height","315"),Se(c.src,We="https://www.youtube.com/embed/rObJel7-OLc?si=TnNwQ8rqXqun_pqE")||r(c,"src",We),r(c,"title","YouTube video player"),r(c,"frameborder","0"),r(c,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"),r(c,"referrerpolicy","strict-origin-when-cross-origin"),c.allowFullscreen=""},m(l,e){xe(document.head,j),t(l,il,e),t(l,Ul,e),t(l,pl,e),p(b,l,e),t(l,ol,e),p(h,l,e),t(l,Tl,e),t(l,u,e),t(l,wl,e),t(l,d,e),t(l,cl,e),t(l,B,e),t(l,rl,e),p(Z,l,e),t(l,jl,e),t(l,C,e),t(l,ml,e),t(l,G,e),t(l,ul,e),t(l,g,e),t(l,Cl,e),t(l,f,e),t(l,Il,e),t(l,V,e),t(l,bl,e),p(W,l,e),t(l,hl,e),t(l,N,e),t(l,dl,e),p(k,l,e),t(l,Bl,e),t(l,Q,e),t(l,Zl,e),p(v,l,e),t(l,Gl,e),t(l,S,e),t(l,gl,e),p(A,l,e),t(l,fl,e),t(l,I,e),t(l,Vl,e),t(l,R,e),t(l,Wl,e),t(l,E,e),t(l,Nl,e),t(l,X,e),t(l,kl,e),t(l,_,e),t(l,Ql,e),t(l,x,e),t(l,vl,e),t(l,F,e),t(l,Sl,e),p(Y,l,e),t(l,Al,e),t(l,H,e),t(l,Rl,e),p($,l,e),t(l,El,e),t(l,z,e),t(l,Xl,e),p(q,l,e),t(l,_l,e),t(l,O,e),t(l,xl,e),t(l,L,e),t(l,Fl,e),p(D,l,e),t(l,Yl,e),t(l,P,e),t(l,Hl,e),p(K,l,e),t(l,$l,e),t(l,ll,e),t(l,zl,e),t(l,el,e),t(l,ql,e),t(l,c,e),t(l,Ol,e),t(l,sl,e),t(l,Ll,e),p(tl,l,e),t(l,Dl,e),t(l,Ml,e),t(l,Pl,e),p(al,l,e),t(l,Kl,e),t(l,nl,e),t(l,le,e),p(yl,l,e),t(l,ee,e),t(l,Jl,e),se=!0},p:Ae,i(l){se||(o(b.$$.fragment,l),o(h.$$.fragment,l),o(Z.$$.fragment,l),o(W.$$.fragment,l),o(k.$$.fragment,l),o(v.$$.fragment,l),o(A.$$.fragment,l),o(Y.$$.fragment,l),o($.$$.fragment,l),o(q.$$.fragment,l),o(D.$$.fragment,l),o(K.$$.fragment,l),o(tl.$$.fragment,l),o(al.$$.fragment,l),o(yl.$$.fragment,l),se=!0)},o(l){T(b.$$.fragment,l),T(h.$$.fragment,l),T(Z.$$.fragment,l),T(W.$$.fragment,l),T(k.$$.fragment,l),T(v.$$.fragment,l),T(A.$$.fragment,l),T(Y.$$.fragment,l),T($.$$.fragment,l),T(q.$$.fragment,l),T(D.$$.fragment,l),T(K.$$.fragment,l),T(tl.$$.fragment,l),T(al.$$.fragment,l),T(yl.$$.fragment,l),se=!1},d(l){l&&(s(il),s(Ul),s(pl),s(ol),s(Tl),s(u),s(wl),s(d),s(cl),s(B),s(rl),s(jl),s(C),s(ml),s(G),s(ul),s(g),s(Cl),s(f),s(Il),s(V),s(bl),s(hl),s(N),s(dl),s(Bl),s(Q),s(Zl),s(Gl),s(S),s(gl),s(fl),s(I),s(Vl),s(R),s(Wl),s(E),s(Nl),s(X),s(kl),s(_),s(Ql),s(x),s(vl),s(F),s(Sl),s(Al),s(H),s(Rl),s(El),s(z),s(Xl),s(_l),s(O),s(xl),s(L),s(Fl),s(Yl),s(P),s(Hl),s($l),s(ll),s(zl),s(el),s(ql),s(c),s(Ol),s(sl),s(Ll),s(Dl),s(Ml),s(Pl),s(Kl),s(nl),s(le),s(ee),s(Jl)),s(j),w(b,l),w(h,l),w(Z,l),w(W,l),w(k,l),w(v,l),w(A,l),w(Y,l),w($,l),w(q,l),w(D,l),w(K,l),w(tl,l),w(al,l),w(yl,l)}}}const $e='{"title":"使用 smolagents 构建视觉智能体","local":"使用-smolagents-构建视觉智能体","sections":[{"title":"初始执行阶段提供图像","local":"初始执行阶段提供图像","sections":[],"depth":2},{"title":"提供动态检索图像","local":"提供动态检索图像","sections":[],"depth":2},{"title":"进一步阅读","local":"进一步阅读","sections":[],"depth":2}],"depth":1}';function ze(ae){return Re(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ls extends Ee{constructor(j){super(),Xe(this,j,ze,He,ve,{})}}export{ls as component};
