import{s as bt,n as jt,o as It}from"../chunks/scheduler.412302f6.js";import{S as Ct,i as Bt,g as o,s as n,r as p,A as $t,h as i,f as l,c as a,j as gt,u as r,x as m,k as Ut,y as Zt,a as s,v as M,d,t as T,w as J}from"../chunks/index.f36f02f5.js";import{C as c}from"../chunks/CodeBlock.f4a4ce81.js";import{D as Gt}from"../chunks/DocNotebookDropdown.1a2c1686.js";import{H as ae}from"../chunks/Heading.41d80af4.js";function Wt(Ke){let w,pe,oe,re,u,me,y,Me,h,et='This tutorial will teach how to fine-tune open LLMs like <a href="https://huggingface.co/google/gemma-7b" rel="nofollow">Google Gemma</a> on Google Cloud’s TPUs. In our example, we are going to leverage Hugging Face Optimum TPU, <a href="https://huggingface.co/docs/transformers/index" rel="nofollow">🤗 Transformers</a> and datasets.',de,f,Te,g,tt="Google Cloud TPUs are custom-designed AI accelerators, which are optimized for training and inference of large AI models. They are ideal for a variety of use cases, such as chatbots, code generation, media content generation, synthetic speech, vision services, recommendation engines, personalization models, among others.",Je,U,lt="Advantages of using TPUs include:",ce,b,st="<li>Designed to scale cost-efficiently for a wide range of AI workloads, spanning training, fine-tuning, and inference.</li> <li>Optimized for TensorFlow, PyTorch, and JAX, and are available in a variety of form factors, including edge devices, workstations, and cloud-based infrastructure.</li> <li>TPUs are available in Google Cloud, and have been integrated with Vertex AI, and Google Kubernetes Engine (GKE).</li>",we,j,ue,I,nt='For this example, a single-host <code>v5litepod8</code> TPU will be enough. To set up a TPU environment with Pytorch XLA, this <a href="https://cloud.google.com/tpu/docs/run-calculation-pytorch" rel="nofollow">Google Cloud guide</a> shows how to do that.',ye,C,at="We can use <code>ssh</code> or <code>gcloud</code> commands to log in to the remote TPU. Enable port-forwarding for the port <code>8888</code>, e.g.:",he,B,fe,$,ot="Once we have access to the TPU VM, we can clone the <code>optimum-tpu</code> repository containing the related notebook. Then we can install few packages used in this tutorial and launch the notebook:",ge,Z,Ue,G,it="We should then see the familiar Jupyter output that shows the address accessible from a browser:",be,W,je,v,pt='Since we are going to use the gated <code>gemma</code> model, we will need to log in using a <a href="https://huggingface.co/settings/tokens" rel="nofollow">Hugging Face token</a>:',Ie,k,Ce,R,Be,x,rt=`To fine-tune an LLM, it might be necessary to shard the model across the TPUs to prevent memory issues and enhance tuning performances. Fully Sharded Data Parallel is an algorithm that has been implemented on Pytorch and that allows to wrap modules to distribute them.
When using Pytorch/XLA on TPUs, <a href="https://pytorch.org/xla/master/#fully-sharded-data-parallel-via-spmd" rel="nofollow">FSDPv2</a> is an utility that re-expresses the famous FSDP algorithm using SPMD (Single Program Multiple Data). In <code>optimum-tpu</code> it is possible to use dedicated helpers to use FSPDv2. To enable it, you can use the dedicated function, that should be called at the beginning of the execution:`,$e,F,Ze,z,Ge,E,mt='We will use <a href="https://huggingface.co/datasets/databricks/databricks-dolly-15k" rel="nofollow">Dolly</a>, an open source dataset of instruction-following records on categories outlined in the <a href="https://arxiv.org/abs/2203.02155" rel="nofollow">InstructGPT</a> paper, including brainstorming, classification, closed QA, generation, information extraction, open QA, and summarization.',We,X,Mt="We will load the dataset from the hub:",ve,A,ke,N,dt="We can take a look to a sample:",Re,H,xe,_,Tt="We obtain a result similar to this:",Fe,Y,ze,V,Jt="We will define a formatting function that combines <code>instruction</code>, <code>context</code> and <code>response</code> fields, and tokenizes them in a complete prompt. We will use a tokenizer compatible with the model we intend to use.",Ee,Q,Xe,S,ct="It is now possible to use this function to map the dataset, where original columns can now be removed:",Ae,P,Ne,L,He,q,wt="We can now load the model that will be used for tuning. The dataset is now ready to be used for fine-tuning:",_e,D,Ye,O,ut='We’re now going to use <a href="https://huggingface.co/blog/peft" rel="nofollow">Parameter Efficient FineTuning PEFT</a> and <a href="https://huggingface.co/papers/2106.09685" rel="nofollow">Low-Rank Adaptation (LoRA)</a> to efficiently fine tune the model on the prepared dataset. In the <code>LoraConfig</code> instance we will define the <code>nn.Linear</code> operations that will be fine tuned.',Ve,K,Qe,ee,yt="The <code>optimum-tpu</code> dedicated function will help us obtain arguments so we can create the trainer instance.",Se,te,Pe,le,ht="Once everything is ready it tuning the model is as simple as calling a function!",Le,se,qe,ne,ft="After this, we have successfully fine-tuned the model on the Dolly dataset.",De,ie,Oe;return u=new Gt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/optimum-tpu/blob/main/language-modeling/gemma_tuning.ipynb"}]}}),y=new ae({props:{title:"Fine-Tune Gemma on Google TPU",local:"fine-tune-gemma-on-google-tpu",headingTag:"h1"}}),f=new ae({props:{title:"Google’s TPU",local:"googles-tpu",headingTag:"h3"}}),j=new ae({props:{title:"Environment Setup",local:"environment-setup",headingTag:"h3"}}),B=new c({props:{code:"Z2Nsb3VkJTIwY29tcHV0ZSUyMHRwdXMlMjB0cHUtdm0lMjBzc2glMjAlMjRUUFVfTkFNRSUyMCU1QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC0tem9uZSUzRCUyNFpPTkUlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAtLSUyMC1MJTIwODg4OCUzQWxvY2FsaG9zdCUzQTg4ODg=",highlighted:`gcloud compute tpus tpu-vm ssh $TPU_NAME \\
        --zone=$ZONE \\
        -- -L <span class="hljs-number">8888</span>:localhost:<span class="hljs-number">8888</span>`,wrap:!1}}),Z=new c({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRm9wdGltdW0tdHB1LmdpdCUwQSUyMyUyMEluc3RhbGwlMjBPcHRpbXVtJTIwdHB1JTBBcGlwJTIwaW5zdGFsbCUyMC1lJTIwLiUyMC1mJTIwaHR0cHMlM0ElMkYlMkZzdG9yYWdlLmdvb2dsZWFwaXMuY29tJTJGbGlidHB1LXJlbGVhc2VzJTJGaW5kZXguaHRtbCUwQSUyMyUyMEluc3RhbGwlMjBUUkwlMjBhbmQlMjBQRUZUJTIwZm9yJTIwdHJhaW5pbmclMjAoc2VlJTIwbGF0ZXIlMjBob3clMjB0aGV5JTIwYXJlJTIwdXNlZCklMEFwaXAlMjBpbnN0YWxsJTIwdHJsJTIwcGVmdCUwQSUyMyUyMEluc3RhbGwlMjBKdXB5dGVyJTIwbm90ZWJvb2slMEFwaXAlMjBpbnN0YWxsJTIwLVUlMjBqdXB5dGVybGFiJTIwbm90ZWJvb2slMEElMjMlMjBPcHRpb25hbGx5JTJDJTIwaW5zdGFsbCUyMHdpZGdldHMlMjBleHRlbnNpb25zJTIwZm9yJTIwYmV0dGVyJTIwcmVuZGVyaW5nJTBBcGlwJTIwaW5zdGFsbCUyMGlweXdpZGdldHMlMjB3aWRnZXRzbmJleHRlbnNpb24lMEElMjMlMjBDaGFuZ2UlMjBkaXJlY3RvcnklMjBhbmQlMjBsYXVuY2glMjBKdXB5dGVyJTIwbm90ZWJvb2slMEFjZCUyMG9wdGltdW0tdHB1JTJGZXhhbXBsZXMlMkZsYW5ndWFnZS1tb2RlbGluZyUwQWp1cHl0ZXIlMjBub3RlYm9vayUyMC0tcG9ydCUyMDg4ODg=",highlighted:`git clone https://github.com/huggingface/optimum-tpu.git
<span class="hljs-comment"># Install Optimum tpu</span>
pip install -e . -f https://storage.googleapis.com/libtpu-releases/index.html
<span class="hljs-comment"># Install TRL and PEFT for training (see later how they are used)</span>
pip install trl peft
<span class="hljs-comment"># Install Jupyter notebook</span>
pip install -U jupyterlab notebook
<span class="hljs-comment"># Optionally, install widgets extensions for better rendering</span>
pip install ipywidgets widgetsnbextension
<span class="hljs-comment"># Change directory and launch Jupyter notebook</span>
cd optimum-tpu/examples/language-modeling
jupyter notebook --port <span class="hljs-number">8888</span>`,wrap:!1}}),W=new c({props:{code:"aHR0cCUzQSUyRiUyRmxvY2FsaG9zdCUzQTg4ODglMkZ0cmVlJTNGdG9rZW4lM0QzY2ViMjQ2MTlkMGEyZjk5YWNmNWZiYTQxYzUxYjQ3NWIxZGRjZTdjYWRiMmExMzM=",highlighted:'<span class="hljs-attribute">http</span>://localhost:<span class="hljs-number">8888</span>/tree?token=<span class="hljs-number">3</span>ceb24619d0a2f99acf5fba41c51b475b1ddce7cadb2a133',wrap:!1}}),k=new c({props:{code:"IWh1Z2dpbmdmYWNlLWNsaSUyMGxvZ2luJTIwLS10b2tlbiUyMFlPVVJfSEZfVE9LRU4=",highlighted:"!huggingface-cli login --token YOUR_HF_TOKEN",wrap:!1}}),R=new ae({props:{title:"Enable FSDPv2",local:"enable-fsdpv2",headingTag:"h3"}}),F=new c({props:{code:"ZnJvbSUyMG9wdGltdW0udHB1JTIwaW1wb3J0JTIwZnNkcF92MiUwQSUwQSUwQWZzZHBfdjIudXNlX2ZzZHBfdjIoKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.tpu <span class="hljs-keyword">import</span> fsdp_v2


fsdp_v2.use_fsdp_v2()`,wrap:!1}}),z=new ae({props:{title:"Load and Prepare Dataset",local:"load-and-prepare-dataset",headingTag:"h3"}}),A=new c({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJkYXRhYnJpY2tzJTJGZGF0YWJyaWNrcy1kb2xseS0xNWslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset


dataset = load_dataset(<span class="hljs-string">&quot;databricks/databricks-dolly-15k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),H=new c({props:{code:"ZGF0YXNldCU1QjMyMSU1RA==",highlighted:'dataset[<span class="hljs-number">321</span>]',wrap:!1}}),Y=new c({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJXaGVuJTIwd2FzJTIwdGhlJTIwODA4OCUyMHByb2Nlc3NvciUyMHJlbGVhc2VkJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMCUyMlRoZSUyMDgwODYlMjAoYWxzbyUyMGNhbGxlZCUyMGlBUFglMjA4NiklMjBpcyUyMGElMjAxNi1iaXQlMjBtaWNyb3Byb2Nlc3NvciUyMGNoaXAlMjBkZXNpZ25lZCUyMGJ5JTIwSW50ZWwlMjBiZXR3ZWVuJTIwZWFybHklMjAxOTc2JTIwYW5kJTIwSnVuZSUyMDglMkMlMjAxOTc4JTJDJTIwd2hlbiUyMGl0JTIwd2FzJTIwcmVsZWFzZWQuJTIwVGhlJTIwSW50ZWwlMjA4MDg4JTJDJTIwcmVsZWFzZWQlMjBKdWx5JTIwMSUyQyUyMDE5NzklMkMlMjBpcyUyMGElMjBzbGlnaHRseSUyMG1vZGlmaWVkJTIwY2hpcCUyMHdpdGglMjBhbiUyMGV4dGVybmFsJTIwOC1iaXQlMjBkYXRhJTIwYnVzJTIwKGFsbG93aW5nJTIwdGhlJTIwdXNlJTIwb2YlMjBjaGVhcGVyJTIwYW5kJTIwZmV3ZXIlMjBzdXBwb3J0aW5nJTIwSUNzKSUyQyU1Qm5vdGUlMjAxJTVEJTIwYW5kJTIwaXMlMjBub3RhYmxlJTIwYXMlMjB0aGUlMjBwcm9jZXNzb3IlMjB1c2VkJTIwaW4lMjB0aGUlMjBvcmlnaW5hbCUyMElCTSUyMFBDJTIwZGVzaWduLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlc3BvbnNlJTIyJTNBJTIwJTIyVGhlJTIwSW50ZWwlMjA4MDg4JTIwcHJvY2Vzc29yJTIwd2FzJTIwcmVsZWFzZWQlMjBKdWx5JTIwMSUyQyUyMDE5NzkuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2F0ZWdvcnklMjIlM0ElMjAlMjJpbmZvcm1hdGlvbl9leHRyYWN0aW9uJTIyJTJDJTBBJTdE",highlighted:`{
    <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;When was the 8088 processor released?&quot;</span>,
    <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;The 8086 (also called iAPX 86) is a 16-bit microprocessor chip designed by Intel between early 1976 and June 8, 1978, when it was released. The Intel 8088, released July 1, 1979, is a slightly modified chip with an external 8-bit data bus (allowing the use of cheaper and fewer supporting ICs),[note 1] and is notable as the processor used in the original IBM PC design.&quot;</span>,
    <span class="hljs-string">&quot;response&quot;</span>: <span class="hljs-string">&quot;The Intel 8088 processor was released July 1, 1979.&quot;</span>,
    <span class="hljs-string">&quot;category&quot;</span>: <span class="hljs-string">&quot;information_extraction&quot;</span>,
}`,wrap:!1}}),Q=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBJTBBZGVmJTIwcHJlcHJvY2Vzc19mdW5jdGlvbihzYW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwaW5zdHJ1Y3Rpb24lMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwSW5zdHJ1Y3Rpb24lNUNuJTdCc2FtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMGNvbnRleHQlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQ29udGV4dCU1Q24lN0JzYW1wbGUlNUInY29udGV4dCclNUQlN0QlMjIlMjBpZiUyMGxlbihzYW1wbGUlNUIlMjJjb250ZXh0JTIyJTVEKSUyMCUzRSUyMDAlMjBlbHNlJTIwTm9uZSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwZiUyMiUyMyUyMyUyMyUyMEFuc3dlciU1Q24lN0JzYW1wbGUlNUIncmVzcG9uc2UnJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIzJTIwam9pbiUyMGFsbCUyMHRoZSUyMHBhcnRzJTIwdG9nZXRoZXIlMEElMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjAlMjIlNUNuJTVDbiUyMi5qb2luKCU1QmklMjBmb3IlMjBpJTIwaW4lMjAlNUJpbnN0cnVjdGlvbiUyQyUyMGNvbnRleHQlMkMlMjByZXNwb25zZSU1RCUyMGlmJTIwaSUyMGlzJTIwbm90JTIwTm9uZSU1RCklMEElMjAlMjAlMjAlMjBwcm9tcHQlMjAlMkIlM0QlMjB0b2tlbml6ZXIuZW9zX3Rva2VuJTBBJTIwJTIwJTIwJTIwc2FtcGxlJTVCJTIycHJvbXB0JTIyJTVEJTIwJTNEJTIwcHJvbXB0JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2FtcGxl",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer


model_id = <span class="hljs-string">&quot;google/gemma-2b&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(model_id)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">sample</span>):
    instruction = <span class="hljs-string">f&quot;### Instruction\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;instruction&#x27;</span>]}</span>&quot;</span>
    context = <span class="hljs-string">f&quot;### Context\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;context&#x27;</span>]}</span>&quot;</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;context&quot;</span>]) &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
    response = <span class="hljs-string">f&quot;### Answer\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;response&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-comment"># join all the parts together</span>
    prompt = <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> [instruction, context, response] <span class="hljs-keyword">if</span> i <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>])
    prompt += tokenizer.eos_token
    sample[<span class="hljs-string">&quot;prompt&quot;</span>] = prompt
    <span class="hljs-keyword">return</span> sample`,wrap:!1}}),P=new c({props:{code:"ZGF0YSUyMCUzRCUyMGRhdGFzZXQubWFwKHByZXByb2Nlc3NfZnVuY3Rpb24lMkMlMjByZW1vdmVfY29sdW1ucyUzRGxpc3QoZGF0YXNldC5mZWF0dXJlcykp",highlighted:'data = dataset.<span class="hljs-built_in">map</span>(preprocess_function, remove_columns=<span class="hljs-built_in">list</span>(dataset.features))',wrap:!1}}),L=new ae({props:{title:"Preparing the Model for Tuning",local:"preparing-the-model-for-tuning",headingTag:"h3"}}),D=new c({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9jYWNoZSUzREZhbHNlJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM


model = AutoModelForCausalLM.from_pretrained(model_id, use_cache=<span class="hljs-literal">False</span>, torch_dtype=torch.bfloat16)`,wrap:!1}}),K=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBJTBBJTIzJTIwU2V0JTIwdXAlMjBQRUZUJTIwTG9SQSUyMGZvciUyMGZpbmUtdHVuaW5nLiUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig


<span class="hljs-comment"># Set up PEFT LoRA for fine-tuning.</span>
lora_config = LoraConfig(
    r=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>],
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)`,wrap:!1}}),te=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEElMEElMjMlMjBTZXQlMjB1cCUyMHRoZSUyMEZTRFAlMjBhcmd1bWVudHMlMEFmc2RwX3RyYWluaW5nX2FyZ3MlMjAlM0QlMjBmc2RwX3YyLmdldF9mc2RwX3RyYWluaW5nX2FyZ3MobW9kZWwpJTBBJTBBJTIzJTIwU2V0JTIwdXAlMjB0aGUlMjB0cmFpbmVyJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDY0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3RyYWluX2Vwb2NocyUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNELTElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIyLiUyRm91dHB1dCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltJTNEJTIyYWRhZmFjdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhbG9hZGVyX2Ryb3BfbGFzdCUzRFRydWUlMkMlMjAlMjAlMjMlMjBSZXF1aXJlZCUyMGZvciUyMEZTRFB2Mi4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAqKmZzZHBfdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGxvcmFfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIycHJvbXB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3NlcV9sZW5ndGglM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwcGFja2luZyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer


<span class="hljs-comment"># Set up the FSDP arguments</span>
fsdp_training_args = fsdp_v2.get_fsdp_training_args(model)

<span class="hljs-comment"># Set up the trainer</span>
trainer = SFTTrainer(
    model=model,
    train_dataset=data,
    args=TrainingArguments(
        per_device_train_batch_size=<span class="hljs-number">64</span>,
        num_train_epochs=<span class="hljs-number">32</span>,
        max_steps=-<span class="hljs-number">1</span>,
        output_dir=<span class="hljs-string">&quot;./output&quot;</span>,
        optim=<span class="hljs-string">&quot;adafactor&quot;</span>,
        logging_steps=<span class="hljs-number">1</span>,
        dataloader_drop_last=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Required for FSDPv2.</span>
        **fsdp_training_args,
    ),
    peft_config=lora_config,
    dataset_text_field=<span class="hljs-string">&quot;prompt&quot;</span>,
    max_seq_length=<span class="hljs-number">1024</span>,
    packing=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),se=new c({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),{c(){w=o("meta"),pe=n(),oe=o("p"),re=n(),p(u.$$.fragment),me=n(),p(y.$$.fragment),Me=n(),h=o("p"),h.innerHTML=et,de=n(),p(f.$$.fragment),Te=n(),g=o("p"),g.textContent=tt,Je=n(),U=o("p"),U.textContent=lt,ce=n(),b=o("ul"),b.innerHTML=st,we=n(),p(j.$$.fragment),ue=n(),I=o("p"),I.innerHTML=nt,ye=n(),C=o("p"),C.innerHTML=at,he=n(),p(B.$$.fragment),fe=n(),$=o("p"),$.innerHTML=ot,ge=n(),p(Z.$$.fragment),Ue=n(),G=o("p"),G.textContent=it,be=n(),p(W.$$.fragment),je=n(),v=o("p"),v.innerHTML=pt,Ie=n(),p(k.$$.fragment),Ce=n(),p(R.$$.fragment),Be=n(),x=o("p"),x.innerHTML=rt,$e=n(),p(F.$$.fragment),Ze=n(),p(z.$$.fragment),Ge=n(),E=o("p"),E.innerHTML=mt,We=n(),X=o("p"),X.textContent=Mt,ve=n(),p(A.$$.fragment),ke=n(),N=o("p"),N.textContent=dt,Re=n(),p(H.$$.fragment),xe=n(),_=o("p"),_.textContent=Tt,Fe=n(),p(Y.$$.fragment),ze=n(),V=o("p"),V.innerHTML=Jt,Ee=n(),p(Q.$$.fragment),Xe=n(),S=o("p"),S.textContent=ct,Ae=n(),p(P.$$.fragment),Ne=n(),p(L.$$.fragment),He=n(),q=o("p"),q.textContent=wt,_e=n(),p(D.$$.fragment),Ye=n(),O=o("p"),O.innerHTML=ut,Ve=n(),p(K.$$.fragment),Qe=n(),ee=o("p"),ee.innerHTML=yt,Se=n(),p(te.$$.fragment),Pe=n(),le=o("p"),le.textContent=ht,Le=n(),p(se.$$.fragment),qe=n(),ne=o("p"),ne.textContent=ft,De=n(),ie=o("p"),this.h()},l(e){const t=$t("svelte-u9bgzb",document.head);w=i(t,"META",{name:!0,content:!0}),t.forEach(l),pe=a(e),oe=i(e,"P",{}),gt(oe).forEach(l),re=a(e),r(u.$$.fragment,e),me=a(e),r(y.$$.fragment,e),Me=a(e),h=i(e,"P",{"data-svelte-h":!0}),m(h)!=="svelte-1eyl6ah"&&(h.innerHTML=et),de=a(e),r(f.$$.fragment,e),Te=a(e),g=i(e,"P",{"data-svelte-h":!0}),m(g)!=="svelte-1b7l63t"&&(g.textContent=tt),Je=a(e),U=i(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1t3ma6h"&&(U.textContent=lt),ce=a(e),b=i(e,"UL",{"data-svelte-h":!0}),m(b)!=="svelte-1xvk4a5"&&(b.innerHTML=st),we=a(e),r(j.$$.fragment,e),ue=a(e),I=i(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-7nrw4x"&&(I.innerHTML=nt),ye=a(e),C=i(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1tvyrjh"&&(C.innerHTML=at),he=a(e),r(B.$$.fragment,e),fe=a(e),$=i(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-1l020lj"&&($.innerHTML=ot),ge=a(e),r(Z.$$.fragment,e),Ue=a(e),G=i(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-lrlfqs"&&(G.textContent=it),be=a(e),r(W.$$.fragment,e),je=a(e),v=i(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-10qjgoo"&&(v.innerHTML=pt),Ie=a(e),r(k.$$.fragment,e),Ce=a(e),r(R.$$.fragment,e),Be=a(e),x=i(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-yyu7nu"&&(x.innerHTML=rt),$e=a(e),r(F.$$.fragment,e),Ze=a(e),r(z.$$.fragment,e),Ge=a(e),E=i(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1tb12py"&&(E.innerHTML=mt),We=a(e),X=i(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1wwn9m7"&&(X.textContent=Mt),ve=a(e),r(A.$$.fragment,e),ke=a(e),N=i(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1dl8uqh"&&(N.textContent=dt),Re=a(e),r(H.$$.fragment,e),xe=a(e),_=i(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-c3pq85"&&(_.textContent=Tt),Fe=a(e),r(Y.$$.fragment,e),ze=a(e),V=i(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1de4s6"&&(V.innerHTML=Jt),Ee=a(e),r(Q.$$.fragment,e),Xe=a(e),S=i(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1qytp3e"&&(S.textContent=ct),Ae=a(e),r(P.$$.fragment,e),Ne=a(e),r(L.$$.fragment,e),He=a(e),q=i(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-10x3gbl"&&(q.textContent=wt),_e=a(e),r(D.$$.fragment,e),Ye=a(e),O=i(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1xe3p53"&&(O.innerHTML=ut),Ve=a(e),r(K.$$.fragment,e),Qe=a(e),ee=i(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-jiamyz"&&(ee.innerHTML=yt),Se=a(e),r(te.$$.fragment,e),Pe=a(e),le=i(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-1s9i2ux"&&(le.textContent=ht),Le=a(e),r(se.$$.fragment,e),qe=a(e),ne=i(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-1ebc61y"&&(ne.textContent=ft),De=a(e),ie=i(e,"P",{}),gt(ie).forEach(l),this.h()},h(){Ut(w,"name","hf:doc:metadata"),Ut(w,"content",vt)},m(e,t){Zt(document.head,w),s(e,pe,t),s(e,oe,t),s(e,re,t),M(u,e,t),s(e,me,t),M(y,e,t),s(e,Me,t),s(e,h,t),s(e,de,t),M(f,e,t),s(e,Te,t),s(e,g,t),s(e,Je,t),s(e,U,t),s(e,ce,t),s(e,b,t),s(e,we,t),M(j,e,t),s(e,ue,t),s(e,I,t),s(e,ye,t),s(e,C,t),s(e,he,t),M(B,e,t),s(e,fe,t),s(e,$,t),s(e,ge,t),M(Z,e,t),s(e,Ue,t),s(e,G,t),s(e,be,t),M(W,e,t),s(e,je,t),s(e,v,t),s(e,Ie,t),M(k,e,t),s(e,Ce,t),M(R,e,t),s(e,Be,t),s(e,x,t),s(e,$e,t),M(F,e,t),s(e,Ze,t),M(z,e,t),s(e,Ge,t),s(e,E,t),s(e,We,t),s(e,X,t),s(e,ve,t),M(A,e,t),s(e,ke,t),s(e,N,t),s(e,Re,t),M(H,e,t),s(e,xe,t),s(e,_,t),s(e,Fe,t),M(Y,e,t),s(e,ze,t),s(e,V,t),s(e,Ee,t),M(Q,e,t),s(e,Xe,t),s(e,S,t),s(e,Ae,t),M(P,e,t),s(e,Ne,t),M(L,e,t),s(e,He,t),s(e,q,t),s(e,_e,t),M(D,e,t),s(e,Ye,t),s(e,O,t),s(e,Ve,t),M(K,e,t),s(e,Qe,t),s(e,ee,t),s(e,Se,t),M(te,e,t),s(e,Pe,t),s(e,le,t),s(e,Le,t),M(se,e,t),s(e,qe,t),s(e,ne,t),s(e,De,t),s(e,ie,t),Oe=!0},p:jt,i(e){Oe||(d(u.$$.fragment,e),d(y.$$.fragment,e),d(f.$$.fragment,e),d(j.$$.fragment,e),d(B.$$.fragment,e),d(Z.$$.fragment,e),d(W.$$.fragment,e),d(k.$$.fragment,e),d(R.$$.fragment,e),d(F.$$.fragment,e),d(z.$$.fragment,e),d(A.$$.fragment,e),d(H.$$.fragment,e),d(Y.$$.fragment,e),d(Q.$$.fragment,e),d(P.$$.fragment,e),d(L.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),Oe=!0)},o(e){T(u.$$.fragment,e),T(y.$$.fragment,e),T(f.$$.fragment,e),T(j.$$.fragment,e),T(B.$$.fragment,e),T(Z.$$.fragment,e),T(W.$$.fragment,e),T(k.$$.fragment,e),T(R.$$.fragment,e),T(F.$$.fragment,e),T(z.$$.fragment,e),T(A.$$.fragment,e),T(H.$$.fragment,e),T(Y.$$.fragment,e),T(Q.$$.fragment,e),T(P.$$.fragment,e),T(L.$$.fragment,e),T(D.$$.fragment,e),T(K.$$.fragment,e),T(te.$$.fragment,e),T(se.$$.fragment,e),Oe=!1},d(e){e&&(l(pe),l(oe),l(re),l(me),l(Me),l(h),l(de),l(Te),l(g),l(Je),l(U),l(ce),l(b),l(we),l(ue),l(I),l(ye),l(C),l(he),l(fe),l($),l(ge),l(Ue),l(G),l(be),l(je),l(v),l(Ie),l(Ce),l(Be),l(x),l($e),l(Ze),l(Ge),l(E),l(We),l(X),l(ve),l(ke),l(N),l(Re),l(xe),l(_),l(Fe),l(ze),l(V),l(Ee),l(Xe),l(S),l(Ae),l(Ne),l(He),l(q),l(_e),l(Ye),l(O),l(Ve),l(Qe),l(ee),l(Se),l(Pe),l(le),l(Le),l(qe),l(ne),l(De),l(ie)),l(w),J(u,e),J(y,e),J(f,e),J(j,e),J(B,e),J(Z,e),J(W,e),J(k,e),J(R,e),J(F,e),J(z,e),J(A,e),J(H,e),J(Y,e),J(Q,e),J(P,e),J(L,e),J(D,e),J(K,e),J(te,e),J(se,e)}}}const vt='{"title":"Fine-Tune Gemma on Google TPU","local":"fine-tune-gemma-on-google-tpu","sections":[{"title":"Google’s TPU","local":"googles-tpu","sections":[],"depth":3},{"title":"Environment Setup","local":"environment-setup","sections":[],"depth":3},{"title":"Enable FSDPv2","local":"enable-fsdpv2","sections":[],"depth":3},{"title":"Load and Prepare Dataset","local":"load-and-prepare-dataset","sections":[],"depth":3},{"title":"Preparing the Model for Tuning","local":"preparing-the-model-for-tuning","sections":[],"depth":3}],"depth":1}';function kt(Ke){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xt extends Ct{constructor(w){super(),Bt(this,w,kt,Wt,bt,{})}}export{Xt as component};
