import{s as Ce,n as je,o as He}from"../chunks/scheduler.d6170356.js";import{S as We,i as Ze,g as o,s as n,r as f,A as Ge,h as i,f as a,c as l,j as xe,u as c,x as r,k as fe,y as Ve,a as s,v as u,d as g,t as h,w as y}from"../chunks/index.fcd4cc08.js";import{C as ce}from"../chunks/CodeBlock.7b16bdef.js";import{H as R}from"../chunks/Heading.8660bd0e.js";function Be(ue){let m,X,z,q,w,F,b,ge="🤗 <code>transformers</code> is a library maintained by Hugging Face and the community, for state-of-the-art Machine Learning for Pytorch, TensorFlow and JAX. It provides thousands of pretrained models to perform tasks on different modalities such as text, vision, and audio. We are a bit biased, but we really like 🤗 <code>transformers</code>!",P,T,Q,M,he='There are over 25,000 <code>transformers</code> models in the Hub which you can find by filtering at the left of <a href="https://huggingface.co/models?library=transformers&amp;sort=downloads" rel="nofollow">the models page</a>.',S,J,ye="You can find models for many different tasks:",E,v,we='<li>Extracting the answer from a context (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=question-answering&amp;sort=downloads" rel="nofollow">question-answering</a>).</li> <li>Creating summaries from a large text (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=summarization&amp;sort=downloads" rel="nofollow">summarization</a>).</li> <li>Classify text (e.g. as spam or not spam, <a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=text-classification&amp;sort=downloads" rel="nofollow">text-classification</a>).</li> <li>Generate a new text with models such as GPT (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=text-generation&amp;sort=downloads" rel="nofollow">text-generation</a>).</li> <li>Identify parts of speech (verb, subject, etc.) or entities (country, organization, etc.) in a sentence (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=token-classification&amp;sort=downloads" rel="nofollow">token-classification</a>).</li> <li>Transcribe audio files to text (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=automatic-speech-recognition&amp;sort=downloads" rel="nofollow">automatic-speech-recognition</a>).</li> <li>Classify the speaker or language in an audio file (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=audio-classification&amp;sort=downloads" rel="nofollow">audio-classification</a>).</li> <li>Detect objects in an image (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=object-detection&amp;sort=downloads" rel="nofollow">object-detection</a>).</li> <li>Segment an image (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=image-segmentation&amp;sort=downloads" rel="nofollow">image-segmentation</a>).</li> <li>Do Reinforcement Learning (<a href="https://huggingface.co/models?library=transformers&amp;pipeline_tag=reinforcement-learning&amp;sort=downloads" rel="nofollow">reinforcement-learning</a>)!</li>',Y,$,be="You can try out the models directly in the browser if you want to test them out without downloading them thanks to the in-browser widgets!",A,p,Te='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-transformers_widget.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-transformers_widget-dark.png"/>',N,I,D,U,Me="All <code>transformer</code> models are a line away from being used! Depending on how you want to use them, you can use the high-level API using the <code>pipeline</code> function or you can use <code>AutoModel</code> for more control.",K,k,O,_,Je="You can also load a model from a specific version (based on commit hash, tag name, or branch) as follows:",ee,x,te,C,ve="If you want to see how to load a specific model, you can click <code>Use in Transformers</code> and you will be given a working snippet that you can load it! If you need further information about the model architecture, you can also click the “Read model documentation” at the bottom of the snippet.",ae,d,$e='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-transformers_snippet.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-transformers_snippet-dark.png"/>',se,j,ne,H,Ie='To read all about sharing models with <code>transformers</code>, please head out to the <a href="https://huggingface.co/docs/transformers/model_sharing" rel="nofollow">Share a model</a> guide in the official documentation.',le,W,Ue="Many classes in <code>transformers</code>, such as the models and tokenizers, have a <code>push_to_hub</code> method that allows to easily upload the files to a repository.",oe,Z,ie,G,ke='There is much more you can do, so we suggest to review the <a href="https://huggingface.co/docs/transformers/model_sharing" rel="nofollow">Share a model</a> guide.',re,V,me,B,_e='<li>Transformers <a href="https://github.com/huggingface/transformers" rel="nofollow">library</a>.</li> <li>Transformers <a href="https://huggingface.co/docs/transformers/index" rel="nofollow">docs</a>.</li> <li>Share a model <a href="https://huggingface.co/docs/transformers/model_sharing" rel="nofollow">guide</a>.</li>',pe,L,de;return w=new R({props:{title:"Using 🤗 transformers at Hugging Face",local:"using--transformers-at-hugging-face",headingTag:"h1"}}),T=new R({props:{title:"Exploring 🤗 transformers in the Hub",local:"exploring--transformers-in-the-hub",headingTag:"h2"}}),I=new R({props:{title:"Using existing models",local:"using-existing-models",headingTag:"h2"}}),k=new ce({props:{code:"JTIzJTIwV2l0aCUyMHBpcGVsaW5lJTJDJTIwanVzdCUyMHNwZWNpZnklMjB0aGUlMjB0YXNrJTIwYW5kJTIwdGhlJTIwbW9kZWwlMjBpZCUyMGZyb20lMjB0aGUlMjBIdWIuJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBJTBBJTIzJTIwSWYlMjB5b3UlMjB3YW50JTIwbW9yZSUyMGNvbnRyb2wlMkMlMjB5b3UlMjB3aWxsJTIwbmVlZCUyMHRvJTIwZGVmaW5lJTIwdGhlJTIwdG9rZW5pemVyJTIwYW5kJTIwbW9kZWwuJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKQ==",highlighted:`<span class="hljs-comment"># With pipeline, just specify the task and the model id from the Hub.</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-comment"># If you want more control, you will need to define the tokenizer and model.</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)`,wrap:!1}}),x=new ce({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmp1bGllbi1jJTJGRXNwZXJCRVJUby1zbWFsbCUyMiUyQyUyMHJldmlzaW9uJTNEJTIydjIuMC4xJTIyJTIwJTIwJTIzJTIwdGFnJTIwbmFtZSUyQyUyMG9yJTIwYnJhbmNoJTIwbmFtZSUyQyUyMG9yJTIwY29tbWl0JTIwaGFzaCUwQSk=",highlighted:`model = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;julien-c/EsperBERTo-small&quot;</span>, revision=<span class="hljs-string">&quot;v2.0.1&quot;</span>  <span class="hljs-comment"># tag name, or branch name, or commit hash</span>
)`,wrap:!1}}),j=new R({props:{title:"Sharing your models",local:"sharing-your-models",headingTag:"h2"}}),Z=new ce({props:{code:"JTIzJTIwUHVzaGluZyUyMG1vZGVsJTIwdG8lMjB5b3VyJTIwb3duJTIwYWNjb3VudCUwQW1vZGVsLnB1c2hfdG9faHViKCUyMm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBJTBBJTIzJTIwUHVzaGluZyUyMHlvdXIlMjB0b2tlbml6ZXIlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybXktYXdlc29tZS1tb2RlbCUyMiklMEElMEElMjMlMjBQdXNoaW5nJTIwYWxsJTIwdGhpbmdzJTIwYWZ0ZXIlMjB0cmFpbmluZyUwQXRyYWluZXIucHVzaF90b19odWIoKQ==",highlighted:`<span class="hljs-comment"># Pushing model to your own account</span>
model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># Pushing your tokenizer</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># Pushing all things after training</span>
trainer.push_to_hub()`,wrap:!1}}),V=new R({props:{title:"Additional resources",local:"additional-resources",headingTag:"h2"}}),{c(){m=o("meta"),X=n(),z=o("p"),q=n(),f(w.$$.fragment),F=n(),b=o("p"),b.innerHTML=ge,P=n(),f(T.$$.fragment),Q=n(),M=o("p"),M.innerHTML=he,S=n(),J=o("p"),J.textContent=ye,E=n(),v=o("ul"),v.innerHTML=we,Y=n(),$=o("p"),$.textContent=be,A=n(),p=o("div"),p.innerHTML=Te,N=n(),f(I.$$.fragment),D=n(),U=o("p"),U.innerHTML=Me,K=n(),f(k.$$.fragment),O=n(),_=o("p"),_.textContent=Je,ee=n(),f(x.$$.fragment),te=n(),C=o("p"),C.innerHTML=ve,ae=n(),d=o("div"),d.innerHTML=$e,se=n(),f(j.$$.fragment),ne=n(),H=o("p"),H.innerHTML=Ie,le=n(),W=o("p"),W.innerHTML=Ue,oe=n(),f(Z.$$.fragment),ie=n(),G=o("p"),G.innerHTML=ke,re=n(),f(V.$$.fragment),me=n(),B=o("ul"),B.innerHTML=_e,pe=n(),L=o("p"),this.h()},l(e){const t=Ge("svelte-u9bgzb",document.head);m=i(t,"META",{name:!0,content:!0}),t.forEach(a),X=l(e),z=i(e,"P",{}),xe(z).forEach(a),q=l(e),c(w.$$.fragment,e),F=l(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-rpg67t"&&(b.innerHTML=ge),P=l(e),c(T.$$.fragment,e),Q=l(e),M=i(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-o4uiyf"&&(M.innerHTML=he),S=l(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-qpj6j"&&(J.textContent=ye),E=l(e),v=i(e,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-qjs9xt"&&(v.innerHTML=we),Y=l(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-apziil"&&($.textContent=be),A=l(e),p=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(p)!=="svelte-435q1z"&&(p.innerHTML=Te),N=l(e),c(I.$$.fragment,e),D=l(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1gtg5ls"&&(U.innerHTML=Me),K=l(e),c(k.$$.fragment,e),O=l(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-3407pd"&&(_.textContent=Je),ee=l(e),c(x.$$.fragment,e),te=l(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1quwgdt"&&(C.innerHTML=ve),ae=l(e),d=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(d)!=="svelte-125odup"&&(d.innerHTML=$e),se=l(e),c(j.$$.fragment,e),ne=l(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1qw74m4"&&(H.innerHTML=Ie),le=l(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1e42a6j"&&(W.innerHTML=Ue),oe=l(e),c(Z.$$.fragment,e),ie=l(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-t0bbcx"&&(G.innerHTML=ke),re=l(e),c(V.$$.fragment,e),me=l(e),B=i(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-1n31o8y"&&(B.innerHTML=_e),pe=l(e),L=i(e,"P",{}),xe(L).forEach(a),this.h()},h(){fe(m,"name","hf:doc:metadata"),fe(m,"content",ze),fe(p,"class","flex justify-center"),fe(d,"class","flex justify-center")},m(e,t){Ve(document.head,m),s(e,X,t),s(e,z,t),s(e,q,t),u(w,e,t),s(e,F,t),s(e,b,t),s(e,P,t),u(T,e,t),s(e,Q,t),s(e,M,t),s(e,S,t),s(e,J,t),s(e,E,t),s(e,v,t),s(e,Y,t),s(e,$,t),s(e,A,t),s(e,p,t),s(e,N,t),u(I,e,t),s(e,D,t),s(e,U,t),s(e,K,t),u(k,e,t),s(e,O,t),s(e,_,t),s(e,ee,t),u(x,e,t),s(e,te,t),s(e,C,t),s(e,ae,t),s(e,d,t),s(e,se,t),u(j,e,t),s(e,ne,t),s(e,H,t),s(e,le,t),s(e,W,t),s(e,oe,t),u(Z,e,t),s(e,ie,t),s(e,G,t),s(e,re,t),u(V,e,t),s(e,me,t),s(e,B,t),s(e,pe,t),s(e,L,t),de=!0},p:je,i(e){de||(g(w.$$.fragment,e),g(T.$$.fragment,e),g(I.$$.fragment,e),g(k.$$.fragment,e),g(x.$$.fragment,e),g(j.$$.fragment,e),g(Z.$$.fragment,e),g(V.$$.fragment,e),de=!0)},o(e){h(w.$$.fragment,e),h(T.$$.fragment,e),h(I.$$.fragment,e),h(k.$$.fragment,e),h(x.$$.fragment,e),h(j.$$.fragment,e),h(Z.$$.fragment,e),h(V.$$.fragment,e),de=!1},d(e){e&&(a(X),a(z),a(q),a(F),a(b),a(P),a(Q),a(M),a(S),a(J),a(E),a(v),a(Y),a($),a(A),a(p),a(N),a(D),a(U),a(K),a(O),a(_),a(ee),a(te),a(C),a(ae),a(d),a(se),a(ne),a(H),a(le),a(W),a(oe),a(ie),a(G),a(re),a(me),a(B),a(pe),a(L)),a(m),y(w,e),y(T,e),y(I,e),y(k,e),y(x,e),y(j,e),y(Z,e),y(V,e)}}}const ze='{"title":"Using 🤗 transformers at Hugging Face","local":"using--transformers-at-hugging-face","sections":[{"title":"Exploring 🤗 transformers in the Hub","local":"exploring--transformers-in-the-hub","sections":[],"depth":2},{"title":"Using existing models","local":"using-existing-models","sections":[],"depth":2},{"title":"Sharing your models","local":"sharing-your-models","sections":[],"depth":2},{"title":"Additional resources","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function Le(ue){return He(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pe extends We{constructor(m){super(),Ze(this,m,Le,Be,Ce,{})}}export{Pe as component};
