import{s as ye,n as be,o as Je}from"../chunks/scheduler.d6170356.js";import{S as Ue,i as je,g as i,s as a,r as c,A as $e,h as o,f as l,c as n,j as Te,u as d,x as p,k as ie,y as Ie,a as s,v as u,d as m,t as f,w as h}from"../chunks/index.fcd4cc08.js";import{C as oe}from"../chunks/CodeBlock.7b16bdef.js";import{H as V}from"../chunks/Heading.8660bd0e.js";function Ze(pe){let r,H,F,x,w,R,T,re='🤗 <a href="https://huggingface.co/docs/peft/index" rel="nofollow">Parameter-Efficient Fine-Tuning (PEFT)</a> is a library for efficiently adapting pre-trained language models to various downstream applications without fine-tuning all the model’s parameters.',N,y,X,b,ce='You can find PEFT models by filtering at the left of the <a href="https://huggingface.co/models?library=peft&amp;sort=trending" rel="nofollow">models page</a>.',Q,J,Y,U,de=`To get started, you can check out the <a href="https://huggingface.co/docs/peft/quicktour" rel="nofollow">Quick Tour in the PEFT docs</a>. To install, follow the <a href="https://huggingface.co/docs/peft/install" rel="nofollow">PEFT installation guide</a>.
You can also use the following one-line install through pip:`,P,j,L,$,S,I,ue="All PEFT models can be loaded from the Hub. To use a PEFT model you also need to load the base model that was fine-tuned, as shown below. Every fine-tuned model has the base model in its model card.",A,Z,z,k,me="Once loaded, you can pass your inputs to the tokenizer to prepare them, and call <code>model.generate()</code> in regular <code>transformers</code> fashion.",q,v,K,G,fe="It outputs the following:",D,E,O,W,he="If you want to load a specific PEFT model, you can click <code>Use in PEFT</code> in the model card and you will be given a working snippet!",ee,g,ge='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/peft_repo_light_new.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/peft_repo.png"/>',te,M,Me='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/peft_snippet_light.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/peft_snippet.png"/>',le,C,se,_,we='<li>PEFT <a href="https://github.com/huggingface/peft" rel="nofollow">repository</a></li> <li>PEFT <a href="https://huggingface.co/docs/peft/index" rel="nofollow">docs</a></li> <li>PEFT <a href="https://huggingface.co/models?library=peft&amp;sort=trending" rel="nofollow">models</a></li>',ae,B,ne;return w=new V({props:{title:"Using PEFT at Hugging Face",local:"using-peft-at-hugging-face",headingTag:"h1"}}),y=new V({props:{title:"Exploring PEFT on the Hub",local:"exploring-peft-on-the-hub",headingTag:"h2"}}),J=new V({props:{title:"Installation",local:"installation",headingTag:"h2"}}),j=new oe({props:{code:"JTI0JTIwcGlwJTIwaW5zdGFsbCUyMHBlZnQ=",highlighted:'$ pip <span class="hljs-keyword">install</span> peft',wrap:!1}}),$=new V({props:{title:"Using existing models",local:"using-existing-models",headingTag:"h2"}}),Z=new oe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTJDJTIwUGVmdENvbmZpZyUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjAlMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLXYwLjElMjIlMEFhZGFwdGVyX21vZGVsJTIwJTNEJTIwJTIyZGZ1cm1hbiUyRk1pc3RyYWwtN0ItSW5zdHJ1Y3QtdjAuMiUyMiUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwpJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsJTJDJTIwYWRhcHRlcl9tb2RlbCklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsKSUwQSUwQW1vZGVsJTIwJTNEJTIwbW9kZWwudG8oJTIyY3VkYSUyMiklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, PeftConfig

base_model = <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>
adapter_model = <span class="hljs-string">&quot;dfurman/Mistral-7B-Instruct-v0.2&quot;</span>

model = AutoModelForCausalLM.from_pretrained(base_model)
model = PeftModel.from_pretrained(model, adapter_model)
tokenizer = AutoTokenizer.from_pretrained(base_model)

model = model.to(<span class="hljs-string">&quot;cuda&quot;</span>)
model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),v=new oe({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRlbGwlMjBtZSUyMHRoZSUyMHJlY2lwZSUyMGZvciUyMGNob2NvbGF0ZSUyMGNoaXAlMjBjb29raWUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfaWRzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnRvKCUyMmN1ZGElMjIpJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMuZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`inputs = tokenizer(<span class="hljs-string">&quot;Tell me the recipe for chocolate chip cookie&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model.generate(input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].to(<span class="hljs-string">&quot;cuda&quot;</span>), max_new_tokens=<span class="hljs-number">10</span>)
    <span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])`,wrap:!1}}),E=new oe({props:{code:"VGVsbCUyMG1lJTIwdGhlJTIwcmVjaXBlJTIwZm9yJTIwY2hvY29sYXRlJTIwY2hpcCUyMGNvb2tpZSUyMGRvdWdoLiUwQSUwQTEuJTIwUHJlaGVhdCUyMG92ZW4lMjB0byUyMDM3NSUyMGRlZ3JlZXMlMjBGJTIwKDE5MCUyMGRlZ3JlZXMlMjBDKS4lMEEyLiUyMEluJTIwYSUyMGxhcmdlJTIwYm93bCUyQyUyMGNyZWFtJTIwdG9nZXRoZXIlMjAxJTJGMiUyMGN1cCUyMCgxJTIwc3RpY2spJTIwb2YlMjBidXR0ZXIlMjBvciUyMG1hcmdhcmluZSUyQyUyMDElMkYyJTIwY3VwJTIwZ3JhbnVsYXRlZCUyMHN1Z2FyJTJDJTIwYW5kJTIwMSUyRjIlMjBjdXAlMjBwYWNrZWQlMjBicm93biUyMHN1Z2FyLiUwQTMuJTIwQmVhdCUyMGluJTIwMSUyMGVnZyUyMGFuZCUyMDElMjB0ZWFzcG9vbiUyMHZhbmlsbGElMjBleHRyYWN0LiUwQTQuJTIwTWl4JTIwaW4lMjAxJTIwMSUyRjQlMjBjdXBzJTIwYWxsLXB1cnBvc2UlMjBmbG91ci4lMEE1LiUyMFN0aXIlMjBpbiUyMDElMkYyJTIwdGVhc3Bvb24lMjBiYWtpbmclMjBzb2RhJTIwYW5kJTIwMSUyRjIlMjB0ZWFzcG9vbiUyMHNhbHQuJTBBNi4lMjBGb2xkJTIwaW4lMjAzJTJGNCUyMGN1cCUyMHNlbWlzd2VldCUyMGNob2NvbGF0ZSUyMGNoaXBzLiUwQTcuJTIwRHJvcCUyMGJ5",highlighted:`Tell me the recipe for chocolate chip cookie dough.

1. Preheat oven to 375 degrees F (190 degrees C).
2. In a large bowl, cream together 1/2 cup (1 stick) of butter or margarine, 1/2 cup granulated sugar, and 1/2 cup packed brown sugar.
3. Beat in 1 egg and 1 teaspoon vanilla extract.
4. Mix in 1 1/4 cups all-purpose flour.
5. Stir in 1/2 teaspoon baking soda and 1/2 teaspoon salt.
6. Fold in 3/4 cup semisweet chocolate chips.
7. Drop by`,wrap:!1}}),C=new V({props:{title:"Additional resources",local:"additional-resources",headingTag:"h2"}}),{c(){r=i("meta"),H=a(),F=i("p"),x=a(),c(w.$$.fragment),R=a(),T=i("p"),T.innerHTML=re,N=a(),c(y.$$.fragment),X=a(),b=i("p"),b.innerHTML=ce,Q=a(),c(J.$$.fragment),Y=a(),U=i("p"),U.innerHTML=de,P=a(),c(j.$$.fragment),L=a(),c($.$$.fragment),S=a(),I=i("p"),I.textContent=ue,A=a(),c(Z.$$.fragment),z=a(),k=i("p"),k.innerHTML=me,q=a(),c(v.$$.fragment),K=a(),G=i("p"),G.textContent=fe,D=a(),c(E.$$.fragment),O=a(),W=i("p"),W.innerHTML=he,ee=a(),g=i("div"),g.innerHTML=ge,te=a(),M=i("div"),M.innerHTML=Me,le=a(),c(C.$$.fragment),se=a(),_=i("ul"),_.innerHTML=we,ae=a(),B=i("p"),this.h()},l(e){const t=$e("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(l),H=n(e),F=o(e,"P",{}),Te(F).forEach(l),x=n(e),d(w.$$.fragment,e),R=n(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1pze80r"&&(T.innerHTML=re),N=n(e),d(y.$$.fragment,e),X=n(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-515lb5"&&(b.innerHTML=ce),Q=n(e),d(J.$$.fragment,e),Y=n(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-11jm9nl"&&(U.innerHTML=de),P=n(e),d(j.$$.fragment,e),L=n(e),d($.$$.fragment,e),S=n(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1qqfp2y"&&(I.textContent=ue),A=n(e),d(Z.$$.fragment,e),z=n(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1ohlhfq"&&(k.innerHTML=me),q=n(e),d(v.$$.fragment,e),K=n(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-7whdhn"&&(G.textContent=fe),D=n(e),d(E.$$.fragment,e),O=n(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-gbpq7c"&&(W.innerHTML=he),ee=n(e),g=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(g)!=="svelte-1ulotkq"&&(g.innerHTML=ge),te=n(e),M=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(M)!=="svelte-ai6chf"&&(M.innerHTML=Me),le=n(e),d(C.$$.fragment,e),se=n(e),_=o(e,"UL",{"data-svelte-h":!0}),p(_)!=="svelte-z8ea3s"&&(_.innerHTML=we),ae=n(e),B=o(e,"P",{}),Te(B).forEach(l),this.h()},h(){ie(r,"name","hf:doc:metadata"),ie(r,"content",ke),ie(g,"class","flex justify-center"),ie(M,"class","flex justify-center")},m(e,t){Ie(document.head,r),s(e,H,t),s(e,F,t),s(e,x,t),u(w,e,t),s(e,R,t),s(e,T,t),s(e,N,t),u(y,e,t),s(e,X,t),s(e,b,t),s(e,Q,t),u(J,e,t),s(e,Y,t),s(e,U,t),s(e,P,t),u(j,e,t),s(e,L,t),u($,e,t),s(e,S,t),s(e,I,t),s(e,A,t),u(Z,e,t),s(e,z,t),s(e,k,t),s(e,q,t),u(v,e,t),s(e,K,t),s(e,G,t),s(e,D,t),u(E,e,t),s(e,O,t),s(e,W,t),s(e,ee,t),s(e,g,t),s(e,te,t),s(e,M,t),s(e,le,t),u(C,e,t),s(e,se,t),s(e,_,t),s(e,ae,t),s(e,B,t),ne=!0},p:be,i(e){ne||(m(w.$$.fragment,e),m(y.$$.fragment,e),m(J.$$.fragment,e),m(j.$$.fragment,e),m($.$$.fragment,e),m(Z.$$.fragment,e),m(v.$$.fragment,e),m(E.$$.fragment,e),m(C.$$.fragment,e),ne=!0)},o(e){f(w.$$.fragment,e),f(y.$$.fragment,e),f(J.$$.fragment,e),f(j.$$.fragment,e),f($.$$.fragment,e),f(Z.$$.fragment,e),f(v.$$.fragment,e),f(E.$$.fragment,e),f(C.$$.fragment,e),ne=!1},d(e){e&&(l(H),l(F),l(x),l(R),l(T),l(N),l(X),l(b),l(Q),l(Y),l(U),l(P),l(L),l(S),l(I),l(A),l(z),l(k),l(q),l(K),l(G),l(D),l(O),l(W),l(ee),l(g),l(te),l(M),l(le),l(se),l(_),l(ae),l(B)),l(r),h(w,e),h(y,e),h(J,e),h(j,e),h($,e),h(Z,e),h(v,e),h(E,e),h(C,e)}}}const ke='{"title":"Using PEFT at Hugging Face","local":"using-peft-at-hugging-face","sections":[{"title":"Exploring PEFT on the Hub","local":"exploring-peft-on-the-hub","sections":[],"depth":2},{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"Using existing models","local":"using-existing-models","sections":[],"depth":2},{"title":"Additional resources","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function ve(pe){return Je(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _e extends Ue{constructor(r){super(),je(this,r,ve,Ze,ye,{})}}export{_e as component};
