import{s as rn,n as un,o as an}from"../chunks/scheduler.0219f8bd.js";import{S as cn,i as pn,g as s,s as o,r as c,A as fn,h as n,f as l,c as d,j as a,u as p,x as r,k as u,y as hn,a as i,v as f,d as h,t as m,w as b}from"../chunks/index.f61edf3b.js";import{H as _,E as mn}from"../chunks/index.1218d110.js";function bn(Bd){let g,Qt,Yt,Xt,$,Zt,T,el,v,Kd='Utility functions to interact with the Hugging Face Hub (<a href="https://huggingface.co/models" rel="nofollow">https://huggingface.co/models</a>)',tl,y,Id='<li><a href="#module_utils/hub">utils/hub</a><ul><li><em>static</em><ul><li><a href="#module_utils/hub.getFile"><code>.getFile(urlOrPath)</code></a> ⇒ <code>Promise.&lt;(FileResponse|Response)&gt;</code></li> <li><a href="#module_utils/hub.getModelFile"><code>.getModelFile(path_or_repo_id, filename, [fatal], [options], [return_path])</code></a> ⇒ <code>Promise.&lt;(string|Uint8Array)&gt;</code><ul><li><a href="#module_utils/hub.getModelFile..cacheKey"><code>~cacheKey</code></a> : <code>string</code></li> <li><a href="#module_utils/hub.getModelFile..response"><code>~response</code></a> : <code>Response</code> | <code>FileResponse</code> | <code>undefined</code></li> <li><a href="#module_utils/hub.getModelFile..buffer"><code>~buffer</code></a> : <code>Uint8Array</code></li></ul></li> <li><a href="#module_utils/hub.getModelJSON"><code>.getModelJSON(modelPath, fileName, [fatal], [options])</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/hub..FileResponse">~FileResponse</a><ul><li><a href="#new_module_utils/hub..FileResponse_new"><code>new FileResponse(filePath)</code></a></li> <li><a href="#module_utils/hub..FileResponse+updateContentType"><code>.updateContentType()</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/hub..FileResponse+clone"><code>.clone()</code></a> ⇒ <code>FileResponse</code></li> <li><a href="#module_utils/hub..FileResponse+arrayBuffer"><code>.arrayBuffer()</code></a> ⇒ <code>Promise.&lt;ArrayBuffer&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+blob"><code>.blob()</code></a> ⇒ <code>Promise.&lt;Blob&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+text"><code>.text()</code></a> ⇒ <code>Promise.&lt;string&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+json"><code>.json()</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><a href="#module_utils/hub..FileCache">~FileCache</a><ul><li><a href="#new_module_utils/hub..FileCache_new"><code>new FileCache(path)</code></a></li> <li><a href="#module_utils/hub..FileCache+match"><code>.match(request)</code></a> ⇒ <code>Promise.&lt;(FileResponse|undefined)&gt;</code></li> <li><a href="#module_utils/hub..FileCache+put"><code>.put(request, response, [progress_callback])</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li></ul></li> <li><a href="#module_utils/hub..CONTENT_TYPE_MAP"><code>~CONTENT_TYPE_MAP</code></a></li> <li><a href="#module_utils/hub..isValidUrl"><code>~isValidUrl(string, [protocols], [validHosts])</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/hub..isValidHfModelId"><code>~isValidHfModelId(string)</code></a> ⇒ <code>boolean</code></li> <li><a href="#module_utils/hub..handleError"><code>~handleError(status, remoteURL, fatal)</code></a> ⇒ <code>null</code></li> <li><a href="#module_utils/hub..tryCache"><code>~tryCache(cache, ...names)</code></a> ⇒ <code>Promise.&lt;(FileResponse|Response|undefined)&gt;</code></li> <li><a href="#module_utils/hub..readResponse"><code>~readResponse(response, progress_callback)</code></a> ⇒ <code>Promise.&lt;Uint8Array&gt;</code></li> <li><a href="#module_utils/hub..pathJoin"><code>~pathJoin(...parts)</code></a> ⇒ <code>string</code></li> <li><a href="#module_utils/hub..ExternalData"><code>~ExternalData</code></a> : <code>boolean</code> | <code>number</code></li> <li><a href="#module_utils/hub..PretrainedOptions"><code>~PretrainedOptions</code></a> : <code>Object</code></li> <li><a href="#module_utils/hub..ModelSpecificPretrainedOptions"><code>~ModelSpecificPretrainedOptions</code></a> : <code>Object</code></li> <li><a href="#module_utils/hub..PretrainedModelOptions"><code>~PretrainedModelOptions</code></a> : <code>*</code></li></ul></li></ul></li>',ll,il,ol,P,dl,M,sl,R,kd="Helper function to get a file, using either the Fetch API or FileSystem API.",nl,C,qd='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(FileResponse|Response)&gt;</code> - A promise that resolves to a FileResponse object (if the file is retrieved using the FileSystem API), or a Response object (if the file is retrieved using the Fetch API).',rl,H,Dd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>urlOrPath</td><td><code>URL</code> | <code>string</code></td><td><p>The URL/path of the file to get.</p></td></tr></tbody>",ul,al,cl,x,pl,L,fl,F,Nd=`Retrieves a file from either a remote URL using the Fetch API or from the local file system using the FileSystem API.
If the filesystem is available and <code>env.useCache = true</code>, the file will be downloaded and cached.`,hl,w,Sd='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(string|Uint8Array)&gt;</code> - A Promise that resolves with the file content as a Uint8Array if <code>return_path</code> is false, or the file path as a string if <code>return_path</code> is true.<br/> <strong>Throws</strong>:',ml,A,zd="<li>Will throw an error if the file is not found and <code>fatal</code> is true.</li>",bl,E,Jd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>path_or_repo_id</td><td><code>string</code></td><td></td><td><p>This can be either:</p> <ul><li>a string, the <em>model id</em> of a model repo on huggingface.co.</li> <li>a path to a <em>directory</em> potentially containing the file.</li></ul></td> </tr><tr><td>filename</td><td><code>string</code></td><td></td><td><p>The name of the file to locate in <code>path_or_repo</code>.</p></td> </tr><tr><td>[fatal]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to throw an error if the file is not found.</p></td> </tr><tr><td>[options]</td><td><code>PretrainedOptions</code></td><td></td><td><p>An object containing optional parameters.</p></td> </tr><tr><td>[return_path]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to return the path of the file instead of the file content.</p></td></tr></tbody>",_l,j,Vd='<li><a href="#module_utils/hub.getModelFile"><code>.getModelFile(path_or_repo_id, filename, [fatal], [options], [return_path])</code></a> ⇒ <code>Promise.&lt;(string|Uint8Array)&gt;</code><ul><li><a href="#module_utils/hub.getModelFile..cacheKey"><code>~cacheKey</code></a> : <code>string</code></li> <li><a href="#module_utils/hub.getModelFile..response"><code>~response</code></a> : <code>Response</code> | <code>FileResponse</code> | <code>undefined</code></li> <li><a href="#module_utils/hub.getModelFile..buffer"><code>~buffer</code></a> : <code>Uint8Array</code></li></ul></li>',gl,$l,Tl,O,vl,U,yl,B,Wd='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',Pl,Ml,Rl,K,Cl,I,Hl,k,Yd='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',xl,Ll,Fl,q,wl,D,Al,N,Gd='<strong>Kind</strong>: inner property of <a href="#module_utils/hub.getModelFile"><code>getModelFile</code></a>',El,jl,Ol,S,Ul,z,Bl,J,Qd="Fetches a JSON file from a given path and file name.",Kl,V,Xd='<strong>Kind</strong>: static method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - The JSON data parsed into a JavaScript object.<br/> <strong>Throws</strong>:',Il,W,Zd="<li>Will throw an error if the file is not found and <code>fatal</code> is true.</li>",kl,Y,es="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>modelPath</td><td><code>string</code></td><td></td><td><p>The path to the directory containing the file.</p></td> </tr><tr><td>fileName</td><td><code>string</code></td><td></td><td><p>The name of the file to fetch.</p></td> </tr><tr><td>[fatal]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether to throw an error if the file is not found.</p></td> </tr><tr><td>[options]</td><td><code>PretrainedOptions</code></td><td></td><td><p>An object containing optional parameters.</p></td></tr></tbody>",ql,Dl,Nl,G,Sl,Q,zl,X,ts='<strong>Kind</strong>: inner class of <a href="#module_utils/hub"><code>utils/hub</code></a>',Jl,Z,ls='<li><a href="#module_utils/hub..FileResponse">~FileResponse</a><ul><li><a href="#new_module_utils/hub..FileResponse_new"><code>new FileResponse(filePath)</code></a></li> <li><a href="#module_utils/hub..FileResponse+updateContentType"><code>.updateContentType()</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/hub..FileResponse+clone"><code>.clone()</code></a> ⇒ <code>FileResponse</code></li> <li><a href="#module_utils/hub..FileResponse+arrayBuffer"><code>.arrayBuffer()</code></a> ⇒ <code>Promise.&lt;ArrayBuffer&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+blob"><code>.blob()</code></a> ⇒ <code>Promise.&lt;Blob&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+text"><code>.text()</code></a> ⇒ <code>Promise.&lt;string&gt;</code></li> <li><a href="#module_utils/hub..FileResponse+json"><code>.json()</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li>',Vl,Wl,Yl,ee,Gl,te,Ql,le,is="Creates a new <code>FileResponse</code> object.",Xl,ie,os="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>filePath</td><td><code>string</code></td></tr></tbody>",Zl,ei,ti,oe,li,de,ii,se,ds=`Updates the ‘content-type’ header property of the response based on the extension of
the file specified by the filePath property of the current object.`,oi,ne,ss='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a>',di,si,ni,re,ri,ue,ui,ae,ns="Clone the current FileResponse object.",ai,ce,rs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>FileResponse</code> - A new FileResponse object with the same properties as the current object.',ci,pi,fi,pe,hi,fe,mi,he,us=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with an ArrayBuffer containing the file’s contents.`,bi,me,as='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;ArrayBuffer&gt;</code> - A Promise that resolves with an ArrayBuffer containing the file’s contents.<br/> <strong>Throws</strong>:',_i,be,cs="<li><code>Error</code> If the file cannot be read.</li>",gi,$i,Ti,_e,vi,ge,yi,$e,ps=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a Blob containing the file’s contents.`,Pi,Te,fs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Blob&gt;</code> - A Promise that resolves with a Blob containing the file’s contents.<br/> <strong>Throws</strong>:',Mi,ve,hs="<li><code>Error</code> If the file cannot be read.</li>",Ri,Ci,Hi,ye,xi,Pe,Li,Me,ms=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a string containing the file’s contents.`,Fi,Re,bs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;string&gt;</code> - A Promise that resolves with a string containing the file’s contents.<br/> <strong>Throws</strong>:',wi,Ce,_s="<li><code>Error</code> If the file cannot be read.</li>",Ai,Ei,ji,He,Oi,xe,Ui,Le,gs=`Reads the contents of the file specified by the filePath property and returns a Promise that
resolves with a parsed JavaScript object containing the file’s contents.`,Bi,Fe,$s='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileResponse"><code>FileResponse</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - A Promise that resolves with a parsed JavaScript object containing the file’s contents.<br/> <strong>Throws</strong>:',Ki,we,Ts="<li><code>Error</code> If the file cannot be read.</li>",Ii,ki,qi,Ae,Di,Ee,Ni,je,vs='<strong>Kind</strong>: inner class of <a href="#module_utils/hub"><code>utils/hub</code></a>',Si,Oe,ys='<li><a href="#module_utils/hub..FileCache">~FileCache</a><ul><li><a href="#new_module_utils/hub..FileCache_new"><code>new FileCache(path)</code></a></li> <li><a href="#module_utils/hub..FileCache+match"><code>.match(request)</code></a> ⇒ <code>Promise.&lt;(FileResponse|undefined)&gt;</code></li> <li><a href="#module_utils/hub..FileCache+put"><code>.put(request, response, [progress_callback])</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li></ul></li>',zi,Ji,Vi,Ue,Wi,Be,Yi,Ke,Ps="Instantiate a <code>FileCache</code> object.",Gi,Ie,Ms="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>path</td><td><code>string</code></td></tr></tbody>",Qi,Xi,Zi,ke,eo,qe,to,De,Rs="Checks whether the given request is in the cache.",lo,Ne,Cs='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileCache"><code>FileCache</code></a>',io,Se,Hs="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>request</td><td><code>string</code></td></tr></tbody>",oo,so,no,ze,ro,Je,uo,Ve,xs="Adds the given response to the cache.",ao,We,Ls='<strong>Kind</strong>: instance method of <a href="#module_utils/hub..FileCache"><code>FileCache</code></a>',co,Ye,Fs=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>request</td><td><code>string</code></td><td></td> </tr><tr><td>response</td><td><code>Response</code></td><td></td> </tr><tr><td>[progress_callback]</td><td><code>*</code></td><td><p>Optional.
The function to call with progress updates</p></td></tr></tbody>`,po,fo,ho,Ge,mo,Qe,bo,Xe,ws="Mapping from file extensions to MIME types.",_o,Ze,As='<strong>Kind</strong>: inner constant of <a href="#module_utils/hub"><code>utils/hub</code></a>',go,$o,To,et,vo,tt,yo,lt,Es="Determines whether the given string is a valid URL.",Po,it,js='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>boolean</code> - True if the string is a valid URL, false otherwise.',Mo,ot,Os="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>string</td><td><code>string</code> | <code>URL</code></td><td></td><td><p>The string to test for validity as an URL.</p></td> </tr><tr><td>[protocols]</td><td><code>Array.&lt;string&gt;</code></td><td><code></code></td><td><p>A list of valid protocols. If specified, the protocol must be in this list.</p></td> </tr><tr><td>[validHosts]</td><td><code>Array.&lt;string&gt;</code></td><td><code></code></td><td><p>A list of valid hostnames. If specified, the URL&#39;s hostname must be in this list.</p></td></tr></tbody>",Ro,Co,Ho,dt,xo,st,Lo,nt,Us=`Tests whether a string is a valid Hugging Face model ID or not.
Adapted from <a href="https://github.com/huggingface/huggingface_hub/blob/6378820ebb03f071988a96c7f3268f5bdf8f9449/src/huggingface_hub/utils/_validators.py#L119-L170" rel="nofollow">https://github.com/huggingface/huggingface_hub/blob/6378820ebb03f071988a96c7f3268f5bdf8f9449/src/huggingface_hub/utils/_validators.py#L119-L170</a>`,Fo,rt,Bs='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>boolean</code> - True if the string is a valid model ID, false otherwise.',wo,ut,Ks="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>string</td><td><code>string</code></td><td><p>The string to test</p></td></tr></tbody>",Ao,Eo,jo,at,Oo,ct,Uo,pt,Is="Helper method to handle fatal errors that occur while trying to load a file from the Hugging Face Hub.",Bo,ft,ks='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>null</code> - Returns <code>null</code> if <code>fatal = true</code>.<br/> <strong>Throws</strong>:',Ko,ht,qs="<li><code>Error</code> If `fatal = false`.</li>",Io,mt,Ds="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>status</td><td><code>number</code></td><td><p>The HTTP status code of the error.</p></td> </tr><tr><td>remoteURL</td><td><code>string</code></td><td><p>The URL of the file that could not be loaded.</p></td> </tr><tr><td>fatal</td><td><code>boolean</code></td><td><p>Whether to raise an error if the file could not be loaded.</p></td></tr></tbody>",ko,qo,Do,bt,No,_t,So,gt,Ns='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(FileResponse|Response|undefined)&gt;</code> - The item from the cache, or undefined if not found.',zo,$t,Ss="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>cache</td><td><code>FileCache</code> | <code>Cache</code></td><td><p>The cache to search</p></td> </tr><tr><td>...names</td><td><code>Array.&lt;string&gt;</code></td><td><p>The names of the item to search for</p></td></tr></tbody>",Jo,Vo,Wo,Tt,Yo,vt,Go,yt,zs="Read and track progress when reading a Response object",Qo,Pt,Js='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Uint8Array&gt;</code> - A Promise that resolves with the Uint8Array buffer',Xo,Mt,Vs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>response</td><td><code>Response</code> | <code>FileResponse</code></td><td><p>The Response object to read</p></td> </tr><tr><td>progress_callback</td><td><code>*</code></td><td><p>The function to call with progress updates</p></td></tr></tbody>",Zo,ed,td,Rt,ld,Ct,id,Ht,Ws="Joins multiple parts of a path into a single path, while handling leading and trailing slashes.",od,xt,Ys='<strong>Kind</strong>: inner method of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Returns</strong>: <code>string</code> - A string representing the joined path.',dd,Lt,Gs="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...parts</td><td><code>string</code></td><td><p>Multiple parts of a path.</p></td></tr></tbody>",sd,nd,rd,Ft,ud,wt,ad,At,Qs=`Whether to load the model using the external data format (used for models &gt;= 2GB in size).
If <code>true</code>, the model will be loaded using the external data format.
If a number, this many chunks will be loaded using the external data format (of the form: “model.onnx<em>data[</em>{chunk_number}]”).`,cd,Et,Xs='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a>',pd,fd,hd,jt,md,Ot,bd,Ut,Zs="Options for loading a pretrained model.",_d,Bt,en='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Properties</strong>',gd,Kt,tn=`<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[progress_callback]</td><td><code>*</code></td><td><code></code></td><td><p>If specified, this function will be called during model construction, to provide the user with progress updates.</p></td> </tr><tr><td>[config]</td><td><code>*</code></td><td><code></code></td><td><p>Configuration for the model to use instead of an automatically loaded configuration. Configuration can be automatically loaded when:</p> <ul><li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained model).</li> <li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a configuration JSON file named <em>config.json</em> is found in the directory.</li></ul></td> </tr><tr><td>[cache_dir]</td><td><code>string</code></td><td><code>null</code></td><td><p>Path to a directory in which a downloaded pretrained model configuration should be cached if the standard cache should not be used.</p></td> </tr><tr><td>[local_files_only]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to only look at local files (e.g., not try downloading the model).</p></td> </tr><tr><td>[revision]</td><td><code>string</code></td><td><code>&quot;&#39;main&#39;&quot;</code></td><td><p>The specific model version to use. It can be a branch name, a tag name, or a commit id,
since we use a git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier allowed by git.
NOTE: This setting is ignored for local requests.</p></td></tr></tbody>`,$d,Td,vd,It,yd,kt,Pd,qt,ln="Options for loading a pretrained model.",Md,Dt,on='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a><br/> <strong>Properties</strong>',Rd,Nt,dn=`<thead><tr><th>Name</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[subfolder]</td><td><code>string</code></td><td><code>&quot;&#39;onnx&#39;&quot;</code></td><td><p>In case the relevant files are located inside a subfolder of the model repo on huggingface.co,
you can specify the folder name here.</p></td> </tr><tr><td>[model_file_name]</td><td><code>string</code></td><td><code>null</code></td><td><p>If specified, load the model with this name (excluding the .onnx suffix). Currently only valid for encoder- or decoder-only models.</p></td> </tr><tr><td>[device]</td><td><code>*</code></td><td><code></code></td><td><p>The device to run the model on. If not specified, the device will be chosen from the environment settings.</p></td> </tr><tr><td>[dtype]</td><td><code>*</code></td><td><code></code></td><td><p>The data type to use for the model. If not specified, the data type will be chosen from the environment settings.</p></td> </tr><tr><td>[use_external_data_format]</td><td><code>ExternalData</code> | <code>Record&lt;string, ExternalData&gt;</code></td><td><code>false</code></td><td><p>Whether to load the model using the external data format (used for models &gt;= 2GB in size).</p></td> </tr><tr><td>[session_options]</td><td><code>*</code></td><td></td><td><p>(Optional) User-specified session options passed to the runtime. If not provided, suitable defaults will be chosen.</p></td></tr></tbody>`,Cd,Hd,xd,St,Ld,zt,Fd,Jt,sn="Options for loading a pretrained model.",wd,Vt,nn='<strong>Kind</strong>: inner typedef of <a href="#module_utils/hub"><code>utils/hub</code></a>',Ad,Ed,jd,Wt,Od,Gt,Ud;return T=new _({props:{title:"utils/hub",local:"utilshub",headingTag:"h1"}}),M=new _({props:{title:"utils/hub.getFile(urlOrPath) ⇒ <code> Promise. < (FileResponse|Response) > </code>",local:"utilshubgetfileurlorpath--code-promise--fileresponseresponse--code",headingTag:"h2"}}),L=new _({props:{title:"utils/hub.getModelFile(path_or_repo_id, filename, [fatal], [options], [return_path]) ⇒ <code> Promise. < (string|Uint8Array) > </code>",local:"utilshubgetmodelfilepathorrepoid-filename-fatal-options-returnpath--code-promise--stringuint8array--code",headingTag:"h2"}}),U=new _({props:{title:"getModelFile~cacheKey : <code> string </code>",local:"getmodelfilecachekey--code-string-code",headingTag:"h3"}}),I=new _({props:{title:"getModelFile~response : <code> Response </code> | <code> FileResponse </code> | <code> undefined </code>",local:"getmodelfileresponse--code-response-code--code-fileresponse-code--code-undefined-code",headingTag:"h3"}}),D=new _({props:{title:"getModelFile~buffer : <code> Uint8Array </code>",local:"getmodelfilebuffer--code-uint8array-code",headingTag:"h3"}}),z=new _({props:{title:"utils/hub.getModelJSON(modelPath, fileName, [fatal], [options]) ⇒ <code> Promise. < Object > </code>",local:"utilshubgetmodeljsonmodelpath-filename-fatal-options--code-promise--object--code",headingTag:"h2"}}),Q=new _({props:{title:"utils/hub~FileResponse",local:"utilshubfileresponse",headingTag:"h2"}}),te=new _({props:{title:"new FileResponse(filePath)",local:"new-fileresponsefilepath",headingTag:"h3"}}),de=new _({props:{title:"fileResponse.updateContentType() ⇒ <code> void </code>",local:"fileresponseupdatecontenttype--code-void-code",headingTag:"h3"}}),ue=new _({props:{title:"fileResponse.clone() ⇒ <code> FileResponse </code>",local:"fileresponseclone--code-fileresponse-code",headingTag:"h3"}}),fe=new _({props:{title:"fileResponse.arrayBuffer() ⇒ <code> Promise. < ArrayBuffer > </code>",local:"fileresponsearraybuffer--code-promise--arraybuffer--code",headingTag:"h3"}}),ge=new _({props:{title:"fileResponse.blob() ⇒ <code> Promise. < Blob > </code>",local:"fileresponseblob--code-promise--blob--code",headingTag:"h3"}}),Pe=new _({props:{title:"fileResponse.text() ⇒ <code> Promise. < string > </code>",local:"fileresponsetext--code-promise--string--code",headingTag:"h3"}}),xe=new _({props:{title:"fileResponse.json() ⇒ <code> Promise. < Object > </code>",local:"fileresponsejson--code-promise--object--code",headingTag:"h3"}}),Ee=new _({props:{title:"utils/hub~FileCache",local:"utilshubfilecache",headingTag:"h2"}}),Be=new _({props:{title:"new FileCache(path)",local:"new-filecachepath",headingTag:"h3"}}),qe=new _({props:{title:"fileCache.match(request) ⇒ <code> Promise. < (FileResponse|undefined) > </code>",local:"filecachematchrequest--code-promise--fileresponseundefined--code",headingTag:"h3"}}),Je=new _({props:{title:"fileCache.put(request, response, [progress_callback]) ⇒ <code> Promise. < void > </code>",local:"filecacheputrequest-response-progresscallback--code-promise--void--code",headingTag:"h3"}}),Qe=new _({props:{title:"utils/hub~CONTENT_TYPE_MAP",local:"utilshubcontenttypemap",headingTag:"h2"}}),tt=new _({props:{title:"utils/hub~isValidUrl(string, [protocols], [validHosts]) ⇒ <code> boolean </code>",local:"utilshubisvalidurlstring-protocols-validhosts--code-boolean-code",headingTag:"h2"}}),st=new _({props:{title:"utils/hub~isValidHfModelId(string) ⇒ <code> boolean </code>",local:"utilshubisvalidhfmodelidstring--code-boolean-code",headingTag:"h2"}}),ct=new _({props:{title:"utils/hub~handleError(status, remoteURL, fatal) ⇒ <code> null </code>",local:"utilshubhandleerrorstatus-remoteurl-fatal--code-null-code",headingTag:"h2"}}),_t=new _({props:{title:"utils/hub~tryCache(cache, ...names) ⇒ <code> Promise. < (FileResponse|Response|undefined) > </code>",local:"utilshubtrycachecache-names--code-promise--fileresponseresponseundefined--code",headingTag:"h2"}}),vt=new _({props:{title:"utils/hub~readResponse(response, progress_callback) ⇒ <code> Promise. < Uint8Array > </code>",local:"utilshubreadresponseresponse-progresscallback--code-promise--uint8array--code",headingTag:"h2"}}),Ct=new _({props:{title:"utils/hub~pathJoin(...parts) ⇒ <code> string </code>",local:"utilshubpathjoinparts--code-string-code",headingTag:"h2"}}),wt=new _({props:{title:"utils/hub~ExternalData : <code> boolean </code> | <code> number </code>",local:"utilshubexternaldata--code-boolean-code--code-number-code",headingTag:"h2"}}),Ot=new _({props:{title:"utils/hub~PretrainedOptions : <code> Object </code>",local:"utilshubpretrainedoptions--code-object-code",headingTag:"h2"}}),kt=new _({props:{title:"utils/hub~ModelSpecificPretrainedOptions : <code> Object </code>",local:"utilshubmodelspecificpretrainedoptions--code-object-code",headingTag:"h2"}}),zt=new _({props:{title:"utils/hub~PretrainedModelOptions : <code> * </code>",local:"utilshubpretrainedmodeloptions--code--code",headingTag:"h2"}}),Wt=new mn({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/utils/hub.md"}}),{c(){g=s("meta"),Qt=o(),Yt=s("p"),Xt=o(),$=s("a"),Zt=o(),c(T.$$.fragment),el=o(),v=s("p"),v.innerHTML=Kd,tl=o(),y=s("ul"),y.innerHTML=Id,ll=o(),il=s("hr"),ol=o(),P=s("a"),dl=o(),c(M.$$.fragment),sl=o(),R=s("p"),R.textContent=kd,nl=o(),C=s("p"),C.innerHTML=qd,rl=o(),H=s("table"),H.innerHTML=Dd,ul=o(),al=s("hr"),cl=o(),x=s("a"),pl=o(),c(L.$$.fragment),fl=o(),F=s("p"),F.innerHTML=Nd,hl=o(),w=s("p"),w.innerHTML=Sd,ml=o(),A=s("ul"),A.innerHTML=zd,bl=o(),E=s("table"),E.innerHTML=Jd,_l=o(),j=s("ul"),j.innerHTML=Vd,gl=o(),$l=s("hr"),Tl=o(),O=s("a"),vl=o(),c(U.$$.fragment),yl=o(),B=s("p"),B.innerHTML=Wd,Pl=o(),Ml=s("hr"),Rl=o(),K=s("a"),Cl=o(),c(I.$$.fragment),Hl=o(),k=s("p"),k.innerHTML=Yd,xl=o(),Ll=s("hr"),Fl=o(),q=s("a"),wl=o(),c(D.$$.fragment),Al=o(),N=s("p"),N.innerHTML=Gd,El=o(),jl=s("hr"),Ol=o(),S=s("a"),Ul=o(),c(z.$$.fragment),Bl=o(),J=s("p"),J.textContent=Qd,Kl=o(),V=s("p"),V.innerHTML=Xd,Il=o(),W=s("ul"),W.innerHTML=Zd,kl=o(),Y=s("table"),Y.innerHTML=es,ql=o(),Dl=s("hr"),Nl=o(),G=s("a"),Sl=o(),c(Q.$$.fragment),zl=o(),X=s("p"),X.innerHTML=ts,Jl=o(),Z=s("ul"),Z.innerHTML=ls,Vl=o(),Wl=s("hr"),Yl=o(),ee=s("a"),Gl=o(),c(te.$$.fragment),Ql=o(),le=s("p"),le.innerHTML=is,Xl=o(),ie=s("table"),ie.innerHTML=os,Zl=o(),ei=s("hr"),ti=o(),oe=s("a"),li=o(),c(de.$$.fragment),ii=o(),se=s("p"),se.textContent=ds,oi=o(),ne=s("p"),ne.innerHTML=ss,di=o(),si=s("hr"),ni=o(),re=s("a"),ri=o(),c(ue.$$.fragment),ui=o(),ae=s("p"),ae.textContent=ns,ai=o(),ce=s("p"),ce.innerHTML=rs,ci=o(),pi=s("hr"),fi=o(),pe=s("a"),hi=o(),c(fe.$$.fragment),mi=o(),he=s("p"),he.textContent=us,bi=o(),me=s("p"),me.innerHTML=as,_i=o(),be=s("ul"),be.innerHTML=cs,gi=o(),$i=s("hr"),Ti=o(),_e=s("a"),vi=o(),c(ge.$$.fragment),yi=o(),$e=s("p"),$e.textContent=ps,Pi=o(),Te=s("p"),Te.innerHTML=fs,Mi=o(),ve=s("ul"),ve.innerHTML=hs,Ri=o(),Ci=s("hr"),Hi=o(),ye=s("a"),xi=o(),c(Pe.$$.fragment),Li=o(),Me=s("p"),Me.textContent=ms,Fi=o(),Re=s("p"),Re.innerHTML=bs,wi=o(),Ce=s("ul"),Ce.innerHTML=_s,Ai=o(),Ei=s("hr"),ji=o(),He=s("a"),Oi=o(),c(xe.$$.fragment),Ui=o(),Le=s("p"),Le.textContent=gs,Bi=o(),Fe=s("p"),Fe.innerHTML=$s,Ki=o(),we=s("ul"),we.innerHTML=Ts,Ii=o(),ki=s("hr"),qi=o(),Ae=s("a"),Di=o(),c(Ee.$$.fragment),Ni=o(),je=s("p"),je.innerHTML=vs,Si=o(),Oe=s("ul"),Oe.innerHTML=ys,zi=o(),Ji=s("hr"),Vi=o(),Ue=s("a"),Wi=o(),c(Be.$$.fragment),Yi=o(),Ke=s("p"),Ke.innerHTML=Ps,Gi=o(),Ie=s("table"),Ie.innerHTML=Ms,Qi=o(),Xi=s("hr"),Zi=o(),ke=s("a"),eo=o(),c(qe.$$.fragment),to=o(),De=s("p"),De.textContent=Rs,lo=o(),Ne=s("p"),Ne.innerHTML=Cs,io=o(),Se=s("table"),Se.innerHTML=Hs,oo=o(),so=s("hr"),no=o(),ze=s("a"),ro=o(),c(Je.$$.fragment),uo=o(),Ve=s("p"),Ve.textContent=xs,ao=o(),We=s("p"),We.innerHTML=Ls,co=o(),Ye=s("table"),Ye.innerHTML=Fs,po=o(),fo=s("hr"),ho=o(),Ge=s("a"),mo=o(),c(Qe.$$.fragment),bo=o(),Xe=s("p"),Xe.textContent=ws,_o=o(),Ze=s("p"),Ze.innerHTML=As,go=o(),$o=s("hr"),To=o(),et=s("a"),vo=o(),c(tt.$$.fragment),yo=o(),lt=s("p"),lt.textContent=Es,Po=o(),it=s("p"),it.innerHTML=js,Mo=o(),ot=s("table"),ot.innerHTML=Os,Ro=o(),Co=s("hr"),Ho=o(),dt=s("a"),xo=o(),c(st.$$.fragment),Lo=o(),nt=s("p"),nt.innerHTML=Us,Fo=o(),rt=s("p"),rt.innerHTML=Bs,wo=o(),ut=s("table"),ut.innerHTML=Ks,Ao=o(),Eo=s("hr"),jo=o(),at=s("a"),Oo=o(),c(ct.$$.fragment),Uo=o(),pt=s("p"),pt.textContent=Is,Bo=o(),ft=s("p"),ft.innerHTML=ks,Ko=o(),ht=s("ul"),ht.innerHTML=qs,Io=o(),mt=s("table"),mt.innerHTML=Ds,ko=o(),qo=s("hr"),Do=o(),bt=s("a"),No=o(),c(_t.$$.fragment),So=o(),gt=s("p"),gt.innerHTML=Ns,zo=o(),$t=s("table"),$t.innerHTML=Ss,Jo=o(),Vo=s("hr"),Wo=o(),Tt=s("a"),Yo=o(),c(vt.$$.fragment),Go=o(),yt=s("p"),yt.textContent=zs,Qo=o(),Pt=s("p"),Pt.innerHTML=Js,Xo=o(),Mt=s("table"),Mt.innerHTML=Vs,Zo=o(),ed=s("hr"),td=o(),Rt=s("a"),ld=o(),c(Ct.$$.fragment),id=o(),Ht=s("p"),Ht.textContent=Ws,od=o(),xt=s("p"),xt.innerHTML=Ys,dd=o(),Lt=s("table"),Lt.innerHTML=Gs,sd=o(),nd=s("hr"),rd=o(),Ft=s("a"),ud=o(),c(wt.$$.fragment),ad=o(),At=s("p"),At.innerHTML=Qs,cd=o(),Et=s("p"),Et.innerHTML=Xs,pd=o(),fd=s("hr"),hd=o(),jt=s("a"),md=o(),c(Ot.$$.fragment),bd=o(),Ut=s("p"),Ut.textContent=Zs,_d=o(),Bt=s("p"),Bt.innerHTML=en,gd=o(),Kt=s("table"),Kt.innerHTML=tn,$d=o(),Td=s("hr"),vd=o(),It=s("a"),yd=o(),c(kt.$$.fragment),Pd=o(),qt=s("p"),qt.textContent=ln,Md=o(),Dt=s("p"),Dt.innerHTML=on,Rd=o(),Nt=s("table"),Nt.innerHTML=dn,Cd=o(),Hd=s("hr"),xd=o(),St=s("a"),Ld=o(),c(zt.$$.fragment),Fd=o(),Jt=s("p"),Jt.textContent=sn,wd=o(),Vt=s("p"),Vt.innerHTML=nn,Ad=o(),Ed=s("hr"),jd=o(),c(Wt.$$.fragment),Od=o(),Gt=s("p"),this.h()},l(e){const t=fn("svelte-u9bgzb",document.head);g=n(t,"META",{name:!0,content:!0}),t.forEach(l),Qt=d(e),Yt=n(e,"P",{}),a(Yt).forEach(l),Xt=d(e),$=n(e,"A",{id:!0,class:!0}),a($).forEach(l),Zt=d(e),p(T.$$.fragment,e),el=d(e),v=n(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1jxl61c"&&(v.innerHTML=Kd),tl=d(e),y=n(e,"UL",{"data-svelte-h":!0}),r(y)!=="svelte-va6rzd"&&(y.innerHTML=Id),ll=d(e),il=n(e,"HR",{}),ol=d(e),P=n(e,"A",{id:!0,class:!0}),a(P).forEach(l),dl=d(e),p(M.$$.fragment,e),sl=d(e),R=n(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-10mshiw"&&(R.textContent=kd),nl=d(e),C=n(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1jj7eze"&&(C.innerHTML=qd),rl=d(e),H=n(e,"TABLE",{"data-svelte-h":!0}),r(H)!=="svelte-pbwhgs"&&(H.innerHTML=Dd),ul=d(e),al=n(e,"HR",{}),cl=d(e),x=n(e,"A",{id:!0,class:!0}),a(x).forEach(l),pl=d(e),p(L.$$.fragment,e),fl=d(e),F=n(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1l3bjq3"&&(F.innerHTML=Nd),hl=d(e),w=n(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1j9rqit"&&(w.innerHTML=Sd),ml=d(e),A=n(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-jl6z4b"&&(A.innerHTML=zd),bl=d(e),E=n(e,"TABLE",{"data-svelte-h":!0}),r(E)!=="svelte-bcbvl9"&&(E.innerHTML=Jd),_l=d(e),j=n(e,"UL",{"data-svelte-h":!0}),r(j)!=="svelte-1g40dlc"&&(j.innerHTML=Vd),gl=d(e),$l=n(e,"HR",{}),Tl=d(e),O=n(e,"A",{id:!0,class:!0}),a(O).forEach(l),vl=d(e),p(U.$$.fragment,e),yl=d(e),B=n(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1ys3w38"&&(B.innerHTML=Wd),Pl=d(e),Ml=n(e,"HR",{}),Rl=d(e),K=n(e,"A",{id:!0,class:!0}),a(K).forEach(l),Cl=d(e),p(I.$$.fragment,e),Hl=d(e),k=n(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1ys3w38"&&(k.innerHTML=Yd),xl=d(e),Ll=n(e,"HR",{}),Fl=d(e),q=n(e,"A",{id:!0,class:!0}),a(q).forEach(l),wl=d(e),p(D.$$.fragment,e),Al=d(e),N=n(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1ys3w38"&&(N.innerHTML=Gd),El=d(e),jl=n(e,"HR",{}),Ol=d(e),S=n(e,"A",{id:!0,class:!0}),a(S).forEach(l),Ul=d(e),p(z.$$.fragment,e),Bl=d(e),J=n(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1en2wh4"&&(J.textContent=Qd),Kl=d(e),V=n(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1l5qo0i"&&(V.innerHTML=Xd),Il=d(e),W=n(e,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-jl6z4b"&&(W.innerHTML=Zd),kl=d(e),Y=n(e,"TABLE",{"data-svelte-h":!0}),r(Y)!=="svelte-1iel3tk"&&(Y.innerHTML=es),ql=d(e),Dl=n(e,"HR",{}),Nl=d(e),G=n(e,"A",{id:!0,class:!0}),a(G).forEach(l),Sl=d(e),p(Q.$$.fragment,e),zl=d(e),X=n(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-16uuos4"&&(X.innerHTML=ts),Jl=d(e),Z=n(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-olh855"&&(Z.innerHTML=ls),Vl=d(e),Wl=n(e,"HR",{}),Yl=d(e),ee=n(e,"A",{id:!0,class:!0}),a(ee).forEach(l),Gl=d(e),p(te.$$.fragment,e),Ql=d(e),le=n(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-zzl0lp"&&(le.innerHTML=is),Xl=d(e),ie=n(e,"TABLE",{"data-svelte-h":!0}),r(ie)!=="svelte-19a8ff4"&&(ie.innerHTML=os),Zl=d(e),ei=n(e,"HR",{}),ti=d(e),oe=n(e,"A",{id:!0,class:!0}),a(oe).forEach(l),li=d(e),p(de.$$.fragment,e),ii=d(e),se=n(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1u1tjx3"&&(se.textContent=ds),oi=d(e),ne=n(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1sowe6d"&&(ne.innerHTML=ss),di=d(e),si=n(e,"HR",{}),ni=d(e),re=n(e,"A",{id:!0,class:!0}),a(re).forEach(l),ri=d(e),p(ue.$$.fragment,e),ui=d(e),ae=n(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-d8j2xp"&&(ae.textContent=ns),ai=d(e),ce=n(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-8jlahc"&&(ce.innerHTML=rs),ci=d(e),pi=n(e,"HR",{}),fi=d(e),pe=n(e,"A",{id:!0,class:!0}),a(pe).forEach(l),hi=d(e),p(fe.$$.fragment,e),mi=d(e),he=n(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1a8fecx"&&(he.textContent=us),bi=d(e),me=n(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-v2f2ae"&&(me.innerHTML=as),_i=d(e),be=n(e,"UL",{"data-svelte-h":!0}),r(be)!=="svelte-1f4f3jw"&&(be.innerHTML=cs),gi=d(e),$i=n(e,"HR",{}),Ti=d(e),_e=n(e,"A",{id:!0,class:!0}),a(_e).forEach(l),vi=d(e),p(ge.$$.fragment,e),yi=d(e),$e=n(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-h3zv97"&&($e.textContent=ps),Pi=d(e),Te=n(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1e723py"&&(Te.innerHTML=fs),Mi=d(e),ve=n(e,"UL",{"data-svelte-h":!0}),r(ve)!=="svelte-1f4f3jw"&&(ve.innerHTML=hs),Ri=d(e),Ci=n(e,"HR",{}),Hi=d(e),ye=n(e,"A",{id:!0,class:!0}),a(ye).forEach(l),xi=d(e),p(Pe.$$.fragment,e),Li=d(e),Me=n(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-jd4zuh"&&(Me.textContent=ms),Fi=d(e),Re=n(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1ozy582"&&(Re.innerHTML=bs),wi=d(e),Ce=n(e,"UL",{"data-svelte-h":!0}),r(Ce)!=="svelte-1f4f3jw"&&(Ce.innerHTML=_s),Ai=d(e),Ei=n(e,"HR",{}),ji=d(e),He=n(e,"A",{id:!0,class:!0}),a(He).forEach(l),Oi=d(e),p(xe.$$.fragment,e),Ui=d(e),Le=n(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-cd4397"&&(Le.textContent=gs),Bi=d(e),Fe=n(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-j83voe"&&(Fe.innerHTML=$s),Ki=d(e),we=n(e,"UL",{"data-svelte-h":!0}),r(we)!=="svelte-1f4f3jw"&&(we.innerHTML=Ts),Ii=d(e),ki=n(e,"HR",{}),qi=d(e),Ae=n(e,"A",{id:!0,class:!0}),a(Ae).forEach(l),Di=d(e),p(Ee.$$.fragment,e),Ni=d(e),je=n(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-16uuos4"&&(je.innerHTML=vs),Si=d(e),Oe=n(e,"UL",{"data-svelte-h":!0}),r(Oe)!=="svelte-13rgwxm"&&(Oe.innerHTML=ys),zi=d(e),Ji=n(e,"HR",{}),Vi=d(e),Ue=n(e,"A",{id:!0,class:!0}),a(Ue).forEach(l),Wi=d(e),p(Be.$$.fragment,e),Yi=d(e),Ke=n(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-pake4r"&&(Ke.innerHTML=Ps),Gi=d(e),Ie=n(e,"TABLE",{"data-svelte-h":!0}),r(Ie)!=="svelte-f03x1m"&&(Ie.innerHTML=Ms),Qi=d(e),Xi=n(e,"HR",{}),Zi=d(e),ke=n(e,"A",{id:!0,class:!0}),a(ke).forEach(l),eo=d(e),p(qe.$$.fragment,e),to=d(e),De=n(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-13oc2rp"&&(De.textContent=Rs),lo=d(e),Ne=n(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1wxlxpn"&&(Ne.innerHTML=Cs),io=d(e),Se=n(e,"TABLE",{"data-svelte-h":!0}),r(Se)!=="svelte-2kmk06"&&(Se.innerHTML=Hs),oo=d(e),so=n(e,"HR",{}),no=d(e),ze=n(e,"A",{id:!0,class:!0}),a(ze).forEach(l),ro=d(e),p(Je.$$.fragment,e),uo=d(e),Ve=n(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-bwoz3v"&&(Ve.textContent=xs),ao=d(e),We=n(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1wxlxpn"&&(We.innerHTML=Ls),co=d(e),Ye=n(e,"TABLE",{"data-svelte-h":!0}),r(Ye)!=="svelte-14il7x7"&&(Ye.innerHTML=Fs),po=d(e),fo=n(e,"HR",{}),ho=d(e),Ge=n(e,"A",{id:!0,class:!0}),a(Ge).forEach(l),mo=d(e),p(Qe.$$.fragment,e),bo=d(e),Xe=n(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-15u13r6"&&(Xe.textContent=ws),_o=d(e),Ze=n(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1tftvai"&&(Ze.innerHTML=As),go=d(e),$o=n(e,"HR",{}),To=d(e),et=n(e,"A",{id:!0,class:!0}),a(et).forEach(l),vo=d(e),p(tt.$$.fragment,e),yo=d(e),lt=n(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-fkm19c"&&(lt.textContent=Es),Po=d(e),it=n(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-xyh2rt"&&(it.innerHTML=js),Mo=d(e),ot=n(e,"TABLE",{"data-svelte-h":!0}),r(ot)!=="svelte-mnoe75"&&(ot.innerHTML=Os),Ro=d(e),Co=n(e,"HR",{}),Ho=d(e),dt=n(e,"A",{id:!0,class:!0}),a(dt).forEach(l),xo=d(e),p(st.$$.fragment,e),Lo=d(e),nt=n(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1xsms0j"&&(nt.innerHTML=Us),Fo=d(e),rt=n(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-1xbcdo6"&&(rt.innerHTML=Bs),wo=d(e),ut=n(e,"TABLE",{"data-svelte-h":!0}),r(ut)!=="svelte-mbdqas"&&(ut.innerHTML=Ks),Ao=d(e),Eo=n(e,"HR",{}),jo=d(e),at=n(e,"A",{id:!0,class:!0}),a(at).forEach(l),Oo=d(e),p(ct.$$.fragment,e),Uo=d(e),pt=n(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-112gzs0"&&(pt.textContent=Is),Bo=d(e),ft=n(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-9i72aw"&&(ft.innerHTML=ks),Ko=d(e),ht=n(e,"UL",{"data-svelte-h":!0}),r(ht)!=="svelte-w7pu3"&&(ht.innerHTML=qs),Io=d(e),mt=n(e,"TABLE",{"data-svelte-h":!0}),r(mt)!=="svelte-bpbhxc"&&(mt.innerHTML=Ds),ko=d(e),qo=n(e,"HR",{}),Do=d(e),bt=n(e,"A",{id:!0,class:!0}),a(bt).forEach(l),No=d(e),p(_t.$$.fragment,e),So=d(e),gt=n(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1h1o1yf"&&(gt.innerHTML=Ns),zo=d(e),$t=n(e,"TABLE",{"data-svelte-h":!0}),r($t)!=="svelte-17sk6uf"&&($t.innerHTML=Ss),Jo=d(e),Vo=n(e,"HR",{}),Wo=d(e),Tt=n(e,"A",{id:!0,class:!0}),a(Tt).forEach(l),Yo=d(e),p(vt.$$.fragment,e),Go=d(e),yt=n(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-1tqccie"&&(yt.textContent=zs),Qo=d(e),Pt=n(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-dyyw29"&&(Pt.innerHTML=Js),Xo=d(e),Mt=n(e,"TABLE",{"data-svelte-h":!0}),r(Mt)!=="svelte-9lzswd"&&(Mt.innerHTML=Vs),Zo=d(e),ed=n(e,"HR",{}),td=d(e),Rt=n(e,"A",{id:!0,class:!0}),a(Rt).forEach(l),ld=d(e),p(Ct.$$.fragment,e),id=d(e),Ht=n(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-7vbcne"&&(Ht.textContent=Ws),od=d(e),xt=n(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-wjfx67"&&(xt.innerHTML=Ys),dd=d(e),Lt=n(e,"TABLE",{"data-svelte-h":!0}),r(Lt)!=="svelte-61qi9d"&&(Lt.innerHTML=Gs),sd=d(e),nd=n(e,"HR",{}),rd=d(e),Ft=n(e,"A",{id:!0,class:!0}),a(Ft).forEach(l),ud=d(e),p(wt.$$.fragment,e),ad=d(e),At=n(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-1l14wsh"&&(At.innerHTML=Qs),cd=d(e),Et=n(e,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-ghvp2p"&&(Et.innerHTML=Xs),pd=d(e),fd=n(e,"HR",{}),hd=d(e),jt=n(e,"A",{id:!0,class:!0}),a(jt).forEach(l),md=d(e),p(Ot.$$.fragment,e),bd=d(e),Ut=n(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-1oi15lr"&&(Ut.textContent=Zs),_d=d(e),Bt=n(e,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-121rdz"&&(Bt.innerHTML=en),gd=d(e),Kt=n(e,"TABLE",{"data-svelte-h":!0}),r(Kt)!=="svelte-lhkacd"&&(Kt.innerHTML=tn),$d=d(e),Td=n(e,"HR",{}),vd=d(e),It=n(e,"A",{id:!0,class:!0}),a(It).forEach(l),yd=d(e),p(kt.$$.fragment,e),Pd=d(e),qt=n(e,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-1oi15lr"&&(qt.textContent=ln),Md=d(e),Dt=n(e,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-121rdz"&&(Dt.innerHTML=on),Rd=d(e),Nt=n(e,"TABLE",{"data-svelte-h":!0}),r(Nt)!=="svelte-3nlj0u"&&(Nt.innerHTML=dn),Cd=d(e),Hd=n(e,"HR",{}),xd=d(e),St=n(e,"A",{id:!0,class:!0}),a(St).forEach(l),Ld=d(e),p(zt.$$.fragment,e),Fd=d(e),Jt=n(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-1oi15lr"&&(Jt.textContent=sn),wd=d(e),Vt=n(e,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-ghvp2p"&&(Vt.innerHTML=nn),Ad=d(e),Ed=n(e,"HR",{}),jd=d(e),p(Wt.$$.fragment,e),Od=d(e),Gt=n(e,"P",{}),a(Gt).forEach(l),this.h()},h(){u(g,"name","hf:doc:metadata"),u(g,"content",_n),u($,"id","module_utils/hub"),u($,"class","group"),u(P,"id","module_utils/hub.getFile"),u(P,"class","group"),u(x,"id","module_utils/hub.getModelFile"),u(x,"class","group"),u(O,"id","module_utils/hub.getModelFile..cacheKey"),u(O,"class","group"),u(K,"id","module_utils/hub.getModelFile..response"),u(K,"class","group"),u(q,"id","module_utils/hub.getModelFile..buffer"),u(q,"class","group"),u(S,"id","module_utils/hub.getModelJSON"),u(S,"class","group"),u(G,"id","module_utils/hub..FileResponse"),u(G,"class","group"),u(ee,"id","new_module_utils/hub..FileResponse_new"),u(ee,"class","group"),u(oe,"id","module_utils/hub..FileResponse+updateContentType"),u(oe,"class","group"),u(re,"id","module_utils/hub..FileResponse+clone"),u(re,"class","group"),u(pe,"id","module_utils/hub..FileResponse+arrayBuffer"),u(pe,"class","group"),u(_e,"id","module_utils/hub..FileResponse+blob"),u(_e,"class","group"),u(ye,"id","module_utils/hub..FileResponse+text"),u(ye,"class","group"),u(He,"id","module_utils/hub..FileResponse+json"),u(He,"class","group"),u(Ae,"id","module_utils/hub..FileCache"),u(Ae,"class","group"),u(Ue,"id","new_module_utils/hub..FileCache_new"),u(Ue,"class","group"),u(ke,"id","module_utils/hub..FileCache+match"),u(ke,"class","group"),u(ze,"id","module_utils/hub..FileCache+put"),u(ze,"class","group"),u(Ge,"id","module_utils/hub..CONTENT_TYPE_MAP"),u(Ge,"class","group"),u(et,"id","module_utils/hub..isValidUrl"),u(et,"class","group"),u(dt,"id","module_utils/hub..isValidHfModelId"),u(dt,"class","group"),u(at,"id","module_utils/hub..handleError"),u(at,"class","group"),u(bt,"id","module_utils/hub..tryCache"),u(bt,"class","group"),u(Tt,"id","module_utils/hub..readResponse"),u(Tt,"class","group"),u(Rt,"id","module_utils/hub..pathJoin"),u(Rt,"class","group"),u(Ft,"id","module_utils/hub..ExternalData"),u(Ft,"class","group"),u(jt,"id","module_utils/hub..PretrainedOptions"),u(jt,"class","group"),u(It,"id","module_utils/hub..ModelSpecificPretrainedOptions"),u(It,"class","group"),u(St,"id","module_utils/hub..PretrainedModelOptions"),u(St,"class","group")},m(e,t){hn(document.head,g),i(e,Qt,t),i(e,Yt,t),i(e,Xt,t),i(e,$,t),i(e,Zt,t),f(T,e,t),i(e,el,t),i(e,v,t),i(e,tl,t),i(e,y,t),i(e,ll,t),i(e,il,t),i(e,ol,t),i(e,P,t),i(e,dl,t),f(M,e,t),i(e,sl,t),i(e,R,t),i(e,nl,t),i(e,C,t),i(e,rl,t),i(e,H,t),i(e,ul,t),i(e,al,t),i(e,cl,t),i(e,x,t),i(e,pl,t),f(L,e,t),i(e,fl,t),i(e,F,t),i(e,hl,t),i(e,w,t),i(e,ml,t),i(e,A,t),i(e,bl,t),i(e,E,t),i(e,_l,t),i(e,j,t),i(e,gl,t),i(e,$l,t),i(e,Tl,t),i(e,O,t),i(e,vl,t),f(U,e,t),i(e,yl,t),i(e,B,t),i(e,Pl,t),i(e,Ml,t),i(e,Rl,t),i(e,K,t),i(e,Cl,t),f(I,e,t),i(e,Hl,t),i(e,k,t),i(e,xl,t),i(e,Ll,t),i(e,Fl,t),i(e,q,t),i(e,wl,t),f(D,e,t),i(e,Al,t),i(e,N,t),i(e,El,t),i(e,jl,t),i(e,Ol,t),i(e,S,t),i(e,Ul,t),f(z,e,t),i(e,Bl,t),i(e,J,t),i(e,Kl,t),i(e,V,t),i(e,Il,t),i(e,W,t),i(e,kl,t),i(e,Y,t),i(e,ql,t),i(e,Dl,t),i(e,Nl,t),i(e,G,t),i(e,Sl,t),f(Q,e,t),i(e,zl,t),i(e,X,t),i(e,Jl,t),i(e,Z,t),i(e,Vl,t),i(e,Wl,t),i(e,Yl,t),i(e,ee,t),i(e,Gl,t),f(te,e,t),i(e,Ql,t),i(e,le,t),i(e,Xl,t),i(e,ie,t),i(e,Zl,t),i(e,ei,t),i(e,ti,t),i(e,oe,t),i(e,li,t),f(de,e,t),i(e,ii,t),i(e,se,t),i(e,oi,t),i(e,ne,t),i(e,di,t),i(e,si,t),i(e,ni,t),i(e,re,t),i(e,ri,t),f(ue,e,t),i(e,ui,t),i(e,ae,t),i(e,ai,t),i(e,ce,t),i(e,ci,t),i(e,pi,t),i(e,fi,t),i(e,pe,t),i(e,hi,t),f(fe,e,t),i(e,mi,t),i(e,he,t),i(e,bi,t),i(e,me,t),i(e,_i,t),i(e,be,t),i(e,gi,t),i(e,$i,t),i(e,Ti,t),i(e,_e,t),i(e,vi,t),f(ge,e,t),i(e,yi,t),i(e,$e,t),i(e,Pi,t),i(e,Te,t),i(e,Mi,t),i(e,ve,t),i(e,Ri,t),i(e,Ci,t),i(e,Hi,t),i(e,ye,t),i(e,xi,t),f(Pe,e,t),i(e,Li,t),i(e,Me,t),i(e,Fi,t),i(e,Re,t),i(e,wi,t),i(e,Ce,t),i(e,Ai,t),i(e,Ei,t),i(e,ji,t),i(e,He,t),i(e,Oi,t),f(xe,e,t),i(e,Ui,t),i(e,Le,t),i(e,Bi,t),i(e,Fe,t),i(e,Ki,t),i(e,we,t),i(e,Ii,t),i(e,ki,t),i(e,qi,t),i(e,Ae,t),i(e,Di,t),f(Ee,e,t),i(e,Ni,t),i(e,je,t),i(e,Si,t),i(e,Oe,t),i(e,zi,t),i(e,Ji,t),i(e,Vi,t),i(e,Ue,t),i(e,Wi,t),f(Be,e,t),i(e,Yi,t),i(e,Ke,t),i(e,Gi,t),i(e,Ie,t),i(e,Qi,t),i(e,Xi,t),i(e,Zi,t),i(e,ke,t),i(e,eo,t),f(qe,e,t),i(e,to,t),i(e,De,t),i(e,lo,t),i(e,Ne,t),i(e,io,t),i(e,Se,t),i(e,oo,t),i(e,so,t),i(e,no,t),i(e,ze,t),i(e,ro,t),f(Je,e,t),i(e,uo,t),i(e,Ve,t),i(e,ao,t),i(e,We,t),i(e,co,t),i(e,Ye,t),i(e,po,t),i(e,fo,t),i(e,ho,t),i(e,Ge,t),i(e,mo,t),f(Qe,e,t),i(e,bo,t),i(e,Xe,t),i(e,_o,t),i(e,Ze,t),i(e,go,t),i(e,$o,t),i(e,To,t),i(e,et,t),i(e,vo,t),f(tt,e,t),i(e,yo,t),i(e,lt,t),i(e,Po,t),i(e,it,t),i(e,Mo,t),i(e,ot,t),i(e,Ro,t),i(e,Co,t),i(e,Ho,t),i(e,dt,t),i(e,xo,t),f(st,e,t),i(e,Lo,t),i(e,nt,t),i(e,Fo,t),i(e,rt,t),i(e,wo,t),i(e,ut,t),i(e,Ao,t),i(e,Eo,t),i(e,jo,t),i(e,at,t),i(e,Oo,t),f(ct,e,t),i(e,Uo,t),i(e,pt,t),i(e,Bo,t),i(e,ft,t),i(e,Ko,t),i(e,ht,t),i(e,Io,t),i(e,mt,t),i(e,ko,t),i(e,qo,t),i(e,Do,t),i(e,bt,t),i(e,No,t),f(_t,e,t),i(e,So,t),i(e,gt,t),i(e,zo,t),i(e,$t,t),i(e,Jo,t),i(e,Vo,t),i(e,Wo,t),i(e,Tt,t),i(e,Yo,t),f(vt,e,t),i(e,Go,t),i(e,yt,t),i(e,Qo,t),i(e,Pt,t),i(e,Xo,t),i(e,Mt,t),i(e,Zo,t),i(e,ed,t),i(e,td,t),i(e,Rt,t),i(e,ld,t),f(Ct,e,t),i(e,id,t),i(e,Ht,t),i(e,od,t),i(e,xt,t),i(e,dd,t),i(e,Lt,t),i(e,sd,t),i(e,nd,t),i(e,rd,t),i(e,Ft,t),i(e,ud,t),f(wt,e,t),i(e,ad,t),i(e,At,t),i(e,cd,t),i(e,Et,t),i(e,pd,t),i(e,fd,t),i(e,hd,t),i(e,jt,t),i(e,md,t),f(Ot,e,t),i(e,bd,t),i(e,Ut,t),i(e,_d,t),i(e,Bt,t),i(e,gd,t),i(e,Kt,t),i(e,$d,t),i(e,Td,t),i(e,vd,t),i(e,It,t),i(e,yd,t),f(kt,e,t),i(e,Pd,t),i(e,qt,t),i(e,Md,t),i(e,Dt,t),i(e,Rd,t),i(e,Nt,t),i(e,Cd,t),i(e,Hd,t),i(e,xd,t),i(e,St,t),i(e,Ld,t),f(zt,e,t),i(e,Fd,t),i(e,Jt,t),i(e,wd,t),i(e,Vt,t),i(e,Ad,t),i(e,Ed,t),i(e,jd,t),f(Wt,e,t),i(e,Od,t),i(e,Gt,t),Ud=!0},p:un,i(e){Ud||(h(T.$$.fragment,e),h(M.$$.fragment,e),h(L.$$.fragment,e),h(U.$$.fragment,e),h(I.$$.fragment,e),h(D.$$.fragment,e),h(z.$$.fragment,e),h(Q.$$.fragment,e),h(te.$$.fragment,e),h(de.$$.fragment,e),h(ue.$$.fragment,e),h(fe.$$.fragment,e),h(ge.$$.fragment,e),h(Pe.$$.fragment,e),h(xe.$$.fragment,e),h(Ee.$$.fragment,e),h(Be.$$.fragment,e),h(qe.$$.fragment,e),h(Je.$$.fragment,e),h(Qe.$$.fragment,e),h(tt.$$.fragment,e),h(st.$$.fragment,e),h(ct.$$.fragment,e),h(_t.$$.fragment,e),h(vt.$$.fragment,e),h(Ct.$$.fragment,e),h(wt.$$.fragment,e),h(Ot.$$.fragment,e),h(kt.$$.fragment,e),h(zt.$$.fragment,e),h(Wt.$$.fragment,e),Ud=!0)},o(e){m(T.$$.fragment,e),m(M.$$.fragment,e),m(L.$$.fragment,e),m(U.$$.fragment,e),m(I.$$.fragment,e),m(D.$$.fragment,e),m(z.$$.fragment,e),m(Q.$$.fragment,e),m(te.$$.fragment,e),m(de.$$.fragment,e),m(ue.$$.fragment,e),m(fe.$$.fragment,e),m(ge.$$.fragment,e),m(Pe.$$.fragment,e),m(xe.$$.fragment,e),m(Ee.$$.fragment,e),m(Be.$$.fragment,e),m(qe.$$.fragment,e),m(Je.$$.fragment,e),m(Qe.$$.fragment,e),m(tt.$$.fragment,e),m(st.$$.fragment,e),m(ct.$$.fragment,e),m(_t.$$.fragment,e),m(vt.$$.fragment,e),m(Ct.$$.fragment,e),m(wt.$$.fragment,e),m(Ot.$$.fragment,e),m(kt.$$.fragment,e),m(zt.$$.fragment,e),m(Wt.$$.fragment,e),Ud=!1},d(e){e&&(l(Qt),l(Yt),l(Xt),l($),l(Zt),l(el),l(v),l(tl),l(y),l(ll),l(il),l(ol),l(P),l(dl),l(sl),l(R),l(nl),l(C),l(rl),l(H),l(ul),l(al),l(cl),l(x),l(pl),l(fl),l(F),l(hl),l(w),l(ml),l(A),l(bl),l(E),l(_l),l(j),l(gl),l($l),l(Tl),l(O),l(vl),l(yl),l(B),l(Pl),l(Ml),l(Rl),l(K),l(Cl),l(Hl),l(k),l(xl),l(Ll),l(Fl),l(q),l(wl),l(Al),l(N),l(El),l(jl),l(Ol),l(S),l(Ul),l(Bl),l(J),l(Kl),l(V),l(Il),l(W),l(kl),l(Y),l(ql),l(Dl),l(Nl),l(G),l(Sl),l(zl),l(X),l(Jl),l(Z),l(Vl),l(Wl),l(Yl),l(ee),l(Gl),l(Ql),l(le),l(Xl),l(ie),l(Zl),l(ei),l(ti),l(oe),l(li),l(ii),l(se),l(oi),l(ne),l(di),l(si),l(ni),l(re),l(ri),l(ui),l(ae),l(ai),l(ce),l(ci),l(pi),l(fi),l(pe),l(hi),l(mi),l(he),l(bi),l(me),l(_i),l(be),l(gi),l($i),l(Ti),l(_e),l(vi),l(yi),l($e),l(Pi),l(Te),l(Mi),l(ve),l(Ri),l(Ci),l(Hi),l(ye),l(xi),l(Li),l(Me),l(Fi),l(Re),l(wi),l(Ce),l(Ai),l(Ei),l(ji),l(He),l(Oi),l(Ui),l(Le),l(Bi),l(Fe),l(Ki),l(we),l(Ii),l(ki),l(qi),l(Ae),l(Di),l(Ni),l(je),l(Si),l(Oe),l(zi),l(Ji),l(Vi),l(Ue),l(Wi),l(Yi),l(Ke),l(Gi),l(Ie),l(Qi),l(Xi),l(Zi),l(ke),l(eo),l(to),l(De),l(lo),l(Ne),l(io),l(Se),l(oo),l(so),l(no),l(ze),l(ro),l(uo),l(Ve),l(ao),l(We),l(co),l(Ye),l(po),l(fo),l(ho),l(Ge),l(mo),l(bo),l(Xe),l(_o),l(Ze),l(go),l($o),l(To),l(et),l(vo),l(yo),l(lt),l(Po),l(it),l(Mo),l(ot),l(Ro),l(Co),l(Ho),l(dt),l(xo),l(Lo),l(nt),l(Fo),l(rt),l(wo),l(ut),l(Ao),l(Eo),l(jo),l(at),l(Oo),l(Uo),l(pt),l(Bo),l(ft),l(Ko),l(ht),l(Io),l(mt),l(ko),l(qo),l(Do),l(bt),l(No),l(So),l(gt),l(zo),l($t),l(Jo),l(Vo),l(Wo),l(Tt),l(Yo),l(Go),l(yt),l(Qo),l(Pt),l(Xo),l(Mt),l(Zo),l(ed),l(td),l(Rt),l(ld),l(id),l(Ht),l(od),l(xt),l(dd),l(Lt),l(sd),l(nd),l(rd),l(Ft),l(ud),l(ad),l(At),l(cd),l(Et),l(pd),l(fd),l(hd),l(jt),l(md),l(bd),l(Ut),l(_d),l(Bt),l(gd),l(Kt),l($d),l(Td),l(vd),l(It),l(yd),l(Pd),l(qt),l(Md),l(Dt),l(Rd),l(Nt),l(Cd),l(Hd),l(xd),l(St),l(Ld),l(Fd),l(Jt),l(wd),l(Vt),l(Ad),l(Ed),l(jd),l(Od),l(Gt)),l(g),b(T,e),b(M,e),b(L,e),b(U,e),b(I,e),b(D,e),b(z,e),b(Q,e),b(te,e),b(de,e),b(ue,e),b(fe,e),b(ge,e),b(Pe,e),b(xe,e),b(Ee,e),b(Be,e),b(qe,e),b(Je,e),b(Qe,e),b(tt,e),b(st,e),b(ct,e),b(_t,e),b(vt,e),b(Ct,e),b(wt,e),b(Ot,e),b(kt,e),b(zt,e),b(Wt,e)}}}const _n='{"title":"utils/hub","local":"utilshub","sections":[{"title":"utils/hub.getFile(urlOrPath) ⇒ <code> Promise. < (FileResponse|Response) > </code>","local":"utilshubgetfileurlorpath--code-promise--fileresponseresponse--code","sections":[],"depth":2},{"title":"utils/hub.getModelFile(path_or_repo_id, filename, [fatal], [options], [return_path]) ⇒ <code> Promise. < (string|Uint8Array) > </code>","local":"utilshubgetmodelfilepathorrepoid-filename-fatal-options-returnpath--code-promise--stringuint8array--code","sections":[{"title":"getModelFile~cacheKey : <code> string </code>","local":"getmodelfilecachekey--code-string-code","sections":[],"depth":3},{"title":"getModelFile~response : <code> Response </code> | <code> FileResponse </code> | <code> undefined </code>","local":"getmodelfileresponse--code-response-code--code-fileresponse-code--code-undefined-code","sections":[],"depth":3},{"title":"getModelFile~buffer : <code> Uint8Array </code>","local":"getmodelfilebuffer--code-uint8array-code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub.getModelJSON(modelPath, fileName, [fatal], [options]) ⇒ <code> Promise. < Object > </code>","local":"utilshubgetmodeljsonmodelpath-filename-fatal-options--code-promise--object--code","sections":[],"depth":2},{"title":"utils/hub~FileResponse","local":"utilshubfileresponse","sections":[{"title":"new FileResponse(filePath)","local":"new-fileresponsefilepath","sections":[],"depth":3},{"title":"fileResponse.updateContentType() ⇒ <code> void </code>","local":"fileresponseupdatecontenttype--code-void-code","sections":[],"depth":3},{"title":"fileResponse.clone() ⇒ <code> FileResponse </code>","local":"fileresponseclone--code-fileresponse-code","sections":[],"depth":3},{"title":"fileResponse.arrayBuffer() ⇒ <code> Promise. < ArrayBuffer > </code>","local":"fileresponsearraybuffer--code-promise--arraybuffer--code","sections":[],"depth":3},{"title":"fileResponse.blob() ⇒ <code> Promise. < Blob > </code>","local":"fileresponseblob--code-promise--blob--code","sections":[],"depth":3},{"title":"fileResponse.text() ⇒ <code> Promise. < string > </code>","local":"fileresponsetext--code-promise--string--code","sections":[],"depth":3},{"title":"fileResponse.json() ⇒ <code> Promise. < Object > </code>","local":"fileresponsejson--code-promise--object--code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub~FileCache","local":"utilshubfilecache","sections":[{"title":"new FileCache(path)","local":"new-filecachepath","sections":[],"depth":3},{"title":"fileCache.match(request) ⇒ <code> Promise. < (FileResponse|undefined) > </code>","local":"filecachematchrequest--code-promise--fileresponseundefined--code","sections":[],"depth":3},{"title":"fileCache.put(request, response, [progress_callback]) ⇒ <code> Promise. < void > </code>","local":"filecacheputrequest-response-progresscallback--code-promise--void--code","sections":[],"depth":3}],"depth":2},{"title":"utils/hub~CONTENT_TYPE_MAP","local":"utilshubcontenttypemap","sections":[],"depth":2},{"title":"utils/hub~isValidUrl(string, [protocols], [validHosts]) ⇒ <code> boolean </code>","local":"utilshubisvalidurlstring-protocols-validhosts--code-boolean-code","sections":[],"depth":2},{"title":"utils/hub~isValidHfModelId(string) ⇒ <code> boolean </code>","local":"utilshubisvalidhfmodelidstring--code-boolean-code","sections":[],"depth":2},{"title":"utils/hub~handleError(status, remoteURL, fatal) ⇒ <code> null </code>","local":"utilshubhandleerrorstatus-remoteurl-fatal--code-null-code","sections":[],"depth":2},{"title":"utils/hub~tryCache(cache, ...names) ⇒ <code> Promise. < (FileResponse|Response|undefined) > </code>","local":"utilshubtrycachecache-names--code-promise--fileresponseresponseundefined--code","sections":[],"depth":2},{"title":"utils/hub~readResponse(response, progress_callback) ⇒ <code> Promise. < Uint8Array > </code>","local":"utilshubreadresponseresponse-progresscallback--code-promise--uint8array--code","sections":[],"depth":2},{"title":"utils/hub~pathJoin(...parts) ⇒ <code> string </code>","local":"utilshubpathjoinparts--code-string-code","sections":[],"depth":2},{"title":"utils/hub~ExternalData : <code> boolean </code> | <code> number </code>","local":"utilshubexternaldata--code-boolean-code--code-number-code","sections":[],"depth":2},{"title":"utils/hub~PretrainedOptions : <code> Object </code>","local":"utilshubpretrainedoptions--code-object-code","sections":[],"depth":2},{"title":"utils/hub~ModelSpecificPretrainedOptions : <code> Object </code>","local":"utilshubmodelspecificpretrainedoptions--code-object-code","sections":[],"depth":2},{"title":"utils/hub~PretrainedModelOptions : <code> * </code>","local":"utilshubpretrainedmodeloptions--code--code","sections":[],"depth":2}],"depth":1}';function gn(Bd){return an(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yn extends cn{constructor(g){super(),pn(this,g,gn,bn,rn,{})}}export{yn as component};
