import{s as Bs,n as Cs,o as ks}from"../chunks/scheduler.987d3921.js";import{S as _s,i as zs,g as a,s as t,r as d,A as Zs,h as p,f as l,c as i,j as gs,u as c,x as r,k as Is,y as As,a as n,v as M,d as o,t as u,w as m}from"../chunks/index.c8b1fed4.js";import{C as w}from"../chunks/CodeBlock.e6da2eac.js";import{H as Le,E as Hs}from"../chunks/index.9c53df72.js";function Gs(De){let y,ae,te,pe,T,re,J,Ke=`In dieser Anleitung sehen wir uns an, wie Sie eine benutzerdefinierte Pipeline erstellen und sie auf dem <a href="https://hf.co/models" rel="nofollow">Hub</a> freigeben oder sie der
🤗 Transformers-Bibliothek hinzufügen.`,de,h,Oe=`Zuallererst müssen Sie entscheiden, welche Roheingaben die Pipeline verarbeiten kann. Es kann sich um Strings, rohe Bytes,
Dictionaries oder was auch immer die wahrscheinlichste gewünschte Eingabe ist. Versuchen Sie, diese Eingaben so rein wie möglich in Python zu halten
denn das macht die Kompatibilität einfacher (auch mit anderen Sprachen über JSON). Dies werden die Eingaben der
Pipeline (<code>Vorverarbeitung</code>).`,ce,j,es=`Definieren Sie dann die <code>Outputs</code>. Dieselbe Richtlinie wie für die Eingänge. Je einfacher, desto besser. Dies werden die Ausgaben der
Methode <code>Postprocess</code>.`,Me,f,ss=`Beginnen Sie damit, die Basisklasse <code>Pipeline</code> mit den 4 Methoden zu erben, die für die Implementierung von <code>preprocess</code> benötigt werden,
Weiterleiten”, “Nachbearbeitung” und “Parameter säubern”.`,oe,b,ue,U,ls=`Die Struktur dieser Aufteilung soll eine relativ nahtlose Unterstützung für CPU/GPU ermöglichen und gleichzeitig die Durchführung von
Vor-/Nachbearbeitung auf der CPU in verschiedenen Threads`,me,g,ns=`Preprocess” nimmt die ursprünglich definierten Eingaben und wandelt sie in etwas um, das in das Modell eingespeist werden kann. Es kann
mehr Informationen enthalten und ist normalerweise ein <code>Dict</code>.`,we,I,ts=`<code>_forward</code> ist das Implementierungsdetail und ist nicht dafür gedacht, direkt aufgerufen zu werden. Weiterleiten” ist die bevorzugte
aufgerufene Methode, da sie Sicherheitsvorkehrungen enthält, die sicherstellen, dass alles auf dem erwarteten Gerät funktioniert. Wenn etwas
mit einem realen Modell verknüpft ist, gehört es in die Methode <code>_forward</code>, alles andere gehört in die Methoden preprocess/postprocess.`,ye,B,is=`Die Methode <code>Postprocess</code> nimmt die Ausgabe von <code>_forward</code> und verwandelt sie in die endgültige Ausgabe, die zuvor festgelegt wurde.
zuvor entschieden wurde.`,Te,C,as=`Die Methode <code>_sanitize_parameters</code> ermöglicht es dem Benutzer, beliebige Parameter zu übergeben, wann immer er möchte, sei es bei der Initialisierung
Zeit <code>pipeline(...., maybe_arg=4)</code> oder zur Aufrufzeit <code>pipe = pipeline(...); output = pipe(...., maybe_arg=4)</code>.`,Je,k,ps=`Die Rückgabe von <code>_sanitize_parameters</code> sind die 3 Dicts von kwargs, die direkt an <code>preprocess</code> übergeben werden,
<code>_forward</code> und <code>postprocess</code> übergeben werden. Füllen Sie nichts aus, wenn der Aufrufer keinen zusätzlichen Parameter angegeben hat. Das
erlaubt es, die Standardargumente in der Funktionsdefinition beizubehalten, was immer “natürlicher” ist.`,he,_,rs="Ein klassisches Beispiel wäre das Argument <code>top_k</code> in der Nachbearbeitung bei Klassifizierungsaufgaben.",je,z,fe,Z,ds=`In order to achieve that, we’ll update our <code>postprocess</code> method with a default parameter to <code>5</code>. and edit
<code>_sanitize_parameters</code> to allow this new parameter.`,be,A,Ue,H,cs=`Versuchen Sie, die Eingaben/Ausgaben sehr einfach und idealerweise JSON-serialisierbar zu halten, da dies die Verwendung der Pipeline sehr einfach macht
ohne dass die Benutzer neue Arten von Objekten verstehen müssen. Es ist auch relativ üblich, viele verschiedene Arten von Argumenten zu unterstützen
von Argumenten zu unterstützen (Audiodateien, die Dateinamen, URLs oder reine Bytes sein können).`,ge,G,Ie,V,Ms="Um Ihre <code>neue Aufgabe</code> in die Liste der unterstützten Aufgaben aufzunehmen, müssen Sie sie zur <code>PIPELINE_REGISTRY</code> hinzufügen:",Be,W,Ce,E,os="Wenn Sie möchten, können Sie ein Standardmodell angeben. In diesem Fall sollte es mit einer bestimmten Revision (die der Name einer Verzweigung oder ein Commit-Hash sein kann, hier haben wir <code>&quot;abcdef&quot;</code> genommen) sowie mit dem Typ versehen sein:",ke,R,_e,X,ze,N,us=`Um Ihre benutzerdefinierte Pipeline auf dem Hub freizugeben, müssen Sie lediglich den benutzerdefinierten Code Ihrer <code>Pipeline</code>-Unterklasse in einer
Python-Datei speichern. Nehmen wir zum Beispiel an, Sie möchten eine benutzerdefinierte Pipeline für die Klassifizierung von Satzpaaren wie folgt verwenden:`,Ze,v,Ae,q,ms=`Die Implementierung ist Framework-unabhängig und funktioniert für PyTorch- und TensorFlow-Modelle. Wenn wir dies in einer Datei
einer Datei namens <code>pair_classification.py</code> gespeichert haben, können wir sie importieren und wie folgt registrieren:`,He,$,Ge,S,ws=`Sobald dies geschehen ist, können wir es mit einem vortrainierten Modell verwenden. Zum Beispiel wurde <code>sgugger/finetuned-bert-mrpc</code> auf den
auf den MRPC-Datensatz abgestimmt, der Satzpaare als Paraphrasen oder nicht klassifiziert.`,Ve,P,We,x,ys="Dann können wir sie auf dem Hub mit der Methode <code>push_to_hub</code> freigeben:",Ee,Y,Re,Q,Ts=`Dadurch wird die Datei, in der Sie <code>PairClassificationPipeline</code> definiert haben, in den Ordner <code>&quot;test-dynamic-pipeline&quot;</code> kopiert,
und speichert das Modell und den Tokenizer der Pipeline, bevor Sie alles in das Repository verschieben
<code>{Ihr_Benutzername}/test-dynamic-pipeline</code>. Danach kann jeder die Pipeline verwenden, solange er die Option
<code>trust_remote_code=True</code> angeben:`,Xe,F,Ne,L,ve,D,Js=`Wenn Sie Ihre Pipeline zu 🤗 Transformers beitragen möchten, müssen Sie ein neues Modul im Untermodul <code>pipelines</code> hinzufügen
mit dem Code Ihrer Pipeline hinzufügen. Fügen Sie es dann der Liste der in <code>pipelines/__init__.py</code> definierten Aufgaben hinzu.`,qe,K,hs="Dann müssen Sie noch Tests hinzufügen. Erstellen Sie eine neue Datei <code>tests/test_pipelines_MY_PIPELINE.py</code> mit Beispielen für die anderen Tests.",$e,O,js=`Die Funktion <code>run_pipeline_test</code> ist sehr allgemein gehalten und läuft auf kleinen Zufallsmodellen auf jeder möglichen
Architektur, wie durch <code>model_mapping</code> und <code>tf_model_mapping</code> definiert.`,Se,ee,fs=`Dies ist sehr wichtig, um die zukünftige Kompatibilität zu testen, d.h. wenn jemand ein neues Modell für
<code>XXXForQuestionAnswering</code> hinzufügt, wird der Pipeline-Test versuchen, mit diesem Modell zu arbeiten. Da die Modelle zufällig sind, ist es
ist es unmöglich, die tatsächlichen Werte zu überprüfen. Deshalb gibt es eine Hilfsfunktion <code>ANY</code>, die einfach versucht, die
Ausgabe der Pipeline TYPE.`,Pe,se,bs="Außerdem <em>müssen</em> Sie 2 (idealerweise 4) Tests implementieren.",xe,le,Us=`<li><code>test_small_model_pt</code> : Definieren Sie 1 kleines Modell für diese Pipeline (es spielt keine Rolle, ob die Ergebnisse keinen Sinn ergeben)
und testen Sie die Ausgaben der Pipeline. Die Ergebnisse sollten die gleichen sein wie bei <code>test_small_model_tf</code>.</li> <li><code>test_small_model_tf</code> : Definieren Sie 1 kleines Modell für diese Pipeline (es spielt keine Rolle, ob die Ergebnisse keinen Sinn ergeben)
und testen Sie die Ausgaben der Pipeline. Die Ergebnisse sollten die gleichen sein wie bei <code>test_small_model_pt</code>.</li> <li><code>test_large_model_pt</code> (<code>optional</code>): Testet die Pipeline an einer echten Pipeline, bei der die Ergebnisse
Sinn machen. Diese Tests sind langsam und sollten als solche gekennzeichnet werden. Hier geht es darum, die Pipeline zu präsentieren und sicherzustellen
sicherzustellen, dass es in zukünftigen Versionen keine Abweichungen gibt.</li> <li><code>test_large_model_tf</code> (<code>optional</code>): Testet die Pipeline an einer echten Pipeline, bei der die Ergebnisse
Sinn machen. Diese Tests sind langsam und sollten als solche gekennzeichnet werden. Hier geht es darum, die Pipeline zu präsentieren und sicherzustellen
sicherzustellen, dass es in zukünftigen Versionen keine Abweichungen gibt.</li>`,Ye,ne,Qe,ie,Fe;return T=new Le({props:{title:"Wie erstellt man eine benutzerdefinierte Pipeline?",local:"wie-erstellt-man-eine-benutzerdefinierte-pipeline",headingTag:"h1"}}),b=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBpcGVsaW5lJTBBJTBBJTBBY2xhc3MlMjBNeVBpcGVsaW5lKFBpcGVsaW5lKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9zYW5pdGl6ZV9wYXJhbWV0ZXJzKHNlbGYlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwJTIybWF5YmVfYXJnJTIyJTIwaW4lMjBrd2FyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUyMCUzRCUyMGt3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwJTdCJTdEJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcHJlcHJvY2VzcyhzZWxmJTJDJTIwaW5wdXRzJTJDJTIwbWF5YmVfYXJnJTNEMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pbnB1dCUyMCUzRCUyMFRlbnNvcihpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9mb3J3YXJkKHNlbGYlMkMlMjBtb2RlbF9pbnB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbW9kZWxfaW5wdXRzJTIwJTNEJTNEJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBzZWxmLm1vZGVsKCoqbW9kZWxfaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME1heWJlJTIwJTdCJTIybG9naXRzJTIyJTNBJTIwVGVuc29yKC4uLiklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRzJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, inputs, maybe_arg=<span class="hljs-number">2</span></span>):
        model_input = Tensor(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;model_input&quot;</span>: model_input}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-comment"># model_inputs == {&quot;model_input&quot;: model_input}</span>
        outputs = self.model(**model_inputs)
        <span class="hljs-comment"># Maybe {&quot;logits&quot;: Tensor(...)}</span>
        <span class="hljs-keyword">return</span> outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
        <span class="hljs-keyword">return</span> best_class`,wrap:!1}}),z=new w({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMm15LW5ldy10YXNrJTIyKSUwQXBpcGUoJTIyVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIpJTBBJTBBcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwdGVzdCUyMiUyQyUyMHRvcF9rJTNEMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;my-new-task&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;3-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.05</span>}
{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;4-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;5-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>, top_k=<span class="hljs-number">2</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}]`,wrap:!1}}),A=new w({props:{code:"ZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMlMkMlMjB0b3BfayUzRDUpJTNBJTBBJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjMlMjBBZGQlMjBsb2dpYyUyMHRvJTIwaGFuZGxlJTIwdG9wX2slMEElMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNzJTBBJTBBJTBBZGVmJTIwX3Nhbml0aXplX3BhcmFtZXRlcnMoc2VsZiUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJtYXliZV9hcmclMjIlMjBpbiUyMGt3YXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTIwJTNEJTIwa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJ0b3BfayUyMiUyMGluJTIwa3dhcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTVCJTIydG9wX2slMjIlNUQlMjAlM0QlMjBrd2FyZ3MlNUIlMjJ0b3BfayUyMiU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwcG9zdHByb2Nlc3Nfa3dhcmdz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs, top_k=<span class="hljs-number">5</span></span>):
    best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
    <span class="hljs-comment"># Add logic to handle top_k</span>
    <span class="hljs-keyword">return</span> best_class


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
    preprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]

    postprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;top_k&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        postprocess_kwargs[<span class="hljs-string">&quot;top_k&quot;</span>] = kwargs[<span class="hljs-string">&quot;top_k&quot;</span>]
    <span class="hljs-keyword">return</span> preprocess_kwargs, {}, postprocess_kwargs`,wrap:!1}}),G=new Le({props:{title:"Hinzufügen zur Liste der unterstützten Aufgaben",local:"hinzufügen-zur-liste-der-unterstützten-aufgaben",headingTag:"h2"}}),W=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMlMjBpbXBvcnQlMjBQSVBFTElORV9SRUdJU1RSWSUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMm5ldy10YXNrJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfY2xhc3MlM0RNeVBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
)`,wrap:!1}}),R=new w({props:{code:"UElQRUxJTkVfUkVHSVNUUlkucmVnaXN0ZXJfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIybmV3LXRhc2slMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRE15UGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBwdF9tb2RlbCUzREF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEElMjAlMjAlMjAlMjBkZWZhdWx0JTNEJTdCJTIycHQlMjIlM0ElMjAoJTIydXNlciUyRmF3ZXNvbWVfbW9kZWwlMjIlMkMlMjAlMjJhYmNkZWYlMjIpJTdEJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnRleHQlMjIlMkMlMjAlMjAlMjMlMjBjdXJyZW50JTIwc3VwcG9ydCUyMHR5cGUlM0ElMjB0ZXh0JTJDJTIwYXVkaW8lMkMlMjBpbWFnZSUyQyUyMG11bHRpbW9kYWwlMEEp",highlighted:`PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
    default={<span class="hljs-string">&quot;pt&quot;</span>: (<span class="hljs-string">&quot;user/awesome_model&quot;</span>, <span class="hljs-string">&quot;abcdef&quot;</span>)},
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;text&quot;</span>,  <span class="hljs-comment"># current support type: text, audio, image, multimodal</span>
)`,wrap:!1}}),X=new Le({props:{title:"Teilen Sie Ihre Pipeline auf dem Hub",local:"teilen-sie-ihre-pipeline-auf-dem-hub",headingTag:"h2"}}),v=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">def</span> <span class="hljs-title function_">softmax</span>(<span class="hljs-params">outputs</span>):
    maxes = np.<span class="hljs-built_in">max</span>(outputs, axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)
    shifted_exp = np.exp(outputs - maxes)
    <span class="hljs-keyword">return</span> shifted_exp / shifted_exp.<span class="hljs-built_in">sum</span>(axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">class</span> <span class="hljs-title class_">PairClassificationPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;second_text&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;second_text&quot;</span>] = kwargs[<span class="hljs-string">&quot;second_text&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, text, second_text=<span class="hljs-literal">None</span></span>):
        <span class="hljs-keyword">return</span> self.tokenizer(text, text_pair=second_text, return_tensors=self.framework)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-keyword">return</span> self.model(**model_inputs)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        logits = model_outputs.logits[<span class="hljs-number">0</span>].numpy()
        probabilities = softmax(logits)

        best_class = np.argmax(probabilities)
        label = self.model.config.id2label[best_class]
        score = probabilities[best_class].item()
        logits = logits.tolist()
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;label&quot;</span>: label, <span class="hljs-string">&quot;score&quot;</span>: score, <span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),$=new w({props:{code:"ZnJvbSUyMHBhaXJfY2xhc3NpZmljYXRpb24lMjBpbXBvcnQlMjBQYWlyQ2xhc3NpZmljYXRpb25QaXBlbGluZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMucGlwZWxpbmVzJTIwaW1wb3J0JTIwUElQRUxJTkVfUkVHSVNUUlklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRFBhaXJDbGFzc2lmaWNhdGlvblBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdGZfbW9kZWwlM0RURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> pair_classification <span class="hljs-keyword">import</span> PairClassificationPipeline
<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, TFAutoModelForSequenceClassification

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;pair-classification&quot;</span>,
    pipeline_class=PairClassificationPipeline,
    pt_model=AutoModelForSequenceClassification,
    tf_model=TFAutoModelForSequenceClassification,
)`,wrap:!1}}),P=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMnNndWdnZXIlMkZmaW5ldHVuZWQtYmVydC1tcnBjJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(<span class="hljs-string">&quot;pair-classification&quot;</span>, model=<span class="hljs-string">&quot;sgugger/finetuned-bert-mrpc&quot;</span>)`,wrap:!1}}),Y=new w({props:{code:"Y2xhc3NpZmllci5wdXNoX3RvX2h1YiglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIp",highlighted:'classifier.push_to_hub(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>)',wrap:!1}}),F=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(model=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),L=new Le({props:{title:"Hinzufügen der Pipeline zu 🤗 Transformers",local:"hinzufügen-der-pipeline-zu--transformers",headingTag:"h2"}}),ne=new Hs({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/de/add_new_pipeline.md"}}),{c(){y=a("meta"),ae=t(),te=a("p"),pe=t(),d(T.$$.fragment),re=t(),J=a("p"),J.innerHTML=Ke,de=t(),h=a("p"),h.innerHTML=Oe,ce=t(),j=a("p"),j.innerHTML=es,Me=t(),f=a("p"),f.innerHTML=ss,oe=t(),d(b.$$.fragment),ue=t(),U=a("p"),U.textContent=ls,me=t(),g=a("p"),g.innerHTML=ns,we=t(),I=a("p"),I.innerHTML=ts,ye=t(),B=a("p"),B.innerHTML=is,Te=t(),C=a("p"),C.innerHTML=as,Je=t(),k=a("p"),k.innerHTML=ps,he=t(),_=a("p"),_.innerHTML=rs,je=t(),d(z.$$.fragment),fe=t(),Z=a("p"),Z.innerHTML=ds,be=t(),d(A.$$.fragment),Ue=t(),H=a("p"),H.textContent=cs,ge=t(),d(G.$$.fragment),Ie=t(),V=a("p"),V.innerHTML=Ms,Be=t(),d(W.$$.fragment),Ce=t(),E=a("p"),E.innerHTML=os,ke=t(),d(R.$$.fragment),_e=t(),d(X.$$.fragment),ze=t(),N=a("p"),N.innerHTML=us,Ze=t(),d(v.$$.fragment),Ae=t(),q=a("p"),q.innerHTML=ms,He=t(),d($.$$.fragment),Ge=t(),S=a("p"),S.innerHTML=ws,Ve=t(),d(P.$$.fragment),We=t(),x=a("p"),x.innerHTML=ys,Ee=t(),d(Y.$$.fragment),Re=t(),Q=a("p"),Q.innerHTML=Ts,Xe=t(),d(F.$$.fragment),Ne=t(),d(L.$$.fragment),ve=t(),D=a("p"),D.innerHTML=Js,qe=t(),K=a("p"),K.innerHTML=hs,$e=t(),O=a("p"),O.innerHTML=js,Se=t(),ee=a("p"),ee.innerHTML=fs,Pe=t(),se=a("p"),se.innerHTML=bs,xe=t(),le=a("ul"),le.innerHTML=Us,Ye=t(),d(ne.$$.fragment),Qe=t(),ie=a("p"),this.h()},l(e){const s=Zs("svelte-u9bgzb",document.head);y=p(s,"META",{name:!0,content:!0}),s.forEach(l),ae=i(e),te=p(e,"P",{}),gs(te).forEach(l),pe=i(e),c(T.$$.fragment,e),re=i(e),J=p(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1wezfmd"&&(J.innerHTML=Ke),de=i(e),h=p(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1gibur5"&&(h.innerHTML=Oe),ce=i(e),j=p(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1s6g8s2"&&(j.innerHTML=es),Me=i(e),f=p(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-178jgk4"&&(f.innerHTML=ss),oe=i(e),c(b.$$.fragment,e),ue=i(e),U=p(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-prsu03"&&(U.textContent=ls),me=i(e),g=p(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-111rxft"&&(g.innerHTML=ns),we=i(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-wh0ews"&&(I.innerHTML=ts),ye=i(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-dhzsf"&&(B.innerHTML=is),Te=i(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1vn0211"&&(C.innerHTML=as),Je=i(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1gm9nlz"&&(k.innerHTML=ps),he=i(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1o6q40b"&&(_.innerHTML=rs),je=i(e),c(z.$$.fragment,e),fe=i(e),Z=p(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-nsc0of"&&(Z.innerHTML=ds),be=i(e),c(A.$$.fragment,e),Ue=i(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-18aybbs"&&(H.textContent=cs),ge=i(e),c(G.$$.fragment,e),Ie=i(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1wh7t0j"&&(V.innerHTML=Ms),Be=i(e),c(W.$$.fragment,e),Ce=i(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-3k8nr4"&&(E.innerHTML=os),ke=i(e),c(R.$$.fragment,e),_e=i(e),c(X.$$.fragment,e),ze=i(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1vgfgi6"&&(N.innerHTML=us),Ze=i(e),c(v.$$.fragment,e),Ae=i(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-rraq57"&&(q.innerHTML=ms),He=i(e),c($.$$.fragment,e),Ge=i(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-lmblxt"&&(S.innerHTML=ws),Ve=i(e),c(P.$$.fragment,e),We=i(e),x=p(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-jbd9uc"&&(x.innerHTML=ys),Ee=i(e),c(Y.$$.fragment,e),Re=i(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-bimycc"&&(Q.innerHTML=Ts),Xe=i(e),c(F.$$.fragment,e),Ne=i(e),c(L.$$.fragment,e),ve=i(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-13f7wv7"&&(D.innerHTML=Js),qe=i(e),K=p(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-ty86wt"&&(K.innerHTML=hs),$e=i(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1mq6d2v"&&(O.innerHTML=js),Se=i(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-bcl54q"&&(ee.innerHTML=fs),Pe=i(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-3mgk43"&&(se.innerHTML=bs),xe=i(e),le=p(e,"UL",{"data-svelte-h":!0}),r(le)!=="svelte-ish3co"&&(le.innerHTML=Us),Ye=i(e),c(ne.$$.fragment,e),Qe=i(e),ie=p(e,"P",{}),gs(ie).forEach(l),this.h()},h(){Is(y,"name","hf:doc:metadata"),Is(y,"content",Vs)},m(e,s){As(document.head,y),n(e,ae,s),n(e,te,s),n(e,pe,s),M(T,e,s),n(e,re,s),n(e,J,s),n(e,de,s),n(e,h,s),n(e,ce,s),n(e,j,s),n(e,Me,s),n(e,f,s),n(e,oe,s),M(b,e,s),n(e,ue,s),n(e,U,s),n(e,me,s),n(e,g,s),n(e,we,s),n(e,I,s),n(e,ye,s),n(e,B,s),n(e,Te,s),n(e,C,s),n(e,Je,s),n(e,k,s),n(e,he,s),n(e,_,s),n(e,je,s),M(z,e,s),n(e,fe,s),n(e,Z,s),n(e,be,s),M(A,e,s),n(e,Ue,s),n(e,H,s),n(e,ge,s),M(G,e,s),n(e,Ie,s),n(e,V,s),n(e,Be,s),M(W,e,s),n(e,Ce,s),n(e,E,s),n(e,ke,s),M(R,e,s),n(e,_e,s),M(X,e,s),n(e,ze,s),n(e,N,s),n(e,Ze,s),M(v,e,s),n(e,Ae,s),n(e,q,s),n(e,He,s),M($,e,s),n(e,Ge,s),n(e,S,s),n(e,Ve,s),M(P,e,s),n(e,We,s),n(e,x,s),n(e,Ee,s),M(Y,e,s),n(e,Re,s),n(e,Q,s),n(e,Xe,s),M(F,e,s),n(e,Ne,s),M(L,e,s),n(e,ve,s),n(e,D,s),n(e,qe,s),n(e,K,s),n(e,$e,s),n(e,O,s),n(e,Se,s),n(e,ee,s),n(e,Pe,s),n(e,se,s),n(e,xe,s),n(e,le,s),n(e,Ye,s),M(ne,e,s),n(e,Qe,s),n(e,ie,s),Fe=!0},p:Cs,i(e){Fe||(o(T.$$.fragment,e),o(b.$$.fragment,e),o(z.$$.fragment,e),o(A.$$.fragment,e),o(G.$$.fragment,e),o(W.$$.fragment,e),o(R.$$.fragment,e),o(X.$$.fragment,e),o(v.$$.fragment,e),o($.$$.fragment,e),o(P.$$.fragment,e),o(Y.$$.fragment,e),o(F.$$.fragment,e),o(L.$$.fragment,e),o(ne.$$.fragment,e),Fe=!0)},o(e){u(T.$$.fragment,e),u(b.$$.fragment,e),u(z.$$.fragment,e),u(A.$$.fragment,e),u(G.$$.fragment,e),u(W.$$.fragment,e),u(R.$$.fragment,e),u(X.$$.fragment,e),u(v.$$.fragment,e),u($.$$.fragment,e),u(P.$$.fragment,e),u(Y.$$.fragment,e),u(F.$$.fragment,e),u(L.$$.fragment,e),u(ne.$$.fragment,e),Fe=!1},d(e){e&&(l(ae),l(te),l(pe),l(re),l(J),l(de),l(h),l(ce),l(j),l(Me),l(f),l(oe),l(ue),l(U),l(me),l(g),l(we),l(I),l(ye),l(B),l(Te),l(C),l(Je),l(k),l(he),l(_),l(je),l(fe),l(Z),l(be),l(Ue),l(H),l(ge),l(Ie),l(V),l(Be),l(Ce),l(E),l(ke),l(_e),l(ze),l(N),l(Ze),l(Ae),l(q),l(He),l(Ge),l(S),l(Ve),l(We),l(x),l(Ee),l(Re),l(Q),l(Xe),l(Ne),l(ve),l(D),l(qe),l(K),l($e),l(O),l(Se),l(ee),l(Pe),l(se),l(xe),l(le),l(Ye),l(Qe),l(ie)),l(y),m(T,e),m(b,e),m(z,e),m(A,e),m(G,e),m(W,e),m(R,e),m(X,e),m(v,e),m($,e),m(P,e),m(Y,e),m(F,e),m(L,e),m(ne,e)}}}const Vs='{"title":"Wie erstellt man eine benutzerdefinierte Pipeline?","local":"wie-erstellt-man-eine-benutzerdefinierte-pipeline","sections":[{"title":"Hinzufügen zur Liste der unterstützten Aufgaben","local":"hinzufügen-zur-liste-der-unterstützten-aufgaben","sections":[],"depth":2},{"title":"Teilen Sie Ihre Pipeline auf dem Hub","local":"teilen-sie-ihre-pipeline-auf-dem-hub","sections":[],"depth":2},{"title":"Hinzufügen der Pipeline zu 🤗 Transformers","local":"hinzufügen-der-pipeline-zu--transformers","sections":[],"depth":2}],"depth":1}';function Ws(De){return ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vs extends _s{constructor(y){super(),zs(this,y,Ws,Gs,Bs,{})}}export{vs as component};
