import{s as Do,o as Ko,n as E}from"../chunks/scheduler.18a86fab.js";import{S as en,i as tn,g as d,s as a,r as u,A as on,h as c,f as o,c as r,j as R,u as g,x as h,k as Z,l as nn,y as l,a as i,v as f,d as _,t as T,w as b}from"../chunks/index.98837b22.js";import{T as Zt}from"../chunks/Tip.77304350.js";import{D as L}from"../chunks/Docstring.6758ea23.js";import{C as Ue}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as st}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as S}from"../chunks/Heading.7e7e0c5b.js";import{E as sn}from"../chunks/index.499f366c.js";function an(M){let n,k="Example:",p,m,y;return m=new Ue({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVEJpZ0NvZGVDb25maWclMkMlMjBHUFRCaWdDb2RlTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwR1BUQmlnQ29kZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwR1BUQmlnQ29kZUNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBHUFRCaWdDb2RlTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPTBigCodeConfig, GPTBigCodeModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a GPTBigCode configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = GPTBigCodeConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GPTBigCodeModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=d("p"),n.textContent=k,p=a(),u(m.$$.fragment)},l(s){n=c(s,"P",{"data-svelte-h":!0}),h(n)!=="svelte-11lpom8"&&(n.textContent=k),p=r(s),g(m.$$.fragment,s)},m(s,C){i(s,n,C),i(s,p,C),f(m,s,C),y=!0},p:E,i(s){y||(_(m.$$.fragment,s),y=!0)},o(s){T(m.$$.fragment,s),y=!1},d(s){s&&(o(n),o(p)),b(m,s)}}}function rn(M){let n,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=k},l(p){n=c(p,"P",{"data-svelte-h":!0}),h(n)!=="svelte-fincs2"&&(n.innerHTML=k)},m(p,m){i(p,n,m)},p:E,d(p){p&&o(n)}}}function ln(M){let n,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=k},l(p){n=c(p,"P",{"data-svelte-h":!0}),h(n)!=="svelte-fincs2"&&(n.innerHTML=k)},m(p,m){i(p,n,m)},p:E,d(p){p&&o(n)}}}function dn(M){let n,k="Example:",p,m,y;return m=new Ue({props:{code:"",highlighted:"",wrap:!1}}),{c(){n=d("p"),n.textContent=k,p=a(),u(m.$$.fragment)},l(s){n=c(s,"P",{"data-svelte-h":!0}),h(n)!=="svelte-11lpom8"&&(n.textContent=k),p=r(s),g(m.$$.fragment,s)},m(s,C){i(s,n,C),i(s,p,C),f(m,s,C),y=!0},p:E,i(s){y||(_(m.$$.fragment,s),y=!0)},o(s){T(m.$$.fragment,s),y=!1},d(s){s&&(o(n),o(p)),b(m,s)}}}function cn(M){let n,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=k},l(p){n=c(p,"P",{"data-svelte-h":!0}),h(n)!=="svelte-fincs2"&&(n.innerHTML=k)},m(p,m){i(p,n,m)},p:E,d(p){p&&o(n)}}}function pn(M){let n,k="Example of single-label classification:",p,m,y;return m=new Ue({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEdQVEJpZ0NvZGVGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0X2JpZ2NvZGUlMjIpJTBBbW9kZWwlMjAlM0QlMjBHUFRCaWdDb2RlRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0X2JpZ2NvZGUlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkJTIwJTNEJTIwbG9naXRzLmFyZ21heCgpLml0ZW0oKSUwQW1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9jbGFzc19pZCU1RCUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyMEdQVEJpZ0NvZGVGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJncHRfYmlnY29kZSUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcyUwQXJvdW5kKGxvc3MuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, GPTBigCodeForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt_bigcode&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GPTBigCodeForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;gpt_bigcode&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.id2label[predicted_class_id]
...

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GPTBigCodeForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;gpt_bigcode&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
...`,wrap:!1}}),{c(){n=d("p"),n.textContent=k,p=a(),u(m.$$.fragment)},l(s){n=c(s,"P",{"data-svelte-h":!0}),h(n)!=="svelte-ykxpe4"&&(n.textContent=k),p=r(s),g(m.$$.fragment,s)},m(s,C){i(s,n,C),i(s,p,C),f(m,s,C),y=!0},p:E,i(s){y||(_(m.$$.fragment,s),y=!0)},o(s){T(m.$$.fragment,s),y=!1},d(s){s&&(o(n),o(p)),b(m,s)}}}function mn(M){let n,k="Example of multi-label classification:",p,m,y;return m=new Ue({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEdQVEJpZ0NvZGVGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0X2JpZ2NvZGUlMjIpJTBBbW9kZWwlMjAlM0QlMjBHUFRCaWdDb2RlRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0X2JpZ2NvZGUlMjIlMkMlMjBwcm9ibGVtX3R5cGUlM0QlMjJtdWx0aV9sYWJlbF9jbGFzc2lmaWNhdGlvbiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWRzJTIwJTNEJTIwdG9yY2guYXJhbmdlKDAlMkMlMjBsb2dpdHMuc2hhcGUlNUItMSU1RCklNUJ0b3JjaC5zaWdtb2lkKGxvZ2l0cykuc3F1ZWV6ZShkaW0lM0QwKSUyMCUzRSUyMDAuNSU1RCUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyMEdQVEJpZ0NvZGVGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJncHRfYmlnY29kZSUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, GPTBigCodeForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt_bigcode&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GPTBigCodeForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;gpt_bigcode&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GPTBigCodeForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;gpt_bigcode&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){n=d("p"),n.textContent=k,p=a(),u(m.$$.fragment)},l(s){n=c(s,"P",{"data-svelte-h":!0}),h(n)!=="svelte-1l8e32d"&&(n.textContent=k),p=r(s),g(m.$$.fragment,s)},m(s,C){i(s,n,C),i(s,p,C),f(m,s,C),y=!0},p:E,i(s){y||(_(m.$$.fragment,s),y=!0)},o(s){T(m.$$.fragment,s),y=!1},d(s){s&&(o(n),o(p)),b(m,s)}}}function hn(M){let n,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=k},l(p){n=c(p,"P",{"data-svelte-h":!0}),h(n)!=="svelte-fincs2"&&(n.innerHTML=k)},m(p,m){i(p,n,m)},p:E,d(p){p&&o(n)}}}function un(M){let n,k="Example:",p,m,y;return m=new Ue({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBHUFRCaWdDb2RlRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0X2JpZ2NvZGUlMjIpJTBBbW9kZWwlMjAlM0QlMjBHUFRCaWdDb2RlRm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0X2JpZ2NvZGUlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCUyMkh1Z2dpbmdGYWNlJTIwaXMlMjBhJTIwY29tcGFueSUyMGJhc2VkJTIwaW4lMjBQYXJpcyUyMGFuZCUyME5ldyUyMFlvcmslMjIlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSklMEElMEElMjMlMjBOb3RlJTIwdGhhdCUyMHRva2VucyUyMGFyZSUyMGNsYXNzaWZpZWQlMjByYXRoZXIlMjB0aGVuJTIwaW5wdXQlMjB3b3JkcyUyMHdoaWNoJTIwbWVhbnMlMjB0aGF0JTBBJTIzJTIwdGhlcmUlMjBtaWdodCUyMGJlJTIwbW9yZSUyMHByZWRpY3RlZCUyMHRva2VuJTIwY2xhc3NlcyUyMHRoYW4lMjB3b3Jkcy4lMEElMjMlMjBNdWx0aXBsZSUyMHRva2VuJTIwY2xhc3NlcyUyMG1pZ2h0JTIwYWNjb3VudCUyMGZvciUyMHRoZSUyMHNhbWUlMjB3b3JkJTBBcHJlZGljdGVkX3Rva2Vuc19jbGFzc2VzJTIwJTNEJTIwJTVCbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCdC5pdGVtKCklNUQlMjBmb3IlMjB0JTIwaW4lMjBwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTVCMCU1RCU1RCUwQXByZWRpY3RlZF90b2tlbnNfY2xhc3NlcyUwQSUwQWxhYmVscyUyMCUzRCUyMHByZWRpY3RlZF90b2tlbl9jbGFzc19pZHMlMEFsb3NzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpLmxvc3MlMEFyb3VuZChsb3NzLml0ZW0oKSUyQyUyMDIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, GPTBigCodeForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt_bigcode&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GPTBigCodeForTokenClassification.from_pretrained(<span class="hljs-string">&quot;gpt_bigcode&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes
...

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
...`,wrap:!1}}),{c(){n=d("p"),n.textContent=k,p=a(),u(m.$$.fragment)},l(s){n=c(s,"P",{"data-svelte-h":!0}),h(n)!=="svelte-11lpom8"&&(n.textContent=k),p=r(s),g(m.$$.fragment,s)},m(s,C){i(s,n,C),i(s,p,C),f(m,s,C),y=!0},p:E,i(s){y||(_(m.$$.fragment,s),y=!0)},o(s){T(m.$$.fragment,s),y=!1},d(s){s&&(o(n),o(p)),b(m,s)}}}function gn(M){let n,k,p,m,y,s,C,To='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',at,ne,rt,se,bo='The GPTBigCode model was proposed in <a href="https://arxiv.org/abs/2301.03988" rel="nofollow">SantaCoder: don’t reach for the stars!</a> by BigCode. The listed authors are: Loubna Ben Allal, Raymond Li, Denis Kocetkov, Chenghao Mou, Christopher Akiki, Carlos Munoz Ferrandis, Niklas Muennighoff, Mayank Mishra, Alex Gu, Manan Dey, Logesh Kumar Umapathi, Carolyn Jane Anderson, Yangtian Zi, Joel Lamy Poirier, Hailey Schoelkopf, Sergey Troshin, Dmitry Abulkhanov, Manuel Romero, Michael Lappert, Francesco De Toni, Bernardo García del Río, Qian Liu, Shamik Bose, Urvashi Bhattacharyya, Terry Yue Zhuo, Ian Yu, Paulo Villegas, Marco Zocca, Sourab Mangrulkar, David Lansky, Huu Nguyen, Danish Contractor, Luis Villa, Jia Li, Dzmitry Bahdanau, Yacine Jernite, Sean Hughes, Daniel Fried, Arjun Guha, Harm de Vries, Leandro von Werra.',it,ae,yo="The abstract from the paper is the following:",lt,re,ko='<em>The BigCode project is an open-scientific collaboration working on the responsible development of large language models for code. This tech report describes the progress of the collaboration until December 2022, outlining the current state of the Personally Identifiable Information (PII) redaction pipeline, the experiments conducted to de-risk the model architecture, and the experiments investigating better preprocessing methods for the training data. We train 1.1B parameter models on the Java, JavaScript, and Python subsets of The Stack and evaluate them on the MultiPL-E text-to-code benchmark. We find that more aggressive filtering of near-duplicates can further boost performance and, surprisingly, that selecting files from repositories with 5+ GitHub stars deteriorates performance significantly. Our best model outperforms previous open-source multilingual code generation models (InCoder-6.7B and CodeGen-Multi-2.7B) in both left-to-right generation and infilling on the Java, JavaScript, and Python portions of MultiPL-E, despite being a substantially smaller model. All models are released under an OpenRAIL license at <a href="https://huggingface.co/bigcode" rel="nofollow">this https URL.</a></em>',dt,ie,Co='The model is an optimized <a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2 model</a> with support for Multi-Query Attention.',ct,le,pt,de,Mo="The main differences compared to GPT2.",mt,ce,vo="<li>Added support for Multi-Query Attention.</li> <li>Use <code>gelu_pytorch_tanh</code> instead of classic <code>gelu</code>.</li> <li>Avoid unnecessary synchronizations (this has since been added to GPT2 in #20061, but wasn’t in the reference codebase).</li> <li>Use Linear layers instead of Conv1D (good speedup but makes the checkpoints incompatible).</li> <li>Merge <code>_attn</code> and <code>_upcast_and_reordered_attn</code>. Always merge the matmul with scaling. Rename <code>reorder_and_upcast_attn</code>-&gt;<code>attention_softmax_in_fp32</code></li> <li>Cache the attention mask value to avoid recreating it every time.</li> <li>Use jit to fuse the attention fp32 casting, masking, softmax, and scaling.</li> <li>Combine the attention and causal masks into a single one, pre-computed for the whole model instead of every layer.</li> <li>Merge the key and value caches into one (this changes the format of layer_past/ present, does it risk creating problems?)</li> <li>Use the memory layout (self.num_heads, 3, self.head_dim) instead of <code>(3, self.num_heads, self.head_dim)</code> for the QKV tensor with MHA. (prevents an overhead with the merged key and values, but makes the checkpoints incompatible with the original openai-community/gpt2 model).</li>",ht,pe,wo='You can read more about the optimizations in the <a href="https://github.com/huggingface/transformers/pull/22575" rel="nofollow">original pull request</a>',ut,me,$o=`<p>[!NOTE]
The <code>head_mask</code> argument is ignored when using all attention implementation other than “eager”. If you have a <code>head_mask</code> and want it to have effect, load the model with <code>XXXModel.from_pretrained(model_id, attn_implementation=&quot;eager&quot;)</code></p>`,gt,he,ft,ue,Go="First, make sure to install the latest version of Flash Attention 2 to include the sliding window attention feature.",_t,ge,Tt,fe,Bo="Make also sure that you have a hardware that is compatible with Flash-Attention 2. Read more about it in the official documentation of flash-attn repository. Make also sure to load your model in half-precision (e.g. `torch.float16“)",bt,_e,xo="To load and run a model using Flash Attention 2, refer to the snippet below:",yt,Te,kt,be,Ct,ye,Jo="Below is a expected speedup diagram that compares pure inference time between the native implementation in transformers using <code>bigcode/starcoder</code> checkpoint and the Flash Attention 2 version of the model using two different sequence lengths.",Mt,Y,Po='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/starcoder-speedup.png"/>',vt,ke,wt,J,Ce,It,Ze,jo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeModel">GPTBigCodeModel</a>. It is used to instantiate a
GPTBigCode model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the GPTBigCode
<a href="https://huggingface.co/gpt_bigcode" rel="nofollow">gpt_bigcode</a> architecture.`,qt,Ie,Fo=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Nt,A,$t,Me,Gt,$,ve,Rt,qe,Wo="The bare Gpt Bigcode Model outputting raw hidden-states without any specific head on top.",Vt,Ne,zo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,St,Re,Uo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ht,V,we,Lt,Ve,Zo='The <a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeModel">GPTBigCodeModel</a> forward method, overrides the <code>__call__</code> special method.',Et,X,Bt,$e,xt,G,Ge,Yt,Se,Io=`The GPT_BIGCODE Model transformer with a language modeling head on top (linear layer with weights tied to the input
embeddings).`,At,He,qo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Xt,Le,No=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Qt,z,Be,Ot,Ee,Ro='The <a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForCausalLM">GPTBigCodeForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Dt,Q,Kt,O,Jt,xe,Pt,v,Je,eo,Ye,Vo="The GPTBigCode Model transformer with a sequence classification head on top (linear layer).",to,Ae,So=`<a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForSequenceClassification">GPTBigCodeForSequenceClassification</a> uses the last token in order to do the classification, as other causal
models (e.g. GPT-1) do.`,oo,Xe,Ho=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,no,Qe,Lo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,so,Oe,Eo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ao,x,Pe,ro,De,Yo='The <a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForSequenceClassification">GPTBigCodeForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',io,D,lo,K,co,ee,jt,je,Ft,B,Fe,po,Ke,Ao=`The Gpt Bigcode transformer with a token classification head on top (a linear layer on top of the hidden-states
output) e.g. for Named-Entity-Recognition (NER) tasks.`,mo,et,Xo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ho,tt,Qo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,uo,U,We,go,ot,Oo='The <a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForTokenClassification">GPTBigCodeForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',fo,te,_o,oe,Wt,ze,zt,nt,Ut;return y=new S({props:{title:"GPTBigCode",local:"gptbigcode",headingTag:"h1"}}),ne=new S({props:{title:"Overview",local:"overview",headingTag:"h2"}}),le=new S({props:{title:"Implementation details",local:"implementation-details",headingTag:"h2"}}),he=new S({props:{title:"Combining Starcoder and Flash Attention 2",local:"combining-starcoder-and-flash-attention-2",headingTag:"h2"}}),ge=new Ue({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0biUyMC0tbm8tYnVpbGQtaXNvbGF0aW9u",highlighted:"pip install -U flash-attn --no-build-isolation",wrap:!1}}),Te=new Ue({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMCUyMyUyMHRoZSUyMGRldmljZSUyMHRvJTIwbG9hZCUyMHRoZSUyMG1vZGVsJTIwb250byUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ2NvZGUlMkZncHRfYmlnY29kZS1zYW50YWNvZGVyJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ2NvZGUlMkZncHRfYmlnY29kZS1zYW50YWNvZGVyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmRlZiUyMGhlbGxvX3dvcmxkKCklM0ElMjIlMEElMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCcHJvbXB0JTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQW1vZGVsLnRvKGRldmljZSklMEElMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKiptb2RlbF9pbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDMwJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-comment"># the device to load the model onto</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/gpt_bigcode-santacoder&quot;</span>, torch_dtype=torch.float16, attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigcode/gpt_bigcode-santacoder&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;def hello_world():&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([prompt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">30</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;def hello_world():\\n    print(&quot;hello world&quot;)\\n\\nif __name__ == &quot;__main__&quot;:\\n    print(&quot;hello world&quot;)\\n&lt;|endoftext|&gt;&#x27;</span>`,wrap:!1}}),be=new S({props:{title:"Expected speedups",local:"expected-speedups",headingTag:"h3"}}),ke=new S({props:{title:"GPTBigCodeConfig",local:"transformers.GPTBigCodeConfig",headingTag:"h2"}}),Ce=new L({props:{name:"class transformers.GPTBigCodeConfig",anchor:"transformers.GPTBigCodeConfig",parameters:[{name:"vocab_size",val:" = 50257"},{name:"n_positions",val:" = 1024"},{name:"n_embd",val:" = 768"},{name:"n_layer",val:" = 12"},{name:"n_head",val:" = 12"},{name:"n_inner",val:" = None"},{name:"activation_function",val:" = 'gelu_pytorch_tanh'"},{name:"resid_pdrop",val:" = 0.1"},{name:"embd_pdrop",val:" = 0.1"},{name:"attn_pdrop",val:" = 0.1"},{name:"layer_norm_epsilon",val:" = 1e-05"},{name:"initializer_range",val:" = 0.02"},{name:"scale_attn_weights",val:" = True"},{name:"use_cache",val:" = True"},{name:"bos_token_id",val:" = 50256"},{name:"eos_token_id",val:" = 50256"},{name:"attention_softmax_in_fp32",val:" = True"},{name:"scale_attention_softmax_in_fp32",val:" = True"},{name:"multi_query",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GPTBigCodeConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 50257) &#x2014;
Vocabulary size of the GPT-2 model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeModel">GPTBigCodeModel</a>.`,name:"vocab_size"},{anchor:"transformers.GPTBigCodeConfig.n_positions",description:`<strong>n_positions</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"n_positions"},{anchor:"transformers.GPTBigCodeConfig.n_embd",description:`<strong>n_embd</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the embeddings and hidden states.`,name:"n_embd"},{anchor:"transformers.GPTBigCodeConfig.n_layer",description:`<strong>n_layer</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"n_layer"},{anchor:"transformers.GPTBigCodeConfig.n_head",description:`<strong>n_head</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"n_head"},{anchor:"transformers.GPTBigCodeConfig.n_inner",description:`<strong>n_inner</strong> (<code>int</code>, <em>optional</em>, defaults to None) &#x2014;
Dimensionality of the inner feed-forward layers. <code>None</code> will set it to 4 times n_embd`,name:"n_inner"},{anchor:"transformers.GPTBigCodeConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu_pytorch_tanh&quot;</code>) &#x2014;
Activation function, to be selected in the list <code>[&quot;relu&quot;, &quot;silu&quot;, &quot;gelu&quot;, &quot;tanh&quot;, &quot;gelu_new&quot;, &quot;gelu_pytorch_tanh&quot;]</code>.`,name:"activation_function"},{anchor:"transformers.GPTBigCodeConfig.resid_pdrop",description:`<strong>resid_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"resid_pdrop"},{anchor:"transformers.GPTBigCodeConfig.embd_pdrop",description:`<strong>embd_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the embeddings.`,name:"embd_pdrop"},{anchor:"transformers.GPTBigCodeConfig.attn_pdrop",description:`<strong>attn_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention.`,name:"attn_pdrop"},{anchor:"transformers.GPTBigCodeConfig.layer_norm_epsilon",description:`<strong>layer_norm_epsilon</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-5) &#x2014;
The epsilon to use in the layer normalization layers.`,name:"layer_norm_epsilon"},{anchor:"transformers.GPTBigCodeConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.GPTBigCodeConfig.scale_attn_weights",description:`<strong>scale_attn_weights</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Scale attention weights by dividing by sqrt(hidden_size)..`,name:"scale_attn_weights"},{anchor:"transformers.GPTBigCodeConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"},{anchor:"transformers.GPTBigCodeConfig.attention_softmax_in_fp32",description:`<strong>attention_softmax_in_fp32</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to call the fused softmax in float32.`,name:"attention_softmax_in_fp32"},{anchor:"transformers.GPTBigCodeConfig.scale_attention_softmax_in_fp32",description:`<strong>scale_attention_softmax_in_fp32</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to scale the attention softmax in float32.`,name:"scale_attention_softmax_in_fp32"},{anchor:"transformers.GPTBigCodeConfig.attention_type",description:`<strong>attention_type</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use Multi-Query Attion (<code>True</code>) or Multi-Head Attention (<code>False</code>).`,name:"attention_type"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gpt_bigcode/configuration_gpt_bigcode.py#L24"}}),A=new st({props:{anchor:"transformers.GPTBigCodeConfig.example",$$slots:{default:[an]},$$scope:{ctx:M}}}),Me=new S({props:{title:"GPTBigCodeModel",local:"transformers.GPTBigCodeModel",headingTag:"h2"}}),ve=new L({props:{name:"class transformers.GPTBigCodeModel",anchor:"transformers.GPTBigCodeModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.GPTBigCodeModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeModel">GPTBigCodeModel</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gpt_bigcode/modeling_gpt_bigcode.py#L686"}}),we=new L({props:{name:"forward",anchor:"transformers.GPTBigCodeModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.GPTBigCodeModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else
<code>past_key_values[0][0].shape[-2]</code> (<code>sequence_length</code> of input past key value states). Indices of input
sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.GPTBigCodeModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.GPTBigCodeModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.GPTBigCodeModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.GPTBigCodeModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.GPTBigCodeModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.GPTBigCodeModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.GPTBigCodeModel.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention
if the model is configured as a decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.GPTBigCodeModel.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on the padding token indices of the encoder input. This mask is used in
the cross-attention if the model is configured as a decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>`,name:"encoder_attention_mask"},{anchor:"transformers.GPTBigCodeModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.GPTBigCodeModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GPTBigCodeModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GPTBigCodeModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gpt_bigcode/modeling_gpt_bigcode.py#L719",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeConfig"
>GPTBigCodeConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),X=new Zt({props:{$$slots:{default:[rn]},$$scope:{ctx:M}}}),$e=new S({props:{title:"GPTBigCodeForCausalLM",local:"transformers.GPTBigCodeForCausalLM",headingTag:"h2"}}),Ge=new L({props:{name:"class transformers.GPTBigCodeForCausalLM",anchor:"transformers.GPTBigCodeForCausalLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.GPTBigCodeForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForCausalLM">GPTBigCodeForCausalLM</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gpt_bigcode/modeling_gpt_bigcode.py#L945"}}),Be=new L({props:{name:"forward",anchor:"transformers.GPTBigCodeForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GPTBigCodeForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else
<code>past_key_values[0][0].shape[-2]</code> (<code>sequence_length</code> of input past key value states). Indices of input
sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.GPTBigCodeForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.GPTBigCodeForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.GPTBigCodeForCausalLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.GPTBigCodeForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.GPTBigCodeForCausalLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.GPTBigCodeForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.GPTBigCodeForCausalLM.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention
if the model is configured as a decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.GPTBigCodeForCausalLM.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on the padding token indices of the encoder input. This mask is used in
the cross-attention if the model is configured as a decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>`,name:"encoder_attention_mask"},{anchor:"transformers.GPTBigCodeForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, input_ids_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.GPTBigCodeForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.GPTBigCodeForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GPTBigCodeForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GPTBigCodeForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gpt_bigcode/modeling_gpt_bigcode.py#L1037",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeConfig"
>GPTBigCodeConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Q=new Zt({props:{$$slots:{default:[ln]},$$scope:{ctx:M}}}),O=new st({props:{anchor:"transformers.GPTBigCodeForCausalLM.forward.example",$$slots:{default:[dn]},$$scope:{ctx:M}}}),xe=new S({props:{title:"GPTBigCodeForSequenceClassification",local:"transformers.GPTBigCodeForSequenceClassification",headingTag:"h2"}}),Je=new L({props:{name:"class transformers.GPTBigCodeForSequenceClassification",anchor:"transformers.GPTBigCodeForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.GPTBigCodeForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForSequenceClassification">GPTBigCodeForSequenceClassification</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gpt_bigcode/modeling_gpt_bigcode.py#L1129"}}),Pe=new L({props:{name:"forward",anchor:"transformers.GPTBigCodeForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.GPTBigCodeForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else
<code>past_key_values[0][0].shape[-2]</code> (<code>sequence_length</code> of input past key value states). Indices of input
sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.GPTBigCodeForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.GPTBigCodeForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.GPTBigCodeForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.GPTBigCodeForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.GPTBigCodeForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.GPTBigCodeForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.GPTBigCodeForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.GPTBigCodeForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.GPTBigCodeForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GPTBigCodeForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GPTBigCodeForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gpt_bigcode/modeling_gpt_bigcode.py#L1153",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeConfig"
>GPTBigCodeConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),D=new Zt({props:{$$slots:{default:[cn]},$$scope:{ctx:M}}}),K=new st({props:{anchor:"transformers.GPTBigCodeForSequenceClassification.forward.example",$$slots:{default:[pn]},$$scope:{ctx:M}}}),ee=new st({props:{anchor:"transformers.GPTBigCodeForSequenceClassification.forward.example-2",$$slots:{default:[mn]},$$scope:{ctx:M}}}),je=new S({props:{title:"GPTBigCodeForTokenClassification",local:"transformers.GPTBigCodeForTokenClassification",headingTag:"h2"}}),Fe=new L({props:{name:"class transformers.GPTBigCodeForTokenClassification",anchor:"transformers.GPTBigCodeForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.GPTBigCodeForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeForTokenClassification">GPTBigCodeForTokenClassification</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gpt_bigcode/modeling_gpt_bigcode.py#L1265"}}),We=new L({props:{name:"forward",anchor:"transformers.GPTBigCodeForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.GPTBigCodeForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else
<code>past_key_values[0][0].shape[-2]</code> (<code>sequence_length</code> of input past key value states). Indices of input
sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.GPTBigCodeForTokenClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.GPTBigCodeForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.GPTBigCodeForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.GPTBigCodeForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.GPTBigCodeForTokenClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.GPTBigCodeForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.GPTBigCodeForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.GPTBigCodeForTokenClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.GPTBigCodeForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GPTBigCodeForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GPTBigCodeForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gpt_bigcode/modeling_gpt_bigcode.py#L1284",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/gpt_bigcode#transformers.GPTBigCodeConfig"
>GPTBigCodeConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),te=new Zt({props:{$$slots:{default:[hn]},$$scope:{ctx:M}}}),oe=new st({props:{anchor:"transformers.GPTBigCodeForTokenClassification.forward.example",$$slots:{default:[un]},$$scope:{ctx:M}}}),ze=new sn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/gpt_bigcode.md"}}),{c(){n=d("meta"),k=a(),p=d("p"),m=a(),u(y.$$.fragment),s=a(),C=d("div"),C.innerHTML=To,at=a(),u(ne.$$.fragment),rt=a(),se=d("p"),se.innerHTML=bo,it=a(),ae=d("p"),ae.textContent=yo,lt=a(),re=d("p"),re.innerHTML=ko,dt=a(),ie=d("p"),ie.innerHTML=Co,ct=a(),u(le.$$.fragment),pt=a(),de=d("p"),de.textContent=Mo,mt=a(),ce=d("ul"),ce.innerHTML=vo,ht=a(),pe=d("p"),pe.innerHTML=wo,ut=a(),me=d("blockquote"),me.innerHTML=$o,gt=a(),u(he.$$.fragment),ft=a(),ue=d("p"),ue.textContent=Go,_t=a(),u(ge.$$.fragment),Tt=a(),fe=d("p"),fe.textContent=Bo,bt=a(),_e=d("p"),_e.textContent=xo,yt=a(),u(Te.$$.fragment),kt=a(),u(be.$$.fragment),Ct=a(),ye=d("p"),ye.innerHTML=Jo,Mt=a(),Y=d("div"),Y.innerHTML=Po,vt=a(),u(ke.$$.fragment),wt=a(),J=d("div"),u(Ce.$$.fragment),It=a(),Ze=d("p"),Ze.innerHTML=jo,qt=a(),Ie=d("p"),Ie.innerHTML=Fo,Nt=a(),u(A.$$.fragment),$t=a(),u(Me.$$.fragment),Gt=a(),$=d("div"),u(ve.$$.fragment),Rt=a(),qe=d("p"),qe.textContent=Wo,Vt=a(),Ne=d("p"),Ne.innerHTML=zo,St=a(),Re=d("p"),Re.innerHTML=Uo,Ht=a(),V=d("div"),u(we.$$.fragment),Lt=a(),Ve=d("p"),Ve.innerHTML=Zo,Et=a(),u(X.$$.fragment),Bt=a(),u($e.$$.fragment),xt=a(),G=d("div"),u(Ge.$$.fragment),Yt=a(),Se=d("p"),Se.textContent=Io,At=a(),He=d("p"),He.innerHTML=qo,Xt=a(),Le=d("p"),Le.innerHTML=No,Qt=a(),z=d("div"),u(Be.$$.fragment),Ot=a(),Ee=d("p"),Ee.innerHTML=Ro,Dt=a(),u(Q.$$.fragment),Kt=a(),u(O.$$.fragment),Jt=a(),u(xe.$$.fragment),Pt=a(),v=d("div"),u(Je.$$.fragment),eo=a(),Ye=d("p"),Ye.textContent=Vo,to=a(),Ae=d("p"),Ae.innerHTML=So,oo=a(),Xe=d("p"),Xe.innerHTML=Ho,no=a(),Qe=d("p"),Qe.innerHTML=Lo,so=a(),Oe=d("p"),Oe.innerHTML=Eo,ao=a(),x=d("div"),u(Pe.$$.fragment),ro=a(),De=d("p"),De.innerHTML=Yo,io=a(),u(D.$$.fragment),lo=a(),u(K.$$.fragment),co=a(),u(ee.$$.fragment),jt=a(),u(je.$$.fragment),Ft=a(),B=d("div"),u(Fe.$$.fragment),po=a(),Ke=d("p"),Ke.textContent=Ao,mo=a(),et=d("p"),et.innerHTML=Xo,ho=a(),tt=d("p"),tt.innerHTML=Qo,uo=a(),U=d("div"),u(We.$$.fragment),go=a(),ot=d("p"),ot.innerHTML=Oo,fo=a(),u(te.$$.fragment),_o=a(),u(oe.$$.fragment),Wt=a(),u(ze.$$.fragment),zt=a(),nt=d("p"),this.h()},l(e){const t=on("svelte-u9bgzb",document.head);n=c(t,"META",{name:!0,content:!0}),t.forEach(o),k=r(e),p=c(e,"P",{}),R(p).forEach(o),m=r(e),g(y.$$.fragment,e),s=r(e),C=c(e,"DIV",{class:!0,"data-svelte-h":!0}),h(C)!=="svelte-b95w5j"&&(C.innerHTML=To),at=r(e),g(ne.$$.fragment,e),rt=r(e),se=c(e,"P",{"data-svelte-h":!0}),h(se)!=="svelte-1y7x4r1"&&(se.innerHTML=bo),it=r(e),ae=c(e,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-vfdo9a"&&(ae.textContent=yo),lt=r(e),re=c(e,"P",{"data-svelte-h":!0}),h(re)!=="svelte-smsn49"&&(re.innerHTML=ko),dt=r(e),ie=c(e,"P",{"data-svelte-h":!0}),h(ie)!=="svelte-1v15zxi"&&(ie.innerHTML=Co),ct=r(e),g(le.$$.fragment,e),pt=r(e),de=c(e,"P",{"data-svelte-h":!0}),h(de)!=="svelte-kswcp9"&&(de.textContent=Mo),mt=r(e),ce=c(e,"UL",{"data-svelte-h":!0}),h(ce)!=="svelte-ll4zqs"&&(ce.innerHTML=vo),ht=r(e),pe=c(e,"P",{"data-svelte-h":!0}),h(pe)!=="svelte-4sqm6f"&&(pe.innerHTML=wo),ut=r(e),me=c(e,"BLOCKQUOTE",{"data-svelte-h":!0}),h(me)!=="svelte-1fwzni2"&&(me.innerHTML=$o),gt=r(e),g(he.$$.fragment,e),ft=r(e),ue=c(e,"P",{"data-svelte-h":!0}),h(ue)!=="svelte-o3pzzu"&&(ue.textContent=Go),_t=r(e),g(ge.$$.fragment,e),Tt=r(e),fe=c(e,"P",{"data-svelte-h":!0}),h(fe)!=="svelte-enej3y"&&(fe.textContent=Bo),bt=r(e),_e=c(e,"P",{"data-svelte-h":!0}),h(_e)!=="svelte-14hchid"&&(_e.textContent=xo),yt=r(e),g(Te.$$.fragment,e),kt=r(e),g(be.$$.fragment,e),Ct=r(e),ye=c(e,"P",{"data-svelte-h":!0}),h(ye)!=="svelte-15phqwn"&&(ye.innerHTML=Jo),Mt=r(e),Y=c(e,"DIV",{style:!0,"data-svelte-h":!0}),h(Y)!=="svelte-1sxfobm"&&(Y.innerHTML=Po),vt=r(e),g(ke.$$.fragment,e),wt=r(e),J=c(e,"DIV",{class:!0});var I=R(J);g(Ce.$$.fragment,I),It=r(I),Ze=c(I,"P",{"data-svelte-h":!0}),h(Ze)!=="svelte-1mey874"&&(Ze.innerHTML=jo),qt=r(I),Ie=c(I,"P",{"data-svelte-h":!0}),h(Ie)!=="svelte-o55m63"&&(Ie.innerHTML=Fo),Nt=r(I),g(A.$$.fragment,I),I.forEach(o),$t=r(e),g(Me.$$.fragment,e),Gt=r(e),$=c(e,"DIV",{class:!0});var P=R($);g(ve.$$.fragment,P),Rt=r(P),qe=c(P,"P",{"data-svelte-h":!0}),h(qe)!=="svelte-zik6ng"&&(qe.textContent=Wo),Vt=r(P),Ne=c(P,"P",{"data-svelte-h":!0}),h(Ne)!=="svelte-6pahdo"&&(Ne.innerHTML=zo),St=r(P),Re=c(P,"P",{"data-svelte-h":!0}),h(Re)!=="svelte-hswkmf"&&(Re.innerHTML=Uo),Ht=r(P),V=c(P,"DIV",{class:!0});var H=R(V);g(we.$$.fragment,H),Lt=r(H),Ve=c(H,"P",{"data-svelte-h":!0}),h(Ve)!=="svelte-1oqee4y"&&(Ve.innerHTML=Zo),Et=r(H),g(X.$$.fragment,H),H.forEach(o),P.forEach(o),Bt=r(e),g($e.$$.fragment,e),xt=r(e),G=c(e,"DIV",{class:!0});var j=R(G);g(Ge.$$.fragment,j),Yt=r(j),Se=c(j,"P",{"data-svelte-h":!0}),h(Se)!=="svelte-ckfo62"&&(Se.textContent=Io),At=r(j),He=c(j,"P",{"data-svelte-h":!0}),h(He)!=="svelte-6pahdo"&&(He.innerHTML=qo),Xt=r(j),Le=c(j,"P",{"data-svelte-h":!0}),h(Le)!=="svelte-hswkmf"&&(Le.innerHTML=No),Qt=r(j),z=c(j,"DIV",{class:!0});var q=R(z);g(Be.$$.fragment,q),Ot=r(q),Ee=c(q,"P",{"data-svelte-h":!0}),h(Ee)!=="svelte-i9apum"&&(Ee.innerHTML=Ro),Dt=r(q),g(Q.$$.fragment,q),Kt=r(q),g(O.$$.fragment,q),q.forEach(o),j.forEach(o),Jt=r(e),g(xe.$$.fragment,e),Pt=r(e),v=c(e,"DIV",{class:!0});var w=R(v);g(Je.$$.fragment,w),eo=r(w),Ye=c(w,"P",{"data-svelte-h":!0}),h(Ye)!=="svelte-x1zjre"&&(Ye.textContent=Vo),to=r(w),Ae=c(w,"P",{"data-svelte-h":!0}),h(Ae)!=="svelte-14x7550"&&(Ae.innerHTML=So),oo=r(w),Xe=c(w,"P",{"data-svelte-h":!0}),h(Xe)!=="svelte-10ugs3m"&&(Xe.innerHTML=Ho),no=r(w),Qe=c(w,"P",{"data-svelte-h":!0}),h(Qe)!=="svelte-6pahdo"&&(Qe.innerHTML=Lo),so=r(w),Oe=c(w,"P",{"data-svelte-h":!0}),h(Oe)!=="svelte-hswkmf"&&(Oe.innerHTML=Eo),ao=r(w),x=c(w,"DIV",{class:!0});var F=R(x);g(Pe.$$.fragment,F),ro=r(F),De=c(F,"P",{"data-svelte-h":!0}),h(De)!=="svelte-yrv006"&&(De.innerHTML=Yo),io=r(F),g(D.$$.fragment,F),lo=r(F),g(K.$$.fragment,F),co=r(F),g(ee.$$.fragment,F),F.forEach(o),w.forEach(o),jt=r(e),g(je.$$.fragment,e),Ft=r(e),B=c(e,"DIV",{class:!0});var W=R(B);g(Fe.$$.fragment,W),po=r(W),Ke=c(W,"P",{"data-svelte-h":!0}),h(Ke)!=="svelte-ehedqs"&&(Ke.textContent=Ao),mo=r(W),et=c(W,"P",{"data-svelte-h":!0}),h(et)!=="svelte-6pahdo"&&(et.innerHTML=Xo),ho=r(W),tt=c(W,"P",{"data-svelte-h":!0}),h(tt)!=="svelte-hswkmf"&&(tt.innerHTML=Qo),uo=r(W),U=c(W,"DIV",{class:!0});var N=R(U);g(We.$$.fragment,N),go=r(N),ot=c(N,"P",{"data-svelte-h":!0}),h(ot)!=="svelte-16z49hy"&&(ot.innerHTML=Oo),fo=r(N),g(te.$$.fragment,N),_o=r(N),g(oe.$$.fragment,N),N.forEach(o),W.forEach(o),Wt=r(e),g(ze.$$.fragment,e),zt=r(e),nt=c(e,"P",{}),R(nt).forEach(o),this.h()},h(){Z(n,"name","hf:doc:metadata"),Z(n,"content",fn),Z(C,"class","flex flex-wrap space-x-1"),nn(Y,"text-align","center"),Z(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,n),i(e,k,t),i(e,p,t),i(e,m,t),f(y,e,t),i(e,s,t),i(e,C,t),i(e,at,t),f(ne,e,t),i(e,rt,t),i(e,se,t),i(e,it,t),i(e,ae,t),i(e,lt,t),i(e,re,t),i(e,dt,t),i(e,ie,t),i(e,ct,t),f(le,e,t),i(e,pt,t),i(e,de,t),i(e,mt,t),i(e,ce,t),i(e,ht,t),i(e,pe,t),i(e,ut,t),i(e,me,t),i(e,gt,t),f(he,e,t),i(e,ft,t),i(e,ue,t),i(e,_t,t),f(ge,e,t),i(e,Tt,t),i(e,fe,t),i(e,bt,t),i(e,_e,t),i(e,yt,t),f(Te,e,t),i(e,kt,t),f(be,e,t),i(e,Ct,t),i(e,ye,t),i(e,Mt,t),i(e,Y,t),i(e,vt,t),f(ke,e,t),i(e,wt,t),i(e,J,t),f(Ce,J,null),l(J,It),l(J,Ze),l(J,qt),l(J,Ie),l(J,Nt),f(A,J,null),i(e,$t,t),f(Me,e,t),i(e,Gt,t),i(e,$,t),f(ve,$,null),l($,Rt),l($,qe),l($,Vt),l($,Ne),l($,St),l($,Re),l($,Ht),l($,V),f(we,V,null),l(V,Lt),l(V,Ve),l(V,Et),f(X,V,null),i(e,Bt,t),f($e,e,t),i(e,xt,t),i(e,G,t),f(Ge,G,null),l(G,Yt),l(G,Se),l(G,At),l(G,He),l(G,Xt),l(G,Le),l(G,Qt),l(G,z),f(Be,z,null),l(z,Ot),l(z,Ee),l(z,Dt),f(Q,z,null),l(z,Kt),f(O,z,null),i(e,Jt,t),f(xe,e,t),i(e,Pt,t),i(e,v,t),f(Je,v,null),l(v,eo),l(v,Ye),l(v,to),l(v,Ae),l(v,oo),l(v,Xe),l(v,no),l(v,Qe),l(v,so),l(v,Oe),l(v,ao),l(v,x),f(Pe,x,null),l(x,ro),l(x,De),l(x,io),f(D,x,null),l(x,lo),f(K,x,null),l(x,co),f(ee,x,null),i(e,jt,t),f(je,e,t),i(e,Ft,t),i(e,B,t),f(Fe,B,null),l(B,po),l(B,Ke),l(B,mo),l(B,et),l(B,ho),l(B,tt),l(B,uo),l(B,U),f(We,U,null),l(U,go),l(U,ot),l(U,fo),f(te,U,null),l(U,_o),f(oe,U,null),i(e,Wt,t),f(ze,e,t),i(e,zt,t),i(e,nt,t),Ut=!0},p(e,[t]){const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),A.$set(I);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),X.$set(P);const H={};t&2&&(H.$$scope={dirty:t,ctx:e}),Q.$set(H);const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),O.$set(j);const q={};t&2&&(q.$$scope={dirty:t,ctx:e}),D.$set(q);const w={};t&2&&(w.$$scope={dirty:t,ctx:e}),K.$set(w);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),ee.$set(F);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),te.$set(W);const N={};t&2&&(N.$$scope={dirty:t,ctx:e}),oe.$set(N)},i(e){Ut||(_(y.$$.fragment,e),_(ne.$$.fragment,e),_(le.$$.fragment,e),_(he.$$.fragment,e),_(ge.$$.fragment,e),_(Te.$$.fragment,e),_(be.$$.fragment,e),_(ke.$$.fragment,e),_(Ce.$$.fragment,e),_(A.$$.fragment,e),_(Me.$$.fragment,e),_(ve.$$.fragment,e),_(we.$$.fragment,e),_(X.$$.fragment,e),_($e.$$.fragment,e),_(Ge.$$.fragment,e),_(Be.$$.fragment,e),_(Q.$$.fragment,e),_(O.$$.fragment,e),_(xe.$$.fragment,e),_(Je.$$.fragment,e),_(Pe.$$.fragment,e),_(D.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(je.$$.fragment,e),_(Fe.$$.fragment,e),_(We.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(ze.$$.fragment,e),Ut=!0)},o(e){T(y.$$.fragment,e),T(ne.$$.fragment,e),T(le.$$.fragment,e),T(he.$$.fragment,e),T(ge.$$.fragment,e),T(Te.$$.fragment,e),T(be.$$.fragment,e),T(ke.$$.fragment,e),T(Ce.$$.fragment,e),T(A.$$.fragment,e),T(Me.$$.fragment,e),T(ve.$$.fragment,e),T(we.$$.fragment,e),T(X.$$.fragment,e),T($e.$$.fragment,e),T(Ge.$$.fragment,e),T(Be.$$.fragment,e),T(Q.$$.fragment,e),T(O.$$.fragment,e),T(xe.$$.fragment,e),T(Je.$$.fragment,e),T(Pe.$$.fragment,e),T(D.$$.fragment,e),T(K.$$.fragment,e),T(ee.$$.fragment,e),T(je.$$.fragment,e),T(Fe.$$.fragment,e),T(We.$$.fragment,e),T(te.$$.fragment,e),T(oe.$$.fragment,e),T(ze.$$.fragment,e),Ut=!1},d(e){e&&(o(k),o(p),o(m),o(s),o(C),o(at),o(rt),o(se),o(it),o(ae),o(lt),o(re),o(dt),o(ie),o(ct),o(pt),o(de),o(mt),o(ce),o(ht),o(pe),o(ut),o(me),o(gt),o(ft),o(ue),o(_t),o(Tt),o(fe),o(bt),o(_e),o(yt),o(kt),o(Ct),o(ye),o(Mt),o(Y),o(vt),o(wt),o(J),o($t),o(Gt),o($),o(Bt),o(xt),o(G),o(Jt),o(Pt),o(v),o(jt),o(Ft),o(B),o(Wt),o(zt),o(nt)),o(n),b(y,e),b(ne,e),b(le,e),b(he,e),b(ge,e),b(Te,e),b(be,e),b(ke,e),b(Ce),b(A),b(Me,e),b(ve),b(we),b(X),b($e,e),b(Ge),b(Be),b(Q),b(O),b(xe,e),b(Je),b(Pe),b(D),b(K),b(ee),b(je,e),b(Fe),b(We),b(te),b(oe),b(ze,e)}}}const fn='{"title":"GPTBigCode","local":"gptbigcode","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Implementation details","local":"implementation-details","sections":[],"depth":2},{"title":"Combining Starcoder and Flash Attention 2","local":"combining-starcoder-and-flash-attention-2","sections":[{"title":"Expected speedups","local":"expected-speedups","sections":[],"depth":3}],"depth":2},{"title":"GPTBigCodeConfig","local":"transformers.GPTBigCodeConfig","sections":[],"depth":2},{"title":"GPTBigCodeModel","local":"transformers.GPTBigCodeModel","sections":[],"depth":2},{"title":"GPTBigCodeForCausalLM","local":"transformers.GPTBigCodeForCausalLM","sections":[],"depth":2},{"title":"GPTBigCodeForSequenceClassification","local":"transformers.GPTBigCodeForSequenceClassification","sections":[],"depth":2},{"title":"GPTBigCodeForTokenClassification","local":"transformers.GPTBigCodeForTokenClassification","sections":[],"depth":2}],"depth":1}';function _n(M){return Ko(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $n extends en{constructor(n){super(),tn(this,n,_n,gn,Do,{})}}export{$n as component};
