import{s as cn,z as dn,o as mn,n as U}from"../chunks/scheduler.18a86fab.js";import{S as pn,i as gn,g as m,s as a,r as g,A as hn,h as p,f as s,c as r,j as x,u as h,x as y,k as j,y as i,a as c,v as u,d as f,t as _,w as b}from"../chunks/index.98837b22.js";import{T as Dt}from"../chunks/Tip.77304350.js";import{D as J}from"../chunks/Docstring.6758ea23.js";import{C as D}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Q}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as V}from"../chunks/Heading.7e7e0c5b.js";import{E as un}from"../chunks/index.499f366c.js";function fn(T){let o,v=`The architecture of OWLv2 is identical to <a href="owlvit">OWL-ViT</a>, however the object detection head now also includes an objectness classifier, which predicts the (query-agnostic) likelihood that a predicted box contains an object (as opposed to background). The objectness score can be used to rank or filter predictions independently of text queries.
Usage of OWLv2 is identical to <a href="owlvit">OWL-ViT</a> with a new, updated image processor (<a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a>).`;return{c(){o=m("p"),o.innerHTML=v},l(d){o=p(d,"P",{"data-svelte-h":!0}),y(o)!=="svelte-ydk29n"&&(o.innerHTML=v)},m(d,l){c(d,o,l)},p:U,d(d){d&&s(o)}}}function _n(T){let o,v="Example:",d,l,w;return l=new D({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME93bHYyVGV4dENvbmZpZyUyQyUyME93bHYyVGV4dE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME93bHYyVGV4dE1vZGVsJTIwd2l0aCUyMGdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBPd2x2MlRleHRDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBPd2x2MlRleHRDb25maWclMjBmcm9tJTIwdGhlJTIwZ29vZ2xlJTJGb3dsdjItYmFzZS1wYXRjaDE2JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBPd2x2MlRleHRNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Owlv2TextConfig, Owlv2TextModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Owlv2TextModel with google/owlv2-base-patch16 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Owlv2TextConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Owlv2TextConfig from the google/owlv2-base-patch16 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2TextModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=m("p"),o.textContent=v,d=a(),g(l.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-11lpom8"&&(o.textContent=v),d=r(t),h(l.$$.fragment,t)},m(t,M){c(t,o,M),c(t,d,M),u(l,t,M),w=!0},p:U,i(t){w||(f(l.$$.fragment,t),w=!0)},o(t){_(l.$$.fragment,t),w=!1},d(t){t&&(s(o),s(d)),b(l,t)}}}function bn(T){let o,v="Example:",d,l,w;return l=new D({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME93bHYyVmlzaW9uQ29uZmlnJTJDJTIwT3dsdjJWaXNpb25Nb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBPd2x2MlZpc2lvbk1vZGVsJTIwd2l0aCUyMGdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBPd2x2MlZpc2lvbkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME93bHYyVmlzaW9uTW9kZWwlMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyME93bHYyVmlzaW9uTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Owlv2VisionConfig, Owlv2VisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Owlv2VisionModel with google/owlv2-base-patch16 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Owlv2VisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Owlv2VisionModel model from the google/owlv2-base-patch16 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2VisionModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=m("p"),o.textContent=v,d=a(),g(l.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-11lpom8"&&(o.textContent=v),d=r(t),h(l.$$.fragment,t)},m(t,M){c(t,o,M),c(t,d,M),u(l,t,M),w=!0},p:U,i(t){w||(f(l.$$.fragment,t),w=!0)},o(t){_(l.$$.fragment,t),w=!1},d(t){t&&(s(o),s(d)),b(l,t)}}}function wn(T){let o,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=v},l(d){o=p(d,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=v)},m(d,l){c(d,o,l)},p:U,d(d){d&&s(o)}}}function vn(T){let o,v="Examples:",d,l,w;return l=new D({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyME93bHYyTW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyME93bHYyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNi1lbnNlbWJsZSUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYtZW5zZW1ibGUlMjIpJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEJTVCJTVCJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwY2F0JTIyJTJDJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwZG9nJTIyJTVEJTVEJTJDJTIwaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHNfcGVyX2ltYWdlJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHNfcGVyX2ltYWdlJTIwJTIwJTIzJTIwdGhpcyUyMGlzJTIwdGhlJTIwaW1hZ2UtdGV4dCUyMHNpbWlsYXJpdHklMjBzY29yZSUwQXByb2JzJTIwJTNEJTIwbG9naXRzX3Blcl9pbWFnZS5zb2Z0bWF4KGRpbSUzRDEpJTIwJTIwJTIzJTIwd2UlMjBjYW4lMjB0YWtlJTIwdGhlJTIwc29mdG1heCUyMHRvJTIwZ2V0JTIwdGhlJTIwbGFiZWwlMjBwcm9iYWJpbGl0aWVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2Model

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2Model.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=[[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>]], images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = logits_per_image.softmax(dim=<span class="hljs-number">1</span>)  <span class="hljs-comment"># we can take the softmax to get the label probabilities</span>`,wrap:!1}}),{c(){o=m("p"),o.textContent=v,d=a(),g(l.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-kvfsh7"&&(o.textContent=v),d=r(t),h(l.$$.fragment,t)},m(t,M){c(t,o,M),c(t,d,M),u(l,t,M),w=!0},p:U,i(t){w||(f(l.$$.fragment,t),w=!0)},o(t){_(l.$$.fragment,t),w=!1},d(t){t&&(s(o),s(d)),b(l,t)}}}function yn(T){let o,v="Examples:",d,l,w;return l=new D({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBPd2x2Mk1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBPd2x2Mk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYtZW5zZW1ibGUlMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGb3dsdjItYmFzZS1wYXRjaDE2LWVuc2VtYmxlJTIyKSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTVCJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwY2F0JTIyJTJDJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwZG9nJTIyJTVEJTJDJTIwJTVCJTIycGhvdG8lMjBvZiUyMGElMjBhc3RyYW5hdXQlMjIlNUQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKSUwQXRleHRfZmVhdHVyZXMlMjAlM0QlMjBtb2RlbC5nZXRfdGV4dF9mZWF0dXJlcygqKmlucHV0cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2Model

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2Model.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], [<span class="hljs-string">&quot;photo of a astranaut&quot;</span>]], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_features = model.get_text_features(**inputs)`,wrap:!1}}),{c(){o=m("p"),o.textContent=v,d=a(),g(l.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-kvfsh7"&&(o.textContent=v),d=r(t),h(l.$$.fragment,t)},m(t,M){c(t,o,M),c(t,d,M),u(l,t,M),w=!0},p:U,i(t){w||(f(l.$$.fragment,t),w=!0)},o(t){_(l.$$.fragment,t),w=!1},d(t){t&&(s(o),s(d)),b(l,t)}}}function Mn(T){let o,v="Examples:",d,l,w;return l=new D({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyME93bHYyTW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyME93bHYyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNi1lbnNlbWJsZSUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYtZW5zZW1ibGUlMjIpJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW1hZ2VfZmVhdHVyZXMlMjAlM0QlMjBtb2RlbC5nZXRfaW1hZ2VfZmVhdHVyZXMoKippbnB1dHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2Model

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2Model.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_features = model.get_image_features(**inputs)`,wrap:!1}}),{c(){o=m("p"),o.textContent=v,d=a(),g(l.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-kvfsh7"&&(o.textContent=v),d=r(t),h(l.$$.fragment,t)},m(t,M){c(t,o,M),c(t,d,M),u(l,t,M),w=!0},p:U,i(t){w||(f(l.$$.fragment,t),w=!0)},o(t){_(l.$$.fragment,t),w=!1},d(t){t&&(s(o),s(d)),b(l,t)}}}function Tn(T){let o,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=v},l(d){o=p(d,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=v)},m(d,l){c(d,o,l)},p:U,d(d){d&&s(o)}}}function jn(T){let o,v="Examples:",d,l,w;return l=new D({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBPd2x2MlRleHRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwT3dsdjJUZXh0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNiUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYlMjIpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMHRleHQlM0QlNUIlNUIlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjIlMkMlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBkb2clMjIlNUQlMkMlMjAlNUIlMjJwaG90byUyMG9mJTIwYSUyMGFzdHJhbmF1dCUyMiU1RCU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQXBvb2xlZF9vdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQlMjAlMjAlMjMlMjBwb29sZWQlMjAoRU9TJTIwdG9rZW4pJTIwc3RhdGVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2TextModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2TextModel.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], [<span class="hljs-string">&quot;photo of a astranaut&quot;</span>]], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooled_output = outputs.pooler_output  <span class="hljs-comment"># pooled (EOS token) states</span>`,wrap:!1}}),{c(){o=m("p"),o.textContent=v,d=a(),g(l.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-kvfsh7"&&(o.textContent=v),d=r(t),h(l.$$.fragment,t)},m(t,M){c(t,o,M),c(t,d,M),u(l,t,M),w=!0},p:U,i(t){w||(f(l.$$.fragment,t),w=!0)},o(t){_(l.$$.fragment,t),w=!1},d(t){t&&(s(o),s(d)),b(l,t)}}}function xn(T){let o,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=v},l(d){o=p(d,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=v)},m(d,l){c(d,o,l)},p:U,d(d){d&&s(o)}}}function Jn(T){let o,v="Examples:",d,l,w;return l=new D({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyME93bHYyVmlzaW9uTW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyME93bHYyVmlzaW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNiUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYlMjIpJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQXBvb2xlZF9vdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQlMjAlMjAlMjMlMjBwb29sZWQlMjBDTFMlMjBzdGF0ZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2VisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2VisionModel.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooled_output = outputs.pooler_output  <span class="hljs-comment"># pooled CLS states</span>`,wrap:!1}}),{c(){o=m("p"),o.textContent=v,d=a(),g(l.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-kvfsh7"&&(o.textContent=v),d=r(t),h(l.$$.fragment,t)},m(t,M){c(t,o,M),c(t,d,M),u(l,t,M),w=!0},p:U,i(t){w||(f(l.$$.fragment,t),w=!0)},o(t){_(l.$$.fragment,t),w=!1},d(t){t&&(s(o),s(d)),b(l,t)}}}function $n(T){let o,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=v},l(d){o=p(d,"P",{"data-svelte-h":!0}),y(o)!=="svelte-fincs2"&&(o.innerHTML=v)},m(d,l){c(d,o,l)},p:U,d(d){d&&s(o)}}}function On(T){let o,v="Examples:",d,l,w;return l=new D({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Owlv2Processor, Owlv2ForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = Owlv2Processor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2ForObjectDetection.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_labels = [[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text_labels, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Target image sizes (height, width) to rescale box predictions [batch_size, 2]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([(image.height, image.width)])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Convert outputs (bounding boxes and class logits) to Pascal VOC format (xmin, ymin, xmax, ymax)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.post_process_grounded_object_detection(
<span class="hljs-meta">... </span>    outputs=outputs, target_sizes=target_sizes, threshold=<span class="hljs-number">0.1</span>, text_labels=text_labels
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Retrieve predictions for the first image for the corresponding text queries</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = results[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes, scores, text_labels = result[<span class="hljs-string">&quot;boxes&quot;</span>], result[<span class="hljs-string">&quot;scores&quot;</span>], result[<span class="hljs-string">&quot;text_labels&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, text_label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, text_labels):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Detected <span class="hljs-subst">{text_label}</span> with confidence <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>)
Detected a photo of a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.614</span> at location [<span class="hljs-number">341.67</span>, <span class="hljs-number">23.39</span>, <span class="hljs-number">642.32</span>, <span class="hljs-number">371.35</span>]
Detected a photo of a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.665</span> at location [<span class="hljs-number">6.75</span>, <span class="hljs-number">51.96</span>, <span class="hljs-number">326.62</span>, <span class="hljs-number">473.13</span>]`,wrap:!1}}),{c(){o=m("p"),o.textContent=v,d=a(),g(l.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-kvfsh7"&&(o.textContent=v),d=r(t),h(l.$$.fragment,t)},m(t,M){c(t,o,M),c(t,d,M),u(l,t,M),w=!0},p:U,i(t){w||(f(l.$$.fragment,t),w=!0)},o(t){_(l.$$.fragment,t),w=!1},d(t){t&&(s(o),s(d)),b(l,t)}}}function In(T){let o,v="Examples:",d,l,w;return l=new D({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2ForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2ForObjectDetection.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>query_url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000001675.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>query_image = Image.<span class="hljs-built_in">open</span>(requests.get(query_url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, query_images=query_image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model.image_guided_detection(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.Tensor([image.size[::-<span class="hljs-number">1</span>]])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Convert outputs (bounding boxes and class logits) to Pascal VOC format (xmin, ymin, xmax, ymax)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.post_process_image_guided_detection(
<span class="hljs-meta">... </span>    outputs=outputs, threshold=<span class="hljs-number">0.9</span>, nms_threshold=<span class="hljs-number">0.3</span>, target_sizes=target_sizes
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>i = <span class="hljs-number">0</span>  <span class="hljs-comment"># Retrieve predictions for the first image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes, scores = results[i][<span class="hljs-string">&quot;boxes&quot;</span>], results[i][<span class="hljs-string">&quot;scores&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Detected similar object with confidence <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>)
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.938</span> at location [<span class="hljs-number">327.31</span>, <span class="hljs-number">54.94</span>, <span class="hljs-number">547.39</span>, <span class="hljs-number">268.06</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.959</span> at location [<span class="hljs-number">5.78</span>, <span class="hljs-number">360.65</span>, <span class="hljs-number">619.12</span>, <span class="hljs-number">366.39</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.902</span> at location [<span class="hljs-number">2.85</span>, <span class="hljs-number">360.01</span>, <span class="hljs-number">627.63</span>, <span class="hljs-number">380.8</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.985</span> at location [<span class="hljs-number">176.98</span>, -<span class="hljs-number">29.45</span>, <span class="hljs-number">672.69</span>, <span class="hljs-number">182.83</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">1.0</span> at location [<span class="hljs-number">6.53</span>, <span class="hljs-number">14.35</span>, <span class="hljs-number">624.87</span>, <span class="hljs-number">470.82</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.998</span> at location [<span class="hljs-number">579.98</span>, <span class="hljs-number">29.14</span>, <span class="hljs-number">615.49</span>, <span class="hljs-number">489.05</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.985</span> at location [<span class="hljs-number">206.15</span>, <span class="hljs-number">10.53</span>, <span class="hljs-number">247.74</span>, <span class="hljs-number">466.01</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.947</span> at location [<span class="hljs-number">18.62</span>, <span class="hljs-number">429.72</span>, <span class="hljs-number">646.5</span>, <span class="hljs-number">457.72</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.996</span> at location [<span class="hljs-number">523.88</span>, <span class="hljs-number">20.69</span>, <span class="hljs-number">586.84</span>, <span class="hljs-number">483.18</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.998</span> at location [<span class="hljs-number">3.39</span>, <span class="hljs-number">360.59</span>, <span class="hljs-number">617.29</span>, <span class="hljs-number">499.21</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.969</span> at location [<span class="hljs-number">4.47</span>, <span class="hljs-number">449.05</span>, <span class="hljs-number">614.5</span>, <span class="hljs-number">474.76</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.966</span> at location [<span class="hljs-number">31.44</span>, <span class="hljs-number">463.65</span>, <span class="hljs-number">654.66</span>, <span class="hljs-number">471.07</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.924</span> at location [<span class="hljs-number">30.93</span>, <span class="hljs-number">468.07</span>, <span class="hljs-number">635.35</span>, <span class="hljs-number">475.39</span>]`,wrap:!1}}),{c(){o=m("p"),o.textContent=v,d=a(),g(l.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),y(o)!=="svelte-kvfsh7"&&(o.textContent=v),d=r(t),h(l.$$.fragment,t)},m(t,M){c(t,o,M),c(t,d,M),u(l,t,M),w=!0},p:U,i(t){w||(f(l.$$.fragment,t),w=!0)},o(t){_(l.$$.fragment,t),w=!1},d(t){t&&(s(o),s(d)),b(l,t)}}}function zn(T){let o,v,d,l,w,t,M,zs='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Et,xe,Yt,Je,Us='OWLv2 was proposed in <a href="https://arxiv.org/abs/2306.09683" rel="nofollow">Scaling Open-Vocabulary Object Detection</a> by Matthias Minderer, Alexey Gritsenko, Neil Houlsby. OWLv2 scales up <a href="owlvit">OWL-ViT</a> using self-training, which uses an existing detector to generate pseudo-box annotations on image-text pairs. This results in large gains over the previous state-of-the-art for zero-shot object detection.',Qt,$e,Cs="The abstract from the paper is the following:",St,Oe,ks="<em>Open-vocabulary object detection has benefited greatly from pretrained vision-language models, but is still limited by the amount of available detection training data. While detection training data can be expanded by using Web image-text pairs as weak supervision, this has not been done at scales comparable to image-level pretraining. Here, we scale up detection data with self-training, which uses an existing detector to generate pseudo-box annotations on image-text pairs. Major challenges in scaling self-training are the choice of label space, pseudo-annotation filtering, and training efficiency. We present the OWLv2 model and OWL-ST self-training recipe, which address these challenges. OWLv2 surpasses the performance of previous state-of-the-art open-vocabulary detectors already at comparable training scales (~10M examples). However, with OWL-ST, we can scale to over 1B examples, yielding further large improvement: With an L/14 architecture, OWL-ST improves AP on LVIS rare classes, for which the model has seen no human box annotations, from 31.2% to 44.6% (43% relative improvement). OWL-ST unlocks Web-scale training for open-world localization, similar to what has been seen for image classification and language modelling.</em>",At,S,Ws,Kt,Ie,Zs='OWLv2 high-level overview. Taken from the <a href="https://arxiv.org/abs/2306.09683">original paper</a>.',eo,ze,Ns=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/google-research/scenic/tree/main/scenic/projects/owl_vit" rel="nofollow">here</a>.`,to,Ue,oo,Ce,Vs='OWLv2 is, just like its predecessor <a href="owlvit">OWL-ViT</a>, a zero-shot text-conditioned object detection model. OWL-ViT uses <a href="clip">CLIP</a> as its multi-modal backbone, with a ViT-like Transformer to get visual features and a causal language model to get the text features. To use CLIP for detection, OWL-ViT removes the final token pooling layer of the vision model and attaches a lightweight classification and box head to each transformer output token. Open-vocabulary classification is enabled by replacing the fixed classification layer weights with the class-name embeddings obtained from the text model. The authors first train CLIP from scratch and fine-tune it end-to-end with the classification and box heads on standard detection datasets using a bipartite matching loss. One or multiple text queries per image can be used to perform zero-shot text-conditioned object detection.',so,ke,Bs='<a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a> can be used to resize (or rescale) and normalize images for the model and <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> is used to encode the text. <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Processor">Owlv2Processor</a> wraps <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> into a single instance to both encode the text and prepare the images. The following example shows how to perform object detection using <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Processor">Owlv2Processor</a> and <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ForObjectDetection">Owlv2ForObjectDetection</a>.',no,We,ao,Ze,ro,Ne,Rs='<li>A demo notebook on using OWLv2 for zero- and one-shot (image-guided) object detection can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/OWLv2" rel="nofollow">here</a>.</li> <li><a href="../tasks/zero_shot_object_detection">Zero-shot object detection task guide</a></li>',lo,A,io,Ve,co,C,Be,Zo,Tt,Hs=`<a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Config">Owlv2Config</a> is the configuration class to store the configuration of an <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Model">Owlv2Model</a>. It is used to
instantiate an OWLv2 model according to the specified arguments, defining the text model and vision model
configs. Instantiating a configuration with the defaults will yield a similar configuration to that of the OWLv2
<a href="https://huggingface.co/google/owlv2-base-patch16" rel="nofollow">google/owlv2-base-patch16</a> architecture.`,No,jt,Fs=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Vo,K,Re,Bo,xt,Ps=`Instantiate a <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Config">Owlv2Config</a> (or a derived class) from owlv2 text model configuration and owlv2 vision
model configuration.`,mo,He,po,k,Fe,Ro,Jt,qs=`This is the configuration class to store the configuration of an <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2TextModel">Owlv2TextModel</a>. It is used to instantiate an
Owlv2 text encoder according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Owlv2
<a href="https://huggingface.co/google/owlv2-base-patch16" rel="nofollow">google/owlv2-base-patch16</a> architecture.`,Ho,$t,Gs=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Fo,ee,go,Pe,ho,W,qe,Po,Ot,Ls=`This is the configuration class to store the configuration of an <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionModel">Owlv2VisionModel</a>. It is used to instantiate
an OWLv2 image encoder according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the OWLv2
<a href="https://huggingface.co/google/owlv2-base-patch16" rel="nofollow">google/owlv2-base-patch16</a> architecture.`,qo,It,Xs=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Go,te,uo,Ge,fo,I,Le,Lo,zt,Ds="Constructs an OWLv2 image processor.",Xo,oe,Xe,Do,Ut,Es="Preprocess an image or batch of images.",Eo,se,De,Yo,Ct,Ys=`Converts the raw output of <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ForObjectDetection">Owlv2ForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format.`,Qo,ne,Ee,So,kt,Qs=`Converts the output of <a href="/docs/transformers/main/en/model_doc/owlvit#transformers.OwlViTForObjectDetection.image_guided_detection">OwlViTForObjectDetection.image_guided_detection()</a> into the format expected by the COCO
api.`,_o,Ye,bo,z,Qe,Ao,Wt,Ss=`Constructs an Owlv2 processor which wraps <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a>/<a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> into
a single processor that inherits both the image processor and tokenizer functionalities. See the
<a href="/docs/transformers/main/en/model_doc/owlvit#transformers.OwlViTProcessor.__call__"><strong>call</strong>()</a> and <code>decode()</code> for more information.`,Ko,ae,Se,es,Zt,As=`Main method to prepare for the model one or several text(s) and image(s). This method forwards the <code>text</code> and
<code>kwargs</code> arguments to CLIPTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__"><strong>call</strong>()</a> if <code>text</code> is not <code>None</code> to encode:
the text. To prepare the image(s), this method forwards the <code>images</code> and <code>kwrags</code> arguments to
CLIPImageProcessor’s <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__"><strong>call</strong>()</a> if <code>images</code> is not <code>None</code>. Please refer to the docstring
of the above two methods for more information.`,ts,re,Ae,os,Nt,Ks=`Converts the raw output of <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ForObjectDetection">Owlv2ForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format.`,ss,le,Ke,ns,Vt,en=`Converts the output of <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ForObjectDetection.image_guided_detection">Owlv2ForObjectDetection.image_guided_detection()</a> into the format expected by the COCO
api.`,wo,et,vo,$,tt,as,Bt,tn="The bare Owlv2 Model outputting raw hidden-states without any specific head on top.",rs,Rt,on=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ls,Ht,sn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,is,B,ot,cs,Ft,nn='The <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Model">Owlv2Model</a> forward method, overrides the <code>__call__</code> special method.',ds,ie,ms,ce,ps,de,st,gs,me,hs,pe,nt,us,ge,yo,at,Mo,E,rt,fs,R,lt,_s,Pt,an='The <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2TextModel">Owlv2TextModel</a> forward method, overrides the <code>__call__</code> special method.',bs,he,ws,ue,To,it,jo,Y,ct,vs,H,dt,ys,qt,rn='The <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionModel">Owlv2VisionModel</a> forward method, overrides the <code>__call__</code> special method.',Ms,fe,Ts,_e,xo,mt,Jo,P,pt,js,F,gt,xs,Gt,ln='The <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ForObjectDetection">Owlv2ForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',Js,be,$s,we,Os,ve,ht,Is,ye,$o,ut,Oo,Xt,Io;return w=new V({props:{title:"OWLv2",local:"owlv2",headingTag:"h1"}}),xe=new V({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Ue=new V({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),We=new D({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Owlv2Processor, Owlv2ForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = Owlv2Processor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2ForObjectDetection.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_labels = [[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text_labels, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Target image sizes (height, width) to rescale box predictions [batch_size, 2]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([(image.height, image.width)])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Convert outputs (bounding boxes and class logits) to Pascal VOC format (xmin, ymin, xmax, ymax)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.post_process_grounded_object_detection(
<span class="hljs-meta">... </span>    outputs=outputs, target_sizes=target_sizes, threshold=<span class="hljs-number">0.1</span>, text_labels=text_labels
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Retrieve predictions for the first image for the corresponding text queries</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = results[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes, scores, text_labels = result[<span class="hljs-string">&quot;boxes&quot;</span>], result[<span class="hljs-string">&quot;scores&quot;</span>], result[<span class="hljs-string">&quot;text_labels&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, text_label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, text_labels):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Detected <span class="hljs-subst">{text_label}</span> with confidence <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>)
Detected a photo of a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.614</span> at location [<span class="hljs-number">341.67</span>, <span class="hljs-number">23.39</span>, <span class="hljs-number">642.32</span>, <span class="hljs-number">371.35</span>]
Detected a photo of a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.665</span> at location [<span class="hljs-number">6.75</span>, <span class="hljs-number">51.96</span>, <span class="hljs-number">326.62</span>, <span class="hljs-number">473.13</span>]`,wrap:!1}}),Ze=new V({props:{title:"Resources",local:"resources",headingTag:"h2"}}),A=new Dt({props:{$$slots:{default:[fn]},$$scope:{ctx:T}}}),Ve=new V({props:{title:"Owlv2Config",local:"transformers.Owlv2Config",headingTag:"h2"}}),Be=new J({props:{name:"class transformers.Owlv2Config",anchor:"transformers.Owlv2Config",parameters:[{name:"text_config",val:" = None"},{name:"vision_config",val:" = None"},{name:"projection_dim",val:" = 512"},{name:"logit_scale_init_value",val:" = 2.6592"},{name:"return_dict",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2Config.text_config",description:`<strong>text_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2TextConfig">Owlv2TextConfig</a>.`,name:"text_config"},{anchor:"transformers.Owlv2Config.vision_config",description:`<strong>vision_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionConfig">Owlv2VisionConfig</a>.`,name:"vision_config"},{anchor:"transformers.Owlv2Config.projection_dim",description:`<strong>projection_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of text and vision projection layers.`,name:"projection_dim"},{anchor:"transformers.Owlv2Config.logit_scale_init_value",description:`<strong>logit_scale_init_value</strong> (<code>float</code>, <em>optional</em>, defaults to 2.6592) &#x2014;
The initial value of the <em>logit_scale</em> parameter. Default is used as per the original OWLv2
implementation.`,name:"logit_scale_init_value"},{anchor:"transformers.Owlv2Config.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return a dictionary. If <code>False</code>, returns a tuple.`,name:"return_dict"},{anchor:"transformers.Owlv2Config.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/configuration_owlv2.py#L217"}}),Re=new J({props:{name:"from_text_vision_configs",anchor:"transformers.Owlv2Config.from_text_vision_configs",parameters:[{name:"text_config",val:": typing.Dict"},{name:"vision_config",val:": typing.Dict"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/configuration_owlv2.py#L273",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Config"
>Owlv2Config</a></p>
`}}),He=new V({props:{title:"Owlv2TextConfig",local:"transformers.Owlv2TextConfig",headingTag:"h2"}}),Fe=new J({props:{name:"class transformers.Owlv2TextConfig",anchor:"transformers.Owlv2TextConfig",parameters:[{name:"vocab_size",val:" = 49408"},{name:"hidden_size",val:" = 512"},{name:"intermediate_size",val:" = 2048"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 8"},{name:"max_position_embeddings",val:" = 16"},{name:"hidden_act",val:" = 'quick_gelu'"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"attention_dropout",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"initializer_factor",val:" = 1.0"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 49406"},{name:"eos_token_id",val:" = 49407"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2TextConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 49408) &#x2014;
Vocabulary size of the OWLv2 text model. Defines the number of different tokens that can be represented
by the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2TextModel">Owlv2TextModel</a>.`,name:"vocab_size"},{anchor:"transformers.Owlv2TextConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.Owlv2TextConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.Owlv2TextConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.Owlv2TextConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.Owlv2TextConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.Owlv2TextConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;quick_gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> <code>&quot;quick_gelu&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.Owlv2TextConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.Owlv2TextConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Owlv2TextConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Owlv2TextConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"},{anchor:"transformers.Owlv2TextConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The id of the padding token in the input sequences.`,name:"pad_token_id"},{anchor:"transformers.Owlv2TextConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 49406) &#x2014;
The id of the beginning-of-sequence token in the input sequences.`,name:"bos_token_id"},{anchor:"transformers.Owlv2TextConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 49407) &#x2014;
The id of the end-of-sequence token in the input sequences.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/configuration_owlv2.py#L31"}}),ee=new Q({props:{anchor:"transformers.Owlv2TextConfig.example",$$slots:{default:[_n]},$$scope:{ctx:T}}}),Pe=new V({props:{title:"Owlv2VisionConfig",local:"transformers.Owlv2VisionConfig",headingTag:"h2"}}),qe=new J({props:{name:"class transformers.Owlv2VisionConfig",anchor:"transformers.Owlv2VisionConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"intermediate_size",val:" = 3072"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"num_channels",val:" = 3"},{name:"image_size",val:" = 768"},{name:"patch_size",val:" = 16"},{name:"hidden_act",val:" = 'quick_gelu'"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"attention_dropout",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"initializer_factor",val:" = 1.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2VisionConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.Owlv2VisionConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.Owlv2VisionConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.Owlv2VisionConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.Owlv2VisionConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of channels in the input images.`,name:"num_channels"},{anchor:"transformers.Owlv2VisionConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.Owlv2VisionConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.Owlv2VisionConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;quick_gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> <code>&quot;quick_gelu&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.Owlv2VisionConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.Owlv2VisionConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Owlv2VisionConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Owlv2VisionConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/configuration_owlv2.py#L128"}}),te=new Q({props:{anchor:"transformers.Owlv2VisionConfig.example",$$slots:{default:[bn]},$$scope:{ctx:T}}}),Ge=new V({props:{title:"Owlv2ImageProcessor",local:"transformers.Owlv2ImageProcessor",headingTag:"h2"}}),Le=new J({props:{name:"class transformers.Owlv2ImageProcessor",anchor:"transformers.Owlv2ImageProcessor",parameters:[{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_pad",val:": bool = True"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2ImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.Owlv2ImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.Owlv2ImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image to a square with gray pixels on the bottom and the right. Can be overridden by
<code>do_pad</code> in the <code>preprocess</code> method.`,name:"do_pad"},{anchor:"transformers.Owlv2ImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden
by <code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.Owlv2ImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 960, &quot;width&quot;: 960}</code>):
Size to resize the image to. Can be overridden by <code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.Owlv2ImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling method to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.Owlv2ImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.Owlv2ImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>OPENAI_CLIP_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.Owlv2ImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>OPENAI_CLIP_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/image_processing_owlv2.py#L211"}}),Xe=new J({props:{name:"preprocess",anchor:"transformers.Owlv2ImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.Owlv2ImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether to pad the image to a square with gray pixels on the bottom and the right.`,name:"do_pad"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size to resize the image to.`,name:"size"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/image_processing_owlv2.py#L368"}}),De=new J({props:{name:"post_process_object_detection",anchor:"transformers.Owlv2ImageProcessor.post_process_object_detection",parameters:[{name:"outputs",val:": Owlv2ObjectDetectionOutput"},{name:"threshold",val:": float = 0.1"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple], NoneType] = None"}],parametersDescription:[{anchor:"transformers.Owlv2ImageProcessor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>Owlv2ObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Owlv2ImageProcessor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.Owlv2ImageProcessor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/image_processing_owlv2.py#L503",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the following keys:</p>
<ul>
<li>“scores”: The confidence scores for each predicted box on the image.</li>
<li>“labels”: Indexes of the classes predicted by the model on the image.</li>
<li>“boxes”: Image bounding boxes in (top_left_x, top_left_y, bottom_right_x, bottom_right_y) format.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Ee=new J({props:{name:"post_process_image_guided_detection",anchor:"transformers.Owlv2ImageProcessor.post_process_image_guided_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:" = 0.0"},{name:"nms_threshold",val:" = 0.3"},{name:"target_sizes",val:" = None"}],parametersDescription:[{anchor:"transformers.Owlv2ImageProcessor.post_process_image_guided_detection.outputs",description:`<strong>outputs</strong> (<code>OwlViTImageGuidedObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Owlv2ImageProcessor.post_process_image_guided_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Minimum confidence threshold to use to filter out predicted boxes.`,name:"threshold"},{anchor:"transformers.Owlv2ImageProcessor.post_process_image_guided_detection.nms_threshold",description:`<strong>nms_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
IoU threshold for non-maximum suppression of overlapping boxes.`,name:"nms_threshold"},{anchor:"transformers.Owlv2ImageProcessor.post_process_image_guided_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Tensor of shape (batch_size, 2) where each entry is the (height, width) of the corresponding image in
the batch. If set, predicted normalized bounding boxes are rescaled to the target sizes. If left to
None, predictions will not be unnormalized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/image_processing_owlv2.py#L557",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model. All labels are set to None as
<code>OwlViTForObjectDetection.image_guided_detection</code> perform one-shot object detection.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Ye=new V({props:{title:"Owlv2Processor",local:"transformers.Owlv2Processor",headingTag:"h2"}}),Qe=new J({props:{name:"class transformers.Owlv2Processor",anchor:"transformers.Owlv2Processor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2Processor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.Owlv2Processor.tokenizer",description:`<strong>tokenizer</strong> ([<code>CLIPTokenizer</code>, <code>CLIPTokenizerFast</code>]) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/processing_owlv2.py#L58"}}),Se=new J({props:{name:"__call__",anchor:"transformers.Owlv2Processor.__call__",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor'], NoneType] = None"},{name:"text",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]]] = None"},{name:"*args",val:""},{name:"audio",val:" = None"},{name:"videos",val:" = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.owlv2.processing_owlv2.Owlv2ProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.Owlv2Processor.__call__.images",description:"<strong>images</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;",name:"images"},{anchor:"transformers.Owlv2Processor.__call__.List[torch.Tensor])",description:`<strong><code>List[torch.Tensor]</code>)</strong> &#x2014;
The image or batch of images to be prepared. Each image can be a PIL image, NumPy array or PyTorch
tensor. Both channels-first and channels-last formats are supported.`,name:"List[torch.Tensor])"},{anchor:"transformers.Owlv2Processor.__call__.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"},{anchor:"transformers.Owlv2Processor.__call__.query_images",description:`<strong>query_images</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, <code>List[torch.Tensor]</code>) &#x2014;
The query image to be prepared, one query image is expected per target image to be queried. Each image
can be a PIL image, NumPy array or PyTorch tensor. In case of a NumPy array/PyTorch tensor, each image
should be of shape (C, H, W), where C is a number of channels, H and W are image height and width.`,name:"query_images"},{anchor:"transformers.Owlv2Processor.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors of a particular framework. Acceptable values are:<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return NumPy <code>np.ndarray</code> objects.</li>
<li><code>&apos;jax&apos;</code>: Return JAX <code>jnp.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/processing_owlv2.py#L81",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>input_ids</strong> — List of token ids to be fed to a model. Returned when <code>text</code> is not <code>None</code>.</li>
<li><strong>attention_mask</strong> — List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>“attention_mask”</em> is in <code>self.model_input_names</code> and if <code>text</code> is not
<code>None</code>).</li>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model. Returned when <code>images</code> is not <code>None</code>.</li>
<li><strong>query_pixel_values</strong> — Pixel values of the query images to be fed to a model. Returned when <code>query_images</code> is not <code>None</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),Ae=new J({props:{name:"post_process_grounded_object_detection",anchor:"transformers.Owlv2Processor.post_process_grounded_object_detection",parameters:[{name:"outputs",val:": Owlv2ObjectDetectionOutput"},{name:"threshold",val:": float = 0.1"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple], NoneType] = None"},{name:"text_labels",val:": typing.Optional[typing.List[typing.List[str]]] = None"}],parametersDescription:[{anchor:"transformers.Owlv2Processor.post_process_grounded_object_detection.outputs",description:`<strong>outputs</strong> (<code>Owlv2ObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Owlv2Processor.post_process_grounded_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.Owlv2Processor.post_process_grounded_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.Owlv2Processor.post_process_grounded_object_detection.text_labels",description:`<strong>text_labels</strong> (<code>List[List[str]]</code>, <em>optional</em>) &#x2014;
List of lists of text labels for each image in the batch. If unset, &#x201C;text_labels&#x201D; in output will be
set to <code>None</code>.`,name:"text_labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/processing_owlv2.py#L221",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the following keys:</p>
<ul>
<li>“scores”: The confidence scores for each predicted box on the image.</li>
<li>“labels”: Indexes of the classes predicted by the model on the image.</li>
<li>“boxes”: Image bounding boxes in (top_left_x, top_left_y, bottom_right_x, bottom_right_y) format.</li>
<li>“text_labels”: The text labels for each predicted bounding box on the image.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Ke=new J({props:{name:"post_process_image_guided_detection",anchor:"transformers.Owlv2Processor.post_process_image_guided_detection",parameters:[{name:"outputs",val:": Owlv2ImageGuidedObjectDetectionOutput"},{name:"threshold",val:": float = 0.0"},{name:"nms_threshold",val:": float = 0.3"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple], NoneType] = None"}],parametersDescription:[{anchor:"transformers.Owlv2Processor.post_process_image_guided_detection.outputs",description:`<strong>outputs</strong> (<code>Owlv2ImageGuidedObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Owlv2Processor.post_process_image_guided_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Minimum confidence threshold to use to filter out predicted boxes.`,name:"threshold"},{anchor:"transformers.Owlv2Processor.post_process_image_guided_detection.nms_threshold",description:`<strong>nms_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
IoU threshold for non-maximum suppression of overlapping boxes.`,name:"nms_threshold"},{anchor:"transformers.Owlv2Processor.post_process_image_guided_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Tensor of shape (batch_size, 2) where each entry is the (height, width) of the corresponding image in
the batch. If set, predicted normalized bounding boxes are rescaled to the target sizes. If left to
None, predictions will not be unnormalized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/processing_owlv2.py#L270",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the following keys:</p>
<ul>
<li>“scores”: The confidence scores for each predicted box on the image.</li>
<li>“boxes”: Image bounding boxes in (top_left_x, top_left_y, bottom_right_x, bottom_right_y) format.</li>
<li>“labels”: Set to <code>None</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),et=new V({props:{title:"Owlv2Model",local:"transformers.Owlv2Model",headingTag:"h2"}}),tt=new J({props:{name:"class transformers.Owlv2Model",anchor:"transformers.Owlv2Model",parameters:[{name:"config",val:": Owlv2Config"}],parametersDescription:[{anchor:"transformers.Owlv2Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Config">Owlv2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L927"}}),ot=new J({props:{name:"forward",anchor:"transformers.Owlv2Model.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"return_loss",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_base_image_embeds",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Owlv2Model.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Owlv2Model.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.Owlv2Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Owlv2Model.forward.return_loss",description:`<strong>return_loss</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the contrastive loss.`,name:"return_loss"},{anchor:"transformers.Owlv2Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2Model.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.Owlv2Model.forward.return_base_image_embeds",description:`<strong>return_base_image_embeds</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the base image embeddings.`,name:"return_base_image_embeds"},{anchor:"transformers.Owlv2Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L1051",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.owlv2.modeling_owlv2.Owlv2Output</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Config"
>Owlv2Config</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>return_loss</code> is <code>True</code>) — Contrastive loss for image-text similarity.</li>
<li><strong>logits_per_image</strong> (<code>torch.FloatTensor</code> of shape <code>(image_batch_size, text_batch_size)</code>) — The scaled dot product scores between <code>image_embeds</code> and <code>text_embeds</code>. This represents the image-text
similarity scores.</li>
<li><strong>logits_per_text</strong> (<code>torch.FloatTensor</code> of shape <code>(text_batch_size, image_batch_size)</code>) — The scaled dot product scores between <code>text_embeds</code> and <code>image_embeds</code>. This represents the text-image
similarity scores.</li>
<li><strong>text_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_max_text_queries, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</li>
<li><strong>image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>) — The image embeddings obtained by applying the projection layer to the pooled output of
<a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>.</li>
<li><strong>text_model_output</strong> (Tuple<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</li>
<li><strong>vision_model_output</strong> (<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.owlv2.modeling_owlv2.Owlv2Output</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ie=new Dt({props:{$$slots:{default:[wn]},$$scope:{ctx:T}}}),ce=new Q({props:{anchor:"transformers.Owlv2Model.forward.example",$$slots:{default:[vn]},$$scope:{ctx:T}}}),st=new J({props:{name:"get_text_features",anchor:"transformers.Owlv2Model.get_text_features",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Owlv2Model.get_text_features.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size * num_max_text_queries, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details. <a href="../glossary#input-ids">What are input
IDs?</a>`,name:"input_ids"},{anchor:"transformers.Owlv2Model.get_text_features.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Owlv2Model.get_text_features.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2Model.get_text_features.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2Model.get_text_features.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L964",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The text embeddings obtained by
applying the projection layer to the pooled output of <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>text_features (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>)</p>
`}}),me=new Q({props:{anchor:"transformers.Owlv2Model.get_text_features.example",$$slots:{default:[yn]},$$scope:{ctx:T}}}),nt=new J({props:{name:"get_image_features",anchor:"transformers.Owlv2Model.get_image_features",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Owlv2Model.get_image_features.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.Owlv2Model.get_image_features.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2Model.get_image_features.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2Model.get_image_features.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.Owlv2Model.get_image_features.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L1004",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The image embeddings obtained by
applying the projection layer to the pooled output of <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>image_features (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>)</p>
`}}),ge=new Q({props:{anchor:"transformers.Owlv2Model.get_image_features.example",$$slots:{default:[Mn]},$$scope:{ctx:T}}}),at=new V({props:{title:"Owlv2TextModel",local:"transformers.Owlv2TextModel",headingTag:"h2"}}),rt=new J({props:{name:"class transformers.Owlv2TextModel",anchor:"transformers.Owlv2TextModel",parameters:[{name:"config",val:": Owlv2TextConfig"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L767"}}),lt=new J({props:{name:"forward",anchor:"transformers.Owlv2TextModel.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Owlv2TextModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size * num_max_text_queries, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details. <a href="../glossary#input-ids">What are input
IDs?</a>`,name:"input_ids"},{anchor:"transformers.Owlv2TextModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Owlv2TextModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2TextModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2TextModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L782",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Config"
>Owlv2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),he=new Dt({props:{$$slots:{default:[Tn]},$$scope:{ctx:T}}}),ue=new Q({props:{anchor:"transformers.Owlv2TextModel.forward.example",$$slots:{default:[jn]},$$scope:{ctx:T}}}),it=new V({props:{title:"Owlv2VisionModel",local:"transformers.Owlv2VisionModel",headingTag:"h2"}}),ct=new J({props:{name:"class transformers.Owlv2VisionModel",anchor:"transformers.Owlv2VisionModel",parameters:[{name:"config",val:": Owlv2VisionConfig"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L878"}}),dt=new J({props:{name:"forward",anchor:"transformers.Owlv2VisionModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Owlv2VisionModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.Owlv2VisionModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2VisionModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2VisionModel.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.Owlv2VisionModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L891",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Config"
>Owlv2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),fe=new Dt({props:{$$slots:{default:[xn]},$$scope:{ctx:T}}}),_e=new Q({props:{anchor:"transformers.Owlv2VisionModel.forward.example",$$slots:{default:[Jn]},$$scope:{ctx:T}}}),mt=new V({props:{title:"Owlv2ForObjectDetection",local:"transformers.Owlv2ForObjectDetection",headingTag:"h2"}}),pt=new J({props:{name:"class transformers.Owlv2ForObjectDetection",anchor:"transformers.Owlv2ForObjectDetection",parameters:[{name:"config",val:": Owlv2Config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L1214"}}),gt=new J({props:{name:"forward",anchor:"transformers.Owlv2ForObjectDetection.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"pixel_values",val:": FloatTensor"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Owlv2ForObjectDetection.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size * num_max_text_queries, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details. <a href="../glossary#input-ids">What are input
IDs?</a>.`,name:"input_ids"},{anchor:"transformers.Owlv2ForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.Owlv2ForObjectDetection.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Owlv2ForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2ForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the last hidden state. See <code>text_model_last_hidden_state</code> and
<code>vision_model_last_hidden_state</code> under returned tensors for more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2ForObjectDetection.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.Owlv2ForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L1600",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.owlv2.modeling_owlv2.Owlv2ObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Config"
>Owlv2Config</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, num_queries)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>objectness_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, 1)</code>) — The objectness logits of all image patches. OWL-ViT represents images as a set of image patches where the
total number of patches is (image_size / patch_size)**2.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ImageProcessor.post_process_object_detection"
>post_process_object_detection()</a> to retrieve the
unnormalized bounding boxes.</li>
<li><strong>text_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_max_text_queries, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</li>
<li><strong>image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, patch_size, patch_size, output_dim</code>) — Pooled output of <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>. OWLv2 represents images as a set of image patches and computes image
embeddings for each patch.</li>
<li><strong>class_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, hidden_size)</code>) — Class embeddings of all image patches. OWLv2 represents images as a set of image patches where the total
number of patches is (image_size / patch_size)**2.</li>
<li><strong>text_model_output</strong> (Tuple<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</li>
<li><strong>vision_model_output</strong> (<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.owlv2.modeling_owlv2.Owlv2ObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),be=new Dt({props:{$$slots:{default:[$n]},$$scope:{ctx:T}}}),we=new Q({props:{anchor:"transformers.Owlv2ForObjectDetection.forward.example",$$slots:{default:[On]},$$scope:{ctx:T}}}),ht=new J({props:{name:"image_guided_detection",anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"query_pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.query_pixel_values",description:`<strong>query_pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values of query image(s) to be detected. Pass in one query image per target image.`,name:"query_pixel_values"},{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/owlv2/modeling_owlv2.py#L1482",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.owlv2.modeling_owlv2.Owlv2ImageGuidedObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2Config"
>Owlv2Config</a>) and inputs.</p>
<ul>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, num_queries)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>target_pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual target image in the batch
(disregarding possible padding). You can use <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ImageProcessor.post_process_object_detection"
>post_process_object_detection()</a> to
retrieve the unnormalized bounding boxes.</li>
<li><strong>query_pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual query image in the batch
(disregarding possible padding). You can use <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2ImageProcessor.post_process_object_detection"
>post_process_object_detection()</a> to
retrieve the unnormalized bounding boxes.</li>
<li><strong>image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, patch_size, patch_size, output_dim</code>) — Pooled output of <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>. OWLv2 represents images as a set of image patches and computes
image embeddings for each patch.</li>
<li><strong>query_image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, patch_size, patch_size, output_dim</code>) — Pooled output of <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>. OWLv2 represents images as a set of image patches and computes
image embeddings for each patch.</li>
<li><strong>class_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, hidden_size)</code>) — Class embeddings of all image patches. OWLv2 represents images as a set of image patches where the total
number of patches is (image_size / patch_size)**2.</li>
<li><strong>text_model_output</strong> (Tuple<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</li>
<li><strong>vision_model_output</strong> (<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/main/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.owlv2.modeling_owlv2.Owlv2ImageGuidedObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ye=new Q({props:{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.example",$$slots:{default:[In]},$$scope:{ctx:T}}}),ut=new un({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/owlv2.md"}}),{c(){o=m("meta"),v=a(),d=m("p"),l=a(),g(w.$$.fragment),t=a(),M=m("div"),M.innerHTML=zs,Et=a(),g(xe.$$.fragment),Yt=a(),Je=m("p"),Je.innerHTML=Us,Qt=a(),$e=m("p"),$e.textContent=Cs,St=a(),Oe=m("p"),Oe.innerHTML=ks,At=a(),S=m("img"),Kt=a(),Ie=m("small"),Ie.innerHTML=Zs,eo=a(),ze=m("p"),ze.innerHTML=Ns,to=a(),g(Ue.$$.fragment),oo=a(),Ce=m("p"),Ce.innerHTML=Vs,so=a(),ke=m("p"),ke.innerHTML=Bs,no=a(),g(We.$$.fragment),ao=a(),g(Ze.$$.fragment),ro=a(),Ne=m("ul"),Ne.innerHTML=Rs,lo=a(),g(A.$$.fragment),io=a(),g(Ve.$$.fragment),co=a(),C=m("div"),g(Be.$$.fragment),Zo=a(),Tt=m("p"),Tt.innerHTML=Hs,No=a(),jt=m("p"),jt.innerHTML=Fs,Vo=a(),K=m("div"),g(Re.$$.fragment),Bo=a(),xt=m("p"),xt.innerHTML=Ps,mo=a(),g(He.$$.fragment),po=a(),k=m("div"),g(Fe.$$.fragment),Ro=a(),Jt=m("p"),Jt.innerHTML=qs,Ho=a(),$t=m("p"),$t.innerHTML=Gs,Fo=a(),g(ee.$$.fragment),go=a(),g(Pe.$$.fragment),ho=a(),W=m("div"),g(qe.$$.fragment),Po=a(),Ot=m("p"),Ot.innerHTML=Ls,qo=a(),It=m("p"),It.innerHTML=Xs,Go=a(),g(te.$$.fragment),uo=a(),g(Ge.$$.fragment),fo=a(),I=m("div"),g(Le.$$.fragment),Lo=a(),zt=m("p"),zt.textContent=Ds,Xo=a(),oe=m("div"),g(Xe.$$.fragment),Do=a(),Ut=m("p"),Ut.textContent=Es,Eo=a(),se=m("div"),g(De.$$.fragment),Yo=a(),Ct=m("p"),Ct.innerHTML=Ys,Qo=a(),ne=m("div"),g(Ee.$$.fragment),So=a(),kt=m("p"),kt.innerHTML=Qs,_o=a(),g(Ye.$$.fragment),bo=a(),z=m("div"),g(Qe.$$.fragment),Ao=a(),Wt=m("p"),Wt.innerHTML=Ss,Ko=a(),ae=m("div"),g(Se.$$.fragment),es=a(),Zt=m("p"),Zt.innerHTML=As,ts=a(),re=m("div"),g(Ae.$$.fragment),os=a(),Nt=m("p"),Nt.innerHTML=Ks,ss=a(),le=m("div"),g(Ke.$$.fragment),ns=a(),Vt=m("p"),Vt.innerHTML=en,wo=a(),g(et.$$.fragment),vo=a(),$=m("div"),g(tt.$$.fragment),as=a(),Bt=m("p"),Bt.textContent=tn,rs=a(),Rt=m("p"),Rt.innerHTML=on,ls=a(),Ht=m("p"),Ht.innerHTML=sn,is=a(),B=m("div"),g(ot.$$.fragment),cs=a(),Ft=m("p"),Ft.innerHTML=nn,ds=a(),g(ie.$$.fragment),ms=a(),g(ce.$$.fragment),ps=a(),de=m("div"),g(st.$$.fragment),gs=a(),g(me.$$.fragment),hs=a(),pe=m("div"),g(nt.$$.fragment),us=a(),g(ge.$$.fragment),yo=a(),g(at.$$.fragment),Mo=a(),E=m("div"),g(rt.$$.fragment),fs=a(),R=m("div"),g(lt.$$.fragment),_s=a(),Pt=m("p"),Pt.innerHTML=an,bs=a(),g(he.$$.fragment),ws=a(),g(ue.$$.fragment),To=a(),g(it.$$.fragment),jo=a(),Y=m("div"),g(ct.$$.fragment),vs=a(),H=m("div"),g(dt.$$.fragment),ys=a(),qt=m("p"),qt.innerHTML=rn,Ms=a(),g(fe.$$.fragment),Ts=a(),g(_e.$$.fragment),xo=a(),g(mt.$$.fragment),Jo=a(),P=m("div"),g(pt.$$.fragment),js=a(),F=m("div"),g(gt.$$.fragment),xs=a(),Gt=m("p"),Gt.innerHTML=ln,Js=a(),g(be.$$.fragment),$s=a(),g(we.$$.fragment),Os=a(),ve=m("div"),g(ht.$$.fragment),Is=a(),g(ye.$$.fragment),$o=a(),g(ut.$$.fragment),Oo=a(),Xt=m("p"),this.h()},l(e){const n=hn("svelte-u9bgzb",document.head);o=p(n,"META",{name:!0,content:!0}),n.forEach(s),v=r(e),d=p(e,"P",{}),x(d).forEach(s),l=r(e),h(w.$$.fragment,e),t=r(e),M=p(e,"DIV",{class:!0,"data-svelte-h":!0}),y(M)!=="svelte-13t8s2t"&&(M.innerHTML=zs),Et=r(e),h(xe.$$.fragment,e),Yt=r(e),Je=p(e,"P",{"data-svelte-h":!0}),y(Je)!=="svelte-1jjmdbl"&&(Je.innerHTML=Us),Qt=r(e),$e=p(e,"P",{"data-svelte-h":!0}),y($e)!=="svelte-vfdo9a"&&($e.textContent=Cs),St=r(e),Oe=p(e,"P",{"data-svelte-h":!0}),y(Oe)!=="svelte-17v2uvw"&&(Oe.innerHTML=ks),At=r(e),S=p(e,"IMG",{src:!0,alt:!0,width:!0}),Kt=r(e),Ie=p(e,"SMALL",{"data-svelte-h":!0}),y(Ie)!=="svelte-a4adom"&&(Ie.innerHTML=Zs),eo=r(e),ze=p(e,"P",{"data-svelte-h":!0}),y(ze)!=="svelte-h0sl6k"&&(ze.innerHTML=Ns),to=r(e),h(Ue.$$.fragment,e),oo=r(e),Ce=p(e,"P",{"data-svelte-h":!0}),y(Ce)!=="svelte-44ncwu"&&(Ce.innerHTML=Vs),so=r(e),ke=p(e,"P",{"data-svelte-h":!0}),y(ke)!=="svelte-2hrjcv"&&(ke.innerHTML=Bs),no=r(e),h(We.$$.fragment,e),ao=r(e),h(Ze.$$.fragment,e),ro=r(e),Ne=p(e,"UL",{"data-svelte-h":!0}),y(Ne)!=="svelte-yomnb6"&&(Ne.innerHTML=Rs),lo=r(e),h(A.$$.fragment,e),io=r(e),h(Ve.$$.fragment,e),co=r(e),C=p(e,"DIV",{class:!0});var q=x(C);h(Be.$$.fragment,q),Zo=r(q),Tt=p(q,"P",{"data-svelte-h":!0}),y(Tt)!=="svelte-1eeue6z"&&(Tt.innerHTML=Hs),No=r(q),jt=p(q,"P",{"data-svelte-h":!0}),y(jt)!=="svelte-o55m63"&&(jt.innerHTML=Fs),Vo=r(q),K=p(q,"DIV",{class:!0});var ft=x(K);h(Re.$$.fragment,ft),Bo=r(ft),xt=p(ft,"P",{"data-svelte-h":!0}),y(xt)!=="svelte-1e3bs5y"&&(xt.innerHTML=Ps),ft.forEach(s),q.forEach(s),mo=r(e),h(He.$$.fragment,e),po=r(e),k=p(e,"DIV",{class:!0});var G=x(k);h(Fe.$$.fragment,G),Ro=r(G),Jt=p(G,"P",{"data-svelte-h":!0}),y(Jt)!=="svelte-1qnmyr9"&&(Jt.innerHTML=qs),Ho=r(G),$t=p(G,"P",{"data-svelte-h":!0}),y($t)!=="svelte-o55m63"&&($t.innerHTML=Gs),Fo=r(G),h(ee.$$.fragment,G),G.forEach(s),go=r(e),h(Pe.$$.fragment,e),ho=r(e),W=p(e,"DIV",{class:!0});var L=x(W);h(qe.$$.fragment,L),Po=r(L),Ot=p(L,"P",{"data-svelte-h":!0}),y(Ot)!=="svelte-1ww21ml"&&(Ot.innerHTML=Ls),qo=r(L),It=p(L,"P",{"data-svelte-h":!0}),y(It)!=="svelte-o55m63"&&(It.innerHTML=Xs),Go=r(L),h(te.$$.fragment,L),L.forEach(s),uo=r(e),h(Ge.$$.fragment,e),fo=r(e),I=p(e,"DIV",{class:!0});var Z=x(I);h(Le.$$.fragment,Z),Lo=r(Z),zt=p(Z,"P",{"data-svelte-h":!0}),y(zt)!=="svelte-dzqrng"&&(zt.textContent=Ds),Xo=r(Z),oe=p(Z,"DIV",{class:!0});var _t=x(oe);h(Xe.$$.fragment,_t),Do=r(_t),Ut=p(_t,"P",{"data-svelte-h":!0}),y(Ut)!=="svelte-1x3yxsa"&&(Ut.textContent=Es),_t.forEach(s),Eo=r(Z),se=p(Z,"DIV",{class:!0});var bt=x(se);h(De.$$.fragment,bt),Yo=r(bt),Ct=p(bt,"P",{"data-svelte-h":!0}),y(Ct)!=="svelte-1dvjhkg"&&(Ct.innerHTML=Ys),bt.forEach(s),Qo=r(Z),ne=p(Z,"DIV",{class:!0});var wt=x(ne);h(Ee.$$.fragment,wt),So=r(wt),kt=p(wt,"P",{"data-svelte-h":!0}),y(kt)!=="svelte-dhbo7w"&&(kt.innerHTML=Qs),wt.forEach(s),Z.forEach(s),_o=r(e),h(Ye.$$.fragment,e),bo=r(e),z=p(e,"DIV",{class:!0});var N=x(z);h(Qe.$$.fragment,N),Ao=r(N),Wt=p(N,"P",{"data-svelte-h":!0}),y(Wt)!=="svelte-1onbrj8"&&(Wt.innerHTML=Ss),Ko=r(N),ae=p(N,"DIV",{class:!0});var vt=x(ae);h(Se.$$.fragment,vt),es=r(vt),Zt=p(vt,"P",{"data-svelte-h":!0}),y(Zt)!=="svelte-3fugte"&&(Zt.innerHTML=As),vt.forEach(s),ts=r(N),re=p(N,"DIV",{class:!0});var yt=x(re);h(Ae.$$.fragment,yt),os=r(yt),Nt=p(yt,"P",{"data-svelte-h":!0}),y(Nt)!=="svelte-1dvjhkg"&&(Nt.innerHTML=Ks),yt.forEach(s),ss=r(N),le=p(N,"DIV",{class:!0});var Mt=x(le);h(Ke.$$.fragment,Mt),ns=r(Mt),Vt=p(Mt,"P",{"data-svelte-h":!0}),y(Vt)!=="svelte-galzft"&&(Vt.innerHTML=en),Mt.forEach(s),N.forEach(s),wo=r(e),h(et.$$.fragment,e),vo=r(e),$=p(e,"DIV",{class:!0});var O=x($);h(tt.$$.fragment,O),as=r(O),Bt=p(O,"P",{"data-svelte-h":!0}),y(Bt)!=="svelte-vxn7lo"&&(Bt.textContent=tn),rs=r(O),Rt=p(O,"P",{"data-svelte-h":!0}),y(Rt)!=="svelte-6pahdo"&&(Rt.innerHTML=on),ls=r(O),Ht=p(O,"P",{"data-svelte-h":!0}),y(Ht)!=="svelte-hswkmf"&&(Ht.innerHTML=sn),is=r(O),B=p(O,"DIV",{class:!0});var X=x(B);h(ot.$$.fragment,X),cs=r(X),Ft=p(X,"P",{"data-svelte-h":!0}),y(Ft)!=="svelte-1snknjv"&&(Ft.innerHTML=nn),ds=r(X),h(ie.$$.fragment,X),ms=r(X),h(ce.$$.fragment,X),X.forEach(s),ps=r(O),de=p(O,"DIV",{class:!0});var zo=x(de);h(st.$$.fragment,zo),gs=r(zo),h(me.$$.fragment,zo),zo.forEach(s),hs=r(O),pe=p(O,"DIV",{class:!0});var Uo=x(pe);h(nt.$$.fragment,Uo),us=r(Uo),h(ge.$$.fragment,Uo),Uo.forEach(s),O.forEach(s),yo=r(e),h(at.$$.fragment,e),Mo=r(e),E=p(e,"DIV",{class:!0});var Co=x(E);h(rt.$$.fragment,Co),fs=r(Co),R=p(Co,"DIV",{class:!0});var Me=x(R);h(lt.$$.fragment,Me),_s=r(Me),Pt=p(Me,"P",{"data-svelte-h":!0}),y(Pt)!=="svelte-1ncxtmd"&&(Pt.innerHTML=an),bs=r(Me),h(he.$$.fragment,Me),ws=r(Me),h(ue.$$.fragment,Me),Me.forEach(s),Co.forEach(s),To=r(e),h(it.$$.fragment,e),jo=r(e),Y=p(e,"DIV",{class:!0});var ko=x(Y);h(ct.$$.fragment,ko),vs=r(ko),H=p(ko,"DIV",{class:!0});var Te=x(H);h(dt.$$.fragment,Te),ys=r(Te),qt=p(Te,"P",{"data-svelte-h":!0}),y(qt)!=="svelte-svi6u7"&&(qt.innerHTML=rn),Ms=r(Te),h(fe.$$.fragment,Te),Ts=r(Te),h(_e.$$.fragment,Te),Te.forEach(s),ko.forEach(s),xo=r(e),h(mt.$$.fragment,e),Jo=r(e),P=p(e,"DIV",{class:!0});var Lt=x(P);h(pt.$$.fragment,Lt),js=r(Lt),F=p(Lt,"DIV",{class:!0});var je=x(F);h(gt.$$.fragment,je),xs=r(je),Gt=p(je,"P",{"data-svelte-h":!0}),y(Gt)!=="svelte-453pb5"&&(Gt.innerHTML=ln),Js=r(je),h(be.$$.fragment,je),$s=r(je),h(we.$$.fragment,je),je.forEach(s),Os=r(Lt),ve=p(Lt,"DIV",{class:!0});var Wo=x(ve);h(ht.$$.fragment,Wo),Is=r(Wo),h(ye.$$.fragment,Wo),Wo.forEach(s),Lt.forEach(s),$o=r(e),h(ut.$$.fragment,e),Oo=r(e),Xt=p(e,"P",{}),x(Xt).forEach(s),this.h()},h(){j(o,"name","hf:doc:metadata"),j(o,"content",Un),j(M,"class","flex flex-wrap space-x-1"),dn(S.src,Ws="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/owlv2_overview.png")||j(S,"src",Ws),j(S,"alt","drawing"),j(S,"width","600"),j(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){i(document.head,o),c(e,v,n),c(e,d,n),c(e,l,n),u(w,e,n),c(e,t,n),c(e,M,n),c(e,Et,n),u(xe,e,n),c(e,Yt,n),c(e,Je,n),c(e,Qt,n),c(e,$e,n),c(e,St,n),c(e,Oe,n),c(e,At,n),c(e,S,n),c(e,Kt,n),c(e,Ie,n),c(e,eo,n),c(e,ze,n),c(e,to,n),u(Ue,e,n),c(e,oo,n),c(e,Ce,n),c(e,so,n),c(e,ke,n),c(e,no,n),u(We,e,n),c(e,ao,n),u(Ze,e,n),c(e,ro,n),c(e,Ne,n),c(e,lo,n),u(A,e,n),c(e,io,n),u(Ve,e,n),c(e,co,n),c(e,C,n),u(Be,C,null),i(C,Zo),i(C,Tt),i(C,No),i(C,jt),i(C,Vo),i(C,K),u(Re,K,null),i(K,Bo),i(K,xt),c(e,mo,n),u(He,e,n),c(e,po,n),c(e,k,n),u(Fe,k,null),i(k,Ro),i(k,Jt),i(k,Ho),i(k,$t),i(k,Fo),u(ee,k,null),c(e,go,n),u(Pe,e,n),c(e,ho,n),c(e,W,n),u(qe,W,null),i(W,Po),i(W,Ot),i(W,qo),i(W,It),i(W,Go),u(te,W,null),c(e,uo,n),u(Ge,e,n),c(e,fo,n),c(e,I,n),u(Le,I,null),i(I,Lo),i(I,zt),i(I,Xo),i(I,oe),u(Xe,oe,null),i(oe,Do),i(oe,Ut),i(I,Eo),i(I,se),u(De,se,null),i(se,Yo),i(se,Ct),i(I,Qo),i(I,ne),u(Ee,ne,null),i(ne,So),i(ne,kt),c(e,_o,n),u(Ye,e,n),c(e,bo,n),c(e,z,n),u(Qe,z,null),i(z,Ao),i(z,Wt),i(z,Ko),i(z,ae),u(Se,ae,null),i(ae,es),i(ae,Zt),i(z,ts),i(z,re),u(Ae,re,null),i(re,os),i(re,Nt),i(z,ss),i(z,le),u(Ke,le,null),i(le,ns),i(le,Vt),c(e,wo,n),u(et,e,n),c(e,vo,n),c(e,$,n),u(tt,$,null),i($,as),i($,Bt),i($,rs),i($,Rt),i($,ls),i($,Ht),i($,is),i($,B),u(ot,B,null),i(B,cs),i(B,Ft),i(B,ds),u(ie,B,null),i(B,ms),u(ce,B,null),i($,ps),i($,de),u(st,de,null),i(de,gs),u(me,de,null),i($,hs),i($,pe),u(nt,pe,null),i(pe,us),u(ge,pe,null),c(e,yo,n),u(at,e,n),c(e,Mo,n),c(e,E,n),u(rt,E,null),i(E,fs),i(E,R),u(lt,R,null),i(R,_s),i(R,Pt),i(R,bs),u(he,R,null),i(R,ws),u(ue,R,null),c(e,To,n),u(it,e,n),c(e,jo,n),c(e,Y,n),u(ct,Y,null),i(Y,vs),i(Y,H),u(dt,H,null),i(H,ys),i(H,qt),i(H,Ms),u(fe,H,null),i(H,Ts),u(_e,H,null),c(e,xo,n),u(mt,e,n),c(e,Jo,n),c(e,P,n),u(pt,P,null),i(P,js),i(P,F),u(gt,F,null),i(F,xs),i(F,Gt),i(F,Js),u(be,F,null),i(F,$s),u(we,F,null),i(P,Os),i(P,ve),u(ht,ve,null),i(ve,Is),u(ye,ve,null),c(e,$o,n),u(ut,e,n),c(e,Oo,n),c(e,Xt,n),Io=!0},p(e,[n]){const q={};n&2&&(q.$$scope={dirty:n,ctx:e}),A.$set(q);const ft={};n&2&&(ft.$$scope={dirty:n,ctx:e}),ee.$set(ft);const G={};n&2&&(G.$$scope={dirty:n,ctx:e}),te.$set(G);const L={};n&2&&(L.$$scope={dirty:n,ctx:e}),ie.$set(L);const Z={};n&2&&(Z.$$scope={dirty:n,ctx:e}),ce.$set(Z);const _t={};n&2&&(_t.$$scope={dirty:n,ctx:e}),me.$set(_t);const bt={};n&2&&(bt.$$scope={dirty:n,ctx:e}),ge.$set(bt);const wt={};n&2&&(wt.$$scope={dirty:n,ctx:e}),he.$set(wt);const N={};n&2&&(N.$$scope={dirty:n,ctx:e}),ue.$set(N);const vt={};n&2&&(vt.$$scope={dirty:n,ctx:e}),fe.$set(vt);const yt={};n&2&&(yt.$$scope={dirty:n,ctx:e}),_e.$set(yt);const Mt={};n&2&&(Mt.$$scope={dirty:n,ctx:e}),be.$set(Mt);const O={};n&2&&(O.$$scope={dirty:n,ctx:e}),we.$set(O);const X={};n&2&&(X.$$scope={dirty:n,ctx:e}),ye.$set(X)},i(e){Io||(f(w.$$.fragment,e),f(xe.$$.fragment,e),f(Ue.$$.fragment,e),f(We.$$.fragment,e),f(Ze.$$.fragment,e),f(A.$$.fragment,e),f(Ve.$$.fragment,e),f(Be.$$.fragment,e),f(Re.$$.fragment,e),f(He.$$.fragment,e),f(Fe.$$.fragment,e),f(ee.$$.fragment,e),f(Pe.$$.fragment,e),f(qe.$$.fragment,e),f(te.$$.fragment,e),f(Ge.$$.fragment,e),f(Le.$$.fragment,e),f(Xe.$$.fragment,e),f(De.$$.fragment,e),f(Ee.$$.fragment,e),f(Ye.$$.fragment,e),f(Qe.$$.fragment,e),f(Se.$$.fragment,e),f(Ae.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(ot.$$.fragment,e),f(ie.$$.fragment,e),f(ce.$$.fragment,e),f(st.$$.fragment,e),f(me.$$.fragment,e),f(nt.$$.fragment,e),f(ge.$$.fragment,e),f(at.$$.fragment,e),f(rt.$$.fragment,e),f(lt.$$.fragment,e),f(he.$$.fragment,e),f(ue.$$.fragment,e),f(it.$$.fragment,e),f(ct.$$.fragment,e),f(dt.$$.fragment,e),f(fe.$$.fragment,e),f(_e.$$.fragment,e),f(mt.$$.fragment,e),f(pt.$$.fragment,e),f(gt.$$.fragment,e),f(be.$$.fragment,e),f(we.$$.fragment,e),f(ht.$$.fragment,e),f(ye.$$.fragment,e),f(ut.$$.fragment,e),Io=!0)},o(e){_(w.$$.fragment,e),_(xe.$$.fragment,e),_(Ue.$$.fragment,e),_(We.$$.fragment,e),_(Ze.$$.fragment,e),_(A.$$.fragment,e),_(Ve.$$.fragment,e),_(Be.$$.fragment,e),_(Re.$$.fragment,e),_(He.$$.fragment,e),_(Fe.$$.fragment,e),_(ee.$$.fragment,e),_(Pe.$$.fragment,e),_(qe.$$.fragment,e),_(te.$$.fragment,e),_(Ge.$$.fragment,e),_(Le.$$.fragment,e),_(Xe.$$.fragment,e),_(De.$$.fragment,e),_(Ee.$$.fragment,e),_(Ye.$$.fragment,e),_(Qe.$$.fragment,e),_(Se.$$.fragment,e),_(Ae.$$.fragment,e),_(Ke.$$.fragment,e),_(et.$$.fragment,e),_(tt.$$.fragment,e),_(ot.$$.fragment,e),_(ie.$$.fragment,e),_(ce.$$.fragment,e),_(st.$$.fragment,e),_(me.$$.fragment,e),_(nt.$$.fragment,e),_(ge.$$.fragment,e),_(at.$$.fragment,e),_(rt.$$.fragment,e),_(lt.$$.fragment,e),_(he.$$.fragment,e),_(ue.$$.fragment,e),_(it.$$.fragment,e),_(ct.$$.fragment,e),_(dt.$$.fragment,e),_(fe.$$.fragment,e),_(_e.$$.fragment,e),_(mt.$$.fragment,e),_(pt.$$.fragment,e),_(gt.$$.fragment,e),_(be.$$.fragment,e),_(we.$$.fragment,e),_(ht.$$.fragment,e),_(ye.$$.fragment,e),_(ut.$$.fragment,e),Io=!1},d(e){e&&(s(v),s(d),s(l),s(t),s(M),s(Et),s(Yt),s(Je),s(Qt),s($e),s(St),s(Oe),s(At),s(S),s(Kt),s(Ie),s(eo),s(ze),s(to),s(oo),s(Ce),s(so),s(ke),s(no),s(ao),s(ro),s(Ne),s(lo),s(io),s(co),s(C),s(mo),s(po),s(k),s(go),s(ho),s(W),s(uo),s(fo),s(I),s(_o),s(bo),s(z),s(wo),s(vo),s($),s(yo),s(Mo),s(E),s(To),s(jo),s(Y),s(xo),s(Jo),s(P),s($o),s(Oo),s(Xt)),s(o),b(w,e),b(xe,e),b(Ue,e),b(We,e),b(Ze,e),b(A,e),b(Ve,e),b(Be),b(Re),b(He,e),b(Fe),b(ee),b(Pe,e),b(qe),b(te),b(Ge,e),b(Le),b(Xe),b(De),b(Ee),b(Ye,e),b(Qe),b(Se),b(Ae),b(Ke),b(et,e),b(tt),b(ot),b(ie),b(ce),b(st),b(me),b(nt),b(ge),b(at,e),b(rt),b(lt),b(he),b(ue),b(it,e),b(ct),b(dt),b(fe),b(_e),b(mt,e),b(pt),b(gt),b(be),b(we),b(ht),b(ye),b(ut,e)}}}const Un='{"title":"OWLv2","local":"owlv2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"Owlv2Config","local":"transformers.Owlv2Config","sections":[],"depth":2},{"title":"Owlv2TextConfig","local":"transformers.Owlv2TextConfig","sections":[],"depth":2},{"title":"Owlv2VisionConfig","local":"transformers.Owlv2VisionConfig","sections":[],"depth":2},{"title":"Owlv2ImageProcessor","local":"transformers.Owlv2ImageProcessor","sections":[],"depth":2},{"title":"Owlv2Processor","local":"transformers.Owlv2Processor","sections":[],"depth":2},{"title":"Owlv2Model","local":"transformers.Owlv2Model","sections":[],"depth":2},{"title":"Owlv2TextModel","local":"transformers.Owlv2TextModel","sections":[],"depth":2},{"title":"Owlv2VisionModel","local":"transformers.Owlv2VisionModel","sections":[],"depth":2},{"title":"Owlv2ForObjectDetection","local":"transformers.Owlv2ForObjectDetection","sections":[],"depth":2}],"depth":1}';function Cn(T){return mn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fn extends pn{constructor(o){super(),gn(this,o,Cn,zn,cn,{})}}export{Fn as component};
