import{s as Zn,o as Gn,n as te}from"../chunks/scheduler.18a86fab.js";import{S as Nn,i as Rn,g as m,s as o,r as h,A as In,h as p,f as s,c as r,j as W,u,x as b,k as U,y as l,a as i,v as f,d as g,t as T,w as _}from"../chunks/index.98837b22.js";import{T as Wn}from"../chunks/Tip.77304350.js";import{D as I}from"../chunks/Docstring.6758ea23.js";import{C as Ke}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Oe}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as V}from"../chunks/Heading.7e7e0c5b.js";import{E as Hn}from"../chunks/index.499f366c.js";function Vn(w){let a,y;return a=new Ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGFuJTIwUGF0Y2hUU1QlMjBjb25maWd1cmF0aW9uJTIwd2l0aCUyMDEyJTIwdGltZSUyMHN0ZXBzJTIwZm9yJTIwcHJlZGljdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBQYXRjaFRTVENvbmZpZyhwcmVkaWN0aW9uX2xlbmd0aCUzRDEyKSUwQSUwQSUyMyUyMFJhbmRvbWx5JTIwaW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBQYXRjaFRTVE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing an PatchTST configuration with 12 time steps for prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = PatchTSTConfig(prediction_length=<span class="hljs-number">12</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Randomly initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){h(a.$$.fragment)},l(c){u(a.$$.fragment,c)},m(c,d){f(a,c,d),y=!0},p:te,i(c){y||(g(a.$$.fragment,c),y=!0)},o(c){T(a.$$.fragment,c),y=!1},d(c){_(a,c)}}}function zn(w){let a,y="Examples:",c,d,M;return d=new Ke({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUTW9kZWwlMEElMEFmaWxlJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZXR0aDEtaG91cmx5LWJhdGNoJTIyJTJDJTIwZmlsZW5hbWUlM0QlMjJ0cmFpbi1iYXRjaC5wdCUyMiUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMEEpJTBBYmF0Y2glMjAlM0QlMjB0b3JjaC5sb2FkKGZpbGUpJTBBJTBBbW9kZWwlMjAlM0QlMjBQYXRjaFRTVE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJuYW1jdGluJTJGcGF0Y2h0c3RfZXR0aDFfcHJldHJhaW4lMjIpJTBBJTBBJTIzJTIwZHVyaW5nJTIwdHJhaW5pbmclMkMlMjBvbmUlMjBwcm92aWRlcyUyMGJvdGglMjBwYXN0JTIwYW5kJTIwZnV0dXJlJTIwdmFsdWVzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCUwQSUyMCUyMCUyMCUyMHBhc3RfdmFsdWVzJTNEYmF0Y2glNUIlMjJwYXN0X3ZhbHVlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGZ1dHVyZV92YWx1ZXMlM0RiYXRjaCU1QiUyMmZ1dHVyZV92YWx1ZXMlMjIlNUQlMkMlMEEpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGUlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTModel

<span class="hljs-meta">&gt;&gt;&gt; </span>file = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;hf-internal-testing/etth1-hourly-batch&quot;</span>, filename=<span class="hljs-string">&quot;train-batch.pt&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>batch = torch.load(file)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTModel.from_pretrained(<span class="hljs-string">&quot;namctin/patchtst_etth1_pretrain&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during training, one provides both past and future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(
<span class="hljs-meta">... </span>    past_values=batch[<span class="hljs-string">&quot;past_values&quot;</span>],
<span class="hljs-meta">... </span>    future_values=batch[<span class="hljs-string">&quot;future_values&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state`,wrap:!1}}),{c(){a=m("p"),a.textContent=y,c=o(),h(d.$$.fragment)},l(t){a=p(t,"P",{"data-svelte-h":!0}),b(a)!=="svelte-kvfsh7"&&(a.textContent=y),c=r(t),u(d.$$.fragment,t)},m(t,v){i(t,a,v),i(t,c,v),f(d,t,v),M=!0},p:te,i(t){M||(g(d.$$.fragment,t),M=!0)},o(t){T(d.$$.fragment,t),M=!1},d(t){t&&(s(a),s(c)),_(d,t)}}}function Yn(w){let a,y="Examples:",c,d,M;return d=new Ke({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RGb3JQcmVkaWN0aW9uJTBBJTBBZmlsZSUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZCglMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmV0dGgxLWhvdXJseS1iYXRjaCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIydHJhaW4tYmF0Y2gucHQlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyJTBBKSUwQWJhdGNoJTIwJTNEJTIwdG9yY2gubG9hZChmaWxlKSUwQSUwQSUyMyUyMFByZWRpY3Rpb24lMjB0YXNrJTIwd2l0aCUyMDclMjBpbnB1dCUyMGNoYW5uZWxzJTIwYW5kJTIwcHJlZGljdGlvbiUyMGxlbmd0aCUyMGlzJTIwOTYlMEFtb2RlbCUyMCUzRCUyMFBhdGNoVFNURm9yUHJlZGljdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybmFtY3RpbiUyRnBhdGNodHN0X2V0dGgxX2ZvcmVjYXN0JTIyKSUwQSUwQSUyMyUyMGR1cmluZyUyMHRyYWluaW5nJTJDJTIwb25lJTIwcHJvdmlkZXMlMjBib3RoJTIwcGFzdCUyMGFuZCUyMGZ1dHVyZSUyMHZhbHVlcyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCglMEElMjAlMjAlMjAlMjBwYXN0X3ZhbHVlcyUzRGJhdGNoJTVCJTIycGFzdF92YWx1ZXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBmdXR1cmVfdmFsdWVzJTNEYmF0Y2glNUIlMjJmdXR1cmVfdmFsdWVzJTIyJTVEJTJDJTBBKSUwQSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb3NzLmJhY2t3YXJkKCklMEElMEElMjMlMjBkdXJpbmclMjBpbmZlcmVuY2UlMkMlMjBvbmUlMjBvbmx5JTIwcHJvdmlkZXMlMjBwYXN0JTIwdmFsdWVzJTJDJTIwdGhlJTIwbW9kZWwlMjBvdXRwdXRzJTIwZnV0dXJlJTIwdmFsdWVzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBhc3RfdmFsdWVzJTNEYmF0Y2glNUIlMjJwYXN0X3ZhbHVlcyUyMiU1RCklMEFwcmVkaWN0aW9uX291dHB1dHMlMjAlM0QlMjBvdXRwdXRzLnByZWRpY3Rpb25fb3V0cHV0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTForPrediction

<span class="hljs-meta">&gt;&gt;&gt; </span>file = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;hf-internal-testing/etth1-hourly-batch&quot;</span>, filename=<span class="hljs-string">&quot;train-batch.pt&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>batch = torch.load(file)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prediction task with 7 input channels and prediction length is 96</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTForPrediction.from_pretrained(<span class="hljs-string">&quot;namctin/patchtst_etth1_forecast&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during training, one provides both past and future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(
<span class="hljs-meta">... </span>    past_values=batch[<span class="hljs-string">&quot;past_values&quot;</span>],
<span class="hljs-meta">... </span>    future_values=batch[<span class="hljs-string">&quot;future_values&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>loss.backward()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during inference, one only provides past values, the model outputs future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(past_values=batch[<span class="hljs-string">&quot;past_values&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>prediction_outputs = outputs.prediction_outputs`,wrap:!1}}),{c(){a=m("p"),a.textContent=y,c=o(),h(d.$$.fragment)},l(t){a=p(t,"P",{"data-svelte-h":!0}),b(a)!=="svelte-kvfsh7"&&(a.textContent=y),c=r(t),u(d.$$.fragment,t)},m(t,v){i(t,a,v),i(t,c,v),f(d,t,v),M=!0},p:te,i(t){M||(g(d.$$.fragment,t),M=!0)},o(t){T(d.$$.fragment,t),M=!1},d(t){t&&(s(a),s(c)),_(d,t)}}}function Xn(w){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=m("p"),a.innerHTML=y},l(c){a=p(c,"P",{"data-svelte-h":!0}),b(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(c,d){i(c,a,d)},p:te,d(c){c&&s(a)}}}function En(w){let a,y="Examples:",c,d,M;return d=new Ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RGb3JDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMGNsYXNzaWZpY2F0aW9uJTIwdGFzayUyMHdpdGglMjB0d28lMjBpbnB1dCUyMGNoYW5uZWwyJTIwYW5kJTIwMyUyMGNsYXNzZXMlMEFjb25maWclMjAlM0QlMjBQYXRjaFRTVENvbmZpZyglMEElMjAlMjAlMjAlMjBudW1faW5wdXRfY2hhbm5lbHMlM0QyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RhcmdldHMlM0QzJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dF9sZW5ndGglM0Q1MTIlMkMlMEElMjAlMjAlMjAlMjBwYXRjaF9sZW5ndGglM0QxMiUyQyUwQSUyMCUyMCUyMCUyMHN0cmlkZSUzRDEyJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2Nsc190b2tlbiUzRFRydWUlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBQYXRjaFRTVEZvckNsYXNzaWZpY2F0aW9uKGNvbmZpZyUzRGNvbmZpZyklMEElMEElMjMlMjBkdXJpbmclMjBpbmZlcmVuY2UlMkMlMjBvbmUlMjBvbmx5JTIwcHJvdmlkZXMlMjBwYXN0JTIwdmFsdWVzJTBBcGFzdF92YWx1ZXMlMjAlM0QlMjB0b3JjaC5yYW5kbigyMCUyQyUyMDUxMiUyQyUyMDIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBhc3RfdmFsdWVzJTNEcGFzdF92YWx1ZXMpJTBBbGFiZWxzJTIwJTNEJTIwb3V0cHV0cy5wcmVkaWN0aW9uX2xvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTForClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># classification task with two input channel2 and 3 classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PatchTSTConfig(
<span class="hljs-meta">... </span>    num_input_channels=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    num_targets=<span class="hljs-number">3</span>,
<span class="hljs-meta">... </span>    context_length=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    patch_length=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    stride=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    use_cls_token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTForClassification(config=config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during inference, one only provides past values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_values = torch.randn(<span class="hljs-number">20</span>, <span class="hljs-number">512</span>, <span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(past_values=past_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = outputs.prediction_logits`,wrap:!1}}),{c(){a=m("p"),a.textContent=y,c=o(),h(d.$$.fragment)},l(t){a=p(t,"P",{"data-svelte-h":!0}),b(a)!=="svelte-kvfsh7"&&(a.textContent=y),c=r(t),u(d.$$.fragment,t)},m(t,v){i(t,a,v),i(t,c,v),f(d,t,v),M=!0},p:te,i(t){M||(g(d.$$.fragment,t),M=!0)},o(t){T(d.$$.fragment,t),M=!1},d(t){t&&(s(a),s(c)),_(d,t)}}}function qn(w){let a,y="Examples:",c,d,M;return d=new Ke({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RGb3JQcmV0cmFpbmluZyUwQSUwQWZpbGUlMjAlM0QlMjBoZl9odWJfZG93bmxvYWQoJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZldHRoMS1ob3VybHktYmF0Y2glMjIlMkMlMjBmaWxlbmFtZSUzRCUyMnRyYWluLWJhdGNoLnB0JTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUwQSklMEFiYXRjaCUyMCUzRCUyMHRvcmNoLmxvYWQoZmlsZSklMEElMEElMjMlMjBDb25maWclMjBmb3IlMjByYW5kb20lMjBtYXNrJTIwcHJldHJhaW5pbmclMEFjb25maWclMjAlM0QlMjBQYXRjaFRTVENvbmZpZyglMEElMjAlMjAlMjAlMjBudW1faW5wdXRfY2hhbm5lbHMlM0Q3JTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dF9sZW5ndGglM0Q1MTIlMkMlMEElMjAlMjAlMjAlMjBwYXRjaF9sZW5ndGglM0QxMiUyQyUwQSUyMCUyMCUyMCUyMHN0cmlkZSUzRDEyJTJDJTBBJTIwJTIwJTIwJTIwbWFza190eXBlJTNEJ3JhbmRvbSclMkMlMEElMjAlMjAlMjAlMjByYW5kb21fbWFza19yYXRpbyUzRDAuNCUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jbHNfdG9rZW4lM0RUcnVlJTJDJTBBKSUwQSUyMyUyMENvbmZpZyUyMGZvciUyMGZvcmVjYXN0JTIwbWFzayUyMHByZXRyYWluaW5nJTBBY29uZmlnJTIwJTNEJTIwUGF0Y2hUU1RDb25maWcoJTBBJTIwJTIwJTIwJTIwbnVtX2lucHV0X2NoYW5uZWxzJTNENyUyQyUwQSUyMCUyMCUyMCUyMGNvbnRleHRfbGVuZ3RoJTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwcGF0Y2hfbGVuZ3RoJTNEMTIlMkMlMEElMjAlMjAlMjAlMjBzdHJpZGUlM0QxMiUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfdHlwZSUzRCdmb3JlY2FzdCclMkMlMEElMjAlMjAlMjAlMjBudW1fZm9yZWNhc3RfbWFza19wYXRjaGVzJTNENSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jbHNfdG9rZW4lM0RUcnVlJTJDJTBBKSUwQW1vZGVsJTIwJTNEJTIwUGF0Y2hUU1RGb3JQcmV0cmFpbmluZyhjb25maWcpJTBBJTBBJTIzJTIwZHVyaW5nJTIwdHJhaW5pbmclMkMlMjBvbmUlMjBwcm92aWRlcyUyMGJvdGglMjBwYXN0JTIwYW5kJTIwZnV0dXJlJTIwdmFsdWVzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBhc3RfdmFsdWVzJTNEYmF0Y2glNUIlMjJwYXN0X3ZhbHVlcyUyMiU1RCklMEElMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBbG9zcy5iYWNrd2FyZCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTForPretraining

<span class="hljs-meta">&gt;&gt;&gt; </span>file = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;hf-internal-testing/etth1-hourly-batch&quot;</span>, filename=<span class="hljs-string">&quot;train-batch.pt&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>batch = torch.load(file)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Config for random mask pretraining</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PatchTSTConfig(
<span class="hljs-meta">... </span>    num_input_channels=<span class="hljs-number">7</span>,
<span class="hljs-meta">... </span>    context_length=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    patch_length=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    stride=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    mask_type=<span class="hljs-string">&#x27;random&#x27;</span>,
<span class="hljs-meta">... </span>    random_mask_ratio=<span class="hljs-number">0.4</span>,
<span class="hljs-meta">... </span>    use_cls_token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Config for forecast mask pretraining</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PatchTSTConfig(
<span class="hljs-meta">... </span>    num_input_channels=<span class="hljs-number">7</span>,
<span class="hljs-meta">... </span>    context_length=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    patch_length=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    stride=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    mask_type=<span class="hljs-string">&#x27;forecast&#x27;</span>,
<span class="hljs-meta">... </span>    num_forecast_mask_patches=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    use_cls_token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTForPretraining(config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during training, one provides both past and future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(past_values=batch[<span class="hljs-string">&quot;past_values&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>loss.backward()`,wrap:!1}}),{c(){a=m("p"),a.textContent=y,c=o(),h(d.$$.fragment)},l(t){a=p(t,"P",{"data-svelte-h":!0}),b(a)!=="svelte-kvfsh7"&&(a.textContent=y),c=r(t),u(d.$$.fragment,t)},m(t,v){i(t,a,v),i(t,c,v),f(d,t,v),M=!0},p:te,i(t){M||(g(d.$$.fragment,t),M=!0)},o(t){T(d.$$.fragment,t),M=!1},d(t){t&&(s(a),s(c)),_(d,t)}}}function Qn(w){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=m("p"),a.innerHTML=y},l(c){a=p(c,"P",{"data-svelte-h":!0}),b(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(c,d){i(c,a,d)},p:te,d(c){c&&s(a)}}}function Dn(w){let a,y="Examples:",c,d,M;return d=new Ke({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RGb3JSZWdyZXNzaW9uJTBBJTBBJTIzJTIwUmVncmVzc2lvbiUyMHRhc2slMjB3aXRoJTIwNiUyMGlucHV0JTIwY2hhbm5lbHMlMjBhbmQlMjByZWdyZXNzJTIwMiUyMHRhcmdldHMlMEFtb2RlbCUyMCUzRCUyMFBhdGNoVFNURm9yUmVncmVzc2lvbi5mcm9tX3ByZXRyYWluZWQoJTIybmFtY3RpbiUyRnBhdGNodHN0X2V0dGgxX3JlZ3Jlc3Npb24lMjIpJTBBJTBBJTIzJTIwZHVyaW5nJTIwaW5mZXJlbmNlJTJDJTIwb25lJTIwb25seSUyMHByb3ZpZGVzJTIwcGFzdCUyMHZhbHVlcyUyQyUyMHRoZSUyMG1vZGVsJTIwb3V0cHV0cyUyMGZ1dHVyZSUyMHZhbHVlcyUwQXBhc3RfdmFsdWVzJTIwJTNEJTIwdG9yY2gucmFuZG4oMjAlMkMlMjA1MTIlMkMlMjA2KSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChwYXN0X3ZhbHVlcyUzRHBhc3RfdmFsdWVzKSUwQXJlZ3Jlc3Npb25fb3V0cHV0cyUyMCUzRCUyMG91dHB1dHMucmVncmVzc2lvbl9vdXRwdXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTForRegression

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Regression task with 6 input channels and regress 2 targets</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTForRegression.from_pretrained(<span class="hljs-string">&quot;namctin/patchtst_etth1_regression&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during inference, one only provides past values, the model outputs future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_values = torch.randn(<span class="hljs-number">20</span>, <span class="hljs-number">512</span>, <span class="hljs-number">6</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(past_values=past_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>regression_outputs = outputs.regression_outputs`,wrap:!1}}),{c(){a=m("p"),a.textContent=y,c=o(),h(d.$$.fragment)},l(t){a=p(t,"P",{"data-svelte-h":!0}),b(a)!=="svelte-kvfsh7"&&(a.textContent=y),c=r(t),u(d.$$.fragment,t)},m(t,v){i(t,a,v),i(t,c,v),f(d,t,v),M=!0},p:te,i(t){M||(g(d.$$.fragment,t),M=!0)},o(t){T(d.$$.fragment,t),M=!1},d(t){t&&(s(a),s(c)),_(d,t)}}}function Ln(w){let a,y,c,d,M,t,v,rn='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',tt,ne,nt,ae,ln='The PatchTST model was proposed in <a href="https://arxiv.org/abs/2211.14730" rel="nofollow">A Time Series is Worth 64 Words: Long-term Forecasting with Transformers</a> by Yuqi Nie, Nam H. Nguyen, Phanwadee Sinthong and Jayant Kalagnanam.',at,se,cn="At a high level the model vectorizes time series into patches of a given size and encodes the resulting sequence of vectors via a Transformer that then outputs the prediction length forecast via an appropriate head. The model is illustrated in the following figure:",st,oe,dn='<img src="https://github.com/namctin/transformers/assets/8100/150af169-29de-419a-8d98-eb78251c21fa" alt="model"/>',ot,re,mn="The abstract from the paper is the following:",rt,le,pn="<em>We propose an efficient design of Transformer-based models for multivariate time series forecasting and self-supervised representation learning. It is based on two key components: (i) segmentation of time series into subseries-level patches which are served as input tokens to Transformer; (ii) channel-independence where each channel contains a single univariate time series that shares the same embedding and Transformer weights across all the series. Patching design naturally has three-fold benefit: local semantic information is retained in the embedding; computation and memory usage of the attention maps are quadratically reduced given the same look-back window; and the model can attend longer history. Our channel-independent patch time series Transformer (PatchTST) can improve the long-term forecasting accuracy significantly when compared with that of SOTA Transformer-based models. We also apply our model to self-supervised pre-training tasks and attain excellent fine-tuning performance, which outperforms supervised training on large datasets. Transferring of masked pre-trained representation on one dataset to others also produces SOTA forecasting accuracy.</em>",lt,ie,hn='This model was contributed by <a href="https://huggingface.co/namctin" rel="nofollow">namctin</a>, <a href="https://huggingface.co/gsinthong" rel="nofollow">gsinthong</a>, <a href="https://huggingface.co/diepi" rel="nofollow">diepi</a>, <a href="https://huggingface.co/vijaye12" rel="nofollow">vijaye12</a>, <a href="https://huggingface.co/wmgifford" rel="nofollow">wmgifford</a>, and <a href="https://huggingface.co/kashif" rel="nofollow">kashif</a>. The original code can be found <a href="https://github.com/yuqinie98/PatchTST" rel="nofollow">here</a>.',it,ce,ct,de,un='The model can also be used for time series classification and time series regression. See the respective <a href="/docs/transformers/main/en/model_doc/patchtst#transformers.PatchTSTForClassification">PatchTSTForClassification</a> and <a href="/docs/transformers/main/en/model_doc/patchtst#transformers.PatchTSTForRegression">PatchTSTForRegression</a> classes.',dt,me,mt,pe,fn='<li>A blog post explaining PatchTST in depth can be found <a href="https://huggingface.co/blog/patchtst" rel="nofollow">here</a>. The blog can also be opened in Google Colab.</li>',pt,he,ht,S,ue,Ct,Fe,gn=`This is the configuration class to store the configuration of an <a href="/docs/transformers/main/en/model_doc/patchtst#transformers.PatchTSTModel">PatchTSTModel</a>. It is used to instantiate an
PatchTST model according to the specified arguments, defining the model architecture.
<a href="https://huggingface.co/ibm/patchtst" rel="nofollow">ibm/patchtst</a> architecture.`,Ut,Be,Tn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,St,z,ut,fe,ft,$,ge,xt,We,_n="The bare Patchtst Model outputting raw hidden-states without any specific head on top.",kt,Ze,bn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ft,Ge,Mn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Bt,Y,Te,Wt,X,gt,_e,Tt,j,be,Zt,Ne,yn="The PatchTST for prediction model.",Gt,Re,vn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Nt,Ie,wn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Rt,E,Me,It,q,_t,ye,bt,P,ve,Ht,He,$n="The PatchTST for classification model.",Vt,Ve,jn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,zt,ze,Pn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Yt,Z,we,Xt,Ye,Jn='The <a href="/docs/transformers/main/en/model_doc/patchtst#transformers.PatchTSTForClassification">PatchTSTForClassification</a> forward method, overrides the <code>__call__</code> special method.',Et,Q,qt,D,Mt,$e,yt,J,je,Qt,Xe,Cn="The PatchTST for pretrain model.",Dt,Ee,Un=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Lt,qe,Sn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,At,L,Pe,Ot,A,vt,Je,wt,C,Ce,Kt,Qe,xn="The PatchTST for regression model.",en,De,kn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,tn,Le,Fn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,nn,G,Ue,an,Ae,Bn='The <a href="/docs/transformers/main/en/model_doc/patchtst#transformers.PatchTSTForRegression">PatchTSTForRegression</a> forward method, overrides the <code>__call__</code> special method.',sn,O,on,K,$t,Se,jt,et,Pt;return M=new V({props:{title:"PatchTST",local:"patchtst",headingTag:"h1"}}),ne=new V({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ce=new V({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),me=new V({props:{title:"Resources",local:"resources",headingTag:"h2"}}),he=new V({props:{title:"PatchTSTConfig",local:"transformers.PatchTSTConfig",headingTag:"h2"}}),ue=new I({props:{name:"class transformers.PatchTSTConfig",anchor:"transformers.PatchTSTConfig",parameters:[{name:"num_input_channels",val:": int = 1"},{name:"context_length",val:": int = 32"},{name:"distribution_output",val:": str = 'student_t'"},{name:"loss",val:": str = 'mse'"},{name:"patch_length",val:": int = 1"},{name:"patch_stride",val:": int = 1"},{name:"num_hidden_layers",val:": int = 3"},{name:"d_model",val:": int = 128"},{name:"num_attention_heads",val:": int = 4"},{name:"share_embedding",val:": bool = True"},{name:"channel_attention",val:": bool = False"},{name:"ffn_dim",val:": int = 512"},{name:"norm_type",val:": str = 'batchnorm'"},{name:"norm_eps",val:": float = 1e-05"},{name:"attention_dropout",val:": float = 0.0"},{name:"positional_dropout",val:": float = 0.0"},{name:"path_dropout",val:": float = 0.0"},{name:"ff_dropout",val:": float = 0.0"},{name:"bias",val:": bool = True"},{name:"activation_function",val:": str = 'gelu'"},{name:"pre_norm",val:": bool = True"},{name:"positional_encoding_type",val:": str = 'sincos'"},{name:"use_cls_token",val:": bool = False"},{name:"init_std",val:": float = 0.02"},{name:"share_projection",val:": bool = True"},{name:"scaling",val:": typing.Union[str, bool, NoneType] = 'std'"},{name:"do_mask_input",val:": typing.Optional[bool] = None"},{name:"mask_type",val:": str = 'random'"},{name:"random_mask_ratio",val:": float = 0.5"},{name:"num_forecast_mask_patches",val:": typing.Union[int, typing.List[int], NoneType] = [2]"},{name:"channel_consistent_masking",val:": typing.Optional[bool] = False"},{name:"unmasked_channel_indices",val:": typing.Optional[typing.List[int]] = None"},{name:"mask_value",val:": int = 0"},{name:"pooling_type",val:": str = 'mean'"},{name:"head_dropout",val:": float = 0.0"},{name:"prediction_length",val:": int = 24"},{name:"num_targets",val:": int = 1"},{name:"output_range",val:": typing.Optional[typing.List] = None"},{name:"num_parallel_samples",val:": int = 100"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PatchTSTConfig.num_input_channels",description:`<strong>num_input_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The size of the target variable which by default is 1 for univariate targets. Would be &gt; 1 in case of
multivariate targets.`,name:"num_input_channels"},{anchor:"transformers.PatchTSTConfig.context_length",description:`<strong>context_length</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The context length of the input sequence.`,name:"context_length"},{anchor:"transformers.PatchTSTConfig.distribution_output",description:`<strong>distribution_output</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;student_t&quot;</code>) &#x2014;
The distribution emission head for the model when loss is &#x201C;nll&#x201D;. Could be either &#x201C;student_t&#x201D;, &#x201C;normal&#x201D; or
&#x201C;negative_binomial&#x201D;.`,name:"distribution_output"},{anchor:"transformers.PatchTSTConfig.loss",description:`<strong>loss</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;mse&quot;</code>) &#x2014;
The loss function for the model corresponding to the <code>distribution_output</code> head. For parametric
distributions it is the negative log likelihood (&#x201C;nll&#x201D;) and for point estimates it is the mean squared
error &#x201C;mse&#x201D;.`,name:"loss"},{anchor:"transformers.PatchTSTConfig.patch_length",description:`<strong>patch_length</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Define the patch length of the patchification process.`,name:"patch_length"},{anchor:"transformers.PatchTSTConfig.patch_stride",description:`<strong>patch_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Define the stride of the patchification process.`,name:"patch_stride"},{anchor:"transformers.PatchTSTConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of hidden layers.`,name:"num_hidden_layers"},{anchor:"transformers.PatchTSTConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Dimensionality of the transformer layers.`,name:"d_model"},{anchor:"transformers.PatchTSTConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.PatchTSTConfig.share_embedding",description:`<strong>share_embedding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Sharing the input embedding across all channels.`,name:"share_embedding"},{anchor:"transformers.PatchTSTConfig.channel_attention",description:`<strong>channel_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activate channel attention block in the Transformer to allow channels to attend each other.`,name:"channel_attention"},{anchor:"transformers.PatchTSTConfig.ffn_dim",description:`<strong>ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer encoder.`,name:"ffn_dim"},{anchor:"transformers.PatchTSTConfig.norm_type",description:`<strong>norm_type</strong> (<code>str</code> , <em>optional</em>, defaults to <code>&quot;batchnorm&quot;</code>) &#x2014;
Normalization at each Transformer layer. Can be <code>&quot;batchnorm&quot;</code> or <code>&quot;layernorm&quot;</code>.`,name:"norm_type"},{anchor:"transformers.PatchTSTConfig.norm_eps",description:`<strong>norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
A value added to the denominator for numerical stability of normalization.`,name:"norm_eps"},{anchor:"transformers.PatchTSTConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.PatchTSTConfig.positional_dropout",description:`<strong>positional_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability in the positional embedding layer.`,name:"positional_dropout"},{anchor:"transformers.PatchTSTConfig.path_dropout",description:`<strong>path_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout path in the residual block.`,name:"path_dropout"},{anchor:"transformers.PatchTSTConfig.ff_dropout",description:`<strong>ff_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability used between the two layers of the feed-forward networks.`,name:"ff_dropout"},{anchor:"transformers.PatchTSTConfig.bias",description:`<strong>bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add bias in the feed-forward networks.`,name:"bias"},{anchor:"transformers.PatchTSTConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (string) in the Transformer.<code>&quot;gelu&quot;</code> and <code>&quot;relu&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.PatchTSTConfig.pre_norm",description:`<strong>pre_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Normalization is applied before self-attention if pre_norm is set to <code>True</code>. Otherwise, normalization is
applied after residual block.`,name:"pre_norm"},{anchor:"transformers.PatchTSTConfig.positional_encoding_type",description:`<strong>positional_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sincos&quot;</code>) &#x2014;
Positional encodings. Options <code>&quot;random&quot;</code> and <code>&quot;sincos&quot;</code> are supported.`,name:"positional_encoding_type"},{anchor:"transformers.PatchTSTConfig.use_cls_token",description:`<strong>use_cls_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether cls token is used.`,name:"use_cls_token"},{anchor:"transformers.PatchTSTConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated normal weight initialization distribution.`,name:"init_std"},{anchor:"transformers.PatchTSTConfig.share_projection",description:`<strong>share_projection</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Sharing the projection layer across different channels in the forecast head.`,name:"share_projection"},{anchor:"transformers.PatchTSTConfig.scaling",description:`<strong>scaling</strong> (<code>Union</code>, <em>optional</em>, defaults to <code>&quot;std&quot;</code>) &#x2014;
Whether to scale the input targets via &#x201C;mean&#x201D; scaler, &#x201C;std&#x201D; scaler or no scaler if <code>None</code>. If <code>True</code>, the
scaler is set to &#x201C;mean&#x201D;.`,name:"scaling"},{anchor:"transformers.PatchTSTConfig.do_mask_input",description:`<strong>do_mask_input</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Apply masking during the pretraining.`,name:"do_mask_input"},{anchor:"transformers.PatchTSTConfig.mask_type",description:`<strong>mask_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;random&quot;</code>) &#x2014;
Masking type. Only <code>&quot;random&quot;</code> and <code>&quot;forecast&quot;</code> are currently supported.`,name:"mask_type"},{anchor:"transformers.PatchTSTConfig.random_mask_ratio",description:`<strong>random_mask_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Masking ratio applied to mask the input data during random pretraining.`,name:"random_mask_ratio"},{anchor:"transformers.PatchTSTConfig.num_forecast_mask_patches",description:`<strong>num_forecast_mask_patches</strong> (<code>int</code> or <code>list</code>, <em>optional</em>, defaults to <code>[2]</code>) &#x2014;
Number of patches to be masked at the end of each batch sample. If it is an integer,
all the samples in the batch will have the same number of masked patches. If it is a list,
samples in the batch will be randomly masked by numbers defined in the list. This argument is only used
for forecast pretraining.`,name:"num_forecast_mask_patches"},{anchor:"transformers.PatchTSTConfig.channel_consistent_masking",description:`<strong>channel_consistent_masking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If channel consistent masking is True, all the channels will have the same masking pattern.`,name:"channel_consistent_masking"},{anchor:"transformers.PatchTSTConfig.unmasked_channel_indices",description:`<strong>unmasked_channel_indices</strong> (<code>list</code>, <em>optional</em>) &#x2014;
Indices of channels that are not masked during pretraining. Values in the list are number between 1 and
<code>num_input_channels</code>`,name:"unmasked_channel_indices"},{anchor:"transformers.PatchTSTConfig.mask_value",description:`<strong>mask_value</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Values in the masked patches will be filled by <code>mask_value</code>.`,name:"mask_value"},{anchor:"transformers.PatchTSTConfig.pooling_type",description:`<strong>pooling_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;mean&quot;</code>) &#x2014;
Pooling of the embedding. <code>&quot;mean&quot;</code>, <code>&quot;max&quot;</code> and <code>None</code> are supported.`,name:"pooling_type"},{anchor:"transformers.PatchTSTConfig.head_dropout",description:`<strong>head_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for head.`,name:"head_dropout"},{anchor:"transformers.PatchTSTConfig.prediction_length",description:`<strong>prediction_length</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
The prediction horizon that the model will output.`,name:"prediction_length"},{anchor:"transformers.PatchTSTConfig.num_targets",description:`<strong>num_targets</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of targets for regression and classification tasks. For classification, it is the number of
classes.`,name:"num_targets"},{anchor:"transformers.PatchTSTConfig.output_range",description:`<strong>output_range</strong> (<code>list</code>, <em>optional</em>) &#x2014;
Output range for regression task. The range of output values can be set to enforce the model to produce
values within a range.`,name:"output_range"},{anchor:"transformers.PatchTSTConfig.num_parallel_samples",description:`<strong>num_parallel_samples</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of samples is generated in parallel for probabilistic prediction.`,name:"num_parallel_samples"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/configuration_patchtst.py#L26"}}),z=new Oe({props:{anchor:"transformers.PatchTSTConfig.example",$$slots:{default:[Vn]},$$scope:{ctx:w}}}),fe=new V({props:{title:"PatchTSTModel",local:"transformers.PatchTSTModel",headingTag:"h2"}}),ge=new I({props:{name:"class transformers.PatchTSTModel",anchor:"transformers.PatchTSTModel",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/modeling_patchtst.py#L1124"}}),Te=new I({props:{name:"forward",anchor:"transformers.PatchTSTModel.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"past_observed_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"future_values",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PatchTSTModel.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTModel.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTModel.forward.future_values",description:`<strong>future_values</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, prediction_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Future target values associated with the <code>past_values</code>`,name:"future_values"},{anchor:"transformers.PatchTSTModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the output attention of all layers`,name:"output_attentions"},{anchor:"transformers.PatchTSTModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/modeling_patchtst.py#L1144",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PatchTSTModelOutput</code> or tuple of <code>torch.Tensor</code> (if <code>return_dict</code>=False or <code>config.return_dict</code>=False)</p>
`}}),X=new Oe({props:{anchor:"transformers.PatchTSTModel.forward.example",$$slots:{default:[zn]},$$scope:{ctx:w}}}),_e=new V({props:{title:"PatchTSTForPrediction",local:"transformers.PatchTSTForPrediction",headingTag:"h2"}}),be=new I({props:{name:"class transformers.PatchTSTForPrediction",anchor:"transformers.PatchTSTForPrediction",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTForPrediction.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/modeling_patchtst.py#L1611"}}),Me=new I({props:{name:"forward",anchor:"transformers.PatchTSTForPrediction.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"past_observed_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"future_values",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PatchTSTForPrediction.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTForPrediction.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTForPrediction.forward.future_values",description:`<strong>future_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, forecast_len, num_input_channels)</code>, <em>optional</em>) &#x2014;
Future target values associated with the <code>past_values</code>`,name:"future_values"},{anchor:"transformers.PatchTSTForPrediction.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTForPrediction.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the output attention of all layers`,name:"output_attentions"},{anchor:"transformers.PatchTSTForPrediction.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/modeling_patchtst.py#L1646",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PatchTSTForPredictionOutput</code> or tuple of <code>torch.Tensor</code> (if <code>return_dict</code>=False or
<code>config.return_dict</code>=False)</p>
`}}),q=new Oe({props:{anchor:"transformers.PatchTSTForPrediction.forward.example",$$slots:{default:[Yn]},$$scope:{ctx:w}}}),ye=new V({props:{title:"PatchTSTForClassification",local:"transformers.PatchTSTForClassification",headingTag:"h2"}}),ve=new I({props:{name:"class transformers.PatchTSTForClassification",anchor:"transformers.PatchTSTForClassification",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTForClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/modeling_patchtst.py#L1418"}}),we=new I({props:{name:"forward",anchor:"transformers.PatchTSTForClassification.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"target_values",val:": typing.Optional[torch.Tensor] = None"},{name:"past_observed_mask",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PatchTSTForClassification.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTForClassification.forward.target_values",description:`<strong>target_values</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Labels associates with the <code>past_values</code>`,name:"target_values"},{anchor:"transformers.PatchTSTForClassification.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>bool</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTForClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTForClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PatchTSTForClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/modeling_patchtst.py#L1438",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.patchtst.modeling_patchtst.PatchTSTForClassificationOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/patchtst#transformers.PatchTSTConfig"
>PatchTSTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<em>optional</em>, returned when <code>labels</code> is provided, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) — Total loss as the sum of the masked language modeling loss and the next sequence prediction
(classification) loss.</p>
</li>
<li>
<p><strong>prediction_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_targets)</code>) — Prediction scores of the PatchTST modeling head (scores before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.patchtst.modeling_patchtst.PatchTSTForClassificationOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Q=new Wn({props:{$$slots:{default:[Xn]},$$scope:{ctx:w}}}),D=new Oe({props:{anchor:"transformers.PatchTSTForClassification.forward.example",$$slots:{default:[En]},$$scope:{ctx:w}}}),$e=new V({props:{title:"PatchTSTForPretraining",local:"transformers.PatchTSTForPretraining",headingTag:"h2"}}),je=new I({props:{name:"class transformers.PatchTSTForPretraining",anchor:"transformers.PatchTSTForPretraining",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTForPretraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/modeling_patchtst.py#L1265"}}),Pe=new I({props:{name:"forward",anchor:"transformers.PatchTSTForPretraining.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"past_observed_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PatchTSTForPretraining.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTForPretraining.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTForPretraining.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTForPretraining.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the output attention of all layers`,name:"output_attentions"},{anchor:"transformers.PatchTSTForPretraining.forward.return_dict",description:"<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.",name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/modeling_patchtst.py#L1281",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PatchTSTForPretrainingOutput</code> or tuple of <code>torch.Tensor</code> (if <code>return_dict</code>=False or
<code>config.return_dict</code>=False)</p>
`}}),A=new Oe({props:{anchor:"transformers.PatchTSTForPretraining.forward.example",$$slots:{default:[qn]},$$scope:{ctx:w}}}),Je=new V({props:{title:"PatchTSTForRegression",local:"transformers.PatchTSTForRegression",headingTag:"h2"}}),Ce=new I({props:{name:"class transformers.PatchTSTForRegression",anchor:"transformers.PatchTSTForRegression",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTForRegression.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/modeling_patchtst.py#L1858"}}),Ue=new I({props:{name:"forward",anchor:"transformers.PatchTSTForRegression.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"target_values",val:": typing.Optional[torch.Tensor] = None"},{name:"past_observed_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PatchTSTForRegression.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTForRegression.forward.target_values",description:`<strong>target_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, num_input_channels)</code>) &#x2014;
Target values associates with the <code>past_values</code>`,name:"target_values"},{anchor:"transformers.PatchTSTForRegression.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).
Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTForRegression.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTForRegression.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PatchTSTForRegression.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/modeling_patchtst.py#L1890",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.patchtst.modeling_patchtst.PatchTSTForRegressionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/patchtst#transformers.PatchTSTConfig"
>PatchTSTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<em>optional</em>, returned when <code>labels</code> is provided, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) — MSE loss.</p>
</li>
<li>
<p><strong>regression_outputs</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_targets)</code>) — Regression outputs of the time series modeling heads.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.patchtst.modeling_patchtst.PatchTSTForRegressionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),O=new Wn({props:{$$slots:{default:[Qn]},$$scope:{ctx:w}}}),K=new Oe({props:{anchor:"transformers.PatchTSTForRegression.forward.example",$$slots:{default:[Dn]},$$scope:{ctx:w}}}),Se=new Hn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/patchtst.md"}}),{c(){a=m("meta"),y=o(),c=m("p"),d=o(),h(M.$$.fragment),t=o(),v=m("div"),v.innerHTML=rn,tt=o(),h(ne.$$.fragment),nt=o(),ae=m("p"),ae.innerHTML=ln,at=o(),se=m("p"),se.textContent=cn,st=o(),oe=m("p"),oe.innerHTML=dn,ot=o(),re=m("p"),re.textContent=mn,rt=o(),le=m("p"),le.innerHTML=pn,lt=o(),ie=m("p"),ie.innerHTML=hn,it=o(),h(ce.$$.fragment),ct=o(),de=m("p"),de.innerHTML=un,dt=o(),h(me.$$.fragment),mt=o(),pe=m("ul"),pe.innerHTML=fn,pt=o(),h(he.$$.fragment),ht=o(),S=m("div"),h(ue.$$.fragment),Ct=o(),Fe=m("p"),Fe.innerHTML=gn,Ut=o(),Be=m("p"),Be.innerHTML=Tn,St=o(),h(z.$$.fragment),ut=o(),h(fe.$$.fragment),ft=o(),$=m("div"),h(ge.$$.fragment),xt=o(),We=m("p"),We.textContent=_n,kt=o(),Ze=m("p"),Ze.innerHTML=bn,Ft=o(),Ge=m("p"),Ge.innerHTML=Mn,Bt=o(),Y=m("div"),h(Te.$$.fragment),Wt=o(),h(X.$$.fragment),gt=o(),h(_e.$$.fragment),Tt=o(),j=m("div"),h(be.$$.fragment),Zt=o(),Ne=m("p"),Ne.textContent=yn,Gt=o(),Re=m("p"),Re.innerHTML=vn,Nt=o(),Ie=m("p"),Ie.innerHTML=wn,Rt=o(),E=m("div"),h(Me.$$.fragment),It=o(),h(q.$$.fragment),_t=o(),h(ye.$$.fragment),bt=o(),P=m("div"),h(ve.$$.fragment),Ht=o(),He=m("p"),He.textContent=$n,Vt=o(),Ve=m("p"),Ve.innerHTML=jn,zt=o(),ze=m("p"),ze.innerHTML=Pn,Yt=o(),Z=m("div"),h(we.$$.fragment),Xt=o(),Ye=m("p"),Ye.innerHTML=Jn,Et=o(),h(Q.$$.fragment),qt=o(),h(D.$$.fragment),Mt=o(),h($e.$$.fragment),yt=o(),J=m("div"),h(je.$$.fragment),Qt=o(),Xe=m("p"),Xe.textContent=Cn,Dt=o(),Ee=m("p"),Ee.innerHTML=Un,Lt=o(),qe=m("p"),qe.innerHTML=Sn,At=o(),L=m("div"),h(Pe.$$.fragment),Ot=o(),h(A.$$.fragment),vt=o(),h(Je.$$.fragment),wt=o(),C=m("div"),h(Ce.$$.fragment),Kt=o(),Qe=m("p"),Qe.textContent=xn,en=o(),De=m("p"),De.innerHTML=kn,tn=o(),Le=m("p"),Le.innerHTML=Fn,nn=o(),G=m("div"),h(Ue.$$.fragment),an=o(),Ae=m("p"),Ae.innerHTML=Bn,sn=o(),h(O.$$.fragment),on=o(),h(K.$$.fragment),$t=o(),h(Se.$$.fragment),jt=o(),et=m("p"),this.h()},l(e){const n=In("svelte-u9bgzb",document.head);a=p(n,"META",{name:!0,content:!0}),n.forEach(s),y=r(e),c=p(e,"P",{}),W(c).forEach(s),d=r(e),u(M.$$.fragment,e),t=r(e),v=p(e,"DIV",{class:!0,"data-svelte-h":!0}),b(v)!=="svelte-13t8s2t"&&(v.innerHTML=rn),tt=r(e),u(ne.$$.fragment,e),nt=r(e),ae=p(e,"P",{"data-svelte-h":!0}),b(ae)!=="svelte-a4z81d"&&(ae.innerHTML=ln),at=r(e),se=p(e,"P",{"data-svelte-h":!0}),b(se)!=="svelte-11qe7tl"&&(se.textContent=cn),st=r(e),oe=p(e,"P",{"data-svelte-h":!0}),b(oe)!=="svelte-cqhrix"&&(oe.innerHTML=dn),ot=r(e),re=p(e,"P",{"data-svelte-h":!0}),b(re)!=="svelte-vfdo9a"&&(re.textContent=mn),rt=r(e),le=p(e,"P",{"data-svelte-h":!0}),b(le)!=="svelte-1lan0k1"&&(le.innerHTML=pn),lt=r(e),ie=p(e,"P",{"data-svelte-h":!0}),b(ie)!=="svelte-kbmat5"&&(ie.innerHTML=hn),it=r(e),u(ce.$$.fragment,e),ct=r(e),de=p(e,"P",{"data-svelte-h":!0}),b(de)!=="svelte-t32a8j"&&(de.innerHTML=un),dt=r(e),u(me.$$.fragment,e),mt=r(e),pe=p(e,"UL",{"data-svelte-h":!0}),b(pe)!=="svelte-tg1cax"&&(pe.innerHTML=fn),pt=r(e),u(he.$$.fragment,e),ht=r(e),S=p(e,"DIV",{class:!0});var N=W(S);u(ue.$$.fragment,N),Ct=r(N),Fe=p(N,"P",{"data-svelte-h":!0}),b(Fe)!=="svelte-160dpnn"&&(Fe.innerHTML=gn),Ut=r(N),Be=p(N,"P",{"data-svelte-h":!0}),b(Be)!=="svelte-hntihc"&&(Be.innerHTML=Tn),St=r(N),u(z.$$.fragment,N),N.forEach(s),ut=r(e),u(fe.$$.fragment,e),ft=r(e),$=p(e,"DIV",{class:!0});var x=W($);u(ge.$$.fragment,x),xt=r(x),We=p(x,"P",{"data-svelte-h":!0}),b(We)!=="svelte-125jl3x"&&(We.textContent=_n),kt=r(x),Ze=p(x,"P",{"data-svelte-h":!0}),b(Ze)!=="svelte-6pahdo"&&(Ze.innerHTML=bn),Ft=r(x),Ge=p(x,"P",{"data-svelte-h":!0}),b(Ge)!=="svelte-hswkmf"&&(Ge.innerHTML=Mn),Bt=r(x),Y=p(x,"DIV",{class:!0});var xe=W(Y);u(Te.$$.fragment,xe),Wt=r(xe),u(X.$$.fragment,xe),xe.forEach(s),x.forEach(s),gt=r(e),u(_e.$$.fragment,e),Tt=r(e),j=p(e,"DIV",{class:!0});var k=W(j);u(be.$$.fragment,k),Zt=r(k),Ne=p(k,"P",{"data-svelte-h":!0}),b(Ne)!=="svelte-12vsmyb"&&(Ne.textContent=yn),Gt=r(k),Re=p(k,"P",{"data-svelte-h":!0}),b(Re)!=="svelte-6pahdo"&&(Re.innerHTML=vn),Nt=r(k),Ie=p(k,"P",{"data-svelte-h":!0}),b(Ie)!=="svelte-hswkmf"&&(Ie.innerHTML=wn),Rt=r(k),E=p(k,"DIV",{class:!0});var ke=W(E);u(Me.$$.fragment,ke),It=r(ke),u(q.$$.fragment,ke),ke.forEach(s),k.forEach(s),_t=r(e),u(ye.$$.fragment,e),bt=r(e),P=p(e,"DIV",{class:!0});var F=W(P);u(ve.$$.fragment,F),Ht=r(F),He=p(F,"P",{"data-svelte-h":!0}),b(He)!=="svelte-1yav0vu"&&(He.textContent=$n),Vt=r(F),Ve=p(F,"P",{"data-svelte-h":!0}),b(Ve)!=="svelte-6pahdo"&&(Ve.innerHTML=jn),zt=r(F),ze=p(F,"P",{"data-svelte-h":!0}),b(ze)!=="svelte-hswkmf"&&(ze.innerHTML=Pn),Yt=r(F),Z=p(F,"DIV",{class:!0});var R=W(Z);u(we.$$.fragment,R),Xt=r(R),Ye=p(R,"P",{"data-svelte-h":!0}),b(Ye)!=="svelte-12mwuic"&&(Ye.innerHTML=Jn),Et=r(R),u(Q.$$.fragment,R),qt=r(R),u(D.$$.fragment,R),R.forEach(s),F.forEach(s),Mt=r(e),u($e.$$.fragment,e),yt=r(e),J=p(e,"DIV",{class:!0});var B=W(J);u(je.$$.fragment,B),Qt=r(B),Xe=p(B,"P",{"data-svelte-h":!0}),b(Xe)!=="svelte-ruyd93"&&(Xe.textContent=Cn),Dt=r(B),Ee=p(B,"P",{"data-svelte-h":!0}),b(Ee)!=="svelte-6pahdo"&&(Ee.innerHTML=Un),Lt=r(B),qe=p(B,"P",{"data-svelte-h":!0}),b(qe)!=="svelte-hswkmf"&&(qe.innerHTML=Sn),At=r(B),L=p(B,"DIV",{class:!0});var Jt=W(L);u(Pe.$$.fragment,Jt),Ot=r(Jt),u(A.$$.fragment,Jt),Jt.forEach(s),B.forEach(s),vt=r(e),u(Je.$$.fragment,e),wt=r(e),C=p(e,"DIV",{class:!0});var H=W(C);u(Ce.$$.fragment,H),Kt=r(H),Qe=p(H,"P",{"data-svelte-h":!0}),b(Qe)!=="svelte-1u8tt8v"&&(Qe.textContent=xn),en=r(H),De=p(H,"P",{"data-svelte-h":!0}),b(De)!=="svelte-6pahdo"&&(De.innerHTML=kn),tn=r(H),Le=p(H,"P",{"data-svelte-h":!0}),b(Le)!=="svelte-hswkmf"&&(Le.innerHTML=Fn),nn=r(H),G=p(H,"DIV",{class:!0});var ee=W(G);u(Ue.$$.fragment,ee),an=r(ee),Ae=p(ee,"P",{"data-svelte-h":!0}),b(Ae)!=="svelte-7v5ue0"&&(Ae.innerHTML=Bn),sn=r(ee),u(O.$$.fragment,ee),on=r(ee),u(K.$$.fragment,ee),ee.forEach(s),H.forEach(s),$t=r(e),u(Se.$$.fragment,e),jt=r(e),et=p(e,"P",{}),W(et).forEach(s),this.h()},h(){U(a,"name","hf:doc:metadata"),U(a,"content",An),U(v,"class","flex flex-wrap space-x-1"),U(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){l(document.head,a),i(e,y,n),i(e,c,n),i(e,d,n),f(M,e,n),i(e,t,n),i(e,v,n),i(e,tt,n),f(ne,e,n),i(e,nt,n),i(e,ae,n),i(e,at,n),i(e,se,n),i(e,st,n),i(e,oe,n),i(e,ot,n),i(e,re,n),i(e,rt,n),i(e,le,n),i(e,lt,n),i(e,ie,n),i(e,it,n),f(ce,e,n),i(e,ct,n),i(e,de,n),i(e,dt,n),f(me,e,n),i(e,mt,n),i(e,pe,n),i(e,pt,n),f(he,e,n),i(e,ht,n),i(e,S,n),f(ue,S,null),l(S,Ct),l(S,Fe),l(S,Ut),l(S,Be),l(S,St),f(z,S,null),i(e,ut,n),f(fe,e,n),i(e,ft,n),i(e,$,n),f(ge,$,null),l($,xt),l($,We),l($,kt),l($,Ze),l($,Ft),l($,Ge),l($,Bt),l($,Y),f(Te,Y,null),l(Y,Wt),f(X,Y,null),i(e,gt,n),f(_e,e,n),i(e,Tt,n),i(e,j,n),f(be,j,null),l(j,Zt),l(j,Ne),l(j,Gt),l(j,Re),l(j,Nt),l(j,Ie),l(j,Rt),l(j,E),f(Me,E,null),l(E,It),f(q,E,null),i(e,_t,n),f(ye,e,n),i(e,bt,n),i(e,P,n),f(ve,P,null),l(P,Ht),l(P,He),l(P,Vt),l(P,Ve),l(P,zt),l(P,ze),l(P,Yt),l(P,Z),f(we,Z,null),l(Z,Xt),l(Z,Ye),l(Z,Et),f(Q,Z,null),l(Z,qt),f(D,Z,null),i(e,Mt,n),f($e,e,n),i(e,yt,n),i(e,J,n),f(je,J,null),l(J,Qt),l(J,Xe),l(J,Dt),l(J,Ee),l(J,Lt),l(J,qe),l(J,At),l(J,L),f(Pe,L,null),l(L,Ot),f(A,L,null),i(e,vt,n),f(Je,e,n),i(e,wt,n),i(e,C,n),f(Ce,C,null),l(C,Kt),l(C,Qe),l(C,en),l(C,De),l(C,tn),l(C,Le),l(C,nn),l(C,G),f(Ue,G,null),l(G,an),l(G,Ae),l(G,sn),f(O,G,null),l(G,on),f(K,G,null),i(e,$t,n),f(Se,e,n),i(e,jt,n),i(e,et,n),Pt=!0},p(e,[n]){const N={};n&2&&(N.$$scope={dirty:n,ctx:e}),z.$set(N);const x={};n&2&&(x.$$scope={dirty:n,ctx:e}),X.$set(x);const xe={};n&2&&(xe.$$scope={dirty:n,ctx:e}),q.$set(xe);const k={};n&2&&(k.$$scope={dirty:n,ctx:e}),Q.$set(k);const ke={};n&2&&(ke.$$scope={dirty:n,ctx:e}),D.$set(ke);const F={};n&2&&(F.$$scope={dirty:n,ctx:e}),A.$set(F);const R={};n&2&&(R.$$scope={dirty:n,ctx:e}),O.$set(R);const B={};n&2&&(B.$$scope={dirty:n,ctx:e}),K.$set(B)},i(e){Pt||(g(M.$$.fragment,e),g(ne.$$.fragment,e),g(ce.$$.fragment,e),g(me.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(z.$$.fragment,e),g(fe.$$.fragment,e),g(ge.$$.fragment,e),g(Te.$$.fragment,e),g(X.$$.fragment,e),g(_e.$$.fragment,e),g(be.$$.fragment,e),g(Me.$$.fragment,e),g(q.$$.fragment,e),g(ye.$$.fragment,e),g(ve.$$.fragment,e),g(we.$$.fragment,e),g(Q.$$.fragment,e),g(D.$$.fragment,e),g($e.$$.fragment,e),g(je.$$.fragment,e),g(Pe.$$.fragment,e),g(A.$$.fragment,e),g(Je.$$.fragment,e),g(Ce.$$.fragment,e),g(Ue.$$.fragment,e),g(O.$$.fragment,e),g(K.$$.fragment,e),g(Se.$$.fragment,e),Pt=!0)},o(e){T(M.$$.fragment,e),T(ne.$$.fragment,e),T(ce.$$.fragment,e),T(me.$$.fragment,e),T(he.$$.fragment,e),T(ue.$$.fragment,e),T(z.$$.fragment,e),T(fe.$$.fragment,e),T(ge.$$.fragment,e),T(Te.$$.fragment,e),T(X.$$.fragment,e),T(_e.$$.fragment,e),T(be.$$.fragment,e),T(Me.$$.fragment,e),T(q.$$.fragment,e),T(ye.$$.fragment,e),T(ve.$$.fragment,e),T(we.$$.fragment,e),T(Q.$$.fragment,e),T(D.$$.fragment,e),T($e.$$.fragment,e),T(je.$$.fragment,e),T(Pe.$$.fragment,e),T(A.$$.fragment,e),T(Je.$$.fragment,e),T(Ce.$$.fragment,e),T(Ue.$$.fragment,e),T(O.$$.fragment,e),T(K.$$.fragment,e),T(Se.$$.fragment,e),Pt=!1},d(e){e&&(s(y),s(c),s(d),s(t),s(v),s(tt),s(nt),s(ae),s(at),s(se),s(st),s(oe),s(ot),s(re),s(rt),s(le),s(lt),s(ie),s(it),s(ct),s(de),s(dt),s(mt),s(pe),s(pt),s(ht),s(S),s(ut),s(ft),s($),s(gt),s(Tt),s(j),s(_t),s(bt),s(P),s(Mt),s(yt),s(J),s(vt),s(wt),s(C),s($t),s(jt),s(et)),s(a),_(M,e),_(ne,e),_(ce,e),_(me,e),_(he,e),_(ue),_(z),_(fe,e),_(ge),_(Te),_(X),_(_e,e),_(be),_(Me),_(q),_(ye,e),_(ve),_(we),_(Q),_(D),_($e,e),_(je),_(Pe),_(A),_(Je,e),_(Ce),_(Ue),_(O),_(K),_(Se,e)}}}const An='{"title":"PatchTST","local":"patchtst","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"PatchTSTConfig","local":"transformers.PatchTSTConfig","sections":[],"depth":2},{"title":"PatchTSTModel","local":"transformers.PatchTSTModel","sections":[],"depth":2},{"title":"PatchTSTForPrediction","local":"transformers.PatchTSTForPrediction","sections":[],"depth":2},{"title":"PatchTSTForClassification","local":"transformers.PatchTSTForClassification","sections":[],"depth":2},{"title":"PatchTSTForPretraining","local":"transformers.PatchTSTForPretraining","sections":[],"depth":2},{"title":"PatchTSTForRegression","local":"transformers.PatchTSTForRegression","sections":[],"depth":2}],"depth":1}';function On(w){return Gn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class la extends Nn{constructor(a){super(),Rn(this,a,On,Ln,Zn,{})}}export{la as component};
