import{s as _o,o as yo,n as Ht}from"../chunks/scheduler.18a86fab.js";import{S as bo,i as Mo,g as r,s as a,r as p,A as wo,h as l,f as o,c as s,j as P,u as c,x as f,k as T,y as i,a as n,v as m,d as u,t as h,w as g}from"../chunks/index.98837b22.js";import{T as fo}from"../chunks/Tip.77304350.js";import{D as C}from"../chunks/Docstring.6758ea23.js";import{C as xe}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as To}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as X}from"../chunks/Heading.7e7e0c5b.js";import{E as vo}from"../chunks/index.499f366c.js";function Jo(B){let d,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=r("p"),d.innerHTML=w},l(_){d=l(_,"P",{"data-svelte-h":!0}),f(d)!=="svelte-fincs2"&&(d.innerHTML=w)},m(_,M){n(_,d,M)},p:Ht,d(_){_&&o(d)}}}function jo(B){let d,w="Example:",_,M,v;return M=new xe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBQb3AyUGlhbm9Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kZW1vJTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJpZCUyMiklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJzd2VldGNvY29hJTJGcG9wMnBpYW5vJTIyKSUwQW1vZGVsJTIwJTNEJTIwUG9wMlBpYW5vRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJzd2VldGNvY29hJTJGcG9wMnBpYW5vJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQXByZWRpY3RlZF9pZHMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTBBJTIzJTIwdHJhbnNjcmliZSUyMHNwZWVjaCUwQXRyYW5zY3JpcHRpb24lMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKHByZWRpY3RlZF9pZHMpJTBBdHJhbnNjcmlwdGlvbiU1QjAlNUQlMEElMEFpbnB1dHMlNUIlMjJsYWJlbHMlMjIlNUQlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRGRhdGFzZXQlNUIwJTVEJTVCJTIydGV4dCUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmlucHV0X2lkcyUwQSUwQSUyMyUyMGNvbXB1dGUlMjBsb3NzJTBBbG9zcyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb3NzJTBBcm91bmQobG9zcy5pdGVtKCklMkMlMjAyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Pop2PianoForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;sweetcocoa/pop2piano&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Pop2PianoForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;sweetcocoa/pop2piano&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># transcribe speech</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription[<span class="hljs-number">0</span>]
...

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs[<span class="hljs-string">&quot;labels&quot;</span>] = processor(text=dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute loss</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
...`,wrap:!1}}),{c(){d=r("p"),d.textContent=w,_=a(),p(M.$$.fragment)},l(y){d=l(y,"P",{"data-svelte-h":!0}),f(d)!=="svelte-11lpom8"&&(d.textContent=w),_=s(y),c(M.$$.fragment,y)},m(y,J){n(y,d,J),n(y,_,J),m(M,y,J),v=!0},p:Ht,i(y){v||(u(M.$$.fragment,y),v=!0)},o(y){h(M.$$.fragment,y),v=!1},d(y){y&&(o(d),o(_)),g(M,y)}}}function Uo(B){let d,w=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate(), e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>. For an overview of generation
strategies and code examples, check out the <a href="./generation_strategies">following guide</a>.`;return{c(){d=r("p"),d.innerHTML=w},l(_){d=l(_,"P",{"data-svelte-h":!0}),f(d)!=="svelte-mxjg2r"&&(d.innerHTML=w)},m(_,M){n(_,d,M)},p:Ht,d(_){_&&o(d)}}}function Po(B){let d,w,_,M,v,y,J,Qt='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Ne,H,qe,Q,Et='The Pop2Piano model was proposed in <a href="https://arxiv.org/abs/2211.00895" rel="nofollow">Pop2Piano : Pop Audio-based Piano Cover Generation</a> by Jongho Choi and Kyogu Lee.',He,E,Yt=`Piano covers of pop music are widely enjoyed, but generating them from music is not a trivial task. It requires great
expertise with playing piano as well as knowing different characteristics and melodies of a song. With Pop2Piano you
can directly generate a cover from a song’s audio waveform. It is the first model to directly generate a piano cover
from pop audio without melody and chord extraction modules.`,Qe,Y,St=`Pop2Piano is an encoder-decoder Transformer model based on <a href="https://arxiv.org/pdf/1910.10683.pdf" rel="nofollow">T5</a>. The input audio
is transformed to its waveform and passed to the encoder, which transforms it to a latent representation. The decoder
uses these latent representations to generate token ids in an autoregressive way. Each token id corresponds to one of four
different token types: time, velocity, note and ‘special’. The token ids are then decoded to their equivalent MIDI file.`,Ee,S,Lt="The abstract from the paper is the following:",Ye,L,Dt=`<em>Piano covers of pop music are enjoyed by many people. However, the
task of automatically generating piano covers of pop music is still
understudied. This is partly due to the lack of synchronized
{Pop, Piano Cover} data pairs, which made it challenging to apply
the latest data-intensive deep learning-based methods. To leverage
the power of the data-driven approach, we make a large amount of
paired and synchronized {Pop, Piano Cover} data using an automated
pipeline. In this paper, we present Pop2Piano, a Transformer network
that generates piano covers given waveforms of pop music. To the best
of our knowledge, this is the first model to generate a piano cover
directly from pop audio without using melody and chord extraction
modules. We show that Pop2Piano, trained with our dataset, is capable
of producing plausible piano covers.</em>`,Se,D,At=`This model was contributed by <a href="https://huggingface.co/susnato" rel="nofollow">Susnato Dhar</a>.
The original code can be found <a href="https://github.com/sweetcocoa/pop2piano" rel="nofollow">here</a>.`,Le,A,De,O,Ot="<li>To use Pop2Piano, you will need to install the 🤗 Transformers library, as well as the following third party modules:</li>",Ae,K,Oe,ee,Kt="Please note that you may need to restart your runtime after installation.",Ke,te,eo="<li>Pop2Piano is an Encoder-Decoder based model like T5.</li> <li>Pop2Piano can be used to generate midi-audio files for a given audio sequence.</li> <li>Choosing different composers in <code>Pop2PianoForConditionalGeneration.generate()</code> can lead to variety of different results.</li> <li>Setting the sampling rate to 44.1 kHz when loading the audio file can give good performance.</li> <li>Though Pop2Piano was mainly trained on Korean Pop music, it also does pretty well on other Western Pop or Hip Hop songs.</li>",et,oe,tt,ne,to="<li>Example using HuggingFace Dataset:</li>",ot,ae,nt,se,oo="<li>Example using your own audio file:</li>",at,re,st,le,no="<li>Example of processing multiple audio files in batch:</li>",rt,ie,lt,de,ao="<li>Example of processing multiple audio files in batch (Using <code>Pop2PianoFeatureExtractor</code> and <code>Pop2PianoTokenizer</code>):</li>",it,pe,dt,ce,pt,k,me,Ut,Ge,so=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/pop2piano#transformers.Pop2PianoForConditionalGeneration">Pop2PianoForConditionalGeneration</a>. It is used
to instantiate a Pop2PianoForConditionalGeneration model according to the specified arguments, defining the model
architecture. Instantiating a configuration with the defaults will yield a similar configuration to that of the
Pop2Piano <a href="https://huggingface.co/sweetcocoa/pop2piano" rel="nofollow">sweetcocoa/pop2piano</a> architecture.`,Pt,Ce,ro=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ct,ue,mt,$,he,kt,W,ge,Gt,$e,lo="Call self as a function.",ut,fe,ht,b,_e,Ct,Ie,io="Pop2Piano Model with a <code>language modeling</code> head on top.",$t,ze,po=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,It,Ze,co=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,zt,j,ye,Zt,Xe,mo='The <a href="/docs/transformers/main/en/model_doc/pop2piano#transformers.Pop2PianoForConditionalGeneration">Pop2PianoForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',Xt,R,Bt,F,Wt,G,be,Rt,Be,uo="Generates token ids for midi outputs.",Ft,x,gt,Me,ft,I,we,xt,V,Te,Vt,We,ho="Call self as a function.",_t,ve,yt,z,Je,Nt,N,je,qt,Re,go="Call self as a function.",bt,Ue,Mt,Ve,wt;return v=new X({props:{title:"Pop2Piano",local:"pop2piano",headingTag:"h1"}}),H=new X({props:{title:"Overview",local:"overview",headingTag:"h2"}}),A=new X({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),K=new xe({props:{code:"cGlwJTIwaW5zdGFsbCUyMHByZXR0eS1taWRpJTNEJTNEMC4yLjklMjBlc3NlbnRpYSUzRCUzRDIuMWI2LmRldjEwMzQlMjBsaWJyb3NhJTIwc2NpcHk=",highlighted:"pip install pretty-midi==0.2.9 essentia==2.1b6.dev1034 librosa scipy",wrap:!1}}),oe=new X({props:{title:"Examples",local:"examples",headingTag:"h2"}}),ae=new xe({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBvcDJQaWFub0ZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyMFBvcDJQaWFub1Byb2Nlc3NvciUwQSUwQW1vZGVsJTIwJTNEJTIwUG9wMlBpYW5vRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJzd2VldGNvY29hJTJGcG9wMnBpYW5vJTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMFBvcDJQaWFub1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyc3dlZXRjb2NvYSUyRnBvcDJwaWFubyUyMiklMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzd2VldGNvY29hJTJGcG9wMnBpYW5vX2NpJTIyJTJDJTIwc3BsaXQlM0QlMjJ0ZXN0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjBhdWRpbyUzRGRzJTVCJTIyYXVkaW8lMjIlNUQlNUIwJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEZHMlNUIlMjJhdWRpbyUyMiU1RCU1QjAlNUQlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSklMEFtb2RlbF9vdXRwdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dF9mZWF0dXJlcyUzRGlucHV0cyU1QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTVEJTJDJTIwY29tcG9zZXIlM0QlMjJjb21wb3NlcjElMjIpJTBBdG9rZW5pemVyX291dHB1dCUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoJTBBJTIwJTIwJTIwJTIwdG9rZW5faWRzJTNEbW9kZWxfb3V0cHV0JTJDJTIwZmVhdHVyZV9leHRyYWN0b3Jfb3V0cHV0JTNEaW5wdXRzJTBBKSU1QiUyMnByZXR0eV9taWRpX29iamVjdHMlMjIlNUQlNUIwJTVEJTBBdG9rZW5pemVyX291dHB1dC53cml0ZSglMjIuJTJGT3V0cHV0cyUyRm1pZGlfb3V0cHV0Lm1pZCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pop2PianoForConditionalGeneration, Pop2PianoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Pop2PianoForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;sweetcocoa/pop2piano&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = Pop2PianoProcessor.from_pretrained(<span class="hljs-string">&quot;sweetcocoa/pop2piano&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;sweetcocoa/pop2piano_ci&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    audio=ds[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=ds[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_output = model.generate(input_features=inputs[<span class="hljs-string">&quot;input_features&quot;</span>], composer=<span class="hljs-string">&quot;composer1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_output = processor.batch_decode(
<span class="hljs-meta">... </span>    token_ids=model_output, feature_extractor_output=inputs
<span class="hljs-meta">... </span>)[<span class="hljs-string">&quot;pretty_midi_objects&quot;</span>][<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_output.write(<span class="hljs-string">&quot;./Outputs/midi_output.mid&quot;</span>)`,wrap:!1}}),re=new xe({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBQb3AyUGlhbm9Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBQb3AyUGlhbm9Qcm9jZXNzb3IlMEElMEFhdWRpbyUyQyUyMHNyJTIwJTNEJTIwbGlicm9zYS5sb2FkKCUyMiUzQ3lvdXJfYXVkaW9fZmlsZV9oZXJlJTNFJTIyJTJDJTIwc3IlM0Q0NDEwMCklMjAlMjAlMjMlMjBmZWVsJTIwZnJlZSUyMHRvJTIwY2hhbmdlJTIwdGhlJTIwc3IlMjB0byUyMGElMjBzdWl0YWJsZSUyMHZhbHVlLiUwQW1vZGVsJTIwJTNEJTIwUG9wMlBpYW5vRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJzd2VldGNvY29hJTJGcG9wMnBpYW5vJTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMFBvcDJQaWFub1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyc3dlZXRjb2NvYSUyRnBvcDJwaWFubyUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoYXVkaW8lM0RhdWRpbyUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzciUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBbW9kZWxfb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfZmVhdHVyZXMlM0RpbnB1dHMlNUIlMjJpbnB1dF9mZWF0dXJlcyUyMiU1RCUyQyUyMGNvbXBvc2VyJTNEJTIyY29tcG9zZXIxJTIyKSUwQXRva2VuaXplcl9vdXRwdXQlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKCUwQSUyMCUyMCUyMCUyMHRva2VuX2lkcyUzRG1vZGVsX291dHB1dCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yX291dHB1dCUzRGlucHV0cyUwQSklNUIlMjJwcmV0dHlfbWlkaV9vYmplY3RzJTIyJTVEJTVCMCU1RCUwQXRva2VuaXplcl9vdXRwdXQud3JpdGUoJTIyLiUyRk91dHB1dHMlMkZtaWRpX291dHB1dC5taWQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> librosa
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pop2PianoForConditionalGeneration, Pop2PianoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>audio, sr = librosa.load(<span class="hljs-string">&quot;&lt;your_audio_file_here&gt;&quot;</span>, sr=<span class="hljs-number">44100</span>)  <span class="hljs-comment"># feel free to change the sr to a suitable value.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Pop2PianoForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;sweetcocoa/pop2piano&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = Pop2PianoProcessor.from_pretrained(<span class="hljs-string">&quot;sweetcocoa/pop2piano&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(audio=audio, sampling_rate=sr, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_output = model.generate(input_features=inputs[<span class="hljs-string">&quot;input_features&quot;</span>], composer=<span class="hljs-string">&quot;composer1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_output = processor.batch_decode(
<span class="hljs-meta">... </span>    token_ids=model_output, feature_extractor_output=inputs
<span class="hljs-meta">... </span>)[<span class="hljs-string">&quot;pretty_midi_objects&quot;</span>][<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_output.write(<span class="hljs-string">&quot;./Outputs/midi_output.mid&quot;</span>)`,wrap:!1}}),ie=new xe({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBQb3AyUGlhbm9Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBQb3AyUGlhbm9Qcm9jZXNzb3IlMEElMEElMjMlMjBmZWVsJTIwZnJlZSUyMHRvJTIwY2hhbmdlJTIwdGhlJTIwc3IlMjB0byUyMGElMjBzdWl0YWJsZSUyMHZhbHVlLiUwQWF1ZGlvMSUyQyUyMHNyMSUyMCUzRCUyMGxpYnJvc2EubG9hZCglMjIlM0N5b3VyX2ZpcnN0X2F1ZGlvX2ZpbGVfaGVyZSUzRSUyMiUyQyUyMHNyJTNENDQxMDApJTIwJTIwJTBBYXVkaW8yJTJDJTIwc3IyJTIwJTNEJTIwbGlicm9zYS5sb2FkKCUyMiUzQ3lvdXJfc2Vjb25kX2F1ZGlvX2ZpbGVfaGVyZSUzRSUyMiUyQyUyMHNyJTNENDQxMDApJTBBbW9kZWwlMjAlM0QlMjBQb3AyUGlhbm9Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnN3ZWV0Y29jb2ElMkZwb3AycGlhbm8lMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwUG9wMlBpYW5vUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJzd2VldGNvY29hJTJGcG9wMnBpYW5vJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihhdWRpbyUzRCU1QmF1ZGlvMSUyQyUyMGF1ZGlvMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0QlNUJzcjElMkMlMjBzcjIlNUQlMkMlMjByZXR1cm5fYXR0ZW50aW9uX21hc2slM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjMlMjBTaW5jZSUyMHdlJTIwbm93JTIwZ2VuZXJhdGluZyUyMGluJTIwYmF0Y2goMiUyMGF1ZGlvcyklMjB3ZSUyMG11c3QlMjBwYXNzJTIwdGhlJTIwYXR0ZW50aW9uX21hc2slMEFtb2RlbF9vdXRwdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjBpbnB1dF9mZWF0dXJlcyUzRGlucHV0cyU1QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwYXR0ZW50aW9uX21hc2slM0RpbnB1dHMlNUIlMjJhdHRlbnRpb25fbWFzayUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGNvbXBvc2VyJTNEJTIyY29tcG9zZXIxJTIyJTJDJTBBKSUwQXRva2VuaXplcl9vdXRwdXQlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKCUwQSUyMCUyMCUyMCUyMHRva2VuX2lkcyUzRG1vZGVsX291dHB1dCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yX291dHB1dCUzRGlucHV0cyUwQSklNUIlMjJwcmV0dHlfbWlkaV9vYmplY3RzJTIyJTVEJTBBJTBBJTIzJTIwU2luY2UlMjB3ZSUyMG5vdyUyMGhhdmUlMjAyJTIwZ2VuZXJhdGVkJTIwTUlESSUyMGZpbGVzJTBBdG9rZW5pemVyX291dHB1dCU1QjAlNUQud3JpdGUoJTIyLiUyRk91dHB1dHMlMkZtaWRpX291dHB1dDEubWlkJTIyKSUwQXRva2VuaXplcl9vdXRwdXQlNUIxJTVELndyaXRlKCUyMi4lMkZPdXRwdXRzJTJGbWlkaV9vdXRwdXQyLm1pZCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> librosa
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pop2PianoForConditionalGeneration, Pop2PianoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># feel free to change the sr to a suitable value.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio1, sr1 = librosa.load(<span class="hljs-string">&quot;&lt;your_first_audio_file_here&gt;&quot;</span>, sr=<span class="hljs-number">44100</span>)  
<span class="hljs-meta">&gt;&gt;&gt; </span>audio2, sr2 = librosa.load(<span class="hljs-string">&quot;&lt;your_second_audio_file_here&gt;&quot;</span>, sr=<span class="hljs-number">44100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Pop2PianoForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;sweetcocoa/pop2piano&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = Pop2PianoProcessor.from_pretrained(<span class="hljs-string">&quot;sweetcocoa/pop2piano&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(audio=[audio1, audio2], sampling_rate=[sr1, sr2], return_attention_mask=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Since we now generating in batch(2 audios) we must pass the attention_mask</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_output = model.generate(
<span class="hljs-meta">... </span>    input_features=inputs[<span class="hljs-string">&quot;input_features&quot;</span>],
<span class="hljs-meta">... </span>    attention_mask=inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>],
<span class="hljs-meta">... </span>    composer=<span class="hljs-string">&quot;composer1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_output = processor.batch_decode(
<span class="hljs-meta">... </span>    token_ids=model_output, feature_extractor_output=inputs
<span class="hljs-meta">... </span>)[<span class="hljs-string">&quot;pretty_midi_objects&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Since we now have 2 generated MIDI files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_output[<span class="hljs-number">0</span>].write(<span class="hljs-string">&quot;./Outputs/midi_output1.mid&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_output[<span class="hljs-number">1</span>].write(<span class="hljs-string">&quot;./Outputs/midi_output2.mid&quot;</span>)`,wrap:!1}}),pe=new xe({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> librosa
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pop2PianoForConditionalGeneration, Pop2PianoFeatureExtractor, Pop2PianoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># feel free to change the sr to a suitable value.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio1, sr1 = librosa.load(<span class="hljs-string">&quot;&lt;your_first_audio_file_here&gt;&quot;</span>, sr=<span class="hljs-number">44100</span>)  
<span class="hljs-meta">&gt;&gt;&gt; </span>audio2, sr2 = librosa.load(<span class="hljs-string">&quot;&lt;your_second_audio_file_here&gt;&quot;</span>, sr=<span class="hljs-number">44100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Pop2PianoForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;sweetcocoa/pop2piano&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = Pop2PianoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;sweetcocoa/pop2piano&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = Pop2PianoTokenizer.from_pretrained(<span class="hljs-string">&quot;sweetcocoa/pop2piano&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    audio=[audio1, audio2], 
<span class="hljs-meta">... </span>    sampling_rate=[sr1, sr2], 
<span class="hljs-meta">... </span>    return_attention_mask=<span class="hljs-literal">True</span>, 
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Since we now generating in batch(2 audios) we must pass the attention_mask</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_output = model.generate(
<span class="hljs-meta">... </span>    input_features=inputs[<span class="hljs-string">&quot;input_features&quot;</span>],
<span class="hljs-meta">... </span>    attention_mask=inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>],
<span class="hljs-meta">... </span>    composer=<span class="hljs-string">&quot;composer1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_output = tokenizer.batch_decode(
<span class="hljs-meta">... </span>    token_ids=model_output, feature_extractor_output=inputs
<span class="hljs-meta">... </span>)[<span class="hljs-string">&quot;pretty_midi_objects&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Since we now have 2 generated MIDI files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_output[<span class="hljs-number">0</span>].write(<span class="hljs-string">&quot;./Outputs/midi_output1.mid&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_output[<span class="hljs-number">1</span>].write(<span class="hljs-string">&quot;./Outputs/midi_output2.mid&quot;</span>)`,wrap:!1}}),ce=new X({props:{title:"Pop2PianoConfig",local:"transformers.Pop2PianoConfig",headingTag:"h2"}}),me=new C({props:{name:"class transformers.Pop2PianoConfig",anchor:"transformers.Pop2PianoConfig",parameters:[{name:"vocab_size",val:" = 2400"},{name:"composer_vocab_size",val:" = 21"},{name:"d_model",val:" = 512"},{name:"d_kv",val:" = 64"},{name:"d_ff",val:" = 2048"},{name:"num_layers",val:" = 6"},{name:"num_decoder_layers",val:" = None"},{name:"num_heads",val:" = 8"},{name:"relative_attention_num_buckets",val:" = 32"},{name:"relative_attention_max_distance",val:" = 128"},{name:"dropout_rate",val:" = 0.1"},{name:"layer_norm_epsilon",val:" = 1e-06"},{name:"initializer_factor",val:" = 1.0"},{name:"feed_forward_proj",val:" = 'gated-gelu'"},{name:"is_encoder_decoder",val:" = True"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"eos_token_id",val:" = 1"},{name:"dense_act_fn",val:" = 'relu'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Pop2PianoConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2400) &#x2014;
Vocabulary size of the <code>Pop2PianoForConditionalGeneration</code> model. Defines the number of different tokens
that can be represented by the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/pop2piano#transformers.Pop2PianoForConditionalGeneration">Pop2PianoForConditionalGeneration</a>.`,name:"vocab_size"},{anchor:"transformers.Pop2PianoConfig.composer_vocab_size",description:`<strong>composer_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 21) &#x2014;
Denotes the number of composers.`,name:"composer_vocab_size"},{anchor:"transformers.Pop2PianoConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Size of the encoder layers and the pooler layer.`,name:"d_model"},{anchor:"transformers.Pop2PianoConfig.d_kv",description:`<strong>d_kv</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Size of the key, query, value projections per attention head. The <code>inner_dim</code> of the projection layer will
be defined as <code>num_heads * d_kv</code>.`,name:"d_kv"},{anchor:"transformers.Pop2PianoConfig.d_ff",description:`<strong>d_ff</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Size of the intermediate feed forward layer in each <code>Pop2PianoBlock</code>.`,name:"d_ff"},{anchor:"transformers.Pop2PianoConfig.num_layers",description:`<strong>num_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_layers"},{anchor:"transformers.Pop2PianoConfig.num_decoder_layers",description:`<strong>num_decoder_layers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of hidden layers in the Transformer decoder. Will use the same value as <code>num_layers</code> if not set.`,name:"num_decoder_layers"},{anchor:"transformers.Pop2PianoConfig.num_heads",description:`<strong>num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_heads"},{anchor:"transformers.Pop2PianoConfig.relative_attention_num_buckets",description:`<strong>relative_attention_num_buckets</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The number of buckets to use for each attention layer.`,name:"relative_attention_num_buckets"},{anchor:"transformers.Pop2PianoConfig.relative_attention_max_distance",description:`<strong>relative_attention_max_distance</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The maximum distance of the longer sequences for the bucket separation.`,name:"relative_attention_max_distance"},{anchor:"transformers.Pop2PianoConfig.dropout_rate",description:`<strong>dropout_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The ratio for all dropout layers.`,name:"dropout_rate"},{anchor:"transformers.Pop2PianoConfig.layer_norm_epsilon",description:`<strong>layer_norm_epsilon</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-6) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_epsilon"},{anchor:"transformers.Pop2PianoConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
A factor for initializing all weight matrices (should be kept to 1.0, used internally for initialization
testing).`,name:"initializer_factor"},{anchor:"transformers.Pop2PianoConfig.feed_forward_proj",description:`<strong>feed_forward_proj</strong> (<code>string</code>, <em>optional</em>, defaults to <code>&quot;gated-gelu&quot;</code>) &#x2014;
Type of feed forward layer to be used. Should be one of <code>&quot;relu&quot;</code> or <code>&quot;gated-gelu&quot;</code>.`,name:"feed_forward_proj"},{anchor:"transformers.Pop2PianoConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"},{anchor:"transformers.Pop2PianoConfig.dense_act_fn",description:`<strong>dense_act_fn</strong> (<code>string</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
Type of Activation Function to be used in <code>Pop2PianoDenseActDense</code> and in <code>Pop2PianoDenseGatedActDense</code>.`,name:"dense_act_fn"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/pop2piano/configuration_pop2piano.py#L24"}}),ue=new X({props:{title:"Pop2PianoFeatureExtractor",local:"transformers.models.pop2piano.feature_extraction_pop2piano._LazyModule. getattr . <locals> .Placeholder",headingTag:"h2"}}),he=new C({props:{name:"class transformers.models.pop2piano.feature_extraction_pop2piano._LazyModule.__getattr__.<locals>.Placeholder",anchor:"transformers.models.pop2piano.feature_extraction_pop2piano._LazyModule.__getattr__.<locals>.Placeholder",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),ge=new C({props:{name:"__call__",anchor:"transformers.models.pop2piano.feature_extraction_pop2piano._LazyModule.__getattr__.<locals>.Placeholder.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),fe=new X({props:{title:"Pop2PianoForConditionalGeneration",local:"transformers.Pop2PianoForConditionalGeneration",headingTag:"h2"}}),_e=new C({props:{name:"class transformers.Pop2PianoForConditionalGeneration",anchor:"transformers.Pop2PianoForConditionalGeneration",parameters:[{name:"config",val:": Pop2PianoConfig"}],parametersDescription:[{anchor:"transformers.Pop2PianoForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/pop2piano#transformers.Pop2PianoConfig">Pop2PianoConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/pop2piano/modeling_pop2piano.py#L1043"}}),ye=new C({props:{name:"forward",anchor:"transformers.Pop2PianoForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"input_features",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Pop2Piano is a model with relative position embeddings
so you should be able to pad the inputs on both the right and the left. Indices can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.
<a href="../glossary#input-ids">What are input IDs?</a> To know more on how to prepare <code>input_ids</code> for pretraining
take a look a <a href="./Pop2Piano#training">Pop2Piano Training</a>.`,name:"input_ids"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary. Indices can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.
<a href="../glossary#decoder-input-ids">What are decoder input IDs?</a> Pop2Piano uses the <code>pad_token_id</code> as the
starting token for <code>decoder_input_ids</code> generation. If <code>past_key_values</code> is used, optionally only the last
<code>decoder_input_ids</code> have to be input (see <code>past_key_values</code>). To know more on how to prepare`,name:"decoder_input_ids"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>Tuple[Tuple[torch.Tensor]]</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Does the same task as <code>inputs_embeds</code>. If <code>inputs_embeds</code> is not present but <code>input_features</code> is present
then <code>input_features</code> will be considered as <code>inputs_embeds</code>.`,name:"input_features"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[-100, 0, ..., config.vocab_size - 1]</code>. All labels set to <code>-100</code> are ignored (masked), the loss is only computed for
labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/pop2piano/modeling_pop2piano.py#L1147",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/pop2piano#transformers.Pop2PianoConfig"
>Pop2PianoConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>EncoderDecoderCache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.EncoderDecoderCache"
>EncoderDecoderCache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),R=new fo({props:{$$slots:{default:[Jo]},$$scope:{ctx:B}}}),F=new To({props:{anchor:"transformers.Pop2PianoForConditionalGeneration.forward.example",$$slots:{default:[jo]},$$scope:{ctx:B}}}),be=new C({props:{name:"generate",anchor:"transformers.Pop2PianoForConditionalGeneration.generate",parameters:[{name:"input_features",val:""},{name:"attention_mask",val:" = None"},{name:"composer",val:" = 'composer1'"},{name:"generation_config",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Pop2PianoForConditionalGeneration.generate.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
This is the featurized version of audio generated by <code>Pop2PianoFeatureExtractor</code>.`,name:"input_features"},{anchor:"transformers.Pop2PianoForConditionalGeneration.generate.attention_mask",description:`<strong>attention_mask</strong> &#x2014;
For batched generation <code>input_features</code> are padded to have the same shape across all examples.
<code>attention_mask</code> helps to determine which areas were padded and which were not.<ul>
<li>1 for tokens that are <strong>not padded</strong>,</li>
<li>0 for tokens that are <strong>padded</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Pop2PianoForConditionalGeneration.generate.composer",description:`<strong>composer</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;composer1&quot;</code>) &#x2014;
This value is passed to <code>Pop2PianoConcatEmbeddingToMel</code> to generate different embeddings for each
<code>&quot;composer&quot;</code>. Please make sure that the composet value is present in <code>composer_to_feature_token</code> in
<code>generation_config</code>. For an example please see
<a href="https://huggingface.co/sweetcocoa/pop2piano/blob/main/generation_config.json" rel="nofollow">https://huggingface.co/sweetcocoa/pop2piano/blob/main/generation_config.json</a> .`,name:"composer"},{anchor:"transformers.Pop2PianoForConditionalGeneration.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.Pop2PianoForConditionalGeneration.generate.kwargs",description:`<strong>kwargs</strong> &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/pop2piano/modeling_pop2piano.py#L1283",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.FloatTensor</code>.
Since Pop2Piano is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateEncoderDecoderOutput"
>GenerateEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateBeamEncoderDecoderOutput"
>GenerateBeamEncoderDecoderOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),x=new fo({props:{warning:!0,$$slots:{default:[Uo]},$$scope:{ctx:B}}}),Me=new X({props:{title:"Pop2PianoTokenizer",local:"transformers.models.pop2piano.tokenization_pop2piano._LazyModule. getattr . <locals> .Placeholder",headingTag:"h2"}}),we=new C({props:{name:"class transformers.models.pop2piano.tokenization_pop2piano._LazyModule.__getattr__.<locals>.Placeholder",anchor:"transformers.models.pop2piano.tokenization_pop2piano._LazyModule.__getattr__.<locals>.Placeholder",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Te=new C({props:{name:"__call__",anchor:"transformers.models.pop2piano.tokenization_pop2piano._LazyModule.__getattr__.<locals>.Placeholder.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),ve=new X({props:{title:"Pop2PianoProcessor",local:"transformers.models.pop2piano.processing_pop2piano._LazyModule. getattr . <locals> .Placeholder",headingTag:"h2"}}),Je=new C({props:{name:"class transformers.models.pop2piano.processing_pop2piano._LazyModule.__getattr__.<locals>.Placeholder",anchor:"transformers.models.pop2piano.processing_pop2piano._LazyModule.__getattr__.<locals>.Placeholder",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),je=new C({props:{name:"__call__",anchor:"transformers.models.pop2piano.processing_pop2piano._LazyModule.__getattr__.<locals>.Placeholder.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Ue=new vo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/pop2piano.md"}}),{c(){d=r("meta"),w=a(),_=r("p"),M=a(),p(v.$$.fragment),y=a(),J=r("div"),J.innerHTML=Qt,Ne=a(),p(H.$$.fragment),qe=a(),Q=r("p"),Q.innerHTML=Et,He=a(),E=r("p"),E.textContent=Yt,Qe=a(),Y=r("p"),Y.innerHTML=St,Ee=a(),S=r("p"),S.textContent=Lt,Ye=a(),L=r("p"),L.innerHTML=Dt,Se=a(),D=r("p"),D.innerHTML=At,Le=a(),p(A.$$.fragment),De=a(),O=r("ul"),O.innerHTML=Ot,Ae=a(),p(K.$$.fragment),Oe=a(),ee=r("p"),ee.textContent=Kt,Ke=a(),te=r("ul"),te.innerHTML=eo,et=a(),p(oe.$$.fragment),tt=a(),ne=r("ul"),ne.innerHTML=to,ot=a(),p(ae.$$.fragment),nt=a(),se=r("ul"),se.innerHTML=oo,at=a(),p(re.$$.fragment),st=a(),le=r("ul"),le.innerHTML=no,rt=a(),p(ie.$$.fragment),lt=a(),de=r("ul"),de.innerHTML=ao,it=a(),p(pe.$$.fragment),dt=a(),p(ce.$$.fragment),pt=a(),k=r("div"),p(me.$$.fragment),Ut=a(),Ge=r("p"),Ge.innerHTML=so,Pt=a(),Ce=r("p"),Ce.innerHTML=ro,ct=a(),p(ue.$$.fragment),mt=a(),$=r("div"),p(he.$$.fragment),kt=a(),W=r("div"),p(ge.$$.fragment),Gt=a(),$e=r("p"),$e.textContent=lo,ut=a(),p(fe.$$.fragment),ht=a(),b=r("div"),p(_e.$$.fragment),Ct=a(),Ie=r("p"),Ie.innerHTML=io,$t=a(),ze=r("p"),ze.innerHTML=po,It=a(),Ze=r("p"),Ze.innerHTML=co,zt=a(),j=r("div"),p(ye.$$.fragment),Zt=a(),Xe=r("p"),Xe.innerHTML=mo,Xt=a(),p(R.$$.fragment),Bt=a(),p(F.$$.fragment),Wt=a(),G=r("div"),p(be.$$.fragment),Rt=a(),Be=r("p"),Be.textContent=uo,Ft=a(),p(x.$$.fragment),gt=a(),p(Me.$$.fragment),ft=a(),I=r("div"),p(we.$$.fragment),xt=a(),V=r("div"),p(Te.$$.fragment),Vt=a(),We=r("p"),We.textContent=ho,_t=a(),p(ve.$$.fragment),yt=a(),z=r("div"),p(Je.$$.fragment),Nt=a(),N=r("div"),p(je.$$.fragment),qt=a(),Re=r("p"),Re.textContent=go,bt=a(),p(Ue.$$.fragment),Mt=a(),Ve=r("p"),this.h()},l(e){const t=wo("svelte-u9bgzb",document.head);d=l(t,"META",{name:!0,content:!0}),t.forEach(o),w=s(e),_=l(e,"P",{}),P(_).forEach(o),M=s(e),c(v.$$.fragment,e),y=s(e),J=l(e,"DIV",{class:!0,"data-svelte-h":!0}),f(J)!=="svelte-13t8s2t"&&(J.innerHTML=Qt),Ne=s(e),c(H.$$.fragment,e),qe=s(e),Q=l(e,"P",{"data-svelte-h":!0}),f(Q)!=="svelte-1hnpp4y"&&(Q.innerHTML=Et),He=s(e),E=l(e,"P",{"data-svelte-h":!0}),f(E)!=="svelte-ni45zt"&&(E.textContent=Yt),Qe=s(e),Y=l(e,"P",{"data-svelte-h":!0}),f(Y)!=="svelte-qqdyhn"&&(Y.innerHTML=St),Ee=s(e),S=l(e,"P",{"data-svelte-h":!0}),f(S)!=="svelte-vfdo9a"&&(S.textContent=Lt),Ye=s(e),L=l(e,"P",{"data-svelte-h":!0}),f(L)!=="svelte-nbagib"&&(L.innerHTML=Dt),Se=s(e),D=l(e,"P",{"data-svelte-h":!0}),f(D)!=="svelte-1g8fp7r"&&(D.innerHTML=At),Le=s(e),c(A.$$.fragment,e),De=s(e),O=l(e,"UL",{"data-svelte-h":!0}),f(O)!=="svelte-d30h4n"&&(O.innerHTML=Ot),Ae=s(e),c(K.$$.fragment,e),Oe=s(e),ee=l(e,"P",{"data-svelte-h":!0}),f(ee)!=="svelte-o4f2iu"&&(ee.textContent=Kt),Ke=s(e),te=l(e,"UL",{"data-svelte-h":!0}),f(te)!=="svelte-1kascwk"&&(te.innerHTML=eo),et=s(e),c(oe.$$.fragment,e),tt=s(e),ne=l(e,"UL",{"data-svelte-h":!0}),f(ne)!=="svelte-1kx0lud"&&(ne.innerHTML=to),ot=s(e),c(ae.$$.fragment,e),nt=s(e),se=l(e,"UL",{"data-svelte-h":!0}),f(se)!=="svelte-v9o7u6"&&(se.innerHTML=oo),at=s(e),c(re.$$.fragment,e),st=s(e),le=l(e,"UL",{"data-svelte-h":!0}),f(le)!=="svelte-q0f5tb"&&(le.innerHTML=no),rt=s(e),c(ie.$$.fragment,e),lt=s(e),de=l(e,"UL",{"data-svelte-h":!0}),f(de)!=="svelte-1awpm4y"&&(de.innerHTML=ao),it=s(e),c(pe.$$.fragment,e),dt=s(e),c(ce.$$.fragment,e),pt=s(e),k=l(e,"DIV",{class:!0});var Z=P(k);c(me.$$.fragment,Z),Ut=s(Z),Ge=l(Z,"P",{"data-svelte-h":!0}),f(Ge)!=="svelte-1kr6rsg"&&(Ge.innerHTML=so),Pt=s(Z),Ce=l(Z,"P",{"data-svelte-h":!0}),f(Ce)!=="svelte-o55m63"&&(Ce.innerHTML=ro),Z.forEach(o),ct=s(e),c(ue.$$.fragment,e),mt=s(e),$=l(e,"DIV",{class:!0});var Pe=P($);c(he.$$.fragment,Pe),kt=s(Pe),W=l(Pe,"DIV",{class:!0});var ke=P(W);c(ge.$$.fragment,ke),Gt=s(ke),$e=l(ke,"P",{"data-svelte-h":!0}),f($e)!=="svelte-1eed40t"&&($e.textContent=lo),ke.forEach(o),Pe.forEach(o),ut=s(e),c(fe.$$.fragment,e),ht=s(e),b=l(e,"DIV",{class:!0});var U=P(b);c(_e.$$.fragment,U),Ct=s(U),Ie=l(U,"P",{"data-svelte-h":!0}),f(Ie)!=="svelte-1gz4p5y"&&(Ie.innerHTML=io),$t=s(U),ze=l(U,"P",{"data-svelte-h":!0}),f(ze)!=="svelte-6pahdo"&&(ze.innerHTML=po),It=s(U),Ze=l(U,"P",{"data-svelte-h":!0}),f(Ze)!=="svelte-hswkmf"&&(Ze.innerHTML=co),zt=s(U),j=l(U,"DIV",{class:!0});var q=P(j);c(ye.$$.fragment,q),Zt=s(q),Xe=l(q,"P",{"data-svelte-h":!0}),f(Xe)!=="svelte-1291ecv"&&(Xe.innerHTML=mo),Xt=s(q),c(R.$$.fragment,q),Bt=s(q),c(F.$$.fragment,q),q.forEach(o),Wt=s(U),G=l(U,"DIV",{class:!0});var Fe=P(G);c(be.$$.fragment,Fe),Rt=s(Fe),Be=l(Fe,"P",{"data-svelte-h":!0}),f(Be)!=="svelte-roqoi3"&&(Be.textContent=uo),Ft=s(Fe),c(x.$$.fragment,Fe),Fe.forEach(o),U.forEach(o),gt=s(e),c(Me.$$.fragment,e),ft=s(e),I=l(e,"DIV",{class:!0});var Tt=P(I);c(we.$$.fragment,Tt),xt=s(Tt),V=l(Tt,"DIV",{class:!0});var vt=P(V);c(Te.$$.fragment,vt),Vt=s(vt),We=l(vt,"P",{"data-svelte-h":!0}),f(We)!=="svelte-1eed40t"&&(We.textContent=ho),vt.forEach(o),Tt.forEach(o),_t=s(e),c(ve.$$.fragment,e),yt=s(e),z=l(e,"DIV",{class:!0});var Jt=P(z);c(Je.$$.fragment,Jt),Nt=s(Jt),N=l(Jt,"DIV",{class:!0});var jt=P(N);c(je.$$.fragment,jt),qt=s(jt),Re=l(jt,"P",{"data-svelte-h":!0}),f(Re)!=="svelte-1eed40t"&&(Re.textContent=go),jt.forEach(o),Jt.forEach(o),bt=s(e),c(Ue.$$.fragment,e),Mt=s(e),Ve=l(e,"P",{}),P(Ve).forEach(o),this.h()},h(){T(d,"name","hf:doc:metadata"),T(d,"content",ko),T(J,"class","flex flex-wrap space-x-1"),T(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,d),n(e,w,t),n(e,_,t),n(e,M,t),m(v,e,t),n(e,y,t),n(e,J,t),n(e,Ne,t),m(H,e,t),n(e,qe,t),n(e,Q,t),n(e,He,t),n(e,E,t),n(e,Qe,t),n(e,Y,t),n(e,Ee,t),n(e,S,t),n(e,Ye,t),n(e,L,t),n(e,Se,t),n(e,D,t),n(e,Le,t),m(A,e,t),n(e,De,t),n(e,O,t),n(e,Ae,t),m(K,e,t),n(e,Oe,t),n(e,ee,t),n(e,Ke,t),n(e,te,t),n(e,et,t),m(oe,e,t),n(e,tt,t),n(e,ne,t),n(e,ot,t),m(ae,e,t),n(e,nt,t),n(e,se,t),n(e,at,t),m(re,e,t),n(e,st,t),n(e,le,t),n(e,rt,t),m(ie,e,t),n(e,lt,t),n(e,de,t),n(e,it,t),m(pe,e,t),n(e,dt,t),m(ce,e,t),n(e,pt,t),n(e,k,t),m(me,k,null),i(k,Ut),i(k,Ge),i(k,Pt),i(k,Ce),n(e,ct,t),m(ue,e,t),n(e,mt,t),n(e,$,t),m(he,$,null),i($,kt),i($,W),m(ge,W,null),i(W,Gt),i(W,$e),n(e,ut,t),m(fe,e,t),n(e,ht,t),n(e,b,t),m(_e,b,null),i(b,Ct),i(b,Ie),i(b,$t),i(b,ze),i(b,It),i(b,Ze),i(b,zt),i(b,j),m(ye,j,null),i(j,Zt),i(j,Xe),i(j,Xt),m(R,j,null),i(j,Bt),m(F,j,null),i(b,Wt),i(b,G),m(be,G,null),i(G,Rt),i(G,Be),i(G,Ft),m(x,G,null),n(e,gt,t),m(Me,e,t),n(e,ft,t),n(e,I,t),m(we,I,null),i(I,xt),i(I,V),m(Te,V,null),i(V,Vt),i(V,We),n(e,_t,t),m(ve,e,t),n(e,yt,t),n(e,z,t),m(Je,z,null),i(z,Nt),i(z,N),m(je,N,null),i(N,qt),i(N,Re),n(e,bt,t),m(Ue,e,t),n(e,Mt,t),n(e,Ve,t),wt=!0},p(e,[t]){const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),R.$set(Z);const Pe={};t&2&&(Pe.$$scope={dirty:t,ctx:e}),F.$set(Pe);const ke={};t&2&&(ke.$$scope={dirty:t,ctx:e}),x.$set(ke)},i(e){wt||(u(v.$$.fragment,e),u(H.$$.fragment,e),u(A.$$.fragment,e),u(K.$$.fragment,e),u(oe.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u(fe.$$.fragment,e),u(_e.$$.fragment,e),u(ye.$$.fragment,e),u(R.$$.fragment,e),u(F.$$.fragment,e),u(be.$$.fragment,e),u(x.$$.fragment,e),u(Me.$$.fragment,e),u(we.$$.fragment,e),u(Te.$$.fragment,e),u(ve.$$.fragment,e),u(Je.$$.fragment,e),u(je.$$.fragment,e),u(Ue.$$.fragment,e),wt=!0)},o(e){h(v.$$.fragment,e),h(H.$$.fragment,e),h(A.$$.fragment,e),h(K.$$.fragment,e),h(oe.$$.fragment,e),h(ae.$$.fragment,e),h(re.$$.fragment,e),h(ie.$$.fragment,e),h(pe.$$.fragment,e),h(ce.$$.fragment,e),h(me.$$.fragment,e),h(ue.$$.fragment,e),h(he.$$.fragment,e),h(ge.$$.fragment,e),h(fe.$$.fragment,e),h(_e.$$.fragment,e),h(ye.$$.fragment,e),h(R.$$.fragment,e),h(F.$$.fragment,e),h(be.$$.fragment,e),h(x.$$.fragment,e),h(Me.$$.fragment,e),h(we.$$.fragment,e),h(Te.$$.fragment,e),h(ve.$$.fragment,e),h(Je.$$.fragment,e),h(je.$$.fragment,e),h(Ue.$$.fragment,e),wt=!1},d(e){e&&(o(w),o(_),o(M),o(y),o(J),o(Ne),o(qe),o(Q),o(He),o(E),o(Qe),o(Y),o(Ee),o(S),o(Ye),o(L),o(Se),o(D),o(Le),o(De),o(O),o(Ae),o(Oe),o(ee),o(Ke),o(te),o(et),o(tt),o(ne),o(ot),o(nt),o(se),o(at),o(st),o(le),o(rt),o(lt),o(de),o(it),o(dt),o(pt),o(k),o(ct),o(mt),o($),o(ut),o(ht),o(b),o(gt),o(ft),o(I),o(_t),o(yt),o(z),o(bt),o(Mt),o(Ve)),o(d),g(v,e),g(H,e),g(A,e),g(K,e),g(oe,e),g(ae,e),g(re,e),g(ie,e),g(pe,e),g(ce,e),g(me),g(ue,e),g(he),g(ge),g(fe,e),g(_e),g(ye),g(R),g(F),g(be),g(x),g(Me,e),g(we),g(Te),g(ve,e),g(Je),g(je),g(Ue,e)}}}const ko='{"title":"Pop2Piano","local":"pop2piano","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Examples","local":"examples","sections":[],"depth":2},{"title":"Pop2PianoConfig","local":"transformers.Pop2PianoConfig","sections":[],"depth":2},{"title":"Pop2PianoFeatureExtractor","local":"transformers.models.pop2piano.feature_extraction_pop2piano._LazyModule. getattr . <locals> .Placeholder","sections":[],"depth":2},{"title":"Pop2PianoForConditionalGeneration","local":"transformers.Pop2PianoForConditionalGeneration","sections":[],"depth":2},{"title":"Pop2PianoTokenizer","local":"transformers.models.pop2piano.tokenization_pop2piano._LazyModule. getattr . <locals> .Placeholder","sections":[],"depth":2},{"title":"Pop2PianoProcessor","local":"transformers.models.pop2piano.processing_pop2piano._LazyModule. getattr . <locals> .Placeholder","sections":[],"depth":2}],"depth":1}';function Go(B){return yo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ro extends bo{constructor(d){super(),Mo(this,d,Go,Po,_o,{})}}export{Ro as component};
