import{s as Fn,o as zn,n as Y}from"../chunks/scheduler.18a86fab.js";import{S as Wn,i as Gn,g as m,s as a,r as h,A as Zn,h as p,f as s,c as r,j as R,u,x as y,k as W,y as c,a as l,v as f,d as g,t as b,w as _}from"../chunks/index.98837b22.js";import{T as jt}from"../chunks/Tip.77304350.js";import{D as X}from"../chunks/Docstring.6758ea23.js";import{C as te}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Oe}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as q}from"../chunks/Heading.7e7e0c5b.js";import{E as In}from"../chunks/index.499f366c.js";function Rn(k){let n,M="Example:",i,d,T;return d=new te({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN0YWJsZUxtTW9kZWwlMkMlMjBTdGFibGVMbUNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBTdGFibGVMTSUyMHN0YWJsZWxtLTNiJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFN0YWJsZUxtQ29uZmlnKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> StableLmModel, StableLmConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a StableLM stablelm-3b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = StableLmConfig()`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),h(d.$$.fragment)},l(o){n=p(o,"P",{"data-svelte-h":!0}),y(n)!=="svelte-11lpom8"&&(n.textContent=M),i=r(o),u(d.$$.fragment,o)},m(o,w){l(o,n,w),l(o,i,w),f(d,o,w),T=!0},p:Y,i(o){T||(g(d.$$.fragment,o),T=!0)},o(o){b(d.$$.fragment,o),T=!1},d(o){o&&(s(n),s(i)),_(d,o)}}}function Nn(k){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=p(i,"P",{"data-svelte-h":!0}),y(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,d){l(i,n,d)},p:Y,d(i){i&&s(n)}}}function qn(k){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=p(i,"P",{"data-svelte-h":!0}),y(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,d){l(i,n,d)},p:Y,d(i){i&&s(n)}}}function Vn(k){let n,M="Example:",i,d,T;return d=new te({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTdGFibGVMbUZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBTdGFibGVMbUZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJhZGVwdCUyRnBlcnNpbW1vbi04Yi1iYXNlJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmFkZXB0JTJGcGVyc2ltbW9uLThiLWJhc2UlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyaHVtYW4lM0ElMjBIZXklMkMlMjB3aGF0JTIwc2hvdWxkJTIwSSUyMGVhdCUyMGZvciUyMGRpbm5lciUzRiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzLmlucHV0X2lkcyUyQyUyMG1heF9sZW5ndGglM0QzMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzREZhbHNlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, StableLmForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = StableLmForCausalLM.from_pretrained(<span class="hljs-string">&quot;adept/persimmon-8b-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;adept/persimmon-8b-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;human: Hey, what should I eat for dinner?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;human: Hey, what should I eat for dinner?\\n\\ncat: 🐱\\n\\nhuman: 😐\\n\\n&#x27;</span>`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),h(d.$$.fragment)},l(o){n=p(o,"P",{"data-svelte-h":!0}),y(n)!=="svelte-11lpom8"&&(n.textContent=M),i=r(o),u(d.$$.fragment,o)},m(o,w){l(o,n,w),l(o,i,w),f(d,o,w),T=!0},p:Y,i(o){T||(g(d.$$.fragment,o),T=!0)},o(o){b(d.$$.fragment,o),T=!1},d(o){o&&(s(n),s(i)),_(d,o)}}}function Bn(k){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=p(i,"P",{"data-svelte-h":!0}),y(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,d){l(i,n,d)},p:Y,d(i){i&&s(n)}}}function Xn(k){let n,M="Example of single-label classification:",i,d,T;return d=new te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFN0YWJsZUxtRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlbG0tM2ItNGUxdCUyMiklMEFtb2RlbCUyMCUzRCUyMFN0YWJsZUxtRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGVsbS0zYi00ZTF0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF9jbGFzc19pZCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoKS5pdGVtKCklMEFtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfY2xhc3NfaWQlNUQlMEElMEElMjMlMjBUbyUyMHRyYWluJTIwYSUyMG1vZGVsJTIwb24lMjAlNjBudW1fbGFiZWxzJTYwJTIwY2xhc3NlcyUyQyUyMHlvdSUyMGNhbiUyMHBhc3MlMjAlNjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyU2MCUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCguLi4pJTYwJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbW9kZWwlMjAlM0QlMjBTdGFibGVMbUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlbG0tM2ItNGUxdCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcyUwQXJvdW5kKGxvc3MuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, StableLmForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;stabilityai/stablelm-3b-4e1t&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = StableLmForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;stabilityai/stablelm-3b-4e1t&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.id2label[predicted_class_id]
...

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = StableLmForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;stabilityai/stablelm-3b-4e1t&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
...`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),h(d.$$.fragment)},l(o){n=p(o,"P",{"data-svelte-h":!0}),y(n)!=="svelte-ykxpe4"&&(n.textContent=M),i=r(o),u(d.$$.fragment,o)},m(o,w){l(o,n,w),l(o,i,w),f(d,o,w),T=!0},p:Y,i(o){T||(g(d.$$.fragment,o),T=!0)},o(o){b(d.$$.fragment,o),T=!1},d(o){o&&(s(n),s(i)),_(d,o)}}}function Yn(k){let n,M="Example of multi-label classification:",i,d,T;return d=new te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFN0YWJsZUxtRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlbG0tM2ItNGUxdCUyMiklMEFtb2RlbCUyMCUzRCUyMFN0YWJsZUxtRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGVsbS0zYi00ZTF0JTIyJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkcyUyMCUzRCUyMHRvcmNoLmFyYW5nZSgwJTJDJTIwbG9naXRzLnNoYXBlJTVCLTElNUQpJTVCdG9yY2guc2lnbW9pZChsb2dpdHMpLnNxdWVlemUoZGltJTNEMCklMjAlM0UlMjAwLjUlNUQlMEElMEElMjMlMjBUbyUyMHRyYWluJTIwYSUyMG1vZGVsJTIwb24lMjAlNjBudW1fbGFiZWxzJTYwJTIwY2xhc3NlcyUyQyUyMHlvdSUyMGNhbiUyMHBhc3MlMjAlNjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyU2MCUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCguLi4pJTYwJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbW9kZWwlMjAlM0QlMjBTdGFibGVMbUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlbG0tM2ItNGUxdCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, StableLmForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;stabilityai/stablelm-3b-4e1t&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = StableLmForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;stabilityai/stablelm-3b-4e1t&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = StableLmForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stablelm-3b-4e1t&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),h(d.$$.fragment)},l(o){n=p(o,"P",{"data-svelte-h":!0}),y(n)!=="svelte-1l8e32d"&&(n.textContent=M),i=r(o),u(d.$$.fragment,o)},m(o,w){l(o,n,w),l(o,i,w),f(d,o,w),T=!0},p:Y,i(o){T||(g(d.$$.fragment,o),T=!0)},o(o){b(d.$$.fragment,o),T=!1},d(o){o&&(s(n),s(i)),_(d,o)}}}function Hn(k){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(i){n=p(i,"P",{"data-svelte-h":!0}),y(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(i,d){l(i,n,d)},p:Y,d(i){i&&s(n)}}}function En(k){let n,M="Example:",i,d,T;return d=new te({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTdGFibGVMbUZvclRva2VuQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlbG0tM2ItNGUxdCUyMiklMEFtb2RlbCUyMCUzRCUyMFN0YWJsZUxtRm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGVsbS0zYi00ZTF0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjJIdWdnaW5nRmFjZSUyMGlzJTIwYSUyMGNvbXBhbnklMjBiYXNlZCUyMGluJTIwUGFyaXMlMjBhbmQlMjBOZXclMjBZb3JrJTIyJTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpJTBBJTBBJTIzJTIwTm90ZSUyMHRoYXQlMjB0b2tlbnMlMjBhcmUlMjBjbGFzc2lmaWVkJTIwcmF0aGVyJTIwdGhlbiUyMGlucHV0JTIwd29yZHMlMjB3aGljaCUyMG1lYW5zJTIwdGhhdCUwQSUyMyUyMHRoZXJlJTIwbWlnaHQlMjBiZSUyMG1vcmUlMjBwcmVkaWN0ZWQlMjB0b2tlbiUyMGNsYXNzZXMlMjB0aGFuJTIwd29yZHMuJTBBJTIzJTIwTXVsdGlwbGUlMjB0b2tlbiUyMGNsYXNzZXMlMjBtaWdodCUyMGFjY291bnQlMjBmb3IlMjB0aGUlMjBzYW1lJTIwd29yZCUwQXByZWRpY3RlZF90b2tlbnNfY2xhc3NlcyUyMCUzRCUyMCU1Qm1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnQuaXRlbSgpJTVEJTIwZm9yJTIwdCUyMGluJTIwcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyU1QjAlNUQlNUQlMEFwcmVkaWN0ZWRfdG9rZW5zX2NsYXNzZXMlMEElMEFsYWJlbHMlMjAlM0QlMjBwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTBBbG9zcyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKS5sb3NzJTBBcm91bmQobG9zcy5pdGVtKCklMkMlMjAyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, StableLmForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;stabilityai/stablelm-3b-4e1t&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = StableLmForTokenClassification.from_pretrained(<span class="hljs-string">&quot;stabilityai/stablelm-3b-4e1t&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes
...

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
...`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,i=a(),h(d.$$.fragment)},l(o){n=p(o,"P",{"data-svelte-h":!0}),y(n)!=="svelte-11lpom8"&&(n.textContent=M),i=r(o),u(d.$$.fragment,o)},m(o,w){l(o,n,w),l(o,i,w),f(d,o,w),T=!0},p:Y,i(o){T||(g(d.$$.fragment,o),T=!0)},o(o){b(d.$$.fragment,o),T=!1},d(o){o&&(s(n),s(i)),_(d,o)}}}function Qn(k){let n,M,i,d,T,o,w,an='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Ke,ne,et,oe,rn='<code>StableLM 3B 4E1T</code> was proposed in <a href="https://stability.wandb.io/stability-llm/stable-lm/reports/StableLM-3B-4E1T--VmlldzoyMjU4?accessToken=u3zujipenkx5g7rtcj9qojjgxpconyjktjkli2po09nffrffdhhchq045vp0wyfo" rel="nofollow"><code>StableLM 3B 4E1T</code>: Technical Report</a> by Stability AI and is the first model in a series of multi-epoch pre-trained language models.',tt,se,nt,ae,ln=`<code>StableLM 3B 4E1T</code> is a decoder-only base language model pre-trained on 1 trillion tokens of diverse English and code datasets for four epochs.
The model architecture is transformer-based with partial Rotary Position Embeddings, SwiGLU activation, LayerNorm, etc.`,ot,re,dn="We also provide <code>StableLM Zephyr 3B</code>, an instruction fine-tuned version of the model that can be used for chat-based applications.",st,le,at,ie,cn='<li>The architecture is similar to LLaMA but with RoPE applied to 25% of head embedding dimensions, LayerNorm instead of RMSNorm, and optional QKV bias terms.</li> <li><code>StableLM 3B 4E1T</code>-based models uses the same tokenizer as <a href="/docs/transformers/main/en/model_doc/gpt_neox#transformers.GPTNeoXTokenizerFast">GPTNeoXTokenizerFast</a>.</li>',rt,de,mn='<code>StableLM 3B 4E1T</code> and <code>StableLM Zephyr 3B</code> can be found on the <a href="https://huggingface.co/stabilityai" rel="nofollow">Huggingface Hub</a>',lt,ce,pn="The following code snippet demonstrates how to use <code>StableLM 3B 4E1T</code> for inference:",it,me,dt,pe,ct,he,hn="First, make sure to install the latest version of Flash Attention v2.",mt,ue,pt,fe,un='Also make sure that your hardware is compatible with Flash-Attention 2. Read more about it in the official documentation of the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow"><code>flash-attn</code></a> repository. Note: you must load your model in half-precision (e.g. <code>torch.bfloat16</code>).',ht,ge,fn="Now, to run the model with Flash Attention 2, refer to the snippet below:",ut,be,ft,_e,gt,L,ye,Lt,ze,gn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmModel">~StableLmModel</a>.
It is used to instantiate an StableLM model according to the specified arguments, defining the model
architecture. Instantiating a configuration with the defaults will yield a similar configuration to that of
the StableLM <a href="https://huggingface.co/stabilityai/stablelm-3b-4e1t" rel="nofollow">stabilityai/stablelm-3b-4e1t</a> architecture.`,Ut,We,bn=`Configuration objects inherit from  <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used
to control the model outputs. Read the documentation from  <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>
for more information.`,Jt,H,bt,Te,_t,$,Me,St,Ge,_n="The bare Stablelm Model outputting raw hidden-states without any specific head on top.",Ft,Ze,yn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,zt,Ie,Tn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Wt,N,we,Gt,Re,Mn='The <a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmModel">StableLmModel</a> forward method, overrides the <code>__call__</code> special method.',Zt,E,yt,ke,Tt,V,ve,It,F,Ce,Rt,Ne,wn='The <a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmForCausalLM">StableLmForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Nt,Q,qt,P,Mt,$e,wt,v,xe,Vt,qe,kn="The StableLm transformer with a sequence classification head on top (linear layer).",Bt,Ve,vn=`<a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmForSequenceClassification">StableLmForSequenceClassification</a> uses the last token in order to do the classification, as other causal
models (e.g. GPT-2) do.`,Xt,Be,Cn=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,Yt,Xe,$n=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ht,Ye,xn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Et,j,je,Qt,He,jn='The <a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmForSequenceClassification">StableLmForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Pt,A,At,D,Dt,O,kt,Le,vt,x,Ue,Ot,Ee,Ln=`The Stablelm transformer with a token classification head on top (a linear layer on top of the hidden-states
output) e.g. for Named-Entity-Recognition (NER) tasks.`,Kt,Qe,Un=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,en,Pe,Jn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,tn,z,Je,nn,Ae,Sn='The <a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmForTokenClassification">StableLmForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',on,K,sn,ee,Ct,Se,$t,De,xt;return T=new q({props:{title:"StableLM",local:"stablelm",headingTag:"h1"}}),ne=new q({props:{title:"Overview",local:"overview",headingTag:"h2"}}),se=new q({props:{title:"Model Details",local:"model-details",headingTag:"h3"}}),le=new q({props:{title:"Usage Tips",local:"usage-tips",headingTag:"h3"}}),me=new te({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMHNldF9zZWVkJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMCUyMyUyMHRoZSUyMGRldmljZSUyMHRvJTIwbG9hZCUyMHRoZSUyMG1vZGVsJTIwb250byUwQSUwQXNldF9zZWVkKDApJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGVsbS0zYi00ZTF0JTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlbG0tM2ItNGUxdCUyMiklMEFtb2RlbC50byhkZXZpY2UpJTBBbW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMHdlYXRoZXIlMjBpcyUyMGFsd2F5cyUyMHdvbmRlcmZ1bCUyMGluJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8obW9kZWwuZGV2aWNlKSUwQSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMG1heF9sZW5ndGglM0QzMiUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBcmVzcG9uc2VzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcmVzcG9uc2Vz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-comment"># the device to load the model onto</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;stabilityai/stablelm-3b-4e1t&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;stabilityai/stablelm-3b-4e1t&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(<span class="hljs-string">&quot;The weather is always wonderful in&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_length=<span class="hljs-number">32</span>, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>responses = tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>responses
[<span class="hljs-string">&#x27;The weather is always wonderful in Costa Rica, which makes it a prime destination for retirees. That’s where the Pensionado program comes in, offering&#x27;</span>]`,wrap:!1}}),pe=new q({props:{title:"Combining StableLM and Flash Attention 2",local:"combining-stablelm-and-flash-attention-2",headingTag:"h2"}}),ue=new te({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0biUyMC0tbm8tYnVpbGQtaXNvbGF0aW9u",highlighted:"pip install -U flash-attn --no-build-isolation",wrap:!1}}),be=new te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTJDJTIwc2V0X3NlZWQlMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTIwJTIzJTIwdGhlJTIwZGV2aWNlJTIwdG8lMjBsb2FkJTIwdGhlJTIwbW9kZWwlMjBvbnRvJTBBJTBBc2V0X3NlZWQoMCklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZWxtLTNiLTRlMXQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGVsbS0zYi00ZTF0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMiklMEFtb2RlbC50byhkZXZpY2UpJTBBbW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMHdlYXRoZXIlMjBpcyUyMGFsd2F5cyUyMHdvbmRlcmZ1bCUyMGluJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8obW9kZWwuZGV2aWNlKSUwQSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMG1heF9sZW5ndGglM0QzMiUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBcmVzcG9uc2VzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcmVzcG9uc2Vz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-comment"># the device to load the model onto</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;stabilityai/stablelm-3b-4e1t&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;stabilityai/stablelm-3b-4e1t&quot;</span>, torch_dtype=torch.bfloat16, attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(<span class="hljs-string">&quot;The weather is always wonderful in&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_length=<span class="hljs-number">32</span>, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>responses = tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>responses
[<span class="hljs-string">&#x27;The weather is always wonderful in Costa Rica, which makes it a prime destination for retirees. That’s where the Pensionado program comes in, offering&#x27;</span>]`,wrap:!1}}),_e=new q({props:{title:"StableLmConfig",local:"transformers.StableLmConfig",headingTag:"h2"}}),ye=new X({props:{name:"class transformers.StableLmConfig",anchor:"transformers.StableLmConfig",parameters:[{name:"vocab_size",val:" = 50304"},{name:"intermediate_size",val:" = 6912"},{name:"hidden_size",val:" = 2560"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 32"},{name:"num_key_value_heads",val:" = 32"},{name:"hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 4096"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 10000"},{name:"rope_scaling",val:" = None"},{name:"use_qkv_bias",val:" = False"},{name:"qk_layernorm",val:" = False"},{name:"use_parallel_residual",val:" = False"},{name:"hidden_dropout",val:" = 0.0"},{name:"attention_dropout",val:" = 0.0"},{name:"partial_rotary_factor",val:" = 0.25"},{name:"bos_token_id",val:" = 0"},{name:"eos_token_id",val:" = 0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StableLmConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 50304) &#x2014;
Vocabulary size of the StableLM model. Defines the number of different tokens that
can be represented by the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmModel">StableLmModel</a>.`,name:"vocab_size"},{anchor:"transformers.StableLmConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 6912) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.StableLmConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2560) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"hidden_size"},{anchor:"transformers.StableLmConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.StableLmConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.StableLmConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to
<code>num_attention_heads</code>.`,name:"num_key_value_heads"},{anchor:"transformers.StableLmConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string).`,name:"hidden_act"},{anchor:"transformers.StableLmConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
The maximum sequence length that this model might ever be used with.
Typically set this to something large just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.StableLmConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing
all weight matrices.`,name:"initializer_range"},{anchor:"transformers.StableLmConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.StableLmConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions
(not used by all models). Only relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.StableLmConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied.`,name:"tie_word_embeddings"},{anchor:"transformers.StableLmConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to <code>10000.0</code>) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.StableLmConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. NOTE: if you apply new rope type
and you expect the model to work on longer <code>max_position_embeddings</code>, we recommend you to update this value
accordingly.
Expected contents:
<code>rope_type</code> (<code>str</code>):
The sub-variant of RoPE to use. Can be one of [&#x2018;default&#x2019;, &#x2018;linear&#x2019;, &#x2018;dynamic&#x2019;, &#x2018;yarn&#x2019;, &#x2018;longrope&#x2019;,
&#x2018;llama3&#x2019;], with &#x2018;default&#x2019; being the original RoPE implementation.
<code>factor</code> (<code>float</code>, <em>optional</em>):
Used with all rope types except &#x2018;default&#x2019;. The scaling factor to apply to the RoPE embeddings. In
most scaling types, a <code>factor</code> of x will enable the model to handle sequences of length x <em>
original maximum pre-trained length.
<code>original_max_position_embeddings</code> (<code>int</code>, </em>optional<em>):
Used with &#x2018;dynamic&#x2019;, &#x2018;longrope&#x2019; and &#x2018;llama3&#x2019;. The original max position embeddings used during
pretraining.
<code>attention_factor</code> (<code>float</code>, </em>optional<em>):
Used with &#x2018;yarn&#x2019; and &#x2018;longrope&#x2019;. The scaling factor to be applied on the attention
computation. If unspecified, it defaults to value recommended by the implementation, using the
<code>factor</code> field to infer the suggested value.
<code>beta_fast</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for extrapolation (only) in the linear
ramp function. If unspecified, it defaults to 32.
<code>beta_slow</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for interpolation (only) in the linear
ramp function. If unspecified, it defaults to 1.
<code>short_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to short contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>long_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to long contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>low_freq_factor</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to low frequency components of the RoPE
<code>high_freq_factor</code> (<code>float</code>, </em>optional*):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to high frequency components of the RoPE`,name:"rope_scaling"},{anchor:"transformers.StableLmConfig.use_qkv_bias",description:`<strong>use_qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the model should use bias for qkv layers.`,name:"use_qkv_bias"},{anchor:"transformers.StableLmConfig.qk_layernorm",description:`<strong>qk_layernorm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to normalize, per head, the Queries and Keys after projecting the hidden states.`,name:"qk_layernorm"},{anchor:"transformers.StableLmConfig.use_parallel_residual",description:`<strong>use_parallel_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a &#x201C;parallel&#x201D; formulation in each Transformer layer, which can provide a slight training
speedup at large scales.`,name:"use_parallel_residual"},{anchor:"transformers.StableLmConfig.hidden_dropout",description:`<strong>hidden_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio after applying the MLP to the hidden states.`,name:"hidden_dropout"},{anchor:"transformers.StableLmConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.StableLmConfig.partial_rotary_factor",description:`<strong>partial_rotary_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.25) &#x2014;
Percentage of the query and keys which will have rotary embedding.`,name:"partial_rotary_factor"},{anchor:"transformers.StableLmConfig.bos_token_id",description:`<strong>bos_token_id</strong> (int, <em>optional</em>, defaults to 0) &#x2014;
The id of the <code>BOS</code> token in the vocabulary.`,name:"bos_token_id"},{anchor:"transformers.StableLmConfig.eos_token_id",description:`<strong>eos_token_id</strong> (int, <em>optional</em>, defaults to 0) &#x2014;
The id of the <code>EOS</code> token in the vocabulary.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/stablelm/configuration_stablelm.py#L25"}}),H=new Oe({props:{anchor:"transformers.StableLmConfig.example",$$slots:{default:[Rn]},$$scope:{ctx:k}}}),Te=new q({props:{title:"StableLmModel",local:"transformers.StableLmModel",headingTag:"h2"}}),Me=new X({props:{name:"class transformers.StableLmModel",anchor:"transformers.StableLmModel",parameters:[{name:"config",val:": StableLmConfig"}],parametersDescription:[{anchor:"transformers.StableLmModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmConfig">StableLmConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/stablelm/modeling_stablelm.py#L642"}}),we=new X({props:{name:"forward",anchor:"transformers.StableLmModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.StableLmModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StableLmModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.StableLmModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.StableLmModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.StableLmModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.StableLmModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.StableLmModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.StableLmModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.StableLmModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/stablelm/modeling_stablelm.py#L674",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmConfig"
>StableLmConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),E=new jt({props:{$$slots:{default:[Nn]},$$scope:{ctx:k}}}),ke=new q({props:{title:"StableLmForCausalLM",local:"transformers.StableLmForCausalLM",headingTag:"h2"}}),ve=new X({props:{name:"class transformers.StableLmForCausalLM",anchor:"transformers.StableLmForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/stablelm/modeling_stablelm.py#L923"}}),Ce=new X({props:{name:"forward",anchor:"transformers.StableLmForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StableLmForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StableLmForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.StableLmForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.StableLmForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.StableLmForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.StableLmForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.StableLmForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.StableLmForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.StableLmForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.StableLmForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.StableLmForCausalLM.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/stablelm/modeling_stablelm.py#L960",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmConfig"
>StableLmConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Q=new jt({props:{$$slots:{default:[qn]},$$scope:{ctx:k}}}),P=new Oe({props:{anchor:"transformers.StableLmForCausalLM.forward.example",$$slots:{default:[Vn]},$$scope:{ctx:k}}}),$e=new q({props:{title:"StableLmForSequenceClassification",local:"transformers.StableLmForSequenceClassification",headingTag:"h2"}}),xe=new X({props:{name:"class transformers.StableLmForSequenceClassification",anchor:"transformers.StableLmForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.StableLmForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmForSequenceClassification">StableLmForSequenceClassification</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/stablelm/modeling_stablelm.py#L1042"}}),je=new X({props:{name:"forward",anchor:"transformers.StableLmForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.StableLmForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StableLmForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.StableLmForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.StableLmForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.StableLmForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.StableLmForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.StableLmForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.StableLmForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.StableLmForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/stablelm/modeling_stablelm.py#L1073",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmConfig"
>StableLmConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new jt({props:{$$slots:{default:[Bn]},$$scope:{ctx:k}}}),D=new Oe({props:{anchor:"transformers.StableLmForSequenceClassification.forward.example",$$slots:{default:[Xn]},$$scope:{ctx:k}}}),O=new Oe({props:{anchor:"transformers.StableLmForSequenceClassification.forward.example-2",$$slots:{default:[Yn]},$$scope:{ctx:k}}}),Le=new q({props:{title:"StableLmForTokenClassification",local:"transformers.StableLmForTokenClassification",headingTag:"h2"}}),Ue=new X({props:{name:"class transformers.StableLmForTokenClassification",anchor:"transformers.StableLmForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.StableLmForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmForTokenClassification">StableLmForTokenClassification</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/stablelm/modeling_stablelm.py#L1143"}}),Je=new X({props:{name:"forward",anchor:"transformers.StableLmForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.StableLmForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StableLmForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.StableLmForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.StableLmForTokenClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.StableLmForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.StableLmForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.StableLmForTokenClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.StableLmForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.StableLmForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/stablelm/modeling_stablelm.py#L1168",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/stablelm#transformers.StableLmConfig"
>StableLmConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),K=new jt({props:{$$slots:{default:[Hn]},$$scope:{ctx:k}}}),ee=new Oe({props:{anchor:"transformers.StableLmForTokenClassification.forward.example",$$slots:{default:[En]},$$scope:{ctx:k}}}),Se=new In({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/stablelm.md"}}),{c(){n=m("meta"),M=a(),i=m("p"),d=a(),h(T.$$.fragment),o=a(),w=m("div"),w.innerHTML=an,Ke=a(),h(ne.$$.fragment),et=a(),oe=m("p"),oe.innerHTML=rn,tt=a(),h(se.$$.fragment),nt=a(),ae=m("p"),ae.innerHTML=ln,ot=a(),re=m("p"),re.innerHTML=dn,st=a(),h(le.$$.fragment),at=a(),ie=m("ul"),ie.innerHTML=cn,rt=a(),de=m("p"),de.innerHTML=mn,lt=a(),ce=m("p"),ce.innerHTML=pn,it=a(),h(me.$$.fragment),dt=a(),h(pe.$$.fragment),ct=a(),he=m("p"),he.textContent=hn,mt=a(),h(ue.$$.fragment),pt=a(),fe=m("p"),fe.innerHTML=un,ht=a(),ge=m("p"),ge.textContent=fn,ut=a(),h(be.$$.fragment),ft=a(),h(_e.$$.fragment),gt=a(),L=m("div"),h(ye.$$.fragment),Lt=a(),ze=m("p"),ze.innerHTML=gn,Ut=a(),We=m("p"),We.innerHTML=bn,Jt=a(),h(H.$$.fragment),bt=a(),h(Te.$$.fragment),_t=a(),$=m("div"),h(Me.$$.fragment),St=a(),Ge=m("p"),Ge.textContent=_n,Ft=a(),Ze=m("p"),Ze.innerHTML=yn,zt=a(),Ie=m("p"),Ie.innerHTML=Tn,Wt=a(),N=m("div"),h(we.$$.fragment),Gt=a(),Re=m("p"),Re.innerHTML=Mn,Zt=a(),h(E.$$.fragment),yt=a(),h(ke.$$.fragment),Tt=a(),V=m("div"),h(ve.$$.fragment),It=a(),F=m("div"),h(Ce.$$.fragment),Rt=a(),Ne=m("p"),Ne.innerHTML=wn,Nt=a(),h(Q.$$.fragment),qt=a(),h(P.$$.fragment),Mt=a(),h($e.$$.fragment),wt=a(),v=m("div"),h(xe.$$.fragment),Vt=a(),qe=m("p"),qe.textContent=kn,Bt=a(),Ve=m("p"),Ve.innerHTML=vn,Xt=a(),Be=m("p"),Be.innerHTML=Cn,Yt=a(),Xe=m("p"),Xe.innerHTML=$n,Ht=a(),Ye=m("p"),Ye.innerHTML=xn,Et=a(),j=m("div"),h(je.$$.fragment),Qt=a(),He=m("p"),He.innerHTML=jn,Pt=a(),h(A.$$.fragment),At=a(),h(D.$$.fragment),Dt=a(),h(O.$$.fragment),kt=a(),h(Le.$$.fragment),vt=a(),x=m("div"),h(Ue.$$.fragment),Ot=a(),Ee=m("p"),Ee.textContent=Ln,Kt=a(),Qe=m("p"),Qe.innerHTML=Un,en=a(),Pe=m("p"),Pe.innerHTML=Jn,tn=a(),z=m("div"),h(Je.$$.fragment),nn=a(),Ae=m("p"),Ae.innerHTML=Sn,on=a(),h(K.$$.fragment),sn=a(),h(ee.$$.fragment),Ct=a(),h(Se.$$.fragment),$t=a(),De=m("p"),this.h()},l(e){const t=Zn("svelte-u9bgzb",document.head);n=p(t,"META",{name:!0,content:!0}),t.forEach(s),M=r(e),i=p(e,"P",{}),R(i).forEach(s),d=r(e),u(T.$$.fragment,e),o=r(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),y(w)!=="svelte-b95w5j"&&(w.innerHTML=an),Ke=r(e),u(ne.$$.fragment,e),et=r(e),oe=p(e,"P",{"data-svelte-h":!0}),y(oe)!=="svelte-p70wk3"&&(oe.innerHTML=rn),tt=r(e),u(se.$$.fragment,e),nt=r(e),ae=p(e,"P",{"data-svelte-h":!0}),y(ae)!=="svelte-13e6wpg"&&(ae.innerHTML=ln),ot=r(e),re=p(e,"P",{"data-svelte-h":!0}),y(re)!=="svelte-ecv3xy"&&(re.innerHTML=dn),st=r(e),u(le.$$.fragment,e),at=r(e),ie=p(e,"UL",{"data-svelte-h":!0}),y(ie)!=="svelte-1lxeakf"&&(ie.innerHTML=cn),rt=r(e),de=p(e,"P",{"data-svelte-h":!0}),y(de)!=="svelte-1a9jefj"&&(de.innerHTML=mn),lt=r(e),ce=p(e,"P",{"data-svelte-h":!0}),y(ce)!=="svelte-udtc57"&&(ce.innerHTML=pn),it=r(e),u(me.$$.fragment,e),dt=r(e),u(pe.$$.fragment,e),ct=r(e),he=p(e,"P",{"data-svelte-h":!0}),y(he)!=="svelte-pstkbw"&&(he.textContent=hn),mt=r(e),u(ue.$$.fragment,e),pt=r(e),fe=p(e,"P",{"data-svelte-h":!0}),y(fe)!=="svelte-8b9qy3"&&(fe.innerHTML=un),ht=r(e),ge=p(e,"P",{"data-svelte-h":!0}),y(ge)!=="svelte-1w2ttra"&&(ge.textContent=fn),ut=r(e),u(be.$$.fragment,e),ft=r(e),u(_e.$$.fragment,e),gt=r(e),L=p(e,"DIV",{class:!0});var G=R(L);u(ye.$$.fragment,G),Lt=r(G),ze=p(G,"P",{"data-svelte-h":!0}),y(ze)!=="svelte-m2vol3"&&(ze.innerHTML=gn),Ut=r(G),We=p(G,"P",{"data-svelte-h":!0}),y(We)!=="svelte-thm8xj"&&(We.innerHTML=bn),Jt=r(G),u(H.$$.fragment,G),G.forEach(s),bt=r(e),u(Te.$$.fragment,e),_t=r(e),$=p(e,"DIV",{class:!0});var U=R($);u(Me.$$.fragment,U),St=r(U),Ge=p(U,"P",{"data-svelte-h":!0}),y(Ge)!=="svelte-o412yk"&&(Ge.textContent=_n),Ft=r(U),Ze=p(U,"P",{"data-svelte-h":!0}),y(Ze)!=="svelte-6pahdo"&&(Ze.innerHTML=yn),zt=r(U),Ie=p(U,"P",{"data-svelte-h":!0}),y(Ie)!=="svelte-hswkmf"&&(Ie.innerHTML=Tn),Wt=r(U),N=p(U,"DIV",{class:!0});var B=R(N);u(we.$$.fragment,B),Gt=r(B),Re=p(B,"P",{"data-svelte-h":!0}),y(Re)!=="svelte-nx0vhf"&&(Re.innerHTML=Mn),Zt=r(B),u(E.$$.fragment,B),B.forEach(s),U.forEach(s),yt=r(e),u(ke.$$.fragment,e),Tt=r(e),V=p(e,"DIV",{class:!0});var Fe=R(V);u(ve.$$.fragment,Fe),It=r(Fe),F=p(Fe,"DIV",{class:!0});var Z=R(F);u(Ce.$$.fragment,Z),Rt=r(Z),Ne=p(Z,"P",{"data-svelte-h":!0}),y(Ne)!=="svelte-jv1ouv"&&(Ne.innerHTML=wn),Nt=r(Z),u(Q.$$.fragment,Z),qt=r(Z),u(P.$$.fragment,Z),Z.forEach(s),Fe.forEach(s),Mt=r(e),u($e.$$.fragment,e),wt=r(e),v=p(e,"DIV",{class:!0});var C=R(v);u(xe.$$.fragment,C),Vt=r(C),qe=p(C,"P",{"data-svelte-h":!0}),y(qe)!=="svelte-1r4bxkh"&&(qe.textContent=kn),Bt=r(C),Ve=p(C,"P",{"data-svelte-h":!0}),y(Ve)!=="svelte-y2qvum"&&(Ve.innerHTML=vn),Xt=r(C),Be=p(C,"P",{"data-svelte-h":!0}),y(Be)!=="svelte-10ugs3m"&&(Be.innerHTML=Cn),Yt=r(C),Xe=p(C,"P",{"data-svelte-h":!0}),y(Xe)!=="svelte-6pahdo"&&(Xe.innerHTML=$n),Ht=r(C),Ye=p(C,"P",{"data-svelte-h":!0}),y(Ye)!=="svelte-hswkmf"&&(Ye.innerHTML=xn),Et=r(C),j=p(C,"DIV",{class:!0});var J=R(j);u(je.$$.fragment,J),Qt=r(J),He=p(J,"P",{"data-svelte-h":!0}),y(He)!=="svelte-3mka3v"&&(He.innerHTML=jn),Pt=r(J),u(A.$$.fragment,J),At=r(J),u(D.$$.fragment,J),Dt=r(J),u(O.$$.fragment,J),J.forEach(s),C.forEach(s),kt=r(e),u(Le.$$.fragment,e),vt=r(e),x=p(e,"DIV",{class:!0});var S=R(x);u(Ue.$$.fragment,S),Ot=r(S),Ee=p(S,"P",{"data-svelte-h":!0}),y(Ee)!=="svelte-1xf90h8"&&(Ee.textContent=Ln),Kt=r(S),Qe=p(S,"P",{"data-svelte-h":!0}),y(Qe)!=="svelte-6pahdo"&&(Qe.innerHTML=Un),en=r(S),Pe=p(S,"P",{"data-svelte-h":!0}),y(Pe)!=="svelte-hswkmf"&&(Pe.innerHTML=Jn),tn=r(S),z=p(S,"DIV",{class:!0});var I=R(z);u(Je.$$.fragment,I),nn=r(I),Ae=p(I,"P",{"data-svelte-h":!0}),y(Ae)!=="svelte-1eo2jtv"&&(Ae.innerHTML=Sn),on=r(I),u(K.$$.fragment,I),sn=r(I),u(ee.$$.fragment,I),I.forEach(s),S.forEach(s),Ct=r(e),u(Se.$$.fragment,e),$t=r(e),De=p(e,"P",{}),R(De).forEach(s),this.h()},h(){W(n,"name","hf:doc:metadata"),W(n,"content",Pn),W(w,"class","flex flex-wrap space-x-1"),W(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,n),l(e,M,t),l(e,i,t),l(e,d,t),f(T,e,t),l(e,o,t),l(e,w,t),l(e,Ke,t),f(ne,e,t),l(e,et,t),l(e,oe,t),l(e,tt,t),f(se,e,t),l(e,nt,t),l(e,ae,t),l(e,ot,t),l(e,re,t),l(e,st,t),f(le,e,t),l(e,at,t),l(e,ie,t),l(e,rt,t),l(e,de,t),l(e,lt,t),l(e,ce,t),l(e,it,t),f(me,e,t),l(e,dt,t),f(pe,e,t),l(e,ct,t),l(e,he,t),l(e,mt,t),f(ue,e,t),l(e,pt,t),l(e,fe,t),l(e,ht,t),l(e,ge,t),l(e,ut,t),f(be,e,t),l(e,ft,t),f(_e,e,t),l(e,gt,t),l(e,L,t),f(ye,L,null),c(L,Lt),c(L,ze),c(L,Ut),c(L,We),c(L,Jt),f(H,L,null),l(e,bt,t),f(Te,e,t),l(e,_t,t),l(e,$,t),f(Me,$,null),c($,St),c($,Ge),c($,Ft),c($,Ze),c($,zt),c($,Ie),c($,Wt),c($,N),f(we,N,null),c(N,Gt),c(N,Re),c(N,Zt),f(E,N,null),l(e,yt,t),f(ke,e,t),l(e,Tt,t),l(e,V,t),f(ve,V,null),c(V,It),c(V,F),f(Ce,F,null),c(F,Rt),c(F,Ne),c(F,Nt),f(Q,F,null),c(F,qt),f(P,F,null),l(e,Mt,t),f($e,e,t),l(e,wt,t),l(e,v,t),f(xe,v,null),c(v,Vt),c(v,qe),c(v,Bt),c(v,Ve),c(v,Xt),c(v,Be),c(v,Yt),c(v,Xe),c(v,Ht),c(v,Ye),c(v,Et),c(v,j),f(je,j,null),c(j,Qt),c(j,He),c(j,Pt),f(A,j,null),c(j,At),f(D,j,null),c(j,Dt),f(O,j,null),l(e,kt,t),f(Le,e,t),l(e,vt,t),l(e,x,t),f(Ue,x,null),c(x,Ot),c(x,Ee),c(x,Kt),c(x,Qe),c(x,en),c(x,Pe),c(x,tn),c(x,z),f(Je,z,null),c(z,nn),c(z,Ae),c(z,on),f(K,z,null),c(z,sn),f(ee,z,null),l(e,Ct,t),f(Se,e,t),l(e,$t,t),l(e,De,t),xt=!0},p(e,[t]){const G={};t&2&&(G.$$scope={dirty:t,ctx:e}),H.$set(G);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),E.$set(U);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),Q.$set(B);const Fe={};t&2&&(Fe.$$scope={dirty:t,ctx:e}),P.$set(Fe);const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),A.$set(Z);const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),D.$set(C);const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),O.$set(J);const S={};t&2&&(S.$$scope={dirty:t,ctx:e}),K.$set(S);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),ee.$set(I)},i(e){xt||(g(T.$$.fragment,e),g(ne.$$.fragment,e),g(se.$$.fragment,e),g(le.$$.fragment,e),g(me.$$.fragment,e),g(pe.$$.fragment,e),g(ue.$$.fragment,e),g(be.$$.fragment,e),g(_e.$$.fragment,e),g(ye.$$.fragment,e),g(H.$$.fragment,e),g(Te.$$.fragment,e),g(Me.$$.fragment,e),g(we.$$.fragment,e),g(E.$$.fragment,e),g(ke.$$.fragment,e),g(ve.$$.fragment,e),g(Ce.$$.fragment,e),g(Q.$$.fragment,e),g(P.$$.fragment,e),g($e.$$.fragment,e),g(xe.$$.fragment,e),g(je.$$.fragment,e),g(A.$$.fragment,e),g(D.$$.fragment,e),g(O.$$.fragment,e),g(Le.$$.fragment,e),g(Ue.$$.fragment,e),g(Je.$$.fragment,e),g(K.$$.fragment,e),g(ee.$$.fragment,e),g(Se.$$.fragment,e),xt=!0)},o(e){b(T.$$.fragment,e),b(ne.$$.fragment,e),b(se.$$.fragment,e),b(le.$$.fragment,e),b(me.$$.fragment,e),b(pe.$$.fragment,e),b(ue.$$.fragment,e),b(be.$$.fragment,e),b(_e.$$.fragment,e),b(ye.$$.fragment,e),b(H.$$.fragment,e),b(Te.$$.fragment,e),b(Me.$$.fragment,e),b(we.$$.fragment,e),b(E.$$.fragment,e),b(ke.$$.fragment,e),b(ve.$$.fragment,e),b(Ce.$$.fragment,e),b(Q.$$.fragment,e),b(P.$$.fragment,e),b($e.$$.fragment,e),b(xe.$$.fragment,e),b(je.$$.fragment,e),b(A.$$.fragment,e),b(D.$$.fragment,e),b(O.$$.fragment,e),b(Le.$$.fragment,e),b(Ue.$$.fragment,e),b(Je.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(Se.$$.fragment,e),xt=!1},d(e){e&&(s(M),s(i),s(d),s(o),s(w),s(Ke),s(et),s(oe),s(tt),s(nt),s(ae),s(ot),s(re),s(st),s(at),s(ie),s(rt),s(de),s(lt),s(ce),s(it),s(dt),s(ct),s(he),s(mt),s(pt),s(fe),s(ht),s(ge),s(ut),s(ft),s(gt),s(L),s(bt),s(_t),s($),s(yt),s(Tt),s(V),s(Mt),s(wt),s(v),s(kt),s(vt),s(x),s(Ct),s($t),s(De)),s(n),_(T,e),_(ne,e),_(se,e),_(le,e),_(me,e),_(pe,e),_(ue,e),_(be,e),_(_e,e),_(ye),_(H),_(Te,e),_(Me),_(we),_(E),_(ke,e),_(ve),_(Ce),_(Q),_(P),_($e,e),_(xe),_(je),_(A),_(D),_(O),_(Le,e),_(Ue),_(Je),_(K),_(ee),_(Se,e)}}}const Pn='{"title":"StableLM","local":"stablelm","sections":[{"title":"Overview","local":"overview","sections":[{"title":"Model Details","local":"model-details","sections":[],"depth":3},{"title":"Usage Tips","local":"usage-tips","sections":[],"depth":3}],"depth":2},{"title":"Combining StableLM and Flash Attention 2","local":"combining-stablelm-and-flash-attention-2","sections":[],"depth":2},{"title":"StableLmConfig","local":"transformers.StableLmConfig","sections":[],"depth":2},{"title":"StableLmModel","local":"transformers.StableLmModel","sections":[],"depth":2},{"title":"StableLmForCausalLM","local":"transformers.StableLmForCausalLM","sections":[],"depth":2},{"title":"StableLmForSequenceClassification","local":"transformers.StableLmForSequenceClassification","sections":[],"depth":2},{"title":"StableLmForTokenClassification","local":"transformers.StableLmForTokenClassification","sections":[],"depth":2}],"depth":1}';function An(k){return zn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ao extends Wn{constructor(n){super(),Gn(this,n,An,Qn,Fn,{})}}export{ao as component};
