import{s as Tt,n as bt,o as gt}from"../chunks/scheduler.18a86fab.js";import{S as Ut,i as Jt,g as o,s as l,r as I,A as jt,h as r,f as a,c as s,j as Mt,u as B,x as i,k as yt,y as Wt,a as n,v as Q,d as v,t as Z,w as _}from"../chunks/index.98837b22.js";import{C as wt}from"../chunks/CodeBlock.8d0c2e8a.js";import{H as nt}from"../chunks/Heading.7e7e0c5b.js";import{E as kt}from"../chunks/index.499f366c.js";function Gt(lt){let p,F,$,C,d,q,u,st='<a href="https://quark.docs.amd.com/latest/" rel="nofollow">Quark</a> is a deep learning quantization toolkit designed to be agnostic to specific data types, algorithms, and hardware. Different pre-processing strategies, algorithms and data-types can be combined in Quark.',x,m,ot='The PyTorch support integrated through 🤗 Transformers primarily targets AMD CPUs and GPUs, and is primarily meant to be used for evaluation purposes. For example, it is possible to use <a href="https://github.com/EleutherAI/lm-evaluation-harness" rel="nofollow">lm-evaluation-harness</a> with 🤗 Transformers backend and evaluate a wide range of models quantized through Quark seamlessly.',H,c,rt='Users interested in Quark can refer to its <a href="https://quark.docs.amd.com/latest/" rel="nofollow">documentation</a> to get started quantizing models and using them in supported open-source libraries!',S,h,it='Although Quark has its own checkpoint / <a href="https://huggingface.co/amd/Llama-3.1-8B-Instruct-FP8-KV-Quark-test/blob/main/config.json#L26" rel="nofollow">configuration format</a>, the library also supports producing models with a serialization layout compliant with other quantization/runtime implementations (<a href="https://huggingface.co/docs/transformers/quantization/awq" rel="nofollow">AutoAWQ</a>, <a href="https://huggingface.co/docs/transformers/quantization/finegrained_fp8" rel="nofollow">native fp8 in 🤗 Transformers</a>).',X,f,pt="To be able to load Quark quantized models in Transformers, the library first needs to be installed:",R,M,V,y,Y,w,dt="Models quantized through Quark support a large range of features, that can be combined together. All quantized models independently of their configuration can seamlessly be reloaded through <code>PretrainedModel.from_pretrained</code>.",E,T,ut="The table below shows a few features supported by Quark:",L,b,mt="<thead><tr><th><strong>Feature</strong></th> <th><strong>Supported subset in Quark</strong></th> <th></th></tr></thead> <tbody><tr><td>Data types</td> <td>int8, int4, int2, bfloat16, float16, fp8_e5m2, fp8_e4m3, fp6_e3m2, fp6_e2m3, fp4, OCP MX, MX6, MX9, bfp16</td> <td></td></tr> <tr><td>Pre-quantization transformation</td> <td>SmoothQuant, QuaRot, SpinQuant, AWQ</td> <td></td></tr> <tr><td>Quantization algorithm</td> <td>GPTQ</td> <td></td></tr> <tr><td>Supported operators</td> <td><code>nn.Linear</code>, <code>nn.Conv2d</code>, <code>nn.ConvTranspose2d</code>, <code>nn.Embedding</code>, <code>nn.EmbeddingBag</code></td> <td></td></tr> <tr><td>Granularity</td> <td>per-tensor, per-channel, per-block, per-layer, per-layer type</td> <td></td></tr> <tr><td>KV cache</td> <td>fp8</td> <td></td></tr> <tr><td>Activation calibration</td> <td>MinMax / Percentile / MSE</td> <td></td></tr> <tr><td>Quantization strategy</td> <td>weight-only, static, dynamic, with or without output quantization</td> <td></td></tr></tbody>",N,g,P,U,ct='Public models using Quark native serialization can be found at <a href="https://huggingface.co/models?other=quark" rel="nofollow">https://huggingface.co/models?other=quark</a>.',A,J,ht='Although Quark also supports <a href="https://huggingface.co/models?other=fp8" rel="nofollow">models using <code>quant_method=&quot;fp8&quot;</code></a> and <a href="https://huggingface.co/models?other=awq" rel="nofollow">models using <code>quant_method=&quot;awq&quot;</code></a>, Transformers loads these models rather through <a href="https://huggingface.co/docs/transformers/quantization/awq" rel="nofollow">AutoAWQ</a> or uses the <a href="https://huggingface.co/docs/transformers/quantization/finegrained_fp8" rel="nofollow">native fp8 support in 🤗 Transformers</a>.',K,j,D,W,ft="Here is an example of how one can load a Quark model in Transformers:",O,k,tt,G,et,z,at;return d=new nt({props:{title:"Quark",local:"quark",headingTag:"h1"}}),M=new wt({props:{code:"cGlwJTIwaW5zdGFsbCUyMGFtZC1xdWFyaw==",highlighted:"pip install amd-quark",wrap:!1}}),y=new nt({props:{title:"Support matrix",local:"support-matrix",headingTag:"h2"}}),g=new nt({props:{title:"Models on Hugging Face Hub",local:"models-on-hugging-face-hub",headingTag:"h2"}}),j=new nt({props:{title:"Using Quark models in Transformers",local:"using-quark-models-in-transformers",headingTag:"h2"}}),k=new wt({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model_id = <span class="hljs-string">&quot;EmbeddedLLM/Llama-3.1-8B-Instruct-w_fp8_per_channel_sym&quot;</span>
model = AutoModelForCausalLM.from_pretrained(model_id)
model = model.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-built_in">print</span>(model.model.layers[<span class="hljs-number">0</span>].self_attn.q_proj)
<span class="hljs-comment"># QParamsLinear(</span>
<span class="hljs-comment">#   (weight_quantizer): ScaledRealQuantizer()</span>
<span class="hljs-comment">#   (input_quantizer): ScaledRealQuantizer()</span>
<span class="hljs-comment">#   (output_quantizer): ScaledRealQuantizer()</span>
<span class="hljs-comment"># )</span>

tokenizer = AutoTokenizer.from_pretrained(model_id)
inp = tokenizer(<span class="hljs-string">&quot;Where is a good place to cycle around Tokyo?&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inp = inp.to(<span class="hljs-string">&quot;cuda&quot;</span>)

res = model.generate(**inp, min_new_tokens=<span class="hljs-number">50</span>, max_new_tokens=<span class="hljs-number">100</span>)

<span class="hljs-built_in">print</span>(tokenizer.batch_decode(res)[<span class="hljs-number">0</span>])
<span class="hljs-comment"># &lt;|begin_of_text|&gt;Where is a good place to cycle around Tokyo? There are several places in Tokyo that are suitable for cycling, depending on your skill level and interests. Here are a few suggestions:</span>
<span class="hljs-comment"># 1. Yoyogi Park: This park is a popular spot for cycling and has a wide, flat path that&#x27;s perfect for beginners. You can also visit the Meiji Shrine, a famous Shinto shrine located in the park.</span>
<span class="hljs-comment"># 2. Imperial Palace East Garden: This beautiful garden has a large, flat path that&#x27;s perfect for cycling. You can also visit the</span>`,wrap:!1}}),G=new kt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/quantization/quark.md"}}),{c(){p=o("meta"),F=l(),$=o("p"),C=l(),I(d.$$.fragment),q=l(),u=o("p"),u.innerHTML=st,x=l(),m=o("p"),m.innerHTML=ot,H=l(),c=o("p"),c.innerHTML=rt,S=l(),h=o("p"),h.innerHTML=it,X=l(),f=o("p"),f.textContent=pt,R=l(),I(M.$$.fragment),V=l(),I(y.$$.fragment),Y=l(),w=o("p"),w.innerHTML=dt,E=l(),T=o("p"),T.textContent=ut,L=l(),b=o("table"),b.innerHTML=mt,N=l(),I(g.$$.fragment),P=l(),U=o("p"),U.innerHTML=ct,A=l(),J=o("p"),J.innerHTML=ht,K=l(),I(j.$$.fragment),D=l(),W=o("p"),W.textContent=ft,O=l(),I(k.$$.fragment),tt=l(),I(G.$$.fragment),et=l(),z=o("p"),this.h()},l(t){const e=jt("svelte-u9bgzb",document.head);p=r(e,"META",{name:!0,content:!0}),e.forEach(a),F=s(t),$=r(t,"P",{}),Mt($).forEach(a),C=s(t),B(d.$$.fragment,t),q=s(t),u=r(t,"P",{"data-svelte-h":!0}),i(u)!=="svelte-f91k68"&&(u.innerHTML=st),x=s(t),m=r(t,"P",{"data-svelte-h":!0}),i(m)!=="svelte-1bghkp0"&&(m.innerHTML=ot),H=s(t),c=r(t,"P",{"data-svelte-h":!0}),i(c)!=="svelte-5ndvt6"&&(c.innerHTML=rt),S=s(t),h=r(t,"P",{"data-svelte-h":!0}),i(h)!=="svelte-8fh62i"&&(h.innerHTML=it),X=s(t),f=r(t,"P",{"data-svelte-h":!0}),i(f)!=="svelte-14oxujq"&&(f.textContent=pt),R=s(t),B(M.$$.fragment,t),V=s(t),B(y.$$.fragment,t),Y=s(t),w=r(t,"P",{"data-svelte-h":!0}),i(w)!=="svelte-1vpj1hi"&&(w.innerHTML=dt),E=s(t),T=r(t,"P",{"data-svelte-h":!0}),i(T)!=="svelte-3upp27"&&(T.textContent=ut),L=s(t),b=r(t,"TABLE",{"data-svelte-h":!0}),i(b)!=="svelte-vm9870"&&(b.innerHTML=mt),N=s(t),B(g.$$.fragment,t),P=s(t),U=r(t,"P",{"data-svelte-h":!0}),i(U)!=="svelte-4nfu69"&&(U.innerHTML=ct),A=s(t),J=r(t,"P",{"data-svelte-h":!0}),i(J)!=="svelte-1m8qmmj"&&(J.innerHTML=ht),K=s(t),B(j.$$.fragment,t),D=s(t),W=r(t,"P",{"data-svelte-h":!0}),i(W)!=="svelte-sp1dmt"&&(W.textContent=ft),O=s(t),B(k.$$.fragment,t),tt=s(t),B(G.$$.fragment,t),et=s(t),z=r(t,"P",{}),Mt(z).forEach(a),this.h()},h(){yt(p,"name","hf:doc:metadata"),yt(p,"content",It)},m(t,e){Wt(document.head,p),n(t,F,e),n(t,$,e),n(t,C,e),Q(d,t,e),n(t,q,e),n(t,u,e),n(t,x,e),n(t,m,e),n(t,H,e),n(t,c,e),n(t,S,e),n(t,h,e),n(t,X,e),n(t,f,e),n(t,R,e),Q(M,t,e),n(t,V,e),Q(y,t,e),n(t,Y,e),n(t,w,e),n(t,E,e),n(t,T,e),n(t,L,e),n(t,b,e),n(t,N,e),Q(g,t,e),n(t,P,e),n(t,U,e),n(t,A,e),n(t,J,e),n(t,K,e),Q(j,t,e),n(t,D,e),n(t,W,e),n(t,O,e),Q(k,t,e),n(t,tt,e),Q(G,t,e),n(t,et,e),n(t,z,e),at=!0},p:bt,i(t){at||(v(d.$$.fragment,t),v(M.$$.fragment,t),v(y.$$.fragment,t),v(g.$$.fragment,t),v(j.$$.fragment,t),v(k.$$.fragment,t),v(G.$$.fragment,t),at=!0)},o(t){Z(d.$$.fragment,t),Z(M.$$.fragment,t),Z(y.$$.fragment,t),Z(g.$$.fragment,t),Z(j.$$.fragment,t),Z(k.$$.fragment,t),Z(G.$$.fragment,t),at=!1},d(t){t&&(a(F),a($),a(C),a(q),a(u),a(x),a(m),a(H),a(c),a(S),a(h),a(X),a(f),a(R),a(V),a(Y),a(w),a(E),a(T),a(L),a(b),a(N),a(P),a(U),a(A),a(J),a(K),a(D),a(W),a(O),a(tt),a(et),a(z)),a(p),_(d,t),_(M,t),_(y,t),_(g,t),_(j,t),_(k,t),_(G,t)}}}const It='{"title":"Quark","local":"quark","sections":[{"title":"Support matrix","local":"support-matrix","sections":[],"depth":2},{"title":"Models on Hugging Face Hub","local":"models-on-hugging-face-hub","sections":[],"depth":2},{"title":"Using Quark models in Transformers","local":"using-quark-models-in-transformers","sections":[],"depth":2}],"depth":1}';function Bt(lt){return gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zt extends Ut{constructor(p){super(),Jt(this,p,Bt,Gt,Tt,{})}}export{zt as component};
