import{s as Nl,o as Hl,n as kl}from"../chunks/scheduler.85c25b89.js";import{S as Yl,i as Fl,g as u,s,r as a,A as Vl,h,f as l,c as i,j as Zl,u as o,x as d,k as Wl,y as Ll,a as n,v as r,d as p,t as c,w as m}from"../chunks/index.c9bcf812.js";import{T as _l}from"../chunks/Tip.d8f753fa.js";import{C as y}from"../chunks/CodeBlock.c004bd26.js";import{H as M}from"../chunks/getInferenceSnippets.d9278495.js";function xl(Ye){let f,w="<strong>Important Limitation</strong>: Models like <code>NeuronModelForSequenceClassification</code>, <code>NeuronModelForQuestionAnswering</code>, etc. use a different compilation path that doesn’t integrate with the cache system. Only <code>NeuronModelForCausalLM</code> and training workflows support caching.";return{c(){f=u("p"),f.innerHTML=w},l($){f=h($,"P",{"data-svelte-h":!0}),d(f)!=="svelte-15db3yp"&&(f.innerHTML=w)},m($,He){n($,f,He)},p:kl,d($){$&&l(f)}}}function Xl(Ye){let f,w,$,He,T,Fe,b,Ve,j,Dt="<strong>Problem</strong>: Neuron compilation takes 30-60 minutes for large models<br/> <strong>Solution</strong>: Download pre-compiled models in seconds",Le,U,Kt="The cache system stores compiled Neuron models on HuggingFace Hub, eliminating recompilation time for your team. When you train or load a model, the system automatically checks for cached versions before starting the expensive compilation process.",_e,J,el="<strong>Key Benefits:</strong>",xe,v,tl="<li><strong>Time savings</strong>: download compiled models in seconds vs. hours of compilation</li> <li><strong>Team collaboration</strong>: share compiled models across team members and instances</li> <li><strong>Cost reduction</strong>: avoid repeated compilation costs on cloud instances</li> <li><strong>Automatic operation</strong>: works transparently with existing code</li>",Xe,C,Ee,I,Se,B,Qe,G,Re,Z,ze,W,ll="That’s it! The cache works automatically for supported model classes.",Pe,N,Ae,H,nl="<thead><tr><th>Model Class</th> <th>Cache Support</th> <th>Use Case</th> <th>Notes</th></tr></thead> <tbody><tr><td><code>NeuronTrainer</code></td> <td>✅ Full</td> <td>Training</td> <td>Auto download + upload during training</td></tr> <tr><td><code>NeuronModelForCausalLM</code></td> <td>✅ Full</td> <td>Inference</td> <td>Auto download for inference</td></tr> <tr><td>Other <code>NeuronModelForXXX</code></td> <td>❌ None</td> <td>Inference</td> <td>Use different export mechanism, no cache integration</td></tr></tbody>",qe,g,Oe,k,De,Y,sl="The cache system operates on two levels to minimize compilation time:",Ke,F,il="<strong>Cache Priority</strong> (fastest to slowest):",et,V,al="<li><strong>Local cache</strong> → instant access from <code>/var/tmp/neuron-compile-cache</code></li> <li><strong>Hub cache</strong> → download in seconds from HuggingFace Hub</li> <li><strong>Compile from scratch</strong> → 30-60 minutes for large models</li>",tt,L,ol="<strong>What Gets Cached</strong>: the system caches <strong>NEFF files</strong> (Neuron Executable File Format) - the compiled binary artifacts that run on Neuron cores, not the original model files.",lt,_,rl="<strong>Cache Identification</strong>: each cached compilation gets a unique hash based on:",nt,x,pl="<li><strong>Model factors</strong>: architecture, precision (fp16/bf16), input shapes, task type</li> <li><strong>Compilation factors</strong>: NeuronX compiler version, number of cores, optimization flags</li> <li><strong>Environment factors</strong>: model checkpoint revision, Optimum Neuron version</li>",st,X,cl="This means even small changes to your setup may require recompilation, but identical configurations will always hit the cache.",it,E,at,S,ml="The default public cache (<code>aws-neuron/optimum-neuron-cache</code>) is <strong>read-only</strong> for users - you can download cached models but cannot upload your own compilations. This public cache only contains models compiled by the Optimum team for common configurations.",ot,Q,ul="For most use cases, you’ll want to create a <strong>private cache repository</strong> where you can store your own compiled models.",rt,R,hl="<strong>Why private cache?</strong>",pt,z,dl="<li><strong>Upload your compilations</strong>: store models you compile for team reuse</li> <li><strong>Private models</strong>: keep proprietary model compilations secure</li> <li><strong>Team collaboration</strong>: share compiled artifacts across team members and CI/CD</li> <li><strong>Custom configurations</strong>: cache models with your specific batch sizes, sequence lengths, etc.</li>",ct,P,mt,A,ut,q,ht,O,dt,D,Ml="<strong>Prerequisites:</strong>",Mt,K,fl="<li>Login: <code>huggingface-cli login</code></li> <li>write access to cache repository</li>",ft,ee,yt,te,$t,le,gt,ne,wt,se,yl="If you do not use the <code>NeuronTrainer</code> class, you can still leverage the cache system in your custom training loops. This is useful when you need more control over the training process or when integrating with custom training frameworks while still benefiting from cached compilations.",Tt,ie,$l="<strong>When to use this approach:</strong>",bt,ae,gl="<li>custom training loops that don’t fit the <code>NeuronTrainer</code> pattern</li> <li>advanced optimization scenarios requiring fine-grained control</li>",jt,oe,wl="<strong>Note</strong>: For most use cases, <code>NeuronTrainer</code> handles caching automatically and is the recommended approach.",Ut,re,Jt,pe,vt,ce,Tl="The inference cache includes a <strong>registry</strong> that lets you search for compatible pre-compiled models before attempting compilation. This is especially useful for inference where you want to avoid compilation altogether.",Ct,me,It,ue,bl="Example output:",Bt,he,Gt,de,jl="<strong>Important</strong>: Finding entries doesn’t guarantee cache hits. Your exact configuration must match the cached parameters, including compiler version and model revision.",Zt,Me,Wt,fe,Ul="The cache system works seamlessly in automated environments:",Nt,ye,Jl="<strong>Environment Variables</strong>: use <code>CUSTOM_CACHE_REPO</code> to specify cache repository in CI workflows",Ht,$e,kt,ge,vl="<strong>Authentication</strong>: ensure your CI environment has access to your private cache repository:",Yt,we,Cl="<li>Set <code>HF_TOKEN</code> environment variable with appropriate read/write permissions</li> <li>For GitHub Actions, store as a repository secret</li>",Ft,Te,Il="<strong>Best Practices</strong>:",Vt,be,Bl="<li>use separate cache repositories for different environments (dev/staging/prod)</li> <li>consider cache repository permissions when setting up automated workflows</li> <li>monitor cache repository size in long-running CI workflows</li>",Lt,je,_t,Ue,xt,Je,Xt,ve,Et,Ce,St,Ie,Qt,Be,Rt,Ge,zt,Ze,Pt,We,At,Ne,qt,ke,Ot;return T=new M({props:{title:"Neuron Model Cache",local:"neuron-model-cache",headingTag:"h1"}}),b=new M({props:{title:"Why Use the Cache?",local:"why-use-the-cache",headingTag:"h2"}}),C=new M({props:{title:"Quick Start",local:"quick-start",headingTag:"h2"}}),I=new M({props:{title:"Training",local:"training",headingTag:"h3"}}),B=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uVHJhaW5lciUwQSUwQSUyMyUyMENhY2hlJTIwd29ya3MlMjBhdXRvbWF0aWNhbGx5JTIwLSUyMG5vJTIwY29uZmlndXJhdGlvbiUyMG5lZWRlZCUwQXRyYWluZXIlMjAlM0QlMjBOZXVyb25UcmFpbmVyKG1vZGVsJTNEbW9kZWwlMkMlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyklMEF0cmFpbmVyLnRyYWluKCklMjAlMjAlMjMlMjBEb3dubG9hZHMlMjBjYWNoZWQlMjBtb2RlbHMlMjBpZiUyMGF2YWlsYWJsZQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainer

<span class="hljs-comment"># Cache works automatically - no configuration needed</span>
trainer = NeuronTrainer(model=model, args=training_args)
trainer.train()  <span class="hljs-comment"># Downloads cached models if available</span>`,wrap:!1}}),G=new M({props:{title:"Inference",local:"inference",headingTag:"h3"}}),Z=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMENhY2hlJTIwd29ya3MlMjBhdXRvbWF0aWNhbGx5JTIwJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtb2RlbF9pZCUyMik=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCausalLM

<span class="hljs-comment"># Cache works automatically </span>
model = NeuronModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;model_id&quot;</span>)`,wrap:!1}}),N=new M({props:{title:"Supported Models",local:"supported-models",headingTag:"h2"}}),g=new _l({props:{warning:!0,$$slots:{default:[xl]},$$scope:{ctx:Ye}}}),k=new M({props:{title:"How It Works",local:"how-it-works",headingTag:"h2"}}),E=new M({props:{title:"Private Cache Setup",local:"private-cache-setup",headingTag:"h2"}}),P=new M({props:{title:"Method 1: CLI Setup (Recommended)",local:"method-1-cli-setup-recommended",headingTag:"h3"}}),A=new y({props:{code:"JTIzJTIwQ3JlYXRlJTIwcHJpdmF0ZSUyMGNhY2hlJTIwcmVwb3NpdG9yeSUwQW9wdGltdW0tY2xpJTIwbmV1cm9uJTIwY2FjaGUlMjBjcmVhdGUlMEElMEElMjMlMjBTZXQlMjBhcyUyMGRlZmF1bHQlMjBjYWNoZSUwQW9wdGltdW0tY2xpJTIwbmV1cm9uJTIwY2FjaGUlMjBzZXQlMjB5b3VyLW9yZyUyRnlvdXItY2FjaGUtbmFtZQ==",highlighted:`<span class="hljs-comment"># Create private cache repository</span>
optimum-cli neuron cache create

<span class="hljs-comment"># Set as default cache</span>
optimum-cli neuron cache <span class="hljs-built_in">set</span> your-org/your-cache-name`,wrap:!1}}),q=new M({props:{title:"Method 2: Environment Variable",local:"method-2-environment-variable",headingTag:"h3"}}),O=new y({props:{code:"JTIzJTIwVXNlJTIwZm9yJTIwc2luZ2xlJTIwdHJhaW5pbmclMjBydW4lMEFDVVNUT01fQ0FDSEVfUkVQTyUzRCUyMnlvdXItb3JnJTJGeW91ci1jYWNoZSUyMiUyMHB5dGhvbiUyMHRyYWluLnB5JTBBJTBBJTIzJTIwT3IlMjBleHBvcnQlMjBmb3IlMjBzZXNzaW9uJTBBZXhwb3J0JTIwQ1VTVE9NX0NBQ0hFX1JFUE8lM0QlMjJ5b3VyLW9yZyUyRnlvdXItY2FjaGUlMjI=",highlighted:`<span class="hljs-comment"># Use for single training run</span>
CUSTOM_CACHE_REPO=<span class="hljs-string">&quot;your-org/your-cache&quot;</span> python train.py

<span class="hljs-comment"># Or export for session</span>
<span class="hljs-built_in">export</span> CUSTOM_CACHE_REPO=<span class="hljs-string">&quot;your-org/your-cache&quot;</span>`,wrap:!1}}),ee=new M({props:{title:"CLI Commands",local:"cli-commands",headingTag:"h2"}}),te=new y({props:{code:"JTIzJTIwQ3JlYXRlJTIwbmV3JTIwY2FjaGUlMjByZXBvc2l0b3J5JTBBb3B0aW11bS1jbGklMjBuZXVyb24lMjBjYWNoZSUyMGNyZWF0ZSUyMCU1Qi1uJTIwTkFNRSU1RCUyMCU1Qi0tcHVibGljJTVEJTBBJTBBJTIzJTIwU2V0JTIwZGVmYXVsdCUyMGNhY2hlJTIwcmVwb3NpdG9yeSUyMCUyMCUwQW9wdGltdW0tY2xpJTIwbmV1cm9uJTIwY2FjaGUlMjBzZXQlMjBSRVBPX05BTUUlMEElMEElMjMlMjBTZWFyY2glMjBmb3IlMjBjYWNoZWQlMjBtb2RlbHMlMEFvcHRpbXVtLWNsaSUyMG5ldXJvbiUyMGNhY2hlJTIwbG9va3VwJTIwTU9ERUxfSUQlMEElMEElMjMlMjBTeW5jJTIwbG9jYWwlMjBjYWNoZSUyMHdpdGglMjBIdWIlMEFvcHRpbXVtLWNsaSUyMG5ldXJvbiUyMGNhY2hlJTIwc3luY2hyb25pemU=",highlighted:`<span class="hljs-comment"># Create new cache repository</span>
optimum-cli neuron cache create [-n NAME] [--public]

<span class="hljs-comment"># Set default cache repository  </span>
optimum-cli neuron cache <span class="hljs-built_in">set</span> REPO_NAME

<span class="hljs-comment"># Search for cached models</span>
optimum-cli neuron cache lookup MODEL_ID

<span class="hljs-comment"># Sync local cache with Hub</span>
optimum-cli neuron cache synchronize`,wrap:!1}}),le=new M({props:{title:"Advanced Usage",local:"advanced-usage",headingTag:"h2"}}),ne=new M({props:{title:"Use the Cache in Training Loops",local:"use-the-cache-in-training-loops",headingTag:"h3"}}),re=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uLmNhY2hlJTIwaW1wb3J0JTIwaHViX25ldXJvbnhfY2FjaGUlMkMlMjBzeW5jaHJvbml6ZV9odWJfY2FjaGUlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24uY2FjaGUuZW50cmllcyUyMGltcG9ydCUyMFNpbmdsZU1vZGVsQ2FjaGVFbnRyeSUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbi5jYWNoZS50cmFpbmluZyUyMGltcG9ydCUyMHBhdGNoX25ldXJvbl9jY193cmFwcGVyJTBBJTBBJTIzJTIwQ3JlYXRlJTIwY2FjaGUlMjBlbnRyeSUwQWNhY2hlX2VudHJ5JTIwJTNEJTIwU2luZ2xlTW9kZWxDYWNoZUVudHJ5KG1vZGVsX2lkJTJDJTIwdGFzayUyQyUyMGNvbmZpZyUyQyUyMG5ldXJvbl9jb25maWcpJTBBJTBBJTIzJTIwVGhlJTIwTmV1cm9uWCUyMGNvbXBpbGVyJTIwd2lsbCUyMHVzZSUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwY2FjaGUlMjBzeXN0ZW0lMEF3aXRoJTIwcGF0Y2hfbmV1cm9uX2NjX3dyYXBwZXIoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFRoZSUyMGNvbXBpbGVyJTIwd2lsbCUyMGNoZWNrJTIwdGhlJTIwc3BlY2lmaWVkJTIwcmVtb3RlJTIwY2FjaGUlMjBmb3IlMjBwcmUtY29tcGlsZWQlMjBORUZGJTIwZmlsZXMlMEElMjAlMjAlMjAlMjB3aXRoJTIwaHViX25ldXJvbnhfY2FjaGUoZW50cnklM0RjYWNoZV9lbnRyeSUyQyUyMGNhY2hlX3JlcG9faWQlM0QlMjJteS1vcmclMkZjYWNoZSUyMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMHRyYWluaW5nX2xvb3AoKSUyMCUyMCUyMyUyMFdpbGwlMjB1c2UlMjBzcGVjaWZpZWQlMjBjYWNoZSUwQSUwQSUyMyUyMFN5bmNocm9uaXplJTIwbG9jYWwlMjBjYWNoZSUyMHdpdGglMjBIdWIlMEFzeW5jaHJvbml6ZV9odWJfY2FjaGUoY2FjaGVfcmVwb19pZCUzRCUyMm15LW9yZyUyRmNhY2hlJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron.cache <span class="hljs-keyword">import</span> hub_neuronx_cache, synchronize_hub_cache
<span class="hljs-keyword">from</span> optimum.neuron.cache.entries <span class="hljs-keyword">import</span> SingleModelCacheEntry
<span class="hljs-keyword">from</span> optimum.neuron.cache.training <span class="hljs-keyword">import</span> patch_neuron_cc_wrapper

<span class="hljs-comment"># Create cache entry</span>
cache_entry = SingleModelCacheEntry(model_id, task, config, neuron_config)

<span class="hljs-comment"># The NeuronX compiler will use the Hugging Face Hub cache system</span>
<span class="hljs-keyword">with</span> patch_neuron_cc_wrapper():
    <span class="hljs-comment"># The compiler will check the specified remote cache for pre-compiled NEFF files</span>
    <span class="hljs-keyword">with</span> hub_neuronx_cache(entry=cache_entry, cache_repo_id=<span class="hljs-string">&quot;my-org/cache&quot;</span>):
        model = training_loop()  <span class="hljs-comment"># Will use specified cache</span>

<span class="hljs-comment"># Synchronize local cache with Hub</span>
synchronize_hub_cache(cache_repo_id=<span class="hljs-string">&quot;my-org/cache&quot;</span>)`,wrap:!1}}),pe=new M({props:{title:"Cache Lookup",local:"cache-lookup",headingTag:"h3"}}),me=new y({props:{code:"b3B0aW11bS1jbGklMjBuZXVyb24lMjBjYWNoZSUyMGxvb2t1cCUyMG1ldGEtbGxhbWElMkZMbGFtYS0yLTdiLWNoYXQtaGY=",highlighted:"optimum-cli neuron cache lookup meta-llama/Llama-2-7b-chat-hf",wrap:!1}}),he=new y({props:{code:"KioqJTIwMSUyMGVudHJpZXMlMjBmb3VuZCUyMGluJTIwY2FjaGUlMjAqKiolMEF0YXNrJTNBJTIwdGV4dC1nZW5lcmF0aW9uJTBBYmF0Y2hfc2l6ZSUzQSUyMDElMkMlMjBzZXF1ZW5jZV9sZW5ndGglM0ElMjAyMDQ4JTBBbnVtX2NvcmVzJTNBJTIwMjQlMkMlMjBwcmVjaXNpb24lM0ElMjBmcDE2JTBBY29tcGlsZXJfdmVyc2lvbiUzQSUyMDIuMTIuNTQuMCUwQWNoZWNrcG9pbnRfcmV2aXNpb24lM0ElMjBjMWIwZGI5MzM2ODRlZGJmZTI5YTA2ZmE0N2ViMTljYzQ4MDI1ZTkz",highlighted:`<span class="hljs-string">***</span> <span class="hljs-number">1</span> <span class="hljs-string">entries</span> <span class="hljs-string">found</span> <span class="hljs-string">in</span> <span class="hljs-string">cache</span> <span class="hljs-string">***</span>
<span class="hljs-attr">task:</span> <span class="hljs-string">text-generation</span>
<span class="hljs-attr">batch_size:</span> <span class="hljs-number">1</span><span class="hljs-string">,</span> <span class="hljs-attr">sequence_length:</span> <span class="hljs-number">2048</span>
<span class="hljs-attr">num_cores:</span> <span class="hljs-number">24</span><span class="hljs-string">,</span> <span class="hljs-attr">precision:</span> <span class="hljs-string">fp16</span>
<span class="hljs-attr">compiler_version:</span> <span class="hljs-number">2.12</span><span class="hljs-number">.54</span><span class="hljs-number">.0</span>
<span class="hljs-attr">checkpoint_revision:</span> <span class="hljs-string">c1b0db933684edbfe29a06fa47eb19cc48025e93</span>`,wrap:!1}}),Me=new M({props:{title:"CI/CD Integration",local:"cicd-integration",headingTag:"h2"}}),$e=new y({props:{code:"JTIzJTIwSW4lMjB5b3VyJTIwQ0klMjBjb25maWd1cmF0aW9uJTBBQ1VTVE9NX0NBQ0hFX1JFUE8lM0QlMjJ5b3VyLW9yZyUyRnlvdXItY2FjaGUlMjIlMjBweXRob24lMjB0cmFpbi5weQ==",highlighted:`<span class="hljs-comment"># In your CI configuration</span>
CUSTOM_CACHE_REPO=<span class="hljs-string">&quot;your-org/your-cache&quot;</span> python train.py`,wrap:!1}}),je=new M({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h2"}}),Ue=new M({props:{title:"“Cache repository does not exist”",local:"cache-repository-does-not-exist",headingTag:"h3"}}),Je=new y({props:{code:"Rml4JTNBJTIwQ2hlY2slMjByZXBvc2l0b3J5JTIwbmFtZSUyMGFuZCUyMGxvZ2luJTIwc3RhdHVzJTBBJUUyJTg2JTkyJTIwaHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4lMEElRTIlODYlOTIlMjBWZXJpZnklMjByZXBvJTIwZm9ybWF0JTNBJTIwb3JnJTJGcmVwby1uYW1l",highlighted:`Fix: Check repository name and login status
→ huggingface-cli login
→ Verify repo format: org/repo-name`,wrap:!1}}),ve=new M({props:{title:"“Graph will be recompiled”",local:"graph-will-be-recompiled",headingTag:"h3"}}),Ce=new y({props:{code:"Q2F1c2UlM0ElMjBObyUyMGNhY2hlZCUyMG1vZGVsJTIwbWF0Y2hlcyUyMHlvdXIlMjBleGFjdCUyMGNvbmZpZ3VyYXRpb24lMEFGaXglM0ElMjBVc2UlMjBsb29rdXAlMjB0byUyMGZpbmQlMjBjb21wYXRpYmxlJTIwY29uZmlndXJhdGlvbnMlMEElRTIlODYlOTIlMjBvcHRpbXVtLWNsaSUyMG5ldXJvbiUyMGNhY2hlJTIwbG9va3VwJTIwTU9ERUxfSUQ=",highlighted:`Cause: No cached model matches your exact configuration
Fix: Use lookup to find compatible configurations
→ optimum-cli neuron cache lookup MODEL_ID`,wrap:!1}}),Ie=new M({props:{title:"Cache not uploading during training",local:"cache-not-uploading-during-training",headingTag:"h3"}}),Be=new y({props:{code:"Q2F1c2UlM0ElMjBObyUyMHdyaXRlJTIwcGVybWlzc2lvbnMlMjB0byUyMGNhY2hlJTIwcmVwb3NpdG9yeSUyMCUyMCUwQUZpeCUzQSUyMFZlcmlmeSUyMGFjY2VzcyUyMGFuZCUyMGF1dGhlbnRpY2F0aW9uJTBBJUUyJTg2JTkyJTIwaHVnZ2luZ2ZhY2UtY2xpJTIwd2hvYW1pJTBBJUUyJTg2JTkyJTIwQ2hlY2slMjBjYWNoZSUyMHJlcG8lMjBwZXJtaXNzaW9ucw==",highlighted:`Cause: No write permissions to cache repository  
Fix: Verify access and authentication
→ huggingface-cli whoami
→ Check cache repo permissions`,wrap:!1}}),Ge=new M({props:{title:"Slow downloads",local:"slow-downloads",headingTag:"h3"}}),Ze=new y({props:{code:"Q2F1c2UlM0ElMjBMYXJnZSUyMGNvbXBpbGVkJTIwbW9kZWxzJTIwKEdCcyklMjBkb3dubG9hZGluZyUwQUZpeCUzQSUyMEVuc3VyZSUyMGdvb2QlMjBpbnRlcm5ldCUyMGNvbm5lY3Rpb24lMEElRTIlODYlOTIlMjBNb25pdG9yJTIwbG9ncyUyMGZvciUyMGRvd25sb2FkJTIwcHJvZ3Jlc3M=",highlighted:`Cause: Large compiled models (GBs) downloading
Fix: Ensure good internet connection
→ Monitor logs for download progress`,wrap:!1}}),We=new M({props:{title:"Clear corrupted local cache",local:"clear-corrupted-local-cache",headingTag:"h3"}}),Ne=new y({props:{code:"cm0lMjAtcmYlMjAlMkZ2YXIlMkZ0bXAlMkZuZXVyb24tY29tcGlsZS1jYWNoZSUyRio=",highlighted:'<span class="hljs-built_in">rm</span> -rf /var/tmp/neuron-compile-cache/*',wrap:!1}}),{c(){f=u("meta"),w=s(),$=u("p"),He=s(),a(T.$$.fragment),Fe=s(),a(b.$$.fragment),Ve=s(),j=u("p"),j.innerHTML=Dt,Le=s(),U=u("p"),U.textContent=Kt,_e=s(),J=u("p"),J.innerHTML=el,xe=s(),v=u("ul"),v.innerHTML=tl,Xe=s(),a(C.$$.fragment),Ee=s(),a(I.$$.fragment),Se=s(),a(B.$$.fragment),Qe=s(),a(G.$$.fragment),Re=s(),a(Z.$$.fragment),ze=s(),W=u("p"),W.textContent=ll,Pe=s(),a(N.$$.fragment),Ae=s(),H=u("table"),H.innerHTML=nl,qe=s(),a(g.$$.fragment),Oe=s(),a(k.$$.fragment),De=s(),Y=u("p"),Y.textContent=sl,Ke=s(),F=u("p"),F.innerHTML=il,et=s(),V=u("ol"),V.innerHTML=al,tt=s(),L=u("p"),L.innerHTML=ol,lt=s(),_=u("p"),_.innerHTML=rl,nt=s(),x=u("ul"),x.innerHTML=pl,st=s(),X=u("p"),X.textContent=cl,it=s(),a(E.$$.fragment),at=s(),S=u("p"),S.innerHTML=ml,ot=s(),Q=u("p"),Q.innerHTML=ul,rt=s(),R=u("p"),R.innerHTML=hl,pt=s(),z=u("ul"),z.innerHTML=dl,ct=s(),a(P.$$.fragment),mt=s(),a(A.$$.fragment),ut=s(),a(q.$$.fragment),ht=s(),a(O.$$.fragment),dt=s(),D=u("p"),D.innerHTML=Ml,Mt=s(),K=u("ul"),K.innerHTML=fl,ft=s(),a(ee.$$.fragment),yt=s(),a(te.$$.fragment),$t=s(),a(le.$$.fragment),gt=s(),a(ne.$$.fragment),wt=s(),se=u("p"),se.innerHTML=yl,Tt=s(),ie=u("p"),ie.innerHTML=$l,bt=s(),ae=u("ul"),ae.innerHTML=gl,jt=s(),oe=u("p"),oe.innerHTML=wl,Ut=s(),a(re.$$.fragment),Jt=s(),a(pe.$$.fragment),vt=s(),ce=u("p"),ce.innerHTML=Tl,Ct=s(),a(me.$$.fragment),It=s(),ue=u("p"),ue.textContent=bl,Bt=s(),a(he.$$.fragment),Gt=s(),de=u("p"),de.innerHTML=jl,Zt=s(),a(Me.$$.fragment),Wt=s(),fe=u("p"),fe.textContent=Ul,Nt=s(),ye=u("p"),ye.innerHTML=Jl,Ht=s(),a($e.$$.fragment),kt=s(),ge=u("p"),ge.innerHTML=vl,Yt=s(),we=u("ul"),we.innerHTML=Cl,Ft=s(),Te=u("p"),Te.innerHTML=Il,Vt=s(),be=u("ul"),be.innerHTML=Bl,Lt=s(),a(je.$$.fragment),_t=s(),a(Ue.$$.fragment),xt=s(),a(Je.$$.fragment),Xt=s(),a(ve.$$.fragment),Et=s(),a(Ce.$$.fragment),St=s(),a(Ie.$$.fragment),Qt=s(),a(Be.$$.fragment),Rt=s(),a(Ge.$$.fragment),zt=s(),a(Ze.$$.fragment),Pt=s(),a(We.$$.fragment),At=s(),a(Ne.$$.fragment),qt=s(),ke=u("p"),this.h()},l(e){const t=Vl("svelte-u9bgzb",document.head);f=h(t,"META",{name:!0,content:!0}),t.forEach(l),w=i(e),$=h(e,"P",{}),Zl($).forEach(l),He=i(e),o(T.$$.fragment,e),Fe=i(e),o(b.$$.fragment,e),Ve=i(e),j=h(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-2zyn2"&&(j.innerHTML=Dt),Le=i(e),U=h(e,"P",{"data-svelte-h":!0}),d(U)!=="svelte-10mqjfi"&&(U.textContent=Kt),_e=i(e),J=h(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-1c3q00"&&(J.innerHTML=el),xe=i(e),v=h(e,"UL",{"data-svelte-h":!0}),d(v)!=="svelte-qr4kj2"&&(v.innerHTML=tl),Xe=i(e),o(C.$$.fragment,e),Ee=i(e),o(I.$$.fragment,e),Se=i(e),o(B.$$.fragment,e),Qe=i(e),o(G.$$.fragment,e),Re=i(e),o(Z.$$.fragment,e),ze=i(e),W=h(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-jto7nf"&&(W.textContent=ll),Pe=i(e),o(N.$$.fragment,e),Ae=i(e),H=h(e,"TABLE",{"data-svelte-h":!0}),d(H)!=="svelte-1fyprry"&&(H.innerHTML=nl),qe=i(e),o(g.$$.fragment,e),Oe=i(e),o(k.$$.fragment,e),De=i(e),Y=h(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1q5edhc"&&(Y.textContent=sl),Ke=i(e),F=h(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-extx4"&&(F.innerHTML=il),et=i(e),V=h(e,"OL",{"data-svelte-h":!0}),d(V)!=="svelte-13m01m6"&&(V.innerHTML=al),tt=i(e),L=h(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1f7xr5v"&&(L.innerHTML=ol),lt=i(e),_=h(e,"P",{"data-svelte-h":!0}),d(_)!=="svelte-16epk2o"&&(_.innerHTML=rl),nt=i(e),x=h(e,"UL",{"data-svelte-h":!0}),d(x)!=="svelte-u7un7n"&&(x.innerHTML=pl),st=i(e),X=h(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1ifb4sf"&&(X.textContent=cl),it=i(e),o(E.$$.fragment,e),at=i(e),S=h(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-3n33pg"&&(S.innerHTML=ml),ot=i(e),Q=h(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1yed0md"&&(Q.innerHTML=ul),rt=i(e),R=h(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-cdnk1d"&&(R.innerHTML=hl),pt=i(e),z=h(e,"UL",{"data-svelte-h":!0}),d(z)!=="svelte-18dj9xc"&&(z.innerHTML=dl),ct=i(e),o(P.$$.fragment,e),mt=i(e),o(A.$$.fragment,e),ut=i(e),o(q.$$.fragment,e),ht=i(e),o(O.$$.fragment,e),dt=i(e),D=h(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-18p63as"&&(D.innerHTML=Ml),Mt=i(e),K=h(e,"UL",{"data-svelte-h":!0}),d(K)!=="svelte-168ncg2"&&(K.innerHTML=fl),ft=i(e),o(ee.$$.fragment,e),yt=i(e),o(te.$$.fragment,e),$t=i(e),o(le.$$.fragment,e),gt=i(e),o(ne.$$.fragment,e),wt=i(e),se=h(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-141w8az"&&(se.innerHTML=yl),Tt=i(e),ie=h(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1paop45"&&(ie.innerHTML=$l),bt=i(e),ae=h(e,"UL",{"data-svelte-h":!0}),d(ae)!=="svelte-e0aew4"&&(ae.innerHTML=gl),jt=i(e),oe=h(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-rti9w"&&(oe.innerHTML=wl),Ut=i(e),o(re.$$.fragment,e),Jt=i(e),o(pe.$$.fragment,e),vt=i(e),ce=h(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-phsox0"&&(ce.innerHTML=Tl),Ct=i(e),o(me.$$.fragment,e),It=i(e),ue=h(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-c9hbnf"&&(ue.textContent=bl),Bt=i(e),o(he.$$.fragment,e),Gt=i(e),de=h(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-101fp4q"&&(de.innerHTML=jl),Zt=i(e),o(Me.$$.fragment,e),Wt=i(e),fe=h(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-1q4kquv"&&(fe.textContent=Ul),Nt=i(e),ye=h(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-1rwaldf"&&(ye.innerHTML=Jl),Ht=i(e),o($e.$$.fragment,e),kt=i(e),ge=h(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-1t0yadi"&&(ge.innerHTML=vl),Yt=i(e),we=h(e,"UL",{"data-svelte-h":!0}),d(we)!=="svelte-130w3q8"&&(we.innerHTML=Cl),Ft=i(e),Te=h(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-120tdf7"&&(Te.innerHTML=Il),Vt=i(e),be=h(e,"UL",{"data-svelte-h":!0}),d(be)!=="svelte-bp9m1l"&&(be.innerHTML=Bl),Lt=i(e),o(je.$$.fragment,e),_t=i(e),o(Ue.$$.fragment,e),xt=i(e),o(Je.$$.fragment,e),Xt=i(e),o(ve.$$.fragment,e),Et=i(e),o(Ce.$$.fragment,e),St=i(e),o(Ie.$$.fragment,e),Qt=i(e),o(Be.$$.fragment,e),Rt=i(e),o(Ge.$$.fragment,e),zt=i(e),o(Ze.$$.fragment,e),Pt=i(e),o(We.$$.fragment,e),At=i(e),o(Ne.$$.fragment,e),qt=i(e),ke=h(e,"P",{}),Zl(ke).forEach(l),this.h()},h(){Wl(f,"name","hf:doc:metadata"),Wl(f,"content",El)},m(e,t){Ll(document.head,f),n(e,w,t),n(e,$,t),n(e,He,t),r(T,e,t),n(e,Fe,t),r(b,e,t),n(e,Ve,t),n(e,j,t),n(e,Le,t),n(e,U,t),n(e,_e,t),n(e,J,t),n(e,xe,t),n(e,v,t),n(e,Xe,t),r(C,e,t),n(e,Ee,t),r(I,e,t),n(e,Se,t),r(B,e,t),n(e,Qe,t),r(G,e,t),n(e,Re,t),r(Z,e,t),n(e,ze,t),n(e,W,t),n(e,Pe,t),r(N,e,t),n(e,Ae,t),n(e,H,t),n(e,qe,t),r(g,e,t),n(e,Oe,t),r(k,e,t),n(e,De,t),n(e,Y,t),n(e,Ke,t),n(e,F,t),n(e,et,t),n(e,V,t),n(e,tt,t),n(e,L,t),n(e,lt,t),n(e,_,t),n(e,nt,t),n(e,x,t),n(e,st,t),n(e,X,t),n(e,it,t),r(E,e,t),n(e,at,t),n(e,S,t),n(e,ot,t),n(e,Q,t),n(e,rt,t),n(e,R,t),n(e,pt,t),n(e,z,t),n(e,ct,t),r(P,e,t),n(e,mt,t),r(A,e,t),n(e,ut,t),r(q,e,t),n(e,ht,t),r(O,e,t),n(e,dt,t),n(e,D,t),n(e,Mt,t),n(e,K,t),n(e,ft,t),r(ee,e,t),n(e,yt,t),r(te,e,t),n(e,$t,t),r(le,e,t),n(e,gt,t),r(ne,e,t),n(e,wt,t),n(e,se,t),n(e,Tt,t),n(e,ie,t),n(e,bt,t),n(e,ae,t),n(e,jt,t),n(e,oe,t),n(e,Ut,t),r(re,e,t),n(e,Jt,t),r(pe,e,t),n(e,vt,t),n(e,ce,t),n(e,Ct,t),r(me,e,t),n(e,It,t),n(e,ue,t),n(e,Bt,t),r(he,e,t),n(e,Gt,t),n(e,de,t),n(e,Zt,t),r(Me,e,t),n(e,Wt,t),n(e,fe,t),n(e,Nt,t),n(e,ye,t),n(e,Ht,t),r($e,e,t),n(e,kt,t),n(e,ge,t),n(e,Yt,t),n(e,we,t),n(e,Ft,t),n(e,Te,t),n(e,Vt,t),n(e,be,t),n(e,Lt,t),r(je,e,t),n(e,_t,t),r(Ue,e,t),n(e,xt,t),r(Je,e,t),n(e,Xt,t),r(ve,e,t),n(e,Et,t),r(Ce,e,t),n(e,St,t),r(Ie,e,t),n(e,Qt,t),r(Be,e,t),n(e,Rt,t),r(Ge,e,t),n(e,zt,t),r(Ze,e,t),n(e,Pt,t),r(We,e,t),n(e,At,t),r(Ne,e,t),n(e,qt,t),n(e,ke,t),Ot=!0},p(e,[t]){const Gl={};t&2&&(Gl.$$scope={dirty:t,ctx:e}),g.$set(Gl)},i(e){Ot||(p(T.$$.fragment,e),p(b.$$.fragment,e),p(C.$$.fragment,e),p(I.$$.fragment,e),p(B.$$.fragment,e),p(G.$$.fragment,e),p(Z.$$.fragment,e),p(N.$$.fragment,e),p(g.$$.fragment,e),p(k.$$.fragment,e),p(E.$$.fragment,e),p(P.$$.fragment,e),p(A.$$.fragment,e),p(q.$$.fragment,e),p(O.$$.fragment,e),p(ee.$$.fragment,e),p(te.$$.fragment,e),p(le.$$.fragment,e),p(ne.$$.fragment,e),p(re.$$.fragment,e),p(pe.$$.fragment,e),p(me.$$.fragment,e),p(he.$$.fragment,e),p(Me.$$.fragment,e),p($e.$$.fragment,e),p(je.$$.fragment,e),p(Ue.$$.fragment,e),p(Je.$$.fragment,e),p(ve.$$.fragment,e),p(Ce.$$.fragment,e),p(Ie.$$.fragment,e),p(Be.$$.fragment,e),p(Ge.$$.fragment,e),p(Ze.$$.fragment,e),p(We.$$.fragment,e),p(Ne.$$.fragment,e),Ot=!0)},o(e){c(T.$$.fragment,e),c(b.$$.fragment,e),c(C.$$.fragment,e),c(I.$$.fragment,e),c(B.$$.fragment,e),c(G.$$.fragment,e),c(Z.$$.fragment,e),c(N.$$.fragment,e),c(g.$$.fragment,e),c(k.$$.fragment,e),c(E.$$.fragment,e),c(P.$$.fragment,e),c(A.$$.fragment,e),c(q.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(re.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(he.$$.fragment,e),c(Me.$$.fragment,e),c($e.$$.fragment,e),c(je.$$.fragment,e),c(Ue.$$.fragment,e),c(Je.$$.fragment,e),c(ve.$$.fragment,e),c(Ce.$$.fragment,e),c(Ie.$$.fragment,e),c(Be.$$.fragment,e),c(Ge.$$.fragment,e),c(Ze.$$.fragment,e),c(We.$$.fragment,e),c(Ne.$$.fragment,e),Ot=!1},d(e){e&&(l(w),l($),l(He),l(Fe),l(Ve),l(j),l(Le),l(U),l(_e),l(J),l(xe),l(v),l(Xe),l(Ee),l(Se),l(Qe),l(Re),l(ze),l(W),l(Pe),l(Ae),l(H),l(qe),l(Oe),l(De),l(Y),l(Ke),l(F),l(et),l(V),l(tt),l(L),l(lt),l(_),l(nt),l(x),l(st),l(X),l(it),l(at),l(S),l(ot),l(Q),l(rt),l(R),l(pt),l(z),l(ct),l(mt),l(ut),l(ht),l(dt),l(D),l(Mt),l(K),l(ft),l(yt),l($t),l(gt),l(wt),l(se),l(Tt),l(ie),l(bt),l(ae),l(jt),l(oe),l(Ut),l(Jt),l(vt),l(ce),l(Ct),l(It),l(ue),l(Bt),l(Gt),l(de),l(Zt),l(Wt),l(fe),l(Nt),l(ye),l(Ht),l(kt),l(ge),l(Yt),l(we),l(Ft),l(Te),l(Vt),l(be),l(Lt),l(_t),l(xt),l(Xt),l(Et),l(St),l(Qt),l(Rt),l(zt),l(Pt),l(At),l(qt),l(ke)),l(f),m(T,e),m(b,e),m(C,e),m(I,e),m(B,e),m(G,e),m(Z,e),m(N,e),m(g,e),m(k,e),m(E,e),m(P,e),m(A,e),m(q,e),m(O,e),m(ee,e),m(te,e),m(le,e),m(ne,e),m(re,e),m(pe,e),m(me,e),m(he,e),m(Me,e),m($e,e),m(je,e),m(Ue,e),m(Je,e),m(ve,e),m(Ce,e),m(Ie,e),m(Be,e),m(Ge,e),m(Ze,e),m(We,e),m(Ne,e)}}}const El='{"title":"Neuron Model Cache","local":"neuron-model-cache","sections":[{"title":"Why Use the Cache?","local":"why-use-the-cache","sections":[],"depth":2},{"title":"Quick Start","local":"quick-start","sections":[{"title":"Training","local":"training","sections":[],"depth":3},{"title":"Inference","local":"inference","sections":[],"depth":3}],"depth":2},{"title":"Supported Models","local":"supported-models","sections":[],"depth":2},{"title":"How It Works","local":"how-it-works","sections":[],"depth":2},{"title":"Private Cache Setup","local":"private-cache-setup","sections":[{"title":"Method 1: CLI Setup (Recommended)","local":"method-1-cli-setup-recommended","sections":[],"depth":3},{"title":"Method 2: Environment Variable","local":"method-2-environment-variable","sections":[],"depth":3}],"depth":2},{"title":"CLI Commands","local":"cli-commands","sections":[],"depth":2},{"title":"Advanced Usage","local":"advanced-usage","sections":[{"title":"Use the Cache in Training Loops","local":"use-the-cache-in-training-loops","sections":[],"depth":3},{"title":"Cache Lookup","local":"cache-lookup","sections":[],"depth":3}],"depth":2},{"title":"CI/CD Integration","local":"cicd-integration","sections":[],"depth":2},{"title":"Troubleshooting","local":"troubleshooting","sections":[{"title":"“Cache repository does not exist”","local":"cache-repository-does-not-exist","sections":[],"depth":3},{"title":"“Graph will be recompiled”","local":"graph-will-be-recompiled","sections":[],"depth":3},{"title":"Cache not uploading during training","local":"cache-not-uploading-during-training","sections":[],"depth":3},{"title":"Slow downloads","local":"slow-downloads","sections":[],"depth":3},{"title":"Clear corrupted local cache","local":"clear-corrupted-local-cache","sections":[],"depth":3}],"depth":2}],"depth":1}';function Sl(Ye){return Hl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ql extends Yl{constructor(f){super(),Fl(this,f,Sl,Xl,Nl,{})}}export{ql as component};
