# Hugging Face on Azure AI

Hugging Face has partnered with Microsoft to bring open-source models from the [Hugging Face Hub](https://huggingface.co) into [Azure Machine Learning](https://ml.azure.com/). The Hugging Face Hub is the home of over 1,700,000 public access open-source models, as well as datasets, spaces and much more. The integration with Azure Machine Learning enables you to deploy open-source models of your choice to secure and scalable inference infrastructure on Azure powered by Hugging Face and other open-source inference solutions such as Text Generation Inference (TGI), vLLM and SGLang for LLMs and VLMs, or Text Embeddings Inference (TEI) for embeddings, among others to come. Now, the Azure Machine Learning Catalog is the home for over 10,000 open-source of the most popular and downloaded models on the Hugging Face Hub from the most popular and influential users and organizations, ensuring secure and verified weights, that can be deployed to managed online endpoints with ease. Once deployed, the managed online endpoint gives you secure REST API to score your model in real time.

Azure Machine Learning Model Catalog contains over 10,000 deployable models under the Hugging Face collection, ranging a wide-variety of models for different tasks such as image generation, Large Language Models (LLMs), Visual Language Models (VLMs), or embeddings, among many others; all of those powered by open-source inference solutions. Additionally, each of those models can be deployed in a wide variety of hardware available on Microsoft Azure, ranging NVIDIA GPUs to CPUs, so that each model comes with a default suggested hardware.

At Microsoft Build 2025, an expansion of the partnership between Hugging Face and Microsoft Azure was announced. Among the main takeaways, the expanded collaboration will not only cover [Azure Machine Learning](https://azure.microsoft.com/en-us/products/machine-learning), but also [Azure AI Hub](https://azure.microsoft.com/en-us/products/ai-foundry) allowing Microsoft Azure users to design, customize, and manage AI apps and agents at scale with open-source models from Hugging Face.

![Satya Nadella announcing the Hugging Face expanded collaboration on Microsoft Build 2025](https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/microsoft-build-2025.png)

## Resources

- [Azure Machine Learning - Deploy models from Hugging Face Hub to Azure Machine Learning online endpoints for real-time inference](https://learn.microsoft.com/en-us/azure/machine-learning/how-to-deploy-models-from-huggingface)
- [Azure Machine Learning - How to use Open Source foundation models curated by Azure Machine Learning](https://learn.microsoft.com/en-us/azure/machine-learning/how-to-use-foundation-models)
- [Microsoft and Hugging Face expand collaboration](https://huggingface.co/blog/azure-ai-foundry)
- [Microsoft and Hugging Face expand collaboration to accelerate Open-Source AI Innovation on Azure AI Foundry](https://devblogs.microsoft.com/foundry/microsoft-and-hugging-face-expand-partnership-to-accelerate-open-source-ai-innovation-on-azure-ai-foundry/)


<EditOnGithub source="https://github.com/huggingface/Microsoft-Azure/blob/main/docs/source/azure-ai/introduction.mdx" />