# Frequent Asked Questions (FAQ)

## What is Azure Machine Learning (Azure ML)?

Azure ML is Microsoft’s cloud-native platform for fully managing the ML lifecycle—training, deployment, monitoring, pipelines, AutoML, model registries, and responsible AI tooling—designed for data scientists and ML engineers.

## What is Azure AI Foundry (formerly Azure AI Studio)?

Azure AI  Foundry builds on Azure ML but is tailored specifically for generative AI and agent-based applications. It offers:
* A unified experience for building, evaluating, and deploying LLMs and multimodal agents.
* Access to a broad catalog of open-source and commercial frontier models—from Azure OpenAI, Hugging Face, Meta, DeepSeek, etc. 
* Integrated tools like model evaluation leaderboards, prompt flows (for RAG), content safety, and agent orchestration.

## What’s the difference between a **Hub-based project** and a **Foundry (standalone) project**?

| Feature | Hub-based project | Standalone Foundry project |
|--------|--------------------|-----------------------------|
| Requires a Hub resource | ✅ Yes—project is linked to a hub | ❌ No—project created individually |
| Shared infrastructure (compute/quota) | ✅ Yes | ❌ No |
| Shared security/network settings | ✅ Yes | ❌ No |
| Shared resource connections | ✅ Yes (e.g., models, storage) | ❌ Per‑project only |
| Full Generative AI tooling (fine-tuning, evaluation, RAG, agent orchestration) | ✅ Yes | ⚠️ Limited support |
| Accessible from Azure ML Studio | ✅ Yes | Limited/absent |

Hub-based projects provide **complete** access to generative-AI features; standalone projects operate with **limited** capabilities. Open-model deployments are only accessible through Hub-based project for now.


<EditOnGithub source="https://github.com/huggingface/Microsoft-Azure/blob/main/docs/source/faq.mdx" />